<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

class ResultSet implements IteratorAggregate
{
    private $_key = -1;
    private $_resultSet;

    private $_count;

    public function __construct($resultSet)
    {
        $this->_resultSet = $resultSet;
        $this->_count = count($this->_resultSet);
    }

    public function __destruct()
    {
        $this->close();
    }

    public function getIterator()
    {
        require_once('ResultSetIterator.class.php');
        return new ResultSetIterator($this);
    }

    public function getResultSet()
    {
        return (array) $this->_resultSet;
    }

    public function count()
    {
        return (integer) $this->_count;
    }

    public function key()
    {
        return (integer) $this->_key;
    }

    public function seek($index)
    {
        if ($index > $this->_count) { return false; }

        $this->_key = $index;

        return true;
    }

    public function first()
    {
        if ($this->_count < 0) { return false; }

        $this->_key = 0;

        return true;
    }

    public function current()
    {
        return $this->_resultSet[$this->_key];
    }

    public function next()
    {
        $this->_key++;
        if ($this->_key >= $this->_count) { return false; }

        return true;
    }

    public function isExist($column)
    {
        $ret = $this->current();
        if (!$ret) { return false; }

        return array_key_exists($column, $ret);
    }

    public function get($column)
    {
        $ret = $this->current();
        if (!$ret) { return false; }

        if (!array_key_exists($column, $ret)) { throw new PDOException('结果集中不存在字段: ' . $column); }

        return $ret[$column];
    }

    public function getString($column)
    {
        return
            is_null($this->get($column))
                ? null
                : (string) $this->get($column);
    }

    public function getBoolean($column)
    {
        return
            is_null($this->get($column))
                ? null
                : (boolean) $this->get($column);
    }

    public function getInt($column)
    {
        return
            is_null($this->get($column))
                ? null
                : (integer) $this->get($column);
    }

    public function getFloat($column)
    {
        return
            is_null($this->get($column))
                ? null
                : (float) $this->get($column);
    }

    public function getDate($column, $format = '%x')
    {
        $ret = $this->get($column);
        if (is_null($ret)) { return null; }

        $ts = strtotime($ret);
        if (-1 == $ts || false == $ts)
        {
            throw new PDOException('不能将字段: ' . $column . '的值: ' . $ret . '转换成日期格式.');
        }

        if (is_null($format)) { return $ts; }

        if (strpos($format, '%') !== false) { return strftime($format, $ts); }
        else { return date($format, $ts); }
    }

    public function getTime($column, $format = '%X')
    {
        return $this->getDate($column, $format);
    }

    public function getTimestamp($column, $format = 'Y-m-d H:i:s')
    {
        return $this->getDate($column, $format);
    }

    public function close()
    {
        $this->_resultSet = array();
    }

}

?>