<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

class ResultSetIterator implements Iterator
{
    private $_resultSet;
    private $_currentIndex = 0;
    private $_count;

    public function __construct(ResultSet $rs)
    {
        $this->_resultSet = $rs->getResultSet();
        $this->_count = $rs->count();
    }

    public function rewind()  { $this->_currentIndex = 0; }
    public function valid()   { return $this->_currentIndex < $this->_count; }
    public function key()     { return $this->_currentIndex; }
    public function current() { return $this->_resultSet[$this->_currentIndex]; }
    public function next()    { $this->_currentIndex++; }

}

?>