<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

//分页
function page($recordCount, $pageSize, $pageIndex, $jumpUrl)
{
    $pageStep = 5;
    $pageString = '';
    $jumpUrl .= strpos($jumpUrl, '?') ? '&' : '?';
    $pageCount = 1;
    if ($recordCount > $pageSize)
    {
        $offset = 2;
        $pageMax = $pageCount = @ceil($recordCount / $pageSize);

        if($pageStep > $pageMax)
        {
            $pageFrom = 1;
            $pageTarget = $pageMax;
        }
        else
        {
            $pageFrom = $pageIndex - $offset;
            $pageTarget = $pageFrom + $pageStep - 1;
            if ($pageFrom < 1)
            {
                $pageTarget = $pageIndex + 1 - $pageFrom;
                $pageFrom = 1;
                if ($pageTarget - $pageFrom < $pageStep) { $pageTarget = $pageStep; }
            }
            elseif ($pageTarget > $pageMax)
            {
                $pageFrom = $pageMax - $pageStep + 1;
                $pageTarget = $pageMax;
            }
        }

        $pageString = ($pageIndex - $offset > 1 && $pageMax > $pageStep
                        ? '<a href="' . $jumpUrl . 'page=1" class="first">1 ...</a>'
                        : '')
                    . ($pageIndex > 1
                        ? '<a href="' . $jumpUrl . 'page=' . ($pageIndex - 1)
                            .'" class="prev">&lsaquo;&lsaquo;</a>'
                        : '');

        for ($i = $pageFrom; $i <= $pageTarget; $i++)
        {
            $pageString .= $i == $pageIndex
                            ? '<strong>' . $i . '</strong>'
                            : '<a href="' . $jumpUrl . 'page=' . $i . '">' . $i . '</a>';
        }

        $pageString .= ($pageIndex < $pageMax
                        ? '<a href="' . $jumpUrl . 'page=' . ($pageIndex + 1)
                            . '" class="next">&rsaquo;&rsaquo;</a>'
                        : '')
                    .  ($pageTarget < $pageMax
                        ? '<a href="' . $jumpUrl . 'page=' . $pageMax
                            . '" class="last">... ' . $pageCount . '</a>'
                        : '');

        $pageString = $pageString
                        ? '<div class="pages">'.'<em>&nbsp;'
                            . $recordCount . '&nbsp;</em>' . $pageString . '</div>'
                        : '';
    }

    return $pageString;
}

//分页
function self_page($recordCount, $pageSize, $pageIndex, $jumpUrl)
{
    $pageStep = 5;
    $pageString = '';
    $jumpUrl .= strpos($jumpUrl, '?') ? '&' : '?';
    $pageCount = 1;
    if ($recordCount > $pageSize)
    {
        $offset = 2;
        // 最大页数
        $pageMax = $pageCount = @ceil($recordCount / $pageSize);

        if($pageStep > $pageMax)
        {
            $pageFrom = 1;
            $pageTarget = $pageMax;
        }
        else
        {
            $pageFrom = $pageIndex - $offset;
            $pageTarget = $pageFrom + $pageStep - 1;
            if ($pageFrom < 1)
            {
                $pageTarget = $pageIndex + 1 - $pageFrom;
                $pageFrom = 1;
                if ($pageTarget - $pageFrom < $pageStep) { $pageTarget = $pageStep; }
            }
            elseif ($pageTarget > $pageMax)
            {
                $pageFrom = $pageMax - $pageStep + 1;
                $pageTarget = $pageMax;
            }
        }

        $pageString = ($pageIndex - $offset > 1 && $pageMax > $pageStep
                        ? '<li class="home"><a href="' . $jumpUrl . 'page=1" title="首页">首页</a></li>'
                        : '')
                    . ($pageIndex > 1
                        ? '<li class="previous"><a href="' . $jumpUrl . 'page=' . ($pageIndex - 1)
                            .'" title="上一页">上一页</a></li>'
                        : '');

        for ($i = $pageFrom; $i <= $pageTarget; $i++)
        {
            $pageString .= $i == $pageIndex
                            ? '<li class="active" title="当前页">' . $i . '</li>'
                            : '<li><a href="' . $jumpUrl . 'page=' . $i . '">' . $i . '</a></li>';
        }

        $pageString .= ($pageIndex < $pageMax
                        ? '<li class="next"><a href="' . $jumpUrl . 'page=' . ($pageIndex + 1)
                            . '" title="下一页">下一页</a></li>'
                        : '')
                    .  ($pageTarget < $pageMax
                        ? '<li class="lastly"><a href="' . $jumpUrl . 'page=' . $pageMax
                            . '" title="尾页">末页</a></li>'
                        : '');

        $pageString = $pageString
                        ? '<span class="last"><font color="#ff0000">'
                            . $pageIndex . '</font> / <font color="#ff0000">'
                            . $recordCount . '</font></span><ul>' . $pageString . '</ul>'
                        : '';
    }

    return $pageString;
}

?>