<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

/**
 * 处理搜索关键字
 *
 * @param string $string 字符串
 * @return string
 */
function strip_search_key($string)
{
    $string = trim($string);
    $string = str_replace('*', '%', addcslashes($string, '%_'));
    $string = str_replace('_', '\_', $string);
    return $string;
}

/**
 * 获取限制条件
 *
 * @param array $intkeys  数字条件
 * @param array $strkeys  字符条件
 * @param array $randkeys 范围
 * @param array $likekeys 模糊
 * @param array $pre      前缀
 * @return array
 */
function get_search_where($intkeys, $strkeys, $randkeys, $likekeys, $pre = '')
{
    $wherearr = array();
    $urls = array();

    foreach ($intkeys as $var)
    {
        $value = isset($_GET[$var]) ? strip_search_key($_GET[$var]) : '';
        if(strlen($value))
        {
            $wherearr[] = "{$pre}{$var}='" . intval($value) . "'";
            $urls[] = "$var=$value";
        }
    }

    foreach ($strkeys as $var)
    {
        $value = isset($_GET[$var]) ? strip_search_key($_GET[$var]) : '';
        if (strlen($value))
        {
            $wherearr[] = "{$pre}{$var}='$value'";
            $urls[] = "$var=" . rawurlencode($value);
        }
    }

    foreach ($randkeys as $vars)
    {
        $value1 = isset($_GET[$vars[1].'1']) ? $vars[0]($_GET[$vars[1].'1']) : '';
        $value2 = isset($_GET[$vars[1].'2']) ? $vars[0]($_GET[$vars[1].'2']) : '';
        if ($value1)
        {
            $wherearr[] = "{$pre}{$vars[1]}>='$value1'";
            $urls[] = "{$vars[1]}1=".rawurlencode($_GET[$vars[1].'1']);
        }
        if ($value2)
        {
            $wherearr[] = "{$pre}{$vars[1]}<='$value2'";
            $urls[] = "{$vars[1]}2=" . rawurlencode($_GET[$vars[1] . '2']);
        }
    }

    foreach ($likekeys as $var)
    {
        $value = isset($_GET[$var]) ? strip_search_key($_GET[$var]) : '';
        if (strlen($value) > 0)
        {
            $wherearr[] = "{$pre}{$var} LIKE BINARY '%$value%'";
            $urls[] = "$var=" . rawurlencode($value);
        }
    }

    return array('wheres' => $wherearr, 'urls' => $urls);
}

/**
 * 获取排序
 *
 * @param array $alloworders 允许的排序
 * @param string $default    默认排序
 * @param string $pre        前缀
 * @return array
 */
function get_search_orders($alloworders, $default, $pre='')
{
    $orders = array('sql'=>'', 'urls'=>array());

    if (!empty($_GET['orderby']) && in_array($_GET['orderby'], $alloworders))
    {
        $orders['sql'] = " ORDER BY {$pre}$_GET[orderby] ";
        $orders['urls'][] = "orderby=$_GET[orderby]";
    }
    else
    {
        $orders['sql'] = empty($default) ? '' : " ORDER BY $default ";
        return $orders;
    }

    if (!empty($_GET['ordersc']) && $_GET['ordersc'] == 'desc')
    {
        $orders['urls'][] = 'ordersc=desc';
        $orders['sql'] .= ' DESC ';
    }
    else
    {
        $orders['urls'][] = 'ordersc=asc';
    }
    return $orders;
}

?>