<?php

defined('__IN_NB__') or exit('Access Denied');

// 统计分类的歌手数量
function stat_category_singernum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `categoryid`, `singernum` FROM ' . T('category') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('singer'), array('categoryid' => $value['categoryid']));
        if ($count != $value['singernum'])
        {
            $data[$value['categoryid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('category') . ' SET `singernum` = ?'
                . " WHERE `categoryid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

// 统计分类的专辑数量
function stat_category_specialnum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `categoryid`, `specialnum` FROM ' . T('category') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('special'), array('categoryid' => $value['categoryid']));
        if ($count != $value['specialnum'])
        {
            $data[$value['categoryid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('category') . ' SET `specialnum` = ?'
                . " WHERE `categoryid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

// 统计分类的歌曲数量
function stat_category_songnum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `categoryid`, `songnum` FROM ' . T('category') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('song'), array('categoryid' => $value['categoryid']));
        if ($count != $value['songnum'])
        {
            $data[$value['categoryid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('category') . ' SET `songnum` = ?'
                . " WHERE `categoryid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

// 统计歌手的专辑数量
function stat_singer_specialnum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `singerid`, `specialnum` FROM ' . T('singer') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('special'), array('singerid' => $value['singerid']));
        if ($count != $value['specialnum'])
        {
            $data[$value['singerid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('singer') . ' SET `specialnum` = ?'
                . " WHERE `singerid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

// 统计歌手的歌曲数量
function stat_singer_songnum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `singerid`, `songnum` FROM ' . T('singer') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('song'), array('singerid' => $value['singerid']));
        if ($count != $value['songnum'])
        {
            $data[$value['singerid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('singer') . ' SET `songnum` = ?'
                . " WHERE `singerid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

// 统计专辑的歌曲数量
function stat_special_songnum($offset, $pagesize)
{
    global $globals;
    $params = new ArrayObject();
    $date = array();

    $sql = 'SELECT `specialid`, `songnum` FROM ' . T('special') . ' LIMIT ?, ?;';
    $params->append(new SqlParameter(1, $offset, DB_PARAM_INT));
    $params->append(new SqlParameter(2, $pagesize, DB_PARAM_INT));
    $result = $globals['db']->executeReader($sql, $params);

    foreach ($result as $key => $value)
    {
        $count = $globals['db']->getScalar(T('song'), array('specialid' => $value['specialid']));
        if ($count != $value['songnum'])
        {
            $data[$value['specialid']] = $count;
        }
    }

    if (empty($data)) { return FALSE; }

    $datas = regroup($data);
    foreach ($datas[0] as $count)
    {
        $params = new ArrayObject();
        $sql = 'UPDATE ' . T('special') . ' SET `songnum` = ?'
                . " WHERE `specialid` IN (" . self_implode($datas[1][$count]) . ");";
        $params->append(new SqlParameter(1, $count, DB_PARAM_INT));
        $globals['db']->executeNonQuery($sql, $params);
    }
    return TRUE;
}

?>