<?php

if (!defined('__IN_SY__')) { exit('Access Denied'); }

$globals['i'] = 0;
$globals['block_search'] = $globals['block_replace'] = array();

function template_parse($template)
{
    global $globals;

    // 模板
    $template = preg_replace("/\<\!\-\-\{template\s+([a-z0-9_\/]+)\}\-\-\>/ie", "template_read('\\1')", $template);
    // 处理子页面中的代码
    $template = preg_replace("/\<\!\-\-\{template\s+([a-z0-9_\/]+)\}\-\-\>/ie", "template_read('\\1')", $template);
    // 解析模块调用
    $template = preg_replace("/\<\!\-\-\{block\/(.+?)\}\-\-\>/ie", "blocktags('\\1')", $template);
    // 解析广告
    $template = preg_replace("/\<\!\-\-\{ad\/(.+?)\}\-\-\>/ie", "adtags('\\1')", $template);
    // 时间处理
    $template = preg_replace("/\<\!\-\-\{date\((.+?)\)\}\-\-\>/ie", "datetags('\\1')", $template);
    // 头像处理
    $template = preg_replace("/\<\!\-\-\{avatar\((.+?)\)\}\-\-\>/ie", "avatartags('\\1')", $template);
    // PHP代码
    $template = preg_replace("/\<\!\-\-\{eval\s+(.+?)\s*\}\-\-\>/ies", "evaltags('\\1')", $template);

    // 开始处理
    // 变量
    $var_regexp = "((\\\$[a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)(\[[a-zA-Z0-9_\-\.\"\'\[\]\$\x7f-\xff]+\])*)";
    $template = preg_replace("/\<\!\-\-\{(.+?)\}\-\-\>/s", "{\\1}", $template);
    $template = preg_replace("/([\n\r]+)\t+/s", "\\1", $template);
    $template = preg_replace("/(\\\$[a-zA-Z0-9_\[\]\'\"\$\x7f-\xff]+)\.([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)/s", "\\1['\\2']", $template);
    $template = preg_replace("/\{(\\\$[a-zA-Z0-9_\[\]\'\"\$\.\x7f-\xff]+)\}/s", "<?=\\1?>", $template);
    $template = preg_replace("/$var_regexp/es", "addquote('<?=\\1?>')", $template);
    $template = preg_replace("/\<\?\=\<\?\=$var_regexp\?\>\?\>/es", "addquote('<?=\\1?>')", $template);
    // 逻辑
    $template = preg_replace("/\{elseif\s+(.+?)\}/ies", "stripvtags('<?php } elseif(\\1) { ?>','')", $template);
    $template = preg_replace("/\{else\}/is", "<?php } else { ?>", $template);
    // 循环
    for ($i = 0; $i < 5; $i++)
    {
        $template = preg_replace("/\{loop\s+(\S+)\s+(\S+)\}(.+?)\{\/loop\}/ies",
                    "stripvtags('<?php if(is_array(\\1)) { foreach(\\1 as \\2) { ?>','\\3<?php } } ?>')",
                    $template);
        $template = preg_replace("/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\}(.+?)\{\/loop\}/ies",
                    "stripvtags('<?php if(is_array(\\1)) { foreach(\\1 as \\2 => \\3) { ?>','\\4<?php } } ?>')",
                    $template);
        // 多行多列
        $template = preg_replace("/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\s+(\d+)\}(.+?)\{\/loop\}/ies",
                    "stripvtags('<?php \\1 = format_array(\\1, \\4); if(is_array(\\1)) { foreach(\\1 as \\2 => \\3) { ?>','\\5<?php } } ?>')",
                    $template);
        $template = preg_replace("/\{loop\s+(\S+)\s+(\S+)\s+(\S+)\s+(\d+)\s+(\S+)\}(.+?)\{\/loop\}/ies",
                    "stripvtags('<?php \\1 = format_array(\\1, \\4, \\6); if(is_array(\\1)) { foreach(\\1 as \\2 => \\3) { ?>','\\6<?php } } ?>')",
                    $template);
        $template = preg_replace("/\{if\s+(.+?)\}(.+?)\{\/if\}/ies",
                    "stripvtags('<?php if(\\1) { ?>','\\2<?php } ?>')",
                    $template);
    }
    // 常量
    $template = preg_replace("/\{([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\}/s", "<?=\\1;?>", $template);
    // 换行
    $template = preg_replace("/ \?\>[\n\r]*\<\? /s", " ", $template);

    $template = "<?php if (!defined('__IN_SY__')) { exit('Access Denied'); } ?>\r\n" . $template;

    // 替换
    if (!empty($globals['block_search']))
    {
        $template = str_replace($globals['block_search'], $globals['block_replace'], $template);
    }

    return $template;
}

function addquote($var)
{
    return str_replace("\\\"", "\"", preg_replace("/\[([a-zA-Z0-9_\-\.\x7f-\xff]+)\]/s", "['\\1']", $var));
}

function striptagquotes($expr)
{
    $expr = preg_replace("/\<\?\=(\\\$.+?)\?\>/s", "\\1", $expr);
    $expr = str_replace("\\\"", "\"", preg_replace("/\[\'([a-zA-Z0-9_\-\.\x7f-\xff]+)\'\]/s", "[\\1]", $expr));
    return $expr;
}

function evaltags($php)
{
    global $globals;

    $globals['i']++;
    $search = "<!--EVAL_TAG_{$globals['i']}-->";
    $globals['block_search'][$globals['i']] = $search;
    $globals['block_replace'][$globals['i']] = "<?php ".stripvtags($php)." ?>";

    return $search;
}

function blocktags($parameter)
{
    global $globals;

    $globals['i']++;
    $search = "<!--BLOCK_TAG_{$globals['i']}-->";
    $globals['block_search'][$globals['i']] = $search;
    $globals['block_replace'][$globals['i']] = "<?php block(\"$parameter\"); ?>";
    return $search;
}

function adtags($pagetype)
{
    global $globals;

    $globals['i']++;
    $search = "<!--AD_TAG_{$globals['i']}-->";
    $globals['block_search'][$globals['i']] = $search;
    $globals['block_replace'][$globals['i']] = "<?php adshow('$pagetype'); ?>";
    return $search;
}

function datetags($parameter)
{
    global $globals;

    $globals['i']++;
    $search = "<!--DATE_TAG_{$globals['i']}-->";
    $globals['block_search'][$globals['i']] = $search;
    $globals['block_replace'][$globals['i']] = "<?php echo sgmdate($parameter); ?>";
    return $search;
}

function avatartags($parameter)
{
    global $globals;

    $globals['i']++;
    $search = "<!--AVATAR_TAG_{$globals['i']}-->";
    $globals['block_search'][$globals['i']] = $search;
    $globals['block_replace'][$globals['i']] = "<?php echo avatar($parameter); ?>";
    return $search;
}

function stripvtags($expr, $statement = '')
{
    $expr = str_replace("\\\"", "\"", preg_replace("/\<\?\=(\\\$.+?)\?\>/s", "\\1", $expr));
    $statement = str_replace("\\\"", "\"", $statement);
    return $expr . $statement;
}


function template_read($tpl_name)
{
    global $settings;

    $tpl = in_string($tpl_name, '/') ? $tpl_name : 'template/' . $settings['template'] . '/' . $tpl_name;
    $content = file_get_contents(__ROOT__ . '/' . $tpl . '.html');
    return $content;
}
?>