<?php

// 来自 ThinkPHP
// Author: liu21st <liu21st@gmail.com>

// 考虑到有的虚拟主机不支持 file_get_contents 函数, 故对 getXml 方法作了些许修改

class Xml
{
	private $xml;

	public function __construct($xml = '')
	{
		$this->getXml($xml);
	}

	public function __destruct()
	{
	}

	// XML解析
	public function Parse($xml = '')
	{
		$this->getXml($xml);
		$result = simplexml_load_string($this->xml);
		if (FALSE !== $result) {
			return $this->objToArray($result);
		} else {
			return FALSE;
		}
	}

	// 获取 XML 数据
	public function GetXml($xml = '') 
	{
		static $xmlArray = array();
		if (!empty($xml)) {
			$this->xml = '';
			if (@is_file($xml)) {
				if (isset($xmlArray[$xml])) {
					$this->xml = $xmlArray[$xml];
				} else {
					if (function_exists('file_get_contents')) {
						$this->xml = @file_get_contents($xml);
					} else {
						$fp = @fopen($xml, 'r');
						if ($fp) {
							while (!feof($fp)) {
								$this->xml .= fgets($fp);
							}
							fclose($fp);
						}
					}
				}
				$xmlArray[$xml] = $this->xml;
			} elseif (is_string($xml)) {
				$this->xml = $xml;
			}
		}
	}

	// SimpleXMLElement 对象转数组
	private function ObjectToArray($object)
	{
		$return = NULL;
           
		if (is_array($object)) {
			foreach($object as $key => $value)
				$return[$key] = $this->objToArray($value);
		} else {
			$var = get_object_vars($object); 
			
			if ($var) {
				foreach ($var as $key => $value) {
					$return[$key] = ($key && !$value) ? NULL : $this->ObjectToArray($value);
				}
			} else {
				return $object;
			}
		}

		return $return;
	} 


}

?>