<?php

@define('__IN_SY__',     TRUE);
define('__SY_NAME__',    '爱迪生影视系统');
define('__SY_VERSION__', '1.0.0');
define('__SY_RELEASE__', '20081124');

if (!defined('DEBUG') && strpos(__SY_VERSION__, 'CVS'))
{
    define('DEBUG', TRUE);
}
else if (!defined('DEBUG'))
{
    define('DEBUG', FALSE);
}

//DEBUG
//    ? error_reporting(7)
//    : error_reporting(0);

$globals = $config = $settings = $cookies = $tpl = $types = array();
$ccapi_settings = $ccapi_types = $ccapi_bindtypes = array();

// 开始时间
$globals['timestamp'] = time();
$globals['starttime'] = microtime(TRUE);

// 程序根目录
define('__ROOT__',         dirname(__FILE__));
define('__INCLUDE__',      __ROOT__ . '/include');
define('__DATA__',         __ROOT__ . '/data');
define('__TEMPLATE__',     __ROOT__ . '/template');
define('REGISTER_GLOBALS', @ini_get('register_globals'));
define('MAGIC_QUOTES_GPC', @ini_get('magic_quotes_gpc'));
define('ALLOW_URL_FOPEN',  @ini_get('allow_url_fopen'));
define('SAFE_MODE',        @ini_get('safe_mode'));
define('__SELF_SCRIPT__',  $_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

// 获取原网页url，需兼容Apache，IIS，php不同安装模式
if (isset($_SERVER['REDIRECT_URL']))
{
    $my_url = $_SERVER['REDIRECT_URL'];
}
else if (isset($_SERVER['URL']))
{
    $my_url = $_SERVER['URL'];
}
else if (isset($_SERVER['REQUEST_URI']))
{
    $my_url = $_SERVER['REQUEST_URI'];
}
define('__SELF_URL__', $my_url);
unset($my_url);

// 数据库配置文件
if (!@include_once(__ROOT__ . '/config.php'))
{
    header("Location: install/index.php");
    exit();
}

// 强制使用字符集
if ($config['charset'])
{
    @header('Content-Type: text/html; charset=' . $config['charset']);
}
else
{
    @header('Content-Type: text/html; charset=utf-8');
}

// 公共函数库
require_once(__INCLUDE__ . '/function.inc.php');
require_once(__INCLUDE__ . '/global.inc.php');

// 连接数据库
self_mysql_connect();

// 系统配置文件
if (!@include_once(__DATA__ . '/settings.cache.php'))
{
    include_cache(__INCLUDE__ . '/cache.inc.php');
    cache_settings();
}

// 时区设置
if (!ereg("[^0-9-]", $settings['timeoffset'])) { $settings['timeoffset'] = 'Etc/GMT' . $settings['timeoffset']; }
if (function_exists('date_default_timezone_set')) { @date_default_timezone_set($settings['timeoffset']); }

// 站点关闭
if ($settings['close']) { exit($settings['closereason']); }
// 禁止访问
if (!allow_ip($settings['ipaccess']) || forbid_ip($settings['ipbanned'])) { exit('您的IP不允许访问！'); }

// 媒体类型
if (!@include_once(__DATA__ . '/types.cache.php'))
{
    include_cache(__INCLUDE__ . '/cache.inc.php');
    cache_types();
}

// GPC过滤
if (!MAGIC_QUOTES_GPC)
{
    $_GET = self_addslashes($_GET);
    $_POST = self_addslashes($_POST);
}

// COOKIE
$len_cookie_prefix = strlen($config['cookie_prefix']);
foreach ($_COOKIE as $key => $value)
{
    if (substr($key, 0, $len_cookie_prefix) == $config['cookie_prefix'])
    {
        $cookies[(substr($key, $len_cookie_prefix))] = !MAGIC_QUOTES_GPC ? self_addslashes($value) : $value;
    }
}

// 初始化
$globals['uid'] = 0;
$globals['username'] = '';
$globals['refer'] = empty($_SERVER['HTTP_REFERER']) ? '' : $_SERVER['HTTP_REFERER'];
$globals['templateurl'] = $settings['sitepath']
                        . '/template/'
                        . (empty($settings['template'])
                            ? 'default'
                            : $settings['template']);
$today = date("Y-m-d", $globals['timestamp']);

self_ob_clean();

?>