<?php
error_reporting(E_ALL & ~E_NOTICE);
// 系统根目录
define('__SY_ROOT__', dirname(__FILE__));

/**
 * 站点链接
 *
 * @param
 * @return string
 */
function get_site_url()
{
    $uri = $_SERVER['REQUEST_URI']
            ? $_SERVER['REQUEST_URI']
            : ($_SERVER['PHP_SELF'] ? $_SERVER['PHP_SELF'] : $_SERVER['SCRIPT_NAME']);

    return 'http://' . $_SERVER['HTTP_HOST'] . substr($uri, 0, strrpos($uri, '/') + 1);
}

/**
 * 站点路径
 *
 * @param
 * @return string
 */
function get_site_path()
{
    $sitepath = '';
    $sitepath = substr($_SERVER['PHP_SELF'],0, -11);
    $sitepath = $sitepath == '/' ? '' : $sitepath;
    return $sitepath;
}

/**
 * 判断提交是否正确
 *
 * @param string $value 需要转换的字符串
 * @return boolean
 */
function is_submit_of($value = '')
{
    empty($value) ? 'isPostBack' : $value;
    if (!empty($_POST[$value]) && $_SERVER['REQUEST_METHOD'] == 'POST')
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**
 * 保存数组
 *
 * @param $name 变量名称
 * @param $data 数据
 * @param $filename 保存的文件名
 * @return void
 */
function save_array($name, $data, $filename = '')
{
    if (empty($filename)) { $filename = __SY_ROOT__ . '/data/' . $name . '.cache.php'; }
    $content = "<?php\r\nif (!defined('__IN_SY__')) { exit('Access Denied'); }\r\n\$$name = "
             . var_export($data, TRUE) . ";\n?>";
    file_put_contents($filename, $content);
    @chmod($filename, 0777);
}

/**
 * 取消HTML代码
 *
 * @param string/array $string 需要取消HTML代码的字符串/数组
 * @return string
 */
function strip_html_tags($string)
{
    if (is_array($string))
    {
        foreach ($string as $key => $val)
        {
            $string[$key] = strip_html_tags($val);
        }
    }
    else
    {
        $string = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1',
                str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $string));
    }
    return $string;
}

/**
 * 错误信息
 *
 * @param $message
 * @return void
 */
function throwException($message)
{
    @header('Content-Type: text/html; charset=utf-8');
    echo '<script>alert("' . $message . '");history.go(-1);</script>';
    exit();
}

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title>爱迪生影视程序安装向导</title>
<style>
table.forumRow
{
    background-color:#E9F5F5;
		width:600px;
}
body
{
	FONT-SIZE: 12px;
	COLOR: #000000;
	FONT-FAMILY: 宋体;
	background-color: #FEFEFF;
	scrollbar-face-color: #EAEAF2;
        scrollbar-highlight-color: #FFFFFF;
        scrollbar-shadow-color: #9395C0;
        scrollbar-3dlight-color: #F3F3F8;
        scrollbar-arrow-color: #9395C0;
        scrollbar-track-color: #F3F3F8;
        scrollbar-darkshadow-color: #F3F3F8;
        background-image: url(images/admin_bg.gif);
}
TD{
font-family:宋体; font-size: 12px; line-height: 25px; LINE-HEIGHT: 150%
}
th
{
    background-color: #89C3E4;
    color: white;
    font-size: 12px;
    font-weight:bold;
    height: 25
}
</style>
</head>
<body>
<?php

if (is_submit_of('installsubmit'))
{
    try
    {
        $pdo = new PDO('mysql:host=' . $_POST['db_host'] . ';dbname=' . $_POST['db_name'],
                        $_POST['db_user'],
                        $_POST['db_password']);
    }
    catch (PDOException $e)
    {
        throwException('连接数据库出错！\r\n' . $e->getMessage() . '\r\n请返回重新填写。');
    }

    $version = $pdo->getAttribute(PDO::ATTR_SERVER_VERSION);
    $version = str_replace('-community-nt', '', trim($version));
    if ($version < 5)
    {
        throwException('MySQL数据库版本太低！\r\n必须使用MySQL5以上版本。');
    }

    $settings = array(
        'sitename' => $_POST['sitename'],
        'siteurl' => $_POST['siteurl'],
        'sitepath' => $_POST['sitepath'],
        'sitelogo' => $_POST['siteurl'] . '/logo.gif',
        'adminemail' => 'admin@sycms.com',
        'template' => 'default',
        'onlinehold' => 1800,
        'timeoffset' => -8,
        'miibeian' => '京ICP备08000001号',
        'allowrewrite' => 0,
        'makehtml' => 0,
        'ccapi_type' => 1,
        'headercharset' => 0,
        'hots' => '',
        'close' => 0,
        'closereason' => NULL,
        'ipaccess' => NULL,
        'ipbanned' => NULL
    );

    $config = array(
        'db_host' => $_POST['db_host'],
        'db_username' => $_POST['db_user'],
        'db_password' => $_POST['db_password'],
        'db_charset' => 'utf8',
        'db_pconnect' => 0,
        'db_name' => $_POST['db_name'],
        'db_table_prefix' => 'sy_',
        'charset' => 'utf-8',
        'gzipcompress' => 0,
        'cookie_prefix' => 'sycms_',
        'cookie_domain' => '',
        'cookie_path' => '/',
        'auth_key' => 'sycms',
    );

    // 写入配置文件
    save_array('settings', $settings);
    save_array('config', $config, __SY_ROOT__ . '/config.php');

    $pdo->query("SET NAMES utf8;");
    $pdo->query("SET sql_mode='';");

    //建表
    $fp = fopen(__SY_ROOT__ . '/data/install.sql', 'r');

    $sql = '';
    while (!feof($fp))
    {
        $line = trim(fgets($fp, 1024));
        if (ereg(";$", $line))
        {
            $sql .= $line;
            $pdo->query($sql);
            $sql = '';
        }
        elseif (!ereg("^(//|--)", $line))
        {
            $sql .= $line;
        }
    }
    fclose($fp);

    // 写入用户信息
    $data = array();

    foreach ($settings as $key => $value)
    {
        $value = is_numeric($value) ? intval($value) : strip_html_tags(trim($value));
        $data[] = "('$key', '$value')";
    }

    if ($data)
    {
        $sql = "REPLACE INTO " . 'sy_settings'
             . " (`name`, `value`)"
             . " VALUES " . implode(',', $data);

        $pdo->query($sql);
    }

?>
<center>
<table class="forumRow">
    <tr>
        <th colspan="2" align="center">爱迪生影视程序安装向导</th>
    </tr>
    <tr>
        <td>已完成安装</td>
    </tr>
    <tr>
        <td><a href="./admin/index.php">转入管理员登录页面</a></td>
    </tr>
</table>
<table class="forumRow">
    <tr>
        <td align="center">Powered by <a href="http://www.edisonstudio.net/">EdisonStudio.Net</a> Team 2008-2010 </td>
    </tr>
</table>
</center>
<?php
    //@unset($pdo);
    @unlink(__SY_ROOT__ . '/install.php');
}

else
{
    // 错误信息
    $error = FALSE;
    $errorMessage = '';

    // PHP版本检查
    if (PHP_VERSION < '5.1')
    {
        $error = TRUE;
        $errorMessage .= 'PHP版本太低！本系统不支持PHP5以下的版本。<br />';
    }

    // PDO扩展 PHP5中默认开启
    if (!extension_loaded('pdo'))
    {
        $error = TRUE;
        $errorMessage .= 'PDO不能加载！本系统使用PDO操作数据库。<br />';
    }

    // 必须拥有读写权限的目录
    $system_dirs = array(
                        '/',
                        '/attachment',
                        '/data',
                        '/data/adtpl',
                        '/data/cache',
                        '/data/table',
                        '/data/tpl',
                        '/template',
                        '/template/default'
                    );

    // 检查目录读写权限
    foreach ($system_dirs as $key => $value)
    {
        if ($value != '/')
        {
            $dir = __SY_ROOT__ . $value;
        }
        else
        {
            $dir = __SY_ROOT__;
        }

        if ($value != '/')
        {
            if (!is_readable($dir))
            {
                $error = TRUE;
                $errorMessage .= '目录：' . $value . ' 不可读。<br />';
            }
        }

        if (!is_writeable($dir))
        {
            $error = TRUE;
            $errorMessage .= '目录：' . $value . ' 不可写。<br />';
        }
    }

    if ($error)
    {
?>
<center>
    <table class="forumRow">
        <tr><th align="center">由于以下原因，您将不能安装本系统</th></tr>
        <tr><td><?php echo $errorMessage; ?></td></tr>
    </table>
<?php
    }
    else
    {
?>
<form action="install.php" method="post">
<center>
<table class="forumRow">
    <tr>
        <th colspan="2" align="center">爱迪生影视程序安装向导</th>
    </tr>
    <tr>
        <td height="25">数据库主机：</td>
        <td><input type="text" name="db_host" value="localhost"> </td>
    </tr>
    <tr>
        <td height="25">数据库名称：</td>
        <td><input type="text" name="db_name" value="sycms"></td>
    </tr>
    <tr>
        <td height="25">数据库用户：</td>
        <td><input type="text" name="db_user" value="root"></td>
    </tr>
    <tr>
        <td height="25">数据库密码：</td>
        <td><input type="text" name="db_password" value=""></td>
    </tr>
    <tr>
        <td height="25">网站名称：</td>
        <td><input type="text" name="sitename" value="我的网站"></td>
    </tr>
    <tr>
        <td height="25">网站网址：</td>
        <td><input type="text" name="siteurl" value="<?=rtrim(get_site_url(), '/');?>"> (开头必须“http://”，末尾不需要加“/”)</td>
    </tr>
    <tr>
        <td height="25">网站路径：</td>
        <td><input type="text" name="sitepath" value="<?=get_site_path();?>"> (开头必须“/”，末尾不需要加“/”，根目录请留空)</td>
    </tr>
    <tr>
        <td colspan="2" align="center"><input type="submit" name="installsubmit" value="安装"></td>
    </tr>
</table>
</form>
<table class="forumRow">
    <tr>
        <td align="center">Powered by <a href="http://www.edisonstudio.net/">EdisonStudio.Net</a> Team 2008-2010 </td>
    </tr>
</table>
</center>
<?php
    }
}
?>
</body>
</html>