<?php
function get_client_ip2() {
	if (getenv ( "HTTP_CLIENT_IP" ) && strcasecmp ( getenv ( "HTTP_CLIENT_IP" ), "unknown" ))
		$ip = getenv ( "HTTP_CLIENT_IP" );
	else if (getenv ( "HTTP_X_FORWARDED_FOR" ) && strcasecmp ( getenv ( "HTTP_X_FORWARDED_FOR" ), "unknown" ))
		$ip = getenv ( "HTTP_X_FORWARDED_FOR" );
	else if (getenv ( "REMOTE_ADDR" ) && strcasecmp ( getenv ( "REMOTE_ADDR" ), "unknown" ))
		$ip = getenv ( "REMOTE_ADDR" );
	else if (isset ( $_SERVER ['REMOTE_ADDR'] ) && $_SERVER ['REMOTE_ADDR'] && strcasecmp ( $_SERVER ['REMOTE_ADDR'], "unknown" ))
		$ip = $_SERVER ['REMOTE_ADDR'];
	else
		$ip = "unknown";
	return ($ip);
}
//公共函数
function new_stripslashes($string) {
	if(!is_array($string)) return stripslashes($string);
	foreach($string as $key => $val) $string[$key] = new_stripslashes($val);
	return $string;
}
function pwdHash($password, $type = 'md5') {
	return hash ( $type, $password );
}
//数组转换
function PostOptions($postarray = array())
{
	$str = '';
	if(is_array($postarray)) {
		for($i=0;$i<sizeof($postarray);$i++) {
			$str .= $postarray[$i];
			if($i<sizeof($postarray)-1)	{
				$str .= ",";
			}
		}	
	}
	return $str;
}
//安全替换
function safe_replace($string)
{
	$string = str_replace('%20','',$string);
	$string = str_replace('%27','',$string);
	$string = str_replace('*','',$string);
	$string = str_replace('"','&quot;',$string);
	$string = str_replace("'",'',$string);
	$string = str_replace("\"",'',$string);
	$string = str_replace('//','',$string);
	$string = str_replace(';','',$string);
	$string = str_replace('<','&lt;',$string);
	$string = str_replace('>','&gt;',$string);
	$string = str_replace('(','',$string);
	$string = str_replace(')','',$string);
	$string = str_replace("{",'',$string);
	$string = str_replace('}','',$string);
	return $string;
}
function format_textarea($string)
{
	return nl2br(str_replace(' ', '&nbsp;', htmlspecialchars($string)));
}

function msubstr($str, $start=0, $length=3, $charset="utf-8", $suffix=true){
    if(function_exists("mb_substr"))
        return mb_substr($str, $start, $length, $charset);
    elseif(function_exists('iconv_substr')) {
        return iconv_substr($str,$start,$length,$charset);
    }
    $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
    $re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
    $re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
    $re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
    preg_match_all($re[$charset], $str, $match);
    $slice = join("",array_slice($match[0], $start, $length));
    if($suffix) return $slice."…";
    return $slice;
}
//类似于asp的fso操作
function mkdirss($dirs,$mode=0777) {
	if(!is_dir($dirs)){
		mkdirss(dirname($dirs), $mode);
		return @mkdir($dirs, $mode);
	}
	return true;
}
function write_file($l1, $l2=''){
	$dir = dirname($l1);
	if(!is_dir($dir)){
		mkdirss($dir);
	}
	return @file_put_contents($l1, $l2);
}
function read_file($l1){
	return @file_get_contents($l1);
}
// 数组保存到文件
function arr2file($filename, $arr=''){
	if(is_array($arr)){
		$con = var_export($arr,true);
	} else{
		$con = $arr;
	}
	$con = "<?php\nreturn $con;\n?>";//\n!defined('IN_MP') && die();\nreturn $con;\n
	write_file($filename, $con);
}
// 转换成JS
function t2js($l1, $l2=1){
    $I1 = str_replace(array("\r", "\n"), array('', '\n'), addslashes($l1));
    return $l2 ? "document.write(\"$I1\");" : $I1;
}
//数据过滤函数库
function in($str)
{
	$str=trim(htmlspecialchars($str));
	if(!get_magic_quotes_gpc()) 
	{
  	  $str = addslashes($str);
	}
	return $str;	
}
function out($str)
{
    $str = stripslashes($str);
	return $str;	
}
//文本输入
function text_in($str)
{
	$str=strip_tags($str,'<br>');
	$str = str_replace(" ", "&nbsp;", $str);
	$str = str_replace("\n", "<br>", $str);	
	if(!get_magic_quotes_gpc()) 
	{
  	  $str = addslashes($str);
	}
	return $str;
}
//文本输出
function text_out($str)
{
	$str = str_replace("&nbsp;", " ", $str);
	$str = str_replace("<br>", "\n", $str);	
    $str = stripslashes($str);
	return $str;
}
//html代码输入
function html_in($str)
{
	$search = array ("'<script[^>]*?>.*?</script>'si",  // 去掉 javascript
					 "'<iframe[^>]*?>.*?</iframe>'si", // 去掉iframe
					);
	$replace = array ("",
					  "",
					);			  
   $str=@preg_replace ($search, $replace, $str);
   $str=htmlspecialchars($str);
   	if(!get_magic_quotes_gpc()) 
	{
  	  $str = addslashes($str);
	}
   return $str;
}
//html代码输出
function html_out($str)
{
	if(function_exists('htmlspecialchars_decode'))
		$str=htmlspecialchars_decode($str);
	else
		$str=html_entity_decode($str);

    $str = filterReplace(stripslashes($str));
	return $str;
}

function set_cookie($var, $value = '', $time = 0)
{
	$time = $time > 0 ? $time : 0;
	$s = $_SERVER['SERVER_PORT'] == '443' ? 1 : 0;
	$var = C('COOKIE_PRE').$var;
	$_COOKIE[$var] = $value;
	if(is_array($value))
	{
		foreach($value as $k=>$v)
		{
			setcookie($var.'['.$k.']', $v, $time, C('COOKIE_PATH'), C('COOKIE_DOMAIN'), $s);
		}
	}
	else
	{
		setcookie($var, $value, $time, C('COOKIE_PATH'), C('COOKIE_DOMAIN'), $s);
	}
}

function get_cookie($var)
{
	$var = C('COOKIE_PRE').$var;
	return isset($_COOKIE[$var]) ? $_COOKIE[$var] : false;
}
	function escape($str)
	{
		if(strtolower(C('DEFAULT_CHARSET'))=='gbk')
		{
			preg_match_all("/[\x80-\xff].|[\x01-\x7f]+/",$str,$r);
			$ar = $r[0];  
			foreach($ar as $k=>$v)
			{
			  if(ord($v[0]) < 128)
				  $ar[$k] = rawurlencode($v);
			  else
				  $ar[$k] = "%u".bin2hex(iconv(CHARSET,"UCS-2",$v));
			}  
			return join("",$ar);
		}
		else
		{
			preg_match_all("/[\xc2-\xdf][\x80-\xbf]+|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}|[\x01-\x7f]+/e",$str,$r);
			$str = $r[0];
			$len = count($str);
			for($i=0; $i<$len; $i++) {
				$value = ord($str[$i][0]);
				if($value < 223){
					$str[$i] = rawurlencode(utf8_decode($str[$i]));
				} else {
				$str[$i] = "%u".strtoupper(bin2hex(iconv("UTF-8","UCS-2",$str[$i])));
				}
			}
			return join("",$str);

		}
	}
//词语替换
function filterReplace($str)
{
	$filterWords = unserialize(substr(file_get_contents(LIB_PATH."/Cache/filter_inc.php"),13));

	for($i=0;$i<count($filterWords);$i++)
	{
		$str = str_ireplace($filterWords[$i][0],$filterWords[$i][1],$str);
	}

	unset($filterWords);

	return $str;
}
//缓存文件写入、读取、删除
function cache_read($file, $path = '', $iscachevar = 0)
{
	if(!$path) $path = CACHE_PATH;
	$cachefile = $path.$file;
	if($iscachevar)
	{
		global $TEMP;
		$key = 'cache_'.substr($file, 0, -4);
		return isset($TEMP[$key]) ? $TEMP[$key] : $TEMP[$key] = @include $cachefile;
	}
	return @include $cachefile;
}

function cache_write($file, $array, $path = '')
{
	if(!is_array($array)) return false;
	$array = "<?php\nreturn ".var_export($array, true).";\n?>";
	$cachefile = ($path ? $path : TEMP_PATH).$file;
	$strlen = file_put_contents($cachefile, $array);
	@chmod($cachefile, 0777);
	return $strlen;
}

function cache_delete($file, $path = '')
{
	$cachefile = ($path ? $path : CACHE_PATH).$file;
	return @unlink($cachefile);
}
// 获取广告调用地址
function getadsurl($str,$charset="utf-8"){
	return '<script type="text/javascript" src="__ROOT__/Runtime/Data/_gg/'.$str.'.js" charset="'.$charset.'"></script>';
}
function get_fra($id,$word='',$cid){
		if(intval($id)<1) return;
		$fra=D('co_fra');
		$node=D('co_node');
		$finfo=$fra->where('id='.$id)->find();
		
		$ruleid=$finfo['ruleid'];
		$conf=$node->where('id='.$ruleid)->find();
		import('@.ORG.Collect');
		$url=str_replace(array('($cate)','($word)'),array($cid,urlencode($word)),$finfo['colurl']);
		$art_list=collection::get_url_lists($url,$conf);
		$html='';
		foreach($art_list as $k=>$v){
			$aurl=$art_list[$k]['url']=U('Index/show?n='.$ruleid.'&aid='.$v['aid']);
			if($v['title']!=='') $html.='<li><a href="'.$aurl.'">'.$v['title'].'</a></li>';
		}
		echo str_replace($word,'<font color="red">'.$word.'</font>',$html);
		
	}
	// 测试写入文件
function testwrite($d){
	$tfile = 'xgcms.txt';
	$d = ereg_replace('/$','',$d);
	$fp = @fopen($d.'/'.$tfile,'w');
	if(!$fp){
		return false;
	}else{
		fclose($fp);
		$rs = @unlink($d.'/'.$tfile);
		if($rs){
			return true;
		}else{
			return false;
		}
	}

}
	// 获取相对目录
function get_base_path($filename){
    $base_path = $_SERVER['PHP_SELF'];
    $base_path = substr($base_path,0,strpos($base_path,$filename));
	return $base_path;
}
	//修改配置的函数 
function set_config($array,$config_file='./../Conf/config.php')
{
	 if(empty($array)||!is_array($array))
	 {
		 return false;
	 }

	 $config=file_get_contents($config_file);//读取配置
 	 foreach($array as $name=>$value)
     { 
		$name=str_replace(array("'",'"','['),array("\\'",'\"','\['),$name);//转义特殊字符，再传给正则替换
		if(is_string($value)&&!in_array($value,array('true','false','3306')))
		{
			$value="'".$value."'";//如果是字符串，加上单引号
		}
		$config=preg_replace("/(\\$".$name.")\s*=\s*(.*?);/i", "$1={$value};", $config);//查找替换
	 }
	//写入配置
	if(file_put_contents($config_file,$config))
	return true;
	else 
	return false; 
}
?>