<?php
// +----------------------------------------------------------------------
// | ƵϢɼ
// +----------------------------------------------------------------------
// | Version 1.0
// +----------------------------------------------------------------------
// | Created on 2010-11-27
// +----------------------------------------------------------------------
// | Copyright (c) 2010 http://danteng.la All rights reserved.
// +----------------------------------------------------------------------
// | Author: xuayee <xuayee@163.com>
// +----------------------------------------------------------------------

include_once('snoopy.php');
include_once('json.php');
//Ƶ
function get_video_info($url, $host) {
	$host = strtolower($host);
	switch ($host) {
		case 'youku.com' :
			//http://v.youku.com/v_show/id_XMjI4MDM4NDc2.html
			preg_match("/id\_(\w+)[=.]/", $url, $matches);
			break;
		case 'tudou.com' :
			//http://www.tudou.com/programs/view/LyimJxqB9Ig/
			preg_match("#view/([-\w]+)/#", $url, $matches);
			break;
		case 'sohu.com':
			//http://my.tv.sohu.com/u/vw/5101536
			preg_match("#vw/(\d+)#", $url, $matches);
			break;
		case 'ku6.com':
			//http://v.ku6.com/special/show_3884542/3WnCo_I4PdH-IzpQ.html
			preg_match("#/([-\w]+)\.html#", $url, $matches);
			break;
		case '56.com':
			//http://www.56.com/u39/v_NTcwMDY0Mjg.html
			preg_match("#/v_(\w+)\.html#", $url, $matches);
			break;
	}
	if (empty ($matches[1]))
		return false;
	return crawl_video($matches[1], $host);
}

function crawl_video($id, $host) {
	$Json=new JSON();
	switch ($host) {
		case 'youku.com' :
			$link = 'http://v.youku.com/player/getPlayList/VideoIDS/' .
			$id .
			'/timezone/+08/version/5/source/out?password=&ran=2513&n=3';
			$json= http_get_file($link);
			$json=$Json->decode($json);
			foreach($json->data[0]->tags as $tag){
				$return['tag'].=iconv("UTF-8","GB2312//IGNORE",$tag).',';
			}
			$return['title']=iconv("UTF-8","GB2312//IGNORE",$json->data[0]->title);
			$return['img']=$json->data[0]->logo;
			$return['time']=get_video_time($json->data[0]->seconds);
			break;
		case 'tudou.com':
			$link='/v/'.$id.'/v.swf';
			$url = http_get_location($link,'www.tudou.com');
			preg_match("#&title=([^&]*)#", $url, $str);
			$return['title']=iconv("UTF-8","GB2312//IGNORE",$str[1]);
			preg_match("#&snap_pic=([^&]*)#", $url, $str);
			$return['img']=$str[1];
			preg_match("#&tag=([^&]*)#", $url, $str);
			$return['tag']=iconv("UTF-8","GB2312//IGNORE",$str[1]);
			preg_match("#&totalTime=([^&]*)#", $url, $str);
			$return['time']=get_video_time($str[1]/100);
			break;
		case 'sohu.com':
			$link="http://v.blog.sohu.com/videinfo.jhtml?m=view&id=$id&outType=3&from=10&block=0&time=" .
					time()."703";
			$json= http_get_file($link);
			$json=$Json->decode($json);
			$return['title']=iconv("UTF-8","GB2312//IGNORE",$json->data->title);
			$return['img']=$json->data->cutCoverURL;
			$return['tag']=iconv("UTF-8","GB2312//IGNORE",$json->data->tag);
			$return['time']=get_video_time($json->data->videoLength);
			break;
		case 'ku6.com':
			$link="http://v.ku6.com/fetchVideo4Player/$id.html";
			$json= http_get_file($link);
			$json=$Json->decode($json);
			$return['title']=iconv("UTF-8","GB2312//IGNORE",$json->data->t);
			$return['img']=$json->data->picpath;
			$return['time']=get_video_time($json->data->vtime);
			break;
		case '56.com':
			$link="http://vxml.56.com/json/$id/?src=out";
			$json= http_get_file($link,'vxml.56.com');
			$json=$Json->decode($json);
			$return['title']=iconv("UTF-8","GB2312//IGNORE",$json->info->Subject);
			$return['img']=$json->info->img;
			$return['time']=get_video_time($json->info->duration/1000);
			$return['tag']=iconv("UTF-8","GB2312//IGNORE",$json->info->tags);
			break;


	}
	return $return;
}




//Httpͷתַ
function http_get_location($url,$host){
	$out="GET $url HTTP/1.1
Host: ".$host."
User-Agent: Mozilla/5.0 Firefox/3.6.8
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: zh-cn,zh;q=0.5
Accept-Charset: GB2312,utf-8;q=0.7,*;q=0.7



";
	$fp=@fsockopen($host,80,$errno,$errstr,10);
	if (!$fp){
	   return false;
	}
	else {
	  fputs($fp,$out); 
	  while (!feof($fp)){
	  	$str=fgets($fp,1024);
	  	if(preg_match("#^Location: (.*)#", $str, $matches)){
		  	fclose($fp);
		  	return urldecode($matches[1]);
	  	}
	  }
	  fclose($fp);
	}
	return false;

}


//Http
function http_get_file($url) {
	$snoopy=new Snoopy;
	$snoopy->agent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)";
	if($snoopy->fetch($url)){
		return $snoopy->results;
	}else{
		return false;
	}
}

//INTת ַ xx:xx
function get_video_time($s=1){
	$i=(int)($s/60);
	$i.=':';
	$j=intval($s)%60;
	if($j<10){
		$i.='0'.$j;
	}else{
		$i.=$j;
	}
	return $i;
}
?>
