<?php
/******************************************************************
	@filename: File.class.php
	
	@function: 文件处理类

	@author:pengyong.info
	
	@date: 2012-10-11 09:32:33

	@copyright: centphp.com
*******************************************************************/
class File
{
	/*
		@function  		创建目录
		
		@var:$filename  目录名
			
		@return:   		true
	*/
	
	static public function mk_dir($dir)
	{
		$dir = rtrim($dir,"\/")."\/";
		if(!is_dir($dir))
		{
			if(mkdir($dir, 0700)==false)
			{
				die("目录".$dir."创建失败!请检查目录创建权限!");
			}
			return true;
		}
		return true;
	}
	

	/*
		@function  		读取文件内容
		
		@var:$filename  文件名
			
		@return:   		文件内容
	*/
	
	static public function read_file($filename)
	{
		$content = '';
		if(function_exists('file_get_contents')) 
		{
			@$content = file_get_contents($filename);
		}
		else
		{
			if(@$fp = fopen($filename, 'r'))
			{
				@$content = fread($fp, filesize($filename));
				@fclose($fp);
			}
		}
		return $content;
	}
	
	/*
		@function  		写文件
		
		@var:$filename  文件名
		
		@var:$writetext 文件内容
		
		@var:$openmod 	打开方式
			
		@return:   		成功=true
	*/
	
	static function write_file($filename, $writetext, $openmod='w')
	{
		if(@$fp = fopen($filename, $openmod)) 
		{
			flock($fp, 2);
			fwrite($fp, $writetext);
			fclose($fp);
			return true;
		}
		else 
		{
			die("File: $filename write error.");
		}
	}
	

	/*
		@function  		删除目录
		
		@var:$dirName  	原目录
			
		@return:   		成功=true
	*/
	
	static function del_dir($dirName)
	{
		if (!file_exists($dirName))
		{
			die("File: $dirName not found.");
			return false;
		}
    
		$dir = opendir($dirName);
		while ($fileName = readdir($dir))
		{
			$file = $dirName . '/' . $fileName;
			if ($fileName != '.' && $fileName != '..') 
			{
				if (is_dir($file))
				{
					File::del_dir($file);
				} 
				else 
				{
					unlink($file);
				}            
			}
		}
		closedir($dir);
		return rmdir($dirName);			
	}
	
	/*
		@function  		复制目录
		
		@var:$surDir  	原目录
		
		@var:$toDir  	目标目录
		
		@return:   		true
	*/
	
	static function copy_dir($surDir,$toDir)
	{
		$surDir = rtrim($surDir,"\/")."\/";
		$toDir = rtrim($toDir,"\/")."\/";
		if (!file_exists($surDir)) 
		{
			die( 'Folder ' . $surDir .' no exist!');
			return false;
		}
    
		if (!file_exists($toDir))
		{
			File::mk_dir($toDir);
		}
		$file = opendir($surDir);
		while ($fileName = readdir($file))
		{
			$file1 = $surDir .'/'.$fileName;
			$file2 = $toDir .'/'.$fileName;
			if ($fileName != '.' && $fileName != '..') 
			{
				if (is_dir($file1)) 
				{
					File::copy_dir($file1, $file2);        
				} 
				else 
				{
					copy($file1, $file2);
				}
			}
		}
		closedir($file);
		return true;
	}
	

	/*
		@function  列出目录
		
		@var:$dir  目录名
		
		@return:   目录数组
		
		列出文件夹下内容，返回数组 $dirArray['dir']:存文件夹；$dirArray['file']：存文件
	*/
	
	static function get_dirs($dir) 
	{
		$dir = rtrim($dir,"\/")."\/";
		$dirArray [][] = NULL;
		if (false != ($handle = opendir ( $dir )))
		{
			$i = 0;
			$j = 0;
			while ( false !== ($file = readdir ( $handle )) ) 
			{
				if (is_dir ( $dir . $file )) 
				{ //判断是否文件夹
					$dirArray ['dir'] [$i] = $file;
					$i ++;
				} 
				else 
				{
					$dirArray ['file'] [$j] = $file;
					$j ++;
				}
			}
			closedir ($handle);
		}
		return $dirArray;
	}

}