<?php
	//过滤安全字符
	function zc_check($string){
		if(!is_array($string)) return addslashes(trim($string));
		foreach($string as $k => $v) $string[$k] = zc_check($v);
		return $string;
	}
	function zc_check_url($string){
		if(!is_array($string)) return safe_check(trim($string));
		foreach($string as $k => $v) $string[$k] = zc_check_url($v);
		return $string;
	}
	//过滤格式
	function zc_strip($string){
		if(!is_array($string)) return stripslashes(trim($string));
		foreach($string as $k => $v) $string[$k] = zc_strip($v);
		return $string;
	}
	
	//过滤防注射字符
	//如果包含SQL字符则返回真，否则返回假
	function inject_check($str){
 		return eregi('select|insert|update|delete|\'|\/\*|\*|\.\.\/|\.\/|union|into|load_file|outfile', $str);	
	}
	
	//对提交参数的值进行验证
	//参数：str:需要验证的字符，参数：num，0为数字，其他为字符
	function safe_check($str){
		if(inject_check($str)){
			showmsg('提交的参数非法');//注射判断
		}
		if(is_numeric($str)){
			$str=intval($str);
		}
		return $str;
	}
	
	//显示信息
	function showmsg($msg, $zc_url = 'back'){
		if($zc_url && $zc_url!='back'){
			exit("<script>alert('$msg');self.location=\"$zc_url\";</script>");
		}else{
			exit("<script>alert(\"$msg\");history.go(-1);</script>");
		}
	}
	
	//显示信息
	function selectmsg($yesurl,$nourl,$msg='是否要继续添加?'){
		exit("<script type='text/javascript'> if(confirm('$msg')){ window.location.href='$yesurl';}else{ window.location.href='$nourl';	}</script>");
	}
	
	//分页函数
	function page($totles,$size){
		$zzcms_page=new page($totles,$size);
		return $zzcms_page->page();
	}
	//写入缓存函数
	function cache_write($file,$array,$path=''){
		//如果不是数组则返回
		if(!is_array($array)) return false;
		//如果没有路径则用默认路径
		$str_array="<?php\nreturn ".var_export($array,true).";\n?>";
		$cachefile=($path?$path:CACHE_PATH).$file;
		$str_len=file_put_contents($cachefile,$str_array);
		@chmod($cachefile, 0777);
		return $str_len;
	}
	//读取缓存函数
	function cache_read($file, $path = '', $iscachevar = 0){
		if(!$path) $path = CACHE_PATH;
		$cachefile = $path.$file;
		return @include $cachefile;
	}
	//删除缓存
	function cache_delete($file, $path = ''){
		$cachefile = ($path ? $path : CACHE_PATH).$file;
		return @unlink($cachefile);
	}
	
	//验证是否有管理员权限
	function check_admin($uid,$shell){
		if($uid&&$shell){
			$sql="select * from `".PRE."admin` where `id`=".intval($uid);
			$rs=mysql_query($sql) or die (showmessage("查询管理员信息出现错误"));
			$ok=is_array($row=mysql_fetch_array($rs));
			$sll=$ok?$shell==md5($row['name'].$row['password'].ZZCMS):false;
			if($sll){
				return $row;
			}else{
				showmessage('你无权进入该页面','AdminLogin.php');
			}
		}else{
			echo("<script>top.location.href = 'AdminLogin.php';</script>");
		}
		
	}
	
	//格式化时间
	function format_date($str,$num=1){
		//$str=$str+(8*60*60);//我用的国外空间，时间相差8个小时，你们可以自己更改
		switch ($num) {
			case 1:
				return date('Y-m-d',$str);//2009-08-02 
				break;
			case 2:
				return date('Y-m-d H:i:s',$str);//2009-08-02 10:45:03 
				break;
			case 3:
				return date('Y年m月d日',$str);//2009年08月02日 
				break;
			case 4:
				return date('m月d日',$str);//08月02日 
				break;
			default:
				return date('F j,Y,g:i a',$str);//August 2,2009,10:48 am  
		}
	}
	
	
	//判断用户是否超时
	function overtime($in_time,$zc_time=1200){
		$new_time=mktime();
		if($new_time-$in_time>$zc_time){
			echo "由于你长时间未有任何操作，登录超时！";
			session_destroy();
			echo("<script>top.location.href = 'AdminLogin.php';</script>");
		}else{
			$_SESSION['in_time']=mktime();
		}		
	}
	
	//取得当前页面的页码,用于分页
	function get_page_num($sql,$pagesize){
		global $db;
		if(isset($_GET['page'])){
			$page=intval($_GET['page']);
		}else{
			$page=1;
		}
		
		if(!$page||$page<1){
			$page=1;
		}
		$totle=$db->num_rows($db->query($sql));
		$maxpage=ceil($totle/$pagesize);
		if($maxpage<1){
			$maxpage=1;
		}
		$page=$page>=$maxpage?$maxpage:$page;
		$firstpage=($page-1)*$pagesize;
		$arr=array($totle,$firstpage);
		return $arr;
	}
	//截取utf8字符串
	function str_len($str, $len) {    
		$i = 0;    
		$tlen = 0;    
		$tstr = '';    
		while ($tlen < $len) {    
			$chr = mb_substr($str, $i, 1, 'utf8');//mb_substr:按字符计算
			$chrLen = ord($chr) > 127 ? 2 : 1;    
			if ($tlen + $chrLen > $len) break;    
			$tstr .= $chr;    
			$tlen += $chrLen;    
			$i ++;    
		 }       
		return $tstr;    
	}  

	//蜘蛛的名称
	function get_bot_name($id){
		if(!$id) return false;
		$bot_array=cache_read('botlist.php');
		if(!is_array($bot_array)) return false;
		$bot_name='';
		foreach($bot_array as $k=>$v){
			if(intval($bot_array[$k]['id'])==intval($id)){
				$bot_name=$bot_array[$k]['name'];
			}
		}
		return $bot_name;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
?>