/**
 **	File ......... httpget.cpp
 **	Published ....  2004-04-07
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#include <HttpGetSocket.h>
#include <SocketHandler.h>
#include <Parse.h>


bool Get(const std::string& url_in)
{
	Parse pa(url_in,":/");
	std::string protocol = pa.getword();
	std::string host = pa.getword();
	int port;
	{
		Parse pa(host,":");
		pa.getword();
		port = pa.getvalue();
	}
	std::string url = "/" + pa.getrest();
	std::string file;
	{
		Parse pa(url,"/");
		std::string tmp = pa.getword();
		while (tmp.size())
		{
			file = tmp;
			tmp = pa.getword();
		}
	}
	SocketHandler h;
	if (!strcasecmp(protocol.c_str(),"http") || !strcasecmp(protocol.c_str(),"https"))
	{
		HttpGetSocket s(h, url_in, file);
		h.Add(&s);
		h.Select(1,0);
		while (h.GetCount())
		{
			h.Select(1,0);
		}
		return s.Complete();
	}
	else
	{
		printf("Unknown protocol: '%s'\n",protocol.c_str());
	}
	return false;
}


int main(int argc,char *argv[])
{
	for (int i = 1; i < argc; i++)
	{
		if (!Get(argv[i]))
		{
			printf("Failed: %s\n",argv[i]);
		}
	}
}


