/**
 **	File ......... ItemFactory.h
 **	Published ....  2004-05-15
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _ITEMFACTORY_H
#define _ITEMFACTORY_H

#include <string>
#include <vector>
#include <map>
#include <Utility.h>
#include "IPersist.h"
#include "cstring.h"

class SmallHandler;


// item properties
//  equip / wield position
//  damage / defense physical
//  damage / defense magical
//  

	/** ITEM properties struct. */
	struct ITEM {
		ITEM(const std::string& n,const std::string& p,const std::string& w);
		ITEM(const std::string& n,const std::string& p,const std::string& w,short ph,short ma,long am);
		std::string GetDescription()
		{
			std::string str;
			if (m_amount == 1)
			{
				str = m_name;
			}
			else
			{
				str = Utility::l2string(m_amount) + " " + m_plural;
			}
			if (m_vecno > 0)
			{
				str += " (" + Utility::l2string(m_vecno) + ")";
			}
			return str;
		}
		size_t m_vecno;
		cstring m_name; // 'a sword'
		cstring m_plural; // swords
		std::string m_wield_position;
		short m_physical;
		short m_magical;
		long m_amount;
	};
	typedef std::vector<ITEM *> item_v;

class SmallSocket;

/** Item factory; contains/spawns items. */
class ItemFactory
{
public:
	ItemFactory(SmallHandler&);
	~ItemFactory();

	ITEM *CreateRandomItem();
	ITEM *CreateGold(long amount);
	void Spawn();
	void ShowNamesAt(SmallSocket *p,int x,int y,const std::string& prefix = "");

	SmallHandler& Handler() { return m_handler; }
	item_v& GetItems(int x,int y) { return m_items[x][y]; }
	size_t NumberOfItems();

	void Merge(item_v&,ITEM *);

private:
	SmallHandler& m_handler;
	std::map<int, std::map<int, item_v> > m_items;
};




#endif // _ITEMFACTORY_H
