/**
 **	File ......... PlayerFactory.cpp
 **	Published ....  2004-05-15
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//#include <stdio.h>

#include "SmallSocket.h"
#include "PlayerFactory.h"



PlayerFactory::PlayerFactory()
:IPersist()
{
}


PlayerFactory::~PlayerFactory()
{
}


void PlayerFactory::Load()
{
	FILE *fil = fopen("players.txt","rt");
	if (fil)
	{
		char slask[1000];
		fgets(slask,1000,fil);
		while (!feof(fil))
		{
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			long nr = atol(slask);
			fgets(slask,1000,fil);
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			std::string name = slask;
			fgets(slask,1000,fil);
			while (strlen(slask) && (slask[strlen(slask) - 1] == 13 || slask[strlen(slask) - 1] == 10))
			{
				slask[strlen(slask) - 1] = 0;
			}
			std::string passwd = slask;
			PLAYER *p = new PLAYER(nr,name,passwd);
			m_players.push_back(p);
			//
			fgets(slask,1000,fil);
		}
	}
}


void PlayerFactory::Save()
{
	FILE *fil = fopen("players.0","wt");
	if (fil)
	{
		for (player_v::iterator it = m_players.begin(); it != m_players.end(); it++)
		{
			PLAYER *p = *it;
			fprintf(fil,"%ld\n",p -> nr);
			fprintf(fil,"%s\n",p -> m_name.c_str());
			fprintf(fil,"%s\n",p -> m_passwd.c_str());
		}
		fclose(fil);
		unlink("players.old");
		rename("players.txt","players.old");
		rename("players.0","players.txt");
	}
}


PlayerFactory::PLAYER *PlayerFactory::FindPlayer(const std::string& n,const std::string& p)
{
	for (player_v::iterator it = m_players.begin(); it != m_players.end(); it++)
	{
		PLAYER *p = *it;
		if (p -> m_name == n) // && p -> passwd == p)
		{
			return p;
		}
	}
	return NULL;
}


PlayerFactory::PLAYER *PlayerFactory::AddPlayer(const std::string& n,const std::string& pw)
{
	PLAYER *p = new PLAYER(0,n,pw);
	m_players.push_back(p);
	p -> nr = m_players.size(); // never delete any player
	return p;
}


void PlayerFactory::PLAYER::DisplayInventory(SmallSocket *p) 
{
	for (item_v::iterator it = m_inventory.begin(); it != m_inventory.end(); it++)
	{
		ITEM *i = *it;
		std::string str;
		p -> Send(" " + i -> GetDescription() + "\n");
	}
}


