/**
 **	File ......... PlayerFactory.h
 **	Published ....  2004-05-15
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _PLAYERFACTORY_H
#define _PLAYERFACTORY_H

#include <string>
#include <vector>
#include <Utility.h>
#include "IPersist.h"
#include "ItemFactory.h"

class SmallSocket;


/** Player list container. */
class PlayerFactory : public IPersist
{
public:
	/** Player properties struct. */
	struct PLAYER
	{
		PLAYER(long l,const std::string& n,const std::string& p) : nr(l),m_name(n),m_passwd(p) {}
		~PLAYER()
		{
			for (item_v::iterator it = m_inventory.begin(); it != m_inventory.end(); it++)
			{
				ITEM *i = *it;
				delete i;
			}
		}
		void DisplayInventory(SmallSocket *p);
		item_v& GetInventory() { return m_inventory; }
		long nr;
		std::string m_name;
		std::string m_passwd;
		item_v m_inventory;
	};
	typedef std::vector<PLAYER *> player_v;

public:
	PlayerFactory();
	virtual ~PlayerFactory();

	void Load();
	void Save();

	PLAYER *FindPlayer(const std::string& n,const std::string& p);
	PLAYER *AddPlayer(const std::string& n,const std::string& p);

private:
	player_v m_players;
};




#endif // _PLAYERFACTORY_H
