//SmallHandler.h
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef _CHATHANDLER_H
#define _CHATHANDLER_H

#include <SocketHandler.h>
#include "World.h"
#include "MobFactory.h"
#include "IPersist.h"
#include "PlayerFactory.h"
#include "ItemFactory.h"


class SmallSocket;

/** Small mud socket handler controller class. */
class SmallHandler : public SocketHandler
{
public:
	SmallHandler();
	~SmallHandler();

	void Who(SmallSocket *);
	void ShowCell(SmallSocket *);

	void SecTick(time_t);
	World& GetWorld() { return m_world; }
	PlayerFactory& GetPlayerF() { return m_pf; }
	item_v& GetItems(int x,int y) { return m_itemf.GetItems(x,y); }
	void ShowStatus(SmallSocket *);
	void MergeItem(item_v& x,ITEM *y) { m_itemf.Merge(x,y); }

	void Event(int x,int y,const std::string& ,SmallSocket * = NULL,bool = false);

	void Load();

private:
	World m_world;
	MobFactory m_mob;
	PlayerFactory m_pf;
	ipersist_v m_persist;
	ItemFactory m_itemf;
};




#endif // _CHATHANDLER_H
