//InSocket.cpp
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#include <stdio.h>

#include <ISocketHandler.h>
#include "OutSocket.h"
#include "InSocket.h"




InSocket::InSocket(ISocketHandler& h)
:TcpSocket(h, 32000, 32000)
,tmpl(0)
{
}


InSocket::~InSocket()
{
}


void InSocket::OnAccept()
{
	printf(" *** Remote Address: '%s'\n",GetRemoteHostname().c_str());
	m_remote = new OutSocket(Handler());
//	m_remote -> Open("159.153.197.91",8888);
	m_remote -> Open("127.0.0.1",80);
	m_remote -> SetDeleteByHandler();
	m_remote -> SetRemote(this);
//	sleep(1);
	Handler().Add(m_remote);
}


void InSocket::OnDelete()
{
	if (Handler().Valid(m_remote))
	{
		m_remote -> SetCloseAndDelete();
	}
}


void InSocket::OnRawData(const char *p,size_t l)
{
	if (Handler().Valid(m_remote) && m_remote -> Ready())
	{
		if (tmpl)
		{
			m_remote -> SendBuf(tmps, tmpl);
			tmpl = 0;
		}
		m_remote -> SendBuf(p, l);
	}
	else
	{
		Handler().LogError(this, "OnRawData", 0, "m_remote not ready");
		memcpy(tmps + tmpl, p, l);
		tmpl += l;
	}
}


