//OutSocket.cpp
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

//#include <stdio.h>

#include "InSocket.h"
#include "OutSocket.h"




OutSocket::OutSocket(ISocketHandler& h)
:TcpSocket(h, 32000, 32000)
,m_remote(NULL)
{
}


OutSocket::~OutSocket()
{
}


void OutSocket::OnDelete()
{
	if (Handler().Valid(m_remote))
	{
		m_remote -> SetCloseAndDelete();
	}
}


void OutSocket::OnRawData(const char *p,size_t l)
{
	if (Handler().Valid(m_remote))
	{
		m_remote -> SendBuf(p, l);
	}
	else
	{
		Handler().LogError(this, "OnRawData", 0, "m_remote not valid");
	}
}


void OutSocket::OnConnect()
{
	if (Handler().Valid(m_remote))
	{
		if (m_remote -> tmpl)
		{
			printf("Sending %d early bytes\n",m_remote -> tmpl);
			SendBuf(m_remote -> tmps, m_remote -> tmpl);
			m_remote -> tmpl = 0;
		}
	}
}


