#include <Utility.h>
#include "UdpTestSocket.h"


UdpTestSocket::UdpTestSocket(ISocketHandler& h)
:UdpSocket(h)
{
}


void UdpTestSocket::OnRawData(const char *p,size_t l,struct sockaddr *sa_from,socklen_t sa_len)
{
	if (sa_len == sizeof(struct sockaddr_in)) // IPv4
	{
		struct sockaddr_in sa;
		memcpy(&sa,sa_from,sa_len);
		ipaddr_t a;
		memcpy(&a,&sa.sin_addr,4);
		std::string ip;
		Utility::l2ip(a,ip);
		printf("Received %d bytes from: %s:%d\n", l,ip.c_str(),ntohs(sa.sin_port));
		printf("%s\n",static_cast<std::string>(p).substr(0,l).c_str());
	}
	else
	if (sa_len == sizeof(struct sockaddr_in6)) // IPv6
	{
		struct sockaddr_in6 sa;
		memcpy(&sa,sa_from,sa_len);
		std::string ip;
		Utility::l2ip(sa.sin6_addr,ip);
		printf("(IPv6) Received %d bytes from: %s:%d\n", l,ip.c_str(),ntohs(sa.sin6_port));
		printf("%s\n",static_cast<std::string>(p).substr(0,l).c_str());
	}
}
