/**
 **	File ......... DChatHandler.cpp
 **	Published ....  2004-04-19
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//#include <stdio.h>
#include <Utility.h>
#include "DChatHandler.h"




DChatHandler::DChatHandler(const std::string& f)
:MinderHandler()
{
}


DChatHandler::~DChatHandler()
{
}


void DChatHandler::Who(ChatSocket *)
{
	SendMessage(Utility::base64("who"));
}


void DChatHandler::Talk(const std::string& name,const std::string& prat)
{
	std::string msg = "talk:" + Utility::base64(name);
	msg += ":" + prat;
	SendMessage(Utility::base64(msg));
}


void DChatHandler::SendWho()
{
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		ChatSocket *p = dynamic_cast<ChatSocket *>(p0);
		if (p)
		{
			std::string msg = "online:" + Utility::base64(p -> GetName());
			SendMessage(Utility::base64(msg));
		}
	}
}


void DChatHandler::SendTalk(const std::string& who,const std::string& prat)
{
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		ChatSocket *p = dynamic_cast<ChatSocket *>(p0);
		if (p)
		{
			std::string str = who + " says '" + prat + "'\n";
			p -> Send( "\n" + str);
			p -> Send(">");
		}
	}
}


void DChatHandler::ShowWho(const std::string& who)
{
	for (socket_m::iterator it = m_sockets.begin(); it != m_sockets.end(); it++)
	{
		Socket *p0 = (*it).second;
		ChatSocket *p = dynamic_cast<ChatSocket *>(p0);
		if (p)
		{
			std::string str = who + " is online.\n";
			p -> Send( "\n" + str);
			p -> Send(">");
		}
	}
}


