/**
 **	File ......... DChatMinionSocket.cpp
 **	Published ....  2004-04-19
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
//#include <stdio.h>
#include "DChatHandler.h"
#include "DChatMinionSocket.h"

#define DEB(x) x


DChatMinionSocket::DChatMinionSocket(ISocketHandler& h)
:MinionSocket(h)
{
}


DChatMinionSocket::DChatMinionSocket(ISocketHandler& h,const std::string& s,ipaddr_t a,port_t p)
:MinionSocket(h,s,a,p)
{
}


DChatMinionSocket::~DChatMinionSocket()
{
}


bool DChatMinionSocket::OnVerifiedLine(const std::string& cmd,Parse& pa)
{
	if (cmd == "who")
	{
		static_cast<DChatHandler&>(Handler()).SendWho();
	}
	else
	if (cmd == "talk")
	{
		std::string who = Utility::base64d(pa.getword());
		std::string prat = pa.getrest();
		static_cast<DChatHandler&>(Handler()).SendTalk(who,prat);
	}
	else
	if (cmd == "online")
	{
		std::string who = Utility::base64d(pa.getword());
		static_cast<DChatHandler&>(Handler()).ShowWho(who);
	}
	else
	{
		return MinionSocket::OnVerifiedLine(cmd, pa);
	}
	return true;
}


