/**
 **	File ......... ICMPTwistSocket.h
 **	Published ....  2004-07-03
 **	Author ....... grymse@alhem.net
**/
/*
Copyright (C) 2004  Anders Hedstrom
Parts Copyright (c) Vergil of Ragestorm.net, 2003

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
#ifndef _ICMPTWISTSOCKET_H
#define _ICMPTWISTSOCKET_H

#include "Socket.h"


/* ICMP_TWIST.C: A program intended to demonstrate the usage
 * of ICMP Information Request (Type 15) messages.
 * What this program does and does not do:
 * It DOES implement an ICMP chat using raw sockets and Type 15 messages.
 * It DOES manipulate UNIX file system descriptors in creative ways.
 * It uses poll() (but not select()), a good call if we want to multiplex
 * input and output
 * It does NOT use the kernel headers for defining ICMP structs etc.
 * (see <linux/icmp.h>
 * It does NOT compile under Windows, although changes to allow that
 * would be minor.
*/

// ICMP codes
#define ICMP_INFO_REQUEST 15
#define ICMP_INFO_REPLY 16

/* Should be between 530 and 1450 (MTU always >= 576, and in most
 * cases < 1500); 14 bytes go for the Ethernet header, 20 for the IP header
 * and 8 for the ICMP header. Fragmentation is not [yet] implemented
*/
#define INP_BUFFER 256

struct icmp_info // reply and request
{
	uint8_t type;
	uint8_t code;
	uint16_t checksum;
	uint16_t id;
	uint16_t seq_no;
	char buffer[INP_BUFFER];
};


class ICMPTwistSocket : public Socket
{
public:
	ICMPTwistSocket(ISocketHandler& );
	~ICMPTwistSocket();

	void OnRead();

	void Connect(const std::string& );
	void Send(const std::string& );

	void OnOptions(int,int,int,SOCKET) {}

private:
	uint16_t calc_crc(uint8_t * packet, size_t len);
	struct icmp_info m_info;
	uint16_t m_seq_no;
};


#endif // _ICMPTWISTSOCKET_H
