/*** xrkmonitor license ***

   Copyright (c) 2019 by rockdeng

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.


   字符云监控(xrkmonitor) 开源版 (c) 2019 by rockdeng
   当前版本：v1.0
   使用授权协议： apache license 2.0

   云版本主页：http://xrkmonitor.com

   云版本为开源版提供永久免费告警通道支持，告警通道支持短信、邮件、
   微信等多种方式，欢迎使用

   开发库 mtagent_api_open 说明:
        字符云监控系统内部公共库，提供各种公共的基础函数调用

****/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <unistd.h>
#include "tconv_g2u.h"

static const uint16_t __wrong_padding_utf16 = 0xa125;
static uint16_t __map_gbk2utf16[33089] = {0};
static int __is_init_g2u_map = 0;
void InitGbk2UtfMap();
class _TInitG2UMap {
	public:
		_TInitG2UMap() {
			InitGbk2UtfMap();
			m_bInit = true;
		}
	private:
		bool m_bInit;
};
static _TInitG2UMap _init_g2u_map;

void InitGbk2UtfMap() 
{
	if(__is_init_g2u_map)
		return ;

	__map_gbk2utf16[0x0000] = 0x4e02; 
	__map_gbk2utf16[0x0001] = 0x4e04; 
	__map_gbk2utf16[0x0002] = 0x4e05;
	__map_gbk2utf16[0x0003] = 0x4e06;
	__map_gbk2utf16[0x0004] = 0x4e0f;
	__map_gbk2utf16[0x0005] = 0x4e12;
	__map_gbk2utf16[0x0006] = 0x4e17;
	__map_gbk2utf16[0x0007] = 0x4e1f;
	__map_gbk2utf16[0x0008] = 0x4e20;
	__map_gbk2utf16[0x0009] = 0x4e21;
	__map_gbk2utf16[0x000a] = 0x4e23;
	__map_gbk2utf16[0x000b] = 0x4e26;
	__map_gbk2utf16[0x000c] = 0x4e29;
	__map_gbk2utf16[0x000d] = 0x4e2e;
	__map_gbk2utf16[0x000e] = 0x4e2f;
	__map_gbk2utf16[0x000f] = 0x4e31;
	__map_gbk2utf16[0x0010] = 0x4e33;
	__map_gbk2utf16[0x0011] = 0x4e35;
	__map_gbk2utf16[0x0012] = 0x4e37;
	__map_gbk2utf16[0x0013] = 0x4e3c;
	__map_gbk2utf16[0x0014] = 0x4e40;
	__map_gbk2utf16[0x0015] = 0x4e41;
	__map_gbk2utf16[0x0016] = 0x4e42;
	__map_gbk2utf16[0x0017] = 0x4e44;
	__map_gbk2utf16[0x0018] = 0x4e46;
	__map_gbk2utf16[0x0019] = 0x4e4a;
	__map_gbk2utf16[0x001a] = 0x4e51;
	__map_gbk2utf16[0x001b] = 0x4e55;
	__map_gbk2utf16[0x001c] = 0x4e57;
	__map_gbk2utf16[0x001d] = 0x4e5a;
	__map_gbk2utf16[0x001e] = 0x4e5b;
	__map_gbk2utf16[0x001f] = 0x4e62;
	__map_gbk2utf16[0x0020] = 0x4e63;
	__map_gbk2utf16[0x0021] = 0x4e64;
	__map_gbk2utf16[0x0022] = 0x4e65;
	__map_gbk2utf16[0x0023] = 0x4e67;
	__map_gbk2utf16[0x0024] = 0x4e68;
	__map_gbk2utf16[0x0025] = 0x4e6a;
	__map_gbk2utf16[0x0026] = 0x4e6b;
	__map_gbk2utf16[0x0027] = 0x4e6c;
	__map_gbk2utf16[0x0028] = 0x4e6d;
	__map_gbk2utf16[0x0029] = 0x4e6e;
	__map_gbk2utf16[0x002a] = 0x4e6f;
	__map_gbk2utf16[0x002b] = 0x4e72;
	__map_gbk2utf16[0x002c] = 0x4e74;
	__map_gbk2utf16[0x002d] = 0x4e75;
	__map_gbk2utf16[0x002e] = 0x4e76;
	__map_gbk2utf16[0x002f] = 0x4e77;
	__map_gbk2utf16[0x0030] = 0x4e78;
	__map_gbk2utf16[0x0031] = 0x4e79;
	__map_gbk2utf16[0x0032] = 0x4e7a;
	__map_gbk2utf16[0x0033] = 0x4e7b;
	__map_gbk2utf16[0x0034] = 0x4e7c;
	__map_gbk2utf16[0x0035] = 0x4e7d;
	__map_gbk2utf16[0x0036] = 0x4e7f;
	__map_gbk2utf16[0x0037] = 0x4e80;
	__map_gbk2utf16[0x0038] = 0x4e81;
	__map_gbk2utf16[0x0039] = 0x4e82;
	__map_gbk2utf16[0x003a] = 0x4e83;
	__map_gbk2utf16[0x003b] = 0x4e84;
	__map_gbk2utf16[0x003c] = 0x4e85;
	__map_gbk2utf16[0x003d] = 0x4e87;
	__map_gbk2utf16[0x003e] = 0x4e8a;
	__map_gbk2utf16[0x0040] = 0x4e90;
	__map_gbk2utf16[0x0041] = 0x4e96;
	__map_gbk2utf16[0x0042] = 0x4e97;
	__map_gbk2utf16[0x0043] = 0x4e99;
	__map_gbk2utf16[0x0044] = 0x4e9c;
	__map_gbk2utf16[0x0045] = 0x4e9d;
	__map_gbk2utf16[0x0046] = 0x4e9e;
	__map_gbk2utf16[0x0047] = 0x4ea3;
	__map_gbk2utf16[0x0048] = 0x4eaa;
	__map_gbk2utf16[0x0049] = 0x4eaf;
	__map_gbk2utf16[0x004a] = 0x4eb0;
	__map_gbk2utf16[0x004b] = 0x4eb1;
	__map_gbk2utf16[0x004c] = 0x4eb4;
	__map_gbk2utf16[0x004d] = 0x4eb6;
	__map_gbk2utf16[0x004e] = 0x4eb7;
	__map_gbk2utf16[0x004f] = 0x4eb8;
	__map_gbk2utf16[0x0050] = 0x4eb9;
	__map_gbk2utf16[0x0051] = 0x4ebc;
	__map_gbk2utf16[0x0052] = 0x4ebd;
	__map_gbk2utf16[0x0053] = 0x4ebe;
	__map_gbk2utf16[0x0054] = 0x4ec8;
	__map_gbk2utf16[0x0055] = 0x4ecc;
	__map_gbk2utf16[0x0056] = 0x4ecf;
	__map_gbk2utf16[0x0057] = 0x4ed0;
	__map_gbk2utf16[0x0058] = 0x4ed2;
	__map_gbk2utf16[0x0059] = 0x4eda;
	__map_gbk2utf16[0x005a] = 0x4edb;
	__map_gbk2utf16[0x005b] = 0x4edc;
	__map_gbk2utf16[0x005c] = 0x4ee0;
	__map_gbk2utf16[0x005d] = 0x4ee2;
	__map_gbk2utf16[0x005e] = 0x4ee6;
	__map_gbk2utf16[0x005f] = 0x4ee7;
	__map_gbk2utf16[0x0060] = 0x4ee9;
	__map_gbk2utf16[0x0061] = 0x4eed;
	__map_gbk2utf16[0x0062] = 0x4eee;
	__map_gbk2utf16[0x0063] = 0x4eef;
	__map_gbk2utf16[0x0064] = 0x4ef1;
	__map_gbk2utf16[0x0065] = 0x4ef4;
	__map_gbk2utf16[0x0066] = 0x4ef8;
	__map_gbk2utf16[0x0067] = 0x4ef9;
	__map_gbk2utf16[0x0068] = 0x4efa;
	__map_gbk2utf16[0x0069] = 0x4efc;
	__map_gbk2utf16[0x006a] = 0x4efe;
	__map_gbk2utf16[0x006b] = 0x4f00;
	__map_gbk2utf16[0x006c] = 0x4f02;
	__map_gbk2utf16[0x006d] = 0x4f03;
	__map_gbk2utf16[0x006e] = 0x4f04;
	__map_gbk2utf16[0x006f] = 0x4f05;
	__map_gbk2utf16[0x0070] = 0x4f06;
	__map_gbk2utf16[0x0071] = 0x4f07;
	__map_gbk2utf16[0x0072] = 0x4f08;
	__map_gbk2utf16[0x0073] = 0x4f0b;
	__map_gbk2utf16[0x0074] = 0x4f0c;
	__map_gbk2utf16[0x0075] = 0x4f12;
	__map_gbk2utf16[0x0076] = 0x4f13;
	__map_gbk2utf16[0x0077] = 0x4f14;
	__map_gbk2utf16[0x0078] = 0x4f15;
	__map_gbk2utf16[0x0079] = 0x4f16;
	__map_gbk2utf16[0x007a] = 0x4f1c;
	__map_gbk2utf16[0x007b] = 0x4f1d;
	__map_gbk2utf16[0x007c] = 0x4f21;
	__map_gbk2utf16[0x007d] = 0x4f23;
	__map_gbk2utf16[0x007e] = 0x4f28;
	__map_gbk2utf16[0x007f] = 0x4f29;
	__map_gbk2utf16[0x0080] = 0x4f2c;
	__map_gbk2utf16[0x0081] = 0x4f2d;
	__map_gbk2utf16[0x0082] = 0x4f2e;
	__map_gbk2utf16[0x0083] = 0x4f31;
	__map_gbk2utf16[0x0084] = 0x4f33;
	__map_gbk2utf16[0x0085] = 0x4f35;
	__map_gbk2utf16[0x0086] = 0x4f37;
	__map_gbk2utf16[0x0087] = 0x4f39;
	__map_gbk2utf16[0x0088] = 0x4f3b;
	__map_gbk2utf16[0x0089] = 0x4f3e;
	__map_gbk2utf16[0x008a] = 0x4f3f;
	__map_gbk2utf16[0x008b] = 0x4f40;
	__map_gbk2utf16[0x008c] = 0x4f41;
	__map_gbk2utf16[0x008d] = 0x4f42;
	__map_gbk2utf16[0x008e] = 0x4f44;
	__map_gbk2utf16[0x008f] = 0x4f45;
	__map_gbk2utf16[0x0090] = 0x4f47;
	__map_gbk2utf16[0x0091] = 0x4f48;
	__map_gbk2utf16[0x0092] = 0x4f49;
	__map_gbk2utf16[0x0093] = 0x4f4a;
	__map_gbk2utf16[0x0094] = 0x4f4b;
	__map_gbk2utf16[0x0095] = 0x4f4c;
	__map_gbk2utf16[0x0096] = 0x4f52;
	__map_gbk2utf16[0x0097] = 0x4f54;
	__map_gbk2utf16[0x0098] = 0x4f56;
	__map_gbk2utf16[0x0099] = 0x4f61;
	__map_gbk2utf16[0x009a] = 0x4f62;
	__map_gbk2utf16[0x009b] = 0x4f66;
	__map_gbk2utf16[0x009c] = 0x4f68;
	__map_gbk2utf16[0x009d] = 0x4f6a;
	__map_gbk2utf16[0x009e] = 0x4f6b;
	__map_gbk2utf16[0x009f] = 0x4f6d;
	__map_gbk2utf16[0x00a0] = 0x4f6e;
	__map_gbk2utf16[0x00a1] = 0x4f71;
	__map_gbk2utf16[0x00a2] = 0x4f72;
	__map_gbk2utf16[0x00a3] = 0x4f75;
	__map_gbk2utf16[0x00a4] = 0x4f77;
	__map_gbk2utf16[0x00a5] = 0x4f78;
	__map_gbk2utf16[0x00a6] = 0x4f79;
	__map_gbk2utf16[0x00a7] = 0x4f7a;
	__map_gbk2utf16[0x00a8] = 0x4f7d;
	__map_gbk2utf16[0x00a9] = 0x4f80;
	__map_gbk2utf16[0x00aa] = 0x4f81;
	__map_gbk2utf16[0x00ab] = 0x4f82;
	__map_gbk2utf16[0x00ac] = 0x4f85;
	__map_gbk2utf16[0x00ad] = 0x4f86;
	__map_gbk2utf16[0x00ae] = 0x4f87;
	__map_gbk2utf16[0x00af] = 0x4f8a;
	__map_gbk2utf16[0x00b0] = 0x4f8c;
	__map_gbk2utf16[0x00b1] = 0x4f8e;
	__map_gbk2utf16[0x00b2] = 0x4f90;
	__map_gbk2utf16[0x00b3] = 0x4f92;
	__map_gbk2utf16[0x00b4] = 0x4f93;
	__map_gbk2utf16[0x00b5] = 0x4f95;
	__map_gbk2utf16[0x00b6] = 0x4f96;
	__map_gbk2utf16[0x00b7] = 0x4f98;
	__map_gbk2utf16[0x00b8] = 0x4f99;
	__map_gbk2utf16[0x00b9] = 0x4f9a;
	__map_gbk2utf16[0x00ba] = 0x4f9c;
	__map_gbk2utf16[0x00bb] = 0x4f9e;
	__map_gbk2utf16[0x00bc] = 0x4f9f;
	__map_gbk2utf16[0x00bd] = 0x4fa1;
	__map_gbk2utf16[0x00be] = 0x4fa2;
	__map_gbk2utf16[0x0100] = 0x4fa4;
	__map_gbk2utf16[0x0101] = 0x4fab;
	__map_gbk2utf16[0x0102] = 0x4fad;
	__map_gbk2utf16[0x0103] = 0x4fb0;
	__map_gbk2utf16[0x0104] = 0x4fb1;
	__map_gbk2utf16[0x0105] = 0x4fb2;
	__map_gbk2utf16[0x0106] = 0x4fb3;
	__map_gbk2utf16[0x0107] = 0x4fb4;
	__map_gbk2utf16[0x0108] = 0x4fb6;
	__map_gbk2utf16[0x0109] = 0x4fb7;
	__map_gbk2utf16[0x010a] = 0x4fb8;
	__map_gbk2utf16[0x010b] = 0x4fb9;
	__map_gbk2utf16[0x010c] = 0x4fba;
	__map_gbk2utf16[0x010d] = 0x4fbb;
	__map_gbk2utf16[0x010e] = 0x4fbc;
	__map_gbk2utf16[0x010f] = 0x4fbd;
	__map_gbk2utf16[0x0110] = 0x4fbe;
	__map_gbk2utf16[0x0111] = 0x4fc0;
	__map_gbk2utf16[0x0112] = 0x4fc1;
	__map_gbk2utf16[0x0113] = 0x4fc2;
	__map_gbk2utf16[0x0114] = 0x4fc6;
	__map_gbk2utf16[0x0115] = 0x4fc7;
	__map_gbk2utf16[0x0116] = 0x4fc8;
	__map_gbk2utf16[0x0117] = 0x4fc9;
	__map_gbk2utf16[0x0118] = 0x4fcb;
	__map_gbk2utf16[0x0119] = 0x4fcc;
	__map_gbk2utf16[0x011a] = 0x4fcd;
	__map_gbk2utf16[0x011b] = 0x4fd2;
	__map_gbk2utf16[0x011c] = 0x4fd3;
	__map_gbk2utf16[0x011d] = 0x4fd4;
	__map_gbk2utf16[0x011e] = 0x4fd5;
	__map_gbk2utf16[0x011f] = 0x4fd6;
	__map_gbk2utf16[0x0120] = 0x4fd9;
	__map_gbk2utf16[0x0121] = 0x4fdb;
	__map_gbk2utf16[0x0122] = 0x4fe0;
	__map_gbk2utf16[0x0123] = 0x4fe2;
	__map_gbk2utf16[0x0124] = 0x4fe4;
	__map_gbk2utf16[0x0125] = 0x4fe5;
	__map_gbk2utf16[0x0126] = 0x4fe7;
	__map_gbk2utf16[0x0127] = 0x4feb;
	__map_gbk2utf16[0x0128] = 0x4fec;
	__map_gbk2utf16[0x0129] = 0x4ff0;
	__map_gbk2utf16[0x012a] = 0x4ff2;
	__map_gbk2utf16[0x012b] = 0x4ff4;
	__map_gbk2utf16[0x012c] = 0x4ff5;
	__map_gbk2utf16[0x012d] = 0x4ff6;
	__map_gbk2utf16[0x012e] = 0x4ff7;
	__map_gbk2utf16[0x012f] = 0x4ff9;
	__map_gbk2utf16[0x0130] = 0x4ffb;
	__map_gbk2utf16[0x0131] = 0x4ffc;
	__map_gbk2utf16[0x0132] = 0x4ffd;
	__map_gbk2utf16[0x0133] = 0x4fff;
	__map_gbk2utf16[0x0134] = 0x5000;
	__map_gbk2utf16[0x0135] = 0x5001;
	__map_gbk2utf16[0x0136] = 0x5002;
	__map_gbk2utf16[0x0137] = 0x5003;
	__map_gbk2utf16[0x0138] = 0x5004;
	__map_gbk2utf16[0x0139] = 0x5005;
	__map_gbk2utf16[0x013a] = 0x5006;
	__map_gbk2utf16[0x013b] = 0x5007;
	__map_gbk2utf16[0x013c] = 0x5008;
	__map_gbk2utf16[0x013d] = 0x5009;
	__map_gbk2utf16[0x013e] = 0x500a;
	__map_gbk2utf16[0x0140] = 0x500b;
	__map_gbk2utf16[0x0141] = 0x500e;
	__map_gbk2utf16[0x0142] = 0x5010;
	__map_gbk2utf16[0x0143] = 0x5011;
	__map_gbk2utf16[0x0144] = 0x5013;
	__map_gbk2utf16[0x0145] = 0x5015;
	__map_gbk2utf16[0x0146] = 0x5016;
	__map_gbk2utf16[0x0147] = 0x5017;
	__map_gbk2utf16[0x0148] = 0x501b;
	__map_gbk2utf16[0x0149] = 0x501d;
	__map_gbk2utf16[0x014a] = 0x501e;
	__map_gbk2utf16[0x014b] = 0x5020;
	__map_gbk2utf16[0x014c] = 0x5022;
	__map_gbk2utf16[0x014d] = 0x5023;
	__map_gbk2utf16[0x014e] = 0x5024;
	__map_gbk2utf16[0x014f] = 0x5027;
	__map_gbk2utf16[0x0150] = 0x502b;
	__map_gbk2utf16[0x0151] = 0x502f;
	__map_gbk2utf16[0x0152] = 0x5030;
	__map_gbk2utf16[0x0153] = 0x5031;
	__map_gbk2utf16[0x0154] = 0x5032;
	__map_gbk2utf16[0x0155] = 0x5033;
	__map_gbk2utf16[0x0156] = 0x5034;
	__map_gbk2utf16[0x0157] = 0x5035;
	__map_gbk2utf16[0x0158] = 0x5036;
	__map_gbk2utf16[0x0159] = 0x5037;
	__map_gbk2utf16[0x015a] = 0x5038;
	__map_gbk2utf16[0x015b] = 0x5039;
	__map_gbk2utf16[0x015c] = 0x503b;
	__map_gbk2utf16[0x015d] = 0x503d;
	__map_gbk2utf16[0x015e] = 0x503f;
	__map_gbk2utf16[0x015f] = 0x5040;
	__map_gbk2utf16[0x0160] = 0x5041;
	__map_gbk2utf16[0x0161] = 0x5042;
	__map_gbk2utf16[0x0162] = 0x5044;
	__map_gbk2utf16[0x0163] = 0x5045;
	__map_gbk2utf16[0x0164] = 0x5046;
	__map_gbk2utf16[0x0165] = 0x5049;
	__map_gbk2utf16[0x0166] = 0x504a;
	__map_gbk2utf16[0x0167] = 0x504b;
	__map_gbk2utf16[0x0168] = 0x504d;
	__map_gbk2utf16[0x0169] = 0x5050;
	__map_gbk2utf16[0x016a] = 0x5051;
	__map_gbk2utf16[0x016b] = 0x5052;
	__map_gbk2utf16[0x016c] = 0x5053;
	__map_gbk2utf16[0x016d] = 0x5054;
	__map_gbk2utf16[0x016e] = 0x5056;
	__map_gbk2utf16[0x016f] = 0x5057;
	__map_gbk2utf16[0x0170] = 0x5058;
	__map_gbk2utf16[0x0171] = 0x5059;
	__map_gbk2utf16[0x0172] = 0x505b;
	__map_gbk2utf16[0x0173] = 0x505d;
	__map_gbk2utf16[0x0174] = 0x505e;
	__map_gbk2utf16[0x0175] = 0x505f;
	__map_gbk2utf16[0x0176] = 0x5060;
	__map_gbk2utf16[0x0177] = 0x5061;
	__map_gbk2utf16[0x0178] = 0x5062;
	__map_gbk2utf16[0x0179] = 0x5063;
	__map_gbk2utf16[0x017a] = 0x5064;
	__map_gbk2utf16[0x017b] = 0x5066;
	__map_gbk2utf16[0x017c] = 0x5067;
	__map_gbk2utf16[0x017d] = 0x5068;
	__map_gbk2utf16[0x017e] = 0x5069;
	__map_gbk2utf16[0x017f] = 0x506a;
	__map_gbk2utf16[0x0180] = 0x506b;
	__map_gbk2utf16[0x0181] = 0x506d;
	__map_gbk2utf16[0x0182] = 0x506e;
	__map_gbk2utf16[0x0183] = 0x506f;
	__map_gbk2utf16[0x0184] = 0x5070;
	__map_gbk2utf16[0x0185] = 0x5071;
	__map_gbk2utf16[0x0186] = 0x5072;
	__map_gbk2utf16[0x0187] = 0x5073;
	__map_gbk2utf16[0x0188] = 0x5074;
	__map_gbk2utf16[0x0189] = 0x5075;
	__map_gbk2utf16[0x018a] = 0x5078;
	__map_gbk2utf16[0x018b] = 0x5079;
	__map_gbk2utf16[0x018c] = 0x507a;
	__map_gbk2utf16[0x018d] = 0x507c;
	__map_gbk2utf16[0x018e] = 0x507d;
	__map_gbk2utf16[0x018f] = 0x5081;
	__map_gbk2utf16[0x0190] = 0x5082;
	__map_gbk2utf16[0x0191] = 0x5083;
	__map_gbk2utf16[0x0192] = 0x5084;
	__map_gbk2utf16[0x0193] = 0x5086;
	__map_gbk2utf16[0x0194] = 0x5087;
	__map_gbk2utf16[0x0195] = 0x5089;
	__map_gbk2utf16[0x0196] = 0x508a;
	__map_gbk2utf16[0x0197] = 0x508b;
	__map_gbk2utf16[0x0198] = 0x508c;
	__map_gbk2utf16[0x0199] = 0x508e;
	__map_gbk2utf16[0x019a] = 0x508f;
	__map_gbk2utf16[0x019b] = 0x5090;
	__map_gbk2utf16[0x019c] = 0x5091;
	__map_gbk2utf16[0x019d] = 0x5092;
	__map_gbk2utf16[0x019e] = 0x5093;
	__map_gbk2utf16[0x019f] = 0x5094;
	__map_gbk2utf16[0x01a0] = 0x5095;
	__map_gbk2utf16[0x01a1] = 0x5096;
	__map_gbk2utf16[0x01a2] = 0x5097;
	__map_gbk2utf16[0x01a3] = 0x5098;
	__map_gbk2utf16[0x01a4] = 0x5099;
	__map_gbk2utf16[0x01a5] = 0x509a;
	__map_gbk2utf16[0x01a6] = 0x509b;
	__map_gbk2utf16[0x01a7] = 0x509c;
	__map_gbk2utf16[0x01a8] = 0x509d;
	__map_gbk2utf16[0x01a9] = 0x509e;
	__map_gbk2utf16[0x01aa] = 0x509f;
	__map_gbk2utf16[0x01ab] = 0x50a0;
	__map_gbk2utf16[0x01ac] = 0x50a1;
	__map_gbk2utf16[0x01ad] = 0x50a2;
	__map_gbk2utf16[0x01ae] = 0x50a4;
	__map_gbk2utf16[0x01af] = 0x50a6;
	__map_gbk2utf16[0x01b0] = 0x50aa;
	__map_gbk2utf16[0x01b1] = 0x50ab;
	__map_gbk2utf16[0x01b2] = 0x50ad;
	__map_gbk2utf16[0x01b3] = 0x50ae;
	__map_gbk2utf16[0x01b4] = 0x50af;
	__map_gbk2utf16[0x01b5] = 0x50b0;
	__map_gbk2utf16[0x01b6] = 0x50b1;
	__map_gbk2utf16[0x01b7] = 0x50b3;
	__map_gbk2utf16[0x01b8] = 0x50b4;
	__map_gbk2utf16[0x01b9] = 0x50b5;
	__map_gbk2utf16[0x01ba] = 0x50b6;
	__map_gbk2utf16[0x01bb] = 0x50b7;
	__map_gbk2utf16[0x01bc] = 0x50b8;
	__map_gbk2utf16[0x01bd] = 0x50b9;
	__map_gbk2utf16[0x01be] = 0x50bc;
	__map_gbk2utf16[0x0200] = 0x50bd;
	__map_gbk2utf16[0x0201] = 0x50be;
	__map_gbk2utf16[0x0202] = 0x50bf;
	__map_gbk2utf16[0x0203] = 0x50c0;
	__map_gbk2utf16[0x0204] = 0x50c1;
	__map_gbk2utf16[0x0205] = 0x50c2;
	__map_gbk2utf16[0x0206] = 0x50c3;
	__map_gbk2utf16[0x0207] = 0x50c4;
	__map_gbk2utf16[0x0208] = 0x50c5;
	__map_gbk2utf16[0x0209] = 0x50c6;
	__map_gbk2utf16[0x020a] = 0x50c7;
	__map_gbk2utf16[0x020b] = 0x50c8;
	__map_gbk2utf16[0x020c] = 0x50c9;
	__map_gbk2utf16[0x020d] = 0x50ca;
	__map_gbk2utf16[0x020e] = 0x50cb;
	__map_gbk2utf16[0x020f] = 0x50cc;
	__map_gbk2utf16[0x0210] = 0x50cd;
	__map_gbk2utf16[0x0211] = 0x50ce;
	__map_gbk2utf16[0x0212] = 0x50d0;
	__map_gbk2utf16[0x0213] = 0x50d1;
	__map_gbk2utf16[0x0214] = 0x50d2;
	__map_gbk2utf16[0x0215] = 0x50d3;
	__map_gbk2utf16[0x0216] = 0x50d4;
	__map_gbk2utf16[0x0217] = 0x50d5;
	__map_gbk2utf16[0x0218] = 0x50d7;
	__map_gbk2utf16[0x0219] = 0x50d8;
	__map_gbk2utf16[0x021a] = 0x50d9;
	__map_gbk2utf16[0x021b] = 0x50db;
	__map_gbk2utf16[0x021c] = 0x50dc;
	__map_gbk2utf16[0x021d] = 0x50dd;
	__map_gbk2utf16[0x021e] = 0x50de;
	__map_gbk2utf16[0x021f] = 0x50df;
	__map_gbk2utf16[0x0220] = 0x50e0;
	__map_gbk2utf16[0x0221] = 0x50e1;
	__map_gbk2utf16[0x0222] = 0x50e2;
	__map_gbk2utf16[0x0223] = 0x50e3;
	__map_gbk2utf16[0x0224] = 0x50e4;
	__map_gbk2utf16[0x0225] = 0x50e5;
	__map_gbk2utf16[0x0226] = 0x50e8;
	__map_gbk2utf16[0x0227] = 0x50e9;
	__map_gbk2utf16[0x0228] = 0x50ea;
	__map_gbk2utf16[0x0229] = 0x50eb;
	__map_gbk2utf16[0x022a] = 0x50ef;
	__map_gbk2utf16[0x022b] = 0x50f0;
	__map_gbk2utf16[0x022c] = 0x50f1;
	__map_gbk2utf16[0x022d] = 0x50f2;
	__map_gbk2utf16[0x022e] = 0x50f4;
	__map_gbk2utf16[0x022f] = 0x50f6;
	__map_gbk2utf16[0x0230] = 0x50f7;
	__map_gbk2utf16[0x0231] = 0x50f8;
	__map_gbk2utf16[0x0232] = 0x50f9;
	__map_gbk2utf16[0x0233] = 0x50fa;
	__map_gbk2utf16[0x0234] = 0x50fc;
	__map_gbk2utf16[0x0235] = 0x50fd;
	__map_gbk2utf16[0x0236] = 0x50fe;
	__map_gbk2utf16[0x0237] = 0x50ff;
	__map_gbk2utf16[0x0238] = 0x5100;
	__map_gbk2utf16[0x0239] = 0x5101;
	__map_gbk2utf16[0x023a] = 0x5102;
	__map_gbk2utf16[0x023b] = 0x5103;
	__map_gbk2utf16[0x023c] = 0x5104;
	__map_gbk2utf16[0x023d] = 0x5105;
	__map_gbk2utf16[0x023e] = 0x5108;
	__map_gbk2utf16[0x0240] = 0x5109;
	__map_gbk2utf16[0x0241] = 0x510a;
	__map_gbk2utf16[0x0242] = 0x510c;
	__map_gbk2utf16[0x0243] = 0x510d;
	__map_gbk2utf16[0x0244] = 0x510e;
	__map_gbk2utf16[0x0245] = 0x510f;
	__map_gbk2utf16[0x0246] = 0x5110;
	__map_gbk2utf16[0x0247] = 0x5111;
	__map_gbk2utf16[0x0248] = 0x5113;
	__map_gbk2utf16[0x0249] = 0x5114;
	__map_gbk2utf16[0x024a] = 0x5115;
	__map_gbk2utf16[0x024b] = 0x5116;
	__map_gbk2utf16[0x024c] = 0x5117;
	__map_gbk2utf16[0x024d] = 0x5118;
	__map_gbk2utf16[0x024e] = 0x5119;
	__map_gbk2utf16[0x024f] = 0x511a;
	__map_gbk2utf16[0x0250] = 0x511b;
	__map_gbk2utf16[0x0251] = 0x511c;
	__map_gbk2utf16[0x0252] = 0x511d;
	__map_gbk2utf16[0x0253] = 0x511e;
	__map_gbk2utf16[0x0254] = 0x511f;
	__map_gbk2utf16[0x0255] = 0x5120;
	__map_gbk2utf16[0x0256] = 0x5122;
	__map_gbk2utf16[0x0257] = 0x5123;
	__map_gbk2utf16[0x0258] = 0x5124;
	__map_gbk2utf16[0x0259] = 0x5125;
	__map_gbk2utf16[0x025a] = 0x5126;
	__map_gbk2utf16[0x025b] = 0x5127;
	__map_gbk2utf16[0x025c] = 0x5128;
	__map_gbk2utf16[0x025d] = 0x5129;
	__map_gbk2utf16[0x025e] = 0x512a;
	__map_gbk2utf16[0x025f] = 0x512b;
	__map_gbk2utf16[0x0260] = 0x512c;
	__map_gbk2utf16[0x0261] = 0x512d;
	__map_gbk2utf16[0x0262] = 0x512e;
	__map_gbk2utf16[0x0263] = 0x512f;
	__map_gbk2utf16[0x0264] = 0x5130;
	__map_gbk2utf16[0x0265] = 0x5131;
	__map_gbk2utf16[0x0266] = 0x5132;
	__map_gbk2utf16[0x0267] = 0x5133;
	__map_gbk2utf16[0x0268] = 0x5134;
	__map_gbk2utf16[0x0269] = 0x5135;
	__map_gbk2utf16[0x026a] = 0x5136;
	__map_gbk2utf16[0x026b] = 0x5137;
	__map_gbk2utf16[0x026c] = 0x5138;
	__map_gbk2utf16[0x026d] = 0x5139;
	__map_gbk2utf16[0x026e] = 0x513a;
	__map_gbk2utf16[0x026f] = 0x513b;
	__map_gbk2utf16[0x0270] = 0x513c;
	__map_gbk2utf16[0x0271] = 0x513d;
	__map_gbk2utf16[0x0272] = 0x513e;
	__map_gbk2utf16[0x0273] = 0x5142;
	__map_gbk2utf16[0x0274] = 0x5147;
	__map_gbk2utf16[0x0275] = 0x514a;
	__map_gbk2utf16[0x0276] = 0x514c;
	__map_gbk2utf16[0x0277] = 0x514e;
	__map_gbk2utf16[0x0278] = 0x514f;
	__map_gbk2utf16[0x0279] = 0x5150;
	__map_gbk2utf16[0x027a] = 0x5152;
	__map_gbk2utf16[0x027b] = 0x5153;
	__map_gbk2utf16[0x027c] = 0x5157;
	__map_gbk2utf16[0x027d] = 0x5158;
	__map_gbk2utf16[0x027e] = 0x5159;
	__map_gbk2utf16[0x027f] = 0x515b;
	__map_gbk2utf16[0x0280] = 0x515d;
	__map_gbk2utf16[0x0281] = 0x515e;
	__map_gbk2utf16[0x0282] = 0x515f;
	__map_gbk2utf16[0x0283] = 0x5160;
	__map_gbk2utf16[0x0284] = 0x5161;
	__map_gbk2utf16[0x0285] = 0x5163;
	__map_gbk2utf16[0x0286] = 0x5164;
	__map_gbk2utf16[0x0287] = 0x5166;
	__map_gbk2utf16[0x0288] = 0x5167;
	__map_gbk2utf16[0x0289] = 0x5169;
	__map_gbk2utf16[0x028a] = 0x516a;
	__map_gbk2utf16[0x028b] = 0x516f;
	__map_gbk2utf16[0x028c] = 0x5172;
	__map_gbk2utf16[0x028d] = 0x517a;
	__map_gbk2utf16[0x028e] = 0x517e;
	__map_gbk2utf16[0x028f] = 0x517f;
	__map_gbk2utf16[0x0290] = 0x5183;
	__map_gbk2utf16[0x0291] = 0x5184;
	__map_gbk2utf16[0x0292] = 0x5186;
	__map_gbk2utf16[0x0293] = 0x5187;
	__map_gbk2utf16[0x0294] = 0x518a;
	__map_gbk2utf16[0x0295] = 0x518b;
	__map_gbk2utf16[0x0296] = 0x518e;
	__map_gbk2utf16[0x0297] = 0x518f;
	__map_gbk2utf16[0x0298] = 0x5190;
	__map_gbk2utf16[0x0299] = 0x5191;
	__map_gbk2utf16[0x029a] = 0x5193;
	__map_gbk2utf16[0x029b] = 0x5194;
	__map_gbk2utf16[0x029c] = 0x5198;
	__map_gbk2utf16[0x029d] = 0x519a;
	__map_gbk2utf16[0x029e] = 0x519d;
	__map_gbk2utf16[0x029f] = 0x519e;
	__map_gbk2utf16[0x02a0] = 0x519f;
	__map_gbk2utf16[0x02a1] = 0x51a1;
	__map_gbk2utf16[0x02a2] = 0x51a3;
	__map_gbk2utf16[0x02a3] = 0x51a6;
	__map_gbk2utf16[0x02a4] = 0x51a7;
	__map_gbk2utf16[0x02a5] = 0x51a8;
	__map_gbk2utf16[0x02a6] = 0x51a9;
	__map_gbk2utf16[0x02a7] = 0x51aa;
	__map_gbk2utf16[0x02a8] = 0x51ad;
	__map_gbk2utf16[0x02a9] = 0x51ae;
	__map_gbk2utf16[0x02aa] = 0x51b4;
	__map_gbk2utf16[0x02ab] = 0x51b8;
	__map_gbk2utf16[0x02ac] = 0x51b9;
	__map_gbk2utf16[0x02ad] = 0x51ba;
	__map_gbk2utf16[0x02ae] = 0x51be;
	__map_gbk2utf16[0x02af] = 0x51bf;
	__map_gbk2utf16[0x02b0] = 0x51c1;
	__map_gbk2utf16[0x02b1] = 0x51c2;
	__map_gbk2utf16[0x02b2] = 0x51c3;
	__map_gbk2utf16[0x02b3] = 0x51c5;
	__map_gbk2utf16[0x02b4] = 0x51c8;
	__map_gbk2utf16[0x02b5] = 0x51ca;
	__map_gbk2utf16[0x02b6] = 0x51cd;
	__map_gbk2utf16[0x02b7] = 0x51ce;
	__map_gbk2utf16[0x02b8] = 0x51d0;
	__map_gbk2utf16[0x02b9] = 0x51d2;
	__map_gbk2utf16[0x02ba] = 0x51d3;
	__map_gbk2utf16[0x02bb] = 0x51d4;
	__map_gbk2utf16[0x02bc] = 0x51d5;
	__map_gbk2utf16[0x02bd] = 0x51d6;
	__map_gbk2utf16[0x02be] = 0x51d7;
	__map_gbk2utf16[0x0300] = 0x51d8;
	__map_gbk2utf16[0x0301] = 0x51d9;
	__map_gbk2utf16[0x0302] = 0x51da;
	__map_gbk2utf16[0x0303] = 0x51dc;
	__map_gbk2utf16[0x0304] = 0x51de;
	__map_gbk2utf16[0x0305] = 0x51df;
	__map_gbk2utf16[0x0306] = 0x51e2;
	__map_gbk2utf16[0x0307] = 0x51e3;
	__map_gbk2utf16[0x0308] = 0x51e5;
	__map_gbk2utf16[0x0309] = 0x51e6;
	__map_gbk2utf16[0x030a] = 0x51e7;
	__map_gbk2utf16[0x030b] = 0x51e8;
	__map_gbk2utf16[0x030c] = 0x51e9;
	__map_gbk2utf16[0x030d] = 0x51ea;
	__map_gbk2utf16[0x030e] = 0x51ec;
	__map_gbk2utf16[0x030f] = 0x51ee;
	__map_gbk2utf16[0x0310] = 0x51f1;
	__map_gbk2utf16[0x0311] = 0x51f2;
	__map_gbk2utf16[0x0312] = 0x51f4;
	__map_gbk2utf16[0x0313] = 0x51f7;
	__map_gbk2utf16[0x0314] = 0x51fe;
	__map_gbk2utf16[0x0315] = 0x5204;
	__map_gbk2utf16[0x0316] = 0x5205;
	__map_gbk2utf16[0x0317] = 0x5209;
	__map_gbk2utf16[0x0318] = 0x520b;
	__map_gbk2utf16[0x0319] = 0x520c;
	__map_gbk2utf16[0x031a] = 0x520f;
	__map_gbk2utf16[0x031b] = 0x5210;
	__map_gbk2utf16[0x031c] = 0x5213;
	__map_gbk2utf16[0x031d] = 0x5214;
	__map_gbk2utf16[0x031e] = 0x5215;
	__map_gbk2utf16[0x031f] = 0x521c;
	__map_gbk2utf16[0x0320] = 0x521e;
	__map_gbk2utf16[0x0321] = 0x521f;
	__map_gbk2utf16[0x0322] = 0x5221;
	__map_gbk2utf16[0x0323] = 0x5222;
	__map_gbk2utf16[0x0324] = 0x5223;
	__map_gbk2utf16[0x0325] = 0x5225;
	__map_gbk2utf16[0x0326] = 0x5226;
	__map_gbk2utf16[0x0327] = 0x5227;
	__map_gbk2utf16[0x0328] = 0x522a;
	__map_gbk2utf16[0x0329] = 0x522c;
	__map_gbk2utf16[0x032a] = 0x522f;
	__map_gbk2utf16[0x032b] = 0x5231;
	__map_gbk2utf16[0x032c] = 0x5232;
	__map_gbk2utf16[0x032d] = 0x5234;
	__map_gbk2utf16[0x032e] = 0x5235;
	__map_gbk2utf16[0x032f] = 0x523c;
	__map_gbk2utf16[0x0330] = 0x523e;
	__map_gbk2utf16[0x0331] = 0x5244;
	__map_gbk2utf16[0x0332] = 0x5245;
	__map_gbk2utf16[0x0333] = 0x5246;
	__map_gbk2utf16[0x0334] = 0x5247;
	__map_gbk2utf16[0x0335] = 0x5248;
	__map_gbk2utf16[0x0336] = 0x5249;
	__map_gbk2utf16[0x0337] = 0x524b;
	__map_gbk2utf16[0x0338] = 0x524e;
	__map_gbk2utf16[0x0339] = 0x524f;
	__map_gbk2utf16[0x033a] = 0x5252;
	__map_gbk2utf16[0x033b] = 0x5253;
	__map_gbk2utf16[0x033c] = 0x5255;
	__map_gbk2utf16[0x033d] = 0x5257;
	__map_gbk2utf16[0x033e] = 0x5258;
	__map_gbk2utf16[0x0340] = 0x5259;
	__map_gbk2utf16[0x0341] = 0x525a;
	__map_gbk2utf16[0x0342] = 0x525b;
	__map_gbk2utf16[0x0343] = 0x525d;
	__map_gbk2utf16[0x0344] = 0x525f;
	__map_gbk2utf16[0x0345] = 0x5260;
	__map_gbk2utf16[0x0346] = 0x5262;
	__map_gbk2utf16[0x0347] = 0x5263;
	__map_gbk2utf16[0x0348] = 0x5264;
	__map_gbk2utf16[0x0349] = 0x5266;
	__map_gbk2utf16[0x034a] = 0x5268;
	__map_gbk2utf16[0x034b] = 0x526b;
	__map_gbk2utf16[0x034c] = 0x526c;
	__map_gbk2utf16[0x034d] = 0x526d;
	__map_gbk2utf16[0x034e] = 0x526e;
	__map_gbk2utf16[0x034f] = 0x5270;
	__map_gbk2utf16[0x0350] = 0x5271;
	__map_gbk2utf16[0x0351] = 0x5273;
	__map_gbk2utf16[0x0352] = 0x5274;
	__map_gbk2utf16[0x0353] = 0x5275;
	__map_gbk2utf16[0x0354] = 0x5276;
	__map_gbk2utf16[0x0355] = 0x5277;
	__map_gbk2utf16[0x0356] = 0x5278;
	__map_gbk2utf16[0x0357] = 0x5279;
	__map_gbk2utf16[0x0358] = 0x527a;
	__map_gbk2utf16[0x0359] = 0x527b;
	__map_gbk2utf16[0x035a] = 0x527c;
	__map_gbk2utf16[0x035b] = 0x527e;
	__map_gbk2utf16[0x035c] = 0x5280;
	__map_gbk2utf16[0x035d] = 0x5283;
	__map_gbk2utf16[0x035e] = 0x5284;
	__map_gbk2utf16[0x035f] = 0x5285;
	__map_gbk2utf16[0x0360] = 0x5286;
	__map_gbk2utf16[0x0361] = 0x5287;
	__map_gbk2utf16[0x0362] = 0x5289;
	__map_gbk2utf16[0x0363] = 0x528a;
	__map_gbk2utf16[0x0364] = 0x528b;
	__map_gbk2utf16[0x0365] = 0x528c;
	__map_gbk2utf16[0x0366] = 0x528d;
	__map_gbk2utf16[0x0367] = 0x528e;
	__map_gbk2utf16[0x0368] = 0x528f;
	__map_gbk2utf16[0x0369] = 0x5291;
	__map_gbk2utf16[0x036a] = 0x5292;
	__map_gbk2utf16[0x036b] = 0x5294;
	__map_gbk2utf16[0x036c] = 0x5295;
	__map_gbk2utf16[0x036d] = 0x5296;
	__map_gbk2utf16[0x036e] = 0x5297;
	__map_gbk2utf16[0x036f] = 0x5298;
	__map_gbk2utf16[0x0370] = 0x5299;
	__map_gbk2utf16[0x0371] = 0x529a;
	__map_gbk2utf16[0x0372] = 0x529c;
	__map_gbk2utf16[0x0373] = 0x52a4;
	__map_gbk2utf16[0x0374] = 0x52a5;
	__map_gbk2utf16[0x0375] = 0x52a6;
	__map_gbk2utf16[0x0376] = 0x52a7;
	__map_gbk2utf16[0x0377] = 0x52ae;
	__map_gbk2utf16[0x0378] = 0x52af;
	__map_gbk2utf16[0x0379] = 0x52b0;
	__map_gbk2utf16[0x037a] = 0x52b4;
	__map_gbk2utf16[0x037b] = 0x52b5;
	__map_gbk2utf16[0x037c] = 0x52b6;
	__map_gbk2utf16[0x037d] = 0x52b7;
	__map_gbk2utf16[0x037e] = 0x52b8;
	__map_gbk2utf16[0x037f] = 0x52b9;
	__map_gbk2utf16[0x0380] = 0x52ba;
	__map_gbk2utf16[0x0381] = 0x52bb;
	__map_gbk2utf16[0x0382] = 0x52bc;
	__map_gbk2utf16[0x0383] = 0x52bd;
	__map_gbk2utf16[0x0384] = 0x52c0;
	__map_gbk2utf16[0x0385] = 0x52c1;
	__map_gbk2utf16[0x0386] = 0x52c2;
	__map_gbk2utf16[0x0387] = 0x52c4;
	__map_gbk2utf16[0x0388] = 0x52c5;
	__map_gbk2utf16[0x0389] = 0x52c6;
	__map_gbk2utf16[0x038a] = 0x52c8;
	__map_gbk2utf16[0x038b] = 0x52ca;
	__map_gbk2utf16[0x038c] = 0x52cc;
	__map_gbk2utf16[0x038d] = 0x52cd;
	__map_gbk2utf16[0x038e] = 0x52ce;
	__map_gbk2utf16[0x038f] = 0x52cf;
	__map_gbk2utf16[0x0390] = 0x52d1;
	__map_gbk2utf16[0x0391] = 0x52d3;
	__map_gbk2utf16[0x0392] = 0x52d4;
	__map_gbk2utf16[0x0393] = 0x52d5;
	__map_gbk2utf16[0x0394] = 0x52d7;
	__map_gbk2utf16[0x0395] = 0x52d9;
	__map_gbk2utf16[0x0396] = 0x52da;
	__map_gbk2utf16[0x0397] = 0x52db;
	__map_gbk2utf16[0x0398] = 0x52dc;
	__map_gbk2utf16[0x0399] = 0x52dd;
	__map_gbk2utf16[0x039a] = 0x52de;
	__map_gbk2utf16[0x039b] = 0x52e0;
	__map_gbk2utf16[0x039c] = 0x52e1;
	__map_gbk2utf16[0x039d] = 0x52e2;
	__map_gbk2utf16[0x039e] = 0x52e3;
	__map_gbk2utf16[0x039f] = 0x52e5;
	__map_gbk2utf16[0x03a0] = 0x52e6;
	__map_gbk2utf16[0x03a1] = 0x52e7;
	__map_gbk2utf16[0x03a2] = 0x52e8;
	__map_gbk2utf16[0x03a3] = 0x52e9;
	__map_gbk2utf16[0x03a4] = 0x52ea;
	__map_gbk2utf16[0x03a5] = 0x52eb;
	__map_gbk2utf16[0x03a6] = 0x52ec;
	__map_gbk2utf16[0x03a7] = 0x52ed;
	__map_gbk2utf16[0x03a8] = 0x52ee;
	__map_gbk2utf16[0x03a9] = 0x52ef;
	__map_gbk2utf16[0x03aa] = 0x52f1;
	__map_gbk2utf16[0x03ab] = 0x52f2;
	__map_gbk2utf16[0x03ac] = 0x52f3;
	__map_gbk2utf16[0x03ad] = 0x52f4;
	__map_gbk2utf16[0x03ae] = 0x52f5;
	__map_gbk2utf16[0x03af] = 0x52f6;
	__map_gbk2utf16[0x03b0] = 0x52f7;
	__map_gbk2utf16[0x03b1] = 0x52f8;
	__map_gbk2utf16[0x03b2] = 0x52fb;
	__map_gbk2utf16[0x03b3] = 0x52fc;
	__map_gbk2utf16[0x03b4] = 0x52fd;
	__map_gbk2utf16[0x03b5] = 0x5301;
	__map_gbk2utf16[0x03b6] = 0x5302;
	__map_gbk2utf16[0x03b7] = 0x5303;
	__map_gbk2utf16[0x03b8] = 0x5304;
	__map_gbk2utf16[0x03b9] = 0x5307;
	__map_gbk2utf16[0x03ba] = 0x5309;
	__map_gbk2utf16[0x03bb] = 0x530a;
	__map_gbk2utf16[0x03bc] = 0x530b;
	__map_gbk2utf16[0x03bd] = 0x530c;
	__map_gbk2utf16[0x03be] = 0x530e;
	__map_gbk2utf16[0x0400] = 0x5311;
	__map_gbk2utf16[0x0401] = 0x5312;
	__map_gbk2utf16[0x0402] = 0x5313;
	__map_gbk2utf16[0x0403] = 0x5314;
	__map_gbk2utf16[0x0404] = 0x5318;
	__map_gbk2utf16[0x0405] = 0x531b;
	__map_gbk2utf16[0x0406] = 0x531c;
	__map_gbk2utf16[0x0407] = 0x531e;
	__map_gbk2utf16[0x0408] = 0x531f;
	__map_gbk2utf16[0x0409] = 0x5322;
	__map_gbk2utf16[0x040a] = 0x5324;
	__map_gbk2utf16[0x040b] = 0x5325;
	__map_gbk2utf16[0x040c] = 0x5327;
	__map_gbk2utf16[0x040d] = 0x5328;
	__map_gbk2utf16[0x040e] = 0x5329;
	__map_gbk2utf16[0x040f] = 0x532b;
	__map_gbk2utf16[0x0410] = 0x532c;
	__map_gbk2utf16[0x0411] = 0x532d;
	__map_gbk2utf16[0x0412] = 0x532f;
	__map_gbk2utf16[0x0413] = 0x5330;
	__map_gbk2utf16[0x0414] = 0x5331;
	__map_gbk2utf16[0x0415] = 0x5332;
	__map_gbk2utf16[0x0416] = 0x5333;
	__map_gbk2utf16[0x0417] = 0x5334;
	__map_gbk2utf16[0x0418] = 0x5335;
	__map_gbk2utf16[0x0419] = 0x5336;
	__map_gbk2utf16[0x041a] = 0x5337;
	__map_gbk2utf16[0x041b] = 0x5338;
	__map_gbk2utf16[0x041c] = 0x533c;
	__map_gbk2utf16[0x041d] = 0x533d;
	__map_gbk2utf16[0x041e] = 0x5340;
	__map_gbk2utf16[0x041f] = 0x5342;
	__map_gbk2utf16[0x0420] = 0x5344;
	__map_gbk2utf16[0x0421] = 0x5346;
	__map_gbk2utf16[0x0422] = 0x534b;
	__map_gbk2utf16[0x0423] = 0x534c;
	__map_gbk2utf16[0x0424] = 0x534d;
	__map_gbk2utf16[0x0425] = 0x5350;
	__map_gbk2utf16[0x0426] = 0x5354;
	__map_gbk2utf16[0x0427] = 0x5358;
	__map_gbk2utf16[0x0428] = 0x5359;
	__map_gbk2utf16[0x0429] = 0x535b;
	__map_gbk2utf16[0x042a] = 0x535d;
	__map_gbk2utf16[0x042b] = 0x5365;
	__map_gbk2utf16[0x042c] = 0x5368;
	__map_gbk2utf16[0x042d] = 0x536a;
	__map_gbk2utf16[0x042e] = 0x536c;
	__map_gbk2utf16[0x042f] = 0x536d;
	__map_gbk2utf16[0x0430] = 0x5372;
	__map_gbk2utf16[0x0431] = 0x5376;
	__map_gbk2utf16[0x0432] = 0x5379;
	__map_gbk2utf16[0x0433] = 0x537b;
	__map_gbk2utf16[0x0434] = 0x537c;
	__map_gbk2utf16[0x0435] = 0x537d;
	__map_gbk2utf16[0x0436] = 0x537e;
	__map_gbk2utf16[0x0437] = 0x5380;
	__map_gbk2utf16[0x0438] = 0x5381;
	__map_gbk2utf16[0x0439] = 0x5383;
	__map_gbk2utf16[0x043a] = 0x5387;
	__map_gbk2utf16[0x043b] = 0x5388;
	__map_gbk2utf16[0x043c] = 0x538a;
	__map_gbk2utf16[0x043d] = 0x538e;
	__map_gbk2utf16[0x043e] = 0x538f;
	__map_gbk2utf16[0x0440] = 0x5390;
	__map_gbk2utf16[0x0441] = 0x5391;
	__map_gbk2utf16[0x0442] = 0x5392;
	__map_gbk2utf16[0x0443] = 0x5393;
	__map_gbk2utf16[0x0444] = 0x5394;
	__map_gbk2utf16[0x0445] = 0x5396;
	__map_gbk2utf16[0x0446] = 0x5397;
	__map_gbk2utf16[0x0447] = 0x5399;
	__map_gbk2utf16[0x0448] = 0x539b;
	__map_gbk2utf16[0x0449] = 0x539c;
	__map_gbk2utf16[0x044a] = 0x539e;
	__map_gbk2utf16[0x044b] = 0x53a0;
	__map_gbk2utf16[0x044c] = 0x53a1;
	__map_gbk2utf16[0x044d] = 0x53a4;
	__map_gbk2utf16[0x044e] = 0x53a7;
	__map_gbk2utf16[0x044f] = 0x53aa;
	__map_gbk2utf16[0x0450] = 0x53ab;
	__map_gbk2utf16[0x0451] = 0x53ac;
	__map_gbk2utf16[0x0452] = 0x53ad;
	__map_gbk2utf16[0x0453] = 0x53af;
	__map_gbk2utf16[0x0454] = 0x53b0;
	__map_gbk2utf16[0x0455] = 0x53b1;
	__map_gbk2utf16[0x0456] = 0x53b2;
	__map_gbk2utf16[0x0457] = 0x53b3;
	__map_gbk2utf16[0x0458] = 0x53b4;
	__map_gbk2utf16[0x0459] = 0x53b5;
	__map_gbk2utf16[0x045a] = 0x53b7;
	__map_gbk2utf16[0x045b] = 0x53b8;
	__map_gbk2utf16[0x045c] = 0x53b9;
	__map_gbk2utf16[0x045d] = 0x53ba;
	__map_gbk2utf16[0x045e] = 0x53bc;
	__map_gbk2utf16[0x045f] = 0x53bd;
	__map_gbk2utf16[0x0460] = 0x53be;
	__map_gbk2utf16[0x0461] = 0x53c0;
	__map_gbk2utf16[0x0462] = 0x53c3;
	__map_gbk2utf16[0x0463] = 0x53c4;
	__map_gbk2utf16[0x0464] = 0x53c5;
	__map_gbk2utf16[0x0465] = 0x53c6;
	__map_gbk2utf16[0x0466] = 0x53c7;
	__map_gbk2utf16[0x0467] = 0x53ce;
	__map_gbk2utf16[0x0468] = 0x53cf;
	__map_gbk2utf16[0x0469] = 0x53d0;
	__map_gbk2utf16[0x046a] = 0x53d2;
	__map_gbk2utf16[0x046b] = 0x53d3;
	__map_gbk2utf16[0x046c] = 0x53d5;
	__map_gbk2utf16[0x046d] = 0x53da;
	__map_gbk2utf16[0x046e] = 0x53dc;
	__map_gbk2utf16[0x046f] = 0x53dd;
	__map_gbk2utf16[0x0470] = 0x53de;
	__map_gbk2utf16[0x0471] = 0x53e1;
	__map_gbk2utf16[0x0472] = 0x53e2;
	__map_gbk2utf16[0x0473] = 0x53e7;
	__map_gbk2utf16[0x0474] = 0x53f4;
	__map_gbk2utf16[0x0475] = 0x53fa;
	__map_gbk2utf16[0x0476] = 0x53fe;
	__map_gbk2utf16[0x0477] = 0x53ff;
	__map_gbk2utf16[0x0478] = 0x5400;
	__map_gbk2utf16[0x0479] = 0x5402;
	__map_gbk2utf16[0x047a] = 0x5405;
	__map_gbk2utf16[0x047b] = 0x5407;
	__map_gbk2utf16[0x047c] = 0x540b;
	__map_gbk2utf16[0x047d] = 0x5414;
	__map_gbk2utf16[0x047e] = 0x5418;
	__map_gbk2utf16[0x047f] = 0x5419;
	__map_gbk2utf16[0x0480] = 0x541a;
	__map_gbk2utf16[0x0481] = 0x541c;
	__map_gbk2utf16[0x0482] = 0x5422;
	__map_gbk2utf16[0x0483] = 0x5424;
	__map_gbk2utf16[0x0484] = 0x5425;
	__map_gbk2utf16[0x0485] = 0x542a;
	__map_gbk2utf16[0x0486] = 0x5430;
	__map_gbk2utf16[0x0487] = 0x5433;
	__map_gbk2utf16[0x0488] = 0x5436;
	__map_gbk2utf16[0x0489] = 0x5437;
	__map_gbk2utf16[0x048a] = 0x543a;
	__map_gbk2utf16[0x048b] = 0x543d;
	__map_gbk2utf16[0x048c] = 0x543f;
	__map_gbk2utf16[0x048d] = 0x5441;
	__map_gbk2utf16[0x048e] = 0x5442;
	__map_gbk2utf16[0x048f] = 0x5444;
	__map_gbk2utf16[0x0490] = 0x5445;
	__map_gbk2utf16[0x0491] = 0x5447;
	__map_gbk2utf16[0x0492] = 0x5449;
	__map_gbk2utf16[0x0493] = 0x544c;
	__map_gbk2utf16[0x0494] = 0x544d;
	__map_gbk2utf16[0x0495] = 0x544e;
	__map_gbk2utf16[0x0496] = 0x544f;
	__map_gbk2utf16[0x0497] = 0x5451;
	__map_gbk2utf16[0x0498] = 0x545a;
	__map_gbk2utf16[0x0499] = 0x545d;
	__map_gbk2utf16[0x049a] = 0x545e;
	__map_gbk2utf16[0x049b] = 0x545f;
	__map_gbk2utf16[0x049c] = 0x5460;
	__map_gbk2utf16[0x049d] = 0x5461;
	__map_gbk2utf16[0x049e] = 0x5463;
	__map_gbk2utf16[0x049f] = 0x5465;
	__map_gbk2utf16[0x04a0] = 0x5467;
	__map_gbk2utf16[0x04a1] = 0x5469;
	__map_gbk2utf16[0x04a2] = 0x546a;
	__map_gbk2utf16[0x04a3] = 0x546b;
	__map_gbk2utf16[0x04a4] = 0x546c;
	__map_gbk2utf16[0x04a5] = 0x546d;
	__map_gbk2utf16[0x04a6] = 0x546e;
	__map_gbk2utf16[0x04a7] = 0x546f;
	__map_gbk2utf16[0x04a8] = 0x5470;
	__map_gbk2utf16[0x04a9] = 0x5474;
	__map_gbk2utf16[0x04aa] = 0x5479;
	__map_gbk2utf16[0x04ab] = 0x547a;
	__map_gbk2utf16[0x04ac] = 0x547e;
	__map_gbk2utf16[0x04ad] = 0x547f;
	__map_gbk2utf16[0x04ae] = 0x5481;
	__map_gbk2utf16[0x04af] = 0x5483;
	__map_gbk2utf16[0x04b0] = 0x5485;
	__map_gbk2utf16[0x04b1] = 0x5487;
	__map_gbk2utf16[0x04b2] = 0x5488;
	__map_gbk2utf16[0x04b3] = 0x5489;
	__map_gbk2utf16[0x04b4] = 0x548a;
	__map_gbk2utf16[0x04b5] = 0x548d;
	__map_gbk2utf16[0x04b6] = 0x5491;
	__map_gbk2utf16[0x04b7] = 0x5493;
	__map_gbk2utf16[0x04b8] = 0x5497;
	__map_gbk2utf16[0x04b9] = 0x5498;
	__map_gbk2utf16[0x04ba] = 0x549c;
	__map_gbk2utf16[0x04bb] = 0x549e;
	__map_gbk2utf16[0x04bc] = 0x549f;
	__map_gbk2utf16[0x04bd] = 0x54a0;
	__map_gbk2utf16[0x04be] = 0x54a1;
	__map_gbk2utf16[0x0500] = 0x54a2;
	__map_gbk2utf16[0x0501] = 0x54a5;
	__map_gbk2utf16[0x0502] = 0x54ae;
	__map_gbk2utf16[0x0503] = 0x54b0;
	__map_gbk2utf16[0x0504] = 0x54b2;
	__map_gbk2utf16[0x0505] = 0x54b5;
	__map_gbk2utf16[0x0506] = 0x54b6;
	__map_gbk2utf16[0x0507] = 0x54b7;
	__map_gbk2utf16[0x0508] = 0x54b9;
	__map_gbk2utf16[0x0509] = 0x54ba;
	__map_gbk2utf16[0x050a] = 0x54bc;
	__map_gbk2utf16[0x050b] = 0x54be;
	__map_gbk2utf16[0x050c] = 0x54c3;
	__map_gbk2utf16[0x050d] = 0x54c5;
	__map_gbk2utf16[0x050e] = 0x54ca;
	__map_gbk2utf16[0x050f] = 0x54cb;
	__map_gbk2utf16[0x0510] = 0x54d6;
	__map_gbk2utf16[0x0511] = 0x54d8;
	__map_gbk2utf16[0x0512] = 0x54db;
	__map_gbk2utf16[0x0513] = 0x54e0;
	__map_gbk2utf16[0x0514] = 0x54e1;
	__map_gbk2utf16[0x0515] = 0x54e2;
	__map_gbk2utf16[0x0516] = 0x54e3;
	__map_gbk2utf16[0x0517] = 0x54e4;
	__map_gbk2utf16[0x0518] = 0x54eb;
	__map_gbk2utf16[0x0519] = 0x54ec;
	__map_gbk2utf16[0x051a] = 0x54ef;
	__map_gbk2utf16[0x051b] = 0x54f0;
	__map_gbk2utf16[0x051c] = 0x54f1;
	__map_gbk2utf16[0x051d] = 0x54f4;
	__map_gbk2utf16[0x051e] = 0x54f5;
	__map_gbk2utf16[0x051f] = 0x54f6;
	__map_gbk2utf16[0x0520] = 0x54f7;
	__map_gbk2utf16[0x0521] = 0x54f8;
	__map_gbk2utf16[0x0522] = 0x54f9;
	__map_gbk2utf16[0x0523] = 0x54fb;
	__map_gbk2utf16[0x0524] = 0x54fe;
	__map_gbk2utf16[0x0525] = 0x5500;
	__map_gbk2utf16[0x0526] = 0x5502;
	__map_gbk2utf16[0x0527] = 0x5503;
	__map_gbk2utf16[0x0528] = 0x5504;
	__map_gbk2utf16[0x0529] = 0x5505;
	__map_gbk2utf16[0x052a] = 0x5508;
	__map_gbk2utf16[0x052b] = 0x550a;
	__map_gbk2utf16[0x052c] = 0x550b;
	__map_gbk2utf16[0x052d] = 0x550c;
	__map_gbk2utf16[0x052e] = 0x550d;
	__map_gbk2utf16[0x052f] = 0x550e;
	__map_gbk2utf16[0x0530] = 0x5512;
	__map_gbk2utf16[0x0531] = 0x5513;
	__map_gbk2utf16[0x0532] = 0x5515;
	__map_gbk2utf16[0x0533] = 0x5516;
	__map_gbk2utf16[0x0534] = 0x5517;
	__map_gbk2utf16[0x0535] = 0x5518;
	__map_gbk2utf16[0x0536] = 0x5519;
	__map_gbk2utf16[0x0537] = 0x551a;
	__map_gbk2utf16[0x0538] = 0x551c;
	__map_gbk2utf16[0x0539] = 0x551d;
	__map_gbk2utf16[0x053a] = 0x551e;
	__map_gbk2utf16[0x053b] = 0x551f;
	__map_gbk2utf16[0x053c] = 0x5521;
	__map_gbk2utf16[0x053d] = 0x5525;
	__map_gbk2utf16[0x053e] = 0x5526;
	__map_gbk2utf16[0x0540] = 0x5528;
	__map_gbk2utf16[0x0541] = 0x5529;
	__map_gbk2utf16[0x0542] = 0x552b;
	__map_gbk2utf16[0x0543] = 0x552d;
	__map_gbk2utf16[0x0544] = 0x5532;
	__map_gbk2utf16[0x0545] = 0x5534;
	__map_gbk2utf16[0x0546] = 0x5535;
	__map_gbk2utf16[0x0547] = 0x5536;
	__map_gbk2utf16[0x0548] = 0x5538;
	__map_gbk2utf16[0x0549] = 0x5539;
	__map_gbk2utf16[0x054a] = 0x553a;
	__map_gbk2utf16[0x054b] = 0x553b;
	__map_gbk2utf16[0x054c] = 0x553d;
	__map_gbk2utf16[0x054d] = 0x5540;
	__map_gbk2utf16[0x054e] = 0x5542;
	__map_gbk2utf16[0x054f] = 0x5545;
	__map_gbk2utf16[0x0550] = 0x5547;
	__map_gbk2utf16[0x0551] = 0x5548;
	__map_gbk2utf16[0x0552] = 0x554b;
	__map_gbk2utf16[0x0553] = 0x554c;
	__map_gbk2utf16[0x0554] = 0x554d;
	__map_gbk2utf16[0x0555] = 0x554e;
	__map_gbk2utf16[0x0556] = 0x554f;
	__map_gbk2utf16[0x0557] = 0x5551;
	__map_gbk2utf16[0x0558] = 0x5552;
	__map_gbk2utf16[0x0559] = 0x5553;
	__map_gbk2utf16[0x055a] = 0x5554;
	__map_gbk2utf16[0x055b] = 0x5557;
	__map_gbk2utf16[0x055c] = 0x5558;
	__map_gbk2utf16[0x055d] = 0x5559;
	__map_gbk2utf16[0x055e] = 0x555a;
	__map_gbk2utf16[0x055f] = 0x555b;
	__map_gbk2utf16[0x0560] = 0x555d;
	__map_gbk2utf16[0x0561] = 0x555e;
	__map_gbk2utf16[0x0562] = 0x555f;
	__map_gbk2utf16[0x0563] = 0x5560;
	__map_gbk2utf16[0x0564] = 0x5562;
	__map_gbk2utf16[0x0565] = 0x5563;
	__map_gbk2utf16[0x0566] = 0x5568;
	__map_gbk2utf16[0x0567] = 0x5569;
	__map_gbk2utf16[0x0568] = 0x556b;
	__map_gbk2utf16[0x0569] = 0x556f;
	__map_gbk2utf16[0x056a] = 0x5570;
	__map_gbk2utf16[0x056b] = 0x5571;
	__map_gbk2utf16[0x056c] = 0x5572;
	__map_gbk2utf16[0x056d] = 0x5573;
	__map_gbk2utf16[0x056e] = 0x5574;
	__map_gbk2utf16[0x056f] = 0x5579;
	__map_gbk2utf16[0x0570] = 0x557a;
	__map_gbk2utf16[0x0571] = 0x557d;
	__map_gbk2utf16[0x0572] = 0x557f;
	__map_gbk2utf16[0x0573] = 0x5585;
	__map_gbk2utf16[0x0574] = 0x5586;
	__map_gbk2utf16[0x0575] = 0x558c;
	__map_gbk2utf16[0x0576] = 0x558d;
	__map_gbk2utf16[0x0577] = 0x558e;
	__map_gbk2utf16[0x0578] = 0x5590;
	__map_gbk2utf16[0x0579] = 0x5592;
	__map_gbk2utf16[0x057a] = 0x5593;
	__map_gbk2utf16[0x057b] = 0x5595;
	__map_gbk2utf16[0x057c] = 0x5596;
	__map_gbk2utf16[0x057d] = 0x5597;
	__map_gbk2utf16[0x057e] = 0x559a;
	__map_gbk2utf16[0x057f] = 0x559b;
	__map_gbk2utf16[0x0580] = 0x559e;
	__map_gbk2utf16[0x0581] = 0x55a0;
	__map_gbk2utf16[0x0582] = 0x55a1;
	__map_gbk2utf16[0x0583] = 0x55a2;
	__map_gbk2utf16[0x0584] = 0x55a3;
	__map_gbk2utf16[0x0585] = 0x55a4;
	__map_gbk2utf16[0x0586] = 0x55a5;
	__map_gbk2utf16[0x0587] = 0x55a6;
	__map_gbk2utf16[0x0588] = 0x55a8;
	__map_gbk2utf16[0x0589] = 0x55a9;
	__map_gbk2utf16[0x058a] = 0x55aa;
	__map_gbk2utf16[0x058b] = 0x55ab;
	__map_gbk2utf16[0x058c] = 0x55ac;
	__map_gbk2utf16[0x058d] = 0x55ad;
	__map_gbk2utf16[0x058e] = 0x55ae;
	__map_gbk2utf16[0x058f] = 0x55af;
	__map_gbk2utf16[0x0590] = 0x55b0;
	__map_gbk2utf16[0x0591] = 0x55b2;
	__map_gbk2utf16[0x0592] = 0x55b4;
	__map_gbk2utf16[0x0593] = 0x55b6;
	__map_gbk2utf16[0x0594] = 0x55b8;
	__map_gbk2utf16[0x0595] = 0x55ba;
	__map_gbk2utf16[0x0596] = 0x55bc;
	__map_gbk2utf16[0x0597] = 0x55bf;
	__map_gbk2utf16[0x0598] = 0x55c0;
	__map_gbk2utf16[0x0599] = 0x55c1;
	__map_gbk2utf16[0x059a] = 0x55c2;
	__map_gbk2utf16[0x059b] = 0x55c3;
	__map_gbk2utf16[0x059c] = 0x55c6;
	__map_gbk2utf16[0x059d] = 0x55c7;
	__map_gbk2utf16[0x059e] = 0x55c8;
	__map_gbk2utf16[0x059f] = 0x55ca;
	__map_gbk2utf16[0x05a0] = 0x55cb;
	__map_gbk2utf16[0x05a1] = 0x55ce;
	__map_gbk2utf16[0x05a2] = 0x55cf;
	__map_gbk2utf16[0x05a3] = 0x55d0;
	__map_gbk2utf16[0x05a4] = 0x55d5;
	__map_gbk2utf16[0x05a5] = 0x55d7;
	__map_gbk2utf16[0x05a6] = 0x55d8;
	__map_gbk2utf16[0x05a7] = 0x55d9;
	__map_gbk2utf16[0x05a8] = 0x55da;
	__map_gbk2utf16[0x05a9] = 0x55db;
	__map_gbk2utf16[0x05aa] = 0x55de;
	__map_gbk2utf16[0x05ab] = 0x55e0;
	__map_gbk2utf16[0x05ac] = 0x55e2;
	__map_gbk2utf16[0x05ad] = 0x55e7;
	__map_gbk2utf16[0x05ae] = 0x55e9;
	__map_gbk2utf16[0x05af] = 0x55ed;
	__map_gbk2utf16[0x05b0] = 0x55ee;
	__map_gbk2utf16[0x05b1] = 0x55f0;
	__map_gbk2utf16[0x05b2] = 0x55f1;
	__map_gbk2utf16[0x05b3] = 0x55f4;
	__map_gbk2utf16[0x05b4] = 0x55f6;
	__map_gbk2utf16[0x05b5] = 0x55f8;
	__map_gbk2utf16[0x05b6] = 0x55f9;
	__map_gbk2utf16[0x05b7] = 0x55fa;
	__map_gbk2utf16[0x05b8] = 0x55fb;
	__map_gbk2utf16[0x05b9] = 0x55fc;
	__map_gbk2utf16[0x05ba] = 0x55ff;
	__map_gbk2utf16[0x05bb] = 0x5602;
	__map_gbk2utf16[0x05bc] = 0x5603;
	__map_gbk2utf16[0x05bd] = 0x5604;
	__map_gbk2utf16[0x05be] = 0x5605;
	__map_gbk2utf16[0x0600] = 0x5606;
	__map_gbk2utf16[0x0601] = 0x5607;
	__map_gbk2utf16[0x0602] = 0x560a;
	__map_gbk2utf16[0x0603] = 0x560b;
	__map_gbk2utf16[0x0604] = 0x560d;
	__map_gbk2utf16[0x0605] = 0x5610;
	__map_gbk2utf16[0x0606] = 0x5611;
	__map_gbk2utf16[0x0607] = 0x5612;
	__map_gbk2utf16[0x0608] = 0x5613;
	__map_gbk2utf16[0x0609] = 0x5614;
	__map_gbk2utf16[0x060a] = 0x5615;
	__map_gbk2utf16[0x060b] = 0x5616;
	__map_gbk2utf16[0x060c] = 0x5617;
	__map_gbk2utf16[0x060d] = 0x5619;
	__map_gbk2utf16[0x060e] = 0x561a;
	__map_gbk2utf16[0x060f] = 0x561c;
	__map_gbk2utf16[0x0610] = 0x561d;
	__map_gbk2utf16[0x0611] = 0x5620;
	__map_gbk2utf16[0x0612] = 0x5621;
	__map_gbk2utf16[0x0613] = 0x5622;
	__map_gbk2utf16[0x0614] = 0x5625;
	__map_gbk2utf16[0x0615] = 0x5626;
	__map_gbk2utf16[0x0616] = 0x5628;
	__map_gbk2utf16[0x0617] = 0x5629;
	__map_gbk2utf16[0x0618] = 0x562a;
	__map_gbk2utf16[0x0619] = 0x562b;
	__map_gbk2utf16[0x061a] = 0x562e;
	__map_gbk2utf16[0x061b] = 0x562f;
	__map_gbk2utf16[0x061c] = 0x5630;
	__map_gbk2utf16[0x061d] = 0x5633;
	__map_gbk2utf16[0x061e] = 0x5635;
	__map_gbk2utf16[0x061f] = 0x5637;
	__map_gbk2utf16[0x0620] = 0x5638;
	__map_gbk2utf16[0x0621] = 0x563a;
	__map_gbk2utf16[0x0622] = 0x563c;
	__map_gbk2utf16[0x0623] = 0x563d;
	__map_gbk2utf16[0x0624] = 0x563e;
	__map_gbk2utf16[0x0625] = 0x5640;
	__map_gbk2utf16[0x0626] = 0x5641;
	__map_gbk2utf16[0x0627] = 0x5642;
	__map_gbk2utf16[0x0628] = 0x5643;
	__map_gbk2utf16[0x0629] = 0x5644;
	__map_gbk2utf16[0x062a] = 0x5645;
	__map_gbk2utf16[0x062b] = 0x5646;
	__map_gbk2utf16[0x062c] = 0x5647;
	__map_gbk2utf16[0x062d] = 0x5648;
	__map_gbk2utf16[0x062e] = 0x5649;
	__map_gbk2utf16[0x062f] = 0x564a;
	__map_gbk2utf16[0x0630] = 0x564b;
	__map_gbk2utf16[0x0631] = 0x564f;
	__map_gbk2utf16[0x0632] = 0x5650;
	__map_gbk2utf16[0x0633] = 0x5651;
	__map_gbk2utf16[0x0634] = 0x5652;
	__map_gbk2utf16[0x0635] = 0x5653;
	__map_gbk2utf16[0x0636] = 0x5655;
	__map_gbk2utf16[0x0637] = 0x5656;
	__map_gbk2utf16[0x0638] = 0x565a;
	__map_gbk2utf16[0x0639] = 0x565b;
	__map_gbk2utf16[0x063a] = 0x565d;
	__map_gbk2utf16[0x063b] = 0x565e;
	__map_gbk2utf16[0x063c] = 0x565f;
	__map_gbk2utf16[0x063d] = 0x5660;
	__map_gbk2utf16[0x063e] = 0x5661;
	__map_gbk2utf16[0x0640] = 0x5663;
	__map_gbk2utf16[0x0641] = 0x5665;
	__map_gbk2utf16[0x0642] = 0x5666;
	__map_gbk2utf16[0x0643] = 0x5667;
	__map_gbk2utf16[0x0644] = 0x566d;
	__map_gbk2utf16[0x0645] = 0x566e;
	__map_gbk2utf16[0x0646] = 0x566f;
	__map_gbk2utf16[0x0647] = 0x5670;
	__map_gbk2utf16[0x0648] = 0x5672;
	__map_gbk2utf16[0x0649] = 0x5673;
	__map_gbk2utf16[0x064a] = 0x5674;
	__map_gbk2utf16[0x064b] = 0x5675;
	__map_gbk2utf16[0x064c] = 0x5677;
	__map_gbk2utf16[0x064d] = 0x5678;
	__map_gbk2utf16[0x064e] = 0x5679;
	__map_gbk2utf16[0x064f] = 0x567a;
	__map_gbk2utf16[0x0650] = 0x567d;
	__map_gbk2utf16[0x0651] = 0x567e;
	__map_gbk2utf16[0x0652] = 0x567f;
	__map_gbk2utf16[0x0653] = 0x5680;
	__map_gbk2utf16[0x0654] = 0x5681;
	__map_gbk2utf16[0x0655] = 0x5682;
	__map_gbk2utf16[0x0656] = 0x5683;
	__map_gbk2utf16[0x0657] = 0x5684;
	__map_gbk2utf16[0x0658] = 0x5687;
	__map_gbk2utf16[0x0659] = 0x5688;
	__map_gbk2utf16[0x065a] = 0x5689;
	__map_gbk2utf16[0x065b] = 0x568a;
	__map_gbk2utf16[0x065c] = 0x568b;
	__map_gbk2utf16[0x065d] = 0x568c;
	__map_gbk2utf16[0x065e] = 0x568d;
	__map_gbk2utf16[0x065f] = 0x5690;
	__map_gbk2utf16[0x0660] = 0x5691;
	__map_gbk2utf16[0x0661] = 0x5692;
	__map_gbk2utf16[0x0662] = 0x5694;
	__map_gbk2utf16[0x0663] = 0x5695;
	__map_gbk2utf16[0x0664] = 0x5696;
	__map_gbk2utf16[0x0665] = 0x5697;
	__map_gbk2utf16[0x0666] = 0x5698;
	__map_gbk2utf16[0x0667] = 0x5699;
	__map_gbk2utf16[0x0668] = 0x569a;
	__map_gbk2utf16[0x0669] = 0x569b;
	__map_gbk2utf16[0x066a] = 0x569c;
	__map_gbk2utf16[0x066b] = 0x569d;
	__map_gbk2utf16[0x066c] = 0x569e;
	__map_gbk2utf16[0x066d] = 0x569f;
	__map_gbk2utf16[0x066e] = 0x56a0;
	__map_gbk2utf16[0x066f] = 0x56a1;
	__map_gbk2utf16[0x0670] = 0x56a2;
	__map_gbk2utf16[0x0671] = 0x56a4;
	__map_gbk2utf16[0x0672] = 0x56a5;
	__map_gbk2utf16[0x0673] = 0x56a6;
	__map_gbk2utf16[0x0674] = 0x56a7;
	__map_gbk2utf16[0x0675] = 0x56a8;
	__map_gbk2utf16[0x0676] = 0x56a9;
	__map_gbk2utf16[0x0677] = 0x56aa;
	__map_gbk2utf16[0x0678] = 0x56ab;
	__map_gbk2utf16[0x0679] = 0x56ac;
	__map_gbk2utf16[0x067a] = 0x56ad;
	__map_gbk2utf16[0x067b] = 0x56ae;
	__map_gbk2utf16[0x067c] = 0x56b0;
	__map_gbk2utf16[0x067d] = 0x56b1;
	__map_gbk2utf16[0x067e] = 0x56b2;
	__map_gbk2utf16[0x067f] = 0x56b3;
	__map_gbk2utf16[0x0680] = 0x56b4;
	__map_gbk2utf16[0x0681] = 0x56b5;
	__map_gbk2utf16[0x0682] = 0x56b6;
	__map_gbk2utf16[0x0683] = 0x56b8;
	__map_gbk2utf16[0x0684] = 0x56b9;
	__map_gbk2utf16[0x0685] = 0x56ba;
	__map_gbk2utf16[0x0686] = 0x56bb;
	__map_gbk2utf16[0x0687] = 0x56bd;
	__map_gbk2utf16[0x0688] = 0x56be;
	__map_gbk2utf16[0x0689] = 0x56bf;
	__map_gbk2utf16[0x068a] = 0x56c0;
	__map_gbk2utf16[0x068b] = 0x56c1;
	__map_gbk2utf16[0x068c] = 0x56c2;
	__map_gbk2utf16[0x068d] = 0x56c3;
	__map_gbk2utf16[0x068e] = 0x56c4;
	__map_gbk2utf16[0x068f] = 0x56c5;
	__map_gbk2utf16[0x0690] = 0x56c6;
	__map_gbk2utf16[0x0691] = 0x56c7;
	__map_gbk2utf16[0x0692] = 0x56c8;
	__map_gbk2utf16[0x0693] = 0x56c9;
	__map_gbk2utf16[0x0694] = 0x56cb;
	__map_gbk2utf16[0x0695] = 0x56cc;
	__map_gbk2utf16[0x0696] = 0x56cd;
	__map_gbk2utf16[0x0697] = 0x56ce;
	__map_gbk2utf16[0x0698] = 0x56cf;
	__map_gbk2utf16[0x0699] = 0x56d0;
	__map_gbk2utf16[0x069a] = 0x56d1;
	__map_gbk2utf16[0x069b] = 0x56d2;
	__map_gbk2utf16[0x069c] = 0x56d3;
	__map_gbk2utf16[0x069d] = 0x56d5;
	__map_gbk2utf16[0x069e] = 0x56d6;
	__map_gbk2utf16[0x069f] = 0x56d8;
	__map_gbk2utf16[0x06a0] = 0x56d9;
	__map_gbk2utf16[0x06a1] = 0x56dc;
	__map_gbk2utf16[0x06a2] = 0x56e3;
	__map_gbk2utf16[0x06a3] = 0x56e5;
	__map_gbk2utf16[0x06a4] = 0x56e6;
	__map_gbk2utf16[0x06a5] = 0x56e7;
	__map_gbk2utf16[0x06a6] = 0x56e8;
	__map_gbk2utf16[0x06a7] = 0x56e9;
	__map_gbk2utf16[0x06a8] = 0x56ea;
	__map_gbk2utf16[0x06a9] = 0x56ec;
	__map_gbk2utf16[0x06aa] = 0x56ee;
	__map_gbk2utf16[0x06ab] = 0x56ef;
	__map_gbk2utf16[0x06ac] = 0x56f2;
	__map_gbk2utf16[0x06ad] = 0x56f3;
	__map_gbk2utf16[0x06ae] = 0x56f6;
	__map_gbk2utf16[0x06af] = 0x56f7;
	__map_gbk2utf16[0x06b0] = 0x56f8;
	__map_gbk2utf16[0x06b1] = 0x56fb;
	__map_gbk2utf16[0x06b2] = 0x56fc;
	__map_gbk2utf16[0x06b3] = 0x5700;
	__map_gbk2utf16[0x06b4] = 0x5701;
	__map_gbk2utf16[0x06b5] = 0x5702;
	__map_gbk2utf16[0x06b6] = 0x5705;
	__map_gbk2utf16[0x06b7] = 0x5707;
	__map_gbk2utf16[0x06b8] = 0x570b;
	__map_gbk2utf16[0x06b9] = 0x570c;
	__map_gbk2utf16[0x06ba] = 0x570d;
	__map_gbk2utf16[0x06bb] = 0x570e;
	__map_gbk2utf16[0x06bc] = 0x570f;
	__map_gbk2utf16[0x06bd] = 0x5710;
	__map_gbk2utf16[0x06be] = 0x5711;
	__map_gbk2utf16[0x0700] = 0x5712;
	__map_gbk2utf16[0x0701] = 0x5713;
	__map_gbk2utf16[0x0702] = 0x5714;
	__map_gbk2utf16[0x0703] = 0x5715;
	__map_gbk2utf16[0x0704] = 0x5716;
	__map_gbk2utf16[0x0705] = 0x5717;
	__map_gbk2utf16[0x0706] = 0x5718;
	__map_gbk2utf16[0x0707] = 0x5719;
	__map_gbk2utf16[0x0708] = 0x571a;
	__map_gbk2utf16[0x0709] = 0x571b;
	__map_gbk2utf16[0x070a] = 0x571d;
	__map_gbk2utf16[0x070b] = 0x571e;
	__map_gbk2utf16[0x070c] = 0x5720;
	__map_gbk2utf16[0x070d] = 0x5721;
	__map_gbk2utf16[0x070e] = 0x5722;
	__map_gbk2utf16[0x070f] = 0x5724;
	__map_gbk2utf16[0x0710] = 0x5725;
	__map_gbk2utf16[0x0711] = 0x5726;
	__map_gbk2utf16[0x0712] = 0x5727;
	__map_gbk2utf16[0x0713] = 0x572b;
	__map_gbk2utf16[0x0714] = 0x5731;
	__map_gbk2utf16[0x0715] = 0x5732;
	__map_gbk2utf16[0x0716] = 0x5734;
	__map_gbk2utf16[0x0717] = 0x5735;
	__map_gbk2utf16[0x0718] = 0x5736;
	__map_gbk2utf16[0x0719] = 0x5737;
	__map_gbk2utf16[0x071a] = 0x5738;
	__map_gbk2utf16[0x071b] = 0x573c;
	__map_gbk2utf16[0x071c] = 0x573d;
	__map_gbk2utf16[0x071d] = 0x573f;
	__map_gbk2utf16[0x071e] = 0x5741;
	__map_gbk2utf16[0x071f] = 0x5743;
	__map_gbk2utf16[0x0720] = 0x5744;
	__map_gbk2utf16[0x0721] = 0x5745;
	__map_gbk2utf16[0x0722] = 0x5746;
	__map_gbk2utf16[0x0723] = 0x5748;
	__map_gbk2utf16[0x0724] = 0x5749;
	__map_gbk2utf16[0x0725] = 0x574b;
	__map_gbk2utf16[0x0726] = 0x5752;
	__map_gbk2utf16[0x0727] = 0x5753;
	__map_gbk2utf16[0x0728] = 0x5754;
	__map_gbk2utf16[0x0729] = 0x5755;
	__map_gbk2utf16[0x072a] = 0x5756;
	__map_gbk2utf16[0x072b] = 0x5758;
	__map_gbk2utf16[0x072c] = 0x5759;
	__map_gbk2utf16[0x072d] = 0x5762;
	__map_gbk2utf16[0x072e] = 0x5763;
	__map_gbk2utf16[0x072f] = 0x5765;
	__map_gbk2utf16[0x0730] = 0x5767;
	__map_gbk2utf16[0x0731] = 0x576c;
	__map_gbk2utf16[0x0732] = 0x576e;
	__map_gbk2utf16[0x0733] = 0x5770;
	__map_gbk2utf16[0x0734] = 0x5771;
	__map_gbk2utf16[0x0735] = 0x5772;
	__map_gbk2utf16[0x0736] = 0x5774;
	__map_gbk2utf16[0x0737] = 0x5775;
	__map_gbk2utf16[0x0738] = 0x5778;
	__map_gbk2utf16[0x0739] = 0x5779;
	__map_gbk2utf16[0x073a] = 0x577a;
	__map_gbk2utf16[0x073b] = 0x577d;
	__map_gbk2utf16[0x073c] = 0x577e;
	__map_gbk2utf16[0x073d] = 0x577f;
	__map_gbk2utf16[0x073e] = 0x5780;
	__map_gbk2utf16[0x0740] = 0x5781;
	__map_gbk2utf16[0x0741] = 0x5787;
	__map_gbk2utf16[0x0742] = 0x5788;
	__map_gbk2utf16[0x0743] = 0x5789;
	__map_gbk2utf16[0x0744] = 0x578a;
	__map_gbk2utf16[0x0745] = 0x578d;
	__map_gbk2utf16[0x0746] = 0x578e;
	__map_gbk2utf16[0x0747] = 0x578f;
	__map_gbk2utf16[0x0748] = 0x5790;
	__map_gbk2utf16[0x0749] = 0x5791;
	__map_gbk2utf16[0x074a] = 0x5794;
	__map_gbk2utf16[0x074b] = 0x5795;
	__map_gbk2utf16[0x074c] = 0x5796;
	__map_gbk2utf16[0x074d] = 0x5797;
	__map_gbk2utf16[0x074e] = 0x5798;
	__map_gbk2utf16[0x074f] = 0x5799;
	__map_gbk2utf16[0x0750] = 0x579a;
	__map_gbk2utf16[0x0751] = 0x579c;
	__map_gbk2utf16[0x0752] = 0x579d;
	__map_gbk2utf16[0x0753] = 0x579e;
	__map_gbk2utf16[0x0754] = 0x579f;
	__map_gbk2utf16[0x0755] = 0x57a5;
	__map_gbk2utf16[0x0756] = 0x57a8;
	__map_gbk2utf16[0x0757] = 0x57aa;
	__map_gbk2utf16[0x0758] = 0x57ac;
	__map_gbk2utf16[0x0759] = 0x57af;
	__map_gbk2utf16[0x075a] = 0x57b0;
	__map_gbk2utf16[0x075b] = 0x57b1;
	__map_gbk2utf16[0x075c] = 0x57b3;
	__map_gbk2utf16[0x075d] = 0x57b5;
	__map_gbk2utf16[0x075e] = 0x57b6;
	__map_gbk2utf16[0x075f] = 0x57b7;
	__map_gbk2utf16[0x0760] = 0x57b9;
	__map_gbk2utf16[0x0761] = 0x57ba;
	__map_gbk2utf16[0x0762] = 0x57bb;
	__map_gbk2utf16[0x0763] = 0x57bc;
	__map_gbk2utf16[0x0764] = 0x57bd;
	__map_gbk2utf16[0x0765] = 0x57be;
	__map_gbk2utf16[0x0766] = 0x57bf;
	__map_gbk2utf16[0x0767] = 0x57c0;
	__map_gbk2utf16[0x0768] = 0x57c1;
	__map_gbk2utf16[0x0769] = 0x57c4;
	__map_gbk2utf16[0x076a] = 0x57c5;
	__map_gbk2utf16[0x076b] = 0x57c6;
	__map_gbk2utf16[0x076c] = 0x57c7;
	__map_gbk2utf16[0x076d] = 0x57c8;
	__map_gbk2utf16[0x076e] = 0x57c9;
	__map_gbk2utf16[0x076f] = 0x57ca;
	__map_gbk2utf16[0x0770] = 0x57cc;
	__map_gbk2utf16[0x0771] = 0x57cd;
	__map_gbk2utf16[0x0772] = 0x57d0;
	__map_gbk2utf16[0x0773] = 0x57d1;
	__map_gbk2utf16[0x0774] = 0x57d3;
	__map_gbk2utf16[0x0775] = 0x57d6;
	__map_gbk2utf16[0x0776] = 0x57d7;
	__map_gbk2utf16[0x0777] = 0x57db;
	__map_gbk2utf16[0x0778] = 0x57dc;
	__map_gbk2utf16[0x0779] = 0x57de;
	__map_gbk2utf16[0x077a] = 0x57e1;
	__map_gbk2utf16[0x077b] = 0x57e2;
	__map_gbk2utf16[0x077c] = 0x57e3;
	__map_gbk2utf16[0x077d] = 0x57e5;
	__map_gbk2utf16[0x077e] = 0x57e6;
	__map_gbk2utf16[0x077f] = 0x57e7;
	__map_gbk2utf16[0x0780] = 0x57e8;
	__map_gbk2utf16[0x0781] = 0x57e9;
	__map_gbk2utf16[0x0782] = 0x57ea;
	__map_gbk2utf16[0x0783] = 0x57eb;
	__map_gbk2utf16[0x0784] = 0x57ec;
	__map_gbk2utf16[0x0785] = 0x57ee;
	__map_gbk2utf16[0x0786] = 0x57f0;
	__map_gbk2utf16[0x0787] = 0x57f1;
	__map_gbk2utf16[0x0788] = 0x57f2;
	__map_gbk2utf16[0x0789] = 0x57f3;
	__map_gbk2utf16[0x078a] = 0x57f5;
	__map_gbk2utf16[0x078b] = 0x57f6;
	__map_gbk2utf16[0x078c] = 0x57f7;
	__map_gbk2utf16[0x078d] = 0x57fb;
	__map_gbk2utf16[0x078e] = 0x57fc;
	__map_gbk2utf16[0x078f] = 0x57fe;
	__map_gbk2utf16[0x0790] = 0x57ff;
	__map_gbk2utf16[0x0791] = 0x5801;
	__map_gbk2utf16[0x0792] = 0x5803;
	__map_gbk2utf16[0x0793] = 0x5804;
	__map_gbk2utf16[0x0794] = 0x5805;
	__map_gbk2utf16[0x0795] = 0x5808;
	__map_gbk2utf16[0x0796] = 0x5809;
	__map_gbk2utf16[0x0797] = 0x580a;
	__map_gbk2utf16[0x0798] = 0x580c;
	__map_gbk2utf16[0x0799] = 0x580e;
	__map_gbk2utf16[0x079a] = 0x580f;
	__map_gbk2utf16[0x079b] = 0x5810;
	__map_gbk2utf16[0x079c] = 0x5812;
	__map_gbk2utf16[0x079d] = 0x5813;
	__map_gbk2utf16[0x079e] = 0x5814;
	__map_gbk2utf16[0x079f] = 0x5816;
	__map_gbk2utf16[0x07a0] = 0x5817;
	__map_gbk2utf16[0x07a1] = 0x5818;
	__map_gbk2utf16[0x07a2] = 0x581a;
	__map_gbk2utf16[0x07a3] = 0x581b;
	__map_gbk2utf16[0x07a4] = 0x581c;
	__map_gbk2utf16[0x07a5] = 0x581d;
	__map_gbk2utf16[0x07a6] = 0x581f;
	__map_gbk2utf16[0x07a7] = 0x5822;
	__map_gbk2utf16[0x07a8] = 0x5823;
	__map_gbk2utf16[0x07a9] = 0x5825;
	__map_gbk2utf16[0x07aa] = 0x5826;
	__map_gbk2utf16[0x07ab] = 0x5827;
	__map_gbk2utf16[0x07ac] = 0x5828;
	__map_gbk2utf16[0x07ad] = 0x5829;
	__map_gbk2utf16[0x07ae] = 0x582b;
	__map_gbk2utf16[0x07af] = 0x582c;
	__map_gbk2utf16[0x07b0] = 0x582d;
	__map_gbk2utf16[0x07b1] = 0x582e;
	__map_gbk2utf16[0x07b2] = 0x582f;
	__map_gbk2utf16[0x07b3] = 0x5831;
	__map_gbk2utf16[0x07b4] = 0x5832;
	__map_gbk2utf16[0x07b5] = 0x5833;
	__map_gbk2utf16[0x07b6] = 0x5834;
	__map_gbk2utf16[0x07b7] = 0x5836;
	__map_gbk2utf16[0x07b8] = 0x5837;
	__map_gbk2utf16[0x07b9] = 0x5838;
	__map_gbk2utf16[0x07ba] = 0x5839;
	__map_gbk2utf16[0x07bb] = 0x583a;
	__map_gbk2utf16[0x07bc] = 0x583b;
	__map_gbk2utf16[0x07bd] = 0x583c;
	__map_gbk2utf16[0x07be] = 0x583d;
	__map_gbk2utf16[0x0800] = 0x583e;
	__map_gbk2utf16[0x0801] = 0x583f;
	__map_gbk2utf16[0x0802] = 0x5840;
	__map_gbk2utf16[0x0803] = 0x5841;
	__map_gbk2utf16[0x0804] = 0x5842;
	__map_gbk2utf16[0x0805] = 0x5843;
	__map_gbk2utf16[0x0806] = 0x5845;
	__map_gbk2utf16[0x0807] = 0x5846;
	__map_gbk2utf16[0x0808] = 0x5847;
	__map_gbk2utf16[0x0809] = 0x5848;
	__map_gbk2utf16[0x080a] = 0x5849;
	__map_gbk2utf16[0x080b] = 0x584a;
	__map_gbk2utf16[0x080c] = 0x584b;
	__map_gbk2utf16[0x080d] = 0x584e;
	__map_gbk2utf16[0x080e] = 0x584f;
	__map_gbk2utf16[0x080f] = 0x5850;
	__map_gbk2utf16[0x0810] = 0x5852;
	__map_gbk2utf16[0x0811] = 0x5853;
	__map_gbk2utf16[0x0812] = 0x5855;
	__map_gbk2utf16[0x0813] = 0x5856;
	__map_gbk2utf16[0x0814] = 0x5857;
	__map_gbk2utf16[0x0815] = 0x5859;
	__map_gbk2utf16[0x0816] = 0x585a;
	__map_gbk2utf16[0x0817] = 0x585b;
	__map_gbk2utf16[0x0818] = 0x585c;
	__map_gbk2utf16[0x0819] = 0x585d;
	__map_gbk2utf16[0x081a] = 0x585f;
	__map_gbk2utf16[0x081b] = 0x5860;
	__map_gbk2utf16[0x081c] = 0x5861;
	__map_gbk2utf16[0x081d] = 0x5862;
	__map_gbk2utf16[0x081e] = 0x5863;
	__map_gbk2utf16[0x081f] = 0x5864;
	__map_gbk2utf16[0x0820] = 0x5866;
	__map_gbk2utf16[0x0821] = 0x5867;
	__map_gbk2utf16[0x0822] = 0x5868;
	__map_gbk2utf16[0x0823] = 0x5869;
	__map_gbk2utf16[0x0824] = 0x586a;
	__map_gbk2utf16[0x0825] = 0x586d;
	__map_gbk2utf16[0x0826] = 0x586e;
	__map_gbk2utf16[0x0827] = 0x586f;
	__map_gbk2utf16[0x0828] = 0x5870;
	__map_gbk2utf16[0x0829] = 0x5871;
	__map_gbk2utf16[0x082a] = 0x5872;
	__map_gbk2utf16[0x082b] = 0x5873;
	__map_gbk2utf16[0x082c] = 0x5874;
	__map_gbk2utf16[0x082d] = 0x5875;
	__map_gbk2utf16[0x082e] = 0x5876;
	__map_gbk2utf16[0x082f] = 0x5877;
	__map_gbk2utf16[0x0830] = 0x5878;
	__map_gbk2utf16[0x0831] = 0x5879;
	__map_gbk2utf16[0x0832] = 0x587a;
	__map_gbk2utf16[0x0833] = 0x587b;
	__map_gbk2utf16[0x0834] = 0x587c;
	__map_gbk2utf16[0x0835] = 0x587d;
	__map_gbk2utf16[0x0836] = 0x587f;
	__map_gbk2utf16[0x0837] = 0x5882;
	__map_gbk2utf16[0x0838] = 0x5884;
	__map_gbk2utf16[0x0839] = 0x5886;
	__map_gbk2utf16[0x083a] = 0x5887;
	__map_gbk2utf16[0x083b] = 0x5888;
	__map_gbk2utf16[0x083c] = 0x588a;
	__map_gbk2utf16[0x083d] = 0x588b;
	__map_gbk2utf16[0x083e] = 0x588c;
	__map_gbk2utf16[0x0840] = 0x588d;
	__map_gbk2utf16[0x0841] = 0x588e;
	__map_gbk2utf16[0x0842] = 0x588f;
	__map_gbk2utf16[0x0843] = 0x5890;
	__map_gbk2utf16[0x0844] = 0x5891;
	__map_gbk2utf16[0x0845] = 0x5894;
	__map_gbk2utf16[0x0846] = 0x5895;
	__map_gbk2utf16[0x0847] = 0x5896;
	__map_gbk2utf16[0x0848] = 0x5897;
	__map_gbk2utf16[0x0849] = 0x5898;
	__map_gbk2utf16[0x084a] = 0x589b;
	__map_gbk2utf16[0x084b] = 0x589c;
	__map_gbk2utf16[0x084c] = 0x589d;
	__map_gbk2utf16[0x084d] = 0x58a0;
	__map_gbk2utf16[0x084e] = 0x58a1;
	__map_gbk2utf16[0x084f] = 0x58a2;
	__map_gbk2utf16[0x0850] = 0x58a3;
	__map_gbk2utf16[0x0851] = 0x58a4;
	__map_gbk2utf16[0x0852] = 0x58a5;
	__map_gbk2utf16[0x0853] = 0x58a6;
	__map_gbk2utf16[0x0854] = 0x58a7;
	__map_gbk2utf16[0x0855] = 0x58aa;
	__map_gbk2utf16[0x0856] = 0x58ab;
	__map_gbk2utf16[0x0857] = 0x58ac;
	__map_gbk2utf16[0x0858] = 0x58ad;
	__map_gbk2utf16[0x0859] = 0x58ae;
	__map_gbk2utf16[0x085a] = 0x58af;
	__map_gbk2utf16[0x085b] = 0x58b0;
	__map_gbk2utf16[0x085c] = 0x58b1;
	__map_gbk2utf16[0x085d] = 0x58b2;
	__map_gbk2utf16[0x085e] = 0x58b3;
	__map_gbk2utf16[0x085f] = 0x58b4;
	__map_gbk2utf16[0x0860] = 0x58b5;
	__map_gbk2utf16[0x0861] = 0x58b6;
	__map_gbk2utf16[0x0862] = 0x58b7;
	__map_gbk2utf16[0x0863] = 0x58b8;
	__map_gbk2utf16[0x0864] = 0x58b9;
	__map_gbk2utf16[0x0865] = 0x58ba;
	__map_gbk2utf16[0x0866] = 0x58bb;
	__map_gbk2utf16[0x0867] = 0x58bd;
	__map_gbk2utf16[0x0868] = 0x58be;
	__map_gbk2utf16[0x0869] = 0x58bf;
	__map_gbk2utf16[0x086a] = 0x58c0;
	__map_gbk2utf16[0x086b] = 0x58c2;
	__map_gbk2utf16[0x086c] = 0x58c3;
	__map_gbk2utf16[0x086d] = 0x58c4;
	__map_gbk2utf16[0x086e] = 0x58c6;
	__map_gbk2utf16[0x086f] = 0x58c7;
	__map_gbk2utf16[0x0870] = 0x58c8;
	__map_gbk2utf16[0x0871] = 0x58c9;
	__map_gbk2utf16[0x0872] = 0x58ca;
	__map_gbk2utf16[0x0873] = 0x58cb;
	__map_gbk2utf16[0x0874] = 0x58cc;
	__map_gbk2utf16[0x0875] = 0x58cd;
	__map_gbk2utf16[0x0876] = 0x58ce;
	__map_gbk2utf16[0x0877] = 0x58cf;
	__map_gbk2utf16[0x0878] = 0x58d0;
	__map_gbk2utf16[0x0879] = 0x58d2;
	__map_gbk2utf16[0x087a] = 0x58d3;
	__map_gbk2utf16[0x087b] = 0x58d4;
	__map_gbk2utf16[0x087c] = 0x58d6;
	__map_gbk2utf16[0x087d] = 0x58d7;
	__map_gbk2utf16[0x087e] = 0x58d8;
	__map_gbk2utf16[0x087f] = 0x58d9;
	__map_gbk2utf16[0x0880] = 0x58da;
	__map_gbk2utf16[0x0881] = 0x58db;
	__map_gbk2utf16[0x0882] = 0x58dc;
	__map_gbk2utf16[0x0883] = 0x58dd;
	__map_gbk2utf16[0x0884] = 0x58de;
	__map_gbk2utf16[0x0885] = 0x58df;
	__map_gbk2utf16[0x0886] = 0x58e0;
	__map_gbk2utf16[0x0887] = 0x58e1;
	__map_gbk2utf16[0x0888] = 0x58e2;
	__map_gbk2utf16[0x0889] = 0x58e3;
	__map_gbk2utf16[0x088a] = 0x58e5;
	__map_gbk2utf16[0x088b] = 0x58e6;
	__map_gbk2utf16[0x088c] = 0x58e7;
	__map_gbk2utf16[0x088d] = 0x58e8;
	__map_gbk2utf16[0x088e] = 0x58e9;
	__map_gbk2utf16[0x088f] = 0x58ea;
	__map_gbk2utf16[0x0890] = 0x58ed;
	__map_gbk2utf16[0x0891] = 0x58ef;
	__map_gbk2utf16[0x0892] = 0x58f1;
	__map_gbk2utf16[0x0893] = 0x58f2;
	__map_gbk2utf16[0x0894] = 0x58f4;
	__map_gbk2utf16[0x0895] = 0x58f5;
	__map_gbk2utf16[0x0896] = 0x58f7;
	__map_gbk2utf16[0x0897] = 0x58f8;
	__map_gbk2utf16[0x0898] = 0x58fa;
	__map_gbk2utf16[0x0899] = 0x58fb;
	__map_gbk2utf16[0x089a] = 0x58fc;
	__map_gbk2utf16[0x089b] = 0x58fd;
	__map_gbk2utf16[0x089c] = 0x58fe;
	__map_gbk2utf16[0x089d] = 0x58ff;
	__map_gbk2utf16[0x089e] = 0x5900;
	__map_gbk2utf16[0x089f] = 0x5901;
	__map_gbk2utf16[0x08a0] = 0x5903;
	__map_gbk2utf16[0x08a1] = 0x5905;
	__map_gbk2utf16[0x08a2] = 0x5906;
	__map_gbk2utf16[0x08a3] = 0x5908;
	__map_gbk2utf16[0x08a4] = 0x5909;
	__map_gbk2utf16[0x08a5] = 0x590a;
	__map_gbk2utf16[0x08a6] = 0x590b;
	__map_gbk2utf16[0x08a7] = 0x590c;
	__map_gbk2utf16[0x08a8] = 0x590e;
	__map_gbk2utf16[0x08a9] = 0x5910;
	__map_gbk2utf16[0x08aa] = 0x5911;
	__map_gbk2utf16[0x08ab] = 0x5912;
	__map_gbk2utf16[0x08ac] = 0x5913;
	__map_gbk2utf16[0x08ad] = 0x5917;
	__map_gbk2utf16[0x08ae] = 0x5918;
	__map_gbk2utf16[0x08af] = 0x591b;
	__map_gbk2utf16[0x08b0] = 0x591d;
	__map_gbk2utf16[0x08b1] = 0x591e;
	__map_gbk2utf16[0x08b2] = 0x5920;
	__map_gbk2utf16[0x08b3] = 0x5921;
	__map_gbk2utf16[0x08b4] = 0x5922;
	__map_gbk2utf16[0x08b5] = 0x5923;
	__map_gbk2utf16[0x08b6] = 0x5926;
	__map_gbk2utf16[0x08b7] = 0x5928;
	__map_gbk2utf16[0x08b8] = 0x592c;
	__map_gbk2utf16[0x08b9] = 0x5930;
	__map_gbk2utf16[0x08ba] = 0x5932;
	__map_gbk2utf16[0x08bb] = 0x5933;
	__map_gbk2utf16[0x08bc] = 0x5935;
	__map_gbk2utf16[0x08bd] = 0x5936;
	__map_gbk2utf16[0x08be] = 0x593b;
	__map_gbk2utf16[0x0900] = 0x593d;
	__map_gbk2utf16[0x0901] = 0x593e;
	__map_gbk2utf16[0x0902] = 0x593f;
	__map_gbk2utf16[0x0903] = 0x5940;
	__map_gbk2utf16[0x0904] = 0x5943;
	__map_gbk2utf16[0x0905] = 0x5945;
	__map_gbk2utf16[0x0906] = 0x5946;
	__map_gbk2utf16[0x0907] = 0x594a;
	__map_gbk2utf16[0x0908] = 0x594c;
	__map_gbk2utf16[0x0909] = 0x594d;
	__map_gbk2utf16[0x090a] = 0x5950;
	__map_gbk2utf16[0x090b] = 0x5952;
	__map_gbk2utf16[0x090c] = 0x5953;
	__map_gbk2utf16[0x090d] = 0x5959;
	__map_gbk2utf16[0x090e] = 0x595b;
	__map_gbk2utf16[0x090f] = 0x595c;
	__map_gbk2utf16[0x0910] = 0x595d;
	__map_gbk2utf16[0x0911] = 0x595e;
	__map_gbk2utf16[0x0912] = 0x595f;
	__map_gbk2utf16[0x0913] = 0x5961;
	__map_gbk2utf16[0x0914] = 0x5963;
	__map_gbk2utf16[0x0915] = 0x5964;
	__map_gbk2utf16[0x0916] = 0x5966;
	__map_gbk2utf16[0x0917] = 0x5967;
	__map_gbk2utf16[0x0918] = 0x5968;
	__map_gbk2utf16[0x0919] = 0x5969;
	__map_gbk2utf16[0x091a] = 0x596a;
	__map_gbk2utf16[0x091b] = 0x596b;
	__map_gbk2utf16[0x091c] = 0x596c;
	__map_gbk2utf16[0x091d] = 0x596d;
	__map_gbk2utf16[0x091e] = 0x596e;
	__map_gbk2utf16[0x091f] = 0x596f;
	__map_gbk2utf16[0x0920] = 0x5970;
	__map_gbk2utf16[0x0921] = 0x5971;
	__map_gbk2utf16[0x0922] = 0x5972;
	__map_gbk2utf16[0x0923] = 0x5975;
	__map_gbk2utf16[0x0924] = 0x5977;
	__map_gbk2utf16[0x0925] = 0x597a;
	__map_gbk2utf16[0x0926] = 0x597b;
	__map_gbk2utf16[0x0927] = 0x597c;
	__map_gbk2utf16[0x0928] = 0x597e;
	__map_gbk2utf16[0x0929] = 0x597f;
	__map_gbk2utf16[0x092a] = 0x5980;
	__map_gbk2utf16[0x092b] = 0x5985;
	__map_gbk2utf16[0x092c] = 0x5989;
	__map_gbk2utf16[0x092d] = 0x598b;
	__map_gbk2utf16[0x092e] = 0x598c;
	__map_gbk2utf16[0x092f] = 0x598e;
	__map_gbk2utf16[0x0930] = 0x598f;
	__map_gbk2utf16[0x0931] = 0x5990;
	__map_gbk2utf16[0x0932] = 0x5991;
	__map_gbk2utf16[0x0933] = 0x5994;
	__map_gbk2utf16[0x0934] = 0x5995;
	__map_gbk2utf16[0x0935] = 0x5998;
	__map_gbk2utf16[0x0936] = 0x599a;
	__map_gbk2utf16[0x0937] = 0x599b;
	__map_gbk2utf16[0x0938] = 0x599c;
	__map_gbk2utf16[0x0939] = 0x599d;
	__map_gbk2utf16[0x093a] = 0x599f;
	__map_gbk2utf16[0x093b] = 0x59a0;
	__map_gbk2utf16[0x093c] = 0x59a1;
	__map_gbk2utf16[0x093d] = 0x59a2;
	__map_gbk2utf16[0x093e] = 0x59a6;
	__map_gbk2utf16[0x0940] = 0x59a7;
	__map_gbk2utf16[0x0941] = 0x59ac;
	__map_gbk2utf16[0x0942] = 0x59ad;
	__map_gbk2utf16[0x0943] = 0x59b0;
	__map_gbk2utf16[0x0944] = 0x59b1;
	__map_gbk2utf16[0x0945] = 0x59b3;
	__map_gbk2utf16[0x0946] = 0x59b4;
	__map_gbk2utf16[0x0947] = 0x59b5;
	__map_gbk2utf16[0x0948] = 0x59b6;
	__map_gbk2utf16[0x0949] = 0x59b7;
	__map_gbk2utf16[0x094a] = 0x59b8;
	__map_gbk2utf16[0x094b] = 0x59ba;
	__map_gbk2utf16[0x094c] = 0x59bc;
	__map_gbk2utf16[0x094d] = 0x59bd;
	__map_gbk2utf16[0x094e] = 0x59bf;
	__map_gbk2utf16[0x094f] = 0x59c0;
	__map_gbk2utf16[0x0950] = 0x59c1;
	__map_gbk2utf16[0x0951] = 0x59c2;
	__map_gbk2utf16[0x0952] = 0x59c3;
	__map_gbk2utf16[0x0953] = 0x59c4;
	__map_gbk2utf16[0x0954] = 0x59c5;
	__map_gbk2utf16[0x0955] = 0x59c7;
	__map_gbk2utf16[0x0956] = 0x59c8;
	__map_gbk2utf16[0x0957] = 0x59c9;
	__map_gbk2utf16[0x0958] = 0x59cc;
	__map_gbk2utf16[0x0959] = 0x59cd;
	__map_gbk2utf16[0x095a] = 0x59ce;
	__map_gbk2utf16[0x095b] = 0x59cf;
	__map_gbk2utf16[0x095c] = 0x59d5;
	__map_gbk2utf16[0x095d] = 0x59d6;
	__map_gbk2utf16[0x095e] = 0x59d9;
	__map_gbk2utf16[0x095f] = 0x59db;
	__map_gbk2utf16[0x0960] = 0x59de;
	__map_gbk2utf16[0x0961] = 0x59df;
	__map_gbk2utf16[0x0962] = 0x59e0;
	__map_gbk2utf16[0x0963] = 0x59e1;
	__map_gbk2utf16[0x0964] = 0x59e2;
	__map_gbk2utf16[0x0965] = 0x59e4;
	__map_gbk2utf16[0x0966] = 0x59e6;
	__map_gbk2utf16[0x0967] = 0x59e7;
	__map_gbk2utf16[0x0968] = 0x59e9;
	__map_gbk2utf16[0x0969] = 0x59ea;
	__map_gbk2utf16[0x096a] = 0x59eb;
	__map_gbk2utf16[0x096b] = 0x59ed;
	__map_gbk2utf16[0x096c] = 0x59ee;
	__map_gbk2utf16[0x096d] = 0x59ef;
	__map_gbk2utf16[0x096e] = 0x59f0;
	__map_gbk2utf16[0x096f] = 0x59f1;
	__map_gbk2utf16[0x0970] = 0x59f2;
	__map_gbk2utf16[0x0971] = 0x59f3;
	__map_gbk2utf16[0x0972] = 0x59f4;
	__map_gbk2utf16[0x0973] = 0x59f5;
	__map_gbk2utf16[0x0974] = 0x59f6;
	__map_gbk2utf16[0x0975] = 0x59f7;
	__map_gbk2utf16[0x0976] = 0x59f8;
	__map_gbk2utf16[0x0977] = 0x59fa;
	__map_gbk2utf16[0x0978] = 0x59fc;
	__map_gbk2utf16[0x0979] = 0x59fd;
	__map_gbk2utf16[0x097a] = 0x59fe;
	__map_gbk2utf16[0x097b] = 0x5a00;
	__map_gbk2utf16[0x097c] = 0x5a02;
	__map_gbk2utf16[0x097d] = 0x5a0a;
	__map_gbk2utf16[0x097e] = 0x5a0b;
	__map_gbk2utf16[0x097f] = 0x5a0d;
	__map_gbk2utf16[0x0980] = 0x5a0e;
	__map_gbk2utf16[0x0981] = 0x5a0f;
	__map_gbk2utf16[0x0982] = 0x5a10;
	__map_gbk2utf16[0x0983] = 0x5a12;
	__map_gbk2utf16[0x0984] = 0x5a14;
	__map_gbk2utf16[0x0985] = 0x5a15;
	__map_gbk2utf16[0x0986] = 0x5a16;
	__map_gbk2utf16[0x0987] = 0x5a17;
	__map_gbk2utf16[0x0988] = 0x5a19;
	__map_gbk2utf16[0x0989] = 0x5a1a;
	__map_gbk2utf16[0x098a] = 0x5a1b;
	__map_gbk2utf16[0x098b] = 0x5a1d;
	__map_gbk2utf16[0x098c] = 0x5a1e;
	__map_gbk2utf16[0x098d] = 0x5a21;
	__map_gbk2utf16[0x098e] = 0x5a22;
	__map_gbk2utf16[0x098f] = 0x5a24;
	__map_gbk2utf16[0x0990] = 0x5a26;
	__map_gbk2utf16[0x0991] = 0x5a27;
	__map_gbk2utf16[0x0992] = 0x5a28;
	__map_gbk2utf16[0x0993] = 0x5a2a;
	__map_gbk2utf16[0x0994] = 0x5a2b;
	__map_gbk2utf16[0x0995] = 0x5a2c;
	__map_gbk2utf16[0x0996] = 0x5a2d;
	__map_gbk2utf16[0x0997] = 0x5a2e;
	__map_gbk2utf16[0x0998] = 0x5a2f;
	__map_gbk2utf16[0x0999] = 0x5a30;
	__map_gbk2utf16[0x099a] = 0x5a33;
	__map_gbk2utf16[0x099b] = 0x5a35;
	__map_gbk2utf16[0x099c] = 0x5a37;
	__map_gbk2utf16[0x099d] = 0x5a38;
	__map_gbk2utf16[0x099e] = 0x5a39;
	__map_gbk2utf16[0x099f] = 0x5a3a;
	__map_gbk2utf16[0x09a0] = 0x5a3b;
	__map_gbk2utf16[0x09a1] = 0x5a3d;
	__map_gbk2utf16[0x09a2] = 0x5a3e;
	__map_gbk2utf16[0x09a3] = 0x5a3f;
	__map_gbk2utf16[0x09a4] = 0x5a41;
	__map_gbk2utf16[0x09a5] = 0x5a42;
	__map_gbk2utf16[0x09a6] = 0x5a43;
	__map_gbk2utf16[0x09a7] = 0x5a44;
	__map_gbk2utf16[0x09a8] = 0x5a45;
	__map_gbk2utf16[0x09a9] = 0x5a47;
	__map_gbk2utf16[0x09aa] = 0x5a48;
	__map_gbk2utf16[0x09ab] = 0x5a4b;
	__map_gbk2utf16[0x09ac] = 0x5a4c;
	__map_gbk2utf16[0x09ad] = 0x5a4d;
	__map_gbk2utf16[0x09ae] = 0x5a4e;
	__map_gbk2utf16[0x09af] = 0x5a4f;
	__map_gbk2utf16[0x09b0] = 0x5a50;
	__map_gbk2utf16[0x09b1] = 0x5a51;
	__map_gbk2utf16[0x09b2] = 0x5a52;
	__map_gbk2utf16[0x09b3] = 0x5a53;
	__map_gbk2utf16[0x09b4] = 0x5a54;
	__map_gbk2utf16[0x09b5] = 0x5a56;
	__map_gbk2utf16[0x09b6] = 0x5a57;
	__map_gbk2utf16[0x09b7] = 0x5a58;
	__map_gbk2utf16[0x09b8] = 0x5a59;
	__map_gbk2utf16[0x09b9] = 0x5a5b;
	__map_gbk2utf16[0x09ba] = 0x5a5c;
	__map_gbk2utf16[0x09bb] = 0x5a5d;
	__map_gbk2utf16[0x09bc] = 0x5a5e;
	__map_gbk2utf16[0x09bd] = 0x5a5f;
	__map_gbk2utf16[0x09be] = 0x5a60;
	__map_gbk2utf16[0x0a00] = 0x5a61;
	__map_gbk2utf16[0x0a01] = 0x5a63;
	__map_gbk2utf16[0x0a02] = 0x5a64;
	__map_gbk2utf16[0x0a03] = 0x5a65;
	__map_gbk2utf16[0x0a04] = 0x5a66;
	__map_gbk2utf16[0x0a05] = 0x5a68;
	__map_gbk2utf16[0x0a06] = 0x5a69;
	__map_gbk2utf16[0x0a07] = 0x5a6b;
	__map_gbk2utf16[0x0a08] = 0x5a6c;
	__map_gbk2utf16[0x0a09] = 0x5a6d;
	__map_gbk2utf16[0x0a0a] = 0x5a6e;
	__map_gbk2utf16[0x0a0b] = 0x5a6f;
	__map_gbk2utf16[0x0a0c] = 0x5a70;
	__map_gbk2utf16[0x0a0d] = 0x5a71;
	__map_gbk2utf16[0x0a0e] = 0x5a72;
	__map_gbk2utf16[0x0a0f] = 0x5a73;
	__map_gbk2utf16[0x0a10] = 0x5a78;
	__map_gbk2utf16[0x0a11] = 0x5a79;
	__map_gbk2utf16[0x0a12] = 0x5a7b;
	__map_gbk2utf16[0x0a13] = 0x5a7c;
	__map_gbk2utf16[0x0a14] = 0x5a7d;
	__map_gbk2utf16[0x0a15] = 0x5a7e;
	__map_gbk2utf16[0x0a16] = 0x5a80;
	__map_gbk2utf16[0x0a17] = 0x5a81;
	__map_gbk2utf16[0x0a18] = 0x5a82;
	__map_gbk2utf16[0x0a19] = 0x5a83;
	__map_gbk2utf16[0x0a1a] = 0x5a84;
	__map_gbk2utf16[0x0a1b] = 0x5a85;
	__map_gbk2utf16[0x0a1c] = 0x5a86;
	__map_gbk2utf16[0x0a1d] = 0x5a87;
	__map_gbk2utf16[0x0a1e] = 0x5a88;
	__map_gbk2utf16[0x0a1f] = 0x5a89;
	__map_gbk2utf16[0x0a20] = 0x5a8a;
	__map_gbk2utf16[0x0a21] = 0x5a8b;
	__map_gbk2utf16[0x0a22] = 0x5a8c;
	__map_gbk2utf16[0x0a23] = 0x5a8d;
	__map_gbk2utf16[0x0a24] = 0x5a8e;
	__map_gbk2utf16[0x0a25] = 0x5a8f;
	__map_gbk2utf16[0x0a26] = 0x5a90;
	__map_gbk2utf16[0x0a27] = 0x5a91;
	__map_gbk2utf16[0x0a28] = 0x5a93;
	__map_gbk2utf16[0x0a29] = 0x5a94;
	__map_gbk2utf16[0x0a2a] = 0x5a95;
	__map_gbk2utf16[0x0a2b] = 0x5a96;
	__map_gbk2utf16[0x0a2c] = 0x5a97;
	__map_gbk2utf16[0x0a2d] = 0x5a98;
	__map_gbk2utf16[0x0a2e] = 0x5a99;
	__map_gbk2utf16[0x0a2f] = 0x5a9c;
	__map_gbk2utf16[0x0a30] = 0x5a9d;
	__map_gbk2utf16[0x0a31] = 0x5a9e;
	__map_gbk2utf16[0x0a32] = 0x5a9f;
	__map_gbk2utf16[0x0a33] = 0x5aa0;
	__map_gbk2utf16[0x0a34] = 0x5aa1;
	__map_gbk2utf16[0x0a35] = 0x5aa2;
	__map_gbk2utf16[0x0a36] = 0x5aa3;
	__map_gbk2utf16[0x0a37] = 0x5aa4;
	__map_gbk2utf16[0x0a38] = 0x5aa5;
	__map_gbk2utf16[0x0a39] = 0x5aa6;
	__map_gbk2utf16[0x0a3a] = 0x5aa7;
	__map_gbk2utf16[0x0a3b] = 0x5aa8;
	__map_gbk2utf16[0x0a3c] = 0x5aa9;
	__map_gbk2utf16[0x0a3d] = 0x5aab;
	__map_gbk2utf16[0x0a3e] = 0x5aac;
	__map_gbk2utf16[0x0a40] = 0x5aad;
	__map_gbk2utf16[0x0a41] = 0x5aae;
	__map_gbk2utf16[0x0a42] = 0x5aaf;
	__map_gbk2utf16[0x0a43] = 0x5ab0;
	__map_gbk2utf16[0x0a44] = 0x5ab1;
	__map_gbk2utf16[0x0a45] = 0x5ab4;
	__map_gbk2utf16[0x0a46] = 0x5ab6;
	__map_gbk2utf16[0x0a47] = 0x5ab7;
	__map_gbk2utf16[0x0a48] = 0x5ab9;
	__map_gbk2utf16[0x0a49] = 0x5aba;
	__map_gbk2utf16[0x0a4a] = 0x5abb;
	__map_gbk2utf16[0x0a4b] = 0x5abc;
	__map_gbk2utf16[0x0a4c] = 0x5abd;
	__map_gbk2utf16[0x0a4d] = 0x5abf;
	__map_gbk2utf16[0x0a4e] = 0x5ac0;
	__map_gbk2utf16[0x0a4f] = 0x5ac3;
	__map_gbk2utf16[0x0a50] = 0x5ac4;
	__map_gbk2utf16[0x0a51] = 0x5ac5;
	__map_gbk2utf16[0x0a52] = 0x5ac6;
	__map_gbk2utf16[0x0a53] = 0x5ac7;
	__map_gbk2utf16[0x0a54] = 0x5ac8;
	__map_gbk2utf16[0x0a55] = 0x5aca;
	__map_gbk2utf16[0x0a56] = 0x5acb;
	__map_gbk2utf16[0x0a57] = 0x5acd;
	__map_gbk2utf16[0x0a58] = 0x5ace;
	__map_gbk2utf16[0x0a59] = 0x5acf;
	__map_gbk2utf16[0x0a5a] = 0x5ad0;
	__map_gbk2utf16[0x0a5b] = 0x5ad1;
	__map_gbk2utf16[0x0a5c] = 0x5ad3;
	__map_gbk2utf16[0x0a5d] = 0x5ad5;
	__map_gbk2utf16[0x0a5e] = 0x5ad7;
	__map_gbk2utf16[0x0a5f] = 0x5ad9;
	__map_gbk2utf16[0x0a60] = 0x5ada;
	__map_gbk2utf16[0x0a61] = 0x5adb;
	__map_gbk2utf16[0x0a62] = 0x5add;
	__map_gbk2utf16[0x0a63] = 0x5ade;
	__map_gbk2utf16[0x0a64] = 0x5adf;
	__map_gbk2utf16[0x0a65] = 0x5ae2;
	__map_gbk2utf16[0x0a66] = 0x5ae4;
	__map_gbk2utf16[0x0a67] = 0x5ae5;
	__map_gbk2utf16[0x0a68] = 0x5ae7;
	__map_gbk2utf16[0x0a69] = 0x5ae8;
	__map_gbk2utf16[0x0a6a] = 0x5aea;
	__map_gbk2utf16[0x0a6b] = 0x5aec;
	__map_gbk2utf16[0x0a6c] = 0x5aed;
	__map_gbk2utf16[0x0a6d] = 0x5aee;
	__map_gbk2utf16[0x0a6e] = 0x5aef;
	__map_gbk2utf16[0x0a6f] = 0x5af0;
	__map_gbk2utf16[0x0a70] = 0x5af2;
	__map_gbk2utf16[0x0a71] = 0x5af3;
	__map_gbk2utf16[0x0a72] = 0x5af4;
	__map_gbk2utf16[0x0a73] = 0x5af5;
	__map_gbk2utf16[0x0a74] = 0x5af6;
	__map_gbk2utf16[0x0a75] = 0x5af7;
	__map_gbk2utf16[0x0a76] = 0x5af8;
	__map_gbk2utf16[0x0a77] = 0x5af9;
	__map_gbk2utf16[0x0a78] = 0x5afa;
	__map_gbk2utf16[0x0a79] = 0x5afb;
	__map_gbk2utf16[0x0a7a] = 0x5afc;
	__map_gbk2utf16[0x0a7b] = 0x5afd;
	__map_gbk2utf16[0x0a7c] = 0x5afe;
	__map_gbk2utf16[0x0a7d] = 0x5aff;
	__map_gbk2utf16[0x0a7e] = 0x5b00;
	__map_gbk2utf16[0x0a7f] = 0x5b01;
	__map_gbk2utf16[0x0a80] = 0x5b02;
	__map_gbk2utf16[0x0a81] = 0x5b03;
	__map_gbk2utf16[0x0a82] = 0x5b04;
	__map_gbk2utf16[0x0a83] = 0x5b05;
	__map_gbk2utf16[0x0a84] = 0x5b06;
	__map_gbk2utf16[0x0a85] = 0x5b07;
	__map_gbk2utf16[0x0a86] = 0x5b08;
	__map_gbk2utf16[0x0a87] = 0x5b0a;
	__map_gbk2utf16[0x0a88] = 0x5b0b;
	__map_gbk2utf16[0x0a89] = 0x5b0c;
	__map_gbk2utf16[0x0a8a] = 0x5b0d;
	__map_gbk2utf16[0x0a8b] = 0x5b0e;
	__map_gbk2utf16[0x0a8c] = 0x5b0f;
	__map_gbk2utf16[0x0a8d] = 0x5b10;
	__map_gbk2utf16[0x0a8e] = 0x5b11;
	__map_gbk2utf16[0x0a8f] = 0x5b12;
	__map_gbk2utf16[0x0a90] = 0x5b13;
	__map_gbk2utf16[0x0a91] = 0x5b14;
	__map_gbk2utf16[0x0a92] = 0x5b15;
	__map_gbk2utf16[0x0a93] = 0x5b18;
	__map_gbk2utf16[0x0a94] = 0x5b19;
	__map_gbk2utf16[0x0a95] = 0x5b1a;
	__map_gbk2utf16[0x0a96] = 0x5b1b;
	__map_gbk2utf16[0x0a97] = 0x5b1c;
	__map_gbk2utf16[0x0a98] = 0x5b1d;
	__map_gbk2utf16[0x0a99] = 0x5b1e;
	__map_gbk2utf16[0x0a9a] = 0x5b1f;
	__map_gbk2utf16[0x0a9b] = 0x5b20;
	__map_gbk2utf16[0x0a9c] = 0x5b21;
	__map_gbk2utf16[0x0a9d] = 0x5b22;
	__map_gbk2utf16[0x0a9e] = 0x5b23;
	__map_gbk2utf16[0x0a9f] = 0x5b24;
	__map_gbk2utf16[0x0aa0] = 0x5b25;
	__map_gbk2utf16[0x0aa1] = 0x5b26;
	__map_gbk2utf16[0x0aa2] = 0x5b27;
	__map_gbk2utf16[0x0aa3] = 0x5b28;
	__map_gbk2utf16[0x0aa4] = 0x5b29;
	__map_gbk2utf16[0x0aa5] = 0x5b2a;
	__map_gbk2utf16[0x0aa6] = 0x5b2b;
	__map_gbk2utf16[0x0aa7] = 0x5b2c;
	__map_gbk2utf16[0x0aa8] = 0x5b2d;
	__map_gbk2utf16[0x0aa9] = 0x5b2e;
	__map_gbk2utf16[0x0aaa] = 0x5b2f;
	__map_gbk2utf16[0x0aab] = 0x5b30;
	__map_gbk2utf16[0x0aac] = 0x5b31;
	__map_gbk2utf16[0x0aad] = 0x5b33;
	__map_gbk2utf16[0x0aae] = 0x5b35;
	__map_gbk2utf16[0x0aaf] = 0x5b36;
	__map_gbk2utf16[0x0ab0] = 0x5b38;
	__map_gbk2utf16[0x0ab1] = 0x5b39;
	__map_gbk2utf16[0x0ab2] = 0x5b3a;
	__map_gbk2utf16[0x0ab3] = 0x5b3b;
	__map_gbk2utf16[0x0ab4] = 0x5b3c;
	__map_gbk2utf16[0x0ab5] = 0x5b3d;
	__map_gbk2utf16[0x0ab6] = 0x5b3e;
	__map_gbk2utf16[0x0ab7] = 0x5b3f;
	__map_gbk2utf16[0x0ab8] = 0x5b41;
	__map_gbk2utf16[0x0ab9] = 0x5b42;
	__map_gbk2utf16[0x0aba] = 0x5b43;
	__map_gbk2utf16[0x0abb] = 0x5b44;
	__map_gbk2utf16[0x0abc] = 0x5b45;
	__map_gbk2utf16[0x0abd] = 0x5b46;
	__map_gbk2utf16[0x0abe] = 0x5b47;
	__map_gbk2utf16[0x0b00] = 0x5b48;
	__map_gbk2utf16[0x0b01] = 0x5b49;
	__map_gbk2utf16[0x0b02] = 0x5b4a;
	__map_gbk2utf16[0x0b03] = 0x5b4b;
	__map_gbk2utf16[0x0b04] = 0x5b4c;
	__map_gbk2utf16[0x0b05] = 0x5b4d;
	__map_gbk2utf16[0x0b06] = 0x5b4e;
	__map_gbk2utf16[0x0b07] = 0x5b4f;
	__map_gbk2utf16[0x0b08] = 0x5b52;
	__map_gbk2utf16[0x0b09] = 0x5b56;
	__map_gbk2utf16[0x0b0a] = 0x5b5e;
	__map_gbk2utf16[0x0b0b] = 0x5b60;
	__map_gbk2utf16[0x0b0c] = 0x5b61;
	__map_gbk2utf16[0x0b0d] = 0x5b67;
	__map_gbk2utf16[0x0b0e] = 0x5b68;
	__map_gbk2utf16[0x0b0f] = 0x5b6b;
	__map_gbk2utf16[0x0b10] = 0x5b6d;
	__map_gbk2utf16[0x0b11] = 0x5b6e;
	__map_gbk2utf16[0x0b12] = 0x5b6f;
	__map_gbk2utf16[0x0b13] = 0x5b72;
	__map_gbk2utf16[0x0b14] = 0x5b74;
	__map_gbk2utf16[0x0b15] = 0x5b76;
	__map_gbk2utf16[0x0b16] = 0x5b77;
	__map_gbk2utf16[0x0b17] = 0x5b78;
	__map_gbk2utf16[0x0b18] = 0x5b79;
	__map_gbk2utf16[0x0b19] = 0x5b7b;
	__map_gbk2utf16[0x0b1a] = 0x5b7c;
	__map_gbk2utf16[0x0b1b] = 0x5b7e;
	__map_gbk2utf16[0x0b1c] = 0x5b7f;
	__map_gbk2utf16[0x0b1d] = 0x5b82;
	__map_gbk2utf16[0x0b1e] = 0x5b86;
	__map_gbk2utf16[0x0b1f] = 0x5b8a;
	__map_gbk2utf16[0x0b20] = 0x5b8d;
	__map_gbk2utf16[0x0b21] = 0x5b8e;
	__map_gbk2utf16[0x0b22] = 0x5b90;
	__map_gbk2utf16[0x0b23] = 0x5b91;
	__map_gbk2utf16[0x0b24] = 0x5b92;
	__map_gbk2utf16[0x0b25] = 0x5b94;
	__map_gbk2utf16[0x0b26] = 0x5b96;
	__map_gbk2utf16[0x0b27] = 0x5b9f;
	__map_gbk2utf16[0x0b28] = 0x5ba7;
	__map_gbk2utf16[0x0b29] = 0x5ba8;
	__map_gbk2utf16[0x0b2a] = 0x5ba9;
	__map_gbk2utf16[0x0b2b] = 0x5bac;
	__map_gbk2utf16[0x0b2c] = 0x5bad;
	__map_gbk2utf16[0x0b2d] = 0x5bae;
	__map_gbk2utf16[0x0b2e] = 0x5baf;
	__map_gbk2utf16[0x0b2f] = 0x5bb1;
	__map_gbk2utf16[0x0b30] = 0x5bb2;
	__map_gbk2utf16[0x0b31] = 0x5bb7;
	__map_gbk2utf16[0x0b32] = 0x5bba;
	__map_gbk2utf16[0x0b33] = 0x5bbb;
	__map_gbk2utf16[0x0b34] = 0x5bbc;
	__map_gbk2utf16[0x0b35] = 0x5bc0;
	__map_gbk2utf16[0x0b36] = 0x5bc1;
	__map_gbk2utf16[0x0b37] = 0x5bc3;
	__map_gbk2utf16[0x0b38] = 0x5bc8;
	__map_gbk2utf16[0x0b39] = 0x5bc9;
	__map_gbk2utf16[0x0b3a] = 0x5bca;
	__map_gbk2utf16[0x0b3b] = 0x5bcb;
	__map_gbk2utf16[0x0b3c] = 0x5bcd;
	__map_gbk2utf16[0x0b3d] = 0x5bce;
	__map_gbk2utf16[0x0b3e] = 0x5bcf;
	__map_gbk2utf16[0x0b40] = 0x5bd1;
	__map_gbk2utf16[0x0b41] = 0x5bd4;
	__map_gbk2utf16[0x0b42] = 0x5bd5;
	__map_gbk2utf16[0x0b43] = 0x5bd6;
	__map_gbk2utf16[0x0b44] = 0x5bd7;
	__map_gbk2utf16[0x0b45] = 0x5bd8;
	__map_gbk2utf16[0x0b46] = 0x5bd9;
	__map_gbk2utf16[0x0b47] = 0x5bda;
	__map_gbk2utf16[0x0b48] = 0x5bdb;
	__map_gbk2utf16[0x0b49] = 0x5bdc;
	__map_gbk2utf16[0x0b4a] = 0x5be0;
	__map_gbk2utf16[0x0b4b] = 0x5be2;
	__map_gbk2utf16[0x0b4c] = 0x5be3;
	__map_gbk2utf16[0x0b4d] = 0x5be6;
	__map_gbk2utf16[0x0b4e] = 0x5be7;
	__map_gbk2utf16[0x0b4f] = 0x5be9;
	__map_gbk2utf16[0x0b50] = 0x5bea;
	__map_gbk2utf16[0x0b51] = 0x5beb;
	__map_gbk2utf16[0x0b52] = 0x5bec;
	__map_gbk2utf16[0x0b53] = 0x5bed;
	__map_gbk2utf16[0x0b54] = 0x5bef;
	__map_gbk2utf16[0x0b55] = 0x5bf1;
	__map_gbk2utf16[0x0b56] = 0x5bf2;
	__map_gbk2utf16[0x0b57] = 0x5bf3;
	__map_gbk2utf16[0x0b58] = 0x5bf4;
	__map_gbk2utf16[0x0b59] = 0x5bf5;
	__map_gbk2utf16[0x0b5a] = 0x5bf6;
	__map_gbk2utf16[0x0b5b] = 0x5bf7;
	__map_gbk2utf16[0x0b5c] = 0x5bfd;
	__map_gbk2utf16[0x0b5d] = 0x5bfe;
	__map_gbk2utf16[0x0b5e] = 0x5c00;
	__map_gbk2utf16[0x0b5f] = 0x5c02;
	__map_gbk2utf16[0x0b60] = 0x5c03;
	__map_gbk2utf16[0x0b61] = 0x5c05;
	__map_gbk2utf16[0x0b62] = 0x5c07;
	__map_gbk2utf16[0x0b63] = 0x5c08;
	__map_gbk2utf16[0x0b64] = 0x5c0b;
	__map_gbk2utf16[0x0b65] = 0x5c0c;
	__map_gbk2utf16[0x0b66] = 0x5c0d;
	__map_gbk2utf16[0x0b67] = 0x5c0e;
	__map_gbk2utf16[0x0b68] = 0x5c10;
	__map_gbk2utf16[0x0b69] = 0x5c12;
	__map_gbk2utf16[0x0b6a] = 0x5c13;
	__map_gbk2utf16[0x0b6b] = 0x5c17;
	__map_gbk2utf16[0x0b6c] = 0x5c19;
	__map_gbk2utf16[0x0b6d] = 0x5c1b;
	__map_gbk2utf16[0x0b6e] = 0x5c1e;
	__map_gbk2utf16[0x0b6f] = 0x5c1f;
	__map_gbk2utf16[0x0b70] = 0x5c20;
	__map_gbk2utf16[0x0b71] = 0x5c21;
	__map_gbk2utf16[0x0b72] = 0x5c23;
	__map_gbk2utf16[0x0b73] = 0x5c26;
	__map_gbk2utf16[0x0b74] = 0x5c28;
	__map_gbk2utf16[0x0b75] = 0x5c29;
	__map_gbk2utf16[0x0b76] = 0x5c2a;
	__map_gbk2utf16[0x0b77] = 0x5c2b;
	__map_gbk2utf16[0x0b78] = 0x5c2d;
	__map_gbk2utf16[0x0b79] = 0x5c2e;
	__map_gbk2utf16[0x0b7a] = 0x5c2f;
	__map_gbk2utf16[0x0b7b] = 0x5c30;
	__map_gbk2utf16[0x0b7c] = 0x5c32;
	__map_gbk2utf16[0x0b7d] = 0x5c33;
	__map_gbk2utf16[0x0b7e] = 0x5c35;
	__map_gbk2utf16[0x0b7f] = 0x5c36;
	__map_gbk2utf16[0x0b80] = 0x5c37;
	__map_gbk2utf16[0x0b81] = 0x5c43;
	__map_gbk2utf16[0x0b82] = 0x5c44;
	__map_gbk2utf16[0x0b83] = 0x5c46;
	__map_gbk2utf16[0x0b84] = 0x5c47;
	__map_gbk2utf16[0x0b85] = 0x5c4c;
	__map_gbk2utf16[0x0b86] = 0x5c4d;
	__map_gbk2utf16[0x0b87] = 0x5c52;
	__map_gbk2utf16[0x0b88] = 0x5c53;
	__map_gbk2utf16[0x0b89] = 0x5c54;
	__map_gbk2utf16[0x0b8a] = 0x5c56;
	__map_gbk2utf16[0x0b8b] = 0x5c57;
	__map_gbk2utf16[0x0b8c] = 0x5c58;
	__map_gbk2utf16[0x0b8d] = 0x5c5a;
	__map_gbk2utf16[0x0b8e] = 0x5c5b;
	__map_gbk2utf16[0x0b8f] = 0x5c5c;
	__map_gbk2utf16[0x0b90] = 0x5c5d;
	__map_gbk2utf16[0x0b91] = 0x5c5f;
	__map_gbk2utf16[0x0b92] = 0x5c62;
	__map_gbk2utf16[0x0b93] = 0x5c64;
	__map_gbk2utf16[0x0b94] = 0x5c67;
	__map_gbk2utf16[0x0b95] = 0x5c68;
	__map_gbk2utf16[0x0b96] = 0x5c69;
	__map_gbk2utf16[0x0b97] = 0x5c6a;
	__map_gbk2utf16[0x0b98] = 0x5c6b;
	__map_gbk2utf16[0x0b99] = 0x5c6c;
	__map_gbk2utf16[0x0b9a] = 0x5c6d;
	__map_gbk2utf16[0x0b9b] = 0x5c70;
	__map_gbk2utf16[0x0b9c] = 0x5c72;
	__map_gbk2utf16[0x0b9d] = 0x5c73;
	__map_gbk2utf16[0x0b9e] = 0x5c74;
	__map_gbk2utf16[0x0b9f] = 0x5c75;
	__map_gbk2utf16[0x0ba0] = 0x5c76;
	__map_gbk2utf16[0x0ba1] = 0x5c77;
	__map_gbk2utf16[0x0ba2] = 0x5c78;
	__map_gbk2utf16[0x0ba3] = 0x5c7b;
	__map_gbk2utf16[0x0ba4] = 0x5c7c;
	__map_gbk2utf16[0x0ba5] = 0x5c7d;
	__map_gbk2utf16[0x0ba6] = 0x5c7e;
	__map_gbk2utf16[0x0ba7] = 0x5c80;
	__map_gbk2utf16[0x0ba8] = 0x5c83;
	__map_gbk2utf16[0x0ba9] = 0x5c84;
	__map_gbk2utf16[0x0baa] = 0x5c85;
	__map_gbk2utf16[0x0bab] = 0x5c86;
	__map_gbk2utf16[0x0bac] = 0x5c87;
	__map_gbk2utf16[0x0bad] = 0x5c89;
	__map_gbk2utf16[0x0bae] = 0x5c8a;
	__map_gbk2utf16[0x0baf] = 0x5c8b;
	__map_gbk2utf16[0x0bb0] = 0x5c8e;
	__map_gbk2utf16[0x0bb1] = 0x5c8f;
	__map_gbk2utf16[0x0bb2] = 0x5c92;
	__map_gbk2utf16[0x0bb3] = 0x5c93;
	__map_gbk2utf16[0x0bb4] = 0x5c95;
	__map_gbk2utf16[0x0bb5] = 0x5c9d;
	__map_gbk2utf16[0x0bb6] = 0x5c9e;
	__map_gbk2utf16[0x0bb7] = 0x5c9f;
	__map_gbk2utf16[0x0bb8] = 0x5ca0;
	__map_gbk2utf16[0x0bb9] = 0x5ca1;
	__map_gbk2utf16[0x0bba] = 0x5ca4;
	__map_gbk2utf16[0x0bbb] = 0x5ca5;
	__map_gbk2utf16[0x0bbc] = 0x5ca6;
	__map_gbk2utf16[0x0bbd] = 0x5ca7;
	__map_gbk2utf16[0x0bbe] = 0x5ca8;
	__map_gbk2utf16[0x0c00] = 0x5caa;
	__map_gbk2utf16[0x0c01] = 0x5cae;
	__map_gbk2utf16[0x0c02] = 0x5caf;
	__map_gbk2utf16[0x0c03] = 0x5cb0;
	__map_gbk2utf16[0x0c04] = 0x5cb2;
	__map_gbk2utf16[0x0c05] = 0x5cb4;
	__map_gbk2utf16[0x0c06] = 0x5cb6;
	__map_gbk2utf16[0x0c07] = 0x5cb9;
	__map_gbk2utf16[0x0c08] = 0x5cba;
	__map_gbk2utf16[0x0c09] = 0x5cbb;
	__map_gbk2utf16[0x0c0a] = 0x5cbc;
	__map_gbk2utf16[0x0c0b] = 0x5cbe;
	__map_gbk2utf16[0x0c0c] = 0x5cc0;
	__map_gbk2utf16[0x0c0d] = 0x5cc2;
	__map_gbk2utf16[0x0c0e] = 0x5cc3;
	__map_gbk2utf16[0x0c0f] = 0x5cc5;
	__map_gbk2utf16[0x0c10] = 0x5cc6;
	__map_gbk2utf16[0x0c11] = 0x5cc7;
	__map_gbk2utf16[0x0c12] = 0x5cc8;
	__map_gbk2utf16[0x0c13] = 0x5cc9;
	__map_gbk2utf16[0x0c14] = 0x5cca;
	__map_gbk2utf16[0x0c15] = 0x5ccc;
	__map_gbk2utf16[0x0c16] = 0x5ccd;
	__map_gbk2utf16[0x0c17] = 0x5cce;
	__map_gbk2utf16[0x0c18] = 0x5ccf;
	__map_gbk2utf16[0x0c19] = 0x5cd0;
	__map_gbk2utf16[0x0c1a] = 0x5cd1;
	__map_gbk2utf16[0x0c1b] = 0x5cd3;
	__map_gbk2utf16[0x0c1c] = 0x5cd4;
	__map_gbk2utf16[0x0c1d] = 0x5cd5;
	__map_gbk2utf16[0x0c1e] = 0x5cd6;
	__map_gbk2utf16[0x0c1f] = 0x5cd7;
	__map_gbk2utf16[0x0c20] = 0x5cd8;
	__map_gbk2utf16[0x0c21] = 0x5cda;
	__map_gbk2utf16[0x0c22] = 0x5cdb;
	__map_gbk2utf16[0x0c23] = 0x5cdc;
	__map_gbk2utf16[0x0c24] = 0x5cdd;
	__map_gbk2utf16[0x0c25] = 0x5cde;
	__map_gbk2utf16[0x0c26] = 0x5cdf;
	__map_gbk2utf16[0x0c27] = 0x5ce0;
	__map_gbk2utf16[0x0c28] = 0x5ce2;
	__map_gbk2utf16[0x0c29] = 0x5ce3;
	__map_gbk2utf16[0x0c2a] = 0x5ce7;
	__map_gbk2utf16[0x0c2b] = 0x5ce9;
	__map_gbk2utf16[0x0c2c] = 0x5ceb;
	__map_gbk2utf16[0x0c2d] = 0x5cec;
	__map_gbk2utf16[0x0c2e] = 0x5cee;
	__map_gbk2utf16[0x0c2f] = 0x5cef;
	__map_gbk2utf16[0x0c30] = 0x5cf1;
	__map_gbk2utf16[0x0c31] = 0x5cf2;
	__map_gbk2utf16[0x0c32] = 0x5cf3;
	__map_gbk2utf16[0x0c33] = 0x5cf4;
	__map_gbk2utf16[0x0c34] = 0x5cf5;
	__map_gbk2utf16[0x0c35] = 0x5cf6;
	__map_gbk2utf16[0x0c36] = 0x5cf7;
	__map_gbk2utf16[0x0c37] = 0x5cf8;
	__map_gbk2utf16[0x0c38] = 0x5cf9;
	__map_gbk2utf16[0x0c39] = 0x5cfa;
	__map_gbk2utf16[0x0c3a] = 0x5cfc;
	__map_gbk2utf16[0x0c3b] = 0x5cfd;
	__map_gbk2utf16[0x0c3c] = 0x5cfe;
	__map_gbk2utf16[0x0c3d] = 0x5cff;
	__map_gbk2utf16[0x0c3e] = 0x5d00;
	__map_gbk2utf16[0x0c40] = 0x5d01;
	__map_gbk2utf16[0x0c41] = 0x5d04;
	__map_gbk2utf16[0x0c42] = 0x5d05;
	__map_gbk2utf16[0x0c43] = 0x5d08;
	__map_gbk2utf16[0x0c44] = 0x5d09;
	__map_gbk2utf16[0x0c45] = 0x5d0a;
	__map_gbk2utf16[0x0c46] = 0x5d0b;
	__map_gbk2utf16[0x0c47] = 0x5d0c;
	__map_gbk2utf16[0x0c48] = 0x5d0d;
	__map_gbk2utf16[0x0c49] = 0x5d0f;
	__map_gbk2utf16[0x0c4a] = 0x5d10;
	__map_gbk2utf16[0x0c4b] = 0x5d11;
	__map_gbk2utf16[0x0c4c] = 0x5d12;
	__map_gbk2utf16[0x0c4d] = 0x5d13;
	__map_gbk2utf16[0x0c4e] = 0x5d15;
	__map_gbk2utf16[0x0c4f] = 0x5d17;
	__map_gbk2utf16[0x0c50] = 0x5d18;
	__map_gbk2utf16[0x0c51] = 0x5d19;
	__map_gbk2utf16[0x0c52] = 0x5d1a;
	__map_gbk2utf16[0x0c53] = 0x5d1c;
	__map_gbk2utf16[0x0c54] = 0x5d1d;
	__map_gbk2utf16[0x0c55] = 0x5d1f;
	__map_gbk2utf16[0x0c56] = 0x5d20;
	__map_gbk2utf16[0x0c57] = 0x5d21;
	__map_gbk2utf16[0x0c58] = 0x5d22;
	__map_gbk2utf16[0x0c59] = 0x5d23;
	__map_gbk2utf16[0x0c5a] = 0x5d25;
	__map_gbk2utf16[0x0c5b] = 0x5d28;
	__map_gbk2utf16[0x0c5c] = 0x5d2a;
	__map_gbk2utf16[0x0c5d] = 0x5d2b;
	__map_gbk2utf16[0x0c5e] = 0x5d2c;
	__map_gbk2utf16[0x0c5f] = 0x5d2f;
	__map_gbk2utf16[0x0c60] = 0x5d30;
	__map_gbk2utf16[0x0c61] = 0x5d31;
	__map_gbk2utf16[0x0c62] = 0x5d32;
	__map_gbk2utf16[0x0c63] = 0x5d33;
	__map_gbk2utf16[0x0c64] = 0x5d35;
	__map_gbk2utf16[0x0c65] = 0x5d36;
	__map_gbk2utf16[0x0c66] = 0x5d37;
	__map_gbk2utf16[0x0c67] = 0x5d38;
	__map_gbk2utf16[0x0c68] = 0x5d39;
	__map_gbk2utf16[0x0c69] = 0x5d3a;
	__map_gbk2utf16[0x0c6a] = 0x5d3b;
	__map_gbk2utf16[0x0c6b] = 0x5d3c;
	__map_gbk2utf16[0x0c6c] = 0x5d3f;
	__map_gbk2utf16[0x0c6d] = 0x5d40;
	__map_gbk2utf16[0x0c6e] = 0x5d41;
	__map_gbk2utf16[0x0c6f] = 0x5d42;
	__map_gbk2utf16[0x0c70] = 0x5d43;
	__map_gbk2utf16[0x0c71] = 0x5d44;
	__map_gbk2utf16[0x0c72] = 0x5d45;
	__map_gbk2utf16[0x0c73] = 0x5d46;
	__map_gbk2utf16[0x0c74] = 0x5d48;
	__map_gbk2utf16[0x0c75] = 0x5d49;
	__map_gbk2utf16[0x0c76] = 0x5d4d;
	__map_gbk2utf16[0x0c77] = 0x5d4e;
	__map_gbk2utf16[0x0c78] = 0x5d4f;
	__map_gbk2utf16[0x0c79] = 0x5d50;
	__map_gbk2utf16[0x0c7a] = 0x5d51;
	__map_gbk2utf16[0x0c7b] = 0x5d52;
	__map_gbk2utf16[0x0c7c] = 0x5d53;
	__map_gbk2utf16[0x0c7d] = 0x5d54;
	__map_gbk2utf16[0x0c7e] = 0x5d55;
	__map_gbk2utf16[0x0c7f] = 0x5d56;
	__map_gbk2utf16[0x0c80] = 0x5d57;
	__map_gbk2utf16[0x0c81] = 0x5d59;
	__map_gbk2utf16[0x0c82] = 0x5d5a;
	__map_gbk2utf16[0x0c83] = 0x5d5c;
	__map_gbk2utf16[0x0c84] = 0x5d5e;
	__map_gbk2utf16[0x0c85] = 0x5d5f;
	__map_gbk2utf16[0x0c86] = 0x5d60;
	__map_gbk2utf16[0x0c87] = 0x5d61;
	__map_gbk2utf16[0x0c88] = 0x5d62;
	__map_gbk2utf16[0x0c89] = 0x5d63;
	__map_gbk2utf16[0x0c8a] = 0x5d64;
	__map_gbk2utf16[0x0c8b] = 0x5d65;
	__map_gbk2utf16[0x0c8c] = 0x5d66;
	__map_gbk2utf16[0x0c8d] = 0x5d67;
	__map_gbk2utf16[0x0c8e] = 0x5d68;
	__map_gbk2utf16[0x0c8f] = 0x5d6a;
	__map_gbk2utf16[0x0c90] = 0x5d6d;
	__map_gbk2utf16[0x0c91] = 0x5d6e;
	__map_gbk2utf16[0x0c92] = 0x5d70;
	__map_gbk2utf16[0x0c93] = 0x5d71;
	__map_gbk2utf16[0x0c94] = 0x5d72;
	__map_gbk2utf16[0x0c95] = 0x5d73;
	__map_gbk2utf16[0x0c96] = 0x5d75;
	__map_gbk2utf16[0x0c97] = 0x5d76;
	__map_gbk2utf16[0x0c98] = 0x5d77;
	__map_gbk2utf16[0x0c99] = 0x5d78;
	__map_gbk2utf16[0x0c9a] = 0x5d79;
	__map_gbk2utf16[0x0c9b] = 0x5d7a;
	__map_gbk2utf16[0x0c9c] = 0x5d7b;
	__map_gbk2utf16[0x0c9d] = 0x5d7c;
	__map_gbk2utf16[0x0c9e] = 0x5d7d;
	__map_gbk2utf16[0x0c9f] = 0x5d7e;
	__map_gbk2utf16[0x0ca0] = 0x5d7f;
	__map_gbk2utf16[0x0ca1] = 0x5d80;
	__map_gbk2utf16[0x0ca2] = 0x5d81;
	__map_gbk2utf16[0x0ca3] = 0x5d83;
	__map_gbk2utf16[0x0ca4] = 0x5d84;
	__map_gbk2utf16[0x0ca5] = 0x5d85;
	__map_gbk2utf16[0x0ca6] = 0x5d86;
	__map_gbk2utf16[0x0ca7] = 0x5d87;
	__map_gbk2utf16[0x0ca8] = 0x5d88;
	__map_gbk2utf16[0x0ca9] = 0x5d89;
	__map_gbk2utf16[0x0caa] = 0x5d8a;
	__map_gbk2utf16[0x0cab] = 0x5d8b;
	__map_gbk2utf16[0x0cac] = 0x5d8c;
	__map_gbk2utf16[0x0cad] = 0x5d8d;
	__map_gbk2utf16[0x0cae] = 0x5d8e;
	__map_gbk2utf16[0x0caf] = 0x5d8f;
	__map_gbk2utf16[0x0cb0] = 0x5d90;
	__map_gbk2utf16[0x0cb1] = 0x5d91;
	__map_gbk2utf16[0x0cb2] = 0x5d92;
	__map_gbk2utf16[0x0cb3] = 0x5d93;
	__map_gbk2utf16[0x0cb4] = 0x5d94;
	__map_gbk2utf16[0x0cb5] = 0x5d95;
	__map_gbk2utf16[0x0cb6] = 0x5d96;
	__map_gbk2utf16[0x0cb7] = 0x5d97;
	__map_gbk2utf16[0x0cb8] = 0x5d98;
	__map_gbk2utf16[0x0cb9] = 0x5d9a;
	__map_gbk2utf16[0x0cba] = 0x5d9b;
	__map_gbk2utf16[0x0cbb] = 0x5d9c;
	__map_gbk2utf16[0x0cbc] = 0x5d9e;
	__map_gbk2utf16[0x0cbd] = 0x5d9f;
	__map_gbk2utf16[0x0cbe] = 0x5da0;
	__map_gbk2utf16[0x0d00] = 0x5da1;
	__map_gbk2utf16[0x0d01] = 0x5da2;
	__map_gbk2utf16[0x0d02] = 0x5da3;
	__map_gbk2utf16[0x0d03] = 0x5da4;
	__map_gbk2utf16[0x0d04] = 0x5da5;
	__map_gbk2utf16[0x0d05] = 0x5da6;
	__map_gbk2utf16[0x0d06] = 0x5da7;
	__map_gbk2utf16[0x0d07] = 0x5da8;
	__map_gbk2utf16[0x0d08] = 0x5da9;
	__map_gbk2utf16[0x0d09] = 0x5daa;
	__map_gbk2utf16[0x0d0a] = 0x5dab;
	__map_gbk2utf16[0x0d0b] = 0x5dac;
	__map_gbk2utf16[0x0d0c] = 0x5dad;
	__map_gbk2utf16[0x0d0d] = 0x5dae;
	__map_gbk2utf16[0x0d0e] = 0x5daf;
	__map_gbk2utf16[0x0d0f] = 0x5db0;
	__map_gbk2utf16[0x0d10] = 0x5db1;
	__map_gbk2utf16[0x0d11] = 0x5db2;
	__map_gbk2utf16[0x0d12] = 0x5db3;
	__map_gbk2utf16[0x0d13] = 0x5db4;
	__map_gbk2utf16[0x0d14] = 0x5db5;
	__map_gbk2utf16[0x0d15] = 0x5db6;
	__map_gbk2utf16[0x0d16] = 0x5db8;
	__map_gbk2utf16[0x0d17] = 0x5db9;
	__map_gbk2utf16[0x0d18] = 0x5dba;
	__map_gbk2utf16[0x0d19] = 0x5dbb;
	__map_gbk2utf16[0x0d1a] = 0x5dbc;
	__map_gbk2utf16[0x0d1b] = 0x5dbd;
	__map_gbk2utf16[0x0d1c] = 0x5dbe;
	__map_gbk2utf16[0x0d1d] = 0x5dbf;
	__map_gbk2utf16[0x0d1e] = 0x5dc0;
	__map_gbk2utf16[0x0d1f] = 0x5dc1;
	__map_gbk2utf16[0x0d20] = 0x5dc2;
	__map_gbk2utf16[0x0d21] = 0x5dc3;
	__map_gbk2utf16[0x0d22] = 0x5dc4;
	__map_gbk2utf16[0x0d23] = 0x5dc6;
	__map_gbk2utf16[0x0d24] = 0x5dc7;
	__map_gbk2utf16[0x0d25] = 0x5dc8;
	__map_gbk2utf16[0x0d26] = 0x5dc9;
	__map_gbk2utf16[0x0d27] = 0x5dca;
	__map_gbk2utf16[0x0d28] = 0x5dcb;
	__map_gbk2utf16[0x0d29] = 0x5dcc;
	__map_gbk2utf16[0x0d2a] = 0x5dce;
	__map_gbk2utf16[0x0d2b] = 0x5dcf;
	__map_gbk2utf16[0x0d2c] = 0x5dd0;
	__map_gbk2utf16[0x0d2d] = 0x5dd1;
	__map_gbk2utf16[0x0d2e] = 0x5dd2;
	__map_gbk2utf16[0x0d2f] = 0x5dd3;
	__map_gbk2utf16[0x0d30] = 0x5dd4;
	__map_gbk2utf16[0x0d31] = 0x5dd5;
	__map_gbk2utf16[0x0d32] = 0x5dd6;
	__map_gbk2utf16[0x0d33] = 0x5dd7;
	__map_gbk2utf16[0x0d34] = 0x5dd8;
	__map_gbk2utf16[0x0d35] = 0x5dd9;
	__map_gbk2utf16[0x0d36] = 0x5dda;
	__map_gbk2utf16[0x0d37] = 0x5ddc;
	__map_gbk2utf16[0x0d38] = 0x5ddf;
	__map_gbk2utf16[0x0d39] = 0x5de0;
	__map_gbk2utf16[0x0d3a] = 0x5de3;
	__map_gbk2utf16[0x0d3b] = 0x5de4;
	__map_gbk2utf16[0x0d3c] = 0x5dea;
	__map_gbk2utf16[0x0d3d] = 0x5dec;
	__map_gbk2utf16[0x0d3e] = 0x5ded;
	__map_gbk2utf16[0x0d40] = 0x5df0;
	__map_gbk2utf16[0x0d41] = 0x5df5;
	__map_gbk2utf16[0x0d42] = 0x5df6;
	__map_gbk2utf16[0x0d43] = 0x5df8;
	__map_gbk2utf16[0x0d44] = 0x5df9;
	__map_gbk2utf16[0x0d45] = 0x5dfa;
	__map_gbk2utf16[0x0d46] = 0x5dfb;
	__map_gbk2utf16[0x0d47] = 0x5dfc;
	__map_gbk2utf16[0x0d48] = 0x5dff;
	__map_gbk2utf16[0x0d49] = 0x5e00;
	__map_gbk2utf16[0x0d4a] = 0x5e04;
	__map_gbk2utf16[0x0d4b] = 0x5e07;
	__map_gbk2utf16[0x0d4c] = 0x5e09;
	__map_gbk2utf16[0x0d4d] = 0x5e0a;
	__map_gbk2utf16[0x0d4e] = 0x5e0b;
	__map_gbk2utf16[0x0d4f] = 0x5e0d;
	__map_gbk2utf16[0x0d50] = 0x5e0e;
	__map_gbk2utf16[0x0d51] = 0x5e12;
	__map_gbk2utf16[0x0d52] = 0x5e13;
	__map_gbk2utf16[0x0d53] = 0x5e17;
	__map_gbk2utf16[0x0d54] = 0x5e1e;
	__map_gbk2utf16[0x0d55] = 0x5e1f;
	__map_gbk2utf16[0x0d56] = 0x5e20;
	__map_gbk2utf16[0x0d57] = 0x5e21;
	__map_gbk2utf16[0x0d58] = 0x5e22;
	__map_gbk2utf16[0x0d59] = 0x5e23;
	__map_gbk2utf16[0x0d5a] = 0x5e24;
	__map_gbk2utf16[0x0d5b] = 0x5e25;
	__map_gbk2utf16[0x0d5c] = 0x5e28;
	__map_gbk2utf16[0x0d5d] = 0x5e29;
	__map_gbk2utf16[0x0d5e] = 0x5e2a;
	__map_gbk2utf16[0x0d5f] = 0x5e2b;
	__map_gbk2utf16[0x0d60] = 0x5e2c;
	__map_gbk2utf16[0x0d61] = 0x5e2f;
	__map_gbk2utf16[0x0d62] = 0x5e30;
	__map_gbk2utf16[0x0d63] = 0x5e32;
	__map_gbk2utf16[0x0d64] = 0x5e33;
	__map_gbk2utf16[0x0d65] = 0x5e34;
	__map_gbk2utf16[0x0d66] = 0x5e35;
	__map_gbk2utf16[0x0d67] = 0x5e36;
	__map_gbk2utf16[0x0d68] = 0x5e39;
	__map_gbk2utf16[0x0d69] = 0x5e3a;
	__map_gbk2utf16[0x0d6a] = 0x5e3e;
	__map_gbk2utf16[0x0d6b] = 0x5e3f;
	__map_gbk2utf16[0x0d6c] = 0x5e40;
	__map_gbk2utf16[0x0d6d] = 0x5e41;
	__map_gbk2utf16[0x0d6e] = 0x5e43;
	__map_gbk2utf16[0x0d6f] = 0x5e46;
	__map_gbk2utf16[0x0d70] = 0x5e47;
	__map_gbk2utf16[0x0d71] = 0x5e48;
	__map_gbk2utf16[0x0d72] = 0x5e49;
	__map_gbk2utf16[0x0d73] = 0x5e4a;
	__map_gbk2utf16[0x0d74] = 0x5e4b;
	__map_gbk2utf16[0x0d75] = 0x5e4d;
	__map_gbk2utf16[0x0d76] = 0x5e4e;
	__map_gbk2utf16[0x0d77] = 0x5e4f;
	__map_gbk2utf16[0x0d78] = 0x5e50;
	__map_gbk2utf16[0x0d79] = 0x5e51;
	__map_gbk2utf16[0x0d7a] = 0x5e52;
	__map_gbk2utf16[0x0d7b] = 0x5e53;
	__map_gbk2utf16[0x0d7c] = 0x5e56;
	__map_gbk2utf16[0x0d7d] = 0x5e57;
	__map_gbk2utf16[0x0d7e] = 0x5e58;
	__map_gbk2utf16[0x0d7f] = 0x5e59;
	__map_gbk2utf16[0x0d80] = 0x5e5a;
	__map_gbk2utf16[0x0d81] = 0x5e5c;
	__map_gbk2utf16[0x0d82] = 0x5e5d;
	__map_gbk2utf16[0x0d83] = 0x5e5f;
	__map_gbk2utf16[0x0d84] = 0x5e60;
	__map_gbk2utf16[0x0d85] = 0x5e63;
	__map_gbk2utf16[0x0d86] = 0x5e64;
	__map_gbk2utf16[0x0d87] = 0x5e65;
	__map_gbk2utf16[0x0d88] = 0x5e66;
	__map_gbk2utf16[0x0d89] = 0x5e67;
	__map_gbk2utf16[0x0d8a] = 0x5e68;
	__map_gbk2utf16[0x0d8b] = 0x5e69;
	__map_gbk2utf16[0x0d8c] = 0x5e6a;
	__map_gbk2utf16[0x0d8d] = 0x5e6b;
	__map_gbk2utf16[0x0d8e] = 0x5e6c;
	__map_gbk2utf16[0x0d8f] = 0x5e6d;
	__map_gbk2utf16[0x0d90] = 0x5e6e;
	__map_gbk2utf16[0x0d91] = 0x5e6f;
	__map_gbk2utf16[0x0d92] = 0x5e70;
	__map_gbk2utf16[0x0d93] = 0x5e71;
	__map_gbk2utf16[0x0d94] = 0x5e75;
	__map_gbk2utf16[0x0d95] = 0x5e77;
	__map_gbk2utf16[0x0d96] = 0x5e79;
	__map_gbk2utf16[0x0d97] = 0x5e7e;
	__map_gbk2utf16[0x0d98] = 0x5e81;
	__map_gbk2utf16[0x0d99] = 0x5e82;
	__map_gbk2utf16[0x0d9a] = 0x5e83;
	__map_gbk2utf16[0x0d9b] = 0x5e85;
	__map_gbk2utf16[0x0d9c] = 0x5e88;
	__map_gbk2utf16[0x0d9d] = 0x5e89;
	__map_gbk2utf16[0x0d9e] = 0x5e8c;
	__map_gbk2utf16[0x0d9f] = 0x5e8d;
	__map_gbk2utf16[0x0da0] = 0x5e8e;
	__map_gbk2utf16[0x0da1] = 0x5e92;
	__map_gbk2utf16[0x0da2] = 0x5e98;
	__map_gbk2utf16[0x0da3] = 0x5e9b;
	__map_gbk2utf16[0x0da4] = 0x5e9d;
	__map_gbk2utf16[0x0da5] = 0x5ea1;
	__map_gbk2utf16[0x0da6] = 0x5ea2;
	__map_gbk2utf16[0x0da7] = 0x5ea3;
	__map_gbk2utf16[0x0da8] = 0x5ea4;
	__map_gbk2utf16[0x0da9] = 0x5ea8;
	__map_gbk2utf16[0x0daa] = 0x5ea9;
	__map_gbk2utf16[0x0dab] = 0x5eaa;
	__map_gbk2utf16[0x0dac] = 0x5eab;
	__map_gbk2utf16[0x0dad] = 0x5eac;
	__map_gbk2utf16[0x0dae] = 0x5eae;
	__map_gbk2utf16[0x0daf] = 0x5eaf;
	__map_gbk2utf16[0x0db0] = 0x5eb0;
	__map_gbk2utf16[0x0db1] = 0x5eb1;
	__map_gbk2utf16[0x0db2] = 0x5eb2;
	__map_gbk2utf16[0x0db3] = 0x5eb4;
	__map_gbk2utf16[0x0db4] = 0x5eba;
	__map_gbk2utf16[0x0db5] = 0x5ebb;
	__map_gbk2utf16[0x0db6] = 0x5ebc;
	__map_gbk2utf16[0x0db7] = 0x5ebd;
	__map_gbk2utf16[0x0db8] = 0x5ebf;
	__map_gbk2utf16[0x0db9] = 0x5ec0;
	__map_gbk2utf16[0x0dba] = 0x5ec1;
	__map_gbk2utf16[0x0dbb] = 0x5ec2;
	__map_gbk2utf16[0x0dbc] = 0x5ec3;
	__map_gbk2utf16[0x0dbd] = 0x5ec4;
	__map_gbk2utf16[0x0dbe] = 0x5ec5;
	__map_gbk2utf16[0x0e00] = 0x5ec6;
	__map_gbk2utf16[0x0e01] = 0x5ec7;
	__map_gbk2utf16[0x0e02] = 0x5ec8;
	__map_gbk2utf16[0x0e03] = 0x5ecb;
	__map_gbk2utf16[0x0e04] = 0x5ecc;
	__map_gbk2utf16[0x0e05] = 0x5ecd;
	__map_gbk2utf16[0x0e06] = 0x5ece;
	__map_gbk2utf16[0x0e07] = 0x5ecf;
	__map_gbk2utf16[0x0e08] = 0x5ed0;
	__map_gbk2utf16[0x0e09] = 0x5ed4;
	__map_gbk2utf16[0x0e0a] = 0x5ed5;
	__map_gbk2utf16[0x0e0b] = 0x5ed7;
	__map_gbk2utf16[0x0e0c] = 0x5ed8;
	__map_gbk2utf16[0x0e0d] = 0x5ed9;
	__map_gbk2utf16[0x0e0e] = 0x5eda;
	__map_gbk2utf16[0x0e0f] = 0x5edc;
	__map_gbk2utf16[0x0e10] = 0x5edd;
	__map_gbk2utf16[0x0e11] = 0x5ede;
	__map_gbk2utf16[0x0e12] = 0x5edf;
	__map_gbk2utf16[0x0e13] = 0x5ee0;
	__map_gbk2utf16[0x0e14] = 0x5ee1;
	__map_gbk2utf16[0x0e15] = 0x5ee2;
	__map_gbk2utf16[0x0e16] = 0x5ee3;
	__map_gbk2utf16[0x0e17] = 0x5ee4;
	__map_gbk2utf16[0x0e18] = 0x5ee5;
	__map_gbk2utf16[0x0e19] = 0x5ee6;
	__map_gbk2utf16[0x0e1a] = 0x5ee7;
	__map_gbk2utf16[0x0e1b] = 0x5ee9;
	__map_gbk2utf16[0x0e1c] = 0x5eeb;
	__map_gbk2utf16[0x0e1d] = 0x5eec;
	__map_gbk2utf16[0x0e1e] = 0x5eed;
	__map_gbk2utf16[0x0e1f] = 0x5eee;
	__map_gbk2utf16[0x0e20] = 0x5eef;
	__map_gbk2utf16[0x0e21] = 0x5ef0;
	__map_gbk2utf16[0x0e22] = 0x5ef1;
	__map_gbk2utf16[0x0e23] = 0x5ef2;
	__map_gbk2utf16[0x0e24] = 0x5ef3;
	__map_gbk2utf16[0x0e25] = 0x5ef5;
	__map_gbk2utf16[0x0e26] = 0x5ef8;
	__map_gbk2utf16[0x0e27] = 0x5ef9;
	__map_gbk2utf16[0x0e28] = 0x5efb;
	__map_gbk2utf16[0x0e29] = 0x5efc;
	__map_gbk2utf16[0x0e2a] = 0x5efd;
	__map_gbk2utf16[0x0e2b] = 0x5f05;
	__map_gbk2utf16[0x0e2c] = 0x5f06;
	__map_gbk2utf16[0x0e2d] = 0x5f07;
	__map_gbk2utf16[0x0e2e] = 0x5f09;
	__map_gbk2utf16[0x0e2f] = 0x5f0c;
	__map_gbk2utf16[0x0e30] = 0x5f0d;
	__map_gbk2utf16[0x0e31] = 0x5f0e;
	__map_gbk2utf16[0x0e32] = 0x5f10;
	__map_gbk2utf16[0x0e33] = 0x5f12;
	__map_gbk2utf16[0x0e34] = 0x5f14;
	__map_gbk2utf16[0x0e35] = 0x5f16;
	__map_gbk2utf16[0x0e36] = 0x5f19;
	__map_gbk2utf16[0x0e37] = 0x5f1a;
	__map_gbk2utf16[0x0e38] = 0x5f1c;
	__map_gbk2utf16[0x0e39] = 0x5f1d;
	__map_gbk2utf16[0x0e3a] = 0x5f1e;
	__map_gbk2utf16[0x0e3b] = 0x5f21;
	__map_gbk2utf16[0x0e3c] = 0x5f22;
	__map_gbk2utf16[0x0e3d] = 0x5f23;
	__map_gbk2utf16[0x0e3e] = 0x5f24;
	__map_gbk2utf16[0x0e40] = 0x5f28;
	__map_gbk2utf16[0x0e41] = 0x5f2b;
	__map_gbk2utf16[0x0e42] = 0x5f2c;
	__map_gbk2utf16[0x0e43] = 0x5f2e;
	__map_gbk2utf16[0x0e44] = 0x5f30;
	__map_gbk2utf16[0x0e45] = 0x5f32;
	__map_gbk2utf16[0x0e46] = 0x5f33;
	__map_gbk2utf16[0x0e47] = 0x5f34;
	__map_gbk2utf16[0x0e48] = 0x5f35;
	__map_gbk2utf16[0x0e49] = 0x5f36;
	__map_gbk2utf16[0x0e4a] = 0x5f37;
	__map_gbk2utf16[0x0e4b] = 0x5f38;
	__map_gbk2utf16[0x0e4c] = 0x5f3b;
	__map_gbk2utf16[0x0e4d] = 0x5f3d;
	__map_gbk2utf16[0x0e4e] = 0x5f3e;
	__map_gbk2utf16[0x0e4f] = 0x5f3f;
	__map_gbk2utf16[0x0e50] = 0x5f41;
	__map_gbk2utf16[0x0e51] = 0x5f42;
	__map_gbk2utf16[0x0e52] = 0x5f43;
	__map_gbk2utf16[0x0e53] = 0x5f44;
	__map_gbk2utf16[0x0e54] = 0x5f45;
	__map_gbk2utf16[0x0e55] = 0x5f46;
	__map_gbk2utf16[0x0e56] = 0x5f47;
	__map_gbk2utf16[0x0e57] = 0x5f48;
	__map_gbk2utf16[0x0e58] = 0x5f49;
	__map_gbk2utf16[0x0e59] = 0x5f4a;
	__map_gbk2utf16[0x0e5a] = 0x5f4b;
	__map_gbk2utf16[0x0e5b] = 0x5f4c;
	__map_gbk2utf16[0x0e5c] = 0x5f4d;
	__map_gbk2utf16[0x0e5d] = 0x5f4e;
	__map_gbk2utf16[0x0e5e] = 0x5f4f;
	__map_gbk2utf16[0x0e5f] = 0x5f51;
	__map_gbk2utf16[0x0e60] = 0x5f54;
	__map_gbk2utf16[0x0e61] = 0x5f59;
	__map_gbk2utf16[0x0e62] = 0x5f5a;
	__map_gbk2utf16[0x0e63] = 0x5f5b;
	__map_gbk2utf16[0x0e64] = 0x5f5c;
	__map_gbk2utf16[0x0e65] = 0x5f5e;
	__map_gbk2utf16[0x0e66] = 0x5f5f;
	__map_gbk2utf16[0x0e67] = 0x5f60;
	__map_gbk2utf16[0x0e68] = 0x5f63;
	__map_gbk2utf16[0x0e69] = 0x5f65;
	__map_gbk2utf16[0x0e6a] = 0x5f67;
	__map_gbk2utf16[0x0e6b] = 0x5f68;
	__map_gbk2utf16[0x0e6c] = 0x5f6b;
	__map_gbk2utf16[0x0e6d] = 0x5f6e;
	__map_gbk2utf16[0x0e6e] = 0x5f6f;
	__map_gbk2utf16[0x0e6f] = 0x5f72;
	__map_gbk2utf16[0x0e70] = 0x5f74;
	__map_gbk2utf16[0x0e71] = 0x5f75;
	__map_gbk2utf16[0x0e72] = 0x5f76;
	__map_gbk2utf16[0x0e73] = 0x5f78;
	__map_gbk2utf16[0x0e74] = 0x5f7a;
	__map_gbk2utf16[0x0e75] = 0x5f7d;
	__map_gbk2utf16[0x0e76] = 0x5f7e;
	__map_gbk2utf16[0x0e77] = 0x5f7f;
	__map_gbk2utf16[0x0e78] = 0x5f83;
	__map_gbk2utf16[0x0e79] = 0x5f86;
	__map_gbk2utf16[0x0e7a] = 0x5f8d;
	__map_gbk2utf16[0x0e7b] = 0x5f8e;
	__map_gbk2utf16[0x0e7c] = 0x5f8f;
	__map_gbk2utf16[0x0e7d] = 0x5f91;
	__map_gbk2utf16[0x0e7e] = 0x5f93;
	__map_gbk2utf16[0x0e7f] = 0x5f94;
	__map_gbk2utf16[0x0e80] = 0x5f96;
	__map_gbk2utf16[0x0e81] = 0x5f9a;
	__map_gbk2utf16[0x0e82] = 0x5f9b;
	__map_gbk2utf16[0x0e83] = 0x5f9d;
	__map_gbk2utf16[0x0e84] = 0x5f9e;
	__map_gbk2utf16[0x0e85] = 0x5f9f;
	__map_gbk2utf16[0x0e86] = 0x5fa0;
	__map_gbk2utf16[0x0e87] = 0x5fa2;
	__map_gbk2utf16[0x0e88] = 0x5fa3;
	__map_gbk2utf16[0x0e89] = 0x5fa4;
	__map_gbk2utf16[0x0e8a] = 0x5fa5;
	__map_gbk2utf16[0x0e8b] = 0x5fa6;
	__map_gbk2utf16[0x0e8c] = 0x5fa7;
	__map_gbk2utf16[0x0e8d] = 0x5fa9;
	__map_gbk2utf16[0x0e8e] = 0x5fab;
	__map_gbk2utf16[0x0e8f] = 0x5fac;
	__map_gbk2utf16[0x0e90] = 0x5faf;
	__map_gbk2utf16[0x0e91] = 0x5fb0;
	__map_gbk2utf16[0x0e92] = 0x5fb1;
	__map_gbk2utf16[0x0e93] = 0x5fb2;
	__map_gbk2utf16[0x0e94] = 0x5fb3;
	__map_gbk2utf16[0x0e95] = 0x5fb4;
	__map_gbk2utf16[0x0e96] = 0x5fb6;
	__map_gbk2utf16[0x0e97] = 0x5fb8;
	__map_gbk2utf16[0x0e98] = 0x5fb9;
	__map_gbk2utf16[0x0e99] = 0x5fba;
	__map_gbk2utf16[0x0e9a] = 0x5fbb;
	__map_gbk2utf16[0x0e9b] = 0x5fbe;
	__map_gbk2utf16[0x0e9c] = 0x5fbf;
	__map_gbk2utf16[0x0e9d] = 0x5fc0;
	__map_gbk2utf16[0x0e9e] = 0x5fc1;
	__map_gbk2utf16[0x0e9f] = 0x5fc2;
	__map_gbk2utf16[0x0ea0] = 0x5fc7;
	__map_gbk2utf16[0x0ea1] = 0x5fc8;
	__map_gbk2utf16[0x0ea2] = 0x5fca;
	__map_gbk2utf16[0x0ea3] = 0x5fcb;
	__map_gbk2utf16[0x0ea4] = 0x5fce;
	__map_gbk2utf16[0x0ea5] = 0x5fd3;
	__map_gbk2utf16[0x0ea6] = 0x5fd4;
	__map_gbk2utf16[0x0ea7] = 0x5fd5;
	__map_gbk2utf16[0x0ea8] = 0x5fda;
	__map_gbk2utf16[0x0ea9] = 0x5fdb;
	__map_gbk2utf16[0x0eaa] = 0x5fdc;
	__map_gbk2utf16[0x0eab] = 0x5fde;
	__map_gbk2utf16[0x0eac] = 0x5fdf;
	__map_gbk2utf16[0x0ead] = 0x5fe2;
	__map_gbk2utf16[0x0eae] = 0x5fe3;
	__map_gbk2utf16[0x0eaf] = 0x5fe5;
	__map_gbk2utf16[0x0eb0] = 0x5fe6;
	__map_gbk2utf16[0x0eb1] = 0x5fe8;
	__map_gbk2utf16[0x0eb2] = 0x5fe9;
	__map_gbk2utf16[0x0eb3] = 0x5fec;
	__map_gbk2utf16[0x0eb4] = 0x5fef;
	__map_gbk2utf16[0x0eb5] = 0x5ff0;
	__map_gbk2utf16[0x0eb6] = 0x5ff2;
	__map_gbk2utf16[0x0eb7] = 0x5ff3;
	__map_gbk2utf16[0x0eb8] = 0x5ff4;
	__map_gbk2utf16[0x0eb9] = 0x5ff6;
	__map_gbk2utf16[0x0eba] = 0x5ff7;
	__map_gbk2utf16[0x0ebb] = 0x5ff9;
	__map_gbk2utf16[0x0ebc] = 0x5ffa;
	__map_gbk2utf16[0x0ebd] = 0x5ffc;
	__map_gbk2utf16[0x0ebe] = 0x6007;
	__map_gbk2utf16[0x0f00] = 0x6008;
	__map_gbk2utf16[0x0f01] = 0x6009;
	__map_gbk2utf16[0x0f02] = 0x600b;
	__map_gbk2utf16[0x0f03] = 0x600c;
	__map_gbk2utf16[0x0f04] = 0x6010;
	__map_gbk2utf16[0x0f05] = 0x6011;
	__map_gbk2utf16[0x0f06] = 0x6013;
	__map_gbk2utf16[0x0f07] = 0x6017;
	__map_gbk2utf16[0x0f08] = 0x6018;
	__map_gbk2utf16[0x0f09] = 0x601a;
	__map_gbk2utf16[0x0f0a] = 0x601e;
	__map_gbk2utf16[0x0f0b] = 0x601f;
	__map_gbk2utf16[0x0f0c] = 0x6022;
	__map_gbk2utf16[0x0f0d] = 0x6023;
	__map_gbk2utf16[0x0f0e] = 0x6024;
	__map_gbk2utf16[0x0f0f] = 0x602c;
	__map_gbk2utf16[0x0f10] = 0x602d;
	__map_gbk2utf16[0x0f11] = 0x602e;
	__map_gbk2utf16[0x0f12] = 0x6030;
	__map_gbk2utf16[0x0f13] = 0x6031;
	__map_gbk2utf16[0x0f14] = 0x6032;
	__map_gbk2utf16[0x0f15] = 0x6033;
	__map_gbk2utf16[0x0f16] = 0x6034;
	__map_gbk2utf16[0x0f17] = 0x6036;
	__map_gbk2utf16[0x0f18] = 0x6037;
	__map_gbk2utf16[0x0f19] = 0x6038;
	__map_gbk2utf16[0x0f1a] = 0x6039;
	__map_gbk2utf16[0x0f1b] = 0x603a;
	__map_gbk2utf16[0x0f1c] = 0x603d;
	__map_gbk2utf16[0x0f1d] = 0x603e;
	__map_gbk2utf16[0x0f1e] = 0x6040;
	__map_gbk2utf16[0x0f1f] = 0x6044;
	__map_gbk2utf16[0x0f20] = 0x6045;
	__map_gbk2utf16[0x0f21] = 0x6046;
	__map_gbk2utf16[0x0f22] = 0x6047;
	__map_gbk2utf16[0x0f23] = 0x6048;
	__map_gbk2utf16[0x0f24] = 0x6049;
	__map_gbk2utf16[0x0f25] = 0x604a;
	__map_gbk2utf16[0x0f26] = 0x604c;
	__map_gbk2utf16[0x0f27] = 0x604e;
	__map_gbk2utf16[0x0f28] = 0x604f;
	__map_gbk2utf16[0x0f29] = 0x6051;
	__map_gbk2utf16[0x0f2a] = 0x6053;
	__map_gbk2utf16[0x0f2b] = 0x6054;
	__map_gbk2utf16[0x0f2c] = 0x6056;
	__map_gbk2utf16[0x0f2d] = 0x6057;
	__map_gbk2utf16[0x0f2e] = 0x6058;
	__map_gbk2utf16[0x0f2f] = 0x605b;
	__map_gbk2utf16[0x0f30] = 0x605c;
	__map_gbk2utf16[0x0f31] = 0x605e;
	__map_gbk2utf16[0x0f32] = 0x605f;
	__map_gbk2utf16[0x0f33] = 0x6060;
	__map_gbk2utf16[0x0f34] = 0x6061;
	__map_gbk2utf16[0x0f35] = 0x6065;
	__map_gbk2utf16[0x0f36] = 0x6066;
	__map_gbk2utf16[0x0f37] = 0x606e;
	__map_gbk2utf16[0x0f38] = 0x6071;
	__map_gbk2utf16[0x0f39] = 0x6072;
	__map_gbk2utf16[0x0f3a] = 0x6074;
	__map_gbk2utf16[0x0f3b] = 0x6075;
	__map_gbk2utf16[0x0f3c] = 0x6077;
	__map_gbk2utf16[0x0f3d] = 0x607e;
	__map_gbk2utf16[0x0f3e] = 0x6080;
	__map_gbk2utf16[0x0f40] = 0x6081;
	__map_gbk2utf16[0x0f41] = 0x6082;
	__map_gbk2utf16[0x0f42] = 0x6085;
	__map_gbk2utf16[0x0f43] = 0x6086;
	__map_gbk2utf16[0x0f44] = 0x6087;
	__map_gbk2utf16[0x0f45] = 0x6088;
	__map_gbk2utf16[0x0f46] = 0x608a;
	__map_gbk2utf16[0x0f47] = 0x608b;
	__map_gbk2utf16[0x0f48] = 0x608e;
	__map_gbk2utf16[0x0f49] = 0x608f;
	__map_gbk2utf16[0x0f4a] = 0x6090;
	__map_gbk2utf16[0x0f4b] = 0x6091;
	__map_gbk2utf16[0x0f4c] = 0x6093;
	__map_gbk2utf16[0x0f4d] = 0x6095;
	__map_gbk2utf16[0x0f4e] = 0x6097;
	__map_gbk2utf16[0x0f4f] = 0x6098;
	__map_gbk2utf16[0x0f50] = 0x6099;
	__map_gbk2utf16[0x0f51] = 0x609c;
	__map_gbk2utf16[0x0f52] = 0x609e;
	__map_gbk2utf16[0x0f53] = 0x60a1;
	__map_gbk2utf16[0x0f54] = 0x60a2;
	__map_gbk2utf16[0x0f55] = 0x60a4;
	__map_gbk2utf16[0x0f56] = 0x60a5;
	__map_gbk2utf16[0x0f57] = 0x60a7;
	__map_gbk2utf16[0x0f58] = 0x60a9;
	__map_gbk2utf16[0x0f59] = 0x60aa;
	__map_gbk2utf16[0x0f5a] = 0x60ae;
	__map_gbk2utf16[0x0f5b] = 0x60b0;
	__map_gbk2utf16[0x0f5c] = 0x60b3;
	__map_gbk2utf16[0x0f5d] = 0x60b5;
	__map_gbk2utf16[0x0f5e] = 0x60b6;
	__map_gbk2utf16[0x0f5f] = 0x60b7;
	__map_gbk2utf16[0x0f60] = 0x60b9;
	__map_gbk2utf16[0x0f61] = 0x60ba;
	__map_gbk2utf16[0x0f62] = 0x60bd;
	__map_gbk2utf16[0x0f63] = 0x60be;
	__map_gbk2utf16[0x0f64] = 0x60bf;
	__map_gbk2utf16[0x0f65] = 0x60c0;
	__map_gbk2utf16[0x0f66] = 0x60c1;
	__map_gbk2utf16[0x0f67] = 0x60c2;
	__map_gbk2utf16[0x0f68] = 0x60c3;
	__map_gbk2utf16[0x0f69] = 0x60c4;
	__map_gbk2utf16[0x0f6a] = 0x60c7;
	__map_gbk2utf16[0x0f6b] = 0x60c8;
	__map_gbk2utf16[0x0f6c] = 0x60c9;
	__map_gbk2utf16[0x0f6d] = 0x60cc;
	__map_gbk2utf16[0x0f6e] = 0x60cd;
	__map_gbk2utf16[0x0f6f] = 0x60ce;
	__map_gbk2utf16[0x0f70] = 0x60cf;
	__map_gbk2utf16[0x0f71] = 0x60d0;
	__map_gbk2utf16[0x0f72] = 0x60d2;
	__map_gbk2utf16[0x0f73] = 0x60d3;
	__map_gbk2utf16[0x0f74] = 0x60d4;
	__map_gbk2utf16[0x0f75] = 0x60d6;
	__map_gbk2utf16[0x0f76] = 0x60d7;
	__map_gbk2utf16[0x0f77] = 0x60d9;
	__map_gbk2utf16[0x0f78] = 0x60db;
	__map_gbk2utf16[0x0f79] = 0x60de;
	__map_gbk2utf16[0x0f7a] = 0x60e1;
	__map_gbk2utf16[0x0f7b] = 0x60e2;
	__map_gbk2utf16[0x0f7c] = 0x60e3;
	__map_gbk2utf16[0x0f7d] = 0x60e4;
	__map_gbk2utf16[0x0f7e] = 0x60e5;
	__map_gbk2utf16[0x0f7f] = 0x60ea;
	__map_gbk2utf16[0x0f80] = 0x60f1;
	__map_gbk2utf16[0x0f81] = 0x60f2;
	__map_gbk2utf16[0x0f82] = 0x60f5;
	__map_gbk2utf16[0x0f83] = 0x60f7;
	__map_gbk2utf16[0x0f84] = 0x60f8;
	__map_gbk2utf16[0x0f85] = 0x60fb;
	__map_gbk2utf16[0x0f86] = 0x60fc;
	__map_gbk2utf16[0x0f87] = 0x60fd;
	__map_gbk2utf16[0x0f88] = 0x60fe;
	__map_gbk2utf16[0x0f89] = 0x60ff;
	__map_gbk2utf16[0x0f8a] = 0x6102;
	__map_gbk2utf16[0x0f8b] = 0x6103;
	__map_gbk2utf16[0x0f8c] = 0x6104;
	__map_gbk2utf16[0x0f8d] = 0x6105;
	__map_gbk2utf16[0x0f8e] = 0x6107;
	__map_gbk2utf16[0x0f8f] = 0x610a;
	__map_gbk2utf16[0x0f90] = 0x610b;
	__map_gbk2utf16[0x0f91] = 0x610c;
	__map_gbk2utf16[0x0f92] = 0x6110;
	__map_gbk2utf16[0x0f93] = 0x6111;
	__map_gbk2utf16[0x0f94] = 0x6112;
	__map_gbk2utf16[0x0f95] = 0x6113;
	__map_gbk2utf16[0x0f96] = 0x6114;
	__map_gbk2utf16[0x0f97] = 0x6116;
	__map_gbk2utf16[0x0f98] = 0x6117;
	__map_gbk2utf16[0x0f99] = 0x6118;
	__map_gbk2utf16[0x0f9a] = 0x6119;
	__map_gbk2utf16[0x0f9b] = 0x611b;
	__map_gbk2utf16[0x0f9c] = 0x611c;
	__map_gbk2utf16[0x0f9d] = 0x611d;
	__map_gbk2utf16[0x0f9e] = 0x611e;
	__map_gbk2utf16[0x0f9f] = 0x6121;
	__map_gbk2utf16[0x0fa0] = 0x6122;
	__map_gbk2utf16[0x0fa1] = 0x6125;
	__map_gbk2utf16[0x0fa2] = 0x6128;
	__map_gbk2utf16[0x0fa3] = 0x6129;
	__map_gbk2utf16[0x0fa4] = 0x612a;
	__map_gbk2utf16[0x0fa5] = 0x612c;
	__map_gbk2utf16[0x0fa6] = 0x612d;
	__map_gbk2utf16[0x0fa7] = 0x612e;
	__map_gbk2utf16[0x0fa8] = 0x612f;
	__map_gbk2utf16[0x0fa9] = 0x6130;
	__map_gbk2utf16[0x0faa] = 0x6131;
	__map_gbk2utf16[0x0fab] = 0x6132;
	__map_gbk2utf16[0x0fac] = 0x6133;
	__map_gbk2utf16[0x0fad] = 0x6134;
	__map_gbk2utf16[0x0fae] = 0x6135;
	__map_gbk2utf16[0x0faf] = 0x6136;
	__map_gbk2utf16[0x0fb0] = 0x6137;
	__map_gbk2utf16[0x0fb1] = 0x6138;
	__map_gbk2utf16[0x0fb2] = 0x6139;
	__map_gbk2utf16[0x0fb3] = 0x613a;
	__map_gbk2utf16[0x0fb4] = 0x613b;
	__map_gbk2utf16[0x0fb5] = 0x613c;
	__map_gbk2utf16[0x0fb6] = 0x613d;
	__map_gbk2utf16[0x0fb7] = 0x613e;
	__map_gbk2utf16[0x0fb8] = 0x6140;
	__map_gbk2utf16[0x0fb9] = 0x6141;
	__map_gbk2utf16[0x0fba] = 0x6142;
	__map_gbk2utf16[0x0fbb] = 0x6143;
	__map_gbk2utf16[0x0fbc] = 0x6144;
	__map_gbk2utf16[0x0fbd] = 0x6145;
	__map_gbk2utf16[0x0fbe] = 0x6146;
	__map_gbk2utf16[0x1000] = 0x6147;
	__map_gbk2utf16[0x1001] = 0x6149;
	__map_gbk2utf16[0x1002] = 0x614b;
	__map_gbk2utf16[0x1003] = 0x614d;
	__map_gbk2utf16[0x1004] = 0x614f;
	__map_gbk2utf16[0x1005] = 0x6150;
	__map_gbk2utf16[0x1006] = 0x6152;
	__map_gbk2utf16[0x1007] = 0x6153;
	__map_gbk2utf16[0x1008] = 0x6154;
	__map_gbk2utf16[0x1009] = 0x6156;
	__map_gbk2utf16[0x100a] = 0x6157;
	__map_gbk2utf16[0x100b] = 0x6158;
	__map_gbk2utf16[0x100c] = 0x6159;
	__map_gbk2utf16[0x100d] = 0x615a;
	__map_gbk2utf16[0x100e] = 0x615b;
	__map_gbk2utf16[0x100f] = 0x615c;
	__map_gbk2utf16[0x1010] = 0x615e;
	__map_gbk2utf16[0x1011] = 0x615f;
	__map_gbk2utf16[0x1012] = 0x6160;
	__map_gbk2utf16[0x1013] = 0x6161;
	__map_gbk2utf16[0x1014] = 0x6163;
	__map_gbk2utf16[0x1015] = 0x6164;
	__map_gbk2utf16[0x1016] = 0x6165;
	__map_gbk2utf16[0x1017] = 0x6166;
	__map_gbk2utf16[0x1018] = 0x6169;
	__map_gbk2utf16[0x1019] = 0x616a;
	__map_gbk2utf16[0x101a] = 0x616b;
	__map_gbk2utf16[0x101b] = 0x616c;
	__map_gbk2utf16[0x101c] = 0x616d;
	__map_gbk2utf16[0x101d] = 0x616e;
	__map_gbk2utf16[0x101e] = 0x616f;
	__map_gbk2utf16[0x101f] = 0x6171;
	__map_gbk2utf16[0x1020] = 0x6172;
	__map_gbk2utf16[0x1021] = 0x6173;
	__map_gbk2utf16[0x1022] = 0x6174;
	__map_gbk2utf16[0x1023] = 0x6176;
	__map_gbk2utf16[0x1024] = 0x6178;
	__map_gbk2utf16[0x1025] = 0x6179;
	__map_gbk2utf16[0x1026] = 0x617a;
	__map_gbk2utf16[0x1027] = 0x617b;
	__map_gbk2utf16[0x1028] = 0x617c;
	__map_gbk2utf16[0x1029] = 0x617d;
	__map_gbk2utf16[0x102a] = 0x617e;
	__map_gbk2utf16[0x102b] = 0x617f;
	__map_gbk2utf16[0x102c] = 0x6180;
	__map_gbk2utf16[0x102d] = 0x6181;
	__map_gbk2utf16[0x102e] = 0x6182;
	__map_gbk2utf16[0x102f] = 0x6183;
	__map_gbk2utf16[0x1030] = 0x6184;
	__map_gbk2utf16[0x1031] = 0x6185;
	__map_gbk2utf16[0x1032] = 0x6186;
	__map_gbk2utf16[0x1033] = 0x6187;
	__map_gbk2utf16[0x1034] = 0x6188;
	__map_gbk2utf16[0x1035] = 0x6189;
	__map_gbk2utf16[0x1036] = 0x618a;
	__map_gbk2utf16[0x1037] = 0x618c;
	__map_gbk2utf16[0x1038] = 0x618d;
	__map_gbk2utf16[0x1039] = 0x618f;
	__map_gbk2utf16[0x103a] = 0x6190;
	__map_gbk2utf16[0x103b] = 0x6191;
	__map_gbk2utf16[0x103c] = 0x6192;
	__map_gbk2utf16[0x103d] = 0x6193;
	__map_gbk2utf16[0x103e] = 0x6195;
	__map_gbk2utf16[0x1040] = 0x6196;
	__map_gbk2utf16[0x1041] = 0x6197;
	__map_gbk2utf16[0x1042] = 0x6198;
	__map_gbk2utf16[0x1043] = 0x6199;
	__map_gbk2utf16[0x1044] = 0x619a;
	__map_gbk2utf16[0x1045] = 0x619b;
	__map_gbk2utf16[0x1046] = 0x619c;
	__map_gbk2utf16[0x1047] = 0x619e;
	__map_gbk2utf16[0x1048] = 0x619f;
	__map_gbk2utf16[0x1049] = 0x61a0;
	__map_gbk2utf16[0x104a] = 0x61a1;
	__map_gbk2utf16[0x104b] = 0x61a2;
	__map_gbk2utf16[0x104c] = 0x61a3;
	__map_gbk2utf16[0x104d] = 0x61a4;
	__map_gbk2utf16[0x104e] = 0x61a5;
	__map_gbk2utf16[0x104f] = 0x61a6;
	__map_gbk2utf16[0x1050] = 0x61aa;
	__map_gbk2utf16[0x1051] = 0x61ab;
	__map_gbk2utf16[0x1052] = 0x61ad;
	__map_gbk2utf16[0x1053] = 0x61ae;
	__map_gbk2utf16[0x1054] = 0x61af;
	__map_gbk2utf16[0x1055] = 0x61b0;
	__map_gbk2utf16[0x1056] = 0x61b1;
	__map_gbk2utf16[0x1057] = 0x61b2;
	__map_gbk2utf16[0x1058] = 0x61b3;
	__map_gbk2utf16[0x1059] = 0x61b4;
	__map_gbk2utf16[0x105a] = 0x61b5;
	__map_gbk2utf16[0x105b] = 0x61b6;
	__map_gbk2utf16[0x105c] = 0x61b8;
	__map_gbk2utf16[0x105d] = 0x61b9;
	__map_gbk2utf16[0x105e] = 0x61ba;
	__map_gbk2utf16[0x105f] = 0x61bb;
	__map_gbk2utf16[0x1060] = 0x61bc;
	__map_gbk2utf16[0x1061] = 0x61bd;
	__map_gbk2utf16[0x1062] = 0x61bf;
	__map_gbk2utf16[0x1063] = 0x61c0;
	__map_gbk2utf16[0x1064] = 0x61c1;
	__map_gbk2utf16[0x1065] = 0x61c3;
	__map_gbk2utf16[0x1066] = 0x61c4;
	__map_gbk2utf16[0x1067] = 0x61c5;
	__map_gbk2utf16[0x1068] = 0x61c6;
	__map_gbk2utf16[0x1069] = 0x61c7;
	__map_gbk2utf16[0x106a] = 0x61c9;
	__map_gbk2utf16[0x106b] = 0x61cc;
	__map_gbk2utf16[0x106c] = 0x61cd;
	__map_gbk2utf16[0x106d] = 0x61ce;
	__map_gbk2utf16[0x106e] = 0x61cf;
	__map_gbk2utf16[0x106f] = 0x61d0;
	__map_gbk2utf16[0x1070] = 0x61d3;
	__map_gbk2utf16[0x1071] = 0x61d5;
	__map_gbk2utf16[0x1072] = 0x61d6;
	__map_gbk2utf16[0x1073] = 0x61d7;
	__map_gbk2utf16[0x1074] = 0x61d8;
	__map_gbk2utf16[0x1075] = 0x61d9;
	__map_gbk2utf16[0x1076] = 0x61da;
	__map_gbk2utf16[0x1077] = 0x61db;
	__map_gbk2utf16[0x1078] = 0x61dc;
	__map_gbk2utf16[0x1079] = 0x61dd;
	__map_gbk2utf16[0x107a] = 0x61de;
	__map_gbk2utf16[0x107b] = 0x61df;
	__map_gbk2utf16[0x107c] = 0x61e0;
	__map_gbk2utf16[0x107d] = 0x61e1;
	__map_gbk2utf16[0x107e] = 0x61e2;
	__map_gbk2utf16[0x107f] = 0x61e3;
	__map_gbk2utf16[0x1080] = 0x61e4;
	__map_gbk2utf16[0x1081] = 0x61e5;
	__map_gbk2utf16[0x1082] = 0x61e7;
	__map_gbk2utf16[0x1083] = 0x61e8;
	__map_gbk2utf16[0x1084] = 0x61e9;
	__map_gbk2utf16[0x1085] = 0x61ea;
	__map_gbk2utf16[0x1086] = 0x61eb;
	__map_gbk2utf16[0x1087] = 0x61ec;
	__map_gbk2utf16[0x1088] = 0x61ed;
	__map_gbk2utf16[0x1089] = 0x61ee;
	__map_gbk2utf16[0x108a] = 0x61ef;
	__map_gbk2utf16[0x108b] = 0x61f0;
	__map_gbk2utf16[0x108c] = 0x61f1;
	__map_gbk2utf16[0x108d] = 0x61f2;
	__map_gbk2utf16[0x108e] = 0x61f3;
	__map_gbk2utf16[0x108f] = 0x61f4;
	__map_gbk2utf16[0x1090] = 0x61f6;
	__map_gbk2utf16[0x1091] = 0x61f7;
	__map_gbk2utf16[0x1092] = 0x61f8;
	__map_gbk2utf16[0x1093] = 0x61f9;
	__map_gbk2utf16[0x1094] = 0x61fa;
	__map_gbk2utf16[0x1095] = 0x61fb;
	__map_gbk2utf16[0x1096] = 0x61fc;
	__map_gbk2utf16[0x1097] = 0x61fd;
	__map_gbk2utf16[0x1098] = 0x61fe;
	__map_gbk2utf16[0x1099] = 0x6200;
	__map_gbk2utf16[0x109a] = 0x6201;
	__map_gbk2utf16[0x109b] = 0x6202;
	__map_gbk2utf16[0x109c] = 0x6203;
	__map_gbk2utf16[0x109d] = 0x6204;
	__map_gbk2utf16[0x109e] = 0x6205;
	__map_gbk2utf16[0x109f] = 0x6207;
	__map_gbk2utf16[0x10a0] = 0x6209;
	__map_gbk2utf16[0x10a1] = 0x6213;
	__map_gbk2utf16[0x10a2] = 0x6214;
	__map_gbk2utf16[0x10a3] = 0x6219;
	__map_gbk2utf16[0x10a4] = 0x621c;
	__map_gbk2utf16[0x10a5] = 0x621d;
	__map_gbk2utf16[0x10a6] = 0x621e;
	__map_gbk2utf16[0x10a7] = 0x6220;
	__map_gbk2utf16[0x10a8] = 0x6223;
	__map_gbk2utf16[0x10a9] = 0x6226;
	__map_gbk2utf16[0x10aa] = 0x6227;
	__map_gbk2utf16[0x10ab] = 0x6228;
	__map_gbk2utf16[0x10ac] = 0x6229;
	__map_gbk2utf16[0x10ad] = 0x622b;
	__map_gbk2utf16[0x10ae] = 0x622d;
	__map_gbk2utf16[0x10af] = 0x622f;
	__map_gbk2utf16[0x10b0] = 0x6230;
	__map_gbk2utf16[0x10b1] = 0x6231;
	__map_gbk2utf16[0x10b2] = 0x6232;
	__map_gbk2utf16[0x10b3] = 0x6235;
	__map_gbk2utf16[0x10b4] = 0x6236;
	__map_gbk2utf16[0x10b5] = 0x6238;
	__map_gbk2utf16[0x10b6] = 0x6239;
	__map_gbk2utf16[0x10b7] = 0x623a;
	__map_gbk2utf16[0x10b8] = 0x623b;
	__map_gbk2utf16[0x10b9] = 0x623c;
	__map_gbk2utf16[0x10ba] = 0x6242;
	__map_gbk2utf16[0x10bb] = 0x6244;
	__map_gbk2utf16[0x10bc] = 0x6245;
	__map_gbk2utf16[0x10bd] = 0x6246;
	__map_gbk2utf16[0x10be] = 0x624a;
	__map_gbk2utf16[0x1100] = 0x624f;
	__map_gbk2utf16[0x1101] = 0x6250;
	__map_gbk2utf16[0x1102] = 0x6255;
	__map_gbk2utf16[0x1103] = 0x6256;
	__map_gbk2utf16[0x1104] = 0x6257;
	__map_gbk2utf16[0x1105] = 0x6259;
	__map_gbk2utf16[0x1106] = 0x625a;
	__map_gbk2utf16[0x1107] = 0x625c;
	__map_gbk2utf16[0x1108] = 0x625d;
	__map_gbk2utf16[0x1109] = 0x625e;
	__map_gbk2utf16[0x110a] = 0x625f;
	__map_gbk2utf16[0x110b] = 0x6260;
	__map_gbk2utf16[0x110c] = 0x6261;
	__map_gbk2utf16[0x110d] = 0x6262;
	__map_gbk2utf16[0x110e] = 0x6264;
	__map_gbk2utf16[0x110f] = 0x6265;
	__map_gbk2utf16[0x1110] = 0x6268;
	__map_gbk2utf16[0x1111] = 0x6271;
	__map_gbk2utf16[0x1112] = 0x6272;
	__map_gbk2utf16[0x1113] = 0x6274;
	__map_gbk2utf16[0x1114] = 0x6275;
	__map_gbk2utf16[0x1115] = 0x6277;
	__map_gbk2utf16[0x1116] = 0x6278;
	__map_gbk2utf16[0x1117] = 0x627a;
	__map_gbk2utf16[0x1118] = 0x627b;
	__map_gbk2utf16[0x1119] = 0x627d;
	__map_gbk2utf16[0x111a] = 0x6281;
	__map_gbk2utf16[0x111b] = 0x6282;
	__map_gbk2utf16[0x111c] = 0x6283;
	__map_gbk2utf16[0x111d] = 0x6285;
	__map_gbk2utf16[0x111e] = 0x6286;
	__map_gbk2utf16[0x111f] = 0x6287;
	__map_gbk2utf16[0x1120] = 0x6288;
	__map_gbk2utf16[0x1121] = 0x628b;
	__map_gbk2utf16[0x1122] = 0x628c;
	__map_gbk2utf16[0x1123] = 0x628d;
	__map_gbk2utf16[0x1124] = 0x628e;
	__map_gbk2utf16[0x1125] = 0x628f;
	__map_gbk2utf16[0x1126] = 0x6290;
	__map_gbk2utf16[0x1127] = 0x6294;
	__map_gbk2utf16[0x1128] = 0x6299;
	__map_gbk2utf16[0x1129] = 0x629c;
	__map_gbk2utf16[0x112a] = 0x629d;
	__map_gbk2utf16[0x112b] = 0x629e;
	__map_gbk2utf16[0x112c] = 0x62a3;
	__map_gbk2utf16[0x112d] = 0x62a6;
	__map_gbk2utf16[0x112e] = 0x62a7;
	__map_gbk2utf16[0x112f] = 0x62a9;
	__map_gbk2utf16[0x1130] = 0x62aa;
	__map_gbk2utf16[0x1131] = 0x62ad;
	__map_gbk2utf16[0x1132] = 0x62ae;
	__map_gbk2utf16[0x1133] = 0x62af;
	__map_gbk2utf16[0x1134] = 0x62b0;
	__map_gbk2utf16[0x1135] = 0x62b2;
	__map_gbk2utf16[0x1136] = 0x62b3;
	__map_gbk2utf16[0x1137] = 0x62b4;
	__map_gbk2utf16[0x1138] = 0x62b6;
	__map_gbk2utf16[0x1139] = 0x62b7;
	__map_gbk2utf16[0x113a] = 0x62b8;
	__map_gbk2utf16[0x113b] = 0x62ba;
	__map_gbk2utf16[0x113c] = 0x62be;
	__map_gbk2utf16[0x113d] = 0x62c0;
	__map_gbk2utf16[0x113e] = 0x62c1;
	__map_gbk2utf16[0x1140] = 0x62c3;
	__map_gbk2utf16[0x1141] = 0x62cb;
	__map_gbk2utf16[0x1142] = 0x62cf;
	__map_gbk2utf16[0x1143] = 0x62d1;
	__map_gbk2utf16[0x1144] = 0x62d5;
	__map_gbk2utf16[0x1145] = 0x62dd;
	__map_gbk2utf16[0x1146] = 0x62de;
	__map_gbk2utf16[0x1147] = 0x62e0;
	__map_gbk2utf16[0x1148] = 0x62e1;
	__map_gbk2utf16[0x1149] = 0x62e4;
	__map_gbk2utf16[0x114a] = 0x62ea;
	__map_gbk2utf16[0x114b] = 0x62eb;
	__map_gbk2utf16[0x114c] = 0x62f0;
	__map_gbk2utf16[0x114d] = 0x62f2;
	__map_gbk2utf16[0x114e] = 0x62f5;
	__map_gbk2utf16[0x114f] = 0x62f8;
	__map_gbk2utf16[0x1150] = 0x62f9;
	__map_gbk2utf16[0x1151] = 0x62fa;
	__map_gbk2utf16[0x1152] = 0x62fb;
	__map_gbk2utf16[0x1153] = 0x6300;
	__map_gbk2utf16[0x1154] = 0x6303;
	__map_gbk2utf16[0x1155] = 0x6304;
	__map_gbk2utf16[0x1156] = 0x6305;
	__map_gbk2utf16[0x1157] = 0x6306;
	__map_gbk2utf16[0x1158] = 0x630a;
	__map_gbk2utf16[0x1159] = 0x630b;
	__map_gbk2utf16[0x115a] = 0x630c;
	__map_gbk2utf16[0x115b] = 0x630d;
	__map_gbk2utf16[0x115c] = 0x630f;
	__map_gbk2utf16[0x115d] = 0x6310;
	__map_gbk2utf16[0x115e] = 0x6312;
	__map_gbk2utf16[0x115f] = 0x6313;
	__map_gbk2utf16[0x1160] = 0x6314;
	__map_gbk2utf16[0x1161] = 0x6315;
	__map_gbk2utf16[0x1162] = 0x6317;
	__map_gbk2utf16[0x1163] = 0x6318;
	__map_gbk2utf16[0x1164] = 0x6319;
	__map_gbk2utf16[0x1165] = 0x631c;
	__map_gbk2utf16[0x1166] = 0x6326;
	__map_gbk2utf16[0x1167] = 0x6327;
	__map_gbk2utf16[0x1168] = 0x6329;
	__map_gbk2utf16[0x1169] = 0x632c;
	__map_gbk2utf16[0x116a] = 0x632d;
	__map_gbk2utf16[0x116b] = 0x632e;
	__map_gbk2utf16[0x116c] = 0x6330;
	__map_gbk2utf16[0x116d] = 0x6331;
	__map_gbk2utf16[0x116e] = 0x6333;
	__map_gbk2utf16[0x116f] = 0x6334;
	__map_gbk2utf16[0x1170] = 0x6335;
	__map_gbk2utf16[0x1171] = 0x6336;
	__map_gbk2utf16[0x1172] = 0x6337;
	__map_gbk2utf16[0x1173] = 0x6338;
	__map_gbk2utf16[0x1174] = 0x633b;
	__map_gbk2utf16[0x1175] = 0x633c;
	__map_gbk2utf16[0x1176] = 0x633e;
	__map_gbk2utf16[0x1177] = 0x633f;
	__map_gbk2utf16[0x1178] = 0x6340;
	__map_gbk2utf16[0x1179] = 0x6341;
	__map_gbk2utf16[0x117a] = 0x6344;
	__map_gbk2utf16[0x117b] = 0x6347;
	__map_gbk2utf16[0x117c] = 0x6348;
	__map_gbk2utf16[0x117d] = 0x634a;
	__map_gbk2utf16[0x117e] = 0x6351;
	__map_gbk2utf16[0x117f] = 0x6352;
	__map_gbk2utf16[0x1180] = 0x6353;
	__map_gbk2utf16[0x1181] = 0x6354;
	__map_gbk2utf16[0x1182] = 0x6356;
	__map_gbk2utf16[0x1183] = 0x6357;
	__map_gbk2utf16[0x1184] = 0x6358;
	__map_gbk2utf16[0x1185] = 0x6359;
	__map_gbk2utf16[0x1186] = 0x635a;
	__map_gbk2utf16[0x1187] = 0x635b;
	__map_gbk2utf16[0x1188] = 0x635c;
	__map_gbk2utf16[0x1189] = 0x635d;
	__map_gbk2utf16[0x118a] = 0x6360;
	__map_gbk2utf16[0x118b] = 0x6364;
	__map_gbk2utf16[0x118c] = 0x6365;
	__map_gbk2utf16[0x118d] = 0x6366;
	__map_gbk2utf16[0x118e] = 0x6368;
	__map_gbk2utf16[0x118f] = 0x636a;
	__map_gbk2utf16[0x1190] = 0x636b;
	__map_gbk2utf16[0x1191] = 0x636c;
	__map_gbk2utf16[0x1192] = 0x636f;
	__map_gbk2utf16[0x1193] = 0x6370;
	__map_gbk2utf16[0x1194] = 0x6372;
	__map_gbk2utf16[0x1195] = 0x6373;
	__map_gbk2utf16[0x1196] = 0x6374;
	__map_gbk2utf16[0x1197] = 0x6375;
	__map_gbk2utf16[0x1198] = 0x6378;
	__map_gbk2utf16[0x1199] = 0x6379;
	__map_gbk2utf16[0x119a] = 0x637c;
	__map_gbk2utf16[0x119b] = 0x637d;
	__map_gbk2utf16[0x119c] = 0x637e;
	__map_gbk2utf16[0x119d] = 0x637f;
	__map_gbk2utf16[0x119e] = 0x6381;
	__map_gbk2utf16[0x119f] = 0x6383;
	__map_gbk2utf16[0x11a0] = 0x6384;
	__map_gbk2utf16[0x11a1] = 0x6385;
	__map_gbk2utf16[0x11a2] = 0x6386;
	__map_gbk2utf16[0x11a3] = 0x638b;
	__map_gbk2utf16[0x11a4] = 0x638d;
	__map_gbk2utf16[0x11a5] = 0x6391;
	__map_gbk2utf16[0x11a6] = 0x6393;
	__map_gbk2utf16[0x11a7] = 0x6394;
	__map_gbk2utf16[0x11a8] = 0x6395;
	__map_gbk2utf16[0x11a9] = 0x6397;
	__map_gbk2utf16[0x11aa] = 0x6399;
	__map_gbk2utf16[0x11ab] = 0x639a;
	__map_gbk2utf16[0x11ac] = 0x639b;
	__map_gbk2utf16[0x11ad] = 0x639c;
	__map_gbk2utf16[0x11ae] = 0x639d;
	__map_gbk2utf16[0x11af] = 0x639e;
	__map_gbk2utf16[0x11b0] = 0x639f;
	__map_gbk2utf16[0x11b1] = 0x63a1;
	__map_gbk2utf16[0x11b2] = 0x63a4;
	__map_gbk2utf16[0x11b3] = 0x63a6;
	__map_gbk2utf16[0x11b4] = 0x63ab;
	__map_gbk2utf16[0x11b5] = 0x63af;
	__map_gbk2utf16[0x11b6] = 0x63b1;
	__map_gbk2utf16[0x11b7] = 0x63b2;
	__map_gbk2utf16[0x11b8] = 0x63b5;
	__map_gbk2utf16[0x11b9] = 0x63b6;
	__map_gbk2utf16[0x11ba] = 0x63b9;
	__map_gbk2utf16[0x11bb] = 0x63bb;
	__map_gbk2utf16[0x11bc] = 0x63bd;
	__map_gbk2utf16[0x11bd] = 0x63bf;
	__map_gbk2utf16[0x11be] = 0x63c0;
	__map_gbk2utf16[0x1200] = 0x63c1;
	__map_gbk2utf16[0x1201] = 0x63c2;
	__map_gbk2utf16[0x1202] = 0x63c3;
	__map_gbk2utf16[0x1203] = 0x63c5;
	__map_gbk2utf16[0x1204] = 0x63c7;
	__map_gbk2utf16[0x1205] = 0x63c8;
	__map_gbk2utf16[0x1206] = 0x63ca;
	__map_gbk2utf16[0x1207] = 0x63cb;
	__map_gbk2utf16[0x1208] = 0x63cc;
	__map_gbk2utf16[0x1209] = 0x63d1;
	__map_gbk2utf16[0x120a] = 0x63d3;
	__map_gbk2utf16[0x120b] = 0x63d4;
	__map_gbk2utf16[0x120c] = 0x63d5;
	__map_gbk2utf16[0x120d] = 0x63d7;
	__map_gbk2utf16[0x120e] = 0x63d8;
	__map_gbk2utf16[0x120f] = 0x63d9;
	__map_gbk2utf16[0x1210] = 0x63da;
	__map_gbk2utf16[0x1211] = 0x63db;
	__map_gbk2utf16[0x1212] = 0x63dc;
	__map_gbk2utf16[0x1213] = 0x63dd;
	__map_gbk2utf16[0x1214] = 0x63df;
	__map_gbk2utf16[0x1215] = 0x63e2;
	__map_gbk2utf16[0x1216] = 0x63e4;
	__map_gbk2utf16[0x1217] = 0x63e5;
	__map_gbk2utf16[0x1218] = 0x63e6;
	__map_gbk2utf16[0x1219] = 0x63e7;
	__map_gbk2utf16[0x121a] = 0x63e8;
	__map_gbk2utf16[0x121b] = 0x63eb;
	__map_gbk2utf16[0x121c] = 0x63ec;
	__map_gbk2utf16[0x121d] = 0x63ee;
	__map_gbk2utf16[0x121e] = 0x63ef;
	__map_gbk2utf16[0x121f] = 0x63f0;
	__map_gbk2utf16[0x1220] = 0x63f1;
	__map_gbk2utf16[0x1221] = 0x63f3;
	__map_gbk2utf16[0x1222] = 0x63f5;
	__map_gbk2utf16[0x1223] = 0x63f7;
	__map_gbk2utf16[0x1224] = 0x63f9;
	__map_gbk2utf16[0x1225] = 0x63fa;
	__map_gbk2utf16[0x1226] = 0x63fb;
	__map_gbk2utf16[0x1227] = 0x63fc;
	__map_gbk2utf16[0x1228] = 0x63fe;
	__map_gbk2utf16[0x1229] = 0x6403;
	__map_gbk2utf16[0x122a] = 0x6404;
	__map_gbk2utf16[0x122b] = 0x6406;
	__map_gbk2utf16[0x122c] = 0x6407;
	__map_gbk2utf16[0x122d] = 0x6408;
	__map_gbk2utf16[0x122e] = 0x6409;
	__map_gbk2utf16[0x122f] = 0x640a;
	__map_gbk2utf16[0x1230] = 0x640d;
	__map_gbk2utf16[0x1231] = 0x640e;
	__map_gbk2utf16[0x1232] = 0x6411;
	__map_gbk2utf16[0x1233] = 0x6412;
	__map_gbk2utf16[0x1234] = 0x6415;
	__map_gbk2utf16[0x1235] = 0x6416;
	__map_gbk2utf16[0x1236] = 0x6417;
	__map_gbk2utf16[0x1237] = 0x6418;
	__map_gbk2utf16[0x1238] = 0x6419;
	__map_gbk2utf16[0x1239] = 0x641a;
	__map_gbk2utf16[0x123a] = 0x641d;
	__map_gbk2utf16[0x123b] = 0x641f;
	__map_gbk2utf16[0x123c] = 0x6422;
	__map_gbk2utf16[0x123d] = 0x6423;
	__map_gbk2utf16[0x123e] = 0x6424;
	__map_gbk2utf16[0x1240] = 0x6425;
	__map_gbk2utf16[0x1241] = 0x6427;
	__map_gbk2utf16[0x1242] = 0x6428;
	__map_gbk2utf16[0x1243] = 0x6429;
	__map_gbk2utf16[0x1244] = 0x642b;
	__map_gbk2utf16[0x1245] = 0x642e;
	__map_gbk2utf16[0x1246] = 0x642f;
	__map_gbk2utf16[0x1247] = 0x6430;
	__map_gbk2utf16[0x1248] = 0x6431;
	__map_gbk2utf16[0x1249] = 0x6432;
	__map_gbk2utf16[0x124a] = 0x6433;
	__map_gbk2utf16[0x124b] = 0x6435;
	__map_gbk2utf16[0x124c] = 0x6436;
	__map_gbk2utf16[0x124d] = 0x6437;
	__map_gbk2utf16[0x124e] = 0x6438;
	__map_gbk2utf16[0x124f] = 0x6439;
	__map_gbk2utf16[0x1250] = 0x643b;
	__map_gbk2utf16[0x1251] = 0x643c;
	__map_gbk2utf16[0x1252] = 0x643e;
	__map_gbk2utf16[0x1253] = 0x6440;
	__map_gbk2utf16[0x1254] = 0x6442;
	__map_gbk2utf16[0x1255] = 0x6443;
	__map_gbk2utf16[0x1256] = 0x6449;
	__map_gbk2utf16[0x1257] = 0x644b;
	__map_gbk2utf16[0x1258] = 0x644c;
	__map_gbk2utf16[0x1259] = 0x644d;
	__map_gbk2utf16[0x125a] = 0x644e;
	__map_gbk2utf16[0x125b] = 0x644f;
	__map_gbk2utf16[0x125c] = 0x6450;
	__map_gbk2utf16[0x125d] = 0x6451;
	__map_gbk2utf16[0x125e] = 0x6453;
	__map_gbk2utf16[0x125f] = 0x6455;
	__map_gbk2utf16[0x1260] = 0x6456;
	__map_gbk2utf16[0x1261] = 0x6457;
	__map_gbk2utf16[0x1262] = 0x6459;
	__map_gbk2utf16[0x1263] = 0x645a;
	__map_gbk2utf16[0x1264] = 0x645b;
	__map_gbk2utf16[0x1265] = 0x645c;
	__map_gbk2utf16[0x1266] = 0x645d;
	__map_gbk2utf16[0x1267] = 0x645f;
	__map_gbk2utf16[0x1268] = 0x6460;
	__map_gbk2utf16[0x1269] = 0x6461;
	__map_gbk2utf16[0x126a] = 0x6462;
	__map_gbk2utf16[0x126b] = 0x6463;
	__map_gbk2utf16[0x126c] = 0x6464;
	__map_gbk2utf16[0x126d] = 0x6465;
	__map_gbk2utf16[0x126e] = 0x6466;
	__map_gbk2utf16[0x126f] = 0x6468;
	__map_gbk2utf16[0x1270] = 0x646a;
	__map_gbk2utf16[0x1271] = 0x646b;
	__map_gbk2utf16[0x1272] = 0x646c;
	__map_gbk2utf16[0x1273] = 0x646e;
	__map_gbk2utf16[0x1274] = 0x646f;
	__map_gbk2utf16[0x1275] = 0x6470;
	__map_gbk2utf16[0x1276] = 0x6471;
	__map_gbk2utf16[0x1277] = 0x6472;
	__map_gbk2utf16[0x1278] = 0x6473;
	__map_gbk2utf16[0x1279] = 0x6474;
	__map_gbk2utf16[0x127a] = 0x6475;
	__map_gbk2utf16[0x127b] = 0x6476;
	__map_gbk2utf16[0x127c] = 0x6477;
	__map_gbk2utf16[0x127d] = 0x647b;
	__map_gbk2utf16[0x127e] = 0x647c;
	__map_gbk2utf16[0x127f] = 0x647d;
	__map_gbk2utf16[0x1280] = 0x647e;
	__map_gbk2utf16[0x1281] = 0x647f;
	__map_gbk2utf16[0x1282] = 0x6480;
	__map_gbk2utf16[0x1283] = 0x6481;
	__map_gbk2utf16[0x1284] = 0x6483;
	__map_gbk2utf16[0x1285] = 0x6486;
	__map_gbk2utf16[0x1286] = 0x6488;
	__map_gbk2utf16[0x1287] = 0x6489;
	__map_gbk2utf16[0x1288] = 0x648a;
	__map_gbk2utf16[0x1289] = 0x648b;
	__map_gbk2utf16[0x128a] = 0x648c;
	__map_gbk2utf16[0x128b] = 0x648d;
	__map_gbk2utf16[0x128c] = 0x648e;
	__map_gbk2utf16[0x128d] = 0x648f;
	__map_gbk2utf16[0x128e] = 0x6490;
	__map_gbk2utf16[0x128f] = 0x6493;
	__map_gbk2utf16[0x1290] = 0x6494;
	__map_gbk2utf16[0x1291] = 0x6497;
	__map_gbk2utf16[0x1292] = 0x6498;
	__map_gbk2utf16[0x1293] = 0x649a;
	__map_gbk2utf16[0x1294] = 0x649b;
	__map_gbk2utf16[0x1295] = 0x649c;
	__map_gbk2utf16[0x1296] = 0x649d;
	__map_gbk2utf16[0x1297] = 0x649f;
	__map_gbk2utf16[0x1298] = 0x64a0;
	__map_gbk2utf16[0x1299] = 0x64a1;
	__map_gbk2utf16[0x129a] = 0x64a2;
	__map_gbk2utf16[0x129b] = 0x64a3;
	__map_gbk2utf16[0x129c] = 0x64a5;
	__map_gbk2utf16[0x129d] = 0x64a6;
	__map_gbk2utf16[0x129e] = 0x64a7;
	__map_gbk2utf16[0x129f] = 0x64a8;
	__map_gbk2utf16[0x12a0] = 0x64aa;
	__map_gbk2utf16[0x12a1] = 0x64ab;
	__map_gbk2utf16[0x12a2] = 0x64af;
	__map_gbk2utf16[0x12a3] = 0x64b1;
	__map_gbk2utf16[0x12a4] = 0x64b2;
	__map_gbk2utf16[0x12a5] = 0x64b3;
	__map_gbk2utf16[0x12a6] = 0x64b4;
	__map_gbk2utf16[0x12a7] = 0x64b6;
	__map_gbk2utf16[0x12a8] = 0x64b9;
	__map_gbk2utf16[0x12a9] = 0x64bb;
	__map_gbk2utf16[0x12aa] = 0x64bd;
	__map_gbk2utf16[0x12ab] = 0x64be;
	__map_gbk2utf16[0x12ac] = 0x64bf;
	__map_gbk2utf16[0x12ad] = 0x64c1;
	__map_gbk2utf16[0x12ae] = 0x64c3;
	__map_gbk2utf16[0x12af] = 0x64c4;
	__map_gbk2utf16[0x12b0] = 0x64c6;
	__map_gbk2utf16[0x12b1] = 0x64c7;
	__map_gbk2utf16[0x12b2] = 0x64c8;
	__map_gbk2utf16[0x12b3] = 0x64c9;
	__map_gbk2utf16[0x12b4] = 0x64ca;
	__map_gbk2utf16[0x12b5] = 0x64cb;
	__map_gbk2utf16[0x12b6] = 0x64cc;
	__map_gbk2utf16[0x12b7] = 0x64cf;
	__map_gbk2utf16[0x12b8] = 0x64d1;
	__map_gbk2utf16[0x12b9] = 0x64d3;
	__map_gbk2utf16[0x12ba] = 0x64d4;
	__map_gbk2utf16[0x12bb] = 0x64d5;
	__map_gbk2utf16[0x12bc] = 0x64d6;
	__map_gbk2utf16[0x12bd] = 0x64d9;
	__map_gbk2utf16[0x12be] = 0x64da;
	__map_gbk2utf16[0x1300] = 0x64db;
	__map_gbk2utf16[0x1301] = 0x64dc;
	__map_gbk2utf16[0x1302] = 0x64dd;
	__map_gbk2utf16[0x1303] = 0x64df;
	__map_gbk2utf16[0x1304] = 0x64e0;
	__map_gbk2utf16[0x1305] = 0x64e1;
	__map_gbk2utf16[0x1306] = 0x64e3;
	__map_gbk2utf16[0x1307] = 0x64e5;
	__map_gbk2utf16[0x1308] = 0x64e7;
	__map_gbk2utf16[0x1309] = 0x64e8;
	__map_gbk2utf16[0x130a] = 0x64e9;
	__map_gbk2utf16[0x130b] = 0x64ea;
	__map_gbk2utf16[0x130c] = 0x64eb;
	__map_gbk2utf16[0x130d] = 0x64ec;
	__map_gbk2utf16[0x130e] = 0x64ed;
	__map_gbk2utf16[0x130f] = 0x64ee;
	__map_gbk2utf16[0x1310] = 0x64ef;
	__map_gbk2utf16[0x1311] = 0x64f0;
	__map_gbk2utf16[0x1312] = 0x64f1;
	__map_gbk2utf16[0x1313] = 0x64f2;
	__map_gbk2utf16[0x1314] = 0x64f3;
	__map_gbk2utf16[0x1315] = 0x64f4;
	__map_gbk2utf16[0x1316] = 0x64f5;
	__map_gbk2utf16[0x1317] = 0x64f6;
	__map_gbk2utf16[0x1318] = 0x64f7;
	__map_gbk2utf16[0x1319] = 0x64f8;
	__map_gbk2utf16[0x131a] = 0x64f9;
	__map_gbk2utf16[0x131b] = 0x64fa;
	__map_gbk2utf16[0x131c] = 0x64fb;
	__map_gbk2utf16[0x131d] = 0x64fc;
	__map_gbk2utf16[0x131e] = 0x64fd;
	__map_gbk2utf16[0x131f] = 0x64fe;
	__map_gbk2utf16[0x1320] = 0x64ff;
	__map_gbk2utf16[0x1321] = 0x6501;
	__map_gbk2utf16[0x1322] = 0x6502;
	__map_gbk2utf16[0x1323] = 0x6503;
	__map_gbk2utf16[0x1324] = 0x6504;
	__map_gbk2utf16[0x1325] = 0x6505;
	__map_gbk2utf16[0x1326] = 0x6506;
	__map_gbk2utf16[0x1327] = 0x6507;
	__map_gbk2utf16[0x1328] = 0x6508;
	__map_gbk2utf16[0x1329] = 0x650a;
	__map_gbk2utf16[0x132a] = 0x650b;
	__map_gbk2utf16[0x132b] = 0x650c;
	__map_gbk2utf16[0x132c] = 0x650d;
	__map_gbk2utf16[0x132d] = 0x650e;
	__map_gbk2utf16[0x132e] = 0x650f;
	__map_gbk2utf16[0x132f] = 0x6510;
	__map_gbk2utf16[0x1330] = 0x6511;
	__map_gbk2utf16[0x1331] = 0x6513;
	__map_gbk2utf16[0x1332] = 0x6514;
	__map_gbk2utf16[0x1333] = 0x6515;
	__map_gbk2utf16[0x1334] = 0x6516;
	__map_gbk2utf16[0x1335] = 0x6517;
	__map_gbk2utf16[0x1336] = 0x6519;
	__map_gbk2utf16[0x1337] = 0x651a;
	__map_gbk2utf16[0x1338] = 0x651b;
	__map_gbk2utf16[0x1339] = 0x651c;
	__map_gbk2utf16[0x133a] = 0x651d;
	__map_gbk2utf16[0x133b] = 0x651e;
	__map_gbk2utf16[0x133c] = 0x651f;
	__map_gbk2utf16[0x133d] = 0x6520;
	__map_gbk2utf16[0x133e] = 0x6521;
	__map_gbk2utf16[0x1340] = 0x6522;
	__map_gbk2utf16[0x1341] = 0x6523;
	__map_gbk2utf16[0x1342] = 0x6524;
	__map_gbk2utf16[0x1343] = 0x6526;
	__map_gbk2utf16[0x1344] = 0x6527;
	__map_gbk2utf16[0x1345] = 0x6528;
	__map_gbk2utf16[0x1346] = 0x6529;
	__map_gbk2utf16[0x1347] = 0x652a;
	__map_gbk2utf16[0x1348] = 0x652c;
	__map_gbk2utf16[0x1349] = 0x652d;
	__map_gbk2utf16[0x134a] = 0x6530;
	__map_gbk2utf16[0x134b] = 0x6531;
	__map_gbk2utf16[0x134c] = 0x6532;
	__map_gbk2utf16[0x134d] = 0x6533;
	__map_gbk2utf16[0x134e] = 0x6537;
	__map_gbk2utf16[0x134f] = 0x653a;
	__map_gbk2utf16[0x1350] = 0x653c;
	__map_gbk2utf16[0x1351] = 0x653d;
	__map_gbk2utf16[0x1352] = 0x6540;
	__map_gbk2utf16[0x1353] = 0x6541;
	__map_gbk2utf16[0x1354] = 0x6542;
	__map_gbk2utf16[0x1355] = 0x6543;
	__map_gbk2utf16[0x1356] = 0x6544;
	__map_gbk2utf16[0x1357] = 0x6546;
	__map_gbk2utf16[0x1358] = 0x6547;
	__map_gbk2utf16[0x1359] = 0x654a;
	__map_gbk2utf16[0x135a] = 0x654b;
	__map_gbk2utf16[0x135b] = 0x654d;
	__map_gbk2utf16[0x135c] = 0x654e;
	__map_gbk2utf16[0x135d] = 0x6550;
	__map_gbk2utf16[0x135e] = 0x6552;
	__map_gbk2utf16[0x135f] = 0x6553;
	__map_gbk2utf16[0x1360] = 0x6554;
	__map_gbk2utf16[0x1361] = 0x6557;
	__map_gbk2utf16[0x1362] = 0x6558;
	__map_gbk2utf16[0x1363] = 0x655a;
	__map_gbk2utf16[0x1364] = 0x655c;
	__map_gbk2utf16[0x1365] = 0x655f;
	__map_gbk2utf16[0x1366] = 0x6560;
	__map_gbk2utf16[0x1367] = 0x6561;
	__map_gbk2utf16[0x1368] = 0x6564;
	__map_gbk2utf16[0x1369] = 0x6565;
	__map_gbk2utf16[0x136a] = 0x6567;
	__map_gbk2utf16[0x136b] = 0x6568;
	__map_gbk2utf16[0x136c] = 0x6569;
	__map_gbk2utf16[0x136d] = 0x656a;
	__map_gbk2utf16[0x136e] = 0x656d;
	__map_gbk2utf16[0x136f] = 0x656e;
	__map_gbk2utf16[0x1370] = 0x656f;
	__map_gbk2utf16[0x1371] = 0x6571;
	__map_gbk2utf16[0x1372] = 0x6573;
	__map_gbk2utf16[0x1373] = 0x6575;
	__map_gbk2utf16[0x1374] = 0x6576;
	__map_gbk2utf16[0x1375] = 0x6578;
	__map_gbk2utf16[0x1376] = 0x6579;
	__map_gbk2utf16[0x1377] = 0x657a;
	__map_gbk2utf16[0x1378] = 0x657b;
	__map_gbk2utf16[0x1379] = 0x657c;
	__map_gbk2utf16[0x137a] = 0x657d;
	__map_gbk2utf16[0x137b] = 0x657e;
	__map_gbk2utf16[0x137c] = 0x657f;
	__map_gbk2utf16[0x137d] = 0x6580;
	__map_gbk2utf16[0x137e] = 0x6581;
	__map_gbk2utf16[0x137f] = 0x6582;
	__map_gbk2utf16[0x1380] = 0x6583;
	__map_gbk2utf16[0x1381] = 0x6584;
	__map_gbk2utf16[0x1382] = 0x6585;
	__map_gbk2utf16[0x1383] = 0x6586;
	__map_gbk2utf16[0x1384] = 0x6588;
	__map_gbk2utf16[0x1385] = 0x6589;
	__map_gbk2utf16[0x1386] = 0x658a;
	__map_gbk2utf16[0x1387] = 0x658d;
	__map_gbk2utf16[0x1388] = 0x658e;
	__map_gbk2utf16[0x1389] = 0x658f;
	__map_gbk2utf16[0x138a] = 0x6592;
	__map_gbk2utf16[0x138b] = 0x6594;
	__map_gbk2utf16[0x138c] = 0x6595;
	__map_gbk2utf16[0x138d] = 0x6596;
	__map_gbk2utf16[0x138e] = 0x6598;
	__map_gbk2utf16[0x138f] = 0x659a;
	__map_gbk2utf16[0x1390] = 0x659d;
	__map_gbk2utf16[0x1391] = 0x659e;
	__map_gbk2utf16[0x1392] = 0x65a0;
	__map_gbk2utf16[0x1393] = 0x65a2;
	__map_gbk2utf16[0x1394] = 0x65a3;
	__map_gbk2utf16[0x1395] = 0x65a6;
	__map_gbk2utf16[0x1396] = 0x65a8;
	__map_gbk2utf16[0x1397] = 0x65aa;
	__map_gbk2utf16[0x1398] = 0x65ac;
	__map_gbk2utf16[0x1399] = 0x65ae;
	__map_gbk2utf16[0x139a] = 0x65b1;
	__map_gbk2utf16[0x139b] = 0x65b2;
	__map_gbk2utf16[0x139c] = 0x65b3;
	__map_gbk2utf16[0x139d] = 0x65b4;
	__map_gbk2utf16[0x139e] = 0x65b5;
	__map_gbk2utf16[0x139f] = 0x65b6;
	__map_gbk2utf16[0x13a0] = 0x65b7;
	__map_gbk2utf16[0x13a1] = 0x65b8;
	__map_gbk2utf16[0x13a2] = 0x65ba;
	__map_gbk2utf16[0x13a3] = 0x65bb;
	__map_gbk2utf16[0x13a4] = 0x65be;
	__map_gbk2utf16[0x13a5] = 0x65bf;
	__map_gbk2utf16[0x13a6] = 0x65c0;
	__map_gbk2utf16[0x13a7] = 0x65c2;
	__map_gbk2utf16[0x13a8] = 0x65c7;
	__map_gbk2utf16[0x13a9] = 0x65c8;
	__map_gbk2utf16[0x13aa] = 0x65c9;
	__map_gbk2utf16[0x13ab] = 0x65ca;
	__map_gbk2utf16[0x13ac] = 0x65cd;
	__map_gbk2utf16[0x13ad] = 0x65d0;
	__map_gbk2utf16[0x13ae] = 0x65d1;
	__map_gbk2utf16[0x13af] = 0x65d3;
	__map_gbk2utf16[0x13b0] = 0x65d4;
	__map_gbk2utf16[0x13b1] = 0x65d5;
	__map_gbk2utf16[0x13b2] = 0x65d8;
	__map_gbk2utf16[0x13b3] = 0x65d9;
	__map_gbk2utf16[0x13b4] = 0x65da;
	__map_gbk2utf16[0x13b5] = 0x65db;
	__map_gbk2utf16[0x13b6] = 0x65dc;
	__map_gbk2utf16[0x13b7] = 0x65dd;
	__map_gbk2utf16[0x13b8] = 0x65de;
	__map_gbk2utf16[0x13b9] = 0x65df;
	__map_gbk2utf16[0x13ba] = 0x65e1;
	__map_gbk2utf16[0x13bb] = 0x65e3;
	__map_gbk2utf16[0x13bc] = 0x65e4;
	__map_gbk2utf16[0x13bd] = 0x65ea;
	__map_gbk2utf16[0x13be] = 0x65eb;
	__map_gbk2utf16[0x1400] = 0x65f2;
	__map_gbk2utf16[0x1401] = 0x65f3;
	__map_gbk2utf16[0x1402] = 0x65f4;
	__map_gbk2utf16[0x1403] = 0x65f5;
	__map_gbk2utf16[0x1404] = 0x65f8;
	__map_gbk2utf16[0x1405] = 0x65f9;
	__map_gbk2utf16[0x1406] = 0x65fb;
	__map_gbk2utf16[0x1407] = 0x65fc;
	__map_gbk2utf16[0x1408] = 0x65fd;
	__map_gbk2utf16[0x1409] = 0x65fe;
	__map_gbk2utf16[0x140a] = 0x65ff;
	__map_gbk2utf16[0x140b] = 0x6601;
	__map_gbk2utf16[0x140c] = 0x6604;
	__map_gbk2utf16[0x140d] = 0x6605;
	__map_gbk2utf16[0x140e] = 0x6607;
	__map_gbk2utf16[0x140f] = 0x6608;
	__map_gbk2utf16[0x1410] = 0x6609;
	__map_gbk2utf16[0x1411] = 0x660b;
	__map_gbk2utf16[0x1412] = 0x660d;
	__map_gbk2utf16[0x1413] = 0x6610;
	__map_gbk2utf16[0x1414] = 0x6611;
	__map_gbk2utf16[0x1415] = 0x6612;
	__map_gbk2utf16[0x1416] = 0x6616;
	__map_gbk2utf16[0x1417] = 0x6617;
	__map_gbk2utf16[0x1418] = 0x6618;
	__map_gbk2utf16[0x1419] = 0x661a;
	__map_gbk2utf16[0x141a] = 0x661b;
	__map_gbk2utf16[0x141b] = 0x661c;
	__map_gbk2utf16[0x141c] = 0x661e;
	__map_gbk2utf16[0x141d] = 0x6621;
	__map_gbk2utf16[0x141e] = 0x6622;
	__map_gbk2utf16[0x141f] = 0x6623;
	__map_gbk2utf16[0x1420] = 0x6624;
	__map_gbk2utf16[0x1421] = 0x6626;
	__map_gbk2utf16[0x1422] = 0x6629;
	__map_gbk2utf16[0x1423] = 0x662a;
	__map_gbk2utf16[0x1424] = 0x662b;
	__map_gbk2utf16[0x1425] = 0x662c;
	__map_gbk2utf16[0x1426] = 0x662e;
	__map_gbk2utf16[0x1427] = 0x6630;
	__map_gbk2utf16[0x1428] = 0x6632;
	__map_gbk2utf16[0x1429] = 0x6633;
	__map_gbk2utf16[0x142a] = 0x6637;
	__map_gbk2utf16[0x142b] = 0x6638;
	__map_gbk2utf16[0x142c] = 0x6639;
	__map_gbk2utf16[0x142d] = 0x663a;
	__map_gbk2utf16[0x142e] = 0x663b;
	__map_gbk2utf16[0x142f] = 0x663d;
	__map_gbk2utf16[0x1430] = 0x663f;
	__map_gbk2utf16[0x1431] = 0x6640;
	__map_gbk2utf16[0x1432] = 0x6642;
	__map_gbk2utf16[0x1433] = 0x6644;
	__map_gbk2utf16[0x1434] = 0x6645;
	__map_gbk2utf16[0x1435] = 0x6646;
	__map_gbk2utf16[0x1436] = 0x6647;
	__map_gbk2utf16[0x1437] = 0x6648;
	__map_gbk2utf16[0x1438] = 0x6649;
	__map_gbk2utf16[0x1439] = 0x664a;
	__map_gbk2utf16[0x143a] = 0x664d;
	__map_gbk2utf16[0x143b] = 0x664e;
	__map_gbk2utf16[0x143c] = 0x6650;
	__map_gbk2utf16[0x143d] = 0x6651;
	__map_gbk2utf16[0x143e] = 0x6658;
	__map_gbk2utf16[0x1440] = 0x6659;
	__map_gbk2utf16[0x1441] = 0x665b;
	__map_gbk2utf16[0x1442] = 0x665c;
	__map_gbk2utf16[0x1443] = 0x665d;
	__map_gbk2utf16[0x1444] = 0x665e;
	__map_gbk2utf16[0x1445] = 0x6660;
	__map_gbk2utf16[0x1446] = 0x6662;
	__map_gbk2utf16[0x1447] = 0x6663;
	__map_gbk2utf16[0x1448] = 0x6665;
	__map_gbk2utf16[0x1449] = 0x6667;
	__map_gbk2utf16[0x144a] = 0x6669;
	__map_gbk2utf16[0x144b] = 0x666a;
	__map_gbk2utf16[0x144c] = 0x666b;
	__map_gbk2utf16[0x144d] = 0x666c;
	__map_gbk2utf16[0x144e] = 0x666d;
	__map_gbk2utf16[0x144f] = 0x6671;
	__map_gbk2utf16[0x1450] = 0x6672;
	__map_gbk2utf16[0x1451] = 0x6673;
	__map_gbk2utf16[0x1452] = 0x6675;
	__map_gbk2utf16[0x1453] = 0x6678;
	__map_gbk2utf16[0x1454] = 0x6679;
	__map_gbk2utf16[0x1455] = 0x667b;
	__map_gbk2utf16[0x1456] = 0x667c;
	__map_gbk2utf16[0x1457] = 0x667d;
	__map_gbk2utf16[0x1458] = 0x667f;
	__map_gbk2utf16[0x1459] = 0x6680;
	__map_gbk2utf16[0x145a] = 0x6681;
	__map_gbk2utf16[0x145b] = 0x6683;
	__map_gbk2utf16[0x145c] = 0x6685;
	__map_gbk2utf16[0x145d] = 0x6686;
	__map_gbk2utf16[0x145e] = 0x6688;
	__map_gbk2utf16[0x145f] = 0x6689;
	__map_gbk2utf16[0x1460] = 0x668a;
	__map_gbk2utf16[0x1461] = 0x668b;
	__map_gbk2utf16[0x1462] = 0x668d;
	__map_gbk2utf16[0x1463] = 0x668e;
	__map_gbk2utf16[0x1464] = 0x668f;
	__map_gbk2utf16[0x1465] = 0x6690;
	__map_gbk2utf16[0x1466] = 0x6692;
	__map_gbk2utf16[0x1467] = 0x6693;
	__map_gbk2utf16[0x1468] = 0x6694;
	__map_gbk2utf16[0x1469] = 0x6695;
	__map_gbk2utf16[0x146a] = 0x6698;
	__map_gbk2utf16[0x146b] = 0x6699;
	__map_gbk2utf16[0x146c] = 0x669a;
	__map_gbk2utf16[0x146d] = 0x669b;
	__map_gbk2utf16[0x146e] = 0x669c;
	__map_gbk2utf16[0x146f] = 0x669e;
	__map_gbk2utf16[0x1470] = 0x669f;
	__map_gbk2utf16[0x1471] = 0x66a0;
	__map_gbk2utf16[0x1472] = 0x66a1;
	__map_gbk2utf16[0x1473] = 0x66a2;
	__map_gbk2utf16[0x1474] = 0x66a3;
	__map_gbk2utf16[0x1475] = 0x66a4;
	__map_gbk2utf16[0x1476] = 0x66a5;
	__map_gbk2utf16[0x1477] = 0x66a6;
	__map_gbk2utf16[0x1478] = 0x66a9;
	__map_gbk2utf16[0x1479] = 0x66aa;
	__map_gbk2utf16[0x147a] = 0x66ab;
	__map_gbk2utf16[0x147b] = 0x66ac;
	__map_gbk2utf16[0x147c] = 0x66ad;
	__map_gbk2utf16[0x147d] = 0x66af;
	__map_gbk2utf16[0x147e] = 0x66b0;
	__map_gbk2utf16[0x147f] = 0x66b1;
	__map_gbk2utf16[0x1480] = 0x66b2;
	__map_gbk2utf16[0x1481] = 0x66b3;
	__map_gbk2utf16[0x1482] = 0x66b5;
	__map_gbk2utf16[0x1483] = 0x66b6;
	__map_gbk2utf16[0x1484] = 0x66b7;
	__map_gbk2utf16[0x1485] = 0x66b8;
	__map_gbk2utf16[0x1486] = 0x66ba;
	__map_gbk2utf16[0x1487] = 0x66bb;
	__map_gbk2utf16[0x1488] = 0x66bc;
	__map_gbk2utf16[0x1489] = 0x66bd;
	__map_gbk2utf16[0x148a] = 0x66bf;
	__map_gbk2utf16[0x148b] = 0x66c0;
	__map_gbk2utf16[0x148c] = 0x66c1;
	__map_gbk2utf16[0x148d] = 0x66c2;
	__map_gbk2utf16[0x148e] = 0x66c3;
	__map_gbk2utf16[0x148f] = 0x66c4;
	__map_gbk2utf16[0x1490] = 0x66c5;
	__map_gbk2utf16[0x1491] = 0x66c6;
	__map_gbk2utf16[0x1492] = 0x66c7;
	__map_gbk2utf16[0x1493] = 0x66c8;
	__map_gbk2utf16[0x1494] = 0x66c9;
	__map_gbk2utf16[0x1495] = 0x66ca;
	__map_gbk2utf16[0x1496] = 0x66cb;
	__map_gbk2utf16[0x1497] = 0x66cc;
	__map_gbk2utf16[0x1498] = 0x66cd;
	__map_gbk2utf16[0x1499] = 0x66ce;
	__map_gbk2utf16[0x149a] = 0x66cf;
	__map_gbk2utf16[0x149b] = 0x66d0;
	__map_gbk2utf16[0x149c] = 0x66d1;
	__map_gbk2utf16[0x149d] = 0x66d2;
	__map_gbk2utf16[0x149e] = 0x66d3;
	__map_gbk2utf16[0x149f] = 0x66d4;
	__map_gbk2utf16[0x14a0] = 0x66d5;
	__map_gbk2utf16[0x14a1] = 0x66d6;
	__map_gbk2utf16[0x14a2] = 0x66d7;
	__map_gbk2utf16[0x14a3] = 0x66d8;
	__map_gbk2utf16[0x14a4] = 0x66da;
	__map_gbk2utf16[0x14a5] = 0x66de;
	__map_gbk2utf16[0x14a6] = 0x66df;
	__map_gbk2utf16[0x14a7] = 0x66e0;
	__map_gbk2utf16[0x14a8] = 0x66e1;
	__map_gbk2utf16[0x14a9] = 0x66e2;
	__map_gbk2utf16[0x14aa] = 0x66e3;
	__map_gbk2utf16[0x14ab] = 0x66e4;
	__map_gbk2utf16[0x14ac] = 0x66e5;
	__map_gbk2utf16[0x14ad] = 0x66e7;
	__map_gbk2utf16[0x14ae] = 0x66e8;
	__map_gbk2utf16[0x14af] = 0x66ea;
	__map_gbk2utf16[0x14b0] = 0x66eb;
	__map_gbk2utf16[0x14b1] = 0x66ec;
	__map_gbk2utf16[0x14b2] = 0x66ed;
	__map_gbk2utf16[0x14b3] = 0x66ee;
	__map_gbk2utf16[0x14b4] = 0x66ef;
	__map_gbk2utf16[0x14b5] = 0x66f1;
	__map_gbk2utf16[0x14b6] = 0x66f5;
	__map_gbk2utf16[0x14b7] = 0x66f6;
	__map_gbk2utf16[0x14b8] = 0x66f8;
	__map_gbk2utf16[0x14b9] = 0x66fa;
	__map_gbk2utf16[0x14ba] = 0x66fb;
	__map_gbk2utf16[0x14bb] = 0x66fd;
	__map_gbk2utf16[0x14bc] = 0x6701;
	__map_gbk2utf16[0x14bd] = 0x6702;
	__map_gbk2utf16[0x14be] = 0x6703;
	__map_gbk2utf16[0x1500] = 0x6704;
	__map_gbk2utf16[0x1501] = 0x6705;
	__map_gbk2utf16[0x1502] = 0x6706;
	__map_gbk2utf16[0x1503] = 0x6707;
	__map_gbk2utf16[0x1504] = 0x670c;
	__map_gbk2utf16[0x1505] = 0x670e;
	__map_gbk2utf16[0x1506] = 0x670f;
	__map_gbk2utf16[0x1507] = 0x6711;
	__map_gbk2utf16[0x1508] = 0x6712;
	__map_gbk2utf16[0x1509] = 0x6713;
	__map_gbk2utf16[0x150a] = 0x6716;
	__map_gbk2utf16[0x150b] = 0x6718;
	__map_gbk2utf16[0x150c] = 0x6719;
	__map_gbk2utf16[0x150d] = 0x671a;
	__map_gbk2utf16[0x150e] = 0x671c;
	__map_gbk2utf16[0x150f] = 0x671e;
	__map_gbk2utf16[0x1510] = 0x6720;
	__map_gbk2utf16[0x1511] = 0x6721;
	__map_gbk2utf16[0x1512] = 0x6722;
	__map_gbk2utf16[0x1513] = 0x6723;
	__map_gbk2utf16[0x1514] = 0x6724;
	__map_gbk2utf16[0x1515] = 0x6725;
	__map_gbk2utf16[0x1516] = 0x6727;
	__map_gbk2utf16[0x1517] = 0x6729;
	__map_gbk2utf16[0x1518] = 0x672e;
	__map_gbk2utf16[0x1519] = 0x6730;
	__map_gbk2utf16[0x151a] = 0x6732;
	__map_gbk2utf16[0x151b] = 0x6733;
	__map_gbk2utf16[0x151c] = 0x6736;
	__map_gbk2utf16[0x151d] = 0x6737;
	__map_gbk2utf16[0x151e] = 0x6738;
	__map_gbk2utf16[0x151f] = 0x6739;
	__map_gbk2utf16[0x1520] = 0x673b;
	__map_gbk2utf16[0x1521] = 0x673c;
	__map_gbk2utf16[0x1522] = 0x673e;
	__map_gbk2utf16[0x1523] = 0x673f;
	__map_gbk2utf16[0x1524] = 0x6741;
	__map_gbk2utf16[0x1525] = 0x6744;
	__map_gbk2utf16[0x1526] = 0x6745;
	__map_gbk2utf16[0x1527] = 0x6747;
	__map_gbk2utf16[0x1528] = 0x674a;
	__map_gbk2utf16[0x1529] = 0x674b;
	__map_gbk2utf16[0x152a] = 0x674d;
	__map_gbk2utf16[0x152b] = 0x6752;
	__map_gbk2utf16[0x152c] = 0x6754;
	__map_gbk2utf16[0x152d] = 0x6755;
	__map_gbk2utf16[0x152e] = 0x6757;
	__map_gbk2utf16[0x152f] = 0x6758;
	__map_gbk2utf16[0x1530] = 0x6759;
	__map_gbk2utf16[0x1531] = 0x675a;
	__map_gbk2utf16[0x1532] = 0x675b;
	__map_gbk2utf16[0x1533] = 0x675d;
	__map_gbk2utf16[0x1534] = 0x6762;
	__map_gbk2utf16[0x1535] = 0x6763;
	__map_gbk2utf16[0x1536] = 0x6764;
	__map_gbk2utf16[0x1537] = 0x6766;
	__map_gbk2utf16[0x1538] = 0x6767;
	__map_gbk2utf16[0x1539] = 0x676b;
	__map_gbk2utf16[0x153a] = 0x676c;
	__map_gbk2utf16[0x153b] = 0x676e;
	__map_gbk2utf16[0x153c] = 0x6771;
	__map_gbk2utf16[0x153d] = 0x6774;
	__map_gbk2utf16[0x153e] = 0x6776;
	__map_gbk2utf16[0x1540] = 0x6778;
	__map_gbk2utf16[0x1541] = 0x6779;
	__map_gbk2utf16[0x1542] = 0x677a;
	__map_gbk2utf16[0x1543] = 0x677b;
	__map_gbk2utf16[0x1544] = 0x677d;
	__map_gbk2utf16[0x1545] = 0x6780;
	__map_gbk2utf16[0x1546] = 0x6782;
	__map_gbk2utf16[0x1547] = 0x6783;
	__map_gbk2utf16[0x1548] = 0x6785;
	__map_gbk2utf16[0x1549] = 0x6786;
	__map_gbk2utf16[0x154a] = 0x6788;
	__map_gbk2utf16[0x154b] = 0x678a;
	__map_gbk2utf16[0x154c] = 0x678c;
	__map_gbk2utf16[0x154d] = 0x678d;
	__map_gbk2utf16[0x154e] = 0x678e;
	__map_gbk2utf16[0x154f] = 0x678f;
	__map_gbk2utf16[0x1550] = 0x6791;
	__map_gbk2utf16[0x1551] = 0x6792;
	__map_gbk2utf16[0x1552] = 0x6793;
	__map_gbk2utf16[0x1553] = 0x6794;
	__map_gbk2utf16[0x1554] = 0x6796;
	__map_gbk2utf16[0x1555] = 0x6799;
	__map_gbk2utf16[0x1556] = 0x679b;
	__map_gbk2utf16[0x1557] = 0x679f;
	__map_gbk2utf16[0x1558] = 0x67a0;
	__map_gbk2utf16[0x1559] = 0x67a1;
	__map_gbk2utf16[0x155a] = 0x67a4;
	__map_gbk2utf16[0x155b] = 0x67a6;
	__map_gbk2utf16[0x155c] = 0x67a9;
	__map_gbk2utf16[0x155d] = 0x67ac;
	__map_gbk2utf16[0x155e] = 0x67ae;
	__map_gbk2utf16[0x155f] = 0x67b1;
	__map_gbk2utf16[0x1560] = 0x67b2;
	__map_gbk2utf16[0x1561] = 0x67b4;
	__map_gbk2utf16[0x1562] = 0x67b9;
	__map_gbk2utf16[0x1563] = 0x67ba;
	__map_gbk2utf16[0x1564] = 0x67bb;
	__map_gbk2utf16[0x1565] = 0x67bc;
	__map_gbk2utf16[0x1566] = 0x67bd;
	__map_gbk2utf16[0x1567] = 0x67be;
	__map_gbk2utf16[0x1568] = 0x67bf;
	__map_gbk2utf16[0x1569] = 0x67c0;
	__map_gbk2utf16[0x156a] = 0x67c2;
	__map_gbk2utf16[0x156b] = 0x67c5;
	__map_gbk2utf16[0x156c] = 0x67c6;
	__map_gbk2utf16[0x156d] = 0x67c7;
	__map_gbk2utf16[0x156e] = 0x67c8;
	__map_gbk2utf16[0x156f] = 0x67c9;
	__map_gbk2utf16[0x1570] = 0x67ca;
	__map_gbk2utf16[0x1571] = 0x67cb;
	__map_gbk2utf16[0x1572] = 0x67cc;
	__map_gbk2utf16[0x1573] = 0x67cd;
	__map_gbk2utf16[0x1574] = 0x67ce;
	__map_gbk2utf16[0x1575] = 0x67d5;
	__map_gbk2utf16[0x1576] = 0x67d6;
	__map_gbk2utf16[0x1577] = 0x67d7;
	__map_gbk2utf16[0x1578] = 0x67db;
	__map_gbk2utf16[0x1579] = 0x67df;
	__map_gbk2utf16[0x157a] = 0x67e1;
	__map_gbk2utf16[0x157b] = 0x67e3;
	__map_gbk2utf16[0x157c] = 0x67e4;
	__map_gbk2utf16[0x157d] = 0x67e6;
	__map_gbk2utf16[0x157e] = 0x67e7;
	__map_gbk2utf16[0x157f] = 0x67e8;
	__map_gbk2utf16[0x1580] = 0x67ea;
	__map_gbk2utf16[0x1581] = 0x67eb;
	__map_gbk2utf16[0x1582] = 0x67ed;
	__map_gbk2utf16[0x1583] = 0x67ee;
	__map_gbk2utf16[0x1584] = 0x67f2;
	__map_gbk2utf16[0x1585] = 0x67f5;
	__map_gbk2utf16[0x1586] = 0x67f6;
	__map_gbk2utf16[0x1587] = 0x67f7;
	__map_gbk2utf16[0x1588] = 0x67f8;
	__map_gbk2utf16[0x1589] = 0x67f9;
	__map_gbk2utf16[0x158a] = 0x67fa;
	__map_gbk2utf16[0x158b] = 0x67fb;
	__map_gbk2utf16[0x158c] = 0x67fc;
	__map_gbk2utf16[0x158d] = 0x67fe;
	__map_gbk2utf16[0x158e] = 0x6801;
	__map_gbk2utf16[0x158f] = 0x6802;
	__map_gbk2utf16[0x1590] = 0x6803;
	__map_gbk2utf16[0x1591] = 0x6804;
	__map_gbk2utf16[0x1592] = 0x6806;
	__map_gbk2utf16[0x1593] = 0x680d;
	__map_gbk2utf16[0x1594] = 0x6810;
	__map_gbk2utf16[0x1595] = 0x6812;
	__map_gbk2utf16[0x1596] = 0x6814;
	__map_gbk2utf16[0x1597] = 0x6815;
	__map_gbk2utf16[0x1598] = 0x6818;
	__map_gbk2utf16[0x1599] = 0x6819;
	__map_gbk2utf16[0x159a] = 0x681a;
	__map_gbk2utf16[0x159b] = 0x681b;
	__map_gbk2utf16[0x159c] = 0x681c;
	__map_gbk2utf16[0x159d] = 0x681e;
	__map_gbk2utf16[0x159e] = 0x681f;
	__map_gbk2utf16[0x159f] = 0x6820;
	__map_gbk2utf16[0x15a0] = 0x6822;
	__map_gbk2utf16[0x15a1] = 0x6823;
	__map_gbk2utf16[0x15a2] = 0x6824;
	__map_gbk2utf16[0x15a3] = 0x6825;
	__map_gbk2utf16[0x15a4] = 0x6826;
	__map_gbk2utf16[0x15a5] = 0x6827;
	__map_gbk2utf16[0x15a6] = 0x6828;
	__map_gbk2utf16[0x15a7] = 0x682b;
	__map_gbk2utf16[0x15a8] = 0x682c;
	__map_gbk2utf16[0x15a9] = 0x682d;
	__map_gbk2utf16[0x15aa] = 0x682e;
	__map_gbk2utf16[0x15ab] = 0x682f;
	__map_gbk2utf16[0x15ac] = 0x6830;
	__map_gbk2utf16[0x15ad] = 0x6831;
	__map_gbk2utf16[0x15ae] = 0x6834;
	__map_gbk2utf16[0x15af] = 0x6835;
	__map_gbk2utf16[0x15b0] = 0x6836;
	__map_gbk2utf16[0x15b1] = 0x683a;
	__map_gbk2utf16[0x15b2] = 0x683b;
	__map_gbk2utf16[0x15b3] = 0x683f;
	__map_gbk2utf16[0x15b4] = 0x6847;
	__map_gbk2utf16[0x15b5] = 0x684b;
	__map_gbk2utf16[0x15b6] = 0x684d;
	__map_gbk2utf16[0x15b7] = 0x684f;
	__map_gbk2utf16[0x15b8] = 0x6852;
	__map_gbk2utf16[0x15b9] = 0x6856;
	__map_gbk2utf16[0x15ba] = 0x6857;
	__map_gbk2utf16[0x15bb] = 0x6858;
	__map_gbk2utf16[0x15bc] = 0x6859;
	__map_gbk2utf16[0x15bd] = 0x685a;
	__map_gbk2utf16[0x15be] = 0x685b;
	__map_gbk2utf16[0x1600] = 0x685c;
	__map_gbk2utf16[0x1601] = 0x685d;
	__map_gbk2utf16[0x1602] = 0x685e;
	__map_gbk2utf16[0x1603] = 0x685f;
	__map_gbk2utf16[0x1604] = 0x686a;
	__map_gbk2utf16[0x1605] = 0x686c;
	__map_gbk2utf16[0x1606] = 0x686d;
	__map_gbk2utf16[0x1607] = 0x686e;
	__map_gbk2utf16[0x1608] = 0x686f;
	__map_gbk2utf16[0x1609] = 0x6870;
	__map_gbk2utf16[0x160a] = 0x6871;
	__map_gbk2utf16[0x160b] = 0x6872;
	__map_gbk2utf16[0x160c] = 0x6873;
	__map_gbk2utf16[0x160d] = 0x6875;
	__map_gbk2utf16[0x160e] = 0x6878;
	__map_gbk2utf16[0x160f] = 0x6879;
	__map_gbk2utf16[0x1610] = 0x687a;
	__map_gbk2utf16[0x1611] = 0x687b;
	__map_gbk2utf16[0x1612] = 0x687c;
	__map_gbk2utf16[0x1613] = 0x687d;
	__map_gbk2utf16[0x1614] = 0x687e;
	__map_gbk2utf16[0x1615] = 0x687f;
	__map_gbk2utf16[0x1616] = 0x6880;
	__map_gbk2utf16[0x1617] = 0x6882;
	__map_gbk2utf16[0x1618] = 0x6884;
	__map_gbk2utf16[0x1619] = 0x6887;
	__map_gbk2utf16[0x161a] = 0x6888;
	__map_gbk2utf16[0x161b] = 0x6889;
	__map_gbk2utf16[0x161c] = 0x688a;
	__map_gbk2utf16[0x161d] = 0x688b;
	__map_gbk2utf16[0x161e] = 0x688c;
	__map_gbk2utf16[0x161f] = 0x688d;
	__map_gbk2utf16[0x1620] = 0x688e;
	__map_gbk2utf16[0x1621] = 0x6890;
	__map_gbk2utf16[0x1622] = 0x6891;
	__map_gbk2utf16[0x1623] = 0x6892;
	__map_gbk2utf16[0x1624] = 0x6894;
	__map_gbk2utf16[0x1625] = 0x6895;
	__map_gbk2utf16[0x1626] = 0x6896;
	__map_gbk2utf16[0x1627] = 0x6898;
	__map_gbk2utf16[0x1628] = 0x6899;
	__map_gbk2utf16[0x1629] = 0x689a;
	__map_gbk2utf16[0x162a] = 0x689b;
	__map_gbk2utf16[0x162b] = 0x689c;
	__map_gbk2utf16[0x162c] = 0x689d;
	__map_gbk2utf16[0x162d] = 0x689e;
	__map_gbk2utf16[0x162e] = 0x689f;
	__map_gbk2utf16[0x162f] = 0x68a0;
	__map_gbk2utf16[0x1630] = 0x68a1;
	__map_gbk2utf16[0x1631] = 0x68a3;
	__map_gbk2utf16[0x1632] = 0x68a4;
	__map_gbk2utf16[0x1633] = 0x68a5;
	__map_gbk2utf16[0x1634] = 0x68a9;
	__map_gbk2utf16[0x1635] = 0x68aa;
	__map_gbk2utf16[0x1636] = 0x68ab;
	__map_gbk2utf16[0x1637] = 0x68ac;
	__map_gbk2utf16[0x1638] = 0x68ae;
	__map_gbk2utf16[0x1639] = 0x68b1;
	__map_gbk2utf16[0x163a] = 0x68b2;
	__map_gbk2utf16[0x163b] = 0x68b4;
	__map_gbk2utf16[0x163c] = 0x68b6;
	__map_gbk2utf16[0x163d] = 0x68b7;
	__map_gbk2utf16[0x163e] = 0x68b8;
	__map_gbk2utf16[0x1640] = 0x68b9;
	__map_gbk2utf16[0x1641] = 0x68ba;
	__map_gbk2utf16[0x1642] = 0x68bb;
	__map_gbk2utf16[0x1643] = 0x68bc;
	__map_gbk2utf16[0x1644] = 0x68bd;
	__map_gbk2utf16[0x1645] = 0x68be;
	__map_gbk2utf16[0x1646] = 0x68bf;
	__map_gbk2utf16[0x1647] = 0x68c1;
	__map_gbk2utf16[0x1648] = 0x68c3;
	__map_gbk2utf16[0x1649] = 0x68c4;
	__map_gbk2utf16[0x164a] = 0x68c5;
	__map_gbk2utf16[0x164b] = 0x68c6;
	__map_gbk2utf16[0x164c] = 0x68c7;
	__map_gbk2utf16[0x164d] = 0x68c8;
	__map_gbk2utf16[0x164e] = 0x68ca;
	__map_gbk2utf16[0x164f] = 0x68cc;
	__map_gbk2utf16[0x1650] = 0x68ce;
	__map_gbk2utf16[0x1651] = 0x68cf;
	__map_gbk2utf16[0x1652] = 0x68d0;
	__map_gbk2utf16[0x1653] = 0x68d1;
	__map_gbk2utf16[0x1654] = 0x68d3;
	__map_gbk2utf16[0x1655] = 0x68d4;
	__map_gbk2utf16[0x1656] = 0x68d6;
	__map_gbk2utf16[0x1657] = 0x68d7;
	__map_gbk2utf16[0x1658] = 0x68d9;
	__map_gbk2utf16[0x1659] = 0x68db;
	__map_gbk2utf16[0x165a] = 0x68dc;
	__map_gbk2utf16[0x165b] = 0x68dd;
	__map_gbk2utf16[0x165c] = 0x68de;
	__map_gbk2utf16[0x165d] = 0x68df;
	__map_gbk2utf16[0x165e] = 0x68e1;
	__map_gbk2utf16[0x165f] = 0x68e2;
	__map_gbk2utf16[0x1660] = 0x68e4;
	__map_gbk2utf16[0x1661] = 0x68e5;
	__map_gbk2utf16[0x1662] = 0x68e6;
	__map_gbk2utf16[0x1663] = 0x68e7;
	__map_gbk2utf16[0x1664] = 0x68e8;
	__map_gbk2utf16[0x1665] = 0x68e9;
	__map_gbk2utf16[0x1666] = 0x68ea;
	__map_gbk2utf16[0x1667] = 0x68eb;
	__map_gbk2utf16[0x1668] = 0x68ec;
	__map_gbk2utf16[0x1669] = 0x68ed;
	__map_gbk2utf16[0x166a] = 0x68ef;
	__map_gbk2utf16[0x166b] = 0x68f2;
	__map_gbk2utf16[0x166c] = 0x68f3;
	__map_gbk2utf16[0x166d] = 0x68f4;
	__map_gbk2utf16[0x166e] = 0x68f6;
	__map_gbk2utf16[0x166f] = 0x68f7;
	__map_gbk2utf16[0x1670] = 0x68f8;
	__map_gbk2utf16[0x1671] = 0x68fb;
	__map_gbk2utf16[0x1672] = 0x68fd;
	__map_gbk2utf16[0x1673] = 0x68fe;
	__map_gbk2utf16[0x1674] = 0x68ff;
	__map_gbk2utf16[0x1675] = 0x6900;
	__map_gbk2utf16[0x1676] = 0x6902;
	__map_gbk2utf16[0x1677] = 0x6903;
	__map_gbk2utf16[0x1678] = 0x6904;
	__map_gbk2utf16[0x1679] = 0x6906;
	__map_gbk2utf16[0x167a] = 0x6907;
	__map_gbk2utf16[0x167b] = 0x6908;
	__map_gbk2utf16[0x167c] = 0x6909;
	__map_gbk2utf16[0x167d] = 0x690a;
	__map_gbk2utf16[0x167e] = 0x690c;
	__map_gbk2utf16[0x167f] = 0x690f;
	__map_gbk2utf16[0x1680] = 0x6911;
	__map_gbk2utf16[0x1681] = 0x6913;
	__map_gbk2utf16[0x1682] = 0x6914;
	__map_gbk2utf16[0x1683] = 0x6915;
	__map_gbk2utf16[0x1684] = 0x6916;
	__map_gbk2utf16[0x1685] = 0x6917;
	__map_gbk2utf16[0x1686] = 0x6918;
	__map_gbk2utf16[0x1687] = 0x6919;
	__map_gbk2utf16[0x1688] = 0x691a;
	__map_gbk2utf16[0x1689] = 0x691b;
	__map_gbk2utf16[0x168a] = 0x691c;
	__map_gbk2utf16[0x168b] = 0x691d;
	__map_gbk2utf16[0x168c] = 0x691e;
	__map_gbk2utf16[0x168d] = 0x6921;
	__map_gbk2utf16[0x168e] = 0x6922;
	__map_gbk2utf16[0x168f] = 0x6923;
	__map_gbk2utf16[0x1690] = 0x6925;
	__map_gbk2utf16[0x1691] = 0x6926;
	__map_gbk2utf16[0x1692] = 0x6927;
	__map_gbk2utf16[0x1693] = 0x6928;
	__map_gbk2utf16[0x1694] = 0x6929;
	__map_gbk2utf16[0x1695] = 0x692a;
	__map_gbk2utf16[0x1696] = 0x692b;
	__map_gbk2utf16[0x1697] = 0x692c;
	__map_gbk2utf16[0x1698] = 0x692e;
	__map_gbk2utf16[0x1699] = 0x692f;
	__map_gbk2utf16[0x169a] = 0x6931;
	__map_gbk2utf16[0x169b] = 0x6932;
	__map_gbk2utf16[0x169c] = 0x6933;
	__map_gbk2utf16[0x169d] = 0x6935;
	__map_gbk2utf16[0x169e] = 0x6936;
	__map_gbk2utf16[0x169f] = 0x6937;
	__map_gbk2utf16[0x16a0] = 0x6938;
	__map_gbk2utf16[0x16a1] = 0x693a;
	__map_gbk2utf16[0x16a2] = 0x693b;
	__map_gbk2utf16[0x16a3] = 0x693c;
	__map_gbk2utf16[0x16a4] = 0x693e;
	__map_gbk2utf16[0x16a5] = 0x6940;
	__map_gbk2utf16[0x16a6] = 0x6941;
	__map_gbk2utf16[0x16a7] = 0x6943;
	__map_gbk2utf16[0x16a8] = 0x6944;
	__map_gbk2utf16[0x16a9] = 0x6945;
	__map_gbk2utf16[0x16aa] = 0x6946;
	__map_gbk2utf16[0x16ab] = 0x6947;
	__map_gbk2utf16[0x16ac] = 0x6948;
	__map_gbk2utf16[0x16ad] = 0x6949;
	__map_gbk2utf16[0x16ae] = 0x694a;
	__map_gbk2utf16[0x16af] = 0x694b;
	__map_gbk2utf16[0x16b0] = 0x694c;
	__map_gbk2utf16[0x16b1] = 0x694d;
	__map_gbk2utf16[0x16b2] = 0x694e;
	__map_gbk2utf16[0x16b3] = 0x694f;
	__map_gbk2utf16[0x16b4] = 0x6950;
	__map_gbk2utf16[0x16b5] = 0x6951;
	__map_gbk2utf16[0x16b6] = 0x6952;
	__map_gbk2utf16[0x16b7] = 0x6953;
	__map_gbk2utf16[0x16b8] = 0x6955;
	__map_gbk2utf16[0x16b9] = 0x6956;
	__map_gbk2utf16[0x16ba] = 0x6958;
	__map_gbk2utf16[0x16bb] = 0x6959;
	__map_gbk2utf16[0x16bc] = 0x695b;
	__map_gbk2utf16[0x16bd] = 0x695c;
	__map_gbk2utf16[0x16be] = 0x695f;
	__map_gbk2utf16[0x1700] = 0x6961;
	__map_gbk2utf16[0x1701] = 0x6962;
	__map_gbk2utf16[0x1702] = 0x6964;
	__map_gbk2utf16[0x1703] = 0x6965;
	__map_gbk2utf16[0x1704] = 0x6967;
	__map_gbk2utf16[0x1705] = 0x6968;
	__map_gbk2utf16[0x1706] = 0x6969;
	__map_gbk2utf16[0x1707] = 0x696a;
	__map_gbk2utf16[0x1708] = 0x696c;
	__map_gbk2utf16[0x1709] = 0x696d;
	__map_gbk2utf16[0x170a] = 0x696f;
	__map_gbk2utf16[0x170b] = 0x6970;
	__map_gbk2utf16[0x170c] = 0x6972;
	__map_gbk2utf16[0x170d] = 0x6973;
	__map_gbk2utf16[0x170e] = 0x6974;
	__map_gbk2utf16[0x170f] = 0x6975;
	__map_gbk2utf16[0x1710] = 0x6976;
	__map_gbk2utf16[0x1711] = 0x697a;
	__map_gbk2utf16[0x1712] = 0x697b;
	__map_gbk2utf16[0x1713] = 0x697d;
	__map_gbk2utf16[0x1714] = 0x697e;
	__map_gbk2utf16[0x1715] = 0x697f;
	__map_gbk2utf16[0x1716] = 0x6981;
	__map_gbk2utf16[0x1717] = 0x6983;
	__map_gbk2utf16[0x1718] = 0x6985;
	__map_gbk2utf16[0x1719] = 0x698a;
	__map_gbk2utf16[0x171a] = 0x698b;
	__map_gbk2utf16[0x171b] = 0x698c;
	__map_gbk2utf16[0x171c] = 0x698e;
	__map_gbk2utf16[0x171d] = 0x698f;
	__map_gbk2utf16[0x171e] = 0x6990;
	__map_gbk2utf16[0x171f] = 0x6991;
	__map_gbk2utf16[0x1720] = 0x6992;
	__map_gbk2utf16[0x1721] = 0x6993;
	__map_gbk2utf16[0x1722] = 0x6996;
	__map_gbk2utf16[0x1723] = 0x6997;
	__map_gbk2utf16[0x1724] = 0x6999;
	__map_gbk2utf16[0x1725] = 0x699a;
	__map_gbk2utf16[0x1726] = 0x699d;
	__map_gbk2utf16[0x1727] = 0x699e;
	__map_gbk2utf16[0x1728] = 0x699f;
	__map_gbk2utf16[0x1729] = 0x69a0;
	__map_gbk2utf16[0x172a] = 0x69a1;
	__map_gbk2utf16[0x172b] = 0x69a2;
	__map_gbk2utf16[0x172c] = 0x69a3;
	__map_gbk2utf16[0x172d] = 0x69a4;
	__map_gbk2utf16[0x172e] = 0x69a5;
	__map_gbk2utf16[0x172f] = 0x69a6;
	__map_gbk2utf16[0x1730] = 0x69a9;
	__map_gbk2utf16[0x1731] = 0x69aa;
	__map_gbk2utf16[0x1732] = 0x69ac;
	__map_gbk2utf16[0x1733] = 0x69ae;
	__map_gbk2utf16[0x1734] = 0x69af;
	__map_gbk2utf16[0x1735] = 0x69b0;
	__map_gbk2utf16[0x1736] = 0x69b2;
	__map_gbk2utf16[0x1737] = 0x69b3;
	__map_gbk2utf16[0x1738] = 0x69b5;
	__map_gbk2utf16[0x1739] = 0x69b6;
	__map_gbk2utf16[0x173a] = 0x69b8;
	__map_gbk2utf16[0x173b] = 0x69b9;
	__map_gbk2utf16[0x173c] = 0x69ba;
	__map_gbk2utf16[0x173d] = 0x69bc;
	__map_gbk2utf16[0x173e] = 0x69bd;
	__map_gbk2utf16[0x1740] = 0x69be;
	__map_gbk2utf16[0x1741] = 0x69bf;
	__map_gbk2utf16[0x1742] = 0x69c0;
	__map_gbk2utf16[0x1743] = 0x69c2;
	__map_gbk2utf16[0x1744] = 0x69c3;
	__map_gbk2utf16[0x1745] = 0x69c4;
	__map_gbk2utf16[0x1746] = 0x69c5;
	__map_gbk2utf16[0x1747] = 0x69c6;
	__map_gbk2utf16[0x1748] = 0x69c7;
	__map_gbk2utf16[0x1749] = 0x69c8;
	__map_gbk2utf16[0x174a] = 0x69c9;
	__map_gbk2utf16[0x174b] = 0x69cb;
	__map_gbk2utf16[0x174c] = 0x69cd;
	__map_gbk2utf16[0x174d] = 0x69cf;
	__map_gbk2utf16[0x174e] = 0x69d1;
	__map_gbk2utf16[0x174f] = 0x69d2;
	__map_gbk2utf16[0x1750] = 0x69d3;
	__map_gbk2utf16[0x1751] = 0x69d5;
	__map_gbk2utf16[0x1752] = 0x69d6;
	__map_gbk2utf16[0x1753] = 0x69d7;
	__map_gbk2utf16[0x1754] = 0x69d8;
	__map_gbk2utf16[0x1755] = 0x69d9;
	__map_gbk2utf16[0x1756] = 0x69da;
	__map_gbk2utf16[0x1757] = 0x69dc;
	__map_gbk2utf16[0x1758] = 0x69dd;
	__map_gbk2utf16[0x1759] = 0x69de;
	__map_gbk2utf16[0x175a] = 0x69e1;
	__map_gbk2utf16[0x175b] = 0x69e2;
	__map_gbk2utf16[0x175c] = 0x69e3;
	__map_gbk2utf16[0x175d] = 0x69e4;
	__map_gbk2utf16[0x175e] = 0x69e5;
	__map_gbk2utf16[0x175f] = 0x69e6;
	__map_gbk2utf16[0x1760] = 0x69e7;
	__map_gbk2utf16[0x1761] = 0x69e8;
	__map_gbk2utf16[0x1762] = 0x69e9;
	__map_gbk2utf16[0x1763] = 0x69ea;
	__map_gbk2utf16[0x1764] = 0x69eb;
	__map_gbk2utf16[0x1765] = 0x69ec;
	__map_gbk2utf16[0x1766] = 0x69ee;
	__map_gbk2utf16[0x1767] = 0x69ef;
	__map_gbk2utf16[0x1768] = 0x69f0;
	__map_gbk2utf16[0x1769] = 0x69f1;
	__map_gbk2utf16[0x176a] = 0x69f3;
	__map_gbk2utf16[0x176b] = 0x69f4;
	__map_gbk2utf16[0x176c] = 0x69f5;
	__map_gbk2utf16[0x176d] = 0x69f6;
	__map_gbk2utf16[0x176e] = 0x69f7;
	__map_gbk2utf16[0x176f] = 0x69f8;
	__map_gbk2utf16[0x1770] = 0x69f9;
	__map_gbk2utf16[0x1771] = 0x69fa;
	__map_gbk2utf16[0x1772] = 0x69fb;
	__map_gbk2utf16[0x1773] = 0x69fc;
	__map_gbk2utf16[0x1774] = 0x69fe;
	__map_gbk2utf16[0x1775] = 0x6a00;
	__map_gbk2utf16[0x1776] = 0x6a01;
	__map_gbk2utf16[0x1777] = 0x6a02;
	__map_gbk2utf16[0x1778] = 0x6a03;
	__map_gbk2utf16[0x1779] = 0x6a04;
	__map_gbk2utf16[0x177a] = 0x6a05;
	__map_gbk2utf16[0x177b] = 0x6a06;
	__map_gbk2utf16[0x177c] = 0x6a07;
	__map_gbk2utf16[0x177d] = 0x6a08;
	__map_gbk2utf16[0x177e] = 0x6a09;
	__map_gbk2utf16[0x177f] = 0x6a0b;
	__map_gbk2utf16[0x1780] = 0x6a0c;
	__map_gbk2utf16[0x1781] = 0x6a0d;
	__map_gbk2utf16[0x1782] = 0x6a0e;
	__map_gbk2utf16[0x1783] = 0x6a0f;
	__map_gbk2utf16[0x1784] = 0x6a10;
	__map_gbk2utf16[0x1785] = 0x6a11;
	__map_gbk2utf16[0x1786] = 0x6a12;
	__map_gbk2utf16[0x1787] = 0x6a13;
	__map_gbk2utf16[0x1788] = 0x6a14;
	__map_gbk2utf16[0x1789] = 0x6a15;
	__map_gbk2utf16[0x178a] = 0x6a16;
	__map_gbk2utf16[0x178b] = 0x6a19;
	__map_gbk2utf16[0x178c] = 0x6a1a;
	__map_gbk2utf16[0x178d] = 0x6a1b;
	__map_gbk2utf16[0x178e] = 0x6a1c;
	__map_gbk2utf16[0x178f] = 0x6a1d;
	__map_gbk2utf16[0x1790] = 0x6a1e;
	__map_gbk2utf16[0x1791] = 0x6a20;
	__map_gbk2utf16[0x1792] = 0x6a22;
	__map_gbk2utf16[0x1793] = 0x6a23;
	__map_gbk2utf16[0x1794] = 0x6a24;
	__map_gbk2utf16[0x1795] = 0x6a25;
	__map_gbk2utf16[0x1796] = 0x6a26;
	__map_gbk2utf16[0x1797] = 0x6a27;
	__map_gbk2utf16[0x1798] = 0x6a29;
	__map_gbk2utf16[0x1799] = 0x6a2b;
	__map_gbk2utf16[0x179a] = 0x6a2c;
	__map_gbk2utf16[0x179b] = 0x6a2d;
	__map_gbk2utf16[0x179c] = 0x6a2e;
	__map_gbk2utf16[0x179d] = 0x6a30;
	__map_gbk2utf16[0x179e] = 0x6a32;
	__map_gbk2utf16[0x179f] = 0x6a33;
	__map_gbk2utf16[0x17a0] = 0x6a34;
	__map_gbk2utf16[0x17a1] = 0x6a36;
	__map_gbk2utf16[0x17a2] = 0x6a37;
	__map_gbk2utf16[0x17a3] = 0x6a38;
	__map_gbk2utf16[0x17a4] = 0x6a39;
	__map_gbk2utf16[0x17a5] = 0x6a3a;
	__map_gbk2utf16[0x17a6] = 0x6a3b;
	__map_gbk2utf16[0x17a7] = 0x6a3c;
	__map_gbk2utf16[0x17a8] = 0x6a3f;
	__map_gbk2utf16[0x17a9] = 0x6a40;
	__map_gbk2utf16[0x17aa] = 0x6a41;
	__map_gbk2utf16[0x17ab] = 0x6a42;
	__map_gbk2utf16[0x17ac] = 0x6a43;
	__map_gbk2utf16[0x17ad] = 0x6a45;
	__map_gbk2utf16[0x17ae] = 0x6a46;
	__map_gbk2utf16[0x17af] = 0x6a48;
	__map_gbk2utf16[0x17b0] = 0x6a49;
	__map_gbk2utf16[0x17b1] = 0x6a4a;
	__map_gbk2utf16[0x17b2] = 0x6a4b;
	__map_gbk2utf16[0x17b3] = 0x6a4c;
	__map_gbk2utf16[0x17b4] = 0x6a4d;
	__map_gbk2utf16[0x17b5] = 0x6a4e;
	__map_gbk2utf16[0x17b6] = 0x6a4f;
	__map_gbk2utf16[0x17b7] = 0x6a51;
	__map_gbk2utf16[0x17b8] = 0x6a52;
	__map_gbk2utf16[0x17b9] = 0x6a53;
	__map_gbk2utf16[0x17ba] = 0x6a54;
	__map_gbk2utf16[0x17bb] = 0x6a55;
	__map_gbk2utf16[0x17bc] = 0x6a56;
	__map_gbk2utf16[0x17bd] = 0x6a57;
	__map_gbk2utf16[0x17be] = 0x6a5a;
	__map_gbk2utf16[0x1800] = 0x6a5c;
	__map_gbk2utf16[0x1801] = 0x6a5d;
	__map_gbk2utf16[0x1802] = 0x6a5e;
	__map_gbk2utf16[0x1803] = 0x6a5f;
	__map_gbk2utf16[0x1804] = 0x6a60;
	__map_gbk2utf16[0x1805] = 0x6a62;
	__map_gbk2utf16[0x1806] = 0x6a63;
	__map_gbk2utf16[0x1807] = 0x6a64;
	__map_gbk2utf16[0x1808] = 0x6a66;
	__map_gbk2utf16[0x1809] = 0x6a67;
	__map_gbk2utf16[0x180a] = 0x6a68;
	__map_gbk2utf16[0x180b] = 0x6a69;
	__map_gbk2utf16[0x180c] = 0x6a6a;
	__map_gbk2utf16[0x180d] = 0x6a6b;
	__map_gbk2utf16[0x180e] = 0x6a6c;
	__map_gbk2utf16[0x180f] = 0x6a6d;
	__map_gbk2utf16[0x1810] = 0x6a6e;
	__map_gbk2utf16[0x1811] = 0x6a6f;
	__map_gbk2utf16[0x1812] = 0x6a70;
	__map_gbk2utf16[0x1813] = 0x6a72;
	__map_gbk2utf16[0x1814] = 0x6a73;
	__map_gbk2utf16[0x1815] = 0x6a74;
	__map_gbk2utf16[0x1816] = 0x6a75;
	__map_gbk2utf16[0x1817] = 0x6a76;
	__map_gbk2utf16[0x1818] = 0x6a77;
	__map_gbk2utf16[0x1819] = 0x6a78;
	__map_gbk2utf16[0x181a] = 0x6a7a;
	__map_gbk2utf16[0x181b] = 0x6a7b;
	__map_gbk2utf16[0x181c] = 0x6a7d;
	__map_gbk2utf16[0x181d] = 0x6a7e;
	__map_gbk2utf16[0x181e] = 0x6a7f;
	__map_gbk2utf16[0x181f] = 0x6a81;
	__map_gbk2utf16[0x1820] = 0x6a82;
	__map_gbk2utf16[0x1821] = 0x6a83;
	__map_gbk2utf16[0x1822] = 0x6a85;
	__map_gbk2utf16[0x1823] = 0x6a86;
	__map_gbk2utf16[0x1824] = 0x6a87;
	__map_gbk2utf16[0x1825] = 0x6a88;
	__map_gbk2utf16[0x1826] = 0x6a89;
	__map_gbk2utf16[0x1827] = 0x6a8a;
	__map_gbk2utf16[0x1828] = 0x6a8b;
	__map_gbk2utf16[0x1829] = 0x6a8c;
	__map_gbk2utf16[0x182a] = 0x6a8d;
	__map_gbk2utf16[0x182b] = 0x6a8f;
	__map_gbk2utf16[0x182c] = 0x6a92;
	__map_gbk2utf16[0x182d] = 0x6a93;
	__map_gbk2utf16[0x182e] = 0x6a94;
	__map_gbk2utf16[0x182f] = 0x6a95;
	__map_gbk2utf16[0x1830] = 0x6a96;
	__map_gbk2utf16[0x1831] = 0x6a98;
	__map_gbk2utf16[0x1832] = 0x6a99;
	__map_gbk2utf16[0x1833] = 0x6a9a;
	__map_gbk2utf16[0x1834] = 0x6a9b;
	__map_gbk2utf16[0x1835] = 0x6a9c;
	__map_gbk2utf16[0x1836] = 0x6a9d;
	__map_gbk2utf16[0x1837] = 0x6a9e;
	__map_gbk2utf16[0x1838] = 0x6a9f;
	__map_gbk2utf16[0x1839] = 0x6aa1;
	__map_gbk2utf16[0x183a] = 0x6aa2;
	__map_gbk2utf16[0x183b] = 0x6aa3;
	__map_gbk2utf16[0x183c] = 0x6aa4;
	__map_gbk2utf16[0x183d] = 0x6aa5;
	__map_gbk2utf16[0x183e] = 0x6aa6;
	__map_gbk2utf16[0x1840] = 0x6aa7;
	__map_gbk2utf16[0x1841] = 0x6aa8;
	__map_gbk2utf16[0x1842] = 0x6aaa;
	__map_gbk2utf16[0x1843] = 0x6aad;
	__map_gbk2utf16[0x1844] = 0x6aae;
	__map_gbk2utf16[0x1845] = 0x6aaf;
	__map_gbk2utf16[0x1846] = 0x6ab0;
	__map_gbk2utf16[0x1847] = 0x6ab1;
	__map_gbk2utf16[0x1848] = 0x6ab2;
	__map_gbk2utf16[0x1849] = 0x6ab3;
	__map_gbk2utf16[0x184a] = 0x6ab4;
	__map_gbk2utf16[0x184b] = 0x6ab5;
	__map_gbk2utf16[0x184c] = 0x6ab6;
	__map_gbk2utf16[0x184d] = 0x6ab7;
	__map_gbk2utf16[0x184e] = 0x6ab8;
	__map_gbk2utf16[0x184f] = 0x6ab9;
	__map_gbk2utf16[0x1850] = 0x6aba;
	__map_gbk2utf16[0x1851] = 0x6abb;
	__map_gbk2utf16[0x1852] = 0x6abc;
	__map_gbk2utf16[0x1853] = 0x6abd;
	__map_gbk2utf16[0x1854] = 0x6abe;
	__map_gbk2utf16[0x1855] = 0x6abf;
	__map_gbk2utf16[0x1856] = 0x6ac0;
	__map_gbk2utf16[0x1857] = 0x6ac1;
	__map_gbk2utf16[0x1858] = 0x6ac2;
	__map_gbk2utf16[0x1859] = 0x6ac3;
	__map_gbk2utf16[0x185a] = 0x6ac4;
	__map_gbk2utf16[0x185b] = 0x6ac5;
	__map_gbk2utf16[0x185c] = 0x6ac6;
	__map_gbk2utf16[0x185d] = 0x6ac7;
	__map_gbk2utf16[0x185e] = 0x6ac8;
	__map_gbk2utf16[0x185f] = 0x6ac9;
	__map_gbk2utf16[0x1860] = 0x6aca;
	__map_gbk2utf16[0x1861] = 0x6acb;
	__map_gbk2utf16[0x1862] = 0x6acc;
	__map_gbk2utf16[0x1863] = 0x6acd;
	__map_gbk2utf16[0x1864] = 0x6ace;
	__map_gbk2utf16[0x1865] = 0x6acf;
	__map_gbk2utf16[0x1866] = 0x6ad0;
	__map_gbk2utf16[0x1867] = 0x6ad1;
	__map_gbk2utf16[0x1868] = 0x6ad2;
	__map_gbk2utf16[0x1869] = 0x6ad3;
	__map_gbk2utf16[0x186a] = 0x6ad4;
	__map_gbk2utf16[0x186b] = 0x6ad5;
	__map_gbk2utf16[0x186c] = 0x6ad6;
	__map_gbk2utf16[0x186d] = 0x6ad7;
	__map_gbk2utf16[0x186e] = 0x6ad8;
	__map_gbk2utf16[0x186f] = 0x6ad9;
	__map_gbk2utf16[0x1870] = 0x6ada;
	__map_gbk2utf16[0x1871] = 0x6adb;
	__map_gbk2utf16[0x1872] = 0x6adc;
	__map_gbk2utf16[0x1873] = 0x6add;
	__map_gbk2utf16[0x1874] = 0x6ade;
	__map_gbk2utf16[0x1875] = 0x6adf;
	__map_gbk2utf16[0x1876] = 0x6ae0;
	__map_gbk2utf16[0x1877] = 0x6ae1;
	__map_gbk2utf16[0x1878] = 0x6ae2;
	__map_gbk2utf16[0x1879] = 0x6ae3;
	__map_gbk2utf16[0x187a] = 0x6ae4;
	__map_gbk2utf16[0x187b] = 0x6ae5;
	__map_gbk2utf16[0x187c] = 0x6ae6;
	__map_gbk2utf16[0x187d] = 0x6ae7;
	__map_gbk2utf16[0x187e] = 0x6ae8;
	__map_gbk2utf16[0x187f] = 0x6ae9;
	__map_gbk2utf16[0x1880] = 0x6aea;
	__map_gbk2utf16[0x1881] = 0x6aeb;
	__map_gbk2utf16[0x1882] = 0x6aec;
	__map_gbk2utf16[0x1883] = 0x6aed;
	__map_gbk2utf16[0x1884] = 0x6aee;
	__map_gbk2utf16[0x1885] = 0x6aef;
	__map_gbk2utf16[0x1886] = 0x6af0;
	__map_gbk2utf16[0x1887] = 0x6af1;
	__map_gbk2utf16[0x1888] = 0x6af2;
	__map_gbk2utf16[0x1889] = 0x6af3;
	__map_gbk2utf16[0x188a] = 0x6af4;
	__map_gbk2utf16[0x188b] = 0x6af5;
	__map_gbk2utf16[0x188c] = 0x6af6;
	__map_gbk2utf16[0x188d] = 0x6af7;
	__map_gbk2utf16[0x188e] = 0x6af8;
	__map_gbk2utf16[0x188f] = 0x6af9;
	__map_gbk2utf16[0x1890] = 0x6afa;
	__map_gbk2utf16[0x1891] = 0x6afb;
	__map_gbk2utf16[0x1892] = 0x6afc;
	__map_gbk2utf16[0x1893] = 0x6afd;
	__map_gbk2utf16[0x1894] = 0x6afe;
	__map_gbk2utf16[0x1895] = 0x6aff;
	__map_gbk2utf16[0x1896] = 0x6b00;
	__map_gbk2utf16[0x1897] = 0x6b01;
	__map_gbk2utf16[0x1898] = 0x6b02;
	__map_gbk2utf16[0x1899] = 0x6b03;
	__map_gbk2utf16[0x189a] = 0x6b04;
	__map_gbk2utf16[0x189b] = 0x6b05;
	__map_gbk2utf16[0x189c] = 0x6b06;
	__map_gbk2utf16[0x189d] = 0x6b07;
	__map_gbk2utf16[0x189e] = 0x6b08;
	__map_gbk2utf16[0x189f] = 0x6b09;
	__map_gbk2utf16[0x18a0] = 0x6b0a;
	__map_gbk2utf16[0x18a1] = 0x6b0b;
	__map_gbk2utf16[0x18a2] = 0x6b0c;
	__map_gbk2utf16[0x18a3] = 0x6b0d;
	__map_gbk2utf16[0x18a4] = 0x6b0e;
	__map_gbk2utf16[0x18a5] = 0x6b0f;
	__map_gbk2utf16[0x18a6] = 0x6b10;
	__map_gbk2utf16[0x18a7] = 0x6b11;
	__map_gbk2utf16[0x18a8] = 0x6b12;
	__map_gbk2utf16[0x18a9] = 0x6b13;
	__map_gbk2utf16[0x18aa] = 0x6b14;
	__map_gbk2utf16[0x18ab] = 0x6b15;
	__map_gbk2utf16[0x18ac] = 0x6b16;
	__map_gbk2utf16[0x18ad] = 0x6b17;
	__map_gbk2utf16[0x18ae] = 0x6b18;
	__map_gbk2utf16[0x18af] = 0x6b19;
	__map_gbk2utf16[0x18b0] = 0x6b1a;
	__map_gbk2utf16[0x18b1] = 0x6b1b;
	__map_gbk2utf16[0x18b2] = 0x6b1c;
	__map_gbk2utf16[0x18b3] = 0x6b1d;
	__map_gbk2utf16[0x18b4] = 0x6b1e;
	__map_gbk2utf16[0x18b5] = 0x6b1f;
	__map_gbk2utf16[0x18b6] = 0x6b25;
	__map_gbk2utf16[0x18b7] = 0x6b26;
	__map_gbk2utf16[0x18b8] = 0x6b28;
	__map_gbk2utf16[0x18b9] = 0x6b29;
	__map_gbk2utf16[0x18ba] = 0x6b2a;
	__map_gbk2utf16[0x18bb] = 0x6b2b;
	__map_gbk2utf16[0x18bc] = 0x6b2c;
	__map_gbk2utf16[0x18bd] = 0x6b2d;
	__map_gbk2utf16[0x18be] = 0x6b2e;
	__map_gbk2utf16[0x1900] = 0x6b2f;
	__map_gbk2utf16[0x1901] = 0x6b30;
	__map_gbk2utf16[0x1902] = 0x6b31;
	__map_gbk2utf16[0x1903] = 0x6b33;
	__map_gbk2utf16[0x1904] = 0x6b34;
	__map_gbk2utf16[0x1905] = 0x6b35;
	__map_gbk2utf16[0x1906] = 0x6b36;
	__map_gbk2utf16[0x1907] = 0x6b38;
	__map_gbk2utf16[0x1908] = 0x6b3b;
	__map_gbk2utf16[0x1909] = 0x6b3c;
	__map_gbk2utf16[0x190a] = 0x6b3d;
	__map_gbk2utf16[0x190b] = 0x6b3f;
	__map_gbk2utf16[0x190c] = 0x6b40;
	__map_gbk2utf16[0x190d] = 0x6b41;
	__map_gbk2utf16[0x190e] = 0x6b42;
	__map_gbk2utf16[0x190f] = 0x6b44;
	__map_gbk2utf16[0x1910] = 0x6b45;
	__map_gbk2utf16[0x1911] = 0x6b48;
	__map_gbk2utf16[0x1912] = 0x6b4a;
	__map_gbk2utf16[0x1913] = 0x6b4b;
	__map_gbk2utf16[0x1914] = 0x6b4d;
	__map_gbk2utf16[0x1915] = 0x6b4e;
	__map_gbk2utf16[0x1916] = 0x6b4f;
	__map_gbk2utf16[0x1917] = 0x6b50;
	__map_gbk2utf16[0x1918] = 0x6b51;
	__map_gbk2utf16[0x1919] = 0x6b52;
	__map_gbk2utf16[0x191a] = 0x6b53;
	__map_gbk2utf16[0x191b] = 0x6b54;
	__map_gbk2utf16[0x191c] = 0x6b55;
	__map_gbk2utf16[0x191d] = 0x6b56;
	__map_gbk2utf16[0x191e] = 0x6b57;
	__map_gbk2utf16[0x191f] = 0x6b58;
	__map_gbk2utf16[0x1920] = 0x6b5a;
	__map_gbk2utf16[0x1921] = 0x6b5b;
	__map_gbk2utf16[0x1922] = 0x6b5c;
	__map_gbk2utf16[0x1923] = 0x6b5d;
	__map_gbk2utf16[0x1924] = 0x6b5e;
	__map_gbk2utf16[0x1925] = 0x6b5f;
	__map_gbk2utf16[0x1926] = 0x6b60;
	__map_gbk2utf16[0x1927] = 0x6b61;
	__map_gbk2utf16[0x1928] = 0x6b68;
	__map_gbk2utf16[0x1929] = 0x6b69;
	__map_gbk2utf16[0x192a] = 0x6b6b;
	__map_gbk2utf16[0x192b] = 0x6b6c;
	__map_gbk2utf16[0x192c] = 0x6b6d;
	__map_gbk2utf16[0x192d] = 0x6b6e;
	__map_gbk2utf16[0x192e] = 0x6b6f;
	__map_gbk2utf16[0x192f] = 0x6b70;
	__map_gbk2utf16[0x1930] = 0x6b71;
	__map_gbk2utf16[0x1931] = 0x6b72;
	__map_gbk2utf16[0x1932] = 0x6b73;
	__map_gbk2utf16[0x1933] = 0x6b74;
	__map_gbk2utf16[0x1934] = 0x6b75;
	__map_gbk2utf16[0x1935] = 0x6b76;
	__map_gbk2utf16[0x1936] = 0x6b77;
	__map_gbk2utf16[0x1937] = 0x6b78;
	__map_gbk2utf16[0x1938] = 0x6b7a;
	__map_gbk2utf16[0x1939] = 0x6b7d;
	__map_gbk2utf16[0x193a] = 0x6b7e;
	__map_gbk2utf16[0x193b] = 0x6b7f;
	__map_gbk2utf16[0x193c] = 0x6b80;
	__map_gbk2utf16[0x193d] = 0x6b85;
	__map_gbk2utf16[0x193e] = 0x6b88;
	__map_gbk2utf16[0x1940] = 0x6b8c;
	__map_gbk2utf16[0x1941] = 0x6b8e;
	__map_gbk2utf16[0x1942] = 0x6b8f;
	__map_gbk2utf16[0x1943] = 0x6b90;
	__map_gbk2utf16[0x1944] = 0x6b91;
	__map_gbk2utf16[0x1945] = 0x6b94;
	__map_gbk2utf16[0x1946] = 0x6b95;
	__map_gbk2utf16[0x1947] = 0x6b97;
	__map_gbk2utf16[0x1948] = 0x6b98;
	__map_gbk2utf16[0x1949] = 0x6b99;
	__map_gbk2utf16[0x194a] = 0x6b9c;
	__map_gbk2utf16[0x194b] = 0x6b9d;
	__map_gbk2utf16[0x194c] = 0x6b9e;
	__map_gbk2utf16[0x194d] = 0x6b9f;
	__map_gbk2utf16[0x194e] = 0x6ba0;
	__map_gbk2utf16[0x194f] = 0x6ba2;
	__map_gbk2utf16[0x1950] = 0x6ba3;
	__map_gbk2utf16[0x1951] = 0x6ba4;
	__map_gbk2utf16[0x1952] = 0x6ba5;
	__map_gbk2utf16[0x1953] = 0x6ba6;
	__map_gbk2utf16[0x1954] = 0x6ba7;
	__map_gbk2utf16[0x1955] = 0x6ba8;
	__map_gbk2utf16[0x1956] = 0x6ba9;
	__map_gbk2utf16[0x1957] = 0x6bab;
	__map_gbk2utf16[0x1958] = 0x6bac;
	__map_gbk2utf16[0x1959] = 0x6bad;
	__map_gbk2utf16[0x195a] = 0x6bae;
	__map_gbk2utf16[0x195b] = 0x6baf;
	__map_gbk2utf16[0x195c] = 0x6bb0;
	__map_gbk2utf16[0x195d] = 0x6bb1;
	__map_gbk2utf16[0x195e] = 0x6bb2;
	__map_gbk2utf16[0x195f] = 0x6bb6;
	__map_gbk2utf16[0x1960] = 0x6bb8;
	__map_gbk2utf16[0x1961] = 0x6bb9;
	__map_gbk2utf16[0x1962] = 0x6bba;
	__map_gbk2utf16[0x1963] = 0x6bbb;
	__map_gbk2utf16[0x1964] = 0x6bbc;
	__map_gbk2utf16[0x1965] = 0x6bbd;
	__map_gbk2utf16[0x1966] = 0x6bbe;
	__map_gbk2utf16[0x1967] = 0x6bc0;
	__map_gbk2utf16[0x1968] = 0x6bc3;
	__map_gbk2utf16[0x1969] = 0x6bc4;
	__map_gbk2utf16[0x196a] = 0x6bc6;
	__map_gbk2utf16[0x196b] = 0x6bc7;
	__map_gbk2utf16[0x196c] = 0x6bc8;
	__map_gbk2utf16[0x196d] = 0x6bc9;
	__map_gbk2utf16[0x196e] = 0x6bca;
	__map_gbk2utf16[0x196f] = 0x6bcc;
	__map_gbk2utf16[0x1970] = 0x6bce;
	__map_gbk2utf16[0x1971] = 0x6bd0;
	__map_gbk2utf16[0x1972] = 0x6bd1;
	__map_gbk2utf16[0x1973] = 0x6bd8;
	__map_gbk2utf16[0x1974] = 0x6bda;
	__map_gbk2utf16[0x1975] = 0x6bdc;
	__map_gbk2utf16[0x1976] = 0x6bdd;
	__map_gbk2utf16[0x1977] = 0x6bde;
	__map_gbk2utf16[0x1978] = 0x6bdf;
	__map_gbk2utf16[0x1979] = 0x6be0;
	__map_gbk2utf16[0x197a] = 0x6be2;
	__map_gbk2utf16[0x197b] = 0x6be3;
	__map_gbk2utf16[0x197c] = 0x6be4;
	__map_gbk2utf16[0x197d] = 0x6be5;
	__map_gbk2utf16[0x197e] = 0x6be6;
	__map_gbk2utf16[0x197f] = 0x6be7;
	__map_gbk2utf16[0x1980] = 0x6be8;
	__map_gbk2utf16[0x1981] = 0x6be9;
	__map_gbk2utf16[0x1982] = 0x6bec;
	__map_gbk2utf16[0x1983] = 0x6bed;
	__map_gbk2utf16[0x1984] = 0x6bee;
	__map_gbk2utf16[0x1985] = 0x6bf0;
	__map_gbk2utf16[0x1986] = 0x6bf1;
	__map_gbk2utf16[0x1987] = 0x6bf2;
	__map_gbk2utf16[0x1988] = 0x6bf4;
	__map_gbk2utf16[0x1989] = 0x6bf6;
	__map_gbk2utf16[0x198a] = 0x6bf7;
	__map_gbk2utf16[0x198b] = 0x6bf8;
	__map_gbk2utf16[0x198c] = 0x6bfa;
	__map_gbk2utf16[0x198d] = 0x6bfb;
	__map_gbk2utf16[0x198e] = 0x6bfc;
	__map_gbk2utf16[0x198f] = 0x6bfe;
	__map_gbk2utf16[0x1990] = 0x6bff;
	__map_gbk2utf16[0x1991] = 0x6c00;
	__map_gbk2utf16[0x1992] = 0x6c01;
	__map_gbk2utf16[0x1993] = 0x6c02;
	__map_gbk2utf16[0x1994] = 0x6c03;
	__map_gbk2utf16[0x1995] = 0x6c04;
	__map_gbk2utf16[0x1996] = 0x6c08;
	__map_gbk2utf16[0x1997] = 0x6c09;
	__map_gbk2utf16[0x1998] = 0x6c0a;
	__map_gbk2utf16[0x1999] = 0x6c0b;
	__map_gbk2utf16[0x199a] = 0x6c0c;
	__map_gbk2utf16[0x199b] = 0x6c0e;
	__map_gbk2utf16[0x199c] = 0x6c12;
	__map_gbk2utf16[0x199d] = 0x6c17;
	__map_gbk2utf16[0x199e] = 0x6c1c;
	__map_gbk2utf16[0x199f] = 0x6c1d;
	__map_gbk2utf16[0x19a0] = 0x6c1e;
	__map_gbk2utf16[0x19a1] = 0x6c20;
	__map_gbk2utf16[0x19a2] = 0x6c23;
	__map_gbk2utf16[0x19a3] = 0x6c25;
	__map_gbk2utf16[0x19a4] = 0x6c2b;
	__map_gbk2utf16[0x19a5] = 0x6c2c;
	__map_gbk2utf16[0x19a6] = 0x6c2d;
	__map_gbk2utf16[0x19a7] = 0x6c31;
	__map_gbk2utf16[0x19a8] = 0x6c33;
	__map_gbk2utf16[0x19a9] = 0x6c36;
	__map_gbk2utf16[0x19aa] = 0x6c37;
	__map_gbk2utf16[0x19ab] = 0x6c39;
	__map_gbk2utf16[0x19ac] = 0x6c3a;
	__map_gbk2utf16[0x19ad] = 0x6c3b;
	__map_gbk2utf16[0x19ae] = 0x6c3c;
	__map_gbk2utf16[0x19af] = 0x6c3e;
	__map_gbk2utf16[0x19b0] = 0x6c3f;
	__map_gbk2utf16[0x19b1] = 0x6c43;
	__map_gbk2utf16[0x19b2] = 0x6c44;
	__map_gbk2utf16[0x19b3] = 0x6c45;
	__map_gbk2utf16[0x19b4] = 0x6c48;
	__map_gbk2utf16[0x19b5] = 0x6c4b;
	__map_gbk2utf16[0x19b6] = 0x6c4c;
	__map_gbk2utf16[0x19b7] = 0x6c4d;
	__map_gbk2utf16[0x19b8] = 0x6c4e;
	__map_gbk2utf16[0x19b9] = 0x6c4f;
	__map_gbk2utf16[0x19ba] = 0x6c51;
	__map_gbk2utf16[0x19bb] = 0x6c52;
	__map_gbk2utf16[0x19bc] = 0x6c53;
	__map_gbk2utf16[0x19bd] = 0x6c56;
	__map_gbk2utf16[0x19be] = 0x6c58;
	__map_gbk2utf16[0x1a00] = 0x6c59;
	__map_gbk2utf16[0x1a01] = 0x6c5a;
	__map_gbk2utf16[0x1a02] = 0x6c62;
	__map_gbk2utf16[0x1a03] = 0x6c63;
	__map_gbk2utf16[0x1a04] = 0x6c65;
	__map_gbk2utf16[0x1a05] = 0x6c66;
	__map_gbk2utf16[0x1a06] = 0x6c67;
	__map_gbk2utf16[0x1a07] = 0x6c6b;
	__map_gbk2utf16[0x1a08] = 0x6c6c;
	__map_gbk2utf16[0x1a09] = 0x6c6d;
	__map_gbk2utf16[0x1a0a] = 0x6c6e;
	__map_gbk2utf16[0x1a0b] = 0x6c6f;
	__map_gbk2utf16[0x1a0c] = 0x6c71;
	__map_gbk2utf16[0x1a0d] = 0x6c73;
	__map_gbk2utf16[0x1a0e] = 0x6c75;
	__map_gbk2utf16[0x1a0f] = 0x6c77;
	__map_gbk2utf16[0x1a10] = 0x6c78;
	__map_gbk2utf16[0x1a11] = 0x6c7a;
	__map_gbk2utf16[0x1a12] = 0x6c7b;
	__map_gbk2utf16[0x1a13] = 0x6c7c;
	__map_gbk2utf16[0x1a14] = 0x6c7f;
	__map_gbk2utf16[0x1a15] = 0x6c80;
	__map_gbk2utf16[0x1a16] = 0x6c84;
	__map_gbk2utf16[0x1a17] = 0x6c87;
	__map_gbk2utf16[0x1a18] = 0x6c8a;
	__map_gbk2utf16[0x1a19] = 0x6c8b;
	__map_gbk2utf16[0x1a1a] = 0x6c8d;
	__map_gbk2utf16[0x1a1b] = 0x6c8e;
	__map_gbk2utf16[0x1a1c] = 0x6c91;
	__map_gbk2utf16[0x1a1d] = 0x6c92;
	__map_gbk2utf16[0x1a1e] = 0x6c95;
	__map_gbk2utf16[0x1a1f] = 0x6c96;
	__map_gbk2utf16[0x1a20] = 0x6c97;
	__map_gbk2utf16[0x1a21] = 0x6c98;
	__map_gbk2utf16[0x1a22] = 0x6c9a;
	__map_gbk2utf16[0x1a23] = 0x6c9c;
	__map_gbk2utf16[0x1a24] = 0x6c9d;
	__map_gbk2utf16[0x1a25] = 0x6c9e;
	__map_gbk2utf16[0x1a26] = 0x6ca0;
	__map_gbk2utf16[0x1a27] = 0x6ca2;
	__map_gbk2utf16[0x1a28] = 0x6ca8;
	__map_gbk2utf16[0x1a29] = 0x6cac;
	__map_gbk2utf16[0x1a2a] = 0x6caf;
	__map_gbk2utf16[0x1a2b] = 0x6cb0;
	__map_gbk2utf16[0x1a2c] = 0x6cb4;
	__map_gbk2utf16[0x1a2d] = 0x6cb5;
	__map_gbk2utf16[0x1a2e] = 0x6cb6;
	__map_gbk2utf16[0x1a2f] = 0x6cb7;
	__map_gbk2utf16[0x1a30] = 0x6cba;
	__map_gbk2utf16[0x1a31] = 0x6cc0;
	__map_gbk2utf16[0x1a32] = 0x6cc1;
	__map_gbk2utf16[0x1a33] = 0x6cc2;
	__map_gbk2utf16[0x1a34] = 0x6cc3;
	__map_gbk2utf16[0x1a35] = 0x6cc6;
	__map_gbk2utf16[0x1a36] = 0x6cc7;
	__map_gbk2utf16[0x1a37] = 0x6cc8;
	__map_gbk2utf16[0x1a38] = 0x6ccb;
	__map_gbk2utf16[0x1a39] = 0x6ccd;
	__map_gbk2utf16[0x1a3a] = 0x6cce;
	__map_gbk2utf16[0x1a3b] = 0x6ccf;
	__map_gbk2utf16[0x1a3c] = 0x6cd1;
	__map_gbk2utf16[0x1a3d] = 0x6cd2;
	__map_gbk2utf16[0x1a3e] = 0x6cd8;
	__map_gbk2utf16[0x1a40] = 0x6cd9;
	__map_gbk2utf16[0x1a41] = 0x6cda;
	__map_gbk2utf16[0x1a42] = 0x6cdc;
	__map_gbk2utf16[0x1a43] = 0x6cdd;
	__map_gbk2utf16[0x1a44] = 0x6cdf;
	__map_gbk2utf16[0x1a45] = 0x6ce4;
	__map_gbk2utf16[0x1a46] = 0x6ce6;
	__map_gbk2utf16[0x1a47] = 0x6ce7;
	__map_gbk2utf16[0x1a48] = 0x6ce9;
	__map_gbk2utf16[0x1a49] = 0x6cec;
	__map_gbk2utf16[0x1a4a] = 0x6ced;
	__map_gbk2utf16[0x1a4b] = 0x6cf2;
	__map_gbk2utf16[0x1a4c] = 0x6cf4;
	__map_gbk2utf16[0x1a4d] = 0x6cf9;
	__map_gbk2utf16[0x1a4e] = 0x6cff;
	__map_gbk2utf16[0x1a4f] = 0x6d00;
	__map_gbk2utf16[0x1a50] = 0x6d02;
	__map_gbk2utf16[0x1a51] = 0x6d03;
	__map_gbk2utf16[0x1a52] = 0x6d05;
	__map_gbk2utf16[0x1a53] = 0x6d06;
	__map_gbk2utf16[0x1a54] = 0x6d08;
	__map_gbk2utf16[0x1a55] = 0x6d09;
	__map_gbk2utf16[0x1a56] = 0x6d0a;
	__map_gbk2utf16[0x1a57] = 0x6d0d;
	__map_gbk2utf16[0x1a58] = 0x6d0f;
	__map_gbk2utf16[0x1a59] = 0x6d10;
	__map_gbk2utf16[0x1a5a] = 0x6d11;
	__map_gbk2utf16[0x1a5b] = 0x6d13;
	__map_gbk2utf16[0x1a5c] = 0x6d14;
	__map_gbk2utf16[0x1a5d] = 0x6d15;
	__map_gbk2utf16[0x1a5e] = 0x6d16;
	__map_gbk2utf16[0x1a5f] = 0x6d18;
	__map_gbk2utf16[0x1a60] = 0x6d1c;
	__map_gbk2utf16[0x1a61] = 0x6d1d;
	__map_gbk2utf16[0x1a62] = 0x6d1f;
	__map_gbk2utf16[0x1a63] = 0x6d20;
	__map_gbk2utf16[0x1a64] = 0x6d21;
	__map_gbk2utf16[0x1a65] = 0x6d22;
	__map_gbk2utf16[0x1a66] = 0x6d23;
	__map_gbk2utf16[0x1a67] = 0x6d24;
	__map_gbk2utf16[0x1a68] = 0x6d26;
	__map_gbk2utf16[0x1a69] = 0x6d28;
	__map_gbk2utf16[0x1a6a] = 0x6d29;
	__map_gbk2utf16[0x1a6b] = 0x6d2c;
	__map_gbk2utf16[0x1a6c] = 0x6d2d;
	__map_gbk2utf16[0x1a6d] = 0x6d2f;
	__map_gbk2utf16[0x1a6e] = 0x6d30;
	__map_gbk2utf16[0x1a6f] = 0x6d34;
	__map_gbk2utf16[0x1a70] = 0x6d36;
	__map_gbk2utf16[0x1a71] = 0x6d37;
	__map_gbk2utf16[0x1a72] = 0x6d38;
	__map_gbk2utf16[0x1a73] = 0x6d3a;
	__map_gbk2utf16[0x1a74] = 0x6d3f;
	__map_gbk2utf16[0x1a75] = 0x6d40;
	__map_gbk2utf16[0x1a76] = 0x6d42;
	__map_gbk2utf16[0x1a77] = 0x6d44;
	__map_gbk2utf16[0x1a78] = 0x6d49;
	__map_gbk2utf16[0x1a79] = 0x6d4c;
	__map_gbk2utf16[0x1a7a] = 0x6d50;
	__map_gbk2utf16[0x1a7b] = 0x6d55;
	__map_gbk2utf16[0x1a7c] = 0x6d56;
	__map_gbk2utf16[0x1a7d] = 0x6d57;
	__map_gbk2utf16[0x1a7e] = 0x6d58;
	__map_gbk2utf16[0x1a7f] = 0x6d5b;
	__map_gbk2utf16[0x1a80] = 0x6d5d;
	__map_gbk2utf16[0x1a81] = 0x6d5f;
	__map_gbk2utf16[0x1a82] = 0x6d61;
	__map_gbk2utf16[0x1a83] = 0x6d62;
	__map_gbk2utf16[0x1a84] = 0x6d64;
	__map_gbk2utf16[0x1a85] = 0x6d65;
	__map_gbk2utf16[0x1a86] = 0x6d67;
	__map_gbk2utf16[0x1a87] = 0x6d68;
	__map_gbk2utf16[0x1a88] = 0x6d6b;
	__map_gbk2utf16[0x1a89] = 0x6d6c;
	__map_gbk2utf16[0x1a8a] = 0x6d6d;
	__map_gbk2utf16[0x1a8b] = 0x6d70;
	__map_gbk2utf16[0x1a8c] = 0x6d71;
	__map_gbk2utf16[0x1a8d] = 0x6d72;
	__map_gbk2utf16[0x1a8e] = 0x6d73;
	__map_gbk2utf16[0x1a8f] = 0x6d75;
	__map_gbk2utf16[0x1a90] = 0x6d76;
	__map_gbk2utf16[0x1a91] = 0x6d79;
	__map_gbk2utf16[0x1a92] = 0x6d7a;
	__map_gbk2utf16[0x1a93] = 0x6d7b;
	__map_gbk2utf16[0x1a94] = 0x6d7d;
	__map_gbk2utf16[0x1a95] = 0x6d7e;
	__map_gbk2utf16[0x1a96] = 0x6d7f;
	__map_gbk2utf16[0x1a97] = 0x6d80;
	__map_gbk2utf16[0x1a98] = 0x6d81;
	__map_gbk2utf16[0x1a99] = 0x6d83;
	__map_gbk2utf16[0x1a9a] = 0x6d84;
	__map_gbk2utf16[0x1a9b] = 0x6d86;
	__map_gbk2utf16[0x1a9c] = 0x6d87;
	__map_gbk2utf16[0x1a9d] = 0x6d8a;
	__map_gbk2utf16[0x1a9e] = 0x6d8b;
	__map_gbk2utf16[0x1a9f] = 0x6d8d;
	__map_gbk2utf16[0x1aa0] = 0x6d8f;
	__map_gbk2utf16[0x1aa1] = 0x6d90;
	__map_gbk2utf16[0x1aa2] = 0x6d92;
	__map_gbk2utf16[0x1aa3] = 0x6d96;
	__map_gbk2utf16[0x1aa4] = 0x6d97;
	__map_gbk2utf16[0x1aa5] = 0x6d98;
	__map_gbk2utf16[0x1aa6] = 0x6d99;
	__map_gbk2utf16[0x1aa7] = 0x6d9a;
	__map_gbk2utf16[0x1aa8] = 0x6d9c;
	__map_gbk2utf16[0x1aa9] = 0x6da2;
	__map_gbk2utf16[0x1aaa] = 0x6da5;
	__map_gbk2utf16[0x1aab] = 0x6dac;
	__map_gbk2utf16[0x1aac] = 0x6dad;
	__map_gbk2utf16[0x1aad] = 0x6db0;
	__map_gbk2utf16[0x1aae] = 0x6db1;
	__map_gbk2utf16[0x1aaf] = 0x6db3;
	__map_gbk2utf16[0x1ab0] = 0x6db4;
	__map_gbk2utf16[0x1ab1] = 0x6db6;
	__map_gbk2utf16[0x1ab2] = 0x6db7;
	__map_gbk2utf16[0x1ab3] = 0x6db9;
	__map_gbk2utf16[0x1ab4] = 0x6dba;
	__map_gbk2utf16[0x1ab5] = 0x6dbb;
	__map_gbk2utf16[0x1ab6] = 0x6dbc;
	__map_gbk2utf16[0x1ab7] = 0x6dbd;
	__map_gbk2utf16[0x1ab8] = 0x6dbe;
	__map_gbk2utf16[0x1ab9] = 0x6dc1;
	__map_gbk2utf16[0x1aba] = 0x6dc2;
	__map_gbk2utf16[0x1abb] = 0x6dc3;
	__map_gbk2utf16[0x1abc] = 0x6dc8;
	__map_gbk2utf16[0x1abd] = 0x6dc9;
	__map_gbk2utf16[0x1abe] = 0x6dca;
	__map_gbk2utf16[0x1b00] = 0x6dcd;
	__map_gbk2utf16[0x1b01] = 0x6dce;
	__map_gbk2utf16[0x1b02] = 0x6dcf;
	__map_gbk2utf16[0x1b03] = 0x6dd0;
	__map_gbk2utf16[0x1b04] = 0x6dd2;
	__map_gbk2utf16[0x1b05] = 0x6dd3;
	__map_gbk2utf16[0x1b06] = 0x6dd4;
	__map_gbk2utf16[0x1b07] = 0x6dd5;
	__map_gbk2utf16[0x1b08] = 0x6dd7;
	__map_gbk2utf16[0x1b09] = 0x6dda;
	__map_gbk2utf16[0x1b0a] = 0x6ddb;
	__map_gbk2utf16[0x1b0b] = 0x6ddc;
	__map_gbk2utf16[0x1b0c] = 0x6ddf;
	__map_gbk2utf16[0x1b0d] = 0x6de2;
	__map_gbk2utf16[0x1b0e] = 0x6de3;
	__map_gbk2utf16[0x1b0f] = 0x6de5;
	__map_gbk2utf16[0x1b10] = 0x6de7;
	__map_gbk2utf16[0x1b11] = 0x6de8;
	__map_gbk2utf16[0x1b12] = 0x6de9;
	__map_gbk2utf16[0x1b13] = 0x6dea;
	__map_gbk2utf16[0x1b14] = 0x6ded;
	__map_gbk2utf16[0x1b15] = 0x6def;
	__map_gbk2utf16[0x1b16] = 0x6df0;
	__map_gbk2utf16[0x1b17] = 0x6df2;
	__map_gbk2utf16[0x1b18] = 0x6df4;
	__map_gbk2utf16[0x1b19] = 0x6df5;
	__map_gbk2utf16[0x1b1a] = 0x6df6;
	__map_gbk2utf16[0x1b1b] = 0x6df8;
	__map_gbk2utf16[0x1b1c] = 0x6dfa;
	__map_gbk2utf16[0x1b1d] = 0x6dfd;
	__map_gbk2utf16[0x1b1e] = 0x6dfe;
	__map_gbk2utf16[0x1b1f] = 0x6dff;
	__map_gbk2utf16[0x1b20] = 0x6e00;
	__map_gbk2utf16[0x1b21] = 0x6e01;
	__map_gbk2utf16[0x1b22] = 0x6e02;
	__map_gbk2utf16[0x1b23] = 0x6e03;
	__map_gbk2utf16[0x1b24] = 0x6e04;
	__map_gbk2utf16[0x1b25] = 0x6e06;
	__map_gbk2utf16[0x1b26] = 0x6e07;
	__map_gbk2utf16[0x1b27] = 0x6e08;
	__map_gbk2utf16[0x1b28] = 0x6e09;
	__map_gbk2utf16[0x1b29] = 0x6e0b;
	__map_gbk2utf16[0x1b2a] = 0x6e0f;
	__map_gbk2utf16[0x1b2b] = 0x6e12;
	__map_gbk2utf16[0x1b2c] = 0x6e13;
	__map_gbk2utf16[0x1b2d] = 0x6e15;
	__map_gbk2utf16[0x1b2e] = 0x6e18;
	__map_gbk2utf16[0x1b2f] = 0x6e19;
	__map_gbk2utf16[0x1b30] = 0x6e1b;
	__map_gbk2utf16[0x1b31] = 0x6e1c;
	__map_gbk2utf16[0x1b32] = 0x6e1e;
	__map_gbk2utf16[0x1b33] = 0x6e1f;
	__map_gbk2utf16[0x1b34] = 0x6e22;
	__map_gbk2utf16[0x1b35] = 0x6e26;
	__map_gbk2utf16[0x1b36] = 0x6e27;
	__map_gbk2utf16[0x1b37] = 0x6e28;
	__map_gbk2utf16[0x1b38] = 0x6e2a;
	__map_gbk2utf16[0x1b39] = 0x6e2c;
	__map_gbk2utf16[0x1b3a] = 0x6e2e;
	__map_gbk2utf16[0x1b3b] = 0x6e30;
	__map_gbk2utf16[0x1b3c] = 0x6e31;
	__map_gbk2utf16[0x1b3d] = 0x6e33;
	__map_gbk2utf16[0x1b3e] = 0x6e35;
	__map_gbk2utf16[0x1b40] = 0x6e36;
	__map_gbk2utf16[0x1b41] = 0x6e37;
	__map_gbk2utf16[0x1b42] = 0x6e39;
	__map_gbk2utf16[0x1b43] = 0x6e3b;
	__map_gbk2utf16[0x1b44] = 0x6e3c;
	__map_gbk2utf16[0x1b45] = 0x6e3d;
	__map_gbk2utf16[0x1b46] = 0x6e3e;
	__map_gbk2utf16[0x1b47] = 0x6e3f;
	__map_gbk2utf16[0x1b48] = 0x6e40;
	__map_gbk2utf16[0x1b49] = 0x6e41;
	__map_gbk2utf16[0x1b4a] = 0x6e42;
	__map_gbk2utf16[0x1b4b] = 0x6e45;
	__map_gbk2utf16[0x1b4c] = 0x6e46;
	__map_gbk2utf16[0x1b4d] = 0x6e47;
	__map_gbk2utf16[0x1b4e] = 0x6e48;
	__map_gbk2utf16[0x1b4f] = 0x6e49;
	__map_gbk2utf16[0x1b50] = 0x6e4a;
	__map_gbk2utf16[0x1b51] = 0x6e4b;
	__map_gbk2utf16[0x1b52] = 0x6e4c;
	__map_gbk2utf16[0x1b53] = 0x6e4f;
	__map_gbk2utf16[0x1b54] = 0x6e50;
	__map_gbk2utf16[0x1b55] = 0x6e51;
	__map_gbk2utf16[0x1b56] = 0x6e52;
	__map_gbk2utf16[0x1b57] = 0x6e55;
	__map_gbk2utf16[0x1b58] = 0x6e57;
	__map_gbk2utf16[0x1b59] = 0x6e59;
	__map_gbk2utf16[0x1b5a] = 0x6e5a;
	__map_gbk2utf16[0x1b5b] = 0x6e5c;
	__map_gbk2utf16[0x1b5c] = 0x6e5d;
	__map_gbk2utf16[0x1b5d] = 0x6e5e;
	__map_gbk2utf16[0x1b5e] = 0x6e60;
	__map_gbk2utf16[0x1b5f] = 0x6e61;
	__map_gbk2utf16[0x1b60] = 0x6e62;
	__map_gbk2utf16[0x1b61] = 0x6e63;
	__map_gbk2utf16[0x1b62] = 0x6e64;
	__map_gbk2utf16[0x1b63] = 0x6e65;
	__map_gbk2utf16[0x1b64] = 0x6e66;
	__map_gbk2utf16[0x1b65] = 0x6e67;
	__map_gbk2utf16[0x1b66] = 0x6e68;
	__map_gbk2utf16[0x1b67] = 0x6e69;
	__map_gbk2utf16[0x1b68] = 0x6e6a;
	__map_gbk2utf16[0x1b69] = 0x6e6c;
	__map_gbk2utf16[0x1b6a] = 0x6e6d;
	__map_gbk2utf16[0x1b6b] = 0x6e6f;
	__map_gbk2utf16[0x1b6c] = 0x6e70;
	__map_gbk2utf16[0x1b6d] = 0x6e71;
	__map_gbk2utf16[0x1b6e] = 0x6e72;
	__map_gbk2utf16[0x1b6f] = 0x6e73;
	__map_gbk2utf16[0x1b70] = 0x6e74;
	__map_gbk2utf16[0x1b71] = 0x6e75;
	__map_gbk2utf16[0x1b72] = 0x6e76;
	__map_gbk2utf16[0x1b73] = 0x6e77;
	__map_gbk2utf16[0x1b74] = 0x6e78;
	__map_gbk2utf16[0x1b75] = 0x6e79;
	__map_gbk2utf16[0x1b76] = 0x6e7a;
	__map_gbk2utf16[0x1b77] = 0x6e7b;
	__map_gbk2utf16[0x1b78] = 0x6e7c;
	__map_gbk2utf16[0x1b79] = 0x6e7d;
	__map_gbk2utf16[0x1b7a] = 0x6e80;
	__map_gbk2utf16[0x1b7b] = 0x6e81;
	__map_gbk2utf16[0x1b7c] = 0x6e82;
	__map_gbk2utf16[0x1b7d] = 0x6e84;
	__map_gbk2utf16[0x1b7e] = 0x6e87;
	__map_gbk2utf16[0x1b7f] = 0x6e88;
	__map_gbk2utf16[0x1b80] = 0x6e8a;
	__map_gbk2utf16[0x1b81] = 0x6e8b;
	__map_gbk2utf16[0x1b82] = 0x6e8c;
	__map_gbk2utf16[0x1b83] = 0x6e8d;
	__map_gbk2utf16[0x1b84] = 0x6e8e;
	__map_gbk2utf16[0x1b85] = 0x6e91;
	__map_gbk2utf16[0x1b86] = 0x6e92;
	__map_gbk2utf16[0x1b87] = 0x6e93;
	__map_gbk2utf16[0x1b88] = 0x6e94;
	__map_gbk2utf16[0x1b89] = 0x6e95;
	__map_gbk2utf16[0x1b8a] = 0x6e96;
	__map_gbk2utf16[0x1b8b] = 0x6e97;
	__map_gbk2utf16[0x1b8c] = 0x6e99;
	__map_gbk2utf16[0x1b8d] = 0x6e9a;
	__map_gbk2utf16[0x1b8e] = 0x6e9b;
	__map_gbk2utf16[0x1b8f] = 0x6e9d;
	__map_gbk2utf16[0x1b90] = 0x6e9e;
	__map_gbk2utf16[0x1b91] = 0x6ea0;
	__map_gbk2utf16[0x1b92] = 0x6ea1;
	__map_gbk2utf16[0x1b93] = 0x6ea3;
	__map_gbk2utf16[0x1b94] = 0x6ea4;
	__map_gbk2utf16[0x1b95] = 0x6ea6;
	__map_gbk2utf16[0x1b96] = 0x6ea8;
	__map_gbk2utf16[0x1b97] = 0x6ea9;
	__map_gbk2utf16[0x1b98] = 0x6eab;
	__map_gbk2utf16[0x1b99] = 0x6eac;
	__map_gbk2utf16[0x1b9a] = 0x6ead;
	__map_gbk2utf16[0x1b9b] = 0x6eae;
	__map_gbk2utf16[0x1b9c] = 0x6eb0;
	__map_gbk2utf16[0x1b9d] = 0x6eb3;
	__map_gbk2utf16[0x1b9e] = 0x6eb5;
	__map_gbk2utf16[0x1b9f] = 0x6eb8;
	__map_gbk2utf16[0x1ba0] = 0x6eb9;
	__map_gbk2utf16[0x1ba1] = 0x6ebc;
	__map_gbk2utf16[0x1ba2] = 0x6ebe;
	__map_gbk2utf16[0x1ba3] = 0x6ebf;
	__map_gbk2utf16[0x1ba4] = 0x6ec0;
	__map_gbk2utf16[0x1ba5] = 0x6ec3;
	__map_gbk2utf16[0x1ba6] = 0x6ec4;
	__map_gbk2utf16[0x1ba7] = 0x6ec5;
	__map_gbk2utf16[0x1ba8] = 0x6ec6;
	__map_gbk2utf16[0x1ba9] = 0x6ec8;
	__map_gbk2utf16[0x1baa] = 0x6ec9;
	__map_gbk2utf16[0x1bab] = 0x6eca;
	__map_gbk2utf16[0x1bac] = 0x6ecc;
	__map_gbk2utf16[0x1bad] = 0x6ecd;
	__map_gbk2utf16[0x1bae] = 0x6ece;
	__map_gbk2utf16[0x1baf] = 0x6ed0;
	__map_gbk2utf16[0x1bb0] = 0x6ed2;
	__map_gbk2utf16[0x1bb1] = 0x6ed6;
	__map_gbk2utf16[0x1bb2] = 0x6ed8;
	__map_gbk2utf16[0x1bb3] = 0x6ed9;
	__map_gbk2utf16[0x1bb4] = 0x6edb;
	__map_gbk2utf16[0x1bb5] = 0x6edc;
	__map_gbk2utf16[0x1bb6] = 0x6edd;
	__map_gbk2utf16[0x1bb7] = 0x6ee3;
	__map_gbk2utf16[0x1bb8] = 0x6ee7;
	__map_gbk2utf16[0x1bb9] = 0x6eea;
	__map_gbk2utf16[0x1bba] = 0x6eeb;
	__map_gbk2utf16[0x1bbb] = 0x6eec;
	__map_gbk2utf16[0x1bbc] = 0x6eed;
	__map_gbk2utf16[0x1bbd] = 0x6eee;
	__map_gbk2utf16[0x1bbe] = 0x6eef;
	__map_gbk2utf16[0x1c00] = 0x6ef0;
	__map_gbk2utf16[0x1c01] = 0x6ef1;
	__map_gbk2utf16[0x1c02] = 0x6ef2;
	__map_gbk2utf16[0x1c03] = 0x6ef3;
	__map_gbk2utf16[0x1c04] = 0x6ef5;
	__map_gbk2utf16[0x1c05] = 0x6ef6;
	__map_gbk2utf16[0x1c06] = 0x6ef7;
	__map_gbk2utf16[0x1c07] = 0x6ef8;
	__map_gbk2utf16[0x1c08] = 0x6efa;
	__map_gbk2utf16[0x1c09] = 0x6efb;
	__map_gbk2utf16[0x1c0a] = 0x6efc;
	__map_gbk2utf16[0x1c0b] = 0x6efd;
	__map_gbk2utf16[0x1c0c] = 0x6efe;
	__map_gbk2utf16[0x1c0d] = 0x6eff;
	__map_gbk2utf16[0x1c0e] = 0x6f00;
	__map_gbk2utf16[0x1c0f] = 0x6f01;
	__map_gbk2utf16[0x1c10] = 0x6f03;
	__map_gbk2utf16[0x1c11] = 0x6f04;
	__map_gbk2utf16[0x1c12] = 0x6f05;
	__map_gbk2utf16[0x1c13] = 0x6f07;
	__map_gbk2utf16[0x1c14] = 0x6f08;
	__map_gbk2utf16[0x1c15] = 0x6f0a;
	__map_gbk2utf16[0x1c16] = 0x6f0b;
	__map_gbk2utf16[0x1c17] = 0x6f0c;
	__map_gbk2utf16[0x1c18] = 0x6f0d;
	__map_gbk2utf16[0x1c19] = 0x6f0e;
	__map_gbk2utf16[0x1c1a] = 0x6f10;
	__map_gbk2utf16[0x1c1b] = 0x6f11;
	__map_gbk2utf16[0x1c1c] = 0x6f12;
	__map_gbk2utf16[0x1c1d] = 0x6f16;
	__map_gbk2utf16[0x1c1e] = 0x6f17;
	__map_gbk2utf16[0x1c1f] = 0x6f18;
	__map_gbk2utf16[0x1c20] = 0x6f19;
	__map_gbk2utf16[0x1c21] = 0x6f1a;
	__map_gbk2utf16[0x1c22] = 0x6f1b;
	__map_gbk2utf16[0x1c23] = 0x6f1c;
	__map_gbk2utf16[0x1c24] = 0x6f1d;
	__map_gbk2utf16[0x1c25] = 0x6f1e;
	__map_gbk2utf16[0x1c26] = 0x6f1f;
	__map_gbk2utf16[0x1c27] = 0x6f21;
	__map_gbk2utf16[0x1c28] = 0x6f22;
	__map_gbk2utf16[0x1c29] = 0x6f23;
	__map_gbk2utf16[0x1c2a] = 0x6f25;
	__map_gbk2utf16[0x1c2b] = 0x6f26;
	__map_gbk2utf16[0x1c2c] = 0x6f27;
	__map_gbk2utf16[0x1c2d] = 0x6f28;
	__map_gbk2utf16[0x1c2e] = 0x6f2c;
	__map_gbk2utf16[0x1c2f] = 0x6f2e;
	__map_gbk2utf16[0x1c30] = 0x6f30;
	__map_gbk2utf16[0x1c31] = 0x6f32;
	__map_gbk2utf16[0x1c32] = 0x6f34;
	__map_gbk2utf16[0x1c33] = 0x6f35;
	__map_gbk2utf16[0x1c34] = 0x6f37;
	__map_gbk2utf16[0x1c35] = 0x6f38;
	__map_gbk2utf16[0x1c36] = 0x6f39;
	__map_gbk2utf16[0x1c37] = 0x6f3a;
	__map_gbk2utf16[0x1c38] = 0x6f3b;
	__map_gbk2utf16[0x1c39] = 0x6f3c;
	__map_gbk2utf16[0x1c3a] = 0x6f3d;
	__map_gbk2utf16[0x1c3b] = 0x6f3f;
	__map_gbk2utf16[0x1c3c] = 0x6f40;
	__map_gbk2utf16[0x1c3d] = 0x6f41;
	__map_gbk2utf16[0x1c3e] = 0x6f42;
	__map_gbk2utf16[0x1c40] = 0x6f43;
	__map_gbk2utf16[0x1c41] = 0x6f44;
	__map_gbk2utf16[0x1c42] = 0x6f45;
	__map_gbk2utf16[0x1c43] = 0x6f48;
	__map_gbk2utf16[0x1c44] = 0x6f49;
	__map_gbk2utf16[0x1c45] = 0x6f4a;
	__map_gbk2utf16[0x1c46] = 0x6f4c;
	__map_gbk2utf16[0x1c47] = 0x6f4e;
	__map_gbk2utf16[0x1c48] = 0x6f4f;
	__map_gbk2utf16[0x1c49] = 0x6f50;
	__map_gbk2utf16[0x1c4a] = 0x6f51;
	__map_gbk2utf16[0x1c4b] = 0x6f52;
	__map_gbk2utf16[0x1c4c] = 0x6f53;
	__map_gbk2utf16[0x1c4d] = 0x6f54;
	__map_gbk2utf16[0x1c4e] = 0x6f55;
	__map_gbk2utf16[0x1c4f] = 0x6f56;
	__map_gbk2utf16[0x1c50] = 0x6f57;
	__map_gbk2utf16[0x1c51] = 0x6f59;
	__map_gbk2utf16[0x1c52] = 0x6f5a;
	__map_gbk2utf16[0x1c53] = 0x6f5b;
	__map_gbk2utf16[0x1c54] = 0x6f5d;
	__map_gbk2utf16[0x1c55] = 0x6f5f;
	__map_gbk2utf16[0x1c56] = 0x6f60;
	__map_gbk2utf16[0x1c57] = 0x6f61;
	__map_gbk2utf16[0x1c58] = 0x6f63;
	__map_gbk2utf16[0x1c59] = 0x6f64;
	__map_gbk2utf16[0x1c5a] = 0x6f65;
	__map_gbk2utf16[0x1c5b] = 0x6f67;
	__map_gbk2utf16[0x1c5c] = 0x6f68;
	__map_gbk2utf16[0x1c5d] = 0x6f69;
	__map_gbk2utf16[0x1c5e] = 0x6f6a;
	__map_gbk2utf16[0x1c5f] = 0x6f6b;
	__map_gbk2utf16[0x1c60] = 0x6f6c;
	__map_gbk2utf16[0x1c61] = 0x6f6f;
	__map_gbk2utf16[0x1c62] = 0x6f70;
	__map_gbk2utf16[0x1c63] = 0x6f71;
	__map_gbk2utf16[0x1c64] = 0x6f73;
	__map_gbk2utf16[0x1c65] = 0x6f75;
	__map_gbk2utf16[0x1c66] = 0x6f76;
	__map_gbk2utf16[0x1c67] = 0x6f77;
	__map_gbk2utf16[0x1c68] = 0x6f79;
	__map_gbk2utf16[0x1c69] = 0x6f7b;
	__map_gbk2utf16[0x1c6a] = 0x6f7d;
	__map_gbk2utf16[0x1c6b] = 0x6f7e;
	__map_gbk2utf16[0x1c6c] = 0x6f7f;
	__map_gbk2utf16[0x1c6d] = 0x6f80;
	__map_gbk2utf16[0x1c6e] = 0x6f81;
	__map_gbk2utf16[0x1c6f] = 0x6f82;
	__map_gbk2utf16[0x1c70] = 0x6f83;
	__map_gbk2utf16[0x1c71] = 0x6f85;
	__map_gbk2utf16[0x1c72] = 0x6f86;
	__map_gbk2utf16[0x1c73] = 0x6f87;
	__map_gbk2utf16[0x1c74] = 0x6f8a;
	__map_gbk2utf16[0x1c75] = 0x6f8b;
	__map_gbk2utf16[0x1c76] = 0x6f8f;
	__map_gbk2utf16[0x1c77] = 0x6f90;
	__map_gbk2utf16[0x1c78] = 0x6f91;
	__map_gbk2utf16[0x1c79] = 0x6f92;
	__map_gbk2utf16[0x1c7a] = 0x6f93;
	__map_gbk2utf16[0x1c7b] = 0x6f94;
	__map_gbk2utf16[0x1c7c] = 0x6f95;
	__map_gbk2utf16[0x1c7d] = 0x6f96;
	__map_gbk2utf16[0x1c7e] = 0x6f97;
	__map_gbk2utf16[0x1c7f] = 0x6f98;
	__map_gbk2utf16[0x1c80] = 0x6f99;
	__map_gbk2utf16[0x1c81] = 0x6f9a;
	__map_gbk2utf16[0x1c82] = 0x6f9b;
	__map_gbk2utf16[0x1c83] = 0x6f9d;
	__map_gbk2utf16[0x1c84] = 0x6f9e;
	__map_gbk2utf16[0x1c85] = 0x6f9f;
	__map_gbk2utf16[0x1c86] = 0x6fa0;
	__map_gbk2utf16[0x1c87] = 0x6fa2;
	__map_gbk2utf16[0x1c88] = 0x6fa3;
	__map_gbk2utf16[0x1c89] = 0x6fa4;
	__map_gbk2utf16[0x1c8a] = 0x6fa5;
	__map_gbk2utf16[0x1c8b] = 0x6fa6;
	__map_gbk2utf16[0x1c8c] = 0x6fa8;
	__map_gbk2utf16[0x1c8d] = 0x6fa9;
	__map_gbk2utf16[0x1c8e] = 0x6faa;
	__map_gbk2utf16[0x1c8f] = 0x6fab;
	__map_gbk2utf16[0x1c90] = 0x6fac;
	__map_gbk2utf16[0x1c91] = 0x6fad;
	__map_gbk2utf16[0x1c92] = 0x6fae;
	__map_gbk2utf16[0x1c93] = 0x6faf;
	__map_gbk2utf16[0x1c94] = 0x6fb0;
	__map_gbk2utf16[0x1c95] = 0x6fb1;
	__map_gbk2utf16[0x1c96] = 0x6fb2;
	__map_gbk2utf16[0x1c97] = 0x6fb4;
	__map_gbk2utf16[0x1c98] = 0x6fb5;
	__map_gbk2utf16[0x1c99] = 0x6fb7;
	__map_gbk2utf16[0x1c9a] = 0x6fb8;
	__map_gbk2utf16[0x1c9b] = 0x6fba;
	__map_gbk2utf16[0x1c9c] = 0x6fbb;
	__map_gbk2utf16[0x1c9d] = 0x6fbc;
	__map_gbk2utf16[0x1c9e] = 0x6fbd;
	__map_gbk2utf16[0x1c9f] = 0x6fbe;
	__map_gbk2utf16[0x1ca0] = 0x6fbf;
	__map_gbk2utf16[0x1ca1] = 0x6fc1;
	__map_gbk2utf16[0x1ca2] = 0x6fc3;
	__map_gbk2utf16[0x1ca3] = 0x6fc4;
	__map_gbk2utf16[0x1ca4] = 0x6fc5;
	__map_gbk2utf16[0x1ca5] = 0x6fc6;
	__map_gbk2utf16[0x1ca6] = 0x6fc7;
	__map_gbk2utf16[0x1ca7] = 0x6fc8;
	__map_gbk2utf16[0x1ca8] = 0x6fca;
	__map_gbk2utf16[0x1ca9] = 0x6fcb;
	__map_gbk2utf16[0x1caa] = 0x6fcc;
	__map_gbk2utf16[0x1cab] = 0x6fcd;
	__map_gbk2utf16[0x1cac] = 0x6fce;
	__map_gbk2utf16[0x1cad] = 0x6fcf;
	__map_gbk2utf16[0x1cae] = 0x6fd0;
	__map_gbk2utf16[0x1caf] = 0x6fd3;
	__map_gbk2utf16[0x1cb0] = 0x6fd4;
	__map_gbk2utf16[0x1cb1] = 0x6fd5;
	__map_gbk2utf16[0x1cb2] = 0x6fd6;
	__map_gbk2utf16[0x1cb3] = 0x6fd7;
	__map_gbk2utf16[0x1cb4] = 0x6fd8;
	__map_gbk2utf16[0x1cb5] = 0x6fd9;
	__map_gbk2utf16[0x1cb6] = 0x6fda;
	__map_gbk2utf16[0x1cb7] = 0x6fdb;
	__map_gbk2utf16[0x1cb8] = 0x6fdc;
	__map_gbk2utf16[0x1cb9] = 0x6fdd;
	__map_gbk2utf16[0x1cba] = 0x6fdf;
	__map_gbk2utf16[0x1cbb] = 0x6fe2;
	__map_gbk2utf16[0x1cbc] = 0x6fe3;
	__map_gbk2utf16[0x1cbd] = 0x6fe4;
	__map_gbk2utf16[0x1cbe] = 0x6fe5;
	__map_gbk2utf16[0x1d00] = 0x6fe6;
	__map_gbk2utf16[0x1d01] = 0x6fe7;
	__map_gbk2utf16[0x1d02] = 0x6fe8;
	__map_gbk2utf16[0x1d03] = 0x6fe9;
	__map_gbk2utf16[0x1d04] = 0x6fea;
	__map_gbk2utf16[0x1d05] = 0x6feb;
	__map_gbk2utf16[0x1d06] = 0x6fec;
	__map_gbk2utf16[0x1d07] = 0x6fed;
	__map_gbk2utf16[0x1d08] = 0x6ff0;
	__map_gbk2utf16[0x1d09] = 0x6ff1;
	__map_gbk2utf16[0x1d0a] = 0x6ff2;
	__map_gbk2utf16[0x1d0b] = 0x6ff3;
	__map_gbk2utf16[0x1d0c] = 0x6ff4;
	__map_gbk2utf16[0x1d0d] = 0x6ff5;
	__map_gbk2utf16[0x1d0e] = 0x6ff6;
	__map_gbk2utf16[0x1d0f] = 0x6ff7;
	__map_gbk2utf16[0x1d10] = 0x6ff8;
	__map_gbk2utf16[0x1d11] = 0x6ff9;
	__map_gbk2utf16[0x1d12] = 0x6ffa;
	__map_gbk2utf16[0x1d13] = 0x6ffb;
	__map_gbk2utf16[0x1d14] = 0x6ffc;
	__map_gbk2utf16[0x1d15] = 0x6ffd;
	__map_gbk2utf16[0x1d16] = 0x6ffe;
	__map_gbk2utf16[0x1d17] = 0x6fff;
	__map_gbk2utf16[0x1d18] = 0x7000;
	__map_gbk2utf16[0x1d19] = 0x7001;
	__map_gbk2utf16[0x1d1a] = 0x7002;
	__map_gbk2utf16[0x1d1b] = 0x7003;
	__map_gbk2utf16[0x1d1c] = 0x7004;
	__map_gbk2utf16[0x1d1d] = 0x7005;
	__map_gbk2utf16[0x1d1e] = 0x7006;
	__map_gbk2utf16[0x1d1f] = 0x7007;
	__map_gbk2utf16[0x1d20] = 0x7008;
	__map_gbk2utf16[0x1d21] = 0x7009;
	__map_gbk2utf16[0x1d22] = 0x700a;
	__map_gbk2utf16[0x1d23] = 0x700b;
	__map_gbk2utf16[0x1d24] = 0x700c;
	__map_gbk2utf16[0x1d25] = 0x700d;
	__map_gbk2utf16[0x1d26] = 0x700e;
	__map_gbk2utf16[0x1d27] = 0x700f;
	__map_gbk2utf16[0x1d28] = 0x7010;
	__map_gbk2utf16[0x1d29] = 0x7012;
	__map_gbk2utf16[0x1d2a] = 0x7013;
	__map_gbk2utf16[0x1d2b] = 0x7014;
	__map_gbk2utf16[0x1d2c] = 0x7015;
	__map_gbk2utf16[0x1d2d] = 0x7016;
	__map_gbk2utf16[0x1d2e] = 0x7017;
	__map_gbk2utf16[0x1d2f] = 0x7018;
	__map_gbk2utf16[0x1d30] = 0x7019;
	__map_gbk2utf16[0x1d31] = 0x701c;
	__map_gbk2utf16[0x1d32] = 0x701d;
	__map_gbk2utf16[0x1d33] = 0x701e;
	__map_gbk2utf16[0x1d34] = 0x701f;
	__map_gbk2utf16[0x1d35] = 0x7020;
	__map_gbk2utf16[0x1d36] = 0x7021;
	__map_gbk2utf16[0x1d37] = 0x7022;
	__map_gbk2utf16[0x1d38] = 0x7024;
	__map_gbk2utf16[0x1d39] = 0x7025;
	__map_gbk2utf16[0x1d3a] = 0x7026;
	__map_gbk2utf16[0x1d3b] = 0x7027;
	__map_gbk2utf16[0x1d3c] = 0x7028;
	__map_gbk2utf16[0x1d3d] = 0x7029;
	__map_gbk2utf16[0x1d3e] = 0x702a;
	__map_gbk2utf16[0x1d40] = 0x702b;
	__map_gbk2utf16[0x1d41] = 0x702c;
	__map_gbk2utf16[0x1d42] = 0x702d;
	__map_gbk2utf16[0x1d43] = 0x702e;
	__map_gbk2utf16[0x1d44] = 0x702f;
	__map_gbk2utf16[0x1d45] = 0x7030;
	__map_gbk2utf16[0x1d46] = 0x7031;
	__map_gbk2utf16[0x1d47] = 0x7032;
	__map_gbk2utf16[0x1d48] = 0x7033;
	__map_gbk2utf16[0x1d49] = 0x7034;
	__map_gbk2utf16[0x1d4a] = 0x7036;
	__map_gbk2utf16[0x1d4b] = 0x7037;
	__map_gbk2utf16[0x1d4c] = 0x7038;
	__map_gbk2utf16[0x1d4d] = 0x703a;
	__map_gbk2utf16[0x1d4e] = 0x703b;
	__map_gbk2utf16[0x1d4f] = 0x703c;
	__map_gbk2utf16[0x1d50] = 0x703d;
	__map_gbk2utf16[0x1d51] = 0x703e;
	__map_gbk2utf16[0x1d52] = 0x703f;
	__map_gbk2utf16[0x1d53] = 0x7040;
	__map_gbk2utf16[0x1d54] = 0x7041;
	__map_gbk2utf16[0x1d55] = 0x7042;
	__map_gbk2utf16[0x1d56] = 0x7043;
	__map_gbk2utf16[0x1d57] = 0x7044;
	__map_gbk2utf16[0x1d58] = 0x7045;
	__map_gbk2utf16[0x1d59] = 0x7046;
	__map_gbk2utf16[0x1d5a] = 0x7047;
	__map_gbk2utf16[0x1d5b] = 0x7048;
	__map_gbk2utf16[0x1d5c] = 0x7049;
	__map_gbk2utf16[0x1d5d] = 0x704a;
	__map_gbk2utf16[0x1d5e] = 0x704b;
	__map_gbk2utf16[0x1d5f] = 0x704d;
	__map_gbk2utf16[0x1d60] = 0x704e;
	__map_gbk2utf16[0x1d61] = 0x7050;
	__map_gbk2utf16[0x1d62] = 0x7051;
	__map_gbk2utf16[0x1d63] = 0x7052;
	__map_gbk2utf16[0x1d64] = 0x7053;
	__map_gbk2utf16[0x1d65] = 0x7054;
	__map_gbk2utf16[0x1d66] = 0x7055;
	__map_gbk2utf16[0x1d67] = 0x7056;
	__map_gbk2utf16[0x1d68] = 0x7057;
	__map_gbk2utf16[0x1d69] = 0x7058;
	__map_gbk2utf16[0x1d6a] = 0x7059;
	__map_gbk2utf16[0x1d6b] = 0x705a;
	__map_gbk2utf16[0x1d6c] = 0x705b;
	__map_gbk2utf16[0x1d6d] = 0x705c;
	__map_gbk2utf16[0x1d6e] = 0x705d;
	__map_gbk2utf16[0x1d6f] = 0x705f;
	__map_gbk2utf16[0x1d70] = 0x7060;
	__map_gbk2utf16[0x1d71] = 0x7061;
	__map_gbk2utf16[0x1d72] = 0x7062;
	__map_gbk2utf16[0x1d73] = 0x7063;
	__map_gbk2utf16[0x1d74] = 0x7064;
	__map_gbk2utf16[0x1d75] = 0x7065;
	__map_gbk2utf16[0x1d76] = 0x7066;
	__map_gbk2utf16[0x1d77] = 0x7067;
	__map_gbk2utf16[0x1d78] = 0x7068;
	__map_gbk2utf16[0x1d79] = 0x7069;
	__map_gbk2utf16[0x1d7a] = 0x706a;
	__map_gbk2utf16[0x1d7b] = 0x706e;
	__map_gbk2utf16[0x1d7c] = 0x7071;
	__map_gbk2utf16[0x1d7d] = 0x7072;
	__map_gbk2utf16[0x1d7e] = 0x7073;
	__map_gbk2utf16[0x1d7f] = 0x7074;
	__map_gbk2utf16[0x1d80] = 0x7077;
	__map_gbk2utf16[0x1d81] = 0x7079;
	__map_gbk2utf16[0x1d82] = 0x707a;
	__map_gbk2utf16[0x1d83] = 0x707b;
	__map_gbk2utf16[0x1d84] = 0x707d;
	__map_gbk2utf16[0x1d85] = 0x7081;
	__map_gbk2utf16[0x1d86] = 0x7082;
	__map_gbk2utf16[0x1d87] = 0x7083;
	__map_gbk2utf16[0x1d88] = 0x7084;
	__map_gbk2utf16[0x1d89] = 0x7086;
	__map_gbk2utf16[0x1d8a] = 0x7087;
	__map_gbk2utf16[0x1d8b] = 0x7088;
	__map_gbk2utf16[0x1d8c] = 0x708b;
	__map_gbk2utf16[0x1d8d] = 0x708c;
	__map_gbk2utf16[0x1d8e] = 0x708d;
	__map_gbk2utf16[0x1d8f] = 0x708f;
	__map_gbk2utf16[0x1d90] = 0x7090;
	__map_gbk2utf16[0x1d91] = 0x7091;
	__map_gbk2utf16[0x1d92] = 0x7093;
	__map_gbk2utf16[0x1d93] = 0x7097;
	__map_gbk2utf16[0x1d94] = 0x7098;
	__map_gbk2utf16[0x1d95] = 0x709a;
	__map_gbk2utf16[0x1d96] = 0x709b;
	__map_gbk2utf16[0x1d97] = 0x709e;
	__map_gbk2utf16[0x1d98] = 0x709f;
	__map_gbk2utf16[0x1d99] = 0x70a0;
	__map_gbk2utf16[0x1d9a] = 0x70a1;
	__map_gbk2utf16[0x1d9b] = 0x70a2;
	__map_gbk2utf16[0x1d9c] = 0x70a3;
	__map_gbk2utf16[0x1d9d] = 0x70a4;
	__map_gbk2utf16[0x1d9e] = 0x70a5;
	__map_gbk2utf16[0x1d9f] = 0x70a6;
	__map_gbk2utf16[0x1da0] = 0x70a7;
	__map_gbk2utf16[0x1da1] = 0x70a8;
	__map_gbk2utf16[0x1da2] = 0x70a9;
	__map_gbk2utf16[0x1da3] = 0x70aa;
	__map_gbk2utf16[0x1da4] = 0x70b0;
	__map_gbk2utf16[0x1da5] = 0x70b2;
	__map_gbk2utf16[0x1da6] = 0x70b4;
	__map_gbk2utf16[0x1da7] = 0x70b5;
	__map_gbk2utf16[0x1da8] = 0x70b6;
	__map_gbk2utf16[0x1da9] = 0x70ba;
	__map_gbk2utf16[0x1daa] = 0x70be;
	__map_gbk2utf16[0x1dab] = 0x70bf;
	__map_gbk2utf16[0x1dac] = 0x70c4;
	__map_gbk2utf16[0x1dad] = 0x70c5;
	__map_gbk2utf16[0x1dae] = 0x70c6;
	__map_gbk2utf16[0x1daf] = 0x70c7;
	__map_gbk2utf16[0x1db0] = 0x70c9;
	__map_gbk2utf16[0x1db1] = 0x70cb;
	__map_gbk2utf16[0x1db2] = 0x70cc;
	__map_gbk2utf16[0x1db3] = 0x70cd;
	__map_gbk2utf16[0x1db4] = 0x70ce;
	__map_gbk2utf16[0x1db5] = 0x70cf;
	__map_gbk2utf16[0x1db6] = 0x70d0;
	__map_gbk2utf16[0x1db7] = 0x70d1;
	__map_gbk2utf16[0x1db8] = 0x70d2;
	__map_gbk2utf16[0x1db9] = 0x70d3;
	__map_gbk2utf16[0x1dba] = 0x70d4;
	__map_gbk2utf16[0x1dbb] = 0x70d5;
	__map_gbk2utf16[0x1dbc] = 0x70d6;
	__map_gbk2utf16[0x1dbd] = 0x70d7;
	__map_gbk2utf16[0x1dbe] = 0x70da;
	__map_gbk2utf16[0x1e00] = 0x70dc;
	__map_gbk2utf16[0x1e01] = 0x70dd;
	__map_gbk2utf16[0x1e02] = 0x70de;
	__map_gbk2utf16[0x1e03] = 0x70e0;
	__map_gbk2utf16[0x1e04] = 0x70e1;
	__map_gbk2utf16[0x1e05] = 0x70e2;
	__map_gbk2utf16[0x1e06] = 0x70e3;
	__map_gbk2utf16[0x1e07] = 0x70e5;
	__map_gbk2utf16[0x1e08] = 0x70ea;
	__map_gbk2utf16[0x1e09] = 0x70ee;
	__map_gbk2utf16[0x1e0a] = 0x70f0;
	__map_gbk2utf16[0x1e0b] = 0x70f1;
	__map_gbk2utf16[0x1e0c] = 0x70f2;
	__map_gbk2utf16[0x1e0d] = 0x70f3;
	__map_gbk2utf16[0x1e0e] = 0x70f4;
	__map_gbk2utf16[0x1e0f] = 0x70f5;
	__map_gbk2utf16[0x1e10] = 0x70f6;
	__map_gbk2utf16[0x1e11] = 0x70f8;
	__map_gbk2utf16[0x1e12] = 0x70fa;
	__map_gbk2utf16[0x1e13] = 0x70fb;
	__map_gbk2utf16[0x1e14] = 0x70fc;
	__map_gbk2utf16[0x1e15] = 0x70fe;
	__map_gbk2utf16[0x1e16] = 0x70ff;
	__map_gbk2utf16[0x1e17] = 0x7100;
	__map_gbk2utf16[0x1e18] = 0x7101;
	__map_gbk2utf16[0x1e19] = 0x7102;
	__map_gbk2utf16[0x1e1a] = 0x7103;
	__map_gbk2utf16[0x1e1b] = 0x7104;
	__map_gbk2utf16[0x1e1c] = 0x7105;
	__map_gbk2utf16[0x1e1d] = 0x7106;
	__map_gbk2utf16[0x1e1e] = 0x7107;
	__map_gbk2utf16[0x1e1f] = 0x7108;
	__map_gbk2utf16[0x1e20] = 0x710b;
	__map_gbk2utf16[0x1e21] = 0x710c;
	__map_gbk2utf16[0x1e22] = 0x710d;
	__map_gbk2utf16[0x1e23] = 0x710e;
	__map_gbk2utf16[0x1e24] = 0x710f;
	__map_gbk2utf16[0x1e25] = 0x7111;
	__map_gbk2utf16[0x1e26] = 0x7112;
	__map_gbk2utf16[0x1e27] = 0x7114;
	__map_gbk2utf16[0x1e28] = 0x7117;
	__map_gbk2utf16[0x1e29] = 0x711b;
	__map_gbk2utf16[0x1e2a] = 0x711c;
	__map_gbk2utf16[0x1e2b] = 0x711d;
	__map_gbk2utf16[0x1e2c] = 0x711e;
	__map_gbk2utf16[0x1e2d] = 0x711f;
	__map_gbk2utf16[0x1e2e] = 0x7120;
	__map_gbk2utf16[0x1e2f] = 0x7121;
	__map_gbk2utf16[0x1e30] = 0x7122;
	__map_gbk2utf16[0x1e31] = 0x7123;
	__map_gbk2utf16[0x1e32] = 0x7124;
	__map_gbk2utf16[0x1e33] = 0x7125;
	__map_gbk2utf16[0x1e34] = 0x7127;
	__map_gbk2utf16[0x1e35] = 0x7128;
	__map_gbk2utf16[0x1e36] = 0x7129;
	__map_gbk2utf16[0x1e37] = 0x712a;
	__map_gbk2utf16[0x1e38] = 0x712b;
	__map_gbk2utf16[0x1e39] = 0x712c;
	__map_gbk2utf16[0x1e3a] = 0x712d;
	__map_gbk2utf16[0x1e3b] = 0x712e;
	__map_gbk2utf16[0x1e3c] = 0x7132;
	__map_gbk2utf16[0x1e3d] = 0x7133;
	__map_gbk2utf16[0x1e3e] = 0x7134;
	__map_gbk2utf16[0x1e40] = 0x7135;
	__map_gbk2utf16[0x1e41] = 0x7137;
	__map_gbk2utf16[0x1e42] = 0x7138;
	__map_gbk2utf16[0x1e43] = 0x7139;
	__map_gbk2utf16[0x1e44] = 0x713a;
	__map_gbk2utf16[0x1e45] = 0x713b;
	__map_gbk2utf16[0x1e46] = 0x713c;
	__map_gbk2utf16[0x1e47] = 0x713d;
	__map_gbk2utf16[0x1e48] = 0x713e;
	__map_gbk2utf16[0x1e49] = 0x713f;
	__map_gbk2utf16[0x1e4a] = 0x7140;
	__map_gbk2utf16[0x1e4b] = 0x7141;
	__map_gbk2utf16[0x1e4c] = 0x7142;
	__map_gbk2utf16[0x1e4d] = 0x7143;
	__map_gbk2utf16[0x1e4e] = 0x7144;
	__map_gbk2utf16[0x1e4f] = 0x7146;
	__map_gbk2utf16[0x1e50] = 0x7147;
	__map_gbk2utf16[0x1e51] = 0x7148;
	__map_gbk2utf16[0x1e52] = 0x7149;
	__map_gbk2utf16[0x1e53] = 0x714b;
	__map_gbk2utf16[0x1e54] = 0x714d;
	__map_gbk2utf16[0x1e55] = 0x714f;
	__map_gbk2utf16[0x1e56] = 0x7150;
	__map_gbk2utf16[0x1e57] = 0x7151;
	__map_gbk2utf16[0x1e58] = 0x7152;
	__map_gbk2utf16[0x1e59] = 0x7153;
	__map_gbk2utf16[0x1e5a] = 0x7154;
	__map_gbk2utf16[0x1e5b] = 0x7155;
	__map_gbk2utf16[0x1e5c] = 0x7156;
	__map_gbk2utf16[0x1e5d] = 0x7157;
	__map_gbk2utf16[0x1e5e] = 0x7158;
	__map_gbk2utf16[0x1e5f] = 0x7159;
	__map_gbk2utf16[0x1e60] = 0x715a;
	__map_gbk2utf16[0x1e61] = 0x715b;
	__map_gbk2utf16[0x1e62] = 0x715d;
	__map_gbk2utf16[0x1e63] = 0x715f;
	__map_gbk2utf16[0x1e64] = 0x7160;
	__map_gbk2utf16[0x1e65] = 0x7161;
	__map_gbk2utf16[0x1e66] = 0x7162;
	__map_gbk2utf16[0x1e67] = 0x7163;
	__map_gbk2utf16[0x1e68] = 0x7165;
	__map_gbk2utf16[0x1e69] = 0x7169;
	__map_gbk2utf16[0x1e6a] = 0x716a;
	__map_gbk2utf16[0x1e6b] = 0x716b;
	__map_gbk2utf16[0x1e6c] = 0x716c;
	__map_gbk2utf16[0x1e6d] = 0x716d;
	__map_gbk2utf16[0x1e6e] = 0x716f;
	__map_gbk2utf16[0x1e6f] = 0x7170;
	__map_gbk2utf16[0x1e70] = 0x7171;
	__map_gbk2utf16[0x1e71] = 0x7174;
	__map_gbk2utf16[0x1e72] = 0x7175;
	__map_gbk2utf16[0x1e73] = 0x7176;
	__map_gbk2utf16[0x1e74] = 0x7177;
	__map_gbk2utf16[0x1e75] = 0x7179;
	__map_gbk2utf16[0x1e76] = 0x717b;
	__map_gbk2utf16[0x1e77] = 0x717c;
	__map_gbk2utf16[0x1e78] = 0x717e;
	__map_gbk2utf16[0x1e79] = 0x717f;
	__map_gbk2utf16[0x1e7a] = 0x7180;
	__map_gbk2utf16[0x1e7b] = 0x7181;
	__map_gbk2utf16[0x1e7c] = 0x7182;
	__map_gbk2utf16[0x1e7d] = 0x7183;
	__map_gbk2utf16[0x1e7e] = 0x7185;
	__map_gbk2utf16[0x1e7f] = 0x7186;
	__map_gbk2utf16[0x1e80] = 0x7187;
	__map_gbk2utf16[0x1e81] = 0x7188;
	__map_gbk2utf16[0x1e82] = 0x7189;
	__map_gbk2utf16[0x1e83] = 0x718b;
	__map_gbk2utf16[0x1e84] = 0x718c;
	__map_gbk2utf16[0x1e85] = 0x718d;
	__map_gbk2utf16[0x1e86] = 0x718e;
	__map_gbk2utf16[0x1e87] = 0x7190;
	__map_gbk2utf16[0x1e88] = 0x7191;
	__map_gbk2utf16[0x1e89] = 0x7192;
	__map_gbk2utf16[0x1e8a] = 0x7193;
	__map_gbk2utf16[0x1e8b] = 0x7195;
	__map_gbk2utf16[0x1e8c] = 0x7196;
	__map_gbk2utf16[0x1e8d] = 0x7197;
	__map_gbk2utf16[0x1e8e] = 0x719a;
	__map_gbk2utf16[0x1e8f] = 0x719b;
	__map_gbk2utf16[0x1e90] = 0x719c;
	__map_gbk2utf16[0x1e91] = 0x719d;
	__map_gbk2utf16[0x1e92] = 0x719e;
	__map_gbk2utf16[0x1e93] = 0x71a1;
	__map_gbk2utf16[0x1e94] = 0x71a2;
	__map_gbk2utf16[0x1e95] = 0x71a3;
	__map_gbk2utf16[0x1e96] = 0x71a4;
	__map_gbk2utf16[0x1e97] = 0x71a5;
	__map_gbk2utf16[0x1e98] = 0x71a6;
	__map_gbk2utf16[0x1e99] = 0x71a7;
	__map_gbk2utf16[0x1e9a] = 0x71a9;
	__map_gbk2utf16[0x1e9b] = 0x71aa;
	__map_gbk2utf16[0x1e9c] = 0x71ab;
	__map_gbk2utf16[0x1e9d] = 0x71ad;
	__map_gbk2utf16[0x1e9e] = 0x71ae;
	__map_gbk2utf16[0x1e9f] = 0x71af;
	__map_gbk2utf16[0x1ea0] = 0x71b0;
	__map_gbk2utf16[0x1ea1] = 0x71b1;
	__map_gbk2utf16[0x1ea2] = 0x71b2;
	__map_gbk2utf16[0x1ea3] = 0x71b4;
	__map_gbk2utf16[0x1ea4] = 0x71b6;
	__map_gbk2utf16[0x1ea5] = 0x71b7;
	__map_gbk2utf16[0x1ea6] = 0x71b8;
	__map_gbk2utf16[0x1ea7] = 0x71ba;
	__map_gbk2utf16[0x1ea8] = 0x71bb;
	__map_gbk2utf16[0x1ea9] = 0x71bc;
	__map_gbk2utf16[0x1eaa] = 0x71bd;
	__map_gbk2utf16[0x1eab] = 0x71be;
	__map_gbk2utf16[0x1eac] = 0x71bf;
	__map_gbk2utf16[0x1ead] = 0x71c0;
	__map_gbk2utf16[0x1eae] = 0x71c1;
	__map_gbk2utf16[0x1eaf] = 0x71c2;
	__map_gbk2utf16[0x1eb0] = 0x71c4;
	__map_gbk2utf16[0x1eb1] = 0x71c5;
	__map_gbk2utf16[0x1eb2] = 0x71c6;
	__map_gbk2utf16[0x1eb3] = 0x71c7;
	__map_gbk2utf16[0x1eb4] = 0x71c8;
	__map_gbk2utf16[0x1eb5] = 0x71c9;
	__map_gbk2utf16[0x1eb6] = 0x71ca;
	__map_gbk2utf16[0x1eb7] = 0x71cb;
	__map_gbk2utf16[0x1eb8] = 0x71cc;
	__map_gbk2utf16[0x1eb9] = 0x71cd;
	__map_gbk2utf16[0x1eba] = 0x71cf;
	__map_gbk2utf16[0x1ebb] = 0x71d0;
	__map_gbk2utf16[0x1ebc] = 0x71d1;
	__map_gbk2utf16[0x1ebd] = 0x71d2;
	__map_gbk2utf16[0x1ebe] = 0x71d3;
	__map_gbk2utf16[0x1f00] = 0x71d6;
	__map_gbk2utf16[0x1f01] = 0x71d7;
	__map_gbk2utf16[0x1f02] = 0x71d8;
	__map_gbk2utf16[0x1f03] = 0x71d9;
	__map_gbk2utf16[0x1f04] = 0x71da;
	__map_gbk2utf16[0x1f05] = 0x71db;
	__map_gbk2utf16[0x1f06] = 0x71dc;
	__map_gbk2utf16[0x1f07] = 0x71dd;
	__map_gbk2utf16[0x1f08] = 0x71de;
	__map_gbk2utf16[0x1f09] = 0x71df;
	__map_gbk2utf16[0x1f0a] = 0x71e1;
	__map_gbk2utf16[0x1f0b] = 0x71e2;
	__map_gbk2utf16[0x1f0c] = 0x71e3;
	__map_gbk2utf16[0x1f0d] = 0x71e4;
	__map_gbk2utf16[0x1f0e] = 0x71e6;
	__map_gbk2utf16[0x1f0f] = 0x71e8;
	__map_gbk2utf16[0x1f10] = 0x71e9;
	__map_gbk2utf16[0x1f11] = 0x71ea;
	__map_gbk2utf16[0x1f12] = 0x71eb;
	__map_gbk2utf16[0x1f13] = 0x71ec;
	__map_gbk2utf16[0x1f14] = 0x71ed;
	__map_gbk2utf16[0x1f15] = 0x71ef;
	__map_gbk2utf16[0x1f16] = 0x71f0;
	__map_gbk2utf16[0x1f17] = 0x71f1;
	__map_gbk2utf16[0x1f18] = 0x71f2;
	__map_gbk2utf16[0x1f19] = 0x71f3;
	__map_gbk2utf16[0x1f1a] = 0x71f4;
	__map_gbk2utf16[0x1f1b] = 0x71f5;
	__map_gbk2utf16[0x1f1c] = 0x71f6;
	__map_gbk2utf16[0x1f1d] = 0x71f7;
	__map_gbk2utf16[0x1f1e] = 0x71f8;
	__map_gbk2utf16[0x1f1f] = 0x71fa;
	__map_gbk2utf16[0x1f20] = 0x71fb;
	__map_gbk2utf16[0x1f21] = 0x71fc;
	__map_gbk2utf16[0x1f22] = 0x71fd;
	__map_gbk2utf16[0x1f23] = 0x71fe;
	__map_gbk2utf16[0x1f24] = 0x71ff;
	__map_gbk2utf16[0x1f25] = 0x7200;
	__map_gbk2utf16[0x1f26] = 0x7201;
	__map_gbk2utf16[0x1f27] = 0x7202;
	__map_gbk2utf16[0x1f28] = 0x7203;
	__map_gbk2utf16[0x1f29] = 0x7204;
	__map_gbk2utf16[0x1f2a] = 0x7205;
	__map_gbk2utf16[0x1f2b] = 0x7207;
	__map_gbk2utf16[0x1f2c] = 0x7208;
	__map_gbk2utf16[0x1f2d] = 0x7209;
	__map_gbk2utf16[0x1f2e] = 0x720a;
	__map_gbk2utf16[0x1f2f] = 0x720b;
	__map_gbk2utf16[0x1f30] = 0x720c;
	__map_gbk2utf16[0x1f31] = 0x720d;
	__map_gbk2utf16[0x1f32] = 0x720e;
	__map_gbk2utf16[0x1f33] = 0x720f;
	__map_gbk2utf16[0x1f34] = 0x7210;
	__map_gbk2utf16[0x1f35] = 0x7211;
	__map_gbk2utf16[0x1f36] = 0x7212;
	__map_gbk2utf16[0x1f37] = 0x7213;
	__map_gbk2utf16[0x1f38] = 0x7214;
	__map_gbk2utf16[0x1f39] = 0x7215;
	__map_gbk2utf16[0x1f3a] = 0x7216;
	__map_gbk2utf16[0x1f3b] = 0x7217;
	__map_gbk2utf16[0x1f3c] = 0x7218;
	__map_gbk2utf16[0x1f3d] = 0x7219;
	__map_gbk2utf16[0x1f3e] = 0x721a;
	__map_gbk2utf16[0x1f40] = 0x721b;
	__map_gbk2utf16[0x1f41] = 0x721c;
	__map_gbk2utf16[0x1f42] = 0x721e;
	__map_gbk2utf16[0x1f43] = 0x721f;
	__map_gbk2utf16[0x1f44] = 0x7220;
	__map_gbk2utf16[0x1f45] = 0x7221;
	__map_gbk2utf16[0x1f46] = 0x7222;
	__map_gbk2utf16[0x1f47] = 0x7223;
	__map_gbk2utf16[0x1f48] = 0x7224;
	__map_gbk2utf16[0x1f49] = 0x7225;
	__map_gbk2utf16[0x1f4a] = 0x7226;
	__map_gbk2utf16[0x1f4b] = 0x7227;
	__map_gbk2utf16[0x1f4c] = 0x7229;
	__map_gbk2utf16[0x1f4d] = 0x722b;
	__map_gbk2utf16[0x1f4e] = 0x722d;
	__map_gbk2utf16[0x1f4f] = 0x722e;
	__map_gbk2utf16[0x1f50] = 0x722f;
	__map_gbk2utf16[0x1f51] = 0x7232;
	__map_gbk2utf16[0x1f52] = 0x7233;
	__map_gbk2utf16[0x1f53] = 0x7234;
	__map_gbk2utf16[0x1f54] = 0x723a;
	__map_gbk2utf16[0x1f55] = 0x723c;
	__map_gbk2utf16[0x1f56] = 0x723e;
	__map_gbk2utf16[0x1f57] = 0x7240;
	__map_gbk2utf16[0x1f58] = 0x7241;
	__map_gbk2utf16[0x1f59] = 0x7242;
	__map_gbk2utf16[0x1f5a] = 0x7243;
	__map_gbk2utf16[0x1f5b] = 0x7244;
	__map_gbk2utf16[0x1f5c] = 0x7245;
	__map_gbk2utf16[0x1f5d] = 0x7246;
	__map_gbk2utf16[0x1f5e] = 0x7249;
	__map_gbk2utf16[0x1f5f] = 0x724a;
	__map_gbk2utf16[0x1f60] = 0x724b;
	__map_gbk2utf16[0x1f61] = 0x724e;
	__map_gbk2utf16[0x1f62] = 0x724f;
	__map_gbk2utf16[0x1f63] = 0x7250;
	__map_gbk2utf16[0x1f64] = 0x7251;
	__map_gbk2utf16[0x1f65] = 0x7253;
	__map_gbk2utf16[0x1f66] = 0x7254;
	__map_gbk2utf16[0x1f67] = 0x7255;
	__map_gbk2utf16[0x1f68] = 0x7257;
	__map_gbk2utf16[0x1f69] = 0x7258;
	__map_gbk2utf16[0x1f6a] = 0x725a;
	__map_gbk2utf16[0x1f6b] = 0x725c;
	__map_gbk2utf16[0x1f6c] = 0x725e;
	__map_gbk2utf16[0x1f6d] = 0x7260;
	__map_gbk2utf16[0x1f6e] = 0x7263;
	__map_gbk2utf16[0x1f6f] = 0x7264;
	__map_gbk2utf16[0x1f70] = 0x7265;
	__map_gbk2utf16[0x1f71] = 0x7268;
	__map_gbk2utf16[0x1f72] = 0x726a;
	__map_gbk2utf16[0x1f73] = 0x726b;
	__map_gbk2utf16[0x1f74] = 0x726c;
	__map_gbk2utf16[0x1f75] = 0x726d;
	__map_gbk2utf16[0x1f76] = 0x7270;
	__map_gbk2utf16[0x1f77] = 0x7271;
	__map_gbk2utf16[0x1f78] = 0x7273;
	__map_gbk2utf16[0x1f79] = 0x7274;
	__map_gbk2utf16[0x1f7a] = 0x7276;
	__map_gbk2utf16[0x1f7b] = 0x7277;
	__map_gbk2utf16[0x1f7c] = 0x7278;
	__map_gbk2utf16[0x1f7d] = 0x727b;
	__map_gbk2utf16[0x1f7e] = 0x727c;
	__map_gbk2utf16[0x1f7f] = 0x727d;
	__map_gbk2utf16[0x1f80] = 0x7282;
	__map_gbk2utf16[0x1f81] = 0x7283;
	__map_gbk2utf16[0x1f82] = 0x7285;
	__map_gbk2utf16[0x1f83] = 0x7286;
	__map_gbk2utf16[0x1f84] = 0x7287;
	__map_gbk2utf16[0x1f85] = 0x7288;
	__map_gbk2utf16[0x1f86] = 0x7289;
	__map_gbk2utf16[0x1f87] = 0x728c;
	__map_gbk2utf16[0x1f88] = 0x728e;
	__map_gbk2utf16[0x1f89] = 0x7290;
	__map_gbk2utf16[0x1f8a] = 0x7291;
	__map_gbk2utf16[0x1f8b] = 0x7293;
	__map_gbk2utf16[0x1f8c] = 0x7294;
	__map_gbk2utf16[0x1f8d] = 0x7295;
	__map_gbk2utf16[0x1f8e] = 0x7296;
	__map_gbk2utf16[0x1f8f] = 0x7297;
	__map_gbk2utf16[0x1f90] = 0x7298;
	__map_gbk2utf16[0x1f91] = 0x7299;
	__map_gbk2utf16[0x1f92] = 0x729a;
	__map_gbk2utf16[0x1f93] = 0x729b;
	__map_gbk2utf16[0x1f94] = 0x729c;
	__map_gbk2utf16[0x1f95] = 0x729d;
	__map_gbk2utf16[0x1f96] = 0x729e;
	__map_gbk2utf16[0x1f97] = 0x72a0;
	__map_gbk2utf16[0x1f98] = 0x72a1;
	__map_gbk2utf16[0x1f99] = 0x72a2;
	__map_gbk2utf16[0x1f9a] = 0x72a3;
	__map_gbk2utf16[0x1f9b] = 0x72a4;
	__map_gbk2utf16[0x1f9c] = 0x72a5;
	__map_gbk2utf16[0x1f9d] = 0x72a6;
	__map_gbk2utf16[0x1f9e] = 0x72a7;
	__map_gbk2utf16[0x1f9f] = 0x72a8;
	__map_gbk2utf16[0x1fa0] = 0x72a9;
	__map_gbk2utf16[0x1fa1] = 0x72aa;
	__map_gbk2utf16[0x1fa2] = 0x72ab;
	__map_gbk2utf16[0x1fa3] = 0x72ae;
	__map_gbk2utf16[0x1fa4] = 0x72b1;
	__map_gbk2utf16[0x1fa5] = 0x72b2;
	__map_gbk2utf16[0x1fa6] = 0x72b3;
	__map_gbk2utf16[0x1fa7] = 0x72b5;
	__map_gbk2utf16[0x1fa8] = 0x72ba;
	__map_gbk2utf16[0x1fa9] = 0x72bb;
	__map_gbk2utf16[0x1faa] = 0x72bc;
	__map_gbk2utf16[0x1fab] = 0x72bd;
	__map_gbk2utf16[0x1fac] = 0x72be;
	__map_gbk2utf16[0x1fad] = 0x72bf;
	__map_gbk2utf16[0x1fae] = 0x72c0;
	__map_gbk2utf16[0x1faf] = 0x72c5;
	__map_gbk2utf16[0x1fb0] = 0x72c6;
	__map_gbk2utf16[0x1fb1] = 0x72c7;
	__map_gbk2utf16[0x1fb2] = 0x72c9;
	__map_gbk2utf16[0x1fb3] = 0x72ca;
	__map_gbk2utf16[0x1fb4] = 0x72cb;
	__map_gbk2utf16[0x1fb5] = 0x72cc;
	__map_gbk2utf16[0x1fb6] = 0x72cf;
	__map_gbk2utf16[0x1fb7] = 0x72d1;
	__map_gbk2utf16[0x1fb8] = 0x72d3;
	__map_gbk2utf16[0x1fb9] = 0x72d4;
	__map_gbk2utf16[0x1fba] = 0x72d5;
	__map_gbk2utf16[0x1fbb] = 0x72d6;
	__map_gbk2utf16[0x1fbc] = 0x72d8;
	__map_gbk2utf16[0x1fbd] = 0x72da;
	__map_gbk2utf16[0x1fbe] = 0x72db;
	__map_gbk2utf16[0x2000] = 0xe4c6;
	__map_gbk2utf16[0x2001] = 0xe4c7;
	__map_gbk2utf16[0x2002] = 0xe4c8;
	__map_gbk2utf16[0x2003] = 0xe4c9;
	__map_gbk2utf16[0x2004] = 0xe4ca;
	__map_gbk2utf16[0x2005] = 0xe4cb;
	__map_gbk2utf16[0x2006] = 0xe4cc;
	__map_gbk2utf16[0x2007] = 0xe4cd;
	__map_gbk2utf16[0x2008] = 0xe4ce;
	__map_gbk2utf16[0x2009] = 0xe4cf;
	__map_gbk2utf16[0x200a] = 0xe4d0;
	__map_gbk2utf16[0x200b] = 0xe4d1;
	__map_gbk2utf16[0x200c] = 0xe4d2;
	__map_gbk2utf16[0x200d] = 0xe4d3;
	__map_gbk2utf16[0x200e] = 0xe4d4;
	__map_gbk2utf16[0x200f] = 0xe4d5;
	__map_gbk2utf16[0x2010] = 0xe4d6;
	__map_gbk2utf16[0x2011] = 0xe4d7;
	__map_gbk2utf16[0x2012] = 0xe4d8;
	__map_gbk2utf16[0x2013] = 0xe4d9;
	__map_gbk2utf16[0x2014] = 0xe4da;
	__map_gbk2utf16[0x2015] = 0xe4db;
	__map_gbk2utf16[0x2016] = 0xe4dc;
	__map_gbk2utf16[0x2017] = 0xe4dd;
	__map_gbk2utf16[0x2018] = 0xe4de;
	__map_gbk2utf16[0x2019] = 0xe4df;
	__map_gbk2utf16[0x201a] = 0xe4e0;
	__map_gbk2utf16[0x201b] = 0xe4e1;
	__map_gbk2utf16[0x201c] = 0xe4e2;
	__map_gbk2utf16[0x201d] = 0xe4e3;
	__map_gbk2utf16[0x201e] = 0xe4e4;
	__map_gbk2utf16[0x201f] = 0xe4e5;
	__map_gbk2utf16[0x2020] = 0xe4e6;
	__map_gbk2utf16[0x2021] = 0xe4e7;
	__map_gbk2utf16[0x2022] = 0xe4e8;
	__map_gbk2utf16[0x2023] = 0xe4e9;
	__map_gbk2utf16[0x2024] = 0xe4ea;
	__map_gbk2utf16[0x2025] = 0xe4eb;
	__map_gbk2utf16[0x2026] = 0xe4ec;
	__map_gbk2utf16[0x2027] = 0xe4ed;
	__map_gbk2utf16[0x2028] = 0xe4ee;
	__map_gbk2utf16[0x2029] = 0xe4ef;
	__map_gbk2utf16[0x202a] = 0xe4f0;
	__map_gbk2utf16[0x202b] = 0xe4f1;
	__map_gbk2utf16[0x202c] = 0xe4f2;
	__map_gbk2utf16[0x202d] = 0xe4f3;
	__map_gbk2utf16[0x202e] = 0xe4f4;
	__map_gbk2utf16[0x202f] = 0xe4f5;
	__map_gbk2utf16[0x2030] = 0xe4f6;
	__map_gbk2utf16[0x2031] = 0xe4f7;
	__map_gbk2utf16[0x2032] = 0xe4f8;
	__map_gbk2utf16[0x2033] = 0xe4f9;
	__map_gbk2utf16[0x2034] = 0xe4fa;
	__map_gbk2utf16[0x2035] = 0xe4fb;
	__map_gbk2utf16[0x2036] = 0xe4fc;
	__map_gbk2utf16[0x2037] = 0xe4fd;
	__map_gbk2utf16[0x2038] = 0xe4fe;
	__map_gbk2utf16[0x2039] = 0xe4ff;
	__map_gbk2utf16[0x203a] = 0xe500;
	__map_gbk2utf16[0x203b] = 0xe501;
	__map_gbk2utf16[0x203c] = 0xe502;
	__map_gbk2utf16[0x203d] = 0xe503;
	__map_gbk2utf16[0x203e] = 0xe504;
	__map_gbk2utf16[0x2040] = 0xe505;
	__map_gbk2utf16[0x2041] = 0xe506;
	__map_gbk2utf16[0x2042] = 0xe507;
	__map_gbk2utf16[0x2043] = 0xe508;
	__map_gbk2utf16[0x2044] = 0xe509;
	__map_gbk2utf16[0x2045] = 0xe50a;
	__map_gbk2utf16[0x2046] = 0xe50b;
	__map_gbk2utf16[0x2047] = 0xe50c;
	__map_gbk2utf16[0x2048] = 0xe50d;
	__map_gbk2utf16[0x2049] = 0xe50e;
	__map_gbk2utf16[0x204a] = 0xe50f;
	__map_gbk2utf16[0x204b] = 0xe510;
	__map_gbk2utf16[0x204c] = 0xe511;
	__map_gbk2utf16[0x204d] = 0xe512;
	__map_gbk2utf16[0x204e] = 0xe513;
	__map_gbk2utf16[0x204f] = 0xe514;
	__map_gbk2utf16[0x2050] = 0xe515;
	__map_gbk2utf16[0x2051] = 0xe516;
	__map_gbk2utf16[0x2052] = 0xe517;
	__map_gbk2utf16[0x2053] = 0xe518;
	__map_gbk2utf16[0x2054] = 0xe519;
	__map_gbk2utf16[0x2055] = 0xe51a;
	__map_gbk2utf16[0x2056] = 0xe51b;
	__map_gbk2utf16[0x2057] = 0xe51c;
	__map_gbk2utf16[0x2058] = 0xe51d;
	__map_gbk2utf16[0x2059] = 0xe51e;
	__map_gbk2utf16[0x205a] = 0xe51f;
	__map_gbk2utf16[0x205b] = 0xe520;
	__map_gbk2utf16[0x205c] = 0xe521;
	__map_gbk2utf16[0x205d] = 0xe522;
	__map_gbk2utf16[0x205e] = 0xe523;
	__map_gbk2utf16[0x205f] = 0xe524;
	__map_gbk2utf16[0x2060] = 0xe525;
	__map_gbk2utf16[0x2061] = 0x3000;
	__map_gbk2utf16[0x2062] = 0x3001;
	__map_gbk2utf16[0x2063] = 0x3002;
	__map_gbk2utf16[0x2064] = 0x00b7;
	__map_gbk2utf16[0x2065] = 0x02c9;
	__map_gbk2utf16[0x2066] = 0x02c7;
	__map_gbk2utf16[0x2067] = 0x00a8;
	__map_gbk2utf16[0x2068] = 0x3003;
	__map_gbk2utf16[0x2069] = 0x3005;
	__map_gbk2utf16[0x206a] = 0x2014;
	__map_gbk2utf16[0x206b] = 0xff5e;
	__map_gbk2utf16[0x206c] = 0x2016;
	__map_gbk2utf16[0x206d] = 0x2026;
	__map_gbk2utf16[0x206e] = 0x2018;
	__map_gbk2utf16[0x206f] = 0x2019;
	__map_gbk2utf16[0x2070] = 0x201c;
	__map_gbk2utf16[0x2071] = 0x201d;
	__map_gbk2utf16[0x2072] = 0x3014;
	__map_gbk2utf16[0x2073] = 0x3015;
	__map_gbk2utf16[0x2074] = 0x3008;
	__map_gbk2utf16[0x2075] = 0x3009;
	__map_gbk2utf16[0x2076] = 0x300a;
	__map_gbk2utf16[0x2077] = 0x300b;
	__map_gbk2utf16[0x2078] = 0x300c;
	__map_gbk2utf16[0x2079] = 0x300d;
	__map_gbk2utf16[0x207a] = 0x300e;
	__map_gbk2utf16[0x207b] = 0x300f;
	__map_gbk2utf16[0x207c] = 0x3016;
	__map_gbk2utf16[0x207d] = 0x3017;
	__map_gbk2utf16[0x207e] = 0x3010;
	__map_gbk2utf16[0x207f] = 0x3011;
	__map_gbk2utf16[0x2080] = 0x00b1;
	__map_gbk2utf16[0x2081] = 0x00d7;
	__map_gbk2utf16[0x2082] = 0x00f7;
	__map_gbk2utf16[0x2083] = 0x2236;
	__map_gbk2utf16[0x2084] = 0x2227;
	__map_gbk2utf16[0x2085] = 0x2228;
	__map_gbk2utf16[0x2086] = 0x2211;
	__map_gbk2utf16[0x2087] = 0x220f;
	__map_gbk2utf16[0x2088] = 0x222a;
	__map_gbk2utf16[0x2089] = 0x2229;
	__map_gbk2utf16[0x208a] = 0x2208;
	__map_gbk2utf16[0x208b] = 0x2237;
	__map_gbk2utf16[0x208c] = 0x221a;
	__map_gbk2utf16[0x208d] = 0x22a5;
	__map_gbk2utf16[0x208e] = 0x2225;
	__map_gbk2utf16[0x208f] = 0x2220;
	__map_gbk2utf16[0x2090] = 0x2312;
	__map_gbk2utf16[0x2091] = 0x2299;
	__map_gbk2utf16[0x2092] = 0x222b;
	__map_gbk2utf16[0x2093] = 0x222e;
	__map_gbk2utf16[0x2094] = 0x2261;
	__map_gbk2utf16[0x2095] = 0x224c;
	__map_gbk2utf16[0x2096] = 0x2248;
	__map_gbk2utf16[0x2097] = 0x223d;
	__map_gbk2utf16[0x2098] = 0x221d;
	__map_gbk2utf16[0x2099] = 0x2260;
	__map_gbk2utf16[0x209a] = 0x226e;
	__map_gbk2utf16[0x209b] = 0x226f;
	__map_gbk2utf16[0x209c] = 0x2264;
	__map_gbk2utf16[0x209d] = 0x2265;
	__map_gbk2utf16[0x209e] = 0x221e;
	__map_gbk2utf16[0x209f] = 0x2235;
	__map_gbk2utf16[0x20a0] = 0x2234;
	__map_gbk2utf16[0x20a1] = 0x2642;
	__map_gbk2utf16[0x20a2] = 0x2640;
	__map_gbk2utf16[0x20a3] = 0x00b0;
	__map_gbk2utf16[0x20a4] = 0x2032;
	__map_gbk2utf16[0x20a5] = 0x2033;
	__map_gbk2utf16[0x20a6] = 0x2103;
	__map_gbk2utf16[0x20a7] = 0xff04;
	__map_gbk2utf16[0x20a8] = 0x00a4;
	__map_gbk2utf16[0x20a9] = 0xffe0;
	__map_gbk2utf16[0x20aa] = 0xffe1;
	__map_gbk2utf16[0x20ab] = 0x2030;
	__map_gbk2utf16[0x20ac] = 0x00a7;
	__map_gbk2utf16[0x20ad] = 0x2116;
	__map_gbk2utf16[0x20ae] = 0x2606;
	__map_gbk2utf16[0x20af] = 0x2605;
	__map_gbk2utf16[0x20b0] = 0x25cb;
	__map_gbk2utf16[0x20b1] = 0x25cf;
	__map_gbk2utf16[0x20b2] = 0x25ce;
	__map_gbk2utf16[0x20b3] = 0x25c7;
	__map_gbk2utf16[0x20b4] = 0x25c6;
	__map_gbk2utf16[0x20b5] = 0x25a1;
	__map_gbk2utf16[0x20b6] = 0x25a0;
	__map_gbk2utf16[0x20b7] = 0x25b3;
	__map_gbk2utf16[0x20b8] = 0x25b2;
	__map_gbk2utf16[0x20b9] = 0x203b;
	__map_gbk2utf16[0x20ba] = 0x2192;
	__map_gbk2utf16[0x20bb] = 0x2190;
	__map_gbk2utf16[0x20bc] = 0x2191;
	__map_gbk2utf16[0x20bd] = 0x2193;
	__map_gbk2utf16[0x20be] = 0x3013;
	__map_gbk2utf16[0x2100] = 0xe526;
	__map_gbk2utf16[0x2101] = 0xe527;
	__map_gbk2utf16[0x2102] = 0xe528;
	__map_gbk2utf16[0x2103] = 0xe529;
	__map_gbk2utf16[0x2104] = 0xe52a;
	__map_gbk2utf16[0x2105] = 0xe52b;
	__map_gbk2utf16[0x2106] = 0xe52c;
	__map_gbk2utf16[0x2107] = 0xe52d;
	__map_gbk2utf16[0x2108] = 0xe52e;
	__map_gbk2utf16[0x2109] = 0xe52f;
	__map_gbk2utf16[0x210a] = 0xe530;
	__map_gbk2utf16[0x210b] = 0xe531;
	__map_gbk2utf16[0x210c] = 0xe532;
	__map_gbk2utf16[0x210d] = 0xe533;
	__map_gbk2utf16[0x210e] = 0xe534;
	__map_gbk2utf16[0x210f] = 0xe535;
	__map_gbk2utf16[0x2110] = 0xe536;
	__map_gbk2utf16[0x2111] = 0xe537;
	__map_gbk2utf16[0x2112] = 0xe538;
	__map_gbk2utf16[0x2113] = 0xe539;
	__map_gbk2utf16[0x2114] = 0xe53a;
	__map_gbk2utf16[0x2115] = 0xe53b;
	__map_gbk2utf16[0x2116] = 0xe53c;
	__map_gbk2utf16[0x2117] = 0xe53d;
	__map_gbk2utf16[0x2118] = 0xe53e;
	__map_gbk2utf16[0x2119] = 0xe53f;
	__map_gbk2utf16[0x211a] = 0xe540;
	__map_gbk2utf16[0x211b] = 0xe541;
	__map_gbk2utf16[0x211c] = 0xe542;
	__map_gbk2utf16[0x211d] = 0xe543;
	__map_gbk2utf16[0x211e] = 0xe544;
	__map_gbk2utf16[0x211f] = 0xe545;
	__map_gbk2utf16[0x2120] = 0xe546;
	__map_gbk2utf16[0x2121] = 0xe547;
	__map_gbk2utf16[0x2122] = 0xe548;
	__map_gbk2utf16[0x2123] = 0xe549;
	__map_gbk2utf16[0x2124] = 0xe54a;
	__map_gbk2utf16[0x2125] = 0xe54b;
	__map_gbk2utf16[0x2126] = 0xe54c;
	__map_gbk2utf16[0x2127] = 0xe54d;
	__map_gbk2utf16[0x2128] = 0xe54e;
	__map_gbk2utf16[0x2129] = 0xe54f;
	__map_gbk2utf16[0x212a] = 0xe550;
	__map_gbk2utf16[0x212b] = 0xe551;
	__map_gbk2utf16[0x212c] = 0xe552;
	__map_gbk2utf16[0x212d] = 0xe553;
	__map_gbk2utf16[0x212e] = 0xe554;
	__map_gbk2utf16[0x212f] = 0xe555;
	__map_gbk2utf16[0x2130] = 0xe556;
	__map_gbk2utf16[0x2131] = 0xe557;
	__map_gbk2utf16[0x2132] = 0xe558;
	__map_gbk2utf16[0x2133] = 0xe559;
	__map_gbk2utf16[0x2134] = 0xe55a;
	__map_gbk2utf16[0x2135] = 0xe55b;
	__map_gbk2utf16[0x2136] = 0xe55c;
	__map_gbk2utf16[0x2137] = 0xe55d;
	__map_gbk2utf16[0x2138] = 0xe55e;
	__map_gbk2utf16[0x2139] = 0xe55f;
	__map_gbk2utf16[0x213a] = 0xe560;
	__map_gbk2utf16[0x213b] = 0xe561;
	__map_gbk2utf16[0x213c] = 0xe562;
	__map_gbk2utf16[0x213d] = 0xe563;
	__map_gbk2utf16[0x213e] = 0xe564;
	__map_gbk2utf16[0x2140] = 0xe565;
	__map_gbk2utf16[0x2141] = 0xe566;
	__map_gbk2utf16[0x2142] = 0xe567;
	__map_gbk2utf16[0x2143] = 0xe568;
	__map_gbk2utf16[0x2144] = 0xe569;
	__map_gbk2utf16[0x2145] = 0xe56a;
	__map_gbk2utf16[0x2146] = 0xe56b;
	__map_gbk2utf16[0x2147] = 0xe56c;
	__map_gbk2utf16[0x2148] = 0xe56d;
	__map_gbk2utf16[0x2149] = 0xe56e;
	__map_gbk2utf16[0x214a] = 0xe56f;
	__map_gbk2utf16[0x214b] = 0xe570;
	__map_gbk2utf16[0x214c] = 0xe571;
	__map_gbk2utf16[0x214d] = 0xe572;
	__map_gbk2utf16[0x214e] = 0xe573;
	__map_gbk2utf16[0x214f] = 0xe574;
	__map_gbk2utf16[0x2150] = 0xe575;
	__map_gbk2utf16[0x2151] = 0xe576;
	__map_gbk2utf16[0x2152] = 0xe577;
	__map_gbk2utf16[0x2153] = 0xe578;
	__map_gbk2utf16[0x2154] = 0xe579;
	__map_gbk2utf16[0x2155] = 0xe57a;
	__map_gbk2utf16[0x2156] = 0xe57b;
	__map_gbk2utf16[0x2157] = 0xe57c;
	__map_gbk2utf16[0x2158] = 0xe57d;
	__map_gbk2utf16[0x2159] = 0xe57e;
	__map_gbk2utf16[0x215a] = 0xe57f;
	__map_gbk2utf16[0x215b] = 0xe580;
	__map_gbk2utf16[0x215c] = 0xe581;
	__map_gbk2utf16[0x215d] = 0xe582;
	__map_gbk2utf16[0x215e] = 0xe583;
	__map_gbk2utf16[0x215f] = 0xe584;
	__map_gbk2utf16[0x2160] = 0xe585;
	__map_gbk2utf16[0x2161] = 0x2170;
	__map_gbk2utf16[0x2162] = 0x2171;
	__map_gbk2utf16[0x2163] = 0x2172;
	__map_gbk2utf16[0x2164] = 0x2173;
	__map_gbk2utf16[0x2165] = 0x2174;
	__map_gbk2utf16[0x2166] = 0x2175;
	__map_gbk2utf16[0x2167] = 0x2176;
	__map_gbk2utf16[0x2168] = 0x2177;
	__map_gbk2utf16[0x2169] = 0x2178;
	__map_gbk2utf16[0x216a] = 0x2179;
	__map_gbk2utf16[0x216b] = 0xe766;
	__map_gbk2utf16[0x216c] = 0xe767;
	__map_gbk2utf16[0x216d] = 0xe768;
	__map_gbk2utf16[0x216e] = 0xe769;
	__map_gbk2utf16[0x216f] = 0xe76a;
	__map_gbk2utf16[0x2170] = 0xe76b;
	__map_gbk2utf16[0x2171] = 0x2488;
	__map_gbk2utf16[0x2172] = 0x2489;
	__map_gbk2utf16[0x2173] = 0x248a;
	__map_gbk2utf16[0x2174] = 0x248b;
	__map_gbk2utf16[0x2175] = 0x248c;
	__map_gbk2utf16[0x2176] = 0x248d;
	__map_gbk2utf16[0x2177] = 0x248e;
	__map_gbk2utf16[0x2178] = 0x248f;
	__map_gbk2utf16[0x2179] = 0x2490;
	__map_gbk2utf16[0x217a] = 0x2491;
	__map_gbk2utf16[0x217b] = 0x2492;
	__map_gbk2utf16[0x217c] = 0x2493;
	__map_gbk2utf16[0x217d] = 0x2494;
	__map_gbk2utf16[0x217e] = 0x2495;
	__map_gbk2utf16[0x217f] = 0x2496;
	__map_gbk2utf16[0x2180] = 0x2497;
	__map_gbk2utf16[0x2181] = 0x2498;
	__map_gbk2utf16[0x2182] = 0x2499;
	__map_gbk2utf16[0x2183] = 0x249a;
	__map_gbk2utf16[0x2184] = 0x249b;
	__map_gbk2utf16[0x2185] = 0x2474;
	__map_gbk2utf16[0x2186] = 0x2475;
	__map_gbk2utf16[0x2187] = 0x2476;
	__map_gbk2utf16[0x2188] = 0x2477;
	__map_gbk2utf16[0x2189] = 0x2478;
	__map_gbk2utf16[0x218a] = 0x2479;
	__map_gbk2utf16[0x218b] = 0x247a;
	__map_gbk2utf16[0x218c] = 0x247b;
	__map_gbk2utf16[0x218d] = 0x247c;
	__map_gbk2utf16[0x218e] = 0x247d;
	__map_gbk2utf16[0x218f] = 0x247e;
	__map_gbk2utf16[0x2190] = 0x247f;
	__map_gbk2utf16[0x2191] = 0x2480;
	__map_gbk2utf16[0x2192] = 0x2481;
	__map_gbk2utf16[0x2193] = 0x2482;
	__map_gbk2utf16[0x2194] = 0x2483;
	__map_gbk2utf16[0x2195] = 0x2484;
	__map_gbk2utf16[0x2196] = 0x2485;
	__map_gbk2utf16[0x2197] = 0x2486;
	__map_gbk2utf16[0x2198] = 0x2487;
	__map_gbk2utf16[0x2199] = 0x2460;
	__map_gbk2utf16[0x219a] = 0x2461;
	__map_gbk2utf16[0x219b] = 0x2462;
	__map_gbk2utf16[0x219c] = 0x2463;
	__map_gbk2utf16[0x219d] = 0x2464;
	__map_gbk2utf16[0x219e] = 0x2465;
	__map_gbk2utf16[0x219f] = 0x2466;
	__map_gbk2utf16[0x21a0] = 0x2467;
	__map_gbk2utf16[0x21a1] = 0x2468;
	__map_gbk2utf16[0x21a2] = 0x2469;
	__map_gbk2utf16[0x21a3] = 0xe76c;
	__map_gbk2utf16[0x21a4] = 0xe76d;
	__map_gbk2utf16[0x21a5] = 0x3220;
	__map_gbk2utf16[0x21a6] = 0x3221;
	__map_gbk2utf16[0x21a7] = 0x3222;
	__map_gbk2utf16[0x21a8] = 0x3223;
	__map_gbk2utf16[0x21a9] = 0x3224;
	__map_gbk2utf16[0x21aa] = 0x3225;
	__map_gbk2utf16[0x21ab] = 0x3226;
	__map_gbk2utf16[0x21ac] = 0x3227;
	__map_gbk2utf16[0x21ad] = 0x3228;
	__map_gbk2utf16[0x21ae] = 0x3229;
	__map_gbk2utf16[0x21af] = 0xe76e;
	__map_gbk2utf16[0x21b0] = 0xe76f;
	__map_gbk2utf16[0x21b1] = 0x2160;
	__map_gbk2utf16[0x21b2] = 0x2161;
	__map_gbk2utf16[0x21b3] = 0x2162;
	__map_gbk2utf16[0x21b4] = 0x2163;
	__map_gbk2utf16[0x21b5] = 0x2164;
	__map_gbk2utf16[0x21b6] = 0x2165;
	__map_gbk2utf16[0x21b7] = 0x2166;
	__map_gbk2utf16[0x21b8] = 0x2167;
	__map_gbk2utf16[0x21b9] = 0x2168;
	__map_gbk2utf16[0x21ba] = 0x2169;
	__map_gbk2utf16[0x21bb] = 0x216a;
	__map_gbk2utf16[0x21bc] = 0x216b;
	__map_gbk2utf16[0x21bd] = 0xe770;
	__map_gbk2utf16[0x21be] = 0xe771;
	__map_gbk2utf16[0x2200] = 0xe586;
	__map_gbk2utf16[0x2201] = 0xe587;
	__map_gbk2utf16[0x2202] = 0xe588;
	__map_gbk2utf16[0x2203] = 0xe589;
	__map_gbk2utf16[0x2204] = 0xe58a;
	__map_gbk2utf16[0x2205] = 0xe58b;
	__map_gbk2utf16[0x2206] = 0xe58c;
	__map_gbk2utf16[0x2207] = 0xe58d;
	__map_gbk2utf16[0x2208] = 0xe58e;
	__map_gbk2utf16[0x2209] = 0xe58f;
	__map_gbk2utf16[0x220a] = 0xe590;
	__map_gbk2utf16[0x220b] = 0xe591;
	__map_gbk2utf16[0x220c] = 0xe592;
	__map_gbk2utf16[0x220d] = 0xe593;
	__map_gbk2utf16[0x220e] = 0xe594;
	__map_gbk2utf16[0x220f] = 0xe595;
	__map_gbk2utf16[0x2210] = 0xe596;
	__map_gbk2utf16[0x2211] = 0xe597;
	__map_gbk2utf16[0x2212] = 0xe598;
	__map_gbk2utf16[0x2213] = 0xe599;
	__map_gbk2utf16[0x2214] = 0xe59a;
	__map_gbk2utf16[0x2215] = 0xe59b;
	__map_gbk2utf16[0x2216] = 0xe59c;
	__map_gbk2utf16[0x2217] = 0xe59d;
	__map_gbk2utf16[0x2218] = 0xe59e;
	__map_gbk2utf16[0x2219] = 0xe59f;
	__map_gbk2utf16[0x221a] = 0xe5a0;
	__map_gbk2utf16[0x221b] = 0xe5a1;
	__map_gbk2utf16[0x221c] = 0xe5a2;
	__map_gbk2utf16[0x221d] = 0xe5a3;
	__map_gbk2utf16[0x221e] = 0xe5a4;
	__map_gbk2utf16[0x221f] = 0xe5a5;
	__map_gbk2utf16[0x2220] = 0xe5a6;
	__map_gbk2utf16[0x2221] = 0xe5a7;
	__map_gbk2utf16[0x2222] = 0xe5a8;
	__map_gbk2utf16[0x2223] = 0xe5a9;
	__map_gbk2utf16[0x2224] = 0xe5aa;
	__map_gbk2utf16[0x2225] = 0xe5ab;
	__map_gbk2utf16[0x2226] = 0xe5ac;
	__map_gbk2utf16[0x2227] = 0xe5ad;
	__map_gbk2utf16[0x2228] = 0xe5ae;
	__map_gbk2utf16[0x2229] = 0xe5af;
	__map_gbk2utf16[0x222a] = 0xe5b0;
	__map_gbk2utf16[0x222b] = 0xe5b1;
	__map_gbk2utf16[0x222c] = 0xe5b2;
	__map_gbk2utf16[0x222d] = 0xe5b3;
	__map_gbk2utf16[0x222e] = 0xe5b4;
	__map_gbk2utf16[0x222f] = 0xe5b5;
	__map_gbk2utf16[0x2230] = 0xe5b6;
	__map_gbk2utf16[0x2231] = 0xe5b7;
	__map_gbk2utf16[0x2232] = 0xe5b8;
	__map_gbk2utf16[0x2233] = 0xe5b9;
	__map_gbk2utf16[0x2234] = 0xe5ba;
	__map_gbk2utf16[0x2235] = 0xe5bb;
	__map_gbk2utf16[0x2236] = 0xe5bc;
	__map_gbk2utf16[0x2237] = 0xe5bd;
	__map_gbk2utf16[0x2238] = 0xe5be;
	__map_gbk2utf16[0x2239] = 0xe5bf;
	__map_gbk2utf16[0x223a] = 0xe5c0;
	__map_gbk2utf16[0x223b] = 0xe5c1;
	__map_gbk2utf16[0x223c] = 0xe5c2;
	__map_gbk2utf16[0x223d] = 0xe5c3;
	__map_gbk2utf16[0x223e] = 0xe5c4;
	__map_gbk2utf16[0x2240] = 0xe5c5;
	__map_gbk2utf16[0x2241] = 0xe5c6;
	__map_gbk2utf16[0x2242] = 0xe5c7;
	__map_gbk2utf16[0x2243] = 0xe5c8;
	__map_gbk2utf16[0x2244] = 0xe5c9;
	__map_gbk2utf16[0x2245] = 0xe5ca;
	__map_gbk2utf16[0x2246] = 0xe5cb;
	__map_gbk2utf16[0x2247] = 0xe5cc;
	__map_gbk2utf16[0x2248] = 0xe5cd;
	__map_gbk2utf16[0x2249] = 0xe5ce;
	__map_gbk2utf16[0x224a] = 0xe5cf;
	__map_gbk2utf16[0x224b] = 0xe5d0;
	__map_gbk2utf16[0x224c] = 0xe5d1;
	__map_gbk2utf16[0x224d] = 0xe5d2;
	__map_gbk2utf16[0x224e] = 0xe5d3;
	__map_gbk2utf16[0x224f] = 0xe5d4;
	__map_gbk2utf16[0x2250] = 0xe5d5;
	__map_gbk2utf16[0x2251] = 0xe5d6;
	__map_gbk2utf16[0x2252] = 0xe5d7;
	__map_gbk2utf16[0x2253] = 0xe5d8;
	__map_gbk2utf16[0x2254] = 0xe5d9;
	__map_gbk2utf16[0x2255] = 0xe5da;
	__map_gbk2utf16[0x2256] = 0xe5db;
	__map_gbk2utf16[0x2257] = 0xe5dc;
	__map_gbk2utf16[0x2258] = 0xe5dd;
	__map_gbk2utf16[0x2259] = 0xe5de;
	__map_gbk2utf16[0x225a] = 0xe5df;
	__map_gbk2utf16[0x225b] = 0xe5e0;
	__map_gbk2utf16[0x225c] = 0xe5e1;
	__map_gbk2utf16[0x225d] = 0xe5e2;
	__map_gbk2utf16[0x225e] = 0xe5e3;
	__map_gbk2utf16[0x225f] = 0xe5e4;
	__map_gbk2utf16[0x2260] = 0xe5e5;
	__map_gbk2utf16[0x2261] = 0xff01;
	__map_gbk2utf16[0x2262] = 0xff02;
	__map_gbk2utf16[0x2263] = 0xff03;
	__map_gbk2utf16[0x2264] = 0xffe5;
	__map_gbk2utf16[0x2265] = 0xff05;
	__map_gbk2utf16[0x2266] = 0xff06;
	__map_gbk2utf16[0x2267] = 0xff07;
	__map_gbk2utf16[0x2268] = 0xff08;
	__map_gbk2utf16[0x2269] = 0xff09;
	__map_gbk2utf16[0x226a] = 0xff0a;
	__map_gbk2utf16[0x226b] = 0xff0b;
	__map_gbk2utf16[0x226c] = 0xff0c;
	__map_gbk2utf16[0x226d] = 0xff0d;
	__map_gbk2utf16[0x226e] = 0xff0e;
	__map_gbk2utf16[0x226f] = 0xff0f;
	__map_gbk2utf16[0x2270] = 0xff10;
	__map_gbk2utf16[0x2271] = 0xff11;
	__map_gbk2utf16[0x2272] = 0xff12;
	__map_gbk2utf16[0x2273] = 0xff13;
	__map_gbk2utf16[0x2274] = 0xff14;
	__map_gbk2utf16[0x2275] = 0xff15;
	__map_gbk2utf16[0x2276] = 0xff16;
	__map_gbk2utf16[0x2277] = 0xff17;
	__map_gbk2utf16[0x2278] = 0xff18;
	__map_gbk2utf16[0x2279] = 0xff19;
	__map_gbk2utf16[0x227a] = 0xff1a;
	__map_gbk2utf16[0x227b] = 0xff1b;
	__map_gbk2utf16[0x227c] = 0xff1c;
	__map_gbk2utf16[0x227d] = 0xff1d;
	__map_gbk2utf16[0x227e] = 0xff1e;
	__map_gbk2utf16[0x227f] = 0xff1f;
	__map_gbk2utf16[0x2280] = 0xff20;
	__map_gbk2utf16[0x2281] = 0xff21;
	__map_gbk2utf16[0x2282] = 0xff22;
	__map_gbk2utf16[0x2283] = 0xff23;
	__map_gbk2utf16[0x2284] = 0xff24;
	__map_gbk2utf16[0x2285] = 0xff25;
	__map_gbk2utf16[0x2286] = 0xff26;
	__map_gbk2utf16[0x2287] = 0xff27;
	__map_gbk2utf16[0x2288] = 0xff28;
	__map_gbk2utf16[0x2289] = 0xff29;
	__map_gbk2utf16[0x228a] = 0xff2a;
	__map_gbk2utf16[0x228b] = 0xff2b;
	__map_gbk2utf16[0x228c] = 0xff2c;
	__map_gbk2utf16[0x228d] = 0xff2d;
	__map_gbk2utf16[0x228e] = 0xff2e;
	__map_gbk2utf16[0x228f] = 0xff2f;
	__map_gbk2utf16[0x2290] = 0xff30;
	__map_gbk2utf16[0x2291] = 0xff31;
	__map_gbk2utf16[0x2292] = 0xff32;
	__map_gbk2utf16[0x2293] = 0xff33;
	__map_gbk2utf16[0x2294] = 0xff34;
	__map_gbk2utf16[0x2295] = 0xff35;
	__map_gbk2utf16[0x2296] = 0xff36;
	__map_gbk2utf16[0x2297] = 0xff37;
	__map_gbk2utf16[0x2298] = 0xff38;
	__map_gbk2utf16[0x2299] = 0xff39;
	__map_gbk2utf16[0x229a] = 0xff3a;
	__map_gbk2utf16[0x229b] = 0xff3b;
	__map_gbk2utf16[0x229c] = 0xff3c;
	__map_gbk2utf16[0x229d] = 0xff3d;
	__map_gbk2utf16[0x229e] = 0xff3e;
	__map_gbk2utf16[0x229f] = 0xff3f;
	__map_gbk2utf16[0x22a0] = 0xff40;
	__map_gbk2utf16[0x22a1] = 0xff41;
	__map_gbk2utf16[0x22a2] = 0xff42;
	__map_gbk2utf16[0x22a3] = 0xff43;
	__map_gbk2utf16[0x22a4] = 0xff44;
	__map_gbk2utf16[0x22a5] = 0xff45;
	__map_gbk2utf16[0x22a6] = 0xff46;
	__map_gbk2utf16[0x22a7] = 0xff47;
	__map_gbk2utf16[0x22a8] = 0xff48;
	__map_gbk2utf16[0x22a9] = 0xff49;
	__map_gbk2utf16[0x22aa] = 0xff4a;
	__map_gbk2utf16[0x22ab] = 0xff4b;
	__map_gbk2utf16[0x22ac] = 0xff4c;
	__map_gbk2utf16[0x22ad] = 0xff4d;
	__map_gbk2utf16[0x22ae] = 0xff4e;
	__map_gbk2utf16[0x22af] = 0xff4f;
	__map_gbk2utf16[0x22b0] = 0xff50;
	__map_gbk2utf16[0x22b1] = 0xff51;
	__map_gbk2utf16[0x22b2] = 0xff52;
	__map_gbk2utf16[0x22b3] = 0xff53;
	__map_gbk2utf16[0x22b4] = 0xff54;
	__map_gbk2utf16[0x22b5] = 0xff55;
	__map_gbk2utf16[0x22b6] = 0xff56;
	__map_gbk2utf16[0x22b7] = 0xff57;
	__map_gbk2utf16[0x22b8] = 0xff58;
	__map_gbk2utf16[0x22b9] = 0xff59;
	__map_gbk2utf16[0x22ba] = 0xff5a;
	__map_gbk2utf16[0x22bb] = 0xff5b;
	__map_gbk2utf16[0x22bc] = 0xff5c;
	__map_gbk2utf16[0x22bd] = 0xff5d;
	__map_gbk2utf16[0x22be] = 0xffe3;
	__map_gbk2utf16[0x2300] = 0xe5e6;
	__map_gbk2utf16[0x2301] = 0xe5e7;
	__map_gbk2utf16[0x2302] = 0xe5e8;
	__map_gbk2utf16[0x2303] = 0xe5e9;
	__map_gbk2utf16[0x2304] = 0xe5ea;
	__map_gbk2utf16[0x2305] = 0xe5eb;
	__map_gbk2utf16[0x2306] = 0xe5ec;
	__map_gbk2utf16[0x2307] = 0xe5ed;
	__map_gbk2utf16[0x2308] = 0xe5ee;
	__map_gbk2utf16[0x2309] = 0xe5ef;
	__map_gbk2utf16[0x230a] = 0xe5f0;
	__map_gbk2utf16[0x230b] = 0xe5f1;
	__map_gbk2utf16[0x230c] = 0xe5f2;
	__map_gbk2utf16[0x230d] = 0xe5f3;
	__map_gbk2utf16[0x230e] = 0xe5f4;
	__map_gbk2utf16[0x230f] = 0xe5f5;
	__map_gbk2utf16[0x2310] = 0xe5f6;
	__map_gbk2utf16[0x2311] = 0xe5f7;
	__map_gbk2utf16[0x2312] = 0xe5f8;
	__map_gbk2utf16[0x2313] = 0xe5f9;
	__map_gbk2utf16[0x2314] = 0xe5fa;
	__map_gbk2utf16[0x2315] = 0xe5fb;
	__map_gbk2utf16[0x2316] = 0xe5fc;
	__map_gbk2utf16[0x2317] = 0xe5fd;
	__map_gbk2utf16[0x2318] = 0xe5fe;
	__map_gbk2utf16[0x2319] = 0xe5ff;
	__map_gbk2utf16[0x231a] = 0xe600;
	__map_gbk2utf16[0x231b] = 0xe601;
	__map_gbk2utf16[0x231c] = 0xe602;
	__map_gbk2utf16[0x231d] = 0xe603;
	__map_gbk2utf16[0x231e] = 0xe604;
	__map_gbk2utf16[0x231f] = 0xe605;
	__map_gbk2utf16[0x2320] = 0xe606;
	__map_gbk2utf16[0x2321] = 0xe607;
	__map_gbk2utf16[0x2322] = 0xe608;
	__map_gbk2utf16[0x2323] = 0xe609;
	__map_gbk2utf16[0x2324] = 0xe60a;
	__map_gbk2utf16[0x2325] = 0xe60b;
	__map_gbk2utf16[0x2326] = 0xe60c;
	__map_gbk2utf16[0x2327] = 0xe60d;
	__map_gbk2utf16[0x2328] = 0xe60e;
	__map_gbk2utf16[0x2329] = 0xe60f;
	__map_gbk2utf16[0x232a] = 0xe610;
	__map_gbk2utf16[0x232b] = 0xe611;
	__map_gbk2utf16[0x232c] = 0xe612;
	__map_gbk2utf16[0x232d] = 0xe613;
	__map_gbk2utf16[0x232e] = 0xe614;
	__map_gbk2utf16[0x232f] = 0xe615;
	__map_gbk2utf16[0x2330] = 0xe616;
	__map_gbk2utf16[0x2331] = 0xe617;
	__map_gbk2utf16[0x2332] = 0xe618;
	__map_gbk2utf16[0x2333] = 0xe619;
	__map_gbk2utf16[0x2334] = 0xe61a;
	__map_gbk2utf16[0x2335] = 0xe61b;
	__map_gbk2utf16[0x2336] = 0xe61c;
	__map_gbk2utf16[0x2337] = 0xe61d;
	__map_gbk2utf16[0x2338] = 0xe61e;
	__map_gbk2utf16[0x2339] = 0xe61f;
	__map_gbk2utf16[0x233a] = 0xe620;
	__map_gbk2utf16[0x233b] = 0xe621;
	__map_gbk2utf16[0x233c] = 0xe622;
	__map_gbk2utf16[0x233d] = 0xe623;
	__map_gbk2utf16[0x233e] = 0xe624;
	__map_gbk2utf16[0x2340] = 0xe625;
	__map_gbk2utf16[0x2341] = 0xe626;
	__map_gbk2utf16[0x2342] = 0xe627;
	__map_gbk2utf16[0x2343] = 0xe628;
	__map_gbk2utf16[0x2344] = 0xe629;
	__map_gbk2utf16[0x2345] = 0xe62a;
	__map_gbk2utf16[0x2346] = 0xe62b;
	__map_gbk2utf16[0x2347] = 0xe62c;
	__map_gbk2utf16[0x2348] = 0xe62d;
	__map_gbk2utf16[0x2349] = 0xe62e;
	__map_gbk2utf16[0x234a] = 0xe62f;
	__map_gbk2utf16[0x234b] = 0xe630;
	__map_gbk2utf16[0x234c] = 0xe631;
	__map_gbk2utf16[0x234d] = 0xe632;
	__map_gbk2utf16[0x234e] = 0xe633;
	__map_gbk2utf16[0x234f] = 0xe634;
	__map_gbk2utf16[0x2350] = 0xe635;
	__map_gbk2utf16[0x2351] = 0xe636;
	__map_gbk2utf16[0x2352] = 0xe637;
	__map_gbk2utf16[0x2353] = 0xe638;
	__map_gbk2utf16[0x2354] = 0xe639;
	__map_gbk2utf16[0x2355] = 0xe63a;
	__map_gbk2utf16[0x2356] = 0xe63b;
	__map_gbk2utf16[0x2357] = 0xe63c;
	__map_gbk2utf16[0x2358] = 0xe63d;
	__map_gbk2utf16[0x2359] = 0xe63e;
	__map_gbk2utf16[0x235a] = 0xe63f;
	__map_gbk2utf16[0x235b] = 0xe640;
	__map_gbk2utf16[0x235c] = 0xe641;
	__map_gbk2utf16[0x235d] = 0xe642;
	__map_gbk2utf16[0x235e] = 0xe643;
	__map_gbk2utf16[0x235f] = 0xe644;
	__map_gbk2utf16[0x2360] = 0xe645;
	__map_gbk2utf16[0x2361] = 0x3041;
	__map_gbk2utf16[0x2362] = 0x3042;
	__map_gbk2utf16[0x2363] = 0x3043;
	__map_gbk2utf16[0x2364] = 0x3044;
	__map_gbk2utf16[0x2365] = 0x3045;
	__map_gbk2utf16[0x2366] = 0x3046;
	__map_gbk2utf16[0x2367] = 0x3047;
	__map_gbk2utf16[0x2368] = 0x3048;
	__map_gbk2utf16[0x2369] = 0x3049;
	__map_gbk2utf16[0x236a] = 0x304a;
	__map_gbk2utf16[0x236b] = 0x304b;
	__map_gbk2utf16[0x236c] = 0x304c;
	__map_gbk2utf16[0x236d] = 0x304d;
	__map_gbk2utf16[0x236e] = 0x304e;
	__map_gbk2utf16[0x236f] = 0x304f;
	__map_gbk2utf16[0x2370] = 0x3050;
	__map_gbk2utf16[0x2371] = 0x3051;
	__map_gbk2utf16[0x2372] = 0x3052;
	__map_gbk2utf16[0x2373] = 0x3053;
	__map_gbk2utf16[0x2374] = 0x3054;
	__map_gbk2utf16[0x2375] = 0x3055;
	__map_gbk2utf16[0x2376] = 0x3056;
	__map_gbk2utf16[0x2377] = 0x3057;
	__map_gbk2utf16[0x2378] = 0x3058;
	__map_gbk2utf16[0x2379] = 0x3059;
	__map_gbk2utf16[0x237a] = 0x305a;
	__map_gbk2utf16[0x237b] = 0x305b;
	__map_gbk2utf16[0x237c] = 0x305c;
	__map_gbk2utf16[0x237d] = 0x305d;
	__map_gbk2utf16[0x237e] = 0x305e;
	__map_gbk2utf16[0x237f] = 0x305f;
	__map_gbk2utf16[0x2380] = 0x3060;
	__map_gbk2utf16[0x2381] = 0x3061;
	__map_gbk2utf16[0x2382] = 0x3062;
	__map_gbk2utf16[0x2383] = 0x3063;
	__map_gbk2utf16[0x2384] = 0x3064;
	__map_gbk2utf16[0x2385] = 0x3065;
	__map_gbk2utf16[0x2386] = 0x3066;
	__map_gbk2utf16[0x2387] = 0x3067;
	__map_gbk2utf16[0x2388] = 0x3068;
	__map_gbk2utf16[0x2389] = 0x3069;
	__map_gbk2utf16[0x238a] = 0x306a;
	__map_gbk2utf16[0x238b] = 0x306b;
	__map_gbk2utf16[0x238c] = 0x306c;
	__map_gbk2utf16[0x238d] = 0x306d;
	__map_gbk2utf16[0x238e] = 0x306e;
	__map_gbk2utf16[0x238f] = 0x306f;
	__map_gbk2utf16[0x2390] = 0x3070;
	__map_gbk2utf16[0x2391] = 0x3071;
	__map_gbk2utf16[0x2392] = 0x3072;
	__map_gbk2utf16[0x2393] = 0x3073;
	__map_gbk2utf16[0x2394] = 0x3074;
	__map_gbk2utf16[0x2395] = 0x3075;
	__map_gbk2utf16[0x2396] = 0x3076;
	__map_gbk2utf16[0x2397] = 0x3077;
	__map_gbk2utf16[0x2398] = 0x3078;
	__map_gbk2utf16[0x2399] = 0x3079;
	__map_gbk2utf16[0x239a] = 0x307a;
	__map_gbk2utf16[0x239b] = 0x307b;
	__map_gbk2utf16[0x239c] = 0x307c;
	__map_gbk2utf16[0x239d] = 0x307d;
	__map_gbk2utf16[0x239e] = 0x307e;
	__map_gbk2utf16[0x239f] = 0x307f;
	__map_gbk2utf16[0x23a0] = 0x3080;
	__map_gbk2utf16[0x23a1] = 0x3081;
	__map_gbk2utf16[0x23a2] = 0x3082;
	__map_gbk2utf16[0x23a3] = 0x3083;
	__map_gbk2utf16[0x23a4] = 0x3084;
	__map_gbk2utf16[0x23a5] = 0x3085;
	__map_gbk2utf16[0x23a6] = 0x3086;
	__map_gbk2utf16[0x23a7] = 0x3087;
	__map_gbk2utf16[0x23a8] = 0x3088;
	__map_gbk2utf16[0x23a9] = 0x3089;
	__map_gbk2utf16[0x23aa] = 0x308a;
	__map_gbk2utf16[0x23ab] = 0x308b;
	__map_gbk2utf16[0x23ac] = 0x308c;
	__map_gbk2utf16[0x23ad] = 0x308d;
	__map_gbk2utf16[0x23ae] = 0x308e;
	__map_gbk2utf16[0x23af] = 0x308f;
	__map_gbk2utf16[0x23b0] = 0x3090;
	__map_gbk2utf16[0x23b1] = 0x3091;
	__map_gbk2utf16[0x23b2] = 0x3092;
	__map_gbk2utf16[0x23b3] = 0x3093;
	__map_gbk2utf16[0x23b4] = 0xe772;
	__map_gbk2utf16[0x23b5] = 0xe773;
	__map_gbk2utf16[0x23b6] = 0xe774;
	__map_gbk2utf16[0x23b7] = 0xe775;
	__map_gbk2utf16[0x23b8] = 0xe776;
	__map_gbk2utf16[0x23b9] = 0xe777;
	__map_gbk2utf16[0x23ba] = 0xe778;
	__map_gbk2utf16[0x23bb] = 0xe779;
	__map_gbk2utf16[0x23bc] = 0xe77a;
	__map_gbk2utf16[0x23bd] = 0xe77b;
	__map_gbk2utf16[0x23be] = 0xe77c;
	__map_gbk2utf16[0x2400] = 0xe646;
	__map_gbk2utf16[0x2401] = 0xe647;
	__map_gbk2utf16[0x2402] = 0xe648;
	__map_gbk2utf16[0x2403] = 0xe649;
	__map_gbk2utf16[0x2404] = 0xe64a;
	__map_gbk2utf16[0x2405] = 0xe64b;
	__map_gbk2utf16[0x2406] = 0xe64c;
	__map_gbk2utf16[0x2407] = 0xe64d;
	__map_gbk2utf16[0x2408] = 0xe64e;
	__map_gbk2utf16[0x2409] = 0xe64f;
	__map_gbk2utf16[0x240a] = 0xe650;
	__map_gbk2utf16[0x240b] = 0xe651;
	__map_gbk2utf16[0x240c] = 0xe652;
	__map_gbk2utf16[0x240d] = 0xe653;
	__map_gbk2utf16[0x240e] = 0xe654;
	__map_gbk2utf16[0x240f] = 0xe655;
	__map_gbk2utf16[0x2410] = 0xe656;
	__map_gbk2utf16[0x2411] = 0xe657;
	__map_gbk2utf16[0x2412] = 0xe658;
	__map_gbk2utf16[0x2413] = 0xe659;
	__map_gbk2utf16[0x2414] = 0xe65a;
	__map_gbk2utf16[0x2415] = 0xe65b;
	__map_gbk2utf16[0x2416] = 0xe65c;
	__map_gbk2utf16[0x2417] = 0xe65d;
	__map_gbk2utf16[0x2418] = 0xe65e;
	__map_gbk2utf16[0x2419] = 0xe65f;
	__map_gbk2utf16[0x241a] = 0xe660;
	__map_gbk2utf16[0x241b] = 0xe661;
	__map_gbk2utf16[0x241c] = 0xe662;
	__map_gbk2utf16[0x241d] = 0xe663;
	__map_gbk2utf16[0x241e] = 0xe664;
	__map_gbk2utf16[0x241f] = 0xe665;
	__map_gbk2utf16[0x2420] = 0xe666;
	__map_gbk2utf16[0x2421] = 0xe667;
	__map_gbk2utf16[0x2422] = 0xe668;
	__map_gbk2utf16[0x2423] = 0xe669;
	__map_gbk2utf16[0x2424] = 0xe66a;
	__map_gbk2utf16[0x2425] = 0xe66b;
	__map_gbk2utf16[0x2426] = 0xe66c;
	__map_gbk2utf16[0x2427] = 0xe66d;
	__map_gbk2utf16[0x2428] = 0xe66e;
	__map_gbk2utf16[0x2429] = 0xe66f;
	__map_gbk2utf16[0x242a] = 0xe670;
	__map_gbk2utf16[0x242b] = 0xe671;
	__map_gbk2utf16[0x242c] = 0xe672;
	__map_gbk2utf16[0x242d] = 0xe673;
	__map_gbk2utf16[0x242e] = 0xe674;
	__map_gbk2utf16[0x242f] = 0xe675;
	__map_gbk2utf16[0x2430] = 0xe676;
	__map_gbk2utf16[0x2431] = 0xe677;
	__map_gbk2utf16[0x2432] = 0xe678;
	__map_gbk2utf16[0x2433] = 0xe679;
	__map_gbk2utf16[0x2434] = 0xe67a;
	__map_gbk2utf16[0x2435] = 0xe67b;
	__map_gbk2utf16[0x2436] = 0xe67c;
	__map_gbk2utf16[0x2437] = 0xe67d;
	__map_gbk2utf16[0x2438] = 0xe67e;
	__map_gbk2utf16[0x2439] = 0xe67f;
	__map_gbk2utf16[0x243a] = 0xe680;
	__map_gbk2utf16[0x243b] = 0xe681;
	__map_gbk2utf16[0x243c] = 0xe682;
	__map_gbk2utf16[0x243d] = 0xe683;
	__map_gbk2utf16[0x243e] = 0xe684;
	__map_gbk2utf16[0x2440] = 0xe685;
	__map_gbk2utf16[0x2441] = 0xe686;
	__map_gbk2utf16[0x2442] = 0xe687;
	__map_gbk2utf16[0x2443] = 0xe688;
	__map_gbk2utf16[0x2444] = 0xe689;
	__map_gbk2utf16[0x2445] = 0xe68a;
	__map_gbk2utf16[0x2446] = 0xe68b;
	__map_gbk2utf16[0x2447] = 0xe68c;
	__map_gbk2utf16[0x2448] = 0xe68d;
	__map_gbk2utf16[0x2449] = 0xe68e;
	__map_gbk2utf16[0x244a] = 0xe68f;
	__map_gbk2utf16[0x244b] = 0xe690;
	__map_gbk2utf16[0x244c] = 0xe691;
	__map_gbk2utf16[0x244d] = 0xe692;
	__map_gbk2utf16[0x244e] = 0xe693;
	__map_gbk2utf16[0x244f] = 0xe694;
	__map_gbk2utf16[0x2450] = 0xe695;
	__map_gbk2utf16[0x2451] = 0xe696;
	__map_gbk2utf16[0x2452] = 0xe697;
	__map_gbk2utf16[0x2453] = 0xe698;
	__map_gbk2utf16[0x2454] = 0xe699;
	__map_gbk2utf16[0x2455] = 0xe69a;
	__map_gbk2utf16[0x2456] = 0xe69b;
	__map_gbk2utf16[0x2457] = 0xe69c;
	__map_gbk2utf16[0x2458] = 0xe69d;
	__map_gbk2utf16[0x2459] = 0xe69e;
	__map_gbk2utf16[0x245a] = 0xe69f;
	__map_gbk2utf16[0x245b] = 0xe6a0;
	__map_gbk2utf16[0x245c] = 0xe6a1;
	__map_gbk2utf16[0x245d] = 0xe6a2;
	__map_gbk2utf16[0x245e] = 0xe6a3;
	__map_gbk2utf16[0x245f] = 0xe6a4;
	__map_gbk2utf16[0x2460] = 0xe6a5;
	__map_gbk2utf16[0x2461] = 0x30a1;
	__map_gbk2utf16[0x2462] = 0x30a2;
	__map_gbk2utf16[0x2463] = 0x30a3;
	__map_gbk2utf16[0x2464] = 0x30a4;
	__map_gbk2utf16[0x2465] = 0x30a5;
	__map_gbk2utf16[0x2466] = 0x30a6;
	__map_gbk2utf16[0x2467] = 0x30a7;
	__map_gbk2utf16[0x2468] = 0x30a8;
	__map_gbk2utf16[0x2469] = 0x30a9;
	__map_gbk2utf16[0x246a] = 0x30aa;
	__map_gbk2utf16[0x246b] = 0x30ab;
	__map_gbk2utf16[0x246c] = 0x30ac;
	__map_gbk2utf16[0x246d] = 0x30ad;
	__map_gbk2utf16[0x246e] = 0x30ae;
	__map_gbk2utf16[0x246f] = 0x30af;
	__map_gbk2utf16[0x2470] = 0x30b0;
	__map_gbk2utf16[0x2471] = 0x30b1;
	__map_gbk2utf16[0x2472] = 0x30b2;
	__map_gbk2utf16[0x2473] = 0x30b3;
	__map_gbk2utf16[0x2474] = 0x30b4;
	__map_gbk2utf16[0x2475] = 0x30b5;
	__map_gbk2utf16[0x2476] = 0x30b6;
	__map_gbk2utf16[0x2477] = 0x30b7;
	__map_gbk2utf16[0x2478] = 0x30b8;
	__map_gbk2utf16[0x2479] = 0x30b9;
	__map_gbk2utf16[0x247a] = 0x30ba;
	__map_gbk2utf16[0x247b] = 0x30bb;
	__map_gbk2utf16[0x247c] = 0x30bc;
	__map_gbk2utf16[0x247d] = 0x30bd;
	__map_gbk2utf16[0x247e] = 0x30be;
	__map_gbk2utf16[0x247f] = 0x30bf;
	__map_gbk2utf16[0x2480] = 0x30c0;
	__map_gbk2utf16[0x2481] = 0x30c1;
	__map_gbk2utf16[0x2482] = 0x30c2;
	__map_gbk2utf16[0x2483] = 0x30c3;
	__map_gbk2utf16[0x2484] = 0x30c4;
	__map_gbk2utf16[0x2485] = 0x30c5;
	__map_gbk2utf16[0x2486] = 0x30c6;
	__map_gbk2utf16[0x2487] = 0x30c7;
	__map_gbk2utf16[0x2488] = 0x30c8;
	__map_gbk2utf16[0x2489] = 0x30c9;
	__map_gbk2utf16[0x248a] = 0x30ca;
	__map_gbk2utf16[0x248b] = 0x30cb;
	__map_gbk2utf16[0x248c] = 0x30cc;
	__map_gbk2utf16[0x248d] = 0x30cd;
	__map_gbk2utf16[0x248e] = 0x30ce;
	__map_gbk2utf16[0x248f] = 0x30cf;
	__map_gbk2utf16[0x2490] = 0x30d0;
	__map_gbk2utf16[0x2491] = 0x30d1;
	__map_gbk2utf16[0x2492] = 0x30d2;
	__map_gbk2utf16[0x2493] = 0x30d3;
	__map_gbk2utf16[0x2494] = 0x30d4;
	__map_gbk2utf16[0x2495] = 0x30d5;
	__map_gbk2utf16[0x2496] = 0x30d6;
	__map_gbk2utf16[0x2497] = 0x30d7;
	__map_gbk2utf16[0x2498] = 0x30d8;
	__map_gbk2utf16[0x2499] = 0x30d9;
	__map_gbk2utf16[0x249a] = 0x30da;
	__map_gbk2utf16[0x249b] = 0x30db;
	__map_gbk2utf16[0x249c] = 0x30dc;
	__map_gbk2utf16[0x249d] = 0x30dd;
	__map_gbk2utf16[0x249e] = 0x30de;
	__map_gbk2utf16[0x249f] = 0x30df;
	__map_gbk2utf16[0x24a0] = 0x30e0;
	__map_gbk2utf16[0x24a1] = 0x30e1;
	__map_gbk2utf16[0x24a2] = 0x30e2;
	__map_gbk2utf16[0x24a3] = 0x30e3;
	__map_gbk2utf16[0x24a4] = 0x30e4;
	__map_gbk2utf16[0x24a5] = 0x30e5;
	__map_gbk2utf16[0x24a6] = 0x30e6;
	__map_gbk2utf16[0x24a7] = 0x30e7;
	__map_gbk2utf16[0x24a8] = 0x30e8;
	__map_gbk2utf16[0x24a9] = 0x30e9;
	__map_gbk2utf16[0x24aa] = 0x30ea;
	__map_gbk2utf16[0x24ab] = 0x30eb;
	__map_gbk2utf16[0x24ac] = 0x30ec;
	__map_gbk2utf16[0x24ad] = 0x30ed;
	__map_gbk2utf16[0x24ae] = 0x30ee;
	__map_gbk2utf16[0x24af] = 0x30ef;
	__map_gbk2utf16[0x24b0] = 0x30f0;
	__map_gbk2utf16[0x24b1] = 0x30f1;
	__map_gbk2utf16[0x24b2] = 0x30f2;
	__map_gbk2utf16[0x24b3] = 0x30f3;
	__map_gbk2utf16[0x24b4] = 0x30f4;
	__map_gbk2utf16[0x24b5] = 0x30f5;
	__map_gbk2utf16[0x24b6] = 0x30f6;
	__map_gbk2utf16[0x24b7] = 0xe77d;
	__map_gbk2utf16[0x24b8] = 0xe77e;
	__map_gbk2utf16[0x24b9] = 0xe77f;
	__map_gbk2utf16[0x24ba] = 0xe780;
	__map_gbk2utf16[0x24bb] = 0xe781;
	__map_gbk2utf16[0x24bc] = 0xe782;
	__map_gbk2utf16[0x24bd] = 0xe783;
	__map_gbk2utf16[0x24be] = 0xe784;
	__map_gbk2utf16[0x2500] = 0xe6a6;
	__map_gbk2utf16[0x2501] = 0xe6a7;
	__map_gbk2utf16[0x2502] = 0xe6a8;
	__map_gbk2utf16[0x2503] = 0xe6a9;
	__map_gbk2utf16[0x2504] = 0xe6aa;
	__map_gbk2utf16[0x2505] = 0xe6ab;
	__map_gbk2utf16[0x2506] = 0xe6ac;
	__map_gbk2utf16[0x2507] = 0xe6ad;
	__map_gbk2utf16[0x2508] = 0xe6ae;
	__map_gbk2utf16[0x2509] = 0xe6af;
	__map_gbk2utf16[0x250a] = 0xe6b0;
	__map_gbk2utf16[0x250b] = 0xe6b1;
	__map_gbk2utf16[0x250c] = 0xe6b2;
	__map_gbk2utf16[0x250d] = 0xe6b3;
	__map_gbk2utf16[0x250e] = 0xe6b4;
	__map_gbk2utf16[0x250f] = 0xe6b5;
	__map_gbk2utf16[0x2510] = 0xe6b6;
	__map_gbk2utf16[0x2511] = 0xe6b7;
	__map_gbk2utf16[0x2512] = 0xe6b8;
	__map_gbk2utf16[0x2513] = 0xe6b9;
	__map_gbk2utf16[0x2514] = 0xe6ba;
	__map_gbk2utf16[0x2515] = 0xe6bb;
	__map_gbk2utf16[0x2516] = 0xe6bc;
	__map_gbk2utf16[0x2517] = 0xe6bd;
	__map_gbk2utf16[0x2518] = 0xe6be;
	__map_gbk2utf16[0x2519] = 0xe6bf;
	__map_gbk2utf16[0x251a] = 0xe6c0;
	__map_gbk2utf16[0x251b] = 0xe6c1;
	__map_gbk2utf16[0x251c] = 0xe6c2;
	__map_gbk2utf16[0x251d] = 0xe6c3;
	__map_gbk2utf16[0x251e] = 0xe6c4;
	__map_gbk2utf16[0x251f] = 0xe6c5;
	__map_gbk2utf16[0x2520] = 0xe6c6;
	__map_gbk2utf16[0x2521] = 0xe6c7;
	__map_gbk2utf16[0x2522] = 0xe6c8;
	__map_gbk2utf16[0x2523] = 0xe6c9;
	__map_gbk2utf16[0x2524] = 0xe6ca;
	__map_gbk2utf16[0x2525] = 0xe6cb;
	__map_gbk2utf16[0x2526] = 0xe6cc;
	__map_gbk2utf16[0x2527] = 0xe6cd;
	__map_gbk2utf16[0x2528] = 0xe6ce;
	__map_gbk2utf16[0x2529] = 0xe6cf;
	__map_gbk2utf16[0x252a] = 0xe6d0;
	__map_gbk2utf16[0x252b] = 0xe6d1;
	__map_gbk2utf16[0x252c] = 0xe6d2;
	__map_gbk2utf16[0x252d] = 0xe6d3;
	__map_gbk2utf16[0x252e] = 0xe6d4;
	__map_gbk2utf16[0x252f] = 0xe6d5;
	__map_gbk2utf16[0x2530] = 0xe6d6;
	__map_gbk2utf16[0x2531] = 0xe6d7;
	__map_gbk2utf16[0x2532] = 0xe6d8;
	__map_gbk2utf16[0x2533] = 0xe6d9;
	__map_gbk2utf16[0x2534] = 0xe6da;
	__map_gbk2utf16[0x2535] = 0xe6db;
	__map_gbk2utf16[0x2536] = 0xe6dc;
	__map_gbk2utf16[0x2537] = 0xe6dd;
	__map_gbk2utf16[0x2538] = 0xe6de;
	__map_gbk2utf16[0x2539] = 0xe6df;
	__map_gbk2utf16[0x253a] = 0xe6e0;
	__map_gbk2utf16[0x253b] = 0xe6e1;
	__map_gbk2utf16[0x253c] = 0xe6e2;
	__map_gbk2utf16[0x253d] = 0xe6e3;
	__map_gbk2utf16[0x253e] = 0xe6e4;
	__map_gbk2utf16[0x2540] = 0xe6e5;
	__map_gbk2utf16[0x2541] = 0xe6e6;
	__map_gbk2utf16[0x2542] = 0xe6e7;
	__map_gbk2utf16[0x2543] = 0xe6e8;
	__map_gbk2utf16[0x2544] = 0xe6e9;
	__map_gbk2utf16[0x2545] = 0xe6ea;
	__map_gbk2utf16[0x2546] = 0xe6eb;
	__map_gbk2utf16[0x2547] = 0xe6ec;
	__map_gbk2utf16[0x2548] = 0xe6ed;
	__map_gbk2utf16[0x2549] = 0xe6ee;
	__map_gbk2utf16[0x254a] = 0xe6ef;
	__map_gbk2utf16[0x254b] = 0xe6f0;
	__map_gbk2utf16[0x254c] = 0xe6f1;
	__map_gbk2utf16[0x254d] = 0xe6f2;
	__map_gbk2utf16[0x254e] = 0xe6f3;
	__map_gbk2utf16[0x254f] = 0xe6f4;
	__map_gbk2utf16[0x2550] = 0xe6f5;
	__map_gbk2utf16[0x2551] = 0xe6f6;
	__map_gbk2utf16[0x2552] = 0xe6f7;
	__map_gbk2utf16[0x2553] = 0xe6f8;
	__map_gbk2utf16[0x2554] = 0xe6f9;
	__map_gbk2utf16[0x2555] = 0xe6fa;
	__map_gbk2utf16[0x2556] = 0xe6fb;
	__map_gbk2utf16[0x2557] = 0xe6fc;
	__map_gbk2utf16[0x2558] = 0xe6fd;
	__map_gbk2utf16[0x2559] = 0xe6fe;
	__map_gbk2utf16[0x255a] = 0xe6ff;
	__map_gbk2utf16[0x255b] = 0xe700;
	__map_gbk2utf16[0x255c] = 0xe701;
	__map_gbk2utf16[0x255d] = 0xe702;
	__map_gbk2utf16[0x255e] = 0xe703;
	__map_gbk2utf16[0x255f] = 0xe704;
	__map_gbk2utf16[0x2560] = 0xe705;
	__map_gbk2utf16[0x2561] = 0x0391;
	__map_gbk2utf16[0x2562] = 0x0392;
	__map_gbk2utf16[0x2563] = 0x0393;
	__map_gbk2utf16[0x2564] = 0x0394;
	__map_gbk2utf16[0x2565] = 0x0395;
	__map_gbk2utf16[0x2566] = 0x0396;
	__map_gbk2utf16[0x2567] = 0x0397;
	__map_gbk2utf16[0x2568] = 0x0398;
	__map_gbk2utf16[0x2569] = 0x0399;
	__map_gbk2utf16[0x256a] = 0x039a;
	__map_gbk2utf16[0x256b] = 0x039b;
	__map_gbk2utf16[0x256c] = 0x039c;
	__map_gbk2utf16[0x256d] = 0x039d;
	__map_gbk2utf16[0x256e] = 0x039e;
	__map_gbk2utf16[0x256f] = 0x039f;
	__map_gbk2utf16[0x2570] = 0x03a0;
	__map_gbk2utf16[0x2571] = 0x03a1;
	__map_gbk2utf16[0x2572] = 0x03a3;
	__map_gbk2utf16[0x2573] = 0x03a4;
	__map_gbk2utf16[0x2574] = 0x03a5;
	__map_gbk2utf16[0x2575] = 0x03a6;
	__map_gbk2utf16[0x2576] = 0x03a7;
	__map_gbk2utf16[0x2577] = 0x03a8;
	__map_gbk2utf16[0x2578] = 0x03a9;
	__map_gbk2utf16[0x2579] = 0xe785;
	__map_gbk2utf16[0x257a] = 0xe786;
	__map_gbk2utf16[0x257b] = 0xe787;
	__map_gbk2utf16[0x257c] = 0xe788;
	__map_gbk2utf16[0x257d] = 0xe789;
	__map_gbk2utf16[0x257e] = 0xe78a;
	__map_gbk2utf16[0x257f] = 0xe78b;
	__map_gbk2utf16[0x2580] = 0xe78c;
	__map_gbk2utf16[0x2581] = 0x03b1;
	__map_gbk2utf16[0x2582] = 0x03b2;
	__map_gbk2utf16[0x2583] = 0x03b3;
	__map_gbk2utf16[0x2584] = 0x03b4;
	__map_gbk2utf16[0x2585] = 0x03b5;
	__map_gbk2utf16[0x2586] = 0x03b6;
	__map_gbk2utf16[0x2587] = 0x03b7;
	__map_gbk2utf16[0x2588] = 0x03b8;
	__map_gbk2utf16[0x2589] = 0x03b9;
	__map_gbk2utf16[0x258a] = 0x03ba;
	__map_gbk2utf16[0x258b] = 0x03bb;
	__map_gbk2utf16[0x258c] = 0x03bc;
	__map_gbk2utf16[0x258d] = 0x03bd;
	__map_gbk2utf16[0x258e] = 0x03be;
	__map_gbk2utf16[0x258f] = 0x03bf;
	__map_gbk2utf16[0x2590] = 0x03c0;
	__map_gbk2utf16[0x2591] = 0x03c1;
	__map_gbk2utf16[0x2592] = 0x03c3;
	__map_gbk2utf16[0x2593] = 0x03c4;
	__map_gbk2utf16[0x2594] = 0x03c5;
	__map_gbk2utf16[0x2595] = 0x03c6;
	__map_gbk2utf16[0x2596] = 0x03c7;
	__map_gbk2utf16[0x2597] = 0x03c8;
	__map_gbk2utf16[0x2598] = 0x03c9;
	__map_gbk2utf16[0x2599] = 0xe78d;
	__map_gbk2utf16[0x259a] = 0xe78e;
	__map_gbk2utf16[0x259b] = 0xe78f;
	__map_gbk2utf16[0x259c] = 0xe790;
	__map_gbk2utf16[0x259d] = 0xe791;
	__map_gbk2utf16[0x259e] = 0xe792;
	__map_gbk2utf16[0x259f] = 0xe793;
	__map_gbk2utf16[0x25a0] = 0xfe35;
	__map_gbk2utf16[0x25a1] = 0xfe36;
	__map_gbk2utf16[0x25a2] = 0xfe39;
	__map_gbk2utf16[0x25a3] = 0xfe3a;
	__map_gbk2utf16[0x25a4] = 0xfe3f;
	__map_gbk2utf16[0x25a5] = 0xfe40;
	__map_gbk2utf16[0x25a6] = 0xfe3d;
	__map_gbk2utf16[0x25a7] = 0xfe3e;
	__map_gbk2utf16[0x25a8] = 0xfe41;
	__map_gbk2utf16[0x25a9] = 0xfe42;
	__map_gbk2utf16[0x25aa] = 0xfe43;
	__map_gbk2utf16[0x25ab] = 0xfe44;
	__map_gbk2utf16[0x25ac] = 0xe794;
	__map_gbk2utf16[0x25ad] = 0xe795;
	__map_gbk2utf16[0x25ae] = 0xfe3b;
	__map_gbk2utf16[0x25af] = 0xfe3c;
	__map_gbk2utf16[0x25b0] = 0xfe37;
	__map_gbk2utf16[0x25b1] = 0xfe38;
	__map_gbk2utf16[0x25b2] = 0xfe31;
	__map_gbk2utf16[0x25b3] = 0xe796;
	__map_gbk2utf16[0x25b4] = 0xfe33;
	__map_gbk2utf16[0x25b5] = 0xfe34;
	__map_gbk2utf16[0x25b6] = 0xe797;
	__map_gbk2utf16[0x25b7] = 0xe798;
	__map_gbk2utf16[0x25b8] = 0xe799;
	__map_gbk2utf16[0x25b9] = 0xe79a;
	__map_gbk2utf16[0x25ba] = 0xe79b;
	__map_gbk2utf16[0x25bb] = 0xe79c;
	__map_gbk2utf16[0x25bc] = 0xe79d;
	__map_gbk2utf16[0x25bd] = 0xe79e;
	__map_gbk2utf16[0x25be] = 0xe79f;
	__map_gbk2utf16[0x2600] = 0xe706;
	__map_gbk2utf16[0x2601] = 0xe707;
	__map_gbk2utf16[0x2602] = 0xe708;
	__map_gbk2utf16[0x2603] = 0xe709;
	__map_gbk2utf16[0x2604] = 0xe70a;
	__map_gbk2utf16[0x2605] = 0xe70b;
	__map_gbk2utf16[0x2606] = 0xe70c;
	__map_gbk2utf16[0x2607] = 0xe70d;
	__map_gbk2utf16[0x2608] = 0xe70e;
	__map_gbk2utf16[0x2609] = 0xe70f;
	__map_gbk2utf16[0x260a] = 0xe710;
	__map_gbk2utf16[0x260b] = 0xe711;
	__map_gbk2utf16[0x260c] = 0xe712;
	__map_gbk2utf16[0x260d] = 0xe713;
	__map_gbk2utf16[0x260e] = 0xe714;
	__map_gbk2utf16[0x260f] = 0xe715;
	__map_gbk2utf16[0x2610] = 0xe716;
	__map_gbk2utf16[0x2611] = 0xe717;
	__map_gbk2utf16[0x2612] = 0xe718;
	__map_gbk2utf16[0x2613] = 0xe719;
	__map_gbk2utf16[0x2614] = 0xe71a;
	__map_gbk2utf16[0x2615] = 0xe71b;
	__map_gbk2utf16[0x2616] = 0xe71c;
	__map_gbk2utf16[0x2617] = 0xe71d;
	__map_gbk2utf16[0x2618] = 0xe71e;
	__map_gbk2utf16[0x2619] = 0xe71f;
	__map_gbk2utf16[0x261a] = 0xe720;
	__map_gbk2utf16[0x261b] = 0xe721;
	__map_gbk2utf16[0x261c] = 0xe722;
	__map_gbk2utf16[0x261d] = 0xe723;
	__map_gbk2utf16[0x261e] = 0xe724;
	__map_gbk2utf16[0x261f] = 0xe725;
	__map_gbk2utf16[0x2620] = 0xe726;
	__map_gbk2utf16[0x2621] = 0xe727;
	__map_gbk2utf16[0x2622] = 0xe728;
	__map_gbk2utf16[0x2623] = 0xe729;
	__map_gbk2utf16[0x2624] = 0xe72a;
	__map_gbk2utf16[0x2625] = 0xe72b;
	__map_gbk2utf16[0x2626] = 0xe72c;
	__map_gbk2utf16[0x2627] = 0xe72d;
	__map_gbk2utf16[0x2628] = 0xe72e;
	__map_gbk2utf16[0x2629] = 0xe72f;
	__map_gbk2utf16[0x262a] = 0xe730;
	__map_gbk2utf16[0x262b] = 0xe731;
	__map_gbk2utf16[0x262c] = 0xe732;
	__map_gbk2utf16[0x262d] = 0xe733;
	__map_gbk2utf16[0x262e] = 0xe734;
	__map_gbk2utf16[0x262f] = 0xe735;
	__map_gbk2utf16[0x2630] = 0xe736;
	__map_gbk2utf16[0x2631] = 0xe737;
	__map_gbk2utf16[0x2632] = 0xe738;
	__map_gbk2utf16[0x2633] = 0xe739;
	__map_gbk2utf16[0x2634] = 0xe73a;
	__map_gbk2utf16[0x2635] = 0xe73b;
	__map_gbk2utf16[0x2636] = 0xe73c;
	__map_gbk2utf16[0x2637] = 0xe73d;
	__map_gbk2utf16[0x2638] = 0xe73e;
	__map_gbk2utf16[0x2639] = 0xe73f;
	__map_gbk2utf16[0x263a] = 0xe740;
	__map_gbk2utf16[0x263b] = 0xe741;
	__map_gbk2utf16[0x263c] = 0xe742;
	__map_gbk2utf16[0x263d] = 0xe743;
	__map_gbk2utf16[0x263e] = 0xe744;
	__map_gbk2utf16[0x2640] = 0xe745;
	__map_gbk2utf16[0x2641] = 0xe746;
	__map_gbk2utf16[0x2642] = 0xe747;
	__map_gbk2utf16[0x2643] = 0xe748;
	__map_gbk2utf16[0x2644] = 0xe749;
	__map_gbk2utf16[0x2645] = 0xe74a;
	__map_gbk2utf16[0x2646] = 0xe74b;
	__map_gbk2utf16[0x2647] = 0xe74c;
	__map_gbk2utf16[0x2648] = 0xe74d;
	__map_gbk2utf16[0x2649] = 0xe74e;
	__map_gbk2utf16[0x264a] = 0xe74f;
	__map_gbk2utf16[0x264b] = 0xe750;
	__map_gbk2utf16[0x264c] = 0xe751;
	__map_gbk2utf16[0x264d] = 0xe752;
	__map_gbk2utf16[0x264e] = 0xe753;
	__map_gbk2utf16[0x264f] = 0xe754;
	__map_gbk2utf16[0x2650] = 0xe755;
	__map_gbk2utf16[0x2651] = 0xe756;
	__map_gbk2utf16[0x2652] = 0xe757;
	__map_gbk2utf16[0x2653] = 0xe758;
	__map_gbk2utf16[0x2654] = 0xe759;
	__map_gbk2utf16[0x2655] = 0xe75a;
	__map_gbk2utf16[0x2656] = 0xe75b;
	__map_gbk2utf16[0x2657] = 0xe75c;
	__map_gbk2utf16[0x2658] = 0xe75d;
	__map_gbk2utf16[0x2659] = 0xe75e;
	__map_gbk2utf16[0x265a] = 0xe75f;
	__map_gbk2utf16[0x265b] = 0xe760;
	__map_gbk2utf16[0x265c] = 0xe761;
	__map_gbk2utf16[0x265d] = 0xe762;
	__map_gbk2utf16[0x265e] = 0xe763;
	__map_gbk2utf16[0x265f] = 0xe764;
	__map_gbk2utf16[0x2660] = 0xe765;
	__map_gbk2utf16[0x2661] = 0x0410;
	__map_gbk2utf16[0x2662] = 0x0411;
	__map_gbk2utf16[0x2663] = 0x0412;
	__map_gbk2utf16[0x2664] = 0x0413;
	__map_gbk2utf16[0x2665] = 0x0414;
	__map_gbk2utf16[0x2666] = 0x0415;
	__map_gbk2utf16[0x2667] = 0x0401;
	__map_gbk2utf16[0x2668] = 0x0416;
	__map_gbk2utf16[0x2669] = 0x0417;
	__map_gbk2utf16[0x266a] = 0x0418;
	__map_gbk2utf16[0x266b] = 0x0419;
	__map_gbk2utf16[0x266c] = 0x041a;
	__map_gbk2utf16[0x266d] = 0x041b;
	__map_gbk2utf16[0x266e] = 0x041c;
	__map_gbk2utf16[0x266f] = 0x041d;
	__map_gbk2utf16[0x2670] = 0x041e;
	__map_gbk2utf16[0x2671] = 0x041f;
	__map_gbk2utf16[0x2672] = 0x0420;
	__map_gbk2utf16[0x2673] = 0x0421;
	__map_gbk2utf16[0x2674] = 0x0422;
	__map_gbk2utf16[0x2675] = 0x0423;
	__map_gbk2utf16[0x2676] = 0x0424;
	__map_gbk2utf16[0x2677] = 0x0425;
	__map_gbk2utf16[0x2678] = 0x0426;
	__map_gbk2utf16[0x2679] = 0x0427;
	__map_gbk2utf16[0x267a] = 0x0428;
	__map_gbk2utf16[0x267b] = 0x0429;
	__map_gbk2utf16[0x267c] = 0x042a;
	__map_gbk2utf16[0x267d] = 0x042b;
	__map_gbk2utf16[0x267e] = 0x042c;
	__map_gbk2utf16[0x267f] = 0x042d;
	__map_gbk2utf16[0x2680] = 0x042e;
	__map_gbk2utf16[0x2681] = 0x042f;
	__map_gbk2utf16[0x2682] = 0xe7a0;
	__map_gbk2utf16[0x2683] = 0xe7a1;
	__map_gbk2utf16[0x2684] = 0xe7a2;
	__map_gbk2utf16[0x2685] = 0xe7a3;
	__map_gbk2utf16[0x2686] = 0xe7a4;
	__map_gbk2utf16[0x2687] = 0xe7a5;
	__map_gbk2utf16[0x2688] = 0xe7a6;
	__map_gbk2utf16[0x2689] = 0xe7a7;
	__map_gbk2utf16[0x268a] = 0xe7a8;
	__map_gbk2utf16[0x268b] = 0xe7a9;
	__map_gbk2utf16[0x268c] = 0xe7aa;
	__map_gbk2utf16[0x268d] = 0xe7ab;
	__map_gbk2utf16[0x268e] = 0xe7ac;
	__map_gbk2utf16[0x268f] = 0xe7ad;
	__map_gbk2utf16[0x2690] = 0xe7ae;
	__map_gbk2utf16[0x2691] = 0x0430;
	__map_gbk2utf16[0x2692] = 0x0431;
	__map_gbk2utf16[0x2693] = 0x0432;
	__map_gbk2utf16[0x2694] = 0x0433;
	__map_gbk2utf16[0x2695] = 0x0434;
	__map_gbk2utf16[0x2696] = 0x0435;
	__map_gbk2utf16[0x2697] = 0x0451;
	__map_gbk2utf16[0x2698] = 0x0436;
	__map_gbk2utf16[0x2699] = 0x0437;
	__map_gbk2utf16[0x269a] = 0x0438;
	__map_gbk2utf16[0x269b] = 0x0439;
	__map_gbk2utf16[0x269c] = 0x043a;
	__map_gbk2utf16[0x269d] = 0x043b;
	__map_gbk2utf16[0x269e] = 0x043c;
	__map_gbk2utf16[0x269f] = 0x043d;
	__map_gbk2utf16[0x26a0] = 0x043e;
	__map_gbk2utf16[0x26a1] = 0x043f;
	__map_gbk2utf16[0x26a2] = 0x0440;
	__map_gbk2utf16[0x26a3] = 0x0441;
	__map_gbk2utf16[0x26a4] = 0x0442;
	__map_gbk2utf16[0x26a5] = 0x0443;
	__map_gbk2utf16[0x26a6] = 0x0444;
	__map_gbk2utf16[0x26a7] = 0x0445;
	__map_gbk2utf16[0x26a8] = 0x0446;
	__map_gbk2utf16[0x26a9] = 0x0447;
	__map_gbk2utf16[0x26aa] = 0x0448;
	__map_gbk2utf16[0x26ab] = 0x0449;
	__map_gbk2utf16[0x26ac] = 0x044a;
	__map_gbk2utf16[0x26ad] = 0x044b;
	__map_gbk2utf16[0x26ae] = 0x044c;
	__map_gbk2utf16[0x26af] = 0x044d;
	__map_gbk2utf16[0x26b0] = 0x044e;
	__map_gbk2utf16[0x26b1] = 0x044f;
	__map_gbk2utf16[0x26b2] = 0xe7af;
	__map_gbk2utf16[0x26b3] = 0xe7b0;
	__map_gbk2utf16[0x26b4] = 0xe7b1;
	__map_gbk2utf16[0x26b5] = 0xe7b2;
	__map_gbk2utf16[0x26b6] = 0xe7b3;
	__map_gbk2utf16[0x26b7] = 0xe7b4;
	__map_gbk2utf16[0x26b8] = 0xe7b5;
	__map_gbk2utf16[0x26b9] = 0xe7b6;
	__map_gbk2utf16[0x26ba] = 0xe7b7;
	__map_gbk2utf16[0x26bb] = 0xe7b8;
	__map_gbk2utf16[0x26bc] = 0xe7b9;
	__map_gbk2utf16[0x26bd] = 0xe7ba;
	__map_gbk2utf16[0x26be] = 0xe7bb;
	__map_gbk2utf16[0x2700] = 0x02ca;
	__map_gbk2utf16[0x2701] = 0x02cb;
	__map_gbk2utf16[0x2702] = 0x02d9;
	__map_gbk2utf16[0x2703] = 0x2013;
	__map_gbk2utf16[0x2704] = 0x2015;
	__map_gbk2utf16[0x2705] = 0x2025;
	__map_gbk2utf16[0x2706] = 0x2035;
	__map_gbk2utf16[0x2707] = 0x2105;
	__map_gbk2utf16[0x2708] = 0x2109;
	__map_gbk2utf16[0x2709] = 0x2196;
	__map_gbk2utf16[0x270a] = 0x2197;
	__map_gbk2utf16[0x270b] = 0x2198;
	__map_gbk2utf16[0x270c] = 0x2199;
	__map_gbk2utf16[0x270d] = 0x2215;
	__map_gbk2utf16[0x270e] = 0x221f;
	__map_gbk2utf16[0x270f] = 0x2223;
	__map_gbk2utf16[0x2710] = 0x2252;
	__map_gbk2utf16[0x2711] = 0x2266;
	__map_gbk2utf16[0x2712] = 0x2267;
	__map_gbk2utf16[0x2713] = 0x22bf;
	__map_gbk2utf16[0x2714] = 0x2550;
	__map_gbk2utf16[0x2715] = 0x2551;
	__map_gbk2utf16[0x2716] = 0x2552;
	__map_gbk2utf16[0x2717] = 0x2553;
	__map_gbk2utf16[0x2718] = 0x2554;
	__map_gbk2utf16[0x2719] = 0x2555;
	__map_gbk2utf16[0x271a] = 0x2556;
	__map_gbk2utf16[0x271b] = 0x2557;
	__map_gbk2utf16[0x271c] = 0x2558;
	__map_gbk2utf16[0x271d] = 0x2559;
	__map_gbk2utf16[0x271e] = 0x255a;
	__map_gbk2utf16[0x271f] = 0x255b;
	__map_gbk2utf16[0x2720] = 0x255c;
	__map_gbk2utf16[0x2721] = 0x255d;
	__map_gbk2utf16[0x2722] = 0x255e;
	__map_gbk2utf16[0x2723] = 0x255f;
	__map_gbk2utf16[0x2724] = 0x2560;
	__map_gbk2utf16[0x2725] = 0x2561;
	__map_gbk2utf16[0x2726] = 0x2562;
	__map_gbk2utf16[0x2727] = 0x2563;
	__map_gbk2utf16[0x2728] = 0x2564;
	__map_gbk2utf16[0x2729] = 0x2565;
	__map_gbk2utf16[0x272a] = 0x2566;
	__map_gbk2utf16[0x272b] = 0x2567;
	__map_gbk2utf16[0x272c] = 0x2568;
	__map_gbk2utf16[0x272d] = 0x2569;
	__map_gbk2utf16[0x272e] = 0x256a;
	__map_gbk2utf16[0x272f] = 0x256b;
	__map_gbk2utf16[0x2730] = 0x256c;
	__map_gbk2utf16[0x2731] = 0x256d;
	__map_gbk2utf16[0x2732] = 0x256e;
	__map_gbk2utf16[0x2733] = 0x256f;
	__map_gbk2utf16[0x2734] = 0x2570;
	__map_gbk2utf16[0x2735] = 0x2571;
	__map_gbk2utf16[0x2736] = 0x2572;
	__map_gbk2utf16[0x2737] = 0x2573;
	__map_gbk2utf16[0x2738] = 0x2581;
	__map_gbk2utf16[0x2739] = 0x2582;
	__map_gbk2utf16[0x273a] = 0x2583;
	__map_gbk2utf16[0x273b] = 0x2584;
	__map_gbk2utf16[0x273c] = 0x2585;
	__map_gbk2utf16[0x273d] = 0x2586;
	__map_gbk2utf16[0x273e] = 0x2587;
	__map_gbk2utf16[0x2740] = 0x2588;
	__map_gbk2utf16[0x2741] = 0x2589;
	__map_gbk2utf16[0x2742] = 0x258a;
	__map_gbk2utf16[0x2743] = 0x258b;
	__map_gbk2utf16[0x2744] = 0x258c;
	__map_gbk2utf16[0x2745] = 0x258d;
	__map_gbk2utf16[0x2746] = 0x258e;
	__map_gbk2utf16[0x2747] = 0x258f;
	__map_gbk2utf16[0x2748] = 0x2593;
	__map_gbk2utf16[0x2749] = 0x2594;
	__map_gbk2utf16[0x274a] = 0x2595;
	__map_gbk2utf16[0x274b] = 0x25bc;
	__map_gbk2utf16[0x274c] = 0x25bd;
	__map_gbk2utf16[0x274d] = 0x25e2;
	__map_gbk2utf16[0x274e] = 0x25e3;
	__map_gbk2utf16[0x274f] = 0x25e4;
	__map_gbk2utf16[0x2750] = 0x25e5;
	__map_gbk2utf16[0x2751] = 0x2609;
	__map_gbk2utf16[0x2752] = 0x2295;
	__map_gbk2utf16[0x2753] = 0x3012;
	__map_gbk2utf16[0x2754] = 0x301d;
	__map_gbk2utf16[0x2755] = 0x301e;
	__map_gbk2utf16[0x2756] = 0xe7bc;
	__map_gbk2utf16[0x2757] = 0xe7bd;
	__map_gbk2utf16[0x2758] = 0xe7be;
	__map_gbk2utf16[0x2759] = 0xe7bf;
	__map_gbk2utf16[0x275a] = 0xe7c0;
	__map_gbk2utf16[0x275b] = 0xe7c1;
	__map_gbk2utf16[0x275c] = 0xe7c2;
	__map_gbk2utf16[0x275d] = 0xe7c3;
	__map_gbk2utf16[0x275e] = 0xe7c4;
	__map_gbk2utf16[0x275f] = 0xe7c5;
	__map_gbk2utf16[0x2760] = 0xe7c6;
	__map_gbk2utf16[0x2761] = 0x0101;
	__map_gbk2utf16[0x2762] = 0x00e1;
	__map_gbk2utf16[0x2763] = 0x01ce;
	__map_gbk2utf16[0x2764] = 0x00e0;
	__map_gbk2utf16[0x2765] = 0x0113;
	__map_gbk2utf16[0x2766] = 0x00e9;
	__map_gbk2utf16[0x2767] = 0x011b;
	__map_gbk2utf16[0x2768] = 0x00e8;
	__map_gbk2utf16[0x2769] = 0x012b;
	__map_gbk2utf16[0x276a] = 0x00ed;
	__map_gbk2utf16[0x276b] = 0x01d0;
	__map_gbk2utf16[0x276c] = 0x00ec;
	__map_gbk2utf16[0x276d] = 0x014d;
	__map_gbk2utf16[0x276e] = 0x00f3;
	__map_gbk2utf16[0x276f] = 0x01d2;
	__map_gbk2utf16[0x2770] = 0x00f2;
	__map_gbk2utf16[0x2771] = 0x016b;
	__map_gbk2utf16[0x2772] = 0x00fa;
	__map_gbk2utf16[0x2773] = 0x01d4;
	__map_gbk2utf16[0x2774] = 0x00f9;
	__map_gbk2utf16[0x2775] = 0x01d6;
	__map_gbk2utf16[0x2776] = 0x01d8;
	__map_gbk2utf16[0x2777] = 0x01da;
	__map_gbk2utf16[0x2778] = 0x01dc;
	__map_gbk2utf16[0x2779] = 0x00fc;
	__map_gbk2utf16[0x277a] = 0x00ea;
	__map_gbk2utf16[0x277b] = 0x0251;
	__map_gbk2utf16[0x277c] = 0xe7c7;
	__map_gbk2utf16[0x277d] = 0x0144;
	__map_gbk2utf16[0x277e] = 0x0148;
	__map_gbk2utf16[0x277f] = 0xe7c8;
	__map_gbk2utf16[0x2780] = 0x0261;
	__map_gbk2utf16[0x2781] = 0xe7c9;
	__map_gbk2utf16[0x2782] = 0xe7ca;
	__map_gbk2utf16[0x2783] = 0xe7cb;
	__map_gbk2utf16[0x2784] = 0xe7cc;
	__map_gbk2utf16[0x2785] = 0x3105;
	__map_gbk2utf16[0x2786] = 0x3106;
	__map_gbk2utf16[0x2787] = 0x3107;
	__map_gbk2utf16[0x2788] = 0x3108;
	__map_gbk2utf16[0x2789] = 0x3109;
	__map_gbk2utf16[0x278a] = 0x310a;
	__map_gbk2utf16[0x278b] = 0x310b;
	__map_gbk2utf16[0x278c] = 0x310c;
	__map_gbk2utf16[0x278d] = 0x310d;
	__map_gbk2utf16[0x278e] = 0x310e;
	__map_gbk2utf16[0x278f] = 0x310f;
	__map_gbk2utf16[0x2790] = 0x3110;
	__map_gbk2utf16[0x2791] = 0x3111;
	__map_gbk2utf16[0x2792] = 0x3112;
	__map_gbk2utf16[0x2793] = 0x3113;
	__map_gbk2utf16[0x2794] = 0x3114;
	__map_gbk2utf16[0x2795] = 0x3115;
	__map_gbk2utf16[0x2796] = 0x3116;
	__map_gbk2utf16[0x2797] = 0x3117;
	__map_gbk2utf16[0x2798] = 0x3118;
	__map_gbk2utf16[0x2799] = 0x3119;
	__map_gbk2utf16[0x279a] = 0x311a;
	__map_gbk2utf16[0x279b] = 0x311b;
	__map_gbk2utf16[0x279c] = 0x311c;
	__map_gbk2utf16[0x279d] = 0x311d;
	__map_gbk2utf16[0x279e] = 0x311e;
	__map_gbk2utf16[0x279f] = 0x311f;
	__map_gbk2utf16[0x27a0] = 0x3120;
	__map_gbk2utf16[0x27a1] = 0x3121;
	__map_gbk2utf16[0x27a2] = 0x3122;
	__map_gbk2utf16[0x27a3] = 0x3123;
	__map_gbk2utf16[0x27a4] = 0x3124;
	__map_gbk2utf16[0x27a5] = 0x3125;
	__map_gbk2utf16[0x27a6] = 0x3126;
	__map_gbk2utf16[0x27a7] = 0x3127;
	__map_gbk2utf16[0x27a8] = 0x3128;
	__map_gbk2utf16[0x27a9] = 0x3129;
	__map_gbk2utf16[0x27aa] = 0xe7cd;
	__map_gbk2utf16[0x27ab] = 0xe7ce;
	__map_gbk2utf16[0x27ac] = 0xe7cf;
	__map_gbk2utf16[0x27ad] = 0xe7d0;
	__map_gbk2utf16[0x27ae] = 0xe7d1;
	__map_gbk2utf16[0x27af] = 0xe7d2;
	__map_gbk2utf16[0x27b0] = 0xe7d3;
	__map_gbk2utf16[0x27b1] = 0xe7d4;
	__map_gbk2utf16[0x27b2] = 0xe7d5;
	__map_gbk2utf16[0x27b3] = 0xe7d6;
	__map_gbk2utf16[0x27b4] = 0xe7d7;
	__map_gbk2utf16[0x27b5] = 0xe7d8;
	__map_gbk2utf16[0x27b6] = 0xe7d9;
	__map_gbk2utf16[0x27b7] = 0xe7da;
	__map_gbk2utf16[0x27b8] = 0xe7db;
	__map_gbk2utf16[0x27b9] = 0xe7dc;
	__map_gbk2utf16[0x27ba] = 0xe7dd;
	__map_gbk2utf16[0x27bb] = 0xe7de;
	__map_gbk2utf16[0x27bc] = 0xe7df;
	__map_gbk2utf16[0x27bd] = 0xe7e0;
	__map_gbk2utf16[0x27be] = 0xe7e1;
	__map_gbk2utf16[0x2800] = 0x3021;
	__map_gbk2utf16[0x2801] = 0x3022;
	__map_gbk2utf16[0x2802] = 0x3023;
	__map_gbk2utf16[0x2803] = 0x3024;
	__map_gbk2utf16[0x2804] = 0x3025;
	__map_gbk2utf16[0x2805] = 0x3026;
	__map_gbk2utf16[0x2806] = 0x3027;
	__map_gbk2utf16[0x2807] = 0x3028;
	__map_gbk2utf16[0x2808] = 0x3029;
	__map_gbk2utf16[0x2809] = 0x32a3;
	__map_gbk2utf16[0x280a] = 0x338e;
	__map_gbk2utf16[0x280b] = 0x338f;
	__map_gbk2utf16[0x280c] = 0x339c;
	__map_gbk2utf16[0x280d] = 0x339d;
	__map_gbk2utf16[0x280e] = 0x339e;
	__map_gbk2utf16[0x280f] = 0x33a1;
	__map_gbk2utf16[0x2810] = 0x33c4;
	__map_gbk2utf16[0x2811] = 0x33ce;
	__map_gbk2utf16[0x2812] = 0x33d1;
	__map_gbk2utf16[0x2813] = 0x33d2;
	__map_gbk2utf16[0x2814] = 0x33d5;
	__map_gbk2utf16[0x2815] = 0xfe30;
	__map_gbk2utf16[0x2816] = 0xffe2;
	__map_gbk2utf16[0x2817] = 0xffe4;
	__map_gbk2utf16[0x2818] = 0xe7e2;
	__map_gbk2utf16[0x2819] = 0x2121;
	__map_gbk2utf16[0x281a] = 0x3231;
	__map_gbk2utf16[0x281b] = 0xe7e3;
	__map_gbk2utf16[0x281c] = 0x2010;
	__map_gbk2utf16[0x281d] = 0xe7e4;
	__map_gbk2utf16[0x281e] = 0xe7e5;
	__map_gbk2utf16[0x281f] = 0xe7e6;
	__map_gbk2utf16[0x2820] = 0x30fc;
	__map_gbk2utf16[0x2821] = 0x309b;
	__map_gbk2utf16[0x2822] = 0x309c;
	__map_gbk2utf16[0x2823] = 0x30fd;
	__map_gbk2utf16[0x2824] = 0x30fe;
	__map_gbk2utf16[0x2825] = 0x3006;
	__map_gbk2utf16[0x2826] = 0x309d;
	__map_gbk2utf16[0x2827] = 0x309e;
	__map_gbk2utf16[0x2828] = 0xfe49;
	__map_gbk2utf16[0x2829] = 0xfe4a;
	__map_gbk2utf16[0x282a] = 0xfe4b;
	__map_gbk2utf16[0x282b] = 0xfe4c;
	__map_gbk2utf16[0x282c] = 0xfe4d;
	__map_gbk2utf16[0x282d] = 0xfe4e;
	__map_gbk2utf16[0x282e] = 0xfe4f;
	__map_gbk2utf16[0x282f] = 0xfe50;
	__map_gbk2utf16[0x2830] = 0xfe51;
	__map_gbk2utf16[0x2831] = 0xfe52;
	__map_gbk2utf16[0x2832] = 0xfe54;
	__map_gbk2utf16[0x2833] = 0xfe55;
	__map_gbk2utf16[0x2834] = 0xfe56;
	__map_gbk2utf16[0x2835] = 0xfe57;
	__map_gbk2utf16[0x2836] = 0xfe59;
	__map_gbk2utf16[0x2837] = 0xfe5a;
	__map_gbk2utf16[0x2838] = 0xfe5b;
	__map_gbk2utf16[0x2839] = 0xfe5c;
	__map_gbk2utf16[0x283a] = 0xfe5d;
	__map_gbk2utf16[0x283b] = 0xfe5e;
	__map_gbk2utf16[0x283c] = 0xfe5f;
	__map_gbk2utf16[0x283d] = 0xfe60;
	__map_gbk2utf16[0x283e] = 0xfe61;
	__map_gbk2utf16[0x2840] = 0xfe62;
	__map_gbk2utf16[0x2841] = 0xfe63;
	__map_gbk2utf16[0x2842] = 0xfe64;
	__map_gbk2utf16[0x2843] = 0xfe65;
	__map_gbk2utf16[0x2844] = 0xfe66;
	__map_gbk2utf16[0x2845] = 0xfe68;
	__map_gbk2utf16[0x2846] = 0xfe69;
	__map_gbk2utf16[0x2847] = 0xfe6a;
	__map_gbk2utf16[0x2848] = 0xfe6b;
	__map_gbk2utf16[0x2849] = 0xe7e7;
	__map_gbk2utf16[0x284a] = 0xe7e8;
	__map_gbk2utf16[0x284b] = 0xe7e9;
	__map_gbk2utf16[0x284c] = 0xe7ea;
	__map_gbk2utf16[0x284d] = 0xe7eb;
	__map_gbk2utf16[0x284e] = 0xe7ec;
	__map_gbk2utf16[0x284f] = 0xe7ed;
	__map_gbk2utf16[0x2850] = 0xe7ee;
	__map_gbk2utf16[0x2851] = 0xe7ef;
	__map_gbk2utf16[0x2852] = 0xe7f0;
	__map_gbk2utf16[0x2853] = 0xe7f1;
	__map_gbk2utf16[0x2854] = 0xe7f2;
	__map_gbk2utf16[0x2855] = 0xe7f3;
	__map_gbk2utf16[0x2856] = 0x3007;
	__map_gbk2utf16[0x2857] = 0xe7f4;
	__map_gbk2utf16[0x2858] = 0xe7f5;
	__map_gbk2utf16[0x2859] = 0xe7f6;
	__map_gbk2utf16[0x285a] = 0xe7f7;
	__map_gbk2utf16[0x285b] = 0xe7f8;
	__map_gbk2utf16[0x285c] = 0xe7f9;
	__map_gbk2utf16[0x285d] = 0xe7fa;
	__map_gbk2utf16[0x285e] = 0xe7fb;
	__map_gbk2utf16[0x285f] = 0xe7fc;
	__map_gbk2utf16[0x2860] = 0xe7fd;
	__map_gbk2utf16[0x2861] = 0xe7fe;
	__map_gbk2utf16[0x2862] = 0xe7ff;
	__map_gbk2utf16[0x2863] = 0xe800;
	__map_gbk2utf16[0x2864] = 0x2500;
	__map_gbk2utf16[0x2865] = 0x2501;
	__map_gbk2utf16[0x2866] = 0x2502;
	__map_gbk2utf16[0x2867] = 0x2503;
	__map_gbk2utf16[0x2868] = 0x2504;
	__map_gbk2utf16[0x2869] = 0x2505;
	__map_gbk2utf16[0x286a] = 0x2506;
	__map_gbk2utf16[0x286b] = 0x2507;
	__map_gbk2utf16[0x286c] = 0x2508;
	__map_gbk2utf16[0x286d] = 0x2509;
	__map_gbk2utf16[0x286e] = 0x250a;
	__map_gbk2utf16[0x286f] = 0x250b;
	__map_gbk2utf16[0x2870] = 0x250c;
	__map_gbk2utf16[0x2871] = 0x250d;
	__map_gbk2utf16[0x2872] = 0x250e;
	__map_gbk2utf16[0x2873] = 0x250f;
	__map_gbk2utf16[0x2874] = 0x2510;
	__map_gbk2utf16[0x2875] = 0x2511;
	__map_gbk2utf16[0x2876] = 0x2512;
	__map_gbk2utf16[0x2877] = 0x2513;
	__map_gbk2utf16[0x2878] = 0x2514;
	__map_gbk2utf16[0x2879] = 0x2515;
	__map_gbk2utf16[0x287a] = 0x2516;
	__map_gbk2utf16[0x287b] = 0x2517;
	__map_gbk2utf16[0x287c] = 0x2518;
	__map_gbk2utf16[0x287d] = 0x2519;
	__map_gbk2utf16[0x287e] = 0x251a;
	__map_gbk2utf16[0x287f] = 0x251b;
	__map_gbk2utf16[0x2880] = 0x251c;
	__map_gbk2utf16[0x2881] = 0x251d;
	__map_gbk2utf16[0x2882] = 0x251e;
	__map_gbk2utf16[0x2883] = 0x251f;
	__map_gbk2utf16[0x2884] = 0x2520;
	__map_gbk2utf16[0x2885] = 0x2521;
	__map_gbk2utf16[0x2886] = 0x2522;
	__map_gbk2utf16[0x2887] = 0x2523;
	__map_gbk2utf16[0x2888] = 0x2524;
	__map_gbk2utf16[0x2889] = 0x2525;
	__map_gbk2utf16[0x288a] = 0x2526;
	__map_gbk2utf16[0x288b] = 0x2527;
	__map_gbk2utf16[0x288c] = 0x2528;
	__map_gbk2utf16[0x288d] = 0x2529;
	__map_gbk2utf16[0x288e] = 0x252a;
	__map_gbk2utf16[0x288f] = 0x252b;
	__map_gbk2utf16[0x2890] = 0x252c;
	__map_gbk2utf16[0x2891] = 0x252d;
	__map_gbk2utf16[0x2892] = 0x252e;
	__map_gbk2utf16[0x2893] = 0x252f;
	__map_gbk2utf16[0x2894] = 0x2530;
	__map_gbk2utf16[0x2895] = 0x2531;
	__map_gbk2utf16[0x2896] = 0x2532;
	__map_gbk2utf16[0x2897] = 0x2533;
	__map_gbk2utf16[0x2898] = 0x2534;
	__map_gbk2utf16[0x2899] = 0x2535;
	__map_gbk2utf16[0x289a] = 0x2536;
	__map_gbk2utf16[0x289b] = 0x2537;
	__map_gbk2utf16[0x289c] = 0x2538;
	__map_gbk2utf16[0x289d] = 0x2539;
	__map_gbk2utf16[0x289e] = 0x253a;
	__map_gbk2utf16[0x289f] = 0x253b;
	__map_gbk2utf16[0x28a0] = 0x253c;
	__map_gbk2utf16[0x28a1] = 0x253d;
	__map_gbk2utf16[0x28a2] = 0x253e;
	__map_gbk2utf16[0x28a3] = 0x253f;
	__map_gbk2utf16[0x28a4] = 0x2540;
	__map_gbk2utf16[0x28a5] = 0x2541;
	__map_gbk2utf16[0x28a6] = 0x2542;
	__map_gbk2utf16[0x28a7] = 0x2543;
	__map_gbk2utf16[0x28a8] = 0x2544;
	__map_gbk2utf16[0x28a9] = 0x2545;
	__map_gbk2utf16[0x28aa] = 0x2546;
	__map_gbk2utf16[0x28ab] = 0x2547;
	__map_gbk2utf16[0x28ac] = 0x2548;
	__map_gbk2utf16[0x28ad] = 0x2549;
	__map_gbk2utf16[0x28ae] = 0x254a;
	__map_gbk2utf16[0x28af] = 0x254b;
	__map_gbk2utf16[0x28b0] = 0xe801;
	__map_gbk2utf16[0x28b1] = 0xe802;
	__map_gbk2utf16[0x28b2] = 0xe803;
	__map_gbk2utf16[0x28b3] = 0xe804;
	__map_gbk2utf16[0x28b4] = 0xe805;
	__map_gbk2utf16[0x28b5] = 0xe806;
	__map_gbk2utf16[0x28b6] = 0xe807;
	__map_gbk2utf16[0x28b7] = 0xe808;
	__map_gbk2utf16[0x28b8] = 0xe809;
	__map_gbk2utf16[0x28b9] = 0xe80a;
	__map_gbk2utf16[0x28ba] = 0xe80b;
	__map_gbk2utf16[0x28bb] = 0xe80c;
	__map_gbk2utf16[0x28bc] = 0xe80d;
	__map_gbk2utf16[0x28bd] = 0xe80e;
	__map_gbk2utf16[0x28be] = 0xe80f;
	__map_gbk2utf16[0x2900] = 0x72dc;
	__map_gbk2utf16[0x2901] = 0x72dd;
	__map_gbk2utf16[0x2902] = 0x72df;
	__map_gbk2utf16[0x2903] = 0x72e2;
	__map_gbk2utf16[0x2904] = 0x72e3;
	__map_gbk2utf16[0x2905] = 0x72e4;
	__map_gbk2utf16[0x2906] = 0x72e5;
	__map_gbk2utf16[0x2907] = 0x72e6;
	__map_gbk2utf16[0x2908] = 0x72e7;
	__map_gbk2utf16[0x2909] = 0x72ea;
	__map_gbk2utf16[0x290a] = 0x72eb;
	__map_gbk2utf16[0x290b] = 0x72f5;
	__map_gbk2utf16[0x290c] = 0x72f6;
	__map_gbk2utf16[0x290d] = 0x72f9;
	__map_gbk2utf16[0x290e] = 0x72fd;
	__map_gbk2utf16[0x290f] = 0x72fe;
	__map_gbk2utf16[0x2910] = 0x72ff;
	__map_gbk2utf16[0x2911] = 0x7300;
	__map_gbk2utf16[0x2912] = 0x7302;
	__map_gbk2utf16[0x2913] = 0x7304;
	__map_gbk2utf16[0x2914] = 0x7305;
	__map_gbk2utf16[0x2915] = 0x7306;
	__map_gbk2utf16[0x2916] = 0x7307;
	__map_gbk2utf16[0x2917] = 0x7308;
	__map_gbk2utf16[0x2918] = 0x7309;
	__map_gbk2utf16[0x2919] = 0x730b;
	__map_gbk2utf16[0x291a] = 0x730c;
	__map_gbk2utf16[0x291b] = 0x730d;
	__map_gbk2utf16[0x291c] = 0x730f;
	__map_gbk2utf16[0x291d] = 0x7310;
	__map_gbk2utf16[0x291e] = 0x7311;
	__map_gbk2utf16[0x291f] = 0x7312;
	__map_gbk2utf16[0x2920] = 0x7314;
	__map_gbk2utf16[0x2921] = 0x7318;
	__map_gbk2utf16[0x2922] = 0x7319;
	__map_gbk2utf16[0x2923] = 0x731a;
	__map_gbk2utf16[0x2924] = 0x731f;
	__map_gbk2utf16[0x2925] = 0x7320;
	__map_gbk2utf16[0x2926] = 0x7323;
	__map_gbk2utf16[0x2927] = 0x7324;
	__map_gbk2utf16[0x2928] = 0x7326;
	__map_gbk2utf16[0x2929] = 0x7327;
	__map_gbk2utf16[0x292a] = 0x7328;
	__map_gbk2utf16[0x292b] = 0x732d;
	__map_gbk2utf16[0x292c] = 0x732f;
	__map_gbk2utf16[0x292d] = 0x7330;
	__map_gbk2utf16[0x292e] = 0x7332;
	__map_gbk2utf16[0x292f] = 0x7333;
	__map_gbk2utf16[0x2930] = 0x7335;
	__map_gbk2utf16[0x2931] = 0x7336;
	__map_gbk2utf16[0x2932] = 0x733a;
	__map_gbk2utf16[0x2933] = 0x733b;
	__map_gbk2utf16[0x2934] = 0x733c;
	__map_gbk2utf16[0x2935] = 0x733d;
	__map_gbk2utf16[0x2936] = 0x7340;
	__map_gbk2utf16[0x2937] = 0x7341;
	__map_gbk2utf16[0x2938] = 0x7342;
	__map_gbk2utf16[0x2939] = 0x7343;
	__map_gbk2utf16[0x293a] = 0x7344;
	__map_gbk2utf16[0x293b] = 0x7345;
	__map_gbk2utf16[0x293c] = 0x7346;
	__map_gbk2utf16[0x293d] = 0x7347;
	__map_gbk2utf16[0x293e] = 0x7348;
	__map_gbk2utf16[0x2940] = 0x7349;
	__map_gbk2utf16[0x2941] = 0x734a;
	__map_gbk2utf16[0x2942] = 0x734b;
	__map_gbk2utf16[0x2943] = 0x734c;
	__map_gbk2utf16[0x2944] = 0x734e;
	__map_gbk2utf16[0x2945] = 0x734f;
	__map_gbk2utf16[0x2946] = 0x7351;
	__map_gbk2utf16[0x2947] = 0x7353;
	__map_gbk2utf16[0x2948] = 0x7354;
	__map_gbk2utf16[0x2949] = 0x7355;
	__map_gbk2utf16[0x294a] = 0x7356;
	__map_gbk2utf16[0x294b] = 0x7358;
	__map_gbk2utf16[0x294c] = 0x7359;
	__map_gbk2utf16[0x294d] = 0x735a;
	__map_gbk2utf16[0x294e] = 0x735b;
	__map_gbk2utf16[0x294f] = 0x735c;
	__map_gbk2utf16[0x2950] = 0x735d;
	__map_gbk2utf16[0x2951] = 0x735e;
	__map_gbk2utf16[0x2952] = 0x735f;
	__map_gbk2utf16[0x2953] = 0x7361;
	__map_gbk2utf16[0x2954] = 0x7362;
	__map_gbk2utf16[0x2955] = 0x7363;
	__map_gbk2utf16[0x2956] = 0x7364;
	__map_gbk2utf16[0x2957] = 0x7365;
	__map_gbk2utf16[0x2958] = 0x7366;
	__map_gbk2utf16[0x2959] = 0x7367;
	__map_gbk2utf16[0x295a] = 0x7368;
	__map_gbk2utf16[0x295b] = 0x7369;
	__map_gbk2utf16[0x295c] = 0x736a;
	__map_gbk2utf16[0x295d] = 0x736b;
	__map_gbk2utf16[0x295e] = 0x736e;
	__map_gbk2utf16[0x295f] = 0x7370;
	__map_gbk2utf16[0x2960] = 0x7371;
	__map_gbk2utf16[0x2961] = 0xe000;
	__map_gbk2utf16[0x2962] = 0xe001;
	__map_gbk2utf16[0x2963] = 0xe002;
	__map_gbk2utf16[0x2964] = 0xe003;
	__map_gbk2utf16[0x2965] = 0xe004;
	__map_gbk2utf16[0x2966] = 0xe005;
	__map_gbk2utf16[0x2967] = 0xe006;
	__map_gbk2utf16[0x2968] = 0xe007;
	__map_gbk2utf16[0x2969] = 0xe008;
	__map_gbk2utf16[0x296a] = 0xe009;
	__map_gbk2utf16[0x296b] = 0xe00a;
	__map_gbk2utf16[0x296c] = 0xe00b;
	__map_gbk2utf16[0x296d] = 0xe00c;
	__map_gbk2utf16[0x296e] = 0xe00d;
	__map_gbk2utf16[0x296f] = 0xe00e;
	__map_gbk2utf16[0x2970] = 0xe00f;
	__map_gbk2utf16[0x2971] = 0xe010;
	__map_gbk2utf16[0x2972] = 0xe011;
	__map_gbk2utf16[0x2973] = 0xe012;
	__map_gbk2utf16[0x2974] = 0xe013;
	__map_gbk2utf16[0x2975] = 0xe014;
	__map_gbk2utf16[0x2976] = 0xe015;
	__map_gbk2utf16[0x2977] = 0xe016;
	__map_gbk2utf16[0x2978] = 0xe017;
	__map_gbk2utf16[0x2979] = 0xe018;
	__map_gbk2utf16[0x297a] = 0xe019;
	__map_gbk2utf16[0x297b] = 0xe01a;
	__map_gbk2utf16[0x297c] = 0xe01b;
	__map_gbk2utf16[0x297d] = 0xe01c;
	__map_gbk2utf16[0x297e] = 0xe01d;
	__map_gbk2utf16[0x297f] = 0xe01e;
	__map_gbk2utf16[0x2980] = 0xe01f;
	__map_gbk2utf16[0x2981] = 0xe020;
	__map_gbk2utf16[0x2982] = 0xe021;
	__map_gbk2utf16[0x2983] = 0xe022;
	__map_gbk2utf16[0x2984] = 0xe023;
	__map_gbk2utf16[0x2985] = 0xe024;
	__map_gbk2utf16[0x2986] = 0xe025;
	__map_gbk2utf16[0x2987] = 0xe026;
	__map_gbk2utf16[0x2988] = 0xe027;
	__map_gbk2utf16[0x2989] = 0xe028;
	__map_gbk2utf16[0x298a] = 0xe029;
	__map_gbk2utf16[0x298b] = 0xe02a;
	__map_gbk2utf16[0x298c] = 0xe02b;
	__map_gbk2utf16[0x298d] = 0xe02c;
	__map_gbk2utf16[0x298e] = 0xe02d;
	__map_gbk2utf16[0x298f] = 0xe02e;
	__map_gbk2utf16[0x2990] = 0xe02f;
	__map_gbk2utf16[0x2991] = 0xe030;
	__map_gbk2utf16[0x2992] = 0xe031;
	__map_gbk2utf16[0x2993] = 0xe032;
	__map_gbk2utf16[0x2994] = 0xe033;
	__map_gbk2utf16[0x2995] = 0xe034;
	__map_gbk2utf16[0x2996] = 0xe035;
	__map_gbk2utf16[0x2997] = 0xe036;
	__map_gbk2utf16[0x2998] = 0xe037;
	__map_gbk2utf16[0x2999] = 0xe038;
	__map_gbk2utf16[0x299a] = 0xe039;
	__map_gbk2utf16[0x299b] = 0xe03a;
	__map_gbk2utf16[0x299c] = 0xe03b;
	__map_gbk2utf16[0x299d] = 0xe03c;
	__map_gbk2utf16[0x299e] = 0xe03d;
	__map_gbk2utf16[0x299f] = 0xe03e;
	__map_gbk2utf16[0x29a0] = 0xe03f;
	__map_gbk2utf16[0x29a1] = 0xe040;
	__map_gbk2utf16[0x29a2] = 0xe041;
	__map_gbk2utf16[0x29a3] = 0xe042;
	__map_gbk2utf16[0x29a4] = 0xe043;
	__map_gbk2utf16[0x29a5] = 0xe044;
	__map_gbk2utf16[0x29a6] = 0xe045;
	__map_gbk2utf16[0x29a7] = 0xe046;
	__map_gbk2utf16[0x29a8] = 0xe047;
	__map_gbk2utf16[0x29a9] = 0xe048;
	__map_gbk2utf16[0x29aa] = 0xe049;
	__map_gbk2utf16[0x29ab] = 0xe04a;
	__map_gbk2utf16[0x29ac] = 0xe04b;
	__map_gbk2utf16[0x29ad] = 0xe04c;
	__map_gbk2utf16[0x29ae] = 0xe04d;
	__map_gbk2utf16[0x29af] = 0xe04e;
	__map_gbk2utf16[0x29b0] = 0xe04f;
	__map_gbk2utf16[0x29b1] = 0xe050;
	__map_gbk2utf16[0x29b2] = 0xe051;
	__map_gbk2utf16[0x29b3] = 0xe052;
	__map_gbk2utf16[0x29b4] = 0xe053;
	__map_gbk2utf16[0x29b5] = 0xe054;
	__map_gbk2utf16[0x29b6] = 0xe055;
	__map_gbk2utf16[0x29b7] = 0xe056;
	__map_gbk2utf16[0x29b8] = 0xe057;
	__map_gbk2utf16[0x29b9] = 0xe058;
	__map_gbk2utf16[0x29ba] = 0xe059;
	__map_gbk2utf16[0x29bb] = 0xe05a;
	__map_gbk2utf16[0x29bc] = 0xe05b;
	__map_gbk2utf16[0x29bd] = 0xe05c;
	__map_gbk2utf16[0x29be] = 0xe05d;
	__map_gbk2utf16[0x2a00] = 0x7372;
	__map_gbk2utf16[0x2a01] = 0x7373;
	__map_gbk2utf16[0x2a02] = 0x7374;
	__map_gbk2utf16[0x2a03] = 0x7375;
	__map_gbk2utf16[0x2a04] = 0x7376;
	__map_gbk2utf16[0x2a05] = 0x7377;
	__map_gbk2utf16[0x2a06] = 0x7378;
	__map_gbk2utf16[0x2a07] = 0x7379;
	__map_gbk2utf16[0x2a08] = 0x737a;
	__map_gbk2utf16[0x2a09] = 0x737b;
	__map_gbk2utf16[0x2a0a] = 0x737c;
	__map_gbk2utf16[0x2a0b] = 0x737d;
	__map_gbk2utf16[0x2a0c] = 0x737f;
	__map_gbk2utf16[0x2a0d] = 0x7380;
	__map_gbk2utf16[0x2a0e] = 0x7381;
	__map_gbk2utf16[0x2a0f] = 0x7382;
	__map_gbk2utf16[0x2a10] = 0x7383;
	__map_gbk2utf16[0x2a11] = 0x7385;
	__map_gbk2utf16[0x2a12] = 0x7386;
	__map_gbk2utf16[0x2a13] = 0x7388;
	__map_gbk2utf16[0x2a14] = 0x738a;
	__map_gbk2utf16[0x2a15] = 0x738c;
	__map_gbk2utf16[0x2a16] = 0x738d;
	__map_gbk2utf16[0x2a17] = 0x738f;
	__map_gbk2utf16[0x2a18] = 0x7390;
	__map_gbk2utf16[0x2a19] = 0x7392;
	__map_gbk2utf16[0x2a1a] = 0x7393;
	__map_gbk2utf16[0x2a1b] = 0x7394;
	__map_gbk2utf16[0x2a1c] = 0x7395;
	__map_gbk2utf16[0x2a1d] = 0x7397;
	__map_gbk2utf16[0x2a1e] = 0x7398;
	__map_gbk2utf16[0x2a1f] = 0x7399;
	__map_gbk2utf16[0x2a20] = 0x739a;
	__map_gbk2utf16[0x2a21] = 0x739c;
	__map_gbk2utf16[0x2a22] = 0x739d;
	__map_gbk2utf16[0x2a23] = 0x739e;
	__map_gbk2utf16[0x2a24] = 0x73a0;
	__map_gbk2utf16[0x2a25] = 0x73a1;
	__map_gbk2utf16[0x2a26] = 0x73a3;
	__map_gbk2utf16[0x2a27] = 0x73a4;
	__map_gbk2utf16[0x2a28] = 0x73a5;
	__map_gbk2utf16[0x2a29] = 0x73a6;
	__map_gbk2utf16[0x2a2a] = 0x73a7;
	__map_gbk2utf16[0x2a2b] = 0x73a8;
	__map_gbk2utf16[0x2a2c] = 0x73aa;
	__map_gbk2utf16[0x2a2d] = 0x73ac;
	__map_gbk2utf16[0x2a2e] = 0x73ad;
	__map_gbk2utf16[0x2a2f] = 0x73b1;
	__map_gbk2utf16[0x2a30] = 0x73b4;
	__map_gbk2utf16[0x2a31] = 0x73b5;
	__map_gbk2utf16[0x2a32] = 0x73b6;
	__map_gbk2utf16[0x2a33] = 0x73b8;
	__map_gbk2utf16[0x2a34] = 0x73b9;
	__map_gbk2utf16[0x2a35] = 0x73bc;
	__map_gbk2utf16[0x2a36] = 0x73bd;
	__map_gbk2utf16[0x2a37] = 0x73be;
	__map_gbk2utf16[0x2a38] = 0x73bf;
	__map_gbk2utf16[0x2a39] = 0x73c1;
	__map_gbk2utf16[0x2a3a] = 0x73c3;
	__map_gbk2utf16[0x2a3b] = 0x73c4;
	__map_gbk2utf16[0x2a3c] = 0x73c5;
	__map_gbk2utf16[0x2a3d] = 0x73c6;
	__map_gbk2utf16[0x2a3e] = 0x73c7;
	__map_gbk2utf16[0x2a40] = 0x73cb;
	__map_gbk2utf16[0x2a41] = 0x73cc;
	__map_gbk2utf16[0x2a42] = 0x73ce;
	__map_gbk2utf16[0x2a43] = 0x73d2;
	__map_gbk2utf16[0x2a44] = 0x73d3;
	__map_gbk2utf16[0x2a45] = 0x73d4;
	__map_gbk2utf16[0x2a46] = 0x73d5;
	__map_gbk2utf16[0x2a47] = 0x73d6;
	__map_gbk2utf16[0x2a48] = 0x73d7;
	__map_gbk2utf16[0x2a49] = 0x73d8;
	__map_gbk2utf16[0x2a4a] = 0x73da;
	__map_gbk2utf16[0x2a4b] = 0x73db;
	__map_gbk2utf16[0x2a4c] = 0x73dc;
	__map_gbk2utf16[0x2a4d] = 0x73dd;
	__map_gbk2utf16[0x2a4e] = 0x73df;
	__map_gbk2utf16[0x2a4f] = 0x73e1;
	__map_gbk2utf16[0x2a50] = 0x73e2;
	__map_gbk2utf16[0x2a51] = 0x73e3;
	__map_gbk2utf16[0x2a52] = 0x73e4;
	__map_gbk2utf16[0x2a53] = 0x73e6;
	__map_gbk2utf16[0x2a54] = 0x73e8;
	__map_gbk2utf16[0x2a55] = 0x73ea;
	__map_gbk2utf16[0x2a56] = 0x73eb;
	__map_gbk2utf16[0x2a57] = 0x73ec;
	__map_gbk2utf16[0x2a58] = 0x73ee;
	__map_gbk2utf16[0x2a59] = 0x73ef;
	__map_gbk2utf16[0x2a5a] = 0x73f0;
	__map_gbk2utf16[0x2a5b] = 0x73f1;
	__map_gbk2utf16[0x2a5c] = 0x73f3;
	__map_gbk2utf16[0x2a5d] = 0x73f4;
	__map_gbk2utf16[0x2a5e] = 0x73f5;
	__map_gbk2utf16[0x2a5f] = 0x73f6;
	__map_gbk2utf16[0x2a60] = 0x73f7;
	__map_gbk2utf16[0x2a61] = 0xe05e;
	__map_gbk2utf16[0x2a62] = 0xe05f;
	__map_gbk2utf16[0x2a63] = 0xe060;
	__map_gbk2utf16[0x2a64] = 0xe061;
	__map_gbk2utf16[0x2a65] = 0xe062;
	__map_gbk2utf16[0x2a66] = 0xe063;
	__map_gbk2utf16[0x2a67] = 0xe064;
	__map_gbk2utf16[0x2a68] = 0xe065;
	__map_gbk2utf16[0x2a69] = 0xe066;
	__map_gbk2utf16[0x2a6a] = 0xe067;
	__map_gbk2utf16[0x2a6b] = 0xe068;
	__map_gbk2utf16[0x2a6c] = 0xe069;
	__map_gbk2utf16[0x2a6d] = 0xe06a;
	__map_gbk2utf16[0x2a6e] = 0xe06b;
	__map_gbk2utf16[0x2a6f] = 0xe06c;
	__map_gbk2utf16[0x2a70] = 0xe06d;
	__map_gbk2utf16[0x2a71] = 0xe06e;
	__map_gbk2utf16[0x2a72] = 0xe06f;
	__map_gbk2utf16[0x2a73] = 0xe070;
	__map_gbk2utf16[0x2a74] = 0xe071;
	__map_gbk2utf16[0x2a75] = 0xe072;
	__map_gbk2utf16[0x2a76] = 0xe073;
	__map_gbk2utf16[0x2a77] = 0xe074;
	__map_gbk2utf16[0x2a78] = 0xe075;
	__map_gbk2utf16[0x2a79] = 0xe076;
	__map_gbk2utf16[0x2a7a] = 0xe077;
	__map_gbk2utf16[0x2a7b] = 0xe078;
	__map_gbk2utf16[0x2a7c] = 0xe079;
	__map_gbk2utf16[0x2a7d] = 0xe07a;
	__map_gbk2utf16[0x2a7e] = 0xe07b;
	__map_gbk2utf16[0x2a7f] = 0xe07c;
	__map_gbk2utf16[0x2a80] = 0xe07d;
	__map_gbk2utf16[0x2a81] = 0xe07e;
	__map_gbk2utf16[0x2a82] = 0xe07f;
	__map_gbk2utf16[0x2a83] = 0xe080;
	__map_gbk2utf16[0x2a84] = 0xe081;
	__map_gbk2utf16[0x2a85] = 0xe082;
	__map_gbk2utf16[0x2a86] = 0xe083;
	__map_gbk2utf16[0x2a87] = 0xe084;
	__map_gbk2utf16[0x2a88] = 0xe085;
	__map_gbk2utf16[0x2a89] = 0xe086;
	__map_gbk2utf16[0x2a8a] = 0xe087;
	__map_gbk2utf16[0x2a8b] = 0xe088;
	__map_gbk2utf16[0x2a8c] = 0xe089;
	__map_gbk2utf16[0x2a8d] = 0xe08a;
	__map_gbk2utf16[0x2a8e] = 0xe08b;
	__map_gbk2utf16[0x2a8f] = 0xe08c;
	__map_gbk2utf16[0x2a90] = 0xe08d;
	__map_gbk2utf16[0x2a91] = 0xe08e;
	__map_gbk2utf16[0x2a92] = 0xe08f;
	__map_gbk2utf16[0x2a93] = 0xe090;
	__map_gbk2utf16[0x2a94] = 0xe091;
	__map_gbk2utf16[0x2a95] = 0xe092;
	__map_gbk2utf16[0x2a96] = 0xe093;
	__map_gbk2utf16[0x2a97] = 0xe094;
	__map_gbk2utf16[0x2a98] = 0xe095;
	__map_gbk2utf16[0x2a99] = 0xe096;
	__map_gbk2utf16[0x2a9a] = 0xe097;
	__map_gbk2utf16[0x2a9b] = 0xe098;
	__map_gbk2utf16[0x2a9c] = 0xe099;
	__map_gbk2utf16[0x2a9d] = 0xe09a;
	__map_gbk2utf16[0x2a9e] = 0xe09b;
	__map_gbk2utf16[0x2a9f] = 0xe09c;
	__map_gbk2utf16[0x2aa0] = 0xe09d;
	__map_gbk2utf16[0x2aa1] = 0xe09e;
	__map_gbk2utf16[0x2aa2] = 0xe09f;
	__map_gbk2utf16[0x2aa3] = 0xe0a0;
	__map_gbk2utf16[0x2aa4] = 0xe0a1;
	__map_gbk2utf16[0x2aa5] = 0xe0a2;
	__map_gbk2utf16[0x2aa6] = 0xe0a3;
	__map_gbk2utf16[0x2aa7] = 0xe0a4;
	__map_gbk2utf16[0x2aa8] = 0xe0a5;
	__map_gbk2utf16[0x2aa9] = 0xe0a6;
	__map_gbk2utf16[0x2aaa] = 0xe0a7;
	__map_gbk2utf16[0x2aab] = 0xe0a8;
	__map_gbk2utf16[0x2aac] = 0xe0a9;
	__map_gbk2utf16[0x2aad] = 0xe0aa;
	__map_gbk2utf16[0x2aae] = 0xe0ab;
	__map_gbk2utf16[0x2aaf] = 0xe0ac;
	__map_gbk2utf16[0x2ab0] = 0xe0ad;
	__map_gbk2utf16[0x2ab1] = 0xe0ae;
	__map_gbk2utf16[0x2ab2] = 0xe0af;
	__map_gbk2utf16[0x2ab3] = 0xe0b0;
	__map_gbk2utf16[0x2ab4] = 0xe0b1;
	__map_gbk2utf16[0x2ab5] = 0xe0b2;
	__map_gbk2utf16[0x2ab6] = 0xe0b3;
	__map_gbk2utf16[0x2ab7] = 0xe0b4;
	__map_gbk2utf16[0x2ab8] = 0xe0b5;
	__map_gbk2utf16[0x2ab9] = 0xe0b6;
	__map_gbk2utf16[0x2aba] = 0xe0b7;
	__map_gbk2utf16[0x2abb] = 0xe0b8;
	__map_gbk2utf16[0x2abc] = 0xe0b9;
	__map_gbk2utf16[0x2abd] = 0xe0ba;
	__map_gbk2utf16[0x2abe] = 0xe0bb;
	__map_gbk2utf16[0x2b00] = 0x73f8;
	__map_gbk2utf16[0x2b01] = 0x73f9;
	__map_gbk2utf16[0x2b02] = 0x73fa;
	__map_gbk2utf16[0x2b03] = 0x73fb;
	__map_gbk2utf16[0x2b04] = 0x73fc;
	__map_gbk2utf16[0x2b05] = 0x73fd;
	__map_gbk2utf16[0x2b06] = 0x73fe;
	__map_gbk2utf16[0x2b07] = 0x73ff;
	__map_gbk2utf16[0x2b08] = 0x7400;
	__map_gbk2utf16[0x2b09] = 0x7401;
	__map_gbk2utf16[0x2b0a] = 0x7402;
	__map_gbk2utf16[0x2b0b] = 0x7404;
	__map_gbk2utf16[0x2b0c] = 0x7407;
	__map_gbk2utf16[0x2b0d] = 0x7408;
	__map_gbk2utf16[0x2b0e] = 0x740b;
	__map_gbk2utf16[0x2b0f] = 0x740c;
	__map_gbk2utf16[0x2b10] = 0x740d;
	__map_gbk2utf16[0x2b11] = 0x740e;
	__map_gbk2utf16[0x2b12] = 0x7411;
	__map_gbk2utf16[0x2b13] = 0x7412;
	__map_gbk2utf16[0x2b14] = 0x7413;
	__map_gbk2utf16[0x2b15] = 0x7414;
	__map_gbk2utf16[0x2b16] = 0x7415;
	__map_gbk2utf16[0x2b17] = 0x7416;
	__map_gbk2utf16[0x2b18] = 0x7417;
	__map_gbk2utf16[0x2b19] = 0x7418;
	__map_gbk2utf16[0x2b1a] = 0x7419;
	__map_gbk2utf16[0x2b1b] = 0x741c;
	__map_gbk2utf16[0x2b1c] = 0x741d;
	__map_gbk2utf16[0x2b1d] = 0x741e;
	__map_gbk2utf16[0x2b1e] = 0x741f;
	__map_gbk2utf16[0x2b1f] = 0x7420;
	__map_gbk2utf16[0x2b20] = 0x7421;
	__map_gbk2utf16[0x2b21] = 0x7423;
	__map_gbk2utf16[0x2b22] = 0x7424;
	__map_gbk2utf16[0x2b23] = 0x7427;
	__map_gbk2utf16[0x2b24] = 0x7429;
	__map_gbk2utf16[0x2b25] = 0x742b;
	__map_gbk2utf16[0x2b26] = 0x742d;
	__map_gbk2utf16[0x2b27] = 0x742f;
	__map_gbk2utf16[0x2b28] = 0x7431;
	__map_gbk2utf16[0x2b29] = 0x7432;
	__map_gbk2utf16[0x2b2a] = 0x7437;
	__map_gbk2utf16[0x2b2b] = 0x7438;
	__map_gbk2utf16[0x2b2c] = 0x7439;
	__map_gbk2utf16[0x2b2d] = 0x743a;
	__map_gbk2utf16[0x2b2e] = 0x743b;
	__map_gbk2utf16[0x2b2f] = 0x743d;
	__map_gbk2utf16[0x2b30] = 0x743e;
	__map_gbk2utf16[0x2b31] = 0x743f;
	__map_gbk2utf16[0x2b32] = 0x7440;
	__map_gbk2utf16[0x2b33] = 0x7442;
	__map_gbk2utf16[0x2b34] = 0x7443;
	__map_gbk2utf16[0x2b35] = 0x7444;
	__map_gbk2utf16[0x2b36] = 0x7445;
	__map_gbk2utf16[0x2b37] = 0x7446;
	__map_gbk2utf16[0x2b38] = 0x7447;
	__map_gbk2utf16[0x2b39] = 0x7448;
	__map_gbk2utf16[0x2b3a] = 0x7449;
	__map_gbk2utf16[0x2b3b] = 0x744a;
	__map_gbk2utf16[0x2b3c] = 0x744b;
	__map_gbk2utf16[0x2b3d] = 0x744c;
	__map_gbk2utf16[0x2b3e] = 0x744d;
	__map_gbk2utf16[0x2b40] = 0x744e;
	__map_gbk2utf16[0x2b41] = 0x744f;
	__map_gbk2utf16[0x2b42] = 0x7450;
	__map_gbk2utf16[0x2b43] = 0x7451;
	__map_gbk2utf16[0x2b44] = 0x7452;
	__map_gbk2utf16[0x2b45] = 0x7453;
	__map_gbk2utf16[0x2b46] = 0x7454;
	__map_gbk2utf16[0x2b47] = 0x7456;
	__map_gbk2utf16[0x2b48] = 0x7458;
	__map_gbk2utf16[0x2b49] = 0x745d;
	__map_gbk2utf16[0x2b4a] = 0x7460;
	__map_gbk2utf16[0x2b4b] = 0x7461;
	__map_gbk2utf16[0x2b4c] = 0x7462;
	__map_gbk2utf16[0x2b4d] = 0x7463;
	__map_gbk2utf16[0x2b4e] = 0x7464;
	__map_gbk2utf16[0x2b4f] = 0x7465;
	__map_gbk2utf16[0x2b50] = 0x7466;
	__map_gbk2utf16[0x2b51] = 0x7467;
	__map_gbk2utf16[0x2b52] = 0x7468;
	__map_gbk2utf16[0x2b53] = 0x7469;
	__map_gbk2utf16[0x2b54] = 0x746a;
	__map_gbk2utf16[0x2b55] = 0x746b;
	__map_gbk2utf16[0x2b56] = 0x746c;
	__map_gbk2utf16[0x2b57] = 0x746e;
	__map_gbk2utf16[0x2b58] = 0x746f;
	__map_gbk2utf16[0x2b59] = 0x7471;
	__map_gbk2utf16[0x2b5a] = 0x7472;
	__map_gbk2utf16[0x2b5b] = 0x7473;
	__map_gbk2utf16[0x2b5c] = 0x7474;
	__map_gbk2utf16[0x2b5d] = 0x7475;
	__map_gbk2utf16[0x2b5e] = 0x7478;
	__map_gbk2utf16[0x2b5f] = 0x7479;
	__map_gbk2utf16[0x2b60] = 0x747a;
	__map_gbk2utf16[0x2b61] = 0xe0bc;
	__map_gbk2utf16[0x2b62] = 0xe0bd;
	__map_gbk2utf16[0x2b63] = 0xe0be;
	__map_gbk2utf16[0x2b64] = 0xe0bf;
	__map_gbk2utf16[0x2b65] = 0xe0c0;
	__map_gbk2utf16[0x2b66] = 0xe0c1;
	__map_gbk2utf16[0x2b67] = 0xe0c2;
	__map_gbk2utf16[0x2b68] = 0xe0c3;
	__map_gbk2utf16[0x2b69] = 0xe0c4;
	__map_gbk2utf16[0x2b6a] = 0xe0c5;
	__map_gbk2utf16[0x2b6b] = 0xe0c6;
	__map_gbk2utf16[0x2b6c] = 0xe0c7;
	__map_gbk2utf16[0x2b6d] = 0xe0c8;
	__map_gbk2utf16[0x2b6e] = 0xe0c9;
	__map_gbk2utf16[0x2b6f] = 0xe0ca;
	__map_gbk2utf16[0x2b70] = 0xe0cb;
	__map_gbk2utf16[0x2b71] = 0xe0cc;
	__map_gbk2utf16[0x2b72] = 0xe0cd;
	__map_gbk2utf16[0x2b73] = 0xe0ce;
	__map_gbk2utf16[0x2b74] = 0xe0cf;
	__map_gbk2utf16[0x2b75] = 0xe0d0;
	__map_gbk2utf16[0x2b76] = 0xe0d1;
	__map_gbk2utf16[0x2b77] = 0xe0d2;
	__map_gbk2utf16[0x2b78] = 0xe0d3;
	__map_gbk2utf16[0x2b79] = 0xe0d4;
	__map_gbk2utf16[0x2b7a] = 0xe0d5;
	__map_gbk2utf16[0x2b7b] = 0xe0d6;
	__map_gbk2utf16[0x2b7c] = 0xe0d7;
	__map_gbk2utf16[0x2b7d] = 0xe0d8;
	__map_gbk2utf16[0x2b7e] = 0xe0d9;
	__map_gbk2utf16[0x2b7f] = 0xe0da;
	__map_gbk2utf16[0x2b80] = 0xe0db;
	__map_gbk2utf16[0x2b81] = 0xe0dc;
	__map_gbk2utf16[0x2b82] = 0xe0dd;
	__map_gbk2utf16[0x2b83] = 0xe0de;
	__map_gbk2utf16[0x2b84] = 0xe0df;
	__map_gbk2utf16[0x2b85] = 0xe0e0;
	__map_gbk2utf16[0x2b86] = 0xe0e1;
	__map_gbk2utf16[0x2b87] = 0xe0e2;
	__map_gbk2utf16[0x2b88] = 0xe0e3;
	__map_gbk2utf16[0x2b89] = 0xe0e4;
	__map_gbk2utf16[0x2b8a] = 0xe0e5;
	__map_gbk2utf16[0x2b8b] = 0xe0e6;
	__map_gbk2utf16[0x2b8c] = 0xe0e7;
	__map_gbk2utf16[0x2b8d] = 0xe0e8;
	__map_gbk2utf16[0x2b8e] = 0xe0e9;
	__map_gbk2utf16[0x2b8f] = 0xe0ea;
	__map_gbk2utf16[0x2b90] = 0xe0eb;
	__map_gbk2utf16[0x2b91] = 0xe0ec;
	__map_gbk2utf16[0x2b92] = 0xe0ed;
	__map_gbk2utf16[0x2b93] = 0xe0ee;
	__map_gbk2utf16[0x2b94] = 0xe0ef;
	__map_gbk2utf16[0x2b95] = 0xe0f0;
	__map_gbk2utf16[0x2b96] = 0xe0f1;
	__map_gbk2utf16[0x2b97] = 0xe0f2;
	__map_gbk2utf16[0x2b98] = 0xe0f3;
	__map_gbk2utf16[0x2b99] = 0xe0f4;
	__map_gbk2utf16[0x2b9a] = 0xe0f5;
	__map_gbk2utf16[0x2b9b] = 0xe0f6;
	__map_gbk2utf16[0x2b9c] = 0xe0f7;
	__map_gbk2utf16[0x2b9d] = 0xe0f8;
	__map_gbk2utf16[0x2b9e] = 0xe0f9;
	__map_gbk2utf16[0x2b9f] = 0xe0fa;
	__map_gbk2utf16[0x2ba0] = 0xe0fb;
	__map_gbk2utf16[0x2ba1] = 0xe0fc;
	__map_gbk2utf16[0x2ba2] = 0xe0fd;
	__map_gbk2utf16[0x2ba3] = 0xe0fe;
	__map_gbk2utf16[0x2ba4] = 0xe0ff;
	__map_gbk2utf16[0x2ba5] = 0xe100;
	__map_gbk2utf16[0x2ba6] = 0xe101;
	__map_gbk2utf16[0x2ba7] = 0xe102;
	__map_gbk2utf16[0x2ba8] = 0xe103;
	__map_gbk2utf16[0x2ba9] = 0xe104;
	__map_gbk2utf16[0x2baa] = 0xe105;
	__map_gbk2utf16[0x2bab] = 0xe106;
	__map_gbk2utf16[0x2bac] = 0xe107;
	__map_gbk2utf16[0x2bad] = 0xe108;
	__map_gbk2utf16[0x2bae] = 0xe109;
	__map_gbk2utf16[0x2baf] = 0xe10a;
	__map_gbk2utf16[0x2bb0] = 0xe10b;
	__map_gbk2utf16[0x2bb1] = 0xe10c;
	__map_gbk2utf16[0x2bb2] = 0xe10d;
	__map_gbk2utf16[0x2bb3] = 0xe10e;
	__map_gbk2utf16[0x2bb4] = 0xe10f;
	__map_gbk2utf16[0x2bb5] = 0xe110;
	__map_gbk2utf16[0x2bb6] = 0xe111;
	__map_gbk2utf16[0x2bb7] = 0xe112;
	__map_gbk2utf16[0x2bb8] = 0xe113;
	__map_gbk2utf16[0x2bb9] = 0xe114;
	__map_gbk2utf16[0x2bba] = 0xe115;
	__map_gbk2utf16[0x2bbb] = 0xe116;
	__map_gbk2utf16[0x2bbc] = 0xe117;
	__map_gbk2utf16[0x2bbd] = 0xe118;
	__map_gbk2utf16[0x2bbe] = 0xe119;
	__map_gbk2utf16[0x2c00] = 0x747b;
	__map_gbk2utf16[0x2c01] = 0x747c;
	__map_gbk2utf16[0x2c02] = 0x747d;
	__map_gbk2utf16[0x2c03] = 0x747f;
	__map_gbk2utf16[0x2c04] = 0x7482;
	__map_gbk2utf16[0x2c05] = 0x7484;
	__map_gbk2utf16[0x2c06] = 0x7485;
	__map_gbk2utf16[0x2c07] = 0x7486;
	__map_gbk2utf16[0x2c08] = 0x7488;
	__map_gbk2utf16[0x2c09] = 0x7489;
	__map_gbk2utf16[0x2c0a] = 0x748a;
	__map_gbk2utf16[0x2c0b] = 0x748c;
	__map_gbk2utf16[0x2c0c] = 0x748d;
	__map_gbk2utf16[0x2c0d] = 0x748f;
	__map_gbk2utf16[0x2c0e] = 0x7491;
	__map_gbk2utf16[0x2c0f] = 0x7492;
	__map_gbk2utf16[0x2c10] = 0x7493;
	__map_gbk2utf16[0x2c11] = 0x7494;
	__map_gbk2utf16[0x2c12] = 0x7495;
	__map_gbk2utf16[0x2c13] = 0x7496;
	__map_gbk2utf16[0x2c14] = 0x7497;
	__map_gbk2utf16[0x2c15] = 0x7498;
	__map_gbk2utf16[0x2c16] = 0x7499;
	__map_gbk2utf16[0x2c17] = 0x749a;
	__map_gbk2utf16[0x2c18] = 0x749b;
	__map_gbk2utf16[0x2c19] = 0x749d;
	__map_gbk2utf16[0x2c1a] = 0x749f;
	__map_gbk2utf16[0x2c1b] = 0x74a0;
	__map_gbk2utf16[0x2c1c] = 0x74a1;
	__map_gbk2utf16[0x2c1d] = 0x74a2;
	__map_gbk2utf16[0x2c1e] = 0x74a3;
	__map_gbk2utf16[0x2c1f] = 0x74a4;
	__map_gbk2utf16[0x2c20] = 0x74a5;
	__map_gbk2utf16[0x2c21] = 0x74a6;
	__map_gbk2utf16[0x2c22] = 0x74aa;
	__map_gbk2utf16[0x2c23] = 0x74ab;
	__map_gbk2utf16[0x2c24] = 0x74ac;
	__map_gbk2utf16[0x2c25] = 0x74ad;
	__map_gbk2utf16[0x2c26] = 0x74ae;
	__map_gbk2utf16[0x2c27] = 0x74af;
	__map_gbk2utf16[0x2c28] = 0x74b0;
	__map_gbk2utf16[0x2c29] = 0x74b1;
	__map_gbk2utf16[0x2c2a] = 0x74b2;
	__map_gbk2utf16[0x2c2b] = 0x74b3;
	__map_gbk2utf16[0x2c2c] = 0x74b4;
	__map_gbk2utf16[0x2c2d] = 0x74b5;
	__map_gbk2utf16[0x2c2e] = 0x74b6;
	__map_gbk2utf16[0x2c2f] = 0x74b7;
	__map_gbk2utf16[0x2c30] = 0x74b8;
	__map_gbk2utf16[0x2c31] = 0x74b9;
	__map_gbk2utf16[0x2c32] = 0x74bb;
	__map_gbk2utf16[0x2c33] = 0x74bc;
	__map_gbk2utf16[0x2c34] = 0x74bd;
	__map_gbk2utf16[0x2c35] = 0x74be;
	__map_gbk2utf16[0x2c36] = 0x74bf;
	__map_gbk2utf16[0x2c37] = 0x74c0;
	__map_gbk2utf16[0x2c38] = 0x74c1;
	__map_gbk2utf16[0x2c39] = 0x74c2;
	__map_gbk2utf16[0x2c3a] = 0x74c3;
	__map_gbk2utf16[0x2c3b] = 0x74c4;
	__map_gbk2utf16[0x2c3c] = 0x74c5;
	__map_gbk2utf16[0x2c3d] = 0x74c6;
	__map_gbk2utf16[0x2c3e] = 0x74c7;
	__map_gbk2utf16[0x2c40] = 0x74c8;
	__map_gbk2utf16[0x2c41] = 0x74c9;
	__map_gbk2utf16[0x2c42] = 0x74ca;
	__map_gbk2utf16[0x2c43] = 0x74cb;
	__map_gbk2utf16[0x2c44] = 0x74cc;
	__map_gbk2utf16[0x2c45] = 0x74cd;
	__map_gbk2utf16[0x2c46] = 0x74ce;
	__map_gbk2utf16[0x2c47] = 0x74cf;
	__map_gbk2utf16[0x2c48] = 0x74d0;
	__map_gbk2utf16[0x2c49] = 0x74d1;
	__map_gbk2utf16[0x2c4a] = 0x74d3;
	__map_gbk2utf16[0x2c4b] = 0x74d4;
	__map_gbk2utf16[0x2c4c] = 0x74d5;
	__map_gbk2utf16[0x2c4d] = 0x74d6;
	__map_gbk2utf16[0x2c4e] = 0x74d7;
	__map_gbk2utf16[0x2c4f] = 0x74d8;
	__map_gbk2utf16[0x2c50] = 0x74d9;
	__map_gbk2utf16[0x2c51] = 0x74da;
	__map_gbk2utf16[0x2c52] = 0x74db;
	__map_gbk2utf16[0x2c53] = 0x74dd;
	__map_gbk2utf16[0x2c54] = 0x74df;
	__map_gbk2utf16[0x2c55] = 0x74e1;
	__map_gbk2utf16[0x2c56] = 0x74e5;
	__map_gbk2utf16[0x2c57] = 0x74e7;
	__map_gbk2utf16[0x2c58] = 0x74e8;
	__map_gbk2utf16[0x2c59] = 0x74e9;
	__map_gbk2utf16[0x2c5a] = 0x74ea;
	__map_gbk2utf16[0x2c5b] = 0x74eb;
	__map_gbk2utf16[0x2c5c] = 0x74ec;
	__map_gbk2utf16[0x2c5d] = 0x74ed;
	__map_gbk2utf16[0x2c5e] = 0x74f0;
	__map_gbk2utf16[0x2c5f] = 0x74f1;
	__map_gbk2utf16[0x2c60] = 0x74f2;
	__map_gbk2utf16[0x2c61] = 0xe11a;
	__map_gbk2utf16[0x2c62] = 0xe11b;
	__map_gbk2utf16[0x2c63] = 0xe11c;
	__map_gbk2utf16[0x2c64] = 0xe11d;
	__map_gbk2utf16[0x2c65] = 0xe11e;
	__map_gbk2utf16[0x2c66] = 0xe11f;
	__map_gbk2utf16[0x2c67] = 0xe120;
	__map_gbk2utf16[0x2c68] = 0xe121;
	__map_gbk2utf16[0x2c69] = 0xe122;
	__map_gbk2utf16[0x2c6a] = 0xe123;
	__map_gbk2utf16[0x2c6b] = 0xe124;
	__map_gbk2utf16[0x2c6c] = 0xe125;
	__map_gbk2utf16[0x2c6d] = 0xe126;
	__map_gbk2utf16[0x2c6e] = 0xe127;
	__map_gbk2utf16[0x2c6f] = 0xe128;
	__map_gbk2utf16[0x2c70] = 0xe129;
	__map_gbk2utf16[0x2c71] = 0xe12a;
	__map_gbk2utf16[0x2c72] = 0xe12b;
	__map_gbk2utf16[0x2c73] = 0xe12c;
	__map_gbk2utf16[0x2c74] = 0xe12d;
	__map_gbk2utf16[0x2c75] = 0xe12e;
	__map_gbk2utf16[0x2c76] = 0xe12f;
	__map_gbk2utf16[0x2c77] = 0xe130;
	__map_gbk2utf16[0x2c78] = 0xe131;
	__map_gbk2utf16[0x2c79] = 0xe132;
	__map_gbk2utf16[0x2c7a] = 0xe133;
	__map_gbk2utf16[0x2c7b] = 0xe134;
	__map_gbk2utf16[0x2c7c] = 0xe135;
	__map_gbk2utf16[0x2c7d] = 0xe136;
	__map_gbk2utf16[0x2c7e] = 0xe137;
	__map_gbk2utf16[0x2c7f] = 0xe138;
	__map_gbk2utf16[0x2c80] = 0xe139;
	__map_gbk2utf16[0x2c81] = 0xe13a;
	__map_gbk2utf16[0x2c82] = 0xe13b;
	__map_gbk2utf16[0x2c83] = 0xe13c;
	__map_gbk2utf16[0x2c84] = 0xe13d;
	__map_gbk2utf16[0x2c85] = 0xe13e;
	__map_gbk2utf16[0x2c86] = 0xe13f;
	__map_gbk2utf16[0x2c87] = 0xe140;
	__map_gbk2utf16[0x2c88] = 0xe141;
	__map_gbk2utf16[0x2c89] = 0xe142;
	__map_gbk2utf16[0x2c8a] = 0xe143;
	__map_gbk2utf16[0x2c8b] = 0xe144;
	__map_gbk2utf16[0x2c8c] = 0xe145;
	__map_gbk2utf16[0x2c8d] = 0xe146;
	__map_gbk2utf16[0x2c8e] = 0xe147;
	__map_gbk2utf16[0x2c8f] = 0xe148;
	__map_gbk2utf16[0x2c90] = 0xe149;
	__map_gbk2utf16[0x2c91] = 0xe14a;
	__map_gbk2utf16[0x2c92] = 0xe14b;
	__map_gbk2utf16[0x2c93] = 0xe14c;
	__map_gbk2utf16[0x2c94] = 0xe14d;
	__map_gbk2utf16[0x2c95] = 0xe14e;
	__map_gbk2utf16[0x2c96] = 0xe14f;
	__map_gbk2utf16[0x2c97] = 0xe150;
	__map_gbk2utf16[0x2c98] = 0xe151;
	__map_gbk2utf16[0x2c99] = 0xe152;
	__map_gbk2utf16[0x2c9a] = 0xe153;
	__map_gbk2utf16[0x2c9b] = 0xe154;
	__map_gbk2utf16[0x2c9c] = 0xe155;
	__map_gbk2utf16[0x2c9d] = 0xe156;
	__map_gbk2utf16[0x2c9e] = 0xe157;
	__map_gbk2utf16[0x2c9f] = 0xe158;
	__map_gbk2utf16[0x2ca0] = 0xe159;
	__map_gbk2utf16[0x2ca1] = 0xe15a;
	__map_gbk2utf16[0x2ca2] = 0xe15b;
	__map_gbk2utf16[0x2ca3] = 0xe15c;
	__map_gbk2utf16[0x2ca4] = 0xe15d;
	__map_gbk2utf16[0x2ca5] = 0xe15e;
	__map_gbk2utf16[0x2ca6] = 0xe15f;
	__map_gbk2utf16[0x2ca7] = 0xe160;
	__map_gbk2utf16[0x2ca8] = 0xe161;
	__map_gbk2utf16[0x2ca9] = 0xe162;
	__map_gbk2utf16[0x2caa] = 0xe163;
	__map_gbk2utf16[0x2cab] = 0xe164;
	__map_gbk2utf16[0x2cac] = 0xe165;
	__map_gbk2utf16[0x2cad] = 0xe166;
	__map_gbk2utf16[0x2cae] = 0xe167;
	__map_gbk2utf16[0x2caf] = 0xe168;
	__map_gbk2utf16[0x2cb0] = 0xe169;
	__map_gbk2utf16[0x2cb1] = 0xe16a;
	__map_gbk2utf16[0x2cb2] = 0xe16b;
	__map_gbk2utf16[0x2cb3] = 0xe16c;
	__map_gbk2utf16[0x2cb4] = 0xe16d;
	__map_gbk2utf16[0x2cb5] = 0xe16e;
	__map_gbk2utf16[0x2cb6] = 0xe16f;
	__map_gbk2utf16[0x2cb7] = 0xe170;
	__map_gbk2utf16[0x2cb8] = 0xe171;
	__map_gbk2utf16[0x2cb9] = 0xe172;
	__map_gbk2utf16[0x2cba] = 0xe173;
	__map_gbk2utf16[0x2cbb] = 0xe174;
	__map_gbk2utf16[0x2cbc] = 0xe175;
	__map_gbk2utf16[0x2cbd] = 0xe176;
	__map_gbk2utf16[0x2cbe] = 0xe177;
	__map_gbk2utf16[0x2d00] = 0x74f3;
	__map_gbk2utf16[0x2d01] = 0x74f5;
	__map_gbk2utf16[0x2d02] = 0x74f8;
	__map_gbk2utf16[0x2d03] = 0x74f9;
	__map_gbk2utf16[0x2d04] = 0x74fa;
	__map_gbk2utf16[0x2d05] = 0x74fb;
	__map_gbk2utf16[0x2d06] = 0x74fc;
	__map_gbk2utf16[0x2d07] = 0x74fd;
	__map_gbk2utf16[0x2d08] = 0x74fe;
	__map_gbk2utf16[0x2d09] = 0x7500;
	__map_gbk2utf16[0x2d0a] = 0x7501;
	__map_gbk2utf16[0x2d0b] = 0x7502;
	__map_gbk2utf16[0x2d0c] = 0x7503;
	__map_gbk2utf16[0x2d0d] = 0x7505;
	__map_gbk2utf16[0x2d0e] = 0x7506;
	__map_gbk2utf16[0x2d0f] = 0x7507;
	__map_gbk2utf16[0x2d10] = 0x7508;
	__map_gbk2utf16[0x2d11] = 0x7509;
	__map_gbk2utf16[0x2d12] = 0x750a;
	__map_gbk2utf16[0x2d13] = 0x750b;
	__map_gbk2utf16[0x2d14] = 0x750c;
	__map_gbk2utf16[0x2d15] = 0x750e;
	__map_gbk2utf16[0x2d16] = 0x7510;
	__map_gbk2utf16[0x2d17] = 0x7512;
	__map_gbk2utf16[0x2d18] = 0x7514;
	__map_gbk2utf16[0x2d19] = 0x7515;
	__map_gbk2utf16[0x2d1a] = 0x7516;
	__map_gbk2utf16[0x2d1b] = 0x7517;
	__map_gbk2utf16[0x2d1c] = 0x751b;
	__map_gbk2utf16[0x2d1d] = 0x751d;
	__map_gbk2utf16[0x2d1e] = 0x751e;
	__map_gbk2utf16[0x2d1f] = 0x7520;
	__map_gbk2utf16[0x2d20] = 0x7521;
	__map_gbk2utf16[0x2d21] = 0x7522;
	__map_gbk2utf16[0x2d22] = 0x7523;
	__map_gbk2utf16[0x2d23] = 0x7524;
	__map_gbk2utf16[0x2d24] = 0x7526;
	__map_gbk2utf16[0x2d25] = 0x7527;
	__map_gbk2utf16[0x2d26] = 0x752a;
	__map_gbk2utf16[0x2d27] = 0x752e;
	__map_gbk2utf16[0x2d28] = 0x7534;
	__map_gbk2utf16[0x2d29] = 0x7536;
	__map_gbk2utf16[0x2d2a] = 0x7539;
	__map_gbk2utf16[0x2d2b] = 0x753c;
	__map_gbk2utf16[0x2d2c] = 0x753d;
	__map_gbk2utf16[0x2d2d] = 0x753f;
	__map_gbk2utf16[0x2d2e] = 0x7541;
	__map_gbk2utf16[0x2d2f] = 0x7542;
	__map_gbk2utf16[0x2d30] = 0x7543;
	__map_gbk2utf16[0x2d31] = 0x7544;
	__map_gbk2utf16[0x2d32] = 0x7546;
	__map_gbk2utf16[0x2d33] = 0x7547;
	__map_gbk2utf16[0x2d34] = 0x7549;
	__map_gbk2utf16[0x2d35] = 0x754a;
	__map_gbk2utf16[0x2d36] = 0x754d;
	__map_gbk2utf16[0x2d37] = 0x7550;
	__map_gbk2utf16[0x2d38] = 0x7551;
	__map_gbk2utf16[0x2d39] = 0x7552;
	__map_gbk2utf16[0x2d3a] = 0x7553;
	__map_gbk2utf16[0x2d3b] = 0x7555;
	__map_gbk2utf16[0x2d3c] = 0x7556;
	__map_gbk2utf16[0x2d3d] = 0x7557;
	__map_gbk2utf16[0x2d3e] = 0x7558;
	__map_gbk2utf16[0x2d40] = 0x755d;
	__map_gbk2utf16[0x2d41] = 0x755e;
	__map_gbk2utf16[0x2d42] = 0x755f;
	__map_gbk2utf16[0x2d43] = 0x7560;
	__map_gbk2utf16[0x2d44] = 0x7561;
	__map_gbk2utf16[0x2d45] = 0x7562;
	__map_gbk2utf16[0x2d46] = 0x7563;
	__map_gbk2utf16[0x2d47] = 0x7564;
	__map_gbk2utf16[0x2d48] = 0x7567;
	__map_gbk2utf16[0x2d49] = 0x7568;
	__map_gbk2utf16[0x2d4a] = 0x7569;
	__map_gbk2utf16[0x2d4b] = 0x756b;
	__map_gbk2utf16[0x2d4c] = 0x756c;
	__map_gbk2utf16[0x2d4d] = 0x756d;
	__map_gbk2utf16[0x2d4e] = 0x756e;
	__map_gbk2utf16[0x2d4f] = 0x756f;
	__map_gbk2utf16[0x2d50] = 0x7570;
	__map_gbk2utf16[0x2d51] = 0x7571;
	__map_gbk2utf16[0x2d52] = 0x7573;
	__map_gbk2utf16[0x2d53] = 0x7575;
	__map_gbk2utf16[0x2d54] = 0x7576;
	__map_gbk2utf16[0x2d55] = 0x7577;
	__map_gbk2utf16[0x2d56] = 0x757a;
	__map_gbk2utf16[0x2d57] = 0x757b;
	__map_gbk2utf16[0x2d58] = 0x757c;
	__map_gbk2utf16[0x2d59] = 0x757d;
	__map_gbk2utf16[0x2d5a] = 0x757e;
	__map_gbk2utf16[0x2d5b] = 0x7580;
	__map_gbk2utf16[0x2d5c] = 0x7581;
	__map_gbk2utf16[0x2d5d] = 0x7582;
	__map_gbk2utf16[0x2d5e] = 0x7584;
	__map_gbk2utf16[0x2d5f] = 0x7585;
	__map_gbk2utf16[0x2d60] = 0x7587;
	__map_gbk2utf16[0x2d61] = 0xe178;
	__map_gbk2utf16[0x2d62] = 0xe179;
	__map_gbk2utf16[0x2d63] = 0xe17a;
	__map_gbk2utf16[0x2d64] = 0xe17b;
	__map_gbk2utf16[0x2d65] = 0xe17c;
	__map_gbk2utf16[0x2d66] = 0xe17d;
	__map_gbk2utf16[0x2d67] = 0xe17e;
	__map_gbk2utf16[0x2d68] = 0xe17f;
	__map_gbk2utf16[0x2d69] = 0xe180;
	__map_gbk2utf16[0x2d6a] = 0xe181;
	__map_gbk2utf16[0x2d6b] = 0xe182;
	__map_gbk2utf16[0x2d6c] = 0xe183;
	__map_gbk2utf16[0x2d6d] = 0xe184;
	__map_gbk2utf16[0x2d6e] = 0xe185;
	__map_gbk2utf16[0x2d6f] = 0xe186;
	__map_gbk2utf16[0x2d70] = 0xe187;
	__map_gbk2utf16[0x2d71] = 0xe188;
	__map_gbk2utf16[0x2d72] = 0xe189;
	__map_gbk2utf16[0x2d73] = 0xe18a;
	__map_gbk2utf16[0x2d74] = 0xe18b;
	__map_gbk2utf16[0x2d75] = 0xe18c;
	__map_gbk2utf16[0x2d76] = 0xe18d;
	__map_gbk2utf16[0x2d77] = 0xe18e;
	__map_gbk2utf16[0x2d78] = 0xe18f;
	__map_gbk2utf16[0x2d79] = 0xe190;
	__map_gbk2utf16[0x2d7a] = 0xe191;
	__map_gbk2utf16[0x2d7b] = 0xe192;
	__map_gbk2utf16[0x2d7c] = 0xe193;
	__map_gbk2utf16[0x2d7d] = 0xe194;
	__map_gbk2utf16[0x2d7e] = 0xe195;
	__map_gbk2utf16[0x2d7f] = 0xe196;
	__map_gbk2utf16[0x2d80] = 0xe197;
	__map_gbk2utf16[0x2d81] = 0xe198;
	__map_gbk2utf16[0x2d82] = 0xe199;
	__map_gbk2utf16[0x2d83] = 0xe19a;
	__map_gbk2utf16[0x2d84] = 0xe19b;
	__map_gbk2utf16[0x2d85] = 0xe19c;
	__map_gbk2utf16[0x2d86] = 0xe19d;
	__map_gbk2utf16[0x2d87] = 0xe19e;
	__map_gbk2utf16[0x2d88] = 0xe19f;
	__map_gbk2utf16[0x2d89] = 0xe1a0;
	__map_gbk2utf16[0x2d8a] = 0xe1a1;
	__map_gbk2utf16[0x2d8b] = 0xe1a2;
	__map_gbk2utf16[0x2d8c] = 0xe1a3;
	__map_gbk2utf16[0x2d8d] = 0xe1a4;
	__map_gbk2utf16[0x2d8e] = 0xe1a5;
	__map_gbk2utf16[0x2d8f] = 0xe1a6;
	__map_gbk2utf16[0x2d90] = 0xe1a7;
	__map_gbk2utf16[0x2d91] = 0xe1a8;
	__map_gbk2utf16[0x2d92] = 0xe1a9;
	__map_gbk2utf16[0x2d93] = 0xe1aa;
	__map_gbk2utf16[0x2d94] = 0xe1ab;
	__map_gbk2utf16[0x2d95] = 0xe1ac;
	__map_gbk2utf16[0x2d96] = 0xe1ad;
	__map_gbk2utf16[0x2d97] = 0xe1ae;
	__map_gbk2utf16[0x2d98] = 0xe1af;
	__map_gbk2utf16[0x2d99] = 0xe1b0;
	__map_gbk2utf16[0x2d9a] = 0xe1b1;
	__map_gbk2utf16[0x2d9b] = 0xe1b2;
	__map_gbk2utf16[0x2d9c] = 0xe1b3;
	__map_gbk2utf16[0x2d9d] = 0xe1b4;
	__map_gbk2utf16[0x2d9e] = 0xe1b5;
	__map_gbk2utf16[0x2d9f] = 0xe1b6;
	__map_gbk2utf16[0x2da0] = 0xe1b7;
	__map_gbk2utf16[0x2da1] = 0xe1b8;
	__map_gbk2utf16[0x2da2] = 0xe1b9;
	__map_gbk2utf16[0x2da3] = 0xe1ba;
	__map_gbk2utf16[0x2da4] = 0xe1bb;
	__map_gbk2utf16[0x2da5] = 0xe1bc;
	__map_gbk2utf16[0x2da6] = 0xe1bd;
	__map_gbk2utf16[0x2da7] = 0xe1be;
	__map_gbk2utf16[0x2da8] = 0xe1bf;
	__map_gbk2utf16[0x2da9] = 0xe1c0;
	__map_gbk2utf16[0x2daa] = 0xe1c1;
	__map_gbk2utf16[0x2dab] = 0xe1c2;
	__map_gbk2utf16[0x2dac] = 0xe1c3;
	__map_gbk2utf16[0x2dad] = 0xe1c4;
	__map_gbk2utf16[0x2dae] = 0xe1c5;
	__map_gbk2utf16[0x2daf] = 0xe1c6;
	__map_gbk2utf16[0x2db0] = 0xe1c7;
	__map_gbk2utf16[0x2db1] = 0xe1c8;
	__map_gbk2utf16[0x2db2] = 0xe1c9;
	__map_gbk2utf16[0x2db3] = 0xe1ca;
	__map_gbk2utf16[0x2db4] = 0xe1cb;
	__map_gbk2utf16[0x2db5] = 0xe1cc;
	__map_gbk2utf16[0x2db6] = 0xe1cd;
	__map_gbk2utf16[0x2db7] = 0xe1ce;
	__map_gbk2utf16[0x2db8] = 0xe1cf;
	__map_gbk2utf16[0x2db9] = 0xe1d0;
	__map_gbk2utf16[0x2dba] = 0xe1d1;
	__map_gbk2utf16[0x2dbb] = 0xe1d2;
	__map_gbk2utf16[0x2dbc] = 0xe1d3;
	__map_gbk2utf16[0x2dbd] = 0xe1d4;
	__map_gbk2utf16[0x2dbe] = 0xe1d5;
	__map_gbk2utf16[0x2e00] = 0x7588;
	__map_gbk2utf16[0x2e01] = 0x7589;
	__map_gbk2utf16[0x2e02] = 0x758a;
	__map_gbk2utf16[0x2e03] = 0x758c;
	__map_gbk2utf16[0x2e04] = 0x758d;
	__map_gbk2utf16[0x2e05] = 0x758e;
	__map_gbk2utf16[0x2e06] = 0x7590;
	__map_gbk2utf16[0x2e07] = 0x7593;
	__map_gbk2utf16[0x2e08] = 0x7595;
	__map_gbk2utf16[0x2e09] = 0x7598;
	__map_gbk2utf16[0x2e0a] = 0x759b;
	__map_gbk2utf16[0x2e0b] = 0x759c;
	__map_gbk2utf16[0x2e0c] = 0x759e;
	__map_gbk2utf16[0x2e0d] = 0x75a2;
	__map_gbk2utf16[0x2e0e] = 0x75a6;
	__map_gbk2utf16[0x2e0f] = 0x75a7;
	__map_gbk2utf16[0x2e10] = 0x75a8;
	__map_gbk2utf16[0x2e11] = 0x75a9;
	__map_gbk2utf16[0x2e12] = 0x75aa;
	__map_gbk2utf16[0x2e13] = 0x75ad;
	__map_gbk2utf16[0x2e14] = 0x75b6;
	__map_gbk2utf16[0x2e15] = 0x75b7;
	__map_gbk2utf16[0x2e16] = 0x75ba;
	__map_gbk2utf16[0x2e17] = 0x75bb;
	__map_gbk2utf16[0x2e18] = 0x75bf;
	__map_gbk2utf16[0x2e19] = 0x75c0;
	__map_gbk2utf16[0x2e1a] = 0x75c1;
	__map_gbk2utf16[0x2e1b] = 0x75c6;
	__map_gbk2utf16[0x2e1c] = 0x75cb;
	__map_gbk2utf16[0x2e1d] = 0x75cc;
	__map_gbk2utf16[0x2e1e] = 0x75ce;
	__map_gbk2utf16[0x2e1f] = 0x75cf;
	__map_gbk2utf16[0x2e20] = 0x75d0;
	__map_gbk2utf16[0x2e21] = 0x75d1;
	__map_gbk2utf16[0x2e22] = 0x75d3;
	__map_gbk2utf16[0x2e23] = 0x75d7;
	__map_gbk2utf16[0x2e24] = 0x75d9;
	__map_gbk2utf16[0x2e25] = 0x75da;
	__map_gbk2utf16[0x2e26] = 0x75dc;
	__map_gbk2utf16[0x2e27] = 0x75dd;
	__map_gbk2utf16[0x2e28] = 0x75df;
	__map_gbk2utf16[0x2e29] = 0x75e0;
	__map_gbk2utf16[0x2e2a] = 0x75e1;
	__map_gbk2utf16[0x2e2b] = 0x75e5;
	__map_gbk2utf16[0x2e2c] = 0x75e9;
	__map_gbk2utf16[0x2e2d] = 0x75ec;
	__map_gbk2utf16[0x2e2e] = 0x75ed;
	__map_gbk2utf16[0x2e2f] = 0x75ee;
	__map_gbk2utf16[0x2e30] = 0x75ef;
	__map_gbk2utf16[0x2e31] = 0x75f2;
	__map_gbk2utf16[0x2e32] = 0x75f3;
	__map_gbk2utf16[0x2e33] = 0x75f5;
	__map_gbk2utf16[0x2e34] = 0x75f6;
	__map_gbk2utf16[0x2e35] = 0x75f7;
	__map_gbk2utf16[0x2e36] = 0x75f8;
	__map_gbk2utf16[0x2e37] = 0x75fa;
	__map_gbk2utf16[0x2e38] = 0x75fb;
	__map_gbk2utf16[0x2e39] = 0x75fd;
	__map_gbk2utf16[0x2e3a] = 0x75fe;
	__map_gbk2utf16[0x2e3b] = 0x7602;
	__map_gbk2utf16[0x2e3c] = 0x7604;
	__map_gbk2utf16[0x2e3d] = 0x7606;
	__map_gbk2utf16[0x2e3e] = 0x7607;
	__map_gbk2utf16[0x2e40] = 0x7608;
	__map_gbk2utf16[0x2e41] = 0x7609;
	__map_gbk2utf16[0x2e42] = 0x760b;
	__map_gbk2utf16[0x2e43] = 0x760d;
	__map_gbk2utf16[0x2e44] = 0x760e;
	__map_gbk2utf16[0x2e45] = 0x760f;
	__map_gbk2utf16[0x2e46] = 0x7611;
	__map_gbk2utf16[0x2e47] = 0x7612;
	__map_gbk2utf16[0x2e48] = 0x7613;
	__map_gbk2utf16[0x2e49] = 0x7614;
	__map_gbk2utf16[0x2e4a] = 0x7616;
	__map_gbk2utf16[0x2e4b] = 0x761a;
	__map_gbk2utf16[0x2e4c] = 0x761c;
	__map_gbk2utf16[0x2e4d] = 0x761d;
	__map_gbk2utf16[0x2e4e] = 0x761e;
	__map_gbk2utf16[0x2e4f] = 0x7621;
	__map_gbk2utf16[0x2e50] = 0x7623;
	__map_gbk2utf16[0x2e51] = 0x7627;
	__map_gbk2utf16[0x2e52] = 0x7628;
	__map_gbk2utf16[0x2e53] = 0x762c;
	__map_gbk2utf16[0x2e54] = 0x762e;
	__map_gbk2utf16[0x2e55] = 0x762f;
	__map_gbk2utf16[0x2e56] = 0x7631;
	__map_gbk2utf16[0x2e57] = 0x7632;
	__map_gbk2utf16[0x2e58] = 0x7636;
	__map_gbk2utf16[0x2e59] = 0x7637;
	__map_gbk2utf16[0x2e5a] = 0x7639;
	__map_gbk2utf16[0x2e5b] = 0x763a;
	__map_gbk2utf16[0x2e5c] = 0x763b;
	__map_gbk2utf16[0x2e5d] = 0x763d;
	__map_gbk2utf16[0x2e5e] = 0x7641;
	__map_gbk2utf16[0x2e5f] = 0x7642;
	__map_gbk2utf16[0x2e60] = 0x7644;
	__map_gbk2utf16[0x2e61] = 0xe1d6;
	__map_gbk2utf16[0x2e62] = 0xe1d7;
	__map_gbk2utf16[0x2e63] = 0xe1d8;
	__map_gbk2utf16[0x2e64] = 0xe1d9;
	__map_gbk2utf16[0x2e65] = 0xe1da;
	__map_gbk2utf16[0x2e66] = 0xe1db;
	__map_gbk2utf16[0x2e67] = 0xe1dc;
	__map_gbk2utf16[0x2e68] = 0xe1dd;
	__map_gbk2utf16[0x2e69] = 0xe1de;
	__map_gbk2utf16[0x2e6a] = 0xe1df;
	__map_gbk2utf16[0x2e6b] = 0xe1e0;
	__map_gbk2utf16[0x2e6c] = 0xe1e1;
	__map_gbk2utf16[0x2e6d] = 0xe1e2;
	__map_gbk2utf16[0x2e6e] = 0xe1e3;
	__map_gbk2utf16[0x2e6f] = 0xe1e4;
	__map_gbk2utf16[0x2e70] = 0xe1e5;
	__map_gbk2utf16[0x2e71] = 0xe1e6;
	__map_gbk2utf16[0x2e72] = 0xe1e7;
	__map_gbk2utf16[0x2e73] = 0xe1e8;
	__map_gbk2utf16[0x2e74] = 0xe1e9;
	__map_gbk2utf16[0x2e75] = 0xe1ea;
	__map_gbk2utf16[0x2e76] = 0xe1eb;
	__map_gbk2utf16[0x2e77] = 0xe1ec;
	__map_gbk2utf16[0x2e78] = 0xe1ed;
	__map_gbk2utf16[0x2e79] = 0xe1ee;
	__map_gbk2utf16[0x2e7a] = 0xe1ef;
	__map_gbk2utf16[0x2e7b] = 0xe1f0;
	__map_gbk2utf16[0x2e7c] = 0xe1f1;
	__map_gbk2utf16[0x2e7d] = 0xe1f2;
	__map_gbk2utf16[0x2e7e] = 0xe1f3;
	__map_gbk2utf16[0x2e7f] = 0xe1f4;
	__map_gbk2utf16[0x2e80] = 0xe1f5;
	__map_gbk2utf16[0x2e81] = 0xe1f6;
	__map_gbk2utf16[0x2e82] = 0xe1f7;
	__map_gbk2utf16[0x2e83] = 0xe1f8;
	__map_gbk2utf16[0x2e84] = 0xe1f9;
	__map_gbk2utf16[0x2e85] = 0xe1fa;
	__map_gbk2utf16[0x2e86] = 0xe1fb;
	__map_gbk2utf16[0x2e87] = 0xe1fc;
	__map_gbk2utf16[0x2e88] = 0xe1fd;
	__map_gbk2utf16[0x2e89] = 0xe1fe;
	__map_gbk2utf16[0x2e8a] = 0xe1ff;
	__map_gbk2utf16[0x2e8b] = 0xe200;
	__map_gbk2utf16[0x2e8c] = 0xe201;
	__map_gbk2utf16[0x2e8d] = 0xe202;
	__map_gbk2utf16[0x2e8e] = 0xe203;
	__map_gbk2utf16[0x2e8f] = 0xe204;
	__map_gbk2utf16[0x2e90] = 0xe205;
	__map_gbk2utf16[0x2e91] = 0xe206;
	__map_gbk2utf16[0x2e92] = 0xe207;
	__map_gbk2utf16[0x2e93] = 0xe208;
	__map_gbk2utf16[0x2e94] = 0xe209;
	__map_gbk2utf16[0x2e95] = 0xe20a;
	__map_gbk2utf16[0x2e96] = 0xe20b;
	__map_gbk2utf16[0x2e97] = 0xe20c;
	__map_gbk2utf16[0x2e98] = 0xe20d;
	__map_gbk2utf16[0x2e99] = 0xe20e;
	__map_gbk2utf16[0x2e9a] = 0xe20f;
	__map_gbk2utf16[0x2e9b] = 0xe210;
	__map_gbk2utf16[0x2e9c] = 0xe211;
	__map_gbk2utf16[0x2e9d] = 0xe212;
	__map_gbk2utf16[0x2e9e] = 0xe213;
	__map_gbk2utf16[0x2e9f] = 0xe214;
	__map_gbk2utf16[0x2ea0] = 0xe215;
	__map_gbk2utf16[0x2ea1] = 0xe216;
	__map_gbk2utf16[0x2ea2] = 0xe217;
	__map_gbk2utf16[0x2ea3] = 0xe218;
	__map_gbk2utf16[0x2ea4] = 0xe219;
	__map_gbk2utf16[0x2ea5] = 0xe21a;
	__map_gbk2utf16[0x2ea6] = 0xe21b;
	__map_gbk2utf16[0x2ea7] = 0xe21c;
	__map_gbk2utf16[0x2ea8] = 0xe21d;
	__map_gbk2utf16[0x2ea9] = 0xe21e;
	__map_gbk2utf16[0x2eaa] = 0xe21f;
	__map_gbk2utf16[0x2eab] = 0xe220;
	__map_gbk2utf16[0x2eac] = 0xe221;
	__map_gbk2utf16[0x2ead] = 0xe222;
	__map_gbk2utf16[0x2eae] = 0xe223;
	__map_gbk2utf16[0x2eaf] = 0xe224;
	__map_gbk2utf16[0x2eb0] = 0xe225;
	__map_gbk2utf16[0x2eb1] = 0xe226;
	__map_gbk2utf16[0x2eb2] = 0xe227;
	__map_gbk2utf16[0x2eb3] = 0xe228;
	__map_gbk2utf16[0x2eb4] = 0xe229;
	__map_gbk2utf16[0x2eb5] = 0xe22a;
	__map_gbk2utf16[0x2eb6] = 0xe22b;
	__map_gbk2utf16[0x2eb7] = 0xe22c;
	__map_gbk2utf16[0x2eb8] = 0xe22d;
	__map_gbk2utf16[0x2eb9] = 0xe22e;
	__map_gbk2utf16[0x2eba] = 0xe22f;
	__map_gbk2utf16[0x2ebb] = 0xe230;
	__map_gbk2utf16[0x2ebc] = 0xe231;
	__map_gbk2utf16[0x2ebd] = 0xe232;
	__map_gbk2utf16[0x2ebe] = 0xe233;
	__map_gbk2utf16[0x2f00] = 0x7645;
	__map_gbk2utf16[0x2f01] = 0x7646;
	__map_gbk2utf16[0x2f02] = 0x7647;
	__map_gbk2utf16[0x2f03] = 0x7648;
	__map_gbk2utf16[0x2f04] = 0x7649;
	__map_gbk2utf16[0x2f05] = 0x764a;
	__map_gbk2utf16[0x2f06] = 0x764b;
	__map_gbk2utf16[0x2f07] = 0x764e;
	__map_gbk2utf16[0x2f08] = 0x764f;
	__map_gbk2utf16[0x2f09] = 0x7650;
	__map_gbk2utf16[0x2f0a] = 0x7651;
	__map_gbk2utf16[0x2f0b] = 0x7652;
	__map_gbk2utf16[0x2f0c] = 0x7653;
	__map_gbk2utf16[0x2f0d] = 0x7655;
	__map_gbk2utf16[0x2f0e] = 0x7657;
	__map_gbk2utf16[0x2f0f] = 0x7658;
	__map_gbk2utf16[0x2f10] = 0x7659;
	__map_gbk2utf16[0x2f11] = 0x765a;
	__map_gbk2utf16[0x2f12] = 0x765b;
	__map_gbk2utf16[0x2f13] = 0x765d;
	__map_gbk2utf16[0x2f14] = 0x765f;
	__map_gbk2utf16[0x2f15] = 0x7660;
	__map_gbk2utf16[0x2f16] = 0x7661;
	__map_gbk2utf16[0x2f17] = 0x7662;
	__map_gbk2utf16[0x2f18] = 0x7664;
	__map_gbk2utf16[0x2f19] = 0x7665;
	__map_gbk2utf16[0x2f1a] = 0x7666;
	__map_gbk2utf16[0x2f1b] = 0x7667;
	__map_gbk2utf16[0x2f1c] = 0x7668;
	__map_gbk2utf16[0x2f1d] = 0x7669;
	__map_gbk2utf16[0x2f1e] = 0x766a;
	__map_gbk2utf16[0x2f1f] = 0x766c;
	__map_gbk2utf16[0x2f20] = 0x766d;
	__map_gbk2utf16[0x2f21] = 0x766e;
	__map_gbk2utf16[0x2f22] = 0x7670;
	__map_gbk2utf16[0x2f23] = 0x7671;
	__map_gbk2utf16[0x2f24] = 0x7672;
	__map_gbk2utf16[0x2f25] = 0x7673;
	__map_gbk2utf16[0x2f26] = 0x7674;
	__map_gbk2utf16[0x2f27] = 0x7675;
	__map_gbk2utf16[0x2f28] = 0x7676;
	__map_gbk2utf16[0x2f29] = 0x7677;
	__map_gbk2utf16[0x2f2a] = 0x7679;
	__map_gbk2utf16[0x2f2b] = 0x767a;
	__map_gbk2utf16[0x2f2c] = 0x767c;
	__map_gbk2utf16[0x2f2d] = 0x767f;
	__map_gbk2utf16[0x2f2e] = 0x7680;
	__map_gbk2utf16[0x2f2f] = 0x7681;
	__map_gbk2utf16[0x2f30] = 0x7683;
	__map_gbk2utf16[0x2f31] = 0x7685;
	__map_gbk2utf16[0x2f32] = 0x7689;
	__map_gbk2utf16[0x2f33] = 0x768a;
	__map_gbk2utf16[0x2f34] = 0x768c;
	__map_gbk2utf16[0x2f35] = 0x768d;
	__map_gbk2utf16[0x2f36] = 0x768f;
	__map_gbk2utf16[0x2f37] = 0x7690;
	__map_gbk2utf16[0x2f38] = 0x7692;
	__map_gbk2utf16[0x2f39] = 0x7694;
	__map_gbk2utf16[0x2f3a] = 0x7695;
	__map_gbk2utf16[0x2f3b] = 0x7697;
	__map_gbk2utf16[0x2f3c] = 0x7698;
	__map_gbk2utf16[0x2f3d] = 0x769a;
	__map_gbk2utf16[0x2f3e] = 0x769b;
	__map_gbk2utf16[0x2f40] = 0x769c;
	__map_gbk2utf16[0x2f41] = 0x769d;
	__map_gbk2utf16[0x2f42] = 0x769e;
	__map_gbk2utf16[0x2f43] = 0x769f;
	__map_gbk2utf16[0x2f44] = 0x76a0;
	__map_gbk2utf16[0x2f45] = 0x76a1;
	__map_gbk2utf16[0x2f46] = 0x76a2;
	__map_gbk2utf16[0x2f47] = 0x76a3;
	__map_gbk2utf16[0x2f48] = 0x76a5;
	__map_gbk2utf16[0x2f49] = 0x76a6;
	__map_gbk2utf16[0x2f4a] = 0x76a7;
	__map_gbk2utf16[0x2f4b] = 0x76a8;
	__map_gbk2utf16[0x2f4c] = 0x76a9;
	__map_gbk2utf16[0x2f4d] = 0x76aa;
	__map_gbk2utf16[0x2f4e] = 0x76ab;
	__map_gbk2utf16[0x2f4f] = 0x76ac;
	__map_gbk2utf16[0x2f50] = 0x76ad;
	__map_gbk2utf16[0x2f51] = 0x76af;
	__map_gbk2utf16[0x2f52] = 0x76b0;
	__map_gbk2utf16[0x2f53] = 0x76b3;
	__map_gbk2utf16[0x2f54] = 0x76b5;
	__map_gbk2utf16[0x2f55] = 0x76b6;
	__map_gbk2utf16[0x2f56] = 0x76b7;
	__map_gbk2utf16[0x2f57] = 0x76b8;
	__map_gbk2utf16[0x2f58] = 0x76b9;
	__map_gbk2utf16[0x2f59] = 0x76ba;
	__map_gbk2utf16[0x2f5a] = 0x76bb;
	__map_gbk2utf16[0x2f5b] = 0x76bc;
	__map_gbk2utf16[0x2f5c] = 0x76bd;
	__map_gbk2utf16[0x2f5d] = 0x76be;
	__map_gbk2utf16[0x2f5e] = 0x76c0;
	__map_gbk2utf16[0x2f5f] = 0x76c1;
	__map_gbk2utf16[0x2f60] = 0x76c3;
	__map_gbk2utf16[0x2f61] = 0x554a;
	__map_gbk2utf16[0x2f62] = 0x963f;
	__map_gbk2utf16[0x2f63] = 0x57c3;
	__map_gbk2utf16[0x2f64] = 0x6328;
	__map_gbk2utf16[0x2f65] = 0x54ce;
	__map_gbk2utf16[0x2f66] = 0x5509;
	__map_gbk2utf16[0x2f67] = 0x54c0;
	__map_gbk2utf16[0x2f68] = 0x7691;
	__map_gbk2utf16[0x2f69] = 0x764c;
	__map_gbk2utf16[0x2f6a] = 0x853c;
	__map_gbk2utf16[0x2f6b] = 0x77ee;
	__map_gbk2utf16[0x2f6c] = 0x827e;
	__map_gbk2utf16[0x2f6d] = 0x788d;
	__map_gbk2utf16[0x2f6e] = 0x7231;
	__map_gbk2utf16[0x2f6f] = 0x9698;
	__map_gbk2utf16[0x2f70] = 0x978d;
	__map_gbk2utf16[0x2f71] = 0x6c28;
	__map_gbk2utf16[0x2f72] = 0x5b89;
	__map_gbk2utf16[0x2f73] = 0x4ffa;
	__map_gbk2utf16[0x2f74] = 0x6309;
	__map_gbk2utf16[0x2f75] = 0x6697;
	__map_gbk2utf16[0x2f76] = 0x5cb8;
	__map_gbk2utf16[0x2f77] = 0x80fa;
	__map_gbk2utf16[0x2f78] = 0x6848;
	__map_gbk2utf16[0x2f79] = 0x80ae;
	__map_gbk2utf16[0x2f7a] = 0x6602;
	__map_gbk2utf16[0x2f7b] = 0x76ce;
	__map_gbk2utf16[0x2f7c] = 0x51f9;
	__map_gbk2utf16[0x2f7d] = 0x6556;
	__map_gbk2utf16[0x2f7e] = 0x71ac;
	__map_gbk2utf16[0x2f7f] = 0x7ff1;
	__map_gbk2utf16[0x2f80] = 0x8884;
	__map_gbk2utf16[0x2f81] = 0x50b2;
	__map_gbk2utf16[0x2f82] = 0x5965;
	__map_gbk2utf16[0x2f83] = 0x61ca;
	__map_gbk2utf16[0x2f84] = 0x6fb3;
	__map_gbk2utf16[0x2f85] = 0x82ad;
	__map_gbk2utf16[0x2f86] = 0x634c;
	__map_gbk2utf16[0x2f87] = 0x6252;
	__map_gbk2utf16[0x2f88] = 0x53ed;
	__map_gbk2utf16[0x2f89] = 0x5427;
	__map_gbk2utf16[0x2f8a] = 0x7b06;
	__map_gbk2utf16[0x2f8b] = 0x516b;
	__map_gbk2utf16[0x2f8c] = 0x75a4;
	__map_gbk2utf16[0x2f8d] = 0x5df4;
	__map_gbk2utf16[0x2f8e] = 0x62d4;
	__map_gbk2utf16[0x2f8f] = 0x8dcb;
	__map_gbk2utf16[0x2f90] = 0x9776;
	__map_gbk2utf16[0x2f91] = 0x628a;
	__map_gbk2utf16[0x2f92] = 0x8019;
	__map_gbk2utf16[0x2f93] = 0x575d;
	__map_gbk2utf16[0x2f94] = 0x9738;
	__map_gbk2utf16[0x2f95] = 0x7f62;
	__map_gbk2utf16[0x2f96] = 0x7238;
	__map_gbk2utf16[0x2f97] = 0x767d;
	__map_gbk2utf16[0x2f98] = 0x67cf;
	__map_gbk2utf16[0x2f99] = 0x767e;
	__map_gbk2utf16[0x2f9a] = 0x6446;
	__map_gbk2utf16[0x2f9b] = 0x4f70;
	__map_gbk2utf16[0x2f9c] = 0x8d25;
	__map_gbk2utf16[0x2f9d] = 0x62dc;
	__map_gbk2utf16[0x2f9e] = 0x7a17;
	__map_gbk2utf16[0x2f9f] = 0x6591;
	__map_gbk2utf16[0x2fa0] = 0x73ed;
	__map_gbk2utf16[0x2fa1] = 0x642c;
	__map_gbk2utf16[0x2fa2] = 0x6273;
	__map_gbk2utf16[0x2fa3] = 0x822c;
	__map_gbk2utf16[0x2fa4] = 0x9881;
	__map_gbk2utf16[0x2fa5] = 0x677f;
	__map_gbk2utf16[0x2fa6] = 0x7248;
	__map_gbk2utf16[0x2fa7] = 0x626e;
	__map_gbk2utf16[0x2fa8] = 0x62cc;
	__map_gbk2utf16[0x2fa9] = 0x4f34;
	__map_gbk2utf16[0x2faa] = 0x74e3;
	__map_gbk2utf16[0x2fab] = 0x534a;
	__map_gbk2utf16[0x2fac] = 0x529e;
	__map_gbk2utf16[0x2fad] = 0x7eca;
	__map_gbk2utf16[0x2fae] = 0x90a6;
	__map_gbk2utf16[0x2faf] = 0x5e2e;
	__map_gbk2utf16[0x2fb0] = 0x6886;
	__map_gbk2utf16[0x2fb1] = 0x699c;
	__map_gbk2utf16[0x2fb2] = 0x8180;
	__map_gbk2utf16[0x2fb3] = 0x7ed1;
	__map_gbk2utf16[0x2fb4] = 0x68d2;
	__map_gbk2utf16[0x2fb5] = 0x78c5;
	__map_gbk2utf16[0x2fb6] = 0x868c;
	__map_gbk2utf16[0x2fb7] = 0x9551;
	__map_gbk2utf16[0x2fb8] = 0x508d;
	__map_gbk2utf16[0x2fb9] = 0x8c24;
	__map_gbk2utf16[0x2fba] = 0x82de;
	__map_gbk2utf16[0x2fbb] = 0x80de;
	__map_gbk2utf16[0x2fbc] = 0x5305;
	__map_gbk2utf16[0x2fbd] = 0x8912;
	__map_gbk2utf16[0x2fbe] = 0x5265;
	__map_gbk2utf16[0x3000] = 0x76c4;
	__map_gbk2utf16[0x3001] = 0x76c7;
	__map_gbk2utf16[0x3002] = 0x76c9;
	__map_gbk2utf16[0x3003] = 0x76cb;
	__map_gbk2utf16[0x3004] = 0x76cc;
	__map_gbk2utf16[0x3005] = 0x76d3;
	__map_gbk2utf16[0x3006] = 0x76d5;
	__map_gbk2utf16[0x3007] = 0x76d9;
	__map_gbk2utf16[0x3008] = 0x76da;
	__map_gbk2utf16[0x3009] = 0x76dc;
	__map_gbk2utf16[0x300a] = 0x76dd;
	__map_gbk2utf16[0x300b] = 0x76de;
	__map_gbk2utf16[0x300c] = 0x76e0;
	__map_gbk2utf16[0x300d] = 0x76e1;
	__map_gbk2utf16[0x300e] = 0x76e2;
	__map_gbk2utf16[0x300f] = 0x76e3;
	__map_gbk2utf16[0x3010] = 0x76e4;
	__map_gbk2utf16[0x3011] = 0x76e6;
	__map_gbk2utf16[0x3012] = 0x76e7;
	__map_gbk2utf16[0x3013] = 0x76e8;
	__map_gbk2utf16[0x3014] = 0x76e9;
	__map_gbk2utf16[0x3015] = 0x76ea;
	__map_gbk2utf16[0x3016] = 0x76eb;
	__map_gbk2utf16[0x3017] = 0x76ec;
	__map_gbk2utf16[0x3018] = 0x76ed;
	__map_gbk2utf16[0x3019] = 0x76f0;
	__map_gbk2utf16[0x301a] = 0x76f3;
	__map_gbk2utf16[0x301b] = 0x76f5;
	__map_gbk2utf16[0x301c] = 0x76f6;
	__map_gbk2utf16[0x301d] = 0x76f7;
	__map_gbk2utf16[0x301e] = 0x76fa;
	__map_gbk2utf16[0x301f] = 0x76fb;
	__map_gbk2utf16[0x3020] = 0x76fd;
	__map_gbk2utf16[0x3021] = 0x76ff;
	__map_gbk2utf16[0x3022] = 0x7700;
	__map_gbk2utf16[0x3023] = 0x7702;
	__map_gbk2utf16[0x3024] = 0x7703;
	__map_gbk2utf16[0x3025] = 0x7705;
	__map_gbk2utf16[0x3026] = 0x7706;
	__map_gbk2utf16[0x3027] = 0x770a;
	__map_gbk2utf16[0x3028] = 0x770c;
	__map_gbk2utf16[0x3029] = 0x770e;
	__map_gbk2utf16[0x302a] = 0x770f;
	__map_gbk2utf16[0x302b] = 0x7710;
	__map_gbk2utf16[0x302c] = 0x7711;
	__map_gbk2utf16[0x302d] = 0x7712;
	__map_gbk2utf16[0x302e] = 0x7713;
	__map_gbk2utf16[0x302f] = 0x7714;
	__map_gbk2utf16[0x3030] = 0x7715;
	__map_gbk2utf16[0x3031] = 0x7716;
	__map_gbk2utf16[0x3032] = 0x7717;
	__map_gbk2utf16[0x3033] = 0x7718;
	__map_gbk2utf16[0x3034] = 0x771b;
	__map_gbk2utf16[0x3035] = 0x771c;
	__map_gbk2utf16[0x3036] = 0x771d;
	__map_gbk2utf16[0x3037] = 0x771e;
	__map_gbk2utf16[0x3038] = 0x7721;
	__map_gbk2utf16[0x3039] = 0x7723;
	__map_gbk2utf16[0x303a] = 0x7724;
	__map_gbk2utf16[0x303b] = 0x7725;
	__map_gbk2utf16[0x303c] = 0x7727;
	__map_gbk2utf16[0x303d] = 0x772a;
	__map_gbk2utf16[0x303e] = 0x772b;
	__map_gbk2utf16[0x3040] = 0x772c;
	__map_gbk2utf16[0x3041] = 0x772e;
	__map_gbk2utf16[0x3042] = 0x7730;
	__map_gbk2utf16[0x3043] = 0x7731;
	__map_gbk2utf16[0x3044] = 0x7732;
	__map_gbk2utf16[0x3045] = 0x7733;
	__map_gbk2utf16[0x3046] = 0x7734;
	__map_gbk2utf16[0x3047] = 0x7739;
	__map_gbk2utf16[0x3048] = 0x773b;
	__map_gbk2utf16[0x3049] = 0x773d;
	__map_gbk2utf16[0x304a] = 0x773e;
	__map_gbk2utf16[0x304b] = 0x773f;
	__map_gbk2utf16[0x304c] = 0x7742;
	__map_gbk2utf16[0x304d] = 0x7744;
	__map_gbk2utf16[0x304e] = 0x7745;
	__map_gbk2utf16[0x304f] = 0x7746;
	__map_gbk2utf16[0x3050] = 0x7748;
	__map_gbk2utf16[0x3051] = 0x7749;
	__map_gbk2utf16[0x3052] = 0x774a;
	__map_gbk2utf16[0x3053] = 0x774b;
	__map_gbk2utf16[0x3054] = 0x774c;
	__map_gbk2utf16[0x3055] = 0x774d;
	__map_gbk2utf16[0x3056] = 0x774e;
	__map_gbk2utf16[0x3057] = 0x774f;
	__map_gbk2utf16[0x3058] = 0x7752;
	__map_gbk2utf16[0x3059] = 0x7753;
	__map_gbk2utf16[0x305a] = 0x7754;
	__map_gbk2utf16[0x305b] = 0x7755;
	__map_gbk2utf16[0x305c] = 0x7756;
	__map_gbk2utf16[0x305d] = 0x7757;
	__map_gbk2utf16[0x305e] = 0x7758;
	__map_gbk2utf16[0x305f] = 0x7759;
	__map_gbk2utf16[0x3060] = 0x775c;
	__map_gbk2utf16[0x3061] = 0x8584;
	__map_gbk2utf16[0x3062] = 0x96f9;
	__map_gbk2utf16[0x3063] = 0x4fdd;
	__map_gbk2utf16[0x3064] = 0x5821;
	__map_gbk2utf16[0x3065] = 0x9971;
	__map_gbk2utf16[0x3066] = 0x5b9d;
	__map_gbk2utf16[0x3067] = 0x62b1;
	__map_gbk2utf16[0x3068] = 0x62a5;
	__map_gbk2utf16[0x3069] = 0x66b4;
	__map_gbk2utf16[0x306a] = 0x8c79;
	__map_gbk2utf16[0x306b] = 0x9c8d;
	__map_gbk2utf16[0x306c] = 0x7206;
	__map_gbk2utf16[0x306d] = 0x676f;
	__map_gbk2utf16[0x306e] = 0x7891;
	__map_gbk2utf16[0x306f] = 0x60b2;
	__map_gbk2utf16[0x3070] = 0x5351;
	__map_gbk2utf16[0x3071] = 0x5317;
	__map_gbk2utf16[0x3072] = 0x8f88;
	__map_gbk2utf16[0x3073] = 0x80cc;
	__map_gbk2utf16[0x3074] = 0x8d1d;
	__map_gbk2utf16[0x3075] = 0x94a1;
	__map_gbk2utf16[0x3076] = 0x500d;
	__map_gbk2utf16[0x3077] = 0x72c8;
	__map_gbk2utf16[0x3078] = 0x5907;
	__map_gbk2utf16[0x3079] = 0x60eb;
	__map_gbk2utf16[0x307a] = 0x7119;
	__map_gbk2utf16[0x307b] = 0x88ab;
	__map_gbk2utf16[0x307c] = 0x5954;
	__map_gbk2utf16[0x307d] = 0x82ef;
	__map_gbk2utf16[0x307e] = 0x672c;
	__map_gbk2utf16[0x307f] = 0x7b28;
	__map_gbk2utf16[0x3080] = 0x5d29;
	__map_gbk2utf16[0x3081] = 0x7ef7;
	__map_gbk2utf16[0x3082] = 0x752d;
	__map_gbk2utf16[0x3083] = 0x6cf5;
	__map_gbk2utf16[0x3084] = 0x8e66;
	__map_gbk2utf16[0x3085] = 0x8ff8;
	__map_gbk2utf16[0x3086] = 0x903c;
	__map_gbk2utf16[0x3087] = 0x9f3b;
	__map_gbk2utf16[0x3088] = 0x6bd4;
	__map_gbk2utf16[0x3089] = 0x9119;
	__map_gbk2utf16[0x308a] = 0x7b14;
	__map_gbk2utf16[0x308b] = 0x5f7c;
	__map_gbk2utf16[0x308c] = 0x78a7;
	__map_gbk2utf16[0x308d] = 0x84d6;
	__map_gbk2utf16[0x308e] = 0x853d;
	__map_gbk2utf16[0x308f] = 0x6bd5;
	__map_gbk2utf16[0x3090] = 0x6bd9;
	__map_gbk2utf16[0x3091] = 0x6bd6;
	__map_gbk2utf16[0x3092] = 0x5e01;
	__map_gbk2utf16[0x3093] = 0x5e87;
	__map_gbk2utf16[0x3094] = 0x75f9;
	__map_gbk2utf16[0x3095] = 0x95ed;
	__map_gbk2utf16[0x3096] = 0x655d;
	__map_gbk2utf16[0x3097] = 0x5f0a;
	__map_gbk2utf16[0x3098] = 0x5fc5;
	__map_gbk2utf16[0x3099] = 0x8f9f;
	__map_gbk2utf16[0x309a] = 0x58c1;
	__map_gbk2utf16[0x309b] = 0x81c2;
	__map_gbk2utf16[0x309c] = 0x907f;
	__map_gbk2utf16[0x309d] = 0x965b;
	__map_gbk2utf16[0x309e] = 0x97ad;
	__map_gbk2utf16[0x309f] = 0x8fb9;
	__map_gbk2utf16[0x30a0] = 0x7f16;
	__map_gbk2utf16[0x30a1] = 0x8d2c;
	__map_gbk2utf16[0x30a2] = 0x6241;
	__map_gbk2utf16[0x30a3] = 0x4fbf;
	__map_gbk2utf16[0x30a4] = 0x53d8;
	__map_gbk2utf16[0x30a5] = 0x535e;
	__map_gbk2utf16[0x30a6] = 0x8fa8;
	__map_gbk2utf16[0x30a7] = 0x8fa9;
	__map_gbk2utf16[0x30a8] = 0x8fab;
	__map_gbk2utf16[0x30a9] = 0x904d;
	__map_gbk2utf16[0x30aa] = 0x6807;
	__map_gbk2utf16[0x30ab] = 0x5f6a;
	__map_gbk2utf16[0x30ac] = 0x8198;
	__map_gbk2utf16[0x30ad] = 0x8868;
	__map_gbk2utf16[0x30ae] = 0x9cd6;
	__map_gbk2utf16[0x30af] = 0x618b;
	__map_gbk2utf16[0x30b0] = 0x522b;
	__map_gbk2utf16[0x30b1] = 0x762a;
	__map_gbk2utf16[0x30b2] = 0x5f6c;
	__map_gbk2utf16[0x30b3] = 0x658c;
	__map_gbk2utf16[0x30b4] = 0x6fd2;
	__map_gbk2utf16[0x30b5] = 0x6ee8;
	__map_gbk2utf16[0x30b6] = 0x5bbe;
	__map_gbk2utf16[0x30b7] = 0x6448;
	__map_gbk2utf16[0x30b8] = 0x5175;
	__map_gbk2utf16[0x30b9] = 0x51b0;
	__map_gbk2utf16[0x30ba] = 0x67c4;
	__map_gbk2utf16[0x30bb] = 0x4e19;
	__map_gbk2utf16[0x30bc] = 0x79c9;
	__map_gbk2utf16[0x30bd] = 0x997c;
	__map_gbk2utf16[0x30be] = 0x70b3;
	__map_gbk2utf16[0x3100] = 0x775d;
	__map_gbk2utf16[0x3101] = 0x775e;
	__map_gbk2utf16[0x3102] = 0x775f;
	__map_gbk2utf16[0x3103] = 0x7760;
	__map_gbk2utf16[0x3104] = 0x7764;
	__map_gbk2utf16[0x3105] = 0x7767;
	__map_gbk2utf16[0x3106] = 0x7769;
	__map_gbk2utf16[0x3107] = 0x776a;
	__map_gbk2utf16[0x3108] = 0x776d;
	__map_gbk2utf16[0x3109] = 0x776e;
	__map_gbk2utf16[0x310a] = 0x776f;
	__map_gbk2utf16[0x310b] = 0x7770;
	__map_gbk2utf16[0x310c] = 0x7771;
	__map_gbk2utf16[0x310d] = 0x7772;
	__map_gbk2utf16[0x310e] = 0x7773;
	__map_gbk2utf16[0x310f] = 0x7774;
	__map_gbk2utf16[0x3110] = 0x7775;
	__map_gbk2utf16[0x3111] = 0x7776;
	__map_gbk2utf16[0x3112] = 0x7777;
	__map_gbk2utf16[0x3113] = 0x7778;
	__map_gbk2utf16[0x3114] = 0x777a;
	__map_gbk2utf16[0x3115] = 0x777b;
	__map_gbk2utf16[0x3116] = 0x777c;
	__map_gbk2utf16[0x3117] = 0x7781;
	__map_gbk2utf16[0x3118] = 0x7782;
	__map_gbk2utf16[0x3119] = 0x7783;
	__map_gbk2utf16[0x311a] = 0x7786;
	__map_gbk2utf16[0x311b] = 0x7787;
	__map_gbk2utf16[0x311c] = 0x7788;
	__map_gbk2utf16[0x311d] = 0x7789;
	__map_gbk2utf16[0x311e] = 0x778a;
	__map_gbk2utf16[0x311f] = 0x778b;
	__map_gbk2utf16[0x3120] = 0x778f;
	__map_gbk2utf16[0x3121] = 0x7790;
	__map_gbk2utf16[0x3122] = 0x7793;
	__map_gbk2utf16[0x3123] = 0x7794;
	__map_gbk2utf16[0x3124] = 0x7795;
	__map_gbk2utf16[0x3125] = 0x7796;
	__map_gbk2utf16[0x3126] = 0x7797;
	__map_gbk2utf16[0x3127] = 0x7798;
	__map_gbk2utf16[0x3128] = 0x7799;
	__map_gbk2utf16[0x3129] = 0x779a;
	__map_gbk2utf16[0x312a] = 0x779b;
	__map_gbk2utf16[0x312b] = 0x779c;
	__map_gbk2utf16[0x312c] = 0x779d;
	__map_gbk2utf16[0x312d] = 0x779e;
	__map_gbk2utf16[0x312e] = 0x77a1;
	__map_gbk2utf16[0x312f] = 0x77a3;
	__map_gbk2utf16[0x3130] = 0x77a4;
	__map_gbk2utf16[0x3131] = 0x77a6;
	__map_gbk2utf16[0x3132] = 0x77a8;
	__map_gbk2utf16[0x3133] = 0x77ab;
	__map_gbk2utf16[0x3134] = 0x77ad;
	__map_gbk2utf16[0x3135] = 0x77ae;
	__map_gbk2utf16[0x3136] = 0x77af;
	__map_gbk2utf16[0x3137] = 0x77b1;
	__map_gbk2utf16[0x3138] = 0x77b2;
	__map_gbk2utf16[0x3139] = 0x77b4;
	__map_gbk2utf16[0x313a] = 0x77b6;
	__map_gbk2utf16[0x313b] = 0x77b7;
	__map_gbk2utf16[0x313c] = 0x77b8;
	__map_gbk2utf16[0x313d] = 0x77b9;
	__map_gbk2utf16[0x313e] = 0x77ba;
	__map_gbk2utf16[0x3140] = 0x77bc;
	__map_gbk2utf16[0x3141] = 0x77be;
	__map_gbk2utf16[0x3142] = 0x77c0;
	__map_gbk2utf16[0x3143] = 0x77c1;
	__map_gbk2utf16[0x3144] = 0x77c2;
	__map_gbk2utf16[0x3145] = 0x77c3;
	__map_gbk2utf16[0x3146] = 0x77c4;
	__map_gbk2utf16[0x3147] = 0x77c5;
	__map_gbk2utf16[0x3148] = 0x77c6;
	__map_gbk2utf16[0x3149] = 0x77c7;
	__map_gbk2utf16[0x314a] = 0x77c8;
	__map_gbk2utf16[0x314b] = 0x77c9;
	__map_gbk2utf16[0x314c] = 0x77ca;
	__map_gbk2utf16[0x314d] = 0x77cb;
	__map_gbk2utf16[0x314e] = 0x77cc;
	__map_gbk2utf16[0x314f] = 0x77ce;
	__map_gbk2utf16[0x3150] = 0x77cf;
	__map_gbk2utf16[0x3151] = 0x77d0;
	__map_gbk2utf16[0x3152] = 0x77d1;
	__map_gbk2utf16[0x3153] = 0x77d2;
	__map_gbk2utf16[0x3154] = 0x77d3;
	__map_gbk2utf16[0x3155] = 0x77d4;
	__map_gbk2utf16[0x3156] = 0x77d5;
	__map_gbk2utf16[0x3157] = 0x77d6;
	__map_gbk2utf16[0x3158] = 0x77d8;
	__map_gbk2utf16[0x3159] = 0x77d9;
	__map_gbk2utf16[0x315a] = 0x77da;
	__map_gbk2utf16[0x315b] = 0x77dd;
	__map_gbk2utf16[0x315c] = 0x77de;
	__map_gbk2utf16[0x315d] = 0x77df;
	__map_gbk2utf16[0x315e] = 0x77e0;
	__map_gbk2utf16[0x315f] = 0x77e1;
	__map_gbk2utf16[0x3160] = 0x77e4;
	__map_gbk2utf16[0x3161] = 0x75c5;
	__map_gbk2utf16[0x3162] = 0x5e76;
	__map_gbk2utf16[0x3163] = 0x73bb;
	__map_gbk2utf16[0x3164] = 0x83e0;
	__map_gbk2utf16[0x3165] = 0x64ad;
	__map_gbk2utf16[0x3166] = 0x62e8;
	__map_gbk2utf16[0x3167] = 0x94b5;
	__map_gbk2utf16[0x3168] = 0x6ce2;
	__map_gbk2utf16[0x3169] = 0x535a;
	__map_gbk2utf16[0x316a] = 0x52c3;
	__map_gbk2utf16[0x316b] = 0x640f;
	__map_gbk2utf16[0x316c] = 0x94c2;
	__map_gbk2utf16[0x316d] = 0x7b94;
	__map_gbk2utf16[0x316e] = 0x4f2f;
	__map_gbk2utf16[0x316f] = 0x5e1b;
	__map_gbk2utf16[0x3170] = 0x8236;
	__map_gbk2utf16[0x3171] = 0x8116;
	__map_gbk2utf16[0x3172] = 0x818a;
	__map_gbk2utf16[0x3173] = 0x6e24;
	__map_gbk2utf16[0x3174] = 0x6cca;
	__map_gbk2utf16[0x3175] = 0x9a73;
	__map_gbk2utf16[0x3176] = 0x6355;
	__map_gbk2utf16[0x3177] = 0x535c;
	__map_gbk2utf16[0x3178] = 0x54fa;
	__map_gbk2utf16[0x3179] = 0x8865;
	__map_gbk2utf16[0x317a] = 0x57e0;
	__map_gbk2utf16[0x317b] = 0x4e0d;
	__map_gbk2utf16[0x317c] = 0x5e03;
	__map_gbk2utf16[0x317d] = 0x6b65;
	__map_gbk2utf16[0x317e] = 0x7c3f;
	__map_gbk2utf16[0x317f] = 0x90e8;
	__map_gbk2utf16[0x3180] = 0x6016;
	__map_gbk2utf16[0x3181] = 0x64e6;
	__map_gbk2utf16[0x3182] = 0x731c;
	__map_gbk2utf16[0x3183] = 0x88c1;
	__map_gbk2utf16[0x3184] = 0x6750;
	__map_gbk2utf16[0x3185] = 0x624d;
	__map_gbk2utf16[0x3186] = 0x8d22;
	__map_gbk2utf16[0x3187] = 0x776c;
	__map_gbk2utf16[0x3188] = 0x8e29;
	__map_gbk2utf16[0x3189] = 0x91c7;
	__map_gbk2utf16[0x318a] = 0x5f69;
	__map_gbk2utf16[0x318b] = 0x83dc;
	__map_gbk2utf16[0x318c] = 0x8521;
	__map_gbk2utf16[0x318d] = 0x9910;
	__map_gbk2utf16[0x318e] = 0x53c2;
	__map_gbk2utf16[0x318f] = 0x8695;
	__map_gbk2utf16[0x3190] = 0x6b8b;
	__map_gbk2utf16[0x3191] = 0x60ed;
	__map_gbk2utf16[0x3192] = 0x60e8;
	__map_gbk2utf16[0x3193] = 0x707f;
	__map_gbk2utf16[0x3194] = 0x82cd;
	__map_gbk2utf16[0x3195] = 0x8231;
	__map_gbk2utf16[0x3196] = 0x4ed3;
	__map_gbk2utf16[0x3197] = 0x6ca7;
	__map_gbk2utf16[0x3198] = 0x85cf;
	__map_gbk2utf16[0x3199] = 0x64cd;
	__map_gbk2utf16[0x319a] = 0x7cd9;
	__map_gbk2utf16[0x319b] = 0x69fd;
	__map_gbk2utf16[0x319c] = 0x66f9;
	__map_gbk2utf16[0x319d] = 0x8349;
	__map_gbk2utf16[0x319e] = 0x5395;
	__map_gbk2utf16[0x319f] = 0x7b56;
	__map_gbk2utf16[0x31a0] = 0x4fa7;
	__map_gbk2utf16[0x31a1] = 0x518c;
	__map_gbk2utf16[0x31a2] = 0x6d4b;
	__map_gbk2utf16[0x31a3] = 0x5c42;
	__map_gbk2utf16[0x31a4] = 0x8e6d;
	__map_gbk2utf16[0x31a5] = 0x63d2;
	__map_gbk2utf16[0x31a6] = 0x53c9;
	__map_gbk2utf16[0x31a7] = 0x832c;
	__map_gbk2utf16[0x31a8] = 0x8336;
	__map_gbk2utf16[0x31a9] = 0x67e5;
	__map_gbk2utf16[0x31aa] = 0x78b4;
	__map_gbk2utf16[0x31ab] = 0x643d;
	__map_gbk2utf16[0x31ac] = 0x5bdf;
	__map_gbk2utf16[0x31ad] = 0x5c94;
	__map_gbk2utf16[0x31ae] = 0x5dee;
	__map_gbk2utf16[0x31af] = 0x8be7;
	__map_gbk2utf16[0x31b0] = 0x62c6;
	__map_gbk2utf16[0x31b1] = 0x67f4;
	__map_gbk2utf16[0x31b2] = 0x8c7a;
	__map_gbk2utf16[0x31b3] = 0x6400;
	__map_gbk2utf16[0x31b4] = 0x63ba;
	__map_gbk2utf16[0x31b5] = 0x8749;
	__map_gbk2utf16[0x31b6] = 0x998b;
	__map_gbk2utf16[0x31b7] = 0x8c17;
	__map_gbk2utf16[0x31b8] = 0x7f20;
	__map_gbk2utf16[0x31b9] = 0x94f2;
	__map_gbk2utf16[0x31ba] = 0x4ea7;
	__map_gbk2utf16[0x31bb] = 0x9610;
	__map_gbk2utf16[0x31bc] = 0x98a4;
	__map_gbk2utf16[0x31bd] = 0x660c;
	__map_gbk2utf16[0x31be] = 0x7316;
	__map_gbk2utf16[0x3200] = 0x77e6;
	__map_gbk2utf16[0x3201] = 0x77e8;
	__map_gbk2utf16[0x3202] = 0x77ea;
	__map_gbk2utf16[0x3203] = 0x77ef;
	__map_gbk2utf16[0x3204] = 0x77f0;
	__map_gbk2utf16[0x3205] = 0x77f1;
	__map_gbk2utf16[0x3206] = 0x77f2;
	__map_gbk2utf16[0x3207] = 0x77f4;
	__map_gbk2utf16[0x3208] = 0x77f5;
	__map_gbk2utf16[0x3209] = 0x77f7;
	__map_gbk2utf16[0x320a] = 0x77f9;
	__map_gbk2utf16[0x320b] = 0x77fa;
	__map_gbk2utf16[0x320c] = 0x77fb;
	__map_gbk2utf16[0x320d] = 0x77fc;
	__map_gbk2utf16[0x320e] = 0x7803;
	__map_gbk2utf16[0x320f] = 0x7804;
	__map_gbk2utf16[0x3210] = 0x7805;
	__map_gbk2utf16[0x3211] = 0x7806;
	__map_gbk2utf16[0x3212] = 0x7807;
	__map_gbk2utf16[0x3213] = 0x7808;
	__map_gbk2utf16[0x3214] = 0x780a;
	__map_gbk2utf16[0x3215] = 0x780b;
	__map_gbk2utf16[0x3216] = 0x780e;
	__map_gbk2utf16[0x3217] = 0x780f;
	__map_gbk2utf16[0x3218] = 0x7810;
	__map_gbk2utf16[0x3219] = 0x7813;
	__map_gbk2utf16[0x321a] = 0x7815;
	__map_gbk2utf16[0x321b] = 0x7819;
	__map_gbk2utf16[0x321c] = 0x781b;
	__map_gbk2utf16[0x321d] = 0x781e;
	__map_gbk2utf16[0x321e] = 0x7820;
	__map_gbk2utf16[0x321f] = 0x7821;
	__map_gbk2utf16[0x3220] = 0x7822;
	__map_gbk2utf16[0x3221] = 0x7824;
	__map_gbk2utf16[0x3222] = 0x7828;
	__map_gbk2utf16[0x3223] = 0x782a;
	__map_gbk2utf16[0x3224] = 0x782b;
	__map_gbk2utf16[0x3225] = 0x782e;
	__map_gbk2utf16[0x3226] = 0x782f;
	__map_gbk2utf16[0x3227] = 0x7831;
	__map_gbk2utf16[0x3228] = 0x7832;
	__map_gbk2utf16[0x3229] = 0x7833;
	__map_gbk2utf16[0x322a] = 0x7835;
	__map_gbk2utf16[0x322b] = 0x7836;
	__map_gbk2utf16[0x322c] = 0x783d;
	__map_gbk2utf16[0x322d] = 0x783f;
	__map_gbk2utf16[0x322e] = 0x7841;
	__map_gbk2utf16[0x322f] = 0x7842;
	__map_gbk2utf16[0x3230] = 0x7843;
	__map_gbk2utf16[0x3231] = 0x7844;
	__map_gbk2utf16[0x3232] = 0x7846;
	__map_gbk2utf16[0x3233] = 0x7848;
	__map_gbk2utf16[0x3234] = 0x7849;
	__map_gbk2utf16[0x3235] = 0x784a;
	__map_gbk2utf16[0x3236] = 0x784b;
	__map_gbk2utf16[0x3237] = 0x784d;
	__map_gbk2utf16[0x3238] = 0x784f;
	__map_gbk2utf16[0x3239] = 0x7851;
	__map_gbk2utf16[0x323a] = 0x7853;
	__map_gbk2utf16[0x323b] = 0x7854;
	__map_gbk2utf16[0x323c] = 0x7858;
	__map_gbk2utf16[0x323d] = 0x7859;
	__map_gbk2utf16[0x323e] = 0x785a;
	__map_gbk2utf16[0x3240] = 0x785b;
	__map_gbk2utf16[0x3241] = 0x785c;
	__map_gbk2utf16[0x3242] = 0x785e;
	__map_gbk2utf16[0x3243] = 0x785f;
	__map_gbk2utf16[0x3244] = 0x7860;
	__map_gbk2utf16[0x3245] = 0x7861;
	__map_gbk2utf16[0x3246] = 0x7862;
	__map_gbk2utf16[0x3247] = 0x7863;
	__map_gbk2utf16[0x3248] = 0x7864;
	__map_gbk2utf16[0x3249] = 0x7865;
	__map_gbk2utf16[0x324a] = 0x7866;
	__map_gbk2utf16[0x324b] = 0x7867;
	__map_gbk2utf16[0x324c] = 0x7868;
	__map_gbk2utf16[0x324d] = 0x7869;
	__map_gbk2utf16[0x324e] = 0x786f;
	__map_gbk2utf16[0x324f] = 0x7870;
	__map_gbk2utf16[0x3250] = 0x7871;
	__map_gbk2utf16[0x3251] = 0x7872;
	__map_gbk2utf16[0x3252] = 0x7873;
	__map_gbk2utf16[0x3253] = 0x7874;
	__map_gbk2utf16[0x3254] = 0x7875;
	__map_gbk2utf16[0x3255] = 0x7876;
	__map_gbk2utf16[0x3256] = 0x7878;
	__map_gbk2utf16[0x3257] = 0x7879;
	__map_gbk2utf16[0x3258] = 0x787a;
	__map_gbk2utf16[0x3259] = 0x787b;
	__map_gbk2utf16[0x325a] = 0x787d;
	__map_gbk2utf16[0x325b] = 0x787e;
	__map_gbk2utf16[0x325c] = 0x787f;
	__map_gbk2utf16[0x325d] = 0x7880;
	__map_gbk2utf16[0x325e] = 0x7881;
	__map_gbk2utf16[0x325f] = 0x7882;
	__map_gbk2utf16[0x3260] = 0x7883;
	__map_gbk2utf16[0x3261] = 0x573a;
	__map_gbk2utf16[0x3262] = 0x5c1d;
	__map_gbk2utf16[0x3263] = 0x5e38;
	__map_gbk2utf16[0x3264] = 0x957f;
	__map_gbk2utf16[0x3265] = 0x507f;
	__map_gbk2utf16[0x3266] = 0x80a0;
	__map_gbk2utf16[0x3267] = 0x5382;
	__map_gbk2utf16[0x3268] = 0x655e;
	__map_gbk2utf16[0x3269] = 0x7545;
	__map_gbk2utf16[0x326a] = 0x5531;
	__map_gbk2utf16[0x326b] = 0x5021;
	__map_gbk2utf16[0x326c] = 0x8d85;
	__map_gbk2utf16[0x326d] = 0x6284;
	__map_gbk2utf16[0x326e] = 0x949e;
	__map_gbk2utf16[0x326f] = 0x671d;
	__map_gbk2utf16[0x3270] = 0x5632;
	__map_gbk2utf16[0x3271] = 0x6f6e;
	__map_gbk2utf16[0x3272] = 0x5de2;
	__map_gbk2utf16[0x3273] = 0x5435;
	__map_gbk2utf16[0x3274] = 0x7092;
	__map_gbk2utf16[0x3275] = 0x8f66;
	__map_gbk2utf16[0x3276] = 0x626f;
	__map_gbk2utf16[0x3277] = 0x64a4;
	__map_gbk2utf16[0x3278] = 0x63a3;
	__map_gbk2utf16[0x3279] = 0x5f7b;
	__map_gbk2utf16[0x327a] = 0x6f88;
	__map_gbk2utf16[0x327b] = 0x90f4;
	__map_gbk2utf16[0x327c] = 0x81e3;
	__map_gbk2utf16[0x327d] = 0x8fb0;
	__map_gbk2utf16[0x327e] = 0x5c18;
	__map_gbk2utf16[0x327f] = 0x6668;
	__map_gbk2utf16[0x3280] = 0x5ff1;
	__map_gbk2utf16[0x3281] = 0x6c89;
	__map_gbk2utf16[0x3282] = 0x9648;
	__map_gbk2utf16[0x3283] = 0x8d81;
	__map_gbk2utf16[0x3284] = 0x886c;
	__map_gbk2utf16[0x3285] = 0x6491;
	__map_gbk2utf16[0x3286] = 0x79f0;
	__map_gbk2utf16[0x3287] = 0x57ce;
	__map_gbk2utf16[0x3288] = 0x6a59;
	__map_gbk2utf16[0x3289] = 0x6210;
	__map_gbk2utf16[0x328a] = 0x5448;
	__map_gbk2utf16[0x328b] = 0x4e58;
	__map_gbk2utf16[0x328c] = 0x7a0b;
	__map_gbk2utf16[0x328d] = 0x60e9;
	__map_gbk2utf16[0x328e] = 0x6f84;
	__map_gbk2utf16[0x328f] = 0x8bda;
	__map_gbk2utf16[0x3290] = 0x627f;
	__map_gbk2utf16[0x3291] = 0x901e;
	__map_gbk2utf16[0x3292] = 0x9a8b;
	__map_gbk2utf16[0x3293] = 0x79e4;
	__map_gbk2utf16[0x3294] = 0x5403;
	__map_gbk2utf16[0x3295] = 0x75f4;
	__map_gbk2utf16[0x3296] = 0x6301;
	__map_gbk2utf16[0x3297] = 0x5319;
	__map_gbk2utf16[0x3298] = 0x6c60;
	__map_gbk2utf16[0x3299] = 0x8fdf;
	__map_gbk2utf16[0x329a] = 0x5f1b;
	__map_gbk2utf16[0x329b] = 0x9a70;
	__map_gbk2utf16[0x329c] = 0x803b;
	__map_gbk2utf16[0x329d] = 0x9f7f;
	__map_gbk2utf16[0x329e] = 0x4f88;
	__map_gbk2utf16[0x329f] = 0x5c3a;
	__map_gbk2utf16[0x32a0] = 0x8d64;
	__map_gbk2utf16[0x32a1] = 0x7fc5;
	__map_gbk2utf16[0x32a2] = 0x65a5;
	__map_gbk2utf16[0x32a3] = 0x70bd;
	__map_gbk2utf16[0x32a4] = 0x5145;
	__map_gbk2utf16[0x32a5] = 0x51b2;
	__map_gbk2utf16[0x32a6] = 0x866b;
	__map_gbk2utf16[0x32a7] = 0x5d07;
	__map_gbk2utf16[0x32a8] = 0x5ba0;
	__map_gbk2utf16[0x32a9] = 0x62bd;
	__map_gbk2utf16[0x32aa] = 0x916c;
	__map_gbk2utf16[0x32ab] = 0x7574;
	__map_gbk2utf16[0x32ac] = 0x8e0c;
	__map_gbk2utf16[0x32ad] = 0x7a20;
	__map_gbk2utf16[0x32ae] = 0x6101;
	__map_gbk2utf16[0x32af] = 0x7b79;
	__map_gbk2utf16[0x32b0] = 0x4ec7;
	__map_gbk2utf16[0x32b1] = 0x7ef8;
	__map_gbk2utf16[0x32b2] = 0x7785;
	__map_gbk2utf16[0x32b3] = 0x4e11;
	__map_gbk2utf16[0x32b4] = 0x81ed;
	__map_gbk2utf16[0x32b5] = 0x521d;
	__map_gbk2utf16[0x32b6] = 0x51fa;
	__map_gbk2utf16[0x32b7] = 0x6a71;
	__map_gbk2utf16[0x32b8] = 0x53a8;
	__map_gbk2utf16[0x32b9] = 0x8e87;
	__map_gbk2utf16[0x32ba] = 0x9504;
	__map_gbk2utf16[0x32bb] = 0x96cf;
	__map_gbk2utf16[0x32bc] = 0x6ec1;
	__map_gbk2utf16[0x32bd] = 0x9664;
	__map_gbk2utf16[0x32be] = 0x695a;
	__map_gbk2utf16[0x3300] = 0x7884;
	__map_gbk2utf16[0x3301] = 0x7885;
	__map_gbk2utf16[0x3302] = 0x7886;
	__map_gbk2utf16[0x3303] = 0x7888;
	__map_gbk2utf16[0x3304] = 0x788a;
	__map_gbk2utf16[0x3305] = 0x788b;
	__map_gbk2utf16[0x3306] = 0x788f;
	__map_gbk2utf16[0x3307] = 0x7890;
	__map_gbk2utf16[0x3308] = 0x7892;
	__map_gbk2utf16[0x3309] = 0x7894;
	__map_gbk2utf16[0x330a] = 0x7895;
	__map_gbk2utf16[0x330b] = 0x7896;
	__map_gbk2utf16[0x330c] = 0x7899;
	__map_gbk2utf16[0x330d] = 0x789d;
	__map_gbk2utf16[0x330e] = 0x789e;
	__map_gbk2utf16[0x330f] = 0x78a0;
	__map_gbk2utf16[0x3310] = 0x78a2;
	__map_gbk2utf16[0x3311] = 0x78a4;
	__map_gbk2utf16[0x3312] = 0x78a6;
	__map_gbk2utf16[0x3313] = 0x78a8;
	__map_gbk2utf16[0x3314] = 0x78a9;
	__map_gbk2utf16[0x3315] = 0x78aa;
	__map_gbk2utf16[0x3316] = 0x78ab;
	__map_gbk2utf16[0x3317] = 0x78ac;
	__map_gbk2utf16[0x3318] = 0x78ad;
	__map_gbk2utf16[0x3319] = 0x78ae;
	__map_gbk2utf16[0x331a] = 0x78af;
	__map_gbk2utf16[0x331b] = 0x78b5;
	__map_gbk2utf16[0x331c] = 0x78b6;
	__map_gbk2utf16[0x331d] = 0x78b7;
	__map_gbk2utf16[0x331e] = 0x78b8;
	__map_gbk2utf16[0x331f] = 0x78ba;
	__map_gbk2utf16[0x3320] = 0x78bb;
	__map_gbk2utf16[0x3321] = 0x78bc;
	__map_gbk2utf16[0x3322] = 0x78bd;
	__map_gbk2utf16[0x3323] = 0x78bf;
	__map_gbk2utf16[0x3324] = 0x78c0;
	__map_gbk2utf16[0x3325] = 0x78c2;
	__map_gbk2utf16[0x3326] = 0x78c3;
	__map_gbk2utf16[0x3327] = 0x78c4;
	__map_gbk2utf16[0x3328] = 0x78c6;
	__map_gbk2utf16[0x3329] = 0x78c7;
	__map_gbk2utf16[0x332a] = 0x78c8;
	__map_gbk2utf16[0x332b] = 0x78cc;
	__map_gbk2utf16[0x332c] = 0x78cd;
	__map_gbk2utf16[0x332d] = 0x78ce;
	__map_gbk2utf16[0x332e] = 0x78cf;
	__map_gbk2utf16[0x332f] = 0x78d1;
	__map_gbk2utf16[0x3330] = 0x78d2;
	__map_gbk2utf16[0x3331] = 0x78d3;
	__map_gbk2utf16[0x3332] = 0x78d6;
	__map_gbk2utf16[0x3333] = 0x78d7;
	__map_gbk2utf16[0x3334] = 0x78d8;
	__map_gbk2utf16[0x3335] = 0x78da;
	__map_gbk2utf16[0x3336] = 0x78db;
	__map_gbk2utf16[0x3337] = 0x78dc;
	__map_gbk2utf16[0x3338] = 0x78dd;
	__map_gbk2utf16[0x3339] = 0x78de;
	__map_gbk2utf16[0x333a] = 0x78df;
	__map_gbk2utf16[0x333b] = 0x78e0;
	__map_gbk2utf16[0x333c] = 0x78e1;
	__map_gbk2utf16[0x333d] = 0x78e2;
	__map_gbk2utf16[0x333e] = 0x78e3;
	__map_gbk2utf16[0x3340] = 0x78e4;
	__map_gbk2utf16[0x3341] = 0x78e5;
	__map_gbk2utf16[0x3342] = 0x78e6;
	__map_gbk2utf16[0x3343] = 0x78e7;
	__map_gbk2utf16[0x3344] = 0x78e9;
	__map_gbk2utf16[0x3345] = 0x78ea;
	__map_gbk2utf16[0x3346] = 0x78eb;
	__map_gbk2utf16[0x3347] = 0x78ed;
	__map_gbk2utf16[0x3348] = 0x78ee;
	__map_gbk2utf16[0x3349] = 0x78ef;
	__map_gbk2utf16[0x334a] = 0x78f0;
	__map_gbk2utf16[0x334b] = 0x78f1;
	__map_gbk2utf16[0x334c] = 0x78f3;
	__map_gbk2utf16[0x334d] = 0x78f5;
	__map_gbk2utf16[0x334e] = 0x78f6;
	__map_gbk2utf16[0x334f] = 0x78f8;
	__map_gbk2utf16[0x3350] = 0x78f9;
	__map_gbk2utf16[0x3351] = 0x78fb;
	__map_gbk2utf16[0x3352] = 0x78fc;
	__map_gbk2utf16[0x3353] = 0x78fd;
	__map_gbk2utf16[0x3354] = 0x78fe;
	__map_gbk2utf16[0x3355] = 0x78ff;
	__map_gbk2utf16[0x3356] = 0x7900;
	__map_gbk2utf16[0x3357] = 0x7902;
	__map_gbk2utf16[0x3358] = 0x7903;
	__map_gbk2utf16[0x3359] = 0x7904;
	__map_gbk2utf16[0x335a] = 0x7906;
	__map_gbk2utf16[0x335b] = 0x7907;
	__map_gbk2utf16[0x335c] = 0x7908;
	__map_gbk2utf16[0x335d] = 0x7909;
	__map_gbk2utf16[0x335e] = 0x790a;
	__map_gbk2utf16[0x335f] = 0x790b;
	__map_gbk2utf16[0x3360] = 0x790c;
	__map_gbk2utf16[0x3361] = 0x7840;
	__map_gbk2utf16[0x3362] = 0x50a8;
	__map_gbk2utf16[0x3363] = 0x77d7;
	__map_gbk2utf16[0x3364] = 0x6410;
	__map_gbk2utf16[0x3365] = 0x89e6;
	__map_gbk2utf16[0x3366] = 0x5904;
	__map_gbk2utf16[0x3367] = 0x63e3;
	__map_gbk2utf16[0x3368] = 0x5ddd;
	__map_gbk2utf16[0x3369] = 0x7a7f;
	__map_gbk2utf16[0x336a] = 0x693d;
	__map_gbk2utf16[0x336b] = 0x4f20;
	__map_gbk2utf16[0x336c] = 0x8239;
	__map_gbk2utf16[0x336d] = 0x5598;
	__map_gbk2utf16[0x336e] = 0x4e32;
	__map_gbk2utf16[0x336f] = 0x75ae;
	__map_gbk2utf16[0x3370] = 0x7a97;
	__map_gbk2utf16[0x3371] = 0x5e62;
	__map_gbk2utf16[0x3372] = 0x5e8a;
	__map_gbk2utf16[0x3373] = 0x95ef;
	__map_gbk2utf16[0x3374] = 0x521b;
	__map_gbk2utf16[0x3375] = 0x5439;
	__map_gbk2utf16[0x3376] = 0x708a;
	__map_gbk2utf16[0x3377] = 0x6376;
	__map_gbk2utf16[0x3378] = 0x9524;
	__map_gbk2utf16[0x3379] = 0x5782;
	__map_gbk2utf16[0x337a] = 0x6625;
	__map_gbk2utf16[0x337b] = 0x693f;
	__map_gbk2utf16[0x337c] = 0x9187;
	__map_gbk2utf16[0x337d] = 0x5507;
	__map_gbk2utf16[0x337e] = 0x6df3;
	__map_gbk2utf16[0x337f] = 0x7eaf;
	__map_gbk2utf16[0x3380] = 0x8822;
	__map_gbk2utf16[0x3381] = 0x6233;
	__map_gbk2utf16[0x3382] = 0x7ef0;
	__map_gbk2utf16[0x3383] = 0x75b5;
	__map_gbk2utf16[0x3384] = 0x8328;
	__map_gbk2utf16[0x3385] = 0x78c1;
	__map_gbk2utf16[0x3386] = 0x96cc;
	__map_gbk2utf16[0x3387] = 0x8f9e;
	__map_gbk2utf16[0x3388] = 0x6148;
	__map_gbk2utf16[0x3389] = 0x74f7;
	__map_gbk2utf16[0x338a] = 0x8bcd;
	__map_gbk2utf16[0x338b] = 0x6b64;
	__map_gbk2utf16[0x338c] = 0x523a;
	__map_gbk2utf16[0x338d] = 0x8d50;
	__map_gbk2utf16[0x338e] = 0x6b21;
	__map_gbk2utf16[0x338f] = 0x806a;
	__map_gbk2utf16[0x3390] = 0x8471;
	__map_gbk2utf16[0x3391] = 0x56f1;
	__map_gbk2utf16[0x3392] = 0x5306;
	__map_gbk2utf16[0x3393] = 0x4ece;
	__map_gbk2utf16[0x3394] = 0x4e1b;
	__map_gbk2utf16[0x3395] = 0x51d1;
	__map_gbk2utf16[0x3396] = 0x7c97;
	__map_gbk2utf16[0x3397] = 0x918b;
	__map_gbk2utf16[0x3398] = 0x7c07;
	__map_gbk2utf16[0x3399] = 0x4fc3;
	__map_gbk2utf16[0x339a] = 0x8e7f;
	__map_gbk2utf16[0x339b] = 0x7be1;
	__map_gbk2utf16[0x339c] = 0x7a9c;
	__map_gbk2utf16[0x339d] = 0x6467;
	__map_gbk2utf16[0x339e] = 0x5d14;
	__map_gbk2utf16[0x339f] = 0x50ac;
	__map_gbk2utf16[0x33a0] = 0x8106;
	__map_gbk2utf16[0x33a1] = 0x7601;
	__map_gbk2utf16[0x33a2] = 0x7cb9;
	__map_gbk2utf16[0x33a3] = 0x6dec;
	__map_gbk2utf16[0x33a4] = 0x7fe0;
	__map_gbk2utf16[0x33a5] = 0x6751;
	__map_gbk2utf16[0x33a6] = 0x5b58;
	__map_gbk2utf16[0x33a7] = 0x5bf8;
	__map_gbk2utf16[0x33a8] = 0x78cb;
	__map_gbk2utf16[0x33a9] = 0x64ae;
	__map_gbk2utf16[0x33aa] = 0x6413;
	__map_gbk2utf16[0x33ab] = 0x63aa;
	__map_gbk2utf16[0x33ac] = 0x632b;
	__map_gbk2utf16[0x33ad] = 0x9519;
	__map_gbk2utf16[0x33ae] = 0x642d;
	__map_gbk2utf16[0x33af] = 0x8fbe;
	__map_gbk2utf16[0x33b0] = 0x7b54;
	__map_gbk2utf16[0x33b1] = 0x7629;
	__map_gbk2utf16[0x33b2] = 0x6253;
	__map_gbk2utf16[0x33b3] = 0x5927;
	__map_gbk2utf16[0x33b4] = 0x5446;
	__map_gbk2utf16[0x33b5] = 0x6b79;
	__map_gbk2utf16[0x33b6] = 0x50a3;
	__map_gbk2utf16[0x33b7] = 0x6234;
	__map_gbk2utf16[0x33b8] = 0x5e26;
	__map_gbk2utf16[0x33b9] = 0x6b86;
	__map_gbk2utf16[0x33ba] = 0x4ee3;
	__map_gbk2utf16[0x33bb] = 0x8d37;
	__map_gbk2utf16[0x33bc] = 0x888b;
	__map_gbk2utf16[0x33bd] = 0x5f85;
	__map_gbk2utf16[0x33be] = 0x902e;
	__map_gbk2utf16[0x3400] = 0x790d;
	__map_gbk2utf16[0x3401] = 0x790e;
	__map_gbk2utf16[0x3402] = 0x790f;
	__map_gbk2utf16[0x3403] = 0x7910;
	__map_gbk2utf16[0x3404] = 0x7911;
	__map_gbk2utf16[0x3405] = 0x7912;
	__map_gbk2utf16[0x3406] = 0x7914;
	__map_gbk2utf16[0x3407] = 0x7915;
	__map_gbk2utf16[0x3408] = 0x7916;
	__map_gbk2utf16[0x3409] = 0x7917;
	__map_gbk2utf16[0x340a] = 0x7918;
	__map_gbk2utf16[0x340b] = 0x7919;
	__map_gbk2utf16[0x340c] = 0x791a;
	__map_gbk2utf16[0x340d] = 0x791b;
	__map_gbk2utf16[0x340e] = 0x791c;
	__map_gbk2utf16[0x340f] = 0x791d;
	__map_gbk2utf16[0x3410] = 0x791f;
	__map_gbk2utf16[0x3411] = 0x7920;
	__map_gbk2utf16[0x3412] = 0x7921;
	__map_gbk2utf16[0x3413] = 0x7922;
	__map_gbk2utf16[0x3414] = 0x7923;
	__map_gbk2utf16[0x3415] = 0x7925;
	__map_gbk2utf16[0x3416] = 0x7926;
	__map_gbk2utf16[0x3417] = 0x7927;
	__map_gbk2utf16[0x3418] = 0x7928;
	__map_gbk2utf16[0x3419] = 0x7929;
	__map_gbk2utf16[0x341a] = 0x792a;
	__map_gbk2utf16[0x341b] = 0x792b;
	__map_gbk2utf16[0x341c] = 0x792c;
	__map_gbk2utf16[0x341d] = 0x792d;
	__map_gbk2utf16[0x341e] = 0x792e;
	__map_gbk2utf16[0x341f] = 0x792f;
	__map_gbk2utf16[0x3420] = 0x7930;
	__map_gbk2utf16[0x3421] = 0x7931;
	__map_gbk2utf16[0x3422] = 0x7932;
	__map_gbk2utf16[0x3423] = 0x7933;
	__map_gbk2utf16[0x3424] = 0x7935;
	__map_gbk2utf16[0x3425] = 0x7936;
	__map_gbk2utf16[0x3426] = 0x7937;
	__map_gbk2utf16[0x3427] = 0x7938;
	__map_gbk2utf16[0x3428] = 0x7939;
	__map_gbk2utf16[0x3429] = 0x793d;
	__map_gbk2utf16[0x342a] = 0x793f;
	__map_gbk2utf16[0x342b] = 0x7942;
	__map_gbk2utf16[0x342c] = 0x7943;
	__map_gbk2utf16[0x342d] = 0x7944;
	__map_gbk2utf16[0x342e] = 0x7945;
	__map_gbk2utf16[0x342f] = 0x7947;
	__map_gbk2utf16[0x3430] = 0x794a;
	__map_gbk2utf16[0x3431] = 0x794b;
	__map_gbk2utf16[0x3432] = 0x794c;
	__map_gbk2utf16[0x3433] = 0x794d;
	__map_gbk2utf16[0x3434] = 0x794e;
	__map_gbk2utf16[0x3435] = 0x794f;
	__map_gbk2utf16[0x3436] = 0x7950;
	__map_gbk2utf16[0x3437] = 0x7951;
	__map_gbk2utf16[0x3438] = 0x7952;
	__map_gbk2utf16[0x3439] = 0x7954;
	__map_gbk2utf16[0x343a] = 0x7955;
	__map_gbk2utf16[0x343b] = 0x7958;
	__map_gbk2utf16[0x343c] = 0x7959;
	__map_gbk2utf16[0x343d] = 0x7961;
	__map_gbk2utf16[0x343e] = 0x7963;
	__map_gbk2utf16[0x3440] = 0x7964;
	__map_gbk2utf16[0x3441] = 0x7966;
	__map_gbk2utf16[0x3442] = 0x7969;
	__map_gbk2utf16[0x3443] = 0x796a;
	__map_gbk2utf16[0x3444] = 0x796b;
	__map_gbk2utf16[0x3445] = 0x796c;
	__map_gbk2utf16[0x3446] = 0x796e;
	__map_gbk2utf16[0x3447] = 0x7970;
	__map_gbk2utf16[0x3448] = 0x7971;
	__map_gbk2utf16[0x3449] = 0x7972;
	__map_gbk2utf16[0x344a] = 0x7973;
	__map_gbk2utf16[0x344b] = 0x7974;
	__map_gbk2utf16[0x344c] = 0x7975;
	__map_gbk2utf16[0x344d] = 0x7976;
	__map_gbk2utf16[0x344e] = 0x7979;
	__map_gbk2utf16[0x344f] = 0x797b;
	__map_gbk2utf16[0x3450] = 0x797c;
	__map_gbk2utf16[0x3451] = 0x797d;
	__map_gbk2utf16[0x3452] = 0x797e;
	__map_gbk2utf16[0x3453] = 0x797f;
	__map_gbk2utf16[0x3454] = 0x7982;
	__map_gbk2utf16[0x3455] = 0x7983;
	__map_gbk2utf16[0x3456] = 0x7986;
	__map_gbk2utf16[0x3457] = 0x7987;
	__map_gbk2utf16[0x3458] = 0x7988;
	__map_gbk2utf16[0x3459] = 0x7989;
	__map_gbk2utf16[0x345a] = 0x798b;
	__map_gbk2utf16[0x345b] = 0x798c;
	__map_gbk2utf16[0x345c] = 0x798d;
	__map_gbk2utf16[0x345d] = 0x798e;
	__map_gbk2utf16[0x345e] = 0x7990;
	__map_gbk2utf16[0x345f] = 0x7991;
	__map_gbk2utf16[0x3460] = 0x7992;
	__map_gbk2utf16[0x3461] = 0x6020;
	__map_gbk2utf16[0x3462] = 0x803d;
	__map_gbk2utf16[0x3463] = 0x62c5;
	__map_gbk2utf16[0x3464] = 0x4e39;
	__map_gbk2utf16[0x3465] = 0x5355;
	__map_gbk2utf16[0x3466] = 0x90f8;
	__map_gbk2utf16[0x3467] = 0x63b8;
	__map_gbk2utf16[0x3468] = 0x80c6;
	__map_gbk2utf16[0x3469] = 0x65e6;
	__map_gbk2utf16[0x346a] = 0x6c2e;
	__map_gbk2utf16[0x346b] = 0x4f46;
	__map_gbk2utf16[0x346c] = 0x60ee;
	__map_gbk2utf16[0x346d] = 0x6de1;
	__map_gbk2utf16[0x346e] = 0x8bde;
	__map_gbk2utf16[0x346f] = 0x5f39;
	__map_gbk2utf16[0x3470] = 0x86cb;
	__map_gbk2utf16[0x3471] = 0x5f53;
	__map_gbk2utf16[0x3472] = 0x6321;
	__map_gbk2utf16[0x3473] = 0x515a;
	__map_gbk2utf16[0x3474] = 0x8361;
	__map_gbk2utf16[0x3475] = 0x6863;
	__map_gbk2utf16[0x3476] = 0x5200;
	__map_gbk2utf16[0x3477] = 0x6363;
	__map_gbk2utf16[0x3478] = 0x8e48;
	__map_gbk2utf16[0x3479] = 0x5012;
	__map_gbk2utf16[0x347a] = 0x5c9b;
	__map_gbk2utf16[0x347b] = 0x7977;
	__map_gbk2utf16[0x347c] = 0x5bfc;
	__map_gbk2utf16[0x347d] = 0x5230;
	__map_gbk2utf16[0x347e] = 0x7a3b;
	__map_gbk2utf16[0x347f] = 0x60bc;
	__map_gbk2utf16[0x3480] = 0x9053;
	__map_gbk2utf16[0x3481] = 0x76d7;
	__map_gbk2utf16[0x3482] = 0x5fb7;
	__map_gbk2utf16[0x3483] = 0x5f97;
	__map_gbk2utf16[0x3484] = 0x7684;
	__map_gbk2utf16[0x3485] = 0x8e6c;
	__map_gbk2utf16[0x3486] = 0x706f;
	__map_gbk2utf16[0x3487] = 0x767b;
	__map_gbk2utf16[0x3488] = 0x7b49;
	__map_gbk2utf16[0x3489] = 0x77aa;
	__map_gbk2utf16[0x348a] = 0x51f3;
	__map_gbk2utf16[0x348b] = 0x9093;
	__map_gbk2utf16[0x348c] = 0x5824;
	__map_gbk2utf16[0x348d] = 0x4f4e;
	__map_gbk2utf16[0x348e] = 0x6ef4;
	__map_gbk2utf16[0x348f] = 0x8fea;
	__map_gbk2utf16[0x3490] = 0x654c;
	__map_gbk2utf16[0x3491] = 0x7b1b;
	__map_gbk2utf16[0x3492] = 0x72c4;
	__map_gbk2utf16[0x3493] = 0x6da4;
	__map_gbk2utf16[0x3494] = 0x7fdf;
	__map_gbk2utf16[0x3495] = 0x5ae1;
	__map_gbk2utf16[0x3496] = 0x62b5;
	__map_gbk2utf16[0x3497] = 0x5e95;
	__map_gbk2utf16[0x3498] = 0x5730;
	__map_gbk2utf16[0x3499] = 0x8482;
	__map_gbk2utf16[0x349a] = 0x7b2c;
	__map_gbk2utf16[0x349b] = 0x5e1d;
	__map_gbk2utf16[0x349c] = 0x5f1f;
	__map_gbk2utf16[0x349d] = 0x9012;
	__map_gbk2utf16[0x349e] = 0x7f14;
	__map_gbk2utf16[0x349f] = 0x98a0;
	__map_gbk2utf16[0x34a0] = 0x6382;
	__map_gbk2utf16[0x34a1] = 0x6ec7;
	__map_gbk2utf16[0x34a2] = 0x7898;
	__map_gbk2utf16[0x34a3] = 0x70b9;
	__map_gbk2utf16[0x34a4] = 0x5178;
	__map_gbk2utf16[0x34a5] = 0x975b;
	__map_gbk2utf16[0x34a6] = 0x57ab;
	__map_gbk2utf16[0x34a7] = 0x7535;
	__map_gbk2utf16[0x34a8] = 0x4f43;
	__map_gbk2utf16[0x34a9] = 0x7538;
	__map_gbk2utf16[0x34aa] = 0x5e97;
	__map_gbk2utf16[0x34ab] = 0x60e6;
	__map_gbk2utf16[0x34ac] = 0x5960;
	__map_gbk2utf16[0x34ad] = 0x6dc0;
	__map_gbk2utf16[0x34ae] = 0x6bbf;
	__map_gbk2utf16[0x34af] = 0x7889;
	__map_gbk2utf16[0x34b0] = 0x53fc;
	__map_gbk2utf16[0x34b1] = 0x96d5;
	__map_gbk2utf16[0x34b2] = 0x51cb;
	__map_gbk2utf16[0x34b3] = 0x5201;
	__map_gbk2utf16[0x34b4] = 0x6389;
	__map_gbk2utf16[0x34b5] = 0x540a;
	__map_gbk2utf16[0x34b6] = 0x9493;
	__map_gbk2utf16[0x34b7] = 0x8c03;
	__map_gbk2utf16[0x34b8] = 0x8dcc;
	__map_gbk2utf16[0x34b9] = 0x7239;
	__map_gbk2utf16[0x34ba] = 0x789f;
	__map_gbk2utf16[0x34bb] = 0x8776;
	__map_gbk2utf16[0x34bc] = 0x8fed;
	__map_gbk2utf16[0x34bd] = 0x8c0d;
	__map_gbk2utf16[0x34be] = 0x53e0;
	__map_gbk2utf16[0x3500] = 0x7993;
	__map_gbk2utf16[0x3501] = 0x7994;
	__map_gbk2utf16[0x3502] = 0x7995;
	__map_gbk2utf16[0x3503] = 0x7996;
	__map_gbk2utf16[0x3504] = 0x7997;
	__map_gbk2utf16[0x3505] = 0x7998;
	__map_gbk2utf16[0x3506] = 0x7999;
	__map_gbk2utf16[0x3507] = 0x799b;
	__map_gbk2utf16[0x3508] = 0x799c;
	__map_gbk2utf16[0x3509] = 0x799d;
	__map_gbk2utf16[0x350a] = 0x799e;
	__map_gbk2utf16[0x350b] = 0x799f;
	__map_gbk2utf16[0x350c] = 0x79a0;
	__map_gbk2utf16[0x350d] = 0x79a1;
	__map_gbk2utf16[0x350e] = 0x79a2;
	__map_gbk2utf16[0x350f] = 0x79a3;
	__map_gbk2utf16[0x3510] = 0x79a4;
	__map_gbk2utf16[0x3511] = 0x79a5;
	__map_gbk2utf16[0x3512] = 0x79a6;
	__map_gbk2utf16[0x3513] = 0x79a8;
	__map_gbk2utf16[0x3514] = 0x79a9;
	__map_gbk2utf16[0x3515] = 0x79aa;
	__map_gbk2utf16[0x3516] = 0x79ab;
	__map_gbk2utf16[0x3517] = 0x79ac;
	__map_gbk2utf16[0x3518] = 0x79ad;
	__map_gbk2utf16[0x3519] = 0x79ae;
	__map_gbk2utf16[0x351a] = 0x79af;
	__map_gbk2utf16[0x351b] = 0x79b0;
	__map_gbk2utf16[0x351c] = 0x79b1;
	__map_gbk2utf16[0x351d] = 0x79b2;
	__map_gbk2utf16[0x351e] = 0x79b4;
	__map_gbk2utf16[0x351f] = 0x79b5;
	__map_gbk2utf16[0x3520] = 0x79b6;
	__map_gbk2utf16[0x3521] = 0x79b7;
	__map_gbk2utf16[0x3522] = 0x79b8;
	__map_gbk2utf16[0x3523] = 0x79bc;
	__map_gbk2utf16[0x3524] = 0x79bf;
	__map_gbk2utf16[0x3525] = 0x79c2;
	__map_gbk2utf16[0x3526] = 0x79c4;
	__map_gbk2utf16[0x3527] = 0x79c5;
	__map_gbk2utf16[0x3528] = 0x79c7;
	__map_gbk2utf16[0x3529] = 0x79c8;
	__map_gbk2utf16[0x352a] = 0x79ca;
	__map_gbk2utf16[0x352b] = 0x79cc;
	__map_gbk2utf16[0x352c] = 0x79ce;
	__map_gbk2utf16[0x352d] = 0x79cf;
	__map_gbk2utf16[0x352e] = 0x79d0;
	__map_gbk2utf16[0x352f] = 0x79d3;
	__map_gbk2utf16[0x3530] = 0x79d4;
	__map_gbk2utf16[0x3531] = 0x79d6;
	__map_gbk2utf16[0x3532] = 0x79d7;
	__map_gbk2utf16[0x3533] = 0x79d9;
	__map_gbk2utf16[0x3534] = 0x79da;
	__map_gbk2utf16[0x3535] = 0x79db;
	__map_gbk2utf16[0x3536] = 0x79dc;
	__map_gbk2utf16[0x3537] = 0x79dd;
	__map_gbk2utf16[0x3538] = 0x79de;
	__map_gbk2utf16[0x3539] = 0x79e0;
	__map_gbk2utf16[0x353a] = 0x79e1;
	__map_gbk2utf16[0x353b] = 0x79e2;
	__map_gbk2utf16[0x353c] = 0x79e5;
	__map_gbk2utf16[0x353d] = 0x79e8;
	__map_gbk2utf16[0x353e] = 0x79ea;
	__map_gbk2utf16[0x3540] = 0x79ec;
	__map_gbk2utf16[0x3541] = 0x79ee;
	__map_gbk2utf16[0x3542] = 0x79f1;
	__map_gbk2utf16[0x3543] = 0x79f2;
	__map_gbk2utf16[0x3544] = 0x79f3;
	__map_gbk2utf16[0x3545] = 0x79f4;
	__map_gbk2utf16[0x3546] = 0x79f5;
	__map_gbk2utf16[0x3547] = 0x79f6;
	__map_gbk2utf16[0x3548] = 0x79f7;
	__map_gbk2utf16[0x3549] = 0x79f9;
	__map_gbk2utf16[0x354a] = 0x79fa;
	__map_gbk2utf16[0x354b] = 0x79fc;
	__map_gbk2utf16[0x354c] = 0x79fe;
	__map_gbk2utf16[0x354d] = 0x79ff;
	__map_gbk2utf16[0x354e] = 0x7a01;
	__map_gbk2utf16[0x354f] = 0x7a04;
	__map_gbk2utf16[0x3550] = 0x7a05;
	__map_gbk2utf16[0x3551] = 0x7a07;
	__map_gbk2utf16[0x3552] = 0x7a08;
	__map_gbk2utf16[0x3553] = 0x7a09;
	__map_gbk2utf16[0x3554] = 0x7a0a;
	__map_gbk2utf16[0x3555] = 0x7a0c;
	__map_gbk2utf16[0x3556] = 0x7a0f;
	__map_gbk2utf16[0x3557] = 0x7a10;
	__map_gbk2utf16[0x3558] = 0x7a11;
	__map_gbk2utf16[0x3559] = 0x7a12;
	__map_gbk2utf16[0x355a] = 0x7a13;
	__map_gbk2utf16[0x355b] = 0x7a15;
	__map_gbk2utf16[0x355c] = 0x7a16;
	__map_gbk2utf16[0x355d] = 0x7a18;
	__map_gbk2utf16[0x355e] = 0x7a19;
	__map_gbk2utf16[0x355f] = 0x7a1b;
	__map_gbk2utf16[0x3560] = 0x7a1c;
	__map_gbk2utf16[0x3561] = 0x4e01;
	__map_gbk2utf16[0x3562] = 0x76ef;
	__map_gbk2utf16[0x3563] = 0x53ee;
	__map_gbk2utf16[0x3564] = 0x9489;
	__map_gbk2utf16[0x3565] = 0x9876;
	__map_gbk2utf16[0x3566] = 0x9f0e;
	__map_gbk2utf16[0x3567] = 0x952d;
	__map_gbk2utf16[0x3568] = 0x5b9a;
	__map_gbk2utf16[0x3569] = 0x8ba2;
	__map_gbk2utf16[0x356a] = 0x4e22;
	__map_gbk2utf16[0x356b] = 0x4e1c;
	__map_gbk2utf16[0x356c] = 0x51ac;
	__map_gbk2utf16[0x356d] = 0x8463;
	__map_gbk2utf16[0x356e] = 0x61c2;
	__map_gbk2utf16[0x356f] = 0x52a8;
	__map_gbk2utf16[0x3570] = 0x680b;
	__map_gbk2utf16[0x3571] = 0x4f97;
	__map_gbk2utf16[0x3572] = 0x606b;
	__map_gbk2utf16[0x3573] = 0x51bb;
	__map_gbk2utf16[0x3574] = 0x6d1e;
	__map_gbk2utf16[0x3575] = 0x515c;
	__map_gbk2utf16[0x3576] = 0x6296;
	__map_gbk2utf16[0x3577] = 0x6597;
	__map_gbk2utf16[0x3578] = 0x9661;
	__map_gbk2utf16[0x3579] = 0x8c46;
	__map_gbk2utf16[0x357a] = 0x9017;
	__map_gbk2utf16[0x357b] = 0x75d8;
	__map_gbk2utf16[0x357c] = 0x90fd;
	__map_gbk2utf16[0x357d] = 0x7763;
	__map_gbk2utf16[0x357e] = 0x6bd2;
	__map_gbk2utf16[0x357f] = 0x728a;
	__map_gbk2utf16[0x3580] = 0x72ec;
	__map_gbk2utf16[0x3581] = 0x8bfb;
	__map_gbk2utf16[0x3582] = 0x5835;
	__map_gbk2utf16[0x3583] = 0x7779;
	__map_gbk2utf16[0x3584] = 0x8d4c;
	__map_gbk2utf16[0x3585] = 0x675c;
	__map_gbk2utf16[0x3586] = 0x9540;
	__map_gbk2utf16[0x3587] = 0x809a;
	__map_gbk2utf16[0x3588] = 0x5ea6;
	__map_gbk2utf16[0x3589] = 0x6e21;
	__map_gbk2utf16[0x358a] = 0x5992;
	__map_gbk2utf16[0x358b] = 0x7aef;
	__map_gbk2utf16[0x358c] = 0x77ed;
	__map_gbk2utf16[0x358d] = 0x953b;
	__map_gbk2utf16[0x358e] = 0x6bb5;
	__map_gbk2utf16[0x358f] = 0x65ad;
	__map_gbk2utf16[0x3590] = 0x7f0e;
	__map_gbk2utf16[0x3591] = 0x5806;
	__map_gbk2utf16[0x3592] = 0x5151;
	__map_gbk2utf16[0x3593] = 0x961f;
	__map_gbk2utf16[0x3594] = 0x5bf9;
	__map_gbk2utf16[0x3595] = 0x58a9;
	__map_gbk2utf16[0x3596] = 0x5428;
	__map_gbk2utf16[0x3597] = 0x8e72;
	__map_gbk2utf16[0x3598] = 0x6566;
	__map_gbk2utf16[0x3599] = 0x987f;
	__map_gbk2utf16[0x359a] = 0x56e4;
	__map_gbk2utf16[0x359b] = 0x949d;
	__map_gbk2utf16[0x359c] = 0x76fe;
	__map_gbk2utf16[0x359d] = 0x9041;
	__map_gbk2utf16[0x359e] = 0x6387;
	__map_gbk2utf16[0x359f] = 0x54c6;
	__map_gbk2utf16[0x35a0] = 0x591a;
	__map_gbk2utf16[0x35a1] = 0x593a;
	__map_gbk2utf16[0x35a2] = 0x579b;
	__map_gbk2utf16[0x35a3] = 0x8eb2;
	__map_gbk2utf16[0x35a4] = 0x6735;
	__map_gbk2utf16[0x35a5] = 0x8dfa;
	__map_gbk2utf16[0x35a6] = 0x8235;
	__map_gbk2utf16[0x35a7] = 0x5241;
	__map_gbk2utf16[0x35a8] = 0x60f0;
	__map_gbk2utf16[0x35a9] = 0x5815;
	__map_gbk2utf16[0x35aa] = 0x86fe;
	__map_gbk2utf16[0x35ab] = 0x5ce8;
	__map_gbk2utf16[0x35ac] = 0x9e45;
	__map_gbk2utf16[0x35ad] = 0x4fc4;
	__map_gbk2utf16[0x35ae] = 0x989d;
	__map_gbk2utf16[0x35af] = 0x8bb9;
	__map_gbk2utf16[0x35b0] = 0x5a25;
	__map_gbk2utf16[0x35b1] = 0x6076;
	__map_gbk2utf16[0x35b2] = 0x5384;
	__map_gbk2utf16[0x35b3] = 0x627c;
	__map_gbk2utf16[0x35b4] = 0x904f;
	__map_gbk2utf16[0x35b5] = 0x9102;
	__map_gbk2utf16[0x35b6] = 0x997f;
	__map_gbk2utf16[0x35b7] = 0x6069;
	__map_gbk2utf16[0x35b8] = 0x800c;
	__map_gbk2utf16[0x35b9] = 0x513f;
	__map_gbk2utf16[0x35ba] = 0x8033;
	__map_gbk2utf16[0x35bb] = 0x5c14;
	__map_gbk2utf16[0x35bc] = 0x9975;
	__map_gbk2utf16[0x35bd] = 0x6d31;
	__map_gbk2utf16[0x35be] = 0x4e8c;
	__map_gbk2utf16[0x3600] = 0x7a1d;
	__map_gbk2utf16[0x3601] = 0x7a1f;
	__map_gbk2utf16[0x3602] = 0x7a21;
	__map_gbk2utf16[0x3603] = 0x7a22;
	__map_gbk2utf16[0x3604] = 0x7a24;
	__map_gbk2utf16[0x3605] = 0x7a25;
	__map_gbk2utf16[0x3606] = 0x7a26;
	__map_gbk2utf16[0x3607] = 0x7a27;
	__map_gbk2utf16[0x3608] = 0x7a28;
	__map_gbk2utf16[0x3609] = 0x7a29;
	__map_gbk2utf16[0x360a] = 0x7a2a;
	__map_gbk2utf16[0x360b] = 0x7a2b;
	__map_gbk2utf16[0x360c] = 0x7a2c;
	__map_gbk2utf16[0x360d] = 0x7a2d;
	__map_gbk2utf16[0x360e] = 0x7a2e;
	__map_gbk2utf16[0x360f] = 0x7a2f;
	__map_gbk2utf16[0x3610] = 0x7a30;
	__map_gbk2utf16[0x3611] = 0x7a31;
	__map_gbk2utf16[0x3612] = 0x7a32;
	__map_gbk2utf16[0x3613] = 0x7a34;
	__map_gbk2utf16[0x3614] = 0x7a35;
	__map_gbk2utf16[0x3615] = 0x7a36;
	__map_gbk2utf16[0x3616] = 0x7a38;
	__map_gbk2utf16[0x3617] = 0x7a3a;
	__map_gbk2utf16[0x3618] = 0x7a3e;
	__map_gbk2utf16[0x3619] = 0x7a40;
	__map_gbk2utf16[0x361a] = 0x7a41;
	__map_gbk2utf16[0x361b] = 0x7a42;
	__map_gbk2utf16[0x361c] = 0x7a43;
	__map_gbk2utf16[0x361d] = 0x7a44;
	__map_gbk2utf16[0x361e] = 0x7a45;
	__map_gbk2utf16[0x361f] = 0x7a47;
	__map_gbk2utf16[0x3620] = 0x7a48;
	__map_gbk2utf16[0x3621] = 0x7a49;
	__map_gbk2utf16[0x3622] = 0x7a4a;
	__map_gbk2utf16[0x3623] = 0x7a4b;
	__map_gbk2utf16[0x3624] = 0x7a4c;
	__map_gbk2utf16[0x3625] = 0x7a4d;
	__map_gbk2utf16[0x3626] = 0x7a4e;
	__map_gbk2utf16[0x3627] = 0x7a4f;
	__map_gbk2utf16[0x3628] = 0x7a50;
	__map_gbk2utf16[0x3629] = 0x7a52;
	__map_gbk2utf16[0x362a] = 0x7a53;
	__map_gbk2utf16[0x362b] = 0x7a54;
	__map_gbk2utf16[0x362c] = 0x7a55;
	__map_gbk2utf16[0x362d] = 0x7a56;
	__map_gbk2utf16[0x362e] = 0x7a58;
	__map_gbk2utf16[0x362f] = 0x7a59;
	__map_gbk2utf16[0x3630] = 0x7a5a;
	__map_gbk2utf16[0x3631] = 0x7a5b;
	__map_gbk2utf16[0x3632] = 0x7a5c;
	__map_gbk2utf16[0x3633] = 0x7a5d;
	__map_gbk2utf16[0x3634] = 0x7a5e;
	__map_gbk2utf16[0x3635] = 0x7a5f;
	__map_gbk2utf16[0x3636] = 0x7a60;
	__map_gbk2utf16[0x3637] = 0x7a61;
	__map_gbk2utf16[0x3638] = 0x7a62;
	__map_gbk2utf16[0x3639] = 0x7a63;
	__map_gbk2utf16[0x363a] = 0x7a64;
	__map_gbk2utf16[0x363b] = 0x7a65;
	__map_gbk2utf16[0x363c] = 0x7a66;
	__map_gbk2utf16[0x363d] = 0x7a67;
	__map_gbk2utf16[0x363e] = 0x7a68;
	__map_gbk2utf16[0x3640] = 0x7a69;
	__map_gbk2utf16[0x3641] = 0x7a6a;
	__map_gbk2utf16[0x3642] = 0x7a6b;
	__map_gbk2utf16[0x3643] = 0x7a6c;
	__map_gbk2utf16[0x3644] = 0x7a6d;
	__map_gbk2utf16[0x3645] = 0x7a6e;
	__map_gbk2utf16[0x3646] = 0x7a6f;
	__map_gbk2utf16[0x3647] = 0x7a71;
	__map_gbk2utf16[0x3648] = 0x7a72;
	__map_gbk2utf16[0x3649] = 0x7a73;
	__map_gbk2utf16[0x364a] = 0x7a75;
	__map_gbk2utf16[0x364b] = 0x7a7b;
	__map_gbk2utf16[0x364c] = 0x7a7c;
	__map_gbk2utf16[0x364d] = 0x7a7d;
	__map_gbk2utf16[0x364e] = 0x7a7e;
	__map_gbk2utf16[0x364f] = 0x7a82;
	__map_gbk2utf16[0x3650] = 0x7a85;
	__map_gbk2utf16[0x3651] = 0x7a87;
	__map_gbk2utf16[0x3652] = 0x7a89;
	__map_gbk2utf16[0x3653] = 0x7a8a;
	__map_gbk2utf16[0x3654] = 0x7a8b;
	__map_gbk2utf16[0x3655] = 0x7a8c;
	__map_gbk2utf16[0x3656] = 0x7a8e;
	__map_gbk2utf16[0x3657] = 0x7a8f;
	__map_gbk2utf16[0x3658] = 0x7a90;
	__map_gbk2utf16[0x3659] = 0x7a93;
	__map_gbk2utf16[0x365a] = 0x7a94;
	__map_gbk2utf16[0x365b] = 0x7a99;
	__map_gbk2utf16[0x365c] = 0x7a9a;
	__map_gbk2utf16[0x365d] = 0x7a9b;
	__map_gbk2utf16[0x365e] = 0x7a9e;
	__map_gbk2utf16[0x365f] = 0x7aa1;
	__map_gbk2utf16[0x3660] = 0x7aa2;
	__map_gbk2utf16[0x3661] = 0x8d30;
	__map_gbk2utf16[0x3662] = 0x53d1;
	__map_gbk2utf16[0x3663] = 0x7f5a;
	__map_gbk2utf16[0x3664] = 0x7b4f;
	__map_gbk2utf16[0x3665] = 0x4f10;
	__map_gbk2utf16[0x3666] = 0x4e4f;
	__map_gbk2utf16[0x3667] = 0x9600;
	__map_gbk2utf16[0x3668] = 0x6cd5;
	__map_gbk2utf16[0x3669] = 0x73d0;
	__map_gbk2utf16[0x366a] = 0x85e9;
	__map_gbk2utf16[0x366b] = 0x5e06;
	__map_gbk2utf16[0x366c] = 0x756a;
	__map_gbk2utf16[0x366d] = 0x7ffb;
	__map_gbk2utf16[0x366e] = 0x6a0a;
	__map_gbk2utf16[0x366f] = 0x77fe;
	__map_gbk2utf16[0x3670] = 0x9492;
	__map_gbk2utf16[0x3671] = 0x7e41;
	__map_gbk2utf16[0x3672] = 0x51e1;
	__map_gbk2utf16[0x3673] = 0x70e6;
	__map_gbk2utf16[0x3674] = 0x53cd;
	__map_gbk2utf16[0x3675] = 0x8fd4;
	__map_gbk2utf16[0x3676] = 0x8303;
	__map_gbk2utf16[0x3677] = 0x8d29;
	__map_gbk2utf16[0x3678] = 0x72af;
	__map_gbk2utf16[0x3679] = 0x996d;
	__map_gbk2utf16[0x367a] = 0x6cdb;
	__map_gbk2utf16[0x367b] = 0x574a;
	__map_gbk2utf16[0x367c] = 0x82b3;
	__map_gbk2utf16[0x367d] = 0x65b9;
	__map_gbk2utf16[0x367e] = 0x80aa;
	__map_gbk2utf16[0x367f] = 0x623f;
	__map_gbk2utf16[0x3680] = 0x9632;
	__map_gbk2utf16[0x3681] = 0x59a8;
	__map_gbk2utf16[0x3682] = 0x4eff;
	__map_gbk2utf16[0x3683] = 0x8bbf;
	__map_gbk2utf16[0x3684] = 0x7eba;
	__map_gbk2utf16[0x3685] = 0x653e;
	__map_gbk2utf16[0x3686] = 0x83f2;
	__map_gbk2utf16[0x3687] = 0x975e;
	__map_gbk2utf16[0x3688] = 0x5561;
	__map_gbk2utf16[0x3689] = 0x98de;
	__map_gbk2utf16[0x368a] = 0x80a5;
	__map_gbk2utf16[0x368b] = 0x532a;
	__map_gbk2utf16[0x368c] = 0x8bfd;
	__map_gbk2utf16[0x368d] = 0x5420;
	__map_gbk2utf16[0x368e] = 0x80ba;
	__map_gbk2utf16[0x368f] = 0x5e9f;
	__map_gbk2utf16[0x3690] = 0x6cb8;
	__map_gbk2utf16[0x3691] = 0x8d39;
	__map_gbk2utf16[0x3692] = 0x82ac;
	__map_gbk2utf16[0x3693] = 0x915a;
	__map_gbk2utf16[0x3694] = 0x5429;
	__map_gbk2utf16[0x3695] = 0x6c1b;
	__map_gbk2utf16[0x3696] = 0x5206;
	__map_gbk2utf16[0x3697] = 0x7eb7;
	__map_gbk2utf16[0x3698] = 0x575f;
	__map_gbk2utf16[0x3699] = 0x711a;
	__map_gbk2utf16[0x369a] = 0x6c7e;
	__map_gbk2utf16[0x369b] = 0x7c89;
	__map_gbk2utf16[0x369c] = 0x594b;
	__map_gbk2utf16[0x369d] = 0x4efd;
	__map_gbk2utf16[0x369e] = 0x5fff;
	__map_gbk2utf16[0x369f] = 0x6124;
	__map_gbk2utf16[0x36a0] = 0x7caa;
	__map_gbk2utf16[0x36a1] = 0x4e30;
	__map_gbk2utf16[0x36a2] = 0x5c01;
	__map_gbk2utf16[0x36a3] = 0x67ab;
	__map_gbk2utf16[0x36a4] = 0x8702;
	__map_gbk2utf16[0x36a5] = 0x5cf0;
	__map_gbk2utf16[0x36a6] = 0x950b;
	__map_gbk2utf16[0x36a7] = 0x98ce;
	__map_gbk2utf16[0x36a8] = 0x75af;
	__map_gbk2utf16[0x36a9] = 0x70fd;
	__map_gbk2utf16[0x36aa] = 0x9022;
	__map_gbk2utf16[0x36ab] = 0x51af;
	__map_gbk2utf16[0x36ac] = 0x7f1d;
	__map_gbk2utf16[0x36ad] = 0x8bbd;
	__map_gbk2utf16[0x36ae] = 0x5949;
	__map_gbk2utf16[0x36af] = 0x51e4;
	__map_gbk2utf16[0x36b0] = 0x4f5b;
	__map_gbk2utf16[0x36b1] = 0x5426;
	__map_gbk2utf16[0x36b2] = 0x592b;
	__map_gbk2utf16[0x36b3] = 0x6577;
	__map_gbk2utf16[0x36b4] = 0x80a4;
	__map_gbk2utf16[0x36b5] = 0x5b75;
	__map_gbk2utf16[0x36b6] = 0x6276;
	__map_gbk2utf16[0x36b7] = 0x62c2;
	__map_gbk2utf16[0x36b8] = 0x8f90;
	__map_gbk2utf16[0x36b9] = 0x5e45;
	__map_gbk2utf16[0x36ba] = 0x6c1f;
	__map_gbk2utf16[0x36bb] = 0x7b26;
	__map_gbk2utf16[0x36bc] = 0x4f0f;
	__map_gbk2utf16[0x36bd] = 0x4fd8;
	__map_gbk2utf16[0x36be] = 0x670d;
	__map_gbk2utf16[0x3700] = 0x7aa3;
	__map_gbk2utf16[0x3701] = 0x7aa4;
	__map_gbk2utf16[0x3702] = 0x7aa7;
	__map_gbk2utf16[0x3703] = 0x7aa9;
	__map_gbk2utf16[0x3704] = 0x7aaa;
	__map_gbk2utf16[0x3705] = 0x7aab;
	__map_gbk2utf16[0x3706] = 0x7aae;
	__map_gbk2utf16[0x3707] = 0x7aaf;
	__map_gbk2utf16[0x3708] = 0x7ab0;
	__map_gbk2utf16[0x3709] = 0x7ab1;
	__map_gbk2utf16[0x370a] = 0x7ab2;
	__map_gbk2utf16[0x370b] = 0x7ab4;
	__map_gbk2utf16[0x370c] = 0x7ab5;
	__map_gbk2utf16[0x370d] = 0x7ab6;
	__map_gbk2utf16[0x370e] = 0x7ab7;
	__map_gbk2utf16[0x370f] = 0x7ab8;
	__map_gbk2utf16[0x3710] = 0x7ab9;
	__map_gbk2utf16[0x3711] = 0x7aba;
	__map_gbk2utf16[0x3712] = 0x7abb;
	__map_gbk2utf16[0x3713] = 0x7abc;
	__map_gbk2utf16[0x3714] = 0x7abd;
	__map_gbk2utf16[0x3715] = 0x7abe;
	__map_gbk2utf16[0x3716] = 0x7ac0;
	__map_gbk2utf16[0x3717] = 0x7ac1;
	__map_gbk2utf16[0x3718] = 0x7ac2;
	__map_gbk2utf16[0x3719] = 0x7ac3;
	__map_gbk2utf16[0x371a] = 0x7ac4;
	__map_gbk2utf16[0x371b] = 0x7ac5;
	__map_gbk2utf16[0x371c] = 0x7ac6;
	__map_gbk2utf16[0x371d] = 0x7ac7;
	__map_gbk2utf16[0x371e] = 0x7ac8;
	__map_gbk2utf16[0x371f] = 0x7ac9;
	__map_gbk2utf16[0x3720] = 0x7aca;
	__map_gbk2utf16[0x3721] = 0x7acc;
	__map_gbk2utf16[0x3722] = 0x7acd;
	__map_gbk2utf16[0x3723] = 0x7ace;
	__map_gbk2utf16[0x3724] = 0x7acf;
	__map_gbk2utf16[0x3725] = 0x7ad0;
	__map_gbk2utf16[0x3726] = 0x7ad1;
	__map_gbk2utf16[0x3727] = 0x7ad2;
	__map_gbk2utf16[0x3728] = 0x7ad3;
	__map_gbk2utf16[0x3729] = 0x7ad4;
	__map_gbk2utf16[0x372a] = 0x7ad5;
	__map_gbk2utf16[0x372b] = 0x7ad7;
	__map_gbk2utf16[0x372c] = 0x7ad8;
	__map_gbk2utf16[0x372d] = 0x7ada;
	__map_gbk2utf16[0x372e] = 0x7adb;
	__map_gbk2utf16[0x372f] = 0x7adc;
	__map_gbk2utf16[0x3730] = 0x7add;
	__map_gbk2utf16[0x3731] = 0x7ae1;
	__map_gbk2utf16[0x3732] = 0x7ae2;
	__map_gbk2utf16[0x3733] = 0x7ae4;
	__map_gbk2utf16[0x3734] = 0x7ae7;
	__map_gbk2utf16[0x3735] = 0x7ae8;
	__map_gbk2utf16[0x3736] = 0x7ae9;
	__map_gbk2utf16[0x3737] = 0x7aea;
	__map_gbk2utf16[0x3738] = 0x7aeb;
	__map_gbk2utf16[0x3739] = 0x7aec;
	__map_gbk2utf16[0x373a] = 0x7aee;
	__map_gbk2utf16[0x373b] = 0x7af0;
	__map_gbk2utf16[0x373c] = 0x7af1;
	__map_gbk2utf16[0x373d] = 0x7af2;
	__map_gbk2utf16[0x373e] = 0x7af3;
	__map_gbk2utf16[0x3740] = 0x7af4;
	__map_gbk2utf16[0x3741] = 0x7af5;
	__map_gbk2utf16[0x3742] = 0x7af6;
	__map_gbk2utf16[0x3743] = 0x7af7;
	__map_gbk2utf16[0x3744] = 0x7af8;
	__map_gbk2utf16[0x3745] = 0x7afb;
	__map_gbk2utf16[0x3746] = 0x7afc;
	__map_gbk2utf16[0x3747] = 0x7afe;
	__map_gbk2utf16[0x3748] = 0x7b00;
	__map_gbk2utf16[0x3749] = 0x7b01;
	__map_gbk2utf16[0x374a] = 0x7b02;
	__map_gbk2utf16[0x374b] = 0x7b05;
	__map_gbk2utf16[0x374c] = 0x7b07;
	__map_gbk2utf16[0x374d] = 0x7b09;
	__map_gbk2utf16[0x374e] = 0x7b0c;
	__map_gbk2utf16[0x374f] = 0x7b0d;
	__map_gbk2utf16[0x3750] = 0x7b0e;
	__map_gbk2utf16[0x3751] = 0x7b10;
	__map_gbk2utf16[0x3752] = 0x7b12;
	__map_gbk2utf16[0x3753] = 0x7b13;
	__map_gbk2utf16[0x3754] = 0x7b16;
	__map_gbk2utf16[0x3755] = 0x7b17;
	__map_gbk2utf16[0x3756] = 0x7b18;
	__map_gbk2utf16[0x3757] = 0x7b1a;
	__map_gbk2utf16[0x3758] = 0x7b1c;
	__map_gbk2utf16[0x3759] = 0x7b1d;
	__map_gbk2utf16[0x375a] = 0x7b1f;
	__map_gbk2utf16[0x375b] = 0x7b21;
	__map_gbk2utf16[0x375c] = 0x7b22;
	__map_gbk2utf16[0x375d] = 0x7b23;
	__map_gbk2utf16[0x375e] = 0x7b27;
	__map_gbk2utf16[0x375f] = 0x7b29;
	__map_gbk2utf16[0x3760] = 0x7b2d;
	__map_gbk2utf16[0x3761] = 0x6d6e;
	__map_gbk2utf16[0x3762] = 0x6daa;
	__map_gbk2utf16[0x3763] = 0x798f;
	__map_gbk2utf16[0x3764] = 0x88b1;
	__map_gbk2utf16[0x3765] = 0x5f17;
	__map_gbk2utf16[0x3766] = 0x752b;
	__map_gbk2utf16[0x3767] = 0x629a;
	__map_gbk2utf16[0x3768] = 0x8f85;
	__map_gbk2utf16[0x3769] = 0x4fef;
	__map_gbk2utf16[0x376a] = 0x91dc;
	__map_gbk2utf16[0x376b] = 0x65a7;
	__map_gbk2utf16[0x376c] = 0x812f;
	__map_gbk2utf16[0x376d] = 0x8151;
	__map_gbk2utf16[0x376e] = 0x5e9c;
	__map_gbk2utf16[0x376f] = 0x8150;
	__map_gbk2utf16[0x3770] = 0x8d74;
	__map_gbk2utf16[0x3771] = 0x526f;
	__map_gbk2utf16[0x3772] = 0x8986;
	__map_gbk2utf16[0x3773] = 0x8d4b;
	__map_gbk2utf16[0x3774] = 0x590d;
	__map_gbk2utf16[0x3775] = 0x5085;
	__map_gbk2utf16[0x3776] = 0x4ed8;
	__map_gbk2utf16[0x3777] = 0x961c;
	__map_gbk2utf16[0x3778] = 0x7236;
	__map_gbk2utf16[0x3779] = 0x8179;
	__map_gbk2utf16[0x377a] = 0x8d1f;
	__map_gbk2utf16[0x377b] = 0x5bcc;
	__map_gbk2utf16[0x377c] = 0x8ba3;
	__map_gbk2utf16[0x377d] = 0x9644;
	__map_gbk2utf16[0x377e] = 0x5987;
	__map_gbk2utf16[0x377f] = 0x7f1a;
	__map_gbk2utf16[0x3780] = 0x5490;
	__map_gbk2utf16[0x3781] = 0x5676;
	__map_gbk2utf16[0x3782] = 0x560e;
	__map_gbk2utf16[0x3783] = 0x8be5;
	__map_gbk2utf16[0x3784] = 0x6539;
	__map_gbk2utf16[0x3785] = 0x6982;
	__map_gbk2utf16[0x3786] = 0x9499;
	__map_gbk2utf16[0x3787] = 0x76d6;
	__map_gbk2utf16[0x3788] = 0x6e89;
	__map_gbk2utf16[0x3789] = 0x5e72;
	__map_gbk2utf16[0x378a] = 0x7518;
	__map_gbk2utf16[0x378b] = 0x6746;
	__map_gbk2utf16[0x378c] = 0x67d1;
	__map_gbk2utf16[0x378d] = 0x7aff;
	__map_gbk2utf16[0x378e] = 0x809d;
	__map_gbk2utf16[0x378f] = 0x8d76;
	__map_gbk2utf16[0x3790] = 0x611f;
	__map_gbk2utf16[0x3791] = 0x79c6;
	__map_gbk2utf16[0x3792] = 0x6562;
	__map_gbk2utf16[0x3793] = 0x8d63;
	__map_gbk2utf16[0x3794] = 0x5188;
	__map_gbk2utf16[0x3795] = 0x521a;
	__map_gbk2utf16[0x3796] = 0x94a2;
	__map_gbk2utf16[0x3797] = 0x7f38;
	__map_gbk2utf16[0x3798] = 0x809b;
	__map_gbk2utf16[0x3799] = 0x7eb2;
	__map_gbk2utf16[0x379a] = 0x5c97;
	__map_gbk2utf16[0x379b] = 0x6e2f;
	__map_gbk2utf16[0x379c] = 0x6760;
	__map_gbk2utf16[0x379d] = 0x7bd9;
	__map_gbk2utf16[0x379e] = 0x768b;
	__map_gbk2utf16[0x379f] = 0x9ad8;
	__map_gbk2utf16[0x37a0] = 0x818f;
	__map_gbk2utf16[0x37a1] = 0x7f94;
	__map_gbk2utf16[0x37a2] = 0x7cd5;
	__map_gbk2utf16[0x37a3] = 0x641e;
	__map_gbk2utf16[0x37a4] = 0x9550;
	__map_gbk2utf16[0x37a5] = 0x7a3f;
	__map_gbk2utf16[0x37a6] = 0x544a;
	__map_gbk2utf16[0x37a7] = 0x54e5;
	__map_gbk2utf16[0x37a8] = 0x6b4c;
	__map_gbk2utf16[0x37a9] = 0x6401;
	__map_gbk2utf16[0x37aa] = 0x6208;
	__map_gbk2utf16[0x37ab] = 0x9e3d;
	__map_gbk2utf16[0x37ac] = 0x80f3;
	__map_gbk2utf16[0x37ad] = 0x7599;
	__map_gbk2utf16[0x37ae] = 0x5272;
	__map_gbk2utf16[0x37af] = 0x9769;
	__map_gbk2utf16[0x37b0] = 0x845b;
	__map_gbk2utf16[0x37b1] = 0x683c;
	__map_gbk2utf16[0x37b2] = 0x86e4;
	__map_gbk2utf16[0x37b3] = 0x9601;
	__map_gbk2utf16[0x37b4] = 0x9694;
	__map_gbk2utf16[0x37b5] = 0x94ec;
	__map_gbk2utf16[0x37b6] = 0x4e2a;
	__map_gbk2utf16[0x37b7] = 0x5404;
	__map_gbk2utf16[0x37b8] = 0x7ed9;
	__map_gbk2utf16[0x37b9] = 0x6839;
	__map_gbk2utf16[0x37ba] = 0x8ddf;
	__map_gbk2utf16[0x37bb] = 0x8015;
	__map_gbk2utf16[0x37bc] = 0x66f4;
	__map_gbk2utf16[0x37bd] = 0x5e9a;
	__map_gbk2utf16[0x37be] = 0x7fb9;
	__map_gbk2utf16[0x3800] = 0x7b2f;
	__map_gbk2utf16[0x3801] = 0x7b30;
	__map_gbk2utf16[0x3802] = 0x7b32;
	__map_gbk2utf16[0x3803] = 0x7b34;
	__map_gbk2utf16[0x3804] = 0x7b35;
	__map_gbk2utf16[0x3805] = 0x7b36;
	__map_gbk2utf16[0x3806] = 0x7b37;
	__map_gbk2utf16[0x3807] = 0x7b39;
	__map_gbk2utf16[0x3808] = 0x7b3b;
	__map_gbk2utf16[0x3809] = 0x7b3d;
	__map_gbk2utf16[0x380a] = 0x7b3f;
	__map_gbk2utf16[0x380b] = 0x7b40;
	__map_gbk2utf16[0x380c] = 0x7b41;
	__map_gbk2utf16[0x380d] = 0x7b42;
	__map_gbk2utf16[0x380e] = 0x7b43;
	__map_gbk2utf16[0x380f] = 0x7b44;
	__map_gbk2utf16[0x3810] = 0x7b46;
	__map_gbk2utf16[0x3811] = 0x7b48;
	__map_gbk2utf16[0x3812] = 0x7b4a;
	__map_gbk2utf16[0x3813] = 0x7b4d;
	__map_gbk2utf16[0x3814] = 0x7b4e;
	__map_gbk2utf16[0x3815] = 0x7b53;
	__map_gbk2utf16[0x3816] = 0x7b55;
	__map_gbk2utf16[0x3817] = 0x7b57;
	__map_gbk2utf16[0x3818] = 0x7b59;
	__map_gbk2utf16[0x3819] = 0x7b5c;
	__map_gbk2utf16[0x381a] = 0x7b5e;
	__map_gbk2utf16[0x381b] = 0x7b5f;
	__map_gbk2utf16[0x381c] = 0x7b61;
	__map_gbk2utf16[0x381d] = 0x7b63;
	__map_gbk2utf16[0x381e] = 0x7b64;
	__map_gbk2utf16[0x381f] = 0x7b65;
	__map_gbk2utf16[0x3820] = 0x7b66;
	__map_gbk2utf16[0x3821] = 0x7b67;
	__map_gbk2utf16[0x3822] = 0x7b68;
	__map_gbk2utf16[0x3823] = 0x7b69;
	__map_gbk2utf16[0x3824] = 0x7b6a;
	__map_gbk2utf16[0x3825] = 0x7b6b;
	__map_gbk2utf16[0x3826] = 0x7b6c;
	__map_gbk2utf16[0x3827] = 0x7b6d;
	__map_gbk2utf16[0x3828] = 0x7b6f;
	__map_gbk2utf16[0x3829] = 0x7b70;
	__map_gbk2utf16[0x382a] = 0x7b73;
	__map_gbk2utf16[0x382b] = 0x7b74;
	__map_gbk2utf16[0x382c] = 0x7b76;
	__map_gbk2utf16[0x382d] = 0x7b78;
	__map_gbk2utf16[0x382e] = 0x7b7a;
	__map_gbk2utf16[0x382f] = 0x7b7c;
	__map_gbk2utf16[0x3830] = 0x7b7d;
	__map_gbk2utf16[0x3831] = 0x7b7f;
	__map_gbk2utf16[0x3832] = 0x7b81;
	__map_gbk2utf16[0x3833] = 0x7b82;
	__map_gbk2utf16[0x3834] = 0x7b83;
	__map_gbk2utf16[0x3835] = 0x7b84;
	__map_gbk2utf16[0x3836] = 0x7b86;
	__map_gbk2utf16[0x3837] = 0x7b87;
	__map_gbk2utf16[0x3838] = 0x7b88;
	__map_gbk2utf16[0x3839] = 0x7b89;
	__map_gbk2utf16[0x383a] = 0x7b8a;
	__map_gbk2utf16[0x383b] = 0x7b8b;
	__map_gbk2utf16[0x383c] = 0x7b8c;
	__map_gbk2utf16[0x383d] = 0x7b8e;
	__map_gbk2utf16[0x383e] = 0x7b8f;
	__map_gbk2utf16[0x3840] = 0x7b91;
	__map_gbk2utf16[0x3841] = 0x7b92;
	__map_gbk2utf16[0x3842] = 0x7b93;
	__map_gbk2utf16[0x3843] = 0x7b96;
	__map_gbk2utf16[0x3844] = 0x7b98;
	__map_gbk2utf16[0x3845] = 0x7b99;
	__map_gbk2utf16[0x3846] = 0x7b9a;
	__map_gbk2utf16[0x3847] = 0x7b9b;
	__map_gbk2utf16[0x3848] = 0x7b9e;
	__map_gbk2utf16[0x3849] = 0x7b9f;
	__map_gbk2utf16[0x384a] = 0x7ba0;
	__map_gbk2utf16[0x384b] = 0x7ba3;
	__map_gbk2utf16[0x384c] = 0x7ba4;
	__map_gbk2utf16[0x384d] = 0x7ba5;
	__map_gbk2utf16[0x384e] = 0x7bae;
	__map_gbk2utf16[0x384f] = 0x7baf;
	__map_gbk2utf16[0x3850] = 0x7bb0;
	__map_gbk2utf16[0x3851] = 0x7bb2;
	__map_gbk2utf16[0x3852] = 0x7bb3;
	__map_gbk2utf16[0x3853] = 0x7bb5;
	__map_gbk2utf16[0x3854] = 0x7bb6;
	__map_gbk2utf16[0x3855] = 0x7bb7;
	__map_gbk2utf16[0x3856] = 0x7bb9;
	__map_gbk2utf16[0x3857] = 0x7bba;
	__map_gbk2utf16[0x3858] = 0x7bbb;
	__map_gbk2utf16[0x3859] = 0x7bbc;
	__map_gbk2utf16[0x385a] = 0x7bbd;
	__map_gbk2utf16[0x385b] = 0x7bbe;
	__map_gbk2utf16[0x385c] = 0x7bbf;
	__map_gbk2utf16[0x385d] = 0x7bc0;
	__map_gbk2utf16[0x385e] = 0x7bc2;
	__map_gbk2utf16[0x385f] = 0x7bc3;
	__map_gbk2utf16[0x3860] = 0x7bc4;
	__map_gbk2utf16[0x3861] = 0x57c2;
	__map_gbk2utf16[0x3862] = 0x803f;
	__map_gbk2utf16[0x3863] = 0x6897;
	__map_gbk2utf16[0x3864] = 0x5de5;
	__map_gbk2utf16[0x3865] = 0x653b;
	__map_gbk2utf16[0x3866] = 0x529f;
	__map_gbk2utf16[0x3867] = 0x606d;
	__map_gbk2utf16[0x3868] = 0x9f9a;
	__map_gbk2utf16[0x3869] = 0x4f9b;
	__map_gbk2utf16[0x386a] = 0x8eac;
	__map_gbk2utf16[0x386b] = 0x516c;
	__map_gbk2utf16[0x386c] = 0x5bab;
	__map_gbk2utf16[0x386d] = 0x5f13;
	__map_gbk2utf16[0x386e] = 0x5de9;
	__map_gbk2utf16[0x386f] = 0x6c5e;
	__map_gbk2utf16[0x3870] = 0x62f1;
	__map_gbk2utf16[0x3871] = 0x8d21;
	__map_gbk2utf16[0x3872] = 0x5171;
	__map_gbk2utf16[0x3873] = 0x94a9;
	__map_gbk2utf16[0x3874] = 0x52fe;
	__map_gbk2utf16[0x3875] = 0x6c9f;
	__map_gbk2utf16[0x3876] = 0x82df;
	__map_gbk2utf16[0x3877] = 0x72d7;
	__map_gbk2utf16[0x3878] = 0x57a2;
	__map_gbk2utf16[0x3879] = 0x6784;
	__map_gbk2utf16[0x387a] = 0x8d2d;
	__map_gbk2utf16[0x387b] = 0x591f;
	__map_gbk2utf16[0x387c] = 0x8f9c;
	__map_gbk2utf16[0x387d] = 0x83c7;
	__map_gbk2utf16[0x387e] = 0x5495;
	__map_gbk2utf16[0x387f] = 0x7b8d;
	__map_gbk2utf16[0x3880] = 0x4f30;
	__map_gbk2utf16[0x3881] = 0x6cbd;
	__map_gbk2utf16[0x3882] = 0x5b64;
	__map_gbk2utf16[0x3883] = 0x59d1;
	__map_gbk2utf16[0x3884] = 0x9f13;
	__map_gbk2utf16[0x3885] = 0x53e4;
	__map_gbk2utf16[0x3886] = 0x86ca;
	__map_gbk2utf16[0x3887] = 0x9aa8;
	__map_gbk2utf16[0x3888] = 0x8c37;
	__map_gbk2utf16[0x3889] = 0x80a1;
	__map_gbk2utf16[0x388a] = 0x6545;
	__map_gbk2utf16[0x388b] = 0x987e;
	__map_gbk2utf16[0x388c] = 0x56fa;
	__map_gbk2utf16[0x388d] = 0x96c7;
	__map_gbk2utf16[0x388e] = 0x522e;
	__map_gbk2utf16[0x388f] = 0x74dc;
	__map_gbk2utf16[0x3890] = 0x5250;
	__map_gbk2utf16[0x3891] = 0x5be1;
	__map_gbk2utf16[0x3892] = 0x6302;
	__map_gbk2utf16[0x3893] = 0x8902;
	__map_gbk2utf16[0x3894] = 0x4e56;
	__map_gbk2utf16[0x3895] = 0x62d0;
	__map_gbk2utf16[0x3896] = 0x602a;
	__map_gbk2utf16[0x3897] = 0x68fa;
	__map_gbk2utf16[0x3898] = 0x5173;
	__map_gbk2utf16[0x3899] = 0x5b98;
	__map_gbk2utf16[0x389a] = 0x51a0;
	__map_gbk2utf16[0x389b] = 0x89c2;
	__map_gbk2utf16[0x389c] = 0x7ba1;
	__map_gbk2utf16[0x389d] = 0x9986;
	__map_gbk2utf16[0x389e] = 0x7f50;
	__map_gbk2utf16[0x389f] = 0x60ef;
	__map_gbk2utf16[0x38a0] = 0x704c;
	__map_gbk2utf16[0x38a1] = 0x8d2f;
	__map_gbk2utf16[0x38a2] = 0x5149;
	__map_gbk2utf16[0x38a3] = 0x5e7f;
	__map_gbk2utf16[0x38a4] = 0x901b;
	__map_gbk2utf16[0x38a5] = 0x7470;
	__map_gbk2utf16[0x38a6] = 0x89c4;
	__map_gbk2utf16[0x38a7] = 0x572d;
	__map_gbk2utf16[0x38a8] = 0x7845;
	__map_gbk2utf16[0x38a9] = 0x5f52;
	__map_gbk2utf16[0x38aa] = 0x9f9f;
	__map_gbk2utf16[0x38ab] = 0x95fa;
	__map_gbk2utf16[0x38ac] = 0x8f68;
	__map_gbk2utf16[0x38ad] = 0x9b3c;
	__map_gbk2utf16[0x38ae] = 0x8be1;
	__map_gbk2utf16[0x38af] = 0x7678;
	__map_gbk2utf16[0x38b0] = 0x6842;
	__map_gbk2utf16[0x38b1] = 0x67dc;
	__map_gbk2utf16[0x38b2] = 0x8dea;
	__map_gbk2utf16[0x38b3] = 0x8d35;
	__map_gbk2utf16[0x38b4] = 0x523d;
	__map_gbk2utf16[0x38b5] = 0x8f8a;
	__map_gbk2utf16[0x38b6] = 0x6eda;
	__map_gbk2utf16[0x38b7] = 0x68cd;
	__map_gbk2utf16[0x38b8] = 0x9505;
	__map_gbk2utf16[0x38b9] = 0x90ed;
	__map_gbk2utf16[0x38ba] = 0x56fd;
	__map_gbk2utf16[0x38bb] = 0x679c;
	__map_gbk2utf16[0x38bc] = 0x88f9;
	__map_gbk2utf16[0x38bd] = 0x8fc7;
	__map_gbk2utf16[0x38be] = 0x54c8;
	__map_gbk2utf16[0x3900] = 0x7bc5;
	__map_gbk2utf16[0x3901] = 0x7bc8;
	__map_gbk2utf16[0x3902] = 0x7bc9;
	__map_gbk2utf16[0x3903] = 0x7bca;
	__map_gbk2utf16[0x3904] = 0x7bcb;
	__map_gbk2utf16[0x3905] = 0x7bcd;
	__map_gbk2utf16[0x3906] = 0x7bce;
	__map_gbk2utf16[0x3907] = 0x7bcf;
	__map_gbk2utf16[0x3908] = 0x7bd0;
	__map_gbk2utf16[0x3909] = 0x7bd2;
	__map_gbk2utf16[0x390a] = 0x7bd4;
	__map_gbk2utf16[0x390b] = 0x7bd5;
	__map_gbk2utf16[0x390c] = 0x7bd6;
	__map_gbk2utf16[0x390d] = 0x7bd7;
	__map_gbk2utf16[0x390e] = 0x7bd8;
	__map_gbk2utf16[0x390f] = 0x7bdb;
	__map_gbk2utf16[0x3910] = 0x7bdc;
	__map_gbk2utf16[0x3911] = 0x7bde;
	__map_gbk2utf16[0x3912] = 0x7bdf;
	__map_gbk2utf16[0x3913] = 0x7be0;
	__map_gbk2utf16[0x3914] = 0x7be2;
	__map_gbk2utf16[0x3915] = 0x7be3;
	__map_gbk2utf16[0x3916] = 0x7be4;
	__map_gbk2utf16[0x3917] = 0x7be7;
	__map_gbk2utf16[0x3918] = 0x7be8;
	__map_gbk2utf16[0x3919] = 0x7be9;
	__map_gbk2utf16[0x391a] = 0x7beb;
	__map_gbk2utf16[0x391b] = 0x7bec;
	__map_gbk2utf16[0x391c] = 0x7bed;
	__map_gbk2utf16[0x391d] = 0x7bef;
	__map_gbk2utf16[0x391e] = 0x7bf0;
	__map_gbk2utf16[0x391f] = 0x7bf2;
	__map_gbk2utf16[0x3920] = 0x7bf3;
	__map_gbk2utf16[0x3921] = 0x7bf4;
	__map_gbk2utf16[0x3922] = 0x7bf5;
	__map_gbk2utf16[0x3923] = 0x7bf6;
	__map_gbk2utf16[0x3924] = 0x7bf8;
	__map_gbk2utf16[0x3925] = 0x7bf9;
	__map_gbk2utf16[0x3926] = 0x7bfa;
	__map_gbk2utf16[0x3927] = 0x7bfb;
	__map_gbk2utf16[0x3928] = 0x7bfd;
	__map_gbk2utf16[0x3929] = 0x7bff;
	__map_gbk2utf16[0x392a] = 0x7c00;
	__map_gbk2utf16[0x392b] = 0x7c01;
	__map_gbk2utf16[0x392c] = 0x7c02;
	__map_gbk2utf16[0x392d] = 0x7c03;
	__map_gbk2utf16[0x392e] = 0x7c04;
	__map_gbk2utf16[0x392f] = 0x7c05;
	__map_gbk2utf16[0x3930] = 0x7c06;
	__map_gbk2utf16[0x3931] = 0x7c08;
	__map_gbk2utf16[0x3932] = 0x7c09;
	__map_gbk2utf16[0x3933] = 0x7c0a;
	__map_gbk2utf16[0x3934] = 0x7c0d;
	__map_gbk2utf16[0x3935] = 0x7c0e;
	__map_gbk2utf16[0x3936] = 0x7c10;
	__map_gbk2utf16[0x3937] = 0x7c11;
	__map_gbk2utf16[0x3938] = 0x7c12;
	__map_gbk2utf16[0x3939] = 0x7c13;
	__map_gbk2utf16[0x393a] = 0x7c14;
	__map_gbk2utf16[0x393b] = 0x7c15;
	__map_gbk2utf16[0x393c] = 0x7c17;
	__map_gbk2utf16[0x393d] = 0x7c18;
	__map_gbk2utf16[0x393e] = 0x7c19;
	__map_gbk2utf16[0x3940] = 0x7c1a;
	__map_gbk2utf16[0x3941] = 0x7c1b;
	__map_gbk2utf16[0x3942] = 0x7c1c;
	__map_gbk2utf16[0x3943] = 0x7c1d;
	__map_gbk2utf16[0x3944] = 0x7c1e;
	__map_gbk2utf16[0x3945] = 0x7c20;
	__map_gbk2utf16[0x3946] = 0x7c21;
	__map_gbk2utf16[0x3947] = 0x7c22;
	__map_gbk2utf16[0x3948] = 0x7c23;
	__map_gbk2utf16[0x3949] = 0x7c24;
	__map_gbk2utf16[0x394a] = 0x7c25;
	__map_gbk2utf16[0x394b] = 0x7c28;
	__map_gbk2utf16[0x394c] = 0x7c29;
	__map_gbk2utf16[0x394d] = 0x7c2b;
	__map_gbk2utf16[0x394e] = 0x7c2c;
	__map_gbk2utf16[0x394f] = 0x7c2d;
	__map_gbk2utf16[0x3950] = 0x7c2e;
	__map_gbk2utf16[0x3951] = 0x7c2f;
	__map_gbk2utf16[0x3952] = 0x7c30;
	__map_gbk2utf16[0x3953] = 0x7c31;
	__map_gbk2utf16[0x3954] = 0x7c32;
	__map_gbk2utf16[0x3955] = 0x7c33;
	__map_gbk2utf16[0x3956] = 0x7c34;
	__map_gbk2utf16[0x3957] = 0x7c35;
	__map_gbk2utf16[0x3958] = 0x7c36;
	__map_gbk2utf16[0x3959] = 0x7c37;
	__map_gbk2utf16[0x395a] = 0x7c39;
	__map_gbk2utf16[0x395b] = 0x7c3a;
	__map_gbk2utf16[0x395c] = 0x7c3b;
	__map_gbk2utf16[0x395d] = 0x7c3c;
	__map_gbk2utf16[0x395e] = 0x7c3d;
	__map_gbk2utf16[0x395f] = 0x7c3e;
	__map_gbk2utf16[0x3960] = 0x7c42;
	__map_gbk2utf16[0x3961] = 0x9ab8;
	__map_gbk2utf16[0x3962] = 0x5b69;
	__map_gbk2utf16[0x3963] = 0x6d77;
	__map_gbk2utf16[0x3964] = 0x6c26;
	__map_gbk2utf16[0x3965] = 0x4ea5;
	__map_gbk2utf16[0x3966] = 0x5bb3;
	__map_gbk2utf16[0x3967] = 0x9a87;
	__map_gbk2utf16[0x3968] = 0x9163;
	__map_gbk2utf16[0x3969] = 0x61a8;
	__map_gbk2utf16[0x396a] = 0x90af;
	__map_gbk2utf16[0x396b] = 0x97e9;
	__map_gbk2utf16[0x396c] = 0x542b;
	__map_gbk2utf16[0x396d] = 0x6db5;
	__map_gbk2utf16[0x396e] = 0x5bd2;
	__map_gbk2utf16[0x396f] = 0x51fd;
	__map_gbk2utf16[0x3970] = 0x558a;
	__map_gbk2utf16[0x3971] = 0x7f55;
	__map_gbk2utf16[0x3972] = 0x7ff0;
	__map_gbk2utf16[0x3973] = 0x64bc;
	__map_gbk2utf16[0x3974] = 0x634d;
	__map_gbk2utf16[0x3975] = 0x65f1;
	__map_gbk2utf16[0x3976] = 0x61be;
	__map_gbk2utf16[0x3977] = 0x608d;
	__map_gbk2utf16[0x3978] = 0x710a;
	__map_gbk2utf16[0x3979] = 0x6c57;
	__map_gbk2utf16[0x397a] = 0x6c49;
	__map_gbk2utf16[0x397b] = 0x592f;
	__map_gbk2utf16[0x397c] = 0x676d;
	__map_gbk2utf16[0x397d] = 0x822a;
	__map_gbk2utf16[0x397e] = 0x58d5;
	__map_gbk2utf16[0x397f] = 0x568e;
	__map_gbk2utf16[0x3980] = 0x8c6a;
	__map_gbk2utf16[0x3981] = 0x6beb;
	__map_gbk2utf16[0x3982] = 0x90dd;
	__map_gbk2utf16[0x3983] = 0x597d;
	__map_gbk2utf16[0x3984] = 0x8017;
	__map_gbk2utf16[0x3985] = 0x53f7;
	__map_gbk2utf16[0x3986] = 0x6d69;
	__map_gbk2utf16[0x3987] = 0x5475;
	__map_gbk2utf16[0x3988] = 0x559d;
	__map_gbk2utf16[0x3989] = 0x8377;
	__map_gbk2utf16[0x398a] = 0x83cf;
	__map_gbk2utf16[0x398b] = 0x6838;
	__map_gbk2utf16[0x398c] = 0x79be;
	__map_gbk2utf16[0x398d] = 0x548c;
	__map_gbk2utf16[0x398e] = 0x4f55;
	__map_gbk2utf16[0x398f] = 0x5408;
	__map_gbk2utf16[0x3990] = 0x76d2;
	__map_gbk2utf16[0x3991] = 0x8c89;
	__map_gbk2utf16[0x3992] = 0x9602;
	__map_gbk2utf16[0x3993] = 0x6cb3;
	__map_gbk2utf16[0x3994] = 0x6db8;
	__map_gbk2utf16[0x3995] = 0x8d6b;
	__map_gbk2utf16[0x3996] = 0x8910;
	__map_gbk2utf16[0x3997] = 0x9e64;
	__map_gbk2utf16[0x3998] = 0x8d3a;
	__map_gbk2utf16[0x3999] = 0x563f;
	__map_gbk2utf16[0x399a] = 0x9ed1;
	__map_gbk2utf16[0x399b] = 0x75d5;
	__map_gbk2utf16[0x399c] = 0x5f88;
	__map_gbk2utf16[0x399d] = 0x72e0;
	__map_gbk2utf16[0x399e] = 0x6068;
	__map_gbk2utf16[0x399f] = 0x54fc;
	__map_gbk2utf16[0x39a0] = 0x4ea8;
	__map_gbk2utf16[0x39a1] = 0x6a2a;
	__map_gbk2utf16[0x39a2] = 0x8861;
	__map_gbk2utf16[0x39a3] = 0x6052;
	__map_gbk2utf16[0x39a4] = 0x8f70;
	__map_gbk2utf16[0x39a5] = 0x54c4;
	__map_gbk2utf16[0x39a6] = 0x70d8;
	__map_gbk2utf16[0x39a7] = 0x8679;
	__map_gbk2utf16[0x39a8] = 0x9e3f;
	__map_gbk2utf16[0x39a9] = 0x6d2a;
	__map_gbk2utf16[0x39aa] = 0x5b8f;
	__map_gbk2utf16[0x39ab] = 0x5f18;
	__map_gbk2utf16[0x39ac] = 0x7ea2;
	__map_gbk2utf16[0x39ad] = 0x5589;
	__map_gbk2utf16[0x39ae] = 0x4faf;
	__map_gbk2utf16[0x39af] = 0x7334;
	__map_gbk2utf16[0x39b0] = 0x543c;
	__map_gbk2utf16[0x39b1] = 0x539a;
	__map_gbk2utf16[0x39b2] = 0x5019;
	__map_gbk2utf16[0x39b3] = 0x540e;
	__map_gbk2utf16[0x39b4] = 0x547c;
	__map_gbk2utf16[0x39b5] = 0x4e4e;
	__map_gbk2utf16[0x39b6] = 0x5ffd;
	__map_gbk2utf16[0x39b7] = 0x745a;
	__map_gbk2utf16[0x39b8] = 0x58f6;
	__map_gbk2utf16[0x39b9] = 0x846b;
	__map_gbk2utf16[0x39ba] = 0x80e1;
	__map_gbk2utf16[0x39bb] = 0x8774;
	__map_gbk2utf16[0x39bc] = 0x72d0;
	__map_gbk2utf16[0x39bd] = 0x7cca;
	__map_gbk2utf16[0x39be] = 0x6e56;
	__map_gbk2utf16[0x3a00] = 0x7c43;
	__map_gbk2utf16[0x3a01] = 0x7c44;
	__map_gbk2utf16[0x3a02] = 0x7c45;
	__map_gbk2utf16[0x3a03] = 0x7c46;
	__map_gbk2utf16[0x3a04] = 0x7c47;
	__map_gbk2utf16[0x3a05] = 0x7c48;
	__map_gbk2utf16[0x3a06] = 0x7c49;
	__map_gbk2utf16[0x3a07] = 0x7c4a;
	__map_gbk2utf16[0x3a08] = 0x7c4b;
	__map_gbk2utf16[0x3a09] = 0x7c4c;
	__map_gbk2utf16[0x3a0a] = 0x7c4e;
	__map_gbk2utf16[0x3a0b] = 0x7c4f;
	__map_gbk2utf16[0x3a0c] = 0x7c50;
	__map_gbk2utf16[0x3a0d] = 0x7c51;
	__map_gbk2utf16[0x3a0e] = 0x7c52;
	__map_gbk2utf16[0x3a0f] = 0x7c53;
	__map_gbk2utf16[0x3a10] = 0x7c54;
	__map_gbk2utf16[0x3a11] = 0x7c55;
	__map_gbk2utf16[0x3a12] = 0x7c56;
	__map_gbk2utf16[0x3a13] = 0x7c57;
	__map_gbk2utf16[0x3a14] = 0x7c58;
	__map_gbk2utf16[0x3a15] = 0x7c59;
	__map_gbk2utf16[0x3a16] = 0x7c5a;
	__map_gbk2utf16[0x3a17] = 0x7c5b;
	__map_gbk2utf16[0x3a18] = 0x7c5c;
	__map_gbk2utf16[0x3a19] = 0x7c5d;
	__map_gbk2utf16[0x3a1a] = 0x7c5e;
	__map_gbk2utf16[0x3a1b] = 0x7c5f;
	__map_gbk2utf16[0x3a1c] = 0x7c60;
	__map_gbk2utf16[0x3a1d] = 0x7c61;
	__map_gbk2utf16[0x3a1e] = 0x7c62;
	__map_gbk2utf16[0x3a1f] = 0x7c63;
	__map_gbk2utf16[0x3a20] = 0x7c64;
	__map_gbk2utf16[0x3a21] = 0x7c65;
	__map_gbk2utf16[0x3a22] = 0x7c66;
	__map_gbk2utf16[0x3a23] = 0x7c67;
	__map_gbk2utf16[0x3a24] = 0x7c68;
	__map_gbk2utf16[0x3a25] = 0x7c69;
	__map_gbk2utf16[0x3a26] = 0x7c6a;
	__map_gbk2utf16[0x3a27] = 0x7c6b;
	__map_gbk2utf16[0x3a28] = 0x7c6c;
	__map_gbk2utf16[0x3a29] = 0x7c6d;
	__map_gbk2utf16[0x3a2a] = 0x7c6e;
	__map_gbk2utf16[0x3a2b] = 0x7c6f;
	__map_gbk2utf16[0x3a2c] = 0x7c70;
	__map_gbk2utf16[0x3a2d] = 0x7c71;
	__map_gbk2utf16[0x3a2e] = 0x7c72;
	__map_gbk2utf16[0x3a2f] = 0x7c75;
	__map_gbk2utf16[0x3a30] = 0x7c76;
	__map_gbk2utf16[0x3a31] = 0x7c77;
	__map_gbk2utf16[0x3a32] = 0x7c78;
	__map_gbk2utf16[0x3a33] = 0x7c79;
	__map_gbk2utf16[0x3a34] = 0x7c7a;
	__map_gbk2utf16[0x3a35] = 0x7c7e;
	__map_gbk2utf16[0x3a36] = 0x7c7f;
	__map_gbk2utf16[0x3a37] = 0x7c80;
	__map_gbk2utf16[0x3a38] = 0x7c81;
	__map_gbk2utf16[0x3a39] = 0x7c82;
	__map_gbk2utf16[0x3a3a] = 0x7c83;
	__map_gbk2utf16[0x3a3b] = 0x7c84;
	__map_gbk2utf16[0x3a3c] = 0x7c85;
	__map_gbk2utf16[0x3a3d] = 0x7c86;
	__map_gbk2utf16[0x3a3e] = 0x7c87;
	__map_gbk2utf16[0x3a40] = 0x7c88;
	__map_gbk2utf16[0x3a41] = 0x7c8a;
	__map_gbk2utf16[0x3a42] = 0x7c8b;
	__map_gbk2utf16[0x3a43] = 0x7c8c;
	__map_gbk2utf16[0x3a44] = 0x7c8d;
	__map_gbk2utf16[0x3a45] = 0x7c8e;
	__map_gbk2utf16[0x3a46] = 0x7c8f;
	__map_gbk2utf16[0x3a47] = 0x7c90;
	__map_gbk2utf16[0x3a48] = 0x7c93;
	__map_gbk2utf16[0x3a49] = 0x7c94;
	__map_gbk2utf16[0x3a4a] = 0x7c96;
	__map_gbk2utf16[0x3a4b] = 0x7c99;
	__map_gbk2utf16[0x3a4c] = 0x7c9a;
	__map_gbk2utf16[0x3a4d] = 0x7c9b;
	__map_gbk2utf16[0x3a4e] = 0x7ca0;
	__map_gbk2utf16[0x3a4f] = 0x7ca1;
	__map_gbk2utf16[0x3a50] = 0x7ca3;
	__map_gbk2utf16[0x3a51] = 0x7ca6;
	__map_gbk2utf16[0x3a52] = 0x7ca7;
	__map_gbk2utf16[0x3a53] = 0x7ca8;
	__map_gbk2utf16[0x3a54] = 0x7ca9;
	__map_gbk2utf16[0x3a55] = 0x7cab;
	__map_gbk2utf16[0x3a56] = 0x7cac;
	__map_gbk2utf16[0x3a57] = 0x7cad;
	__map_gbk2utf16[0x3a58] = 0x7caf;
	__map_gbk2utf16[0x3a59] = 0x7cb0;
	__map_gbk2utf16[0x3a5a] = 0x7cb4;
	__map_gbk2utf16[0x3a5b] = 0x7cb5;
	__map_gbk2utf16[0x3a5c] = 0x7cb6;
	__map_gbk2utf16[0x3a5d] = 0x7cb7;
	__map_gbk2utf16[0x3a5e] = 0x7cb8;
	__map_gbk2utf16[0x3a5f] = 0x7cba;
	__map_gbk2utf16[0x3a60] = 0x7cbb;
	__map_gbk2utf16[0x3a61] = 0x5f27;
	__map_gbk2utf16[0x3a62] = 0x864e;
	__map_gbk2utf16[0x3a63] = 0x552c;
	__map_gbk2utf16[0x3a64] = 0x62a4;
	__map_gbk2utf16[0x3a65] = 0x4e92;
	__map_gbk2utf16[0x3a66] = 0x6caa;
	__map_gbk2utf16[0x3a67] = 0x6237;
	__map_gbk2utf16[0x3a68] = 0x82b1;
	__map_gbk2utf16[0x3a69] = 0x54d7;
	__map_gbk2utf16[0x3a6a] = 0x534e;
	__map_gbk2utf16[0x3a6b] = 0x733e;
	__map_gbk2utf16[0x3a6c] = 0x6ed1;
	__map_gbk2utf16[0x3a6d] = 0x753b;
	__map_gbk2utf16[0x3a6e] = 0x5212;
	__map_gbk2utf16[0x3a6f] = 0x5316;
	__map_gbk2utf16[0x3a70] = 0x8bdd;
	__map_gbk2utf16[0x3a71] = 0x69d0;
	__map_gbk2utf16[0x3a72] = 0x5f8a;
	__map_gbk2utf16[0x3a73] = 0x6000;
	__map_gbk2utf16[0x3a74] = 0x6dee;
	__map_gbk2utf16[0x3a75] = 0x574f;
	__map_gbk2utf16[0x3a76] = 0x6b22;
	__map_gbk2utf16[0x3a77] = 0x73af;
	__map_gbk2utf16[0x3a78] = 0x6853;
	__map_gbk2utf16[0x3a79] = 0x8fd8;
	__map_gbk2utf16[0x3a7a] = 0x7f13;
	__map_gbk2utf16[0x3a7b] = 0x6362;
	__map_gbk2utf16[0x3a7c] = 0x60a3;
	__map_gbk2utf16[0x3a7d] = 0x5524;
	__map_gbk2utf16[0x3a7e] = 0x75ea;
	__map_gbk2utf16[0x3a7f] = 0x8c62;
	__map_gbk2utf16[0x3a80] = 0x7115;
	__map_gbk2utf16[0x3a81] = 0x6da3;
	__map_gbk2utf16[0x3a82] = 0x5ba6;
	__map_gbk2utf16[0x3a83] = 0x5e7b;
	__map_gbk2utf16[0x3a84] = 0x8352;
	__map_gbk2utf16[0x3a85] = 0x614c;
	__map_gbk2utf16[0x3a86] = 0x9ec4;
	__map_gbk2utf16[0x3a87] = 0x78fa;
	__map_gbk2utf16[0x3a88] = 0x8757;
	__map_gbk2utf16[0x3a89] = 0x7c27;
	__map_gbk2utf16[0x3a8a] = 0x7687;
	__map_gbk2utf16[0x3a8b] = 0x51f0;
	__map_gbk2utf16[0x3a8c] = 0x60f6;
	__map_gbk2utf16[0x3a8d] = 0x714c;
	__map_gbk2utf16[0x3a8e] = 0x6643;
	__map_gbk2utf16[0x3a8f] = 0x5e4c;
	__map_gbk2utf16[0x3a90] = 0x604d;
	__map_gbk2utf16[0x3a91] = 0x8c0e;
	__map_gbk2utf16[0x3a92] = 0x7070;
	__map_gbk2utf16[0x3a93] = 0x6325;
	__map_gbk2utf16[0x3a94] = 0x8f89;
	__map_gbk2utf16[0x3a95] = 0x5fbd;
	__map_gbk2utf16[0x3a96] = 0x6062;
	__map_gbk2utf16[0x3a97] = 0x86d4;
	__map_gbk2utf16[0x3a98] = 0x56de;
	__map_gbk2utf16[0x3a99] = 0x6bc1;
	__map_gbk2utf16[0x3a9a] = 0x6094;
	__map_gbk2utf16[0x3a9b] = 0x6167;
	__map_gbk2utf16[0x3a9c] = 0x5349;
	__map_gbk2utf16[0x3a9d] = 0x60e0;
	__map_gbk2utf16[0x3a9e] = 0x6666;
	__map_gbk2utf16[0x3a9f] = 0x8d3f;
	__map_gbk2utf16[0x3aa0] = 0x79fd;
	__map_gbk2utf16[0x3aa1] = 0x4f1a;
	__map_gbk2utf16[0x3aa2] = 0x70e9;
	__map_gbk2utf16[0x3aa3] = 0x6c47;
	__map_gbk2utf16[0x3aa4] = 0x8bb3;
	__map_gbk2utf16[0x3aa5] = 0x8bf2;
	__map_gbk2utf16[0x3aa6] = 0x7ed8;
	__map_gbk2utf16[0x3aa7] = 0x8364;
	__map_gbk2utf16[0x3aa8] = 0x660f;
	__map_gbk2utf16[0x3aa9] = 0x5a5a;
	__map_gbk2utf16[0x3aaa] = 0x9b42;
	__map_gbk2utf16[0x3aab] = 0x6d51;
	__map_gbk2utf16[0x3aac] = 0x6df7;
	__map_gbk2utf16[0x3aad] = 0x8c41;
	__map_gbk2utf16[0x3aae] = 0x6d3b;
	__map_gbk2utf16[0x3aaf] = 0x4f19;
	__map_gbk2utf16[0x3ab0] = 0x706b;
	__map_gbk2utf16[0x3ab1] = 0x83b7;
	__map_gbk2utf16[0x3ab2] = 0x6216;
	__map_gbk2utf16[0x3ab3] = 0x60d1;
	__map_gbk2utf16[0x3ab4] = 0x970d;
	__map_gbk2utf16[0x3ab5] = 0x8d27;
	__map_gbk2utf16[0x3ab6] = 0x7978;
	__map_gbk2utf16[0x3ab7] = 0x51fb;
	__map_gbk2utf16[0x3ab8] = 0x573e;
	__map_gbk2utf16[0x3ab9] = 0x57fa;
	__map_gbk2utf16[0x3aba] = 0x673a;
	__map_gbk2utf16[0x3abb] = 0x7578;
	__map_gbk2utf16[0x3abc] = 0x7a3d;
	__map_gbk2utf16[0x3abd] = 0x79ef;
	__map_gbk2utf16[0x3abe] = 0x7b95;
	__map_gbk2utf16[0x3b00] = 0x7cbf;
	__map_gbk2utf16[0x3b01] = 0x7cc0;
	__map_gbk2utf16[0x3b02] = 0x7cc2;
	__map_gbk2utf16[0x3b03] = 0x7cc3;
	__map_gbk2utf16[0x3b04] = 0x7cc4;
	__map_gbk2utf16[0x3b05] = 0x7cc6;
	__map_gbk2utf16[0x3b06] = 0x7cc9;
	__map_gbk2utf16[0x3b07] = 0x7ccb;
	__map_gbk2utf16[0x3b08] = 0x7cce;
	__map_gbk2utf16[0x3b09] = 0x7ccf;
	__map_gbk2utf16[0x3b0a] = 0x7cd0;
	__map_gbk2utf16[0x3b0b] = 0x7cd1;
	__map_gbk2utf16[0x3b0c] = 0x7cd2;
	__map_gbk2utf16[0x3b0d] = 0x7cd3;
	__map_gbk2utf16[0x3b0e] = 0x7cd4;
	__map_gbk2utf16[0x3b0f] = 0x7cd8;
	__map_gbk2utf16[0x3b10] = 0x7cda;
	__map_gbk2utf16[0x3b11] = 0x7cdb;
	__map_gbk2utf16[0x3b12] = 0x7cdd;
	__map_gbk2utf16[0x3b13] = 0x7cde;
	__map_gbk2utf16[0x3b14] = 0x7ce1;
	__map_gbk2utf16[0x3b15] = 0x7ce2;
	__map_gbk2utf16[0x3b16] = 0x7ce3;
	__map_gbk2utf16[0x3b17] = 0x7ce4;
	__map_gbk2utf16[0x3b18] = 0x7ce5;
	__map_gbk2utf16[0x3b19] = 0x7ce6;
	__map_gbk2utf16[0x3b1a] = 0x7ce7;
	__map_gbk2utf16[0x3b1b] = 0x7ce9;
	__map_gbk2utf16[0x3b1c] = 0x7cea;
	__map_gbk2utf16[0x3b1d] = 0x7ceb;
	__map_gbk2utf16[0x3b1e] = 0x7cec;
	__map_gbk2utf16[0x3b1f] = 0x7ced;
	__map_gbk2utf16[0x3b20] = 0x7cee;
	__map_gbk2utf16[0x3b21] = 0x7cf0;
	__map_gbk2utf16[0x3b22] = 0x7cf1;
	__map_gbk2utf16[0x3b23] = 0x7cf2;
	__map_gbk2utf16[0x3b24] = 0x7cf3;
	__map_gbk2utf16[0x3b25] = 0x7cf4;
	__map_gbk2utf16[0x3b26] = 0x7cf5;
	__map_gbk2utf16[0x3b27] = 0x7cf6;
	__map_gbk2utf16[0x3b28] = 0x7cf7;
	__map_gbk2utf16[0x3b29] = 0x7cf9;
	__map_gbk2utf16[0x3b2a] = 0x7cfa;
	__map_gbk2utf16[0x3b2b] = 0x7cfc;
	__map_gbk2utf16[0x3b2c] = 0x7cfd;
	__map_gbk2utf16[0x3b2d] = 0x7cfe;
	__map_gbk2utf16[0x3b2e] = 0x7cff;
	__map_gbk2utf16[0x3b2f] = 0x7d00;
	__map_gbk2utf16[0x3b30] = 0x7d01;
	__map_gbk2utf16[0x3b31] = 0x7d02;
	__map_gbk2utf16[0x3b32] = 0x7d03;
	__map_gbk2utf16[0x3b33] = 0x7d04;
	__map_gbk2utf16[0x3b34] = 0x7d05;
	__map_gbk2utf16[0x3b35] = 0x7d06;
	__map_gbk2utf16[0x3b36] = 0x7d07;
	__map_gbk2utf16[0x3b37] = 0x7d08;
	__map_gbk2utf16[0x3b38] = 0x7d09;
	__map_gbk2utf16[0x3b39] = 0x7d0b;
	__map_gbk2utf16[0x3b3a] = 0x7d0c;
	__map_gbk2utf16[0x3b3b] = 0x7d0d;
	__map_gbk2utf16[0x3b3c] = 0x7d0e;
	__map_gbk2utf16[0x3b3d] = 0x7d0f;
	__map_gbk2utf16[0x3b3e] = 0x7d10;
	__map_gbk2utf16[0x3b40] = 0x7d11;
	__map_gbk2utf16[0x3b41] = 0x7d12;
	__map_gbk2utf16[0x3b42] = 0x7d13;
	__map_gbk2utf16[0x3b43] = 0x7d14;
	__map_gbk2utf16[0x3b44] = 0x7d15;
	__map_gbk2utf16[0x3b45] = 0x7d16;
	__map_gbk2utf16[0x3b46] = 0x7d17;
	__map_gbk2utf16[0x3b47] = 0x7d18;
	__map_gbk2utf16[0x3b48] = 0x7d19;
	__map_gbk2utf16[0x3b49] = 0x7d1a;
	__map_gbk2utf16[0x3b4a] = 0x7d1b;
	__map_gbk2utf16[0x3b4b] = 0x7d1c;
	__map_gbk2utf16[0x3b4c] = 0x7d1d;
	__map_gbk2utf16[0x3b4d] = 0x7d1e;
	__map_gbk2utf16[0x3b4e] = 0x7d1f;
	__map_gbk2utf16[0x3b4f] = 0x7d21;
	__map_gbk2utf16[0x3b50] = 0x7d23;
	__map_gbk2utf16[0x3b51] = 0x7d24;
	__map_gbk2utf16[0x3b52] = 0x7d25;
	__map_gbk2utf16[0x3b53] = 0x7d26;
	__map_gbk2utf16[0x3b54] = 0x7d28;
	__map_gbk2utf16[0x3b55] = 0x7d29;
	__map_gbk2utf16[0x3b56] = 0x7d2a;
	__map_gbk2utf16[0x3b57] = 0x7d2c;
	__map_gbk2utf16[0x3b58] = 0x7d2d;
	__map_gbk2utf16[0x3b59] = 0x7d2e;
	__map_gbk2utf16[0x3b5a] = 0x7d30;
	__map_gbk2utf16[0x3b5b] = 0x7d31;
	__map_gbk2utf16[0x3b5c] = 0x7d32;
	__map_gbk2utf16[0x3b5d] = 0x7d33;
	__map_gbk2utf16[0x3b5e] = 0x7d34;
	__map_gbk2utf16[0x3b5f] = 0x7d35;
	__map_gbk2utf16[0x3b60] = 0x7d36;
	__map_gbk2utf16[0x3b61] = 0x808c;
	__map_gbk2utf16[0x3b62] = 0x9965;
	__map_gbk2utf16[0x3b63] = 0x8ff9;
	__map_gbk2utf16[0x3b64] = 0x6fc0;
	__map_gbk2utf16[0x3b65] = 0x8ba5;
	__map_gbk2utf16[0x3b66] = 0x9e21;
	__map_gbk2utf16[0x3b67] = 0x59ec;
	__map_gbk2utf16[0x3b68] = 0x7ee9;
	__map_gbk2utf16[0x3b69] = 0x7f09;
	__map_gbk2utf16[0x3b6a] = 0x5409;
	__map_gbk2utf16[0x3b6b] = 0x6781;
	__map_gbk2utf16[0x3b6c] = 0x68d8;
	__map_gbk2utf16[0x3b6d] = 0x8f91;
	__map_gbk2utf16[0x3b6e] = 0x7c4d;
	__map_gbk2utf16[0x3b6f] = 0x96c6;
	__map_gbk2utf16[0x3b70] = 0x53ca;
	__map_gbk2utf16[0x3b71] = 0x6025;
	__map_gbk2utf16[0x3b72] = 0x75be;
	__map_gbk2utf16[0x3b73] = 0x6c72;
	__map_gbk2utf16[0x3b74] = 0x5373;
	__map_gbk2utf16[0x3b75] = 0x5ac9;
	__map_gbk2utf16[0x3b76] = 0x7ea7;
	__map_gbk2utf16[0x3b77] = 0x6324;
	__map_gbk2utf16[0x3b78] = 0x51e0;
	__map_gbk2utf16[0x3b79] = 0x810a;
	__map_gbk2utf16[0x3b7a] = 0x5df1;
	__map_gbk2utf16[0x3b7b] = 0x84df;
	__map_gbk2utf16[0x3b7c] = 0x6280;
	__map_gbk2utf16[0x3b7d] = 0x5180;
	__map_gbk2utf16[0x3b7e] = 0x5b63;
	__map_gbk2utf16[0x3b7f] = 0x4f0e;
	__map_gbk2utf16[0x3b80] = 0x796d;
	__map_gbk2utf16[0x3b81] = 0x5242;
	__map_gbk2utf16[0x3b82] = 0x60b8;
	__map_gbk2utf16[0x3b83] = 0x6d4e;
	__map_gbk2utf16[0x3b84] = 0x5bc4;
	__map_gbk2utf16[0x3b85] = 0x5bc2;
	__map_gbk2utf16[0x3b86] = 0x8ba1;
	__map_gbk2utf16[0x3b87] = 0x8bb0;
	__map_gbk2utf16[0x3b88] = 0x65e2;
	__map_gbk2utf16[0x3b89] = 0x5fcc;
	__map_gbk2utf16[0x3b8a] = 0x9645;
	__map_gbk2utf16[0x3b8b] = 0x5993;
	__map_gbk2utf16[0x3b8c] = 0x7ee7;
	__map_gbk2utf16[0x3b8d] = 0x7eaa;
	__map_gbk2utf16[0x3b8e] = 0x5609;
	__map_gbk2utf16[0x3b8f] = 0x67b7;
	__map_gbk2utf16[0x3b90] = 0x5939;
	__map_gbk2utf16[0x3b91] = 0x4f73;
	__map_gbk2utf16[0x3b92] = 0x5bb6;
	__map_gbk2utf16[0x3b93] = 0x52a0;
	__map_gbk2utf16[0x3b94] = 0x835a;
	__map_gbk2utf16[0x3b95] = 0x988a;
	__map_gbk2utf16[0x3b96] = 0x8d3e;
	__map_gbk2utf16[0x3b97] = 0x7532;
	__map_gbk2utf16[0x3b98] = 0x94be;
	__map_gbk2utf16[0x3b99] = 0x5047;
	__map_gbk2utf16[0x3b9a] = 0x7a3c;
	__map_gbk2utf16[0x3b9b] = 0x4ef7;
	__map_gbk2utf16[0x3b9c] = 0x67b6;
	__map_gbk2utf16[0x3b9d] = 0x9a7e;
	__map_gbk2utf16[0x3b9e] = 0x5ac1;
	__map_gbk2utf16[0x3b9f] = 0x6b7c;
	__map_gbk2utf16[0x3ba0] = 0x76d1;
	__map_gbk2utf16[0x3ba1] = 0x575a;
	__map_gbk2utf16[0x3ba2] = 0x5c16;
	__map_gbk2utf16[0x3ba3] = 0x7b3a;
	__map_gbk2utf16[0x3ba4] = 0x95f4;
	__map_gbk2utf16[0x3ba5] = 0x714e;
	__map_gbk2utf16[0x3ba6] = 0x517c;
	__map_gbk2utf16[0x3ba7] = 0x80a9;
	__map_gbk2utf16[0x3ba8] = 0x8270;
	__map_gbk2utf16[0x3ba9] = 0x5978;
	__map_gbk2utf16[0x3baa] = 0x7f04;
	__map_gbk2utf16[0x3bab] = 0x8327;
	__map_gbk2utf16[0x3bac] = 0x68c0;
	__map_gbk2utf16[0x3bad] = 0x67ec;
	__map_gbk2utf16[0x3bae] = 0x78b1;
	__map_gbk2utf16[0x3baf] = 0x7877;
	__map_gbk2utf16[0x3bb0] = 0x62e3;
	__map_gbk2utf16[0x3bb1] = 0x6361;
	__map_gbk2utf16[0x3bb2] = 0x7b80;
	__map_gbk2utf16[0x3bb3] = 0x4fed;
	__map_gbk2utf16[0x3bb4] = 0x526a;
	__map_gbk2utf16[0x3bb5] = 0x51cf;
	__map_gbk2utf16[0x3bb6] = 0x8350;
	__map_gbk2utf16[0x3bb7] = 0x69db;
	__map_gbk2utf16[0x3bb8] = 0x9274;
	__map_gbk2utf16[0x3bb9] = 0x8df5;
	__map_gbk2utf16[0x3bba] = 0x8d31;
	__map_gbk2utf16[0x3bbb] = 0x89c1;
	__map_gbk2utf16[0x3bbc] = 0x952e;
	__map_gbk2utf16[0x3bbd] = 0x7bad;
	__map_gbk2utf16[0x3bbe] = 0x4ef6;
	__map_gbk2utf16[0x3c00] = 0x7d37;
	__map_gbk2utf16[0x3c01] = 0x7d38;
	__map_gbk2utf16[0x3c02] = 0x7d39;
	__map_gbk2utf16[0x3c03] = 0x7d3a;
	__map_gbk2utf16[0x3c04] = 0x7d3b;
	__map_gbk2utf16[0x3c05] = 0x7d3c;
	__map_gbk2utf16[0x3c06] = 0x7d3d;
	__map_gbk2utf16[0x3c07] = 0x7d3e;
	__map_gbk2utf16[0x3c08] = 0x7d3f;
	__map_gbk2utf16[0x3c09] = 0x7d40;
	__map_gbk2utf16[0x3c0a] = 0x7d41;
	__map_gbk2utf16[0x3c0b] = 0x7d42;
	__map_gbk2utf16[0x3c0c] = 0x7d43;
	__map_gbk2utf16[0x3c0d] = 0x7d44;
	__map_gbk2utf16[0x3c0e] = 0x7d45;
	__map_gbk2utf16[0x3c0f] = 0x7d46;
	__map_gbk2utf16[0x3c10] = 0x7d47;
	__map_gbk2utf16[0x3c11] = 0x7d48;
	__map_gbk2utf16[0x3c12] = 0x7d49;
	__map_gbk2utf16[0x3c13] = 0x7d4a;
	__map_gbk2utf16[0x3c14] = 0x7d4b;
	__map_gbk2utf16[0x3c15] = 0x7d4c;
	__map_gbk2utf16[0x3c16] = 0x7d4d;
	__map_gbk2utf16[0x3c17] = 0x7d4e;
	__map_gbk2utf16[0x3c18] = 0x7d4f;
	__map_gbk2utf16[0x3c19] = 0x7d50;
	__map_gbk2utf16[0x3c1a] = 0x7d51;
	__map_gbk2utf16[0x3c1b] = 0x7d52;
	__map_gbk2utf16[0x3c1c] = 0x7d53;
	__map_gbk2utf16[0x3c1d] = 0x7d54;
	__map_gbk2utf16[0x3c1e] = 0x7d55;
	__map_gbk2utf16[0x3c1f] = 0x7d56;
	__map_gbk2utf16[0x3c20] = 0x7d57;
	__map_gbk2utf16[0x3c21] = 0x7d58;
	__map_gbk2utf16[0x3c22] = 0x7d59;
	__map_gbk2utf16[0x3c23] = 0x7d5a;
	__map_gbk2utf16[0x3c24] = 0x7d5b;
	__map_gbk2utf16[0x3c25] = 0x7d5c;
	__map_gbk2utf16[0x3c26] = 0x7d5d;
	__map_gbk2utf16[0x3c27] = 0x7d5e;
	__map_gbk2utf16[0x3c28] = 0x7d5f;
	__map_gbk2utf16[0x3c29] = 0x7d60;
	__map_gbk2utf16[0x3c2a] = 0x7d61;
	__map_gbk2utf16[0x3c2b] = 0x7d62;
	__map_gbk2utf16[0x3c2c] = 0x7d63;
	__map_gbk2utf16[0x3c2d] = 0x7d64;
	__map_gbk2utf16[0x3c2e] = 0x7d65;
	__map_gbk2utf16[0x3c2f] = 0x7d66;
	__map_gbk2utf16[0x3c30] = 0x7d67;
	__map_gbk2utf16[0x3c31] = 0x7d68;
	__map_gbk2utf16[0x3c32] = 0x7d69;
	__map_gbk2utf16[0x3c33] = 0x7d6a;
	__map_gbk2utf16[0x3c34] = 0x7d6b;
	__map_gbk2utf16[0x3c35] = 0x7d6c;
	__map_gbk2utf16[0x3c36] = 0x7d6d;
	__map_gbk2utf16[0x3c37] = 0x7d6f;
	__map_gbk2utf16[0x3c38] = 0x7d70;
	__map_gbk2utf16[0x3c39] = 0x7d71;
	__map_gbk2utf16[0x3c3a] = 0x7d72;
	__map_gbk2utf16[0x3c3b] = 0x7d73;
	__map_gbk2utf16[0x3c3c] = 0x7d74;
	__map_gbk2utf16[0x3c3d] = 0x7d75;
	__map_gbk2utf16[0x3c3e] = 0x7d76;
	__map_gbk2utf16[0x3c40] = 0x7d78;
	__map_gbk2utf16[0x3c41] = 0x7d79;
	__map_gbk2utf16[0x3c42] = 0x7d7a;
	__map_gbk2utf16[0x3c43] = 0x7d7b;
	__map_gbk2utf16[0x3c44] = 0x7d7c;
	__map_gbk2utf16[0x3c45] = 0x7d7d;
	__map_gbk2utf16[0x3c46] = 0x7d7e;
	__map_gbk2utf16[0x3c47] = 0x7d7f;
	__map_gbk2utf16[0x3c48] = 0x7d80;
	__map_gbk2utf16[0x3c49] = 0x7d81;
	__map_gbk2utf16[0x3c4a] = 0x7d82;
	__map_gbk2utf16[0x3c4b] = 0x7d83;
	__map_gbk2utf16[0x3c4c] = 0x7d84;
	__map_gbk2utf16[0x3c4d] = 0x7d85;
	__map_gbk2utf16[0x3c4e] = 0x7d86;
	__map_gbk2utf16[0x3c4f] = 0x7d87;
	__map_gbk2utf16[0x3c50] = 0x7d88;
	__map_gbk2utf16[0x3c51] = 0x7d89;
	__map_gbk2utf16[0x3c52] = 0x7d8a;
	__map_gbk2utf16[0x3c53] = 0x7d8b;
	__map_gbk2utf16[0x3c54] = 0x7d8c;
	__map_gbk2utf16[0x3c55] = 0x7d8d;
	__map_gbk2utf16[0x3c56] = 0x7d8e;
	__map_gbk2utf16[0x3c57] = 0x7d8f;
	__map_gbk2utf16[0x3c58] = 0x7d90;
	__map_gbk2utf16[0x3c59] = 0x7d91;
	__map_gbk2utf16[0x3c5a] = 0x7d92;
	__map_gbk2utf16[0x3c5b] = 0x7d93;
	__map_gbk2utf16[0x3c5c] = 0x7d94;
	__map_gbk2utf16[0x3c5d] = 0x7d95;
	__map_gbk2utf16[0x3c5e] = 0x7d96;
	__map_gbk2utf16[0x3c5f] = 0x7d97;
	__map_gbk2utf16[0x3c60] = 0x7d98;
	__map_gbk2utf16[0x3c61] = 0x5065;
	__map_gbk2utf16[0x3c62] = 0x8230;
	__map_gbk2utf16[0x3c63] = 0x5251;
	__map_gbk2utf16[0x3c64] = 0x996f;
	__map_gbk2utf16[0x3c65] = 0x6e10;
	__map_gbk2utf16[0x3c66] = 0x6e85;
	__map_gbk2utf16[0x3c67] = 0x6da7;
	__map_gbk2utf16[0x3c68] = 0x5efa;
	__map_gbk2utf16[0x3c69] = 0x50f5;
	__map_gbk2utf16[0x3c6a] = 0x59dc;
	__map_gbk2utf16[0x3c6b] = 0x5c06;
	__map_gbk2utf16[0x3c6c] = 0x6d46;
	__map_gbk2utf16[0x3c6d] = 0x6c5f;
	__map_gbk2utf16[0x3c6e] = 0x7586;
	__map_gbk2utf16[0x3c6f] = 0x848b;
	__map_gbk2utf16[0x3c70] = 0x6868;
	__map_gbk2utf16[0x3c71] = 0x5956;
	__map_gbk2utf16[0x3c72] = 0x8bb2;
	__map_gbk2utf16[0x3c73] = 0x5320;
	__map_gbk2utf16[0x3c74] = 0x9171;
	__map_gbk2utf16[0x3c75] = 0x964d;
	__map_gbk2utf16[0x3c76] = 0x8549;
	__map_gbk2utf16[0x3c77] = 0x6912;
	__map_gbk2utf16[0x3c78] = 0x7901;
	__map_gbk2utf16[0x3c79] = 0x7126;
	__map_gbk2utf16[0x3c7a] = 0x80f6;
	__map_gbk2utf16[0x3c7b] = 0x4ea4;
	__map_gbk2utf16[0x3c7c] = 0x90ca;
	__map_gbk2utf16[0x3c7d] = 0x6d47;
	__map_gbk2utf16[0x3c7e] = 0x9a84;
	__map_gbk2utf16[0x3c7f] = 0x5a07;
	__map_gbk2utf16[0x3c80] = 0x56bc;
	__map_gbk2utf16[0x3c81] = 0x6405;
	__map_gbk2utf16[0x3c82] = 0x94f0;
	__map_gbk2utf16[0x3c83] = 0x77eb;
	__map_gbk2utf16[0x3c84] = 0x4fa5;
	__map_gbk2utf16[0x3c85] = 0x811a;
	__map_gbk2utf16[0x3c86] = 0x72e1;
	__map_gbk2utf16[0x3c87] = 0x89d2;
	__map_gbk2utf16[0x3c88] = 0x997a;
	__map_gbk2utf16[0x3c89] = 0x7f34;
	__map_gbk2utf16[0x3c8a] = 0x7ede;
	__map_gbk2utf16[0x3c8b] = 0x527f;
	__map_gbk2utf16[0x3c8c] = 0x6559;
	__map_gbk2utf16[0x3c8d] = 0x9175;
	__map_gbk2utf16[0x3c8e] = 0x8f7f;
	__map_gbk2utf16[0x3c8f] = 0x8f83;
	__map_gbk2utf16[0x3c90] = 0x53eb;
	__map_gbk2utf16[0x3c91] = 0x7a96;
	__map_gbk2utf16[0x3c92] = 0x63ed;
	__map_gbk2utf16[0x3c93] = 0x63a5;
	__map_gbk2utf16[0x3c94] = 0x7686;
	__map_gbk2utf16[0x3c95] = 0x79f8;
	__map_gbk2utf16[0x3c96] = 0x8857;
	__map_gbk2utf16[0x3c97] = 0x9636;
	__map_gbk2utf16[0x3c98] = 0x622a;
	__map_gbk2utf16[0x3c99] = 0x52ab;
	__map_gbk2utf16[0x3c9a] = 0x8282;
	__map_gbk2utf16[0x3c9b] = 0x6854;
	__map_gbk2utf16[0x3c9c] = 0x6770;
	__map_gbk2utf16[0x3c9d] = 0x6377;
	__map_gbk2utf16[0x3c9e] = 0x776b;
	__map_gbk2utf16[0x3c9f] = 0x7aed;
	__map_gbk2utf16[0x3ca0] = 0x6d01;
	__map_gbk2utf16[0x3ca1] = 0x7ed3;
	__map_gbk2utf16[0x3ca2] = 0x89e3;
	__map_gbk2utf16[0x3ca3] = 0x59d0;
	__map_gbk2utf16[0x3ca4] = 0x6212;
	__map_gbk2utf16[0x3ca5] = 0x85c9;
	__map_gbk2utf16[0x3ca6] = 0x82a5;
	__map_gbk2utf16[0x3ca7] = 0x754c;
	__map_gbk2utf16[0x3ca8] = 0x501f;
	__map_gbk2utf16[0x3ca9] = 0x4ecb;
	__map_gbk2utf16[0x3caa] = 0x75a5;
	__map_gbk2utf16[0x3cab] = 0x8beb;
	__map_gbk2utf16[0x3cac] = 0x5c4a;
	__map_gbk2utf16[0x3cad] = 0x5dfe;
	__map_gbk2utf16[0x3cae] = 0x7b4b;
	__map_gbk2utf16[0x3caf] = 0x65a4;
	__map_gbk2utf16[0x3cb0] = 0x91d1;
	__map_gbk2utf16[0x3cb1] = 0x4eca;
	__map_gbk2utf16[0x3cb2] = 0x6d25;
	__map_gbk2utf16[0x3cb3] = 0x895f;
	__map_gbk2utf16[0x3cb4] = 0x7d27;
	__map_gbk2utf16[0x3cb5] = 0x9526;
	__map_gbk2utf16[0x3cb6] = 0x4ec5;
	__map_gbk2utf16[0x3cb7] = 0x8c28;
	__map_gbk2utf16[0x3cb8] = 0x8fdb;
	__map_gbk2utf16[0x3cb9] = 0x9773;
	__map_gbk2utf16[0x3cba] = 0x664b;
	__map_gbk2utf16[0x3cbb] = 0x7981;
	__map_gbk2utf16[0x3cbc] = 0x8fd1;
	__map_gbk2utf16[0x3cbd] = 0x70ec;
	__map_gbk2utf16[0x3cbe] = 0x6d78;
	__map_gbk2utf16[0x3d00] = 0x7d99;
	__map_gbk2utf16[0x3d01] = 0x7d9a;
	__map_gbk2utf16[0x3d02] = 0x7d9b;
	__map_gbk2utf16[0x3d03] = 0x7d9c;
	__map_gbk2utf16[0x3d04] = 0x7d9d;
	__map_gbk2utf16[0x3d05] = 0x7d9e;
	__map_gbk2utf16[0x3d06] = 0x7d9f;
	__map_gbk2utf16[0x3d07] = 0x7da0;
	__map_gbk2utf16[0x3d08] = 0x7da1;
	__map_gbk2utf16[0x3d09] = 0x7da2;
	__map_gbk2utf16[0x3d0a] = 0x7da3;
	__map_gbk2utf16[0x3d0b] = 0x7da4;
	__map_gbk2utf16[0x3d0c] = 0x7da5;
	__map_gbk2utf16[0x3d0d] = 0x7da7;
	__map_gbk2utf16[0x3d0e] = 0x7da8;
	__map_gbk2utf16[0x3d0f] = 0x7da9;
	__map_gbk2utf16[0x3d10] = 0x7daa;
	__map_gbk2utf16[0x3d11] = 0x7dab;
	__map_gbk2utf16[0x3d12] = 0x7dac;
	__map_gbk2utf16[0x3d13] = 0x7dad;
	__map_gbk2utf16[0x3d14] = 0x7daf;
	__map_gbk2utf16[0x3d15] = 0x7db0;
	__map_gbk2utf16[0x3d16] = 0x7db1;
	__map_gbk2utf16[0x3d17] = 0x7db2;
	__map_gbk2utf16[0x3d18] = 0x7db3;
	__map_gbk2utf16[0x3d19] = 0x7db4;
	__map_gbk2utf16[0x3d1a] = 0x7db5;
	__map_gbk2utf16[0x3d1b] = 0x7db6;
	__map_gbk2utf16[0x3d1c] = 0x7db7;
	__map_gbk2utf16[0x3d1d] = 0x7db8;
	__map_gbk2utf16[0x3d1e] = 0x7db9;
	__map_gbk2utf16[0x3d1f] = 0x7dba;
	__map_gbk2utf16[0x3d20] = 0x7dbb;
	__map_gbk2utf16[0x3d21] = 0x7dbc;
	__map_gbk2utf16[0x3d22] = 0x7dbd;
	__map_gbk2utf16[0x3d23] = 0x7dbe;
	__map_gbk2utf16[0x3d24] = 0x7dbf;
	__map_gbk2utf16[0x3d25] = 0x7dc0;
	__map_gbk2utf16[0x3d26] = 0x7dc1;
	__map_gbk2utf16[0x3d27] = 0x7dc2;
	__map_gbk2utf16[0x3d28] = 0x7dc3;
	__map_gbk2utf16[0x3d29] = 0x7dc4;
	__map_gbk2utf16[0x3d2a] = 0x7dc5;
	__map_gbk2utf16[0x3d2b] = 0x7dc6;
	__map_gbk2utf16[0x3d2c] = 0x7dc7;
	__map_gbk2utf16[0x3d2d] = 0x7dc8;
	__map_gbk2utf16[0x3d2e] = 0x7dc9;
	__map_gbk2utf16[0x3d2f] = 0x7dca;
	__map_gbk2utf16[0x3d30] = 0x7dcb;
	__map_gbk2utf16[0x3d31] = 0x7dcc;
	__map_gbk2utf16[0x3d32] = 0x7dcd;
	__map_gbk2utf16[0x3d33] = 0x7dce;
	__map_gbk2utf16[0x3d34] = 0x7dcf;
	__map_gbk2utf16[0x3d35] = 0x7dd0;
	__map_gbk2utf16[0x3d36] = 0x7dd1;
	__map_gbk2utf16[0x3d37] = 0x7dd2;
	__map_gbk2utf16[0x3d38] = 0x7dd3;
	__map_gbk2utf16[0x3d39] = 0x7dd4;
	__map_gbk2utf16[0x3d3a] = 0x7dd5;
	__map_gbk2utf16[0x3d3b] = 0x7dd6;
	__map_gbk2utf16[0x3d3c] = 0x7dd7;
	__map_gbk2utf16[0x3d3d] = 0x7dd8;
	__map_gbk2utf16[0x3d3e] = 0x7dd9;
	__map_gbk2utf16[0x3d40] = 0x7dda;
	__map_gbk2utf16[0x3d41] = 0x7ddb;
	__map_gbk2utf16[0x3d42] = 0x7ddc;
	__map_gbk2utf16[0x3d43] = 0x7ddd;
	__map_gbk2utf16[0x3d44] = 0x7dde;
	__map_gbk2utf16[0x3d45] = 0x7ddf;
	__map_gbk2utf16[0x3d46] = 0x7de0;
	__map_gbk2utf16[0x3d47] = 0x7de1;
	__map_gbk2utf16[0x3d48] = 0x7de2;
	__map_gbk2utf16[0x3d49] = 0x7de3;
	__map_gbk2utf16[0x3d4a] = 0x7de4;
	__map_gbk2utf16[0x3d4b] = 0x7de5;
	__map_gbk2utf16[0x3d4c] = 0x7de6;
	__map_gbk2utf16[0x3d4d] = 0x7de7;
	__map_gbk2utf16[0x3d4e] = 0x7de8;
	__map_gbk2utf16[0x3d4f] = 0x7de9;
	__map_gbk2utf16[0x3d50] = 0x7dea;
	__map_gbk2utf16[0x3d51] = 0x7deb;
	__map_gbk2utf16[0x3d52] = 0x7dec;
	__map_gbk2utf16[0x3d53] = 0x7ded;
	__map_gbk2utf16[0x3d54] = 0x7dee;
	__map_gbk2utf16[0x3d55] = 0x7def;
	__map_gbk2utf16[0x3d56] = 0x7df0;
	__map_gbk2utf16[0x3d57] = 0x7df1;
	__map_gbk2utf16[0x3d58] = 0x7df2;
	__map_gbk2utf16[0x3d59] = 0x7df3;
	__map_gbk2utf16[0x3d5a] = 0x7df4;
	__map_gbk2utf16[0x3d5b] = 0x7df5;
	__map_gbk2utf16[0x3d5c] = 0x7df6;
	__map_gbk2utf16[0x3d5d] = 0x7df7;
	__map_gbk2utf16[0x3d5e] = 0x7df8;
	__map_gbk2utf16[0x3d5f] = 0x7df9;
	__map_gbk2utf16[0x3d60] = 0x7dfa;
	__map_gbk2utf16[0x3d61] = 0x5c3d;
	__map_gbk2utf16[0x3d62] = 0x52b2;
	__map_gbk2utf16[0x3d63] = 0x8346;
	__map_gbk2utf16[0x3d64] = 0x5162;
	__map_gbk2utf16[0x3d65] = 0x830e;
	__map_gbk2utf16[0x3d66] = 0x775b;
	__map_gbk2utf16[0x3d67] = 0x6676;
	__map_gbk2utf16[0x3d68] = 0x9cb8;
	__map_gbk2utf16[0x3d69] = 0x4eac;
	__map_gbk2utf16[0x3d6a] = 0x60ca;
	__map_gbk2utf16[0x3d6b] = 0x7cbe;
	__map_gbk2utf16[0x3d6c] = 0x7cb3;
	__map_gbk2utf16[0x3d6d] = 0x7ecf;
	__map_gbk2utf16[0x3d6e] = 0x4e95;
	__map_gbk2utf16[0x3d6f] = 0x8b66;
	__map_gbk2utf16[0x3d70] = 0x666f;
	__map_gbk2utf16[0x3d71] = 0x9888;
	__map_gbk2utf16[0x3d72] = 0x9759;
	__map_gbk2utf16[0x3d73] = 0x5883;
	__map_gbk2utf16[0x3d74] = 0x656c;
	__map_gbk2utf16[0x3d75] = 0x955c;
	__map_gbk2utf16[0x3d76] = 0x5f84;
	__map_gbk2utf16[0x3d77] = 0x75c9;
	__map_gbk2utf16[0x3d78] = 0x9756;
	__map_gbk2utf16[0x3d79] = 0x7adf;
	__map_gbk2utf16[0x3d7a] = 0x7ade;
	__map_gbk2utf16[0x3d7b] = 0x51c0;
	__map_gbk2utf16[0x3d7c] = 0x70af;
	__map_gbk2utf16[0x3d7d] = 0x7a98;
	__map_gbk2utf16[0x3d7e] = 0x63ea;
	__map_gbk2utf16[0x3d7f] = 0x7a76;
	__map_gbk2utf16[0x3d80] = 0x7ea0;
	__map_gbk2utf16[0x3d81] = 0x7396;
	__map_gbk2utf16[0x3d82] = 0x97ed;
	__map_gbk2utf16[0x3d83] = 0x4e45;
	__map_gbk2utf16[0x3d84] = 0x7078;
	__map_gbk2utf16[0x3d85] = 0x4e5d;
	__map_gbk2utf16[0x3d86] = 0x9152;
	__map_gbk2utf16[0x3d87] = 0x53a9;
	__map_gbk2utf16[0x3d88] = 0x6551;
	__map_gbk2utf16[0x3d89] = 0x65e7;
	__map_gbk2utf16[0x3d8a] = 0x81fc;
	__map_gbk2utf16[0x3d8b] = 0x8205;
	__map_gbk2utf16[0x3d8c] = 0x548e;
	__map_gbk2utf16[0x3d8d] = 0x5c31;
	__map_gbk2utf16[0x3d8e] = 0x759a;
	__map_gbk2utf16[0x3d8f] = 0x97a0;
	__map_gbk2utf16[0x3d90] = 0x62d8;
	__map_gbk2utf16[0x3d91] = 0x72d9;
	__map_gbk2utf16[0x3d92] = 0x75bd;
	__map_gbk2utf16[0x3d93] = 0x5c45;
	__map_gbk2utf16[0x3d94] = 0x9a79;
	__map_gbk2utf16[0x3d95] = 0x83ca;
	__map_gbk2utf16[0x3d96] = 0x5c40;
	__map_gbk2utf16[0x3d97] = 0x5480;
	__map_gbk2utf16[0x3d98] = 0x77e9;
	__map_gbk2utf16[0x3d99] = 0x4e3e;
	__map_gbk2utf16[0x3d9a] = 0x6cae;
	__map_gbk2utf16[0x3d9b] = 0x805a;
	__map_gbk2utf16[0x3d9c] = 0x62d2;
	__map_gbk2utf16[0x3d9d] = 0x636e;
	__map_gbk2utf16[0x3d9e] = 0x5de8;
	__map_gbk2utf16[0x3d9f] = 0x5177;
	__map_gbk2utf16[0x3da0] = 0x8ddd;
	__map_gbk2utf16[0x3da1] = 0x8e1e;
	__map_gbk2utf16[0x3da2] = 0x952f;
	__map_gbk2utf16[0x3da3] = 0x4ff1;
	__map_gbk2utf16[0x3da4] = 0x53e5;
	__map_gbk2utf16[0x3da5] = 0x60e7;
	__map_gbk2utf16[0x3da6] = 0x70ac;
	__map_gbk2utf16[0x3da7] = 0x5267;
	__map_gbk2utf16[0x3da8] = 0x6350;
	__map_gbk2utf16[0x3da9] = 0x9e43;
	__map_gbk2utf16[0x3daa] = 0x5a1f;
	__map_gbk2utf16[0x3dab] = 0x5026;
	__map_gbk2utf16[0x3dac] = 0x7737;
	__map_gbk2utf16[0x3dad] = 0x5377;
	__map_gbk2utf16[0x3dae] = 0x7ee2;
	__map_gbk2utf16[0x3daf] = 0x6485;
	__map_gbk2utf16[0x3db0] = 0x652b;
	__map_gbk2utf16[0x3db1] = 0x6289;
	__map_gbk2utf16[0x3db2] = 0x6398;
	__map_gbk2utf16[0x3db3] = 0x5014;
	__map_gbk2utf16[0x3db4] = 0x7235;
	__map_gbk2utf16[0x3db5] = 0x89c9;
	__map_gbk2utf16[0x3db6] = 0x51b3;
	__map_gbk2utf16[0x3db7] = 0x8bc0;
	__map_gbk2utf16[0x3db8] = 0x7edd;
	__map_gbk2utf16[0x3db9] = 0x5747;
	__map_gbk2utf16[0x3dba] = 0x83cc;
	__map_gbk2utf16[0x3dbb] = 0x94a7;
	__map_gbk2utf16[0x3dbc] = 0x519b;
	__map_gbk2utf16[0x3dbd] = 0x541b;
	__map_gbk2utf16[0x3dbe] = 0x5cfb;
	__map_gbk2utf16[0x3e00] = 0x7dfb;
	__map_gbk2utf16[0x3e01] = 0x7dfc;
	__map_gbk2utf16[0x3e02] = 0x7dfd;
	__map_gbk2utf16[0x3e03] = 0x7dfe;
	__map_gbk2utf16[0x3e04] = 0x7dff;
	__map_gbk2utf16[0x3e05] = 0x7e00;
	__map_gbk2utf16[0x3e06] = 0x7e01;
	__map_gbk2utf16[0x3e07] = 0x7e02;
	__map_gbk2utf16[0x3e08] = 0x7e03;
	__map_gbk2utf16[0x3e09] = 0x7e04;
	__map_gbk2utf16[0x3e0a] = 0x7e05;
	__map_gbk2utf16[0x3e0b] = 0x7e06;
	__map_gbk2utf16[0x3e0c] = 0x7e07;
	__map_gbk2utf16[0x3e0d] = 0x7e08;
	__map_gbk2utf16[0x3e0e] = 0x7e09;
	__map_gbk2utf16[0x3e0f] = 0x7e0a;
	__map_gbk2utf16[0x3e10] = 0x7e0b;
	__map_gbk2utf16[0x3e11] = 0x7e0c;
	__map_gbk2utf16[0x3e12] = 0x7e0d;
	__map_gbk2utf16[0x3e13] = 0x7e0e;
	__map_gbk2utf16[0x3e14] = 0x7e0f;
	__map_gbk2utf16[0x3e15] = 0x7e10;
	__map_gbk2utf16[0x3e16] = 0x7e11;
	__map_gbk2utf16[0x3e17] = 0x7e12;
	__map_gbk2utf16[0x3e18] = 0x7e13;
	__map_gbk2utf16[0x3e19] = 0x7e14;
	__map_gbk2utf16[0x3e1a] = 0x7e15;
	__map_gbk2utf16[0x3e1b] = 0x7e16;
	__map_gbk2utf16[0x3e1c] = 0x7e17;
	__map_gbk2utf16[0x3e1d] = 0x7e18;
	__map_gbk2utf16[0x3e1e] = 0x7e19;
	__map_gbk2utf16[0x3e1f] = 0x7e1a;
	__map_gbk2utf16[0x3e20] = 0x7e1b;
	__map_gbk2utf16[0x3e21] = 0x7e1c;
	__map_gbk2utf16[0x3e22] = 0x7e1d;
	__map_gbk2utf16[0x3e23] = 0x7e1e;
	__map_gbk2utf16[0x3e24] = 0x7e1f;
	__map_gbk2utf16[0x3e25] = 0x7e20;
	__map_gbk2utf16[0x3e26] = 0x7e21;
	__map_gbk2utf16[0x3e27] = 0x7e22;
	__map_gbk2utf16[0x3e28] = 0x7e23;
	__map_gbk2utf16[0x3e29] = 0x7e24;
	__map_gbk2utf16[0x3e2a] = 0x7e25;
	__map_gbk2utf16[0x3e2b] = 0x7e26;
	__map_gbk2utf16[0x3e2c] = 0x7e27;
	__map_gbk2utf16[0x3e2d] = 0x7e28;
	__map_gbk2utf16[0x3e2e] = 0x7e29;
	__map_gbk2utf16[0x3e2f] = 0x7e2a;
	__map_gbk2utf16[0x3e30] = 0x7e2b;
	__map_gbk2utf16[0x3e31] = 0x7e2c;
	__map_gbk2utf16[0x3e32] = 0x7e2d;
	__map_gbk2utf16[0x3e33] = 0x7e2e;
	__map_gbk2utf16[0x3e34] = 0x7e2f;
	__map_gbk2utf16[0x3e35] = 0x7e30;
	__map_gbk2utf16[0x3e36] = 0x7e31;
	__map_gbk2utf16[0x3e37] = 0x7e32;
	__map_gbk2utf16[0x3e38] = 0x7e33;
	__map_gbk2utf16[0x3e39] = 0x7e34;
	__map_gbk2utf16[0x3e3a] = 0x7e35;
	__map_gbk2utf16[0x3e3b] = 0x7e36;
	__map_gbk2utf16[0x3e3c] = 0x7e37;
	__map_gbk2utf16[0x3e3d] = 0x7e38;
	__map_gbk2utf16[0x3e3e] = 0x7e39;
	__map_gbk2utf16[0x3e40] = 0x7e3a;
	__map_gbk2utf16[0x3e41] = 0x7e3c;
	__map_gbk2utf16[0x3e42] = 0x7e3d;
	__map_gbk2utf16[0x3e43] = 0x7e3e;
	__map_gbk2utf16[0x3e44] = 0x7e3f;
	__map_gbk2utf16[0x3e45] = 0x7e40;
	__map_gbk2utf16[0x3e46] = 0x7e42;
	__map_gbk2utf16[0x3e47] = 0x7e43;
	__map_gbk2utf16[0x3e48] = 0x7e44;
	__map_gbk2utf16[0x3e49] = 0x7e45;
	__map_gbk2utf16[0x3e4a] = 0x7e46;
	__map_gbk2utf16[0x3e4b] = 0x7e48;
	__map_gbk2utf16[0x3e4c] = 0x7e49;
	__map_gbk2utf16[0x3e4d] = 0x7e4a;
	__map_gbk2utf16[0x3e4e] = 0x7e4b;
	__map_gbk2utf16[0x3e4f] = 0x7e4c;
	__map_gbk2utf16[0x3e50] = 0x7e4d;
	__map_gbk2utf16[0x3e51] = 0x7e4e;
	__map_gbk2utf16[0x3e52] = 0x7e4f;
	__map_gbk2utf16[0x3e53] = 0x7e50;
	__map_gbk2utf16[0x3e54] = 0x7e51;
	__map_gbk2utf16[0x3e55] = 0x7e52;
	__map_gbk2utf16[0x3e56] = 0x7e53;
	__map_gbk2utf16[0x3e57] = 0x7e54;
	__map_gbk2utf16[0x3e58] = 0x7e55;
	__map_gbk2utf16[0x3e59] = 0x7e56;
	__map_gbk2utf16[0x3e5a] = 0x7e57;
	__map_gbk2utf16[0x3e5b] = 0x7e58;
	__map_gbk2utf16[0x3e5c] = 0x7e59;
	__map_gbk2utf16[0x3e5d] = 0x7e5a;
	__map_gbk2utf16[0x3e5e] = 0x7e5b;
	__map_gbk2utf16[0x3e5f] = 0x7e5c;
	__map_gbk2utf16[0x3e60] = 0x7e5d;
	__map_gbk2utf16[0x3e61] = 0x4fca;
	__map_gbk2utf16[0x3e62] = 0x7ae3;
	__map_gbk2utf16[0x3e63] = 0x6d5a;
	__map_gbk2utf16[0x3e64] = 0x90e1;
	__map_gbk2utf16[0x3e65] = 0x9a8f;
	__map_gbk2utf16[0x3e66] = 0x5580;
	__map_gbk2utf16[0x3e67] = 0x5496;
	__map_gbk2utf16[0x3e68] = 0x5361;
	__map_gbk2utf16[0x3e69] = 0x54af;
	__map_gbk2utf16[0x3e6a] = 0x5f00;
	__map_gbk2utf16[0x3e6b] = 0x63e9;
	__map_gbk2utf16[0x3e6c] = 0x6977;
	__map_gbk2utf16[0x3e6d] = 0x51ef;
	__map_gbk2utf16[0x3e6e] = 0x6168;
	__map_gbk2utf16[0x3e6f] = 0x520a;
	__map_gbk2utf16[0x3e70] = 0x582a;
	__map_gbk2utf16[0x3e71] = 0x52d8;
	__map_gbk2utf16[0x3e72] = 0x574e;
	__map_gbk2utf16[0x3e73] = 0x780d;
	__map_gbk2utf16[0x3e74] = 0x770b;
	__map_gbk2utf16[0x3e75] = 0x5eb7;
	__map_gbk2utf16[0x3e76] = 0x6177;
	__map_gbk2utf16[0x3e77] = 0x7ce0;
	__map_gbk2utf16[0x3e78] = 0x625b;
	__map_gbk2utf16[0x3e79] = 0x6297;
	__map_gbk2utf16[0x3e7a] = 0x4ea2;
	__map_gbk2utf16[0x3e7b] = 0x7095;
	__map_gbk2utf16[0x3e7c] = 0x8003;
	__map_gbk2utf16[0x3e7d] = 0x62f7;
	__map_gbk2utf16[0x3e7e] = 0x70e4;
	__map_gbk2utf16[0x3e7f] = 0x9760;
	__map_gbk2utf16[0x3e80] = 0x5777;
	__map_gbk2utf16[0x3e81] = 0x82db;
	__map_gbk2utf16[0x3e82] = 0x67ef;
	__map_gbk2utf16[0x3e83] = 0x68f5;
	__map_gbk2utf16[0x3e84] = 0x78d5;
	__map_gbk2utf16[0x3e85] = 0x9897;
	__map_gbk2utf16[0x3e86] = 0x79d1;
	__map_gbk2utf16[0x3e87] = 0x58f3;
	__map_gbk2utf16[0x3e88] = 0x54b3;
	__map_gbk2utf16[0x3e89] = 0x53ef;
	__map_gbk2utf16[0x3e8a] = 0x6e34;
	__map_gbk2utf16[0x3e8b] = 0x514b;
	__map_gbk2utf16[0x3e8c] = 0x523b;
	__map_gbk2utf16[0x3e8d] = 0x5ba2;
	__map_gbk2utf16[0x3e8e] = 0x8bfe;
	__map_gbk2utf16[0x3e8f] = 0x80af;
	__map_gbk2utf16[0x3e90] = 0x5543;
	__map_gbk2utf16[0x3e91] = 0x57a6;
	__map_gbk2utf16[0x3e92] = 0x6073;
	__map_gbk2utf16[0x3e93] = 0x5751;
	__map_gbk2utf16[0x3e94] = 0x542d;
	__map_gbk2utf16[0x3e95] = 0x7a7a;
	__map_gbk2utf16[0x3e96] = 0x6050;
	__map_gbk2utf16[0x3e97] = 0x5b54;
	__map_gbk2utf16[0x3e98] = 0x63a7;
	__map_gbk2utf16[0x3e99] = 0x62a0;
	__map_gbk2utf16[0x3e9a] = 0x53e3;
	__map_gbk2utf16[0x3e9b] = 0x6263;
	__map_gbk2utf16[0x3e9c] = 0x5bc7;
	__map_gbk2utf16[0x3e9d] = 0x67af;
	__map_gbk2utf16[0x3e9e] = 0x54ed;
	__map_gbk2utf16[0x3e9f] = 0x7a9f;
	__map_gbk2utf16[0x3ea0] = 0x82e6;
	__map_gbk2utf16[0x3ea1] = 0x9177;
	__map_gbk2utf16[0x3ea2] = 0x5e93;
	__map_gbk2utf16[0x3ea3] = 0x88e4;
	__map_gbk2utf16[0x3ea4] = 0x5938;
	__map_gbk2utf16[0x3ea5] = 0x57ae;
	__map_gbk2utf16[0x3ea6] = 0x630e;
	__map_gbk2utf16[0x3ea7] = 0x8de8;
	__map_gbk2utf16[0x3ea8] = 0x80ef;
	__map_gbk2utf16[0x3ea9] = 0x5757;
	__map_gbk2utf16[0x3eaa] = 0x7b77;
	__map_gbk2utf16[0x3eab] = 0x4fa9;
	__map_gbk2utf16[0x3eac] = 0x5feb;
	__map_gbk2utf16[0x3ead] = 0x5bbd;
	__map_gbk2utf16[0x3eae] = 0x6b3e;
	__map_gbk2utf16[0x3eaf] = 0x5321;
	__map_gbk2utf16[0x3eb0] = 0x7b50;
	__map_gbk2utf16[0x3eb1] = 0x72c2;
	__map_gbk2utf16[0x3eb2] = 0x6846;
	__map_gbk2utf16[0x3eb3] = 0x77ff;
	__map_gbk2utf16[0x3eb4] = 0x7736;
	__map_gbk2utf16[0x3eb5] = 0x65f7;
	__map_gbk2utf16[0x3eb6] = 0x51b5;
	__map_gbk2utf16[0x3eb7] = 0x4e8f;
	__map_gbk2utf16[0x3eb8] = 0x76d4;
	__map_gbk2utf16[0x3eb9] = 0x5cbf;
	__map_gbk2utf16[0x3eba] = 0x7aa5;
	__map_gbk2utf16[0x3ebb] = 0x8475;
	__map_gbk2utf16[0x3ebc] = 0x594e;
	__map_gbk2utf16[0x3ebd] = 0x9b41;
	__map_gbk2utf16[0x3ebe] = 0x5080;
	__map_gbk2utf16[0x3f00] = 0x7e5e;
	__map_gbk2utf16[0x3f01] = 0x7e5f;
	__map_gbk2utf16[0x3f02] = 0x7e60;
	__map_gbk2utf16[0x3f03] = 0x7e61;
	__map_gbk2utf16[0x3f04] = 0x7e62;
	__map_gbk2utf16[0x3f05] = 0x7e63;
	__map_gbk2utf16[0x3f06] = 0x7e64;
	__map_gbk2utf16[0x3f07] = 0x7e65;
	__map_gbk2utf16[0x3f08] = 0x7e66;
	__map_gbk2utf16[0x3f09] = 0x7e67;
	__map_gbk2utf16[0x3f0a] = 0x7e68;
	__map_gbk2utf16[0x3f0b] = 0x7e69;
	__map_gbk2utf16[0x3f0c] = 0x7e6a;
	__map_gbk2utf16[0x3f0d] = 0x7e6b;
	__map_gbk2utf16[0x3f0e] = 0x7e6c;
	__map_gbk2utf16[0x3f0f] = 0x7e6d;
	__map_gbk2utf16[0x3f10] = 0x7e6e;
	__map_gbk2utf16[0x3f11] = 0x7e6f;
	__map_gbk2utf16[0x3f12] = 0x7e70;
	__map_gbk2utf16[0x3f13] = 0x7e71;
	__map_gbk2utf16[0x3f14] = 0x7e72;
	__map_gbk2utf16[0x3f15] = 0x7e73;
	__map_gbk2utf16[0x3f16] = 0x7e74;
	__map_gbk2utf16[0x3f17] = 0x7e75;
	__map_gbk2utf16[0x3f18] = 0x7e76;
	__map_gbk2utf16[0x3f19] = 0x7e77;
	__map_gbk2utf16[0x3f1a] = 0x7e78;
	__map_gbk2utf16[0x3f1b] = 0x7e79;
	__map_gbk2utf16[0x3f1c] = 0x7e7a;
	__map_gbk2utf16[0x3f1d] = 0x7e7b;
	__map_gbk2utf16[0x3f1e] = 0x7e7c;
	__map_gbk2utf16[0x3f1f] = 0x7e7d;
	__map_gbk2utf16[0x3f20] = 0x7e7e;
	__map_gbk2utf16[0x3f21] = 0x7e7f;
	__map_gbk2utf16[0x3f22] = 0x7e80;
	__map_gbk2utf16[0x3f23] = 0x7e81;
	__map_gbk2utf16[0x3f24] = 0x7e83;
	__map_gbk2utf16[0x3f25] = 0x7e84;
	__map_gbk2utf16[0x3f26] = 0x7e85;
	__map_gbk2utf16[0x3f27] = 0x7e86;
	__map_gbk2utf16[0x3f28] = 0x7e87;
	__map_gbk2utf16[0x3f29] = 0x7e88;
	__map_gbk2utf16[0x3f2a] = 0x7e89;
	__map_gbk2utf16[0x3f2b] = 0x7e8a;
	__map_gbk2utf16[0x3f2c] = 0x7e8b;
	__map_gbk2utf16[0x3f2d] = 0x7e8c;
	__map_gbk2utf16[0x3f2e] = 0x7e8d;
	__map_gbk2utf16[0x3f2f] = 0x7e8e;
	__map_gbk2utf16[0x3f30] = 0x7e8f;
	__map_gbk2utf16[0x3f31] = 0x7e90;
	__map_gbk2utf16[0x3f32] = 0x7e91;
	__map_gbk2utf16[0x3f33] = 0x7e92;
	__map_gbk2utf16[0x3f34] = 0x7e93;
	__map_gbk2utf16[0x3f35] = 0x7e94;
	__map_gbk2utf16[0x3f36] = 0x7e95;
	__map_gbk2utf16[0x3f37] = 0x7e96;
	__map_gbk2utf16[0x3f38] = 0x7e97;
	__map_gbk2utf16[0x3f39] = 0x7e98;
	__map_gbk2utf16[0x3f3a] = 0x7e99;
	__map_gbk2utf16[0x3f3b] = 0x7e9a;
	__map_gbk2utf16[0x3f3c] = 0x7e9c;
	__map_gbk2utf16[0x3f3d] = 0x7e9d;
	__map_gbk2utf16[0x3f3e] = 0x7e9e;
	__map_gbk2utf16[0x3f40] = 0x7eae;
	__map_gbk2utf16[0x3f41] = 0x7eb4;
	__map_gbk2utf16[0x3f42] = 0x7ebb;
	__map_gbk2utf16[0x3f43] = 0x7ebc;
	__map_gbk2utf16[0x3f44] = 0x7ed6;
	__map_gbk2utf16[0x3f45] = 0x7ee4;
	__map_gbk2utf16[0x3f46] = 0x7eec;
	__map_gbk2utf16[0x3f47] = 0x7ef9;
	__map_gbk2utf16[0x3f48] = 0x7f0a;
	__map_gbk2utf16[0x3f49] = 0x7f10;
	__map_gbk2utf16[0x3f4a] = 0x7f1e;
	__map_gbk2utf16[0x3f4b] = 0x7f37;
	__map_gbk2utf16[0x3f4c] = 0x7f39;
	__map_gbk2utf16[0x3f4d] = 0x7f3b;
	__map_gbk2utf16[0x3f4e] = 0x7f3c;
	__map_gbk2utf16[0x3f4f] = 0x7f3d;
	__map_gbk2utf16[0x3f50] = 0x7f3e;
	__map_gbk2utf16[0x3f51] = 0x7f3f;
	__map_gbk2utf16[0x3f52] = 0x7f40;
	__map_gbk2utf16[0x3f53] = 0x7f41;
	__map_gbk2utf16[0x3f54] = 0x7f43;
	__map_gbk2utf16[0x3f55] = 0x7f46;
	__map_gbk2utf16[0x3f56] = 0x7f47;
	__map_gbk2utf16[0x3f57] = 0x7f48;
	__map_gbk2utf16[0x3f58] = 0x7f49;
	__map_gbk2utf16[0x3f59] = 0x7f4a;
	__map_gbk2utf16[0x3f5a] = 0x7f4b;
	__map_gbk2utf16[0x3f5b] = 0x7f4c;
	__map_gbk2utf16[0x3f5c] = 0x7f4d;
	__map_gbk2utf16[0x3f5d] = 0x7f4e;
	__map_gbk2utf16[0x3f5e] = 0x7f4f;
	__map_gbk2utf16[0x3f5f] = 0x7f52;
	__map_gbk2utf16[0x3f60] = 0x7f53;
	__map_gbk2utf16[0x3f61] = 0x9988;
	__map_gbk2utf16[0x3f62] = 0x6127;
	__map_gbk2utf16[0x3f63] = 0x6e83;
	__map_gbk2utf16[0x3f64] = 0x5764;
	__map_gbk2utf16[0x3f65] = 0x6606;
	__map_gbk2utf16[0x3f66] = 0x6346;
	__map_gbk2utf16[0x3f67] = 0x56f0;
	__map_gbk2utf16[0x3f68] = 0x62ec;
	__map_gbk2utf16[0x3f69] = 0x6269;
	__map_gbk2utf16[0x3f6a] = 0x5ed3;
	__map_gbk2utf16[0x3f6b] = 0x9614;
	__map_gbk2utf16[0x3f6c] = 0x5783;
	__map_gbk2utf16[0x3f6d] = 0x62c9;
	__map_gbk2utf16[0x3f6e] = 0x5587;
	__map_gbk2utf16[0x3f6f] = 0x8721;
	__map_gbk2utf16[0x3f70] = 0x814a;
	__map_gbk2utf16[0x3f71] = 0x8fa3;
	__map_gbk2utf16[0x3f72] = 0x5566;
	__map_gbk2utf16[0x3f73] = 0x83b1;
	__map_gbk2utf16[0x3f74] = 0x6765;
	__map_gbk2utf16[0x3f75] = 0x8d56;
	__map_gbk2utf16[0x3f76] = 0x84dd;
	__map_gbk2utf16[0x3f77] = 0x5a6a;
	__map_gbk2utf16[0x3f78] = 0x680f;
	__map_gbk2utf16[0x3f79] = 0x62e6;
	__map_gbk2utf16[0x3f7a] = 0x7bee;
	__map_gbk2utf16[0x3f7b] = 0x9611;
	__map_gbk2utf16[0x3f7c] = 0x5170;
	__map_gbk2utf16[0x3f7d] = 0x6f9c;
	__map_gbk2utf16[0x3f7e] = 0x8c30;
	__map_gbk2utf16[0x3f7f] = 0x63fd;
	__map_gbk2utf16[0x3f80] = 0x89c8;
	__map_gbk2utf16[0x3f81] = 0x61d2;
	__map_gbk2utf16[0x3f82] = 0x7f06;
	__map_gbk2utf16[0x3f83] = 0x70c2;
	__map_gbk2utf16[0x3f84] = 0x6ee5;
	__map_gbk2utf16[0x3f85] = 0x7405;
	__map_gbk2utf16[0x3f86] = 0x6994;
	__map_gbk2utf16[0x3f87] = 0x72fc;
	__map_gbk2utf16[0x3f88] = 0x5eca;
	__map_gbk2utf16[0x3f89] = 0x90ce;
	__map_gbk2utf16[0x3f8a] = 0x6717;
	__map_gbk2utf16[0x3f8b] = 0x6d6a;
	__map_gbk2utf16[0x3f8c] = 0x635e;
	__map_gbk2utf16[0x3f8d] = 0x52b3;
	__map_gbk2utf16[0x3f8e] = 0x7262;
	__map_gbk2utf16[0x3f8f] = 0x8001;
	__map_gbk2utf16[0x3f90] = 0x4f6c;
	__map_gbk2utf16[0x3f91] = 0x59e5;
	__map_gbk2utf16[0x3f92] = 0x916a;
	__map_gbk2utf16[0x3f93] = 0x70d9;
	__map_gbk2utf16[0x3f94] = 0x6d9d;
	__map_gbk2utf16[0x3f95] = 0x52d2;
	__map_gbk2utf16[0x3f96] = 0x4e50;
	__map_gbk2utf16[0x3f97] = 0x96f7;
	__map_gbk2utf16[0x3f98] = 0x956d;
	__map_gbk2utf16[0x3f99] = 0x857e;
	__map_gbk2utf16[0x3f9a] = 0x78ca;
	__map_gbk2utf16[0x3f9b] = 0x7d2f;
	__map_gbk2utf16[0x3f9c] = 0x5121;
	__map_gbk2utf16[0x3f9d] = 0x5792;
	__map_gbk2utf16[0x3f9e] = 0x64c2;
	__map_gbk2utf16[0x3f9f] = 0x808b;
	__map_gbk2utf16[0x3fa0] = 0x7c7b;
	__map_gbk2utf16[0x3fa1] = 0x6cea;
	__map_gbk2utf16[0x3fa2] = 0x68f1;
	__map_gbk2utf16[0x3fa3] = 0x695e;
	__map_gbk2utf16[0x3fa4] = 0x51b7;
	__map_gbk2utf16[0x3fa5] = 0x5398;
	__map_gbk2utf16[0x3fa6] = 0x68a8;
	__map_gbk2utf16[0x3fa7] = 0x7281;
	__map_gbk2utf16[0x3fa8] = 0x9ece;
	__map_gbk2utf16[0x3fa9] = 0x7bf1;
	__map_gbk2utf16[0x3faa] = 0x72f8;
	__map_gbk2utf16[0x3fab] = 0x79bb;
	__map_gbk2utf16[0x3fac] = 0x6f13;
	__map_gbk2utf16[0x3fad] = 0x7406;
	__map_gbk2utf16[0x3fae] = 0x674e;
	__map_gbk2utf16[0x3faf] = 0x91cc;
	__map_gbk2utf16[0x3fb0] = 0x9ca4;
	__map_gbk2utf16[0x3fb1] = 0x793c;
	__map_gbk2utf16[0x3fb2] = 0x8389;
	__map_gbk2utf16[0x3fb3] = 0x8354;
	__map_gbk2utf16[0x3fb4] = 0x540f;
	__map_gbk2utf16[0x3fb5] = 0x6817;
	__map_gbk2utf16[0x3fb6] = 0x4e3d;
	__map_gbk2utf16[0x3fb7] = 0x5389;
	__map_gbk2utf16[0x3fb8] = 0x52b1;
	__map_gbk2utf16[0x3fb9] = 0x783e;
	__map_gbk2utf16[0x3fba] = 0x5386;
	__map_gbk2utf16[0x3fbb] = 0x5229;
	__map_gbk2utf16[0x3fbc] = 0x5088;
	__map_gbk2utf16[0x3fbd] = 0x4f8b;
	__map_gbk2utf16[0x3fbe] = 0x4fd0;
	__map_gbk2utf16[0x4000] = 0x7f56;
	__map_gbk2utf16[0x4001] = 0x7f59;
	__map_gbk2utf16[0x4002] = 0x7f5b;
	__map_gbk2utf16[0x4003] = 0x7f5c;
	__map_gbk2utf16[0x4004] = 0x7f5d;
	__map_gbk2utf16[0x4005] = 0x7f5e;
	__map_gbk2utf16[0x4006] = 0x7f60;
	__map_gbk2utf16[0x4007] = 0x7f63;
	__map_gbk2utf16[0x4008] = 0x7f64;
	__map_gbk2utf16[0x4009] = 0x7f65;
	__map_gbk2utf16[0x400a] = 0x7f66;
	__map_gbk2utf16[0x400b] = 0x7f67;
	__map_gbk2utf16[0x400c] = 0x7f6b;
	__map_gbk2utf16[0x400d] = 0x7f6c;
	__map_gbk2utf16[0x400e] = 0x7f6d;
	__map_gbk2utf16[0x400f] = 0x7f6f;
	__map_gbk2utf16[0x4010] = 0x7f70;
	__map_gbk2utf16[0x4011] = 0x7f73;
	__map_gbk2utf16[0x4012] = 0x7f75;
	__map_gbk2utf16[0x4013] = 0x7f76;
	__map_gbk2utf16[0x4014] = 0x7f77;
	__map_gbk2utf16[0x4015] = 0x7f78;
	__map_gbk2utf16[0x4016] = 0x7f7a;
	__map_gbk2utf16[0x4017] = 0x7f7b;
	__map_gbk2utf16[0x4018] = 0x7f7c;
	__map_gbk2utf16[0x4019] = 0x7f7d;
	__map_gbk2utf16[0x401a] = 0x7f7f;
	__map_gbk2utf16[0x401b] = 0x7f80;
	__map_gbk2utf16[0x401c] = 0x7f82;
	__map_gbk2utf16[0x401d] = 0x7f83;
	__map_gbk2utf16[0x401e] = 0x7f84;
	__map_gbk2utf16[0x401f] = 0x7f85;
	__map_gbk2utf16[0x4020] = 0x7f86;
	__map_gbk2utf16[0x4021] = 0x7f87;
	__map_gbk2utf16[0x4022] = 0x7f88;
	__map_gbk2utf16[0x4023] = 0x7f89;
	__map_gbk2utf16[0x4024] = 0x7f8b;
	__map_gbk2utf16[0x4025] = 0x7f8d;
	__map_gbk2utf16[0x4026] = 0x7f8f;
	__map_gbk2utf16[0x4027] = 0x7f90;
	__map_gbk2utf16[0x4028] = 0x7f91;
	__map_gbk2utf16[0x4029] = 0x7f92;
	__map_gbk2utf16[0x402a] = 0x7f93;
	__map_gbk2utf16[0x402b] = 0x7f95;
	__map_gbk2utf16[0x402c] = 0x7f96;
	__map_gbk2utf16[0x402d] = 0x7f97;
	__map_gbk2utf16[0x402e] = 0x7f98;
	__map_gbk2utf16[0x402f] = 0x7f99;
	__map_gbk2utf16[0x4030] = 0x7f9b;
	__map_gbk2utf16[0x4031] = 0x7f9c;
	__map_gbk2utf16[0x4032] = 0x7fa0;
	__map_gbk2utf16[0x4033] = 0x7fa2;
	__map_gbk2utf16[0x4034] = 0x7fa3;
	__map_gbk2utf16[0x4035] = 0x7fa5;
	__map_gbk2utf16[0x4036] = 0x7fa6;
	__map_gbk2utf16[0x4037] = 0x7fa8;
	__map_gbk2utf16[0x4038] = 0x7fa9;
	__map_gbk2utf16[0x4039] = 0x7faa;
	__map_gbk2utf16[0x403a] = 0x7fab;
	__map_gbk2utf16[0x403b] = 0x7fac;
	__map_gbk2utf16[0x403c] = 0x7fad;
	__map_gbk2utf16[0x403d] = 0x7fae;
	__map_gbk2utf16[0x403e] = 0x7fb1;
	__map_gbk2utf16[0x4040] = 0x7fb3;
	__map_gbk2utf16[0x4041] = 0x7fb4;
	__map_gbk2utf16[0x4042] = 0x7fb5;
	__map_gbk2utf16[0x4043] = 0x7fb6;
	__map_gbk2utf16[0x4044] = 0x7fb7;
	__map_gbk2utf16[0x4045] = 0x7fba;
	__map_gbk2utf16[0x4046] = 0x7fbb;
	__map_gbk2utf16[0x4047] = 0x7fbe;
	__map_gbk2utf16[0x4048] = 0x7fc0;
	__map_gbk2utf16[0x4049] = 0x7fc2;
	__map_gbk2utf16[0x404a] = 0x7fc3;
	__map_gbk2utf16[0x404b] = 0x7fc4;
	__map_gbk2utf16[0x404c] = 0x7fc6;
	__map_gbk2utf16[0x404d] = 0x7fc7;
	__map_gbk2utf16[0x404e] = 0x7fc8;
	__map_gbk2utf16[0x404f] = 0x7fc9;
	__map_gbk2utf16[0x4050] = 0x7fcb;
	__map_gbk2utf16[0x4051] = 0x7fcd;
	__map_gbk2utf16[0x4052] = 0x7fcf;
	__map_gbk2utf16[0x4053] = 0x7fd0;
	__map_gbk2utf16[0x4054] = 0x7fd1;
	__map_gbk2utf16[0x4055] = 0x7fd2;
	__map_gbk2utf16[0x4056] = 0x7fd3;
	__map_gbk2utf16[0x4057] = 0x7fd6;
	__map_gbk2utf16[0x4058] = 0x7fd7;
	__map_gbk2utf16[0x4059] = 0x7fd9;
	__map_gbk2utf16[0x405a] = 0x7fda;
	__map_gbk2utf16[0x405b] = 0x7fdb;
	__map_gbk2utf16[0x405c] = 0x7fdc;
	__map_gbk2utf16[0x405d] = 0x7fdd;
	__map_gbk2utf16[0x405e] = 0x7fde;
	__map_gbk2utf16[0x405f] = 0x7fe2;
	__map_gbk2utf16[0x4060] = 0x7fe3;
	__map_gbk2utf16[0x4061] = 0x75e2;
	__map_gbk2utf16[0x4062] = 0x7acb;
	__map_gbk2utf16[0x4063] = 0x7c92;
	__map_gbk2utf16[0x4064] = 0x6ca5;
	__map_gbk2utf16[0x4065] = 0x96b6;
	__map_gbk2utf16[0x4066] = 0x529b;
	__map_gbk2utf16[0x4067] = 0x7483;
	__map_gbk2utf16[0x4068] = 0x54e9;
	__map_gbk2utf16[0x4069] = 0x4fe9;
	__map_gbk2utf16[0x406a] = 0x8054;
	__map_gbk2utf16[0x406b] = 0x83b2;
	__map_gbk2utf16[0x406c] = 0x8fde;
	__map_gbk2utf16[0x406d] = 0x9570;
	__map_gbk2utf16[0x406e] = 0x5ec9;
	__map_gbk2utf16[0x406f] = 0x601c;
	__map_gbk2utf16[0x4070] = 0x6d9f;
	__map_gbk2utf16[0x4071] = 0x5e18;
	__map_gbk2utf16[0x4072] = 0x655b;
	__map_gbk2utf16[0x4073] = 0x8138;
	__map_gbk2utf16[0x4074] = 0x94fe;
	__map_gbk2utf16[0x4075] = 0x604b;
	__map_gbk2utf16[0x4076] = 0x70bc;
	__map_gbk2utf16[0x4077] = 0x7ec3;
	__map_gbk2utf16[0x4078] = 0x7cae;
	__map_gbk2utf16[0x4079] = 0x51c9;
	__map_gbk2utf16[0x407a] = 0x6881;
	__map_gbk2utf16[0x407b] = 0x7cb1;
	__map_gbk2utf16[0x407c] = 0x826f;
	__map_gbk2utf16[0x407d] = 0x4e24;
	__map_gbk2utf16[0x407e] = 0x8f86;
	__map_gbk2utf16[0x407f] = 0x91cf;
	__map_gbk2utf16[0x4080] = 0x667e;
	__map_gbk2utf16[0x4081] = 0x4eae;
	__map_gbk2utf16[0x4082] = 0x8c05;
	__map_gbk2utf16[0x4083] = 0x64a9;
	__map_gbk2utf16[0x4084] = 0x804a;
	__map_gbk2utf16[0x4085] = 0x50da;
	__map_gbk2utf16[0x4086] = 0x7597;
	__map_gbk2utf16[0x4087] = 0x71ce;
	__map_gbk2utf16[0x4088] = 0x5be5;
	__map_gbk2utf16[0x4089] = 0x8fbd;
	__map_gbk2utf16[0x408a] = 0x6f66;
	__map_gbk2utf16[0x408b] = 0x4e86;
	__map_gbk2utf16[0x408c] = 0x6482;
	__map_gbk2utf16[0x408d] = 0x9563;
	__map_gbk2utf16[0x408e] = 0x5ed6;
	__map_gbk2utf16[0x408f] = 0x6599;
	__map_gbk2utf16[0x4090] = 0x5217;
	__map_gbk2utf16[0x4091] = 0x88c2;
	__map_gbk2utf16[0x4092] = 0x70c8;
	__map_gbk2utf16[0x4093] = 0x52a3;
	__map_gbk2utf16[0x4094] = 0x730e;
	__map_gbk2utf16[0x4095] = 0x7433;
	__map_gbk2utf16[0x4096] = 0x6797;
	__map_gbk2utf16[0x4097] = 0x78f7;
	__map_gbk2utf16[0x4098] = 0x9716;
	__map_gbk2utf16[0x4099] = 0x4e34;
	__map_gbk2utf16[0x409a] = 0x90bb;
	__map_gbk2utf16[0x409b] = 0x9cde;
	__map_gbk2utf16[0x409c] = 0x6dcb;
	__map_gbk2utf16[0x409d] = 0x51db;
	__map_gbk2utf16[0x409e] = 0x8d41;
	__map_gbk2utf16[0x409f] = 0x541d;
	__map_gbk2utf16[0x40a0] = 0x62ce;
	__map_gbk2utf16[0x40a1] = 0x73b2;
	__map_gbk2utf16[0x40a2] = 0x83f1;
	__map_gbk2utf16[0x40a3] = 0x96f6;
	__map_gbk2utf16[0x40a4] = 0x9f84;
	__map_gbk2utf16[0x40a5] = 0x94c3;
	__map_gbk2utf16[0x40a6] = 0x4f36;
	__map_gbk2utf16[0x40a7] = 0x7f9a;
	__map_gbk2utf16[0x40a8] = 0x51cc;
	__map_gbk2utf16[0x40a9] = 0x7075;
	__map_gbk2utf16[0x40aa] = 0x9675;
	__map_gbk2utf16[0x40ab] = 0x5cad;
	__map_gbk2utf16[0x40ac] = 0x9886;
	__map_gbk2utf16[0x40ad] = 0x53e6;
	__map_gbk2utf16[0x40ae] = 0x4ee4;
	__map_gbk2utf16[0x40af] = 0x6e9c;
	__map_gbk2utf16[0x40b0] = 0x7409;
	__map_gbk2utf16[0x40b1] = 0x69b4;
	__map_gbk2utf16[0x40b2] = 0x786b;
	__map_gbk2utf16[0x40b3] = 0x998f;
	__map_gbk2utf16[0x40b4] = 0x7559;
	__map_gbk2utf16[0x40b5] = 0x5218;
	__map_gbk2utf16[0x40b6] = 0x7624;
	__map_gbk2utf16[0x40b7] = 0x6d41;
	__map_gbk2utf16[0x40b8] = 0x67f3;
	__map_gbk2utf16[0x40b9] = 0x516d;
	__map_gbk2utf16[0x40ba] = 0x9f99;
	__map_gbk2utf16[0x40bb] = 0x804b;
	__map_gbk2utf16[0x40bc] = 0x5499;
	__map_gbk2utf16[0x40bd] = 0x7b3c;
	__map_gbk2utf16[0x40be] = 0x7abf;
	__map_gbk2utf16[0x4100] = 0x7fe4;
	__map_gbk2utf16[0x4101] = 0x7fe7;
	__map_gbk2utf16[0x4102] = 0x7fe8;
	__map_gbk2utf16[0x4103] = 0x7fea;
	__map_gbk2utf16[0x4104] = 0x7feb;
	__map_gbk2utf16[0x4105] = 0x7fec;
	__map_gbk2utf16[0x4106] = 0x7fed;
	__map_gbk2utf16[0x4107] = 0x7fef;
	__map_gbk2utf16[0x4108] = 0x7ff2;
	__map_gbk2utf16[0x4109] = 0x7ff4;
	__map_gbk2utf16[0x410a] = 0x7ff5;
	__map_gbk2utf16[0x410b] = 0x7ff6;
	__map_gbk2utf16[0x410c] = 0x7ff7;
	__map_gbk2utf16[0x410d] = 0x7ff8;
	__map_gbk2utf16[0x410e] = 0x7ff9;
	__map_gbk2utf16[0x410f] = 0x7ffa;
	__map_gbk2utf16[0x4110] = 0x7ffd;
	__map_gbk2utf16[0x4111] = 0x7ffe;
	__map_gbk2utf16[0x4112] = 0x7fff;
	__map_gbk2utf16[0x4113] = 0x8002;
	__map_gbk2utf16[0x4114] = 0x8007;
	__map_gbk2utf16[0x4115] = 0x8008;
	__map_gbk2utf16[0x4116] = 0x8009;
	__map_gbk2utf16[0x4117] = 0x800a;
	__map_gbk2utf16[0x4118] = 0x800e;
	__map_gbk2utf16[0x4119] = 0x800f;
	__map_gbk2utf16[0x411a] = 0x8011;
	__map_gbk2utf16[0x411b] = 0x8013;
	__map_gbk2utf16[0x411c] = 0x801a;
	__map_gbk2utf16[0x411d] = 0x801b;
	__map_gbk2utf16[0x411e] = 0x801d;
	__map_gbk2utf16[0x411f] = 0x801e;
	__map_gbk2utf16[0x4120] = 0x801f;
	__map_gbk2utf16[0x4121] = 0x8021;
	__map_gbk2utf16[0x4122] = 0x8023;
	__map_gbk2utf16[0x4123] = 0x8024;
	__map_gbk2utf16[0x4124] = 0x802b;
	__map_gbk2utf16[0x4125] = 0x802c;
	__map_gbk2utf16[0x4126] = 0x802d;
	__map_gbk2utf16[0x4127] = 0x802e;
	__map_gbk2utf16[0x4128] = 0x802f;
	__map_gbk2utf16[0x4129] = 0x8030;
	__map_gbk2utf16[0x412a] = 0x8032;
	__map_gbk2utf16[0x412b] = 0x8034;
	__map_gbk2utf16[0x412c] = 0x8039;
	__map_gbk2utf16[0x412d] = 0x803a;
	__map_gbk2utf16[0x412e] = 0x803c;
	__map_gbk2utf16[0x412f] = 0x803e;
	__map_gbk2utf16[0x4130] = 0x8040;
	__map_gbk2utf16[0x4131] = 0x8041;
	__map_gbk2utf16[0x4132] = 0x8044;
	__map_gbk2utf16[0x4133] = 0x8045;
	__map_gbk2utf16[0x4134] = 0x8047;
	__map_gbk2utf16[0x4135] = 0x8048;
	__map_gbk2utf16[0x4136] = 0x8049;
	__map_gbk2utf16[0x4137] = 0x804e;
	__map_gbk2utf16[0x4138] = 0x804f;
	__map_gbk2utf16[0x4139] = 0x8050;
	__map_gbk2utf16[0x413a] = 0x8051;
	__map_gbk2utf16[0x413b] = 0x8053;
	__map_gbk2utf16[0x413c] = 0x8055;
	__map_gbk2utf16[0x413d] = 0x8056;
	__map_gbk2utf16[0x413e] = 0x8057;
	__map_gbk2utf16[0x4140] = 0x8059;
	__map_gbk2utf16[0x4141] = 0x805b;
	__map_gbk2utf16[0x4142] = 0x805c;
	__map_gbk2utf16[0x4143] = 0x805d;
	__map_gbk2utf16[0x4144] = 0x805e;
	__map_gbk2utf16[0x4145] = 0x805f;
	__map_gbk2utf16[0x4146] = 0x8060;
	__map_gbk2utf16[0x4147] = 0x8061;
	__map_gbk2utf16[0x4148] = 0x8062;
	__map_gbk2utf16[0x4149] = 0x8063;
	__map_gbk2utf16[0x414a] = 0x8064;
	__map_gbk2utf16[0x414b] = 0x8065;
	__map_gbk2utf16[0x414c] = 0x8066;
	__map_gbk2utf16[0x414d] = 0x8067;
	__map_gbk2utf16[0x414e] = 0x8068;
	__map_gbk2utf16[0x414f] = 0x806b;
	__map_gbk2utf16[0x4150] = 0x806c;
	__map_gbk2utf16[0x4151] = 0x806d;
	__map_gbk2utf16[0x4152] = 0x806e;
	__map_gbk2utf16[0x4153] = 0x806f;
	__map_gbk2utf16[0x4154] = 0x8070;
	__map_gbk2utf16[0x4155] = 0x8072;
	__map_gbk2utf16[0x4156] = 0x8073;
	__map_gbk2utf16[0x4157] = 0x8074;
	__map_gbk2utf16[0x4158] = 0x8075;
	__map_gbk2utf16[0x4159] = 0x8076;
	__map_gbk2utf16[0x415a] = 0x8077;
	__map_gbk2utf16[0x415b] = 0x8078;
	__map_gbk2utf16[0x415c] = 0x8079;
	__map_gbk2utf16[0x415d] = 0x807a;
	__map_gbk2utf16[0x415e] = 0x807b;
	__map_gbk2utf16[0x415f] = 0x807c;
	__map_gbk2utf16[0x4160] = 0x807d;
	__map_gbk2utf16[0x4161] = 0x9686;
	__map_gbk2utf16[0x4162] = 0x5784;
	__map_gbk2utf16[0x4163] = 0x62e2;
	__map_gbk2utf16[0x4164] = 0x9647;
	__map_gbk2utf16[0x4165] = 0x697c;
	__map_gbk2utf16[0x4166] = 0x5a04;
	__map_gbk2utf16[0x4167] = 0x6402;
	__map_gbk2utf16[0x4168] = 0x7bd3;
	__map_gbk2utf16[0x4169] = 0x6f0f;
	__map_gbk2utf16[0x416a] = 0x964b;
	__map_gbk2utf16[0x416b] = 0x82a6;
	__map_gbk2utf16[0x416c] = 0x5362;
	__map_gbk2utf16[0x416d] = 0x9885;
	__map_gbk2utf16[0x416e] = 0x5e90;
	__map_gbk2utf16[0x416f] = 0x7089;
	__map_gbk2utf16[0x4170] = 0x63b3;
	__map_gbk2utf16[0x4171] = 0x5364;
	__map_gbk2utf16[0x4172] = 0x864f;
	__map_gbk2utf16[0x4173] = 0x9c81;
	__map_gbk2utf16[0x4174] = 0x9e93;
	__map_gbk2utf16[0x4175] = 0x788c;
	__map_gbk2utf16[0x4176] = 0x9732;
	__map_gbk2utf16[0x4177] = 0x8def;
	__map_gbk2utf16[0x4178] = 0x8d42;
	__map_gbk2utf16[0x4179] = 0x9e7f;
	__map_gbk2utf16[0x417a] = 0x6f5e;
	__map_gbk2utf16[0x417b] = 0x7984;
	__map_gbk2utf16[0x417c] = 0x5f55;
	__map_gbk2utf16[0x417d] = 0x9646;
	__map_gbk2utf16[0x417e] = 0x622e;
	__map_gbk2utf16[0x417f] = 0x9a74;
	__map_gbk2utf16[0x4180] = 0x5415;
	__map_gbk2utf16[0x4181] = 0x94dd;
	__map_gbk2utf16[0x4182] = 0x4fa3;
	__map_gbk2utf16[0x4183] = 0x65c5;
	__map_gbk2utf16[0x4184] = 0x5c65;
	__map_gbk2utf16[0x4185] = 0x5c61;
	__map_gbk2utf16[0x4186] = 0x7f15;
	__map_gbk2utf16[0x4187] = 0x8651;
	__map_gbk2utf16[0x4188] = 0x6c2f;
	__map_gbk2utf16[0x4189] = 0x5f8b;
	__map_gbk2utf16[0x418a] = 0x7387;
	__map_gbk2utf16[0x418b] = 0x6ee4;
	__map_gbk2utf16[0x418c] = 0x7eff;
	__map_gbk2utf16[0x418d] = 0x5ce6;
	__map_gbk2utf16[0x418e] = 0x631b;
	__map_gbk2utf16[0x418f] = 0x5b6a;
	__map_gbk2utf16[0x4190] = 0x6ee6;
	__map_gbk2utf16[0x4191] = 0x5375;
	__map_gbk2utf16[0x4192] = 0x4e71;
	__map_gbk2utf16[0x4193] = 0x63a0;
	__map_gbk2utf16[0x4194] = 0x7565;
	__map_gbk2utf16[0x4195] = 0x62a1;
	__map_gbk2utf16[0x4196] = 0x8f6e;
	__map_gbk2utf16[0x4197] = 0x4f26;
	__map_gbk2utf16[0x4198] = 0x4ed1;
	__map_gbk2utf16[0x4199] = 0x6ca6;
	__map_gbk2utf16[0x419a] = 0x7eb6;
	__map_gbk2utf16[0x419b] = 0x8bba;
	__map_gbk2utf16[0x419c] = 0x841d;
	__map_gbk2utf16[0x419d] = 0x87ba;
	__map_gbk2utf16[0x419e] = 0x7f57;
	__map_gbk2utf16[0x419f] = 0x903b;
	__map_gbk2utf16[0x41a0] = 0x9523;
	__map_gbk2utf16[0x41a1] = 0x7ba9;
	__map_gbk2utf16[0x41a2] = 0x9aa1;
	__map_gbk2utf16[0x41a3] = 0x88f8;
	__map_gbk2utf16[0x41a4] = 0x843d;
	__map_gbk2utf16[0x41a5] = 0x6d1b;
	__map_gbk2utf16[0x41a6] = 0x9a86;
	__map_gbk2utf16[0x41a7] = 0x7edc;
	__map_gbk2utf16[0x41a8] = 0x5988;
	__map_gbk2utf16[0x41a9] = 0x9ebb;
	__map_gbk2utf16[0x41aa] = 0x739b;
	__map_gbk2utf16[0x41ab] = 0x7801;
	__map_gbk2utf16[0x41ac] = 0x8682;
	__map_gbk2utf16[0x41ad] = 0x9a6c;
	__map_gbk2utf16[0x41ae] = 0x9a82;
	__map_gbk2utf16[0x41af] = 0x561b;
	__map_gbk2utf16[0x41b0] = 0x5417;
	__map_gbk2utf16[0x41b1] = 0x57cb;
	__map_gbk2utf16[0x41b2] = 0x4e70;
	__map_gbk2utf16[0x41b3] = 0x9ea6;
	__map_gbk2utf16[0x41b4] = 0x5356;
	__map_gbk2utf16[0x41b5] = 0x8fc8;
	__map_gbk2utf16[0x41b6] = 0x8109;
	__map_gbk2utf16[0x41b7] = 0x7792;
	__map_gbk2utf16[0x41b8] = 0x9992;
	__map_gbk2utf16[0x41b9] = 0x86ee;
	__map_gbk2utf16[0x41ba] = 0x6ee1;
	__map_gbk2utf16[0x41bb] = 0x8513;
	__map_gbk2utf16[0x41bc] = 0x66fc;
	__map_gbk2utf16[0x41bd] = 0x6162;
	__map_gbk2utf16[0x41be] = 0x6f2b;
	__map_gbk2utf16[0x4200] = 0x807e;
	__map_gbk2utf16[0x4201] = 0x8081;
	__map_gbk2utf16[0x4202] = 0x8082;
	__map_gbk2utf16[0x4203] = 0x8085;
	__map_gbk2utf16[0x4204] = 0x8088;
	__map_gbk2utf16[0x4205] = 0x808a;
	__map_gbk2utf16[0x4206] = 0x808d;
	__map_gbk2utf16[0x4207] = 0x808e;
	__map_gbk2utf16[0x4208] = 0x808f;
	__map_gbk2utf16[0x4209] = 0x8090;
	__map_gbk2utf16[0x420a] = 0x8091;
	__map_gbk2utf16[0x420b] = 0x8092;
	__map_gbk2utf16[0x420c] = 0x8094;
	__map_gbk2utf16[0x420d] = 0x8095;
	__map_gbk2utf16[0x420e] = 0x8097;
	__map_gbk2utf16[0x420f] = 0x8099;
	__map_gbk2utf16[0x4210] = 0x809e;
	__map_gbk2utf16[0x4211] = 0x80a3;
	__map_gbk2utf16[0x4212] = 0x80a6;
	__map_gbk2utf16[0x4213] = 0x80a7;
	__map_gbk2utf16[0x4214] = 0x80a8;
	__map_gbk2utf16[0x4215] = 0x80ac;
	__map_gbk2utf16[0x4216] = 0x80b0;
	__map_gbk2utf16[0x4217] = 0x80b3;
	__map_gbk2utf16[0x4218] = 0x80b5;
	__map_gbk2utf16[0x4219] = 0x80b6;
	__map_gbk2utf16[0x421a] = 0x80b8;
	__map_gbk2utf16[0x421b] = 0x80b9;
	__map_gbk2utf16[0x421c] = 0x80bb;
	__map_gbk2utf16[0x421d] = 0x80c5;
	__map_gbk2utf16[0x421e] = 0x80c7;
	__map_gbk2utf16[0x421f] = 0x80c8;
	__map_gbk2utf16[0x4220] = 0x80c9;
	__map_gbk2utf16[0x4221] = 0x80ca;
	__map_gbk2utf16[0x4222] = 0x80cb;
	__map_gbk2utf16[0x4223] = 0x80cf;
	__map_gbk2utf16[0x4224] = 0x80d0;
	__map_gbk2utf16[0x4225] = 0x80d1;
	__map_gbk2utf16[0x4226] = 0x80d2;
	__map_gbk2utf16[0x4227] = 0x80d3;
	__map_gbk2utf16[0x4228] = 0x80d4;
	__map_gbk2utf16[0x4229] = 0x80d5;
	__map_gbk2utf16[0x422a] = 0x80d8;
	__map_gbk2utf16[0x422b] = 0x80df;
	__map_gbk2utf16[0x422c] = 0x80e0;
	__map_gbk2utf16[0x422d] = 0x80e2;
	__map_gbk2utf16[0x422e] = 0x80e3;
	__map_gbk2utf16[0x422f] = 0x80e6;
	__map_gbk2utf16[0x4230] = 0x80ee;
	__map_gbk2utf16[0x4231] = 0x80f5;
	__map_gbk2utf16[0x4232] = 0x80f7;
	__map_gbk2utf16[0x4233] = 0x80f9;
	__map_gbk2utf16[0x4234] = 0x80fb;
	__map_gbk2utf16[0x4235] = 0x80fe;
	__map_gbk2utf16[0x4236] = 0x80ff;
	__map_gbk2utf16[0x4237] = 0x8100;
	__map_gbk2utf16[0x4238] = 0x8101;
	__map_gbk2utf16[0x4239] = 0x8103;
	__map_gbk2utf16[0x423a] = 0x8104;
	__map_gbk2utf16[0x423b] = 0x8105;
	__map_gbk2utf16[0x423c] = 0x8107;
	__map_gbk2utf16[0x423d] = 0x8108;
	__map_gbk2utf16[0x423e] = 0x810b;
	__map_gbk2utf16[0x4240] = 0x810c;
	__map_gbk2utf16[0x4241] = 0x8115;
	__map_gbk2utf16[0x4242] = 0x8117;
	__map_gbk2utf16[0x4243] = 0x8119;
	__map_gbk2utf16[0x4244] = 0x811b;
	__map_gbk2utf16[0x4245] = 0x811c;
	__map_gbk2utf16[0x4246] = 0x811d;
	__map_gbk2utf16[0x4247] = 0x811f;
	__map_gbk2utf16[0x4248] = 0x8120;
	__map_gbk2utf16[0x4249] = 0x8121;
	__map_gbk2utf16[0x424a] = 0x8122;
	__map_gbk2utf16[0x424b] = 0x8123;
	__map_gbk2utf16[0x424c] = 0x8124;
	__map_gbk2utf16[0x424d] = 0x8125;
	__map_gbk2utf16[0x424e] = 0x8126;
	__map_gbk2utf16[0x424f] = 0x8127;
	__map_gbk2utf16[0x4250] = 0x8128;
	__map_gbk2utf16[0x4251] = 0x8129;
	__map_gbk2utf16[0x4252] = 0x812a;
	__map_gbk2utf16[0x4253] = 0x812b;
	__map_gbk2utf16[0x4254] = 0x812d;
	__map_gbk2utf16[0x4255] = 0x812e;
	__map_gbk2utf16[0x4256] = 0x8130;
	__map_gbk2utf16[0x4257] = 0x8133;
	__map_gbk2utf16[0x4258] = 0x8134;
	__map_gbk2utf16[0x4259] = 0x8135;
	__map_gbk2utf16[0x425a] = 0x8137;
	__map_gbk2utf16[0x425b] = 0x8139;
	__map_gbk2utf16[0x425c] = 0x813a;
	__map_gbk2utf16[0x425d] = 0x813b;
	__map_gbk2utf16[0x425e] = 0x813c;
	__map_gbk2utf16[0x425f] = 0x813d;
	__map_gbk2utf16[0x4260] = 0x813f;
	__map_gbk2utf16[0x4261] = 0x8c29;
	__map_gbk2utf16[0x4262] = 0x8292;
	__map_gbk2utf16[0x4263] = 0x832b;
	__map_gbk2utf16[0x4264] = 0x76f2;
	__map_gbk2utf16[0x4265] = 0x6c13;
	__map_gbk2utf16[0x4266] = 0x5fd9;
	__map_gbk2utf16[0x4267] = 0x83bd;
	__map_gbk2utf16[0x4268] = 0x732b;
	__map_gbk2utf16[0x4269] = 0x8305;
	__map_gbk2utf16[0x426a] = 0x951a;
	__map_gbk2utf16[0x426b] = 0x6bdb;
	__map_gbk2utf16[0x426c] = 0x77db;
	__map_gbk2utf16[0x426d] = 0x94c6;
	__map_gbk2utf16[0x426e] = 0x536f;
	__map_gbk2utf16[0x426f] = 0x8302;
	__map_gbk2utf16[0x4270] = 0x5192;
	__map_gbk2utf16[0x4271] = 0x5e3d;
	__map_gbk2utf16[0x4272] = 0x8c8c;
	__map_gbk2utf16[0x4273] = 0x8d38;
	__map_gbk2utf16[0x4274] = 0x4e48;
	__map_gbk2utf16[0x4275] = 0x73ab;
	__map_gbk2utf16[0x4276] = 0x679a;
	__map_gbk2utf16[0x4277] = 0x6885;
	__map_gbk2utf16[0x4278] = 0x9176;
	__map_gbk2utf16[0x4279] = 0x9709;
	__map_gbk2utf16[0x427a] = 0x7164;
	__map_gbk2utf16[0x427b] = 0x6ca1;
	__map_gbk2utf16[0x427c] = 0x7709;
	__map_gbk2utf16[0x427d] = 0x5a92;
	__map_gbk2utf16[0x427e] = 0x9541;
	__map_gbk2utf16[0x427f] = 0x6bcf;
	__map_gbk2utf16[0x4280] = 0x7f8e;
	__map_gbk2utf16[0x4281] = 0x6627;
	__map_gbk2utf16[0x4282] = 0x5bd0;
	__map_gbk2utf16[0x4283] = 0x59b9;
	__map_gbk2utf16[0x4284] = 0x5a9a;
	__map_gbk2utf16[0x4285] = 0x95e8;
	__map_gbk2utf16[0x4286] = 0x95f7;
	__map_gbk2utf16[0x4287] = 0x4eec;
	__map_gbk2utf16[0x4288] = 0x840c;
	__map_gbk2utf16[0x4289] = 0x8499;
	__map_gbk2utf16[0x428a] = 0x6aac;
	__map_gbk2utf16[0x428b] = 0x76df;
	__map_gbk2utf16[0x428c] = 0x9530;
	__map_gbk2utf16[0x428d] = 0x731b;
	__map_gbk2utf16[0x428e] = 0x68a6;
	__map_gbk2utf16[0x428f] = 0x5b5f;
	__map_gbk2utf16[0x4290] = 0x772f;
	__map_gbk2utf16[0x4291] = 0x919a;
	__map_gbk2utf16[0x4292] = 0x9761;
	__map_gbk2utf16[0x4293] = 0x7cdc;
	__map_gbk2utf16[0x4294] = 0x8ff7;
	__map_gbk2utf16[0x4295] = 0x8c1c;
	__map_gbk2utf16[0x4296] = 0x5f25;
	__map_gbk2utf16[0x4297] = 0x7c73;
	__map_gbk2utf16[0x4298] = 0x79d8;
	__map_gbk2utf16[0x4299] = 0x89c5;
	__map_gbk2utf16[0x429a] = 0x6ccc;
	__map_gbk2utf16[0x429b] = 0x871c;
	__map_gbk2utf16[0x429c] = 0x5bc6;
	__map_gbk2utf16[0x429d] = 0x5e42;
	__map_gbk2utf16[0x429e] = 0x68c9;
	__map_gbk2utf16[0x429f] = 0x7720;
	__map_gbk2utf16[0x42a0] = 0x7ef5;
	__map_gbk2utf16[0x42a1] = 0x5195;
	__map_gbk2utf16[0x42a2] = 0x514d;
	__map_gbk2utf16[0x42a3] = 0x52c9;
	__map_gbk2utf16[0x42a4] = 0x5a29;
	__map_gbk2utf16[0x42a5] = 0x7f05;
	__map_gbk2utf16[0x42a6] = 0x9762;
	__map_gbk2utf16[0x42a7] = 0x82d7;
	__map_gbk2utf16[0x42a8] = 0x63cf;
	__map_gbk2utf16[0x42a9] = 0x7784;
	__map_gbk2utf16[0x42aa] = 0x85d0;
	__map_gbk2utf16[0x42ab] = 0x79d2;
	__map_gbk2utf16[0x42ac] = 0x6e3a;
	__map_gbk2utf16[0x42ad] = 0x5e99;
	__map_gbk2utf16[0x42ae] = 0x5999;
	__map_gbk2utf16[0x42af] = 0x8511;
	__map_gbk2utf16[0x42b0] = 0x706d;
	__map_gbk2utf16[0x42b1] = 0x6c11;
	__map_gbk2utf16[0x42b2] = 0x62bf;
	__map_gbk2utf16[0x42b3] = 0x76bf;
	__map_gbk2utf16[0x42b4] = 0x654f;
	__map_gbk2utf16[0x42b5] = 0x60af;
	__map_gbk2utf16[0x42b6] = 0x95fd;
	__map_gbk2utf16[0x42b7] = 0x660e;
	__map_gbk2utf16[0x42b8] = 0x879f;
	__map_gbk2utf16[0x42b9] = 0x9e23;
	__map_gbk2utf16[0x42ba] = 0x94ed;
	__map_gbk2utf16[0x42bb] = 0x540d;
	__map_gbk2utf16[0x42bc] = 0x547d;
	__map_gbk2utf16[0x42bd] = 0x8c2c;
	__map_gbk2utf16[0x42be] = 0x6478;
	__map_gbk2utf16[0x4300] = 0x8140;
	__map_gbk2utf16[0x4301] = 0x8141;
	__map_gbk2utf16[0x4302] = 0x8142;
	__map_gbk2utf16[0x4303] = 0x8143;
	__map_gbk2utf16[0x4304] = 0x8144;
	__map_gbk2utf16[0x4305] = 0x8145;
	__map_gbk2utf16[0x4306] = 0x8147;
	__map_gbk2utf16[0x4307] = 0x8149;
	__map_gbk2utf16[0x4308] = 0x814d;
	__map_gbk2utf16[0x4309] = 0x814e;
	__map_gbk2utf16[0x430a] = 0x814f;
	__map_gbk2utf16[0x430b] = 0x8152;
	__map_gbk2utf16[0x430c] = 0x8156;
	__map_gbk2utf16[0x430d] = 0x8157;
	__map_gbk2utf16[0x430e] = 0x8158;
	__map_gbk2utf16[0x430f] = 0x815b;
	__map_gbk2utf16[0x4310] = 0x815c;
	__map_gbk2utf16[0x4311] = 0x815d;
	__map_gbk2utf16[0x4312] = 0x815e;
	__map_gbk2utf16[0x4313] = 0x815f;
	__map_gbk2utf16[0x4314] = 0x8161;
	__map_gbk2utf16[0x4315] = 0x8162;
	__map_gbk2utf16[0x4316] = 0x8163;
	__map_gbk2utf16[0x4317] = 0x8164;
	__map_gbk2utf16[0x4318] = 0x8166;
	__map_gbk2utf16[0x4319] = 0x8168;
	__map_gbk2utf16[0x431a] = 0x816a;
	__map_gbk2utf16[0x431b] = 0x816b;
	__map_gbk2utf16[0x431c] = 0x816c;
	__map_gbk2utf16[0x431d] = 0x816f;
	__map_gbk2utf16[0x431e] = 0x8172;
	__map_gbk2utf16[0x431f] = 0x8173;
	__map_gbk2utf16[0x4320] = 0x8175;
	__map_gbk2utf16[0x4321] = 0x8176;
	__map_gbk2utf16[0x4322] = 0x8177;
	__map_gbk2utf16[0x4323] = 0x8178;
	__map_gbk2utf16[0x4324] = 0x8181;
	__map_gbk2utf16[0x4325] = 0x8183;
	__map_gbk2utf16[0x4326] = 0x8184;
	__map_gbk2utf16[0x4327] = 0x8185;
	__map_gbk2utf16[0x4328] = 0x8186;
	__map_gbk2utf16[0x4329] = 0x8187;
	__map_gbk2utf16[0x432a] = 0x8189;
	__map_gbk2utf16[0x432b] = 0x818b;
	__map_gbk2utf16[0x432c] = 0x818c;
	__map_gbk2utf16[0x432d] = 0x818d;
	__map_gbk2utf16[0x432e] = 0x818e;
	__map_gbk2utf16[0x432f] = 0x8190;
	__map_gbk2utf16[0x4330] = 0x8192;
	__map_gbk2utf16[0x4331] = 0x8193;
	__map_gbk2utf16[0x4332] = 0x8194;
	__map_gbk2utf16[0x4333] = 0x8195;
	__map_gbk2utf16[0x4334] = 0x8196;
	__map_gbk2utf16[0x4335] = 0x8197;
	__map_gbk2utf16[0x4336] = 0x8199;
	__map_gbk2utf16[0x4337] = 0x819a;
	__map_gbk2utf16[0x4338] = 0x819e;
	__map_gbk2utf16[0x4339] = 0x819f;
	__map_gbk2utf16[0x433a] = 0x81a0;
	__map_gbk2utf16[0x433b] = 0x81a1;
	__map_gbk2utf16[0x433c] = 0x81a2;
	__map_gbk2utf16[0x433d] = 0x81a4;
	__map_gbk2utf16[0x433e] = 0x81a5;
	__map_gbk2utf16[0x4340] = 0x81a7;
	__map_gbk2utf16[0x4341] = 0x81a9;
	__map_gbk2utf16[0x4342] = 0x81ab;
	__map_gbk2utf16[0x4343] = 0x81ac;
	__map_gbk2utf16[0x4344] = 0x81ad;
	__map_gbk2utf16[0x4345] = 0x81ae;
	__map_gbk2utf16[0x4346] = 0x81af;
	__map_gbk2utf16[0x4347] = 0x81b0;
	__map_gbk2utf16[0x4348] = 0x81b1;
	__map_gbk2utf16[0x4349] = 0x81b2;
	__map_gbk2utf16[0x434a] = 0x81b4;
	__map_gbk2utf16[0x434b] = 0x81b5;
	__map_gbk2utf16[0x434c] = 0x81b6;
	__map_gbk2utf16[0x434d] = 0x81b7;
	__map_gbk2utf16[0x434e] = 0x81b8;
	__map_gbk2utf16[0x434f] = 0x81b9;
	__map_gbk2utf16[0x4350] = 0x81bc;
	__map_gbk2utf16[0x4351] = 0x81bd;
	__map_gbk2utf16[0x4352] = 0x81be;
	__map_gbk2utf16[0x4353] = 0x81bf;
	__map_gbk2utf16[0x4354] = 0x81c4;
	__map_gbk2utf16[0x4355] = 0x81c5;
	__map_gbk2utf16[0x4356] = 0x81c7;
	__map_gbk2utf16[0x4357] = 0x81c8;
	__map_gbk2utf16[0x4358] = 0x81c9;
	__map_gbk2utf16[0x4359] = 0x81cb;
	__map_gbk2utf16[0x435a] = 0x81cd;
	__map_gbk2utf16[0x435b] = 0x81ce;
	__map_gbk2utf16[0x435c] = 0x81cf;
	__map_gbk2utf16[0x435d] = 0x81d0;
	__map_gbk2utf16[0x435e] = 0x81d1;
	__map_gbk2utf16[0x435f] = 0x81d2;
	__map_gbk2utf16[0x4360] = 0x81d3;
	__map_gbk2utf16[0x4361] = 0x6479;
	__map_gbk2utf16[0x4362] = 0x8611;
	__map_gbk2utf16[0x4363] = 0x6a21;
	__map_gbk2utf16[0x4364] = 0x819c;
	__map_gbk2utf16[0x4365] = 0x78e8;
	__map_gbk2utf16[0x4366] = 0x6469;
	__map_gbk2utf16[0x4367] = 0x9b54;
	__map_gbk2utf16[0x4368] = 0x62b9;
	__map_gbk2utf16[0x4369] = 0x672b;
	__map_gbk2utf16[0x436a] = 0x83ab;
	__map_gbk2utf16[0x436b] = 0x58a8;
	__map_gbk2utf16[0x436c] = 0x9ed8;
	__map_gbk2utf16[0x436d] = 0x6cab;
	__map_gbk2utf16[0x436e] = 0x6f20;
	__map_gbk2utf16[0x436f] = 0x5bde;
	__map_gbk2utf16[0x4370] = 0x964c;
	__map_gbk2utf16[0x4371] = 0x8c0b;
	__map_gbk2utf16[0x4372] = 0x725f;
	__map_gbk2utf16[0x4373] = 0x67d0;
	__map_gbk2utf16[0x4374] = 0x62c7;
	__map_gbk2utf16[0x4375] = 0x7261;
	__map_gbk2utf16[0x4376] = 0x4ea9;
	__map_gbk2utf16[0x4377] = 0x59c6;
	__map_gbk2utf16[0x4378] = 0x6bcd;
	__map_gbk2utf16[0x4379] = 0x5893;
	__map_gbk2utf16[0x437a] = 0x66ae;
	__map_gbk2utf16[0x437b] = 0x5e55;
	__map_gbk2utf16[0x437c] = 0x52df;
	__map_gbk2utf16[0x437d] = 0x6155;
	__map_gbk2utf16[0x437e] = 0x6728;
	__map_gbk2utf16[0x437f] = 0x76ee;
	__map_gbk2utf16[0x4380] = 0x7766;
	__map_gbk2utf16[0x4381] = 0x7267;
	__map_gbk2utf16[0x4382] = 0x7a46;
	__map_gbk2utf16[0x4383] = 0x62ff;
	__map_gbk2utf16[0x4384] = 0x54ea;
	__map_gbk2utf16[0x4385] = 0x5450;
	__map_gbk2utf16[0x4386] = 0x94a0;
	__map_gbk2utf16[0x4387] = 0x90a3;
	__map_gbk2utf16[0x4388] = 0x5a1c;
	__map_gbk2utf16[0x4389] = 0x7eb3;
	__map_gbk2utf16[0x438a] = 0x6c16;
	__map_gbk2utf16[0x438b] = 0x4e43;
	__map_gbk2utf16[0x438c] = 0x5976;
	__map_gbk2utf16[0x438d] = 0x8010;
	__map_gbk2utf16[0x438e] = 0x5948;
	__map_gbk2utf16[0x438f] = 0x5357;
	__map_gbk2utf16[0x4390] = 0x7537;
	__map_gbk2utf16[0x4391] = 0x96be;
	__map_gbk2utf16[0x4392] = 0x56ca;
	__map_gbk2utf16[0x4393] = 0x6320;
	__map_gbk2utf16[0x4394] = 0x8111;
	__map_gbk2utf16[0x4395] = 0x607c;
	__map_gbk2utf16[0x4396] = 0x95f9;
	__map_gbk2utf16[0x4397] = 0x6dd6;
	__map_gbk2utf16[0x4398] = 0x5462;
	__map_gbk2utf16[0x4399] = 0x9981;
	__map_gbk2utf16[0x439a] = 0x5185;
	__map_gbk2utf16[0x439b] = 0x5ae9;
	__map_gbk2utf16[0x439c] = 0x80fd;
	__map_gbk2utf16[0x439d] = 0x59ae;
	__map_gbk2utf16[0x439e] = 0x9713;
	__map_gbk2utf16[0x439f] = 0x502a;
	__map_gbk2utf16[0x43a0] = 0x6ce5;
	__map_gbk2utf16[0x43a1] = 0x5c3c;
	__map_gbk2utf16[0x43a2] = 0x62df;
	__map_gbk2utf16[0x43a3] = 0x4f60;
	__map_gbk2utf16[0x43a4] = 0x533f;
	__map_gbk2utf16[0x43a5] = 0x817b;
	__map_gbk2utf16[0x43a6] = 0x9006;
	__map_gbk2utf16[0x43a7] = 0x6eba;
	__map_gbk2utf16[0x43a8] = 0x852b;
	__map_gbk2utf16[0x43a9] = 0x62c8;
	__map_gbk2utf16[0x43aa] = 0x5e74;
	__map_gbk2utf16[0x43ab] = 0x78be;
	__map_gbk2utf16[0x43ac] = 0x64b5;
	__map_gbk2utf16[0x43ad] = 0x637b;
	__map_gbk2utf16[0x43ae] = 0x5ff5;
	__map_gbk2utf16[0x43af] = 0x5a18;
	__map_gbk2utf16[0x43b0] = 0x917f;
	__map_gbk2utf16[0x43b1] = 0x9e1f;
	__map_gbk2utf16[0x43b2] = 0x5c3f;
	__map_gbk2utf16[0x43b3] = 0x634f;
	__map_gbk2utf16[0x43b4] = 0x8042;
	__map_gbk2utf16[0x43b5] = 0x5b7d;
	__map_gbk2utf16[0x43b6] = 0x556e;
	__map_gbk2utf16[0x43b7] = 0x954a;
	__map_gbk2utf16[0x43b8] = 0x954d;
	__map_gbk2utf16[0x43b9] = 0x6d85;
	__map_gbk2utf16[0x43ba] = 0x60a8;
	__map_gbk2utf16[0x43bb] = 0x67e0;
	__map_gbk2utf16[0x43bc] = 0x72de;
	__map_gbk2utf16[0x43bd] = 0x51dd;
	__map_gbk2utf16[0x43be] = 0x5b81;
	__map_gbk2utf16[0x4400] = 0x81d4;
	__map_gbk2utf16[0x4401] = 0x81d5;
	__map_gbk2utf16[0x4402] = 0x81d6;
	__map_gbk2utf16[0x4403] = 0x81d7;
	__map_gbk2utf16[0x4404] = 0x81d8;
	__map_gbk2utf16[0x4405] = 0x81d9;
	__map_gbk2utf16[0x4406] = 0x81da;
	__map_gbk2utf16[0x4407] = 0x81db;
	__map_gbk2utf16[0x4408] = 0x81dc;
	__map_gbk2utf16[0x4409] = 0x81dd;
	__map_gbk2utf16[0x440a] = 0x81de;
	__map_gbk2utf16[0x440b] = 0x81df;
	__map_gbk2utf16[0x440c] = 0x81e0;
	__map_gbk2utf16[0x440d] = 0x81e1;
	__map_gbk2utf16[0x440e] = 0x81e2;
	__map_gbk2utf16[0x440f] = 0x81e4;
	__map_gbk2utf16[0x4410] = 0x81e5;
	__map_gbk2utf16[0x4411] = 0x81e6;
	__map_gbk2utf16[0x4412] = 0x81e8;
	__map_gbk2utf16[0x4413] = 0x81e9;
	__map_gbk2utf16[0x4414] = 0x81eb;
	__map_gbk2utf16[0x4415] = 0x81ee;
	__map_gbk2utf16[0x4416] = 0x81ef;
	__map_gbk2utf16[0x4417] = 0x81f0;
	__map_gbk2utf16[0x4418] = 0x81f1;
	__map_gbk2utf16[0x4419] = 0x81f2;
	__map_gbk2utf16[0x441a] = 0x81f5;
	__map_gbk2utf16[0x441b] = 0x81f6;
	__map_gbk2utf16[0x441c] = 0x81f7;
	__map_gbk2utf16[0x441d] = 0x81f8;
	__map_gbk2utf16[0x441e] = 0x81f9;
	__map_gbk2utf16[0x441f] = 0x81fa;
	__map_gbk2utf16[0x4420] = 0x81fd;
	__map_gbk2utf16[0x4421] = 0x81ff;
	__map_gbk2utf16[0x4422] = 0x8203;
	__map_gbk2utf16[0x4423] = 0x8207;
	__map_gbk2utf16[0x4424] = 0x8208;
	__map_gbk2utf16[0x4425] = 0x8209;
	__map_gbk2utf16[0x4426] = 0x820a;
	__map_gbk2utf16[0x4427] = 0x820b;
	__map_gbk2utf16[0x4428] = 0x820e;
	__map_gbk2utf16[0x4429] = 0x820f;
	__map_gbk2utf16[0x442a] = 0x8211;
	__map_gbk2utf16[0x442b] = 0x8213;
	__map_gbk2utf16[0x442c] = 0x8215;
	__map_gbk2utf16[0x442d] = 0x8216;
	__map_gbk2utf16[0x442e] = 0x8217;
	__map_gbk2utf16[0x442f] = 0x8218;
	__map_gbk2utf16[0x4430] = 0x8219;
	__map_gbk2utf16[0x4431] = 0x821a;
	__map_gbk2utf16[0x4432] = 0x821d;
	__map_gbk2utf16[0x4433] = 0x8220;
	__map_gbk2utf16[0x4434] = 0x8224;
	__map_gbk2utf16[0x4435] = 0x8225;
	__map_gbk2utf16[0x4436] = 0x8226;
	__map_gbk2utf16[0x4437] = 0x8227;
	__map_gbk2utf16[0x4438] = 0x8229;
	__map_gbk2utf16[0x4439] = 0x822e;
	__map_gbk2utf16[0x443a] = 0x8232;
	__map_gbk2utf16[0x443b] = 0x823a;
	__map_gbk2utf16[0x443c] = 0x823c;
	__map_gbk2utf16[0x443d] = 0x823d;
	__map_gbk2utf16[0x443e] = 0x823f;
	__map_gbk2utf16[0x4440] = 0x8240;
	__map_gbk2utf16[0x4441] = 0x8241;
	__map_gbk2utf16[0x4442] = 0x8242;
	__map_gbk2utf16[0x4443] = 0x8243;
	__map_gbk2utf16[0x4444] = 0x8245;
	__map_gbk2utf16[0x4445] = 0x8246;
	__map_gbk2utf16[0x4446] = 0x8248;
	__map_gbk2utf16[0x4447] = 0x824a;
	__map_gbk2utf16[0x4448] = 0x824c;
	__map_gbk2utf16[0x4449] = 0x824d;
	__map_gbk2utf16[0x444a] = 0x824e;
	__map_gbk2utf16[0x444b] = 0x8250;
	__map_gbk2utf16[0x444c] = 0x8251;
	__map_gbk2utf16[0x444d] = 0x8252;
	__map_gbk2utf16[0x444e] = 0x8253;
	__map_gbk2utf16[0x444f] = 0x8254;
	__map_gbk2utf16[0x4450] = 0x8255;
	__map_gbk2utf16[0x4451] = 0x8256;
	__map_gbk2utf16[0x4452] = 0x8257;
	__map_gbk2utf16[0x4453] = 0x8259;
	__map_gbk2utf16[0x4454] = 0x825b;
	__map_gbk2utf16[0x4455] = 0x825c;
	__map_gbk2utf16[0x4456] = 0x825d;
	__map_gbk2utf16[0x4457] = 0x825e;
	__map_gbk2utf16[0x4458] = 0x8260;
	__map_gbk2utf16[0x4459] = 0x8261;
	__map_gbk2utf16[0x445a] = 0x8262;
	__map_gbk2utf16[0x445b] = 0x8263;
	__map_gbk2utf16[0x445c] = 0x8264;
	__map_gbk2utf16[0x445d] = 0x8265;
	__map_gbk2utf16[0x445e] = 0x8266;
	__map_gbk2utf16[0x445f] = 0x8267;
	__map_gbk2utf16[0x4460] = 0x8269;
	__map_gbk2utf16[0x4461] = 0x62e7;
	__map_gbk2utf16[0x4462] = 0x6cde;
	__map_gbk2utf16[0x4463] = 0x725b;
	__map_gbk2utf16[0x4464] = 0x626d;
	__map_gbk2utf16[0x4465] = 0x94ae;
	__map_gbk2utf16[0x4466] = 0x7ebd;
	__map_gbk2utf16[0x4467] = 0x8113;
	__map_gbk2utf16[0x4468] = 0x6d53;
	__map_gbk2utf16[0x4469] = 0x519c;
	__map_gbk2utf16[0x446a] = 0x5f04;
	__map_gbk2utf16[0x446b] = 0x5974;
	__map_gbk2utf16[0x446c] = 0x52aa;
	__map_gbk2utf16[0x446d] = 0x6012;
	__map_gbk2utf16[0x446e] = 0x5973;
	__map_gbk2utf16[0x446f] = 0x6696;
	__map_gbk2utf16[0x4470] = 0x8650;
	__map_gbk2utf16[0x4471] = 0x759f;
	__map_gbk2utf16[0x4472] = 0x632a;
	__map_gbk2utf16[0x4473] = 0x61e6;
	__map_gbk2utf16[0x4474] = 0x7cef;
	__map_gbk2utf16[0x4475] = 0x8bfa;
	__map_gbk2utf16[0x4476] = 0x54e6;
	__map_gbk2utf16[0x4477] = 0x6b27;
	__map_gbk2utf16[0x4478] = 0x9e25;
	__map_gbk2utf16[0x4479] = 0x6bb4;
	__map_gbk2utf16[0x447a] = 0x85d5;
	__map_gbk2utf16[0x447b] = 0x5455;
	__map_gbk2utf16[0x447c] = 0x5076;
	__map_gbk2utf16[0x447d] = 0x6ca4;
	__map_gbk2utf16[0x447e] = 0x556a;
	__map_gbk2utf16[0x447f] = 0x8db4;
	__map_gbk2utf16[0x4480] = 0x722c;
	__map_gbk2utf16[0x4481] = 0x5e15;
	__map_gbk2utf16[0x4482] = 0x6015;
	__map_gbk2utf16[0x4483] = 0x7436;
	__map_gbk2utf16[0x4484] = 0x62cd;
	__map_gbk2utf16[0x4485] = 0x6392;
	__map_gbk2utf16[0x4486] = 0x724c;
	__map_gbk2utf16[0x4487] = 0x5f98;
	__map_gbk2utf16[0x4488] = 0x6e43;
	__map_gbk2utf16[0x4489] = 0x6d3e;
	__map_gbk2utf16[0x448a] = 0x6500;
	__map_gbk2utf16[0x448b] = 0x6f58;
	__map_gbk2utf16[0x448c] = 0x76d8;
	__map_gbk2utf16[0x448d] = 0x78d0;
	__map_gbk2utf16[0x448e] = 0x76fc;
	__map_gbk2utf16[0x448f] = 0x7554;
	__map_gbk2utf16[0x4490] = 0x5224;
	__map_gbk2utf16[0x4491] = 0x53db;
	__map_gbk2utf16[0x4492] = 0x4e53;
	__map_gbk2utf16[0x4493] = 0x5e9e;
	__map_gbk2utf16[0x4494] = 0x65c1;
	__map_gbk2utf16[0x4495] = 0x802a;
	__map_gbk2utf16[0x4496] = 0x80d6;
	__map_gbk2utf16[0x4497] = 0x629b;
	__map_gbk2utf16[0x4498] = 0x5486;
	__map_gbk2utf16[0x4499] = 0x5228;
	__map_gbk2utf16[0x449a] = 0x70ae;
	__map_gbk2utf16[0x449b] = 0x888d;
	__map_gbk2utf16[0x449c] = 0x8dd1;
	__map_gbk2utf16[0x449d] = 0x6ce1;
	__map_gbk2utf16[0x449e] = 0x5478;
	__map_gbk2utf16[0x449f] = 0x80da;
	__map_gbk2utf16[0x44a0] = 0x57f9;
	__map_gbk2utf16[0x44a1] = 0x88f4;
	__map_gbk2utf16[0x44a2] = 0x8d54;
	__map_gbk2utf16[0x44a3] = 0x966a;
	__map_gbk2utf16[0x44a4] = 0x914d;
	__map_gbk2utf16[0x44a5] = 0x4f69;
	__map_gbk2utf16[0x44a6] = 0x6c9b;
	__map_gbk2utf16[0x44a7] = 0x55b7;
	__map_gbk2utf16[0x44a8] = 0x76c6;
	__map_gbk2utf16[0x44a9] = 0x7830;
	__map_gbk2utf16[0x44aa] = 0x62a8;
	__map_gbk2utf16[0x44ab] = 0x70f9;
	__map_gbk2utf16[0x44ac] = 0x6f8e;
	__map_gbk2utf16[0x44ad] = 0x5f6d;
	__map_gbk2utf16[0x44ae] = 0x84ec;
	__map_gbk2utf16[0x44af] = 0x68da;
	__map_gbk2utf16[0x44b0] = 0x787c;
	__map_gbk2utf16[0x44b1] = 0x7bf7;
	__map_gbk2utf16[0x44b2] = 0x81a8;
	__map_gbk2utf16[0x44b3] = 0x670b;
	__map_gbk2utf16[0x44b4] = 0x9e4f;
	__map_gbk2utf16[0x44b5] = 0x6367;
	__map_gbk2utf16[0x44b6] = 0x78b0;
	__map_gbk2utf16[0x44b7] = 0x576f;
	__map_gbk2utf16[0x44b8] = 0x7812;
	__map_gbk2utf16[0x44b9] = 0x9739;
	__map_gbk2utf16[0x44ba] = 0x6279;
	__map_gbk2utf16[0x44bb] = 0x62ab;
	__map_gbk2utf16[0x44bc] = 0x5288;
	__map_gbk2utf16[0x44bd] = 0x7435;
	__map_gbk2utf16[0x44be] = 0x6bd7;
	__map_gbk2utf16[0x4500] = 0x826a;
	__map_gbk2utf16[0x4501] = 0x826b;
	__map_gbk2utf16[0x4502] = 0x826c;
	__map_gbk2utf16[0x4503] = 0x826d;
	__map_gbk2utf16[0x4504] = 0x8271;
	__map_gbk2utf16[0x4505] = 0x8275;
	__map_gbk2utf16[0x4506] = 0x8276;
	__map_gbk2utf16[0x4507] = 0x8277;
	__map_gbk2utf16[0x4508] = 0x8278;
	__map_gbk2utf16[0x4509] = 0x827b;
	__map_gbk2utf16[0x450a] = 0x827c;
	__map_gbk2utf16[0x450b] = 0x8280;
	__map_gbk2utf16[0x450c] = 0x8281;
	__map_gbk2utf16[0x450d] = 0x8283;
	__map_gbk2utf16[0x450e] = 0x8285;
	__map_gbk2utf16[0x450f] = 0x8286;
	__map_gbk2utf16[0x4510] = 0x8287;
	__map_gbk2utf16[0x4511] = 0x8289;
	__map_gbk2utf16[0x4512] = 0x828c;
	__map_gbk2utf16[0x4513] = 0x8290;
	__map_gbk2utf16[0x4514] = 0x8293;
	__map_gbk2utf16[0x4515] = 0x8294;
	__map_gbk2utf16[0x4516] = 0x8295;
	__map_gbk2utf16[0x4517] = 0x8296;
	__map_gbk2utf16[0x4518] = 0x829a;
	__map_gbk2utf16[0x4519] = 0x829b;
	__map_gbk2utf16[0x451a] = 0x829e;
	__map_gbk2utf16[0x451b] = 0x82a0;
	__map_gbk2utf16[0x451c] = 0x82a2;
	__map_gbk2utf16[0x451d] = 0x82a3;
	__map_gbk2utf16[0x451e] = 0x82a7;
	__map_gbk2utf16[0x451f] = 0x82b2;
	__map_gbk2utf16[0x4520] = 0x82b5;
	__map_gbk2utf16[0x4521] = 0x82b6;
	__map_gbk2utf16[0x4522] = 0x82ba;
	__map_gbk2utf16[0x4523] = 0x82bb;
	__map_gbk2utf16[0x4524] = 0x82bc;
	__map_gbk2utf16[0x4525] = 0x82bf;
	__map_gbk2utf16[0x4526] = 0x82c0;
	__map_gbk2utf16[0x4527] = 0x82c2;
	__map_gbk2utf16[0x4528] = 0x82c3;
	__map_gbk2utf16[0x4529] = 0x82c5;
	__map_gbk2utf16[0x452a] = 0x82c6;
	__map_gbk2utf16[0x452b] = 0x82c9;
	__map_gbk2utf16[0x452c] = 0x82d0;
	__map_gbk2utf16[0x452d] = 0x82d6;
	__map_gbk2utf16[0x452e] = 0x82d9;
	__map_gbk2utf16[0x452f] = 0x82da;
	__map_gbk2utf16[0x4530] = 0x82dd;
	__map_gbk2utf16[0x4531] = 0x82e2;
	__map_gbk2utf16[0x4532] = 0x82e7;
	__map_gbk2utf16[0x4533] = 0x82e8;
	__map_gbk2utf16[0x4534] = 0x82e9;
	__map_gbk2utf16[0x4535] = 0x82ea;
	__map_gbk2utf16[0x4536] = 0x82ec;
	__map_gbk2utf16[0x4537] = 0x82ed;
	__map_gbk2utf16[0x4538] = 0x82ee;
	__map_gbk2utf16[0x4539] = 0x82f0;
	__map_gbk2utf16[0x453a] = 0x82f2;
	__map_gbk2utf16[0x453b] = 0x82f3;
	__map_gbk2utf16[0x453c] = 0x82f5;
	__map_gbk2utf16[0x453d] = 0x82f6;
	__map_gbk2utf16[0x453e] = 0x82f8;
	__map_gbk2utf16[0x4540] = 0x82fa;
	__map_gbk2utf16[0x4541] = 0x82fc;
	__map_gbk2utf16[0x4542] = 0x82fd;
	__map_gbk2utf16[0x4543] = 0x82fe;
	__map_gbk2utf16[0x4544] = 0x82ff;
	__map_gbk2utf16[0x4545] = 0x8300;
	__map_gbk2utf16[0x4546] = 0x830a;
	__map_gbk2utf16[0x4547] = 0x830b;
	__map_gbk2utf16[0x4548] = 0x830d;
	__map_gbk2utf16[0x4549] = 0x8310;
	__map_gbk2utf16[0x454a] = 0x8312;
	__map_gbk2utf16[0x454b] = 0x8313;
	__map_gbk2utf16[0x454c] = 0x8316;
	__map_gbk2utf16[0x454d] = 0x8318;
	__map_gbk2utf16[0x454e] = 0x8319;
	__map_gbk2utf16[0x454f] = 0x831d;
	__map_gbk2utf16[0x4550] = 0x831e;
	__map_gbk2utf16[0x4551] = 0x831f;
	__map_gbk2utf16[0x4552] = 0x8320;
	__map_gbk2utf16[0x4553] = 0x8321;
	__map_gbk2utf16[0x4554] = 0x8322;
	__map_gbk2utf16[0x4555] = 0x8323;
	__map_gbk2utf16[0x4556] = 0x8324;
	__map_gbk2utf16[0x4557] = 0x8325;
	__map_gbk2utf16[0x4558] = 0x8326;
	__map_gbk2utf16[0x4559] = 0x8329;
	__map_gbk2utf16[0x455a] = 0x832a;
	__map_gbk2utf16[0x455b] = 0x832e;
	__map_gbk2utf16[0x455c] = 0x8330;
	__map_gbk2utf16[0x455d] = 0x8332;
	__map_gbk2utf16[0x455e] = 0x8337;
	__map_gbk2utf16[0x455f] = 0x833b;
	__map_gbk2utf16[0x4560] = 0x833d;
	__map_gbk2utf16[0x4561] = 0x5564;
	__map_gbk2utf16[0x4562] = 0x813e;
	__map_gbk2utf16[0x4563] = 0x75b2;
	__map_gbk2utf16[0x4564] = 0x76ae;
	__map_gbk2utf16[0x4565] = 0x5339;
	__map_gbk2utf16[0x4566] = 0x75de;
	__map_gbk2utf16[0x4567] = 0x50fb;
	__map_gbk2utf16[0x4568] = 0x5c41;
	__map_gbk2utf16[0x4569] = 0x8b6c;
	__map_gbk2utf16[0x456a] = 0x7bc7;
	__map_gbk2utf16[0x456b] = 0x504f;
	__map_gbk2utf16[0x456c] = 0x7247;
	__map_gbk2utf16[0x456d] = 0x9a97;
	__map_gbk2utf16[0x456e] = 0x98d8;
	__map_gbk2utf16[0x456f] = 0x6f02;
	__map_gbk2utf16[0x4570] = 0x74e2;
	__map_gbk2utf16[0x4571] = 0x7968;
	__map_gbk2utf16[0x4572] = 0x6487;
	__map_gbk2utf16[0x4573] = 0x77a5;
	__map_gbk2utf16[0x4574] = 0x62fc;
	__map_gbk2utf16[0x4575] = 0x9891;
	__map_gbk2utf16[0x4576] = 0x8d2b;
	__map_gbk2utf16[0x4577] = 0x54c1;
	__map_gbk2utf16[0x4578] = 0x8058;
	__map_gbk2utf16[0x4579] = 0x4e52;
	__map_gbk2utf16[0x457a] = 0x576a;
	__map_gbk2utf16[0x457b] = 0x82f9;
	__map_gbk2utf16[0x457c] = 0x840d;
	__map_gbk2utf16[0x457d] = 0x5e73;
	__map_gbk2utf16[0x457e] = 0x51ed;
	__map_gbk2utf16[0x457f] = 0x74f6;
	__map_gbk2utf16[0x4580] = 0x8bc4;
	__map_gbk2utf16[0x4581] = 0x5c4f;
	__map_gbk2utf16[0x4582] = 0x5761;
	__map_gbk2utf16[0x4583] = 0x6cfc;
	__map_gbk2utf16[0x4584] = 0x9887;
	__map_gbk2utf16[0x4585] = 0x5a46;
	__map_gbk2utf16[0x4586] = 0x7834;
	__map_gbk2utf16[0x4587] = 0x9b44;
	__map_gbk2utf16[0x4588] = 0x8feb;
	__map_gbk2utf16[0x4589] = 0x7c95;
	__map_gbk2utf16[0x458a] = 0x5256;
	__map_gbk2utf16[0x458b] = 0x6251;
	__map_gbk2utf16[0x458c] = 0x94fa;
	__map_gbk2utf16[0x458d] = 0x4ec6;
	__map_gbk2utf16[0x458e] = 0x8386;
	__map_gbk2utf16[0x458f] = 0x8461;
	__map_gbk2utf16[0x4590] = 0x83e9;
	__map_gbk2utf16[0x4591] = 0x84b2;
	__map_gbk2utf16[0x4592] = 0x57d4;
	__map_gbk2utf16[0x4593] = 0x6734;
	__map_gbk2utf16[0x4594] = 0x5703;
	__map_gbk2utf16[0x4595] = 0x666e;
	__map_gbk2utf16[0x4596] = 0x6d66;
	__map_gbk2utf16[0x4597] = 0x8c31;
	__map_gbk2utf16[0x4598] = 0x66dd;
	__map_gbk2utf16[0x4599] = 0x7011;
	__map_gbk2utf16[0x459a] = 0x671f;
	__map_gbk2utf16[0x459b] = 0x6b3a;
	__map_gbk2utf16[0x459c] = 0x6816;
	__map_gbk2utf16[0x459d] = 0x621a;
	__map_gbk2utf16[0x459e] = 0x59bb;
	__map_gbk2utf16[0x459f] = 0x4e03;
	__map_gbk2utf16[0x45a0] = 0x51c4;
	__map_gbk2utf16[0x45a1] = 0x6f06;
	__map_gbk2utf16[0x45a2] = 0x67d2;
	__map_gbk2utf16[0x45a3] = 0x6c8f;
	__map_gbk2utf16[0x45a4] = 0x5176;
	__map_gbk2utf16[0x45a5] = 0x68cb;
	__map_gbk2utf16[0x45a6] = 0x5947;
	__map_gbk2utf16[0x45a7] = 0x6b67;
	__map_gbk2utf16[0x45a8] = 0x7566;
	__map_gbk2utf16[0x45a9] = 0x5d0e;
	__map_gbk2utf16[0x45aa] = 0x8110;
	__map_gbk2utf16[0x45ab] = 0x9f50;
	__map_gbk2utf16[0x45ac] = 0x65d7;
	__map_gbk2utf16[0x45ad] = 0x7948;
	__map_gbk2utf16[0x45ae] = 0x7941;
	__map_gbk2utf16[0x45af] = 0x9a91;
	__map_gbk2utf16[0x45b0] = 0x8d77;
	__map_gbk2utf16[0x45b1] = 0x5c82;
	__map_gbk2utf16[0x45b2] = 0x4e5e;
	__map_gbk2utf16[0x45b3] = 0x4f01;
	__map_gbk2utf16[0x45b4] = 0x542f;
	__map_gbk2utf16[0x45b5] = 0x5951;
	__map_gbk2utf16[0x45b6] = 0x780c;
	__map_gbk2utf16[0x45b7] = 0x5668;
	__map_gbk2utf16[0x45b8] = 0x6c14;
	__map_gbk2utf16[0x45b9] = 0x8fc4;
	__map_gbk2utf16[0x45ba] = 0x5f03;
	__map_gbk2utf16[0x45bb] = 0x6c7d;
	__map_gbk2utf16[0x45bc] = 0x6ce3;
	__map_gbk2utf16[0x45bd] = 0x8bab;
	__map_gbk2utf16[0x45be] = 0x6390;
	__map_gbk2utf16[0x4600] = 0x833e;
	__map_gbk2utf16[0x4601] = 0x833f;
	__map_gbk2utf16[0x4602] = 0x8341;
	__map_gbk2utf16[0x4603] = 0x8342;
	__map_gbk2utf16[0x4604] = 0x8344;
	__map_gbk2utf16[0x4605] = 0x8345;
	__map_gbk2utf16[0x4606] = 0x8348;
	__map_gbk2utf16[0x4607] = 0x834a;
	__map_gbk2utf16[0x4608] = 0x834b;
	__map_gbk2utf16[0x4609] = 0x834c;
	__map_gbk2utf16[0x460a] = 0x834d;
	__map_gbk2utf16[0x460b] = 0x834e;
	__map_gbk2utf16[0x460c] = 0x8353;
	__map_gbk2utf16[0x460d] = 0x8355;
	__map_gbk2utf16[0x460e] = 0x8356;
	__map_gbk2utf16[0x460f] = 0x8357;
	__map_gbk2utf16[0x4610] = 0x8358;
	__map_gbk2utf16[0x4611] = 0x8359;
	__map_gbk2utf16[0x4612] = 0x835d;
	__map_gbk2utf16[0x4613] = 0x8362;
	__map_gbk2utf16[0x4614] = 0x8370;
	__map_gbk2utf16[0x4615] = 0x8371;
	__map_gbk2utf16[0x4616] = 0x8372;
	__map_gbk2utf16[0x4617] = 0x8373;
	__map_gbk2utf16[0x4618] = 0x8374;
	__map_gbk2utf16[0x4619] = 0x8375;
	__map_gbk2utf16[0x461a] = 0x8376;
	__map_gbk2utf16[0x461b] = 0x8379;
	__map_gbk2utf16[0x461c] = 0x837a;
	__map_gbk2utf16[0x461d] = 0x837e;
	__map_gbk2utf16[0x461e] = 0x837f;
	__map_gbk2utf16[0x461f] = 0x8380;
	__map_gbk2utf16[0x4620] = 0x8381;
	__map_gbk2utf16[0x4621] = 0x8382;
	__map_gbk2utf16[0x4622] = 0x8383;
	__map_gbk2utf16[0x4623] = 0x8384;
	__map_gbk2utf16[0x4624] = 0x8387;
	__map_gbk2utf16[0x4625] = 0x8388;
	__map_gbk2utf16[0x4626] = 0x838a;
	__map_gbk2utf16[0x4627] = 0x838b;
	__map_gbk2utf16[0x4628] = 0x838c;
	__map_gbk2utf16[0x4629] = 0x838d;
	__map_gbk2utf16[0x462a] = 0x838f;
	__map_gbk2utf16[0x462b] = 0x8390;
	__map_gbk2utf16[0x462c] = 0x8391;
	__map_gbk2utf16[0x462d] = 0x8394;
	__map_gbk2utf16[0x462e] = 0x8395;
	__map_gbk2utf16[0x462f] = 0x8396;
	__map_gbk2utf16[0x4630] = 0x8397;
	__map_gbk2utf16[0x4631] = 0x8399;
	__map_gbk2utf16[0x4632] = 0x839a;
	__map_gbk2utf16[0x4633] = 0x839d;
	__map_gbk2utf16[0x4634] = 0x839f;
	__map_gbk2utf16[0x4635] = 0x83a1;
	__map_gbk2utf16[0x4636] = 0x83a2;
	__map_gbk2utf16[0x4637] = 0x83a3;
	__map_gbk2utf16[0x4638] = 0x83a4;
	__map_gbk2utf16[0x4639] = 0x83a5;
	__map_gbk2utf16[0x463a] = 0x83a6;
	__map_gbk2utf16[0x463b] = 0x83a7;
	__map_gbk2utf16[0x463c] = 0x83ac;
	__map_gbk2utf16[0x463d] = 0x83ad;
	__map_gbk2utf16[0x463e] = 0x83ae;
	__map_gbk2utf16[0x4640] = 0x83af;
	__map_gbk2utf16[0x4641] = 0x83b5;
	__map_gbk2utf16[0x4642] = 0x83bb;
	__map_gbk2utf16[0x4643] = 0x83be;
	__map_gbk2utf16[0x4644] = 0x83bf;
	__map_gbk2utf16[0x4645] = 0x83c2;
	__map_gbk2utf16[0x4646] = 0x83c3;
	__map_gbk2utf16[0x4647] = 0x83c4;
	__map_gbk2utf16[0x4648] = 0x83c6;
	__map_gbk2utf16[0x4649] = 0x83c8;
	__map_gbk2utf16[0x464a] = 0x83c9;
	__map_gbk2utf16[0x464b] = 0x83cb;
	__map_gbk2utf16[0x464c] = 0x83cd;
	__map_gbk2utf16[0x464d] = 0x83ce;
	__map_gbk2utf16[0x464e] = 0x83d0;
	__map_gbk2utf16[0x464f] = 0x83d1;
	__map_gbk2utf16[0x4650] = 0x83d2;
	__map_gbk2utf16[0x4651] = 0x83d3;
	__map_gbk2utf16[0x4652] = 0x83d5;
	__map_gbk2utf16[0x4653] = 0x83d7;
	__map_gbk2utf16[0x4654] = 0x83d9;
	__map_gbk2utf16[0x4655] = 0x83da;
	__map_gbk2utf16[0x4656] = 0x83db;
	__map_gbk2utf16[0x4657] = 0x83de;
	__map_gbk2utf16[0x4658] = 0x83e2;
	__map_gbk2utf16[0x4659] = 0x83e3;
	__map_gbk2utf16[0x465a] = 0x83e4;
	__map_gbk2utf16[0x465b] = 0x83e6;
	__map_gbk2utf16[0x465c] = 0x83e7;
	__map_gbk2utf16[0x465d] = 0x83e8;
	__map_gbk2utf16[0x465e] = 0x83eb;
	__map_gbk2utf16[0x465f] = 0x83ec;
	__map_gbk2utf16[0x4660] = 0x83ed;
	__map_gbk2utf16[0x4661] = 0x6070;
	__map_gbk2utf16[0x4662] = 0x6d3d;
	__map_gbk2utf16[0x4663] = 0x7275;
	__map_gbk2utf16[0x4664] = 0x6266;
	__map_gbk2utf16[0x4665] = 0x948e;
	__map_gbk2utf16[0x4666] = 0x94c5;
	__map_gbk2utf16[0x4667] = 0x5343;
	__map_gbk2utf16[0x4668] = 0x8fc1;
	__map_gbk2utf16[0x4669] = 0x7b7e;
	__map_gbk2utf16[0x466a] = 0x4edf;
	__map_gbk2utf16[0x466b] = 0x8c26;
	__map_gbk2utf16[0x466c] = 0x4e7e;
	__map_gbk2utf16[0x466d] = 0x9ed4;
	__map_gbk2utf16[0x466e] = 0x94b1;
	__map_gbk2utf16[0x466f] = 0x94b3;
	__map_gbk2utf16[0x4670] = 0x524d;
	__map_gbk2utf16[0x4671] = 0x6f5c;
	__map_gbk2utf16[0x4672] = 0x9063;
	__map_gbk2utf16[0x4673] = 0x6d45;
	__map_gbk2utf16[0x4674] = 0x8c34;
	__map_gbk2utf16[0x4675] = 0x5811;
	__map_gbk2utf16[0x4676] = 0x5d4c;
	__map_gbk2utf16[0x4677] = 0x6b20;
	__map_gbk2utf16[0x4678] = 0x6b49;
	__map_gbk2utf16[0x4679] = 0x67aa;
	__map_gbk2utf16[0x467a] = 0x545b;
	__map_gbk2utf16[0x467b] = 0x8154;
	__map_gbk2utf16[0x467c] = 0x7f8c;
	__map_gbk2utf16[0x467d] = 0x5899;
	__map_gbk2utf16[0x467e] = 0x8537;
	__map_gbk2utf16[0x467f] = 0x5f3a;
	__map_gbk2utf16[0x4680] = 0x62a2;
	__map_gbk2utf16[0x4681] = 0x6a47;
	__map_gbk2utf16[0x4682] = 0x9539;
	__map_gbk2utf16[0x4683] = 0x6572;
	__map_gbk2utf16[0x4684] = 0x6084;
	__map_gbk2utf16[0x4685] = 0x6865;
	__map_gbk2utf16[0x4686] = 0x77a7;
	__map_gbk2utf16[0x4687] = 0x4e54;
	__map_gbk2utf16[0x4688] = 0x4fa8;
	__map_gbk2utf16[0x4689] = 0x5de7;
	__map_gbk2utf16[0x468a] = 0x9798;
	__map_gbk2utf16[0x468b] = 0x64ac;
	__map_gbk2utf16[0x468c] = 0x7fd8;
	__map_gbk2utf16[0x468d] = 0x5ced;
	__map_gbk2utf16[0x468e] = 0x4fcf;
	__map_gbk2utf16[0x468f] = 0x7a8d;
	__map_gbk2utf16[0x4690] = 0x5207;
	__map_gbk2utf16[0x4691] = 0x8304;
	__map_gbk2utf16[0x4692] = 0x4e14;
	__map_gbk2utf16[0x4693] = 0x602f;
	__map_gbk2utf16[0x4694] = 0x7a83;
	__map_gbk2utf16[0x4695] = 0x94a6;
	__map_gbk2utf16[0x4696] = 0x4fb5;
	__map_gbk2utf16[0x4697] = 0x4eb2;
	__map_gbk2utf16[0x4698] = 0x79e6;
	__map_gbk2utf16[0x4699] = 0x7434;
	__map_gbk2utf16[0x469a] = 0x52e4;
	__map_gbk2utf16[0x469b] = 0x82b9;
	__map_gbk2utf16[0x469c] = 0x64d2;
	__map_gbk2utf16[0x469d] = 0x79bd;
	__map_gbk2utf16[0x469e] = 0x5bdd;
	__map_gbk2utf16[0x469f] = 0x6c81;
	__map_gbk2utf16[0x46a0] = 0x9752;
	__map_gbk2utf16[0x46a1] = 0x8f7b;
	__map_gbk2utf16[0x46a2] = 0x6c22;
	__map_gbk2utf16[0x46a3] = 0x503e;
	__map_gbk2utf16[0x46a4] = 0x537f;
	__map_gbk2utf16[0x46a5] = 0x6e05;
	__map_gbk2utf16[0x46a6] = 0x64ce;
	__map_gbk2utf16[0x46a7] = 0x6674;
	__map_gbk2utf16[0x46a8] = 0x6c30;
	__map_gbk2utf16[0x46a9] = 0x60c5;
	__map_gbk2utf16[0x46aa] = 0x9877;
	__map_gbk2utf16[0x46ab] = 0x8bf7;
	__map_gbk2utf16[0x46ac] = 0x5e86;
	__map_gbk2utf16[0x46ad] = 0x743c;
	__map_gbk2utf16[0x46ae] = 0x7a77;
	__map_gbk2utf16[0x46af] = 0x79cb;
	__map_gbk2utf16[0x46b0] = 0x4e18;
	__map_gbk2utf16[0x46b1] = 0x90b1;
	__map_gbk2utf16[0x46b2] = 0x7403;
	__map_gbk2utf16[0x46b3] = 0x6c42;
	__map_gbk2utf16[0x46b4] = 0x56da;
	__map_gbk2utf16[0x46b5] = 0x914b;
	__map_gbk2utf16[0x46b6] = 0x6cc5;
	__map_gbk2utf16[0x46b7] = 0x8d8b;
	__map_gbk2utf16[0x46b8] = 0x533a;
	__map_gbk2utf16[0x46b9] = 0x86c6;
	__map_gbk2utf16[0x46ba] = 0x66f2;
	__map_gbk2utf16[0x46bb] = 0x8eaf;
	__map_gbk2utf16[0x46bc] = 0x5c48;
	__map_gbk2utf16[0x46bd] = 0x9a71;
	__map_gbk2utf16[0x46be] = 0x6e20;
	__map_gbk2utf16[0x4700] = 0x83ee;
	__map_gbk2utf16[0x4701] = 0x83ef;
	__map_gbk2utf16[0x4702] = 0x83f3;
	__map_gbk2utf16[0x4703] = 0x83f4;
	__map_gbk2utf16[0x4704] = 0x83f5;
	__map_gbk2utf16[0x4705] = 0x83f6;
	__map_gbk2utf16[0x4706] = 0x83f7;
	__map_gbk2utf16[0x4707] = 0x83fa;
	__map_gbk2utf16[0x4708] = 0x83fb;
	__map_gbk2utf16[0x4709] = 0x83fc;
	__map_gbk2utf16[0x470a] = 0x83fe;
	__map_gbk2utf16[0x470b] = 0x83ff;
	__map_gbk2utf16[0x470c] = 0x8400;
	__map_gbk2utf16[0x470d] = 0x8402;
	__map_gbk2utf16[0x470e] = 0x8405;
	__map_gbk2utf16[0x470f] = 0x8407;
	__map_gbk2utf16[0x4710] = 0x8408;
	__map_gbk2utf16[0x4711] = 0x8409;
	__map_gbk2utf16[0x4712] = 0x840a;
	__map_gbk2utf16[0x4713] = 0x8410;
	__map_gbk2utf16[0x4714] = 0x8412;
	__map_gbk2utf16[0x4715] = 0x8413;
	__map_gbk2utf16[0x4716] = 0x8414;
	__map_gbk2utf16[0x4717] = 0x8415;
	__map_gbk2utf16[0x4718] = 0x8416;
	__map_gbk2utf16[0x4719] = 0x8417;
	__map_gbk2utf16[0x471a] = 0x8419;
	__map_gbk2utf16[0x471b] = 0x841a;
	__map_gbk2utf16[0x471c] = 0x841b;
	__map_gbk2utf16[0x471d] = 0x841e;
	__map_gbk2utf16[0x471e] = 0x841f;
	__map_gbk2utf16[0x471f] = 0x8420;
	__map_gbk2utf16[0x4720] = 0x8421;
	__map_gbk2utf16[0x4721] = 0x8422;
	__map_gbk2utf16[0x4722] = 0x8423;
	__map_gbk2utf16[0x4723] = 0x8429;
	__map_gbk2utf16[0x4724] = 0x842a;
	__map_gbk2utf16[0x4725] = 0x842b;
	__map_gbk2utf16[0x4726] = 0x842c;
	__map_gbk2utf16[0x4727] = 0x842d;
	__map_gbk2utf16[0x4728] = 0x842e;
	__map_gbk2utf16[0x4729] = 0x842f;
	__map_gbk2utf16[0x472a] = 0x8430;
	__map_gbk2utf16[0x472b] = 0x8432;
	__map_gbk2utf16[0x472c] = 0x8433;
	__map_gbk2utf16[0x472d] = 0x8434;
	__map_gbk2utf16[0x472e] = 0x8435;
	__map_gbk2utf16[0x472f] = 0x8436;
	__map_gbk2utf16[0x4730] = 0x8437;
	__map_gbk2utf16[0x4731] = 0x8439;
	__map_gbk2utf16[0x4732] = 0x843a;
	__map_gbk2utf16[0x4733] = 0x843b;
	__map_gbk2utf16[0x4734] = 0x843e;
	__map_gbk2utf16[0x4735] = 0x843f;
	__map_gbk2utf16[0x4736] = 0x8440;
	__map_gbk2utf16[0x4737] = 0x8441;
	__map_gbk2utf16[0x4738] = 0x8442;
	__map_gbk2utf16[0x4739] = 0x8443;
	__map_gbk2utf16[0x473a] = 0x8444;
	__map_gbk2utf16[0x473b] = 0x8445;
	__map_gbk2utf16[0x473c] = 0x8447;
	__map_gbk2utf16[0x473d] = 0x8448;
	__map_gbk2utf16[0x473e] = 0x8449;
	__map_gbk2utf16[0x4740] = 0x844a;
	__map_gbk2utf16[0x4741] = 0x844b;
	__map_gbk2utf16[0x4742] = 0x844c;
	__map_gbk2utf16[0x4743] = 0x844d;
	__map_gbk2utf16[0x4744] = 0x844e;
	__map_gbk2utf16[0x4745] = 0x844f;
	__map_gbk2utf16[0x4746] = 0x8450;
	__map_gbk2utf16[0x4747] = 0x8452;
	__map_gbk2utf16[0x4748] = 0x8453;
	__map_gbk2utf16[0x4749] = 0x8454;
	__map_gbk2utf16[0x474a] = 0x8455;
	__map_gbk2utf16[0x474b] = 0x8456;
	__map_gbk2utf16[0x474c] = 0x8458;
	__map_gbk2utf16[0x474d] = 0x845d;
	__map_gbk2utf16[0x474e] = 0x845e;
	__map_gbk2utf16[0x474f] = 0x845f;
	__map_gbk2utf16[0x4750] = 0x8460;
	__map_gbk2utf16[0x4751] = 0x8462;
	__map_gbk2utf16[0x4752] = 0x8464;
	__map_gbk2utf16[0x4753] = 0x8465;
	__map_gbk2utf16[0x4754] = 0x8466;
	__map_gbk2utf16[0x4755] = 0x8467;
	__map_gbk2utf16[0x4756] = 0x8468;
	__map_gbk2utf16[0x4757] = 0x846a;
	__map_gbk2utf16[0x4758] = 0x846e;
	__map_gbk2utf16[0x4759] = 0x846f;
	__map_gbk2utf16[0x475a] = 0x8470;
	__map_gbk2utf16[0x475b] = 0x8472;
	__map_gbk2utf16[0x475c] = 0x8474;
	__map_gbk2utf16[0x475d] = 0x8477;
	__map_gbk2utf16[0x475e] = 0x8479;
	__map_gbk2utf16[0x475f] = 0x847b;
	__map_gbk2utf16[0x4760] = 0x847c;
	__map_gbk2utf16[0x4761] = 0x53d6;
	__map_gbk2utf16[0x4762] = 0x5a36;
	__map_gbk2utf16[0x4763] = 0x9f8b;
	__map_gbk2utf16[0x4764] = 0x8da3;
	__map_gbk2utf16[0x4765] = 0x53bb;
	__map_gbk2utf16[0x4766] = 0x5708;
	__map_gbk2utf16[0x4767] = 0x98a7;
	__map_gbk2utf16[0x4768] = 0x6743;
	__map_gbk2utf16[0x4769] = 0x919b;
	__map_gbk2utf16[0x476a] = 0x6cc9;
	__map_gbk2utf16[0x476b] = 0x5168;
	__map_gbk2utf16[0x476c] = 0x75ca;
	__map_gbk2utf16[0x476d] = 0x62f3;
	__map_gbk2utf16[0x476e] = 0x72ac;
	__map_gbk2utf16[0x476f] = 0x5238;
	__map_gbk2utf16[0x4770] = 0x529d;
	__map_gbk2utf16[0x4771] = 0x7f3a;
	__map_gbk2utf16[0x4772] = 0x7094;
	__map_gbk2utf16[0x4773] = 0x7638;
	__map_gbk2utf16[0x4774] = 0x5374;
	__map_gbk2utf16[0x4775] = 0x9e4a;
	__map_gbk2utf16[0x4776] = 0x69b7;
	__map_gbk2utf16[0x4777] = 0x786e;
	__map_gbk2utf16[0x4778] = 0x96c0;
	__map_gbk2utf16[0x4779] = 0x88d9;
	__map_gbk2utf16[0x477a] = 0x7fa4;
	__map_gbk2utf16[0x477b] = 0x7136;
	__map_gbk2utf16[0x477c] = 0x71c3;
	__map_gbk2utf16[0x477d] = 0x5189;
	__map_gbk2utf16[0x477e] = 0x67d3;
	__map_gbk2utf16[0x477f] = 0x74e4;
	__map_gbk2utf16[0x4780] = 0x58e4;
	__map_gbk2utf16[0x4781] = 0x6518;
	__map_gbk2utf16[0x4782] = 0x56b7;
	__map_gbk2utf16[0x4783] = 0x8ba9;
	__map_gbk2utf16[0x4784] = 0x9976;
	__map_gbk2utf16[0x4785] = 0x6270;
	__map_gbk2utf16[0x4786] = 0x7ed5;
	__map_gbk2utf16[0x4787] = 0x60f9;
	__map_gbk2utf16[0x4788] = 0x70ed;
	__map_gbk2utf16[0x4789] = 0x58ec;
	__map_gbk2utf16[0x478a] = 0x4ec1;
	__map_gbk2utf16[0x478b] = 0x4eba;
	__map_gbk2utf16[0x478c] = 0x5fcd;
	__map_gbk2utf16[0x478d] = 0x97e7;
	__map_gbk2utf16[0x478e] = 0x4efb;
	__map_gbk2utf16[0x478f] = 0x8ba4;
	__map_gbk2utf16[0x4790] = 0x5203;
	__map_gbk2utf16[0x4791] = 0x598a;
	__map_gbk2utf16[0x4792] = 0x7eab;
	__map_gbk2utf16[0x4793] = 0x6254;
	__map_gbk2utf16[0x4794] = 0x4ecd;
	__map_gbk2utf16[0x4795] = 0x65e5;
	__map_gbk2utf16[0x4796] = 0x620e;
	__map_gbk2utf16[0x4797] = 0x8338;
	__map_gbk2utf16[0x4798] = 0x84c9;
	__map_gbk2utf16[0x4799] = 0x8363;
	__map_gbk2utf16[0x479a] = 0x878d;
	__map_gbk2utf16[0x479b] = 0x7194;
	__map_gbk2utf16[0x479c] = 0x6eb6;
	__map_gbk2utf16[0x479d] = 0x5bb9;
	__map_gbk2utf16[0x479e] = 0x7ed2;
	__map_gbk2utf16[0x479f] = 0x5197;
	__map_gbk2utf16[0x47a0] = 0x63c9;
	__map_gbk2utf16[0x47a1] = 0x67d4;
	__map_gbk2utf16[0x47a2] = 0x8089;
	__map_gbk2utf16[0x47a3] = 0x8339;
	__map_gbk2utf16[0x47a4] = 0x8815;
	__map_gbk2utf16[0x47a5] = 0x5112;
	__map_gbk2utf16[0x47a6] = 0x5b7a;
	__map_gbk2utf16[0x47a7] = 0x5982;
	__map_gbk2utf16[0x47a8] = 0x8fb1;
	__map_gbk2utf16[0x47a9] = 0x4e73;
	__map_gbk2utf16[0x47aa] = 0x6c5d;
	__map_gbk2utf16[0x47ab] = 0x5165;
	__map_gbk2utf16[0x47ac] = 0x8925;
	__map_gbk2utf16[0x47ad] = 0x8f6f;
	__map_gbk2utf16[0x47ae] = 0x962e;
	__map_gbk2utf16[0x47af] = 0x854a;
	__map_gbk2utf16[0x47b0] = 0x745e;
	__map_gbk2utf16[0x47b1] = 0x9510;
	__map_gbk2utf16[0x47b2] = 0x95f0;
	__map_gbk2utf16[0x47b3] = 0x6da6;
	__map_gbk2utf16[0x47b4] = 0x82e5;
	__map_gbk2utf16[0x47b5] = 0x5f31;
	__map_gbk2utf16[0x47b6] = 0x6492;
	__map_gbk2utf16[0x47b7] = 0x6d12;
	__map_gbk2utf16[0x47b8] = 0x8428;
	__map_gbk2utf16[0x47b9] = 0x816e;
	__map_gbk2utf16[0x47ba] = 0x9cc3;
	__map_gbk2utf16[0x47bb] = 0x585e;
	__map_gbk2utf16[0x47bc] = 0x8d5b;
	__map_gbk2utf16[0x47bd] = 0x4e09;
	__map_gbk2utf16[0x47be] = 0x53c1;
	__map_gbk2utf16[0x4800] = 0x847d;
	__map_gbk2utf16[0x4801] = 0x847e;
	__map_gbk2utf16[0x4802] = 0x847f;
	__map_gbk2utf16[0x4803] = 0x8480;
	__map_gbk2utf16[0x4804] = 0x8481;
	__map_gbk2utf16[0x4805] = 0x8483;
	__map_gbk2utf16[0x4806] = 0x8484;
	__map_gbk2utf16[0x4807] = 0x8485;
	__map_gbk2utf16[0x4808] = 0x8486;
	__map_gbk2utf16[0x4809] = 0x848a;
	__map_gbk2utf16[0x480a] = 0x848d;
	__map_gbk2utf16[0x480b] = 0x848f;
	__map_gbk2utf16[0x480c] = 0x8490;
	__map_gbk2utf16[0x480d] = 0x8491;
	__map_gbk2utf16[0x480e] = 0x8492;
	__map_gbk2utf16[0x480f] = 0x8493;
	__map_gbk2utf16[0x4810] = 0x8494;
	__map_gbk2utf16[0x4811] = 0x8495;
	__map_gbk2utf16[0x4812] = 0x8496;
	__map_gbk2utf16[0x4813] = 0x8498;
	__map_gbk2utf16[0x4814] = 0x849a;
	__map_gbk2utf16[0x4815] = 0x849b;
	__map_gbk2utf16[0x4816] = 0x849d;
	__map_gbk2utf16[0x4817] = 0x849e;
	__map_gbk2utf16[0x4818] = 0x849f;
	__map_gbk2utf16[0x4819] = 0x84a0;
	__map_gbk2utf16[0x481a] = 0x84a2;
	__map_gbk2utf16[0x481b] = 0x84a3;
	__map_gbk2utf16[0x481c] = 0x84a4;
	__map_gbk2utf16[0x481d] = 0x84a5;
	__map_gbk2utf16[0x481e] = 0x84a6;
	__map_gbk2utf16[0x481f] = 0x84a7;
	__map_gbk2utf16[0x4820] = 0x84a8;
	__map_gbk2utf16[0x4821] = 0x84a9;
	__map_gbk2utf16[0x4822] = 0x84aa;
	__map_gbk2utf16[0x4823] = 0x84ab;
	__map_gbk2utf16[0x4824] = 0x84ac;
	__map_gbk2utf16[0x4825] = 0x84ad;
	__map_gbk2utf16[0x4826] = 0x84ae;
	__map_gbk2utf16[0x4827] = 0x84b0;
	__map_gbk2utf16[0x4828] = 0x84b1;
	__map_gbk2utf16[0x4829] = 0x84b3;
	__map_gbk2utf16[0x482a] = 0x84b5;
	__map_gbk2utf16[0x482b] = 0x84b6;
	__map_gbk2utf16[0x482c] = 0x84b7;
	__map_gbk2utf16[0x482d] = 0x84bb;
	__map_gbk2utf16[0x482e] = 0x84bc;
	__map_gbk2utf16[0x482f] = 0x84be;
	__map_gbk2utf16[0x4830] = 0x84c0;
	__map_gbk2utf16[0x4831] = 0x84c2;
	__map_gbk2utf16[0x4832] = 0x84c3;
	__map_gbk2utf16[0x4833] = 0x84c5;
	__map_gbk2utf16[0x4834] = 0x84c6;
	__map_gbk2utf16[0x4835] = 0x84c7;
	__map_gbk2utf16[0x4836] = 0x84c8;
	__map_gbk2utf16[0x4837] = 0x84cb;
	__map_gbk2utf16[0x4838] = 0x84cc;
	__map_gbk2utf16[0x4839] = 0x84ce;
	__map_gbk2utf16[0x483a] = 0x84cf;
	__map_gbk2utf16[0x483b] = 0x84d2;
	__map_gbk2utf16[0x483c] = 0x84d4;
	__map_gbk2utf16[0x483d] = 0x84d5;
	__map_gbk2utf16[0x483e] = 0x84d7;
	__map_gbk2utf16[0x4840] = 0x84d8;
	__map_gbk2utf16[0x4841] = 0x84d9;
	__map_gbk2utf16[0x4842] = 0x84da;
	__map_gbk2utf16[0x4843] = 0x84db;
	__map_gbk2utf16[0x4844] = 0x84dc;
	__map_gbk2utf16[0x4845] = 0x84de;
	__map_gbk2utf16[0x4846] = 0x84e1;
	__map_gbk2utf16[0x4847] = 0x84e2;
	__map_gbk2utf16[0x4848] = 0x84e4;
	__map_gbk2utf16[0x4849] = 0x84e7;
	__map_gbk2utf16[0x484a] = 0x84e8;
	__map_gbk2utf16[0x484b] = 0x84e9;
	__map_gbk2utf16[0x484c] = 0x84ea;
	__map_gbk2utf16[0x484d] = 0x84eb;
	__map_gbk2utf16[0x484e] = 0x84ed;
	__map_gbk2utf16[0x484f] = 0x84ee;
	__map_gbk2utf16[0x4850] = 0x84ef;
	__map_gbk2utf16[0x4851] = 0x84f1;
	__map_gbk2utf16[0x4852] = 0x84f2;
	__map_gbk2utf16[0x4853] = 0x84f3;
	__map_gbk2utf16[0x4854] = 0x84f4;
	__map_gbk2utf16[0x4855] = 0x84f5;
	__map_gbk2utf16[0x4856] = 0x84f6;
	__map_gbk2utf16[0x4857] = 0x84f7;
	__map_gbk2utf16[0x4858] = 0x84f8;
	__map_gbk2utf16[0x4859] = 0x84f9;
	__map_gbk2utf16[0x485a] = 0x84fa;
	__map_gbk2utf16[0x485b] = 0x84fb;
	__map_gbk2utf16[0x485c] = 0x84fd;
	__map_gbk2utf16[0x485d] = 0x84fe;
	__map_gbk2utf16[0x485e] = 0x8500;
	__map_gbk2utf16[0x485f] = 0x8501;
	__map_gbk2utf16[0x4860] = 0x8502;
	__map_gbk2utf16[0x4861] = 0x4f1e;
	__map_gbk2utf16[0x4862] = 0x6563;
	__map_gbk2utf16[0x4863] = 0x6851;
	__map_gbk2utf16[0x4864] = 0x55d3;
	__map_gbk2utf16[0x4865] = 0x4e27;
	__map_gbk2utf16[0x4866] = 0x6414;
	__map_gbk2utf16[0x4867] = 0x9a9a;
	__map_gbk2utf16[0x4868] = 0x626b;
	__map_gbk2utf16[0x4869] = 0x5ac2;
	__map_gbk2utf16[0x486a] = 0x745f;
	__map_gbk2utf16[0x486b] = 0x8272;
	__map_gbk2utf16[0x486c] = 0x6da9;
	__map_gbk2utf16[0x486d] = 0x68ee;
	__map_gbk2utf16[0x486e] = 0x50e7;
	__map_gbk2utf16[0x486f] = 0x838e;
	__map_gbk2utf16[0x4870] = 0x7802;
	__map_gbk2utf16[0x4871] = 0x6740;
	__map_gbk2utf16[0x4872] = 0x5239;
	__map_gbk2utf16[0x4873] = 0x6c99;
	__map_gbk2utf16[0x4874] = 0x7eb1;
	__map_gbk2utf16[0x4875] = 0x50bb;
	__map_gbk2utf16[0x4876] = 0x5565;
	__map_gbk2utf16[0x4877] = 0x715e;
	__map_gbk2utf16[0x4878] = 0x7b5b;
	__map_gbk2utf16[0x4879] = 0x6652;
	__map_gbk2utf16[0x487a] = 0x73ca;
	__map_gbk2utf16[0x487b] = 0x82eb;
	__map_gbk2utf16[0x487c] = 0x6749;
	__map_gbk2utf16[0x487d] = 0x5c71;
	__map_gbk2utf16[0x487e] = 0x5220;
	__map_gbk2utf16[0x487f] = 0x717d;
	__map_gbk2utf16[0x4880] = 0x886b;
	__map_gbk2utf16[0x4881] = 0x95ea;
	__map_gbk2utf16[0x4882] = 0x9655;
	__map_gbk2utf16[0x4883] = 0x64c5;
	__map_gbk2utf16[0x4884] = 0x8d61;
	__map_gbk2utf16[0x4885] = 0x81b3;
	__map_gbk2utf16[0x4886] = 0x5584;
	__map_gbk2utf16[0x4887] = 0x6c55;
	__map_gbk2utf16[0x4888] = 0x6247;
	__map_gbk2utf16[0x4889] = 0x7f2e;
	__map_gbk2utf16[0x488a] = 0x5892;
	__map_gbk2utf16[0x488b] = 0x4f24;
	__map_gbk2utf16[0x488c] = 0x5546;
	__map_gbk2utf16[0x488d] = 0x8d4f;
	__map_gbk2utf16[0x488e] = 0x664c;
	__map_gbk2utf16[0x488f] = 0x4e0a;
	__map_gbk2utf16[0x4890] = 0x5c1a;
	__map_gbk2utf16[0x4891] = 0x88f3;
	__map_gbk2utf16[0x4892] = 0x68a2;
	__map_gbk2utf16[0x4893] = 0x634e;
	__map_gbk2utf16[0x4894] = 0x7a0d;
	__map_gbk2utf16[0x4895] = 0x70e7;
	__map_gbk2utf16[0x4896] = 0x828d;
	__map_gbk2utf16[0x4897] = 0x52fa;
	__map_gbk2utf16[0x4898] = 0x97f6;
	__map_gbk2utf16[0x4899] = 0x5c11;
	__map_gbk2utf16[0x489a] = 0x54e8;
	__map_gbk2utf16[0x489b] = 0x90b5;
	__map_gbk2utf16[0x489c] = 0x7ecd;
	__map_gbk2utf16[0x489d] = 0x5962;
	__map_gbk2utf16[0x489e] = 0x8d4a;
	__map_gbk2utf16[0x489f] = 0x86c7;
	__map_gbk2utf16[0x48a0] = 0x820c;
	__map_gbk2utf16[0x48a1] = 0x820d;
	__map_gbk2utf16[0x48a2] = 0x8d66;
	__map_gbk2utf16[0x48a3] = 0x6444;
	__map_gbk2utf16[0x48a4] = 0x5c04;
	__map_gbk2utf16[0x48a5] = 0x6151;
	__map_gbk2utf16[0x48a6] = 0x6d89;
	__map_gbk2utf16[0x48a7] = 0x793e;
	__map_gbk2utf16[0x48a8] = 0x8bbe;
	__map_gbk2utf16[0x48a9] = 0x7837;
	__map_gbk2utf16[0x48aa] = 0x7533;
	__map_gbk2utf16[0x48ab] = 0x547b;
	__map_gbk2utf16[0x48ac] = 0x4f38;
	__map_gbk2utf16[0x48ad] = 0x8eab;
	__map_gbk2utf16[0x48ae] = 0x6df1;
	__map_gbk2utf16[0x48af] = 0x5a20;
	__map_gbk2utf16[0x48b0] = 0x7ec5;
	__map_gbk2utf16[0x48b1] = 0x795e;
	__map_gbk2utf16[0x48b2] = 0x6c88;
	__map_gbk2utf16[0x48b3] = 0x5ba1;
	__map_gbk2utf16[0x48b4] = 0x5a76;
	__map_gbk2utf16[0x48b5] = 0x751a;
	__map_gbk2utf16[0x48b6] = 0x80be;
	__map_gbk2utf16[0x48b7] = 0x614e;
	__map_gbk2utf16[0x48b8] = 0x6e17;
	__map_gbk2utf16[0x48b9] = 0x58f0;
	__map_gbk2utf16[0x48ba] = 0x751f;
	__map_gbk2utf16[0x48bb] = 0x7525;
	__map_gbk2utf16[0x48bc] = 0x7272;
	__map_gbk2utf16[0x48bd] = 0x5347;
	__map_gbk2utf16[0x48be] = 0x7ef3;
	__map_gbk2utf16[0x4900] = 0x8503;
	__map_gbk2utf16[0x4901] = 0x8504;
	__map_gbk2utf16[0x4902] = 0x8505;
	__map_gbk2utf16[0x4903] = 0x8506;
	__map_gbk2utf16[0x4904] = 0x8507;
	__map_gbk2utf16[0x4905] = 0x8508;
	__map_gbk2utf16[0x4906] = 0x8509;
	__map_gbk2utf16[0x4907] = 0x850a;
	__map_gbk2utf16[0x4908] = 0x850b;
	__map_gbk2utf16[0x4909] = 0x850d;
	__map_gbk2utf16[0x490a] = 0x850e;
	__map_gbk2utf16[0x490b] = 0x850f;
	__map_gbk2utf16[0x490c] = 0x8510;
	__map_gbk2utf16[0x490d] = 0x8512;
	__map_gbk2utf16[0x490e] = 0x8514;
	__map_gbk2utf16[0x490f] = 0x8515;
	__map_gbk2utf16[0x4910] = 0x8516;
	__map_gbk2utf16[0x4911] = 0x8518;
	__map_gbk2utf16[0x4912] = 0x8519;
	__map_gbk2utf16[0x4913] = 0x851b;
	__map_gbk2utf16[0x4914] = 0x851c;
	__map_gbk2utf16[0x4915] = 0x851d;
	__map_gbk2utf16[0x4916] = 0x851e;
	__map_gbk2utf16[0x4917] = 0x8520;
	__map_gbk2utf16[0x4918] = 0x8522;
	__map_gbk2utf16[0x4919] = 0x8523;
	__map_gbk2utf16[0x491a] = 0x8524;
	__map_gbk2utf16[0x491b] = 0x8525;
	__map_gbk2utf16[0x491c] = 0x8526;
	__map_gbk2utf16[0x491d] = 0x8527;
	__map_gbk2utf16[0x491e] = 0x8528;
	__map_gbk2utf16[0x491f] = 0x8529;
	__map_gbk2utf16[0x4920] = 0x852a;
	__map_gbk2utf16[0x4921] = 0x852d;
	__map_gbk2utf16[0x4922] = 0x852e;
	__map_gbk2utf16[0x4923] = 0x852f;
	__map_gbk2utf16[0x4924] = 0x8530;
	__map_gbk2utf16[0x4925] = 0x8531;
	__map_gbk2utf16[0x4926] = 0x8532;
	__map_gbk2utf16[0x4927] = 0x8533;
	__map_gbk2utf16[0x4928] = 0x8534;
	__map_gbk2utf16[0x4929] = 0x8535;
	__map_gbk2utf16[0x492a] = 0x8536;
	__map_gbk2utf16[0x492b] = 0x853e;
	__map_gbk2utf16[0x492c] = 0x853f;
	__map_gbk2utf16[0x492d] = 0x8540;
	__map_gbk2utf16[0x492e] = 0x8541;
	__map_gbk2utf16[0x492f] = 0x8542;
	__map_gbk2utf16[0x4930] = 0x8544;
	__map_gbk2utf16[0x4931] = 0x8545;
	__map_gbk2utf16[0x4932] = 0x8546;
	__map_gbk2utf16[0x4933] = 0x8547;
	__map_gbk2utf16[0x4934] = 0x854b;
	__map_gbk2utf16[0x4935] = 0x854c;
	__map_gbk2utf16[0x4936] = 0x854d;
	__map_gbk2utf16[0x4937] = 0x854e;
	__map_gbk2utf16[0x4938] = 0x854f;
	__map_gbk2utf16[0x4939] = 0x8550;
	__map_gbk2utf16[0x493a] = 0x8551;
	__map_gbk2utf16[0x493b] = 0x8552;
	__map_gbk2utf16[0x493c] = 0x8553;
	__map_gbk2utf16[0x493d] = 0x8554;
	__map_gbk2utf16[0x493e] = 0x8555;
	__map_gbk2utf16[0x4940] = 0x8557;
	__map_gbk2utf16[0x4941] = 0x8558;
	__map_gbk2utf16[0x4942] = 0x855a;
	__map_gbk2utf16[0x4943] = 0x855b;
	__map_gbk2utf16[0x4944] = 0x855c;
	__map_gbk2utf16[0x4945] = 0x855d;
	__map_gbk2utf16[0x4946] = 0x855f;
	__map_gbk2utf16[0x4947] = 0x8560;
	__map_gbk2utf16[0x4948] = 0x8561;
	__map_gbk2utf16[0x4949] = 0x8562;
	__map_gbk2utf16[0x494a] = 0x8563;
	__map_gbk2utf16[0x494b] = 0x8565;
	__map_gbk2utf16[0x494c] = 0x8566;
	__map_gbk2utf16[0x494d] = 0x8567;
	__map_gbk2utf16[0x494e] = 0x8569;
	__map_gbk2utf16[0x494f] = 0x856a;
	__map_gbk2utf16[0x4950] = 0x856b;
	__map_gbk2utf16[0x4951] = 0x856c;
	__map_gbk2utf16[0x4952] = 0x856d;
	__map_gbk2utf16[0x4953] = 0x856e;
	__map_gbk2utf16[0x4954] = 0x856f;
	__map_gbk2utf16[0x4955] = 0x8570;
	__map_gbk2utf16[0x4956] = 0x8571;
	__map_gbk2utf16[0x4957] = 0x8573;
	__map_gbk2utf16[0x4958] = 0x8575;
	__map_gbk2utf16[0x4959] = 0x8576;
	__map_gbk2utf16[0x495a] = 0x8577;
	__map_gbk2utf16[0x495b] = 0x8578;
	__map_gbk2utf16[0x495c] = 0x857c;
	__map_gbk2utf16[0x495d] = 0x857d;
	__map_gbk2utf16[0x495e] = 0x857f;
	__map_gbk2utf16[0x495f] = 0x8580;
	__map_gbk2utf16[0x4960] = 0x8581;
	__map_gbk2utf16[0x4961] = 0x7701;
	__map_gbk2utf16[0x4962] = 0x76db;
	__map_gbk2utf16[0x4963] = 0x5269;
	__map_gbk2utf16[0x4964] = 0x80dc;
	__map_gbk2utf16[0x4965] = 0x5723;
	__map_gbk2utf16[0x4966] = 0x5e08;
	__map_gbk2utf16[0x4967] = 0x5931;
	__map_gbk2utf16[0x4968] = 0x72ee;
	__map_gbk2utf16[0x4969] = 0x65bd;
	__map_gbk2utf16[0x496a] = 0x6e7f;
	__map_gbk2utf16[0x496b] = 0x8bd7;
	__map_gbk2utf16[0x496c] = 0x5c38;
	__map_gbk2utf16[0x496d] = 0x8671;
	__map_gbk2utf16[0x496e] = 0x5341;
	__map_gbk2utf16[0x496f] = 0x77f3;
	__map_gbk2utf16[0x4970] = 0x62fe;
	__map_gbk2utf16[0x4971] = 0x65f6;
	__map_gbk2utf16[0x4972] = 0x4ec0;
	__map_gbk2utf16[0x4973] = 0x98df;
	__map_gbk2utf16[0x4974] = 0x8680;
	__map_gbk2utf16[0x4975] = 0x5b9e;
	__map_gbk2utf16[0x4976] = 0x8bc6;
	__map_gbk2utf16[0x4977] = 0x53f2;
	__map_gbk2utf16[0x4978] = 0x77e2;
	__map_gbk2utf16[0x4979] = 0x4f7f;
	__map_gbk2utf16[0x497a] = 0x5c4e;
	__map_gbk2utf16[0x497b] = 0x9a76;
	__map_gbk2utf16[0x497c] = 0x59cb;
	__map_gbk2utf16[0x497d] = 0x5f0f;
	__map_gbk2utf16[0x497e] = 0x793a;
	__map_gbk2utf16[0x497f] = 0x58eb;
	__map_gbk2utf16[0x4980] = 0x4e16;
	__map_gbk2utf16[0x4981] = 0x67ff;
	__map_gbk2utf16[0x4982] = 0x4e8b;
	__map_gbk2utf16[0x4983] = 0x62ed;
	__map_gbk2utf16[0x4984] = 0x8a93;
	__map_gbk2utf16[0x4985] = 0x901d;
	__map_gbk2utf16[0x4986] = 0x52bf;
	__map_gbk2utf16[0x4987] = 0x662f;
	__map_gbk2utf16[0x4988] = 0x55dc;
	__map_gbk2utf16[0x4989] = 0x566c;
	__map_gbk2utf16[0x498a] = 0x9002;
	__map_gbk2utf16[0x498b] = 0x4ed5;
	__map_gbk2utf16[0x498c] = 0x4f8d;
	__map_gbk2utf16[0x498d] = 0x91ca;
	__map_gbk2utf16[0x498e] = 0x9970;
	__map_gbk2utf16[0x498f] = 0x6c0f;
	__map_gbk2utf16[0x4990] = 0x5e02;
	__map_gbk2utf16[0x4991] = 0x6043;
	__map_gbk2utf16[0x4992] = 0x5ba4;
	__map_gbk2utf16[0x4993] = 0x89c6;
	__map_gbk2utf16[0x4994] = 0x8bd5;
	__map_gbk2utf16[0x4995] = 0x6536;
	__map_gbk2utf16[0x4996] = 0x624b;
	__map_gbk2utf16[0x4997] = 0x9996;
	__map_gbk2utf16[0x4998] = 0x5b88;
	__map_gbk2utf16[0x4999] = 0x5bff;
	__map_gbk2utf16[0x499a] = 0x6388;
	__map_gbk2utf16[0x499b] = 0x552e;
	__map_gbk2utf16[0x499c] = 0x53d7;
	__map_gbk2utf16[0x499d] = 0x7626;
	__map_gbk2utf16[0x499e] = 0x517d;
	__map_gbk2utf16[0x499f] = 0x852c;
	__map_gbk2utf16[0x49a0] = 0x67a2;
	__map_gbk2utf16[0x49a1] = 0x68b3;
	__map_gbk2utf16[0x49a2] = 0x6b8a;
	__map_gbk2utf16[0x49a3] = 0x6292;
	__map_gbk2utf16[0x49a4] = 0x8f93;
	__map_gbk2utf16[0x49a5] = 0x53d4;
	__map_gbk2utf16[0x49a6] = 0x8212;
	__map_gbk2utf16[0x49a7] = 0x6dd1;
	__map_gbk2utf16[0x49a8] = 0x758f;
	__map_gbk2utf16[0x49a9] = 0x4e66;
	__map_gbk2utf16[0x49aa] = 0x8d4e;
	__map_gbk2utf16[0x49ab] = 0x5b70;
	__map_gbk2utf16[0x49ac] = 0x719f;
	__map_gbk2utf16[0x49ad] = 0x85af;
	__map_gbk2utf16[0x49ae] = 0x6691;
	__map_gbk2utf16[0x49af] = 0x66d9;
	__map_gbk2utf16[0x49b0] = 0x7f72;
	__map_gbk2utf16[0x49b1] = 0x8700;
	__map_gbk2utf16[0x49b2] = 0x9ecd;
	__map_gbk2utf16[0x49b3] = 0x9f20;
	__map_gbk2utf16[0x49b4] = 0x5c5e;
	__map_gbk2utf16[0x49b5] = 0x672f;
	__map_gbk2utf16[0x49b6] = 0x8ff0;
	__map_gbk2utf16[0x49b7] = 0x6811;
	__map_gbk2utf16[0x49b8] = 0x675f;
	__map_gbk2utf16[0x49b9] = 0x620d;
	__map_gbk2utf16[0x49ba] = 0x7ad6;
	__map_gbk2utf16[0x49bb] = 0x5885;
	__map_gbk2utf16[0x49bc] = 0x5eb6;
	__map_gbk2utf16[0x49bd] = 0x6570;
	__map_gbk2utf16[0x49be] = 0x6f31;
	__map_gbk2utf16[0x4a00] = 0x8582;
	__map_gbk2utf16[0x4a01] = 0x8583;
	__map_gbk2utf16[0x4a02] = 0x8586;
	__map_gbk2utf16[0x4a03] = 0x8588;
	__map_gbk2utf16[0x4a04] = 0x8589;
	__map_gbk2utf16[0x4a05] = 0x858a;
	__map_gbk2utf16[0x4a06] = 0x858b;
	__map_gbk2utf16[0x4a07] = 0x858c;
	__map_gbk2utf16[0x4a08] = 0x858d;
	__map_gbk2utf16[0x4a09] = 0x858e;
	__map_gbk2utf16[0x4a0a] = 0x8590;
	__map_gbk2utf16[0x4a0b] = 0x8591;
	__map_gbk2utf16[0x4a0c] = 0x8592;
	__map_gbk2utf16[0x4a0d] = 0x8593;
	__map_gbk2utf16[0x4a0e] = 0x8594;
	__map_gbk2utf16[0x4a0f] = 0x8595;
	__map_gbk2utf16[0x4a10] = 0x8596;
	__map_gbk2utf16[0x4a11] = 0x8597;
	__map_gbk2utf16[0x4a12] = 0x8598;
	__map_gbk2utf16[0x4a13] = 0x8599;
	__map_gbk2utf16[0x4a14] = 0x859a;
	__map_gbk2utf16[0x4a15] = 0x859d;
	__map_gbk2utf16[0x4a16] = 0x859e;
	__map_gbk2utf16[0x4a17] = 0x859f;
	__map_gbk2utf16[0x4a18] = 0x85a0;
	__map_gbk2utf16[0x4a19] = 0x85a1;
	__map_gbk2utf16[0x4a1a] = 0x85a2;
	__map_gbk2utf16[0x4a1b] = 0x85a3;
	__map_gbk2utf16[0x4a1c] = 0x85a5;
	__map_gbk2utf16[0x4a1d] = 0x85a6;
	__map_gbk2utf16[0x4a1e] = 0x85a7;
	__map_gbk2utf16[0x4a1f] = 0x85a9;
	__map_gbk2utf16[0x4a20] = 0x85ab;
	__map_gbk2utf16[0x4a21] = 0x85ac;
	__map_gbk2utf16[0x4a22] = 0x85ad;
	__map_gbk2utf16[0x4a23] = 0x85b1;
	__map_gbk2utf16[0x4a24] = 0x85b2;
	__map_gbk2utf16[0x4a25] = 0x85b3;
	__map_gbk2utf16[0x4a26] = 0x85b4;
	__map_gbk2utf16[0x4a27] = 0x85b5;
	__map_gbk2utf16[0x4a28] = 0x85b6;
	__map_gbk2utf16[0x4a29] = 0x85b8;
	__map_gbk2utf16[0x4a2a] = 0x85ba;
	__map_gbk2utf16[0x4a2b] = 0x85bb;
	__map_gbk2utf16[0x4a2c] = 0x85bc;
	__map_gbk2utf16[0x4a2d] = 0x85bd;
	__map_gbk2utf16[0x4a2e] = 0x85be;
	__map_gbk2utf16[0x4a2f] = 0x85bf;
	__map_gbk2utf16[0x4a30] = 0x85c0;
	__map_gbk2utf16[0x4a31] = 0x85c2;
	__map_gbk2utf16[0x4a32] = 0x85c3;
	__map_gbk2utf16[0x4a33] = 0x85c4;
	__map_gbk2utf16[0x4a34] = 0x85c5;
	__map_gbk2utf16[0x4a35] = 0x85c6;
	__map_gbk2utf16[0x4a36] = 0x85c7;
	__map_gbk2utf16[0x4a37] = 0x85c8;
	__map_gbk2utf16[0x4a38] = 0x85ca;
	__map_gbk2utf16[0x4a39] = 0x85cb;
	__map_gbk2utf16[0x4a3a] = 0x85cc;
	__map_gbk2utf16[0x4a3b] = 0x85cd;
	__map_gbk2utf16[0x4a3c] = 0x85ce;
	__map_gbk2utf16[0x4a3d] = 0x85d1;
	__map_gbk2utf16[0x4a3e] = 0x85d2;
	__map_gbk2utf16[0x4a40] = 0x85d4;
	__map_gbk2utf16[0x4a41] = 0x85d6;
	__map_gbk2utf16[0x4a42] = 0x85d7;
	__map_gbk2utf16[0x4a43] = 0x85d8;
	__map_gbk2utf16[0x4a44] = 0x85d9;
	__map_gbk2utf16[0x4a45] = 0x85da;
	__map_gbk2utf16[0x4a46] = 0x85db;
	__map_gbk2utf16[0x4a47] = 0x85dd;
	__map_gbk2utf16[0x4a48] = 0x85de;
	__map_gbk2utf16[0x4a49] = 0x85df;
	__map_gbk2utf16[0x4a4a] = 0x85e0;
	__map_gbk2utf16[0x4a4b] = 0x85e1;
	__map_gbk2utf16[0x4a4c] = 0x85e2;
	__map_gbk2utf16[0x4a4d] = 0x85e3;
	__map_gbk2utf16[0x4a4e] = 0x85e5;
	__map_gbk2utf16[0x4a4f] = 0x85e6;
	__map_gbk2utf16[0x4a50] = 0x85e7;
	__map_gbk2utf16[0x4a51] = 0x85e8;
	__map_gbk2utf16[0x4a52] = 0x85ea;
	__map_gbk2utf16[0x4a53] = 0x85eb;
	__map_gbk2utf16[0x4a54] = 0x85ec;
	__map_gbk2utf16[0x4a55] = 0x85ed;
	__map_gbk2utf16[0x4a56] = 0x85ee;
	__map_gbk2utf16[0x4a57] = 0x85ef;
	__map_gbk2utf16[0x4a58] = 0x85f0;
	__map_gbk2utf16[0x4a59] = 0x85f1;
	__map_gbk2utf16[0x4a5a] = 0x85f2;
	__map_gbk2utf16[0x4a5b] = 0x85f3;
	__map_gbk2utf16[0x4a5c] = 0x85f4;
	__map_gbk2utf16[0x4a5d] = 0x85f5;
	__map_gbk2utf16[0x4a5e] = 0x85f6;
	__map_gbk2utf16[0x4a5f] = 0x85f7;
	__map_gbk2utf16[0x4a60] = 0x85f8;
	__map_gbk2utf16[0x4a61] = 0x6055;
	__map_gbk2utf16[0x4a62] = 0x5237;
	__map_gbk2utf16[0x4a63] = 0x800d;
	__map_gbk2utf16[0x4a64] = 0x6454;
	__map_gbk2utf16[0x4a65] = 0x8870;
	__map_gbk2utf16[0x4a66] = 0x7529;
	__map_gbk2utf16[0x4a67] = 0x5e05;
	__map_gbk2utf16[0x4a68] = 0x6813;
	__map_gbk2utf16[0x4a69] = 0x62f4;
	__map_gbk2utf16[0x4a6a] = 0x971c;
	__map_gbk2utf16[0x4a6b] = 0x53cc;
	__map_gbk2utf16[0x4a6c] = 0x723d;
	__map_gbk2utf16[0x4a6d] = 0x8c01;
	__map_gbk2utf16[0x4a6e] = 0x6c34;
	__map_gbk2utf16[0x4a6f] = 0x7761;
	__map_gbk2utf16[0x4a70] = 0x7a0e;
	__map_gbk2utf16[0x4a71] = 0x542e;
	__map_gbk2utf16[0x4a72] = 0x77ac;
	__map_gbk2utf16[0x4a73] = 0x987a;
	__map_gbk2utf16[0x4a74] = 0x821c;
	__map_gbk2utf16[0x4a75] = 0x8bf4;
	__map_gbk2utf16[0x4a76] = 0x7855;
	__map_gbk2utf16[0x4a77] = 0x6714;
	__map_gbk2utf16[0x4a78] = 0x70c1;
	__map_gbk2utf16[0x4a79] = 0x65af;
	__map_gbk2utf16[0x4a7a] = 0x6495;
	__map_gbk2utf16[0x4a7b] = 0x5636;
	__map_gbk2utf16[0x4a7c] = 0x601d;
	__map_gbk2utf16[0x4a7d] = 0x79c1;
	__map_gbk2utf16[0x4a7e] = 0x53f8;
	__map_gbk2utf16[0x4a7f] = 0x4e1d;
	__map_gbk2utf16[0x4a80] = 0x6b7b;
	__map_gbk2utf16[0x4a81] = 0x8086;
	__map_gbk2utf16[0x4a82] = 0x5bfa;
	__map_gbk2utf16[0x4a83] = 0x55e3;
	__map_gbk2utf16[0x4a84] = 0x56db;
	__map_gbk2utf16[0x4a85] = 0x4f3a;
	__map_gbk2utf16[0x4a86] = 0x4f3c;
	__map_gbk2utf16[0x4a87] = 0x9972;
	__map_gbk2utf16[0x4a88] = 0x5df3;
	__map_gbk2utf16[0x4a89] = 0x677e;
	__map_gbk2utf16[0x4a8a] = 0x8038;
	__map_gbk2utf16[0x4a8b] = 0x6002;
	__map_gbk2utf16[0x4a8c] = 0x9882;
	__map_gbk2utf16[0x4a8d] = 0x9001;
	__map_gbk2utf16[0x4a8e] = 0x5b8b;
	__map_gbk2utf16[0x4a8f] = 0x8bbc;
	__map_gbk2utf16[0x4a90] = 0x8bf5;
	__map_gbk2utf16[0x4a91] = 0x641c;
	__map_gbk2utf16[0x4a92] = 0x8258;
	__map_gbk2utf16[0x4a93] = 0x64de;
	__map_gbk2utf16[0x4a94] = 0x55fd;
	__map_gbk2utf16[0x4a95] = 0x82cf;
	__map_gbk2utf16[0x4a96] = 0x9165;
	__map_gbk2utf16[0x4a97] = 0x4fd7;
	__map_gbk2utf16[0x4a98] = 0x7d20;
	__map_gbk2utf16[0x4a99] = 0x901f;
	__map_gbk2utf16[0x4a9a] = 0x7c9f;
	__map_gbk2utf16[0x4a9b] = 0x50f3;
	__map_gbk2utf16[0x4a9c] = 0x5851;
	__map_gbk2utf16[0x4a9d] = 0x6eaf;
	__map_gbk2utf16[0x4a9e] = 0x5bbf;
	__map_gbk2utf16[0x4a9f] = 0x8bc9;
	__map_gbk2utf16[0x4aa0] = 0x8083;
	__map_gbk2utf16[0x4aa1] = 0x9178;
	__map_gbk2utf16[0x4aa2] = 0x849c;
	__map_gbk2utf16[0x4aa3] = 0x7b97;
	__map_gbk2utf16[0x4aa4] = 0x867d;
	__map_gbk2utf16[0x4aa5] = 0x968b;
	__map_gbk2utf16[0x4aa6] = 0x968f;
	__map_gbk2utf16[0x4aa7] = 0x7ee5;
	__map_gbk2utf16[0x4aa8] = 0x9ad3;
	__map_gbk2utf16[0x4aa9] = 0x788e;
	__map_gbk2utf16[0x4aaa] = 0x5c81;
	__map_gbk2utf16[0x4aab] = 0x7a57;
	__map_gbk2utf16[0x4aac] = 0x9042;
	__map_gbk2utf16[0x4aad] = 0x96a7;
	__map_gbk2utf16[0x4aae] = 0x795f;
	__map_gbk2utf16[0x4aaf] = 0x5b59;
	__map_gbk2utf16[0x4ab0] = 0x635f;
	__map_gbk2utf16[0x4ab1] = 0x7b0b;
	__map_gbk2utf16[0x4ab2] = 0x84d1;
	__map_gbk2utf16[0x4ab3] = 0x68ad;
	__map_gbk2utf16[0x4ab4] = 0x5506;
	__map_gbk2utf16[0x4ab5] = 0x7f29;
	__map_gbk2utf16[0x4ab6] = 0x7410;
	__map_gbk2utf16[0x4ab7] = 0x7d22;
	__map_gbk2utf16[0x4ab8] = 0x9501;
	__map_gbk2utf16[0x4ab9] = 0x6240;
	__map_gbk2utf16[0x4aba] = 0x584c;
	__map_gbk2utf16[0x4abb] = 0x4ed6;
	__map_gbk2utf16[0x4abc] = 0x5b83;
	__map_gbk2utf16[0x4abd] = 0x5979;
	__map_gbk2utf16[0x4abe] = 0x5854;
	__map_gbk2utf16[0x4b00] = 0x85f9;
	__map_gbk2utf16[0x4b01] = 0x85fa;
	__map_gbk2utf16[0x4b02] = 0x85fc;
	__map_gbk2utf16[0x4b03] = 0x85fd;
	__map_gbk2utf16[0x4b04] = 0x85fe;
	__map_gbk2utf16[0x4b05] = 0x8600;
	__map_gbk2utf16[0x4b06] = 0x8601;
	__map_gbk2utf16[0x4b07] = 0x8602;
	__map_gbk2utf16[0x4b08] = 0x8603;
	__map_gbk2utf16[0x4b09] = 0x8604;
	__map_gbk2utf16[0x4b0a] = 0x8606;
	__map_gbk2utf16[0x4b0b] = 0x8607;
	__map_gbk2utf16[0x4b0c] = 0x8608;
	__map_gbk2utf16[0x4b0d] = 0x8609;
	__map_gbk2utf16[0x4b0e] = 0x860a;
	__map_gbk2utf16[0x4b0f] = 0x860b;
	__map_gbk2utf16[0x4b10] = 0x860c;
	__map_gbk2utf16[0x4b11] = 0x860d;
	__map_gbk2utf16[0x4b12] = 0x860e;
	__map_gbk2utf16[0x4b13] = 0x860f;
	__map_gbk2utf16[0x4b14] = 0x8610;
	__map_gbk2utf16[0x4b15] = 0x8612;
	__map_gbk2utf16[0x4b16] = 0x8613;
	__map_gbk2utf16[0x4b17] = 0x8614;
	__map_gbk2utf16[0x4b18] = 0x8615;
	__map_gbk2utf16[0x4b19] = 0x8617;
	__map_gbk2utf16[0x4b1a] = 0x8618;
	__map_gbk2utf16[0x4b1b] = 0x8619;
	__map_gbk2utf16[0x4b1c] = 0x861a;
	__map_gbk2utf16[0x4b1d] = 0x861b;
	__map_gbk2utf16[0x4b1e] = 0x861c;
	__map_gbk2utf16[0x4b1f] = 0x861d;
	__map_gbk2utf16[0x4b20] = 0x861e;
	__map_gbk2utf16[0x4b21] = 0x861f;
	__map_gbk2utf16[0x4b22] = 0x8620;
	__map_gbk2utf16[0x4b23] = 0x8621;
	__map_gbk2utf16[0x4b24] = 0x8622;
	__map_gbk2utf16[0x4b25] = 0x8623;
	__map_gbk2utf16[0x4b26] = 0x8624;
	__map_gbk2utf16[0x4b27] = 0x8625;
	__map_gbk2utf16[0x4b28] = 0x8626;
	__map_gbk2utf16[0x4b29] = 0x8628;
	__map_gbk2utf16[0x4b2a] = 0x862a;
	__map_gbk2utf16[0x4b2b] = 0x862b;
	__map_gbk2utf16[0x4b2c] = 0x862c;
	__map_gbk2utf16[0x4b2d] = 0x862d;
	__map_gbk2utf16[0x4b2e] = 0x862e;
	__map_gbk2utf16[0x4b2f] = 0x862f;
	__map_gbk2utf16[0x4b30] = 0x8630;
	__map_gbk2utf16[0x4b31] = 0x8631;
	__map_gbk2utf16[0x4b32] = 0x8632;
	__map_gbk2utf16[0x4b33] = 0x8633;
	__map_gbk2utf16[0x4b34] = 0x8634;
	__map_gbk2utf16[0x4b35] = 0x8635;
	__map_gbk2utf16[0x4b36] = 0x8636;
	__map_gbk2utf16[0x4b37] = 0x8637;
	__map_gbk2utf16[0x4b38] = 0x8639;
	__map_gbk2utf16[0x4b39] = 0x863a;
	__map_gbk2utf16[0x4b3a] = 0x863b;
	__map_gbk2utf16[0x4b3b] = 0x863d;
	__map_gbk2utf16[0x4b3c] = 0x863e;
	__map_gbk2utf16[0x4b3d] = 0x863f;
	__map_gbk2utf16[0x4b3e] = 0x8640;
	__map_gbk2utf16[0x4b40] = 0x8641;
	__map_gbk2utf16[0x4b41] = 0x8642;
	__map_gbk2utf16[0x4b42] = 0x8643;
	__map_gbk2utf16[0x4b43] = 0x8644;
	__map_gbk2utf16[0x4b44] = 0x8645;
	__map_gbk2utf16[0x4b45] = 0x8646;
	__map_gbk2utf16[0x4b46] = 0x8647;
	__map_gbk2utf16[0x4b47] = 0x8648;
	__map_gbk2utf16[0x4b48] = 0x8649;
	__map_gbk2utf16[0x4b49] = 0x864a;
	__map_gbk2utf16[0x4b4a] = 0x864b;
	__map_gbk2utf16[0x4b4b] = 0x864c;
	__map_gbk2utf16[0x4b4c] = 0x8652;
	__map_gbk2utf16[0x4b4d] = 0x8653;
	__map_gbk2utf16[0x4b4e] = 0x8655;
	__map_gbk2utf16[0x4b4f] = 0x8656;
	__map_gbk2utf16[0x4b50] = 0x8657;
	__map_gbk2utf16[0x4b51] = 0x8658;
	__map_gbk2utf16[0x4b52] = 0x8659;
	__map_gbk2utf16[0x4b53] = 0x865b;
	__map_gbk2utf16[0x4b54] = 0x865c;
	__map_gbk2utf16[0x4b55] = 0x865d;
	__map_gbk2utf16[0x4b56] = 0x865f;
	__map_gbk2utf16[0x4b57] = 0x8660;
	__map_gbk2utf16[0x4b58] = 0x8661;
	__map_gbk2utf16[0x4b59] = 0x8663;
	__map_gbk2utf16[0x4b5a] = 0x8664;
	__map_gbk2utf16[0x4b5b] = 0x8665;
	__map_gbk2utf16[0x4b5c] = 0x8666;
	__map_gbk2utf16[0x4b5d] = 0x8667;
	__map_gbk2utf16[0x4b5e] = 0x8668;
	__map_gbk2utf16[0x4b5f] = 0x8669;
	__map_gbk2utf16[0x4b60] = 0x866a;
	__map_gbk2utf16[0x4b61] = 0x736d;
	__map_gbk2utf16[0x4b62] = 0x631e;
	__map_gbk2utf16[0x4b63] = 0x8e4b;
	__map_gbk2utf16[0x4b64] = 0x8e0f;
	__map_gbk2utf16[0x4b65] = 0x80ce;
	__map_gbk2utf16[0x4b66] = 0x82d4;
	__map_gbk2utf16[0x4b67] = 0x62ac;
	__map_gbk2utf16[0x4b68] = 0x53f0;
	__map_gbk2utf16[0x4b69] = 0x6cf0;
	__map_gbk2utf16[0x4b6a] = 0x915e;
	__map_gbk2utf16[0x4b6b] = 0x592a;
	__map_gbk2utf16[0x4b6c] = 0x6001;
	__map_gbk2utf16[0x4b6d] = 0x6c70;
	__map_gbk2utf16[0x4b6e] = 0x574d;
	__map_gbk2utf16[0x4b6f] = 0x644a;
	__map_gbk2utf16[0x4b70] = 0x8d2a;
	__map_gbk2utf16[0x4b71] = 0x762b;
	__map_gbk2utf16[0x4b72] = 0x6ee9;
	__map_gbk2utf16[0x4b73] = 0x575b;
	__map_gbk2utf16[0x4b74] = 0x6a80;
	__map_gbk2utf16[0x4b75] = 0x75f0;
	__map_gbk2utf16[0x4b76] = 0x6f6d;
	__map_gbk2utf16[0x4b77] = 0x8c2d;
	__map_gbk2utf16[0x4b78] = 0x8c08;
	__map_gbk2utf16[0x4b79] = 0x5766;
	__map_gbk2utf16[0x4b7a] = 0x6bef;
	__map_gbk2utf16[0x4b7b] = 0x8892;
	__map_gbk2utf16[0x4b7c] = 0x78b3;
	__map_gbk2utf16[0x4b7d] = 0x63a2;
	__map_gbk2utf16[0x4b7e] = 0x53f9;
	__map_gbk2utf16[0x4b7f] = 0x70ad;
	__map_gbk2utf16[0x4b80] = 0x6c64;
	__map_gbk2utf16[0x4b81] = 0x5858;
	__map_gbk2utf16[0x4b82] = 0x642a;
	__map_gbk2utf16[0x4b83] = 0x5802;
	__map_gbk2utf16[0x4b84] = 0x68e0;
	__map_gbk2utf16[0x4b85] = 0x819b;
	__map_gbk2utf16[0x4b86] = 0x5510;
	__map_gbk2utf16[0x4b87] = 0x7cd6;
	__map_gbk2utf16[0x4b88] = 0x5018;
	__map_gbk2utf16[0x4b89] = 0x8eba;
	__map_gbk2utf16[0x4b8a] = 0x6dcc;
	__map_gbk2utf16[0x4b8b] = 0x8d9f;
	__map_gbk2utf16[0x4b8c] = 0x70eb;
	__map_gbk2utf16[0x4b8d] = 0x638f;
	__map_gbk2utf16[0x4b8e] = 0x6d9b;
	__map_gbk2utf16[0x4b8f] = 0x6ed4;
	__map_gbk2utf16[0x4b90] = 0x7ee6;
	__map_gbk2utf16[0x4b91] = 0x8404;
	__map_gbk2utf16[0x4b92] = 0x6843;
	__map_gbk2utf16[0x4b93] = 0x9003;
	__map_gbk2utf16[0x4b94] = 0x6dd8;
	__map_gbk2utf16[0x4b95] = 0x9676;
	__map_gbk2utf16[0x4b96] = 0x8ba8;
	__map_gbk2utf16[0x4b97] = 0x5957;
	__map_gbk2utf16[0x4b98] = 0x7279;
	__map_gbk2utf16[0x4b99] = 0x85e4;
	__map_gbk2utf16[0x4b9a] = 0x817e;
	__map_gbk2utf16[0x4b9b] = 0x75bc;
	__map_gbk2utf16[0x4b9c] = 0x8a8a;
	__map_gbk2utf16[0x4b9d] = 0x68af;
	__map_gbk2utf16[0x4b9e] = 0x5254;
	__map_gbk2utf16[0x4b9f] = 0x8e22;
	__map_gbk2utf16[0x4ba0] = 0x9511;
	__map_gbk2utf16[0x4ba1] = 0x63d0;
	__map_gbk2utf16[0x4ba2] = 0x9898;
	__map_gbk2utf16[0x4ba3] = 0x8e44;
	__map_gbk2utf16[0x4ba4] = 0x557c;
	__map_gbk2utf16[0x4ba5] = 0x4f53;
	__map_gbk2utf16[0x4ba6] = 0x66ff;
	__map_gbk2utf16[0x4ba7] = 0x568f;
	__map_gbk2utf16[0x4ba8] = 0x60d5;
	__map_gbk2utf16[0x4ba9] = 0x6d95;
	__map_gbk2utf16[0x4baa] = 0x5243;
	__map_gbk2utf16[0x4bab] = 0x5c49;
	__map_gbk2utf16[0x4bac] = 0x5929;
	__map_gbk2utf16[0x4bad] = 0x6dfb;
	__map_gbk2utf16[0x4bae] = 0x586b;
	__map_gbk2utf16[0x4baf] = 0x7530;
	__map_gbk2utf16[0x4bb0] = 0x751c;
	__map_gbk2utf16[0x4bb1] = 0x606c;
	__map_gbk2utf16[0x4bb2] = 0x8214;
	__map_gbk2utf16[0x4bb3] = 0x8146;
	__map_gbk2utf16[0x4bb4] = 0x6311;
	__map_gbk2utf16[0x4bb5] = 0x6761;
	__map_gbk2utf16[0x4bb6] = 0x8fe2;
	__map_gbk2utf16[0x4bb7] = 0x773a;
	__map_gbk2utf16[0x4bb8] = 0x8df3;
	__map_gbk2utf16[0x4bb9] = 0x8d34;
	__map_gbk2utf16[0x4bba] = 0x94c1;
	__map_gbk2utf16[0x4bbb] = 0x5e16;
	__map_gbk2utf16[0x4bbc] = 0x5385;
	__map_gbk2utf16[0x4bbd] = 0x542c;
	__map_gbk2utf16[0x4bbe] = 0x70c3;
	__map_gbk2utf16[0x4c00] = 0x866d;
	__map_gbk2utf16[0x4c01] = 0x866f;
	__map_gbk2utf16[0x4c02] = 0x8670;
	__map_gbk2utf16[0x4c03] = 0x8672;
	__map_gbk2utf16[0x4c04] = 0x8673;
	__map_gbk2utf16[0x4c05] = 0x8674;
	__map_gbk2utf16[0x4c06] = 0x8675;
	__map_gbk2utf16[0x4c07] = 0x8676;
	__map_gbk2utf16[0x4c08] = 0x8677;
	__map_gbk2utf16[0x4c09] = 0x8678;
	__map_gbk2utf16[0x4c0a] = 0x8683;
	__map_gbk2utf16[0x4c0b] = 0x8684;
	__map_gbk2utf16[0x4c0c] = 0x8685;
	__map_gbk2utf16[0x4c0d] = 0x8686;
	__map_gbk2utf16[0x4c0e] = 0x8687;
	__map_gbk2utf16[0x4c0f] = 0x8688;
	__map_gbk2utf16[0x4c10] = 0x8689;
	__map_gbk2utf16[0x4c11] = 0x868e;
	__map_gbk2utf16[0x4c12] = 0x868f;
	__map_gbk2utf16[0x4c13] = 0x8690;
	__map_gbk2utf16[0x4c14] = 0x8691;
	__map_gbk2utf16[0x4c15] = 0x8692;
	__map_gbk2utf16[0x4c16] = 0x8694;
	__map_gbk2utf16[0x4c17] = 0x8696;
	__map_gbk2utf16[0x4c18] = 0x8697;
	__map_gbk2utf16[0x4c19] = 0x8698;
	__map_gbk2utf16[0x4c1a] = 0x8699;
	__map_gbk2utf16[0x4c1b] = 0x869a;
	__map_gbk2utf16[0x4c1c] = 0x869b;
	__map_gbk2utf16[0x4c1d] = 0x869e;
	__map_gbk2utf16[0x4c1e] = 0x869f;
	__map_gbk2utf16[0x4c1f] = 0x86a0;
	__map_gbk2utf16[0x4c20] = 0x86a1;
	__map_gbk2utf16[0x4c21] = 0x86a2;
	__map_gbk2utf16[0x4c22] = 0x86a5;
	__map_gbk2utf16[0x4c23] = 0x86a6;
	__map_gbk2utf16[0x4c24] = 0x86ab;
	__map_gbk2utf16[0x4c25] = 0x86ad;
	__map_gbk2utf16[0x4c26] = 0x86ae;
	__map_gbk2utf16[0x4c27] = 0x86b2;
	__map_gbk2utf16[0x4c28] = 0x86b3;
	__map_gbk2utf16[0x4c29] = 0x86b7;
	__map_gbk2utf16[0x4c2a] = 0x86b8;
	__map_gbk2utf16[0x4c2b] = 0x86b9;
	__map_gbk2utf16[0x4c2c] = 0x86bb;
	__map_gbk2utf16[0x4c2d] = 0x86bc;
	__map_gbk2utf16[0x4c2e] = 0x86bd;
	__map_gbk2utf16[0x4c2f] = 0x86be;
	__map_gbk2utf16[0x4c30] = 0x86bf;
	__map_gbk2utf16[0x4c31] = 0x86c1;
	__map_gbk2utf16[0x4c32] = 0x86c2;
	__map_gbk2utf16[0x4c33] = 0x86c3;
	__map_gbk2utf16[0x4c34] = 0x86c5;
	__map_gbk2utf16[0x4c35] = 0x86c8;
	__map_gbk2utf16[0x4c36] = 0x86cc;
	__map_gbk2utf16[0x4c37] = 0x86cd;
	__map_gbk2utf16[0x4c38] = 0x86d2;
	__map_gbk2utf16[0x4c39] = 0x86d3;
	__map_gbk2utf16[0x4c3a] = 0x86d5;
	__map_gbk2utf16[0x4c3b] = 0x86d6;
	__map_gbk2utf16[0x4c3c] = 0x86d7;
	__map_gbk2utf16[0x4c3d] = 0x86da;
	__map_gbk2utf16[0x4c3e] = 0x86dc;
	__map_gbk2utf16[0x4c40] = 0x86dd;
	__map_gbk2utf16[0x4c41] = 0x86e0;
	__map_gbk2utf16[0x4c42] = 0x86e1;
	__map_gbk2utf16[0x4c43] = 0x86e2;
	__map_gbk2utf16[0x4c44] = 0x86e3;
	__map_gbk2utf16[0x4c45] = 0x86e5;
	__map_gbk2utf16[0x4c46] = 0x86e6;
	__map_gbk2utf16[0x4c47] = 0x86e7;
	__map_gbk2utf16[0x4c48] = 0x86e8;
	__map_gbk2utf16[0x4c49] = 0x86ea;
	__map_gbk2utf16[0x4c4a] = 0x86eb;
	__map_gbk2utf16[0x4c4b] = 0x86ec;
	__map_gbk2utf16[0x4c4c] = 0x86ef;
	__map_gbk2utf16[0x4c4d] = 0x86f5;
	__map_gbk2utf16[0x4c4e] = 0x86f6;
	__map_gbk2utf16[0x4c4f] = 0x86f7;
	__map_gbk2utf16[0x4c50] = 0x86fa;
	__map_gbk2utf16[0x4c51] = 0x86fb;
	__map_gbk2utf16[0x4c52] = 0x86fc;
	__map_gbk2utf16[0x4c53] = 0x86fd;
	__map_gbk2utf16[0x4c54] = 0x86ff;
	__map_gbk2utf16[0x4c55] = 0x8701;
	__map_gbk2utf16[0x4c56] = 0x8704;
	__map_gbk2utf16[0x4c57] = 0x8705;
	__map_gbk2utf16[0x4c58] = 0x8706;
	__map_gbk2utf16[0x4c59] = 0x870b;
	__map_gbk2utf16[0x4c5a] = 0x870c;
	__map_gbk2utf16[0x4c5b] = 0x870e;
	__map_gbk2utf16[0x4c5c] = 0x870f;
	__map_gbk2utf16[0x4c5d] = 0x8710;
	__map_gbk2utf16[0x4c5e] = 0x8711;
	__map_gbk2utf16[0x4c5f] = 0x8714;
	__map_gbk2utf16[0x4c60] = 0x8716;
	__map_gbk2utf16[0x4c61] = 0x6c40;
	__map_gbk2utf16[0x4c62] = 0x5ef7;
	__map_gbk2utf16[0x4c63] = 0x505c;
	__map_gbk2utf16[0x4c64] = 0x4ead;
	__map_gbk2utf16[0x4c65] = 0x5ead;
	__map_gbk2utf16[0x4c66] = 0x633a;
	__map_gbk2utf16[0x4c67] = 0x8247;
	__map_gbk2utf16[0x4c68] = 0x901a;
	__map_gbk2utf16[0x4c69] = 0x6850;
	__map_gbk2utf16[0x4c6a] = 0x916e;
	__map_gbk2utf16[0x4c6b] = 0x77b3;
	__map_gbk2utf16[0x4c6c] = 0x540c;
	__map_gbk2utf16[0x4c6d] = 0x94dc;
	__map_gbk2utf16[0x4c6e] = 0x5f64;
	__map_gbk2utf16[0x4c6f] = 0x7ae5;
	__map_gbk2utf16[0x4c70] = 0x6876;
	__map_gbk2utf16[0x4c71] = 0x6345;
	__map_gbk2utf16[0x4c72] = 0x7b52;
	__map_gbk2utf16[0x4c73] = 0x7edf;
	__map_gbk2utf16[0x4c74] = 0x75db;
	__map_gbk2utf16[0x4c75] = 0x5077;
	__map_gbk2utf16[0x4c76] = 0x6295;
	__map_gbk2utf16[0x4c77] = 0x5934;
	__map_gbk2utf16[0x4c78] = 0x900f;
	__map_gbk2utf16[0x4c79] = 0x51f8;
	__map_gbk2utf16[0x4c7a] = 0x79c3;
	__map_gbk2utf16[0x4c7b] = 0x7a81;
	__map_gbk2utf16[0x4c7c] = 0x56fe;
	__map_gbk2utf16[0x4c7d] = 0x5f92;
	__map_gbk2utf16[0x4c7e] = 0x9014;
	__map_gbk2utf16[0x4c7f] = 0x6d82;
	__map_gbk2utf16[0x4c80] = 0x5c60;
	__map_gbk2utf16[0x4c81] = 0x571f;
	__map_gbk2utf16[0x4c82] = 0x5410;
	__map_gbk2utf16[0x4c83] = 0x5154;
	__map_gbk2utf16[0x4c84] = 0x6e4d;
	__map_gbk2utf16[0x4c85] = 0x56e2;
	__map_gbk2utf16[0x4c86] = 0x63a8;
	__map_gbk2utf16[0x4c87] = 0x9893;
	__map_gbk2utf16[0x4c88] = 0x817f;
	__map_gbk2utf16[0x4c89] = 0x8715;
	__map_gbk2utf16[0x4c8a] = 0x892a;
	__map_gbk2utf16[0x4c8b] = 0x9000;
	__map_gbk2utf16[0x4c8c] = 0x541e;
	__map_gbk2utf16[0x4c8d] = 0x5c6f;
	__map_gbk2utf16[0x4c8e] = 0x81c0;
	__map_gbk2utf16[0x4c8f] = 0x62d6;
	__map_gbk2utf16[0x4c90] = 0x6258;
	__map_gbk2utf16[0x4c91] = 0x8131;
	__map_gbk2utf16[0x4c92] = 0x9e35;
	__map_gbk2utf16[0x4c93] = 0x9640;
	__map_gbk2utf16[0x4c94] = 0x9a6e;
	__map_gbk2utf16[0x4c95] = 0x9a7c;
	__map_gbk2utf16[0x4c96] = 0x692d;
	__map_gbk2utf16[0x4c97] = 0x59a5;
	__map_gbk2utf16[0x4c98] = 0x62d3;
	__map_gbk2utf16[0x4c99] = 0x553e;
	__map_gbk2utf16[0x4c9a] = 0x6316;
	__map_gbk2utf16[0x4c9b] = 0x54c7;
	__map_gbk2utf16[0x4c9c] = 0x86d9;
	__map_gbk2utf16[0x4c9d] = 0x6d3c;
	__map_gbk2utf16[0x4c9e] = 0x5a03;
	__map_gbk2utf16[0x4c9f] = 0x74e6;
	__map_gbk2utf16[0x4ca0] = 0x889c;
	__map_gbk2utf16[0x4ca1] = 0x6b6a;
	__map_gbk2utf16[0x4ca2] = 0x5916;
	__map_gbk2utf16[0x4ca3] = 0x8c4c;
	__map_gbk2utf16[0x4ca4] = 0x5f2f;
	__map_gbk2utf16[0x4ca5] = 0x6e7e;
	__map_gbk2utf16[0x4ca6] = 0x73a9;
	__map_gbk2utf16[0x4ca7] = 0x987d;
	__map_gbk2utf16[0x4ca8] = 0x4e38;
	__map_gbk2utf16[0x4ca9] = 0x70f7;
	__map_gbk2utf16[0x4caa] = 0x5b8c;
	__map_gbk2utf16[0x4cab] = 0x7897;
	__map_gbk2utf16[0x4cac] = 0x633d;
	__map_gbk2utf16[0x4cad] = 0x665a;
	__map_gbk2utf16[0x4cae] = 0x7696;
	__map_gbk2utf16[0x4caf] = 0x60cb;
	__map_gbk2utf16[0x4cb0] = 0x5b9b;
	__map_gbk2utf16[0x4cb1] = 0x5a49;
	__map_gbk2utf16[0x4cb2] = 0x4e07;
	__map_gbk2utf16[0x4cb3] = 0x8155;
	__map_gbk2utf16[0x4cb4] = 0x6c6a;
	__map_gbk2utf16[0x4cb5] = 0x738b;
	__map_gbk2utf16[0x4cb6] = 0x4ea1;
	__map_gbk2utf16[0x4cb7] = 0x6789;
	__map_gbk2utf16[0x4cb8] = 0x7f51;
	__map_gbk2utf16[0x4cb9] = 0x5f80;
	__map_gbk2utf16[0x4cba] = 0x65fa;
	__map_gbk2utf16[0x4cbb] = 0x671b;
	__map_gbk2utf16[0x4cbc] = 0x5fd8;
	__map_gbk2utf16[0x4cbd] = 0x5984;
	__map_gbk2utf16[0x4cbe] = 0x5a01;
	__map_gbk2utf16[0x4d00] = 0x8719;
	__map_gbk2utf16[0x4d01] = 0x871b;
	__map_gbk2utf16[0x4d02] = 0x871d;
	__map_gbk2utf16[0x4d03] = 0x871f;
	__map_gbk2utf16[0x4d04] = 0x8720;
	__map_gbk2utf16[0x4d05] = 0x8724;
	__map_gbk2utf16[0x4d06] = 0x8726;
	__map_gbk2utf16[0x4d07] = 0x8727;
	__map_gbk2utf16[0x4d08] = 0x8728;
	__map_gbk2utf16[0x4d09] = 0x872a;
	__map_gbk2utf16[0x4d0a] = 0x872b;
	__map_gbk2utf16[0x4d0b] = 0x872c;
	__map_gbk2utf16[0x4d0c] = 0x872d;
	__map_gbk2utf16[0x4d0d] = 0x872f;
	__map_gbk2utf16[0x4d0e] = 0x8730;
	__map_gbk2utf16[0x4d0f] = 0x8732;
	__map_gbk2utf16[0x4d10] = 0x8733;
	__map_gbk2utf16[0x4d11] = 0x8735;
	__map_gbk2utf16[0x4d12] = 0x8736;
	__map_gbk2utf16[0x4d13] = 0x8738;
	__map_gbk2utf16[0x4d14] = 0x8739;
	__map_gbk2utf16[0x4d15] = 0x873a;
	__map_gbk2utf16[0x4d16] = 0x873c;
	__map_gbk2utf16[0x4d17] = 0x873d;
	__map_gbk2utf16[0x4d18] = 0x8740;
	__map_gbk2utf16[0x4d19] = 0x8741;
	__map_gbk2utf16[0x4d1a] = 0x8742;
	__map_gbk2utf16[0x4d1b] = 0x8743;
	__map_gbk2utf16[0x4d1c] = 0x8744;
	__map_gbk2utf16[0x4d1d] = 0x8745;
	__map_gbk2utf16[0x4d1e] = 0x8746;
	__map_gbk2utf16[0x4d1f] = 0x874a;
	__map_gbk2utf16[0x4d20] = 0x874b;
	__map_gbk2utf16[0x4d21] = 0x874d;
	__map_gbk2utf16[0x4d22] = 0x874f;
	__map_gbk2utf16[0x4d23] = 0x8750;
	__map_gbk2utf16[0x4d24] = 0x8751;
	__map_gbk2utf16[0x4d25] = 0x8752;
	__map_gbk2utf16[0x4d26] = 0x8754;
	__map_gbk2utf16[0x4d27] = 0x8755;
	__map_gbk2utf16[0x4d28] = 0x8756;
	__map_gbk2utf16[0x4d29] = 0x8758;
	__map_gbk2utf16[0x4d2a] = 0x875a;
	__map_gbk2utf16[0x4d2b] = 0x875b;
	__map_gbk2utf16[0x4d2c] = 0x875c;
	__map_gbk2utf16[0x4d2d] = 0x875d;
	__map_gbk2utf16[0x4d2e] = 0x875e;
	__map_gbk2utf16[0x4d2f] = 0x875f;
	__map_gbk2utf16[0x4d30] = 0x8761;
	__map_gbk2utf16[0x4d31] = 0x8762;
	__map_gbk2utf16[0x4d32] = 0x8766;
	__map_gbk2utf16[0x4d33] = 0x8767;
	__map_gbk2utf16[0x4d34] = 0x8768;
	__map_gbk2utf16[0x4d35] = 0x8769;
	__map_gbk2utf16[0x4d36] = 0x876a;
	__map_gbk2utf16[0x4d37] = 0x876b;
	__map_gbk2utf16[0x4d38] = 0x876c;
	__map_gbk2utf16[0x4d39] = 0x876d;
	__map_gbk2utf16[0x4d3a] = 0x876f;
	__map_gbk2utf16[0x4d3b] = 0x8771;
	__map_gbk2utf16[0x4d3c] = 0x8772;
	__map_gbk2utf16[0x4d3d] = 0x8773;
	__map_gbk2utf16[0x4d3e] = 0x8775;
	__map_gbk2utf16[0x4d40] = 0x8777;
	__map_gbk2utf16[0x4d41] = 0x8778;
	__map_gbk2utf16[0x4d42] = 0x8779;
	__map_gbk2utf16[0x4d43] = 0x877a;
	__map_gbk2utf16[0x4d44] = 0x877f;
	__map_gbk2utf16[0x4d45] = 0x8780;
	__map_gbk2utf16[0x4d46] = 0x8781;
	__map_gbk2utf16[0x4d47] = 0x8784;
	__map_gbk2utf16[0x4d48] = 0x8786;
	__map_gbk2utf16[0x4d49] = 0x8787;
	__map_gbk2utf16[0x4d4a] = 0x8789;
	__map_gbk2utf16[0x4d4b] = 0x878a;
	__map_gbk2utf16[0x4d4c] = 0x878c;
	__map_gbk2utf16[0x4d4d] = 0x878e;
	__map_gbk2utf16[0x4d4e] = 0x878f;
	__map_gbk2utf16[0x4d4f] = 0x8790;
	__map_gbk2utf16[0x4d50] = 0x8791;
	__map_gbk2utf16[0x4d51] = 0x8792;
	__map_gbk2utf16[0x4d52] = 0x8794;
	__map_gbk2utf16[0x4d53] = 0x8795;
	__map_gbk2utf16[0x4d54] = 0x8796;
	__map_gbk2utf16[0x4d55] = 0x8798;
	__map_gbk2utf16[0x4d56] = 0x8799;
	__map_gbk2utf16[0x4d57] = 0x879a;
	__map_gbk2utf16[0x4d58] = 0x879b;
	__map_gbk2utf16[0x4d59] = 0x879c;
	__map_gbk2utf16[0x4d5a] = 0x879d;
	__map_gbk2utf16[0x4d5b] = 0x879e;
	__map_gbk2utf16[0x4d5c] = 0x87a0;
	__map_gbk2utf16[0x4d5d] = 0x87a1;
	__map_gbk2utf16[0x4d5e] = 0x87a2;
	__map_gbk2utf16[0x4d5f] = 0x87a3;
	__map_gbk2utf16[0x4d60] = 0x87a4;
	__map_gbk2utf16[0x4d61] = 0x5dcd;
	__map_gbk2utf16[0x4d62] = 0x5fae;
	__map_gbk2utf16[0x4d63] = 0x5371;
	__map_gbk2utf16[0x4d64] = 0x97e6;
	__map_gbk2utf16[0x4d65] = 0x8fdd;
	__map_gbk2utf16[0x4d66] = 0x6845;
	__map_gbk2utf16[0x4d67] = 0x56f4;
	__map_gbk2utf16[0x4d68] = 0x552f;
	__map_gbk2utf16[0x4d69] = 0x60df;
	__map_gbk2utf16[0x4d6a] = 0x4e3a;
	__map_gbk2utf16[0x4d6b] = 0x6f4d;
	__map_gbk2utf16[0x4d6c] = 0x7ef4;
	__map_gbk2utf16[0x4d6d] = 0x82c7;
	__map_gbk2utf16[0x4d6e] = 0x840e;
	__map_gbk2utf16[0x4d6f] = 0x59d4;
	__map_gbk2utf16[0x4d70] = 0x4f1f;
	__map_gbk2utf16[0x4d71] = 0x4f2a;
	__map_gbk2utf16[0x4d72] = 0x5c3e;
	__map_gbk2utf16[0x4d73] = 0x7eac;
	__map_gbk2utf16[0x4d74] = 0x672a;
	__map_gbk2utf16[0x4d75] = 0x851a;
	__map_gbk2utf16[0x4d76] = 0x5473;
	__map_gbk2utf16[0x4d77] = 0x754f;
	__map_gbk2utf16[0x4d78] = 0x80c3;
	__map_gbk2utf16[0x4d79] = 0x5582;
	__map_gbk2utf16[0x4d7a] = 0x9b4f;
	__map_gbk2utf16[0x4d7b] = 0x4f4d;
	__map_gbk2utf16[0x4d7c] = 0x6e2d;
	__map_gbk2utf16[0x4d7d] = 0x8c13;
	__map_gbk2utf16[0x4d7e] = 0x5c09;
	__map_gbk2utf16[0x4d7f] = 0x6170;
	__map_gbk2utf16[0x4d80] = 0x536b;
	__map_gbk2utf16[0x4d81] = 0x761f;
	__map_gbk2utf16[0x4d82] = 0x6e29;
	__map_gbk2utf16[0x4d83] = 0x868a;
	__map_gbk2utf16[0x4d84] = 0x6587;
	__map_gbk2utf16[0x4d85] = 0x95fb;
	__map_gbk2utf16[0x4d86] = 0x7eb9;
	__map_gbk2utf16[0x4d87] = 0x543b;
	__map_gbk2utf16[0x4d88] = 0x7a33;
	__map_gbk2utf16[0x4d89] = 0x7d0a;
	__map_gbk2utf16[0x4d8a] = 0x95ee;
	__map_gbk2utf16[0x4d8b] = 0x55e1;
	__map_gbk2utf16[0x4d8c] = 0x7fc1;
	__map_gbk2utf16[0x4d8d] = 0x74ee;
	__map_gbk2utf16[0x4d8e] = 0x631d;
	__map_gbk2utf16[0x4d8f] = 0x8717;
	__map_gbk2utf16[0x4d90] = 0x6da1;
	__map_gbk2utf16[0x4d91] = 0x7a9d;
	__map_gbk2utf16[0x4d92] = 0x6211;
	__map_gbk2utf16[0x4d93] = 0x65a1;
	__map_gbk2utf16[0x4d94] = 0x5367;
	__map_gbk2utf16[0x4d95] = 0x63e1;
	__map_gbk2utf16[0x4d96] = 0x6c83;
	__map_gbk2utf16[0x4d97] = 0x5deb;
	__map_gbk2utf16[0x4d98] = 0x545c;
	__map_gbk2utf16[0x4d99] = 0x94a8;
	__map_gbk2utf16[0x4d9a] = 0x4e4c;
	__map_gbk2utf16[0x4d9b] = 0x6c61;
	__map_gbk2utf16[0x4d9c] = 0x8bec;
	__map_gbk2utf16[0x4d9d] = 0x5c4b;
	__map_gbk2utf16[0x4d9e] = 0x65e0;
	__map_gbk2utf16[0x4d9f] = 0x829c;
	__map_gbk2utf16[0x4da0] = 0x68a7;
	__map_gbk2utf16[0x4da1] = 0x543e;
	__map_gbk2utf16[0x4da2] = 0x5434;
	__map_gbk2utf16[0x4da3] = 0x6bcb;
	__map_gbk2utf16[0x4da4] = 0x6b66;
	__map_gbk2utf16[0x4da5] = 0x4e94;
	__map_gbk2utf16[0x4da6] = 0x6342;
	__map_gbk2utf16[0x4da7] = 0x5348;
	__map_gbk2utf16[0x4da8] = 0x821e;
	__map_gbk2utf16[0x4da9] = 0x4f0d;
	__map_gbk2utf16[0x4daa] = 0x4fae;
	__map_gbk2utf16[0x4dab] = 0x575e;
	__map_gbk2utf16[0x4dac] = 0x620a;
	__map_gbk2utf16[0x4dad] = 0x96fe;
	__map_gbk2utf16[0x4dae] = 0x6664;
	__map_gbk2utf16[0x4daf] = 0x7269;
	__map_gbk2utf16[0x4db0] = 0x52ff;
	__map_gbk2utf16[0x4db1] = 0x52a1;
	__map_gbk2utf16[0x4db2] = 0x609f;
	__map_gbk2utf16[0x4db3] = 0x8bef;
	__map_gbk2utf16[0x4db4] = 0x6614;
	__map_gbk2utf16[0x4db5] = 0x7199;
	__map_gbk2utf16[0x4db6] = 0x6790;
	__map_gbk2utf16[0x4db7] = 0x897f;
	__map_gbk2utf16[0x4db8] = 0x7852;
	__map_gbk2utf16[0x4db9] = 0x77fd;
	__map_gbk2utf16[0x4dba] = 0x6670;
	__map_gbk2utf16[0x4dbb] = 0x563b;
	__map_gbk2utf16[0x4dbc] = 0x5438;
	__map_gbk2utf16[0x4dbd] = 0x9521;
	__map_gbk2utf16[0x4dbe] = 0x727a;
	__map_gbk2utf16[0x4e00] = 0x87a5;
	__map_gbk2utf16[0x4e01] = 0x87a6;
	__map_gbk2utf16[0x4e02] = 0x87a7;
	__map_gbk2utf16[0x4e03] = 0x87a9;
	__map_gbk2utf16[0x4e04] = 0x87aa;
	__map_gbk2utf16[0x4e05] = 0x87ae;
	__map_gbk2utf16[0x4e06] = 0x87b0;
	__map_gbk2utf16[0x4e07] = 0x87b1;
	__map_gbk2utf16[0x4e08] = 0x87b2;
	__map_gbk2utf16[0x4e09] = 0x87b4;
	__map_gbk2utf16[0x4e0a] = 0x87b6;
	__map_gbk2utf16[0x4e0b] = 0x87b7;
	__map_gbk2utf16[0x4e0c] = 0x87b8;
	__map_gbk2utf16[0x4e0d] = 0x87b9;
	__map_gbk2utf16[0x4e0e] = 0x87bb;
	__map_gbk2utf16[0x4e0f] = 0x87bc;
	__map_gbk2utf16[0x4e10] = 0x87be;
	__map_gbk2utf16[0x4e11] = 0x87bf;
	__map_gbk2utf16[0x4e12] = 0x87c1;
	__map_gbk2utf16[0x4e13] = 0x87c2;
	__map_gbk2utf16[0x4e14] = 0x87c3;
	__map_gbk2utf16[0x4e15] = 0x87c4;
	__map_gbk2utf16[0x4e16] = 0x87c5;
	__map_gbk2utf16[0x4e17] = 0x87c7;
	__map_gbk2utf16[0x4e18] = 0x87c8;
	__map_gbk2utf16[0x4e19] = 0x87c9;
	__map_gbk2utf16[0x4e1a] = 0x87cc;
	__map_gbk2utf16[0x4e1b] = 0x87cd;
	__map_gbk2utf16[0x4e1c] = 0x87ce;
	__map_gbk2utf16[0x4e1d] = 0x87cf;
	__map_gbk2utf16[0x4e1e] = 0x87d0;
	__map_gbk2utf16[0x4e1f] = 0x87d4;
	__map_gbk2utf16[0x4e20] = 0x87d5;
	__map_gbk2utf16[0x4e21] = 0x87d6;
	__map_gbk2utf16[0x4e22] = 0x87d7;
	__map_gbk2utf16[0x4e23] = 0x87d8;
	__map_gbk2utf16[0x4e24] = 0x87d9;
	__map_gbk2utf16[0x4e25] = 0x87da;
	__map_gbk2utf16[0x4e26] = 0x87dc;
	__map_gbk2utf16[0x4e27] = 0x87dd;
	__map_gbk2utf16[0x4e28] = 0x87de;
	__map_gbk2utf16[0x4e29] = 0x87df;
	__map_gbk2utf16[0x4e2a] = 0x87e1;
	__map_gbk2utf16[0x4e2b] = 0x87e2;
	__map_gbk2utf16[0x4e2c] = 0x87e3;
	__map_gbk2utf16[0x4e2d] = 0x87e4;
	__map_gbk2utf16[0x4e2e] = 0x87e6;
	__map_gbk2utf16[0x4e2f] = 0x87e7;
	__map_gbk2utf16[0x4e30] = 0x87e8;
	__map_gbk2utf16[0x4e31] = 0x87e9;
	__map_gbk2utf16[0x4e32] = 0x87eb;
	__map_gbk2utf16[0x4e33] = 0x87ec;
	__map_gbk2utf16[0x4e34] = 0x87ed;
	__map_gbk2utf16[0x4e35] = 0x87ef;
	__map_gbk2utf16[0x4e36] = 0x87f0;
	__map_gbk2utf16[0x4e37] = 0x87f1;
	__map_gbk2utf16[0x4e38] = 0x87f2;
	__map_gbk2utf16[0x4e39] = 0x87f3;
	__map_gbk2utf16[0x4e3a] = 0x87f4;
	__map_gbk2utf16[0x4e3b] = 0x87f5;
	__map_gbk2utf16[0x4e3c] = 0x87f6;
	__map_gbk2utf16[0x4e3d] = 0x87f7;
	__map_gbk2utf16[0x4e3e] = 0x87f8;
	__map_gbk2utf16[0x4e40] = 0x87fa;
	__map_gbk2utf16[0x4e41] = 0x87fb;
	__map_gbk2utf16[0x4e42] = 0x87fc;
	__map_gbk2utf16[0x4e43] = 0x87fd;
	__map_gbk2utf16[0x4e44] = 0x87ff;
	__map_gbk2utf16[0x4e45] = 0x8800;
	__map_gbk2utf16[0x4e46] = 0x8801;
	__map_gbk2utf16[0x4e47] = 0x8802;
	__map_gbk2utf16[0x4e48] = 0x8804;
	__map_gbk2utf16[0x4e49] = 0x8805;
	__map_gbk2utf16[0x4e4a] = 0x8806;
	__map_gbk2utf16[0x4e4b] = 0x8807;
	__map_gbk2utf16[0x4e4c] = 0x8808;
	__map_gbk2utf16[0x4e4d] = 0x8809;
	__map_gbk2utf16[0x4e4e] = 0x880b;
	__map_gbk2utf16[0x4e4f] = 0x880c;
	__map_gbk2utf16[0x4e50] = 0x880d;
	__map_gbk2utf16[0x4e51] = 0x880e;
	__map_gbk2utf16[0x4e52] = 0x880f;
	__map_gbk2utf16[0x4e53] = 0x8810;
	__map_gbk2utf16[0x4e54] = 0x8811;
	__map_gbk2utf16[0x4e55] = 0x8812;
	__map_gbk2utf16[0x4e56] = 0x8814;
	__map_gbk2utf16[0x4e57] = 0x8817;
	__map_gbk2utf16[0x4e58] = 0x8818;
	__map_gbk2utf16[0x4e59] = 0x8819;
	__map_gbk2utf16[0x4e5a] = 0x881a;
	__map_gbk2utf16[0x4e5b] = 0x881c;
	__map_gbk2utf16[0x4e5c] = 0x881d;
	__map_gbk2utf16[0x4e5d] = 0x881e;
	__map_gbk2utf16[0x4e5e] = 0x881f;
	__map_gbk2utf16[0x4e5f] = 0x8820;
	__map_gbk2utf16[0x4e60] = 0x8823;
	__map_gbk2utf16[0x4e61] = 0x7a00;
	__map_gbk2utf16[0x4e62] = 0x606f;
	__map_gbk2utf16[0x4e63] = 0x5e0c;
	__map_gbk2utf16[0x4e64] = 0x6089;
	__map_gbk2utf16[0x4e65] = 0x819d;
	__map_gbk2utf16[0x4e66] = 0x5915;
	__map_gbk2utf16[0x4e67] = 0x60dc;
	__map_gbk2utf16[0x4e68] = 0x7184;
	__map_gbk2utf16[0x4e69] = 0x70ef;
	__map_gbk2utf16[0x4e6a] = 0x6eaa;
	__map_gbk2utf16[0x4e6b] = 0x6c50;
	__map_gbk2utf16[0x4e6c] = 0x7280;
	__map_gbk2utf16[0x4e6d] = 0x6a84;
	__map_gbk2utf16[0x4e6e] = 0x88ad;
	__map_gbk2utf16[0x4e6f] = 0x5e2d;
	__map_gbk2utf16[0x4e70] = 0x4e60;
	__map_gbk2utf16[0x4e71] = 0x5ab3;
	__map_gbk2utf16[0x4e72] = 0x559c;
	__map_gbk2utf16[0x4e73] = 0x94e3;
	__map_gbk2utf16[0x4e74] = 0x6d17;
	__map_gbk2utf16[0x4e75] = 0x7cfb;
	__map_gbk2utf16[0x4e76] = 0x9699;
	__map_gbk2utf16[0x4e77] = 0x620f;
	__map_gbk2utf16[0x4e78] = 0x7ec6;
	__map_gbk2utf16[0x4e79] = 0x778e;
	__map_gbk2utf16[0x4e7a] = 0x867e;
	__map_gbk2utf16[0x4e7b] = 0x5323;
	__map_gbk2utf16[0x4e7c] = 0x971e;
	__map_gbk2utf16[0x4e7d] = 0x8f96;
	__map_gbk2utf16[0x4e7e] = 0x6687;
	__map_gbk2utf16[0x4e7f] = 0x5ce1;
	__map_gbk2utf16[0x4e80] = 0x4fa0;
	__map_gbk2utf16[0x4e81] = 0x72ed;
	__map_gbk2utf16[0x4e82] = 0x4e0b;
	__map_gbk2utf16[0x4e83] = 0x53a6;
	__map_gbk2utf16[0x4e84] = 0x590f;
	__map_gbk2utf16[0x4e85] = 0x5413;
	__map_gbk2utf16[0x4e86] = 0x6380;
	__map_gbk2utf16[0x4e87] = 0x9528;
	__map_gbk2utf16[0x4e88] = 0x5148;
	__map_gbk2utf16[0x4e89] = 0x4ed9;
	__map_gbk2utf16[0x4e8a] = 0x9c9c;
	__map_gbk2utf16[0x4e8b] = 0x7ea4;
	__map_gbk2utf16[0x4e8c] = 0x54b8;
	__map_gbk2utf16[0x4e8d] = 0x8d24;
	__map_gbk2utf16[0x4e8e] = 0x8854;
	__map_gbk2utf16[0x4e8f] = 0x8237;
	__map_gbk2utf16[0x4e90] = 0x95f2;
	__map_gbk2utf16[0x4e91] = 0x6d8e;
	__map_gbk2utf16[0x4e92] = 0x5f26;
	__map_gbk2utf16[0x4e93] = 0x5acc;
	__map_gbk2utf16[0x4e94] = 0x663e;
	__map_gbk2utf16[0x4e95] = 0x9669;
	__map_gbk2utf16[0x4e96] = 0x73b0;
	__map_gbk2utf16[0x4e97] = 0x732e;
	__map_gbk2utf16[0x4e98] = 0x53bf;
	__map_gbk2utf16[0x4e99] = 0x817a;
	__map_gbk2utf16[0x4e9a] = 0x9985;
	__map_gbk2utf16[0x4e9b] = 0x7fa1;
	__map_gbk2utf16[0x4e9c] = 0x5baa;
	__map_gbk2utf16[0x4e9d] = 0x9677;
	__map_gbk2utf16[0x4e9e] = 0x9650;
	__map_gbk2utf16[0x4e9f] = 0x7ebf;
	__map_gbk2utf16[0x4ea0] = 0x76f8;
	__map_gbk2utf16[0x4ea1] = 0x53a2;
	__map_gbk2utf16[0x4ea2] = 0x9576;
	__map_gbk2utf16[0x4ea3] = 0x9999;
	__map_gbk2utf16[0x4ea4] = 0x7bb1;
	__map_gbk2utf16[0x4ea5] = 0x8944;
	__map_gbk2utf16[0x4ea6] = 0x6e58;
	__map_gbk2utf16[0x4ea7] = 0x4e61;
	__map_gbk2utf16[0x4ea8] = 0x7fd4;
	__map_gbk2utf16[0x4ea9] = 0x7965;
	__map_gbk2utf16[0x4eaa] = 0x8be6;
	__map_gbk2utf16[0x4eab] = 0x60f3;
	__map_gbk2utf16[0x4eac] = 0x54cd;
	__map_gbk2utf16[0x4ead] = 0x4eab;
	__map_gbk2utf16[0x4eae] = 0x9879;
	__map_gbk2utf16[0x4eaf] = 0x5df7;
	__map_gbk2utf16[0x4eb0] = 0x6a61;
	__map_gbk2utf16[0x4eb1] = 0x50cf;
	__map_gbk2utf16[0x4eb2] = 0x5411;
	__map_gbk2utf16[0x4eb3] = 0x8c61;
	__map_gbk2utf16[0x4eb4] = 0x8427;
	__map_gbk2utf16[0x4eb5] = 0x785d;
	__map_gbk2utf16[0x4eb6] = 0x9704;
	__map_gbk2utf16[0x4eb7] = 0x524a;
	__map_gbk2utf16[0x4eb8] = 0x54ee;
	__map_gbk2utf16[0x4eb9] = 0x56a3;
	__map_gbk2utf16[0x4eba] = 0x9500;
	__map_gbk2utf16[0x4ebb] = 0x6d88;
	__map_gbk2utf16[0x4ebc] = 0x5bb5;
	__map_gbk2utf16[0x4ebd] = 0x6dc6;
	__map_gbk2utf16[0x4ebe] = 0x6653;
	__map_gbk2utf16[0x4f00] = 0x8824;
	__map_gbk2utf16[0x4f01] = 0x8825;
	__map_gbk2utf16[0x4f02] = 0x8826;
	__map_gbk2utf16[0x4f03] = 0x8827;
	__map_gbk2utf16[0x4f04] = 0x8828;
	__map_gbk2utf16[0x4f05] = 0x8829;
	__map_gbk2utf16[0x4f06] = 0x882a;
	__map_gbk2utf16[0x4f07] = 0x882b;
	__map_gbk2utf16[0x4f08] = 0x882c;
	__map_gbk2utf16[0x4f09] = 0x882d;
	__map_gbk2utf16[0x4f0a] = 0x882e;
	__map_gbk2utf16[0x4f0b] = 0x882f;
	__map_gbk2utf16[0x4f0c] = 0x8830;
	__map_gbk2utf16[0x4f0d] = 0x8831;
	__map_gbk2utf16[0x4f0e] = 0x8833;
	__map_gbk2utf16[0x4f0f] = 0x8834;
	__map_gbk2utf16[0x4f10] = 0x8835;
	__map_gbk2utf16[0x4f11] = 0x8836;
	__map_gbk2utf16[0x4f12] = 0x8837;
	__map_gbk2utf16[0x4f13] = 0x8838;
	__map_gbk2utf16[0x4f14] = 0x883a;
	__map_gbk2utf16[0x4f15] = 0x883b;
	__map_gbk2utf16[0x4f16] = 0x883d;
	__map_gbk2utf16[0x4f17] = 0x883e;
	__map_gbk2utf16[0x4f18] = 0x883f;
	__map_gbk2utf16[0x4f19] = 0x8841;
	__map_gbk2utf16[0x4f1a] = 0x8842;
	__map_gbk2utf16[0x4f1b] = 0x8843;
	__map_gbk2utf16[0x4f1c] = 0x8846;
	__map_gbk2utf16[0x4f1d] = 0x8847;
	__map_gbk2utf16[0x4f1e] = 0x8848;
	__map_gbk2utf16[0x4f1f] = 0x8849;
	__map_gbk2utf16[0x4f20] = 0x884a;
	__map_gbk2utf16[0x4f21] = 0x884b;
	__map_gbk2utf16[0x4f22] = 0x884e;
	__map_gbk2utf16[0x4f23] = 0x884f;
	__map_gbk2utf16[0x4f24] = 0x8850;
	__map_gbk2utf16[0x4f25] = 0x8851;
	__map_gbk2utf16[0x4f26] = 0x8852;
	__map_gbk2utf16[0x4f27] = 0x8853;
	__map_gbk2utf16[0x4f28] = 0x8855;
	__map_gbk2utf16[0x4f29] = 0x8856;
	__map_gbk2utf16[0x4f2a] = 0x8858;
	__map_gbk2utf16[0x4f2b] = 0x885a;
	__map_gbk2utf16[0x4f2c] = 0x885b;
	__map_gbk2utf16[0x4f2d] = 0x885c;
	__map_gbk2utf16[0x4f2e] = 0x885d;
	__map_gbk2utf16[0x4f2f] = 0x885e;
	__map_gbk2utf16[0x4f30] = 0x885f;
	__map_gbk2utf16[0x4f31] = 0x8860;
	__map_gbk2utf16[0x4f32] = 0x8866;
	__map_gbk2utf16[0x4f33] = 0x8867;
	__map_gbk2utf16[0x4f34] = 0x886a;
	__map_gbk2utf16[0x4f35] = 0x886d;
	__map_gbk2utf16[0x4f36] = 0x886f;
	__map_gbk2utf16[0x4f37] = 0x8871;
	__map_gbk2utf16[0x4f38] = 0x8873;
	__map_gbk2utf16[0x4f39] = 0x8874;
	__map_gbk2utf16[0x4f3a] = 0x8875;
	__map_gbk2utf16[0x4f3b] = 0x8876;
	__map_gbk2utf16[0x4f3c] = 0x8878;
	__map_gbk2utf16[0x4f3d] = 0x8879;
	__map_gbk2utf16[0x4f3e] = 0x887a;
	__map_gbk2utf16[0x4f40] = 0x887b;
	__map_gbk2utf16[0x4f41] = 0x887c;
	__map_gbk2utf16[0x4f42] = 0x8880;
	__map_gbk2utf16[0x4f43] = 0x8883;
	__map_gbk2utf16[0x4f44] = 0x8886;
	__map_gbk2utf16[0x4f45] = 0x8887;
	__map_gbk2utf16[0x4f46] = 0x8889;
	__map_gbk2utf16[0x4f47] = 0x888a;
	__map_gbk2utf16[0x4f48] = 0x888c;
	__map_gbk2utf16[0x4f49] = 0x888e;
	__map_gbk2utf16[0x4f4a] = 0x888f;
	__map_gbk2utf16[0x4f4b] = 0x8890;
	__map_gbk2utf16[0x4f4c] = 0x8891;
	__map_gbk2utf16[0x4f4d] = 0x8893;
	__map_gbk2utf16[0x4f4e] = 0x8894;
	__map_gbk2utf16[0x4f4f] = 0x8895;
	__map_gbk2utf16[0x4f50] = 0x8897;
	__map_gbk2utf16[0x4f51] = 0x8898;
	__map_gbk2utf16[0x4f52] = 0x8899;
	__map_gbk2utf16[0x4f53] = 0x889a;
	__map_gbk2utf16[0x4f54] = 0x889b;
	__map_gbk2utf16[0x4f55] = 0x889d;
	__map_gbk2utf16[0x4f56] = 0x889e;
	__map_gbk2utf16[0x4f57] = 0x889f;
	__map_gbk2utf16[0x4f58] = 0x88a0;
	__map_gbk2utf16[0x4f59] = 0x88a1;
	__map_gbk2utf16[0x4f5a] = 0x88a3;
	__map_gbk2utf16[0x4f5b] = 0x88a5;
	__map_gbk2utf16[0x4f5c] = 0x88a6;
	__map_gbk2utf16[0x4f5d] = 0x88a7;
	__map_gbk2utf16[0x4f5e] = 0x88a8;
	__map_gbk2utf16[0x4f5f] = 0x88a9;
	__map_gbk2utf16[0x4f60] = 0x88aa;
	__map_gbk2utf16[0x4f61] = 0x5c0f;
	__map_gbk2utf16[0x4f62] = 0x5b5d;
	__map_gbk2utf16[0x4f63] = 0x6821;
	__map_gbk2utf16[0x4f64] = 0x8096;
	__map_gbk2utf16[0x4f65] = 0x5578;
	__map_gbk2utf16[0x4f66] = 0x7b11;
	__map_gbk2utf16[0x4f67] = 0x6548;
	__map_gbk2utf16[0x4f68] = 0x6954;
	__map_gbk2utf16[0x4f69] = 0x4e9b;
	__map_gbk2utf16[0x4f6a] = 0x6b47;
	__map_gbk2utf16[0x4f6b] = 0x874e;
	__map_gbk2utf16[0x4f6c] = 0x978b;
	__map_gbk2utf16[0x4f6d] = 0x534f;
	__map_gbk2utf16[0x4f6e] = 0x631f;
	__map_gbk2utf16[0x4f6f] = 0x643a;
	__map_gbk2utf16[0x4f70] = 0x90aa;
	__map_gbk2utf16[0x4f71] = 0x659c;
	__map_gbk2utf16[0x4f72] = 0x80c1;
	__map_gbk2utf16[0x4f73] = 0x8c10;
	__map_gbk2utf16[0x4f74] = 0x5199;
	__map_gbk2utf16[0x4f75] = 0x68b0;
	__map_gbk2utf16[0x4f76] = 0x5378;
	__map_gbk2utf16[0x4f77] = 0x87f9;
	__map_gbk2utf16[0x4f78] = 0x61c8;
	__map_gbk2utf16[0x4f79] = 0x6cc4;
	__map_gbk2utf16[0x4f7a] = 0x6cfb;
	__map_gbk2utf16[0x4f7b] = 0x8c22;
	__map_gbk2utf16[0x4f7c] = 0x5c51;
	__map_gbk2utf16[0x4f7d] = 0x85aa;
	__map_gbk2utf16[0x4f7e] = 0x82af;
	__map_gbk2utf16[0x4f7f] = 0x950c;
	__map_gbk2utf16[0x4f80] = 0x6b23;
	__map_gbk2utf16[0x4f81] = 0x8f9b;
	__map_gbk2utf16[0x4f82] = 0x65b0;
	__map_gbk2utf16[0x4f83] = 0x5ffb;
	__map_gbk2utf16[0x4f84] = 0x5fc3;
	__map_gbk2utf16[0x4f85] = 0x4fe1;
	__map_gbk2utf16[0x4f86] = 0x8845;
	__map_gbk2utf16[0x4f87] = 0x661f;
	__map_gbk2utf16[0x4f88] = 0x8165;
	__map_gbk2utf16[0x4f89] = 0x7329;
	__map_gbk2utf16[0x4f8a] = 0x60fa;
	__map_gbk2utf16[0x4f8b] = 0x5174;
	__map_gbk2utf16[0x4f8c] = 0x5211;
	__map_gbk2utf16[0x4f8d] = 0x578b;
	__map_gbk2utf16[0x4f8e] = 0x5f62;
	__map_gbk2utf16[0x4f8f] = 0x90a2;
	__map_gbk2utf16[0x4f90] = 0x884c;
	__map_gbk2utf16[0x4f91] = 0x9192;
	__map_gbk2utf16[0x4f92] = 0x5e78;
	__map_gbk2utf16[0x4f93] = 0x674f;
	__map_gbk2utf16[0x4f94] = 0x6027;
	__map_gbk2utf16[0x4f95] = 0x59d3;
	__map_gbk2utf16[0x4f96] = 0x5144;
	__map_gbk2utf16[0x4f97] = 0x51f6;
	__map_gbk2utf16[0x4f98] = 0x80f8;
	__map_gbk2utf16[0x4f99] = 0x5308;
	__map_gbk2utf16[0x4f9a] = 0x6c79;
	__map_gbk2utf16[0x4f9b] = 0x96c4;
	__map_gbk2utf16[0x4f9c] = 0x718a;
	__map_gbk2utf16[0x4f9d] = 0x4f11;
	__map_gbk2utf16[0x4f9e] = 0x4fee;
	__map_gbk2utf16[0x4f9f] = 0x7f9e;
	__map_gbk2utf16[0x4fa0] = 0x673d;
	__map_gbk2utf16[0x4fa1] = 0x55c5;
	__map_gbk2utf16[0x4fa2] = 0x9508;
	__map_gbk2utf16[0x4fa3] = 0x79c0;
	__map_gbk2utf16[0x4fa4] = 0x8896;
	__map_gbk2utf16[0x4fa5] = 0x7ee3;
	__map_gbk2utf16[0x4fa6] = 0x589f;
	__map_gbk2utf16[0x4fa7] = 0x620c;
	__map_gbk2utf16[0x4fa8] = 0x9700;
	__map_gbk2utf16[0x4fa9] = 0x865a;
	__map_gbk2utf16[0x4faa] = 0x5618;
	__map_gbk2utf16[0x4fab] = 0x987b;
	__map_gbk2utf16[0x4fac] = 0x5f90;
	__map_gbk2utf16[0x4fad] = 0x8bb8;
	__map_gbk2utf16[0x4fae] = 0x84c4;
	__map_gbk2utf16[0x4faf] = 0x9157;
	__map_gbk2utf16[0x4fb0] = 0x53d9;
	__map_gbk2utf16[0x4fb1] = 0x65ed;
	__map_gbk2utf16[0x4fb2] = 0x5e8f;
	__map_gbk2utf16[0x4fb3] = 0x755c;
	__map_gbk2utf16[0x4fb4] = 0x6064;
	__map_gbk2utf16[0x4fb5] = 0x7d6e;
	__map_gbk2utf16[0x4fb6] = 0x5a7f;
	__map_gbk2utf16[0x4fb7] = 0x7eea;
	__map_gbk2utf16[0x4fb8] = 0x7eed;
	__map_gbk2utf16[0x4fb9] = 0x8f69;
	__map_gbk2utf16[0x4fba] = 0x55a7;
	__map_gbk2utf16[0x4fbb] = 0x5ba3;
	__map_gbk2utf16[0x4fbc] = 0x60ac;
	__map_gbk2utf16[0x4fbd] = 0x65cb;
	__map_gbk2utf16[0x4fbe] = 0x7384;
	__map_gbk2utf16[0x5000] = 0x88ac;
	__map_gbk2utf16[0x5001] = 0x88ae;
	__map_gbk2utf16[0x5002] = 0x88af;
	__map_gbk2utf16[0x5003] = 0x88b0;
	__map_gbk2utf16[0x5004] = 0x88b2;
	__map_gbk2utf16[0x5005] = 0x88b3;
	__map_gbk2utf16[0x5006] = 0x88b4;
	__map_gbk2utf16[0x5007] = 0x88b5;
	__map_gbk2utf16[0x5008] = 0x88b6;
	__map_gbk2utf16[0x5009] = 0x88b8;
	__map_gbk2utf16[0x500a] = 0x88b9;
	__map_gbk2utf16[0x500b] = 0x88ba;
	__map_gbk2utf16[0x500c] = 0x88bb;
	__map_gbk2utf16[0x500d] = 0x88bd;
	__map_gbk2utf16[0x500e] = 0x88be;
	__map_gbk2utf16[0x500f] = 0x88bf;
	__map_gbk2utf16[0x5010] = 0x88c0;
	__map_gbk2utf16[0x5011] = 0x88c3;
	__map_gbk2utf16[0x5012] = 0x88c4;
	__map_gbk2utf16[0x5013] = 0x88c7;
	__map_gbk2utf16[0x5014] = 0x88c8;
	__map_gbk2utf16[0x5015] = 0x88ca;
	__map_gbk2utf16[0x5016] = 0x88cb;
	__map_gbk2utf16[0x5017] = 0x88cc;
	__map_gbk2utf16[0x5018] = 0x88cd;
	__map_gbk2utf16[0x5019] = 0x88cf;
	__map_gbk2utf16[0x501a] = 0x88d0;
	__map_gbk2utf16[0x501b] = 0x88d1;
	__map_gbk2utf16[0x501c] = 0x88d3;
	__map_gbk2utf16[0x501d] = 0x88d6;
	__map_gbk2utf16[0x501e] = 0x88d7;
	__map_gbk2utf16[0x501f] = 0x88da;
	__map_gbk2utf16[0x5020] = 0x88db;
	__map_gbk2utf16[0x5021] = 0x88dc;
	__map_gbk2utf16[0x5022] = 0x88dd;
	__map_gbk2utf16[0x5023] = 0x88de;
	__map_gbk2utf16[0x5024] = 0x88e0;
	__map_gbk2utf16[0x5025] = 0x88e1;
	__map_gbk2utf16[0x5026] = 0x88e6;
	__map_gbk2utf16[0x5027] = 0x88e7;
	__map_gbk2utf16[0x5028] = 0x88e9;
	__map_gbk2utf16[0x5029] = 0x88ea;
	__map_gbk2utf16[0x502a] = 0x88eb;
	__map_gbk2utf16[0x502b] = 0x88ec;
	__map_gbk2utf16[0x502c] = 0x88ed;
	__map_gbk2utf16[0x502d] = 0x88ee;
	__map_gbk2utf16[0x502e] = 0x88ef;
	__map_gbk2utf16[0x502f] = 0x88f2;
	__map_gbk2utf16[0x5030] = 0x88f5;
	__map_gbk2utf16[0x5031] = 0x88f6;
	__map_gbk2utf16[0x5032] = 0x88f7;
	__map_gbk2utf16[0x5033] = 0x88fa;
	__map_gbk2utf16[0x5034] = 0x88fb;
	__map_gbk2utf16[0x5035] = 0x88fd;
	__map_gbk2utf16[0x5036] = 0x88ff;
	__map_gbk2utf16[0x5037] = 0x8900;
	__map_gbk2utf16[0x5038] = 0x8901;
	__map_gbk2utf16[0x5039] = 0x8903;
	__map_gbk2utf16[0x503a] = 0x8904;
	__map_gbk2utf16[0x503b] = 0x8905;
	__map_gbk2utf16[0x503c] = 0x8906;
	__map_gbk2utf16[0x503d] = 0x8907;
	__map_gbk2utf16[0x503e] = 0x8908;
	__map_gbk2utf16[0x5040] = 0x8909;
	__map_gbk2utf16[0x5041] = 0x890b;
	__map_gbk2utf16[0x5042] = 0x890c;
	__map_gbk2utf16[0x5043] = 0x890d;
	__map_gbk2utf16[0x5044] = 0x890e;
	__map_gbk2utf16[0x5045] = 0x890f;
	__map_gbk2utf16[0x5046] = 0x8911;
	__map_gbk2utf16[0x5047] = 0x8914;
	__map_gbk2utf16[0x5048] = 0x8915;
	__map_gbk2utf16[0x5049] = 0x8916;
	__map_gbk2utf16[0x504a] = 0x8917;
	__map_gbk2utf16[0x504b] = 0x8918;
	__map_gbk2utf16[0x504c] = 0x891c;
	__map_gbk2utf16[0x504d] = 0x891d;
	__map_gbk2utf16[0x504e] = 0x891e;
	__map_gbk2utf16[0x504f] = 0x891f;
	__map_gbk2utf16[0x5050] = 0x8920;
	__map_gbk2utf16[0x5051] = 0x8922;
	__map_gbk2utf16[0x5052] = 0x8923;
	__map_gbk2utf16[0x5053] = 0x8924;
	__map_gbk2utf16[0x5054] = 0x8926;
	__map_gbk2utf16[0x5055] = 0x8927;
	__map_gbk2utf16[0x5056] = 0x8928;
	__map_gbk2utf16[0x5057] = 0x8929;
	__map_gbk2utf16[0x5058] = 0x892c;
	__map_gbk2utf16[0x5059] = 0x892d;
	__map_gbk2utf16[0x505a] = 0x892e;
	__map_gbk2utf16[0x505b] = 0x892f;
	__map_gbk2utf16[0x505c] = 0x8931;
	__map_gbk2utf16[0x505d] = 0x8932;
	__map_gbk2utf16[0x505e] = 0x8933;
	__map_gbk2utf16[0x505f] = 0x8935;
	__map_gbk2utf16[0x5060] = 0x8937;
	__map_gbk2utf16[0x5061] = 0x9009;
	__map_gbk2utf16[0x5062] = 0x7663;
	__map_gbk2utf16[0x5063] = 0x7729;
	__map_gbk2utf16[0x5064] = 0x7eda;
	__map_gbk2utf16[0x5065] = 0x9774;
	__map_gbk2utf16[0x5066] = 0x859b;
	__map_gbk2utf16[0x5067] = 0x5b66;
	__map_gbk2utf16[0x5068] = 0x7a74;
	__map_gbk2utf16[0x5069] = 0x96ea;
	__map_gbk2utf16[0x506a] = 0x8840;
	__map_gbk2utf16[0x506b] = 0x52cb;
	__map_gbk2utf16[0x506c] = 0x718f;
	__map_gbk2utf16[0x506d] = 0x5faa;
	__map_gbk2utf16[0x506e] = 0x65ec;
	__map_gbk2utf16[0x506f] = 0x8be2;
	__map_gbk2utf16[0x5070] = 0x5bfb;
	__map_gbk2utf16[0x5071] = 0x9a6f;
	__map_gbk2utf16[0x5072] = 0x5de1;
	__map_gbk2utf16[0x5073] = 0x6b89;
	__map_gbk2utf16[0x5074] = 0x6c5b;
	__map_gbk2utf16[0x5075] = 0x8bad;
	__map_gbk2utf16[0x5076] = 0x8baf;
	__map_gbk2utf16[0x5077] = 0x900a;
	__map_gbk2utf16[0x5078] = 0x8fc5;
	__map_gbk2utf16[0x5079] = 0x538b;
	__map_gbk2utf16[0x507a] = 0x62bc;
	__map_gbk2utf16[0x507b] = 0x9e26;
	__map_gbk2utf16[0x507c] = 0x9e2d;
	__map_gbk2utf16[0x507d] = 0x5440;
	__map_gbk2utf16[0x507e] = 0x4e2b;
	__map_gbk2utf16[0x507f] = 0x82bd;
	__map_gbk2utf16[0x5080] = 0x7259;
	__map_gbk2utf16[0x5081] = 0x869c;
	__map_gbk2utf16[0x5082] = 0x5d16;
	__map_gbk2utf16[0x5083] = 0x8859;
	__map_gbk2utf16[0x5084] = 0x6daf;
	__map_gbk2utf16[0x5085] = 0x96c5;
	__map_gbk2utf16[0x5086] = 0x54d1;
	__map_gbk2utf16[0x5087] = 0x4e9a;
	__map_gbk2utf16[0x5088] = 0x8bb6;
	__map_gbk2utf16[0x5089] = 0x7109;
	__map_gbk2utf16[0x508a] = 0x54bd;
	__map_gbk2utf16[0x508b] = 0x9609;
	__map_gbk2utf16[0x508c] = 0x70df;
	__map_gbk2utf16[0x508d] = 0x6df9;
	__map_gbk2utf16[0x508e] = 0x76d0;
	__map_gbk2utf16[0x508f] = 0x4e25;
	__map_gbk2utf16[0x5090] = 0x7814;
	__map_gbk2utf16[0x5091] = 0x8712;
	__map_gbk2utf16[0x5092] = 0x5ca9;
	__map_gbk2utf16[0x5093] = 0x5ef6;
	__map_gbk2utf16[0x5094] = 0x8a00;
	__map_gbk2utf16[0x5095] = 0x989c;
	__map_gbk2utf16[0x5096] = 0x960e;
	__map_gbk2utf16[0x5097] = 0x708e;
	__map_gbk2utf16[0x5098] = 0x6cbf;
	__map_gbk2utf16[0x5099] = 0x5944;
	__map_gbk2utf16[0x509a] = 0x63a9;
	__map_gbk2utf16[0x509b] = 0x773c;
	__map_gbk2utf16[0x509c] = 0x884d;
	__map_gbk2utf16[0x509d] = 0x6f14;
	__map_gbk2utf16[0x509e] = 0x8273;
	__map_gbk2utf16[0x509f] = 0x5830;
	__map_gbk2utf16[0x50a0] = 0x71d5;
	__map_gbk2utf16[0x50a1] = 0x538c;
	__map_gbk2utf16[0x50a2] = 0x781a;
	__map_gbk2utf16[0x50a3] = 0x96c1;
	__map_gbk2utf16[0x50a4] = 0x5501;
	__map_gbk2utf16[0x50a5] = 0x5f66;
	__map_gbk2utf16[0x50a6] = 0x7130;
	__map_gbk2utf16[0x50a7] = 0x5bb4;
	__map_gbk2utf16[0x50a8] = 0x8c1a;
	__map_gbk2utf16[0x50a9] = 0x9a8c;
	__map_gbk2utf16[0x50aa] = 0x6b83;
	__map_gbk2utf16[0x50ab] = 0x592e;
	__map_gbk2utf16[0x50ac] = 0x9e2f;
	__map_gbk2utf16[0x50ad] = 0x79e7;
	__map_gbk2utf16[0x50ae] = 0x6768;
	__map_gbk2utf16[0x50af] = 0x626c;
	__map_gbk2utf16[0x50b0] = 0x4f6f;
	__map_gbk2utf16[0x50b1] = 0x75a1;
	__map_gbk2utf16[0x50b2] = 0x7f8a;
	__map_gbk2utf16[0x50b3] = 0x6d0b;
	__map_gbk2utf16[0x50b4] = 0x9633;
	__map_gbk2utf16[0x50b5] = 0x6c27;
	__map_gbk2utf16[0x50b6] = 0x4ef0;
	__map_gbk2utf16[0x50b7] = 0x75d2;
	__map_gbk2utf16[0x50b8] = 0x517b;
	__map_gbk2utf16[0x50b9] = 0x6837;
	__map_gbk2utf16[0x50ba] = 0x6f3e;
	__map_gbk2utf16[0x50bb] = 0x9080;
	__map_gbk2utf16[0x50bc] = 0x8170;
	__map_gbk2utf16[0x50bd] = 0x5996;
	__map_gbk2utf16[0x50be] = 0x7476;
	__map_gbk2utf16[0x5100] = 0x8938;
	__map_gbk2utf16[0x5101] = 0x8939;
	__map_gbk2utf16[0x5102] = 0x893a;
	__map_gbk2utf16[0x5103] = 0x893b;
	__map_gbk2utf16[0x5104] = 0x893c;
	__map_gbk2utf16[0x5105] = 0x893d;
	__map_gbk2utf16[0x5106] = 0x893e;
	__map_gbk2utf16[0x5107] = 0x893f;
	__map_gbk2utf16[0x5108] = 0x8940;
	__map_gbk2utf16[0x5109] = 0x8942;
	__map_gbk2utf16[0x510a] = 0x8943;
	__map_gbk2utf16[0x510b] = 0x8945;
	__map_gbk2utf16[0x510c] = 0x8946;
	__map_gbk2utf16[0x510d] = 0x8947;
	__map_gbk2utf16[0x510e] = 0x8948;
	__map_gbk2utf16[0x510f] = 0x8949;
	__map_gbk2utf16[0x5110] = 0x894a;
	__map_gbk2utf16[0x5111] = 0x894b;
	__map_gbk2utf16[0x5112] = 0x894c;
	__map_gbk2utf16[0x5113] = 0x894d;
	__map_gbk2utf16[0x5114] = 0x894e;
	__map_gbk2utf16[0x5115] = 0x894f;
	__map_gbk2utf16[0x5116] = 0x8950;
	__map_gbk2utf16[0x5117] = 0x8951;
	__map_gbk2utf16[0x5118] = 0x8952;
	__map_gbk2utf16[0x5119] = 0x8953;
	__map_gbk2utf16[0x511a] = 0x8954;
	__map_gbk2utf16[0x511b] = 0x8955;
	__map_gbk2utf16[0x511c] = 0x8956;
	__map_gbk2utf16[0x511d] = 0x8957;
	__map_gbk2utf16[0x511e] = 0x8958;
	__map_gbk2utf16[0x511f] = 0x8959;
	__map_gbk2utf16[0x5120] = 0x895a;
	__map_gbk2utf16[0x5121] = 0x895b;
	__map_gbk2utf16[0x5122] = 0x895c;
	__map_gbk2utf16[0x5123] = 0x895d;
	__map_gbk2utf16[0x5124] = 0x8960;
	__map_gbk2utf16[0x5125] = 0x8961;
	__map_gbk2utf16[0x5126] = 0x8962;
	__map_gbk2utf16[0x5127] = 0x8963;
	__map_gbk2utf16[0x5128] = 0x8964;
	__map_gbk2utf16[0x5129] = 0x8965;
	__map_gbk2utf16[0x512a] = 0x8967;
	__map_gbk2utf16[0x512b] = 0x8968;
	__map_gbk2utf16[0x512c] = 0x8969;
	__map_gbk2utf16[0x512d] = 0x896a;
	__map_gbk2utf16[0x512e] = 0x896b;
	__map_gbk2utf16[0x512f] = 0x896c;
	__map_gbk2utf16[0x5130] = 0x896d;
	__map_gbk2utf16[0x5131] = 0x896e;
	__map_gbk2utf16[0x5132] = 0x896f;
	__map_gbk2utf16[0x5133] = 0x8970;
	__map_gbk2utf16[0x5134] = 0x8971;
	__map_gbk2utf16[0x5135] = 0x8972;
	__map_gbk2utf16[0x5136] = 0x8973;
	__map_gbk2utf16[0x5137] = 0x8974;
	__map_gbk2utf16[0x5138] = 0x8975;
	__map_gbk2utf16[0x5139] = 0x8976;
	__map_gbk2utf16[0x513a] = 0x8977;
	__map_gbk2utf16[0x513b] = 0x8978;
	__map_gbk2utf16[0x513c] = 0x8979;
	__map_gbk2utf16[0x513d] = 0x897a;
	__map_gbk2utf16[0x513e] = 0x897c;
	__map_gbk2utf16[0x5140] = 0x897d;
	__map_gbk2utf16[0x5141] = 0x897e;
	__map_gbk2utf16[0x5142] = 0x8980;
	__map_gbk2utf16[0x5143] = 0x8982;
	__map_gbk2utf16[0x5144] = 0x8984;
	__map_gbk2utf16[0x5145] = 0x8985;
	__map_gbk2utf16[0x5146] = 0x8987;
	__map_gbk2utf16[0x5147] = 0x8988;
	__map_gbk2utf16[0x5148] = 0x8989;
	__map_gbk2utf16[0x5149] = 0x898a;
	__map_gbk2utf16[0x514a] = 0x898b;
	__map_gbk2utf16[0x514b] = 0x898c;
	__map_gbk2utf16[0x514c] = 0x898d;
	__map_gbk2utf16[0x514d] = 0x898e;
	__map_gbk2utf16[0x514e] = 0x898f;
	__map_gbk2utf16[0x514f] = 0x8990;
	__map_gbk2utf16[0x5150] = 0x8991;
	__map_gbk2utf16[0x5151] = 0x8992;
	__map_gbk2utf16[0x5152] = 0x8993;
	__map_gbk2utf16[0x5153] = 0x8994;
	__map_gbk2utf16[0x5154] = 0x8995;
	__map_gbk2utf16[0x5155] = 0x8996;
	__map_gbk2utf16[0x5156] = 0x8997;
	__map_gbk2utf16[0x5157] = 0x8998;
	__map_gbk2utf16[0x5158] = 0x8999;
	__map_gbk2utf16[0x5159] = 0x899a;
	__map_gbk2utf16[0x515a] = 0x899b;
	__map_gbk2utf16[0x515b] = 0x899c;
	__map_gbk2utf16[0x515c] = 0x899d;
	__map_gbk2utf16[0x515d] = 0x899e;
	__map_gbk2utf16[0x515e] = 0x899f;
	__map_gbk2utf16[0x515f] = 0x89a0;
	__map_gbk2utf16[0x5160] = 0x89a1;
	__map_gbk2utf16[0x5161] = 0x6447;
	__map_gbk2utf16[0x5162] = 0x5c27;
	__map_gbk2utf16[0x5163] = 0x9065;
	__map_gbk2utf16[0x5164] = 0x7a91;
	__map_gbk2utf16[0x5165] = 0x8c23;
	__map_gbk2utf16[0x5166] = 0x59da;
	__map_gbk2utf16[0x5167] = 0x54ac;
	__map_gbk2utf16[0x5168] = 0x8200;
	__map_gbk2utf16[0x5169] = 0x836f;
	__map_gbk2utf16[0x516a] = 0x8981;
	__map_gbk2utf16[0x516b] = 0x8000;
	__map_gbk2utf16[0x516c] = 0x6930;
	__map_gbk2utf16[0x516d] = 0x564e;
	__map_gbk2utf16[0x516e] = 0x8036;
	__map_gbk2utf16[0x516f] = 0x7237;
	__map_gbk2utf16[0x5170] = 0x91ce;
	__map_gbk2utf16[0x5171] = 0x51b6;
	__map_gbk2utf16[0x5172] = 0x4e5f;
	__map_gbk2utf16[0x5173] = 0x9875;
	__map_gbk2utf16[0x5174] = 0x6396;
	__map_gbk2utf16[0x5175] = 0x4e1a;
	__map_gbk2utf16[0x5176] = 0x53f6;
	__map_gbk2utf16[0x5177] = 0x66f3;
	__map_gbk2utf16[0x5178] = 0x814b;
	__map_gbk2utf16[0x5179] = 0x591c;
	__map_gbk2utf16[0x517a] = 0x6db2;
	__map_gbk2utf16[0x517b] = 0x4e00;
	__map_gbk2utf16[0x517c] = 0x58f9;
	__map_gbk2utf16[0x517d] = 0x533b;
	__map_gbk2utf16[0x517e] = 0x63d6;
	__map_gbk2utf16[0x517f] = 0x94f1;
	__map_gbk2utf16[0x5180] = 0x4f9d;
	__map_gbk2utf16[0x5181] = 0x4f0a;
	__map_gbk2utf16[0x5182] = 0x8863;
	__map_gbk2utf16[0x5183] = 0x9890;
	__map_gbk2utf16[0x5184] = 0x5937;
	__map_gbk2utf16[0x5185] = 0x9057;
	__map_gbk2utf16[0x5186] = 0x79fb;
	__map_gbk2utf16[0x5187] = 0x4eea;
	__map_gbk2utf16[0x5188] = 0x80f0;
	__map_gbk2utf16[0x5189] = 0x7591;
	__map_gbk2utf16[0x518a] = 0x6c82;
	__map_gbk2utf16[0x518b] = 0x5b9c;
	__map_gbk2utf16[0x518c] = 0x59e8;
	__map_gbk2utf16[0x518d] = 0x5f5d;
	__map_gbk2utf16[0x518e] = 0x6905;
	__map_gbk2utf16[0x518f] = 0x8681;
	__map_gbk2utf16[0x5190] = 0x501a;
	__map_gbk2utf16[0x5191] = 0x5df2;
	__map_gbk2utf16[0x5192] = 0x4e59;
	__map_gbk2utf16[0x5193] = 0x77e3;
	__map_gbk2utf16[0x5194] = 0x4ee5;
	__map_gbk2utf16[0x5195] = 0x827a;
	__map_gbk2utf16[0x5196] = 0x6291;
	__map_gbk2utf16[0x5197] = 0x6613;
	__map_gbk2utf16[0x5198] = 0x9091;
	__map_gbk2utf16[0x5199] = 0x5c79;
	__map_gbk2utf16[0x519a] = 0x4ebf;
	__map_gbk2utf16[0x519b] = 0x5f79;
	__map_gbk2utf16[0x519c] = 0x81c6;
	__map_gbk2utf16[0x519d] = 0x9038;
	__map_gbk2utf16[0x519e] = 0x8084;
	__map_gbk2utf16[0x519f] = 0x75ab;
	__map_gbk2utf16[0x51a0] = 0x4ea6;
	__map_gbk2utf16[0x51a1] = 0x88d4;
	__map_gbk2utf16[0x51a2] = 0x610f;
	__map_gbk2utf16[0x51a3] = 0x6bc5;
	__map_gbk2utf16[0x51a4] = 0x5fc6;
	__map_gbk2utf16[0x51a5] = 0x4e49;
	__map_gbk2utf16[0x51a6] = 0x76ca;
	__map_gbk2utf16[0x51a7] = 0x6ea2;
	__map_gbk2utf16[0x51a8] = 0x8be3;
	__map_gbk2utf16[0x51a9] = 0x8bae;
	__map_gbk2utf16[0x51aa] = 0x8c0a;
	__map_gbk2utf16[0x51ab] = 0x8bd1;
	__map_gbk2utf16[0x51ac] = 0x5f02;
	__map_gbk2utf16[0x51ad] = 0x7ffc;
	__map_gbk2utf16[0x51ae] = 0x7fcc;
	__map_gbk2utf16[0x51af] = 0x7ece;
	__map_gbk2utf16[0x51b0] = 0x8335;
	__map_gbk2utf16[0x51b1] = 0x836b;
	__map_gbk2utf16[0x51b2] = 0x56e0;
	__map_gbk2utf16[0x51b3] = 0x6bb7;
	__map_gbk2utf16[0x51b4] = 0x97f3;
	__map_gbk2utf16[0x51b5] = 0x9634;
	__map_gbk2utf16[0x51b6] = 0x59fb;
	__map_gbk2utf16[0x51b7] = 0x541f;
	__map_gbk2utf16[0x51b8] = 0x94f6;
	__map_gbk2utf16[0x51b9] = 0x6deb;
	__map_gbk2utf16[0x51ba] = 0x5bc5;
	__map_gbk2utf16[0x51bb] = 0x996e;
	__map_gbk2utf16[0x51bc] = 0x5c39;
	__map_gbk2utf16[0x51bd] = 0x5f15;
	__map_gbk2utf16[0x51be] = 0x9690;
	__map_gbk2utf16[0x5200] = 0x89a2;
	__map_gbk2utf16[0x5201] = 0x89a3;
	__map_gbk2utf16[0x5202] = 0x89a4;
	__map_gbk2utf16[0x5203] = 0x89a5;
	__map_gbk2utf16[0x5204] = 0x89a6;
	__map_gbk2utf16[0x5205] = 0x89a7;
	__map_gbk2utf16[0x5206] = 0x89a8;
	__map_gbk2utf16[0x5207] = 0x89a9;
	__map_gbk2utf16[0x5208] = 0x89aa;
	__map_gbk2utf16[0x5209] = 0x89ab;
	__map_gbk2utf16[0x520a] = 0x89ac;
	__map_gbk2utf16[0x520b] = 0x89ad;
	__map_gbk2utf16[0x520c] = 0x89ae;
	__map_gbk2utf16[0x520d] = 0x89af;
	__map_gbk2utf16[0x520e] = 0x89b0;
	__map_gbk2utf16[0x520f] = 0x89b1;
	__map_gbk2utf16[0x5210] = 0x89b2;
	__map_gbk2utf16[0x5211] = 0x89b3;
	__map_gbk2utf16[0x5212] = 0x89b4;
	__map_gbk2utf16[0x5213] = 0x89b5;
	__map_gbk2utf16[0x5214] = 0x89b6;
	__map_gbk2utf16[0x5215] = 0x89b7;
	__map_gbk2utf16[0x5216] = 0x89b8;
	__map_gbk2utf16[0x5217] = 0x89b9;
	__map_gbk2utf16[0x5218] = 0x89ba;
	__map_gbk2utf16[0x5219] = 0x89bb;
	__map_gbk2utf16[0x521a] = 0x89bc;
	__map_gbk2utf16[0x521b] = 0x89bd;
	__map_gbk2utf16[0x521c] = 0x89be;
	__map_gbk2utf16[0x521d] = 0x89bf;
	__map_gbk2utf16[0x521e] = 0x89c0;
	__map_gbk2utf16[0x521f] = 0x89c3;
	__map_gbk2utf16[0x5220] = 0x89cd;
	__map_gbk2utf16[0x5221] = 0x89d3;
	__map_gbk2utf16[0x5222] = 0x89d4;
	__map_gbk2utf16[0x5223] = 0x89d5;
	__map_gbk2utf16[0x5224] = 0x89d7;
	__map_gbk2utf16[0x5225] = 0x89d8;
	__map_gbk2utf16[0x5226] = 0x89d9;
	__map_gbk2utf16[0x5227] = 0x89db;
	__map_gbk2utf16[0x5228] = 0x89dd;
	__map_gbk2utf16[0x5229] = 0x89df;
	__map_gbk2utf16[0x522a] = 0x89e0;
	__map_gbk2utf16[0x522b] = 0x89e1;
	__map_gbk2utf16[0x522c] = 0x89e2;
	__map_gbk2utf16[0x522d] = 0x89e4;
	__map_gbk2utf16[0x522e] = 0x89e7;
	__map_gbk2utf16[0x522f] = 0x89e8;
	__map_gbk2utf16[0x5230] = 0x89e9;
	__map_gbk2utf16[0x5231] = 0x89ea;
	__map_gbk2utf16[0x5232] = 0x89ec;
	__map_gbk2utf16[0x5233] = 0x89ed;
	__map_gbk2utf16[0x5234] = 0x89ee;
	__map_gbk2utf16[0x5235] = 0x89f0;
	__map_gbk2utf16[0x5236] = 0x89f1;
	__map_gbk2utf16[0x5237] = 0x89f2;
	__map_gbk2utf16[0x5238] = 0x89f4;
	__map_gbk2utf16[0x5239] = 0x89f5;
	__map_gbk2utf16[0x523a] = 0x89f6;
	__map_gbk2utf16[0x523b] = 0x89f7;
	__map_gbk2utf16[0x523c] = 0x89f8;
	__map_gbk2utf16[0x523d] = 0x89f9;
	__map_gbk2utf16[0x523e] = 0x89fa;
	__map_gbk2utf16[0x5240] = 0x89fb;
	__map_gbk2utf16[0x5241] = 0x89fc;
	__map_gbk2utf16[0x5242] = 0x89fd;
	__map_gbk2utf16[0x5243] = 0x89fe;
	__map_gbk2utf16[0x5244] = 0x89ff;
	__map_gbk2utf16[0x5245] = 0x8a01;
	__map_gbk2utf16[0x5246] = 0x8a02;
	__map_gbk2utf16[0x5247] = 0x8a03;
	__map_gbk2utf16[0x5248] = 0x8a04;
	__map_gbk2utf16[0x5249] = 0x8a05;
	__map_gbk2utf16[0x524a] = 0x8a06;
	__map_gbk2utf16[0x524b] = 0x8a08;
	__map_gbk2utf16[0x524c] = 0x8a09;
	__map_gbk2utf16[0x524d] = 0x8a0a;
	__map_gbk2utf16[0x524e] = 0x8a0b;
	__map_gbk2utf16[0x524f] = 0x8a0c;
	__map_gbk2utf16[0x5250] = 0x8a0d;
	__map_gbk2utf16[0x5251] = 0x8a0e;
	__map_gbk2utf16[0x5252] = 0x8a0f;
	__map_gbk2utf16[0x5253] = 0x8a10;
	__map_gbk2utf16[0x5254] = 0x8a11;
	__map_gbk2utf16[0x5255] = 0x8a12;
	__map_gbk2utf16[0x5256] = 0x8a13;
	__map_gbk2utf16[0x5257] = 0x8a14;
	__map_gbk2utf16[0x5258] = 0x8a15;
	__map_gbk2utf16[0x5259] = 0x8a16;
	__map_gbk2utf16[0x525a] = 0x8a17;
	__map_gbk2utf16[0x525b] = 0x8a18;
	__map_gbk2utf16[0x525c] = 0x8a19;
	__map_gbk2utf16[0x525d] = 0x8a1a;
	__map_gbk2utf16[0x525e] = 0x8a1b;
	__map_gbk2utf16[0x525f] = 0x8a1c;
	__map_gbk2utf16[0x5260] = 0x8a1d;
	__map_gbk2utf16[0x5261] = 0x5370;
	__map_gbk2utf16[0x5262] = 0x82f1;
	__map_gbk2utf16[0x5263] = 0x6a31;
	__map_gbk2utf16[0x5264] = 0x5a74;
	__map_gbk2utf16[0x5265] = 0x9e70;
	__map_gbk2utf16[0x5266] = 0x5e94;
	__map_gbk2utf16[0x5267] = 0x7f28;
	__map_gbk2utf16[0x5268] = 0x83b9;
	__map_gbk2utf16[0x5269] = 0x8424;
	__map_gbk2utf16[0x526a] = 0x8425;
	__map_gbk2utf16[0x526b] = 0x8367;
	__map_gbk2utf16[0x526c] = 0x8747;
	__map_gbk2utf16[0x526d] = 0x8fce;
	__map_gbk2utf16[0x526e] = 0x8d62;
	__map_gbk2utf16[0x526f] = 0x76c8;
	__map_gbk2utf16[0x5270] = 0x5f71;
	__map_gbk2utf16[0x5271] = 0x9896;
	__map_gbk2utf16[0x5272] = 0x786c;
	__map_gbk2utf16[0x5273] = 0x6620;
	__map_gbk2utf16[0x5274] = 0x54df;
	__map_gbk2utf16[0x5275] = 0x62e5;
	__map_gbk2utf16[0x5276] = 0x4f63;
	__map_gbk2utf16[0x5277] = 0x81c3;
	__map_gbk2utf16[0x5278] = 0x75c8;
	__map_gbk2utf16[0x5279] = 0x5eb8;
	__map_gbk2utf16[0x527a] = 0x96cd;
	__map_gbk2utf16[0x527b] = 0x8e0a;
	__map_gbk2utf16[0x527c] = 0x86f9;
	__map_gbk2utf16[0x527d] = 0x548f;
	__map_gbk2utf16[0x527e] = 0x6cf3;
	__map_gbk2utf16[0x527f] = 0x6d8c;
	__map_gbk2utf16[0x5280] = 0x6c38;
	__map_gbk2utf16[0x5281] = 0x607f;
	__map_gbk2utf16[0x5282] = 0x52c7;
	__map_gbk2utf16[0x5283] = 0x7528;
	__map_gbk2utf16[0x5284] = 0x5e7d;
	__map_gbk2utf16[0x5285] = 0x4f18;
	__map_gbk2utf16[0x5286] = 0x60a0;
	__map_gbk2utf16[0x5287] = 0x5fe7;
	__map_gbk2utf16[0x5288] = 0x5c24;
	__map_gbk2utf16[0x5289] = 0x7531;
	__map_gbk2utf16[0x528a] = 0x90ae;
	__map_gbk2utf16[0x528b] = 0x94c0;
	__map_gbk2utf16[0x528c] = 0x72b9;
	__map_gbk2utf16[0x528d] = 0x6cb9;
	__map_gbk2utf16[0x528e] = 0x6e38;
	__map_gbk2utf16[0x528f] = 0x9149;
	__map_gbk2utf16[0x5290] = 0x6709;
	__map_gbk2utf16[0x5291] = 0x53cb;
	__map_gbk2utf16[0x5292] = 0x53f3;
	__map_gbk2utf16[0x5293] = 0x4f51;
	__map_gbk2utf16[0x5294] = 0x91c9;
	__map_gbk2utf16[0x5295] = 0x8bf1;
	__map_gbk2utf16[0x5296] = 0x53c8;
	__map_gbk2utf16[0x5297] = 0x5e7c;
	__map_gbk2utf16[0x5298] = 0x8fc2;
	__map_gbk2utf16[0x5299] = 0x6de4;
	__map_gbk2utf16[0x529a] = 0x4e8e;
	__map_gbk2utf16[0x529b] = 0x76c2;
	__map_gbk2utf16[0x529c] = 0x6986;
	__map_gbk2utf16[0x529d] = 0x865e;
	__map_gbk2utf16[0x529e] = 0x611a;
	__map_gbk2utf16[0x529f] = 0x8206;
	__map_gbk2utf16[0x52a0] = 0x4f59;
	__map_gbk2utf16[0x52a1] = 0x4fde;
	__map_gbk2utf16[0x52a2] = 0x903e;
	__map_gbk2utf16[0x52a3] = 0x9c7c;
	__map_gbk2utf16[0x52a4] = 0x6109;
	__map_gbk2utf16[0x52a5] = 0x6e1d;
	__map_gbk2utf16[0x52a6] = 0x6e14;
	__map_gbk2utf16[0x52a7] = 0x9685;
	__map_gbk2utf16[0x52a8] = 0x4e88;
	__map_gbk2utf16[0x52a9] = 0x5a31;
	__map_gbk2utf16[0x52aa] = 0x96e8;
	__map_gbk2utf16[0x52ab] = 0x4e0e;
	__map_gbk2utf16[0x52ac] = 0x5c7f;
	__map_gbk2utf16[0x52ad] = 0x79b9;
	__map_gbk2utf16[0x52ae] = 0x5b87;
	__map_gbk2utf16[0x52af] = 0x8bed;
	__map_gbk2utf16[0x52b0] = 0x7fbd;
	__map_gbk2utf16[0x52b1] = 0x7389;
	__map_gbk2utf16[0x52b2] = 0x57df;
	__map_gbk2utf16[0x52b3] = 0x828b;
	__map_gbk2utf16[0x52b4] = 0x90c1;
	__map_gbk2utf16[0x52b5] = 0x5401;
	__map_gbk2utf16[0x52b6] = 0x9047;
	__map_gbk2utf16[0x52b7] = 0x55bb;
	__map_gbk2utf16[0x52b8] = 0x5cea;
	__map_gbk2utf16[0x52b9] = 0x5fa1;
	__map_gbk2utf16[0x52ba] = 0x6108;
	__map_gbk2utf16[0x52bb] = 0x6b32;
	__map_gbk2utf16[0x52bc] = 0x72f1;
	__map_gbk2utf16[0x52bd] = 0x80b2;
	__map_gbk2utf16[0x52be] = 0x8a89;
	__map_gbk2utf16[0x5300] = 0x8a1e;
	__map_gbk2utf16[0x5301] = 0x8a1f;
	__map_gbk2utf16[0x5302] = 0x8a20;
	__map_gbk2utf16[0x5303] = 0x8a21;
	__map_gbk2utf16[0x5304] = 0x8a22;
	__map_gbk2utf16[0x5305] = 0x8a23;
	__map_gbk2utf16[0x5306] = 0x8a24;
	__map_gbk2utf16[0x5307] = 0x8a25;
	__map_gbk2utf16[0x5308] = 0x8a26;
	__map_gbk2utf16[0x5309] = 0x8a27;
	__map_gbk2utf16[0x530a] = 0x8a28;
	__map_gbk2utf16[0x530b] = 0x8a29;
	__map_gbk2utf16[0x530c] = 0x8a2a;
	__map_gbk2utf16[0x530d] = 0x8a2b;
	__map_gbk2utf16[0x530e] = 0x8a2c;
	__map_gbk2utf16[0x530f] = 0x8a2d;
	__map_gbk2utf16[0x5310] = 0x8a2e;
	__map_gbk2utf16[0x5311] = 0x8a2f;
	__map_gbk2utf16[0x5312] = 0x8a30;
	__map_gbk2utf16[0x5313] = 0x8a31;
	__map_gbk2utf16[0x5314] = 0x8a32;
	__map_gbk2utf16[0x5315] = 0x8a33;
	__map_gbk2utf16[0x5316] = 0x8a34;
	__map_gbk2utf16[0x5317] = 0x8a35;
	__map_gbk2utf16[0x5318] = 0x8a36;
	__map_gbk2utf16[0x5319] = 0x8a37;
	__map_gbk2utf16[0x531a] = 0x8a38;
	__map_gbk2utf16[0x531b] = 0x8a39;
	__map_gbk2utf16[0x531c] = 0x8a3a;
	__map_gbk2utf16[0x531d] = 0x8a3b;
	__map_gbk2utf16[0x531e] = 0x8a3c;
	__map_gbk2utf16[0x531f] = 0x8a3d;
	__map_gbk2utf16[0x5320] = 0x8a3f;
	__map_gbk2utf16[0x5321] = 0x8a40;
	__map_gbk2utf16[0x5322] = 0x8a41;
	__map_gbk2utf16[0x5323] = 0x8a42;
	__map_gbk2utf16[0x5324] = 0x8a43;
	__map_gbk2utf16[0x5325] = 0x8a44;
	__map_gbk2utf16[0x5326] = 0x8a45;
	__map_gbk2utf16[0x5327] = 0x8a46;
	__map_gbk2utf16[0x5328] = 0x8a47;
	__map_gbk2utf16[0x5329] = 0x8a49;
	__map_gbk2utf16[0x532a] = 0x8a4a;
	__map_gbk2utf16[0x532b] = 0x8a4b;
	__map_gbk2utf16[0x532c] = 0x8a4c;
	__map_gbk2utf16[0x532d] = 0x8a4d;
	__map_gbk2utf16[0x532e] = 0x8a4e;
	__map_gbk2utf16[0x532f] = 0x8a4f;
	__map_gbk2utf16[0x5330] = 0x8a50;
	__map_gbk2utf16[0x5331] = 0x8a51;
	__map_gbk2utf16[0x5332] = 0x8a52;
	__map_gbk2utf16[0x5333] = 0x8a53;
	__map_gbk2utf16[0x5334] = 0x8a54;
	__map_gbk2utf16[0x5335] = 0x8a55;
	__map_gbk2utf16[0x5336] = 0x8a56;
	__map_gbk2utf16[0x5337] = 0x8a57;
	__map_gbk2utf16[0x5338] = 0x8a58;
	__map_gbk2utf16[0x5339] = 0x8a59;
	__map_gbk2utf16[0x533a] = 0x8a5a;
	__map_gbk2utf16[0x533b] = 0x8a5b;
	__map_gbk2utf16[0x533c] = 0x8a5c;
	__map_gbk2utf16[0x533d] = 0x8a5d;
	__map_gbk2utf16[0x533e] = 0x8a5e;
	__map_gbk2utf16[0x5340] = 0x8a5f;
	__map_gbk2utf16[0x5341] = 0x8a60;
	__map_gbk2utf16[0x5342] = 0x8a61;
	__map_gbk2utf16[0x5343] = 0x8a62;
	__map_gbk2utf16[0x5344] = 0x8a63;
	__map_gbk2utf16[0x5345] = 0x8a64;
	__map_gbk2utf16[0x5346] = 0x8a65;
	__map_gbk2utf16[0x5347] = 0x8a66;
	__map_gbk2utf16[0x5348] = 0x8a67;
	__map_gbk2utf16[0x5349] = 0x8a68;
	__map_gbk2utf16[0x534a] = 0x8a69;
	__map_gbk2utf16[0x534b] = 0x8a6a;
	__map_gbk2utf16[0x534c] = 0x8a6b;
	__map_gbk2utf16[0x534d] = 0x8a6c;
	__map_gbk2utf16[0x534e] = 0x8a6d;
	__map_gbk2utf16[0x534f] = 0x8a6e;
	__map_gbk2utf16[0x5350] = 0x8a6f;
	__map_gbk2utf16[0x5351] = 0x8a70;
	__map_gbk2utf16[0x5352] = 0x8a71;
	__map_gbk2utf16[0x5353] = 0x8a72;
	__map_gbk2utf16[0x5354] = 0x8a73;
	__map_gbk2utf16[0x5355] = 0x8a74;
	__map_gbk2utf16[0x5356] = 0x8a75;
	__map_gbk2utf16[0x5357] = 0x8a76;
	__map_gbk2utf16[0x5358] = 0x8a77;
	__map_gbk2utf16[0x5359] = 0x8a78;
	__map_gbk2utf16[0x535a] = 0x8a7a;
	__map_gbk2utf16[0x535b] = 0x8a7b;
	__map_gbk2utf16[0x535c] = 0x8a7c;
	__map_gbk2utf16[0x535d] = 0x8a7d;
	__map_gbk2utf16[0x535e] = 0x8a7e;
	__map_gbk2utf16[0x535f] = 0x8a7f;
	__map_gbk2utf16[0x5360] = 0x8a80;
	__map_gbk2utf16[0x5361] = 0x6d74;
	__map_gbk2utf16[0x5362] = 0x5bd3;
	__map_gbk2utf16[0x5363] = 0x88d5;
	__map_gbk2utf16[0x5364] = 0x9884;
	__map_gbk2utf16[0x5365] = 0x8c6b;
	__map_gbk2utf16[0x5366] = 0x9a6d;
	__map_gbk2utf16[0x5367] = 0x9e33;
	__map_gbk2utf16[0x5368] = 0x6e0a;
	__map_gbk2utf16[0x5369] = 0x51a4;
	__map_gbk2utf16[0x536a] = 0x5143;
	__map_gbk2utf16[0x536b] = 0x57a3;
	__map_gbk2utf16[0x536c] = 0x8881;
	__map_gbk2utf16[0x536d] = 0x539f;
	__map_gbk2utf16[0x536e] = 0x63f4;
	__map_gbk2utf16[0x536f] = 0x8f95;
	__map_gbk2utf16[0x5370] = 0x56ed;
	__map_gbk2utf16[0x5371] = 0x5458;
	__map_gbk2utf16[0x5372] = 0x5706;
	__map_gbk2utf16[0x5373] = 0x733f;
	__map_gbk2utf16[0x5374] = 0x6e90;
	__map_gbk2utf16[0x5375] = 0x7f18;
	__map_gbk2utf16[0x5376] = 0x8fdc;
	__map_gbk2utf16[0x5377] = 0x82d1;
	__map_gbk2utf16[0x5378] = 0x613f;
	__map_gbk2utf16[0x5379] = 0x6028;
	__map_gbk2utf16[0x537a] = 0x9662;
	__map_gbk2utf16[0x537b] = 0x66f0;
	__map_gbk2utf16[0x537c] = 0x7ea6;
	__map_gbk2utf16[0x537d] = 0x8d8a;
	__map_gbk2utf16[0x537e] = 0x8dc3;
	__map_gbk2utf16[0x537f] = 0x94a5;
	__map_gbk2utf16[0x5380] = 0x5cb3;
	__map_gbk2utf16[0x5381] = 0x7ca4;
	__map_gbk2utf16[0x5382] = 0x6708;
	__map_gbk2utf16[0x5383] = 0x60a6;
	__map_gbk2utf16[0x5384] = 0x9605;
	__map_gbk2utf16[0x5385] = 0x8018;
	__map_gbk2utf16[0x5386] = 0x4e91;
	__map_gbk2utf16[0x5387] = 0x90e7;
	__map_gbk2utf16[0x5388] = 0x5300;
	__map_gbk2utf16[0x5389] = 0x9668;
	__map_gbk2utf16[0x538a] = 0x5141;
	__map_gbk2utf16[0x538b] = 0x8fd0;
	__map_gbk2utf16[0x538c] = 0x8574;
	__map_gbk2utf16[0x538d] = 0x915d;
	__map_gbk2utf16[0x538e] = 0x6655;
	__map_gbk2utf16[0x538f] = 0x97f5;
	__map_gbk2utf16[0x5390] = 0x5b55;
	__map_gbk2utf16[0x5391] = 0x531d;
	__map_gbk2utf16[0x5392] = 0x7838;
	__map_gbk2utf16[0x5393] = 0x6742;
	__map_gbk2utf16[0x5394] = 0x683d;
	__map_gbk2utf16[0x5395] = 0x54c9;
	__map_gbk2utf16[0x5396] = 0x707e;
	__map_gbk2utf16[0x5397] = 0x5bb0;
	__map_gbk2utf16[0x5398] = 0x8f7d;
	__map_gbk2utf16[0x5399] = 0x518d;
	__map_gbk2utf16[0x539a] = 0x5728;
	__map_gbk2utf16[0x539b] = 0x54b1;
	__map_gbk2utf16[0x539c] = 0x6512;
	__map_gbk2utf16[0x539d] = 0x6682;
	__map_gbk2utf16[0x539e] = 0x8d5e;
	__map_gbk2utf16[0x539f] = 0x8d43;
	__map_gbk2utf16[0x53a0] = 0x810f;
	__map_gbk2utf16[0x53a1] = 0x846c;
	__map_gbk2utf16[0x53a2] = 0x906d;
	__map_gbk2utf16[0x53a3] = 0x7cdf;
	__map_gbk2utf16[0x53a4] = 0x51ff;
	__map_gbk2utf16[0x53a5] = 0x85fb;
	__map_gbk2utf16[0x53a6] = 0x67a3;
	__map_gbk2utf16[0x53a7] = 0x65e9;
	__map_gbk2utf16[0x53a8] = 0x6fa1;
	__map_gbk2utf16[0x53a9] = 0x86a4;
	__map_gbk2utf16[0x53aa] = 0x8e81;
	__map_gbk2utf16[0x53ab] = 0x566a;
	__map_gbk2utf16[0x53ac] = 0x9020;
	__map_gbk2utf16[0x53ad] = 0x7682;
	__map_gbk2utf16[0x53ae] = 0x7076;
	__map_gbk2utf16[0x53af] = 0x71e5;
	__map_gbk2utf16[0x53b0] = 0x8d23;
	__map_gbk2utf16[0x53b1] = 0x62e9;
	__map_gbk2utf16[0x53b2] = 0x5219;
	__map_gbk2utf16[0x53b3] = 0x6cfd;
	__map_gbk2utf16[0x53b4] = 0x8d3c;
	__map_gbk2utf16[0x53b5] = 0x600e;
	__map_gbk2utf16[0x53b6] = 0x589e;
	__map_gbk2utf16[0x53b7] = 0x618e;
	__map_gbk2utf16[0x53b8] = 0x66fe;
	__map_gbk2utf16[0x53b9] = 0x8d60;
	__map_gbk2utf16[0x53ba] = 0x624e;
	__map_gbk2utf16[0x53bb] = 0x55b3;
	__map_gbk2utf16[0x53bc] = 0x6e23;
	__map_gbk2utf16[0x53bd] = 0x672d;
	__map_gbk2utf16[0x53be] = 0x8f67;
	__map_gbk2utf16[0x5400] = 0x8a81;
	__map_gbk2utf16[0x5401] = 0x8a82;
	__map_gbk2utf16[0x5402] = 0x8a83;
	__map_gbk2utf16[0x5403] = 0x8a84;
	__map_gbk2utf16[0x5404] = 0x8a85;
	__map_gbk2utf16[0x5405] = 0x8a86;
	__map_gbk2utf16[0x5406] = 0x8a87;
	__map_gbk2utf16[0x5407] = 0x8a88;
	__map_gbk2utf16[0x5408] = 0x8a8b;
	__map_gbk2utf16[0x5409] = 0x8a8c;
	__map_gbk2utf16[0x540a] = 0x8a8d;
	__map_gbk2utf16[0x540b] = 0x8a8e;
	__map_gbk2utf16[0x540c] = 0x8a8f;
	__map_gbk2utf16[0x540d] = 0x8a90;
	__map_gbk2utf16[0x540e] = 0x8a91;
	__map_gbk2utf16[0x540f] = 0x8a92;
	__map_gbk2utf16[0x5410] = 0x8a94;
	__map_gbk2utf16[0x5411] = 0x8a95;
	__map_gbk2utf16[0x5412] = 0x8a96;
	__map_gbk2utf16[0x5413] = 0x8a97;
	__map_gbk2utf16[0x5414] = 0x8a98;
	__map_gbk2utf16[0x5415] = 0x8a99;
	__map_gbk2utf16[0x5416] = 0x8a9a;
	__map_gbk2utf16[0x5417] = 0x8a9b;
	__map_gbk2utf16[0x5418] = 0x8a9c;
	__map_gbk2utf16[0x5419] = 0x8a9d;
	__map_gbk2utf16[0x541a] = 0x8a9e;
	__map_gbk2utf16[0x541b] = 0x8a9f;
	__map_gbk2utf16[0x541c] = 0x8aa0;
	__map_gbk2utf16[0x541d] = 0x8aa1;
	__map_gbk2utf16[0x541e] = 0x8aa2;
	__map_gbk2utf16[0x541f] = 0x8aa3;
	__map_gbk2utf16[0x5420] = 0x8aa4;
	__map_gbk2utf16[0x5421] = 0x8aa5;
	__map_gbk2utf16[0x5422] = 0x8aa6;
	__map_gbk2utf16[0x5423] = 0x8aa7;
	__map_gbk2utf16[0x5424] = 0x8aa8;
	__map_gbk2utf16[0x5425] = 0x8aa9;
	__map_gbk2utf16[0x5426] = 0x8aaa;
	__map_gbk2utf16[0x5427] = 0x8aab;
	__map_gbk2utf16[0x5428] = 0x8aac;
	__map_gbk2utf16[0x5429] = 0x8aad;
	__map_gbk2utf16[0x542a] = 0x8aae;
	__map_gbk2utf16[0x542b] = 0x8aaf;
	__map_gbk2utf16[0x542c] = 0x8ab0;
	__map_gbk2utf16[0x542d] = 0x8ab1;
	__map_gbk2utf16[0x542e] = 0x8ab2;
	__map_gbk2utf16[0x542f] = 0x8ab3;
	__map_gbk2utf16[0x5430] = 0x8ab4;
	__map_gbk2utf16[0x5431] = 0x8ab5;
	__map_gbk2utf16[0x5432] = 0x8ab6;
	__map_gbk2utf16[0x5433] = 0x8ab7;
	__map_gbk2utf16[0x5434] = 0x8ab8;
	__map_gbk2utf16[0x5435] = 0x8ab9;
	__map_gbk2utf16[0x5436] = 0x8aba;
	__map_gbk2utf16[0x5437] = 0x8abb;
	__map_gbk2utf16[0x5438] = 0x8abc;
	__map_gbk2utf16[0x5439] = 0x8abd;
	__map_gbk2utf16[0x543a] = 0x8abe;
	__map_gbk2utf16[0x543b] = 0x8abf;
	__map_gbk2utf16[0x543c] = 0x8ac0;
	__map_gbk2utf16[0x543d] = 0x8ac1;
	__map_gbk2utf16[0x543e] = 0x8ac2;
	__map_gbk2utf16[0x5440] = 0x8ac3;
	__map_gbk2utf16[0x5441] = 0x8ac4;
	__map_gbk2utf16[0x5442] = 0x8ac5;
	__map_gbk2utf16[0x5443] = 0x8ac6;
	__map_gbk2utf16[0x5444] = 0x8ac7;
	__map_gbk2utf16[0x5445] = 0x8ac8;
	__map_gbk2utf16[0x5446] = 0x8ac9;
	__map_gbk2utf16[0x5447] = 0x8aca;
	__map_gbk2utf16[0x5448] = 0x8acb;
	__map_gbk2utf16[0x5449] = 0x8acc;
	__map_gbk2utf16[0x544a] = 0x8acd;
	__map_gbk2utf16[0x544b] = 0x8ace;
	__map_gbk2utf16[0x544c] = 0x8acf;
	__map_gbk2utf16[0x544d] = 0x8ad0;
	__map_gbk2utf16[0x544e] = 0x8ad1;
	__map_gbk2utf16[0x544f] = 0x8ad2;
	__map_gbk2utf16[0x5450] = 0x8ad3;
	__map_gbk2utf16[0x5451] = 0x8ad4;
	__map_gbk2utf16[0x5452] = 0x8ad5;
	__map_gbk2utf16[0x5453] = 0x8ad6;
	__map_gbk2utf16[0x5454] = 0x8ad7;
	__map_gbk2utf16[0x5455] = 0x8ad8;
	__map_gbk2utf16[0x5456] = 0x8ad9;
	__map_gbk2utf16[0x5457] = 0x8ada;
	__map_gbk2utf16[0x5458] = 0x8adb;
	__map_gbk2utf16[0x5459] = 0x8adc;
	__map_gbk2utf16[0x545a] = 0x8add;
	__map_gbk2utf16[0x545b] = 0x8ade;
	__map_gbk2utf16[0x545c] = 0x8adf;
	__map_gbk2utf16[0x545d] = 0x8ae0;
	__map_gbk2utf16[0x545e] = 0x8ae1;
	__map_gbk2utf16[0x545f] = 0x8ae2;
	__map_gbk2utf16[0x5460] = 0x8ae3;
	__map_gbk2utf16[0x5461] = 0x94e1;
	__map_gbk2utf16[0x5462] = 0x95f8;
	__map_gbk2utf16[0x5463] = 0x7728;
	__map_gbk2utf16[0x5464] = 0x6805;
	__map_gbk2utf16[0x5465] = 0x69a8;
	__map_gbk2utf16[0x5466] = 0x548b;
	__map_gbk2utf16[0x5467] = 0x4e4d;
	__map_gbk2utf16[0x5468] = 0x70b8;
	__map_gbk2utf16[0x5469] = 0x8bc8;
	__map_gbk2utf16[0x546a] = 0x6458;
	__map_gbk2utf16[0x546b] = 0x658b;
	__map_gbk2utf16[0x546c] = 0x5b85;
	__map_gbk2utf16[0x546d] = 0x7a84;
	__map_gbk2utf16[0x546e] = 0x503a;
	__map_gbk2utf16[0x546f] = 0x5be8;
	__map_gbk2utf16[0x5470] = 0x77bb;
	__map_gbk2utf16[0x5471] = 0x6be1;
	__map_gbk2utf16[0x5472] = 0x8a79;
	__map_gbk2utf16[0x5473] = 0x7c98;
	__map_gbk2utf16[0x5474] = 0x6cbe;
	__map_gbk2utf16[0x5475] = 0x76cf;
	__map_gbk2utf16[0x5476] = 0x65a9;
	__map_gbk2utf16[0x5477] = 0x8f97;
	__map_gbk2utf16[0x5478] = 0x5d2d;
	__map_gbk2utf16[0x5479] = 0x5c55;
	__map_gbk2utf16[0x547a] = 0x8638;
	__map_gbk2utf16[0x547b] = 0x6808;
	__map_gbk2utf16[0x547c] = 0x5360;
	__map_gbk2utf16[0x547d] = 0x6218;
	__map_gbk2utf16[0x547e] = 0x7ad9;
	__map_gbk2utf16[0x547f] = 0x6e5b;
	__map_gbk2utf16[0x5480] = 0x7efd;
	__map_gbk2utf16[0x5481] = 0x6a1f;
	__map_gbk2utf16[0x5482] = 0x7ae0;
	__map_gbk2utf16[0x5483] = 0x5f70;
	__map_gbk2utf16[0x5484] = 0x6f33;
	__map_gbk2utf16[0x5485] = 0x5f20;
	__map_gbk2utf16[0x5486] = 0x638c;
	__map_gbk2utf16[0x5487] = 0x6da8;
	__map_gbk2utf16[0x5488] = 0x6756;
	__map_gbk2utf16[0x5489] = 0x4e08;
	__map_gbk2utf16[0x548a] = 0x5e10;
	__map_gbk2utf16[0x548b] = 0x8d26;
	__map_gbk2utf16[0x548c] = 0x4ed7;
	__map_gbk2utf16[0x548d] = 0x80c0;
	__map_gbk2utf16[0x548e] = 0x7634;
	__map_gbk2utf16[0x548f] = 0x969c;
	__map_gbk2utf16[0x5490] = 0x62db;
	__map_gbk2utf16[0x5491] = 0x662d;
	__map_gbk2utf16[0x5492] = 0x627e;
	__map_gbk2utf16[0x5493] = 0x6cbc;
	__map_gbk2utf16[0x5494] = 0x8d75;
	__map_gbk2utf16[0x5495] = 0x7167;
	__map_gbk2utf16[0x5496] = 0x7f69;
	__map_gbk2utf16[0x5497] = 0x5146;
	__map_gbk2utf16[0x5498] = 0x8087;
	__map_gbk2utf16[0x5499] = 0x53ec;
	__map_gbk2utf16[0x549a] = 0x906e;
	__map_gbk2utf16[0x549b] = 0x6298;
	__map_gbk2utf16[0x549c] = 0x54f2;
	__map_gbk2utf16[0x549d] = 0x86f0;
	__map_gbk2utf16[0x549e] = 0x8f99;
	__map_gbk2utf16[0x549f] = 0x8005;
	__map_gbk2utf16[0x54a0] = 0x9517;
	__map_gbk2utf16[0x54a1] = 0x8517;
	__map_gbk2utf16[0x54a2] = 0x8fd9;
	__map_gbk2utf16[0x54a3] = 0x6d59;
	__map_gbk2utf16[0x54a4] = 0x73cd;
	__map_gbk2utf16[0x54a5] = 0x659f;
	__map_gbk2utf16[0x54a6] = 0x771f;
	__map_gbk2utf16[0x54a7] = 0x7504;
	__map_gbk2utf16[0x54a8] = 0x7827;
	__map_gbk2utf16[0x54a9] = 0x81fb;
	__map_gbk2utf16[0x54aa] = 0x8d1e;
	__map_gbk2utf16[0x54ab] = 0x9488;
	__map_gbk2utf16[0x54ac] = 0x4fa6;
	__map_gbk2utf16[0x54ad] = 0x6795;
	__map_gbk2utf16[0x54ae] = 0x75b9;
	__map_gbk2utf16[0x54af] = 0x8bca;
	__map_gbk2utf16[0x54b0] = 0x9707;
	__map_gbk2utf16[0x54b1] = 0x632f;
	__map_gbk2utf16[0x54b2] = 0x9547;
	__map_gbk2utf16[0x54b3] = 0x9635;
	__map_gbk2utf16[0x54b4] = 0x84b8;
	__map_gbk2utf16[0x54b5] = 0x6323;
	__map_gbk2utf16[0x54b6] = 0x7741;
	__map_gbk2utf16[0x54b7] = 0x5f81;
	__map_gbk2utf16[0x54b8] = 0x72f0;
	__map_gbk2utf16[0x54b9] = 0x4e89;
	__map_gbk2utf16[0x54ba] = 0x6014;
	__map_gbk2utf16[0x54bb] = 0x6574;
	__map_gbk2utf16[0x54bc] = 0x62ef;
	__map_gbk2utf16[0x54bd] = 0x6b63;
	__map_gbk2utf16[0x54be] = 0x653f;
	__map_gbk2utf16[0x5500] = 0x8ae4;
	__map_gbk2utf16[0x5501] = 0x8ae5;
	__map_gbk2utf16[0x5502] = 0x8ae6;
	__map_gbk2utf16[0x5503] = 0x8ae7;
	__map_gbk2utf16[0x5504] = 0x8ae8;
	__map_gbk2utf16[0x5505] = 0x8ae9;
	__map_gbk2utf16[0x5506] = 0x8aea;
	__map_gbk2utf16[0x5507] = 0x8aeb;
	__map_gbk2utf16[0x5508] = 0x8aec;
	__map_gbk2utf16[0x5509] = 0x8aed;
	__map_gbk2utf16[0x550a] = 0x8aee;
	__map_gbk2utf16[0x550b] = 0x8aef;
	__map_gbk2utf16[0x550c] = 0x8af0;
	__map_gbk2utf16[0x550d] = 0x8af1;
	__map_gbk2utf16[0x550e] = 0x8af2;
	__map_gbk2utf16[0x550f] = 0x8af3;
	__map_gbk2utf16[0x5510] = 0x8af4;
	__map_gbk2utf16[0x5511] = 0x8af5;
	__map_gbk2utf16[0x5512] = 0x8af6;
	__map_gbk2utf16[0x5513] = 0x8af7;
	__map_gbk2utf16[0x5514] = 0x8af8;
	__map_gbk2utf16[0x5515] = 0x8af9;
	__map_gbk2utf16[0x5516] = 0x8afa;
	__map_gbk2utf16[0x5517] = 0x8afb;
	__map_gbk2utf16[0x5518] = 0x8afc;
	__map_gbk2utf16[0x5519] = 0x8afd;
	__map_gbk2utf16[0x551a] = 0x8afe;
	__map_gbk2utf16[0x551b] = 0x8aff;
	__map_gbk2utf16[0x551c] = 0x8b00;
	__map_gbk2utf16[0x551d] = 0x8b01;
	__map_gbk2utf16[0x551e] = 0x8b02;
	__map_gbk2utf16[0x551f] = 0x8b03;
	__map_gbk2utf16[0x5520] = 0x8b04;
	__map_gbk2utf16[0x5521] = 0x8b05;
	__map_gbk2utf16[0x5522] = 0x8b06;
	__map_gbk2utf16[0x5523] = 0x8b08;
	__map_gbk2utf16[0x5524] = 0x8b09;
	__map_gbk2utf16[0x5525] = 0x8b0a;
	__map_gbk2utf16[0x5526] = 0x8b0b;
	__map_gbk2utf16[0x5527] = 0x8b0c;
	__map_gbk2utf16[0x5528] = 0x8b0d;
	__map_gbk2utf16[0x5529] = 0x8b0e;
	__map_gbk2utf16[0x552a] = 0x8b0f;
	__map_gbk2utf16[0x552b] = 0x8b10;
	__map_gbk2utf16[0x552c] = 0x8b11;
	__map_gbk2utf16[0x552d] = 0x8b12;
	__map_gbk2utf16[0x552e] = 0x8b13;
	__map_gbk2utf16[0x552f] = 0x8b14;
	__map_gbk2utf16[0x5530] = 0x8b15;
	__map_gbk2utf16[0x5531] = 0x8b16;
	__map_gbk2utf16[0x5532] = 0x8b17;
	__map_gbk2utf16[0x5533] = 0x8b18;
	__map_gbk2utf16[0x5534] = 0x8b19;
	__map_gbk2utf16[0x5535] = 0x8b1a;
	__map_gbk2utf16[0x5536] = 0x8b1b;
	__map_gbk2utf16[0x5537] = 0x8b1c;
	__map_gbk2utf16[0x5538] = 0x8b1d;
	__map_gbk2utf16[0x5539] = 0x8b1e;
	__map_gbk2utf16[0x553a] = 0x8b1f;
	__map_gbk2utf16[0x553b] = 0x8b20;
	__map_gbk2utf16[0x553c] = 0x8b21;
	__map_gbk2utf16[0x553d] = 0x8b22;
	__map_gbk2utf16[0x553e] = 0x8b23;
	__map_gbk2utf16[0x5540] = 0x8b24;
	__map_gbk2utf16[0x5541] = 0x8b25;
	__map_gbk2utf16[0x5542] = 0x8b27;
	__map_gbk2utf16[0x5543] = 0x8b28;
	__map_gbk2utf16[0x5544] = 0x8b29;
	__map_gbk2utf16[0x5545] = 0x8b2a;
	__map_gbk2utf16[0x5546] = 0x8b2b;
	__map_gbk2utf16[0x5547] = 0x8b2c;
	__map_gbk2utf16[0x5548] = 0x8b2d;
	__map_gbk2utf16[0x5549] = 0x8b2e;
	__map_gbk2utf16[0x554a] = 0x8b2f;
	__map_gbk2utf16[0x554b] = 0x8b30;
	__map_gbk2utf16[0x554c] = 0x8b31;
	__map_gbk2utf16[0x554d] = 0x8b32;
	__map_gbk2utf16[0x554e] = 0x8b33;
	__map_gbk2utf16[0x554f] = 0x8b34;
	__map_gbk2utf16[0x5550] = 0x8b35;
	__map_gbk2utf16[0x5551] = 0x8b36;
	__map_gbk2utf16[0x5552] = 0x8b37;
	__map_gbk2utf16[0x5553] = 0x8b38;
	__map_gbk2utf16[0x5554] = 0x8b39;
	__map_gbk2utf16[0x5555] = 0x8b3a;
	__map_gbk2utf16[0x5556] = 0x8b3b;
	__map_gbk2utf16[0x5557] = 0x8b3c;
	__map_gbk2utf16[0x5558] = 0x8b3d;
	__map_gbk2utf16[0x5559] = 0x8b3e;
	__map_gbk2utf16[0x555a] = 0x8b3f;
	__map_gbk2utf16[0x555b] = 0x8b40;
	__map_gbk2utf16[0x555c] = 0x8b41;
	__map_gbk2utf16[0x555d] = 0x8b42;
	__map_gbk2utf16[0x555e] = 0x8b43;
	__map_gbk2utf16[0x555f] = 0x8b44;
	__map_gbk2utf16[0x5560] = 0x8b45;
	__map_gbk2utf16[0x5561] = 0x5e27;
	__map_gbk2utf16[0x5562] = 0x75c7;
	__map_gbk2utf16[0x5563] = 0x90d1;
	__map_gbk2utf16[0x5564] = 0x8bc1;
	__map_gbk2utf16[0x5565] = 0x829d;
	__map_gbk2utf16[0x5566] = 0x679d;
	__map_gbk2utf16[0x5567] = 0x652f;
	__map_gbk2utf16[0x5568] = 0x5431;
	__map_gbk2utf16[0x5569] = 0x8718;
	__map_gbk2utf16[0x556a] = 0x77e5;
	__map_gbk2utf16[0x556b] = 0x80a2;
	__map_gbk2utf16[0x556c] = 0x8102;
	__map_gbk2utf16[0x556d] = 0x6c41;
	__map_gbk2utf16[0x556e] = 0x4e4b;
	__map_gbk2utf16[0x556f] = 0x7ec7;
	__map_gbk2utf16[0x5570] = 0x804c;
	__map_gbk2utf16[0x5571] = 0x76f4;
	__map_gbk2utf16[0x5572] = 0x690d;
	__map_gbk2utf16[0x5573] = 0x6b96;
	__map_gbk2utf16[0x5574] = 0x6267;
	__map_gbk2utf16[0x5575] = 0x503c;
	__map_gbk2utf16[0x5576] = 0x4f84;
	__map_gbk2utf16[0x5577] = 0x5740;
	__map_gbk2utf16[0x5578] = 0x6307;
	__map_gbk2utf16[0x5579] = 0x6b62;
	__map_gbk2utf16[0x557a] = 0x8dbe;
	__map_gbk2utf16[0x557b] = 0x53ea;
	__map_gbk2utf16[0x557c] = 0x65e8;
	__map_gbk2utf16[0x557d] = 0x7eb8;
	__map_gbk2utf16[0x557e] = 0x5fd7;
	__map_gbk2utf16[0x557f] = 0x631a;
	__map_gbk2utf16[0x5580] = 0x63b7;
	__map_gbk2utf16[0x5581] = 0x81f3;
	__map_gbk2utf16[0x5582] = 0x81f4;
	__map_gbk2utf16[0x5583] = 0x7f6e;
	__map_gbk2utf16[0x5584] = 0x5e1c;
	__map_gbk2utf16[0x5585] = 0x5cd9;
	__map_gbk2utf16[0x5586] = 0x5236;
	__map_gbk2utf16[0x5587] = 0x667a;
	__map_gbk2utf16[0x5588] = 0x79e9;
	__map_gbk2utf16[0x5589] = 0x7a1a;
	__map_gbk2utf16[0x558a] = 0x8d28;
	__map_gbk2utf16[0x558b] = 0x7099;
	__map_gbk2utf16[0x558c] = 0x75d4;
	__map_gbk2utf16[0x558d] = 0x6ede;
	__map_gbk2utf16[0x558e] = 0x6cbb;
	__map_gbk2utf16[0x558f] = 0x7a92;
	__map_gbk2utf16[0x5590] = 0x4e2d;
	__map_gbk2utf16[0x5591] = 0x76c5;
	__map_gbk2utf16[0x5592] = 0x5fe0;
	__map_gbk2utf16[0x5593] = 0x949f;
	__map_gbk2utf16[0x5594] = 0x8877;
	__map_gbk2utf16[0x5595] = 0x7ec8;
	__map_gbk2utf16[0x5596] = 0x79cd;
	__map_gbk2utf16[0x5597] = 0x80bf;
	__map_gbk2utf16[0x5598] = 0x91cd;
	__map_gbk2utf16[0x5599] = 0x4ef2;
	__map_gbk2utf16[0x559a] = 0x4f17;
	__map_gbk2utf16[0x559b] = 0x821f;
	__map_gbk2utf16[0x559c] = 0x5468;
	__map_gbk2utf16[0x559d] = 0x5dde;
	__map_gbk2utf16[0x559e] = 0x6d32;
	__map_gbk2utf16[0x559f] = 0x8bcc;
	__map_gbk2utf16[0x55a0] = 0x7ca5;
	__map_gbk2utf16[0x55a1] = 0x8f74;
	__map_gbk2utf16[0x55a2] = 0x8098;
	__map_gbk2utf16[0x55a3] = 0x5e1a;
	__map_gbk2utf16[0x55a4] = 0x5492;
	__map_gbk2utf16[0x55a5] = 0x76b1;
	__map_gbk2utf16[0x55a6] = 0x5b99;
	__map_gbk2utf16[0x55a7] = 0x663c;
	__map_gbk2utf16[0x55a8] = 0x9aa4;
	__map_gbk2utf16[0x55a9] = 0x73e0;
	__map_gbk2utf16[0x55aa] = 0x682a;
	__map_gbk2utf16[0x55ab] = 0x86db;
	__map_gbk2utf16[0x55ac] = 0x6731;
	__map_gbk2utf16[0x55ad] = 0x732a;
	__map_gbk2utf16[0x55ae] = 0x8bf8;
	__map_gbk2utf16[0x55af] = 0x8bdb;
	__map_gbk2utf16[0x55b0] = 0x9010;
	__map_gbk2utf16[0x55b1] = 0x7af9;
	__map_gbk2utf16[0x55b2] = 0x70db;
	__map_gbk2utf16[0x55b3] = 0x716e;
	__map_gbk2utf16[0x55b4] = 0x62c4;
	__map_gbk2utf16[0x55b5] = 0x77a9;
	__map_gbk2utf16[0x55b6] = 0x5631;
	__map_gbk2utf16[0x55b7] = 0x4e3b;
	__map_gbk2utf16[0x55b8] = 0x8457;
	__map_gbk2utf16[0x55b9] = 0x67f1;
	__map_gbk2utf16[0x55ba] = 0x52a9;
	__map_gbk2utf16[0x55bb] = 0x86c0;
	__map_gbk2utf16[0x55bc] = 0x8d2e;
	__map_gbk2utf16[0x55bd] = 0x94f8;
	__map_gbk2utf16[0x55be] = 0x7b51;
	__map_gbk2utf16[0x5600] = 0x8b46;
	__map_gbk2utf16[0x5601] = 0x8b47;
	__map_gbk2utf16[0x5602] = 0x8b48;
	__map_gbk2utf16[0x5603] = 0x8b49;
	__map_gbk2utf16[0x5604] = 0x8b4a;
	__map_gbk2utf16[0x5605] = 0x8b4b;
	__map_gbk2utf16[0x5606] = 0x8b4c;
	__map_gbk2utf16[0x5607] = 0x8b4d;
	__map_gbk2utf16[0x5608] = 0x8b4e;
	__map_gbk2utf16[0x5609] = 0x8b4f;
	__map_gbk2utf16[0x560a] = 0x8b50;
	__map_gbk2utf16[0x560b] = 0x8b51;
	__map_gbk2utf16[0x560c] = 0x8b52;
	__map_gbk2utf16[0x560d] = 0x8b53;
	__map_gbk2utf16[0x560e] = 0x8b54;
	__map_gbk2utf16[0x560f] = 0x8b55;
	__map_gbk2utf16[0x5610] = 0x8b56;
	__map_gbk2utf16[0x5611] = 0x8b57;
	__map_gbk2utf16[0x5612] = 0x8b58;
	__map_gbk2utf16[0x5613] = 0x8b59;
	__map_gbk2utf16[0x5614] = 0x8b5a;
	__map_gbk2utf16[0x5615] = 0x8b5b;
	__map_gbk2utf16[0x5616] = 0x8b5c;
	__map_gbk2utf16[0x5617] = 0x8b5d;
	__map_gbk2utf16[0x5618] = 0x8b5e;
	__map_gbk2utf16[0x5619] = 0x8b5f;
	__map_gbk2utf16[0x561a] = 0x8b60;
	__map_gbk2utf16[0x561b] = 0x8b61;
	__map_gbk2utf16[0x561c] = 0x8b62;
	__map_gbk2utf16[0x561d] = 0x8b63;
	__map_gbk2utf16[0x561e] = 0x8b64;
	__map_gbk2utf16[0x561f] = 0x8b65;
	__map_gbk2utf16[0x5620] = 0x8b67;
	__map_gbk2utf16[0x5621] = 0x8b68;
	__map_gbk2utf16[0x5622] = 0x8b69;
	__map_gbk2utf16[0x5623] = 0x8b6a;
	__map_gbk2utf16[0x5624] = 0x8b6b;
	__map_gbk2utf16[0x5625] = 0x8b6d;
	__map_gbk2utf16[0x5626] = 0x8b6e;
	__map_gbk2utf16[0x5627] = 0x8b6f;
	__map_gbk2utf16[0x5628] = 0x8b70;
	__map_gbk2utf16[0x5629] = 0x8b71;
	__map_gbk2utf16[0x562a] = 0x8b72;
	__map_gbk2utf16[0x562b] = 0x8b73;
	__map_gbk2utf16[0x562c] = 0x8b74;
	__map_gbk2utf16[0x562d] = 0x8b75;
	__map_gbk2utf16[0x562e] = 0x8b76;
	__map_gbk2utf16[0x562f] = 0x8b77;
	__map_gbk2utf16[0x5630] = 0x8b78;
	__map_gbk2utf16[0x5631] = 0x8b79;
	__map_gbk2utf16[0x5632] = 0x8b7a;
	__map_gbk2utf16[0x5633] = 0x8b7b;
	__map_gbk2utf16[0x5634] = 0x8b7c;
	__map_gbk2utf16[0x5635] = 0x8b7d;
	__map_gbk2utf16[0x5636] = 0x8b7e;
	__map_gbk2utf16[0x5637] = 0x8b7f;
	__map_gbk2utf16[0x5638] = 0x8b80;
	__map_gbk2utf16[0x5639] = 0x8b81;
	__map_gbk2utf16[0x563a] = 0x8b82;
	__map_gbk2utf16[0x563b] = 0x8b83;
	__map_gbk2utf16[0x563c] = 0x8b84;
	__map_gbk2utf16[0x563d] = 0x8b85;
	__map_gbk2utf16[0x563e] = 0x8b86;
	__map_gbk2utf16[0x5640] = 0x8b87;
	__map_gbk2utf16[0x5641] = 0x8b88;
	__map_gbk2utf16[0x5642] = 0x8b89;
	__map_gbk2utf16[0x5643] = 0x8b8a;
	__map_gbk2utf16[0x5644] = 0x8b8b;
	__map_gbk2utf16[0x5645] = 0x8b8c;
	__map_gbk2utf16[0x5646] = 0x8b8d;
	__map_gbk2utf16[0x5647] = 0x8b8e;
	__map_gbk2utf16[0x5648] = 0x8b8f;
	__map_gbk2utf16[0x5649] = 0x8b90;
	__map_gbk2utf16[0x564a] = 0x8b91;
	__map_gbk2utf16[0x564b] = 0x8b92;
	__map_gbk2utf16[0x564c] = 0x8b93;
	__map_gbk2utf16[0x564d] = 0x8b94;
	__map_gbk2utf16[0x564e] = 0x8b95;
	__map_gbk2utf16[0x564f] = 0x8b96;
	__map_gbk2utf16[0x5650] = 0x8b97;
	__map_gbk2utf16[0x5651] = 0x8b98;
	__map_gbk2utf16[0x5652] = 0x8b99;
	__map_gbk2utf16[0x5653] = 0x8b9a;
	__map_gbk2utf16[0x5654] = 0x8b9b;
	__map_gbk2utf16[0x5655] = 0x8b9c;
	__map_gbk2utf16[0x5656] = 0x8b9d;
	__map_gbk2utf16[0x5657] = 0x8b9e;
	__map_gbk2utf16[0x5658] = 0x8b9f;
	__map_gbk2utf16[0x5659] = 0x8bac;
	__map_gbk2utf16[0x565a] = 0x8bb1;
	__map_gbk2utf16[0x565b] = 0x8bbb;
	__map_gbk2utf16[0x565c] = 0x8bc7;
	__map_gbk2utf16[0x565d] = 0x8bd0;
	__map_gbk2utf16[0x565e] = 0x8bea;
	__map_gbk2utf16[0x565f] = 0x8c09;
	__map_gbk2utf16[0x5660] = 0x8c1e;
	__map_gbk2utf16[0x5661] = 0x4f4f;
	__map_gbk2utf16[0x5662] = 0x6ce8;
	__map_gbk2utf16[0x5663] = 0x795d;
	__map_gbk2utf16[0x5664] = 0x9a7b;
	__map_gbk2utf16[0x5665] = 0x6293;
	__map_gbk2utf16[0x5666] = 0x722a;
	__map_gbk2utf16[0x5667] = 0x62fd;
	__map_gbk2utf16[0x5668] = 0x4e13;
	__map_gbk2utf16[0x5669] = 0x7816;
	__map_gbk2utf16[0x566a] = 0x8f6c;
	__map_gbk2utf16[0x566b] = 0x64b0;
	__map_gbk2utf16[0x566c] = 0x8d5a;
	__map_gbk2utf16[0x566d] = 0x7bc6;
	__map_gbk2utf16[0x566e] = 0x6869;
	__map_gbk2utf16[0x566f] = 0x5e84;
	__map_gbk2utf16[0x5670] = 0x88c5;
	__map_gbk2utf16[0x5671] = 0x5986;
	__map_gbk2utf16[0x5672] = 0x649e;
	__map_gbk2utf16[0x5673] = 0x58ee;
	__map_gbk2utf16[0x5674] = 0x72b6;
	__map_gbk2utf16[0x5675] = 0x690e;
	__map_gbk2utf16[0x5676] = 0x9525;
	__map_gbk2utf16[0x5677] = 0x8ffd;
	__map_gbk2utf16[0x5678] = 0x8d58;
	__map_gbk2utf16[0x5679] = 0x5760;
	__map_gbk2utf16[0x567a] = 0x7f00;
	__map_gbk2utf16[0x567b] = 0x8c06;
	__map_gbk2utf16[0x567c] = 0x51c6;
	__map_gbk2utf16[0x567d] = 0x6349;
	__map_gbk2utf16[0x567e] = 0x62d9;
	__map_gbk2utf16[0x567f] = 0x5353;
	__map_gbk2utf16[0x5680] = 0x684c;
	__map_gbk2utf16[0x5681] = 0x7422;
	__map_gbk2utf16[0x5682] = 0x8301;
	__map_gbk2utf16[0x5683] = 0x914c;
	__map_gbk2utf16[0x5684] = 0x5544;
	__map_gbk2utf16[0x5685] = 0x7740;
	__map_gbk2utf16[0x5686] = 0x707c;
	__map_gbk2utf16[0x5687] = 0x6d4a;
	__map_gbk2utf16[0x5688] = 0x5179;
	__map_gbk2utf16[0x5689] = 0x54a8;
	__map_gbk2utf16[0x568a] = 0x8d44;
	__map_gbk2utf16[0x568b] = 0x59ff;
	__map_gbk2utf16[0x568c] = 0x6ecb;
	__map_gbk2utf16[0x568d] = 0x6dc4;
	__map_gbk2utf16[0x568e] = 0x5b5c;
	__map_gbk2utf16[0x568f] = 0x7d2b;
	__map_gbk2utf16[0x5690] = 0x4ed4;
	__map_gbk2utf16[0x5691] = 0x7c7d;
	__map_gbk2utf16[0x5692] = 0x6ed3;
	__map_gbk2utf16[0x5693] = 0x5b50;
	__map_gbk2utf16[0x5694] = 0x81ea;
	__map_gbk2utf16[0x5695] = 0x6e0d;
	__map_gbk2utf16[0x5696] = 0x5b57;
	__map_gbk2utf16[0x5697] = 0x9b03;
	__map_gbk2utf16[0x5698] = 0x68d5;
	__map_gbk2utf16[0x5699] = 0x8e2a;
	__map_gbk2utf16[0x569a] = 0x5b97;
	__map_gbk2utf16[0x569b] = 0x7efc;
	__map_gbk2utf16[0x569c] = 0x603b;
	__map_gbk2utf16[0x569d] = 0x7eb5;
	__map_gbk2utf16[0x569e] = 0x90b9;
	__map_gbk2utf16[0x569f] = 0x8d70;
	__map_gbk2utf16[0x56a0] = 0x594f;
	__map_gbk2utf16[0x56a1] = 0x63cd;
	__map_gbk2utf16[0x56a2] = 0x79df;
	__map_gbk2utf16[0x56a3] = 0x8db3;
	__map_gbk2utf16[0x56a4] = 0x5352;
	__map_gbk2utf16[0x56a5] = 0x65cf;
	__map_gbk2utf16[0x56a6] = 0x7956;
	__map_gbk2utf16[0x56a7] = 0x8bc5;
	__map_gbk2utf16[0x56a8] = 0x963b;
	__map_gbk2utf16[0x56a9] = 0x7ec4;
	__map_gbk2utf16[0x56aa] = 0x94bb;
	__map_gbk2utf16[0x56ab] = 0x7e82;
	__map_gbk2utf16[0x56ac] = 0x5634;
	__map_gbk2utf16[0x56ad] = 0x9189;
	__map_gbk2utf16[0x56ae] = 0x6700;
	__map_gbk2utf16[0x56af] = 0x7f6a;
	__map_gbk2utf16[0x56b0] = 0x5c0a;
	__map_gbk2utf16[0x56b1] = 0x9075;
	__map_gbk2utf16[0x56b2] = 0x6628;
	__map_gbk2utf16[0x56b3] = 0x5de6;
	__map_gbk2utf16[0x56b4] = 0x4f50;
	__map_gbk2utf16[0x56b5] = 0x67de;
	__map_gbk2utf16[0x56b6] = 0x505a;
	__map_gbk2utf16[0x56b7] = 0x4f5c;
	__map_gbk2utf16[0x56b8] = 0x5750;
	__map_gbk2utf16[0x56b9] = 0x5ea7;
	__map_gbk2utf16[0x56ba] = 0xe810;
	__map_gbk2utf16[0x56bb] = 0xe811;
	__map_gbk2utf16[0x56bc] = 0xe812;
	__map_gbk2utf16[0x56bd] = 0xe813;
	__map_gbk2utf16[0x56be] = 0xe814;
	__map_gbk2utf16[0x5700] = 0x8c38;
	__map_gbk2utf16[0x5701] = 0x8c39;
	__map_gbk2utf16[0x5702] = 0x8c3a;
	__map_gbk2utf16[0x5703] = 0x8c3b;
	__map_gbk2utf16[0x5704] = 0x8c3c;
	__map_gbk2utf16[0x5705] = 0x8c3d;
	__map_gbk2utf16[0x5706] = 0x8c3e;
	__map_gbk2utf16[0x5707] = 0x8c3f;
	__map_gbk2utf16[0x5708] = 0x8c40;
	__map_gbk2utf16[0x5709] = 0x8c42;
	__map_gbk2utf16[0x570a] = 0x8c43;
	__map_gbk2utf16[0x570b] = 0x8c44;
	__map_gbk2utf16[0x570c] = 0x8c45;
	__map_gbk2utf16[0x570d] = 0x8c48;
	__map_gbk2utf16[0x570e] = 0x8c4a;
	__map_gbk2utf16[0x570f] = 0x8c4b;
	__map_gbk2utf16[0x5710] = 0x8c4d;
	__map_gbk2utf16[0x5711] = 0x8c4e;
	__map_gbk2utf16[0x5712] = 0x8c4f;
	__map_gbk2utf16[0x5713] = 0x8c50;
	__map_gbk2utf16[0x5714] = 0x8c51;
	__map_gbk2utf16[0x5715] = 0x8c52;
	__map_gbk2utf16[0x5716] = 0x8c53;
	__map_gbk2utf16[0x5717] = 0x8c54;
	__map_gbk2utf16[0x5718] = 0x8c56;
	__map_gbk2utf16[0x5719] = 0x8c57;
	__map_gbk2utf16[0x571a] = 0x8c58;
	__map_gbk2utf16[0x571b] = 0x8c59;
	__map_gbk2utf16[0x571c] = 0x8c5b;
	__map_gbk2utf16[0x571d] = 0x8c5c;
	__map_gbk2utf16[0x571e] = 0x8c5d;
	__map_gbk2utf16[0x571f] = 0x8c5e;
	__map_gbk2utf16[0x5720] = 0x8c5f;
	__map_gbk2utf16[0x5721] = 0x8c60;
	__map_gbk2utf16[0x5722] = 0x8c63;
	__map_gbk2utf16[0x5723] = 0x8c64;
	__map_gbk2utf16[0x5724] = 0x8c65;
	__map_gbk2utf16[0x5725] = 0x8c66;
	__map_gbk2utf16[0x5726] = 0x8c67;
	__map_gbk2utf16[0x5727] = 0x8c68;
	__map_gbk2utf16[0x5728] = 0x8c69;
	__map_gbk2utf16[0x5729] = 0x8c6c;
	__map_gbk2utf16[0x572a] = 0x8c6d;
	__map_gbk2utf16[0x572b] = 0x8c6e;
	__map_gbk2utf16[0x572c] = 0x8c6f;
	__map_gbk2utf16[0x572d] = 0x8c70;
	__map_gbk2utf16[0x572e] = 0x8c71;
	__map_gbk2utf16[0x572f] = 0x8c72;
	__map_gbk2utf16[0x5730] = 0x8c74;
	__map_gbk2utf16[0x5731] = 0x8c75;
	__map_gbk2utf16[0x5732] = 0x8c76;
	__map_gbk2utf16[0x5733] = 0x8c77;
	__map_gbk2utf16[0x5734] = 0x8c7b;
	__map_gbk2utf16[0x5735] = 0x8c7c;
	__map_gbk2utf16[0x5736] = 0x8c7d;
	__map_gbk2utf16[0x5737] = 0x8c7e;
	__map_gbk2utf16[0x5738] = 0x8c7f;
	__map_gbk2utf16[0x5739] = 0x8c80;
	__map_gbk2utf16[0x573a] = 0x8c81;
	__map_gbk2utf16[0x573b] = 0x8c83;
	__map_gbk2utf16[0x573c] = 0x8c84;
	__map_gbk2utf16[0x573d] = 0x8c86;
	__map_gbk2utf16[0x573e] = 0x8c87;
	__map_gbk2utf16[0x5740] = 0x8c88;
	__map_gbk2utf16[0x5741] = 0x8c8b;
	__map_gbk2utf16[0x5742] = 0x8c8d;
	__map_gbk2utf16[0x5743] = 0x8c8e;
	__map_gbk2utf16[0x5744] = 0x8c8f;
	__map_gbk2utf16[0x5745] = 0x8c90;
	__map_gbk2utf16[0x5746] = 0x8c91;
	__map_gbk2utf16[0x5747] = 0x8c92;
	__map_gbk2utf16[0x5748] = 0x8c93;
	__map_gbk2utf16[0x5749] = 0x8c95;
	__map_gbk2utf16[0x574a] = 0x8c96;
	__map_gbk2utf16[0x574b] = 0x8c97;
	__map_gbk2utf16[0x574c] = 0x8c99;
	__map_gbk2utf16[0x574d] = 0x8c9a;
	__map_gbk2utf16[0x574e] = 0x8c9b;
	__map_gbk2utf16[0x574f] = 0x8c9c;
	__map_gbk2utf16[0x5750] = 0x8c9d;
	__map_gbk2utf16[0x5751] = 0x8c9e;
	__map_gbk2utf16[0x5752] = 0x8c9f;
	__map_gbk2utf16[0x5753] = 0x8ca0;
	__map_gbk2utf16[0x5754] = 0x8ca1;
	__map_gbk2utf16[0x5755] = 0x8ca2;
	__map_gbk2utf16[0x5756] = 0x8ca3;
	__map_gbk2utf16[0x5757] = 0x8ca4;
	__map_gbk2utf16[0x5758] = 0x8ca5;
	__map_gbk2utf16[0x5759] = 0x8ca6;
	__map_gbk2utf16[0x575a] = 0x8ca7;
	__map_gbk2utf16[0x575b] = 0x8ca8;
	__map_gbk2utf16[0x575c] = 0x8ca9;
	__map_gbk2utf16[0x575d] = 0x8caa;
	__map_gbk2utf16[0x575e] = 0x8cab;
	__map_gbk2utf16[0x575f] = 0x8cac;
	__map_gbk2utf16[0x5760] = 0x8cad;
	__map_gbk2utf16[0x5761] = 0x4e8d;
	__map_gbk2utf16[0x5762] = 0x4e0c;
	__map_gbk2utf16[0x5763] = 0x5140;
	__map_gbk2utf16[0x5764] = 0x4e10;
	__map_gbk2utf16[0x5765] = 0x5eff;
	__map_gbk2utf16[0x5766] = 0x5345;
	__map_gbk2utf16[0x5767] = 0x4e15;
	__map_gbk2utf16[0x5768] = 0x4e98;
	__map_gbk2utf16[0x5769] = 0x4e1e;
	__map_gbk2utf16[0x576a] = 0x9b32;
	__map_gbk2utf16[0x576b] = 0x5b6c;
	__map_gbk2utf16[0x576c] = 0x5669;
	__map_gbk2utf16[0x576d] = 0x4e28;
	__map_gbk2utf16[0x576e] = 0x79ba;
	__map_gbk2utf16[0x576f] = 0x4e3f;
	__map_gbk2utf16[0x5770] = 0x5315;
	__map_gbk2utf16[0x5771] = 0x4e47;
	__map_gbk2utf16[0x5772] = 0x592d;
	__map_gbk2utf16[0x5773] = 0x723b;
	__map_gbk2utf16[0x5774] = 0x536e;
	__map_gbk2utf16[0x5775] = 0x6c10;
	__map_gbk2utf16[0x5776] = 0x56df;
	__map_gbk2utf16[0x5777] = 0x80e4;
	__map_gbk2utf16[0x5778] = 0x9997;
	__map_gbk2utf16[0x5779] = 0x6bd3;
	__map_gbk2utf16[0x577a] = 0x777e;
	__map_gbk2utf16[0x577b] = 0x9f17;
	__map_gbk2utf16[0x577c] = 0x4e36;
	__map_gbk2utf16[0x577d] = 0x4e9f;
	__map_gbk2utf16[0x577e] = 0x9f10;
	__map_gbk2utf16[0x577f] = 0x4e5c;
	__map_gbk2utf16[0x5780] = 0x4e69;
	__map_gbk2utf16[0x5781] = 0x4e93;
	__map_gbk2utf16[0x5782] = 0x8288;
	__map_gbk2utf16[0x5783] = 0x5b5b;
	__map_gbk2utf16[0x5784] = 0x556c;
	__map_gbk2utf16[0x5785] = 0x560f;
	__map_gbk2utf16[0x5786] = 0x4ec4;
	__map_gbk2utf16[0x5787] = 0x538d;
	__map_gbk2utf16[0x5788] = 0x539d;
	__map_gbk2utf16[0x5789] = 0x53a3;
	__map_gbk2utf16[0x578a] = 0x53a5;
	__map_gbk2utf16[0x578b] = 0x53ae;
	__map_gbk2utf16[0x578c] = 0x9765;
	__map_gbk2utf16[0x578d] = 0x8d5d;
	__map_gbk2utf16[0x578e] = 0x531a;
	__map_gbk2utf16[0x578f] = 0x53f5;
	__map_gbk2utf16[0x5790] = 0x5326;
	__map_gbk2utf16[0x5791] = 0x532e;
	__map_gbk2utf16[0x5792] = 0x533e;
	__map_gbk2utf16[0x5793] = 0x8d5c;
	__map_gbk2utf16[0x5794] = 0x5366;
	__map_gbk2utf16[0x5795] = 0x5363;
	__map_gbk2utf16[0x5796] = 0x5202;
	__map_gbk2utf16[0x5797] = 0x5208;
	__map_gbk2utf16[0x5798] = 0x520e;
	__map_gbk2utf16[0x5799] = 0x522d;
	__map_gbk2utf16[0x579a] = 0x5233;
	__map_gbk2utf16[0x579b] = 0x523f;
	__map_gbk2utf16[0x579c] = 0x5240;
	__map_gbk2utf16[0x579d] = 0x524c;
	__map_gbk2utf16[0x579e] = 0x525e;
	__map_gbk2utf16[0x579f] = 0x5261;
	__map_gbk2utf16[0x57a0] = 0x525c;
	__map_gbk2utf16[0x57a1] = 0x84af;
	__map_gbk2utf16[0x57a2] = 0x527d;
	__map_gbk2utf16[0x57a3] = 0x5282;
	__map_gbk2utf16[0x57a4] = 0x5281;
	__map_gbk2utf16[0x57a5] = 0x5290;
	__map_gbk2utf16[0x57a6] = 0x5293;
	__map_gbk2utf16[0x57a7] = 0x5182;
	__map_gbk2utf16[0x57a8] = 0x7f54;
	__map_gbk2utf16[0x57a9] = 0x4ebb;
	__map_gbk2utf16[0x57aa] = 0x4ec3;
	__map_gbk2utf16[0x57ab] = 0x4ec9;
	__map_gbk2utf16[0x57ac] = 0x4ec2;
	__map_gbk2utf16[0x57ad] = 0x4ee8;
	__map_gbk2utf16[0x57ae] = 0x4ee1;
	__map_gbk2utf16[0x57af] = 0x4eeb;
	__map_gbk2utf16[0x57b0] = 0x4ede;
	__map_gbk2utf16[0x57b1] = 0x4f1b;
	__map_gbk2utf16[0x57b2] = 0x4ef3;
	__map_gbk2utf16[0x57b3] = 0x4f22;
	__map_gbk2utf16[0x57b4] = 0x4f64;
	__map_gbk2utf16[0x57b5] = 0x4ef5;
	__map_gbk2utf16[0x57b6] = 0x4f25;
	__map_gbk2utf16[0x57b7] = 0x4f27;
	__map_gbk2utf16[0x57b8] = 0x4f09;
	__map_gbk2utf16[0x57b9] = 0x4f2b;
	__map_gbk2utf16[0x57ba] = 0x4f5e;
	__map_gbk2utf16[0x57bb] = 0x4f67;
	__map_gbk2utf16[0x57bc] = 0x6538;
	__map_gbk2utf16[0x57bd] = 0x4f5a;
	__map_gbk2utf16[0x57be] = 0x4f5d;
	__map_gbk2utf16[0x5800] = 0x8cae;
	__map_gbk2utf16[0x5801] = 0x8caf;
	__map_gbk2utf16[0x5802] = 0x8cb0;
	__map_gbk2utf16[0x5803] = 0x8cb1;
	__map_gbk2utf16[0x5804] = 0x8cb2;
	__map_gbk2utf16[0x5805] = 0x8cb3;
	__map_gbk2utf16[0x5806] = 0x8cb4;
	__map_gbk2utf16[0x5807] = 0x8cb5;
	__map_gbk2utf16[0x5808] = 0x8cb6;
	__map_gbk2utf16[0x5809] = 0x8cb7;
	__map_gbk2utf16[0x580a] = 0x8cb8;
	__map_gbk2utf16[0x580b] = 0x8cb9;
	__map_gbk2utf16[0x580c] = 0x8cba;
	__map_gbk2utf16[0x580d] = 0x8cbb;
	__map_gbk2utf16[0x580e] = 0x8cbc;
	__map_gbk2utf16[0x580f] = 0x8cbd;
	__map_gbk2utf16[0x5810] = 0x8cbe;
	__map_gbk2utf16[0x5811] = 0x8cbf;
	__map_gbk2utf16[0x5812] = 0x8cc0;
	__map_gbk2utf16[0x5813] = 0x8cc1;
	__map_gbk2utf16[0x5814] = 0x8cc2;
	__map_gbk2utf16[0x5815] = 0x8cc3;
	__map_gbk2utf16[0x5816] = 0x8cc4;
	__map_gbk2utf16[0x5817] = 0x8cc5;
	__map_gbk2utf16[0x5818] = 0x8cc6;
	__map_gbk2utf16[0x5819] = 0x8cc7;
	__map_gbk2utf16[0x581a] = 0x8cc8;
	__map_gbk2utf16[0x581b] = 0x8cc9;
	__map_gbk2utf16[0x581c] = 0x8cca;
	__map_gbk2utf16[0x581d] = 0x8ccb;
	__map_gbk2utf16[0x581e] = 0x8ccc;
	__map_gbk2utf16[0x581f] = 0x8ccd;
	__map_gbk2utf16[0x5820] = 0x8cce;
	__map_gbk2utf16[0x5821] = 0x8ccf;
	__map_gbk2utf16[0x5822] = 0x8cd0;
	__map_gbk2utf16[0x5823] = 0x8cd1;
	__map_gbk2utf16[0x5824] = 0x8cd2;
	__map_gbk2utf16[0x5825] = 0x8cd3;
	__map_gbk2utf16[0x5826] = 0x8cd4;
	__map_gbk2utf16[0x5827] = 0x8cd5;
	__map_gbk2utf16[0x5828] = 0x8cd6;
	__map_gbk2utf16[0x5829] = 0x8cd7;
	__map_gbk2utf16[0x582a] = 0x8cd8;
	__map_gbk2utf16[0x582b] = 0x8cd9;
	__map_gbk2utf16[0x582c] = 0x8cda;
	__map_gbk2utf16[0x582d] = 0x8cdb;
	__map_gbk2utf16[0x582e] = 0x8cdc;
	__map_gbk2utf16[0x582f] = 0x8cdd;
	__map_gbk2utf16[0x5830] = 0x8cde;
	__map_gbk2utf16[0x5831] = 0x8cdf;
	__map_gbk2utf16[0x5832] = 0x8ce0;
	__map_gbk2utf16[0x5833] = 0x8ce1;
	__map_gbk2utf16[0x5834] = 0x8ce2;
	__map_gbk2utf16[0x5835] = 0x8ce3;
	__map_gbk2utf16[0x5836] = 0x8ce4;
	__map_gbk2utf16[0x5837] = 0x8ce5;
	__map_gbk2utf16[0x5838] = 0x8ce6;
	__map_gbk2utf16[0x5839] = 0x8ce7;
	__map_gbk2utf16[0x583a] = 0x8ce8;
	__map_gbk2utf16[0x583b] = 0x8ce9;
	__map_gbk2utf16[0x583c] = 0x8cea;
	__map_gbk2utf16[0x583d] = 0x8ceb;
	__map_gbk2utf16[0x583e] = 0x8cec;
	__map_gbk2utf16[0x5840] = 0x8ced;
	__map_gbk2utf16[0x5841] = 0x8cee;
	__map_gbk2utf16[0x5842] = 0x8cef;
	__map_gbk2utf16[0x5843] = 0x8cf0;
	__map_gbk2utf16[0x5844] = 0x8cf1;
	__map_gbk2utf16[0x5845] = 0x8cf2;
	__map_gbk2utf16[0x5846] = 0x8cf3;
	__map_gbk2utf16[0x5847] = 0x8cf4;
	__map_gbk2utf16[0x5848] = 0x8cf5;
	__map_gbk2utf16[0x5849] = 0x8cf6;
	__map_gbk2utf16[0x584a] = 0x8cf7;
	__map_gbk2utf16[0x584b] = 0x8cf8;
	__map_gbk2utf16[0x584c] = 0x8cf9;
	__map_gbk2utf16[0x584d] = 0x8cfa;
	__map_gbk2utf16[0x584e] = 0x8cfb;
	__map_gbk2utf16[0x584f] = 0x8cfc;
	__map_gbk2utf16[0x5850] = 0x8cfd;
	__map_gbk2utf16[0x5851] = 0x8cfe;
	__map_gbk2utf16[0x5852] = 0x8cff;
	__map_gbk2utf16[0x5853] = 0x8d00;
	__map_gbk2utf16[0x5854] = 0x8d01;
	__map_gbk2utf16[0x5855] = 0x8d02;
	__map_gbk2utf16[0x5856] = 0x8d03;
	__map_gbk2utf16[0x5857] = 0x8d04;
	__map_gbk2utf16[0x5858] = 0x8d05;
	__map_gbk2utf16[0x5859] = 0x8d06;
	__map_gbk2utf16[0x585a] = 0x8d07;
	__map_gbk2utf16[0x585b] = 0x8d08;
	__map_gbk2utf16[0x585c] = 0x8d09;
	__map_gbk2utf16[0x585d] = 0x8d0a;
	__map_gbk2utf16[0x585e] = 0x8d0b;
	__map_gbk2utf16[0x585f] = 0x8d0c;
	__map_gbk2utf16[0x5860] = 0x8d0d;
	__map_gbk2utf16[0x5861] = 0x4f5f;
	__map_gbk2utf16[0x5862] = 0x4f57;
	__map_gbk2utf16[0x5863] = 0x4f32;
	__map_gbk2utf16[0x5864] = 0x4f3d;
	__map_gbk2utf16[0x5865] = 0x4f76;
	__map_gbk2utf16[0x5866] = 0x4f74;
	__map_gbk2utf16[0x5867] = 0x4f91;
	__map_gbk2utf16[0x5868] = 0x4f89;
	__map_gbk2utf16[0x5869] = 0x4f83;
	__map_gbk2utf16[0x586a] = 0x4f8f;
	__map_gbk2utf16[0x586b] = 0x4f7e;
	__map_gbk2utf16[0x586c] = 0x4f7b;
	__map_gbk2utf16[0x586d] = 0x4faa;
	__map_gbk2utf16[0x586e] = 0x4f7c;
	__map_gbk2utf16[0x586f] = 0x4fac;
	__map_gbk2utf16[0x5870] = 0x4f94;
	__map_gbk2utf16[0x5871] = 0x4fe6;
	__map_gbk2utf16[0x5872] = 0x4fe8;
	__map_gbk2utf16[0x5873] = 0x4fea;
	__map_gbk2utf16[0x5874] = 0x4fc5;
	__map_gbk2utf16[0x5875] = 0x4fda;
	__map_gbk2utf16[0x5876] = 0x4fe3;
	__map_gbk2utf16[0x5877] = 0x4fdc;
	__map_gbk2utf16[0x5878] = 0x4fd1;
	__map_gbk2utf16[0x5879] = 0x4fdf;
	__map_gbk2utf16[0x587a] = 0x4ff8;
	__map_gbk2utf16[0x587b] = 0x5029;
	__map_gbk2utf16[0x587c] = 0x504c;
	__map_gbk2utf16[0x587d] = 0x4ff3;
	__map_gbk2utf16[0x587e] = 0x502c;
	__map_gbk2utf16[0x587f] = 0x500f;
	__map_gbk2utf16[0x5880] = 0x502e;
	__map_gbk2utf16[0x5881] = 0x502d;
	__map_gbk2utf16[0x5882] = 0x4ffe;
	__map_gbk2utf16[0x5883] = 0x501c;
	__map_gbk2utf16[0x5884] = 0x500c;
	__map_gbk2utf16[0x5885] = 0x5025;
	__map_gbk2utf16[0x5886] = 0x5028;
	__map_gbk2utf16[0x5887] = 0x507e;
	__map_gbk2utf16[0x5888] = 0x5043;
	__map_gbk2utf16[0x5889] = 0x5055;
	__map_gbk2utf16[0x588a] = 0x5048;
	__map_gbk2utf16[0x588b] = 0x504e;
	__map_gbk2utf16[0x588c] = 0x506c;
	__map_gbk2utf16[0x588d] = 0x507b;
	__map_gbk2utf16[0x588e] = 0x50a5;
	__map_gbk2utf16[0x588f] = 0x50a7;
	__map_gbk2utf16[0x5890] = 0x50a9;
	__map_gbk2utf16[0x5891] = 0x50ba;
	__map_gbk2utf16[0x5892] = 0x50d6;
	__map_gbk2utf16[0x5893] = 0x5106;
	__map_gbk2utf16[0x5894] = 0x50ed;
	__map_gbk2utf16[0x5895] = 0x50ec;
	__map_gbk2utf16[0x5896] = 0x50e6;
	__map_gbk2utf16[0x5897] = 0x50ee;
	__map_gbk2utf16[0x5898] = 0x5107;
	__map_gbk2utf16[0x5899] = 0x510b;
	__map_gbk2utf16[0x589a] = 0x4edd;
	__map_gbk2utf16[0x589b] = 0x6c3d;
	__map_gbk2utf16[0x589c] = 0x4f58;
	__map_gbk2utf16[0x589d] = 0x4f65;
	__map_gbk2utf16[0x589e] = 0x4fce;
	__map_gbk2utf16[0x589f] = 0x9fa0;
	__map_gbk2utf16[0x58a0] = 0x6c46;
	__map_gbk2utf16[0x58a1] = 0x7c74;
	__map_gbk2utf16[0x58a2] = 0x516e;
	__map_gbk2utf16[0x58a3] = 0x5dfd;
	__map_gbk2utf16[0x58a4] = 0x9ec9;
	__map_gbk2utf16[0x58a5] = 0x9998;
	__map_gbk2utf16[0x58a6] = 0x5181;
	__map_gbk2utf16[0x58a7] = 0x5914;
	__map_gbk2utf16[0x58a8] = 0x52f9;
	__map_gbk2utf16[0x58a9] = 0x530d;
	__map_gbk2utf16[0x58aa] = 0x8a07;
	__map_gbk2utf16[0x58ab] = 0x5310;
	__map_gbk2utf16[0x58ac] = 0x51eb;
	__map_gbk2utf16[0x58ad] = 0x5919;
	__map_gbk2utf16[0x58ae] = 0x5155;
	__map_gbk2utf16[0x58af] = 0x4ea0;
	__map_gbk2utf16[0x58b0] = 0x5156;
	__map_gbk2utf16[0x58b1] = 0x4eb3;
	__map_gbk2utf16[0x58b2] = 0x886e;
	__map_gbk2utf16[0x58b3] = 0x88a4;
	__map_gbk2utf16[0x58b4] = 0x4eb5;
	__map_gbk2utf16[0x58b5] = 0x8114;
	__map_gbk2utf16[0x58b6] = 0x88d2;
	__map_gbk2utf16[0x58b7] = 0x7980;
	__map_gbk2utf16[0x58b8] = 0x5b34;
	__map_gbk2utf16[0x58b9] = 0x8803;
	__map_gbk2utf16[0x58ba] = 0x7fb8;
	__map_gbk2utf16[0x58bb] = 0x51ab;
	__map_gbk2utf16[0x58bc] = 0x51b1;
	__map_gbk2utf16[0x58bd] = 0x51bd;
	__map_gbk2utf16[0x58be] = 0x51bc;
	__map_gbk2utf16[0x5900] = 0x8d0e;
	__map_gbk2utf16[0x5901] = 0x8d0f;
	__map_gbk2utf16[0x5902] = 0x8d10;
	__map_gbk2utf16[0x5903] = 0x8d11;
	__map_gbk2utf16[0x5904] = 0x8d12;
	__map_gbk2utf16[0x5905] = 0x8d13;
	__map_gbk2utf16[0x5906] = 0x8d14;
	__map_gbk2utf16[0x5907] = 0x8d15;
	__map_gbk2utf16[0x5908] = 0x8d16;
	__map_gbk2utf16[0x5909] = 0x8d17;
	__map_gbk2utf16[0x590a] = 0x8d18;
	__map_gbk2utf16[0x590b] = 0x8d19;
	__map_gbk2utf16[0x590c] = 0x8d1a;
	__map_gbk2utf16[0x590d] = 0x8d1b;
	__map_gbk2utf16[0x590e] = 0x8d1c;
	__map_gbk2utf16[0x590f] = 0x8d20;
	__map_gbk2utf16[0x5910] = 0x8d51;
	__map_gbk2utf16[0x5911] = 0x8d52;
	__map_gbk2utf16[0x5912] = 0x8d57;
	__map_gbk2utf16[0x5913] = 0x8d5f;
	__map_gbk2utf16[0x5914] = 0x8d65;
	__map_gbk2utf16[0x5915] = 0x8d68;
	__map_gbk2utf16[0x5916] = 0x8d69;
	__map_gbk2utf16[0x5917] = 0x8d6a;
	__map_gbk2utf16[0x5918] = 0x8d6c;
	__map_gbk2utf16[0x5919] = 0x8d6e;
	__map_gbk2utf16[0x591a] = 0x8d6f;
	__map_gbk2utf16[0x591b] = 0x8d71;
	__map_gbk2utf16[0x591c] = 0x8d72;
	__map_gbk2utf16[0x591d] = 0x8d78;
	__map_gbk2utf16[0x591e] = 0x8d79;
	__map_gbk2utf16[0x591f] = 0x8d7a;
	__map_gbk2utf16[0x5920] = 0x8d7b;
	__map_gbk2utf16[0x5921] = 0x8d7c;
	__map_gbk2utf16[0x5922] = 0x8d7d;
	__map_gbk2utf16[0x5923] = 0x8d7e;
	__map_gbk2utf16[0x5924] = 0x8d7f;
	__map_gbk2utf16[0x5925] = 0x8d80;
	__map_gbk2utf16[0x5926] = 0x8d82;
	__map_gbk2utf16[0x5927] = 0x8d83;
	__map_gbk2utf16[0x5928] = 0x8d86;
	__map_gbk2utf16[0x5929] = 0x8d87;
	__map_gbk2utf16[0x592a] = 0x8d88;
	__map_gbk2utf16[0x592b] = 0x8d89;
	__map_gbk2utf16[0x592c] = 0x8d8c;
	__map_gbk2utf16[0x592d] = 0x8d8d;
	__map_gbk2utf16[0x592e] = 0x8d8e;
	__map_gbk2utf16[0x592f] = 0x8d8f;
	__map_gbk2utf16[0x5930] = 0x8d90;
	__map_gbk2utf16[0x5931] = 0x8d92;
	__map_gbk2utf16[0x5932] = 0x8d93;
	__map_gbk2utf16[0x5933] = 0x8d95;
	__map_gbk2utf16[0x5934] = 0x8d96;
	__map_gbk2utf16[0x5935] = 0x8d97;
	__map_gbk2utf16[0x5936] = 0x8d98;
	__map_gbk2utf16[0x5937] = 0x8d99;
	__map_gbk2utf16[0x5938] = 0x8d9a;
	__map_gbk2utf16[0x5939] = 0x8d9b;
	__map_gbk2utf16[0x593a] = 0x8d9c;
	__map_gbk2utf16[0x593b] = 0x8d9d;
	__map_gbk2utf16[0x593c] = 0x8d9e;
	__map_gbk2utf16[0x593d] = 0x8da0;
	__map_gbk2utf16[0x593e] = 0x8da1;
	__map_gbk2utf16[0x5940] = 0x8da2;
	__map_gbk2utf16[0x5941] = 0x8da4;
	__map_gbk2utf16[0x5942] = 0x8da5;
	__map_gbk2utf16[0x5943] = 0x8da6;
	__map_gbk2utf16[0x5944] = 0x8da7;
	__map_gbk2utf16[0x5945] = 0x8da8;
	__map_gbk2utf16[0x5946] = 0x8da9;
	__map_gbk2utf16[0x5947] = 0x8daa;
	__map_gbk2utf16[0x5948] = 0x8dab;
	__map_gbk2utf16[0x5949] = 0x8dac;
	__map_gbk2utf16[0x594a] = 0x8dad;
	__map_gbk2utf16[0x594b] = 0x8dae;
	__map_gbk2utf16[0x594c] = 0x8daf;
	__map_gbk2utf16[0x594d] = 0x8db0;
	__map_gbk2utf16[0x594e] = 0x8db2;
	__map_gbk2utf16[0x594f] = 0x8db6;
	__map_gbk2utf16[0x5950] = 0x8db7;
	__map_gbk2utf16[0x5951] = 0x8db9;
	__map_gbk2utf16[0x5952] = 0x8dbb;
	__map_gbk2utf16[0x5953] = 0x8dbd;
	__map_gbk2utf16[0x5954] = 0x8dc0;
	__map_gbk2utf16[0x5955] = 0x8dc1;
	__map_gbk2utf16[0x5956] = 0x8dc2;
	__map_gbk2utf16[0x5957] = 0x8dc5;
	__map_gbk2utf16[0x5958] = 0x8dc7;
	__map_gbk2utf16[0x5959] = 0x8dc8;
	__map_gbk2utf16[0x595a] = 0x8dc9;
	__map_gbk2utf16[0x595b] = 0x8dca;
	__map_gbk2utf16[0x595c] = 0x8dcd;
	__map_gbk2utf16[0x595d] = 0x8dd0;
	__map_gbk2utf16[0x595e] = 0x8dd2;
	__map_gbk2utf16[0x595f] = 0x8dd3;
	__map_gbk2utf16[0x5960] = 0x8dd4;
	__map_gbk2utf16[0x5961] = 0x51c7;
	__map_gbk2utf16[0x5962] = 0x5196;
	__map_gbk2utf16[0x5963] = 0x51a2;
	__map_gbk2utf16[0x5964] = 0x51a5;
	__map_gbk2utf16[0x5965] = 0x8ba0;
	__map_gbk2utf16[0x5966] = 0x8ba6;
	__map_gbk2utf16[0x5967] = 0x8ba7;
	__map_gbk2utf16[0x5968] = 0x8baa;
	__map_gbk2utf16[0x5969] = 0x8bb4;
	__map_gbk2utf16[0x596a] = 0x8bb5;
	__map_gbk2utf16[0x596b] = 0x8bb7;
	__map_gbk2utf16[0x596c] = 0x8bc2;
	__map_gbk2utf16[0x596d] = 0x8bc3;
	__map_gbk2utf16[0x596e] = 0x8bcb;
	__map_gbk2utf16[0x596f] = 0x8bcf;
	__map_gbk2utf16[0x5970] = 0x8bce;
	__map_gbk2utf16[0x5971] = 0x8bd2;
	__map_gbk2utf16[0x5972] = 0x8bd3;
	__map_gbk2utf16[0x5973] = 0x8bd4;
	__map_gbk2utf16[0x5974] = 0x8bd6;
	__map_gbk2utf16[0x5975] = 0x8bd8;
	__map_gbk2utf16[0x5976] = 0x8bd9;
	__map_gbk2utf16[0x5977] = 0x8bdc;
	__map_gbk2utf16[0x5978] = 0x8bdf;
	__map_gbk2utf16[0x5979] = 0x8be0;
	__map_gbk2utf16[0x597a] = 0x8be4;
	__map_gbk2utf16[0x597b] = 0x8be8;
	__map_gbk2utf16[0x597c] = 0x8be9;
	__map_gbk2utf16[0x597d] = 0x8bee;
	__map_gbk2utf16[0x597e] = 0x8bf0;
	__map_gbk2utf16[0x597f] = 0x8bf3;
	__map_gbk2utf16[0x5980] = 0x8bf6;
	__map_gbk2utf16[0x5981] = 0x8bf9;
	__map_gbk2utf16[0x5982] = 0x8bfc;
	__map_gbk2utf16[0x5983] = 0x8bff;
	__map_gbk2utf16[0x5984] = 0x8c00;
	__map_gbk2utf16[0x5985] = 0x8c02;
	__map_gbk2utf16[0x5986] = 0x8c04;
	__map_gbk2utf16[0x5987] = 0x8c07;
	__map_gbk2utf16[0x5988] = 0x8c0c;
	__map_gbk2utf16[0x5989] = 0x8c0f;
	__map_gbk2utf16[0x598a] = 0x8c11;
	__map_gbk2utf16[0x598b] = 0x8c12;
	__map_gbk2utf16[0x598c] = 0x8c14;
	__map_gbk2utf16[0x598d] = 0x8c15;
	__map_gbk2utf16[0x598e] = 0x8c16;
	__map_gbk2utf16[0x598f] = 0x8c19;
	__map_gbk2utf16[0x5990] = 0x8c1b;
	__map_gbk2utf16[0x5991] = 0x8c18;
	__map_gbk2utf16[0x5992] = 0x8c1d;
	__map_gbk2utf16[0x5993] = 0x8c1f;
	__map_gbk2utf16[0x5994] = 0x8c20;
	__map_gbk2utf16[0x5995] = 0x8c21;
	__map_gbk2utf16[0x5996] = 0x8c25;
	__map_gbk2utf16[0x5997] = 0x8c27;
	__map_gbk2utf16[0x5998] = 0x8c2a;
	__map_gbk2utf16[0x5999] = 0x8c2b;
	__map_gbk2utf16[0x599a] = 0x8c2e;
	__map_gbk2utf16[0x599b] = 0x8c2f;
	__map_gbk2utf16[0x599c] = 0x8c32;
	__map_gbk2utf16[0x599d] = 0x8c33;
	__map_gbk2utf16[0x599e] = 0x8c35;
	__map_gbk2utf16[0x599f] = 0x8c36;
	__map_gbk2utf16[0x59a0] = 0x5369;
	__map_gbk2utf16[0x59a1] = 0x537a;
	__map_gbk2utf16[0x59a2] = 0x961d;
	__map_gbk2utf16[0x59a3] = 0x9622;
	__map_gbk2utf16[0x59a4] = 0x9621;
	__map_gbk2utf16[0x59a5] = 0x9631;
	__map_gbk2utf16[0x59a6] = 0x962a;
	__map_gbk2utf16[0x59a7] = 0x963d;
	__map_gbk2utf16[0x59a8] = 0x963c;
	__map_gbk2utf16[0x59a9] = 0x9642;
	__map_gbk2utf16[0x59aa] = 0x9649;
	__map_gbk2utf16[0x59ab] = 0x9654;
	__map_gbk2utf16[0x59ac] = 0x965f;
	__map_gbk2utf16[0x59ad] = 0x9667;
	__map_gbk2utf16[0x59ae] = 0x966c;
	__map_gbk2utf16[0x59af] = 0x9672;
	__map_gbk2utf16[0x59b0] = 0x9674;
	__map_gbk2utf16[0x59b1] = 0x9688;
	__map_gbk2utf16[0x59b2] = 0x968d;
	__map_gbk2utf16[0x59b3] = 0x9697;
	__map_gbk2utf16[0x59b4] = 0x96b0;
	__map_gbk2utf16[0x59b5] = 0x9097;
	__map_gbk2utf16[0x59b6] = 0x909b;
	__map_gbk2utf16[0x59b7] = 0x909d;
	__map_gbk2utf16[0x59b8] = 0x9099;
	__map_gbk2utf16[0x59b9] = 0x90ac;
	__map_gbk2utf16[0x59ba] = 0x90a1;
	__map_gbk2utf16[0x59bb] = 0x90b4;
	__map_gbk2utf16[0x59bc] = 0x90b3;
	__map_gbk2utf16[0x59bd] = 0x90b6;
	__map_gbk2utf16[0x59be] = 0x90ba;
	__map_gbk2utf16[0x5a00] = 0x8dd5;
	__map_gbk2utf16[0x5a01] = 0x8dd8;
	__map_gbk2utf16[0x5a02] = 0x8dd9;
	__map_gbk2utf16[0x5a03] = 0x8ddc;
	__map_gbk2utf16[0x5a04] = 0x8de0;
	__map_gbk2utf16[0x5a05] = 0x8de1;
	__map_gbk2utf16[0x5a06] = 0x8de2;
	__map_gbk2utf16[0x5a07] = 0x8de5;
	__map_gbk2utf16[0x5a08] = 0x8de6;
	__map_gbk2utf16[0x5a09] = 0x8de7;
	__map_gbk2utf16[0x5a0a] = 0x8de9;
	__map_gbk2utf16[0x5a0b] = 0x8ded;
	__map_gbk2utf16[0x5a0c] = 0x8dee;
	__map_gbk2utf16[0x5a0d] = 0x8df0;
	__map_gbk2utf16[0x5a0e] = 0x8df1;
	__map_gbk2utf16[0x5a0f] = 0x8df2;
	__map_gbk2utf16[0x5a10] = 0x8df4;
	__map_gbk2utf16[0x5a11] = 0x8df6;
	__map_gbk2utf16[0x5a12] = 0x8dfc;
	__map_gbk2utf16[0x5a13] = 0x8dfe;
	__map_gbk2utf16[0x5a14] = 0x8dff;
	__map_gbk2utf16[0x5a15] = 0x8e00;
	__map_gbk2utf16[0x5a16] = 0x8e01;
	__map_gbk2utf16[0x5a17] = 0x8e02;
	__map_gbk2utf16[0x5a18] = 0x8e03;
	__map_gbk2utf16[0x5a19] = 0x8e04;
	__map_gbk2utf16[0x5a1a] = 0x8e06;
	__map_gbk2utf16[0x5a1b] = 0x8e07;
	__map_gbk2utf16[0x5a1c] = 0x8e08;
	__map_gbk2utf16[0x5a1d] = 0x8e0b;
	__map_gbk2utf16[0x5a1e] = 0x8e0d;
	__map_gbk2utf16[0x5a1f] = 0x8e0e;
	__map_gbk2utf16[0x5a20] = 0x8e10;
	__map_gbk2utf16[0x5a21] = 0x8e11;
	__map_gbk2utf16[0x5a22] = 0x8e12;
	__map_gbk2utf16[0x5a23] = 0x8e13;
	__map_gbk2utf16[0x5a24] = 0x8e15;
	__map_gbk2utf16[0x5a25] = 0x8e16;
	__map_gbk2utf16[0x5a26] = 0x8e17;
	__map_gbk2utf16[0x5a27] = 0x8e18;
	__map_gbk2utf16[0x5a28] = 0x8e19;
	__map_gbk2utf16[0x5a29] = 0x8e1a;
	__map_gbk2utf16[0x5a2a] = 0x8e1b;
	__map_gbk2utf16[0x5a2b] = 0x8e1c;
	__map_gbk2utf16[0x5a2c] = 0x8e20;
	__map_gbk2utf16[0x5a2d] = 0x8e21;
	__map_gbk2utf16[0x5a2e] = 0x8e24;
	__map_gbk2utf16[0x5a2f] = 0x8e25;
	__map_gbk2utf16[0x5a30] = 0x8e26;
	__map_gbk2utf16[0x5a31] = 0x8e27;
	__map_gbk2utf16[0x5a32] = 0x8e28;
	__map_gbk2utf16[0x5a33] = 0x8e2b;
	__map_gbk2utf16[0x5a34] = 0x8e2d;
	__map_gbk2utf16[0x5a35] = 0x8e30;
	__map_gbk2utf16[0x5a36] = 0x8e32;
	__map_gbk2utf16[0x5a37] = 0x8e33;
	__map_gbk2utf16[0x5a38] = 0x8e34;
	__map_gbk2utf16[0x5a39] = 0x8e36;
	__map_gbk2utf16[0x5a3a] = 0x8e37;
	__map_gbk2utf16[0x5a3b] = 0x8e38;
	__map_gbk2utf16[0x5a3c] = 0x8e3b;
	__map_gbk2utf16[0x5a3d] = 0x8e3c;
	__map_gbk2utf16[0x5a3e] = 0x8e3e;
	__map_gbk2utf16[0x5a40] = 0x8e3f;
	__map_gbk2utf16[0x5a41] = 0x8e43;
	__map_gbk2utf16[0x5a42] = 0x8e45;
	__map_gbk2utf16[0x5a43] = 0x8e46;
	__map_gbk2utf16[0x5a44] = 0x8e4c;
	__map_gbk2utf16[0x5a45] = 0x8e4d;
	__map_gbk2utf16[0x5a46] = 0x8e4e;
	__map_gbk2utf16[0x5a47] = 0x8e4f;
	__map_gbk2utf16[0x5a48] = 0x8e50;
	__map_gbk2utf16[0x5a49] = 0x8e53;
	__map_gbk2utf16[0x5a4a] = 0x8e54;
	__map_gbk2utf16[0x5a4b] = 0x8e55;
	__map_gbk2utf16[0x5a4c] = 0x8e56;
	__map_gbk2utf16[0x5a4d] = 0x8e57;
	__map_gbk2utf16[0x5a4e] = 0x8e58;
	__map_gbk2utf16[0x5a4f] = 0x8e5a;
	__map_gbk2utf16[0x5a50] = 0x8e5b;
	__map_gbk2utf16[0x5a51] = 0x8e5c;
	__map_gbk2utf16[0x5a52] = 0x8e5d;
	__map_gbk2utf16[0x5a53] = 0x8e5e;
	__map_gbk2utf16[0x5a54] = 0x8e5f;
	__map_gbk2utf16[0x5a55] = 0x8e60;
	__map_gbk2utf16[0x5a56] = 0x8e61;
	__map_gbk2utf16[0x5a57] = 0x8e62;
	__map_gbk2utf16[0x5a58] = 0x8e63;
	__map_gbk2utf16[0x5a59] = 0x8e64;
	__map_gbk2utf16[0x5a5a] = 0x8e65;
	__map_gbk2utf16[0x5a5b] = 0x8e67;
	__map_gbk2utf16[0x5a5c] = 0x8e68;
	__map_gbk2utf16[0x5a5d] = 0x8e6a;
	__map_gbk2utf16[0x5a5e] = 0x8e6b;
	__map_gbk2utf16[0x5a5f] = 0x8e6e;
	__map_gbk2utf16[0x5a60] = 0x8e71;
	__map_gbk2utf16[0x5a61] = 0x90b8;
	__map_gbk2utf16[0x5a62] = 0x90b0;
	__map_gbk2utf16[0x5a63] = 0x90cf;
	__map_gbk2utf16[0x5a64] = 0x90c5;
	__map_gbk2utf16[0x5a65] = 0x90be;
	__map_gbk2utf16[0x5a66] = 0x90d0;
	__map_gbk2utf16[0x5a67] = 0x90c4;
	__map_gbk2utf16[0x5a68] = 0x90c7;
	__map_gbk2utf16[0x5a69] = 0x90d3;
	__map_gbk2utf16[0x5a6a] = 0x90e6;
	__map_gbk2utf16[0x5a6b] = 0x90e2;
	__map_gbk2utf16[0x5a6c] = 0x90dc;
	__map_gbk2utf16[0x5a6d] = 0x90d7;
	__map_gbk2utf16[0x5a6e] = 0x90db;
	__map_gbk2utf16[0x5a6f] = 0x90eb;
	__map_gbk2utf16[0x5a70] = 0x90ef;
	__map_gbk2utf16[0x5a71] = 0x90fe;
	__map_gbk2utf16[0x5a72] = 0x9104;
	__map_gbk2utf16[0x5a73] = 0x9122;
	__map_gbk2utf16[0x5a74] = 0x911e;
	__map_gbk2utf16[0x5a75] = 0x9123;
	__map_gbk2utf16[0x5a76] = 0x9131;
	__map_gbk2utf16[0x5a77] = 0x912f;
	__map_gbk2utf16[0x5a78] = 0x9139;
	__map_gbk2utf16[0x5a79] = 0x9143;
	__map_gbk2utf16[0x5a7a] = 0x9146;
	__map_gbk2utf16[0x5a7b] = 0x520d;
	__map_gbk2utf16[0x5a7c] = 0x5942;
	__map_gbk2utf16[0x5a7d] = 0x52a2;
	__map_gbk2utf16[0x5a7e] = 0x52ac;
	__map_gbk2utf16[0x5a7f] = 0x52ad;
	__map_gbk2utf16[0x5a80] = 0x52be;
	__map_gbk2utf16[0x5a81] = 0x54ff;
	__map_gbk2utf16[0x5a82] = 0x52d0;
	__map_gbk2utf16[0x5a83] = 0x52d6;
	__map_gbk2utf16[0x5a84] = 0x52f0;
	__map_gbk2utf16[0x5a85] = 0x53df;
	__map_gbk2utf16[0x5a86] = 0x71ee;
	__map_gbk2utf16[0x5a87] = 0x77cd;
	__map_gbk2utf16[0x5a88] = 0x5ef4;
	__map_gbk2utf16[0x5a89] = 0x51f5;
	__map_gbk2utf16[0x5a8a] = 0x51fc;
	__map_gbk2utf16[0x5a8b] = 0x9b2f;
	__map_gbk2utf16[0x5a8c] = 0x53b6;
	__map_gbk2utf16[0x5a8d] = 0x5f01;
	__map_gbk2utf16[0x5a8e] = 0x755a;
	__map_gbk2utf16[0x5a8f] = 0x5def;
	__map_gbk2utf16[0x5a90] = 0x574c;
	__map_gbk2utf16[0x5a91] = 0x57a9;
	__map_gbk2utf16[0x5a92] = 0x57a1;
	__map_gbk2utf16[0x5a93] = 0x587e;
	__map_gbk2utf16[0x5a94] = 0x58bc;
	__map_gbk2utf16[0x5a95] = 0x58c5;
	__map_gbk2utf16[0x5a96] = 0x58d1;
	__map_gbk2utf16[0x5a97] = 0x5729;
	__map_gbk2utf16[0x5a98] = 0x572c;
	__map_gbk2utf16[0x5a99] = 0x572a;
	__map_gbk2utf16[0x5a9a] = 0x5733;
	__map_gbk2utf16[0x5a9b] = 0x5739;
	__map_gbk2utf16[0x5a9c] = 0x572e;
	__map_gbk2utf16[0x5a9d] = 0x572f;
	__map_gbk2utf16[0x5a9e] = 0x575c;
	__map_gbk2utf16[0x5a9f] = 0x573b;
	__map_gbk2utf16[0x5aa0] = 0x5742;
	__map_gbk2utf16[0x5aa1] = 0x5769;
	__map_gbk2utf16[0x5aa2] = 0x5785;
	__map_gbk2utf16[0x5aa3] = 0x576b;
	__map_gbk2utf16[0x5aa4] = 0x5786;
	__map_gbk2utf16[0x5aa5] = 0x577c;
	__map_gbk2utf16[0x5aa6] = 0x577b;
	__map_gbk2utf16[0x5aa7] = 0x5768;
	__map_gbk2utf16[0x5aa8] = 0x576d;
	__map_gbk2utf16[0x5aa9] = 0x5776;
	__map_gbk2utf16[0x5aaa] = 0x5773;
	__map_gbk2utf16[0x5aab] = 0x57ad;
	__map_gbk2utf16[0x5aac] = 0x57a4;
	__map_gbk2utf16[0x5aad] = 0x578c;
	__map_gbk2utf16[0x5aae] = 0x57b2;
	__map_gbk2utf16[0x5aaf] = 0x57cf;
	__map_gbk2utf16[0x5ab0] = 0x57a7;
	__map_gbk2utf16[0x5ab1] = 0x57b4;
	__map_gbk2utf16[0x5ab2] = 0x5793;
	__map_gbk2utf16[0x5ab3] = 0x57a0;
	__map_gbk2utf16[0x5ab4] = 0x57d5;
	__map_gbk2utf16[0x5ab5] = 0x57d8;
	__map_gbk2utf16[0x5ab6] = 0x57da;
	__map_gbk2utf16[0x5ab7] = 0x57d9;
	__map_gbk2utf16[0x5ab8] = 0x57d2;
	__map_gbk2utf16[0x5ab9] = 0x57b8;
	__map_gbk2utf16[0x5aba] = 0x57f4;
	__map_gbk2utf16[0x5abb] = 0x57ef;
	__map_gbk2utf16[0x5abc] = 0x57f8;
	__map_gbk2utf16[0x5abd] = 0x57e4;
	__map_gbk2utf16[0x5abe] = 0x57dd;
	__map_gbk2utf16[0x5b00] = 0x8e73;
	__map_gbk2utf16[0x5b01] = 0x8e75;
	__map_gbk2utf16[0x5b02] = 0x8e77;
	__map_gbk2utf16[0x5b03] = 0x8e78;
	__map_gbk2utf16[0x5b04] = 0x8e79;
	__map_gbk2utf16[0x5b05] = 0x8e7a;
	__map_gbk2utf16[0x5b06] = 0x8e7b;
	__map_gbk2utf16[0x5b07] = 0x8e7d;
	__map_gbk2utf16[0x5b08] = 0x8e7e;
	__map_gbk2utf16[0x5b09] = 0x8e80;
	__map_gbk2utf16[0x5b0a] = 0x8e82;
	__map_gbk2utf16[0x5b0b] = 0x8e83;
	__map_gbk2utf16[0x5b0c] = 0x8e84;
	__map_gbk2utf16[0x5b0d] = 0x8e86;
	__map_gbk2utf16[0x5b0e] = 0x8e88;
	__map_gbk2utf16[0x5b0f] = 0x8e89;
	__map_gbk2utf16[0x5b10] = 0x8e8a;
	__map_gbk2utf16[0x5b11] = 0x8e8b;
	__map_gbk2utf16[0x5b12] = 0x8e8c;
	__map_gbk2utf16[0x5b13] = 0x8e8d;
	__map_gbk2utf16[0x5b14] = 0x8e8e;
	__map_gbk2utf16[0x5b15] = 0x8e91;
	__map_gbk2utf16[0x5b16] = 0x8e92;
	__map_gbk2utf16[0x5b17] = 0x8e93;
	__map_gbk2utf16[0x5b18] = 0x8e95;
	__map_gbk2utf16[0x5b19] = 0x8e96;
	__map_gbk2utf16[0x5b1a] = 0x8e97;
	__map_gbk2utf16[0x5b1b] = 0x8e98;
	__map_gbk2utf16[0x5b1c] = 0x8e99;
	__map_gbk2utf16[0x5b1d] = 0x8e9a;
	__map_gbk2utf16[0x5b1e] = 0x8e9b;
	__map_gbk2utf16[0x5b1f] = 0x8e9d;
	__map_gbk2utf16[0x5b20] = 0x8e9f;
	__map_gbk2utf16[0x5b21] = 0x8ea0;
	__map_gbk2utf16[0x5b22] = 0x8ea1;
	__map_gbk2utf16[0x5b23] = 0x8ea2;
	__map_gbk2utf16[0x5b24] = 0x8ea3;
	__map_gbk2utf16[0x5b25] = 0x8ea4;
	__map_gbk2utf16[0x5b26] = 0x8ea5;
	__map_gbk2utf16[0x5b27] = 0x8ea6;
	__map_gbk2utf16[0x5b28] = 0x8ea7;
	__map_gbk2utf16[0x5b29] = 0x8ea8;
	__map_gbk2utf16[0x5b2a] = 0x8ea9;
	__map_gbk2utf16[0x5b2b] = 0x8eaa;
	__map_gbk2utf16[0x5b2c] = 0x8ead;
	__map_gbk2utf16[0x5b2d] = 0x8eae;
	__map_gbk2utf16[0x5b2e] = 0x8eb0;
	__map_gbk2utf16[0x5b2f] = 0x8eb1;
	__map_gbk2utf16[0x5b30] = 0x8eb3;
	__map_gbk2utf16[0x5b31] = 0x8eb4;
	__map_gbk2utf16[0x5b32] = 0x8eb5;
	__map_gbk2utf16[0x5b33] = 0x8eb6;
	__map_gbk2utf16[0x5b34] = 0x8eb7;
	__map_gbk2utf16[0x5b35] = 0x8eb8;
	__map_gbk2utf16[0x5b36] = 0x8eb9;
	__map_gbk2utf16[0x5b37] = 0x8ebb;
	__map_gbk2utf16[0x5b38] = 0x8ebc;
	__map_gbk2utf16[0x5b39] = 0x8ebd;
	__map_gbk2utf16[0x5b3a] = 0x8ebe;
	__map_gbk2utf16[0x5b3b] = 0x8ebf;
	__map_gbk2utf16[0x5b3c] = 0x8ec0;
	__map_gbk2utf16[0x5b3d] = 0x8ec1;
	__map_gbk2utf16[0x5b3e] = 0x8ec2;
	__map_gbk2utf16[0x5b40] = 0x8ec3;
	__map_gbk2utf16[0x5b41] = 0x8ec4;
	__map_gbk2utf16[0x5b42] = 0x8ec5;
	__map_gbk2utf16[0x5b43] = 0x8ec6;
	__map_gbk2utf16[0x5b44] = 0x8ec7;
	__map_gbk2utf16[0x5b45] = 0x8ec8;
	__map_gbk2utf16[0x5b46] = 0x8ec9;
	__map_gbk2utf16[0x5b47] = 0x8eca;
	__map_gbk2utf16[0x5b48] = 0x8ecb;
	__map_gbk2utf16[0x5b49] = 0x8ecc;
	__map_gbk2utf16[0x5b4a] = 0x8ecd;
	__map_gbk2utf16[0x5b4b] = 0x8ecf;
	__map_gbk2utf16[0x5b4c] = 0x8ed0;
	__map_gbk2utf16[0x5b4d] = 0x8ed1;
	__map_gbk2utf16[0x5b4e] = 0x8ed2;
	__map_gbk2utf16[0x5b4f] = 0x8ed3;
	__map_gbk2utf16[0x5b50] = 0x8ed4;
	__map_gbk2utf16[0x5b51] = 0x8ed5;
	__map_gbk2utf16[0x5b52] = 0x8ed6;
	__map_gbk2utf16[0x5b53] = 0x8ed7;
	__map_gbk2utf16[0x5b54] = 0x8ed8;
	__map_gbk2utf16[0x5b55] = 0x8ed9;
	__map_gbk2utf16[0x5b56] = 0x8eda;
	__map_gbk2utf16[0x5b57] = 0x8edb;
	__map_gbk2utf16[0x5b58] = 0x8edc;
	__map_gbk2utf16[0x5b59] = 0x8edd;
	__map_gbk2utf16[0x5b5a] = 0x8ede;
	__map_gbk2utf16[0x5b5b] = 0x8edf;
	__map_gbk2utf16[0x5b5c] = 0x8ee0;
	__map_gbk2utf16[0x5b5d] = 0x8ee1;
	__map_gbk2utf16[0x5b5e] = 0x8ee2;
	__map_gbk2utf16[0x5b5f] = 0x8ee3;
	__map_gbk2utf16[0x5b60] = 0x8ee4;
	__map_gbk2utf16[0x5b61] = 0x580b;
	__map_gbk2utf16[0x5b62] = 0x580d;
	__map_gbk2utf16[0x5b63] = 0x57fd;
	__map_gbk2utf16[0x5b64] = 0x57ed;
	__map_gbk2utf16[0x5b65] = 0x5800;
	__map_gbk2utf16[0x5b66] = 0x581e;
	__map_gbk2utf16[0x5b67] = 0x5819;
	__map_gbk2utf16[0x5b68] = 0x5844;
	__map_gbk2utf16[0x5b69] = 0x5820;
	__map_gbk2utf16[0x5b6a] = 0x5865;
	__map_gbk2utf16[0x5b6b] = 0x586c;
	__map_gbk2utf16[0x5b6c] = 0x5881;
	__map_gbk2utf16[0x5b6d] = 0x5889;
	__map_gbk2utf16[0x5b6e] = 0x589a;
	__map_gbk2utf16[0x5b6f] = 0x5880;
	__map_gbk2utf16[0x5b70] = 0x99a8;
	__map_gbk2utf16[0x5b71] = 0x9f19;
	__map_gbk2utf16[0x5b72] = 0x61ff;
	__map_gbk2utf16[0x5b73] = 0x8279;
	__map_gbk2utf16[0x5b74] = 0x827d;
	__map_gbk2utf16[0x5b75] = 0x827f;
	__map_gbk2utf16[0x5b76] = 0x828f;
	__map_gbk2utf16[0x5b77] = 0x828a;
	__map_gbk2utf16[0x5b78] = 0x82a8;
	__map_gbk2utf16[0x5b79] = 0x8284;
	__map_gbk2utf16[0x5b7a] = 0x828e;
	__map_gbk2utf16[0x5b7b] = 0x8291;
	__map_gbk2utf16[0x5b7c] = 0x8297;
	__map_gbk2utf16[0x5b7d] = 0x8299;
	__map_gbk2utf16[0x5b7e] = 0x82ab;
	__map_gbk2utf16[0x5b7f] = 0x82b8;
	__map_gbk2utf16[0x5b80] = 0x82be;
	__map_gbk2utf16[0x5b81] = 0x82b0;
	__map_gbk2utf16[0x5b82] = 0x82c8;
	__map_gbk2utf16[0x5b83] = 0x82ca;
	__map_gbk2utf16[0x5b84] = 0x82e3;
	__map_gbk2utf16[0x5b85] = 0x8298;
	__map_gbk2utf16[0x5b86] = 0x82b7;
	__map_gbk2utf16[0x5b87] = 0x82ae;
	__map_gbk2utf16[0x5b88] = 0x82cb;
	__map_gbk2utf16[0x5b89] = 0x82cc;
	__map_gbk2utf16[0x5b8a] = 0x82c1;
	__map_gbk2utf16[0x5b8b] = 0x82a9;
	__map_gbk2utf16[0x5b8c] = 0x82b4;
	__map_gbk2utf16[0x5b8d] = 0x82a1;
	__map_gbk2utf16[0x5b8e] = 0x82aa;
	__map_gbk2utf16[0x5b8f] = 0x829f;
	__map_gbk2utf16[0x5b90] = 0x82c4;
	__map_gbk2utf16[0x5b91] = 0x82ce;
	__map_gbk2utf16[0x5b92] = 0x82a4;
	__map_gbk2utf16[0x5b93] = 0x82e1;
	__map_gbk2utf16[0x5b94] = 0x8309;
	__map_gbk2utf16[0x5b95] = 0x82f7;
	__map_gbk2utf16[0x5b96] = 0x82e4;
	__map_gbk2utf16[0x5b97] = 0x830f;
	__map_gbk2utf16[0x5b98] = 0x8307;
	__map_gbk2utf16[0x5b99] = 0x82dc;
	__map_gbk2utf16[0x5b9a] = 0x82f4;
	__map_gbk2utf16[0x5b9b] = 0x82d2;
	__map_gbk2utf16[0x5b9c] = 0x82d8;
	__map_gbk2utf16[0x5b9d] = 0x830c;
	__map_gbk2utf16[0x5b9e] = 0x82fb;
	__map_gbk2utf16[0x5b9f] = 0x82d3;
	__map_gbk2utf16[0x5ba0] = 0x8311;
	__map_gbk2utf16[0x5ba1] = 0x831a;
	__map_gbk2utf16[0x5ba2] = 0x8306;
	__map_gbk2utf16[0x5ba3] = 0x8314;
	__map_gbk2utf16[0x5ba4] = 0x8315;
	__map_gbk2utf16[0x5ba5] = 0x82e0;
	__map_gbk2utf16[0x5ba6] = 0x82d5;
	__map_gbk2utf16[0x5ba7] = 0x831c;
	__map_gbk2utf16[0x5ba8] = 0x8351;
	__map_gbk2utf16[0x5ba9] = 0x835b;
	__map_gbk2utf16[0x5baa] = 0x835c;
	__map_gbk2utf16[0x5bab] = 0x8308;
	__map_gbk2utf16[0x5bac] = 0x8392;
	__map_gbk2utf16[0x5bad] = 0x833c;
	__map_gbk2utf16[0x5bae] = 0x8334;
	__map_gbk2utf16[0x5baf] = 0x8331;
	__map_gbk2utf16[0x5bb0] = 0x839b;
	__map_gbk2utf16[0x5bb1] = 0x835e;
	__map_gbk2utf16[0x5bb2] = 0x832f;
	__map_gbk2utf16[0x5bb3] = 0x834f;
	__map_gbk2utf16[0x5bb4] = 0x8347;
	__map_gbk2utf16[0x5bb5] = 0x8343;
	__map_gbk2utf16[0x5bb6] = 0x835f;
	__map_gbk2utf16[0x5bb7] = 0x8340;
	__map_gbk2utf16[0x5bb8] = 0x8317;
	__map_gbk2utf16[0x5bb9] = 0x8360;
	__map_gbk2utf16[0x5bba] = 0x832d;
	__map_gbk2utf16[0x5bbb] = 0x833a;
	__map_gbk2utf16[0x5bbc] = 0x8333;
	__map_gbk2utf16[0x5bbd] = 0x8366;
	__map_gbk2utf16[0x5bbe] = 0x8365;
	__map_gbk2utf16[0x5c00] = 0x8ee5;
	__map_gbk2utf16[0x5c01] = 0x8ee6;
	__map_gbk2utf16[0x5c02] = 0x8ee7;
	__map_gbk2utf16[0x5c03] = 0x8ee8;
	__map_gbk2utf16[0x5c04] = 0x8ee9;
	__map_gbk2utf16[0x5c05] = 0x8eea;
	__map_gbk2utf16[0x5c06] = 0x8eeb;
	__map_gbk2utf16[0x5c07] = 0x8eec;
	__map_gbk2utf16[0x5c08] = 0x8eed;
	__map_gbk2utf16[0x5c09] = 0x8eee;
	__map_gbk2utf16[0x5c0a] = 0x8eef;
	__map_gbk2utf16[0x5c0b] = 0x8ef0;
	__map_gbk2utf16[0x5c0c] = 0x8ef1;
	__map_gbk2utf16[0x5c0d] = 0x8ef2;
	__map_gbk2utf16[0x5c0e] = 0x8ef3;
	__map_gbk2utf16[0x5c0f] = 0x8ef4;
	__map_gbk2utf16[0x5c10] = 0x8ef5;
	__map_gbk2utf16[0x5c11] = 0x8ef6;
	__map_gbk2utf16[0x5c12] = 0x8ef7;
	__map_gbk2utf16[0x5c13] = 0x8ef8;
	__map_gbk2utf16[0x5c14] = 0x8ef9;
	__map_gbk2utf16[0x5c15] = 0x8efa;
	__map_gbk2utf16[0x5c16] = 0x8efb;
	__map_gbk2utf16[0x5c17] = 0x8efc;
	__map_gbk2utf16[0x5c18] = 0x8efd;
	__map_gbk2utf16[0x5c19] = 0x8efe;
	__map_gbk2utf16[0x5c1a] = 0x8eff;
	__map_gbk2utf16[0x5c1b] = 0x8f00;
	__map_gbk2utf16[0x5c1c] = 0x8f01;
	__map_gbk2utf16[0x5c1d] = 0x8f02;
	__map_gbk2utf16[0x5c1e] = 0x8f03;
	__map_gbk2utf16[0x5c1f] = 0x8f04;
	__map_gbk2utf16[0x5c20] = 0x8f05;
	__map_gbk2utf16[0x5c21] = 0x8f06;
	__map_gbk2utf16[0x5c22] = 0x8f07;
	__map_gbk2utf16[0x5c23] = 0x8f08;
	__map_gbk2utf16[0x5c24] = 0x8f09;
	__map_gbk2utf16[0x5c25] = 0x8f0a;
	__map_gbk2utf16[0x5c26] = 0x8f0b;
	__map_gbk2utf16[0x5c27] = 0x8f0c;
	__map_gbk2utf16[0x5c28] = 0x8f0d;
	__map_gbk2utf16[0x5c29] = 0x8f0e;
	__map_gbk2utf16[0x5c2a] = 0x8f0f;
	__map_gbk2utf16[0x5c2b] = 0x8f10;
	__map_gbk2utf16[0x5c2c] = 0x8f11;
	__map_gbk2utf16[0x5c2d] = 0x8f12;
	__map_gbk2utf16[0x5c2e] = 0x8f13;
	__map_gbk2utf16[0x5c2f] = 0x8f14;
	__map_gbk2utf16[0x5c30] = 0x8f15;
	__map_gbk2utf16[0x5c31] = 0x8f16;
	__map_gbk2utf16[0x5c32] = 0x8f17;
	__map_gbk2utf16[0x5c33] = 0x8f18;
	__map_gbk2utf16[0x5c34] = 0x8f19;
	__map_gbk2utf16[0x5c35] = 0x8f1a;
	__map_gbk2utf16[0x5c36] = 0x8f1b;
	__map_gbk2utf16[0x5c37] = 0x8f1c;
	__map_gbk2utf16[0x5c38] = 0x8f1d;
	__map_gbk2utf16[0x5c39] = 0x8f1e;
	__map_gbk2utf16[0x5c3a] = 0x8f1f;
	__map_gbk2utf16[0x5c3b] = 0x8f20;
	__map_gbk2utf16[0x5c3c] = 0x8f21;
	__map_gbk2utf16[0x5c3d] = 0x8f22;
	__map_gbk2utf16[0x5c3e] = 0x8f23;
	__map_gbk2utf16[0x5c40] = 0x8f24;
	__map_gbk2utf16[0x5c41] = 0x8f25;
	__map_gbk2utf16[0x5c42] = 0x8f26;
	__map_gbk2utf16[0x5c43] = 0x8f27;
	__map_gbk2utf16[0x5c44] = 0x8f28;
	__map_gbk2utf16[0x5c45] = 0x8f29;
	__map_gbk2utf16[0x5c46] = 0x8f2a;
	__map_gbk2utf16[0x5c47] = 0x8f2b;
	__map_gbk2utf16[0x5c48] = 0x8f2c;
	__map_gbk2utf16[0x5c49] = 0x8f2d;
	__map_gbk2utf16[0x5c4a] = 0x8f2e;
	__map_gbk2utf16[0x5c4b] = 0x8f2f;
	__map_gbk2utf16[0x5c4c] = 0x8f30;
	__map_gbk2utf16[0x5c4d] = 0x8f31;
	__map_gbk2utf16[0x5c4e] = 0x8f32;
	__map_gbk2utf16[0x5c4f] = 0x8f33;
	__map_gbk2utf16[0x5c50] = 0x8f34;
	__map_gbk2utf16[0x5c51] = 0x8f35;
	__map_gbk2utf16[0x5c52] = 0x8f36;
	__map_gbk2utf16[0x5c53] = 0x8f37;
	__map_gbk2utf16[0x5c54] = 0x8f38;
	__map_gbk2utf16[0x5c55] = 0x8f39;
	__map_gbk2utf16[0x5c56] = 0x8f3a;
	__map_gbk2utf16[0x5c57] = 0x8f3b;
	__map_gbk2utf16[0x5c58] = 0x8f3c;
	__map_gbk2utf16[0x5c59] = 0x8f3d;
	__map_gbk2utf16[0x5c5a] = 0x8f3e;
	__map_gbk2utf16[0x5c5b] = 0x8f3f;
	__map_gbk2utf16[0x5c5c] = 0x8f40;
	__map_gbk2utf16[0x5c5d] = 0x8f41;
	__map_gbk2utf16[0x5c5e] = 0x8f42;
	__map_gbk2utf16[0x5c5f] = 0x8f43;
	__map_gbk2utf16[0x5c60] = 0x8f44;
	__map_gbk2utf16[0x5c61] = 0x8368;
	__map_gbk2utf16[0x5c62] = 0x831b;
	__map_gbk2utf16[0x5c63] = 0x8369;
	__map_gbk2utf16[0x5c64] = 0x836c;
	__map_gbk2utf16[0x5c65] = 0x836a;
	__map_gbk2utf16[0x5c66] = 0x836d;
	__map_gbk2utf16[0x5c67] = 0x836e;
	__map_gbk2utf16[0x5c68] = 0x83b0;
	__map_gbk2utf16[0x5c69] = 0x8378;
	__map_gbk2utf16[0x5c6a] = 0x83b3;
	__map_gbk2utf16[0x5c6b] = 0x83b4;
	__map_gbk2utf16[0x5c6c] = 0x83a0;
	__map_gbk2utf16[0x5c6d] = 0x83aa;
	__map_gbk2utf16[0x5c6e] = 0x8393;
	__map_gbk2utf16[0x5c6f] = 0x839c;
	__map_gbk2utf16[0x5c70] = 0x8385;
	__map_gbk2utf16[0x5c71] = 0x837c;
	__map_gbk2utf16[0x5c72] = 0x83b6;
	__map_gbk2utf16[0x5c73] = 0x83a9;
	__map_gbk2utf16[0x5c74] = 0x837d;
	__map_gbk2utf16[0x5c75] = 0x83b8;
	__map_gbk2utf16[0x5c76] = 0x837b;
	__map_gbk2utf16[0x5c77] = 0x8398;
	__map_gbk2utf16[0x5c78] = 0x839e;
	__map_gbk2utf16[0x5c79] = 0x83a8;
	__map_gbk2utf16[0x5c7a] = 0x83ba;
	__map_gbk2utf16[0x5c7b] = 0x83bc;
	__map_gbk2utf16[0x5c7c] = 0x83c1;
	__map_gbk2utf16[0x5c7d] = 0x8401;
	__map_gbk2utf16[0x5c7e] = 0x83e5;
	__map_gbk2utf16[0x5c7f] = 0x83d8;
	__map_gbk2utf16[0x5c80] = 0x5807;
	__map_gbk2utf16[0x5c81] = 0x8418;
	__map_gbk2utf16[0x5c82] = 0x840b;
	__map_gbk2utf16[0x5c83] = 0x83dd;
	__map_gbk2utf16[0x5c84] = 0x83fd;
	__map_gbk2utf16[0x5c85] = 0x83d6;
	__map_gbk2utf16[0x5c86] = 0x841c;
	__map_gbk2utf16[0x5c87] = 0x8438;
	__map_gbk2utf16[0x5c88] = 0x8411;
	__map_gbk2utf16[0x5c89] = 0x8406;
	__map_gbk2utf16[0x5c8a] = 0x83d4;
	__map_gbk2utf16[0x5c8b] = 0x83df;
	__map_gbk2utf16[0x5c8c] = 0x840f;
	__map_gbk2utf16[0x5c8d] = 0x8403;
	__map_gbk2utf16[0x5c8e] = 0x83f8;
	__map_gbk2utf16[0x5c8f] = 0x83f9;
	__map_gbk2utf16[0x5c90] = 0x83ea;
	__map_gbk2utf16[0x5c91] = 0x83c5;
	__map_gbk2utf16[0x5c92] = 0x83c0;
	__map_gbk2utf16[0x5c93] = 0x8426;
	__map_gbk2utf16[0x5c94] = 0x83f0;
	__map_gbk2utf16[0x5c95] = 0x83e1;
	__map_gbk2utf16[0x5c96] = 0x845c;
	__map_gbk2utf16[0x5c97] = 0x8451;
	__map_gbk2utf16[0x5c98] = 0x845a;
	__map_gbk2utf16[0x5c99] = 0x8459;
	__map_gbk2utf16[0x5c9a] = 0x8473;
	__map_gbk2utf16[0x5c9b] = 0x8487;
	__map_gbk2utf16[0x5c9c] = 0x8488;
	__map_gbk2utf16[0x5c9d] = 0x847a;
	__map_gbk2utf16[0x5c9e] = 0x8489;
	__map_gbk2utf16[0x5c9f] = 0x8478;
	__map_gbk2utf16[0x5ca0] = 0x843c;
	__map_gbk2utf16[0x5ca1] = 0x8446;
	__map_gbk2utf16[0x5ca2] = 0x8469;
	__map_gbk2utf16[0x5ca3] = 0x8476;
	__map_gbk2utf16[0x5ca4] = 0x848c;
	__map_gbk2utf16[0x5ca5] = 0x848e;
	__map_gbk2utf16[0x5ca6] = 0x8431;
	__map_gbk2utf16[0x5ca7] = 0x846d;
	__map_gbk2utf16[0x5ca8] = 0x84c1;
	__map_gbk2utf16[0x5ca9] = 0x84cd;
	__map_gbk2utf16[0x5caa] = 0x84d0;
	__map_gbk2utf16[0x5cab] = 0x84e6;
	__map_gbk2utf16[0x5cac] = 0x84bd;
	__map_gbk2utf16[0x5cad] = 0x84d3;
	__map_gbk2utf16[0x5cae] = 0x84ca;
	__map_gbk2utf16[0x5caf] = 0x84bf;
	__map_gbk2utf16[0x5cb0] = 0x84ba;
	__map_gbk2utf16[0x5cb1] = 0x84e0;
	__map_gbk2utf16[0x5cb2] = 0x84a1;
	__map_gbk2utf16[0x5cb3] = 0x84b9;
	__map_gbk2utf16[0x5cb4] = 0x84b4;
	__map_gbk2utf16[0x5cb5] = 0x8497;
	__map_gbk2utf16[0x5cb6] = 0x84e5;
	__map_gbk2utf16[0x5cb7] = 0x84e3;
	__map_gbk2utf16[0x5cb8] = 0x850c;
	__map_gbk2utf16[0x5cb9] = 0x750d;
	__map_gbk2utf16[0x5cba] = 0x8538;
	__map_gbk2utf16[0x5cbb] = 0x84f0;
	__map_gbk2utf16[0x5cbc] = 0x8539;
	__map_gbk2utf16[0x5cbd] = 0x851f;
	__map_gbk2utf16[0x5cbe] = 0x853a;
	__map_gbk2utf16[0x5d00] = 0x8f45;
	__map_gbk2utf16[0x5d01] = 0x8f46;
	__map_gbk2utf16[0x5d02] = 0x8f47;
	__map_gbk2utf16[0x5d03] = 0x8f48;
	__map_gbk2utf16[0x5d04] = 0x8f49;
	__map_gbk2utf16[0x5d05] = 0x8f4a;
	__map_gbk2utf16[0x5d06] = 0x8f4b;
	__map_gbk2utf16[0x5d07] = 0x8f4c;
	__map_gbk2utf16[0x5d08] = 0x8f4d;
	__map_gbk2utf16[0x5d09] = 0x8f4e;
	__map_gbk2utf16[0x5d0a] = 0x8f4f;
	__map_gbk2utf16[0x5d0b] = 0x8f50;
	__map_gbk2utf16[0x5d0c] = 0x8f51;
	__map_gbk2utf16[0x5d0d] = 0x8f52;
	__map_gbk2utf16[0x5d0e] = 0x8f53;
	__map_gbk2utf16[0x5d0f] = 0x8f54;
	__map_gbk2utf16[0x5d10] = 0x8f55;
	__map_gbk2utf16[0x5d11] = 0x8f56;
	__map_gbk2utf16[0x5d12] = 0x8f57;
	__map_gbk2utf16[0x5d13] = 0x8f58;
	__map_gbk2utf16[0x5d14] = 0x8f59;
	__map_gbk2utf16[0x5d15] = 0x8f5a;
	__map_gbk2utf16[0x5d16] = 0x8f5b;
	__map_gbk2utf16[0x5d17] = 0x8f5c;
	__map_gbk2utf16[0x5d18] = 0x8f5d;
	__map_gbk2utf16[0x5d19] = 0x8f5e;
	__map_gbk2utf16[0x5d1a] = 0x8f5f;
	__map_gbk2utf16[0x5d1b] = 0x8f60;
	__map_gbk2utf16[0x5d1c] = 0x8f61;
	__map_gbk2utf16[0x5d1d] = 0x8f62;
	__map_gbk2utf16[0x5d1e] = 0x8f63;
	__map_gbk2utf16[0x5d1f] = 0x8f64;
	__map_gbk2utf16[0x5d20] = 0x8f65;
	__map_gbk2utf16[0x5d21] = 0x8f6a;
	__map_gbk2utf16[0x5d22] = 0x8f80;
	__map_gbk2utf16[0x5d23] = 0x8f8c;
	__map_gbk2utf16[0x5d24] = 0x8f92;
	__map_gbk2utf16[0x5d25] = 0x8f9d;
	__map_gbk2utf16[0x5d26] = 0x8fa0;
	__map_gbk2utf16[0x5d27] = 0x8fa1;
	__map_gbk2utf16[0x5d28] = 0x8fa2;
	__map_gbk2utf16[0x5d29] = 0x8fa4;
	__map_gbk2utf16[0x5d2a] = 0x8fa5;
	__map_gbk2utf16[0x5d2b] = 0x8fa6;
	__map_gbk2utf16[0x5d2c] = 0x8fa7;
	__map_gbk2utf16[0x5d2d] = 0x8faa;
	__map_gbk2utf16[0x5d2e] = 0x8fac;
	__map_gbk2utf16[0x5d2f] = 0x8fad;
	__map_gbk2utf16[0x5d30] = 0x8fae;
	__map_gbk2utf16[0x5d31] = 0x8faf;
	__map_gbk2utf16[0x5d32] = 0x8fb2;
	__map_gbk2utf16[0x5d33] = 0x8fb3;
	__map_gbk2utf16[0x5d34] = 0x8fb4;
	__map_gbk2utf16[0x5d35] = 0x8fb5;
	__map_gbk2utf16[0x5d36] = 0x8fb7;
	__map_gbk2utf16[0x5d37] = 0x8fb8;
	__map_gbk2utf16[0x5d38] = 0x8fba;
	__map_gbk2utf16[0x5d39] = 0x8fbb;
	__map_gbk2utf16[0x5d3a] = 0x8fbc;
	__map_gbk2utf16[0x5d3b] = 0x8fbf;
	__map_gbk2utf16[0x5d3c] = 0x8fc0;
	__map_gbk2utf16[0x5d3d] = 0x8fc3;
	__map_gbk2utf16[0x5d3e] = 0x8fc6;
	__map_gbk2utf16[0x5d40] = 0x8fc9;
	__map_gbk2utf16[0x5d41] = 0x8fca;
	__map_gbk2utf16[0x5d42] = 0x8fcb;
	__map_gbk2utf16[0x5d43] = 0x8fcc;
	__map_gbk2utf16[0x5d44] = 0x8fcd;
	__map_gbk2utf16[0x5d45] = 0x8fcf;
	__map_gbk2utf16[0x5d46] = 0x8fd2;
	__map_gbk2utf16[0x5d47] = 0x8fd6;
	__map_gbk2utf16[0x5d48] = 0x8fd7;
	__map_gbk2utf16[0x5d49] = 0x8fda;
	__map_gbk2utf16[0x5d4a] = 0x8fe0;
	__map_gbk2utf16[0x5d4b] = 0x8fe1;
	__map_gbk2utf16[0x5d4c] = 0x8fe3;
	__map_gbk2utf16[0x5d4d] = 0x8fe7;
	__map_gbk2utf16[0x5d4e] = 0x8fec;
	__map_gbk2utf16[0x5d4f] = 0x8fef;
	__map_gbk2utf16[0x5d50] = 0x8ff1;
	__map_gbk2utf16[0x5d51] = 0x8ff2;
	__map_gbk2utf16[0x5d52] = 0x8ff4;
	__map_gbk2utf16[0x5d53] = 0x8ff5;
	__map_gbk2utf16[0x5d54] = 0x8ff6;
	__map_gbk2utf16[0x5d55] = 0x8ffa;
	__map_gbk2utf16[0x5d56] = 0x8ffb;
	__map_gbk2utf16[0x5d57] = 0x8ffc;
	__map_gbk2utf16[0x5d58] = 0x8ffe;
	__map_gbk2utf16[0x5d59] = 0x8fff;
	__map_gbk2utf16[0x5d5a] = 0x9007;
	__map_gbk2utf16[0x5d5b] = 0x9008;
	__map_gbk2utf16[0x5d5c] = 0x900c;
	__map_gbk2utf16[0x5d5d] = 0x900e;
	__map_gbk2utf16[0x5d5e] = 0x9013;
	__map_gbk2utf16[0x5d5f] = 0x9015;
	__map_gbk2utf16[0x5d60] = 0x9018;
	__map_gbk2utf16[0x5d61] = 0x8556;
	__map_gbk2utf16[0x5d62] = 0x853b;
	__map_gbk2utf16[0x5d63] = 0x84ff;
	__map_gbk2utf16[0x5d64] = 0x84fc;
	__map_gbk2utf16[0x5d65] = 0x8559;
	__map_gbk2utf16[0x5d66] = 0x8548;
	__map_gbk2utf16[0x5d67] = 0x8568;
	__map_gbk2utf16[0x5d68] = 0x8564;
	__map_gbk2utf16[0x5d69] = 0x855e;
	__map_gbk2utf16[0x5d6a] = 0x857a;
	__map_gbk2utf16[0x5d6b] = 0x77a2;
	__map_gbk2utf16[0x5d6c] = 0x8543;
	__map_gbk2utf16[0x5d6d] = 0x8572;
	__map_gbk2utf16[0x5d6e] = 0x857b;
	__map_gbk2utf16[0x5d6f] = 0x85a4;
	__map_gbk2utf16[0x5d70] = 0x85a8;
	__map_gbk2utf16[0x5d71] = 0x8587;
	__map_gbk2utf16[0x5d72] = 0x858f;
	__map_gbk2utf16[0x5d73] = 0x8579;
	__map_gbk2utf16[0x5d74] = 0x85ae;
	__map_gbk2utf16[0x5d75] = 0x859c;
	__map_gbk2utf16[0x5d76] = 0x8585;
	__map_gbk2utf16[0x5d77] = 0x85b9;
	__map_gbk2utf16[0x5d78] = 0x85b7;
	__map_gbk2utf16[0x5d79] = 0x85b0;
	__map_gbk2utf16[0x5d7a] = 0x85d3;
	__map_gbk2utf16[0x5d7b] = 0x85c1;
	__map_gbk2utf16[0x5d7c] = 0x85dc;
	__map_gbk2utf16[0x5d7d] = 0x85ff;
	__map_gbk2utf16[0x5d7e] = 0x8627;
	__map_gbk2utf16[0x5d7f] = 0x8605;
	__map_gbk2utf16[0x5d80] = 0x8629;
	__map_gbk2utf16[0x5d81] = 0x8616;
	__map_gbk2utf16[0x5d82] = 0x863c;
	__map_gbk2utf16[0x5d83] = 0x5efe;
	__map_gbk2utf16[0x5d84] = 0x5f08;
	__map_gbk2utf16[0x5d85] = 0x593c;
	__map_gbk2utf16[0x5d86] = 0x5941;
	__map_gbk2utf16[0x5d87] = 0x8037;
	__map_gbk2utf16[0x5d88] = 0x5955;
	__map_gbk2utf16[0x5d89] = 0x595a;
	__map_gbk2utf16[0x5d8a] = 0x5958;
	__map_gbk2utf16[0x5d8b] = 0x530f;
	__map_gbk2utf16[0x5d8c] = 0x5c22;
	__map_gbk2utf16[0x5d8d] = 0x5c25;
	__map_gbk2utf16[0x5d8e] = 0x5c2c;
	__map_gbk2utf16[0x5d8f] = 0x5c34;
	__map_gbk2utf16[0x5d90] = 0x624c;
	__map_gbk2utf16[0x5d91] = 0x626a;
	__map_gbk2utf16[0x5d92] = 0x629f;
	__map_gbk2utf16[0x5d93] = 0x62bb;
	__map_gbk2utf16[0x5d94] = 0x62ca;
	__map_gbk2utf16[0x5d95] = 0x62da;
	__map_gbk2utf16[0x5d96] = 0x62d7;
	__map_gbk2utf16[0x5d97] = 0x62ee;
	__map_gbk2utf16[0x5d98] = 0x6322;
	__map_gbk2utf16[0x5d99] = 0x62f6;
	__map_gbk2utf16[0x5d9a] = 0x6339;
	__map_gbk2utf16[0x5d9b] = 0x634b;
	__map_gbk2utf16[0x5d9c] = 0x6343;
	__map_gbk2utf16[0x5d9d] = 0x63ad;
	__map_gbk2utf16[0x5d9e] = 0x63f6;
	__map_gbk2utf16[0x5d9f] = 0x6371;
	__map_gbk2utf16[0x5da0] = 0x637a;
	__map_gbk2utf16[0x5da1] = 0x638e;
	__map_gbk2utf16[0x5da2] = 0x63b4;
	__map_gbk2utf16[0x5da3] = 0x636d;
	__map_gbk2utf16[0x5da4] = 0x63ac;
	__map_gbk2utf16[0x5da5] = 0x638a;
	__map_gbk2utf16[0x5da6] = 0x6369;
	__map_gbk2utf16[0x5da7] = 0x63ae;
	__map_gbk2utf16[0x5da8] = 0x63bc;
	__map_gbk2utf16[0x5da9] = 0x63f2;
	__map_gbk2utf16[0x5daa] = 0x63f8;
	__map_gbk2utf16[0x5dab] = 0x63e0;
	__map_gbk2utf16[0x5dac] = 0x63ff;
	__map_gbk2utf16[0x5dad] = 0x63c4;
	__map_gbk2utf16[0x5dae] = 0x63de;
	__map_gbk2utf16[0x5daf] = 0x63ce;
	__map_gbk2utf16[0x5db0] = 0x6452;
	__map_gbk2utf16[0x5db1] = 0x63c6;
	__map_gbk2utf16[0x5db2] = 0x63be;
	__map_gbk2utf16[0x5db3] = 0x6445;
	__map_gbk2utf16[0x5db4] = 0x6441;
	__map_gbk2utf16[0x5db5] = 0x640b;
	__map_gbk2utf16[0x5db6] = 0x641b;
	__map_gbk2utf16[0x5db7] = 0x6420;
	__map_gbk2utf16[0x5db8] = 0x640c;
	__map_gbk2utf16[0x5db9] = 0x6426;
	__map_gbk2utf16[0x5dba] = 0x6421;
	__map_gbk2utf16[0x5dbb] = 0x645e;
	__map_gbk2utf16[0x5dbc] = 0x6484;
	__map_gbk2utf16[0x5dbd] = 0x646d;
	__map_gbk2utf16[0x5dbe] = 0x6496;
	__map_gbk2utf16[0x5e00] = 0x9019;
	__map_gbk2utf16[0x5e01] = 0x901c;
	__map_gbk2utf16[0x5e02] = 0x9023;
	__map_gbk2utf16[0x5e03] = 0x9024;
	__map_gbk2utf16[0x5e04] = 0x9025;
	__map_gbk2utf16[0x5e05] = 0x9027;
	__map_gbk2utf16[0x5e06] = 0x9028;
	__map_gbk2utf16[0x5e07] = 0x9029;
	__map_gbk2utf16[0x5e08] = 0x902a;
	__map_gbk2utf16[0x5e09] = 0x902b;
	__map_gbk2utf16[0x5e0a] = 0x902c;
	__map_gbk2utf16[0x5e0b] = 0x9030;
	__map_gbk2utf16[0x5e0c] = 0x9031;
	__map_gbk2utf16[0x5e0d] = 0x9032;
	__map_gbk2utf16[0x5e0e] = 0x9033;
	__map_gbk2utf16[0x5e0f] = 0x9034;
	__map_gbk2utf16[0x5e10] = 0x9037;
	__map_gbk2utf16[0x5e11] = 0x9039;
	__map_gbk2utf16[0x5e12] = 0x903a;
	__map_gbk2utf16[0x5e13] = 0x903d;
	__map_gbk2utf16[0x5e14] = 0x903f;
	__map_gbk2utf16[0x5e15] = 0x9040;
	__map_gbk2utf16[0x5e16] = 0x9043;
	__map_gbk2utf16[0x5e17] = 0x9045;
	__map_gbk2utf16[0x5e18] = 0x9046;
	__map_gbk2utf16[0x5e19] = 0x9048;
	__map_gbk2utf16[0x5e1a] = 0x9049;
	__map_gbk2utf16[0x5e1b] = 0x904a;
	__map_gbk2utf16[0x5e1c] = 0x904b;
	__map_gbk2utf16[0x5e1d] = 0x904c;
	__map_gbk2utf16[0x5e1e] = 0x904e;
	__map_gbk2utf16[0x5e1f] = 0x9054;
	__map_gbk2utf16[0x5e20] = 0x9055;
	__map_gbk2utf16[0x5e21] = 0x9056;
	__map_gbk2utf16[0x5e22] = 0x9059;
	__map_gbk2utf16[0x5e23] = 0x905a;
	__map_gbk2utf16[0x5e24] = 0x905c;
	__map_gbk2utf16[0x5e25] = 0x905d;
	__map_gbk2utf16[0x5e26] = 0x905e;
	__map_gbk2utf16[0x5e27] = 0x905f;
	__map_gbk2utf16[0x5e28] = 0x9060;
	__map_gbk2utf16[0x5e29] = 0x9061;
	__map_gbk2utf16[0x5e2a] = 0x9064;
	__map_gbk2utf16[0x5e2b] = 0x9066;
	__map_gbk2utf16[0x5e2c] = 0x9067;
	__map_gbk2utf16[0x5e2d] = 0x9069;
	__map_gbk2utf16[0x5e2e] = 0x906a;
	__map_gbk2utf16[0x5e2f] = 0x906b;
	__map_gbk2utf16[0x5e30] = 0x906c;
	__map_gbk2utf16[0x5e31] = 0x906f;
	__map_gbk2utf16[0x5e32] = 0x9070;
	__map_gbk2utf16[0x5e33] = 0x9071;
	__map_gbk2utf16[0x5e34] = 0x9072;
	__map_gbk2utf16[0x5e35] = 0x9073;
	__map_gbk2utf16[0x5e36] = 0x9076;
	__map_gbk2utf16[0x5e37] = 0x9077;
	__map_gbk2utf16[0x5e38] = 0x9078;
	__map_gbk2utf16[0x5e39] = 0x9079;
	__map_gbk2utf16[0x5e3a] = 0x907a;
	__map_gbk2utf16[0x5e3b] = 0x907b;
	__map_gbk2utf16[0x5e3c] = 0x907c;
	__map_gbk2utf16[0x5e3d] = 0x907e;
	__map_gbk2utf16[0x5e3e] = 0x9081;
	__map_gbk2utf16[0x5e40] = 0x9084;
	__map_gbk2utf16[0x5e41] = 0x9085;
	__map_gbk2utf16[0x5e42] = 0x9086;
	__map_gbk2utf16[0x5e43] = 0x9087;
	__map_gbk2utf16[0x5e44] = 0x9089;
	__map_gbk2utf16[0x5e45] = 0x908a;
	__map_gbk2utf16[0x5e46] = 0x908c;
	__map_gbk2utf16[0x5e47] = 0x908d;
	__map_gbk2utf16[0x5e48] = 0x908e;
	__map_gbk2utf16[0x5e49] = 0x908f;
	__map_gbk2utf16[0x5e4a] = 0x9090;
	__map_gbk2utf16[0x5e4b] = 0x9092;
	__map_gbk2utf16[0x5e4c] = 0x9094;
	__map_gbk2utf16[0x5e4d] = 0x9096;
	__map_gbk2utf16[0x5e4e] = 0x9098;
	__map_gbk2utf16[0x5e4f] = 0x909a;
	__map_gbk2utf16[0x5e50] = 0x909c;
	__map_gbk2utf16[0x5e51] = 0x909e;
	__map_gbk2utf16[0x5e52] = 0x909f;
	__map_gbk2utf16[0x5e53] = 0x90a0;
	__map_gbk2utf16[0x5e54] = 0x90a4;
	__map_gbk2utf16[0x5e55] = 0x90a5;
	__map_gbk2utf16[0x5e56] = 0x90a7;
	__map_gbk2utf16[0x5e57] = 0x90a8;
	__map_gbk2utf16[0x5e58] = 0x90a9;
	__map_gbk2utf16[0x5e59] = 0x90ab;
	__map_gbk2utf16[0x5e5a] = 0x90ad;
	__map_gbk2utf16[0x5e5b] = 0x90b2;
	__map_gbk2utf16[0x5e5c] = 0x90b7;
	__map_gbk2utf16[0x5e5d] = 0x90bc;
	__map_gbk2utf16[0x5e5e] = 0x90bd;
	__map_gbk2utf16[0x5e5f] = 0x90bf;
	__map_gbk2utf16[0x5e60] = 0x90c0;
	__map_gbk2utf16[0x5e61] = 0x647a;
	__map_gbk2utf16[0x5e62] = 0x64b7;
	__map_gbk2utf16[0x5e63] = 0x64b8;
	__map_gbk2utf16[0x5e64] = 0x6499;
	__map_gbk2utf16[0x5e65] = 0x64ba;
	__map_gbk2utf16[0x5e66] = 0x64c0;
	__map_gbk2utf16[0x5e67] = 0x64d0;
	__map_gbk2utf16[0x5e68] = 0x64d7;
	__map_gbk2utf16[0x5e69] = 0x64e4;
	__map_gbk2utf16[0x5e6a] = 0x64e2;
	__map_gbk2utf16[0x5e6b] = 0x6509;
	__map_gbk2utf16[0x5e6c] = 0x6525;
	__map_gbk2utf16[0x5e6d] = 0x652e;
	__map_gbk2utf16[0x5e6e] = 0x5f0b;
	__map_gbk2utf16[0x5e6f] = 0x5fd2;
	__map_gbk2utf16[0x5e70] = 0x7519;
	__map_gbk2utf16[0x5e71] = 0x5f11;
	__map_gbk2utf16[0x5e72] = 0x535f;
	__map_gbk2utf16[0x5e73] = 0x53f1;
	__map_gbk2utf16[0x5e74] = 0x53fd;
	__map_gbk2utf16[0x5e75] = 0x53e9;
	__map_gbk2utf16[0x5e76] = 0x53e8;
	__map_gbk2utf16[0x5e77] = 0x53fb;
	__map_gbk2utf16[0x5e78] = 0x5412;
	__map_gbk2utf16[0x5e79] = 0x5416;
	__map_gbk2utf16[0x5e7a] = 0x5406;
	__map_gbk2utf16[0x5e7b] = 0x544b;
	__map_gbk2utf16[0x5e7c] = 0x5452;
	__map_gbk2utf16[0x5e7d] = 0x5453;
	__map_gbk2utf16[0x5e7e] = 0x5454;
	__map_gbk2utf16[0x5e7f] = 0x5456;
	__map_gbk2utf16[0x5e80] = 0x5443;
	__map_gbk2utf16[0x5e81] = 0x5421;
	__map_gbk2utf16[0x5e82] = 0x5457;
	__map_gbk2utf16[0x5e83] = 0x5459;
	__map_gbk2utf16[0x5e84] = 0x5423;
	__map_gbk2utf16[0x5e85] = 0x5432;
	__map_gbk2utf16[0x5e86] = 0x5482;
	__map_gbk2utf16[0x5e87] = 0x5494;
	__map_gbk2utf16[0x5e88] = 0x5477;
	__map_gbk2utf16[0x5e89] = 0x5471;
	__map_gbk2utf16[0x5e8a] = 0x5464;
	__map_gbk2utf16[0x5e8b] = 0x549a;
	__map_gbk2utf16[0x5e8c] = 0x549b;
	__map_gbk2utf16[0x5e8d] = 0x5484;
	__map_gbk2utf16[0x5e8e] = 0x5476;
	__map_gbk2utf16[0x5e8f] = 0x5466;
	__map_gbk2utf16[0x5e90] = 0x549d;
	__map_gbk2utf16[0x5e91] = 0x54d0;
	__map_gbk2utf16[0x5e92] = 0x54ad;
	__map_gbk2utf16[0x5e93] = 0x54c2;
	__map_gbk2utf16[0x5e94] = 0x54b4;
	__map_gbk2utf16[0x5e95] = 0x54d2;
	__map_gbk2utf16[0x5e96] = 0x54a7;
	__map_gbk2utf16[0x5e97] = 0x54a6;
	__map_gbk2utf16[0x5e98] = 0x54d3;
	__map_gbk2utf16[0x5e99] = 0x54d4;
	__map_gbk2utf16[0x5e9a] = 0x5472;
	__map_gbk2utf16[0x5e9b] = 0x54a3;
	__map_gbk2utf16[0x5e9c] = 0x54d5;
	__map_gbk2utf16[0x5e9d] = 0x54bb;
	__map_gbk2utf16[0x5e9e] = 0x54bf;
	__map_gbk2utf16[0x5e9f] = 0x54cc;
	__map_gbk2utf16[0x5ea0] = 0x54d9;
	__map_gbk2utf16[0x5ea1] = 0x54da;
	__map_gbk2utf16[0x5ea2] = 0x54dc;
	__map_gbk2utf16[0x5ea3] = 0x54a9;
	__map_gbk2utf16[0x5ea4] = 0x54aa;
	__map_gbk2utf16[0x5ea5] = 0x54a4;
	__map_gbk2utf16[0x5ea6] = 0x54dd;
	__map_gbk2utf16[0x5ea7] = 0x54cf;
	__map_gbk2utf16[0x5ea8] = 0x54de;
	__map_gbk2utf16[0x5ea9] = 0x551b;
	__map_gbk2utf16[0x5eaa] = 0x54e7;
	__map_gbk2utf16[0x5eab] = 0x5520;
	__map_gbk2utf16[0x5eac] = 0x54fd;
	__map_gbk2utf16[0x5ead] = 0x5514;
	__map_gbk2utf16[0x5eae] = 0x54f3;
	__map_gbk2utf16[0x5eaf] = 0x5522;
	__map_gbk2utf16[0x5eb0] = 0x5523;
	__map_gbk2utf16[0x5eb1] = 0x550f;
	__map_gbk2utf16[0x5eb2] = 0x5511;
	__map_gbk2utf16[0x5eb3] = 0x5527;
	__map_gbk2utf16[0x5eb4] = 0x552a;
	__map_gbk2utf16[0x5eb5] = 0x5567;
	__map_gbk2utf16[0x5eb6] = 0x558f;
	__map_gbk2utf16[0x5eb7] = 0x55b5;
	__map_gbk2utf16[0x5eb8] = 0x5549;
	__map_gbk2utf16[0x5eb9] = 0x556d;
	__map_gbk2utf16[0x5eba] = 0x5541;
	__map_gbk2utf16[0x5ebb] = 0x5555;
	__map_gbk2utf16[0x5ebc] = 0x553f;
	__map_gbk2utf16[0x5ebd] = 0x5550;
	__map_gbk2utf16[0x5ebe] = 0x553c;
	__map_gbk2utf16[0x5f00] = 0x90c2;
	__map_gbk2utf16[0x5f01] = 0x90c3;
	__map_gbk2utf16[0x5f02] = 0x90c6;
	__map_gbk2utf16[0x5f03] = 0x90c8;
	__map_gbk2utf16[0x5f04] = 0x90c9;
	__map_gbk2utf16[0x5f05] = 0x90cb;
	__map_gbk2utf16[0x5f06] = 0x90cc;
	__map_gbk2utf16[0x5f07] = 0x90cd;
	__map_gbk2utf16[0x5f08] = 0x90d2;
	__map_gbk2utf16[0x5f09] = 0x90d4;
	__map_gbk2utf16[0x5f0a] = 0x90d5;
	__map_gbk2utf16[0x5f0b] = 0x90d6;
	__map_gbk2utf16[0x5f0c] = 0x90d8;
	__map_gbk2utf16[0x5f0d] = 0x90d9;
	__map_gbk2utf16[0x5f0e] = 0x90da;
	__map_gbk2utf16[0x5f0f] = 0x90de;
	__map_gbk2utf16[0x5f10] = 0x90df;
	__map_gbk2utf16[0x5f11] = 0x90e0;
	__map_gbk2utf16[0x5f12] = 0x90e3;
	__map_gbk2utf16[0x5f13] = 0x90e4;
	__map_gbk2utf16[0x5f14] = 0x90e5;
	__map_gbk2utf16[0x5f15] = 0x90e9;
	__map_gbk2utf16[0x5f16] = 0x90ea;
	__map_gbk2utf16[0x5f17] = 0x90ec;
	__map_gbk2utf16[0x5f18] = 0x90ee;
	__map_gbk2utf16[0x5f19] = 0x90f0;
	__map_gbk2utf16[0x5f1a] = 0x90f1;
	__map_gbk2utf16[0x5f1b] = 0x90f2;
	__map_gbk2utf16[0x5f1c] = 0x90f3;
	__map_gbk2utf16[0x5f1d] = 0x90f5;
	__map_gbk2utf16[0x5f1e] = 0x90f6;
	__map_gbk2utf16[0x5f1f] = 0x90f7;
	__map_gbk2utf16[0x5f20] = 0x90f9;
	__map_gbk2utf16[0x5f21] = 0x90fa;
	__map_gbk2utf16[0x5f22] = 0x90fb;
	__map_gbk2utf16[0x5f23] = 0x90fc;
	__map_gbk2utf16[0x5f24] = 0x90ff;
	__map_gbk2utf16[0x5f25] = 0x9100;
	__map_gbk2utf16[0x5f26] = 0x9101;
	__map_gbk2utf16[0x5f27] = 0x9103;
	__map_gbk2utf16[0x5f28] = 0x9105;
	__map_gbk2utf16[0x5f29] = 0x9106;
	__map_gbk2utf16[0x5f2a] = 0x9107;
	__map_gbk2utf16[0x5f2b] = 0x9108;
	__map_gbk2utf16[0x5f2c] = 0x9109;
	__map_gbk2utf16[0x5f2d] = 0x910a;
	__map_gbk2utf16[0x5f2e] = 0x910b;
	__map_gbk2utf16[0x5f2f] = 0x910c;
	__map_gbk2utf16[0x5f30] = 0x910d;
	__map_gbk2utf16[0x5f31] = 0x910e;
	__map_gbk2utf16[0x5f32] = 0x910f;
	__map_gbk2utf16[0x5f33] = 0x9110;
	__map_gbk2utf16[0x5f34] = 0x9111;
	__map_gbk2utf16[0x5f35] = 0x9112;
	__map_gbk2utf16[0x5f36] = 0x9113;
	__map_gbk2utf16[0x5f37] = 0x9114;
	__map_gbk2utf16[0x5f38] = 0x9115;
	__map_gbk2utf16[0x5f39] = 0x9116;
	__map_gbk2utf16[0x5f3a] = 0x9117;
	__map_gbk2utf16[0x5f3b] = 0x9118;
	__map_gbk2utf16[0x5f3c] = 0x911a;
	__map_gbk2utf16[0x5f3d] = 0x911b;
	__map_gbk2utf16[0x5f3e] = 0x911c;
	__map_gbk2utf16[0x5f40] = 0x911d;
	__map_gbk2utf16[0x5f41] = 0x911f;
	__map_gbk2utf16[0x5f42] = 0x9120;
	__map_gbk2utf16[0x5f43] = 0x9121;
	__map_gbk2utf16[0x5f44] = 0x9124;
	__map_gbk2utf16[0x5f45] = 0x9125;
	__map_gbk2utf16[0x5f46] = 0x9126;
	__map_gbk2utf16[0x5f47] = 0x9127;
	__map_gbk2utf16[0x5f48] = 0x9128;
	__map_gbk2utf16[0x5f49] = 0x9129;
	__map_gbk2utf16[0x5f4a] = 0x912a;
	__map_gbk2utf16[0x5f4b] = 0x912b;
	__map_gbk2utf16[0x5f4c] = 0x912c;
	__map_gbk2utf16[0x5f4d] = 0x912d;
	__map_gbk2utf16[0x5f4e] = 0x912e;
	__map_gbk2utf16[0x5f4f] = 0x9130;
	__map_gbk2utf16[0x5f50] = 0x9132;
	__map_gbk2utf16[0x5f51] = 0x9133;
	__map_gbk2utf16[0x5f52] = 0x9134;
	__map_gbk2utf16[0x5f53] = 0x9135;
	__map_gbk2utf16[0x5f54] = 0x9136;
	__map_gbk2utf16[0x5f55] = 0x9137;
	__map_gbk2utf16[0x5f56] = 0x9138;
	__map_gbk2utf16[0x5f57] = 0x913a;
	__map_gbk2utf16[0x5f58] = 0x913b;
	__map_gbk2utf16[0x5f59] = 0x913c;
	__map_gbk2utf16[0x5f5a] = 0x913d;
	__map_gbk2utf16[0x5f5b] = 0x913e;
	__map_gbk2utf16[0x5f5c] = 0x913f;
	__map_gbk2utf16[0x5f5d] = 0x9140;
	__map_gbk2utf16[0x5f5e] = 0x9141;
	__map_gbk2utf16[0x5f5f] = 0x9142;
	__map_gbk2utf16[0x5f60] = 0x9144;
	__map_gbk2utf16[0x5f61] = 0x5537;
	__map_gbk2utf16[0x5f62] = 0x5556;
	__map_gbk2utf16[0x5f63] = 0x5575;
	__map_gbk2utf16[0x5f64] = 0x5576;
	__map_gbk2utf16[0x5f65] = 0x5577;
	__map_gbk2utf16[0x5f66] = 0x5533;
	__map_gbk2utf16[0x5f67] = 0x5530;
	__map_gbk2utf16[0x5f68] = 0x555c;
	__map_gbk2utf16[0x5f69] = 0x558b;
	__map_gbk2utf16[0x5f6a] = 0x55d2;
	__map_gbk2utf16[0x5f6b] = 0x5583;
	__map_gbk2utf16[0x5f6c] = 0x55b1;
	__map_gbk2utf16[0x5f6d] = 0x55b9;
	__map_gbk2utf16[0x5f6e] = 0x5588;
	__map_gbk2utf16[0x5f6f] = 0x5581;
	__map_gbk2utf16[0x5f70] = 0x559f;
	__map_gbk2utf16[0x5f71] = 0x557e;
	__map_gbk2utf16[0x5f72] = 0x55d6;
	__map_gbk2utf16[0x5f73] = 0x5591;
	__map_gbk2utf16[0x5f74] = 0x557b;
	__map_gbk2utf16[0x5f75] = 0x55df;
	__map_gbk2utf16[0x5f76] = 0x55bd;
	__map_gbk2utf16[0x5f77] = 0x55be;
	__map_gbk2utf16[0x5f78] = 0x5594;
	__map_gbk2utf16[0x5f79] = 0x5599;
	__map_gbk2utf16[0x5f7a] = 0x55ea;
	__map_gbk2utf16[0x5f7b] = 0x55f7;
	__map_gbk2utf16[0x5f7c] = 0x55c9;
	__map_gbk2utf16[0x5f7d] = 0x561f;
	__map_gbk2utf16[0x5f7e] = 0x55d1;
	__map_gbk2utf16[0x5f7f] = 0x55eb;
	__map_gbk2utf16[0x5f80] = 0x55ec;
	__map_gbk2utf16[0x5f81] = 0x55d4;
	__map_gbk2utf16[0x5f82] = 0x55e6;
	__map_gbk2utf16[0x5f83] = 0x55dd;
	__map_gbk2utf16[0x5f84] = 0x55c4;
	__map_gbk2utf16[0x5f85] = 0x55ef;
	__map_gbk2utf16[0x5f86] = 0x55e5;
	__map_gbk2utf16[0x5f87] = 0x55f2;
	__map_gbk2utf16[0x5f88] = 0x55f3;
	__map_gbk2utf16[0x5f89] = 0x55cc;
	__map_gbk2utf16[0x5f8a] = 0x55cd;
	__map_gbk2utf16[0x5f8b] = 0x55e8;
	__map_gbk2utf16[0x5f8c] = 0x55f5;
	__map_gbk2utf16[0x5f8d] = 0x55e4;
	__map_gbk2utf16[0x5f8e] = 0x8f94;
	__map_gbk2utf16[0x5f8f] = 0x561e;
	__map_gbk2utf16[0x5f90] = 0x5608;
	__map_gbk2utf16[0x5f91] = 0x560c;
	__map_gbk2utf16[0x5f92] = 0x5601;
	__map_gbk2utf16[0x5f93] = 0x5624;
	__map_gbk2utf16[0x5f94] = 0x5623;
	__map_gbk2utf16[0x5f95] = 0x55fe;
	__map_gbk2utf16[0x5f96] = 0x5600;
	__map_gbk2utf16[0x5f97] = 0x5627;
	__map_gbk2utf16[0x5f98] = 0x562d;
	__map_gbk2utf16[0x5f99] = 0x5658;
	__map_gbk2utf16[0x5f9a] = 0x5639;
	__map_gbk2utf16[0x5f9b] = 0x5657;
	__map_gbk2utf16[0x5f9c] = 0x562c;
	__map_gbk2utf16[0x5f9d] = 0x564d;
	__map_gbk2utf16[0x5f9e] = 0x5662;
	__map_gbk2utf16[0x5f9f] = 0x5659;
	__map_gbk2utf16[0x5fa0] = 0x565c;
	__map_gbk2utf16[0x5fa1] = 0x564c;
	__map_gbk2utf16[0x5fa2] = 0x5654;
	__map_gbk2utf16[0x5fa3] = 0x5686;
	__map_gbk2utf16[0x5fa4] = 0x5664;
	__map_gbk2utf16[0x5fa5] = 0x5671;
	__map_gbk2utf16[0x5fa6] = 0x566b;
	__map_gbk2utf16[0x5fa7] = 0x567b;
	__map_gbk2utf16[0x5fa8] = 0x567c;
	__map_gbk2utf16[0x5fa9] = 0x5685;
	__map_gbk2utf16[0x5faa] = 0x5693;
	__map_gbk2utf16[0x5fab] = 0x56af;
	__map_gbk2utf16[0x5fac] = 0x56d4;
	__map_gbk2utf16[0x5fad] = 0x56d7;
	__map_gbk2utf16[0x5fae] = 0x56dd;
	__map_gbk2utf16[0x5faf] = 0x56e1;
	__map_gbk2utf16[0x5fb0] = 0x56f5;
	__map_gbk2utf16[0x5fb1] = 0x56eb;
	__map_gbk2utf16[0x5fb2] = 0x56f9;
	__map_gbk2utf16[0x5fb3] = 0x56ff;
	__map_gbk2utf16[0x5fb4] = 0x5704;
	__map_gbk2utf16[0x5fb5] = 0x570a;
	__map_gbk2utf16[0x5fb6] = 0x5709;
	__map_gbk2utf16[0x5fb7] = 0x571c;
	__map_gbk2utf16[0x5fb8] = 0x5e0f;
	__map_gbk2utf16[0x5fb9] = 0x5e19;
	__map_gbk2utf16[0x5fba] = 0x5e14;
	__map_gbk2utf16[0x5fbb] = 0x5e11;
	__map_gbk2utf16[0x5fbc] = 0x5e31;
	__map_gbk2utf16[0x5fbd] = 0x5e3b;
	__map_gbk2utf16[0x5fbe] = 0x5e3c;
	__map_gbk2utf16[0x6000] = 0x9145;
	__map_gbk2utf16[0x6001] = 0x9147;
	__map_gbk2utf16[0x6002] = 0x9148;
	__map_gbk2utf16[0x6003] = 0x9151;
	__map_gbk2utf16[0x6004] = 0x9153;
	__map_gbk2utf16[0x6005] = 0x9154;
	__map_gbk2utf16[0x6006] = 0x9155;
	__map_gbk2utf16[0x6007] = 0x9156;
	__map_gbk2utf16[0x6008] = 0x9158;
	__map_gbk2utf16[0x6009] = 0x9159;
	__map_gbk2utf16[0x600a] = 0x915b;
	__map_gbk2utf16[0x600b] = 0x915c;
	__map_gbk2utf16[0x600c] = 0x915f;
	__map_gbk2utf16[0x600d] = 0x9160;
	__map_gbk2utf16[0x600e] = 0x9166;
	__map_gbk2utf16[0x600f] = 0x9167;
	__map_gbk2utf16[0x6010] = 0x9168;
	__map_gbk2utf16[0x6011] = 0x916b;
	__map_gbk2utf16[0x6012] = 0x916d;
	__map_gbk2utf16[0x6013] = 0x9173;
	__map_gbk2utf16[0x6014] = 0x917a;
	__map_gbk2utf16[0x6015] = 0x917b;
	__map_gbk2utf16[0x6016] = 0x917c;
	__map_gbk2utf16[0x6017] = 0x9180;
	__map_gbk2utf16[0x6018] = 0x9181;
	__map_gbk2utf16[0x6019] = 0x9182;
	__map_gbk2utf16[0x601a] = 0x9183;
	__map_gbk2utf16[0x601b] = 0x9184;
	__map_gbk2utf16[0x601c] = 0x9186;
	__map_gbk2utf16[0x601d] = 0x9188;
	__map_gbk2utf16[0x601e] = 0x918a;
	__map_gbk2utf16[0x601f] = 0x918e;
	__map_gbk2utf16[0x6020] = 0x918f;
	__map_gbk2utf16[0x6021] = 0x9193;
	__map_gbk2utf16[0x6022] = 0x9194;
	__map_gbk2utf16[0x6023] = 0x9195;
	__map_gbk2utf16[0x6024] = 0x9196;
	__map_gbk2utf16[0x6025] = 0x9197;
	__map_gbk2utf16[0x6026] = 0x9198;
	__map_gbk2utf16[0x6027] = 0x9199;
	__map_gbk2utf16[0x6028] = 0x919c;
	__map_gbk2utf16[0x6029] = 0x919d;
	__map_gbk2utf16[0x602a] = 0x919e;
	__map_gbk2utf16[0x602b] = 0x919f;
	__map_gbk2utf16[0x602c] = 0x91a0;
	__map_gbk2utf16[0x602d] = 0x91a1;
	__map_gbk2utf16[0x602e] = 0x91a4;
	__map_gbk2utf16[0x602f] = 0x91a5;
	__map_gbk2utf16[0x6030] = 0x91a6;
	__map_gbk2utf16[0x6031] = 0x91a7;
	__map_gbk2utf16[0x6032] = 0x91a8;
	__map_gbk2utf16[0x6033] = 0x91a9;
	__map_gbk2utf16[0x6034] = 0x91ab;
	__map_gbk2utf16[0x6035] = 0x91ac;
	__map_gbk2utf16[0x6036] = 0x91b0;
	__map_gbk2utf16[0x6037] = 0x91b1;
	__map_gbk2utf16[0x6038] = 0x91b2;
	__map_gbk2utf16[0x6039] = 0x91b3;
	__map_gbk2utf16[0x603a] = 0x91b6;
	__map_gbk2utf16[0x603b] = 0x91b7;
	__map_gbk2utf16[0x603c] = 0x91b8;
	__map_gbk2utf16[0x603d] = 0x91b9;
	__map_gbk2utf16[0x603e] = 0x91bb;
	__map_gbk2utf16[0x6040] = 0x91bc;
	__map_gbk2utf16[0x6041] = 0x91bd;
	__map_gbk2utf16[0x6042] = 0x91be;
	__map_gbk2utf16[0x6043] = 0x91bf;
	__map_gbk2utf16[0x6044] = 0x91c0;
	__map_gbk2utf16[0x6045] = 0x91c1;
	__map_gbk2utf16[0x6046] = 0x91c2;
	__map_gbk2utf16[0x6047] = 0x91c3;
	__map_gbk2utf16[0x6048] = 0x91c4;
	__map_gbk2utf16[0x6049] = 0x91c5;
	__map_gbk2utf16[0x604a] = 0x91c6;
	__map_gbk2utf16[0x604b] = 0x91c8;
	__map_gbk2utf16[0x604c] = 0x91cb;
	__map_gbk2utf16[0x604d] = 0x91d0;
	__map_gbk2utf16[0x604e] = 0x91d2;
	__map_gbk2utf16[0x604f] = 0x91d3;
	__map_gbk2utf16[0x6050] = 0x91d4;
	__map_gbk2utf16[0x6051] = 0x91d5;
	__map_gbk2utf16[0x6052] = 0x91d6;
	__map_gbk2utf16[0x6053] = 0x91d7;
	__map_gbk2utf16[0x6054] = 0x91d8;
	__map_gbk2utf16[0x6055] = 0x91d9;
	__map_gbk2utf16[0x6056] = 0x91da;
	__map_gbk2utf16[0x6057] = 0x91db;
	__map_gbk2utf16[0x6058] = 0x91dd;
	__map_gbk2utf16[0x6059] = 0x91de;
	__map_gbk2utf16[0x605a] = 0x91df;
	__map_gbk2utf16[0x605b] = 0x91e0;
	__map_gbk2utf16[0x605c] = 0x91e1;
	__map_gbk2utf16[0x605d] = 0x91e2;
	__map_gbk2utf16[0x605e] = 0x91e3;
	__map_gbk2utf16[0x605f] = 0x91e4;
	__map_gbk2utf16[0x6060] = 0x91e5;
	__map_gbk2utf16[0x6061] = 0x5e37;
	__map_gbk2utf16[0x6062] = 0x5e44;
	__map_gbk2utf16[0x6063] = 0x5e54;
	__map_gbk2utf16[0x6064] = 0x5e5b;
	__map_gbk2utf16[0x6065] = 0x5e5e;
	__map_gbk2utf16[0x6066] = 0x5e61;
	__map_gbk2utf16[0x6067] = 0x5c8c;
	__map_gbk2utf16[0x6068] = 0x5c7a;
	__map_gbk2utf16[0x6069] = 0x5c8d;
	__map_gbk2utf16[0x606a] = 0x5c90;
	__map_gbk2utf16[0x606b] = 0x5c96;
	__map_gbk2utf16[0x606c] = 0x5c88;
	__map_gbk2utf16[0x606d] = 0x5c98;
	__map_gbk2utf16[0x606e] = 0x5c99;
	__map_gbk2utf16[0x606f] = 0x5c91;
	__map_gbk2utf16[0x6070] = 0x5c9a;
	__map_gbk2utf16[0x6071] = 0x5c9c;
	__map_gbk2utf16[0x6072] = 0x5cb5;
	__map_gbk2utf16[0x6073] = 0x5ca2;
	__map_gbk2utf16[0x6074] = 0x5cbd;
	__map_gbk2utf16[0x6075] = 0x5cac;
	__map_gbk2utf16[0x6076] = 0x5cab;
	__map_gbk2utf16[0x6077] = 0x5cb1;
	__map_gbk2utf16[0x6078] = 0x5ca3;
	__map_gbk2utf16[0x6079] = 0x5cc1;
	__map_gbk2utf16[0x607a] = 0x5cb7;
	__map_gbk2utf16[0x607b] = 0x5cc4;
	__map_gbk2utf16[0x607c] = 0x5cd2;
	__map_gbk2utf16[0x607d] = 0x5ce4;
	__map_gbk2utf16[0x607e] = 0x5ccb;
	__map_gbk2utf16[0x607f] = 0x5ce5;
	__map_gbk2utf16[0x6080] = 0x5d02;
	__map_gbk2utf16[0x6081] = 0x5d03;
	__map_gbk2utf16[0x6082] = 0x5d27;
	__map_gbk2utf16[0x6083] = 0x5d26;
	__map_gbk2utf16[0x6084] = 0x5d2e;
	__map_gbk2utf16[0x6085] = 0x5d24;
	__map_gbk2utf16[0x6086] = 0x5d1e;
	__map_gbk2utf16[0x6087] = 0x5d06;
	__map_gbk2utf16[0x6088] = 0x5d1b;
	__map_gbk2utf16[0x6089] = 0x5d58;
	__map_gbk2utf16[0x608a] = 0x5d3e;
	__map_gbk2utf16[0x608b] = 0x5d34;
	__map_gbk2utf16[0x608c] = 0x5d3d;
	__map_gbk2utf16[0x608d] = 0x5d6c;
	__map_gbk2utf16[0x608e] = 0x5d5b;
	__map_gbk2utf16[0x608f] = 0x5d6f;
	__map_gbk2utf16[0x6090] = 0x5d5d;
	__map_gbk2utf16[0x6091] = 0x5d6b;
	__map_gbk2utf16[0x6092] = 0x5d4b;
	__map_gbk2utf16[0x6093] = 0x5d4a;
	__map_gbk2utf16[0x6094] = 0x5d69;
	__map_gbk2utf16[0x6095] = 0x5d74;
	__map_gbk2utf16[0x6096] = 0x5d82;
	__map_gbk2utf16[0x6097] = 0x5d99;
	__map_gbk2utf16[0x6098] = 0x5d9d;
	__map_gbk2utf16[0x6099] = 0x8c73;
	__map_gbk2utf16[0x609a] = 0x5db7;
	__map_gbk2utf16[0x609b] = 0x5dc5;
	__map_gbk2utf16[0x609c] = 0x5f73;
	__map_gbk2utf16[0x609d] = 0x5f77;
	__map_gbk2utf16[0x609e] = 0x5f82;
	__map_gbk2utf16[0x609f] = 0x5f87;
	__map_gbk2utf16[0x60a0] = 0x5f89;
	__map_gbk2utf16[0x60a1] = 0x5f8c;
	__map_gbk2utf16[0x60a2] = 0x5f95;
	__map_gbk2utf16[0x60a3] = 0x5f99;
	__map_gbk2utf16[0x60a4] = 0x5f9c;
	__map_gbk2utf16[0x60a5] = 0x5fa8;
	__map_gbk2utf16[0x60a6] = 0x5fad;
	__map_gbk2utf16[0x60a7] = 0x5fb5;
	__map_gbk2utf16[0x60a8] = 0x5fbc;
	__map_gbk2utf16[0x60a9] = 0x8862;
	__map_gbk2utf16[0x60aa] = 0x5f61;
	__map_gbk2utf16[0x60ab] = 0x72ad;
	__map_gbk2utf16[0x60ac] = 0x72b0;
	__map_gbk2utf16[0x60ad] = 0x72b4;
	__map_gbk2utf16[0x60ae] = 0x72b7;
	__map_gbk2utf16[0x60af] = 0x72b8;
	__map_gbk2utf16[0x60b0] = 0x72c3;
	__map_gbk2utf16[0x60b1] = 0x72c1;
	__map_gbk2utf16[0x60b2] = 0x72ce;
	__map_gbk2utf16[0x60b3] = 0x72cd;
	__map_gbk2utf16[0x60b4] = 0x72d2;
	__map_gbk2utf16[0x60b5] = 0x72e8;
	__map_gbk2utf16[0x60b6] = 0x72ef;
	__map_gbk2utf16[0x60b7] = 0x72e9;
	__map_gbk2utf16[0x60b8] = 0x72f2;
	__map_gbk2utf16[0x60b9] = 0x72f4;
	__map_gbk2utf16[0x60ba] = 0x72f7;
	__map_gbk2utf16[0x60bb] = 0x7301;
	__map_gbk2utf16[0x60bc] = 0x72f3;
	__map_gbk2utf16[0x60bd] = 0x7303;
	__map_gbk2utf16[0x60be] = 0x72fa;
	__map_gbk2utf16[0x6100] = 0x91e6;
	__map_gbk2utf16[0x6101] = 0x91e7;
	__map_gbk2utf16[0x6102] = 0x91e8;
	__map_gbk2utf16[0x6103] = 0x91e9;
	__map_gbk2utf16[0x6104] = 0x91ea;
	__map_gbk2utf16[0x6105] = 0x91eb;
	__map_gbk2utf16[0x6106] = 0x91ec;
	__map_gbk2utf16[0x6107] = 0x91ed;
	__map_gbk2utf16[0x6108] = 0x91ee;
	__map_gbk2utf16[0x6109] = 0x91ef;
	__map_gbk2utf16[0x610a] = 0x91f0;
	__map_gbk2utf16[0x610b] = 0x91f1;
	__map_gbk2utf16[0x610c] = 0x91f2;
	__map_gbk2utf16[0x610d] = 0x91f3;
	__map_gbk2utf16[0x610e] = 0x91f4;
	__map_gbk2utf16[0x610f] = 0x91f5;
	__map_gbk2utf16[0x6110] = 0x91f6;
	__map_gbk2utf16[0x6111] = 0x91f7;
	__map_gbk2utf16[0x6112] = 0x91f8;
	__map_gbk2utf16[0x6113] = 0x91f9;
	__map_gbk2utf16[0x6114] = 0x91fa;
	__map_gbk2utf16[0x6115] = 0x91fb;
	__map_gbk2utf16[0x6116] = 0x91fc;
	__map_gbk2utf16[0x6117] = 0x91fd;
	__map_gbk2utf16[0x6118] = 0x91fe;
	__map_gbk2utf16[0x6119] = 0x91ff;
	__map_gbk2utf16[0x611a] = 0x9200;
	__map_gbk2utf16[0x611b] = 0x9201;
	__map_gbk2utf16[0x611c] = 0x9202;
	__map_gbk2utf16[0x611d] = 0x9203;
	__map_gbk2utf16[0x611e] = 0x9204;
	__map_gbk2utf16[0x611f] = 0x9205;
	__map_gbk2utf16[0x6120] = 0x9206;
	__map_gbk2utf16[0x6121] = 0x9207;
	__map_gbk2utf16[0x6122] = 0x9208;
	__map_gbk2utf16[0x6123] = 0x9209;
	__map_gbk2utf16[0x6124] = 0x920a;
	__map_gbk2utf16[0x6125] = 0x920b;
	__map_gbk2utf16[0x6126] = 0x920c;
	__map_gbk2utf16[0x6127] = 0x920d;
	__map_gbk2utf16[0x6128] = 0x920e;
	__map_gbk2utf16[0x6129] = 0x920f;
	__map_gbk2utf16[0x612a] = 0x9210;
	__map_gbk2utf16[0x612b] = 0x9211;
	__map_gbk2utf16[0x612c] = 0x9212;
	__map_gbk2utf16[0x612d] = 0x9213;
	__map_gbk2utf16[0x612e] = 0x9214;
	__map_gbk2utf16[0x612f] = 0x9215;
	__map_gbk2utf16[0x6130] = 0x9216;
	__map_gbk2utf16[0x6131] = 0x9217;
	__map_gbk2utf16[0x6132] = 0x9218;
	__map_gbk2utf16[0x6133] = 0x9219;
	__map_gbk2utf16[0x6134] = 0x921a;
	__map_gbk2utf16[0x6135] = 0x921b;
	__map_gbk2utf16[0x6136] = 0x921c;
	__map_gbk2utf16[0x6137] = 0x921d;
	__map_gbk2utf16[0x6138] = 0x921e;
	__map_gbk2utf16[0x6139] = 0x921f;
	__map_gbk2utf16[0x613a] = 0x9220;
	__map_gbk2utf16[0x613b] = 0x9221;
	__map_gbk2utf16[0x613c] = 0x9222;
	__map_gbk2utf16[0x613d] = 0x9223;
	__map_gbk2utf16[0x613e] = 0x9224;
	__map_gbk2utf16[0x6140] = 0x9225;
	__map_gbk2utf16[0x6141] = 0x9226;
	__map_gbk2utf16[0x6142] = 0x9227;
	__map_gbk2utf16[0x6143] = 0x9228;
	__map_gbk2utf16[0x6144] = 0x9229;
	__map_gbk2utf16[0x6145] = 0x922a;
	__map_gbk2utf16[0x6146] = 0x922b;
	__map_gbk2utf16[0x6147] = 0x922c;
	__map_gbk2utf16[0x6148] = 0x922d;
	__map_gbk2utf16[0x6149] = 0x922e;
	__map_gbk2utf16[0x614a] = 0x922f;
	__map_gbk2utf16[0x614b] = 0x9230;
	__map_gbk2utf16[0x614c] = 0x9231;
	__map_gbk2utf16[0x614d] = 0x9232;
	__map_gbk2utf16[0x614e] = 0x9233;
	__map_gbk2utf16[0x614f] = 0x9234;
	__map_gbk2utf16[0x6150] = 0x9235;
	__map_gbk2utf16[0x6151] = 0x9236;
	__map_gbk2utf16[0x6152] = 0x9237;
	__map_gbk2utf16[0x6153] = 0x9238;
	__map_gbk2utf16[0x6154] = 0x9239;
	__map_gbk2utf16[0x6155] = 0x923a;
	__map_gbk2utf16[0x6156] = 0x923b;
	__map_gbk2utf16[0x6157] = 0x923c;
	__map_gbk2utf16[0x6158] = 0x923d;
	__map_gbk2utf16[0x6159] = 0x923e;
	__map_gbk2utf16[0x615a] = 0x923f;
	__map_gbk2utf16[0x615b] = 0x9240;
	__map_gbk2utf16[0x615c] = 0x9241;
	__map_gbk2utf16[0x615d] = 0x9242;
	__map_gbk2utf16[0x615e] = 0x9243;
	__map_gbk2utf16[0x615f] = 0x9244;
	__map_gbk2utf16[0x6160] = 0x9245;
	__map_gbk2utf16[0x6161] = 0x72fb;
	__map_gbk2utf16[0x6162] = 0x7317;
	__map_gbk2utf16[0x6163] = 0x7313;
	__map_gbk2utf16[0x6164] = 0x7321;
	__map_gbk2utf16[0x6165] = 0x730a;
	__map_gbk2utf16[0x6166] = 0x731e;
	__map_gbk2utf16[0x6167] = 0x731d;
	__map_gbk2utf16[0x6168] = 0x7315;
	__map_gbk2utf16[0x6169] = 0x7322;
	__map_gbk2utf16[0x616a] = 0x7339;
	__map_gbk2utf16[0x616b] = 0x7325;
	__map_gbk2utf16[0x616c] = 0x732c;
	__map_gbk2utf16[0x616d] = 0x7338;
	__map_gbk2utf16[0x616e] = 0x7331;
	__map_gbk2utf16[0x616f] = 0x7350;
	__map_gbk2utf16[0x6170] = 0x734d;
	__map_gbk2utf16[0x6171] = 0x7357;
	__map_gbk2utf16[0x6172] = 0x7360;
	__map_gbk2utf16[0x6173] = 0x736c;
	__map_gbk2utf16[0x6174] = 0x736f;
	__map_gbk2utf16[0x6175] = 0x737e;
	__map_gbk2utf16[0x6176] = 0x821b;
	__map_gbk2utf16[0x6177] = 0x5925;
	__map_gbk2utf16[0x6178] = 0x98e7;
	__map_gbk2utf16[0x6179] = 0x5924;
	__map_gbk2utf16[0x617a] = 0x5902;
	__map_gbk2utf16[0x617b] = 0x9963;
	__map_gbk2utf16[0x617c] = 0x9967;
	__map_gbk2utf16[0x617d] = 0x9968;
	__map_gbk2utf16[0x617e] = 0x9969;
	__map_gbk2utf16[0x617f] = 0x996a;
	__map_gbk2utf16[0x6180] = 0x996b;
	__map_gbk2utf16[0x6181] = 0x996c;
	__map_gbk2utf16[0x6182] = 0x9974;
	__map_gbk2utf16[0x6183] = 0x9977;
	__map_gbk2utf16[0x6184] = 0x997d;
	__map_gbk2utf16[0x6185] = 0x9980;
	__map_gbk2utf16[0x6186] = 0x9984;
	__map_gbk2utf16[0x6187] = 0x9987;
	__map_gbk2utf16[0x6188] = 0x998a;
	__map_gbk2utf16[0x6189] = 0x998d;
	__map_gbk2utf16[0x618a] = 0x9990;
	__map_gbk2utf16[0x618b] = 0x9991;
	__map_gbk2utf16[0x618c] = 0x9993;
	__map_gbk2utf16[0x618d] = 0x9994;
	__map_gbk2utf16[0x618e] = 0x9995;
	__map_gbk2utf16[0x618f] = 0x5e80;
	__map_gbk2utf16[0x6190] = 0x5e91;
	__map_gbk2utf16[0x6191] = 0x5e8b;
	__map_gbk2utf16[0x6192] = 0x5e96;
	__map_gbk2utf16[0x6193] = 0x5ea5;
	__map_gbk2utf16[0x6194] = 0x5ea0;
	__map_gbk2utf16[0x6195] = 0x5eb9;
	__map_gbk2utf16[0x6196] = 0x5eb5;
	__map_gbk2utf16[0x6197] = 0x5ebe;
	__map_gbk2utf16[0x6198] = 0x5eb3;
	__map_gbk2utf16[0x6199] = 0x8d53;
	__map_gbk2utf16[0x619a] = 0x5ed2;
	__map_gbk2utf16[0x619b] = 0x5ed1;
	__map_gbk2utf16[0x619c] = 0x5edb;
	__map_gbk2utf16[0x619d] = 0x5ee8;
	__map_gbk2utf16[0x619e] = 0x5eea;
	__map_gbk2utf16[0x619f] = 0x81ba;
	__map_gbk2utf16[0x61a0] = 0x5fc4;
	__map_gbk2utf16[0x61a1] = 0x5fc9;
	__map_gbk2utf16[0x61a2] = 0x5fd6;
	__map_gbk2utf16[0x61a3] = 0x5fcf;
	__map_gbk2utf16[0x61a4] = 0x6003;
	__map_gbk2utf16[0x61a5] = 0x5fee;
	__map_gbk2utf16[0x61a6] = 0x6004;
	__map_gbk2utf16[0x61a7] = 0x5fe1;
	__map_gbk2utf16[0x61a8] = 0x5fe4;
	__map_gbk2utf16[0x61a9] = 0x5ffe;
	__map_gbk2utf16[0x61aa] = 0x6005;
	__map_gbk2utf16[0x61ab] = 0x6006;
	__map_gbk2utf16[0x61ac] = 0x5fea;
	__map_gbk2utf16[0x61ad] = 0x5fed;
	__map_gbk2utf16[0x61ae] = 0x5ff8;
	__map_gbk2utf16[0x61af] = 0x6019;
	__map_gbk2utf16[0x61b0] = 0x6035;
	__map_gbk2utf16[0x61b1] = 0x6026;
	__map_gbk2utf16[0x61b2] = 0x601b;
	__map_gbk2utf16[0x61b3] = 0x600f;
	__map_gbk2utf16[0x61b4] = 0x600d;
	__map_gbk2utf16[0x61b5] = 0x6029;
	__map_gbk2utf16[0x61b6] = 0x602b;
	__map_gbk2utf16[0x61b7] = 0x600a;
	__map_gbk2utf16[0x61b8] = 0x603f;
	__map_gbk2utf16[0x61b9] = 0x6021;
	__map_gbk2utf16[0x61ba] = 0x6078;
	__map_gbk2utf16[0x61bb] = 0x6079;
	__map_gbk2utf16[0x61bc] = 0x607b;
	__map_gbk2utf16[0x61bd] = 0x607a;
	__map_gbk2utf16[0x61be] = 0x6042;
	__map_gbk2utf16[0x6200] = 0x9246;
	__map_gbk2utf16[0x6201] = 0x9247;
	__map_gbk2utf16[0x6202] = 0x9248;
	__map_gbk2utf16[0x6203] = 0x9249;
	__map_gbk2utf16[0x6204] = 0x924a;
	__map_gbk2utf16[0x6205] = 0x924b;
	__map_gbk2utf16[0x6206] = 0x924c;
	__map_gbk2utf16[0x6207] = 0x924d;
	__map_gbk2utf16[0x6208] = 0x924e;
	__map_gbk2utf16[0x6209] = 0x924f;
	__map_gbk2utf16[0x620a] = 0x9250;
	__map_gbk2utf16[0x620b] = 0x9251;
	__map_gbk2utf16[0x620c] = 0x9252;
	__map_gbk2utf16[0x620d] = 0x9253;
	__map_gbk2utf16[0x620e] = 0x9254;
	__map_gbk2utf16[0x620f] = 0x9255;
	__map_gbk2utf16[0x6210] = 0x9256;
	__map_gbk2utf16[0x6211] = 0x9257;
	__map_gbk2utf16[0x6212] = 0x9258;
	__map_gbk2utf16[0x6213] = 0x9259;
	__map_gbk2utf16[0x6214] = 0x925a;
	__map_gbk2utf16[0x6215] = 0x925b;
	__map_gbk2utf16[0x6216] = 0x925c;
	__map_gbk2utf16[0x6217] = 0x925d;
	__map_gbk2utf16[0x6218] = 0x925e;
	__map_gbk2utf16[0x6219] = 0x925f;
	__map_gbk2utf16[0x621a] = 0x9260;
	__map_gbk2utf16[0x621b] = 0x9261;
	__map_gbk2utf16[0x621c] = 0x9262;
	__map_gbk2utf16[0x621d] = 0x9263;
	__map_gbk2utf16[0x621e] = 0x9264;
	__map_gbk2utf16[0x621f] = 0x9265;
	__map_gbk2utf16[0x6220] = 0x9266;
	__map_gbk2utf16[0x6221] = 0x9267;
	__map_gbk2utf16[0x6222] = 0x9268;
	__map_gbk2utf16[0x6223] = 0x9269;
	__map_gbk2utf16[0x6224] = 0x926a;
	__map_gbk2utf16[0x6225] = 0x926b;
	__map_gbk2utf16[0x6226] = 0x926c;
	__map_gbk2utf16[0x6227] = 0x926d;
	__map_gbk2utf16[0x6228] = 0x926e;
	__map_gbk2utf16[0x6229] = 0x926f;
	__map_gbk2utf16[0x622a] = 0x9270;
	__map_gbk2utf16[0x622b] = 0x9271;
	__map_gbk2utf16[0x622c] = 0x9272;
	__map_gbk2utf16[0x622d] = 0x9273;
	__map_gbk2utf16[0x622e] = 0x9275;
	__map_gbk2utf16[0x622f] = 0x9276;
	__map_gbk2utf16[0x6230] = 0x9277;
	__map_gbk2utf16[0x6231] = 0x9278;
	__map_gbk2utf16[0x6232] = 0x9279;
	__map_gbk2utf16[0x6233] = 0x927a;
	__map_gbk2utf16[0x6234] = 0x927b;
	__map_gbk2utf16[0x6235] = 0x927c;
	__map_gbk2utf16[0x6236] = 0x927d;
	__map_gbk2utf16[0x6237] = 0x927e;
	__map_gbk2utf16[0x6238] = 0x927f;
	__map_gbk2utf16[0x6239] = 0x9280;
	__map_gbk2utf16[0x623a] = 0x9281;
	__map_gbk2utf16[0x623b] = 0x9282;
	__map_gbk2utf16[0x623c] = 0x9283;
	__map_gbk2utf16[0x623d] = 0x9284;
	__map_gbk2utf16[0x623e] = 0x9285;
	__map_gbk2utf16[0x6240] = 0x9286;
	__map_gbk2utf16[0x6241] = 0x9287;
	__map_gbk2utf16[0x6242] = 0x9288;
	__map_gbk2utf16[0x6243] = 0x9289;
	__map_gbk2utf16[0x6244] = 0x928a;
	__map_gbk2utf16[0x6245] = 0x928b;
	__map_gbk2utf16[0x6246] = 0x928c;
	__map_gbk2utf16[0x6247] = 0x928d;
	__map_gbk2utf16[0x6248] = 0x928f;
	__map_gbk2utf16[0x6249] = 0x9290;
	__map_gbk2utf16[0x624a] = 0x9291;
	__map_gbk2utf16[0x624b] = 0x9292;
	__map_gbk2utf16[0x624c] = 0x9293;
	__map_gbk2utf16[0x624d] = 0x9294;
	__map_gbk2utf16[0x624e] = 0x9295;
	__map_gbk2utf16[0x624f] = 0x9296;
	__map_gbk2utf16[0x6250] = 0x9297;
	__map_gbk2utf16[0x6251] = 0x9298;
	__map_gbk2utf16[0x6252] = 0x9299;
	__map_gbk2utf16[0x6253] = 0x929a;
	__map_gbk2utf16[0x6254] = 0x929b;
	__map_gbk2utf16[0x6255] = 0x929c;
	__map_gbk2utf16[0x6256] = 0x929d;
	__map_gbk2utf16[0x6257] = 0x929e;
	__map_gbk2utf16[0x6258] = 0x929f;
	__map_gbk2utf16[0x6259] = 0x92a0;
	__map_gbk2utf16[0x625a] = 0x92a1;
	__map_gbk2utf16[0x625b] = 0x92a2;
	__map_gbk2utf16[0x625c] = 0x92a3;
	__map_gbk2utf16[0x625d] = 0x92a4;
	__map_gbk2utf16[0x625e] = 0x92a5;
	__map_gbk2utf16[0x625f] = 0x92a6;
	__map_gbk2utf16[0x6260] = 0x92a7;
	__map_gbk2utf16[0x6261] = 0x606a;
	__map_gbk2utf16[0x6262] = 0x607d;
	__map_gbk2utf16[0x6263] = 0x6096;
	__map_gbk2utf16[0x6264] = 0x609a;
	__map_gbk2utf16[0x6265] = 0x60ad;
	__map_gbk2utf16[0x6266] = 0x609d;
	__map_gbk2utf16[0x6267] = 0x6083;
	__map_gbk2utf16[0x6268] = 0x6092;
	__map_gbk2utf16[0x6269] = 0x608c;
	__map_gbk2utf16[0x626a] = 0x609b;
	__map_gbk2utf16[0x626b] = 0x60ec;
	__map_gbk2utf16[0x626c] = 0x60bb;
	__map_gbk2utf16[0x626d] = 0x60b1;
	__map_gbk2utf16[0x626e] = 0x60dd;
	__map_gbk2utf16[0x626f] = 0x60d8;
	__map_gbk2utf16[0x6270] = 0x60c6;
	__map_gbk2utf16[0x6271] = 0x60da;
	__map_gbk2utf16[0x6272] = 0x60b4;
	__map_gbk2utf16[0x6273] = 0x6120;
	__map_gbk2utf16[0x6274] = 0x6126;
	__map_gbk2utf16[0x6275] = 0x6115;
	__map_gbk2utf16[0x6276] = 0x6123;
	__map_gbk2utf16[0x6277] = 0x60f4;
	__map_gbk2utf16[0x6278] = 0x6100;
	__map_gbk2utf16[0x6279] = 0x610e;
	__map_gbk2utf16[0x627a] = 0x612b;
	__map_gbk2utf16[0x627b] = 0x614a;
	__map_gbk2utf16[0x627c] = 0x6175;
	__map_gbk2utf16[0x627d] = 0x61ac;
	__map_gbk2utf16[0x627e] = 0x6194;
	__map_gbk2utf16[0x627f] = 0x61a7;
	__map_gbk2utf16[0x6280] = 0x61b7;
	__map_gbk2utf16[0x6281] = 0x61d4;
	__map_gbk2utf16[0x6282] = 0x61f5;
	__map_gbk2utf16[0x6283] = 0x5fdd;
	__map_gbk2utf16[0x6284] = 0x96b3;
	__map_gbk2utf16[0x6285] = 0x95e9;
	__map_gbk2utf16[0x6286] = 0x95eb;
	__map_gbk2utf16[0x6287] = 0x95f1;
	__map_gbk2utf16[0x6288] = 0x95f3;
	__map_gbk2utf16[0x6289] = 0x95f5;
	__map_gbk2utf16[0x628a] = 0x95f6;
	__map_gbk2utf16[0x628b] = 0x95fc;
	__map_gbk2utf16[0x628c] = 0x95fe;
	__map_gbk2utf16[0x628d] = 0x9603;
	__map_gbk2utf16[0x628e] = 0x9604;
	__map_gbk2utf16[0x628f] = 0x9606;
	__map_gbk2utf16[0x6290] = 0x9608;
	__map_gbk2utf16[0x6291] = 0x960a;
	__map_gbk2utf16[0x6292] = 0x960b;
	__map_gbk2utf16[0x6293] = 0x960c;
	__map_gbk2utf16[0x6294] = 0x960d;
	__map_gbk2utf16[0x6295] = 0x960f;
	__map_gbk2utf16[0x6296] = 0x9612;
	__map_gbk2utf16[0x6297] = 0x9615;
	__map_gbk2utf16[0x6298] = 0x9616;
	__map_gbk2utf16[0x6299] = 0x9617;
	__map_gbk2utf16[0x629a] = 0x9619;
	__map_gbk2utf16[0x629b] = 0x961a;
	__map_gbk2utf16[0x629c] = 0x4e2c;
	__map_gbk2utf16[0x629d] = 0x723f;
	__map_gbk2utf16[0x629e] = 0x6215;
	__map_gbk2utf16[0x629f] = 0x6c35;
	__map_gbk2utf16[0x62a0] = 0x6c54;
	__map_gbk2utf16[0x62a1] = 0x6c5c;
	__map_gbk2utf16[0x62a2] = 0x6c4a;
	__map_gbk2utf16[0x62a3] = 0x6ca3;
	__map_gbk2utf16[0x62a4] = 0x6c85;
	__map_gbk2utf16[0x62a5] = 0x6c90;
	__map_gbk2utf16[0x62a6] = 0x6c94;
	__map_gbk2utf16[0x62a7] = 0x6c8c;
	__map_gbk2utf16[0x62a8] = 0x6c68;
	__map_gbk2utf16[0x62a9] = 0x6c69;
	__map_gbk2utf16[0x62aa] = 0x6c74;
	__map_gbk2utf16[0x62ab] = 0x6c76;
	__map_gbk2utf16[0x62ac] = 0x6c86;
	__map_gbk2utf16[0x62ad] = 0x6ca9;
	__map_gbk2utf16[0x62ae] = 0x6cd0;
	__map_gbk2utf16[0x62af] = 0x6cd4;
	__map_gbk2utf16[0x62b0] = 0x6cad;
	__map_gbk2utf16[0x62b1] = 0x6cf7;
	__map_gbk2utf16[0x62b2] = 0x6cf8;
	__map_gbk2utf16[0x62b3] = 0x6cf1;
	__map_gbk2utf16[0x62b4] = 0x6cd7;
	__map_gbk2utf16[0x62b5] = 0x6cb2;
	__map_gbk2utf16[0x62b6] = 0x6ce0;
	__map_gbk2utf16[0x62b7] = 0x6cd6;
	__map_gbk2utf16[0x62b8] = 0x6cfa;
	__map_gbk2utf16[0x62b9] = 0x6ceb;
	__map_gbk2utf16[0x62ba] = 0x6cee;
	__map_gbk2utf16[0x62bb] = 0x6cb1;
	__map_gbk2utf16[0x62bc] = 0x6cd3;
	__map_gbk2utf16[0x62bd] = 0x6cef;
	__map_gbk2utf16[0x62be] = 0x6cfe;
	__map_gbk2utf16[0x6300] = 0x92a8;
	__map_gbk2utf16[0x6301] = 0x92a9;
	__map_gbk2utf16[0x6302] = 0x92aa;
	__map_gbk2utf16[0x6303] = 0x92ab;
	__map_gbk2utf16[0x6304] = 0x92ac;
	__map_gbk2utf16[0x6305] = 0x92ad;
	__map_gbk2utf16[0x6306] = 0x92af;
	__map_gbk2utf16[0x6307] = 0x92b0;
	__map_gbk2utf16[0x6308] = 0x92b1;
	__map_gbk2utf16[0x6309] = 0x92b2;
	__map_gbk2utf16[0x630a] = 0x92b3;
	__map_gbk2utf16[0x630b] = 0x92b4;
	__map_gbk2utf16[0x630c] = 0x92b5;
	__map_gbk2utf16[0x630d] = 0x92b6;
	__map_gbk2utf16[0x630e] = 0x92b7;
	__map_gbk2utf16[0x630f] = 0x92b8;
	__map_gbk2utf16[0x6310] = 0x92b9;
	__map_gbk2utf16[0x6311] = 0x92ba;
	__map_gbk2utf16[0x6312] = 0x92bb;
	__map_gbk2utf16[0x6313] = 0x92bc;
	__map_gbk2utf16[0x6314] = 0x92bd;
	__map_gbk2utf16[0x6315] = 0x92be;
	__map_gbk2utf16[0x6316] = 0x92bf;
	__map_gbk2utf16[0x6317] = 0x92c0;
	__map_gbk2utf16[0x6318] = 0x92c1;
	__map_gbk2utf16[0x6319] = 0x92c2;
	__map_gbk2utf16[0x631a] = 0x92c3;
	__map_gbk2utf16[0x631b] = 0x92c4;
	__map_gbk2utf16[0x631c] = 0x92c5;
	__map_gbk2utf16[0x631d] = 0x92c6;
	__map_gbk2utf16[0x631e] = 0x92c7;
	__map_gbk2utf16[0x631f] = 0x92c9;
	__map_gbk2utf16[0x6320] = 0x92ca;
	__map_gbk2utf16[0x6321] = 0x92cb;
	__map_gbk2utf16[0x6322] = 0x92cc;
	__map_gbk2utf16[0x6323] = 0x92cd;
	__map_gbk2utf16[0x6324] = 0x92ce;
	__map_gbk2utf16[0x6325] = 0x92cf;
	__map_gbk2utf16[0x6326] = 0x92d0;
	__map_gbk2utf16[0x6327] = 0x92d1;
	__map_gbk2utf16[0x6328] = 0x92d2;
	__map_gbk2utf16[0x6329] = 0x92d3;
	__map_gbk2utf16[0x632a] = 0x92d4;
	__map_gbk2utf16[0x632b] = 0x92d5;
	__map_gbk2utf16[0x632c] = 0x92d6;
	__map_gbk2utf16[0x632d] = 0x92d7;
	__map_gbk2utf16[0x632e] = 0x92d8;
	__map_gbk2utf16[0x632f] = 0x92d9;
	__map_gbk2utf16[0x6330] = 0x92da;
	__map_gbk2utf16[0x6331] = 0x92db;
	__map_gbk2utf16[0x6332] = 0x92dc;
	__map_gbk2utf16[0x6333] = 0x92dd;
	__map_gbk2utf16[0x6334] = 0x92de;
	__map_gbk2utf16[0x6335] = 0x92df;
	__map_gbk2utf16[0x6336] = 0x92e0;
	__map_gbk2utf16[0x6337] = 0x92e1;
	__map_gbk2utf16[0x6338] = 0x92e2;
	__map_gbk2utf16[0x6339] = 0x92e3;
	__map_gbk2utf16[0x633a] = 0x92e4;
	__map_gbk2utf16[0x633b] = 0x92e5;
	__map_gbk2utf16[0x633c] = 0x92e6;
	__map_gbk2utf16[0x633d] = 0x92e7;
	__map_gbk2utf16[0x633e] = 0x92e8;
	__map_gbk2utf16[0x6340] = 0x92e9;
	__map_gbk2utf16[0x6341] = 0x92ea;
	__map_gbk2utf16[0x6342] = 0x92eb;
	__map_gbk2utf16[0x6343] = 0x92ec;
	__map_gbk2utf16[0x6344] = 0x92ed;
	__map_gbk2utf16[0x6345] = 0x92ee;
	__map_gbk2utf16[0x6346] = 0x92ef;
	__map_gbk2utf16[0x6347] = 0x92f0;
	__map_gbk2utf16[0x6348] = 0x92f1;
	__map_gbk2utf16[0x6349] = 0x92f2;
	__map_gbk2utf16[0x634a] = 0x92f3;
	__map_gbk2utf16[0x634b] = 0x92f4;
	__map_gbk2utf16[0x634c] = 0x92f5;
	__map_gbk2utf16[0x634d] = 0x92f6;
	__map_gbk2utf16[0x634e] = 0x92f7;
	__map_gbk2utf16[0x634f] = 0x92f8;
	__map_gbk2utf16[0x6350] = 0x92f9;
	__map_gbk2utf16[0x6351] = 0x92fa;
	__map_gbk2utf16[0x6352] = 0x92fb;
	__map_gbk2utf16[0x6353] = 0x92fc;
	__map_gbk2utf16[0x6354] = 0x92fd;
	__map_gbk2utf16[0x6355] = 0x92fe;
	__map_gbk2utf16[0x6356] = 0x92ff;
	__map_gbk2utf16[0x6357] = 0x9300;
	__map_gbk2utf16[0x6358] = 0x9301;
	__map_gbk2utf16[0x6359] = 0x9302;
	__map_gbk2utf16[0x635a] = 0x9303;
	__map_gbk2utf16[0x635b] = 0x9304;
	__map_gbk2utf16[0x635c] = 0x9305;
	__map_gbk2utf16[0x635d] = 0x9306;
	__map_gbk2utf16[0x635e] = 0x9307;
	__map_gbk2utf16[0x635f] = 0x9308;
	__map_gbk2utf16[0x6360] = 0x9309;
	__map_gbk2utf16[0x6361] = 0x6d39;
	__map_gbk2utf16[0x6362] = 0x6d27;
	__map_gbk2utf16[0x6363] = 0x6d0c;
	__map_gbk2utf16[0x6364] = 0x6d43;
	__map_gbk2utf16[0x6365] = 0x6d48;
	__map_gbk2utf16[0x6366] = 0x6d07;
	__map_gbk2utf16[0x6367] = 0x6d04;
	__map_gbk2utf16[0x6368] = 0x6d19;
	__map_gbk2utf16[0x6369] = 0x6d0e;
	__map_gbk2utf16[0x636a] = 0x6d2b;
	__map_gbk2utf16[0x636b] = 0x6d4d;
	__map_gbk2utf16[0x636c] = 0x6d2e;
	__map_gbk2utf16[0x636d] = 0x6d35;
	__map_gbk2utf16[0x636e] = 0x6d1a;
	__map_gbk2utf16[0x636f] = 0x6d4f;
	__map_gbk2utf16[0x6370] = 0x6d52;
	__map_gbk2utf16[0x6371] = 0x6d54;
	__map_gbk2utf16[0x6372] = 0x6d33;
	__map_gbk2utf16[0x6373] = 0x6d91;
	__map_gbk2utf16[0x6374] = 0x6d6f;
	__map_gbk2utf16[0x6375] = 0x6d9e;
	__map_gbk2utf16[0x6376] = 0x6da0;
	__map_gbk2utf16[0x6377] = 0x6d5e;
	__map_gbk2utf16[0x6378] = 0x6d93;
	__map_gbk2utf16[0x6379] = 0x6d94;
	__map_gbk2utf16[0x637a] = 0x6d5c;
	__map_gbk2utf16[0x637b] = 0x6d60;
	__map_gbk2utf16[0x637c] = 0x6d7c;
	__map_gbk2utf16[0x637d] = 0x6d63;
	__map_gbk2utf16[0x637e] = 0x6e1a;
	__map_gbk2utf16[0x637f] = 0x6dc7;
	__map_gbk2utf16[0x6380] = 0x6dc5;
	__map_gbk2utf16[0x6381] = 0x6dde;
	__map_gbk2utf16[0x6382] = 0x6e0e;
	__map_gbk2utf16[0x6383] = 0x6dbf;
	__map_gbk2utf16[0x6384] = 0x6de0;
	__map_gbk2utf16[0x6385] = 0x6e11;
	__map_gbk2utf16[0x6386] = 0x6de6;
	__map_gbk2utf16[0x6387] = 0x6ddd;
	__map_gbk2utf16[0x6388] = 0x6dd9;
	__map_gbk2utf16[0x6389] = 0x6e16;
	__map_gbk2utf16[0x638a] = 0x6dab;
	__map_gbk2utf16[0x638b] = 0x6e0c;
	__map_gbk2utf16[0x638c] = 0x6dae;
	__map_gbk2utf16[0x638d] = 0x6e2b;
	__map_gbk2utf16[0x638e] = 0x6e6e;
	__map_gbk2utf16[0x638f] = 0x6e4e;
	__map_gbk2utf16[0x6390] = 0x6e6b;
	__map_gbk2utf16[0x6391] = 0x6eb2;
	__map_gbk2utf16[0x6392] = 0x6e5f;
	__map_gbk2utf16[0x6393] = 0x6e86;
	__map_gbk2utf16[0x6394] = 0x6e53;
	__map_gbk2utf16[0x6395] = 0x6e54;
	__map_gbk2utf16[0x6396] = 0x6e32;
	__map_gbk2utf16[0x6397] = 0x6e25;
	__map_gbk2utf16[0x6398] = 0x6e44;
	__map_gbk2utf16[0x6399] = 0x6edf;
	__map_gbk2utf16[0x639a] = 0x6eb1;
	__map_gbk2utf16[0x639b] = 0x6e98;
	__map_gbk2utf16[0x639c] = 0x6ee0;
	__map_gbk2utf16[0x639d] = 0x6f2d;
	__map_gbk2utf16[0x639e] = 0x6ee2;
	__map_gbk2utf16[0x639f] = 0x6ea5;
	__map_gbk2utf16[0x63a0] = 0x6ea7;
	__map_gbk2utf16[0x63a1] = 0x6ebd;
	__map_gbk2utf16[0x63a2] = 0x6ebb;
	__map_gbk2utf16[0x63a3] = 0x6eb7;
	__map_gbk2utf16[0x63a4] = 0x6ed7;
	__map_gbk2utf16[0x63a5] = 0x6eb4;
	__map_gbk2utf16[0x63a6] = 0x6ecf;
	__map_gbk2utf16[0x63a7] = 0x6e8f;
	__map_gbk2utf16[0x63a8] = 0x6ec2;
	__map_gbk2utf16[0x63a9] = 0x6e9f;
	__map_gbk2utf16[0x63aa] = 0x6f62;
	__map_gbk2utf16[0x63ab] = 0x6f46;
	__map_gbk2utf16[0x63ac] = 0x6f47;
	__map_gbk2utf16[0x63ad] = 0x6f24;
	__map_gbk2utf16[0x63ae] = 0x6f15;
	__map_gbk2utf16[0x63af] = 0x6ef9;
	__map_gbk2utf16[0x63b0] = 0x6f2f;
	__map_gbk2utf16[0x63b1] = 0x6f36;
	__map_gbk2utf16[0x63b2] = 0x6f4b;
	__map_gbk2utf16[0x63b3] = 0x6f74;
	__map_gbk2utf16[0x63b4] = 0x6f2a;
	__map_gbk2utf16[0x63b5] = 0x6f09;
	__map_gbk2utf16[0x63b6] = 0x6f29;
	__map_gbk2utf16[0x63b7] = 0x6f89;
	__map_gbk2utf16[0x63b8] = 0x6f8d;
	__map_gbk2utf16[0x63b9] = 0x6f8c;
	__map_gbk2utf16[0x63ba] = 0x6f78;
	__map_gbk2utf16[0x63bb] = 0x6f72;
	__map_gbk2utf16[0x63bc] = 0x6f7c;
	__map_gbk2utf16[0x63bd] = 0x6f7a;
	__map_gbk2utf16[0x63be] = 0x6fd1;
	__map_gbk2utf16[0x6400] = 0x930a;
	__map_gbk2utf16[0x6401] = 0x930b;
	__map_gbk2utf16[0x6402] = 0x930c;
	__map_gbk2utf16[0x6403] = 0x930d;
	__map_gbk2utf16[0x6404] = 0x930e;
	__map_gbk2utf16[0x6405] = 0x930f;
	__map_gbk2utf16[0x6406] = 0x9310;
	__map_gbk2utf16[0x6407] = 0x9311;
	__map_gbk2utf16[0x6408] = 0x9312;
	__map_gbk2utf16[0x6409] = 0x9313;
	__map_gbk2utf16[0x640a] = 0x9314;
	__map_gbk2utf16[0x640b] = 0x9315;
	__map_gbk2utf16[0x640c] = 0x9316;
	__map_gbk2utf16[0x640d] = 0x9317;
	__map_gbk2utf16[0x640e] = 0x9318;
	__map_gbk2utf16[0x640f] = 0x9319;
	__map_gbk2utf16[0x6410] = 0x931a;
	__map_gbk2utf16[0x6411] = 0x931b;
	__map_gbk2utf16[0x6412] = 0x931c;
	__map_gbk2utf16[0x6413] = 0x931d;
	__map_gbk2utf16[0x6414] = 0x931e;
	__map_gbk2utf16[0x6415] = 0x931f;
	__map_gbk2utf16[0x6416] = 0x9320;
	__map_gbk2utf16[0x6417] = 0x9321;
	__map_gbk2utf16[0x6418] = 0x9322;
	__map_gbk2utf16[0x6419] = 0x9323;
	__map_gbk2utf16[0x641a] = 0x9324;
	__map_gbk2utf16[0x641b] = 0x9325;
	__map_gbk2utf16[0x641c] = 0x9326;
	__map_gbk2utf16[0x641d] = 0x9327;
	__map_gbk2utf16[0x641e] = 0x9328;
	__map_gbk2utf16[0x641f] = 0x9329;
	__map_gbk2utf16[0x6420] = 0x932a;
	__map_gbk2utf16[0x6421] = 0x932b;
	__map_gbk2utf16[0x6422] = 0x932c;
	__map_gbk2utf16[0x6423] = 0x932d;
	__map_gbk2utf16[0x6424] = 0x932e;
	__map_gbk2utf16[0x6425] = 0x932f;
	__map_gbk2utf16[0x6426] = 0x9330;
	__map_gbk2utf16[0x6427] = 0x9331;
	__map_gbk2utf16[0x6428] = 0x9332;
	__map_gbk2utf16[0x6429] = 0x9333;
	__map_gbk2utf16[0x642a] = 0x9334;
	__map_gbk2utf16[0x642b] = 0x9335;
	__map_gbk2utf16[0x642c] = 0x9336;
	__map_gbk2utf16[0x642d] = 0x9337;
	__map_gbk2utf16[0x642e] = 0x9338;
	__map_gbk2utf16[0x642f] = 0x9339;
	__map_gbk2utf16[0x6430] = 0x933a;
	__map_gbk2utf16[0x6431] = 0x933b;
	__map_gbk2utf16[0x6432] = 0x933c;
	__map_gbk2utf16[0x6433] = 0x933d;
	__map_gbk2utf16[0x6434] = 0x933f;
	__map_gbk2utf16[0x6435] = 0x9340;
	__map_gbk2utf16[0x6436] = 0x9341;
	__map_gbk2utf16[0x6437] = 0x9342;
	__map_gbk2utf16[0x6438] = 0x9343;
	__map_gbk2utf16[0x6439] = 0x9344;
	__map_gbk2utf16[0x643a] = 0x9345;
	__map_gbk2utf16[0x643b] = 0x9346;
	__map_gbk2utf16[0x643c] = 0x9347;
	__map_gbk2utf16[0x643d] = 0x9348;
	__map_gbk2utf16[0x643e] = 0x9349;
	__map_gbk2utf16[0x6440] = 0x934a;
	__map_gbk2utf16[0x6441] = 0x934b;
	__map_gbk2utf16[0x6442] = 0x934c;
	__map_gbk2utf16[0x6443] = 0x934d;
	__map_gbk2utf16[0x6444] = 0x934e;
	__map_gbk2utf16[0x6445] = 0x934f;
	__map_gbk2utf16[0x6446] = 0x9350;
	__map_gbk2utf16[0x6447] = 0x9351;
	__map_gbk2utf16[0x6448] = 0x9352;
	__map_gbk2utf16[0x6449] = 0x9353;
	__map_gbk2utf16[0x644a] = 0x9354;
	__map_gbk2utf16[0x644b] = 0x9355;
	__map_gbk2utf16[0x644c] = 0x9356;
	__map_gbk2utf16[0x644d] = 0x9357;
	__map_gbk2utf16[0x644e] = 0x9358;
	__map_gbk2utf16[0x644f] = 0x9359;
	__map_gbk2utf16[0x6450] = 0x935a;
	__map_gbk2utf16[0x6451] = 0x935b;
	__map_gbk2utf16[0x6452] = 0x935c;
	__map_gbk2utf16[0x6453] = 0x935d;
	__map_gbk2utf16[0x6454] = 0x935e;
	__map_gbk2utf16[0x6455] = 0x935f;
	__map_gbk2utf16[0x6456] = 0x9360;
	__map_gbk2utf16[0x6457] = 0x9361;
	__map_gbk2utf16[0x6458] = 0x9362;
	__map_gbk2utf16[0x6459] = 0x9363;
	__map_gbk2utf16[0x645a] = 0x9364;
	__map_gbk2utf16[0x645b] = 0x9365;
	__map_gbk2utf16[0x645c] = 0x9366;
	__map_gbk2utf16[0x645d] = 0x9367;
	__map_gbk2utf16[0x645e] = 0x9368;
	__map_gbk2utf16[0x645f] = 0x9369;
	__map_gbk2utf16[0x6460] = 0x936b;
	__map_gbk2utf16[0x6461] = 0x6fc9;
	__map_gbk2utf16[0x6462] = 0x6fa7;
	__map_gbk2utf16[0x6463] = 0x6fb9;
	__map_gbk2utf16[0x6464] = 0x6fb6;
	__map_gbk2utf16[0x6465] = 0x6fc2;
	__map_gbk2utf16[0x6466] = 0x6fe1;
	__map_gbk2utf16[0x6467] = 0x6fee;
	__map_gbk2utf16[0x6468] = 0x6fde;
	__map_gbk2utf16[0x6469] = 0x6fe0;
	__map_gbk2utf16[0x646a] = 0x6fef;
	__map_gbk2utf16[0x646b] = 0x701a;
	__map_gbk2utf16[0x646c] = 0x7023;
	__map_gbk2utf16[0x646d] = 0x701b;
	__map_gbk2utf16[0x646e] = 0x7039;
	__map_gbk2utf16[0x646f] = 0x7035;
	__map_gbk2utf16[0x6470] = 0x704f;
	__map_gbk2utf16[0x6471] = 0x705e;
	__map_gbk2utf16[0x6472] = 0x5b80;
	__map_gbk2utf16[0x6473] = 0x5b84;
	__map_gbk2utf16[0x6474] = 0x5b95;
	__map_gbk2utf16[0x6475] = 0x5b93;
	__map_gbk2utf16[0x6476] = 0x5ba5;
	__map_gbk2utf16[0x6477] = 0x5bb8;
	__map_gbk2utf16[0x6478] = 0x752f;
	__map_gbk2utf16[0x6479] = 0x9a9e;
	__map_gbk2utf16[0x647a] = 0x6434;
	__map_gbk2utf16[0x647b] = 0x5be4;
	__map_gbk2utf16[0x647c] = 0x5bee;
	__map_gbk2utf16[0x647d] = 0x8930;
	__map_gbk2utf16[0x647e] = 0x5bf0;
	__map_gbk2utf16[0x647f] = 0x8e47;
	__map_gbk2utf16[0x6480] = 0x8b07;
	__map_gbk2utf16[0x6481] = 0x8fb6;
	__map_gbk2utf16[0x6482] = 0x8fd3;
	__map_gbk2utf16[0x6483] = 0x8fd5;
	__map_gbk2utf16[0x6484] = 0x8fe5;
	__map_gbk2utf16[0x6485] = 0x8fee;
	__map_gbk2utf16[0x6486] = 0x8fe4;
	__map_gbk2utf16[0x6487] = 0x8fe9;
	__map_gbk2utf16[0x6488] = 0x8fe6;
	__map_gbk2utf16[0x6489] = 0x8ff3;
	__map_gbk2utf16[0x648a] = 0x8fe8;
	__map_gbk2utf16[0x648b] = 0x9005;
	__map_gbk2utf16[0x648c] = 0x9004;
	__map_gbk2utf16[0x648d] = 0x900b;
	__map_gbk2utf16[0x648e] = 0x9026;
	__map_gbk2utf16[0x648f] = 0x9011;
	__map_gbk2utf16[0x6490] = 0x900d;
	__map_gbk2utf16[0x6491] = 0x9016;
	__map_gbk2utf16[0x6492] = 0x9021;
	__map_gbk2utf16[0x6493] = 0x9035;
	__map_gbk2utf16[0x6494] = 0x9036;
	__map_gbk2utf16[0x6495] = 0x902d;
	__map_gbk2utf16[0x6496] = 0x902f;
	__map_gbk2utf16[0x6497] = 0x9044;
	__map_gbk2utf16[0x6498] = 0x9051;
	__map_gbk2utf16[0x6499] = 0x9052;
	__map_gbk2utf16[0x649a] = 0x9050;
	__map_gbk2utf16[0x649b] = 0x9068;
	__map_gbk2utf16[0x649c] = 0x9058;
	__map_gbk2utf16[0x649d] = 0x9062;
	__map_gbk2utf16[0x649e] = 0x905b;
	__map_gbk2utf16[0x649f] = 0x66b9;
	__map_gbk2utf16[0x64a0] = 0x9074;
	__map_gbk2utf16[0x64a1] = 0x907d;
	__map_gbk2utf16[0x64a2] = 0x9082;
	__map_gbk2utf16[0x64a3] = 0x9088;
	__map_gbk2utf16[0x64a4] = 0x9083;
	__map_gbk2utf16[0x64a5] = 0x908b;
	__map_gbk2utf16[0x64a6] = 0x5f50;
	__map_gbk2utf16[0x64a7] = 0x5f57;
	__map_gbk2utf16[0x64a8] = 0x5f56;
	__map_gbk2utf16[0x64a9] = 0x5f58;
	__map_gbk2utf16[0x64aa] = 0x5c3b;
	__map_gbk2utf16[0x64ab] = 0x54ab;
	__map_gbk2utf16[0x64ac] = 0x5c50;
	__map_gbk2utf16[0x64ad] = 0x5c59;
	__map_gbk2utf16[0x64ae] = 0x5b71;
	__map_gbk2utf16[0x64af] = 0x5c63;
	__map_gbk2utf16[0x64b0] = 0x5c66;
	__map_gbk2utf16[0x64b1] = 0x7fbc;
	__map_gbk2utf16[0x64b2] = 0x5f2a;
	__map_gbk2utf16[0x64b3] = 0x5f29;
	__map_gbk2utf16[0x64b4] = 0x5f2d;
	__map_gbk2utf16[0x64b5] = 0x8274;
	__map_gbk2utf16[0x64b6] = 0x5f3c;
	__map_gbk2utf16[0x64b7] = 0x9b3b;
	__map_gbk2utf16[0x64b8] = 0x5c6e;
	__map_gbk2utf16[0x64b9] = 0x5981;
	__map_gbk2utf16[0x64ba] = 0x5983;
	__map_gbk2utf16[0x64bb] = 0x598d;
	__map_gbk2utf16[0x64bc] = 0x59a9;
	__map_gbk2utf16[0x64bd] = 0x59aa;
	__map_gbk2utf16[0x64be] = 0x59a3;
	__map_gbk2utf16[0x6500] = 0x936c;
	__map_gbk2utf16[0x6501] = 0x936d;
	__map_gbk2utf16[0x6502] = 0x936e;
	__map_gbk2utf16[0x6503] = 0x936f;
	__map_gbk2utf16[0x6504] = 0x9370;
	__map_gbk2utf16[0x6505] = 0x9371;
	__map_gbk2utf16[0x6506] = 0x9372;
	__map_gbk2utf16[0x6507] = 0x9373;
	__map_gbk2utf16[0x6508] = 0x9374;
	__map_gbk2utf16[0x6509] = 0x9375;
	__map_gbk2utf16[0x650a] = 0x9376;
	__map_gbk2utf16[0x650b] = 0x9377;
	__map_gbk2utf16[0x650c] = 0x9378;
	__map_gbk2utf16[0x650d] = 0x9379;
	__map_gbk2utf16[0x650e] = 0x937a;
	__map_gbk2utf16[0x650f] = 0x937b;
	__map_gbk2utf16[0x6510] = 0x937c;
	__map_gbk2utf16[0x6511] = 0x937d;
	__map_gbk2utf16[0x6512] = 0x937e;
	__map_gbk2utf16[0x6513] = 0x937f;
	__map_gbk2utf16[0x6514] = 0x9380;
	__map_gbk2utf16[0x6515] = 0x9381;
	__map_gbk2utf16[0x6516] = 0x9382;
	__map_gbk2utf16[0x6517] = 0x9383;
	__map_gbk2utf16[0x6518] = 0x9384;
	__map_gbk2utf16[0x6519] = 0x9385;
	__map_gbk2utf16[0x651a] = 0x9386;
	__map_gbk2utf16[0x651b] = 0x9387;
	__map_gbk2utf16[0x651c] = 0x9388;
	__map_gbk2utf16[0x651d] = 0x9389;
	__map_gbk2utf16[0x651e] = 0x938a;
	__map_gbk2utf16[0x651f] = 0x938b;
	__map_gbk2utf16[0x6520] = 0x938c;
	__map_gbk2utf16[0x6521] = 0x938d;
	__map_gbk2utf16[0x6522] = 0x938e;
	__map_gbk2utf16[0x6523] = 0x9390;
	__map_gbk2utf16[0x6524] = 0x9391;
	__map_gbk2utf16[0x6525] = 0x9392;
	__map_gbk2utf16[0x6526] = 0x9393;
	__map_gbk2utf16[0x6527] = 0x9394;
	__map_gbk2utf16[0x6528] = 0x9395;
	__map_gbk2utf16[0x6529] = 0x9396;
	__map_gbk2utf16[0x652a] = 0x9397;
	__map_gbk2utf16[0x652b] = 0x9398;
	__map_gbk2utf16[0x652c] = 0x9399;
	__map_gbk2utf16[0x652d] = 0x939a;
	__map_gbk2utf16[0x652e] = 0x939b;
	__map_gbk2utf16[0x652f] = 0x939c;
	__map_gbk2utf16[0x6530] = 0x939d;
	__map_gbk2utf16[0x6531] = 0x939e;
	__map_gbk2utf16[0x6532] = 0x939f;
	__map_gbk2utf16[0x6533] = 0x93a0;
	__map_gbk2utf16[0x6534] = 0x93a1;
	__map_gbk2utf16[0x6535] = 0x93a2;
	__map_gbk2utf16[0x6536] = 0x93a3;
	__map_gbk2utf16[0x6537] = 0x93a4;
	__map_gbk2utf16[0x6538] = 0x93a5;
	__map_gbk2utf16[0x6539] = 0x93a6;
	__map_gbk2utf16[0x653a] = 0x93a7;
	__map_gbk2utf16[0x653b] = 0x93a8;
	__map_gbk2utf16[0x653c] = 0x93a9;
	__map_gbk2utf16[0x653d] = 0x93aa;
	__map_gbk2utf16[0x653e] = 0x93ab;
	__map_gbk2utf16[0x6540] = 0x93ac;
	__map_gbk2utf16[0x6541] = 0x93ad;
	__map_gbk2utf16[0x6542] = 0x93ae;
	__map_gbk2utf16[0x6543] = 0x93af;
	__map_gbk2utf16[0x6544] = 0x93b0;
	__map_gbk2utf16[0x6545] = 0x93b1;
	__map_gbk2utf16[0x6546] = 0x93b2;
	__map_gbk2utf16[0x6547] = 0x93b3;
	__map_gbk2utf16[0x6548] = 0x93b4;
	__map_gbk2utf16[0x6549] = 0x93b5;
	__map_gbk2utf16[0x654a] = 0x93b6;
	__map_gbk2utf16[0x654b] = 0x93b7;
	__map_gbk2utf16[0x654c] = 0x93b8;
	__map_gbk2utf16[0x654d] = 0x93b9;
	__map_gbk2utf16[0x654e] = 0x93ba;
	__map_gbk2utf16[0x654f] = 0x93bb;
	__map_gbk2utf16[0x6550] = 0x93bc;
	__map_gbk2utf16[0x6551] = 0x93bd;
	__map_gbk2utf16[0x6552] = 0x93be;
	__map_gbk2utf16[0x6553] = 0x93bf;
	__map_gbk2utf16[0x6554] = 0x93c0;
	__map_gbk2utf16[0x6555] = 0x93c1;
	__map_gbk2utf16[0x6556] = 0x93c2;
	__map_gbk2utf16[0x6557] = 0x93c3;
	__map_gbk2utf16[0x6558] = 0x93c4;
	__map_gbk2utf16[0x6559] = 0x93c5;
	__map_gbk2utf16[0x655a] = 0x93c6;
	__map_gbk2utf16[0x655b] = 0x93c7;
	__map_gbk2utf16[0x655c] = 0x93c8;
	__map_gbk2utf16[0x655d] = 0x93c9;
	__map_gbk2utf16[0x655e] = 0x93cb;
	__map_gbk2utf16[0x655f] = 0x93cc;
	__map_gbk2utf16[0x6560] = 0x93cd;
	__map_gbk2utf16[0x6561] = 0x5997;
	__map_gbk2utf16[0x6562] = 0x59ca;
	__map_gbk2utf16[0x6563] = 0x59ab;
	__map_gbk2utf16[0x6564] = 0x599e;
	__map_gbk2utf16[0x6565] = 0x59a4;
	__map_gbk2utf16[0x6566] = 0x59d2;
	__map_gbk2utf16[0x6567] = 0x59b2;
	__map_gbk2utf16[0x6568] = 0x59af;
	__map_gbk2utf16[0x6569] = 0x59d7;
	__map_gbk2utf16[0x656a] = 0x59be;
	__map_gbk2utf16[0x656b] = 0x5a05;
	__map_gbk2utf16[0x656c] = 0x5a06;
	__map_gbk2utf16[0x656d] = 0x59dd;
	__map_gbk2utf16[0x656e] = 0x5a08;
	__map_gbk2utf16[0x656f] = 0x59e3;
	__map_gbk2utf16[0x6570] = 0x59d8;
	__map_gbk2utf16[0x6571] = 0x59f9;
	__map_gbk2utf16[0x6572] = 0x5a0c;
	__map_gbk2utf16[0x6573] = 0x5a09;
	__map_gbk2utf16[0x6574] = 0x5a32;
	__map_gbk2utf16[0x6575] = 0x5a34;
	__map_gbk2utf16[0x6576] = 0x5a11;
	__map_gbk2utf16[0x6577] = 0x5a23;
	__map_gbk2utf16[0x6578] = 0x5a13;
	__map_gbk2utf16[0x6579] = 0x5a40;
	__map_gbk2utf16[0x657a] = 0x5a67;
	__map_gbk2utf16[0x657b] = 0x5a4a;
	__map_gbk2utf16[0x657c] = 0x5a55;
	__map_gbk2utf16[0x657d] = 0x5a3c;
	__map_gbk2utf16[0x657e] = 0x5a62;
	__map_gbk2utf16[0x657f] = 0x5a75;
	__map_gbk2utf16[0x6580] = 0x80ec;
	__map_gbk2utf16[0x6581] = 0x5aaa;
	__map_gbk2utf16[0x6582] = 0x5a9b;
	__map_gbk2utf16[0x6583] = 0x5a77;
	__map_gbk2utf16[0x6584] = 0x5a7a;
	__map_gbk2utf16[0x6585] = 0x5abe;
	__map_gbk2utf16[0x6586] = 0x5aeb;
	__map_gbk2utf16[0x6587] = 0x5ab2;
	__map_gbk2utf16[0x6588] = 0x5ad2;
	__map_gbk2utf16[0x6589] = 0x5ad4;
	__map_gbk2utf16[0x658a] = 0x5ab8;
	__map_gbk2utf16[0x658b] = 0x5ae0;
	__map_gbk2utf16[0x658c] = 0x5ae3;
	__map_gbk2utf16[0x658d] = 0x5af1;
	__map_gbk2utf16[0x658e] = 0x5ad6;
	__map_gbk2utf16[0x658f] = 0x5ae6;
	__map_gbk2utf16[0x6590] = 0x5ad8;
	__map_gbk2utf16[0x6591] = 0x5adc;
	__map_gbk2utf16[0x6592] = 0x5b09;
	__map_gbk2utf16[0x6593] = 0x5b17;
	__map_gbk2utf16[0x6594] = 0x5b16;
	__map_gbk2utf16[0x6595] = 0x5b32;
	__map_gbk2utf16[0x6596] = 0x5b37;
	__map_gbk2utf16[0x6597] = 0x5b40;
	__map_gbk2utf16[0x6598] = 0x5c15;
	__map_gbk2utf16[0x6599] = 0x5c1c;
	__map_gbk2utf16[0x659a] = 0x5b5a;
	__map_gbk2utf16[0x659b] = 0x5b65;
	__map_gbk2utf16[0x659c] = 0x5b73;
	__map_gbk2utf16[0x659d] = 0x5b51;
	__map_gbk2utf16[0x659e] = 0x5b53;
	__map_gbk2utf16[0x659f] = 0x5b62;
	__map_gbk2utf16[0x65a0] = 0x9a75;
	__map_gbk2utf16[0x65a1] = 0x9a77;
	__map_gbk2utf16[0x65a2] = 0x9a78;
	__map_gbk2utf16[0x65a3] = 0x9a7a;
	__map_gbk2utf16[0x65a4] = 0x9a7f;
	__map_gbk2utf16[0x65a5] = 0x9a7d;
	__map_gbk2utf16[0x65a6] = 0x9a80;
	__map_gbk2utf16[0x65a7] = 0x9a81;
	__map_gbk2utf16[0x65a8] = 0x9a85;
	__map_gbk2utf16[0x65a9] = 0x9a88;
	__map_gbk2utf16[0x65aa] = 0x9a8a;
	__map_gbk2utf16[0x65ab] = 0x9a90;
	__map_gbk2utf16[0x65ac] = 0x9a92;
	__map_gbk2utf16[0x65ad] = 0x9a93;
	__map_gbk2utf16[0x65ae] = 0x9a96;
	__map_gbk2utf16[0x65af] = 0x9a98;
	__map_gbk2utf16[0x65b0] = 0x9a9b;
	__map_gbk2utf16[0x65b1] = 0x9a9c;
	__map_gbk2utf16[0x65b2] = 0x9a9d;
	__map_gbk2utf16[0x65b3] = 0x9a9f;
	__map_gbk2utf16[0x65b4] = 0x9aa0;
	__map_gbk2utf16[0x65b5] = 0x9aa2;
	__map_gbk2utf16[0x65b6] = 0x9aa3;
	__map_gbk2utf16[0x65b7] = 0x9aa5;
	__map_gbk2utf16[0x65b8] = 0x9aa7;
	__map_gbk2utf16[0x65b9] = 0x7e9f;
	__map_gbk2utf16[0x65ba] = 0x7ea1;
	__map_gbk2utf16[0x65bb] = 0x7ea3;
	__map_gbk2utf16[0x65bc] = 0x7ea5;
	__map_gbk2utf16[0x65bd] = 0x7ea8;
	__map_gbk2utf16[0x65be] = 0x7ea9;
	__map_gbk2utf16[0x6600] = 0x93ce;
	__map_gbk2utf16[0x6601] = 0x93cf;
	__map_gbk2utf16[0x6602] = 0x93d0;
	__map_gbk2utf16[0x6603] = 0x93d1;
	__map_gbk2utf16[0x6604] = 0x93d2;
	__map_gbk2utf16[0x6605] = 0x93d3;
	__map_gbk2utf16[0x6606] = 0x93d4;
	__map_gbk2utf16[0x6607] = 0x93d5;
	__map_gbk2utf16[0x6608] = 0x93d7;
	__map_gbk2utf16[0x6609] = 0x93d8;
	__map_gbk2utf16[0x660a] = 0x93d9;
	__map_gbk2utf16[0x660b] = 0x93da;
	__map_gbk2utf16[0x660c] = 0x93db;
	__map_gbk2utf16[0x660d] = 0x93dc;
	__map_gbk2utf16[0x660e] = 0x93dd;
	__map_gbk2utf16[0x660f] = 0x93de;
	__map_gbk2utf16[0x6610] = 0x93df;
	__map_gbk2utf16[0x6611] = 0x93e0;
	__map_gbk2utf16[0x6612] = 0x93e1;
	__map_gbk2utf16[0x6613] = 0x93e2;
	__map_gbk2utf16[0x6614] = 0x93e3;
	__map_gbk2utf16[0x6615] = 0x93e4;
	__map_gbk2utf16[0x6616] = 0x93e5;
	__map_gbk2utf16[0x6617] = 0x93e6;
	__map_gbk2utf16[0x6618] = 0x93e7;
	__map_gbk2utf16[0x6619] = 0x93e8;
	__map_gbk2utf16[0x661a] = 0x93e9;
	__map_gbk2utf16[0x661b] = 0x93ea;
	__map_gbk2utf16[0x661c] = 0x93eb;
	__map_gbk2utf16[0x661d] = 0x93ec;
	__map_gbk2utf16[0x661e] = 0x93ed;
	__map_gbk2utf16[0x661f] = 0x93ee;
	__map_gbk2utf16[0x6620] = 0x93ef;
	__map_gbk2utf16[0x6621] = 0x93f0;
	__map_gbk2utf16[0x6622] = 0x93f1;
	__map_gbk2utf16[0x6623] = 0x93f2;
	__map_gbk2utf16[0x6624] = 0x93f3;
	__map_gbk2utf16[0x6625] = 0x93f4;
	__map_gbk2utf16[0x6626] = 0x93f5;
	__map_gbk2utf16[0x6627] = 0x93f6;
	__map_gbk2utf16[0x6628] = 0x93f7;
	__map_gbk2utf16[0x6629] = 0x93f8;
	__map_gbk2utf16[0x662a] = 0x93f9;
	__map_gbk2utf16[0x662b] = 0x93fa;
	__map_gbk2utf16[0x662c] = 0x93fb;
	__map_gbk2utf16[0x662d] = 0x93fc;
	__map_gbk2utf16[0x662e] = 0x93fd;
	__map_gbk2utf16[0x662f] = 0x93fe;
	__map_gbk2utf16[0x6630] = 0x93ff;
	__map_gbk2utf16[0x6631] = 0x9400;
	__map_gbk2utf16[0x6632] = 0x9401;
	__map_gbk2utf16[0x6633] = 0x9402;
	__map_gbk2utf16[0x6634] = 0x9403;
	__map_gbk2utf16[0x6635] = 0x9404;
	__map_gbk2utf16[0x6636] = 0x9405;
	__map_gbk2utf16[0x6637] = 0x9406;
	__map_gbk2utf16[0x6638] = 0x9407;
	__map_gbk2utf16[0x6639] = 0x9408;
	__map_gbk2utf16[0x663a] = 0x9409;
	__map_gbk2utf16[0x663b] = 0x940a;
	__map_gbk2utf16[0x663c] = 0x940b;
	__map_gbk2utf16[0x663d] = 0x940c;
	__map_gbk2utf16[0x663e] = 0x940d;
	__map_gbk2utf16[0x6640] = 0x940e;
	__map_gbk2utf16[0x6641] = 0x940f;
	__map_gbk2utf16[0x6642] = 0x9410;
	__map_gbk2utf16[0x6643] = 0x9411;
	__map_gbk2utf16[0x6644] = 0x9412;
	__map_gbk2utf16[0x6645] = 0x9413;
	__map_gbk2utf16[0x6646] = 0x9414;
	__map_gbk2utf16[0x6647] = 0x9415;
	__map_gbk2utf16[0x6648] = 0x9416;
	__map_gbk2utf16[0x6649] = 0x9417;
	__map_gbk2utf16[0x664a] = 0x9418;
	__map_gbk2utf16[0x664b] = 0x9419;
	__map_gbk2utf16[0x664c] = 0x941a;
	__map_gbk2utf16[0x664d] = 0x941b;
	__map_gbk2utf16[0x664e] = 0x941c;
	__map_gbk2utf16[0x664f] = 0x941d;
	__map_gbk2utf16[0x6650] = 0x941e;
	__map_gbk2utf16[0x6651] = 0x941f;
	__map_gbk2utf16[0x6652] = 0x9420;
	__map_gbk2utf16[0x6653] = 0x9421;
	__map_gbk2utf16[0x6654] = 0x9422;
	__map_gbk2utf16[0x6655] = 0x9423;
	__map_gbk2utf16[0x6656] = 0x9424;
	__map_gbk2utf16[0x6657] = 0x9425;
	__map_gbk2utf16[0x6658] = 0x9426;
	__map_gbk2utf16[0x6659] = 0x9427;
	__map_gbk2utf16[0x665a] = 0x9428;
	__map_gbk2utf16[0x665b] = 0x9429;
	__map_gbk2utf16[0x665c] = 0x942a;
	__map_gbk2utf16[0x665d] = 0x942b;
	__map_gbk2utf16[0x665e] = 0x942c;
	__map_gbk2utf16[0x665f] = 0x942d;
	__map_gbk2utf16[0x6660] = 0x942e;
	__map_gbk2utf16[0x6661] = 0x7ead;
	__map_gbk2utf16[0x6662] = 0x7eb0;
	__map_gbk2utf16[0x6663] = 0x7ebe;
	__map_gbk2utf16[0x6664] = 0x7ec0;
	__map_gbk2utf16[0x6665] = 0x7ec1;
	__map_gbk2utf16[0x6666] = 0x7ec2;
	__map_gbk2utf16[0x6667] = 0x7ec9;
	__map_gbk2utf16[0x6668] = 0x7ecb;
	__map_gbk2utf16[0x6669] = 0x7ecc;
	__map_gbk2utf16[0x666a] = 0x7ed0;
	__map_gbk2utf16[0x666b] = 0x7ed4;
	__map_gbk2utf16[0x666c] = 0x7ed7;
	__map_gbk2utf16[0x666d] = 0x7edb;
	__map_gbk2utf16[0x666e] = 0x7ee0;
	__map_gbk2utf16[0x666f] = 0x7ee1;
	__map_gbk2utf16[0x6670] = 0x7ee8;
	__map_gbk2utf16[0x6671] = 0x7eeb;
	__map_gbk2utf16[0x6672] = 0x7eee;
	__map_gbk2utf16[0x6673] = 0x7eef;
	__map_gbk2utf16[0x6674] = 0x7ef1;
	__map_gbk2utf16[0x6675] = 0x7ef2;
	__map_gbk2utf16[0x6676] = 0x7f0d;
	__map_gbk2utf16[0x6677] = 0x7ef6;
	__map_gbk2utf16[0x6678] = 0x7efa;
	__map_gbk2utf16[0x6679] = 0x7efb;
	__map_gbk2utf16[0x667a] = 0x7efe;
	__map_gbk2utf16[0x667b] = 0x7f01;
	__map_gbk2utf16[0x667c] = 0x7f02;
	__map_gbk2utf16[0x667d] = 0x7f03;
	__map_gbk2utf16[0x667e] = 0x7f07;
	__map_gbk2utf16[0x667f] = 0x7f08;
	__map_gbk2utf16[0x6680] = 0x7f0b;
	__map_gbk2utf16[0x6681] = 0x7f0c;
	__map_gbk2utf16[0x6682] = 0x7f0f;
	__map_gbk2utf16[0x6683] = 0x7f11;
	__map_gbk2utf16[0x6684] = 0x7f12;
	__map_gbk2utf16[0x6685] = 0x7f17;
	__map_gbk2utf16[0x6686] = 0x7f19;
	__map_gbk2utf16[0x6687] = 0x7f1c;
	__map_gbk2utf16[0x6688] = 0x7f1b;
	__map_gbk2utf16[0x6689] = 0x7f1f;
	__map_gbk2utf16[0x668a] = 0x7f21;
	__map_gbk2utf16[0x668b] = 0x7f22;
	__map_gbk2utf16[0x668c] = 0x7f23;
	__map_gbk2utf16[0x668d] = 0x7f24;
	__map_gbk2utf16[0x668e] = 0x7f25;
	__map_gbk2utf16[0x668f] = 0x7f26;
	__map_gbk2utf16[0x6690] = 0x7f27;
	__map_gbk2utf16[0x6691] = 0x7f2a;
	__map_gbk2utf16[0x6692] = 0x7f2b;
	__map_gbk2utf16[0x6693] = 0x7f2c;
	__map_gbk2utf16[0x6694] = 0x7f2d;
	__map_gbk2utf16[0x6695] = 0x7f2f;
	__map_gbk2utf16[0x6696] = 0x7f30;
	__map_gbk2utf16[0x6697] = 0x7f31;
	__map_gbk2utf16[0x6698] = 0x7f32;
	__map_gbk2utf16[0x6699] = 0x7f33;
	__map_gbk2utf16[0x669a] = 0x7f35;
	__map_gbk2utf16[0x669b] = 0x5e7a;
	__map_gbk2utf16[0x669c] = 0x757f;
	__map_gbk2utf16[0x669d] = 0x5ddb;
	__map_gbk2utf16[0x669e] = 0x753e;
	__map_gbk2utf16[0x669f] = 0x9095;
	__map_gbk2utf16[0x66a0] = 0x738e;
	__map_gbk2utf16[0x66a1] = 0x7391;
	__map_gbk2utf16[0x66a2] = 0x73ae;
	__map_gbk2utf16[0x66a3] = 0x73a2;
	__map_gbk2utf16[0x66a4] = 0x739f;
	__map_gbk2utf16[0x66a5] = 0x73cf;
	__map_gbk2utf16[0x66a6] = 0x73c2;
	__map_gbk2utf16[0x66a7] = 0x73d1;
	__map_gbk2utf16[0x66a8] = 0x73b7;
	__map_gbk2utf16[0x66a9] = 0x73b3;
	__map_gbk2utf16[0x66aa] = 0x73c0;
	__map_gbk2utf16[0x66ab] = 0x73c9;
	__map_gbk2utf16[0x66ac] = 0x73c8;
	__map_gbk2utf16[0x66ad] = 0x73e5;
	__map_gbk2utf16[0x66ae] = 0x73d9;
	__map_gbk2utf16[0x66af] = 0x987c;
	__map_gbk2utf16[0x66b0] = 0x740a;
	__map_gbk2utf16[0x66b1] = 0x73e9;
	__map_gbk2utf16[0x66b2] = 0x73e7;
	__map_gbk2utf16[0x66b3] = 0x73de;
	__map_gbk2utf16[0x66b4] = 0x73ba;
	__map_gbk2utf16[0x66b5] = 0x73f2;
	__map_gbk2utf16[0x66b6] = 0x740f;
	__map_gbk2utf16[0x66b7] = 0x742a;
	__map_gbk2utf16[0x66b8] = 0x745b;
	__map_gbk2utf16[0x66b9] = 0x7426;
	__map_gbk2utf16[0x66ba] = 0x7425;
	__map_gbk2utf16[0x66bb] = 0x7428;
	__map_gbk2utf16[0x66bc] = 0x7430;
	__map_gbk2utf16[0x66bd] = 0x742e;
	__map_gbk2utf16[0x66be] = 0x742c;
	__map_gbk2utf16[0x6700] = 0x942f;
	__map_gbk2utf16[0x6701] = 0x9430;
	__map_gbk2utf16[0x6702] = 0x9431;
	__map_gbk2utf16[0x6703] = 0x9432;
	__map_gbk2utf16[0x6704] = 0x9433;
	__map_gbk2utf16[0x6705] = 0x9434;
	__map_gbk2utf16[0x6706] = 0x9435;
	__map_gbk2utf16[0x6707] = 0x9436;
	__map_gbk2utf16[0x6708] = 0x9437;
	__map_gbk2utf16[0x6709] = 0x9438;
	__map_gbk2utf16[0x670a] = 0x9439;
	__map_gbk2utf16[0x670b] = 0x943a;
	__map_gbk2utf16[0x670c] = 0x943b;
	__map_gbk2utf16[0x670d] = 0x943c;
	__map_gbk2utf16[0x670e] = 0x943d;
	__map_gbk2utf16[0x670f] = 0x943f;
	__map_gbk2utf16[0x6710] = 0x9440;
	__map_gbk2utf16[0x6711] = 0x9441;
	__map_gbk2utf16[0x6712] = 0x9442;
	__map_gbk2utf16[0x6713] = 0x9443;
	__map_gbk2utf16[0x6714] = 0x9444;
	__map_gbk2utf16[0x6715] = 0x9445;
	__map_gbk2utf16[0x6716] = 0x9446;
	__map_gbk2utf16[0x6717] = 0x9447;
	__map_gbk2utf16[0x6718] = 0x9448;
	__map_gbk2utf16[0x6719] = 0x9449;
	__map_gbk2utf16[0x671a] = 0x944a;
	__map_gbk2utf16[0x671b] = 0x944b;
	__map_gbk2utf16[0x671c] = 0x944c;
	__map_gbk2utf16[0x671d] = 0x944d;
	__map_gbk2utf16[0x671e] = 0x944e;
	__map_gbk2utf16[0x671f] = 0x944f;
	__map_gbk2utf16[0x6720] = 0x9450;
	__map_gbk2utf16[0x6721] = 0x9451;
	__map_gbk2utf16[0x6722] = 0x9452;
	__map_gbk2utf16[0x6723] = 0x9453;
	__map_gbk2utf16[0x6724] = 0x9454;
	__map_gbk2utf16[0x6725] = 0x9455;
	__map_gbk2utf16[0x6726] = 0x9456;
	__map_gbk2utf16[0x6727] = 0x9457;
	__map_gbk2utf16[0x6728] = 0x9458;
	__map_gbk2utf16[0x6729] = 0x9459;
	__map_gbk2utf16[0x672a] = 0x945a;
	__map_gbk2utf16[0x672b] = 0x945b;
	__map_gbk2utf16[0x672c] = 0x945c;
	__map_gbk2utf16[0x672d] = 0x945d;
	__map_gbk2utf16[0x672e] = 0x945e;
	__map_gbk2utf16[0x672f] = 0x945f;
	__map_gbk2utf16[0x6730] = 0x9460;
	__map_gbk2utf16[0x6731] = 0x9461;
	__map_gbk2utf16[0x6732] = 0x9462;
	__map_gbk2utf16[0x6733] = 0x9463;
	__map_gbk2utf16[0x6734] = 0x9464;
	__map_gbk2utf16[0x6735] = 0x9465;
	__map_gbk2utf16[0x6736] = 0x9466;
	__map_gbk2utf16[0x6737] = 0x9467;
	__map_gbk2utf16[0x6738] = 0x9468;
	__map_gbk2utf16[0x6739] = 0x9469;
	__map_gbk2utf16[0x673a] = 0x946a;
	__map_gbk2utf16[0x673b] = 0x946c;
	__map_gbk2utf16[0x673c] = 0x946d;
	__map_gbk2utf16[0x673d] = 0x946e;
	__map_gbk2utf16[0x673e] = 0x946f;
	__map_gbk2utf16[0x6740] = 0x9470;
	__map_gbk2utf16[0x6741] = 0x9471;
	__map_gbk2utf16[0x6742] = 0x9472;
	__map_gbk2utf16[0x6743] = 0x9473;
	__map_gbk2utf16[0x6744] = 0x9474;
	__map_gbk2utf16[0x6745] = 0x9475;
	__map_gbk2utf16[0x6746] = 0x9476;
	__map_gbk2utf16[0x6747] = 0x9477;
	__map_gbk2utf16[0x6748] = 0x9478;
	__map_gbk2utf16[0x6749] = 0x9479;
	__map_gbk2utf16[0x674a] = 0x947a;
	__map_gbk2utf16[0x674b] = 0x947b;
	__map_gbk2utf16[0x674c] = 0x947c;
	__map_gbk2utf16[0x674d] = 0x947d;
	__map_gbk2utf16[0x674e] = 0x947e;
	__map_gbk2utf16[0x674f] = 0x947f;
	__map_gbk2utf16[0x6750] = 0x9480;
	__map_gbk2utf16[0x6751] = 0x9481;
	__map_gbk2utf16[0x6752] = 0x9482;
	__map_gbk2utf16[0x6753] = 0x9483;
	__map_gbk2utf16[0x6754] = 0x9484;
	__map_gbk2utf16[0x6755] = 0x9491;
	__map_gbk2utf16[0x6756] = 0x9496;
	__map_gbk2utf16[0x6757] = 0x9498;
	__map_gbk2utf16[0x6758] = 0x94c7;
	__map_gbk2utf16[0x6759] = 0x94cf;
	__map_gbk2utf16[0x675a] = 0x94d3;
	__map_gbk2utf16[0x675b] = 0x94d4;
	__map_gbk2utf16[0x675c] = 0x94da;
	__map_gbk2utf16[0x675d] = 0x94e6;
	__map_gbk2utf16[0x675e] = 0x94fb;
	__map_gbk2utf16[0x675f] = 0x951c;
	__map_gbk2utf16[0x6760] = 0x9520;
	__map_gbk2utf16[0x6761] = 0x741b;
	__map_gbk2utf16[0x6762] = 0x741a;
	__map_gbk2utf16[0x6763] = 0x7441;
	__map_gbk2utf16[0x6764] = 0x745c;
	__map_gbk2utf16[0x6765] = 0x7457;
	__map_gbk2utf16[0x6766] = 0x7455;
	__map_gbk2utf16[0x6767] = 0x7459;
	__map_gbk2utf16[0x6768] = 0x7477;
	__map_gbk2utf16[0x6769] = 0x746d;
	__map_gbk2utf16[0x676a] = 0x747e;
	__map_gbk2utf16[0x676b] = 0x749c;
	__map_gbk2utf16[0x676c] = 0x748e;
	__map_gbk2utf16[0x676d] = 0x7480;
	__map_gbk2utf16[0x676e] = 0x7481;
	__map_gbk2utf16[0x676f] = 0x7487;
	__map_gbk2utf16[0x6770] = 0x748b;
	__map_gbk2utf16[0x6771] = 0x749e;
	__map_gbk2utf16[0x6772] = 0x74a8;
	__map_gbk2utf16[0x6773] = 0x74a9;
	__map_gbk2utf16[0x6774] = 0x7490;
	__map_gbk2utf16[0x6775] = 0x74a7;
	__map_gbk2utf16[0x6776] = 0x74d2;
	__map_gbk2utf16[0x6777] = 0x74ba;
	__map_gbk2utf16[0x6778] = 0x97ea;
	__map_gbk2utf16[0x6779] = 0x97eb;
	__map_gbk2utf16[0x677a] = 0x97ec;
	__map_gbk2utf16[0x677b] = 0x674c;
	__map_gbk2utf16[0x677c] = 0x6753;
	__map_gbk2utf16[0x677d] = 0x675e;
	__map_gbk2utf16[0x677e] = 0x6748;
	__map_gbk2utf16[0x677f] = 0x6769;
	__map_gbk2utf16[0x6780] = 0x67a5;
	__map_gbk2utf16[0x6781] = 0x6787;
	__map_gbk2utf16[0x6782] = 0x676a;
	__map_gbk2utf16[0x6783] = 0x6773;
	__map_gbk2utf16[0x6784] = 0x6798;
	__map_gbk2utf16[0x6785] = 0x67a7;
	__map_gbk2utf16[0x6786] = 0x6775;
	__map_gbk2utf16[0x6787] = 0x67a8;
	__map_gbk2utf16[0x6788] = 0x679e;
	__map_gbk2utf16[0x6789] = 0x67ad;
	__map_gbk2utf16[0x678a] = 0x678b;
	__map_gbk2utf16[0x678b] = 0x6777;
	__map_gbk2utf16[0x678c] = 0x677c;
	__map_gbk2utf16[0x678d] = 0x67f0;
	__map_gbk2utf16[0x678e] = 0x6809;
	__map_gbk2utf16[0x678f] = 0x67d8;
	__map_gbk2utf16[0x6790] = 0x680a;
	__map_gbk2utf16[0x6791] = 0x67e9;
	__map_gbk2utf16[0x6792] = 0x67b0;
	__map_gbk2utf16[0x6793] = 0x680c;
	__map_gbk2utf16[0x6794] = 0x67d9;
	__map_gbk2utf16[0x6795] = 0x67b5;
	__map_gbk2utf16[0x6796] = 0x67da;
	__map_gbk2utf16[0x6797] = 0x67b3;
	__map_gbk2utf16[0x6798] = 0x67dd;
	__map_gbk2utf16[0x6799] = 0x6800;
	__map_gbk2utf16[0x679a] = 0x67c3;
	__map_gbk2utf16[0x679b] = 0x67b8;
	__map_gbk2utf16[0x679c] = 0x67e2;
	__map_gbk2utf16[0x679d] = 0x680e;
	__map_gbk2utf16[0x679e] = 0x67c1;
	__map_gbk2utf16[0x679f] = 0x67fd;
	__map_gbk2utf16[0x67a0] = 0x6832;
	__map_gbk2utf16[0x67a1] = 0x6833;
	__map_gbk2utf16[0x67a2] = 0x6860;
	__map_gbk2utf16[0x67a3] = 0x6861;
	__map_gbk2utf16[0x67a4] = 0x684e;
	__map_gbk2utf16[0x67a5] = 0x6862;
	__map_gbk2utf16[0x67a6] = 0x6844;
	__map_gbk2utf16[0x67a7] = 0x6864;
	__map_gbk2utf16[0x67a8] = 0x6883;
	__map_gbk2utf16[0x67a9] = 0x681d;
	__map_gbk2utf16[0x67aa] = 0x6855;
	__map_gbk2utf16[0x67ab] = 0x6866;
	__map_gbk2utf16[0x67ac] = 0x6841;
	__map_gbk2utf16[0x67ad] = 0x6867;
	__map_gbk2utf16[0x67ae] = 0x6840;
	__map_gbk2utf16[0x67af] = 0x683e;
	__map_gbk2utf16[0x67b0] = 0x684a;
	__map_gbk2utf16[0x67b1] = 0x6849;
	__map_gbk2utf16[0x67b2] = 0x6829;
	__map_gbk2utf16[0x67b3] = 0x68b5;
	__map_gbk2utf16[0x67b4] = 0x688f;
	__map_gbk2utf16[0x67b5] = 0x6874;
	__map_gbk2utf16[0x67b6] = 0x6877;
	__map_gbk2utf16[0x67b7] = 0x6893;
	__map_gbk2utf16[0x67b8] = 0x686b;
	__map_gbk2utf16[0x67b9] = 0x68c2;
	__map_gbk2utf16[0x67ba] = 0x696e;
	__map_gbk2utf16[0x67bb] = 0x68fc;
	__map_gbk2utf16[0x67bc] = 0x691f;
	__map_gbk2utf16[0x67bd] = 0x6920;
	__map_gbk2utf16[0x67be] = 0x68f9;
	__map_gbk2utf16[0x6800] = 0x9527;
	__map_gbk2utf16[0x6801] = 0x9533;
	__map_gbk2utf16[0x6802] = 0x953d;
	__map_gbk2utf16[0x6803] = 0x9543;
	__map_gbk2utf16[0x6804] = 0x9548;
	__map_gbk2utf16[0x6805] = 0x954b;
	__map_gbk2utf16[0x6806] = 0x9555;
	__map_gbk2utf16[0x6807] = 0x955a;
	__map_gbk2utf16[0x6808] = 0x9560;
	__map_gbk2utf16[0x6809] = 0x956e;
	__map_gbk2utf16[0x680a] = 0x9574;
	__map_gbk2utf16[0x680b] = 0x9575;
	__map_gbk2utf16[0x680c] = 0x9577;
	__map_gbk2utf16[0x680d] = 0x9578;
	__map_gbk2utf16[0x680e] = 0x9579;
	__map_gbk2utf16[0x680f] = 0x957a;
	__map_gbk2utf16[0x6810] = 0x957b;
	__map_gbk2utf16[0x6811] = 0x957c;
	__map_gbk2utf16[0x6812] = 0x957d;
	__map_gbk2utf16[0x6813] = 0x957e;
	__map_gbk2utf16[0x6814] = 0x9580;
	__map_gbk2utf16[0x6815] = 0x9581;
	__map_gbk2utf16[0x6816] = 0x9582;
	__map_gbk2utf16[0x6817] = 0x9583;
	__map_gbk2utf16[0x6818] = 0x9584;
	__map_gbk2utf16[0x6819] = 0x9585;
	__map_gbk2utf16[0x681a] = 0x9586;
	__map_gbk2utf16[0x681b] = 0x9587;
	__map_gbk2utf16[0x681c] = 0x9588;
	__map_gbk2utf16[0x681d] = 0x9589;
	__map_gbk2utf16[0x681e] = 0x958a;
	__map_gbk2utf16[0x681f] = 0x958b;
	__map_gbk2utf16[0x6820] = 0x958c;
	__map_gbk2utf16[0x6821] = 0x958d;
	__map_gbk2utf16[0x6822] = 0x958e;
	__map_gbk2utf16[0x6823] = 0x958f;
	__map_gbk2utf16[0x6824] = 0x9590;
	__map_gbk2utf16[0x6825] = 0x9591;
	__map_gbk2utf16[0x6826] = 0x9592;
	__map_gbk2utf16[0x6827] = 0x9593;
	__map_gbk2utf16[0x6828] = 0x9594;
	__map_gbk2utf16[0x6829] = 0x9595;
	__map_gbk2utf16[0x682a] = 0x9596;
	__map_gbk2utf16[0x682b] = 0x9597;
	__map_gbk2utf16[0x682c] = 0x9598;
	__map_gbk2utf16[0x682d] = 0x9599;
	__map_gbk2utf16[0x682e] = 0x959a;
	__map_gbk2utf16[0x682f] = 0x959b;
	__map_gbk2utf16[0x6830] = 0x959c;
	__map_gbk2utf16[0x6831] = 0x959d;
	__map_gbk2utf16[0x6832] = 0x959e;
	__map_gbk2utf16[0x6833] = 0x959f;
	__map_gbk2utf16[0x6834] = 0x95a0;
	__map_gbk2utf16[0x6835] = 0x95a1;
	__map_gbk2utf16[0x6836] = 0x95a2;
	__map_gbk2utf16[0x6837] = 0x95a3;
	__map_gbk2utf16[0x6838] = 0x95a4;
	__map_gbk2utf16[0x6839] = 0x95a5;
	__map_gbk2utf16[0x683a] = 0x95a6;
	__map_gbk2utf16[0x683b] = 0x95a7;
	__map_gbk2utf16[0x683c] = 0x95a8;
	__map_gbk2utf16[0x683d] = 0x95a9;
	__map_gbk2utf16[0x683e] = 0x95aa;
	__map_gbk2utf16[0x6840] = 0x95ab;
	__map_gbk2utf16[0x6841] = 0x95ac;
	__map_gbk2utf16[0x6842] = 0x95ad;
	__map_gbk2utf16[0x6843] = 0x95ae;
	__map_gbk2utf16[0x6844] = 0x95af;
	__map_gbk2utf16[0x6845] = 0x95b0;
	__map_gbk2utf16[0x6846] = 0x95b1;
	__map_gbk2utf16[0x6847] = 0x95b2;
	__map_gbk2utf16[0x6848] = 0x95b3;
	__map_gbk2utf16[0x6849] = 0x95b4;
	__map_gbk2utf16[0x684a] = 0x95b5;
	__map_gbk2utf16[0x684b] = 0x95b6;
	__map_gbk2utf16[0x684c] = 0x95b7;
	__map_gbk2utf16[0x684d] = 0x95b8;
	__map_gbk2utf16[0x684e] = 0x95b9;
	__map_gbk2utf16[0x684f] = 0x95ba;
	__map_gbk2utf16[0x6850] = 0x95bb;
	__map_gbk2utf16[0x6851] = 0x95bc;
	__map_gbk2utf16[0x6852] = 0x95bd;
	__map_gbk2utf16[0x6853] = 0x95be;
	__map_gbk2utf16[0x6854] = 0x95bf;
	__map_gbk2utf16[0x6855] = 0x95c0;
	__map_gbk2utf16[0x6856] = 0x95c1;
	__map_gbk2utf16[0x6857] = 0x95c2;
	__map_gbk2utf16[0x6858] = 0x95c3;
	__map_gbk2utf16[0x6859] = 0x95c4;
	__map_gbk2utf16[0x685a] = 0x95c5;
	__map_gbk2utf16[0x685b] = 0x95c6;
	__map_gbk2utf16[0x685c] = 0x95c7;
	__map_gbk2utf16[0x685d] = 0x95c8;
	__map_gbk2utf16[0x685e] = 0x95c9;
	__map_gbk2utf16[0x685f] = 0x95ca;
	__map_gbk2utf16[0x6860] = 0x95cb;
	__map_gbk2utf16[0x6861] = 0x6924;
	__map_gbk2utf16[0x6862] = 0x68f0;
	__map_gbk2utf16[0x6863] = 0x690b;
	__map_gbk2utf16[0x6864] = 0x6901;
	__map_gbk2utf16[0x6865] = 0x6957;
	__map_gbk2utf16[0x6866] = 0x68e3;
	__map_gbk2utf16[0x6867] = 0x6910;
	__map_gbk2utf16[0x6868] = 0x6971;
	__map_gbk2utf16[0x6869] = 0x6939;
	__map_gbk2utf16[0x686a] = 0x6960;
	__map_gbk2utf16[0x686b] = 0x6942;
	__map_gbk2utf16[0x686c] = 0x695d;
	__map_gbk2utf16[0x686d] = 0x6984;
	__map_gbk2utf16[0x686e] = 0x696b;
	__map_gbk2utf16[0x686f] = 0x6980;
	__map_gbk2utf16[0x6870] = 0x6998;
	__map_gbk2utf16[0x6871] = 0x6978;
	__map_gbk2utf16[0x6872] = 0x6934;
	__map_gbk2utf16[0x6873] = 0x69cc;
	__map_gbk2utf16[0x6874] = 0x6987;
	__map_gbk2utf16[0x6875] = 0x6988;
	__map_gbk2utf16[0x6876] = 0x69ce;
	__map_gbk2utf16[0x6877] = 0x6989;
	__map_gbk2utf16[0x6878] = 0x6966;
	__map_gbk2utf16[0x6879] = 0x6963;
	__map_gbk2utf16[0x687a] = 0x6979;
	__map_gbk2utf16[0x687b] = 0x699b;
	__map_gbk2utf16[0x687c] = 0x69a7;
	__map_gbk2utf16[0x687d] = 0x69bb;
	__map_gbk2utf16[0x687e] = 0x69ab;
	__map_gbk2utf16[0x687f] = 0x69ad;
	__map_gbk2utf16[0x6880] = 0x69d4;
	__map_gbk2utf16[0x6881] = 0x69b1;
	__map_gbk2utf16[0x6882] = 0x69c1;
	__map_gbk2utf16[0x6883] = 0x69ca;
	__map_gbk2utf16[0x6884] = 0x69df;
	__map_gbk2utf16[0x6885] = 0x6995;
	__map_gbk2utf16[0x6886] = 0x69e0;
	__map_gbk2utf16[0x6887] = 0x698d;
	__map_gbk2utf16[0x6888] = 0x69ff;
	__map_gbk2utf16[0x6889] = 0x6a2f;
	__map_gbk2utf16[0x688a] = 0x69ed;
	__map_gbk2utf16[0x688b] = 0x6a17;
	__map_gbk2utf16[0x688c] = 0x6a18;
	__map_gbk2utf16[0x688d] = 0x6a65;
	__map_gbk2utf16[0x688e] = 0x69f2;
	__map_gbk2utf16[0x688f] = 0x6a44;
	__map_gbk2utf16[0x6890] = 0x6a3e;
	__map_gbk2utf16[0x6891] = 0x6aa0;
	__map_gbk2utf16[0x6892] = 0x6a50;
	__map_gbk2utf16[0x6893] = 0x6a5b;
	__map_gbk2utf16[0x6894] = 0x6a35;
	__map_gbk2utf16[0x6895] = 0x6a8e;
	__map_gbk2utf16[0x6896] = 0x6a79;
	__map_gbk2utf16[0x6897] = 0x6a3d;
	__map_gbk2utf16[0x6898] = 0x6a28;
	__map_gbk2utf16[0x6899] = 0x6a58;
	__map_gbk2utf16[0x689a] = 0x6a7c;
	__map_gbk2utf16[0x689b] = 0x6a91;
	__map_gbk2utf16[0x689c] = 0x6a90;
	__map_gbk2utf16[0x689d] = 0x6aa9;
	__map_gbk2utf16[0x689e] = 0x6a97;
	__map_gbk2utf16[0x689f] = 0x6aab;
	__map_gbk2utf16[0x68a0] = 0x7337;
	__map_gbk2utf16[0x68a1] = 0x7352;
	__map_gbk2utf16[0x68a2] = 0x6b81;
	__map_gbk2utf16[0x68a3] = 0x6b82;
	__map_gbk2utf16[0x68a4] = 0x6b87;
	__map_gbk2utf16[0x68a5] = 0x6b84;
	__map_gbk2utf16[0x68a6] = 0x6b92;
	__map_gbk2utf16[0x68a7] = 0x6b93;
	__map_gbk2utf16[0x68a8] = 0x6b8d;
	__map_gbk2utf16[0x68a9] = 0x6b9a;
	__map_gbk2utf16[0x68aa] = 0x6b9b;
	__map_gbk2utf16[0x68ab] = 0x6ba1;
	__map_gbk2utf16[0x68ac] = 0x6baa;
	__map_gbk2utf16[0x68ad] = 0x8f6b;
	__map_gbk2utf16[0x68ae] = 0x8f6d;
	__map_gbk2utf16[0x68af] = 0x8f71;
	__map_gbk2utf16[0x68b0] = 0x8f72;
	__map_gbk2utf16[0x68b1] = 0x8f73;
	__map_gbk2utf16[0x68b2] = 0x8f75;
	__map_gbk2utf16[0x68b3] = 0x8f76;
	__map_gbk2utf16[0x68b4] = 0x8f78;
	__map_gbk2utf16[0x68b5] = 0x8f77;
	__map_gbk2utf16[0x68b6] = 0x8f79;
	__map_gbk2utf16[0x68b7] = 0x8f7a;
	__map_gbk2utf16[0x68b8] = 0x8f7c;
	__map_gbk2utf16[0x68b9] = 0x8f7e;
	__map_gbk2utf16[0x68ba] = 0x8f81;
	__map_gbk2utf16[0x68bb] = 0x8f82;
	__map_gbk2utf16[0x68bc] = 0x8f84;
	__map_gbk2utf16[0x68bd] = 0x8f87;
	__map_gbk2utf16[0x68be] = 0x8f8b;
	__map_gbk2utf16[0x6900] = 0x95cc;
	__map_gbk2utf16[0x6901] = 0x95cd;
	__map_gbk2utf16[0x6902] = 0x95ce;
	__map_gbk2utf16[0x6903] = 0x95cf;
	__map_gbk2utf16[0x6904] = 0x95d0;
	__map_gbk2utf16[0x6905] = 0x95d1;
	__map_gbk2utf16[0x6906] = 0x95d2;
	__map_gbk2utf16[0x6907] = 0x95d3;
	__map_gbk2utf16[0x6908] = 0x95d4;
	__map_gbk2utf16[0x6909] = 0x95d5;
	__map_gbk2utf16[0x690a] = 0x95d6;
	__map_gbk2utf16[0x690b] = 0x95d7;
	__map_gbk2utf16[0x690c] = 0x95d8;
	__map_gbk2utf16[0x690d] = 0x95d9;
	__map_gbk2utf16[0x690e] = 0x95da;
	__map_gbk2utf16[0x690f] = 0x95db;
	__map_gbk2utf16[0x6910] = 0x95dc;
	__map_gbk2utf16[0x6911] = 0x95dd;
	__map_gbk2utf16[0x6912] = 0x95de;
	__map_gbk2utf16[0x6913] = 0x95df;
	__map_gbk2utf16[0x6914] = 0x95e0;
	__map_gbk2utf16[0x6915] = 0x95e1;
	__map_gbk2utf16[0x6916] = 0x95e2;
	__map_gbk2utf16[0x6917] = 0x95e3;
	__map_gbk2utf16[0x6918] = 0x95e4;
	__map_gbk2utf16[0x6919] = 0x95e5;
	__map_gbk2utf16[0x691a] = 0x95e6;
	__map_gbk2utf16[0x691b] = 0x95e7;
	__map_gbk2utf16[0x691c] = 0x95ec;
	__map_gbk2utf16[0x691d] = 0x95ff;
	__map_gbk2utf16[0x691e] = 0x9607;
	__map_gbk2utf16[0x691f] = 0x9613;
	__map_gbk2utf16[0x6920] = 0x9618;
	__map_gbk2utf16[0x6921] = 0x961b;
	__map_gbk2utf16[0x6922] = 0x961e;
	__map_gbk2utf16[0x6923] = 0x9620;
	__map_gbk2utf16[0x6924] = 0x9623;
	__map_gbk2utf16[0x6925] = 0x9624;
	__map_gbk2utf16[0x6926] = 0x9625;
	__map_gbk2utf16[0x6927] = 0x9626;
	__map_gbk2utf16[0x6928] = 0x9627;
	__map_gbk2utf16[0x6929] = 0x9628;
	__map_gbk2utf16[0x692a] = 0x9629;
	__map_gbk2utf16[0x692b] = 0x962b;
	__map_gbk2utf16[0x692c] = 0x962c;
	__map_gbk2utf16[0x692d] = 0x962d;
	__map_gbk2utf16[0x692e] = 0x962f;
	__map_gbk2utf16[0x692f] = 0x9630;
	__map_gbk2utf16[0x6930] = 0x9637;
	__map_gbk2utf16[0x6931] = 0x9638;
	__map_gbk2utf16[0x6932] = 0x9639;
	__map_gbk2utf16[0x6933] = 0x963a;
	__map_gbk2utf16[0x6934] = 0x963e;
	__map_gbk2utf16[0x6935] = 0x9641;
	__map_gbk2utf16[0x6936] = 0x9643;
	__map_gbk2utf16[0x6937] = 0x964a;
	__map_gbk2utf16[0x6938] = 0x964e;
	__map_gbk2utf16[0x6939] = 0x964f;
	__map_gbk2utf16[0x693a] = 0x9651;
	__map_gbk2utf16[0x693b] = 0x9652;
	__map_gbk2utf16[0x693c] = 0x9653;
	__map_gbk2utf16[0x693d] = 0x9656;
	__map_gbk2utf16[0x693e] = 0x9657;
	__map_gbk2utf16[0x6940] = 0x9658;
	__map_gbk2utf16[0x6941] = 0x9659;
	__map_gbk2utf16[0x6942] = 0x965a;
	__map_gbk2utf16[0x6943] = 0x965c;
	__map_gbk2utf16[0x6944] = 0x965d;
	__map_gbk2utf16[0x6945] = 0x965e;
	__map_gbk2utf16[0x6946] = 0x9660;
	__map_gbk2utf16[0x6947] = 0x9663;
	__map_gbk2utf16[0x6948] = 0x9665;
	__map_gbk2utf16[0x6949] = 0x9666;
	__map_gbk2utf16[0x694a] = 0x966b;
	__map_gbk2utf16[0x694b] = 0x966d;
	__map_gbk2utf16[0x694c] = 0x966e;
	__map_gbk2utf16[0x694d] = 0x966f;
	__map_gbk2utf16[0x694e] = 0x9670;
	__map_gbk2utf16[0x694f] = 0x9671;
	__map_gbk2utf16[0x6950] = 0x9673;
	__map_gbk2utf16[0x6951] = 0x9678;
	__map_gbk2utf16[0x6952] = 0x9679;
	__map_gbk2utf16[0x6953] = 0x967a;
	__map_gbk2utf16[0x6954] = 0x967b;
	__map_gbk2utf16[0x6955] = 0x967c;
	__map_gbk2utf16[0x6956] = 0x967d;
	__map_gbk2utf16[0x6957] = 0x967e;
	__map_gbk2utf16[0x6958] = 0x967f;
	__map_gbk2utf16[0x6959] = 0x9680;
	__map_gbk2utf16[0x695a] = 0x9681;
	__map_gbk2utf16[0x695b] = 0x9682;
	__map_gbk2utf16[0x695c] = 0x9683;
	__map_gbk2utf16[0x695d] = 0x9684;
	__map_gbk2utf16[0x695e] = 0x9687;
	__map_gbk2utf16[0x695f] = 0x9689;
	__map_gbk2utf16[0x6960] = 0x968a;
	__map_gbk2utf16[0x6961] = 0x8f8d;
	__map_gbk2utf16[0x6962] = 0x8f8e;
	__map_gbk2utf16[0x6963] = 0x8f8f;
	__map_gbk2utf16[0x6964] = 0x8f98;
	__map_gbk2utf16[0x6965] = 0x8f9a;
	__map_gbk2utf16[0x6966] = 0x8ece;
	__map_gbk2utf16[0x6967] = 0x620b;
	__map_gbk2utf16[0x6968] = 0x6217;
	__map_gbk2utf16[0x6969] = 0x621b;
	__map_gbk2utf16[0x696a] = 0x621f;
	__map_gbk2utf16[0x696b] = 0x6222;
	__map_gbk2utf16[0x696c] = 0x6221;
	__map_gbk2utf16[0x696d] = 0x6225;
	__map_gbk2utf16[0x696e] = 0x6224;
	__map_gbk2utf16[0x696f] = 0x622c;
	__map_gbk2utf16[0x6970] = 0x81e7;
	__map_gbk2utf16[0x6971] = 0x74ef;
	__map_gbk2utf16[0x6972] = 0x74f4;
	__map_gbk2utf16[0x6973] = 0x74ff;
	__map_gbk2utf16[0x6974] = 0x750f;
	__map_gbk2utf16[0x6975] = 0x7511;
	__map_gbk2utf16[0x6976] = 0x7513;
	__map_gbk2utf16[0x6977] = 0x6534;
	__map_gbk2utf16[0x6978] = 0x65ee;
	__map_gbk2utf16[0x6979] = 0x65ef;
	__map_gbk2utf16[0x697a] = 0x65f0;
	__map_gbk2utf16[0x697b] = 0x660a;
	__map_gbk2utf16[0x697c] = 0x6619;
	__map_gbk2utf16[0x697d] = 0x6772;
	__map_gbk2utf16[0x697e] = 0x6603;
	__map_gbk2utf16[0x697f] = 0x6615;
	__map_gbk2utf16[0x6980] = 0x6600;
	__map_gbk2utf16[0x6981] = 0x7085;
	__map_gbk2utf16[0x6982] = 0x66f7;
	__map_gbk2utf16[0x6983] = 0x661d;
	__map_gbk2utf16[0x6984] = 0x6634;
	__map_gbk2utf16[0x6985] = 0x6631;
	__map_gbk2utf16[0x6986] = 0x6636;
	__map_gbk2utf16[0x6987] = 0x6635;
	__map_gbk2utf16[0x6988] = 0x8006;
	__map_gbk2utf16[0x6989] = 0x665f;
	__map_gbk2utf16[0x698a] = 0x6654;
	__map_gbk2utf16[0x698b] = 0x6641;
	__map_gbk2utf16[0x698c] = 0x664f;
	__map_gbk2utf16[0x698d] = 0x6656;
	__map_gbk2utf16[0x698e] = 0x6661;
	__map_gbk2utf16[0x698f] = 0x6657;
	__map_gbk2utf16[0x6990] = 0x6677;
	__map_gbk2utf16[0x6991] = 0x6684;
	__map_gbk2utf16[0x6992] = 0x668c;
	__map_gbk2utf16[0x6993] = 0x66a7;
	__map_gbk2utf16[0x6994] = 0x669d;
	__map_gbk2utf16[0x6995] = 0x66be;
	__map_gbk2utf16[0x6996] = 0x66db;
	__map_gbk2utf16[0x6997] = 0x66dc;
	__map_gbk2utf16[0x6998] = 0x66e6;
	__map_gbk2utf16[0x6999] = 0x66e9;
	__map_gbk2utf16[0x699a] = 0x8d32;
	__map_gbk2utf16[0x699b] = 0x8d33;
	__map_gbk2utf16[0x699c] = 0x8d36;
	__map_gbk2utf16[0x699d] = 0x8d3b;
	__map_gbk2utf16[0x699e] = 0x8d3d;
	__map_gbk2utf16[0x699f] = 0x8d40;
	__map_gbk2utf16[0x69a0] = 0x8d45;
	__map_gbk2utf16[0x69a1] = 0x8d46;
	__map_gbk2utf16[0x69a2] = 0x8d48;
	__map_gbk2utf16[0x69a3] = 0x8d49;
	__map_gbk2utf16[0x69a4] = 0x8d47;
	__map_gbk2utf16[0x69a5] = 0x8d4d;
	__map_gbk2utf16[0x69a6] = 0x8d55;
	__map_gbk2utf16[0x69a7] = 0x8d59;
	__map_gbk2utf16[0x69a8] = 0x89c7;
	__map_gbk2utf16[0x69a9] = 0x89ca;
	__map_gbk2utf16[0x69aa] = 0x89cb;
	__map_gbk2utf16[0x69ab] = 0x89cc;
	__map_gbk2utf16[0x69ac] = 0x89ce;
	__map_gbk2utf16[0x69ad] = 0x89cf;
	__map_gbk2utf16[0x69ae] = 0x89d0;
	__map_gbk2utf16[0x69af] = 0x89d1;
	__map_gbk2utf16[0x69b0] = 0x726e;
	__map_gbk2utf16[0x69b1] = 0x729f;
	__map_gbk2utf16[0x69b2] = 0x725d;
	__map_gbk2utf16[0x69b3] = 0x7266;
	__map_gbk2utf16[0x69b4] = 0x726f;
	__map_gbk2utf16[0x69b5] = 0x727e;
	__map_gbk2utf16[0x69b6] = 0x727f;
	__map_gbk2utf16[0x69b7] = 0x7284;
	__map_gbk2utf16[0x69b8] = 0x728b;
	__map_gbk2utf16[0x69b9] = 0x728d;
	__map_gbk2utf16[0x69ba] = 0x728f;
	__map_gbk2utf16[0x69bb] = 0x7292;
	__map_gbk2utf16[0x69bc] = 0x6308;
	__map_gbk2utf16[0x69bd] = 0x6332;
	__map_gbk2utf16[0x69be] = 0x63b0;
	__map_gbk2utf16[0x6a00] = 0x968c;
	__map_gbk2utf16[0x6a01] = 0x968e;
	__map_gbk2utf16[0x6a02] = 0x9691;
	__map_gbk2utf16[0x6a03] = 0x9692;
	__map_gbk2utf16[0x6a04] = 0x9693;
	__map_gbk2utf16[0x6a05] = 0x9695;
	__map_gbk2utf16[0x6a06] = 0x9696;
	__map_gbk2utf16[0x6a07] = 0x969a;
	__map_gbk2utf16[0x6a08] = 0x969b;
	__map_gbk2utf16[0x6a09] = 0x969d;
	__map_gbk2utf16[0x6a0a] = 0x969e;
	__map_gbk2utf16[0x6a0b] = 0x969f;
	__map_gbk2utf16[0x6a0c] = 0x96a0;
	__map_gbk2utf16[0x6a0d] = 0x96a1;
	__map_gbk2utf16[0x6a0e] = 0x96a2;
	__map_gbk2utf16[0x6a0f] = 0x96a3;
	__map_gbk2utf16[0x6a10] = 0x96a4;
	__map_gbk2utf16[0x6a11] = 0x96a5;
	__map_gbk2utf16[0x6a12] = 0x96a6;
	__map_gbk2utf16[0x6a13] = 0x96a8;
	__map_gbk2utf16[0x6a14] = 0x96a9;
	__map_gbk2utf16[0x6a15] = 0x96aa;
	__map_gbk2utf16[0x6a16] = 0x96ab;
	__map_gbk2utf16[0x6a17] = 0x96ac;
	__map_gbk2utf16[0x6a18] = 0x96ad;
	__map_gbk2utf16[0x6a19] = 0x96ae;
	__map_gbk2utf16[0x6a1a] = 0x96af;
	__map_gbk2utf16[0x6a1b] = 0x96b1;
	__map_gbk2utf16[0x6a1c] = 0x96b2;
	__map_gbk2utf16[0x6a1d] = 0x96b4;
	__map_gbk2utf16[0x6a1e] = 0x96b5;
	__map_gbk2utf16[0x6a1f] = 0x96b7;
	__map_gbk2utf16[0x6a20] = 0x96b8;
	__map_gbk2utf16[0x6a21] = 0x96ba;
	__map_gbk2utf16[0x6a22] = 0x96bb;
	__map_gbk2utf16[0x6a23] = 0x96bf;
	__map_gbk2utf16[0x6a24] = 0x96c2;
	__map_gbk2utf16[0x6a25] = 0x96c3;
	__map_gbk2utf16[0x6a26] = 0x96c8;
	__map_gbk2utf16[0x6a27] = 0x96ca;
	__map_gbk2utf16[0x6a28] = 0x96cb;
	__map_gbk2utf16[0x6a29] = 0x96d0;
	__map_gbk2utf16[0x6a2a] = 0x96d1;
	__map_gbk2utf16[0x6a2b] = 0x96d3;
	__map_gbk2utf16[0x6a2c] = 0x96d4;
	__map_gbk2utf16[0x6a2d] = 0x96d6;
	__map_gbk2utf16[0x6a2e] = 0x96d7;
	__map_gbk2utf16[0x6a2f] = 0x96d8;
	__map_gbk2utf16[0x6a30] = 0x96d9;
	__map_gbk2utf16[0x6a31] = 0x96da;
	__map_gbk2utf16[0x6a32] = 0x96db;
	__map_gbk2utf16[0x6a33] = 0x96dc;
	__map_gbk2utf16[0x6a34] = 0x96dd;
	__map_gbk2utf16[0x6a35] = 0x96de;
	__map_gbk2utf16[0x6a36] = 0x96df;
	__map_gbk2utf16[0x6a37] = 0x96e1;
	__map_gbk2utf16[0x6a38] = 0x96e2;
	__map_gbk2utf16[0x6a39] = 0x96e3;
	__map_gbk2utf16[0x6a3a] = 0x96e4;
	__map_gbk2utf16[0x6a3b] = 0x96e5;
	__map_gbk2utf16[0x6a3c] = 0x96e6;
	__map_gbk2utf16[0x6a3d] = 0x96e7;
	__map_gbk2utf16[0x6a3e] = 0x96eb;
	__map_gbk2utf16[0x6a40] = 0x96ec;
	__map_gbk2utf16[0x6a41] = 0x96ed;
	__map_gbk2utf16[0x6a42] = 0x96ee;
	__map_gbk2utf16[0x6a43] = 0x96f0;
	__map_gbk2utf16[0x6a44] = 0x96f1;
	__map_gbk2utf16[0x6a45] = 0x96f2;
	__map_gbk2utf16[0x6a46] = 0x96f4;
	__map_gbk2utf16[0x6a47] = 0x96f5;
	__map_gbk2utf16[0x6a48] = 0x96f8;
	__map_gbk2utf16[0x6a49] = 0x96fa;
	__map_gbk2utf16[0x6a4a] = 0x96fb;
	__map_gbk2utf16[0x6a4b] = 0x96fc;
	__map_gbk2utf16[0x6a4c] = 0x96fd;
	__map_gbk2utf16[0x6a4d] = 0x96ff;
	__map_gbk2utf16[0x6a4e] = 0x9702;
	__map_gbk2utf16[0x6a4f] = 0x9703;
	__map_gbk2utf16[0x6a50] = 0x9705;
	__map_gbk2utf16[0x6a51] = 0x970a;
	__map_gbk2utf16[0x6a52] = 0x970b;
	__map_gbk2utf16[0x6a53] = 0x970c;
	__map_gbk2utf16[0x6a54] = 0x9710;
	__map_gbk2utf16[0x6a55] = 0x9711;
	__map_gbk2utf16[0x6a56] = 0x9712;
	__map_gbk2utf16[0x6a57] = 0x9714;
	__map_gbk2utf16[0x6a58] = 0x9715;
	__map_gbk2utf16[0x6a59] = 0x9717;
	__map_gbk2utf16[0x6a5a] = 0x9718;
	__map_gbk2utf16[0x6a5b] = 0x9719;
	__map_gbk2utf16[0x6a5c] = 0x971a;
	__map_gbk2utf16[0x6a5d] = 0x971b;
	__map_gbk2utf16[0x6a5e] = 0x971d;
	__map_gbk2utf16[0x6a5f] = 0x971f;
	__map_gbk2utf16[0x6a60] = 0x9720;
	__map_gbk2utf16[0x6a61] = 0x643f;
	__map_gbk2utf16[0x6a62] = 0x64d8;
	__map_gbk2utf16[0x6a63] = 0x8004;
	__map_gbk2utf16[0x6a64] = 0x6bea;
	__map_gbk2utf16[0x6a65] = 0x6bf3;
	__map_gbk2utf16[0x6a66] = 0x6bfd;
	__map_gbk2utf16[0x6a67] = 0x6bf5;
	__map_gbk2utf16[0x6a68] = 0x6bf9;
	__map_gbk2utf16[0x6a69] = 0x6c05;
	__map_gbk2utf16[0x6a6a] = 0x6c07;
	__map_gbk2utf16[0x6a6b] = 0x6c06;
	__map_gbk2utf16[0x6a6c] = 0x6c0d;
	__map_gbk2utf16[0x6a6d] = 0x6c15;
	__map_gbk2utf16[0x6a6e] = 0x6c18;
	__map_gbk2utf16[0x6a6f] = 0x6c19;
	__map_gbk2utf16[0x6a70] = 0x6c1a;
	__map_gbk2utf16[0x6a71] = 0x6c21;
	__map_gbk2utf16[0x6a72] = 0x6c29;
	__map_gbk2utf16[0x6a73] = 0x6c24;
	__map_gbk2utf16[0x6a74] = 0x6c2a;
	__map_gbk2utf16[0x6a75] = 0x6c32;
	__map_gbk2utf16[0x6a76] = 0x6535;
	__map_gbk2utf16[0x6a77] = 0x6555;
	__map_gbk2utf16[0x6a78] = 0x656b;
	__map_gbk2utf16[0x6a79] = 0x724d;
	__map_gbk2utf16[0x6a7a] = 0x7252;
	__map_gbk2utf16[0x6a7b] = 0x7256;
	__map_gbk2utf16[0x6a7c] = 0x7230;
	__map_gbk2utf16[0x6a7d] = 0x8662;
	__map_gbk2utf16[0x6a7e] = 0x5216;
	__map_gbk2utf16[0x6a7f] = 0x809f;
	__map_gbk2utf16[0x6a80] = 0x809c;
	__map_gbk2utf16[0x6a81] = 0x8093;
	__map_gbk2utf16[0x6a82] = 0x80bc;
	__map_gbk2utf16[0x6a83] = 0x670a;
	__map_gbk2utf16[0x6a84] = 0x80bd;
	__map_gbk2utf16[0x6a85] = 0x80b1;
	__map_gbk2utf16[0x6a86] = 0x80ab;
	__map_gbk2utf16[0x6a87] = 0x80ad;
	__map_gbk2utf16[0x6a88] = 0x80b4;
	__map_gbk2utf16[0x6a89] = 0x80b7;
	__map_gbk2utf16[0x6a8a] = 0x80e7;
	__map_gbk2utf16[0x6a8b] = 0x80e8;
	__map_gbk2utf16[0x6a8c] = 0x80e9;
	__map_gbk2utf16[0x6a8d] = 0x80ea;
	__map_gbk2utf16[0x6a8e] = 0x80db;
	__map_gbk2utf16[0x6a8f] = 0x80c2;
	__map_gbk2utf16[0x6a90] = 0x80c4;
	__map_gbk2utf16[0x6a91] = 0x80d9;
	__map_gbk2utf16[0x6a92] = 0x80cd;
	__map_gbk2utf16[0x6a93] = 0x80d7;
	__map_gbk2utf16[0x6a94] = 0x6710;
	__map_gbk2utf16[0x6a95] = 0x80dd;
	__map_gbk2utf16[0x6a96] = 0x80eb;
	__map_gbk2utf16[0x6a97] = 0x80f1;
	__map_gbk2utf16[0x6a98] = 0x80f4;
	__map_gbk2utf16[0x6a99] = 0x80ed;
	__map_gbk2utf16[0x6a9a] = 0x810d;
	__map_gbk2utf16[0x6a9b] = 0x810e;
	__map_gbk2utf16[0x6a9c] = 0x80f2;
	__map_gbk2utf16[0x6a9d] = 0x80fc;
	__map_gbk2utf16[0x6a9e] = 0x6715;
	__map_gbk2utf16[0x6a9f] = 0x8112;
	__map_gbk2utf16[0x6aa0] = 0x8c5a;
	__map_gbk2utf16[0x6aa1] = 0x8136;
	__map_gbk2utf16[0x6aa2] = 0x811e;
	__map_gbk2utf16[0x6aa3] = 0x812c;
	__map_gbk2utf16[0x6aa4] = 0x8118;
	__map_gbk2utf16[0x6aa5] = 0x8132;
	__map_gbk2utf16[0x6aa6] = 0x8148;
	__map_gbk2utf16[0x6aa7] = 0x814c;
	__map_gbk2utf16[0x6aa8] = 0x8153;
	__map_gbk2utf16[0x6aa9] = 0x8174;
	__map_gbk2utf16[0x6aaa] = 0x8159;
	__map_gbk2utf16[0x6aab] = 0x815a;
	__map_gbk2utf16[0x6aac] = 0x8171;
	__map_gbk2utf16[0x6aad] = 0x8160;
	__map_gbk2utf16[0x6aae] = 0x8169;
	__map_gbk2utf16[0x6aaf] = 0x817c;
	__map_gbk2utf16[0x6ab0] = 0x817d;
	__map_gbk2utf16[0x6ab1] = 0x816d;
	__map_gbk2utf16[0x6ab2] = 0x8167;
	__map_gbk2utf16[0x6ab3] = 0x584d;
	__map_gbk2utf16[0x6ab4] = 0x5ab5;
	__map_gbk2utf16[0x6ab5] = 0x8188;
	__map_gbk2utf16[0x6ab6] = 0x8182;
	__map_gbk2utf16[0x6ab7] = 0x8191;
	__map_gbk2utf16[0x6ab8] = 0x6ed5;
	__map_gbk2utf16[0x6ab9] = 0x81a3;
	__map_gbk2utf16[0x6aba] = 0x81aa;
	__map_gbk2utf16[0x6abb] = 0x81cc;
	__map_gbk2utf16[0x6abc] = 0x6726;
	__map_gbk2utf16[0x6abd] = 0x81ca;
	__map_gbk2utf16[0x6abe] = 0x81bb;
	__map_gbk2utf16[0x6b00] = 0x9721;
	__map_gbk2utf16[0x6b01] = 0x9722;
	__map_gbk2utf16[0x6b02] = 0x9723;
	__map_gbk2utf16[0x6b03] = 0x9724;
	__map_gbk2utf16[0x6b04] = 0x9725;
	__map_gbk2utf16[0x6b05] = 0x9726;
	__map_gbk2utf16[0x6b06] = 0x9727;
	__map_gbk2utf16[0x6b07] = 0x9728;
	__map_gbk2utf16[0x6b08] = 0x9729;
	__map_gbk2utf16[0x6b09] = 0x972b;
	__map_gbk2utf16[0x6b0a] = 0x972c;
	__map_gbk2utf16[0x6b0b] = 0x972e;
	__map_gbk2utf16[0x6b0c] = 0x972f;
	__map_gbk2utf16[0x6b0d] = 0x9731;
	__map_gbk2utf16[0x6b0e] = 0x9733;
	__map_gbk2utf16[0x6b0f] = 0x9734;
	__map_gbk2utf16[0x6b10] = 0x9735;
	__map_gbk2utf16[0x6b11] = 0x9736;
	__map_gbk2utf16[0x6b12] = 0x9737;
	__map_gbk2utf16[0x6b13] = 0x973a;
	__map_gbk2utf16[0x6b14] = 0x973b;
	__map_gbk2utf16[0x6b15] = 0x973c;
	__map_gbk2utf16[0x6b16] = 0x973d;
	__map_gbk2utf16[0x6b17] = 0x973f;
	__map_gbk2utf16[0x6b18] = 0x9740;
	__map_gbk2utf16[0x6b19] = 0x9741;
	__map_gbk2utf16[0x6b1a] = 0x9742;
	__map_gbk2utf16[0x6b1b] = 0x9743;
	__map_gbk2utf16[0x6b1c] = 0x9744;
	__map_gbk2utf16[0x6b1d] = 0x9745;
	__map_gbk2utf16[0x6b1e] = 0x9746;
	__map_gbk2utf16[0x6b1f] = 0x9747;
	__map_gbk2utf16[0x6b20] = 0x9748;
	__map_gbk2utf16[0x6b21] = 0x9749;
	__map_gbk2utf16[0x6b22] = 0x974a;
	__map_gbk2utf16[0x6b23] = 0x974b;
	__map_gbk2utf16[0x6b24] = 0x974c;
	__map_gbk2utf16[0x6b25] = 0x974d;
	__map_gbk2utf16[0x6b26] = 0x974e;
	__map_gbk2utf16[0x6b27] = 0x974f;
	__map_gbk2utf16[0x6b28] = 0x9750;
	__map_gbk2utf16[0x6b29] = 0x9751;
	__map_gbk2utf16[0x6b2a] = 0x9754;
	__map_gbk2utf16[0x6b2b] = 0x9755;
	__map_gbk2utf16[0x6b2c] = 0x9757;
	__map_gbk2utf16[0x6b2d] = 0x9758;
	__map_gbk2utf16[0x6b2e] = 0x975a;
	__map_gbk2utf16[0x6b2f] = 0x975c;
	__map_gbk2utf16[0x6b30] = 0x975d;
	__map_gbk2utf16[0x6b31] = 0x975f;
	__map_gbk2utf16[0x6b32] = 0x9763;
	__map_gbk2utf16[0x6b33] = 0x9764;
	__map_gbk2utf16[0x6b34] = 0x9766;
	__map_gbk2utf16[0x6b35] = 0x9767;
	__map_gbk2utf16[0x6b36] = 0x9768;
	__map_gbk2utf16[0x6b37] = 0x976a;
	__map_gbk2utf16[0x6b38] = 0x976b;
	__map_gbk2utf16[0x6b39] = 0x976c;
	__map_gbk2utf16[0x6b3a] = 0x976d;
	__map_gbk2utf16[0x6b3b] = 0x976e;
	__map_gbk2utf16[0x6b3c] = 0x976f;
	__map_gbk2utf16[0x6b3d] = 0x9770;
	__map_gbk2utf16[0x6b3e] = 0x9771;
	__map_gbk2utf16[0x6b40] = 0x9772;
	__map_gbk2utf16[0x6b41] = 0x9775;
	__map_gbk2utf16[0x6b42] = 0x9777;
	__map_gbk2utf16[0x6b43] = 0x9778;
	__map_gbk2utf16[0x6b44] = 0x9779;
	__map_gbk2utf16[0x6b45] = 0x977a;
	__map_gbk2utf16[0x6b46] = 0x977b;
	__map_gbk2utf16[0x6b47] = 0x977d;
	__map_gbk2utf16[0x6b48] = 0x977e;
	__map_gbk2utf16[0x6b49] = 0x977f;
	__map_gbk2utf16[0x6b4a] = 0x9780;
	__map_gbk2utf16[0x6b4b] = 0x9781;
	__map_gbk2utf16[0x6b4c] = 0x9782;
	__map_gbk2utf16[0x6b4d] = 0x9783;
	__map_gbk2utf16[0x6b4e] = 0x9784;
	__map_gbk2utf16[0x6b4f] = 0x9786;
	__map_gbk2utf16[0x6b50] = 0x9787;
	__map_gbk2utf16[0x6b51] = 0x9788;
	__map_gbk2utf16[0x6b52] = 0x9789;
	__map_gbk2utf16[0x6b53] = 0x978a;
	__map_gbk2utf16[0x6b54] = 0x978c;
	__map_gbk2utf16[0x6b55] = 0x978e;
	__map_gbk2utf16[0x6b56] = 0x978f;
	__map_gbk2utf16[0x6b57] = 0x9790;
	__map_gbk2utf16[0x6b58] = 0x9793;
	__map_gbk2utf16[0x6b59] = 0x9795;
	__map_gbk2utf16[0x6b5a] = 0x9796;
	__map_gbk2utf16[0x6b5b] = 0x9797;
	__map_gbk2utf16[0x6b5c] = 0x9799;
	__map_gbk2utf16[0x6b5d] = 0x979a;
	__map_gbk2utf16[0x6b5e] = 0x979b;
	__map_gbk2utf16[0x6b5f] = 0x979c;
	__map_gbk2utf16[0x6b60] = 0x979d;
	__map_gbk2utf16[0x6b61] = 0x81c1;
	__map_gbk2utf16[0x6b62] = 0x81a6;
	__map_gbk2utf16[0x6b63] = 0x6b24;
	__map_gbk2utf16[0x6b64] = 0x6b37;
	__map_gbk2utf16[0x6b65] = 0x6b39;
	__map_gbk2utf16[0x6b66] = 0x6b43;
	__map_gbk2utf16[0x6b67] = 0x6b46;
	__map_gbk2utf16[0x6b68] = 0x6b59;
	__map_gbk2utf16[0x6b69] = 0x98d1;
	__map_gbk2utf16[0x6b6a] = 0x98d2;
	__map_gbk2utf16[0x6b6b] = 0x98d3;
	__map_gbk2utf16[0x6b6c] = 0x98d5;
	__map_gbk2utf16[0x6b6d] = 0x98d9;
	__map_gbk2utf16[0x6b6e] = 0x98da;
	__map_gbk2utf16[0x6b6f] = 0x6bb3;
	__map_gbk2utf16[0x6b70] = 0x5f40;
	__map_gbk2utf16[0x6b71] = 0x6bc2;
	__map_gbk2utf16[0x6b72] = 0x89f3;
	__map_gbk2utf16[0x6b73] = 0x6590;
	__map_gbk2utf16[0x6b74] = 0x9f51;
	__map_gbk2utf16[0x6b75] = 0x6593;
	__map_gbk2utf16[0x6b76] = 0x65bc;
	__map_gbk2utf16[0x6b77] = 0x65c6;
	__map_gbk2utf16[0x6b78] = 0x65c4;
	__map_gbk2utf16[0x6b79] = 0x65c3;
	__map_gbk2utf16[0x6b7a] = 0x65cc;
	__map_gbk2utf16[0x6b7b] = 0x65ce;
	__map_gbk2utf16[0x6b7c] = 0x65d2;
	__map_gbk2utf16[0x6b7d] = 0x65d6;
	__map_gbk2utf16[0x6b7e] = 0x7080;
	__map_gbk2utf16[0x6b7f] = 0x709c;
	__map_gbk2utf16[0x6b80] = 0x7096;
	__map_gbk2utf16[0x6b81] = 0x709d;
	__map_gbk2utf16[0x6b82] = 0x70bb;
	__map_gbk2utf16[0x6b83] = 0x70c0;
	__map_gbk2utf16[0x6b84] = 0x70b7;
	__map_gbk2utf16[0x6b85] = 0x70ab;
	__map_gbk2utf16[0x6b86] = 0x70b1;
	__map_gbk2utf16[0x6b87] = 0x70e8;
	__map_gbk2utf16[0x6b88] = 0x70ca;
	__map_gbk2utf16[0x6b89] = 0x7110;
	__map_gbk2utf16[0x6b8a] = 0x7113;
	__map_gbk2utf16[0x6b8b] = 0x7116;
	__map_gbk2utf16[0x6b8c] = 0x712f;
	__map_gbk2utf16[0x6b8d] = 0x7131;
	__map_gbk2utf16[0x6b8e] = 0x7173;
	__map_gbk2utf16[0x6b8f] = 0x715c;
	__map_gbk2utf16[0x6b90] = 0x7168;
	__map_gbk2utf16[0x6b91] = 0x7145;
	__map_gbk2utf16[0x6b92] = 0x7172;
	__map_gbk2utf16[0x6b93] = 0x714a;
	__map_gbk2utf16[0x6b94] = 0x7178;
	__map_gbk2utf16[0x6b95] = 0x717a;
	__map_gbk2utf16[0x6b96] = 0x7198;
	__map_gbk2utf16[0x6b97] = 0x71b3;
	__map_gbk2utf16[0x6b98] = 0x71b5;
	__map_gbk2utf16[0x6b99] = 0x71a8;
	__map_gbk2utf16[0x6b9a] = 0x71a0;
	__map_gbk2utf16[0x6b9b] = 0x71e0;
	__map_gbk2utf16[0x6b9c] = 0x71d4;
	__map_gbk2utf16[0x6b9d] = 0x71e7;
	__map_gbk2utf16[0x6b9e] = 0x71f9;
	__map_gbk2utf16[0x6b9f] = 0x721d;
	__map_gbk2utf16[0x6ba0] = 0x7228;
	__map_gbk2utf16[0x6ba1] = 0x706c;
	__map_gbk2utf16[0x6ba2] = 0x7118;
	__map_gbk2utf16[0x6ba3] = 0x7166;
	__map_gbk2utf16[0x6ba4] = 0x71b9;
	__map_gbk2utf16[0x6ba5] = 0x623e;
	__map_gbk2utf16[0x6ba6] = 0x623d;
	__map_gbk2utf16[0x6ba7] = 0x6243;
	__map_gbk2utf16[0x6ba8] = 0x6248;
	__map_gbk2utf16[0x6ba9] = 0x6249;
	__map_gbk2utf16[0x6baa] = 0x793b;
	__map_gbk2utf16[0x6bab] = 0x7940;
	__map_gbk2utf16[0x6bac] = 0x7946;
	__map_gbk2utf16[0x6bad] = 0x7949;
	__map_gbk2utf16[0x6bae] = 0x795b;
	__map_gbk2utf16[0x6baf] = 0x795c;
	__map_gbk2utf16[0x6bb0] = 0x7953;
	__map_gbk2utf16[0x6bb1] = 0x795a;
	__map_gbk2utf16[0x6bb2] = 0x7962;
	__map_gbk2utf16[0x6bb3] = 0x7957;
	__map_gbk2utf16[0x6bb4] = 0x7960;
	__map_gbk2utf16[0x6bb5] = 0x796f;
	__map_gbk2utf16[0x6bb6] = 0x7967;
	__map_gbk2utf16[0x6bb7] = 0x797a;
	__map_gbk2utf16[0x6bb8] = 0x7985;
	__map_gbk2utf16[0x6bb9] = 0x798a;
	__map_gbk2utf16[0x6bba] = 0x799a;
	__map_gbk2utf16[0x6bbb] = 0x79a7;
	__map_gbk2utf16[0x6bbc] = 0x79b3;
	__map_gbk2utf16[0x6bbd] = 0x5fd1;
	__map_gbk2utf16[0x6bbe] = 0x5fd0;
	__map_gbk2utf16[0x6c00] = 0x979e;
	__map_gbk2utf16[0x6c01] = 0x979f;
	__map_gbk2utf16[0x6c02] = 0x97a1;
	__map_gbk2utf16[0x6c03] = 0x97a2;
	__map_gbk2utf16[0x6c04] = 0x97a4;
	__map_gbk2utf16[0x6c05] = 0x97a5;
	__map_gbk2utf16[0x6c06] = 0x97a6;
	__map_gbk2utf16[0x6c07] = 0x97a7;
	__map_gbk2utf16[0x6c08] = 0x97a8;
	__map_gbk2utf16[0x6c09] = 0x97a9;
	__map_gbk2utf16[0x6c0a] = 0x97aa;
	__map_gbk2utf16[0x6c0b] = 0x97ac;
	__map_gbk2utf16[0x6c0c] = 0x97ae;
	__map_gbk2utf16[0x6c0d] = 0x97b0;
	__map_gbk2utf16[0x6c0e] = 0x97b1;
	__map_gbk2utf16[0x6c0f] = 0x97b3;
	__map_gbk2utf16[0x6c10] = 0x97b5;
	__map_gbk2utf16[0x6c11] = 0x97b6;
	__map_gbk2utf16[0x6c12] = 0x97b7;
	__map_gbk2utf16[0x6c13] = 0x97b8;
	__map_gbk2utf16[0x6c14] = 0x97b9;
	__map_gbk2utf16[0x6c15] = 0x97ba;
	__map_gbk2utf16[0x6c16] = 0x97bb;
	__map_gbk2utf16[0x6c17] = 0x97bc;
	__map_gbk2utf16[0x6c18] = 0x97bd;
	__map_gbk2utf16[0x6c19] = 0x97be;
	__map_gbk2utf16[0x6c1a] = 0x97bf;
	__map_gbk2utf16[0x6c1b] = 0x97c0;
	__map_gbk2utf16[0x6c1c] = 0x97c1;
	__map_gbk2utf16[0x6c1d] = 0x97c2;
	__map_gbk2utf16[0x6c1e] = 0x97c3;
	__map_gbk2utf16[0x6c1f] = 0x97c4;
	__map_gbk2utf16[0x6c20] = 0x97c5;
	__map_gbk2utf16[0x6c21] = 0x97c6;
	__map_gbk2utf16[0x6c22] = 0x97c7;
	__map_gbk2utf16[0x6c23] = 0x97c8;
	__map_gbk2utf16[0x6c24] = 0x97c9;
	__map_gbk2utf16[0x6c25] = 0x97ca;
	__map_gbk2utf16[0x6c26] = 0x97cb;
	__map_gbk2utf16[0x6c27] = 0x97cc;
	__map_gbk2utf16[0x6c28] = 0x97cd;
	__map_gbk2utf16[0x6c29] = 0x97ce;
	__map_gbk2utf16[0x6c2a] = 0x97cf;
	__map_gbk2utf16[0x6c2b] = 0x97d0;
	__map_gbk2utf16[0x6c2c] = 0x97d1;
	__map_gbk2utf16[0x6c2d] = 0x97d2;
	__map_gbk2utf16[0x6c2e] = 0x97d3;
	__map_gbk2utf16[0x6c2f] = 0x97d4;
	__map_gbk2utf16[0x6c30] = 0x97d5;
	__map_gbk2utf16[0x6c31] = 0x97d6;
	__map_gbk2utf16[0x6c32] = 0x97d7;
	__map_gbk2utf16[0x6c33] = 0x97d8;
	__map_gbk2utf16[0x6c34] = 0x97d9;
	__map_gbk2utf16[0x6c35] = 0x97da;
	__map_gbk2utf16[0x6c36] = 0x97db;
	__map_gbk2utf16[0x6c37] = 0x97dc;
	__map_gbk2utf16[0x6c38] = 0x97dd;
	__map_gbk2utf16[0x6c39] = 0x97de;
	__map_gbk2utf16[0x6c3a] = 0x97df;
	__map_gbk2utf16[0x6c3b] = 0x97e0;
	__map_gbk2utf16[0x6c3c] = 0x97e1;
	__map_gbk2utf16[0x6c3d] = 0x97e2;
	__map_gbk2utf16[0x6c3e] = 0x97e3;
	__map_gbk2utf16[0x6c40] = 0x97e4;
	__map_gbk2utf16[0x6c41] = 0x97e5;
	__map_gbk2utf16[0x6c42] = 0x97e8;
	__map_gbk2utf16[0x6c43] = 0x97ee;
	__map_gbk2utf16[0x6c44] = 0x97ef;
	__map_gbk2utf16[0x6c45] = 0x97f0;
	__map_gbk2utf16[0x6c46] = 0x97f1;
	__map_gbk2utf16[0x6c47] = 0x97f2;
	__map_gbk2utf16[0x6c48] = 0x97f4;
	__map_gbk2utf16[0x6c49] = 0x97f7;
	__map_gbk2utf16[0x6c4a] = 0x97f8;
	__map_gbk2utf16[0x6c4b] = 0x97f9;
	__map_gbk2utf16[0x6c4c] = 0x97fa;
	__map_gbk2utf16[0x6c4d] = 0x97fb;
	__map_gbk2utf16[0x6c4e] = 0x97fc;
	__map_gbk2utf16[0x6c4f] = 0x97fd;
	__map_gbk2utf16[0x6c50] = 0x97fe;
	__map_gbk2utf16[0x6c51] = 0x97ff;
	__map_gbk2utf16[0x6c52] = 0x9800;
	__map_gbk2utf16[0x6c53] = 0x9801;
	__map_gbk2utf16[0x6c54] = 0x9802;
	__map_gbk2utf16[0x6c55] = 0x9803;
	__map_gbk2utf16[0x6c56] = 0x9804;
	__map_gbk2utf16[0x6c57] = 0x9805;
	__map_gbk2utf16[0x6c58] = 0x9806;
	__map_gbk2utf16[0x6c59] = 0x9807;
	__map_gbk2utf16[0x6c5a] = 0x9808;
	__map_gbk2utf16[0x6c5b] = 0x9809;
	__map_gbk2utf16[0x6c5c] = 0x980a;
	__map_gbk2utf16[0x6c5d] = 0x980b;
	__map_gbk2utf16[0x6c5e] = 0x980c;
	__map_gbk2utf16[0x6c5f] = 0x980d;
	__map_gbk2utf16[0x6c60] = 0x980e;
	__map_gbk2utf16[0x6c61] = 0x603c;
	__map_gbk2utf16[0x6c62] = 0x605d;
	__map_gbk2utf16[0x6c63] = 0x605a;
	__map_gbk2utf16[0x6c64] = 0x6067;
	__map_gbk2utf16[0x6c65] = 0x6041;
	__map_gbk2utf16[0x6c66] = 0x6059;
	__map_gbk2utf16[0x6c67] = 0x6063;
	__map_gbk2utf16[0x6c68] = 0x60ab;
	__map_gbk2utf16[0x6c69] = 0x6106;
	__map_gbk2utf16[0x6c6a] = 0x610d;
	__map_gbk2utf16[0x6c6b] = 0x615d;
	__map_gbk2utf16[0x6c6c] = 0x61a9;
	__map_gbk2utf16[0x6c6d] = 0x619d;
	__map_gbk2utf16[0x6c6e] = 0x61cb;
	__map_gbk2utf16[0x6c6f] = 0x61d1;
	__map_gbk2utf16[0x6c70] = 0x6206;
	__map_gbk2utf16[0x6c71] = 0x8080;
	__map_gbk2utf16[0x6c72] = 0x807f;
	__map_gbk2utf16[0x6c73] = 0x6c93;
	__map_gbk2utf16[0x6c74] = 0x6cf6;
	__map_gbk2utf16[0x6c75] = 0x6dfc;
	__map_gbk2utf16[0x6c76] = 0x77f6;
	__map_gbk2utf16[0x6c77] = 0x77f8;
	__map_gbk2utf16[0x6c78] = 0x7800;
	__map_gbk2utf16[0x6c79] = 0x7809;
	__map_gbk2utf16[0x6c7a] = 0x7817;
	__map_gbk2utf16[0x6c7b] = 0x7818;
	__map_gbk2utf16[0x6c7c] = 0x7811;
	__map_gbk2utf16[0x6c7d] = 0x65ab;
	__map_gbk2utf16[0x6c7e] = 0x782d;
	__map_gbk2utf16[0x6c7f] = 0x781c;
	__map_gbk2utf16[0x6c80] = 0x781d;
	__map_gbk2utf16[0x6c81] = 0x7839;
	__map_gbk2utf16[0x6c82] = 0x783a;
	__map_gbk2utf16[0x6c83] = 0x783b;
	__map_gbk2utf16[0x6c84] = 0x781f;
	__map_gbk2utf16[0x6c85] = 0x783c;
	__map_gbk2utf16[0x6c86] = 0x7825;
	__map_gbk2utf16[0x6c87] = 0x782c;
	__map_gbk2utf16[0x6c88] = 0x7823;
	__map_gbk2utf16[0x6c89] = 0x7829;
	__map_gbk2utf16[0x6c8a] = 0x784e;
	__map_gbk2utf16[0x6c8b] = 0x786d;
	__map_gbk2utf16[0x6c8c] = 0x7856;
	__map_gbk2utf16[0x6c8d] = 0x7857;
	__map_gbk2utf16[0x6c8e] = 0x7826;
	__map_gbk2utf16[0x6c8f] = 0x7850;
	__map_gbk2utf16[0x6c90] = 0x7847;
	__map_gbk2utf16[0x6c91] = 0x784c;
	__map_gbk2utf16[0x6c92] = 0x786a;
	__map_gbk2utf16[0x6c93] = 0x789b;
	__map_gbk2utf16[0x6c94] = 0x7893;
	__map_gbk2utf16[0x6c95] = 0x789a;
	__map_gbk2utf16[0x6c96] = 0x7887;
	__map_gbk2utf16[0x6c97] = 0x789c;
	__map_gbk2utf16[0x6c98] = 0x78a1;
	__map_gbk2utf16[0x6c99] = 0x78a3;
	__map_gbk2utf16[0x6c9a] = 0x78b2;
	__map_gbk2utf16[0x6c9b] = 0x78b9;
	__map_gbk2utf16[0x6c9c] = 0x78a5;
	__map_gbk2utf16[0x6c9d] = 0x78d4;
	__map_gbk2utf16[0x6c9e] = 0x78d9;
	__map_gbk2utf16[0x6c9f] = 0x78c9;
	__map_gbk2utf16[0x6ca0] = 0x78ec;
	__map_gbk2utf16[0x6ca1] = 0x78f2;
	__map_gbk2utf16[0x6ca2] = 0x7905;
	__map_gbk2utf16[0x6ca3] = 0x78f4;
	__map_gbk2utf16[0x6ca4] = 0x7913;
	__map_gbk2utf16[0x6ca5] = 0x7924;
	__map_gbk2utf16[0x6ca6] = 0x791e;
	__map_gbk2utf16[0x6ca7] = 0x7934;
	__map_gbk2utf16[0x6ca8] = 0x9f9b;
	__map_gbk2utf16[0x6ca9] = 0x9ef9;
	__map_gbk2utf16[0x6caa] = 0x9efb;
	__map_gbk2utf16[0x6cab] = 0x9efc;
	__map_gbk2utf16[0x6cac] = 0x76f1;
	__map_gbk2utf16[0x6cad] = 0x7704;
	__map_gbk2utf16[0x6cae] = 0x770d;
	__map_gbk2utf16[0x6caf] = 0x76f9;
	__map_gbk2utf16[0x6cb0] = 0x7707;
	__map_gbk2utf16[0x6cb1] = 0x7708;
	__map_gbk2utf16[0x6cb2] = 0x771a;
	__map_gbk2utf16[0x6cb3] = 0x7722;
	__map_gbk2utf16[0x6cb4] = 0x7719;
	__map_gbk2utf16[0x6cb5] = 0x772d;
	__map_gbk2utf16[0x6cb6] = 0x7726;
	__map_gbk2utf16[0x6cb7] = 0x7735;
	__map_gbk2utf16[0x6cb8] = 0x7738;
	__map_gbk2utf16[0x6cb9] = 0x7750;
	__map_gbk2utf16[0x6cba] = 0x7751;
	__map_gbk2utf16[0x6cbb] = 0x7747;
	__map_gbk2utf16[0x6cbc] = 0x7743;
	__map_gbk2utf16[0x6cbd] = 0x775a;
	__map_gbk2utf16[0x6cbe] = 0x7768;
	__map_gbk2utf16[0x6d00] = 0x980f;
	__map_gbk2utf16[0x6d01] = 0x9810;
	__map_gbk2utf16[0x6d02] = 0x9811;
	__map_gbk2utf16[0x6d03] = 0x9812;
	__map_gbk2utf16[0x6d04] = 0x9813;
	__map_gbk2utf16[0x6d05] = 0x9814;
	__map_gbk2utf16[0x6d06] = 0x9815;
	__map_gbk2utf16[0x6d07] = 0x9816;
	__map_gbk2utf16[0x6d08] = 0x9817;
	__map_gbk2utf16[0x6d09] = 0x9818;
	__map_gbk2utf16[0x6d0a] = 0x9819;
	__map_gbk2utf16[0x6d0b] = 0x981a;
	__map_gbk2utf16[0x6d0c] = 0x981b;
	__map_gbk2utf16[0x6d0d] = 0x981c;
	__map_gbk2utf16[0x6d0e] = 0x981d;
	__map_gbk2utf16[0x6d0f] = 0x981e;
	__map_gbk2utf16[0x6d10] = 0x981f;
	__map_gbk2utf16[0x6d11] = 0x9820;
	__map_gbk2utf16[0x6d12] = 0x9821;
	__map_gbk2utf16[0x6d13] = 0x9822;
	__map_gbk2utf16[0x6d14] = 0x9823;
	__map_gbk2utf16[0x6d15] = 0x9824;
	__map_gbk2utf16[0x6d16] = 0x9825;
	__map_gbk2utf16[0x6d17] = 0x9826;
	__map_gbk2utf16[0x6d18] = 0x9827;
	__map_gbk2utf16[0x6d19] = 0x9828;
	__map_gbk2utf16[0x6d1a] = 0x9829;
	__map_gbk2utf16[0x6d1b] = 0x982a;
	__map_gbk2utf16[0x6d1c] = 0x982b;
	__map_gbk2utf16[0x6d1d] = 0x982c;
	__map_gbk2utf16[0x6d1e] = 0x982d;
	__map_gbk2utf16[0x6d1f] = 0x982e;
	__map_gbk2utf16[0x6d20] = 0x982f;
	__map_gbk2utf16[0x6d21] = 0x9830;
	__map_gbk2utf16[0x6d22] = 0x9831;
	__map_gbk2utf16[0x6d23] = 0x9832;
	__map_gbk2utf16[0x6d24] = 0x9833;
	__map_gbk2utf16[0x6d25] = 0x9834;
	__map_gbk2utf16[0x6d26] = 0x9835;
	__map_gbk2utf16[0x6d27] = 0x9836;
	__map_gbk2utf16[0x6d28] = 0x9837;
	__map_gbk2utf16[0x6d29] = 0x9838;
	__map_gbk2utf16[0x6d2a] = 0x9839;
	__map_gbk2utf16[0x6d2b] = 0x983a;
	__map_gbk2utf16[0x6d2c] = 0x983b;
	__map_gbk2utf16[0x6d2d] = 0x983c;
	__map_gbk2utf16[0x6d2e] = 0x983d;
	__map_gbk2utf16[0x6d2f] = 0x983e;
	__map_gbk2utf16[0x6d30] = 0x983f;
	__map_gbk2utf16[0x6d31] = 0x9840;
	__map_gbk2utf16[0x6d32] = 0x9841;
	__map_gbk2utf16[0x6d33] = 0x9842;
	__map_gbk2utf16[0x6d34] = 0x9843;
	__map_gbk2utf16[0x6d35] = 0x9844;
	__map_gbk2utf16[0x6d36] = 0x9845;
	__map_gbk2utf16[0x6d37] = 0x9846;
	__map_gbk2utf16[0x6d38] = 0x9847;
	__map_gbk2utf16[0x6d39] = 0x9848;
	__map_gbk2utf16[0x6d3a] = 0x9849;
	__map_gbk2utf16[0x6d3b] = 0x984a;
	__map_gbk2utf16[0x6d3c] = 0x984b;
	__map_gbk2utf16[0x6d3d] = 0x984c;
	__map_gbk2utf16[0x6d3e] = 0x984d;
	__map_gbk2utf16[0x6d40] = 0x984e;
	__map_gbk2utf16[0x6d41] = 0x984f;
	__map_gbk2utf16[0x6d42] = 0x9850;
	__map_gbk2utf16[0x6d43] = 0x9851;
	__map_gbk2utf16[0x6d44] = 0x9852;
	__map_gbk2utf16[0x6d45] = 0x9853;
	__map_gbk2utf16[0x6d46] = 0x9854;
	__map_gbk2utf16[0x6d47] = 0x9855;
	__map_gbk2utf16[0x6d48] = 0x9856;
	__map_gbk2utf16[0x6d49] = 0x9857;
	__map_gbk2utf16[0x6d4a] = 0x9858;
	__map_gbk2utf16[0x6d4b] = 0x9859;
	__map_gbk2utf16[0x6d4c] = 0x985a;
	__map_gbk2utf16[0x6d4d] = 0x985b;
	__map_gbk2utf16[0x6d4e] = 0x985c;
	__map_gbk2utf16[0x6d4f] = 0x985d;
	__map_gbk2utf16[0x6d50] = 0x985e;
	__map_gbk2utf16[0x6d51] = 0x985f;
	__map_gbk2utf16[0x6d52] = 0x9860;
	__map_gbk2utf16[0x6d53] = 0x9861;
	__map_gbk2utf16[0x6d54] = 0x9862;
	__map_gbk2utf16[0x6d55] = 0x9863;
	__map_gbk2utf16[0x6d56] = 0x9864;
	__map_gbk2utf16[0x6d57] = 0x9865;
	__map_gbk2utf16[0x6d58] = 0x9866;
	__map_gbk2utf16[0x6d59] = 0x9867;
	__map_gbk2utf16[0x6d5a] = 0x9868;
	__map_gbk2utf16[0x6d5b] = 0x9869;
	__map_gbk2utf16[0x6d5c] = 0x986a;
	__map_gbk2utf16[0x6d5d] = 0x986b;
	__map_gbk2utf16[0x6d5e] = 0x986c;
	__map_gbk2utf16[0x6d5f] = 0x986d;
	__map_gbk2utf16[0x6d60] = 0x986e;
	__map_gbk2utf16[0x6d61] = 0x7762;
	__map_gbk2utf16[0x6d62] = 0x7765;
	__map_gbk2utf16[0x6d63] = 0x777f;
	__map_gbk2utf16[0x6d64] = 0x778d;
	__map_gbk2utf16[0x6d65] = 0x777d;
	__map_gbk2utf16[0x6d66] = 0x7780;
	__map_gbk2utf16[0x6d67] = 0x778c;
	__map_gbk2utf16[0x6d68] = 0x7791;
	__map_gbk2utf16[0x6d69] = 0x779f;
	__map_gbk2utf16[0x6d6a] = 0x77a0;
	__map_gbk2utf16[0x6d6b] = 0x77b0;
	__map_gbk2utf16[0x6d6c] = 0x77b5;
	__map_gbk2utf16[0x6d6d] = 0x77bd;
	__map_gbk2utf16[0x6d6e] = 0x753a;
	__map_gbk2utf16[0x6d6f] = 0x7540;
	__map_gbk2utf16[0x6d70] = 0x754e;
	__map_gbk2utf16[0x6d71] = 0x754b;
	__map_gbk2utf16[0x6d72] = 0x7548;
	__map_gbk2utf16[0x6d73] = 0x755b;
	__map_gbk2utf16[0x6d74] = 0x7572;
	__map_gbk2utf16[0x6d75] = 0x7579;
	__map_gbk2utf16[0x6d76] = 0x7583;
	__map_gbk2utf16[0x6d77] = 0x7f58;
	__map_gbk2utf16[0x6d78] = 0x7f61;
	__map_gbk2utf16[0x6d79] = 0x7f5f;
	__map_gbk2utf16[0x6d7a] = 0x8a48;
	__map_gbk2utf16[0x6d7b] = 0x7f68;
	__map_gbk2utf16[0x6d7c] = 0x7f74;
	__map_gbk2utf16[0x6d7d] = 0x7f71;
	__map_gbk2utf16[0x6d7e] = 0x7f79;
	__map_gbk2utf16[0x6d7f] = 0x7f81;
	__map_gbk2utf16[0x6d80] = 0x7f7e;
	__map_gbk2utf16[0x6d81] = 0x76cd;
	__map_gbk2utf16[0x6d82] = 0x76e5;
	__map_gbk2utf16[0x6d83] = 0x8832;
	__map_gbk2utf16[0x6d84] = 0x9485;
	__map_gbk2utf16[0x6d85] = 0x9486;
	__map_gbk2utf16[0x6d86] = 0x9487;
	__map_gbk2utf16[0x6d87] = 0x948b;
	__map_gbk2utf16[0x6d88] = 0x948a;
	__map_gbk2utf16[0x6d89] = 0x948c;
	__map_gbk2utf16[0x6d8a] = 0x948d;
	__map_gbk2utf16[0x6d8b] = 0x948f;
	__map_gbk2utf16[0x6d8c] = 0x9490;
	__map_gbk2utf16[0x6d8d] = 0x9494;
	__map_gbk2utf16[0x6d8e] = 0x9497;
	__map_gbk2utf16[0x6d8f] = 0x9495;
	__map_gbk2utf16[0x6d90] = 0x949a;
	__map_gbk2utf16[0x6d91] = 0x949b;
	__map_gbk2utf16[0x6d92] = 0x949c;
	__map_gbk2utf16[0x6d93] = 0x94a3;
	__map_gbk2utf16[0x6d94] = 0x94a4;
	__map_gbk2utf16[0x6d95] = 0x94ab;
	__map_gbk2utf16[0x6d96] = 0x94aa;
	__map_gbk2utf16[0x6d97] = 0x94ad;
	__map_gbk2utf16[0x6d98] = 0x94ac;
	__map_gbk2utf16[0x6d99] = 0x94af;
	__map_gbk2utf16[0x6d9a] = 0x94b0;
	__map_gbk2utf16[0x6d9b] = 0x94b2;
	__map_gbk2utf16[0x6d9c] = 0x94b4;
	__map_gbk2utf16[0x6d9d] = 0x94b6;
	__map_gbk2utf16[0x6d9e] = 0x94b7;
	__map_gbk2utf16[0x6d9f] = 0x94b8;
	__map_gbk2utf16[0x6da0] = 0x94b9;
	__map_gbk2utf16[0x6da1] = 0x94ba;
	__map_gbk2utf16[0x6da2] = 0x94bc;
	__map_gbk2utf16[0x6da3] = 0x94bd;
	__map_gbk2utf16[0x6da4] = 0x94bf;
	__map_gbk2utf16[0x6da5] = 0x94c4;
	__map_gbk2utf16[0x6da6] = 0x94c8;
	__map_gbk2utf16[0x6da7] = 0x94c9;
	__map_gbk2utf16[0x6da8] = 0x94ca;
	__map_gbk2utf16[0x6da9] = 0x94cb;
	__map_gbk2utf16[0x6daa] = 0x94cc;
	__map_gbk2utf16[0x6dab] = 0x94cd;
	__map_gbk2utf16[0x6dac] = 0x94ce;
	__map_gbk2utf16[0x6dad] = 0x94d0;
	__map_gbk2utf16[0x6dae] = 0x94d1;
	__map_gbk2utf16[0x6daf] = 0x94d2;
	__map_gbk2utf16[0x6db0] = 0x94d5;
	__map_gbk2utf16[0x6db1] = 0x94d6;
	__map_gbk2utf16[0x6db2] = 0x94d7;
	__map_gbk2utf16[0x6db3] = 0x94d9;
	__map_gbk2utf16[0x6db4] = 0x94d8;
	__map_gbk2utf16[0x6db5] = 0x94db;
	__map_gbk2utf16[0x6db6] = 0x94de;
	__map_gbk2utf16[0x6db7] = 0x94df;
	__map_gbk2utf16[0x6db8] = 0x94e0;
	__map_gbk2utf16[0x6db9] = 0x94e2;
	__map_gbk2utf16[0x6dba] = 0x94e4;
	__map_gbk2utf16[0x6dbb] = 0x94e5;
	__map_gbk2utf16[0x6dbc] = 0x94e7;
	__map_gbk2utf16[0x6dbd] = 0x94e8;
	__map_gbk2utf16[0x6dbe] = 0x94ea;
	__map_gbk2utf16[0x6e00] = 0x986f;
	__map_gbk2utf16[0x6e01] = 0x9870;
	__map_gbk2utf16[0x6e02] = 0x9871;
	__map_gbk2utf16[0x6e03] = 0x9872;
	__map_gbk2utf16[0x6e04] = 0x9873;
	__map_gbk2utf16[0x6e05] = 0x9874;
	__map_gbk2utf16[0x6e06] = 0x988b;
	__map_gbk2utf16[0x6e07] = 0x988e;
	__map_gbk2utf16[0x6e08] = 0x9892;
	__map_gbk2utf16[0x6e09] = 0x9895;
	__map_gbk2utf16[0x6e0a] = 0x9899;
	__map_gbk2utf16[0x6e0b] = 0x98a3;
	__map_gbk2utf16[0x6e0c] = 0x98a8;
	__map_gbk2utf16[0x6e0d] = 0x98a9;
	__map_gbk2utf16[0x6e0e] = 0x98aa;
	__map_gbk2utf16[0x6e0f] = 0x98ab;
	__map_gbk2utf16[0x6e10] = 0x98ac;
	__map_gbk2utf16[0x6e11] = 0x98ad;
	__map_gbk2utf16[0x6e12] = 0x98ae;
	__map_gbk2utf16[0x6e13] = 0x98af;
	__map_gbk2utf16[0x6e14] = 0x98b0;
	__map_gbk2utf16[0x6e15] = 0x98b1;
	__map_gbk2utf16[0x6e16] = 0x98b2;
	__map_gbk2utf16[0x6e17] = 0x98b3;
	__map_gbk2utf16[0x6e18] = 0x98b4;
	__map_gbk2utf16[0x6e19] = 0x98b5;
	__map_gbk2utf16[0x6e1a] = 0x98b6;
	__map_gbk2utf16[0x6e1b] = 0x98b7;
	__map_gbk2utf16[0x6e1c] = 0x98b8;
	__map_gbk2utf16[0x6e1d] = 0x98b9;
	__map_gbk2utf16[0x6e1e] = 0x98ba;
	__map_gbk2utf16[0x6e1f] = 0x98bb;
	__map_gbk2utf16[0x6e20] = 0x98bc;
	__map_gbk2utf16[0x6e21] = 0x98bd;
	__map_gbk2utf16[0x6e22] = 0x98be;
	__map_gbk2utf16[0x6e23] = 0x98bf;
	__map_gbk2utf16[0x6e24] = 0x98c0;
	__map_gbk2utf16[0x6e25] = 0x98c1;
	__map_gbk2utf16[0x6e26] = 0x98c2;
	__map_gbk2utf16[0x6e27] = 0x98c3;
	__map_gbk2utf16[0x6e28] = 0x98c4;
	__map_gbk2utf16[0x6e29] = 0x98c5;
	__map_gbk2utf16[0x6e2a] = 0x98c6;
	__map_gbk2utf16[0x6e2b] = 0x98c7;
	__map_gbk2utf16[0x6e2c] = 0x98c8;
	__map_gbk2utf16[0x6e2d] = 0x98c9;
	__map_gbk2utf16[0x6e2e] = 0x98ca;
	__map_gbk2utf16[0x6e2f] = 0x98cb;
	__map_gbk2utf16[0x6e30] = 0x98cc;
	__map_gbk2utf16[0x6e31] = 0x98cd;
	__map_gbk2utf16[0x6e32] = 0x98cf;
	__map_gbk2utf16[0x6e33] = 0x98d0;
	__map_gbk2utf16[0x6e34] = 0x98d4;
	__map_gbk2utf16[0x6e35] = 0x98d6;
	__map_gbk2utf16[0x6e36] = 0x98d7;
	__map_gbk2utf16[0x6e37] = 0x98db;
	__map_gbk2utf16[0x6e38] = 0x98dc;
	__map_gbk2utf16[0x6e39] = 0x98dd;
	__map_gbk2utf16[0x6e3a] = 0x98e0;
	__map_gbk2utf16[0x6e3b] = 0x98e1;
	__map_gbk2utf16[0x6e3c] = 0x98e2;
	__map_gbk2utf16[0x6e3d] = 0x98e3;
	__map_gbk2utf16[0x6e3e] = 0x98e4;
	__map_gbk2utf16[0x6e40] = 0x98e5;
	__map_gbk2utf16[0x6e41] = 0x98e6;
	__map_gbk2utf16[0x6e42] = 0x98e9;
	__map_gbk2utf16[0x6e43] = 0x98ea;
	__map_gbk2utf16[0x6e44] = 0x98eb;
	__map_gbk2utf16[0x6e45] = 0x98ec;
	__map_gbk2utf16[0x6e46] = 0x98ed;
	__map_gbk2utf16[0x6e47] = 0x98ee;
	__map_gbk2utf16[0x6e48] = 0x98ef;
	__map_gbk2utf16[0x6e49] = 0x98f0;
	__map_gbk2utf16[0x6e4a] = 0x98f1;
	__map_gbk2utf16[0x6e4b] = 0x98f2;
	__map_gbk2utf16[0x6e4c] = 0x98f3;
	__map_gbk2utf16[0x6e4d] = 0x98f4;
	__map_gbk2utf16[0x6e4e] = 0x98f5;
	__map_gbk2utf16[0x6e4f] = 0x98f6;
	__map_gbk2utf16[0x6e50] = 0x98f7;
	__map_gbk2utf16[0x6e51] = 0x98f8;
	__map_gbk2utf16[0x6e52] = 0x98f9;
	__map_gbk2utf16[0x6e53] = 0x98fa;
	__map_gbk2utf16[0x6e54] = 0x98fb;
	__map_gbk2utf16[0x6e55] = 0x98fc;
	__map_gbk2utf16[0x6e56] = 0x98fd;
	__map_gbk2utf16[0x6e57] = 0x98fe;
	__map_gbk2utf16[0x6e58] = 0x98ff;
	__map_gbk2utf16[0x6e59] = 0x9900;
	__map_gbk2utf16[0x6e5a] = 0x9901;
	__map_gbk2utf16[0x6e5b] = 0x9902;
	__map_gbk2utf16[0x6e5c] = 0x9903;
	__map_gbk2utf16[0x6e5d] = 0x9904;
	__map_gbk2utf16[0x6e5e] = 0x9905;
	__map_gbk2utf16[0x6e5f] = 0x9906;
	__map_gbk2utf16[0x6e60] = 0x9907;
	__map_gbk2utf16[0x6e61] = 0x94e9;
	__map_gbk2utf16[0x6e62] = 0x94eb;
	__map_gbk2utf16[0x6e63] = 0x94ee;
	__map_gbk2utf16[0x6e64] = 0x94ef;
	__map_gbk2utf16[0x6e65] = 0x94f3;
	__map_gbk2utf16[0x6e66] = 0x94f4;
	__map_gbk2utf16[0x6e67] = 0x94f5;
	__map_gbk2utf16[0x6e68] = 0x94f7;
	__map_gbk2utf16[0x6e69] = 0x94f9;
	__map_gbk2utf16[0x6e6a] = 0x94fc;
	__map_gbk2utf16[0x6e6b] = 0x94fd;
	__map_gbk2utf16[0x6e6c] = 0x94ff;
	__map_gbk2utf16[0x6e6d] = 0x9503;
	__map_gbk2utf16[0x6e6e] = 0x9502;
	__map_gbk2utf16[0x6e6f] = 0x9506;
	__map_gbk2utf16[0x6e70] = 0x9507;
	__map_gbk2utf16[0x6e71] = 0x9509;
	__map_gbk2utf16[0x6e72] = 0x950a;
	__map_gbk2utf16[0x6e73] = 0x950d;
	__map_gbk2utf16[0x6e74] = 0x950e;
	__map_gbk2utf16[0x6e75] = 0x950f;
	__map_gbk2utf16[0x6e76] = 0x9512;
	__map_gbk2utf16[0x6e77] = 0x9513;
	__map_gbk2utf16[0x6e78] = 0x9514;
	__map_gbk2utf16[0x6e79] = 0x9515;
	__map_gbk2utf16[0x6e7a] = 0x9516;
	__map_gbk2utf16[0x6e7b] = 0x9518;
	__map_gbk2utf16[0x6e7c] = 0x951b;
	__map_gbk2utf16[0x6e7d] = 0x951d;
	__map_gbk2utf16[0x6e7e] = 0x951e;
	__map_gbk2utf16[0x6e7f] = 0x951f;
	__map_gbk2utf16[0x6e80] = 0x9522;
	__map_gbk2utf16[0x6e81] = 0x952a;
	__map_gbk2utf16[0x6e82] = 0x952b;
	__map_gbk2utf16[0x6e83] = 0x9529;
	__map_gbk2utf16[0x6e84] = 0x952c;
	__map_gbk2utf16[0x6e85] = 0x9531;
	__map_gbk2utf16[0x6e86] = 0x9532;
	__map_gbk2utf16[0x6e87] = 0x9534;
	__map_gbk2utf16[0x6e88] = 0x9536;
	__map_gbk2utf16[0x6e89] = 0x9537;
	__map_gbk2utf16[0x6e8a] = 0x9538;
	__map_gbk2utf16[0x6e8b] = 0x953c;
	__map_gbk2utf16[0x6e8c] = 0x953e;
	__map_gbk2utf16[0x6e8d] = 0x953f;
	__map_gbk2utf16[0x6e8e] = 0x9542;
	__map_gbk2utf16[0x6e8f] = 0x9535;
	__map_gbk2utf16[0x6e90] = 0x9544;
	__map_gbk2utf16[0x6e91] = 0x9545;
	__map_gbk2utf16[0x6e92] = 0x9546;
	__map_gbk2utf16[0x6e93] = 0x9549;
	__map_gbk2utf16[0x6e94] = 0x954c;
	__map_gbk2utf16[0x6e95] = 0x954e;
	__map_gbk2utf16[0x6e96] = 0x954f;
	__map_gbk2utf16[0x6e97] = 0x9552;
	__map_gbk2utf16[0x6e98] = 0x9553;
	__map_gbk2utf16[0x6e99] = 0x9554;
	__map_gbk2utf16[0x6e9a] = 0x9556;
	__map_gbk2utf16[0x6e9b] = 0x9557;
	__map_gbk2utf16[0x6e9c] = 0x9558;
	__map_gbk2utf16[0x6e9d] = 0x9559;
	__map_gbk2utf16[0x6e9e] = 0x955b;
	__map_gbk2utf16[0x6e9f] = 0x955e;
	__map_gbk2utf16[0x6ea0] = 0x955f;
	__map_gbk2utf16[0x6ea1] = 0x955d;
	__map_gbk2utf16[0x6ea2] = 0x9561;
	__map_gbk2utf16[0x6ea3] = 0x9562;
	__map_gbk2utf16[0x6ea4] = 0x9564;
	__map_gbk2utf16[0x6ea5] = 0x9565;
	__map_gbk2utf16[0x6ea6] = 0x9566;
	__map_gbk2utf16[0x6ea7] = 0x9567;
	__map_gbk2utf16[0x6ea8] = 0x9568;
	__map_gbk2utf16[0x6ea9] = 0x9569;
	__map_gbk2utf16[0x6eaa] = 0x956a;
	__map_gbk2utf16[0x6eab] = 0x956b;
	__map_gbk2utf16[0x6eac] = 0x956c;
	__map_gbk2utf16[0x6ead] = 0x956f;
	__map_gbk2utf16[0x6eae] = 0x9571;
	__map_gbk2utf16[0x6eaf] = 0x9572;
	__map_gbk2utf16[0x6eb0] = 0x9573;
	__map_gbk2utf16[0x6eb1] = 0x953a;
	__map_gbk2utf16[0x6eb2] = 0x77e7;
	__map_gbk2utf16[0x6eb3] = 0x77ec;
	__map_gbk2utf16[0x6eb4] = 0x96c9;
	__map_gbk2utf16[0x6eb5] = 0x79d5;
	__map_gbk2utf16[0x6eb6] = 0x79ed;
	__map_gbk2utf16[0x6eb7] = 0x79e3;
	__map_gbk2utf16[0x6eb8] = 0x79eb;
	__map_gbk2utf16[0x6eb9] = 0x7a06;
	__map_gbk2utf16[0x6eba] = 0x5d47;
	__map_gbk2utf16[0x6ebb] = 0x7a03;
	__map_gbk2utf16[0x6ebc] = 0x7a02;
	__map_gbk2utf16[0x6ebd] = 0x7a1e;
	__map_gbk2utf16[0x6ebe] = 0x7a14;
	__map_gbk2utf16[0x6f00] = 0x9908;
	__map_gbk2utf16[0x6f01] = 0x9909;
	__map_gbk2utf16[0x6f02] = 0x990a;
	__map_gbk2utf16[0x6f03] = 0x990b;
	__map_gbk2utf16[0x6f04] = 0x990c;
	__map_gbk2utf16[0x6f05] = 0x990e;
	__map_gbk2utf16[0x6f06] = 0x990f;
	__map_gbk2utf16[0x6f07] = 0x9911;
	__map_gbk2utf16[0x6f08] = 0x9912;
	__map_gbk2utf16[0x6f09] = 0x9913;
	__map_gbk2utf16[0x6f0a] = 0x9914;
	__map_gbk2utf16[0x6f0b] = 0x9915;
	__map_gbk2utf16[0x6f0c] = 0x9916;
	__map_gbk2utf16[0x6f0d] = 0x9917;
	__map_gbk2utf16[0x6f0e] = 0x9918;
	__map_gbk2utf16[0x6f0f] = 0x9919;
	__map_gbk2utf16[0x6f10] = 0x991a;
	__map_gbk2utf16[0x6f11] = 0x991b;
	__map_gbk2utf16[0x6f12] = 0x991c;
	__map_gbk2utf16[0x6f13] = 0x991d;
	__map_gbk2utf16[0x6f14] = 0x991e;
	__map_gbk2utf16[0x6f15] = 0x991f;
	__map_gbk2utf16[0x6f16] = 0x9920;
	__map_gbk2utf16[0x6f17] = 0x9921;
	__map_gbk2utf16[0x6f18] = 0x9922;
	__map_gbk2utf16[0x6f19] = 0x9923;
	__map_gbk2utf16[0x6f1a] = 0x9924;
	__map_gbk2utf16[0x6f1b] = 0x9925;
	__map_gbk2utf16[0x6f1c] = 0x9926;
	__map_gbk2utf16[0x6f1d] = 0x9927;
	__map_gbk2utf16[0x6f1e] = 0x9928;
	__map_gbk2utf16[0x6f1f] = 0x9929;
	__map_gbk2utf16[0x6f20] = 0x992a;
	__map_gbk2utf16[0x6f21] = 0x992b;
	__map_gbk2utf16[0x6f22] = 0x992c;
	__map_gbk2utf16[0x6f23] = 0x992d;
	__map_gbk2utf16[0x6f24] = 0x992f;
	__map_gbk2utf16[0x6f25] = 0x9930;
	__map_gbk2utf16[0x6f26] = 0x9931;
	__map_gbk2utf16[0x6f27] = 0x9932;
	__map_gbk2utf16[0x6f28] = 0x9933;
	__map_gbk2utf16[0x6f29] = 0x9934;
	__map_gbk2utf16[0x6f2a] = 0x9935;
	__map_gbk2utf16[0x6f2b] = 0x9936;
	__map_gbk2utf16[0x6f2c] = 0x9937;
	__map_gbk2utf16[0x6f2d] = 0x9938;
	__map_gbk2utf16[0x6f2e] = 0x9939;
	__map_gbk2utf16[0x6f2f] = 0x993a;
	__map_gbk2utf16[0x6f30] = 0x993b;
	__map_gbk2utf16[0x6f31] = 0x993c;
	__map_gbk2utf16[0x6f32] = 0x993d;
	__map_gbk2utf16[0x6f33] = 0x993e;
	__map_gbk2utf16[0x6f34] = 0x993f;
	__map_gbk2utf16[0x6f35] = 0x9940;
	__map_gbk2utf16[0x6f36] = 0x9941;
	__map_gbk2utf16[0x6f37] = 0x9942;
	__map_gbk2utf16[0x6f38] = 0x9943;
	__map_gbk2utf16[0x6f39] = 0x9944;
	__map_gbk2utf16[0x6f3a] = 0x9945;
	__map_gbk2utf16[0x6f3b] = 0x9946;
	__map_gbk2utf16[0x6f3c] = 0x9947;
	__map_gbk2utf16[0x6f3d] = 0x9948;
	__map_gbk2utf16[0x6f3e] = 0x9949;
	__map_gbk2utf16[0x6f40] = 0x994a;
	__map_gbk2utf16[0x6f41] = 0x994b;
	__map_gbk2utf16[0x6f42] = 0x994c;
	__map_gbk2utf16[0x6f43] = 0x994d;
	__map_gbk2utf16[0x6f44] = 0x994e;
	__map_gbk2utf16[0x6f45] = 0x994f;
	__map_gbk2utf16[0x6f46] = 0x9950;
	__map_gbk2utf16[0x6f47] = 0x9951;
	__map_gbk2utf16[0x6f48] = 0x9952;
	__map_gbk2utf16[0x6f49] = 0x9953;
	__map_gbk2utf16[0x6f4a] = 0x9956;
	__map_gbk2utf16[0x6f4b] = 0x9957;
	__map_gbk2utf16[0x6f4c] = 0x9958;
	__map_gbk2utf16[0x6f4d] = 0x9959;
	__map_gbk2utf16[0x6f4e] = 0x995a;
	__map_gbk2utf16[0x6f4f] = 0x995b;
	__map_gbk2utf16[0x6f50] = 0x995c;
	__map_gbk2utf16[0x6f51] = 0x995d;
	__map_gbk2utf16[0x6f52] = 0x995e;
	__map_gbk2utf16[0x6f53] = 0x995f;
	__map_gbk2utf16[0x6f54] = 0x9960;
	__map_gbk2utf16[0x6f55] = 0x9961;
	__map_gbk2utf16[0x6f56] = 0x9962;
	__map_gbk2utf16[0x6f57] = 0x9964;
	__map_gbk2utf16[0x6f58] = 0x9966;
	__map_gbk2utf16[0x6f59] = 0x9973;
	__map_gbk2utf16[0x6f5a] = 0x9978;
	__map_gbk2utf16[0x6f5b] = 0x9979;
	__map_gbk2utf16[0x6f5c] = 0x997b;
	__map_gbk2utf16[0x6f5d] = 0x997e;
	__map_gbk2utf16[0x6f5e] = 0x9982;
	__map_gbk2utf16[0x6f5f] = 0x9983;
	__map_gbk2utf16[0x6f60] = 0x9989;
	__map_gbk2utf16[0x6f61] = 0x7a39;
	__map_gbk2utf16[0x6f62] = 0x7a37;
	__map_gbk2utf16[0x6f63] = 0x7a51;
	__map_gbk2utf16[0x6f64] = 0x9ecf;
	__map_gbk2utf16[0x6f65] = 0x99a5;
	__map_gbk2utf16[0x6f66] = 0x7a70;
	__map_gbk2utf16[0x6f67] = 0x7688;
	__map_gbk2utf16[0x6f68] = 0x768e;
	__map_gbk2utf16[0x6f69] = 0x7693;
	__map_gbk2utf16[0x6f6a] = 0x7699;
	__map_gbk2utf16[0x6f6b] = 0x76a4;
	__map_gbk2utf16[0x6f6c] = 0x74de;
	__map_gbk2utf16[0x6f6d] = 0x74e0;
	__map_gbk2utf16[0x6f6e] = 0x752c;
	__map_gbk2utf16[0x6f6f] = 0x9e20;
	__map_gbk2utf16[0x6f70] = 0x9e22;
	__map_gbk2utf16[0x6f71] = 0x9e28;
	__map_gbk2utf16[0x6f72] = 0x9e29;
	__map_gbk2utf16[0x6f73] = 0x9e2a;
	__map_gbk2utf16[0x6f74] = 0x9e2b;
	__map_gbk2utf16[0x6f75] = 0x9e2c;
	__map_gbk2utf16[0x6f76] = 0x9e32;
	__map_gbk2utf16[0x6f77] = 0x9e31;
	__map_gbk2utf16[0x6f78] = 0x9e36;
	__map_gbk2utf16[0x6f79] = 0x9e38;
	__map_gbk2utf16[0x6f7a] = 0x9e37;
	__map_gbk2utf16[0x6f7b] = 0x9e39;
	__map_gbk2utf16[0x6f7c] = 0x9e3a;
	__map_gbk2utf16[0x6f7d] = 0x9e3e;
	__map_gbk2utf16[0x6f7e] = 0x9e41;
	__map_gbk2utf16[0x6f7f] = 0x9e42;
	__map_gbk2utf16[0x6f80] = 0x9e44;
	__map_gbk2utf16[0x6f81] = 0x9e46;
	__map_gbk2utf16[0x6f82] = 0x9e47;
	__map_gbk2utf16[0x6f83] = 0x9e48;
	__map_gbk2utf16[0x6f84] = 0x9e49;
	__map_gbk2utf16[0x6f85] = 0x9e4b;
	__map_gbk2utf16[0x6f86] = 0x9e4c;
	__map_gbk2utf16[0x6f87] = 0x9e4e;
	__map_gbk2utf16[0x6f88] = 0x9e51;
	__map_gbk2utf16[0x6f89] = 0x9e55;
	__map_gbk2utf16[0x6f8a] = 0x9e57;
	__map_gbk2utf16[0x6f8b] = 0x9e5a;
	__map_gbk2utf16[0x6f8c] = 0x9e5b;
	__map_gbk2utf16[0x6f8d] = 0x9e5c;
	__map_gbk2utf16[0x6f8e] = 0x9e5e;
	__map_gbk2utf16[0x6f8f] = 0x9e63;
	__map_gbk2utf16[0x6f90] = 0x9e66;
	__map_gbk2utf16[0x6f91] = 0x9e67;
	__map_gbk2utf16[0x6f92] = 0x9e68;
	__map_gbk2utf16[0x6f93] = 0x9e69;
	__map_gbk2utf16[0x6f94] = 0x9e6a;
	__map_gbk2utf16[0x6f95] = 0x9e6b;
	__map_gbk2utf16[0x6f96] = 0x9e6c;
	__map_gbk2utf16[0x6f97] = 0x9e71;
	__map_gbk2utf16[0x6f98] = 0x9e6d;
	__map_gbk2utf16[0x6f99] = 0x9e73;
	__map_gbk2utf16[0x6f9a] = 0x7592;
	__map_gbk2utf16[0x6f9b] = 0x7594;
	__map_gbk2utf16[0x6f9c] = 0x7596;
	__map_gbk2utf16[0x6f9d] = 0x75a0;
	__map_gbk2utf16[0x6f9e] = 0x759d;
	__map_gbk2utf16[0x6f9f] = 0x75ac;
	__map_gbk2utf16[0x6fa0] = 0x75a3;
	__map_gbk2utf16[0x6fa1] = 0x75b3;
	__map_gbk2utf16[0x6fa2] = 0x75b4;
	__map_gbk2utf16[0x6fa3] = 0x75b8;
	__map_gbk2utf16[0x6fa4] = 0x75c4;
	__map_gbk2utf16[0x6fa5] = 0x75b1;
	__map_gbk2utf16[0x6fa6] = 0x75b0;
	__map_gbk2utf16[0x6fa7] = 0x75c3;
	__map_gbk2utf16[0x6fa8] = 0x75c2;
	__map_gbk2utf16[0x6fa9] = 0x75d6;
	__map_gbk2utf16[0x6faa] = 0x75cd;
	__map_gbk2utf16[0x6fab] = 0x75e3;
	__map_gbk2utf16[0x6fac] = 0x75e8;
	__map_gbk2utf16[0x6fad] = 0x75e6;
	__map_gbk2utf16[0x6fae] = 0x75e4;
	__map_gbk2utf16[0x6faf] = 0x75eb;
	__map_gbk2utf16[0x6fb0] = 0x75e7;
	__map_gbk2utf16[0x6fb1] = 0x7603;
	__map_gbk2utf16[0x6fb2] = 0x75f1;
	__map_gbk2utf16[0x6fb3] = 0x75fc;
	__map_gbk2utf16[0x6fb4] = 0x75ff;
	__map_gbk2utf16[0x6fb5] = 0x7610;
	__map_gbk2utf16[0x6fb6] = 0x7600;
	__map_gbk2utf16[0x6fb7] = 0x7605;
	__map_gbk2utf16[0x6fb8] = 0x760c;
	__map_gbk2utf16[0x6fb9] = 0x7617;
	__map_gbk2utf16[0x6fba] = 0x760a;
	__map_gbk2utf16[0x6fbb] = 0x7625;
	__map_gbk2utf16[0x6fbc] = 0x7618;
	__map_gbk2utf16[0x6fbd] = 0x7615;
	__map_gbk2utf16[0x6fbe] = 0x7619;
	__map_gbk2utf16[0x7000] = 0x998c;
	__map_gbk2utf16[0x7001] = 0x998e;
	__map_gbk2utf16[0x7002] = 0x999a;
	__map_gbk2utf16[0x7003] = 0x999b;
	__map_gbk2utf16[0x7004] = 0x999c;
	__map_gbk2utf16[0x7005] = 0x999d;
	__map_gbk2utf16[0x7006] = 0x999e;
	__map_gbk2utf16[0x7007] = 0x999f;
	__map_gbk2utf16[0x7008] = 0x99a0;
	__map_gbk2utf16[0x7009] = 0x99a1;
	__map_gbk2utf16[0x700a] = 0x99a2;
	__map_gbk2utf16[0x700b] = 0x99a3;
	__map_gbk2utf16[0x700c] = 0x99a4;
	__map_gbk2utf16[0x700d] = 0x99a6;
	__map_gbk2utf16[0x700e] = 0x99a7;
	__map_gbk2utf16[0x700f] = 0x99a9;
	__map_gbk2utf16[0x7010] = 0x99aa;
	__map_gbk2utf16[0x7011] = 0x99ab;
	__map_gbk2utf16[0x7012] = 0x99ac;
	__map_gbk2utf16[0x7013] = 0x99ad;
	__map_gbk2utf16[0x7014] = 0x99ae;
	__map_gbk2utf16[0x7015] = 0x99af;
	__map_gbk2utf16[0x7016] = 0x99b0;
	__map_gbk2utf16[0x7017] = 0x99b1;
	__map_gbk2utf16[0x7018] = 0x99b2;
	__map_gbk2utf16[0x7019] = 0x99b3;
	__map_gbk2utf16[0x701a] = 0x99b4;
	__map_gbk2utf16[0x701b] = 0x99b5;
	__map_gbk2utf16[0x701c] = 0x99b6;
	__map_gbk2utf16[0x701d] = 0x99b7;
	__map_gbk2utf16[0x701e] = 0x99b8;
	__map_gbk2utf16[0x701f] = 0x99b9;
	__map_gbk2utf16[0x7020] = 0x99ba;
	__map_gbk2utf16[0x7021] = 0x99bb;
	__map_gbk2utf16[0x7022] = 0x99bc;
	__map_gbk2utf16[0x7023] = 0x99bd;
	__map_gbk2utf16[0x7024] = 0x99be;
	__map_gbk2utf16[0x7025] = 0x99bf;
	__map_gbk2utf16[0x7026] = 0x99c0;
	__map_gbk2utf16[0x7027] = 0x99c1;
	__map_gbk2utf16[0x7028] = 0x99c2;
	__map_gbk2utf16[0x7029] = 0x99c3;
	__map_gbk2utf16[0x702a] = 0x99c4;
	__map_gbk2utf16[0x702b] = 0x99c5;
	__map_gbk2utf16[0x702c] = 0x99c6;
	__map_gbk2utf16[0x702d] = 0x99c7;
	__map_gbk2utf16[0x702e] = 0x99c8;
	__map_gbk2utf16[0x702f] = 0x99c9;
	__map_gbk2utf16[0x7030] = 0x99ca;
	__map_gbk2utf16[0x7031] = 0x99cb;
	__map_gbk2utf16[0x7032] = 0x99cc;
	__map_gbk2utf16[0x7033] = 0x99cd;
	__map_gbk2utf16[0x7034] = 0x99ce;
	__map_gbk2utf16[0x7035] = 0x99cf;
	__map_gbk2utf16[0x7036] = 0x99d0;
	__map_gbk2utf16[0x7037] = 0x99d1;
	__map_gbk2utf16[0x7038] = 0x99d2;
	__map_gbk2utf16[0x7039] = 0x99d3;
	__map_gbk2utf16[0x703a] = 0x99d4;
	__map_gbk2utf16[0x703b] = 0x99d5;
	__map_gbk2utf16[0x703c] = 0x99d6;
	__map_gbk2utf16[0x703d] = 0x99d7;
	__map_gbk2utf16[0x703e] = 0x99d8;
	__map_gbk2utf16[0x7040] = 0x99d9;
	__map_gbk2utf16[0x7041] = 0x99da;
	__map_gbk2utf16[0x7042] = 0x99db;
	__map_gbk2utf16[0x7043] = 0x99dc;
	__map_gbk2utf16[0x7044] = 0x99dd;
	__map_gbk2utf16[0x7045] = 0x99de;
	__map_gbk2utf16[0x7046] = 0x99df;
	__map_gbk2utf16[0x7047] = 0x99e0;
	__map_gbk2utf16[0x7048] = 0x99e1;
	__map_gbk2utf16[0x7049] = 0x99e2;
	__map_gbk2utf16[0x704a] = 0x99e3;
	__map_gbk2utf16[0x704b] = 0x99e4;
	__map_gbk2utf16[0x704c] = 0x99e5;
	__map_gbk2utf16[0x704d] = 0x99e6;
	__map_gbk2utf16[0x704e] = 0x99e7;
	__map_gbk2utf16[0x704f] = 0x99e8;
	__map_gbk2utf16[0x7050] = 0x99e9;
	__map_gbk2utf16[0x7051] = 0x99ea;
	__map_gbk2utf16[0x7052] = 0x99eb;
	__map_gbk2utf16[0x7053] = 0x99ec;
	__map_gbk2utf16[0x7054] = 0x99ed;
	__map_gbk2utf16[0x7055] = 0x99ee;
	__map_gbk2utf16[0x7056] = 0x99ef;
	__map_gbk2utf16[0x7057] = 0x99f0;
	__map_gbk2utf16[0x7058] = 0x99f1;
	__map_gbk2utf16[0x7059] = 0x99f2;
	__map_gbk2utf16[0x705a] = 0x99f3;
	__map_gbk2utf16[0x705b] = 0x99f4;
	__map_gbk2utf16[0x705c] = 0x99f5;
	__map_gbk2utf16[0x705d] = 0x99f6;
	__map_gbk2utf16[0x705e] = 0x99f7;
	__map_gbk2utf16[0x705f] = 0x99f8;
	__map_gbk2utf16[0x7060] = 0x99f9;
	__map_gbk2utf16[0x7061] = 0x761b;
	__map_gbk2utf16[0x7062] = 0x763c;
	__map_gbk2utf16[0x7063] = 0x7622;
	__map_gbk2utf16[0x7064] = 0x7620;
	__map_gbk2utf16[0x7065] = 0x7640;
	__map_gbk2utf16[0x7066] = 0x762d;
	__map_gbk2utf16[0x7067] = 0x7630;
	__map_gbk2utf16[0x7068] = 0x763f;
	__map_gbk2utf16[0x7069] = 0x7635;
	__map_gbk2utf16[0x706a] = 0x7643;
	__map_gbk2utf16[0x706b] = 0x763e;
	__map_gbk2utf16[0x706c] = 0x7633;
	__map_gbk2utf16[0x706d] = 0x764d;
	__map_gbk2utf16[0x706e] = 0x765e;
	__map_gbk2utf16[0x706f] = 0x7654;
	__map_gbk2utf16[0x7070] = 0x765c;
	__map_gbk2utf16[0x7071] = 0x7656;
	__map_gbk2utf16[0x7072] = 0x766b;
	__map_gbk2utf16[0x7073] = 0x766f;
	__map_gbk2utf16[0x7074] = 0x7fca;
	__map_gbk2utf16[0x7075] = 0x7ae6;
	__map_gbk2utf16[0x7076] = 0x7a78;
	__map_gbk2utf16[0x7077] = 0x7a79;
	__map_gbk2utf16[0x7078] = 0x7a80;
	__map_gbk2utf16[0x7079] = 0x7a86;
	__map_gbk2utf16[0x707a] = 0x7a88;
	__map_gbk2utf16[0x707b] = 0x7a95;
	__map_gbk2utf16[0x707c] = 0x7aa6;
	__map_gbk2utf16[0x707d] = 0x7aa0;
	__map_gbk2utf16[0x707e] = 0x7aac;
	__map_gbk2utf16[0x707f] = 0x7aa8;
	__map_gbk2utf16[0x7080] = 0x7aad;
	__map_gbk2utf16[0x7081] = 0x7ab3;
	__map_gbk2utf16[0x7082] = 0x8864;
	__map_gbk2utf16[0x7083] = 0x8869;
	__map_gbk2utf16[0x7084] = 0x8872;
	__map_gbk2utf16[0x7085] = 0x887d;
	__map_gbk2utf16[0x7086] = 0x887f;
	__map_gbk2utf16[0x7087] = 0x8882;
	__map_gbk2utf16[0x7088] = 0x88a2;
	__map_gbk2utf16[0x7089] = 0x88c6;
	__map_gbk2utf16[0x708a] = 0x88b7;
	__map_gbk2utf16[0x708b] = 0x88bc;
	__map_gbk2utf16[0x708c] = 0x88c9;
	__map_gbk2utf16[0x708d] = 0x88e2;
	__map_gbk2utf16[0x708e] = 0x88ce;
	__map_gbk2utf16[0x708f] = 0x88e3;
	__map_gbk2utf16[0x7090] = 0x88e5;
	__map_gbk2utf16[0x7091] = 0x88f1;
	__map_gbk2utf16[0x7092] = 0x891a;
	__map_gbk2utf16[0x7093] = 0x88fc;
	__map_gbk2utf16[0x7094] = 0x88e8;
	__map_gbk2utf16[0x7095] = 0x88fe;
	__map_gbk2utf16[0x7096] = 0x88f0;
	__map_gbk2utf16[0x7097] = 0x8921;
	__map_gbk2utf16[0x7098] = 0x8919;
	__map_gbk2utf16[0x7099] = 0x8913;
	__map_gbk2utf16[0x709a] = 0x891b;
	__map_gbk2utf16[0x709b] = 0x890a;
	__map_gbk2utf16[0x709c] = 0x8934;
	__map_gbk2utf16[0x709d] = 0x892b;
	__map_gbk2utf16[0x709e] = 0x8936;
	__map_gbk2utf16[0x709f] = 0x8941;
	__map_gbk2utf16[0x70a0] = 0x8966;
	__map_gbk2utf16[0x70a1] = 0x897b;
	__map_gbk2utf16[0x70a2] = 0x758b;
	__map_gbk2utf16[0x70a3] = 0x80e5;
	__map_gbk2utf16[0x70a4] = 0x76b2;
	__map_gbk2utf16[0x70a5] = 0x76b4;
	__map_gbk2utf16[0x70a6] = 0x77dc;
	__map_gbk2utf16[0x70a7] = 0x8012;
	__map_gbk2utf16[0x70a8] = 0x8014;
	__map_gbk2utf16[0x70a9] = 0x8016;
	__map_gbk2utf16[0x70aa] = 0x801c;
	__map_gbk2utf16[0x70ab] = 0x8020;
	__map_gbk2utf16[0x70ac] = 0x8022;
	__map_gbk2utf16[0x70ad] = 0x8025;
	__map_gbk2utf16[0x70ae] = 0x8026;
	__map_gbk2utf16[0x70af] = 0x8027;
	__map_gbk2utf16[0x70b0] = 0x8029;
	__map_gbk2utf16[0x70b1] = 0x8028;
	__map_gbk2utf16[0x70b2] = 0x8031;
	__map_gbk2utf16[0x70b3] = 0x800b;
	__map_gbk2utf16[0x70b4] = 0x8035;
	__map_gbk2utf16[0x70b5] = 0x8043;
	__map_gbk2utf16[0x70b6] = 0x8046;
	__map_gbk2utf16[0x70b7] = 0x804d;
	__map_gbk2utf16[0x70b8] = 0x8052;
	__map_gbk2utf16[0x70b9] = 0x8069;
	__map_gbk2utf16[0x70ba] = 0x8071;
	__map_gbk2utf16[0x70bb] = 0x8983;
	__map_gbk2utf16[0x70bc] = 0x9878;
	__map_gbk2utf16[0x70bd] = 0x9880;
	__map_gbk2utf16[0x70be] = 0x9883;
	__map_gbk2utf16[0x7100] = 0x99fa;
	__map_gbk2utf16[0x7101] = 0x99fb;
	__map_gbk2utf16[0x7102] = 0x99fc;
	__map_gbk2utf16[0x7103] = 0x99fd;
	__map_gbk2utf16[0x7104] = 0x99fe;
	__map_gbk2utf16[0x7105] = 0x99ff;
	__map_gbk2utf16[0x7106] = 0x9a00;
	__map_gbk2utf16[0x7107] = 0x9a01;
	__map_gbk2utf16[0x7108] = 0x9a02;
	__map_gbk2utf16[0x7109] = 0x9a03;
	__map_gbk2utf16[0x710a] = 0x9a04;
	__map_gbk2utf16[0x710b] = 0x9a05;
	__map_gbk2utf16[0x710c] = 0x9a06;
	__map_gbk2utf16[0x710d] = 0x9a07;
	__map_gbk2utf16[0x710e] = 0x9a08;
	__map_gbk2utf16[0x710f] = 0x9a09;
	__map_gbk2utf16[0x7110] = 0x9a0a;
	__map_gbk2utf16[0x7111] = 0x9a0b;
	__map_gbk2utf16[0x7112] = 0x9a0c;
	__map_gbk2utf16[0x7113] = 0x9a0d;
	__map_gbk2utf16[0x7114] = 0x9a0e;
	__map_gbk2utf16[0x7115] = 0x9a0f;
	__map_gbk2utf16[0x7116] = 0x9a10;
	__map_gbk2utf16[0x7117] = 0x9a11;
	__map_gbk2utf16[0x7118] = 0x9a12;
	__map_gbk2utf16[0x7119] = 0x9a13;
	__map_gbk2utf16[0x711a] = 0x9a14;
	__map_gbk2utf16[0x711b] = 0x9a15;
	__map_gbk2utf16[0x711c] = 0x9a16;
	__map_gbk2utf16[0x711d] = 0x9a17;
	__map_gbk2utf16[0x711e] = 0x9a18;
	__map_gbk2utf16[0x711f] = 0x9a19;
	__map_gbk2utf16[0x7120] = 0x9a1a;
	__map_gbk2utf16[0x7121] = 0x9a1b;
	__map_gbk2utf16[0x7122] = 0x9a1c;
	__map_gbk2utf16[0x7123] = 0x9a1d;
	__map_gbk2utf16[0x7124] = 0x9a1e;
	__map_gbk2utf16[0x7125] = 0x9a1f;
	__map_gbk2utf16[0x7126] = 0x9a20;
	__map_gbk2utf16[0x7127] = 0x9a21;
	__map_gbk2utf16[0x7128] = 0x9a22;
	__map_gbk2utf16[0x7129] = 0x9a23;
	__map_gbk2utf16[0x712a] = 0x9a24;
	__map_gbk2utf16[0x712b] = 0x9a25;
	__map_gbk2utf16[0x712c] = 0x9a26;
	__map_gbk2utf16[0x712d] = 0x9a27;
	__map_gbk2utf16[0x712e] = 0x9a28;
	__map_gbk2utf16[0x712f] = 0x9a29;
	__map_gbk2utf16[0x7130] = 0x9a2a;
	__map_gbk2utf16[0x7131] = 0x9a2b;
	__map_gbk2utf16[0x7132] = 0x9a2c;
	__map_gbk2utf16[0x7133] = 0x9a2d;
	__map_gbk2utf16[0x7134] = 0x9a2e;
	__map_gbk2utf16[0x7135] = 0x9a2f;
	__map_gbk2utf16[0x7136] = 0x9a30;
	__map_gbk2utf16[0x7137] = 0x9a31;
	__map_gbk2utf16[0x7138] = 0x9a32;
	__map_gbk2utf16[0x7139] = 0x9a33;
	__map_gbk2utf16[0x713a] = 0x9a34;
	__map_gbk2utf16[0x713b] = 0x9a35;
	__map_gbk2utf16[0x713c] = 0x9a36;
	__map_gbk2utf16[0x713d] = 0x9a37;
	__map_gbk2utf16[0x713e] = 0x9a38;
	__map_gbk2utf16[0x7140] = 0x9a39;
	__map_gbk2utf16[0x7141] = 0x9a3a;
	__map_gbk2utf16[0x7142] = 0x9a3b;
	__map_gbk2utf16[0x7143] = 0x9a3c;
	__map_gbk2utf16[0x7144] = 0x9a3d;
	__map_gbk2utf16[0x7145] = 0x9a3e;
	__map_gbk2utf16[0x7146] = 0x9a3f;
	__map_gbk2utf16[0x7147] = 0x9a40;
	__map_gbk2utf16[0x7148] = 0x9a41;
	__map_gbk2utf16[0x7149] = 0x9a42;
	__map_gbk2utf16[0x714a] = 0x9a43;
	__map_gbk2utf16[0x714b] = 0x9a44;
	__map_gbk2utf16[0x714c] = 0x9a45;
	__map_gbk2utf16[0x714d] = 0x9a46;
	__map_gbk2utf16[0x714e] = 0x9a47;
	__map_gbk2utf16[0x714f] = 0x9a48;
	__map_gbk2utf16[0x7150] = 0x9a49;
	__map_gbk2utf16[0x7151] = 0x9a4a;
	__map_gbk2utf16[0x7152] = 0x9a4b;
	__map_gbk2utf16[0x7153] = 0x9a4c;
	__map_gbk2utf16[0x7154] = 0x9a4d;
	__map_gbk2utf16[0x7155] = 0x9a4e;
	__map_gbk2utf16[0x7156] = 0x9a4f;
	__map_gbk2utf16[0x7157] = 0x9a50;
	__map_gbk2utf16[0x7158] = 0x9a51;
	__map_gbk2utf16[0x7159] = 0x9a52;
	__map_gbk2utf16[0x715a] = 0x9a53;
	__map_gbk2utf16[0x715b] = 0x9a54;
	__map_gbk2utf16[0x715c] = 0x9a55;
	__map_gbk2utf16[0x715d] = 0x9a56;
	__map_gbk2utf16[0x715e] = 0x9a57;
	__map_gbk2utf16[0x715f] = 0x9a58;
	__map_gbk2utf16[0x7160] = 0x9a59;
	__map_gbk2utf16[0x7161] = 0x9889;
	__map_gbk2utf16[0x7162] = 0x988c;
	__map_gbk2utf16[0x7163] = 0x988d;
	__map_gbk2utf16[0x7164] = 0x988f;
	__map_gbk2utf16[0x7165] = 0x9894;
	__map_gbk2utf16[0x7166] = 0x989a;
	__map_gbk2utf16[0x7167] = 0x989b;
	__map_gbk2utf16[0x7168] = 0x989e;
	__map_gbk2utf16[0x7169] = 0x989f;
	__map_gbk2utf16[0x716a] = 0x98a1;
	__map_gbk2utf16[0x716b] = 0x98a2;
	__map_gbk2utf16[0x716c] = 0x98a5;
	__map_gbk2utf16[0x716d] = 0x98a6;
	__map_gbk2utf16[0x716e] = 0x864d;
	__map_gbk2utf16[0x716f] = 0x8654;
	__map_gbk2utf16[0x7170] = 0x866c;
	__map_gbk2utf16[0x7171] = 0x866e;
	__map_gbk2utf16[0x7172] = 0x867f;
	__map_gbk2utf16[0x7173] = 0x867a;
	__map_gbk2utf16[0x7174] = 0x867c;
	__map_gbk2utf16[0x7175] = 0x867b;
	__map_gbk2utf16[0x7176] = 0x86a8;
	__map_gbk2utf16[0x7177] = 0x868d;
	__map_gbk2utf16[0x7178] = 0x868b;
	__map_gbk2utf16[0x7179] = 0x86ac;
	__map_gbk2utf16[0x717a] = 0x869d;
	__map_gbk2utf16[0x717b] = 0x86a7;
	__map_gbk2utf16[0x717c] = 0x86a3;
	__map_gbk2utf16[0x717d] = 0x86aa;
	__map_gbk2utf16[0x717e] = 0x8693;
	__map_gbk2utf16[0x717f] = 0x86a9;
	__map_gbk2utf16[0x7180] = 0x86b6;
	__map_gbk2utf16[0x7181] = 0x86c4;
	__map_gbk2utf16[0x7182] = 0x86b5;
	__map_gbk2utf16[0x7183] = 0x86ce;
	__map_gbk2utf16[0x7184] = 0x86b0;
	__map_gbk2utf16[0x7185] = 0x86ba;
	__map_gbk2utf16[0x7186] = 0x86b1;
	__map_gbk2utf16[0x7187] = 0x86af;
	__map_gbk2utf16[0x7188] = 0x86c9;
	__map_gbk2utf16[0x7189] = 0x86cf;
	__map_gbk2utf16[0x718a] = 0x86b4;
	__map_gbk2utf16[0x718b] = 0x86e9;
	__map_gbk2utf16[0x718c] = 0x86f1;
	__map_gbk2utf16[0x718d] = 0x86f2;
	__map_gbk2utf16[0x718e] = 0x86ed;
	__map_gbk2utf16[0x718f] = 0x86f3;
	__map_gbk2utf16[0x7190] = 0x86d0;
	__map_gbk2utf16[0x7191] = 0x8713;
	__map_gbk2utf16[0x7192] = 0x86de;
	__map_gbk2utf16[0x7193] = 0x86f4;
	__map_gbk2utf16[0x7194] = 0x86df;
	__map_gbk2utf16[0x7195] = 0x86d8;
	__map_gbk2utf16[0x7196] = 0x86d1;
	__map_gbk2utf16[0x7197] = 0x8703;
	__map_gbk2utf16[0x7198] = 0x8707;
	__map_gbk2utf16[0x7199] = 0x86f8;
	__map_gbk2utf16[0x719a] = 0x8708;
	__map_gbk2utf16[0x719b] = 0x870a;
	__map_gbk2utf16[0x719c] = 0x870d;
	__map_gbk2utf16[0x719d] = 0x8709;
	__map_gbk2utf16[0x719e] = 0x8723;
	__map_gbk2utf16[0x719f] = 0x873b;
	__map_gbk2utf16[0x71a0] = 0x871e;
	__map_gbk2utf16[0x71a1] = 0x8725;
	__map_gbk2utf16[0x71a2] = 0x872e;
	__map_gbk2utf16[0x71a3] = 0x871a;
	__map_gbk2utf16[0x71a4] = 0x873e;
	__map_gbk2utf16[0x71a5] = 0x8748;
	__map_gbk2utf16[0x71a6] = 0x8734;
	__map_gbk2utf16[0x71a7] = 0x8731;
	__map_gbk2utf16[0x71a8] = 0x8729;
	__map_gbk2utf16[0x71a9] = 0x8737;
	__map_gbk2utf16[0x71aa] = 0x873f;
	__map_gbk2utf16[0x71ab] = 0x8782;
	__map_gbk2utf16[0x71ac] = 0x8722;
	__map_gbk2utf16[0x71ad] = 0x877d;
	__map_gbk2utf16[0x71ae] = 0x877e;
	__map_gbk2utf16[0x71af] = 0x877b;
	__map_gbk2utf16[0x71b0] = 0x8760;
	__map_gbk2utf16[0x71b1] = 0x8770;
	__map_gbk2utf16[0x71b2] = 0x874c;
	__map_gbk2utf16[0x71b3] = 0x876e;
	__map_gbk2utf16[0x71b4] = 0x878b;
	__map_gbk2utf16[0x71b5] = 0x8753;
	__map_gbk2utf16[0x71b6] = 0x8763;
	__map_gbk2utf16[0x71b7] = 0x877c;
	__map_gbk2utf16[0x71b8] = 0x8764;
	__map_gbk2utf16[0x71b9] = 0x8759;
	__map_gbk2utf16[0x71ba] = 0x8765;
	__map_gbk2utf16[0x71bb] = 0x8793;
	__map_gbk2utf16[0x71bc] = 0x87af;
	__map_gbk2utf16[0x71bd] = 0x87a8;
	__map_gbk2utf16[0x71be] = 0x87d2;
	__map_gbk2utf16[0x7200] = 0x9a5a;
	__map_gbk2utf16[0x7201] = 0x9a5b;
	__map_gbk2utf16[0x7202] = 0x9a5c;
	__map_gbk2utf16[0x7203] = 0x9a5d;
	__map_gbk2utf16[0x7204] = 0x9a5e;
	__map_gbk2utf16[0x7205] = 0x9a5f;
	__map_gbk2utf16[0x7206] = 0x9a60;
	__map_gbk2utf16[0x7207] = 0x9a61;
	__map_gbk2utf16[0x7208] = 0x9a62;
	__map_gbk2utf16[0x7209] = 0x9a63;
	__map_gbk2utf16[0x720a] = 0x9a64;
	__map_gbk2utf16[0x720b] = 0x9a65;
	__map_gbk2utf16[0x720c] = 0x9a66;
	__map_gbk2utf16[0x720d] = 0x9a67;
	__map_gbk2utf16[0x720e] = 0x9a68;
	__map_gbk2utf16[0x720f] = 0x9a69;
	__map_gbk2utf16[0x7210] = 0x9a6a;
	__map_gbk2utf16[0x7211] = 0x9a6b;
	__map_gbk2utf16[0x7212] = 0x9a72;
	__map_gbk2utf16[0x7213] = 0x9a83;
	__map_gbk2utf16[0x7214] = 0x9a89;
	__map_gbk2utf16[0x7215] = 0x9a8d;
	__map_gbk2utf16[0x7216] = 0x9a8e;
	__map_gbk2utf16[0x7217] = 0x9a94;
	__map_gbk2utf16[0x7218] = 0x9a95;
	__map_gbk2utf16[0x7219] = 0x9a99;
	__map_gbk2utf16[0x721a] = 0x9aa6;
	__map_gbk2utf16[0x721b] = 0x9aa9;
	__map_gbk2utf16[0x721c] = 0x9aaa;
	__map_gbk2utf16[0x721d] = 0x9aab;
	__map_gbk2utf16[0x721e] = 0x9aac;
	__map_gbk2utf16[0x721f] = 0x9aad;
	__map_gbk2utf16[0x7220] = 0x9aae;
	__map_gbk2utf16[0x7221] = 0x9aaf;
	__map_gbk2utf16[0x7222] = 0x9ab2;
	__map_gbk2utf16[0x7223] = 0x9ab3;
	__map_gbk2utf16[0x7224] = 0x9ab4;
	__map_gbk2utf16[0x7225] = 0x9ab5;
	__map_gbk2utf16[0x7226] = 0x9ab9;
	__map_gbk2utf16[0x7227] = 0x9abb;
	__map_gbk2utf16[0x7228] = 0x9abd;
	__map_gbk2utf16[0x7229] = 0x9abe;
	__map_gbk2utf16[0x722a] = 0x9abf;
	__map_gbk2utf16[0x722b] = 0x9ac3;
	__map_gbk2utf16[0x722c] = 0x9ac4;
	__map_gbk2utf16[0x722d] = 0x9ac6;
	__map_gbk2utf16[0x722e] = 0x9ac7;
	__map_gbk2utf16[0x722f] = 0x9ac8;
	__map_gbk2utf16[0x7230] = 0x9ac9;
	__map_gbk2utf16[0x7231] = 0x9aca;
	__map_gbk2utf16[0x7232] = 0x9acd;
	__map_gbk2utf16[0x7233] = 0x9ace;
	__map_gbk2utf16[0x7234] = 0x9acf;
	__map_gbk2utf16[0x7235] = 0x9ad0;
	__map_gbk2utf16[0x7236] = 0x9ad2;
	__map_gbk2utf16[0x7237] = 0x9ad4;
	__map_gbk2utf16[0x7238] = 0x9ad5;
	__map_gbk2utf16[0x7239] = 0x9ad6;
	__map_gbk2utf16[0x723a] = 0x9ad7;
	__map_gbk2utf16[0x723b] = 0x9ad9;
	__map_gbk2utf16[0x723c] = 0x9ada;
	__map_gbk2utf16[0x723d] = 0x9adb;
	__map_gbk2utf16[0x723e] = 0x9adc;
	__map_gbk2utf16[0x7240] = 0x9add;
	__map_gbk2utf16[0x7241] = 0x9ade;
	__map_gbk2utf16[0x7242] = 0x9ae0;
	__map_gbk2utf16[0x7243] = 0x9ae2;
	__map_gbk2utf16[0x7244] = 0x9ae3;
	__map_gbk2utf16[0x7245] = 0x9ae4;
	__map_gbk2utf16[0x7246] = 0x9ae5;
	__map_gbk2utf16[0x7247] = 0x9ae7;
	__map_gbk2utf16[0x7248] = 0x9ae8;
	__map_gbk2utf16[0x7249] = 0x9ae9;
	__map_gbk2utf16[0x724a] = 0x9aea;
	__map_gbk2utf16[0x724b] = 0x9aec;
	__map_gbk2utf16[0x724c] = 0x9aee;
	__map_gbk2utf16[0x724d] = 0x9af0;
	__map_gbk2utf16[0x724e] = 0x9af1;
	__map_gbk2utf16[0x724f] = 0x9af2;
	__map_gbk2utf16[0x7250] = 0x9af3;
	__map_gbk2utf16[0x7251] = 0x9af4;
	__map_gbk2utf16[0x7252] = 0x9af5;
	__map_gbk2utf16[0x7253] = 0x9af6;
	__map_gbk2utf16[0x7254] = 0x9af7;
	__map_gbk2utf16[0x7255] = 0x9af8;
	__map_gbk2utf16[0x7256] = 0x9afa;
	__map_gbk2utf16[0x7257] = 0x9afc;
	__map_gbk2utf16[0x7258] = 0x9afd;
	__map_gbk2utf16[0x7259] = 0x9afe;
	__map_gbk2utf16[0x725a] = 0x9aff;
	__map_gbk2utf16[0x725b] = 0x9b00;
	__map_gbk2utf16[0x725c] = 0x9b01;
	__map_gbk2utf16[0x725d] = 0x9b02;
	__map_gbk2utf16[0x725e] = 0x9b04;
	__map_gbk2utf16[0x725f] = 0x9b05;
	__map_gbk2utf16[0x7260] = 0x9b06;
	__map_gbk2utf16[0x7261] = 0x87c6;
	__map_gbk2utf16[0x7262] = 0x8788;
	__map_gbk2utf16[0x7263] = 0x8785;
	__map_gbk2utf16[0x7264] = 0x87ad;
	__map_gbk2utf16[0x7265] = 0x8797;
	__map_gbk2utf16[0x7266] = 0x8783;
	__map_gbk2utf16[0x7267] = 0x87ab;
	__map_gbk2utf16[0x7268] = 0x87e5;
	__map_gbk2utf16[0x7269] = 0x87ac;
	__map_gbk2utf16[0x726a] = 0x87b5;
	__map_gbk2utf16[0x726b] = 0x87b3;
	__map_gbk2utf16[0x726c] = 0x87cb;
	__map_gbk2utf16[0x726d] = 0x87d3;
	__map_gbk2utf16[0x726e] = 0x87bd;
	__map_gbk2utf16[0x726f] = 0x87d1;
	__map_gbk2utf16[0x7270] = 0x87c0;
	__map_gbk2utf16[0x7271] = 0x87ca;
	__map_gbk2utf16[0x7272] = 0x87db;
	__map_gbk2utf16[0x7273] = 0x87ea;
	__map_gbk2utf16[0x7274] = 0x87e0;
	__map_gbk2utf16[0x7275] = 0x87ee;
	__map_gbk2utf16[0x7276] = 0x8816;
	__map_gbk2utf16[0x7277] = 0x8813;
	__map_gbk2utf16[0x7278] = 0x87fe;
	__map_gbk2utf16[0x7279] = 0x880a;
	__map_gbk2utf16[0x727a] = 0x881b;
	__map_gbk2utf16[0x727b] = 0x8821;
	__map_gbk2utf16[0x727c] = 0x8839;
	__map_gbk2utf16[0x727d] = 0x883c;
	__map_gbk2utf16[0x727e] = 0x7f36;
	__map_gbk2utf16[0x727f] = 0x7f42;
	__map_gbk2utf16[0x7280] = 0x7f44;
	__map_gbk2utf16[0x7281] = 0x7f45;
	__map_gbk2utf16[0x7282] = 0x8210;
	__map_gbk2utf16[0x7283] = 0x7afa;
	__map_gbk2utf16[0x7284] = 0x7afd;
	__map_gbk2utf16[0x7285] = 0x7b08;
	__map_gbk2utf16[0x7286] = 0x7b03;
	__map_gbk2utf16[0x7287] = 0x7b04;
	__map_gbk2utf16[0x7288] = 0x7b15;
	__map_gbk2utf16[0x7289] = 0x7b0a;
	__map_gbk2utf16[0x728a] = 0x7b2b;
	__map_gbk2utf16[0x728b] = 0x7b0f;
	__map_gbk2utf16[0x728c] = 0x7b47;
	__map_gbk2utf16[0x728d] = 0x7b38;
	__map_gbk2utf16[0x728e] = 0x7b2a;
	__map_gbk2utf16[0x728f] = 0x7b19;
	__map_gbk2utf16[0x7290] = 0x7b2e;
	__map_gbk2utf16[0x7291] = 0x7b31;
	__map_gbk2utf16[0x7292] = 0x7b20;
	__map_gbk2utf16[0x7293] = 0x7b25;
	__map_gbk2utf16[0x7294] = 0x7b24;
	__map_gbk2utf16[0x7295] = 0x7b33;
	__map_gbk2utf16[0x7296] = 0x7b3e;
	__map_gbk2utf16[0x7297] = 0x7b1e;
	__map_gbk2utf16[0x7298] = 0x7b58;
	__map_gbk2utf16[0x7299] = 0x7b5a;
	__map_gbk2utf16[0x729a] = 0x7b45;
	__map_gbk2utf16[0x729b] = 0x7b75;
	__map_gbk2utf16[0x729c] = 0x7b4c;
	__map_gbk2utf16[0x729d] = 0x7b5d;
	__map_gbk2utf16[0x729e] = 0x7b60;
	__map_gbk2utf16[0x729f] = 0x7b6e;
	__map_gbk2utf16[0x72a0] = 0x7b7b;
	__map_gbk2utf16[0x72a1] = 0x7b62;
	__map_gbk2utf16[0x72a2] = 0x7b72;
	__map_gbk2utf16[0x72a3] = 0x7b71;
	__map_gbk2utf16[0x72a4] = 0x7b90;
	__map_gbk2utf16[0x72a5] = 0x7ba6;
	__map_gbk2utf16[0x72a6] = 0x7ba7;
	__map_gbk2utf16[0x72a7] = 0x7bb8;
	__map_gbk2utf16[0x72a8] = 0x7bac;
	__map_gbk2utf16[0x72a9] = 0x7b9d;
	__map_gbk2utf16[0x72aa] = 0x7ba8;
	__map_gbk2utf16[0x72ab] = 0x7b85;
	__map_gbk2utf16[0x72ac] = 0x7baa;
	__map_gbk2utf16[0x72ad] = 0x7b9c;
	__map_gbk2utf16[0x72ae] = 0x7ba2;
	__map_gbk2utf16[0x72af] = 0x7bab;
	__map_gbk2utf16[0x72b0] = 0x7bb4;
	__map_gbk2utf16[0x72b1] = 0x7bd1;
	__map_gbk2utf16[0x72b2] = 0x7bc1;
	__map_gbk2utf16[0x72b3] = 0x7bcc;
	__map_gbk2utf16[0x72b4] = 0x7bdd;
	__map_gbk2utf16[0x72b5] = 0x7bda;
	__map_gbk2utf16[0x72b6] = 0x7be5;
	__map_gbk2utf16[0x72b7] = 0x7be6;
	__map_gbk2utf16[0x72b8] = 0x7bea;
	__map_gbk2utf16[0x72b9] = 0x7c0c;
	__map_gbk2utf16[0x72ba] = 0x7bfe;
	__map_gbk2utf16[0x72bb] = 0x7bfc;
	__map_gbk2utf16[0x72bc] = 0x7c0f;
	__map_gbk2utf16[0x72bd] = 0x7c16;
	__map_gbk2utf16[0x72be] = 0x7c0b;
	__map_gbk2utf16[0x7300] = 0x9b07;
	__map_gbk2utf16[0x7301] = 0x9b09;
	__map_gbk2utf16[0x7302] = 0x9b0a;
	__map_gbk2utf16[0x7303] = 0x9b0b;
	__map_gbk2utf16[0x7304] = 0x9b0c;
	__map_gbk2utf16[0x7305] = 0x9b0d;
	__map_gbk2utf16[0x7306] = 0x9b0e;
	__map_gbk2utf16[0x7307] = 0x9b10;
	__map_gbk2utf16[0x7308] = 0x9b11;
	__map_gbk2utf16[0x7309] = 0x9b12;
	__map_gbk2utf16[0x730a] = 0x9b14;
	__map_gbk2utf16[0x730b] = 0x9b15;
	__map_gbk2utf16[0x730c] = 0x9b16;
	__map_gbk2utf16[0x730d] = 0x9b17;
	__map_gbk2utf16[0x730e] = 0x9b18;
	__map_gbk2utf16[0x730f] = 0x9b19;
	__map_gbk2utf16[0x7310] = 0x9b1a;
	__map_gbk2utf16[0x7311] = 0x9b1b;
	__map_gbk2utf16[0x7312] = 0x9b1c;
	__map_gbk2utf16[0x7313] = 0x9b1d;
	__map_gbk2utf16[0x7314] = 0x9b1e;
	__map_gbk2utf16[0x7315] = 0x9b20;
	__map_gbk2utf16[0x7316] = 0x9b21;
	__map_gbk2utf16[0x7317] = 0x9b22;
	__map_gbk2utf16[0x7318] = 0x9b24;
	__map_gbk2utf16[0x7319] = 0x9b25;
	__map_gbk2utf16[0x731a] = 0x9b26;
	__map_gbk2utf16[0x731b] = 0x9b27;
	__map_gbk2utf16[0x731c] = 0x9b28;
	__map_gbk2utf16[0x731d] = 0x9b29;
	__map_gbk2utf16[0x731e] = 0x9b2a;
	__map_gbk2utf16[0x731f] = 0x9b2b;
	__map_gbk2utf16[0x7320] = 0x9b2c;
	__map_gbk2utf16[0x7321] = 0x9b2d;
	__map_gbk2utf16[0x7322] = 0x9b2e;
	__map_gbk2utf16[0x7323] = 0x9b30;
	__map_gbk2utf16[0x7324] = 0x9b31;
	__map_gbk2utf16[0x7325] = 0x9b33;
	__map_gbk2utf16[0x7326] = 0x9b34;
	__map_gbk2utf16[0x7327] = 0x9b35;
	__map_gbk2utf16[0x7328] = 0x9b36;
	__map_gbk2utf16[0x7329] = 0x9b37;
	__map_gbk2utf16[0x732a] = 0x9b38;
	__map_gbk2utf16[0x732b] = 0x9b39;
	__map_gbk2utf16[0x732c] = 0x9b3a;
	__map_gbk2utf16[0x732d] = 0x9b3d;
	__map_gbk2utf16[0x732e] = 0x9b3e;
	__map_gbk2utf16[0x732f] = 0x9b3f;
	__map_gbk2utf16[0x7330] = 0x9b40;
	__map_gbk2utf16[0x7331] = 0x9b46;
	__map_gbk2utf16[0x7332] = 0x9b4a;
	__map_gbk2utf16[0x7333] = 0x9b4b;
	__map_gbk2utf16[0x7334] = 0x9b4c;
	__map_gbk2utf16[0x7335] = 0x9b4e;
	__map_gbk2utf16[0x7336] = 0x9b50;
	__map_gbk2utf16[0x7337] = 0x9b52;
	__map_gbk2utf16[0x7338] = 0x9b53;
	__map_gbk2utf16[0x7339] = 0x9b55;
	__map_gbk2utf16[0x733a] = 0x9b56;
	__map_gbk2utf16[0x733b] = 0x9b57;
	__map_gbk2utf16[0x733c] = 0x9b58;
	__map_gbk2utf16[0x733d] = 0x9b59;
	__map_gbk2utf16[0x733e] = 0x9b5a;
	__map_gbk2utf16[0x7340] = 0x9b5b;
	__map_gbk2utf16[0x7341] = 0x9b5c;
	__map_gbk2utf16[0x7342] = 0x9b5d;
	__map_gbk2utf16[0x7343] = 0x9b5e;
	__map_gbk2utf16[0x7344] = 0x9b5f;
	__map_gbk2utf16[0x7345] = 0x9b60;
	__map_gbk2utf16[0x7346] = 0x9b61;
	__map_gbk2utf16[0x7347] = 0x9b62;
	__map_gbk2utf16[0x7348] = 0x9b63;
	__map_gbk2utf16[0x7349] = 0x9b64;
	__map_gbk2utf16[0x734a] = 0x9b65;
	__map_gbk2utf16[0x734b] = 0x9b66;
	__map_gbk2utf16[0x734c] = 0x9b67;
	__map_gbk2utf16[0x734d] = 0x9b68;
	__map_gbk2utf16[0x734e] = 0x9b69;
	__map_gbk2utf16[0x734f] = 0x9b6a;
	__map_gbk2utf16[0x7350] = 0x9b6b;
	__map_gbk2utf16[0x7351] = 0x9b6c;
	__map_gbk2utf16[0x7352] = 0x9b6d;
	__map_gbk2utf16[0x7353] = 0x9b6e;
	__map_gbk2utf16[0x7354] = 0x9b6f;
	__map_gbk2utf16[0x7355] = 0x9b70;
	__map_gbk2utf16[0x7356] = 0x9b71;
	__map_gbk2utf16[0x7357] = 0x9b72;
	__map_gbk2utf16[0x7358] = 0x9b73;
	__map_gbk2utf16[0x7359] = 0x9b74;
	__map_gbk2utf16[0x735a] = 0x9b75;
	__map_gbk2utf16[0x735b] = 0x9b76;
	__map_gbk2utf16[0x735c] = 0x9b77;
	__map_gbk2utf16[0x735d] = 0x9b78;
	__map_gbk2utf16[0x735e] = 0x9b79;
	__map_gbk2utf16[0x735f] = 0x9b7a;
	__map_gbk2utf16[0x7360] = 0x9b7b;
	__map_gbk2utf16[0x7361] = 0x7c1f;
	__map_gbk2utf16[0x7362] = 0x7c2a;
	__map_gbk2utf16[0x7363] = 0x7c26;
	__map_gbk2utf16[0x7364] = 0x7c38;
	__map_gbk2utf16[0x7365] = 0x7c41;
	__map_gbk2utf16[0x7366] = 0x7c40;
	__map_gbk2utf16[0x7367] = 0x81fe;
	__map_gbk2utf16[0x7368] = 0x8201;
	__map_gbk2utf16[0x7369] = 0x8202;
	__map_gbk2utf16[0x736a] = 0x8204;
	__map_gbk2utf16[0x736b] = 0x81ec;
	__map_gbk2utf16[0x736c] = 0x8844;
	__map_gbk2utf16[0x736d] = 0x8221;
	__map_gbk2utf16[0x736e] = 0x8222;
	__map_gbk2utf16[0x736f] = 0x8223;
	__map_gbk2utf16[0x7370] = 0x822d;
	__map_gbk2utf16[0x7371] = 0x822f;
	__map_gbk2utf16[0x7372] = 0x8228;
	__map_gbk2utf16[0x7373] = 0x822b;
	__map_gbk2utf16[0x7374] = 0x8238;
	__map_gbk2utf16[0x7375] = 0x823b;
	__map_gbk2utf16[0x7376] = 0x8233;
	__map_gbk2utf16[0x7377] = 0x8234;
	__map_gbk2utf16[0x7378] = 0x823e;
	__map_gbk2utf16[0x7379] = 0x8244;
	__map_gbk2utf16[0x737a] = 0x8249;
	__map_gbk2utf16[0x737b] = 0x824b;
	__map_gbk2utf16[0x737c] = 0x824f;
	__map_gbk2utf16[0x737d] = 0x825a;
	__map_gbk2utf16[0x737e] = 0x825f;
	__map_gbk2utf16[0x737f] = 0x8268;
	__map_gbk2utf16[0x7380] = 0x887e;
	__map_gbk2utf16[0x7381] = 0x8885;
	__map_gbk2utf16[0x7382] = 0x8888;
	__map_gbk2utf16[0x7383] = 0x88d8;
	__map_gbk2utf16[0x7384] = 0x88df;
	__map_gbk2utf16[0x7385] = 0x895e;
	__map_gbk2utf16[0x7386] = 0x7f9d;
	__map_gbk2utf16[0x7387] = 0x7f9f;
	__map_gbk2utf16[0x7388] = 0x7fa7;
	__map_gbk2utf16[0x7389] = 0x7faf;
	__map_gbk2utf16[0x738a] = 0x7fb0;
	__map_gbk2utf16[0x738b] = 0x7fb2;
	__map_gbk2utf16[0x738c] = 0x7c7c;
	__map_gbk2utf16[0x738d] = 0x6549;
	__map_gbk2utf16[0x738e] = 0x7c91;
	__map_gbk2utf16[0x738f] = 0x7c9d;
	__map_gbk2utf16[0x7390] = 0x7c9c;
	__map_gbk2utf16[0x7391] = 0x7c9e;
	__map_gbk2utf16[0x7392] = 0x7ca2;
	__map_gbk2utf16[0x7393] = 0x7cb2;
	__map_gbk2utf16[0x7394] = 0x7cbc;
	__map_gbk2utf16[0x7395] = 0x7cbd;
	__map_gbk2utf16[0x7396] = 0x7cc1;
	__map_gbk2utf16[0x7397] = 0x7cc7;
	__map_gbk2utf16[0x7398] = 0x7ccc;
	__map_gbk2utf16[0x7399] = 0x7ccd;
	__map_gbk2utf16[0x739a] = 0x7cc8;
	__map_gbk2utf16[0x739b] = 0x7cc5;
	__map_gbk2utf16[0x739c] = 0x7cd7;
	__map_gbk2utf16[0x739d] = 0x7ce8;
	__map_gbk2utf16[0x739e] = 0x826e;
	__map_gbk2utf16[0x739f] = 0x66a8;
	__map_gbk2utf16[0x73a0] = 0x7fbf;
	__map_gbk2utf16[0x73a1] = 0x7fce;
	__map_gbk2utf16[0x73a2] = 0x7fd5;
	__map_gbk2utf16[0x73a3] = 0x7fe5;
	__map_gbk2utf16[0x73a4] = 0x7fe1;
	__map_gbk2utf16[0x73a5] = 0x7fe6;
	__map_gbk2utf16[0x73a6] = 0x7fe9;
	__map_gbk2utf16[0x73a7] = 0x7fee;
	__map_gbk2utf16[0x73a8] = 0x7ff3;
	__map_gbk2utf16[0x73a9] = 0x7cf8;
	__map_gbk2utf16[0x73aa] = 0x7d77;
	__map_gbk2utf16[0x73ab] = 0x7da6;
	__map_gbk2utf16[0x73ac] = 0x7dae;
	__map_gbk2utf16[0x73ad] = 0x7e47;
	__map_gbk2utf16[0x73ae] = 0x7e9b;
	__map_gbk2utf16[0x73af] = 0x9eb8;
	__map_gbk2utf16[0x73b0] = 0x9eb4;
	__map_gbk2utf16[0x73b1] = 0x8d73;
	__map_gbk2utf16[0x73b2] = 0x8d84;
	__map_gbk2utf16[0x73b3] = 0x8d94;
	__map_gbk2utf16[0x73b4] = 0x8d91;
	__map_gbk2utf16[0x73b5] = 0x8db1;
	__map_gbk2utf16[0x73b6] = 0x8d67;
	__map_gbk2utf16[0x73b7] = 0x8d6d;
	__map_gbk2utf16[0x73b8] = 0x8c47;
	__map_gbk2utf16[0x73b9] = 0x8c49;
	__map_gbk2utf16[0x73ba] = 0x914a;
	__map_gbk2utf16[0x73bb] = 0x9150;
	__map_gbk2utf16[0x73bc] = 0x914e;
	__map_gbk2utf16[0x73bd] = 0x914f;
	__map_gbk2utf16[0x73be] = 0x9164;
	__map_gbk2utf16[0x7400] = 0x9b7c;
	__map_gbk2utf16[0x7401] = 0x9b7d;
	__map_gbk2utf16[0x7402] = 0x9b7e;
	__map_gbk2utf16[0x7403] = 0x9b7f;
	__map_gbk2utf16[0x7404] = 0x9b80;
	__map_gbk2utf16[0x7405] = 0x9b81;
	__map_gbk2utf16[0x7406] = 0x9b82;
	__map_gbk2utf16[0x7407] = 0x9b83;
	__map_gbk2utf16[0x7408] = 0x9b84;
	__map_gbk2utf16[0x7409] = 0x9b85;
	__map_gbk2utf16[0x740a] = 0x9b86;
	__map_gbk2utf16[0x740b] = 0x9b87;
	__map_gbk2utf16[0x740c] = 0x9b88;
	__map_gbk2utf16[0x740d] = 0x9b89;
	__map_gbk2utf16[0x740e] = 0x9b8a;
	__map_gbk2utf16[0x740f] = 0x9b8b;
	__map_gbk2utf16[0x7410] = 0x9b8c;
	__map_gbk2utf16[0x7411] = 0x9b8d;
	__map_gbk2utf16[0x7412] = 0x9b8e;
	__map_gbk2utf16[0x7413] = 0x9b8f;
	__map_gbk2utf16[0x7414] = 0x9b90;
	__map_gbk2utf16[0x7415] = 0x9b91;
	__map_gbk2utf16[0x7416] = 0x9b92;
	__map_gbk2utf16[0x7417] = 0x9b93;
	__map_gbk2utf16[0x7418] = 0x9b94;
	__map_gbk2utf16[0x7419] = 0x9b95;
	__map_gbk2utf16[0x741a] = 0x9b96;
	__map_gbk2utf16[0x741b] = 0x9b97;
	__map_gbk2utf16[0x741c] = 0x9b98;
	__map_gbk2utf16[0x741d] = 0x9b99;
	__map_gbk2utf16[0x741e] = 0x9b9a;
	__map_gbk2utf16[0x741f] = 0x9b9b;
	__map_gbk2utf16[0x7420] = 0x9b9c;
	__map_gbk2utf16[0x7421] = 0x9b9d;
	__map_gbk2utf16[0x7422] = 0x9b9e;
	__map_gbk2utf16[0x7423] = 0x9b9f;
	__map_gbk2utf16[0x7424] = 0x9ba0;
	__map_gbk2utf16[0x7425] = 0x9ba1;
	__map_gbk2utf16[0x7426] = 0x9ba2;
	__map_gbk2utf16[0x7427] = 0x9ba3;
	__map_gbk2utf16[0x7428] = 0x9ba4;
	__map_gbk2utf16[0x7429] = 0x9ba5;
	__map_gbk2utf16[0x742a] = 0x9ba6;
	__map_gbk2utf16[0x742b] = 0x9ba7;
	__map_gbk2utf16[0x742c] = 0x9ba8;
	__map_gbk2utf16[0x742d] = 0x9ba9;
	__map_gbk2utf16[0x742e] = 0x9baa;
	__map_gbk2utf16[0x742f] = 0x9bab;
	__map_gbk2utf16[0x7430] = 0x9bac;
	__map_gbk2utf16[0x7431] = 0x9bad;
	__map_gbk2utf16[0x7432] = 0x9bae;
	__map_gbk2utf16[0x7433] = 0x9baf;
	__map_gbk2utf16[0x7434] = 0x9bb0;
	__map_gbk2utf16[0x7435] = 0x9bb1;
	__map_gbk2utf16[0x7436] = 0x9bb2;
	__map_gbk2utf16[0x7437] = 0x9bb3;
	__map_gbk2utf16[0x7438] = 0x9bb4;
	__map_gbk2utf16[0x7439] = 0x9bb5;
	__map_gbk2utf16[0x743a] = 0x9bb6;
	__map_gbk2utf16[0x743b] = 0x9bb7;
	__map_gbk2utf16[0x743c] = 0x9bb8;
	__map_gbk2utf16[0x743d] = 0x9bb9;
	__map_gbk2utf16[0x743e] = 0x9bba;
	__map_gbk2utf16[0x7440] = 0x9bbb;
	__map_gbk2utf16[0x7441] = 0x9bbc;
	__map_gbk2utf16[0x7442] = 0x9bbd;
	__map_gbk2utf16[0x7443] = 0x9bbe;
	__map_gbk2utf16[0x7444] = 0x9bbf;
	__map_gbk2utf16[0x7445] = 0x9bc0;
	__map_gbk2utf16[0x7446] = 0x9bc1;
	__map_gbk2utf16[0x7447] = 0x9bc2;
	__map_gbk2utf16[0x7448] = 0x9bc3;
	__map_gbk2utf16[0x7449] = 0x9bc4;
	__map_gbk2utf16[0x744a] = 0x9bc5;
	__map_gbk2utf16[0x744b] = 0x9bc6;
	__map_gbk2utf16[0x744c] = 0x9bc7;
	__map_gbk2utf16[0x744d] = 0x9bc8;
	__map_gbk2utf16[0x744e] = 0x9bc9;
	__map_gbk2utf16[0x744f] = 0x9bca;
	__map_gbk2utf16[0x7450] = 0x9bcb;
	__map_gbk2utf16[0x7451] = 0x9bcc;
	__map_gbk2utf16[0x7452] = 0x9bcd;
	__map_gbk2utf16[0x7453] = 0x9bce;
	__map_gbk2utf16[0x7454] = 0x9bcf;
	__map_gbk2utf16[0x7455] = 0x9bd0;
	__map_gbk2utf16[0x7456] = 0x9bd1;
	__map_gbk2utf16[0x7457] = 0x9bd2;
	__map_gbk2utf16[0x7458] = 0x9bd3;
	__map_gbk2utf16[0x7459] = 0x9bd4;
	__map_gbk2utf16[0x745a] = 0x9bd5;
	__map_gbk2utf16[0x745b] = 0x9bd6;
	__map_gbk2utf16[0x745c] = 0x9bd7;
	__map_gbk2utf16[0x745d] = 0x9bd8;
	__map_gbk2utf16[0x745e] = 0x9bd9;
	__map_gbk2utf16[0x745f] = 0x9bda;
	__map_gbk2utf16[0x7460] = 0x9bdb;
	__map_gbk2utf16[0x7461] = 0x9162;
	__map_gbk2utf16[0x7462] = 0x9161;
	__map_gbk2utf16[0x7463] = 0x9170;
	__map_gbk2utf16[0x7464] = 0x9169;
	__map_gbk2utf16[0x7465] = 0x916f;
	__map_gbk2utf16[0x7466] = 0x917d;
	__map_gbk2utf16[0x7467] = 0x917e;
	__map_gbk2utf16[0x7468] = 0x9172;
	__map_gbk2utf16[0x7469] = 0x9174;
	__map_gbk2utf16[0x746a] = 0x9179;
	__map_gbk2utf16[0x746b] = 0x918c;
	__map_gbk2utf16[0x746c] = 0x9185;
	__map_gbk2utf16[0x746d] = 0x9190;
	__map_gbk2utf16[0x746e] = 0x918d;
	__map_gbk2utf16[0x746f] = 0x9191;
	__map_gbk2utf16[0x7470] = 0x91a2;
	__map_gbk2utf16[0x7471] = 0x91a3;
	__map_gbk2utf16[0x7472] = 0x91aa;
	__map_gbk2utf16[0x7473] = 0x91ad;
	__map_gbk2utf16[0x7474] = 0x91ae;
	__map_gbk2utf16[0x7475] = 0x91af;
	__map_gbk2utf16[0x7476] = 0x91b5;
	__map_gbk2utf16[0x7477] = 0x91b4;
	__map_gbk2utf16[0x7478] = 0x91ba;
	__map_gbk2utf16[0x7479] = 0x8c55;
	__map_gbk2utf16[0x747a] = 0x9e7e;
	__map_gbk2utf16[0x747b] = 0x8db8;
	__map_gbk2utf16[0x747c] = 0x8deb;
	__map_gbk2utf16[0x747d] = 0x8e05;
	__map_gbk2utf16[0x747e] = 0x8e59;
	__map_gbk2utf16[0x747f] = 0x8e69;
	__map_gbk2utf16[0x7480] = 0x8db5;
	__map_gbk2utf16[0x7481] = 0x8dbf;
	__map_gbk2utf16[0x7482] = 0x8dbc;
	__map_gbk2utf16[0x7483] = 0x8dba;
	__map_gbk2utf16[0x7484] = 0x8dc4;
	__map_gbk2utf16[0x7485] = 0x8dd6;
	__map_gbk2utf16[0x7486] = 0x8dd7;
	__map_gbk2utf16[0x7487] = 0x8dda;
	__map_gbk2utf16[0x7488] = 0x8dde;
	__map_gbk2utf16[0x7489] = 0x8dce;
	__map_gbk2utf16[0x748a] = 0x8dcf;
	__map_gbk2utf16[0x748b] = 0x8ddb;
	__map_gbk2utf16[0x748c] = 0x8dc6;
	__map_gbk2utf16[0x748d] = 0x8dec;
	__map_gbk2utf16[0x748e] = 0x8df7;
	__map_gbk2utf16[0x748f] = 0x8df8;
	__map_gbk2utf16[0x7490] = 0x8de3;
	__map_gbk2utf16[0x7491] = 0x8df9;
	__map_gbk2utf16[0x7492] = 0x8dfb;
	__map_gbk2utf16[0x7493] = 0x8de4;
	__map_gbk2utf16[0x7494] = 0x8e09;
	__map_gbk2utf16[0x7495] = 0x8dfd;
	__map_gbk2utf16[0x7496] = 0x8e14;
	__map_gbk2utf16[0x7497] = 0x8e1d;
	__map_gbk2utf16[0x7498] = 0x8e1f;
	__map_gbk2utf16[0x7499] = 0x8e2c;
	__map_gbk2utf16[0x749a] = 0x8e2e;
	__map_gbk2utf16[0x749b] = 0x8e23;
	__map_gbk2utf16[0x749c] = 0x8e2f;
	__map_gbk2utf16[0x749d] = 0x8e3a;
	__map_gbk2utf16[0x749e] = 0x8e40;
	__map_gbk2utf16[0x749f] = 0x8e39;
	__map_gbk2utf16[0x74a0] = 0x8e35;
	__map_gbk2utf16[0x74a1] = 0x8e3d;
	__map_gbk2utf16[0x74a2] = 0x8e31;
	__map_gbk2utf16[0x74a3] = 0x8e49;
	__map_gbk2utf16[0x74a4] = 0x8e41;
	__map_gbk2utf16[0x74a5] = 0x8e42;
	__map_gbk2utf16[0x74a6] = 0x8e51;
	__map_gbk2utf16[0x74a7] = 0x8e52;
	__map_gbk2utf16[0x74a8] = 0x8e4a;
	__map_gbk2utf16[0x74a9] = 0x8e70;
	__map_gbk2utf16[0x74aa] = 0x8e76;
	__map_gbk2utf16[0x74ab] = 0x8e7c;
	__map_gbk2utf16[0x74ac] = 0x8e6f;
	__map_gbk2utf16[0x74ad] = 0x8e74;
	__map_gbk2utf16[0x74ae] = 0x8e85;
	__map_gbk2utf16[0x74af] = 0x8e8f;
	__map_gbk2utf16[0x74b0] = 0x8e94;
	__map_gbk2utf16[0x74b1] = 0x8e90;
	__map_gbk2utf16[0x74b2] = 0x8e9c;
	__map_gbk2utf16[0x74b3] = 0x8e9e;
	__map_gbk2utf16[0x74b4] = 0x8c78;
	__map_gbk2utf16[0x74b5] = 0x8c82;
	__map_gbk2utf16[0x74b6] = 0x8c8a;
	__map_gbk2utf16[0x74b7] = 0x8c85;
	__map_gbk2utf16[0x74b8] = 0x8c98;
	__map_gbk2utf16[0x74b9] = 0x8c94;
	__map_gbk2utf16[0x74ba] = 0x659b;
	__map_gbk2utf16[0x74bb] = 0x89d6;
	__map_gbk2utf16[0x74bc] = 0x89de;
	__map_gbk2utf16[0x74bd] = 0x89da;
	__map_gbk2utf16[0x74be] = 0x89dc;
	__map_gbk2utf16[0x7500] = 0x9bdc;
	__map_gbk2utf16[0x7501] = 0x9bdd;
	__map_gbk2utf16[0x7502] = 0x9bde;
	__map_gbk2utf16[0x7503] = 0x9bdf;
	__map_gbk2utf16[0x7504] = 0x9be0;
	__map_gbk2utf16[0x7505] = 0x9be1;
	__map_gbk2utf16[0x7506] = 0x9be2;
	__map_gbk2utf16[0x7507] = 0x9be3;
	__map_gbk2utf16[0x7508] = 0x9be4;
	__map_gbk2utf16[0x7509] = 0x9be5;
	__map_gbk2utf16[0x750a] = 0x9be6;
	__map_gbk2utf16[0x750b] = 0x9be7;
	__map_gbk2utf16[0x750c] = 0x9be8;
	__map_gbk2utf16[0x750d] = 0x9be9;
	__map_gbk2utf16[0x750e] = 0x9bea;
	__map_gbk2utf16[0x750f] = 0x9beb;
	__map_gbk2utf16[0x7510] = 0x9bec;
	__map_gbk2utf16[0x7511] = 0x9bed;
	__map_gbk2utf16[0x7512] = 0x9bee;
	__map_gbk2utf16[0x7513] = 0x9bef;
	__map_gbk2utf16[0x7514] = 0x9bf0;
	__map_gbk2utf16[0x7515] = 0x9bf1;
	__map_gbk2utf16[0x7516] = 0x9bf2;
	__map_gbk2utf16[0x7517] = 0x9bf3;
	__map_gbk2utf16[0x7518] = 0x9bf4;
	__map_gbk2utf16[0x7519] = 0x9bf5;
	__map_gbk2utf16[0x751a] = 0x9bf6;
	__map_gbk2utf16[0x751b] = 0x9bf7;
	__map_gbk2utf16[0x751c] = 0x9bf8;
	__map_gbk2utf16[0x751d] = 0x9bf9;
	__map_gbk2utf16[0x751e] = 0x9bfa;
	__map_gbk2utf16[0x751f] = 0x9bfb;
	__map_gbk2utf16[0x7520] = 0x9bfc;
	__map_gbk2utf16[0x7521] = 0x9bfd;
	__map_gbk2utf16[0x7522] = 0x9bfe;
	__map_gbk2utf16[0x7523] = 0x9bff;
	__map_gbk2utf16[0x7524] = 0x9c00;
	__map_gbk2utf16[0x7525] = 0x9c01;
	__map_gbk2utf16[0x7526] = 0x9c02;
	__map_gbk2utf16[0x7527] = 0x9c03;
	__map_gbk2utf16[0x7528] = 0x9c04;
	__map_gbk2utf16[0x7529] = 0x9c05;
	__map_gbk2utf16[0x752a] = 0x9c06;
	__map_gbk2utf16[0x752b] = 0x9c07;
	__map_gbk2utf16[0x752c] = 0x9c08;
	__map_gbk2utf16[0x752d] = 0x9c09;
	__map_gbk2utf16[0x752e] = 0x9c0a;
	__map_gbk2utf16[0x752f] = 0x9c0b;
	__map_gbk2utf16[0x7530] = 0x9c0c;
	__map_gbk2utf16[0x7531] = 0x9c0d;
	__map_gbk2utf16[0x7532] = 0x9c0e;
	__map_gbk2utf16[0x7533] = 0x9c0f;
	__map_gbk2utf16[0x7534] = 0x9c10;
	__map_gbk2utf16[0x7535] = 0x9c11;
	__map_gbk2utf16[0x7536] = 0x9c12;
	__map_gbk2utf16[0x7537] = 0x9c13;
	__map_gbk2utf16[0x7538] = 0x9c14;
	__map_gbk2utf16[0x7539] = 0x9c15;
	__map_gbk2utf16[0x753a] = 0x9c16;
	__map_gbk2utf16[0x753b] = 0x9c17;
	__map_gbk2utf16[0x753c] = 0x9c18;
	__map_gbk2utf16[0x753d] = 0x9c19;
	__map_gbk2utf16[0x753e] = 0x9c1a;
	__map_gbk2utf16[0x7540] = 0x9c1b;
	__map_gbk2utf16[0x7541] = 0x9c1c;
	__map_gbk2utf16[0x7542] = 0x9c1d;
	__map_gbk2utf16[0x7543] = 0x9c1e;
	__map_gbk2utf16[0x7544] = 0x9c1f;
	__map_gbk2utf16[0x7545] = 0x9c20;
	__map_gbk2utf16[0x7546] = 0x9c21;
	__map_gbk2utf16[0x7547] = 0x9c22;
	__map_gbk2utf16[0x7548] = 0x9c23;
	__map_gbk2utf16[0x7549] = 0x9c24;
	__map_gbk2utf16[0x754a] = 0x9c25;
	__map_gbk2utf16[0x754b] = 0x9c26;
	__map_gbk2utf16[0x754c] = 0x9c27;
	__map_gbk2utf16[0x754d] = 0x9c28;
	__map_gbk2utf16[0x754e] = 0x9c29;
	__map_gbk2utf16[0x754f] = 0x9c2a;
	__map_gbk2utf16[0x7550] = 0x9c2b;
	__map_gbk2utf16[0x7551] = 0x9c2c;
	__map_gbk2utf16[0x7552] = 0x9c2d;
	__map_gbk2utf16[0x7553] = 0x9c2e;
	__map_gbk2utf16[0x7554] = 0x9c2f;
	__map_gbk2utf16[0x7555] = 0x9c30;
	__map_gbk2utf16[0x7556] = 0x9c31;
	__map_gbk2utf16[0x7557] = 0x9c32;
	__map_gbk2utf16[0x7558] = 0x9c33;
	__map_gbk2utf16[0x7559] = 0x9c34;
	__map_gbk2utf16[0x755a] = 0x9c35;
	__map_gbk2utf16[0x755b] = 0x9c36;
	__map_gbk2utf16[0x755c] = 0x9c37;
	__map_gbk2utf16[0x755d] = 0x9c38;
	__map_gbk2utf16[0x755e] = 0x9c39;
	__map_gbk2utf16[0x755f] = 0x9c3a;
	__map_gbk2utf16[0x7560] = 0x9c3b;
	__map_gbk2utf16[0x7561] = 0x89e5;
	__map_gbk2utf16[0x7562] = 0x89eb;
	__map_gbk2utf16[0x7563] = 0x89ef;
	__map_gbk2utf16[0x7564] = 0x8a3e;
	__map_gbk2utf16[0x7565] = 0x8b26;
	__map_gbk2utf16[0x7566] = 0x9753;
	__map_gbk2utf16[0x7567] = 0x96e9;
	__map_gbk2utf16[0x7568] = 0x96f3;
	__map_gbk2utf16[0x7569] = 0x96ef;
	__map_gbk2utf16[0x756a] = 0x9706;
	__map_gbk2utf16[0x756b] = 0x9701;
	__map_gbk2utf16[0x756c] = 0x9708;
	__map_gbk2utf16[0x756d] = 0x970f;
	__map_gbk2utf16[0x756e] = 0x970e;
	__map_gbk2utf16[0x756f] = 0x972a;
	__map_gbk2utf16[0x7570] = 0x972d;
	__map_gbk2utf16[0x7571] = 0x9730;
	__map_gbk2utf16[0x7572] = 0x973e;
	__map_gbk2utf16[0x7573] = 0x9f80;
	__map_gbk2utf16[0x7574] = 0x9f83;
	__map_gbk2utf16[0x7575] = 0x9f85;
	__map_gbk2utf16[0x7576] = 0x9f86;
	__map_gbk2utf16[0x7577] = 0x9f87;
	__map_gbk2utf16[0x7578] = 0x9f88;
	__map_gbk2utf16[0x7579] = 0x9f89;
	__map_gbk2utf16[0x757a] = 0x9f8a;
	__map_gbk2utf16[0x757b] = 0x9f8c;
	__map_gbk2utf16[0x757c] = 0x9efe;
	__map_gbk2utf16[0x757d] = 0x9f0b;
	__map_gbk2utf16[0x757e] = 0x9f0d;
	__map_gbk2utf16[0x757f] = 0x96b9;
	__map_gbk2utf16[0x7580] = 0x96bc;
	__map_gbk2utf16[0x7581] = 0x96bd;
	__map_gbk2utf16[0x7582] = 0x96ce;
	__map_gbk2utf16[0x7583] = 0x96d2;
	__map_gbk2utf16[0x7584] = 0x77bf;
	__map_gbk2utf16[0x7585] = 0x96e0;
	__map_gbk2utf16[0x7586] = 0x928e;
	__map_gbk2utf16[0x7587] = 0x92ae;
	__map_gbk2utf16[0x7588] = 0x92c8;
	__map_gbk2utf16[0x7589] = 0x933e;
	__map_gbk2utf16[0x758a] = 0x936a;
	__map_gbk2utf16[0x758b] = 0x93ca;
	__map_gbk2utf16[0x758c] = 0x938f;
	__map_gbk2utf16[0x758d] = 0x943e;
	__map_gbk2utf16[0x758e] = 0x946b;
	__map_gbk2utf16[0x758f] = 0x9c7f;
	__map_gbk2utf16[0x7590] = 0x9c82;
	__map_gbk2utf16[0x7591] = 0x9c85;
	__map_gbk2utf16[0x7592] = 0x9c86;
	__map_gbk2utf16[0x7593] = 0x9c87;
	__map_gbk2utf16[0x7594] = 0x9c88;
	__map_gbk2utf16[0x7595] = 0x7a23;
	__map_gbk2utf16[0x7596] = 0x9c8b;
	__map_gbk2utf16[0x7597] = 0x9c8e;
	__map_gbk2utf16[0x7598] = 0x9c90;
	__map_gbk2utf16[0x7599] = 0x9c91;
	__map_gbk2utf16[0x759a] = 0x9c92;
	__map_gbk2utf16[0x759b] = 0x9c94;
	__map_gbk2utf16[0x759c] = 0x9c95;
	__map_gbk2utf16[0x759d] = 0x9c9a;
	__map_gbk2utf16[0x759e] = 0x9c9b;
	__map_gbk2utf16[0x759f] = 0x9c9e;
	__map_gbk2utf16[0x75a0] = 0x9c9f;
	__map_gbk2utf16[0x75a1] = 0x9ca0;
	__map_gbk2utf16[0x75a2] = 0x9ca1;
	__map_gbk2utf16[0x75a3] = 0x9ca2;
	__map_gbk2utf16[0x75a4] = 0x9ca3;
	__map_gbk2utf16[0x75a5] = 0x9ca5;
	__map_gbk2utf16[0x75a6] = 0x9ca6;
	__map_gbk2utf16[0x75a7] = 0x9ca7;
	__map_gbk2utf16[0x75a8] = 0x9ca8;
	__map_gbk2utf16[0x75a9] = 0x9ca9;
	__map_gbk2utf16[0x75aa] = 0x9cab;
	__map_gbk2utf16[0x75ab] = 0x9cad;
	__map_gbk2utf16[0x75ac] = 0x9cae;
	__map_gbk2utf16[0x75ad] = 0x9cb0;
	__map_gbk2utf16[0x75ae] = 0x9cb1;
	__map_gbk2utf16[0x75af] = 0x9cb2;
	__map_gbk2utf16[0x75b0] = 0x9cb3;
	__map_gbk2utf16[0x75b1] = 0x9cb4;
	__map_gbk2utf16[0x75b2] = 0x9cb5;
	__map_gbk2utf16[0x75b3] = 0x9cb6;
	__map_gbk2utf16[0x75b4] = 0x9cb7;
	__map_gbk2utf16[0x75b5] = 0x9cba;
	__map_gbk2utf16[0x75b6] = 0x9cbb;
	__map_gbk2utf16[0x75b7] = 0x9cbc;
	__map_gbk2utf16[0x75b8] = 0x9cbd;
	__map_gbk2utf16[0x75b9] = 0x9cc4;
	__map_gbk2utf16[0x75ba] = 0x9cc5;
	__map_gbk2utf16[0x75bb] = 0x9cc6;
	__map_gbk2utf16[0x75bc] = 0x9cc7;
	__map_gbk2utf16[0x75bd] = 0x9cca;
	__map_gbk2utf16[0x75be] = 0x9ccb;
	__map_gbk2utf16[0x7600] = 0x9c3c;
	__map_gbk2utf16[0x7601] = 0x9c3d;
	__map_gbk2utf16[0x7602] = 0x9c3e;
	__map_gbk2utf16[0x7603] = 0x9c3f;
	__map_gbk2utf16[0x7604] = 0x9c40;
	__map_gbk2utf16[0x7605] = 0x9c41;
	__map_gbk2utf16[0x7606] = 0x9c42;
	__map_gbk2utf16[0x7607] = 0x9c43;
	__map_gbk2utf16[0x7608] = 0x9c44;
	__map_gbk2utf16[0x7609] = 0x9c45;
	__map_gbk2utf16[0x760a] = 0x9c46;
	__map_gbk2utf16[0x760b] = 0x9c47;
	__map_gbk2utf16[0x760c] = 0x9c48;
	__map_gbk2utf16[0x760d] = 0x9c49;
	__map_gbk2utf16[0x760e] = 0x9c4a;
	__map_gbk2utf16[0x760f] = 0x9c4b;
	__map_gbk2utf16[0x7610] = 0x9c4c;
	__map_gbk2utf16[0x7611] = 0x9c4d;
	__map_gbk2utf16[0x7612] = 0x9c4e;
	__map_gbk2utf16[0x7613] = 0x9c4f;
	__map_gbk2utf16[0x7614] = 0x9c50;
	__map_gbk2utf16[0x7615] = 0x9c51;
	__map_gbk2utf16[0x7616] = 0x9c52;
	__map_gbk2utf16[0x7617] = 0x9c53;
	__map_gbk2utf16[0x7618] = 0x9c54;
	__map_gbk2utf16[0x7619] = 0x9c55;
	__map_gbk2utf16[0x761a] = 0x9c56;
	__map_gbk2utf16[0x761b] = 0x9c57;
	__map_gbk2utf16[0x761c] = 0x9c58;
	__map_gbk2utf16[0x761d] = 0x9c59;
	__map_gbk2utf16[0x761e] = 0x9c5a;
	__map_gbk2utf16[0x761f] = 0x9c5b;
	__map_gbk2utf16[0x7620] = 0x9c5c;
	__map_gbk2utf16[0x7621] = 0x9c5d;
	__map_gbk2utf16[0x7622] = 0x9c5e;
	__map_gbk2utf16[0x7623] = 0x9c5f;
	__map_gbk2utf16[0x7624] = 0x9c60;
	__map_gbk2utf16[0x7625] = 0x9c61;
	__map_gbk2utf16[0x7626] = 0x9c62;
	__map_gbk2utf16[0x7627] = 0x9c63;
	__map_gbk2utf16[0x7628] = 0x9c64;
	__map_gbk2utf16[0x7629] = 0x9c65;
	__map_gbk2utf16[0x762a] = 0x9c66;
	__map_gbk2utf16[0x762b] = 0x9c67;
	__map_gbk2utf16[0x762c] = 0x9c68;
	__map_gbk2utf16[0x762d] = 0x9c69;
	__map_gbk2utf16[0x762e] = 0x9c6a;
	__map_gbk2utf16[0x762f] = 0x9c6b;
	__map_gbk2utf16[0x7630] = 0x9c6c;
	__map_gbk2utf16[0x7631] = 0x9c6d;
	__map_gbk2utf16[0x7632] = 0x9c6e;
	__map_gbk2utf16[0x7633] = 0x9c6f;
	__map_gbk2utf16[0x7634] = 0x9c70;
	__map_gbk2utf16[0x7635] = 0x9c71;
	__map_gbk2utf16[0x7636] = 0x9c72;
	__map_gbk2utf16[0x7637] = 0x9c73;
	__map_gbk2utf16[0x7638] = 0x9c74;
	__map_gbk2utf16[0x7639] = 0x9c75;
	__map_gbk2utf16[0x763a] = 0x9c76;
	__map_gbk2utf16[0x763b] = 0x9c77;
	__map_gbk2utf16[0x763c] = 0x9c78;
	__map_gbk2utf16[0x763d] = 0x9c79;
	__map_gbk2utf16[0x763e] = 0x9c7a;
	__map_gbk2utf16[0x7640] = 0x9c7b;
	__map_gbk2utf16[0x7641] = 0x9c7d;
	__map_gbk2utf16[0x7642] = 0x9c7e;
	__map_gbk2utf16[0x7643] = 0x9c80;
	__map_gbk2utf16[0x7644] = 0x9c83;
	__map_gbk2utf16[0x7645] = 0x9c84;
	__map_gbk2utf16[0x7646] = 0x9c89;
	__map_gbk2utf16[0x7647] = 0x9c8a;
	__map_gbk2utf16[0x7648] = 0x9c8c;
	__map_gbk2utf16[0x7649] = 0x9c8f;
	__map_gbk2utf16[0x764a] = 0x9c93;
	__map_gbk2utf16[0x764b] = 0x9c96;
	__map_gbk2utf16[0x764c] = 0x9c97;
	__map_gbk2utf16[0x764d] = 0x9c98;
	__map_gbk2utf16[0x764e] = 0x9c99;
	__map_gbk2utf16[0x764f] = 0x9c9d;
	__map_gbk2utf16[0x7650] = 0x9caa;
	__map_gbk2utf16[0x7651] = 0x9cac;
	__map_gbk2utf16[0x7652] = 0x9caf;
	__map_gbk2utf16[0x7653] = 0x9cb9;
	__map_gbk2utf16[0x7654] = 0x9cbe;
	__map_gbk2utf16[0x7655] = 0x9cbf;
	__map_gbk2utf16[0x7656] = 0x9cc0;
	__map_gbk2utf16[0x7657] = 0x9cc1;
	__map_gbk2utf16[0x7658] = 0x9cc2;
	__map_gbk2utf16[0x7659] = 0x9cc8;
	__map_gbk2utf16[0x765a] = 0x9cc9;
	__map_gbk2utf16[0x765b] = 0x9cd1;
	__map_gbk2utf16[0x765c] = 0x9cd2;
	__map_gbk2utf16[0x765d] = 0x9cda;
	__map_gbk2utf16[0x765e] = 0x9cdb;
	__map_gbk2utf16[0x765f] = 0x9ce0;
	__map_gbk2utf16[0x7660] = 0x9ce1;
	__map_gbk2utf16[0x7661] = 0x9ccc;
	__map_gbk2utf16[0x7662] = 0x9ccd;
	__map_gbk2utf16[0x7663] = 0x9cce;
	__map_gbk2utf16[0x7664] = 0x9ccf;
	__map_gbk2utf16[0x7665] = 0x9cd0;
	__map_gbk2utf16[0x7666] = 0x9cd3;
	__map_gbk2utf16[0x7667] = 0x9cd4;
	__map_gbk2utf16[0x7668] = 0x9cd5;
	__map_gbk2utf16[0x7669] = 0x9cd7;
	__map_gbk2utf16[0x766a] = 0x9cd8;
	__map_gbk2utf16[0x766b] = 0x9cd9;
	__map_gbk2utf16[0x766c] = 0x9cdc;
	__map_gbk2utf16[0x766d] = 0x9cdd;
	__map_gbk2utf16[0x766e] = 0x9cdf;
	__map_gbk2utf16[0x766f] = 0x9ce2;
	__map_gbk2utf16[0x7670] = 0x977c;
	__map_gbk2utf16[0x7671] = 0x9785;
	__map_gbk2utf16[0x7672] = 0x9791;
	__map_gbk2utf16[0x7673] = 0x9792;
	__map_gbk2utf16[0x7674] = 0x9794;
	__map_gbk2utf16[0x7675] = 0x97af;
	__map_gbk2utf16[0x7676] = 0x97ab;
	__map_gbk2utf16[0x7677] = 0x97a3;
	__map_gbk2utf16[0x7678] = 0x97b2;
	__map_gbk2utf16[0x7679] = 0x97b4;
	__map_gbk2utf16[0x767a] = 0x9ab1;
	__map_gbk2utf16[0x767b] = 0x9ab0;
	__map_gbk2utf16[0x767c] = 0x9ab7;
	__map_gbk2utf16[0x767d] = 0x9e58;
	__map_gbk2utf16[0x767e] = 0x9ab6;
	__map_gbk2utf16[0x767f] = 0x9aba;
	__map_gbk2utf16[0x7680] = 0x9abc;
	__map_gbk2utf16[0x7681] = 0x9ac1;
	__map_gbk2utf16[0x7682] = 0x9ac0;
	__map_gbk2utf16[0x7683] = 0x9ac5;
	__map_gbk2utf16[0x7684] = 0x9ac2;
	__map_gbk2utf16[0x7685] = 0x9acb;
	__map_gbk2utf16[0x7686] = 0x9acc;
	__map_gbk2utf16[0x7687] = 0x9ad1;
	__map_gbk2utf16[0x7688] = 0x9b45;
	__map_gbk2utf16[0x7689] = 0x9b43;
	__map_gbk2utf16[0x768a] = 0x9b47;
	__map_gbk2utf16[0x768b] = 0x9b49;
	__map_gbk2utf16[0x768c] = 0x9b48;
	__map_gbk2utf16[0x768d] = 0x9b4d;
	__map_gbk2utf16[0x768e] = 0x9b51;
	__map_gbk2utf16[0x768f] = 0x98e8;
	__map_gbk2utf16[0x7690] = 0x990d;
	__map_gbk2utf16[0x7691] = 0x992e;
	__map_gbk2utf16[0x7692] = 0x9955;
	__map_gbk2utf16[0x7693] = 0x9954;
	__map_gbk2utf16[0x7694] = 0x9adf;
	__map_gbk2utf16[0x7695] = 0x9ae1;
	__map_gbk2utf16[0x7696] = 0x9ae6;
	__map_gbk2utf16[0x7697] = 0x9aef;
	__map_gbk2utf16[0x7698] = 0x9aeb;
	__map_gbk2utf16[0x7699] = 0x9afb;
	__map_gbk2utf16[0x769a] = 0x9aed;
	__map_gbk2utf16[0x769b] = 0x9af9;
	__map_gbk2utf16[0x769c] = 0x9b08;
	__map_gbk2utf16[0x769d] = 0x9b0f;
	__map_gbk2utf16[0x769e] = 0x9b13;
	__map_gbk2utf16[0x769f] = 0x9b1f;
	__map_gbk2utf16[0x76a0] = 0x9b23;
	__map_gbk2utf16[0x76a1] = 0x9ebd;
	__map_gbk2utf16[0x76a2] = 0x9ebe;
	__map_gbk2utf16[0x76a3] = 0x7e3b;
	__map_gbk2utf16[0x76a4] = 0x9e82;
	__map_gbk2utf16[0x76a5] = 0x9e87;
	__map_gbk2utf16[0x76a6] = 0x9e88;
	__map_gbk2utf16[0x76a7] = 0x9e8b;
	__map_gbk2utf16[0x76a8] = 0x9e92;
	__map_gbk2utf16[0x76a9] = 0x93d6;
	__map_gbk2utf16[0x76aa] = 0x9e9d;
	__map_gbk2utf16[0x76ab] = 0x9e9f;
	__map_gbk2utf16[0x76ac] = 0x9edb;
	__map_gbk2utf16[0x76ad] = 0x9edc;
	__map_gbk2utf16[0x76ae] = 0x9edd;
	__map_gbk2utf16[0x76af] = 0x9ee0;
	__map_gbk2utf16[0x76b0] = 0x9edf;
	__map_gbk2utf16[0x76b1] = 0x9ee2;
	__map_gbk2utf16[0x76b2] = 0x9ee9;
	__map_gbk2utf16[0x76b3] = 0x9ee7;
	__map_gbk2utf16[0x76b4] = 0x9ee5;
	__map_gbk2utf16[0x76b5] = 0x9eea;
	__map_gbk2utf16[0x76b6] = 0x9eef;
	__map_gbk2utf16[0x76b7] = 0x9f22;
	__map_gbk2utf16[0x76b8] = 0x9f2c;
	__map_gbk2utf16[0x76b9] = 0x9f2f;
	__map_gbk2utf16[0x76ba] = 0x9f39;
	__map_gbk2utf16[0x76bb] = 0x9f37;
	__map_gbk2utf16[0x76bc] = 0x9f3d;
	__map_gbk2utf16[0x76bd] = 0x9f3e;
	__map_gbk2utf16[0x76be] = 0x9f44;
	__map_gbk2utf16[0x7700] = 0x9ce3;
	__map_gbk2utf16[0x7701] = 0x9ce4;
	__map_gbk2utf16[0x7702] = 0x9ce5;
	__map_gbk2utf16[0x7703] = 0x9ce6;
	__map_gbk2utf16[0x7704] = 0x9ce7;
	__map_gbk2utf16[0x7705] = 0x9ce8;
	__map_gbk2utf16[0x7706] = 0x9ce9;
	__map_gbk2utf16[0x7707] = 0x9cea;
	__map_gbk2utf16[0x7708] = 0x9ceb;
	__map_gbk2utf16[0x7709] = 0x9cec;
	__map_gbk2utf16[0x770a] = 0x9ced;
	__map_gbk2utf16[0x770b] = 0x9cee;
	__map_gbk2utf16[0x770c] = 0x9cef;
	__map_gbk2utf16[0x770d] = 0x9cf0;
	__map_gbk2utf16[0x770e] = 0x9cf1;
	__map_gbk2utf16[0x770f] = 0x9cf2;
	__map_gbk2utf16[0x7710] = 0x9cf3;
	__map_gbk2utf16[0x7711] = 0x9cf4;
	__map_gbk2utf16[0x7712] = 0x9cf5;
	__map_gbk2utf16[0x7713] = 0x9cf6;
	__map_gbk2utf16[0x7714] = 0x9cf7;
	__map_gbk2utf16[0x7715] = 0x9cf8;
	__map_gbk2utf16[0x7716] = 0x9cf9;
	__map_gbk2utf16[0x7717] = 0x9cfa;
	__map_gbk2utf16[0x7718] = 0x9cfb;
	__map_gbk2utf16[0x7719] = 0x9cfc;
	__map_gbk2utf16[0x771a] = 0x9cfd;
	__map_gbk2utf16[0x771b] = 0x9cfe;
	__map_gbk2utf16[0x771c] = 0x9cff;
	__map_gbk2utf16[0x771d] = 0x9d00;
	__map_gbk2utf16[0x771e] = 0x9d01;
	__map_gbk2utf16[0x771f] = 0x9d02;
	__map_gbk2utf16[0x7720] = 0x9d03;
	__map_gbk2utf16[0x7721] = 0x9d04;
	__map_gbk2utf16[0x7722] = 0x9d05;
	__map_gbk2utf16[0x7723] = 0x9d06;
	__map_gbk2utf16[0x7724] = 0x9d07;
	__map_gbk2utf16[0x7725] = 0x9d08;
	__map_gbk2utf16[0x7726] = 0x9d09;
	__map_gbk2utf16[0x7727] = 0x9d0a;
	__map_gbk2utf16[0x7728] = 0x9d0b;
	__map_gbk2utf16[0x7729] = 0x9d0c;
	__map_gbk2utf16[0x772a] = 0x9d0d;
	__map_gbk2utf16[0x772b] = 0x9d0e;
	__map_gbk2utf16[0x772c] = 0x9d0f;
	__map_gbk2utf16[0x772d] = 0x9d10;
	__map_gbk2utf16[0x772e] = 0x9d11;
	__map_gbk2utf16[0x772f] = 0x9d12;
	__map_gbk2utf16[0x7730] = 0x9d13;
	__map_gbk2utf16[0x7731] = 0x9d14;
	__map_gbk2utf16[0x7732] = 0x9d15;
	__map_gbk2utf16[0x7733] = 0x9d16;
	__map_gbk2utf16[0x7734] = 0x9d17;
	__map_gbk2utf16[0x7735] = 0x9d18;
	__map_gbk2utf16[0x7736] = 0x9d19;
	__map_gbk2utf16[0x7737] = 0x9d1a;
	__map_gbk2utf16[0x7738] = 0x9d1b;
	__map_gbk2utf16[0x7739] = 0x9d1c;
	__map_gbk2utf16[0x773a] = 0x9d1d;
	__map_gbk2utf16[0x773b] = 0x9d1e;
	__map_gbk2utf16[0x773c] = 0x9d1f;
	__map_gbk2utf16[0x773d] = 0x9d20;
	__map_gbk2utf16[0x773e] = 0x9d21;
	__map_gbk2utf16[0x7740] = 0x9d22;
	__map_gbk2utf16[0x7741] = 0x9d23;
	__map_gbk2utf16[0x7742] = 0x9d24;
	__map_gbk2utf16[0x7743] = 0x9d25;
	__map_gbk2utf16[0x7744] = 0x9d26;
	__map_gbk2utf16[0x7745] = 0x9d27;
	__map_gbk2utf16[0x7746] = 0x9d28;
	__map_gbk2utf16[0x7747] = 0x9d29;
	__map_gbk2utf16[0x7748] = 0x9d2a;
	__map_gbk2utf16[0x7749] = 0x9d2b;
	__map_gbk2utf16[0x774a] = 0x9d2c;
	__map_gbk2utf16[0x774b] = 0x9d2d;
	__map_gbk2utf16[0x774c] = 0x9d2e;
	__map_gbk2utf16[0x774d] = 0x9d2f;
	__map_gbk2utf16[0x774e] = 0x9d30;
	__map_gbk2utf16[0x774f] = 0x9d31;
	__map_gbk2utf16[0x7750] = 0x9d32;
	__map_gbk2utf16[0x7751] = 0x9d33;
	__map_gbk2utf16[0x7752] = 0x9d34;
	__map_gbk2utf16[0x7753] = 0x9d35;
	__map_gbk2utf16[0x7754] = 0x9d36;
	__map_gbk2utf16[0x7755] = 0x9d37;
	__map_gbk2utf16[0x7756] = 0x9d38;
	__map_gbk2utf16[0x7757] = 0x9d39;
	__map_gbk2utf16[0x7758] = 0x9d3a;
	__map_gbk2utf16[0x7759] = 0x9d3b;
	__map_gbk2utf16[0x775a] = 0x9d3c;
	__map_gbk2utf16[0x775b] = 0x9d3d;
	__map_gbk2utf16[0x775c] = 0x9d3e;
	__map_gbk2utf16[0x775d] = 0x9d3f;
	__map_gbk2utf16[0x775e] = 0x9d40;
	__map_gbk2utf16[0x775f] = 0x9d41;
	__map_gbk2utf16[0x7760] = 0x9d42;
	__map_gbk2utf16[0x7761] = 0xe234;
	__map_gbk2utf16[0x7762] = 0xe235;
	__map_gbk2utf16[0x7763] = 0xe236;
	__map_gbk2utf16[0x7764] = 0xe237;
	__map_gbk2utf16[0x7765] = 0xe238;
	__map_gbk2utf16[0x7766] = 0xe239;
	__map_gbk2utf16[0x7767] = 0xe23a;
	__map_gbk2utf16[0x7768] = 0xe23b;
	__map_gbk2utf16[0x7769] = 0xe23c;
	__map_gbk2utf16[0x776a] = 0xe23d;
	__map_gbk2utf16[0x776b] = 0xe23e;
	__map_gbk2utf16[0x776c] = 0xe23f;
	__map_gbk2utf16[0x776d] = 0xe240;
	__map_gbk2utf16[0x776e] = 0xe241;
	__map_gbk2utf16[0x776f] = 0xe242;
	__map_gbk2utf16[0x7770] = 0xe243;
	__map_gbk2utf16[0x7771] = 0xe244;
	__map_gbk2utf16[0x7772] = 0xe245;
	__map_gbk2utf16[0x7773] = 0xe246;
	__map_gbk2utf16[0x7774] = 0xe247;
	__map_gbk2utf16[0x7775] = 0xe248;
	__map_gbk2utf16[0x7776] = 0xe249;
	__map_gbk2utf16[0x7777] = 0xe24a;
	__map_gbk2utf16[0x7778] = 0xe24b;
	__map_gbk2utf16[0x7779] = 0xe24c;
	__map_gbk2utf16[0x777a] = 0xe24d;
	__map_gbk2utf16[0x777b] = 0xe24e;
	__map_gbk2utf16[0x777c] = 0xe24f;
	__map_gbk2utf16[0x777d] = 0xe250;
	__map_gbk2utf16[0x777e] = 0xe251;
	__map_gbk2utf16[0x777f] = 0xe252;
	__map_gbk2utf16[0x7780] = 0xe253;
	__map_gbk2utf16[0x7781] = 0xe254;
	__map_gbk2utf16[0x7782] = 0xe255;
	__map_gbk2utf16[0x7783] = 0xe256;
	__map_gbk2utf16[0x7784] = 0xe257;
	__map_gbk2utf16[0x7785] = 0xe258;
	__map_gbk2utf16[0x7786] = 0xe259;
	__map_gbk2utf16[0x7787] = 0xe25a;
	__map_gbk2utf16[0x7788] = 0xe25b;
	__map_gbk2utf16[0x7789] = 0xe25c;
	__map_gbk2utf16[0x778a] = 0xe25d;
	__map_gbk2utf16[0x778b] = 0xe25e;
	__map_gbk2utf16[0x778c] = 0xe25f;
	__map_gbk2utf16[0x778d] = 0xe260;
	__map_gbk2utf16[0x778e] = 0xe261;
	__map_gbk2utf16[0x778f] = 0xe262;
	__map_gbk2utf16[0x7790] = 0xe263;
	__map_gbk2utf16[0x7791] = 0xe264;
	__map_gbk2utf16[0x7792] = 0xe265;
	__map_gbk2utf16[0x7793] = 0xe266;
	__map_gbk2utf16[0x7794] = 0xe267;
	__map_gbk2utf16[0x7795] = 0xe268;
	__map_gbk2utf16[0x7796] = 0xe269;
	__map_gbk2utf16[0x7797] = 0xe26a;
	__map_gbk2utf16[0x7798] = 0xe26b;
	__map_gbk2utf16[0x7799] = 0xe26c;
	__map_gbk2utf16[0x779a] = 0xe26d;
	__map_gbk2utf16[0x779b] = 0xe26e;
	__map_gbk2utf16[0x779c] = 0xe26f;
	__map_gbk2utf16[0x779d] = 0xe270;
	__map_gbk2utf16[0x779e] = 0xe271;
	__map_gbk2utf16[0x779f] = 0xe272;
	__map_gbk2utf16[0x77a0] = 0xe273;
	__map_gbk2utf16[0x77a1] = 0xe274;
	__map_gbk2utf16[0x77a2] = 0xe275;
	__map_gbk2utf16[0x77a3] = 0xe276;
	__map_gbk2utf16[0x77a4] = 0xe277;
	__map_gbk2utf16[0x77a5] = 0xe278;
	__map_gbk2utf16[0x77a6] = 0xe279;
	__map_gbk2utf16[0x77a7] = 0xe27a;
	__map_gbk2utf16[0x77a8] = 0xe27b;
	__map_gbk2utf16[0x77a9] = 0xe27c;
	__map_gbk2utf16[0x77aa] = 0xe27d;
	__map_gbk2utf16[0x77ab] = 0xe27e;
	__map_gbk2utf16[0x77ac] = 0xe27f;
	__map_gbk2utf16[0x77ad] = 0xe280;
	__map_gbk2utf16[0x77ae] = 0xe281;
	__map_gbk2utf16[0x77af] = 0xe282;
	__map_gbk2utf16[0x77b0] = 0xe283;
	__map_gbk2utf16[0x77b1] = 0xe284;
	__map_gbk2utf16[0x77b2] = 0xe285;
	__map_gbk2utf16[0x77b3] = 0xe286;
	__map_gbk2utf16[0x77b4] = 0xe287;
	__map_gbk2utf16[0x77b5] = 0xe288;
	__map_gbk2utf16[0x77b6] = 0xe289;
	__map_gbk2utf16[0x77b7] = 0xe28a;
	__map_gbk2utf16[0x77b8] = 0xe28b;
	__map_gbk2utf16[0x77b9] = 0xe28c;
	__map_gbk2utf16[0x77ba] = 0xe28d;
	__map_gbk2utf16[0x77bb] = 0xe28e;
	__map_gbk2utf16[0x77bc] = 0xe28f;
	__map_gbk2utf16[0x77bd] = 0xe290;
	__map_gbk2utf16[0x77be] = 0xe291;
	__map_gbk2utf16[0x7800] = 0x9d43;
	__map_gbk2utf16[0x7801] = 0x9d44;
	__map_gbk2utf16[0x7802] = 0x9d45;
	__map_gbk2utf16[0x7803] = 0x9d46;
	__map_gbk2utf16[0x7804] = 0x9d47;
	__map_gbk2utf16[0x7805] = 0x9d48;
	__map_gbk2utf16[0x7806] = 0x9d49;
	__map_gbk2utf16[0x7807] = 0x9d4a;
	__map_gbk2utf16[0x7808] = 0x9d4b;
	__map_gbk2utf16[0x7809] = 0x9d4c;
	__map_gbk2utf16[0x780a] = 0x9d4d;
	__map_gbk2utf16[0x780b] = 0x9d4e;
	__map_gbk2utf16[0x780c] = 0x9d4f;
	__map_gbk2utf16[0x780d] = 0x9d50;
	__map_gbk2utf16[0x780e] = 0x9d51;
	__map_gbk2utf16[0x780f] = 0x9d52;
	__map_gbk2utf16[0x7810] = 0x9d53;
	__map_gbk2utf16[0x7811] = 0x9d54;
	__map_gbk2utf16[0x7812] = 0x9d55;
	__map_gbk2utf16[0x7813] = 0x9d56;
	__map_gbk2utf16[0x7814] = 0x9d57;
	__map_gbk2utf16[0x7815] = 0x9d58;
	__map_gbk2utf16[0x7816] = 0x9d59;
	__map_gbk2utf16[0x7817] = 0x9d5a;
	__map_gbk2utf16[0x7818] = 0x9d5b;
	__map_gbk2utf16[0x7819] = 0x9d5c;
	__map_gbk2utf16[0x781a] = 0x9d5d;
	__map_gbk2utf16[0x781b] = 0x9d5e;
	__map_gbk2utf16[0x781c] = 0x9d5f;
	__map_gbk2utf16[0x781d] = 0x9d60;
	__map_gbk2utf16[0x781e] = 0x9d61;
	__map_gbk2utf16[0x781f] = 0x9d62;
	__map_gbk2utf16[0x7820] = 0x9d63;
	__map_gbk2utf16[0x7821] = 0x9d64;
	__map_gbk2utf16[0x7822] = 0x9d65;
	__map_gbk2utf16[0x7823] = 0x9d66;
	__map_gbk2utf16[0x7824] = 0x9d67;
	__map_gbk2utf16[0x7825] = 0x9d68;
	__map_gbk2utf16[0x7826] = 0x9d69;
	__map_gbk2utf16[0x7827] = 0x9d6a;
	__map_gbk2utf16[0x7828] = 0x9d6b;
	__map_gbk2utf16[0x7829] = 0x9d6c;
	__map_gbk2utf16[0x782a] = 0x9d6d;
	__map_gbk2utf16[0x782b] = 0x9d6e;
	__map_gbk2utf16[0x782c] = 0x9d6f;
	__map_gbk2utf16[0x782d] = 0x9d70;
	__map_gbk2utf16[0x782e] = 0x9d71;
	__map_gbk2utf16[0x782f] = 0x9d72;
	__map_gbk2utf16[0x7830] = 0x9d73;
	__map_gbk2utf16[0x7831] = 0x9d74;
	__map_gbk2utf16[0x7832] = 0x9d75;
	__map_gbk2utf16[0x7833] = 0x9d76;
	__map_gbk2utf16[0x7834] = 0x9d77;
	__map_gbk2utf16[0x7835] = 0x9d78;
	__map_gbk2utf16[0x7836] = 0x9d79;
	__map_gbk2utf16[0x7837] = 0x9d7a;
	__map_gbk2utf16[0x7838] = 0x9d7b;
	__map_gbk2utf16[0x7839] = 0x9d7c;
	__map_gbk2utf16[0x783a] = 0x9d7d;
	__map_gbk2utf16[0x783b] = 0x9d7e;
	__map_gbk2utf16[0x783c] = 0x9d7f;
	__map_gbk2utf16[0x783d] = 0x9d80;
	__map_gbk2utf16[0x783e] = 0x9d81;
	__map_gbk2utf16[0x7840] = 0x9d82;
	__map_gbk2utf16[0x7841] = 0x9d83;
	__map_gbk2utf16[0x7842] = 0x9d84;
	__map_gbk2utf16[0x7843] = 0x9d85;
	__map_gbk2utf16[0x7844] = 0x9d86;
	__map_gbk2utf16[0x7845] = 0x9d87;
	__map_gbk2utf16[0x7846] = 0x9d88;
	__map_gbk2utf16[0x7847] = 0x9d89;
	__map_gbk2utf16[0x7848] = 0x9d8a;
	__map_gbk2utf16[0x7849] = 0x9d8b;
	__map_gbk2utf16[0x784a] = 0x9d8c;
	__map_gbk2utf16[0x784b] = 0x9d8d;
	__map_gbk2utf16[0x784c] = 0x9d8e;
	__map_gbk2utf16[0x784d] = 0x9d8f;
	__map_gbk2utf16[0x784e] = 0x9d90;
	__map_gbk2utf16[0x784f] = 0x9d91;
	__map_gbk2utf16[0x7850] = 0x9d92;
	__map_gbk2utf16[0x7851] = 0x9d93;
	__map_gbk2utf16[0x7852] = 0x9d94;
	__map_gbk2utf16[0x7853] = 0x9d95;
	__map_gbk2utf16[0x7854] = 0x9d96;
	__map_gbk2utf16[0x7855] = 0x9d97;
	__map_gbk2utf16[0x7856] = 0x9d98;
	__map_gbk2utf16[0x7857] = 0x9d99;
	__map_gbk2utf16[0x7858] = 0x9d9a;
	__map_gbk2utf16[0x7859] = 0x9d9b;
	__map_gbk2utf16[0x785a] = 0x9d9c;
	__map_gbk2utf16[0x785b] = 0x9d9d;
	__map_gbk2utf16[0x785c] = 0x9d9e;
	__map_gbk2utf16[0x785d] = 0x9d9f;
	__map_gbk2utf16[0x785e] = 0x9da0;
	__map_gbk2utf16[0x785f] = 0x9da1;
	__map_gbk2utf16[0x7860] = 0x9da2;
	__map_gbk2utf16[0x7861] = 0xe292;
	__map_gbk2utf16[0x7862] = 0xe293;
	__map_gbk2utf16[0x7863] = 0xe294;
	__map_gbk2utf16[0x7864] = 0xe295;
	__map_gbk2utf16[0x7865] = 0xe296;
	__map_gbk2utf16[0x7866] = 0xe297;
	__map_gbk2utf16[0x7867] = 0xe298;
	__map_gbk2utf16[0x7868] = 0xe299;
	__map_gbk2utf16[0x7869] = 0xe29a;
	__map_gbk2utf16[0x786a] = 0xe29b;
	__map_gbk2utf16[0x786b] = 0xe29c;
	__map_gbk2utf16[0x786c] = 0xe29d;
	__map_gbk2utf16[0x786d] = 0xe29e;
	__map_gbk2utf16[0x786e] = 0xe29f;
	__map_gbk2utf16[0x786f] = 0xe2a0;
	__map_gbk2utf16[0x7870] = 0xe2a1;
	__map_gbk2utf16[0x7871] = 0xe2a2;
	__map_gbk2utf16[0x7872] = 0xe2a3;
	__map_gbk2utf16[0x7873] = 0xe2a4;
	__map_gbk2utf16[0x7874] = 0xe2a5;
	__map_gbk2utf16[0x7875] = 0xe2a6;
	__map_gbk2utf16[0x7876] = 0xe2a7;
	__map_gbk2utf16[0x7877] = 0xe2a8;
	__map_gbk2utf16[0x7878] = 0xe2a9;
	__map_gbk2utf16[0x7879] = 0xe2aa;
	__map_gbk2utf16[0x787a] = 0xe2ab;
	__map_gbk2utf16[0x787b] = 0xe2ac;
	__map_gbk2utf16[0x787c] = 0xe2ad;
	__map_gbk2utf16[0x787d] = 0xe2ae;
	__map_gbk2utf16[0x787e] = 0xe2af;
	__map_gbk2utf16[0x787f] = 0xe2b0;
	__map_gbk2utf16[0x7880] = 0xe2b1;
	__map_gbk2utf16[0x7881] = 0xe2b2;
	__map_gbk2utf16[0x7882] = 0xe2b3;
	__map_gbk2utf16[0x7883] = 0xe2b4;
	__map_gbk2utf16[0x7884] = 0xe2b5;
	__map_gbk2utf16[0x7885] = 0xe2b6;
	__map_gbk2utf16[0x7886] = 0xe2b7;
	__map_gbk2utf16[0x7887] = 0xe2b8;
	__map_gbk2utf16[0x7888] = 0xe2b9;
	__map_gbk2utf16[0x7889] = 0xe2ba;
	__map_gbk2utf16[0x788a] = 0xe2bb;
	__map_gbk2utf16[0x788b] = 0xe2bc;
	__map_gbk2utf16[0x788c] = 0xe2bd;
	__map_gbk2utf16[0x788d] = 0xe2be;
	__map_gbk2utf16[0x788e] = 0xe2bf;
	__map_gbk2utf16[0x788f] = 0xe2c0;
	__map_gbk2utf16[0x7890] = 0xe2c1;
	__map_gbk2utf16[0x7891] = 0xe2c2;
	__map_gbk2utf16[0x7892] = 0xe2c3;
	__map_gbk2utf16[0x7893] = 0xe2c4;
	__map_gbk2utf16[0x7894] = 0xe2c5;
	__map_gbk2utf16[0x7895] = 0xe2c6;
	__map_gbk2utf16[0x7896] = 0xe2c7;
	__map_gbk2utf16[0x7897] = 0xe2c8;
	__map_gbk2utf16[0x7898] = 0xe2c9;
	__map_gbk2utf16[0x7899] = 0xe2ca;
	__map_gbk2utf16[0x789a] = 0xe2cb;
	__map_gbk2utf16[0x789b] = 0xe2cc;
	__map_gbk2utf16[0x789c] = 0xe2cd;
	__map_gbk2utf16[0x789d] = 0xe2ce;
	__map_gbk2utf16[0x789e] = 0xe2cf;
	__map_gbk2utf16[0x789f] = 0xe2d0;
	__map_gbk2utf16[0x78a0] = 0xe2d1;
	__map_gbk2utf16[0x78a1] = 0xe2d2;
	__map_gbk2utf16[0x78a2] = 0xe2d3;
	__map_gbk2utf16[0x78a3] = 0xe2d4;
	__map_gbk2utf16[0x78a4] = 0xe2d5;
	__map_gbk2utf16[0x78a5] = 0xe2d6;
	__map_gbk2utf16[0x78a6] = 0xe2d7;
	__map_gbk2utf16[0x78a7] = 0xe2d8;
	__map_gbk2utf16[0x78a8] = 0xe2d9;
	__map_gbk2utf16[0x78a9] = 0xe2da;
	__map_gbk2utf16[0x78aa] = 0xe2db;
	__map_gbk2utf16[0x78ab] = 0xe2dc;
	__map_gbk2utf16[0x78ac] = 0xe2dd;
	__map_gbk2utf16[0x78ad] = 0xe2de;
	__map_gbk2utf16[0x78ae] = 0xe2df;
	__map_gbk2utf16[0x78af] = 0xe2e0;
	__map_gbk2utf16[0x78b0] = 0xe2e1;
	__map_gbk2utf16[0x78b1] = 0xe2e2;
	__map_gbk2utf16[0x78b2] = 0xe2e3;
	__map_gbk2utf16[0x78b3] = 0xe2e4;
	__map_gbk2utf16[0x78b4] = 0xe2e5;
	__map_gbk2utf16[0x78b5] = 0xe2e6;
	__map_gbk2utf16[0x78b6] = 0xe2e7;
	__map_gbk2utf16[0x78b7] = 0xe2e8;
	__map_gbk2utf16[0x78b8] = 0xe2e9;
	__map_gbk2utf16[0x78b9] = 0xe2ea;
	__map_gbk2utf16[0x78ba] = 0xe2eb;
	__map_gbk2utf16[0x78bb] = 0xe2ec;
	__map_gbk2utf16[0x78bc] = 0xe2ed;
	__map_gbk2utf16[0x78bd] = 0xe2ee;
	__map_gbk2utf16[0x78be] = 0xe2ef;
	__map_gbk2utf16[0x7900] = 0x9da3;
	__map_gbk2utf16[0x7901] = 0x9da4;
	__map_gbk2utf16[0x7902] = 0x9da5;
	__map_gbk2utf16[0x7903] = 0x9da6;
	__map_gbk2utf16[0x7904] = 0x9da7;
	__map_gbk2utf16[0x7905] = 0x9da8;
	__map_gbk2utf16[0x7906] = 0x9da9;
	__map_gbk2utf16[0x7907] = 0x9daa;
	__map_gbk2utf16[0x7908] = 0x9dab;
	__map_gbk2utf16[0x7909] = 0x9dac;
	__map_gbk2utf16[0x790a] = 0x9dad;
	__map_gbk2utf16[0x790b] = 0x9dae;
	__map_gbk2utf16[0x790c] = 0x9daf;
	__map_gbk2utf16[0x790d] = 0x9db0;
	__map_gbk2utf16[0x790e] = 0x9db1;
	__map_gbk2utf16[0x790f] = 0x9db2;
	__map_gbk2utf16[0x7910] = 0x9db3;
	__map_gbk2utf16[0x7911] = 0x9db4;
	__map_gbk2utf16[0x7912] = 0x9db5;
	__map_gbk2utf16[0x7913] = 0x9db6;
	__map_gbk2utf16[0x7914] = 0x9db7;
	__map_gbk2utf16[0x7915] = 0x9db8;
	__map_gbk2utf16[0x7916] = 0x9db9;
	__map_gbk2utf16[0x7917] = 0x9dba;
	__map_gbk2utf16[0x7918] = 0x9dbb;
	__map_gbk2utf16[0x7919] = 0x9dbc;
	__map_gbk2utf16[0x791a] = 0x9dbd;
	__map_gbk2utf16[0x791b] = 0x9dbe;
	__map_gbk2utf16[0x791c] = 0x9dbf;
	__map_gbk2utf16[0x791d] = 0x9dc0;
	__map_gbk2utf16[0x791e] = 0x9dc1;
	__map_gbk2utf16[0x791f] = 0x9dc2;
	__map_gbk2utf16[0x7920] = 0x9dc3;
	__map_gbk2utf16[0x7921] = 0x9dc4;
	__map_gbk2utf16[0x7922] = 0x9dc5;
	__map_gbk2utf16[0x7923] = 0x9dc6;
	__map_gbk2utf16[0x7924] = 0x9dc7;
	__map_gbk2utf16[0x7925] = 0x9dc8;
	__map_gbk2utf16[0x7926] = 0x9dc9;
	__map_gbk2utf16[0x7927] = 0x9dca;
	__map_gbk2utf16[0x7928] = 0x9dcb;
	__map_gbk2utf16[0x7929] = 0x9dcc;
	__map_gbk2utf16[0x792a] = 0x9dcd;
	__map_gbk2utf16[0x792b] = 0x9dce;
	__map_gbk2utf16[0x792c] = 0x9dcf;
	__map_gbk2utf16[0x792d] = 0x9dd0;
	__map_gbk2utf16[0x792e] = 0x9dd1;
	__map_gbk2utf16[0x792f] = 0x9dd2;
	__map_gbk2utf16[0x7930] = 0x9dd3;
	__map_gbk2utf16[0x7931] = 0x9dd4;
	__map_gbk2utf16[0x7932] = 0x9dd5;
	__map_gbk2utf16[0x7933] = 0x9dd6;
	__map_gbk2utf16[0x7934] = 0x9dd7;
	__map_gbk2utf16[0x7935] = 0x9dd8;
	__map_gbk2utf16[0x7936] = 0x9dd9;
	__map_gbk2utf16[0x7937] = 0x9dda;
	__map_gbk2utf16[0x7938] = 0x9ddb;
	__map_gbk2utf16[0x7939] = 0x9ddc;
	__map_gbk2utf16[0x793a] = 0x9ddd;
	__map_gbk2utf16[0x793b] = 0x9dde;
	__map_gbk2utf16[0x793c] = 0x9ddf;
	__map_gbk2utf16[0x793d] = 0x9de0;
	__map_gbk2utf16[0x793e] = 0x9de1;
	__map_gbk2utf16[0x7940] = 0x9de2;
	__map_gbk2utf16[0x7941] = 0x9de3;
	__map_gbk2utf16[0x7942] = 0x9de4;
	__map_gbk2utf16[0x7943] = 0x9de5;
	__map_gbk2utf16[0x7944] = 0x9de6;
	__map_gbk2utf16[0x7945] = 0x9de7;
	__map_gbk2utf16[0x7946] = 0x9de8;
	__map_gbk2utf16[0x7947] = 0x9de9;
	__map_gbk2utf16[0x7948] = 0x9dea;
	__map_gbk2utf16[0x7949] = 0x9deb;
	__map_gbk2utf16[0x794a] = 0x9dec;
	__map_gbk2utf16[0x794b] = 0x9ded;
	__map_gbk2utf16[0x794c] = 0x9dee;
	__map_gbk2utf16[0x794d] = 0x9def;
	__map_gbk2utf16[0x794e] = 0x9df0;
	__map_gbk2utf16[0x794f] = 0x9df1;
	__map_gbk2utf16[0x7950] = 0x9df2;
	__map_gbk2utf16[0x7951] = 0x9df3;
	__map_gbk2utf16[0x7952] = 0x9df4;
	__map_gbk2utf16[0x7953] = 0x9df5;
	__map_gbk2utf16[0x7954] = 0x9df6;
	__map_gbk2utf16[0x7955] = 0x9df7;
	__map_gbk2utf16[0x7956] = 0x9df8;
	__map_gbk2utf16[0x7957] = 0x9df9;
	__map_gbk2utf16[0x7958] = 0x9dfa;
	__map_gbk2utf16[0x7959] = 0x9dfb;
	__map_gbk2utf16[0x795a] = 0x9dfc;
	__map_gbk2utf16[0x795b] = 0x9dfd;
	__map_gbk2utf16[0x795c] = 0x9dfe;
	__map_gbk2utf16[0x795d] = 0x9dff;
	__map_gbk2utf16[0x795e] = 0x9e00;
	__map_gbk2utf16[0x795f] = 0x9e01;
	__map_gbk2utf16[0x7960] = 0x9e02;
	__map_gbk2utf16[0x7961] = 0xe2f0;
	__map_gbk2utf16[0x7962] = 0xe2f1;
	__map_gbk2utf16[0x7963] = 0xe2f2;
	__map_gbk2utf16[0x7964] = 0xe2f3;
	__map_gbk2utf16[0x7965] = 0xe2f4;
	__map_gbk2utf16[0x7966] = 0xe2f5;
	__map_gbk2utf16[0x7967] = 0xe2f6;
	__map_gbk2utf16[0x7968] = 0xe2f7;
	__map_gbk2utf16[0x7969] = 0xe2f8;
	__map_gbk2utf16[0x796a] = 0xe2f9;
	__map_gbk2utf16[0x796b] = 0xe2fa;
	__map_gbk2utf16[0x796c] = 0xe2fb;
	__map_gbk2utf16[0x796d] = 0xe2fc;
	__map_gbk2utf16[0x796e] = 0xe2fd;
	__map_gbk2utf16[0x796f] = 0xe2fe;
	__map_gbk2utf16[0x7970] = 0xe2ff;
	__map_gbk2utf16[0x7971] = 0xe300;
	__map_gbk2utf16[0x7972] = 0xe301;
	__map_gbk2utf16[0x7973] = 0xe302;
	__map_gbk2utf16[0x7974] = 0xe303;
	__map_gbk2utf16[0x7975] = 0xe304;
	__map_gbk2utf16[0x7976] = 0xe305;
	__map_gbk2utf16[0x7977] = 0xe306;
	__map_gbk2utf16[0x7978] = 0xe307;
	__map_gbk2utf16[0x7979] = 0xe308;
	__map_gbk2utf16[0x797a] = 0xe309;
	__map_gbk2utf16[0x797b] = 0xe30a;
	__map_gbk2utf16[0x797c] = 0xe30b;
	__map_gbk2utf16[0x797d] = 0xe30c;
	__map_gbk2utf16[0x797e] = 0xe30d;
	__map_gbk2utf16[0x797f] = 0xe30e;
	__map_gbk2utf16[0x7980] = 0xe30f;
	__map_gbk2utf16[0x7981] = 0xe310;
	__map_gbk2utf16[0x7982] = 0xe311;
	__map_gbk2utf16[0x7983] = 0xe312;
	__map_gbk2utf16[0x7984] = 0xe313;
	__map_gbk2utf16[0x7985] = 0xe314;
	__map_gbk2utf16[0x7986] = 0xe315;
	__map_gbk2utf16[0x7987] = 0xe316;
	__map_gbk2utf16[0x7988] = 0xe317;
	__map_gbk2utf16[0x7989] = 0xe318;
	__map_gbk2utf16[0x798a] = 0xe319;
	__map_gbk2utf16[0x798b] = 0xe31a;
	__map_gbk2utf16[0x798c] = 0xe31b;
	__map_gbk2utf16[0x798d] = 0xe31c;
	__map_gbk2utf16[0x798e] = 0xe31d;
	__map_gbk2utf16[0x798f] = 0xe31e;
	__map_gbk2utf16[0x7990] = 0xe31f;
	__map_gbk2utf16[0x7991] = 0xe320;
	__map_gbk2utf16[0x7992] = 0xe321;
	__map_gbk2utf16[0x7993] = 0xe322;
	__map_gbk2utf16[0x7994] = 0xe323;
	__map_gbk2utf16[0x7995] = 0xe324;
	__map_gbk2utf16[0x7996] = 0xe325;
	__map_gbk2utf16[0x7997] = 0xe326;
	__map_gbk2utf16[0x7998] = 0xe327;
	__map_gbk2utf16[0x7999] = 0xe328;
	__map_gbk2utf16[0x799a] = 0xe329;
	__map_gbk2utf16[0x799b] = 0xe32a;
	__map_gbk2utf16[0x799c] = 0xe32b;
	__map_gbk2utf16[0x799d] = 0xe32c;
	__map_gbk2utf16[0x799e] = 0xe32d;
	__map_gbk2utf16[0x799f] = 0xe32e;
	__map_gbk2utf16[0x79a0] = 0xe32f;
	__map_gbk2utf16[0x79a1] = 0xe330;
	__map_gbk2utf16[0x79a2] = 0xe331;
	__map_gbk2utf16[0x79a3] = 0xe332;
	__map_gbk2utf16[0x79a4] = 0xe333;
	__map_gbk2utf16[0x79a5] = 0xe334;
	__map_gbk2utf16[0x79a6] = 0xe335;
	__map_gbk2utf16[0x79a7] = 0xe336;
	__map_gbk2utf16[0x79a8] = 0xe337;
	__map_gbk2utf16[0x79a9] = 0xe338;
	__map_gbk2utf16[0x79aa] = 0xe339;
	__map_gbk2utf16[0x79ab] = 0xe33a;
	__map_gbk2utf16[0x79ac] = 0xe33b;
	__map_gbk2utf16[0x79ad] = 0xe33c;
	__map_gbk2utf16[0x79ae] = 0xe33d;
	__map_gbk2utf16[0x79af] = 0xe33e;
	__map_gbk2utf16[0x79b0] = 0xe33f;
	__map_gbk2utf16[0x79b1] = 0xe340;
	__map_gbk2utf16[0x79b2] = 0xe341;
	__map_gbk2utf16[0x79b3] = 0xe342;
	__map_gbk2utf16[0x79b4] = 0xe343;
	__map_gbk2utf16[0x79b5] = 0xe344;
	__map_gbk2utf16[0x79b6] = 0xe345;
	__map_gbk2utf16[0x79b7] = 0xe346;
	__map_gbk2utf16[0x79b8] = 0xe347;
	__map_gbk2utf16[0x79b9] = 0xe348;
	__map_gbk2utf16[0x79ba] = 0xe349;
	__map_gbk2utf16[0x79bb] = 0xe34a;
	__map_gbk2utf16[0x79bc] = 0xe34b;
	__map_gbk2utf16[0x79bd] = 0xe34c;
	__map_gbk2utf16[0x79be] = 0xe34d;
	__map_gbk2utf16[0x7a00] = 0x9e03;
	__map_gbk2utf16[0x7a01] = 0x9e04;
	__map_gbk2utf16[0x7a02] = 0x9e05;
	__map_gbk2utf16[0x7a03] = 0x9e06;
	__map_gbk2utf16[0x7a04] = 0x9e07;
	__map_gbk2utf16[0x7a05] = 0x9e08;
	__map_gbk2utf16[0x7a06] = 0x9e09;
	__map_gbk2utf16[0x7a07] = 0x9e0a;
	__map_gbk2utf16[0x7a08] = 0x9e0b;
	__map_gbk2utf16[0x7a09] = 0x9e0c;
	__map_gbk2utf16[0x7a0a] = 0x9e0d;
	__map_gbk2utf16[0x7a0b] = 0x9e0e;
	__map_gbk2utf16[0x7a0c] = 0x9e0f;
	__map_gbk2utf16[0x7a0d] = 0x9e10;
	__map_gbk2utf16[0x7a0e] = 0x9e11;
	__map_gbk2utf16[0x7a0f] = 0x9e12;
	__map_gbk2utf16[0x7a10] = 0x9e13;
	__map_gbk2utf16[0x7a11] = 0x9e14;
	__map_gbk2utf16[0x7a12] = 0x9e15;
	__map_gbk2utf16[0x7a13] = 0x9e16;
	__map_gbk2utf16[0x7a14] = 0x9e17;
	__map_gbk2utf16[0x7a15] = 0x9e18;
	__map_gbk2utf16[0x7a16] = 0x9e19;
	__map_gbk2utf16[0x7a17] = 0x9e1a;
	__map_gbk2utf16[0x7a18] = 0x9e1b;
	__map_gbk2utf16[0x7a19] = 0x9e1c;
	__map_gbk2utf16[0x7a1a] = 0x9e1d;
	__map_gbk2utf16[0x7a1b] = 0x9e1e;
	__map_gbk2utf16[0x7a1c] = 0x9e24;
	__map_gbk2utf16[0x7a1d] = 0x9e27;
	__map_gbk2utf16[0x7a1e] = 0x9e2e;
	__map_gbk2utf16[0x7a1f] = 0x9e30;
	__map_gbk2utf16[0x7a20] = 0x9e34;
	__map_gbk2utf16[0x7a21] = 0x9e3b;
	__map_gbk2utf16[0x7a22] = 0x9e3c;
	__map_gbk2utf16[0x7a23] = 0x9e40;
	__map_gbk2utf16[0x7a24] = 0x9e4d;
	__map_gbk2utf16[0x7a25] = 0x9e50;
	__map_gbk2utf16[0x7a26] = 0x9e52;
	__map_gbk2utf16[0x7a27] = 0x9e53;
	__map_gbk2utf16[0x7a28] = 0x9e54;
	__map_gbk2utf16[0x7a29] = 0x9e56;
	__map_gbk2utf16[0x7a2a] = 0x9e59;
	__map_gbk2utf16[0x7a2b] = 0x9e5d;
	__map_gbk2utf16[0x7a2c] = 0x9e5f;
	__map_gbk2utf16[0x7a2d] = 0x9e60;
	__map_gbk2utf16[0x7a2e] = 0x9e61;
	__map_gbk2utf16[0x7a2f] = 0x9e62;
	__map_gbk2utf16[0x7a30] = 0x9e65;
	__map_gbk2utf16[0x7a31] = 0x9e6e;
	__map_gbk2utf16[0x7a32] = 0x9e6f;
	__map_gbk2utf16[0x7a33] = 0x9e72;
	__map_gbk2utf16[0x7a34] = 0x9e74;
	__map_gbk2utf16[0x7a35] = 0x9e75;
	__map_gbk2utf16[0x7a36] = 0x9e76;
	__map_gbk2utf16[0x7a37] = 0x9e77;
	__map_gbk2utf16[0x7a38] = 0x9e78;
	__map_gbk2utf16[0x7a39] = 0x9e79;
	__map_gbk2utf16[0x7a3a] = 0x9e7a;
	__map_gbk2utf16[0x7a3b] = 0x9e7b;
	__map_gbk2utf16[0x7a3c] = 0x9e7c;
	__map_gbk2utf16[0x7a3d] = 0x9e7d;
	__map_gbk2utf16[0x7a3e] = 0x9e80;
	__map_gbk2utf16[0x7a40] = 0x9e81;
	__map_gbk2utf16[0x7a41] = 0x9e83;
	__map_gbk2utf16[0x7a42] = 0x9e84;
	__map_gbk2utf16[0x7a43] = 0x9e85;
	__map_gbk2utf16[0x7a44] = 0x9e86;
	__map_gbk2utf16[0x7a45] = 0x9e89;
	__map_gbk2utf16[0x7a46] = 0x9e8a;
	__map_gbk2utf16[0x7a47] = 0x9e8c;
	__map_gbk2utf16[0x7a48] = 0x9e8d;
	__map_gbk2utf16[0x7a49] = 0x9e8e;
	__map_gbk2utf16[0x7a4a] = 0x9e8f;
	__map_gbk2utf16[0x7a4b] = 0x9e90;
	__map_gbk2utf16[0x7a4c] = 0x9e91;
	__map_gbk2utf16[0x7a4d] = 0x9e94;
	__map_gbk2utf16[0x7a4e] = 0x9e95;
	__map_gbk2utf16[0x7a4f] = 0x9e96;
	__map_gbk2utf16[0x7a50] = 0x9e97;
	__map_gbk2utf16[0x7a51] = 0x9e98;
	__map_gbk2utf16[0x7a52] = 0x9e99;
	__map_gbk2utf16[0x7a53] = 0x9e9a;
	__map_gbk2utf16[0x7a54] = 0x9e9b;
	__map_gbk2utf16[0x7a55] = 0x9e9c;
	__map_gbk2utf16[0x7a56] = 0x9e9e;
	__map_gbk2utf16[0x7a57] = 0x9ea0;
	__map_gbk2utf16[0x7a58] = 0x9ea1;
	__map_gbk2utf16[0x7a59] = 0x9ea2;
	__map_gbk2utf16[0x7a5a] = 0x9ea3;
	__map_gbk2utf16[0x7a5b] = 0x9ea4;
	__map_gbk2utf16[0x7a5c] = 0x9ea5;
	__map_gbk2utf16[0x7a5d] = 0x9ea7;
	__map_gbk2utf16[0x7a5e] = 0x9ea8;
	__map_gbk2utf16[0x7a5f] = 0x9ea9;
	__map_gbk2utf16[0x7a60] = 0x9eaa;
	__map_gbk2utf16[0x7a61] = 0xe34e;
	__map_gbk2utf16[0x7a62] = 0xe34f;
	__map_gbk2utf16[0x7a63] = 0xe350;
	__map_gbk2utf16[0x7a64] = 0xe351;
	__map_gbk2utf16[0x7a65] = 0xe352;
	__map_gbk2utf16[0x7a66] = 0xe353;
	__map_gbk2utf16[0x7a67] = 0xe354;
	__map_gbk2utf16[0x7a68] = 0xe355;
	__map_gbk2utf16[0x7a69] = 0xe356;
	__map_gbk2utf16[0x7a6a] = 0xe357;
	__map_gbk2utf16[0x7a6b] = 0xe358;
	__map_gbk2utf16[0x7a6c] = 0xe359;
	__map_gbk2utf16[0x7a6d] = 0xe35a;
	__map_gbk2utf16[0x7a6e] = 0xe35b;
	__map_gbk2utf16[0x7a6f] = 0xe35c;
	__map_gbk2utf16[0x7a70] = 0xe35d;
	__map_gbk2utf16[0x7a71] = 0xe35e;
	__map_gbk2utf16[0x7a72] = 0xe35f;
	__map_gbk2utf16[0x7a73] = 0xe360;
	__map_gbk2utf16[0x7a74] = 0xe361;
	__map_gbk2utf16[0x7a75] = 0xe362;
	__map_gbk2utf16[0x7a76] = 0xe363;
	__map_gbk2utf16[0x7a77] = 0xe364;
	__map_gbk2utf16[0x7a78] = 0xe365;
	__map_gbk2utf16[0x7a79] = 0xe366;
	__map_gbk2utf16[0x7a7a] = 0xe367;
	__map_gbk2utf16[0x7a7b] = 0xe368;
	__map_gbk2utf16[0x7a7c] = 0xe369;
	__map_gbk2utf16[0x7a7d] = 0xe36a;
	__map_gbk2utf16[0x7a7e] = 0xe36b;
	__map_gbk2utf16[0x7a7f] = 0xe36c;
	__map_gbk2utf16[0x7a80] = 0xe36d;
	__map_gbk2utf16[0x7a81] = 0xe36e;
	__map_gbk2utf16[0x7a82] = 0xe36f;
	__map_gbk2utf16[0x7a83] = 0xe370;
	__map_gbk2utf16[0x7a84] = 0xe371;
	__map_gbk2utf16[0x7a85] = 0xe372;
	__map_gbk2utf16[0x7a86] = 0xe373;
	__map_gbk2utf16[0x7a87] = 0xe374;
	__map_gbk2utf16[0x7a88] = 0xe375;
	__map_gbk2utf16[0x7a89] = 0xe376;
	__map_gbk2utf16[0x7a8a] = 0xe377;
	__map_gbk2utf16[0x7a8b] = 0xe378;
	__map_gbk2utf16[0x7a8c] = 0xe379;
	__map_gbk2utf16[0x7a8d] = 0xe37a;
	__map_gbk2utf16[0x7a8e] = 0xe37b;
	__map_gbk2utf16[0x7a8f] = 0xe37c;
	__map_gbk2utf16[0x7a90] = 0xe37d;
	__map_gbk2utf16[0x7a91] = 0xe37e;
	__map_gbk2utf16[0x7a92] = 0xe37f;
	__map_gbk2utf16[0x7a93] = 0xe380;
	__map_gbk2utf16[0x7a94] = 0xe381;
	__map_gbk2utf16[0x7a95] = 0xe382;
	__map_gbk2utf16[0x7a96] = 0xe383;
	__map_gbk2utf16[0x7a97] = 0xe384;
	__map_gbk2utf16[0x7a98] = 0xe385;
	__map_gbk2utf16[0x7a99] = 0xe386;
	__map_gbk2utf16[0x7a9a] = 0xe387;
	__map_gbk2utf16[0x7a9b] = 0xe388;
	__map_gbk2utf16[0x7a9c] = 0xe389;
	__map_gbk2utf16[0x7a9d] = 0xe38a;
	__map_gbk2utf16[0x7a9e] = 0xe38b;
	__map_gbk2utf16[0x7a9f] = 0xe38c;
	__map_gbk2utf16[0x7aa0] = 0xe38d;
	__map_gbk2utf16[0x7aa1] = 0xe38e;
	__map_gbk2utf16[0x7aa2] = 0xe38f;
	__map_gbk2utf16[0x7aa3] = 0xe390;
	__map_gbk2utf16[0x7aa4] = 0xe391;
	__map_gbk2utf16[0x7aa5] = 0xe392;
	__map_gbk2utf16[0x7aa6] = 0xe393;
	__map_gbk2utf16[0x7aa7] = 0xe394;
	__map_gbk2utf16[0x7aa8] = 0xe395;
	__map_gbk2utf16[0x7aa9] = 0xe396;
	__map_gbk2utf16[0x7aaa] = 0xe397;
	__map_gbk2utf16[0x7aab] = 0xe398;
	__map_gbk2utf16[0x7aac] = 0xe399;
	__map_gbk2utf16[0x7aad] = 0xe39a;
	__map_gbk2utf16[0x7aae] = 0xe39b;
	__map_gbk2utf16[0x7aaf] = 0xe39c;
	__map_gbk2utf16[0x7ab0] = 0xe39d;
	__map_gbk2utf16[0x7ab1] = 0xe39e;
	__map_gbk2utf16[0x7ab2] = 0xe39f;
	__map_gbk2utf16[0x7ab3] = 0xe3a0;
	__map_gbk2utf16[0x7ab4] = 0xe3a1;
	__map_gbk2utf16[0x7ab5] = 0xe3a2;
	__map_gbk2utf16[0x7ab6] = 0xe3a3;
	__map_gbk2utf16[0x7ab7] = 0xe3a4;
	__map_gbk2utf16[0x7ab8] = 0xe3a5;
	__map_gbk2utf16[0x7ab9] = 0xe3a6;
	__map_gbk2utf16[0x7aba] = 0xe3a7;
	__map_gbk2utf16[0x7abb] = 0xe3a8;
	__map_gbk2utf16[0x7abc] = 0xe3a9;
	__map_gbk2utf16[0x7abd] = 0xe3aa;
	__map_gbk2utf16[0x7abe] = 0xe3ab;
	__map_gbk2utf16[0x7b00] = 0x9eab;
	__map_gbk2utf16[0x7b01] = 0x9eac;
	__map_gbk2utf16[0x7b02] = 0x9ead;
	__map_gbk2utf16[0x7b03] = 0x9eae;
	__map_gbk2utf16[0x7b04] = 0x9eaf;
	__map_gbk2utf16[0x7b05] = 0x9eb0;
	__map_gbk2utf16[0x7b06] = 0x9eb1;
	__map_gbk2utf16[0x7b07] = 0x9eb2;
	__map_gbk2utf16[0x7b08] = 0x9eb3;
	__map_gbk2utf16[0x7b09] = 0x9eb5;
	__map_gbk2utf16[0x7b0a] = 0x9eb6;
	__map_gbk2utf16[0x7b0b] = 0x9eb7;
	__map_gbk2utf16[0x7b0c] = 0x9eb9;
	__map_gbk2utf16[0x7b0d] = 0x9eba;
	__map_gbk2utf16[0x7b0e] = 0x9ebc;
	__map_gbk2utf16[0x7b0f] = 0x9ebf;
	__map_gbk2utf16[0x7b10] = 0x9ec0;
	__map_gbk2utf16[0x7b11] = 0x9ec1;
	__map_gbk2utf16[0x7b12] = 0x9ec2;
	__map_gbk2utf16[0x7b13] = 0x9ec3;
	__map_gbk2utf16[0x7b14] = 0x9ec5;
	__map_gbk2utf16[0x7b15] = 0x9ec6;
	__map_gbk2utf16[0x7b16] = 0x9ec7;
	__map_gbk2utf16[0x7b17] = 0x9ec8;
	__map_gbk2utf16[0x7b18] = 0x9eca;
	__map_gbk2utf16[0x7b19] = 0x9ecb;
	__map_gbk2utf16[0x7b1a] = 0x9ecc;
	__map_gbk2utf16[0x7b1b] = 0x9ed0;
	__map_gbk2utf16[0x7b1c] = 0x9ed2;
	__map_gbk2utf16[0x7b1d] = 0x9ed3;
	__map_gbk2utf16[0x7b1e] = 0x9ed5;
	__map_gbk2utf16[0x7b1f] = 0x9ed6;
	__map_gbk2utf16[0x7b20] = 0x9ed7;
	__map_gbk2utf16[0x7b21] = 0x9ed9;
	__map_gbk2utf16[0x7b22] = 0x9eda;
	__map_gbk2utf16[0x7b23] = 0x9ede;
	__map_gbk2utf16[0x7b24] = 0x9ee1;
	__map_gbk2utf16[0x7b25] = 0x9ee3;
	__map_gbk2utf16[0x7b26] = 0x9ee4;
	__map_gbk2utf16[0x7b27] = 0x9ee6;
	__map_gbk2utf16[0x7b28] = 0x9ee8;
	__map_gbk2utf16[0x7b29] = 0x9eeb;
	__map_gbk2utf16[0x7b2a] = 0x9eec;
	__map_gbk2utf16[0x7b2b] = 0x9eed;
	__map_gbk2utf16[0x7b2c] = 0x9eee;
	__map_gbk2utf16[0x7b2d] = 0x9ef0;
	__map_gbk2utf16[0x7b2e] = 0x9ef1;
	__map_gbk2utf16[0x7b2f] = 0x9ef2;
	__map_gbk2utf16[0x7b30] = 0x9ef3;
	__map_gbk2utf16[0x7b31] = 0x9ef4;
	__map_gbk2utf16[0x7b32] = 0x9ef5;
	__map_gbk2utf16[0x7b33] = 0x9ef6;
	__map_gbk2utf16[0x7b34] = 0x9ef7;
	__map_gbk2utf16[0x7b35] = 0x9ef8;
	__map_gbk2utf16[0x7b36] = 0x9efa;
	__map_gbk2utf16[0x7b37] = 0x9efd;
	__map_gbk2utf16[0x7b38] = 0x9eff;
	__map_gbk2utf16[0x7b39] = 0x9f00;
	__map_gbk2utf16[0x7b3a] = 0x9f01;
	__map_gbk2utf16[0x7b3b] = 0x9f02;
	__map_gbk2utf16[0x7b3c] = 0x9f03;
	__map_gbk2utf16[0x7b3d] = 0x9f04;
	__map_gbk2utf16[0x7b3e] = 0x9f05;
	__map_gbk2utf16[0x7b40] = 0x9f06;
	__map_gbk2utf16[0x7b41] = 0x9f07;
	__map_gbk2utf16[0x7b42] = 0x9f08;
	__map_gbk2utf16[0x7b43] = 0x9f09;
	__map_gbk2utf16[0x7b44] = 0x9f0a;
	__map_gbk2utf16[0x7b45] = 0x9f0c;
	__map_gbk2utf16[0x7b46] = 0x9f0f;
	__map_gbk2utf16[0x7b47] = 0x9f11;
	__map_gbk2utf16[0x7b48] = 0x9f12;
	__map_gbk2utf16[0x7b49] = 0x9f14;
	__map_gbk2utf16[0x7b4a] = 0x9f15;
	__map_gbk2utf16[0x7b4b] = 0x9f16;
	__map_gbk2utf16[0x7b4c] = 0x9f18;
	__map_gbk2utf16[0x7b4d] = 0x9f1a;
	__map_gbk2utf16[0x7b4e] = 0x9f1b;
	__map_gbk2utf16[0x7b4f] = 0x9f1c;
	__map_gbk2utf16[0x7b50] = 0x9f1d;
	__map_gbk2utf16[0x7b51] = 0x9f1e;
	__map_gbk2utf16[0x7b52] = 0x9f1f;
	__map_gbk2utf16[0x7b53] = 0x9f21;
	__map_gbk2utf16[0x7b54] = 0x9f23;
	__map_gbk2utf16[0x7b55] = 0x9f24;
	__map_gbk2utf16[0x7b56] = 0x9f25;
	__map_gbk2utf16[0x7b57] = 0x9f26;
	__map_gbk2utf16[0x7b58] = 0x9f27;
	__map_gbk2utf16[0x7b59] = 0x9f28;
	__map_gbk2utf16[0x7b5a] = 0x9f29;
	__map_gbk2utf16[0x7b5b] = 0x9f2a;
	__map_gbk2utf16[0x7b5c] = 0x9f2b;
	__map_gbk2utf16[0x7b5d] = 0x9f2d;
	__map_gbk2utf16[0x7b5e] = 0x9f2e;
	__map_gbk2utf16[0x7b5f] = 0x9f30;
	__map_gbk2utf16[0x7b60] = 0x9f31;
	__map_gbk2utf16[0x7b61] = 0xe3ac;
	__map_gbk2utf16[0x7b62] = 0xe3ad;
	__map_gbk2utf16[0x7b63] = 0xe3ae;
	__map_gbk2utf16[0x7b64] = 0xe3af;
	__map_gbk2utf16[0x7b65] = 0xe3b0;
	__map_gbk2utf16[0x7b66] = 0xe3b1;
	__map_gbk2utf16[0x7b67] = 0xe3b2;
	__map_gbk2utf16[0x7b68] = 0xe3b3;
	__map_gbk2utf16[0x7b69] = 0xe3b4;
	__map_gbk2utf16[0x7b6a] = 0xe3b5;
	__map_gbk2utf16[0x7b6b] = 0xe3b6;
	__map_gbk2utf16[0x7b6c] = 0xe3b7;
	__map_gbk2utf16[0x7b6d] = 0xe3b8;
	__map_gbk2utf16[0x7b6e] = 0xe3b9;
	__map_gbk2utf16[0x7b6f] = 0xe3ba;
	__map_gbk2utf16[0x7b70] = 0xe3bb;
	__map_gbk2utf16[0x7b71] = 0xe3bc;
	__map_gbk2utf16[0x7b72] = 0xe3bd;
	__map_gbk2utf16[0x7b73] = 0xe3be;
	__map_gbk2utf16[0x7b74] = 0xe3bf;
	__map_gbk2utf16[0x7b75] = 0xe3c0;
	__map_gbk2utf16[0x7b76] = 0xe3c1;
	__map_gbk2utf16[0x7b77] = 0xe3c2;
	__map_gbk2utf16[0x7b78] = 0xe3c3;
	__map_gbk2utf16[0x7b79] = 0xe3c4;
	__map_gbk2utf16[0x7b7a] = 0xe3c5;
	__map_gbk2utf16[0x7b7b] = 0xe3c6;
	__map_gbk2utf16[0x7b7c] = 0xe3c7;
	__map_gbk2utf16[0x7b7d] = 0xe3c8;
	__map_gbk2utf16[0x7b7e] = 0xe3c9;
	__map_gbk2utf16[0x7b7f] = 0xe3ca;
	__map_gbk2utf16[0x7b80] = 0xe3cb;
	__map_gbk2utf16[0x7b81] = 0xe3cc;
	__map_gbk2utf16[0x7b82] = 0xe3cd;
	__map_gbk2utf16[0x7b83] = 0xe3ce;
	__map_gbk2utf16[0x7b84] = 0xe3cf;
	__map_gbk2utf16[0x7b85] = 0xe3d0;
	__map_gbk2utf16[0x7b86] = 0xe3d1;
	__map_gbk2utf16[0x7b87] = 0xe3d2;
	__map_gbk2utf16[0x7b88] = 0xe3d3;
	__map_gbk2utf16[0x7b89] = 0xe3d4;
	__map_gbk2utf16[0x7b8a] = 0xe3d5;
	__map_gbk2utf16[0x7b8b] = 0xe3d6;
	__map_gbk2utf16[0x7b8c] = 0xe3d7;
	__map_gbk2utf16[0x7b8d] = 0xe3d8;
	__map_gbk2utf16[0x7b8e] = 0xe3d9;
	__map_gbk2utf16[0x7b8f] = 0xe3da;
	__map_gbk2utf16[0x7b90] = 0xe3db;
	__map_gbk2utf16[0x7b91] = 0xe3dc;
	__map_gbk2utf16[0x7b92] = 0xe3dd;
	__map_gbk2utf16[0x7b93] = 0xe3de;
	__map_gbk2utf16[0x7b94] = 0xe3df;
	__map_gbk2utf16[0x7b95] = 0xe3e0;
	__map_gbk2utf16[0x7b96] = 0xe3e1;
	__map_gbk2utf16[0x7b97] = 0xe3e2;
	__map_gbk2utf16[0x7b98] = 0xe3e3;
	__map_gbk2utf16[0x7b99] = 0xe3e4;
	__map_gbk2utf16[0x7b9a] = 0xe3e5;
	__map_gbk2utf16[0x7b9b] = 0xe3e6;
	__map_gbk2utf16[0x7b9c] = 0xe3e7;
	__map_gbk2utf16[0x7b9d] = 0xe3e8;
	__map_gbk2utf16[0x7b9e] = 0xe3e9;
	__map_gbk2utf16[0x7b9f] = 0xe3ea;
	__map_gbk2utf16[0x7ba0] = 0xe3eb;
	__map_gbk2utf16[0x7ba1] = 0xe3ec;
	__map_gbk2utf16[0x7ba2] = 0xe3ed;
	__map_gbk2utf16[0x7ba3] = 0xe3ee;
	__map_gbk2utf16[0x7ba4] = 0xe3ef;
	__map_gbk2utf16[0x7ba5] = 0xe3f0;
	__map_gbk2utf16[0x7ba6] = 0xe3f1;
	__map_gbk2utf16[0x7ba7] = 0xe3f2;
	__map_gbk2utf16[0x7ba8] = 0xe3f3;
	__map_gbk2utf16[0x7ba9] = 0xe3f4;
	__map_gbk2utf16[0x7baa] = 0xe3f5;
	__map_gbk2utf16[0x7bab] = 0xe3f6;
	__map_gbk2utf16[0x7bac] = 0xe3f7;
	__map_gbk2utf16[0x7bad] = 0xe3f8;
	__map_gbk2utf16[0x7bae] = 0xe3f9;
	__map_gbk2utf16[0x7baf] = 0xe3fa;
	__map_gbk2utf16[0x7bb0] = 0xe3fb;
	__map_gbk2utf16[0x7bb1] = 0xe3fc;
	__map_gbk2utf16[0x7bb2] = 0xe3fd;
	__map_gbk2utf16[0x7bb3] = 0xe3fe;
	__map_gbk2utf16[0x7bb4] = 0xe3ff;
	__map_gbk2utf16[0x7bb5] = 0xe400;
	__map_gbk2utf16[0x7bb6] = 0xe401;
	__map_gbk2utf16[0x7bb7] = 0xe402;
	__map_gbk2utf16[0x7bb8] = 0xe403;
	__map_gbk2utf16[0x7bb9] = 0xe404;
	__map_gbk2utf16[0x7bba] = 0xe405;
	__map_gbk2utf16[0x7bbb] = 0xe406;
	__map_gbk2utf16[0x7bbc] = 0xe407;
	__map_gbk2utf16[0x7bbd] = 0xe408;
	__map_gbk2utf16[0x7bbe] = 0xe409;
	__map_gbk2utf16[0x7c00] = 0x9f32;
	__map_gbk2utf16[0x7c01] = 0x9f33;
	__map_gbk2utf16[0x7c02] = 0x9f34;
	__map_gbk2utf16[0x7c03] = 0x9f35;
	__map_gbk2utf16[0x7c04] = 0x9f36;
	__map_gbk2utf16[0x7c05] = 0x9f38;
	__map_gbk2utf16[0x7c06] = 0x9f3a;
	__map_gbk2utf16[0x7c07] = 0x9f3c;
	__map_gbk2utf16[0x7c08] = 0x9f3f;
	__map_gbk2utf16[0x7c09] = 0x9f40;
	__map_gbk2utf16[0x7c0a] = 0x9f41;
	__map_gbk2utf16[0x7c0b] = 0x9f42;
	__map_gbk2utf16[0x7c0c] = 0x9f43;
	__map_gbk2utf16[0x7c0d] = 0x9f45;
	__map_gbk2utf16[0x7c0e] = 0x9f46;
	__map_gbk2utf16[0x7c0f] = 0x9f47;
	__map_gbk2utf16[0x7c10] = 0x9f48;
	__map_gbk2utf16[0x7c11] = 0x9f49;
	__map_gbk2utf16[0x7c12] = 0x9f4a;
	__map_gbk2utf16[0x7c13] = 0x9f4b;
	__map_gbk2utf16[0x7c14] = 0x9f4c;
	__map_gbk2utf16[0x7c15] = 0x9f4d;
	__map_gbk2utf16[0x7c16] = 0x9f4e;
	__map_gbk2utf16[0x7c17] = 0x9f4f;
	__map_gbk2utf16[0x7c18] = 0x9f52;
	__map_gbk2utf16[0x7c19] = 0x9f53;
	__map_gbk2utf16[0x7c1a] = 0x9f54;
	__map_gbk2utf16[0x7c1b] = 0x9f55;
	__map_gbk2utf16[0x7c1c] = 0x9f56;
	__map_gbk2utf16[0x7c1d] = 0x9f57;
	__map_gbk2utf16[0x7c1e] = 0x9f58;
	__map_gbk2utf16[0x7c1f] = 0x9f59;
	__map_gbk2utf16[0x7c20] = 0x9f5a;
	__map_gbk2utf16[0x7c21] = 0x9f5b;
	__map_gbk2utf16[0x7c22] = 0x9f5c;
	__map_gbk2utf16[0x7c23] = 0x9f5d;
	__map_gbk2utf16[0x7c24] = 0x9f5e;
	__map_gbk2utf16[0x7c25] = 0x9f5f;
	__map_gbk2utf16[0x7c26] = 0x9f60;
	__map_gbk2utf16[0x7c27] = 0x9f61;
	__map_gbk2utf16[0x7c28] = 0x9f62;
	__map_gbk2utf16[0x7c29] = 0x9f63;
	__map_gbk2utf16[0x7c2a] = 0x9f64;
	__map_gbk2utf16[0x7c2b] = 0x9f65;
	__map_gbk2utf16[0x7c2c] = 0x9f66;
	__map_gbk2utf16[0x7c2d] = 0x9f67;
	__map_gbk2utf16[0x7c2e] = 0x9f68;
	__map_gbk2utf16[0x7c2f] = 0x9f69;
	__map_gbk2utf16[0x7c30] = 0x9f6a;
	__map_gbk2utf16[0x7c31] = 0x9f6b;
	__map_gbk2utf16[0x7c32] = 0x9f6c;
	__map_gbk2utf16[0x7c33] = 0x9f6d;
	__map_gbk2utf16[0x7c34] = 0x9f6e;
	__map_gbk2utf16[0x7c35] = 0x9f6f;
	__map_gbk2utf16[0x7c36] = 0x9f70;
	__map_gbk2utf16[0x7c37] = 0x9f71;
	__map_gbk2utf16[0x7c38] = 0x9f72;
	__map_gbk2utf16[0x7c39] = 0x9f73;
	__map_gbk2utf16[0x7c3a] = 0x9f74;
	__map_gbk2utf16[0x7c3b] = 0x9f75;
	__map_gbk2utf16[0x7c3c] = 0x9f76;
	__map_gbk2utf16[0x7c3d] = 0x9f77;
	__map_gbk2utf16[0x7c3e] = 0x9f78;
	__map_gbk2utf16[0x7c40] = 0x9f79;
	__map_gbk2utf16[0x7c41] = 0x9f7a;
	__map_gbk2utf16[0x7c42] = 0x9f7b;
	__map_gbk2utf16[0x7c43] = 0x9f7c;
	__map_gbk2utf16[0x7c44] = 0x9f7d;
	__map_gbk2utf16[0x7c45] = 0x9f7e;
	__map_gbk2utf16[0x7c46] = 0x9f81;
	__map_gbk2utf16[0x7c47] = 0x9f82;
	__map_gbk2utf16[0x7c48] = 0x9f8d;
	__map_gbk2utf16[0x7c49] = 0x9f8e;
	__map_gbk2utf16[0x7c4a] = 0x9f8f;
	__map_gbk2utf16[0x7c4b] = 0x9f90;
	__map_gbk2utf16[0x7c4c] = 0x9f91;
	__map_gbk2utf16[0x7c4d] = 0x9f92;
	__map_gbk2utf16[0x7c4e] = 0x9f93;
	__map_gbk2utf16[0x7c4f] = 0x9f94;
	__map_gbk2utf16[0x7c50] = 0x9f95;
	__map_gbk2utf16[0x7c51] = 0x9f96;
	__map_gbk2utf16[0x7c52] = 0x9f97;
	__map_gbk2utf16[0x7c53] = 0x9f98;
	__map_gbk2utf16[0x7c54] = 0x9f9c;
	__map_gbk2utf16[0x7c55] = 0x9f9d;
	__map_gbk2utf16[0x7c56] = 0x9f9e;
	__map_gbk2utf16[0x7c57] = 0x9fa1;
	__map_gbk2utf16[0x7c58] = 0x9fa2;
	__map_gbk2utf16[0x7c59] = 0x9fa3;
	__map_gbk2utf16[0x7c5a] = 0x9fa4;
	__map_gbk2utf16[0x7c5b] = 0x9fa5;
	__map_gbk2utf16[0x7c5c] = 0xf92c;
	__map_gbk2utf16[0x7c5d] = 0xf979;
	__map_gbk2utf16[0x7c5e] = 0xf995;
	__map_gbk2utf16[0x7c5f] = 0xf9e7;
	__map_gbk2utf16[0x7c60] = 0xf9f1;
	__map_gbk2utf16[0x7c61] = 0xe40a;
	__map_gbk2utf16[0x7c62] = 0xe40b;
	__map_gbk2utf16[0x7c63] = 0xe40c;
	__map_gbk2utf16[0x7c64] = 0xe40d;
	__map_gbk2utf16[0x7c65] = 0xe40e;
	__map_gbk2utf16[0x7c66] = 0xe40f;
	__map_gbk2utf16[0x7c67] = 0xe410;
	__map_gbk2utf16[0x7c68] = 0xe411;
	__map_gbk2utf16[0x7c69] = 0xe412;
	__map_gbk2utf16[0x7c6a] = 0xe413;
	__map_gbk2utf16[0x7c6b] = 0xe414;
	__map_gbk2utf16[0x7c6c] = 0xe415;
	__map_gbk2utf16[0x7c6d] = 0xe416;
	__map_gbk2utf16[0x7c6e] = 0xe417;
	__map_gbk2utf16[0x7c6f] = 0xe418;
	__map_gbk2utf16[0x7c70] = 0xe419;
	__map_gbk2utf16[0x7c71] = 0xe41a;
	__map_gbk2utf16[0x7c72] = 0xe41b;
	__map_gbk2utf16[0x7c73] = 0xe41c;
	__map_gbk2utf16[0x7c74] = 0xe41d;
	__map_gbk2utf16[0x7c75] = 0xe41e;
	__map_gbk2utf16[0x7c76] = 0xe41f;
	__map_gbk2utf16[0x7c77] = 0xe420;
	__map_gbk2utf16[0x7c78] = 0xe421;
	__map_gbk2utf16[0x7c79] = 0xe422;
	__map_gbk2utf16[0x7c7a] = 0xe423;
	__map_gbk2utf16[0x7c7b] = 0xe424;
	__map_gbk2utf16[0x7c7c] = 0xe425;
	__map_gbk2utf16[0x7c7d] = 0xe426;
	__map_gbk2utf16[0x7c7e] = 0xe427;
	__map_gbk2utf16[0x7c7f] = 0xe428;
	__map_gbk2utf16[0x7c80] = 0xe429;
	__map_gbk2utf16[0x7c81] = 0xe42a;
	__map_gbk2utf16[0x7c82] = 0xe42b;
	__map_gbk2utf16[0x7c83] = 0xe42c;
	__map_gbk2utf16[0x7c84] = 0xe42d;
	__map_gbk2utf16[0x7c85] = 0xe42e;
	__map_gbk2utf16[0x7c86] = 0xe42f;
	__map_gbk2utf16[0x7c87] = 0xe430;
	__map_gbk2utf16[0x7c88] = 0xe431;
	__map_gbk2utf16[0x7c89] = 0xe432;
	__map_gbk2utf16[0x7c8a] = 0xe433;
	__map_gbk2utf16[0x7c8b] = 0xe434;
	__map_gbk2utf16[0x7c8c] = 0xe435;
	__map_gbk2utf16[0x7c8d] = 0xe436;
	__map_gbk2utf16[0x7c8e] = 0xe437;
	__map_gbk2utf16[0x7c8f] = 0xe438;
	__map_gbk2utf16[0x7c90] = 0xe439;
	__map_gbk2utf16[0x7c91] = 0xe43a;
	__map_gbk2utf16[0x7c92] = 0xe43b;
	__map_gbk2utf16[0x7c93] = 0xe43c;
	__map_gbk2utf16[0x7c94] = 0xe43d;
	__map_gbk2utf16[0x7c95] = 0xe43e;
	__map_gbk2utf16[0x7c96] = 0xe43f;
	__map_gbk2utf16[0x7c97] = 0xe440;
	__map_gbk2utf16[0x7c98] = 0xe441;
	__map_gbk2utf16[0x7c99] = 0xe442;
	__map_gbk2utf16[0x7c9a] = 0xe443;
	__map_gbk2utf16[0x7c9b] = 0xe444;
	__map_gbk2utf16[0x7c9c] = 0xe445;
	__map_gbk2utf16[0x7c9d] = 0xe446;
	__map_gbk2utf16[0x7c9e] = 0xe447;
	__map_gbk2utf16[0x7c9f] = 0xe448;
	__map_gbk2utf16[0x7ca0] = 0xe449;
	__map_gbk2utf16[0x7ca1] = 0xe44a;
	__map_gbk2utf16[0x7ca2] = 0xe44b;
	__map_gbk2utf16[0x7ca3] = 0xe44c;
	__map_gbk2utf16[0x7ca4] = 0xe44d;
	__map_gbk2utf16[0x7ca5] = 0xe44e;
	__map_gbk2utf16[0x7ca6] = 0xe44f;
	__map_gbk2utf16[0x7ca7] = 0xe450;
	__map_gbk2utf16[0x7ca8] = 0xe451;
	__map_gbk2utf16[0x7ca9] = 0xe452;
	__map_gbk2utf16[0x7caa] = 0xe453;
	__map_gbk2utf16[0x7cab] = 0xe454;
	__map_gbk2utf16[0x7cac] = 0xe455;
	__map_gbk2utf16[0x7cad] = 0xe456;
	__map_gbk2utf16[0x7cae] = 0xe457;
	__map_gbk2utf16[0x7caf] = 0xe458;
	__map_gbk2utf16[0x7cb0] = 0xe459;
	__map_gbk2utf16[0x7cb1] = 0xe45a;
	__map_gbk2utf16[0x7cb2] = 0xe45b;
	__map_gbk2utf16[0x7cb3] = 0xe45c;
	__map_gbk2utf16[0x7cb4] = 0xe45d;
	__map_gbk2utf16[0x7cb5] = 0xe45e;
	__map_gbk2utf16[0x7cb6] = 0xe45f;
	__map_gbk2utf16[0x7cb7] = 0xe460;
	__map_gbk2utf16[0x7cb8] = 0xe461;
	__map_gbk2utf16[0x7cb9] = 0xe462;
	__map_gbk2utf16[0x7cba] = 0xe463;
	__map_gbk2utf16[0x7cbb] = 0xe464;
	__map_gbk2utf16[0x7cbc] = 0xe465;
	__map_gbk2utf16[0x7cbd] = 0xe466;
	__map_gbk2utf16[0x7cbe] = 0xe467;
	__map_gbk2utf16[0x7d00] = 0xfa0c;
	__map_gbk2utf16[0x7d01] = 0xfa0d;
	__map_gbk2utf16[0x7d02] = 0xfa0e;
	__map_gbk2utf16[0x7d03] = 0xfa0f;
	__map_gbk2utf16[0x7d04] = 0xfa11;
	__map_gbk2utf16[0x7d05] = 0xfa13;
	__map_gbk2utf16[0x7d06] = 0xfa14;
	__map_gbk2utf16[0x7d07] = 0xfa18;
	__map_gbk2utf16[0x7d08] = 0xfa1f;
	__map_gbk2utf16[0x7d09] = 0xfa20;
	__map_gbk2utf16[0x7d0a] = 0xfa21;
	__map_gbk2utf16[0x7d0b] = 0xfa23;
	__map_gbk2utf16[0x7d0c] = 0xfa24;
	__map_gbk2utf16[0x7d0d] = 0xfa27;
	__map_gbk2utf16[0x7d0e] = 0xfa28;
	__map_gbk2utf16[0x7d0f] = 0xfa29;
	__map_gbk2utf16[0x7d10] = 0xe815;
	__map_gbk2utf16[0x7d11] = 0xe816;
	__map_gbk2utf16[0x7d12] = 0xe817;
	__map_gbk2utf16[0x7d13] = 0xe818;
	__map_gbk2utf16[0x7d14] = 0xe819;
	__map_gbk2utf16[0x7d15] = 0xe81a;
	__map_gbk2utf16[0x7d16] = 0xe81b;
	__map_gbk2utf16[0x7d17] = 0xe81c;
	__map_gbk2utf16[0x7d18] = 0xe81d;
	__map_gbk2utf16[0x7d19] = 0xe81e;
	__map_gbk2utf16[0x7d1a] = 0xe81f;
	__map_gbk2utf16[0x7d1b] = 0xe820;
	__map_gbk2utf16[0x7d1c] = 0xe821;
	__map_gbk2utf16[0x7d1d] = 0xe822;
	__map_gbk2utf16[0x7d1e] = 0xe823;
	__map_gbk2utf16[0x7d1f] = 0xe824;
	__map_gbk2utf16[0x7d20] = 0xe825;
	__map_gbk2utf16[0x7d21] = 0xe826;
	__map_gbk2utf16[0x7d22] = 0xe827;
	__map_gbk2utf16[0x7d23] = 0xe828;
	__map_gbk2utf16[0x7d24] = 0xe829;
	__map_gbk2utf16[0x7d25] = 0xe82a;
	__map_gbk2utf16[0x7d26] = 0xe82b;
	__map_gbk2utf16[0x7d27] = 0xe82c;
	__map_gbk2utf16[0x7d28] = 0xe82d;
	__map_gbk2utf16[0x7d29] = 0xe82e;
	__map_gbk2utf16[0x7d2a] = 0xe82f;
	__map_gbk2utf16[0x7d2b] = 0xe830;
	__map_gbk2utf16[0x7d2c] = 0xe831;
	__map_gbk2utf16[0x7d2d] = 0xe832;
	__map_gbk2utf16[0x7d2e] = 0xe833;
	__map_gbk2utf16[0x7d2f] = 0xe834;
	__map_gbk2utf16[0x7d30] = 0xe835;
	__map_gbk2utf16[0x7d31] = 0xe836;
	__map_gbk2utf16[0x7d32] = 0xe837;
	__map_gbk2utf16[0x7d33] = 0xe838;
	__map_gbk2utf16[0x7d34] = 0xe839;
	__map_gbk2utf16[0x7d35] = 0xe83a;
	__map_gbk2utf16[0x7d36] = 0xe83b;
	__map_gbk2utf16[0x7d37] = 0xe83c;
	__map_gbk2utf16[0x7d38] = 0xe83d;
	__map_gbk2utf16[0x7d39] = 0xe83e;
	__map_gbk2utf16[0x7d3a] = 0xe83f;
	__map_gbk2utf16[0x7d3b] = 0xe840;
	__map_gbk2utf16[0x7d3c] = 0xe841;
	__map_gbk2utf16[0x7d3d] = 0xe842;
	__map_gbk2utf16[0x7d3e] = 0xe843;
	__map_gbk2utf16[0x7d40] = 0xe844;
	__map_gbk2utf16[0x7d41] = 0xe845;
	__map_gbk2utf16[0x7d42] = 0xe846;
	__map_gbk2utf16[0x7d43] = 0xe847;
	__map_gbk2utf16[0x7d44] = 0xe848;
	__map_gbk2utf16[0x7d45] = 0xe849;
	__map_gbk2utf16[0x7d46] = 0xe84a;
	__map_gbk2utf16[0x7d47] = 0xe84b;
	__map_gbk2utf16[0x7d48] = 0xe84c;
	__map_gbk2utf16[0x7d49] = 0xe84d;
	__map_gbk2utf16[0x7d4a] = 0xe84e;
	__map_gbk2utf16[0x7d4b] = 0xe84f;
	__map_gbk2utf16[0x7d4c] = 0xe850;
	__map_gbk2utf16[0x7d4d] = 0xe851;
	__map_gbk2utf16[0x7d4e] = 0xe852;
	__map_gbk2utf16[0x7d4f] = 0xe853;
	__map_gbk2utf16[0x7d50] = 0xe854;
	__map_gbk2utf16[0x7d51] = 0xe855;
	__map_gbk2utf16[0x7d52] = 0xe856;
	__map_gbk2utf16[0x7d53] = 0xe857;
	__map_gbk2utf16[0x7d54] = 0xe858;
	__map_gbk2utf16[0x7d55] = 0xe859;
	__map_gbk2utf16[0x7d56] = 0xe85a;
	__map_gbk2utf16[0x7d57] = 0xe85b;
	__map_gbk2utf16[0x7d58] = 0xe85c;
	__map_gbk2utf16[0x7d59] = 0xe85d;
	__map_gbk2utf16[0x7d5a] = 0xe85e;
	__map_gbk2utf16[0x7d5b] = 0xe85f;
	__map_gbk2utf16[0x7d5c] = 0xe860;
	__map_gbk2utf16[0x7d5d] = 0xe861;
	__map_gbk2utf16[0x7d5e] = 0xe862;
	__map_gbk2utf16[0x7d5f] = 0xe863;
	__map_gbk2utf16[0x7d60] = 0xe864;
	__map_gbk2utf16[0x7d61] = 0xe468;
	__map_gbk2utf16[0x7d62] = 0xe469;
	__map_gbk2utf16[0x7d63] = 0xe46a;
	__map_gbk2utf16[0x7d64] = 0xe46b;
	__map_gbk2utf16[0x7d65] = 0xe46c;
	__map_gbk2utf16[0x7d66] = 0xe46d;
	__map_gbk2utf16[0x7d67] = 0xe46e;
	__map_gbk2utf16[0x7d68] = 0xe46f;
	__map_gbk2utf16[0x7d69] = 0xe470;
	__map_gbk2utf16[0x7d6a] = 0xe471;
	__map_gbk2utf16[0x7d6b] = 0xe472;
	__map_gbk2utf16[0x7d6c] = 0xe473;
	__map_gbk2utf16[0x7d6d] = 0xe474;
	__map_gbk2utf16[0x7d6e] = 0xe475;
	__map_gbk2utf16[0x7d6f] = 0xe476;
	__map_gbk2utf16[0x7d70] = 0xe477;
	__map_gbk2utf16[0x7d71] = 0xe478;
	__map_gbk2utf16[0x7d72] = 0xe479;
	__map_gbk2utf16[0x7d73] = 0xe47a;
	__map_gbk2utf16[0x7d74] = 0xe47b;
	__map_gbk2utf16[0x7d75] = 0xe47c;
	__map_gbk2utf16[0x7d76] = 0xe47d;
	__map_gbk2utf16[0x7d77] = 0xe47e;
	__map_gbk2utf16[0x7d78] = 0xe47f;
	__map_gbk2utf16[0x7d79] = 0xe480;
	__map_gbk2utf16[0x7d7a] = 0xe481;
	__map_gbk2utf16[0x7d7b] = 0xe482;
	__map_gbk2utf16[0x7d7c] = 0xe483;
	__map_gbk2utf16[0x7d7d] = 0xe484;
	__map_gbk2utf16[0x7d7e] = 0xe485;
	__map_gbk2utf16[0x7d7f] = 0xe486;
	__map_gbk2utf16[0x7d80] = 0xe487;
	__map_gbk2utf16[0x7d81] = 0xe488;
	__map_gbk2utf16[0x7d82] = 0xe489;
	__map_gbk2utf16[0x7d83] = 0xe48a;
	__map_gbk2utf16[0x7d84] = 0xe48b;
	__map_gbk2utf16[0x7d85] = 0xe48c;
	__map_gbk2utf16[0x7d86] = 0xe48d;
	__map_gbk2utf16[0x7d87] = 0xe48e;
	__map_gbk2utf16[0x7d88] = 0xe48f;
	__map_gbk2utf16[0x7d89] = 0xe490;
	__map_gbk2utf16[0x7d8a] = 0xe491;
	__map_gbk2utf16[0x7d8b] = 0xe492;
	__map_gbk2utf16[0x7d8c] = 0xe493;
	__map_gbk2utf16[0x7d8d] = 0xe494;
	__map_gbk2utf16[0x7d8e] = 0xe495;
	__map_gbk2utf16[0x7d8f] = 0xe496;
	__map_gbk2utf16[0x7d90] = 0xe497;
	__map_gbk2utf16[0x7d91] = 0xe498;
	__map_gbk2utf16[0x7d92] = 0xe499;
	__map_gbk2utf16[0x7d93] = 0xe49a;
	__map_gbk2utf16[0x7d94] = 0xe49b;
	__map_gbk2utf16[0x7d95] = 0xe49c;
	__map_gbk2utf16[0x7d96] = 0xe49d;
	__map_gbk2utf16[0x7d97] = 0xe49e;
	__map_gbk2utf16[0x7d98] = 0xe49f;
	__map_gbk2utf16[0x7d99] = 0xe4a0;
	__map_gbk2utf16[0x7d9a] = 0xe4a1;
	__map_gbk2utf16[0x7d9b] = 0xe4a2;
	__map_gbk2utf16[0x7d9c] = 0xe4a3;
	__map_gbk2utf16[0x7d9d] = 0xe4a4;
	__map_gbk2utf16[0x7d9e] = 0xe4a5;
	__map_gbk2utf16[0x7d9f] = 0xe4a6;
	__map_gbk2utf16[0x7da0] = 0xe4a7;
	__map_gbk2utf16[0x7da1] = 0xe4a8;
	__map_gbk2utf16[0x7da2] = 0xe4a9;
	__map_gbk2utf16[0x7da3] = 0xe4aa;
	__map_gbk2utf16[0x7da4] = 0xe4ab;
	__map_gbk2utf16[0x7da5] = 0xe4ac;
	__map_gbk2utf16[0x7da6] = 0xe4ad;
	__map_gbk2utf16[0x7da7] = 0xe4ae;
	__map_gbk2utf16[0x7da8] = 0xe4af;
	__map_gbk2utf16[0x7da9] = 0xe4b0;
	__map_gbk2utf16[0x7daa] = 0xe4b1;
	__map_gbk2utf16[0x7dab] = 0xe4b2;
	__map_gbk2utf16[0x7dac] = 0xe4b3;
	__map_gbk2utf16[0x7dad] = 0xe4b4;
	__map_gbk2utf16[0x7dae] = 0xe4b5;
	__map_gbk2utf16[0x7daf] = 0xe4b6;
	__map_gbk2utf16[0x7db0] = 0xe4b7;
	__map_gbk2utf16[0x7db1] = 0xe4b8;
	__map_gbk2utf16[0x7db2] = 0xe4b9;
	__map_gbk2utf16[0x7db3] = 0xe4ba;
	__map_gbk2utf16[0x7db4] = 0xe4bb;
	__map_gbk2utf16[0x7db5] = 0xe4bc;
	__map_gbk2utf16[0x7db6] = 0xe4bd;
	__map_gbk2utf16[0x7db7] = 0xe4be;
	__map_gbk2utf16[0x7db8] = 0xe4bf;
	__map_gbk2utf16[0x7db9] = 0xe4c0;
	__map_gbk2utf16[0x7dba] = 0xe4c1;
	__map_gbk2utf16[0x7dbb] = 0xe4c2;
	__map_gbk2utf16[0x7dbc] = 0xe4c3;
	__map_gbk2utf16[0x7dbd] = 0xe4c4;
	__map_gbk2utf16[0x7dbe] = 0xe4c5;

	__is_init_g2u_map = 1;
	return ;
};

int tconv_single_utf16to8(uint16_t u16, unsigned char * u8)
{
	if (u16 <= 0x7f){
		u8[0] = (u16 & 0xff);
		return 1;
	}
	else if (u16 <= 0x7ff){
		u8[0] = 0xc0 | ((u16 & 0x7c0) >> 6);
		u8[1] = 0x80 | (u16 & 0x3f);
		return 2;
	}

	u8[0] = 0xe0 | ((u16 & 0xf000) >> 12);
	u8[1] = 0x80 | ((u16 & 0xfc0) >> 6);
	u8[2] = 0x80 | (u16 & 0x3f);
	return 3;
}

int tconv_gbk2utf8(const char * in, C2_SIZE ilen, char * out, C2_SIZE * olen)
{
	InitGbk2UtfMap();

	const unsigned char * pin = (const unsigned char *)in;
	unsigned char c1;
	unsigned char c2;
	C2_SIZE opos = 0;
	int wong_bytes = 0;
	C2_SIZE osize = *olen;
	C2_SIZE left = ilen;

	assert(in != NULL);
	assert(out != NULL);
	assert(olen != NULL);

	for (; (*pin) != '\0' && left > 0; ++pin){
		c1 = (unsigned char)(*pin);
		if (c1 <= 0x7f){
			if (opos + 1 >= osize){
				return -1;
			}
			out[opos++] = c1;
			--left;
			continue;
		}

		c2 = (unsigned char)(*++pin);
		left -= 2;
		if (c2 == '\0'){
			++wong_bytes;
			break;
		}

		if (TCONV_IS_GBK_CHAR(c1, c2)){
			C2_SIZE idx = ((int)c1 << 8) + c2 - 0x8140;
			uint16_t utf16 = __map_gbk2utf16[idx];
			if (utf16 == 0){
				utf16 = __wrong_padding_utf16;
				wong_bytes += 2;
			}
			
			if (opos + 3 >= osize){
				return -1;
			}
			opos += tconv_single_utf16to8(utf16, (unsigned char *)out + opos);
		}
		else{
			uint16_t utf16 = __wrong_padding_utf16;
			if (opos + 3 >= osize){
				return -1;
			}
			opos += tconv_single_utf16to8(utf16, (unsigned char *)out + opos);
			wong_bytes += 2;
		}
	}

	*(out + opos) = '\0';
	*olen = opos;

	return wong_bytes;
}


// 判断是否中文 utf8 编码
int IsUtf8Str(const char *sStr)
{
    const unsigned char *pc = (const unsigned char*)sStr;
	int iLen = (int)strlen((const char*)pc), i = 0, t = 0, hz = 0;
	while(iLen > i) {
		t = TCONV_UTF8_LENGTH_ALL(*pc);
		i += t;
		pc += t;
		if(t == 0)
			break;
		if(t == 3)
			++hz;
	}
	if(iLen == i && hz > 0)
		return 1;
	return 0;
}

int IsGbkStr(const char *sStr)
{
    int bHasGbk = 0;
    const unsigned char *pc = (const unsigned char*)sStr;
    for(; *pc != '\0'; pc++) {
        if(*pc <= 0x7f)
            continue;
        if(*pc >= 0x81 && *pc <= 0xfe && *(pc+1) >= 0x40) {
            pc++;
            bHasGbk = 1;
            continue;
        }    
        return 0;
    }    
    return bHasGbk;
}

