# Linux makefile for $(TARGET)

# This file can be generated by ./gensrclist.sh
include Makefile.srcs
include ../../make_env

# General configuration variables:
INCDIR = $(MTLIB_INCLUDE_PATH)/my_proto
LIBDIR = $(MTLIB_LIB_PATH)

TARGET  = myproto
LIBRARIES = 

MODULES = $(SRCS:.c=.o)
MODULES := $(MODULES:.cc=.o)

CXXFLAGS = $(CXXFLAGS_LIB)
CXXFLAGS += $(INCLUDE)
CFLAGS = $(CFLAGS_LIB)
CFLAGS += $(INCLUDE)

STATICLIB = lib$(TARGET).a
SHAREDLIB = lib$(TARGET)-$(VER_MAJOR).$(VER_MINOR).so
LIBNAME	= lib$(TARGET).so
VERLIBNAME = $(LIBNAME).$(VER_MAJOR)

default: all

all: dist

dist: $(TARGET)

dos2unix:
	@$(DOS2UNIX) $(SRCS) $(INCLS)

$(TARGET): $(SHAREDLIB) $(STATICLIB)

.c.o:
	$(CC) $(CFLAGS) -c $< -o $@

.cpp.o:
	$(CXX) $(CXXFLAGS) -c $< -o $@

$(STATICLIB): $(MODULES)
	$(AR) r $@ $(MODULES)

$(SHAREDLIB): $(MODULES)
	$(CC) -s -shared -Wl,-soname,$(VERLIBNAME) $(LDFLAGS) -o $@ $(MODULES) $(LIBRARIES)

install:
	install -d $(INCDIR) $(LIBDIR)
	install -m 644 $(INSTALL_INC) $(INCDIR)
	install -m 644 $(STATICLIB) $(LIBDIR)
	install -m 755 $(SHAREDLIB) $(LIBDIR)
	ln -sf $(SHAREDLIB) $(LIBDIR)/$(VERLIBNAME)
	ln -sf $(VERLIBNAME) $(LIBDIR)/$(LIBNAME)	

clean:
	rm -fr $(INCDIR)
	rm -f $(LIBDIR)/lib$(TARGET).* 
	rm -f $(LIBDIR)/lib$(TARGET)-* 
	rm -f $(MODULES) $(STATICLIB) $(SHAREDLIB) $(LIBNAME)


