<?php
/**
 * 框架助手函数库
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-08
 */
defined('WPHP_URI') or die('Access Denied');
/**
 * 获取单例模式
 * @param string $class 类名
 * @param mixed $args 参数
 * @return object 返回实例
 */
function get_instance($class, $args = null) {
	static $instances = array();
	if (!isset($instances[$class])) {
		$instances[$class] = is_null($args)? new $class() : new $class($args);
	}
	return $instances[$class];
}
/**
 * 获取模型类
 * @param string $table 要操作的表名
 * @return object 返回模型实例
 */
function M($table = '') {
	$model = get_instance('wiphp\Model', $table);	
	return $model;
}
/**
 * 获取自定义模型类
 * @param string $name 自定义的模型名称
 * @return object 返回模型实例
 */
function D($name) {
	$class = strtr('home/model/'.ucfirst($name).'Model', '/', '\\');
	return get_instance($class);
}
/**
 * 获取自定义Widget部件实例
 * @param string $name 自定义的Widget名称
 * @return object 返回Widget实例
 */
function W($name) {
	$class = strtr('home/widget/'.ucfirst($name).'Widget', '/', '\\');
	return get_instance($class);
}
/**
 * 获取自定义验证器实例
 * @param string $name 自定义的验证器名称
 * @param string $scene 验证器场景
 * @return object 返回验证器实例
 */
function validate($name, $scene = '*') {
	$class = strtr('home/validate/'.ucfirst($name).'Validate', '/', '\\');
	return get_instance($class, $scene);
}
/**
 * 获取分页类
 * @param int $total 总页数
 * @param int $psize 每页记录数
 * @param int $pn 当前页码
 * @param string $purl 当前url
 * @return object 返回分页实例 
 */
function P($total, $psize, $pn, $purl = '') {
	if ($purl != '') $purl = U($purl);
	return get_instance('wiphp\Page', [$total, $psize, $pn, $purl]);
}
/**
 * 生成url
 * @param string $route 路由
 * @param array $vars 参数
 * @param string $method 类型
 * @return string 返回生成url
 */
function U($route='', $vars=[], $method = '*'){
	$url = \wiphp\Route::getUrl($route, $vars, $method);
	return __URL__.$url;
}
/**
 * 获取或设置配置 
 * @param string $name 配置名称
 * @param string $val 要设置的配置值
 * @return array|string 返回的配置
 */
function C($name = '', $val = '') {
	return \wiphp\App::getConfig($name, $val);
}
/**
 * 获取$_GET或$_POST请求参数
 * @param string $name 变量名 
 * @param string $default 默认值
 * @param string $fns 过滤函数,过滤函数
 * @return string|array 返回请求参数
 */
function I($name = '', $default = '', $fns = '') {
	return \wiphp\App::getRequest($name, $default, $fns);
}
/**
 * 快捷缓存操作
 * @param string $name 缓存名称
 * @param mixed $value 要设置的值
 * @param number $time 有效时间
 * @return boolean 返回缓存操作结果
 */
function cache($name, $value = '', $time = 0) {
	if (is_null($name)) {
		return \wiphp\Cache::clear();
	} elseif ('' === $value) {
		return \wiphp\Cache::get($name);
	} elseif (is_null($value)) {
		return \wiphp\Cache::del($name);
	} else {
		return \wiphp\Cache::set($name, $value, $time);
	}
}
/**
 * 快捷session操作
 * @param string $name 名称
 * @param string $value 要设置的值
 * @return boolean|mixed 返回操作结果
 */
function session($name, $value = '') {
	if (!session_id()) session_start();
	if (is_null($name)) {
		$_SESSION = [];
		if(isset($_COOKIE[session_name()])) {
			setCookie(session_name(), "", time()-42000, "/");
		}
		session_destroy();
	} else {
		$name = APP_NAME.'_'.$name;
		if ('' === $value) {
			return isset($_SESSION[$name])? $_SESSION[$name] : false;
		} elseif (is_null($value)) {
			if (isset($_SESSION[$name])) unset($_SESSION[$name]);
		} else {
			$_SESSION[$name] = $value;
		}
	}
}
/**
 * 快捷cookie操作
 * @param string $name 名称
 * @param string $value 要设置的值
 * @return boolean|mixed 返回操作结果
 */
function cookie($name, $value = '') {
	$name = APP_NAME.'_'.$name;
	if ('' === $value) {
		return isset($_COOKIE[$name])? $_COOKIE[$name] : false;
	} elseif (is_null($value)) {
		if (isset($_COOKIE[$name])) unset($_COOKIE[$name]);
	} else {
		$_COOKIE[$name] = $value;
	}
}
/**
 * 用应用名参与md5加密
 * @param string $str 要加密的字符串
 * @return string 加密后的字符串
 */
function app_md5($str = '') {
	return md5(APP_NAME.$str);
}
/**
 * 生成token
 * @param string $name token名称
 * @return string 返回token值
 */
function get_token($name = '') {
	$name = !empty($name)? $name : 'token';
	if (!session($name)) {
		$token = md5(APP_NAME.time().rand(1,999));
		session($name, $token);
	} else {
		$token = session($name);
	}
	return $token;
}
/**
 * 验证token
 * @param string $token_name 名称 
 * @return boolean 验证结果
 */
function valid_token($name = '') {
	$name = !empty($name)? $name : 'token';
	$token  = I($name);
	if (!empty($token) && session($name) && session($name) == $token) {
		session($name, null);
		return true;
	}
	return false;
}
/**
 * 传变量到模板
 * @param string $name 变量名
 * @param mixed $value 值
 */
function assign($name, $value = null) {
	\wiphp\View::assign($name, $value);
}
/**
 * 显示模板 
 * @param string $file 模板文件名
 * @param array $vars 传入变量
 * @return string 返回输出模板
 */
function view($file = '', $vars = []) {
	return \wiphp\View::fetch($file, $vars);
}
/**
 * 返回支持中文json 
 * @param string $data 变量
 * @return string 返回json
 */
function json($data = '') {
	return json_encode($data, JSON_UNESCAPED_UNICODE);
}
/**
 * 变量测试输出
 * @param mixed $var 变量
 * @param boolean $echo 是否输出
 * @param string $label 制表符
 * @param string $strict
 * @return string 返回输出的变量
 */
function dump($var, $echo = true, $label = '', $strict = true) {
	$label = ($label == '') ? '' : rtrim($label) . ' ';
	if (!$strict) {
		if (ini_get('html_errors')) {
			$output = print_r($var, true);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		} else {
			$output = $label . print_r($var, true);
		}
	} else {
		ob_start();
		var_dump($var);
		$output = ob_get_clean();
		if (!extension_loaded('xdebug')) {
			$output = preg_replace('/\]\=\>\n(\s+)/m', '] => ', $output);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		}
	}
	if ($echo) {
		echo($output);
		return null;
	} else {
		return $output;
	}
}
/**
 * 转跳到url 
 * @param string $url 
 * @param number $time
 * @param string $msg
 */
function redirect($url, $time = 0, $msg = '') {
	$url = str_replace(array("\n", "\r"), '', $url);
	$msg = ($msg == '')? "系统将在{$time}秒之后自动跳转到{$url}！" : $msg;
	if (!headers_sent()) {
		if (0 === $time) {
			header('Location:'.$url);
		} else {
			header("refresh:{$time};url={$url}");
			echo $msg;
		}
		exit();
	} else {
		$str = "<meta http-equiv='Refresh' content='{$time};URL={$url}'>";
		if ($time != 0) $str .= $msg;
		exit($str);
	}
}
