<?php
/**
 * 常量定义与主程序引入
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-08
 */
defined('WPHP_URI') or die('Access Denied');
date_default_timezone_set('PRC'); //时区设置
define('START_TIME', microtime(true)); //开始时间
defined('URL_MODEL') or define('URL_MODEL', 1); //1.普通模式;2.隐藏index.php
define('WPHP_VER', 'v2.0_beta'); //框架版本号
define('__WPHP__', 'WillPHP '.WPHP_VER); //框架全称
define('__ROOT__', rtrim(dirname($_SERVER['SCRIPT_NAME']), '/')); //网站根目录
define('__PUBLIC__', __ROOT__.'/public'); //公共资源目录
define('__URL__', (URL_MODEL == 2)? str_replace('/index.php', '', $_SERVER['SCRIPT_NAME']) : $_SERVER['SCRIPT_NAME']); //基URL
defined('APP_NAME') or define('APP_NAME', str_replace('.','',basename($_SERVER['SCRIPT_FILENAME']))); //应用名称
defined('APP_MODE') or define('APP_MODE', 1); //1.单应用模式;2.多应用模式
defined('APP_TPLE') or define('APP_TPLE', ''); //模板引擎设置
defined('APP_DEBUG') or define('APP_DEBUG', false); //调试开关
define('APP_PATH', (APP_MODE == 1)? WPHP_URI.'/app' : WPHP_URI.'/app/'.APP_NAME); //应用目录
define('PATH_CORE', WPHP_PATH.'/wiphp'); //框架核心路径
define('PATH_TPLE', (APP_TPLE == '')? PATH_CORE : WPHP_PATH.'/tple/'.APP_TPLE); //模板引擎路径
define('PATH_VIEW', APP_PATH.'/view'); //模板文件路径
define('PATH_EXTEND', WPHP_URI.'/extend'); //扩展类库路径
define('PATH_RUNTIME', (APP_MODE == 1)? WPHP_URI.'/runtime' : WPHP_URI.'/runtime/'.APP_NAME); //编译运行路径
define('PATH_CACHE', PATH_RUNTIME.'/data'); //数据缓存路径
define('PATH_LOG', PATH_RUNTIME.'/log'); //错误日志路径
define('PATH_VIEWC', PATH_RUNTIME.'/viewc'); //模板编译路径
define('PATH_SHTML', PATH_RUNTIME.'/shtml'); //模板缓存路径
defined('SESSION_ON') or define('SESSION_ON', false); //session开关
if (SESSION_ON && !session_id()) session_start(); //是否自动开启session
require WPHP_PATH.'/helper.php'; //载入框架助手函数库
if (file_exists(WPHP_URI.'/app/common.php')) require WPHP_URI.'/app/common.php'; //载入用户函数库
require PATH_CORE.'/App.php'; //载入框架主程序
\wiphp\App::start(); //启动框架