<?php
/**
 * 框架调试类
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-17
 */
namespace wiphp;
class Debug {
	private static $debug = [];	
	//设置 debug
	public static function set($info, $type = 'info') {
		if (in_array($type, ['inc', 'sql', 'info'])) {			
			if ($type == 'inc') {		
				$sysclass = ['wiphp\Route','wiphp\Debug','wiphp\Db','wiphp\Cache','wiphp\ParseSql','wiphp\Widget','wiphp\Validate'];
				if (!in_array($info, $sysclass)) self::$debug[$type][] = $info;
			} else {
				self::$debug[$type][] = $info;
			}			
		}
	}
	//显示 debug
	public static function show() {
		$total_inc = isset(self::$debug['inc'])? count(self::$debug['inc']) : 0;
		$total_sql = isset(self::$debug['sql'])? count(self::$debug['sql']) : 0;
		$total_err = isset(self::$debug['info'])? count(self::$debug['info']) : 0;
		$title = __MODULE__.'-&gt'.__ACTION__.'()';
		$shtml = '<style type="text/css">*{padding: 0;margin:0;}</style><div class="debug" style="line-height:25px;font-size:14px;color:#888;padding:10px;margin:10px auto;background:#F5F5F5;border:1px dashed #666666;">';
		$shtml .= '<div style="height:20px;line-height:20px;clear:both;"><span style="float:left;width:220px;"><b>Debug：'.$title.'</b></span>';
		$shtml .= '<span style="float:right;">inc('.$total_inc.') sql('.$total_sql.') err('.$total_err.')';
		$shtml .= '<a href="#" style="color:green;" onclick="document.getElementById(\'debug\').style.display=\'block\'">[view]</a>';
		$shtml .= '<a href="#" style="color:green;" onclick="this.parentNode.parentNode.parentNode.style.display=\'none\'">[x]</a></span></div>';
		$shtml .= '<div id="debug" style="margin:0px;padding:0;display:none;">';
		if (isset(self::$debug['inc'])) {
			$shtml .= '<p>［Include]</p><ul style="list-style:none;padding-left:25px;">';
			foreach (self::$debug['inc'] as $class) {
				$shtml .= "<li>$class [class]</li>";
			}
			$shtml .= '</ul>';
		}
		if (isset(self::$debug['sql'])) {
			$shtml .= '<p>［Sql]</p><ul style="list-style:none;padding-left:25px;">';
			foreach (self::$debug['sql'] as $sql) {
				$shtml .= "<li>$sql</li>";
			}
			$shtml .= '</ul>';
		}
		if (isset(self::$debug['info'])) {
			$shtml .= '<p>［Error]</p><ul style="list-style:none;padding-left:25px;">';
			foreach (self::$debug['info'] as $err) {
				$shtml .= "<li>$err</li>";
			}
			$shtml .= '</ul>';
		}
		$shtml .= '<p>&copy;2020 <a href="http://www.113344.com/" target="_blank" style="color:#888;">113344.com</a>';
		$runtime = round((microtime(true) - START_TIME) , 4);
		$shtml .= ' DaSongzi Processed in <font color="green">'.$runtime.'</font> s Power By '.__WPHP__.'</p></div></div>';
		echo $shtml;
		exit();
	}
}