<?php
/**
 * 控制器内跳转 Trait
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-13
 */
namespace wiphp;
trait Jump {
	/**
	 * 是否ajax返回
	 * @var boolean
	 */
	public $isAjax = false;
	/**
	 * 操作成功跳转
	 * @access protected
	 * @param  mixed $msg 提示信息
	 * @param  string $url 跳转的URL地址
	 * @return void
	 */
	protected function success($msg = '', $url = null) {
		$url = is_null($url)? '' : U($url);
		$result = ['status' => 1, 'info' => $msg, 'url' => $url];
		$ajax = I('ajax', 0);
		if ($ajax == 1 || $this->isAjax) {
			exit(json($result));
		}
		view('public:jump', $result);
	}
	/**
	 * 操作错误跳转
	 * @access protected
	 * @param  mixed $msg 提示信息
	 * @param  string $url 跳转的URL地址
	 * @return void
	 */
	protected function error($msg = '', $url = null) {
		$url = is_null($url)? 'javascript:history.back(-1);' : U($url);
		$result = ['status' => 0, 'info' => $msg, 'url' => $url];
		$ajax = I('ajax', 0);
		if ($ajax == 1 || $this->isAjax) {
			exit(json($result));
		} 	
		view('public:jump', $result);
		exit();
	}
	/**
	 * 操作跳转合同并
	 * @access protected
	 * @param mixed $info 提示信息
	 * @param number $result 操作结果
	 * @param string $url 跳转的URL地址
	 * @return void
	 */
	protected function _jump($info, $result = 0, $url = null) {
		$msg = [];
		if (is_array($info)) {
			$msg = $info;
		} else {
			$msg[0] = $msg[1] = $info;
		}
		if ($result) {
			$this->success($msg[0], $url);
		} else {
			$this->error($msg[1]);
		}
	}
	/**
	 * URL重定向
	 * @access protected
	 * @param  string $url 跳转的URL表达式
	 * @return void
	 */
	protected function _url($url) {
		redirect(U($url));
	}
}