<?php
/**
 * 框架模型类
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-10
 */
namespace wiphp;
class Model {
	protected $options = [];
	protected $name = '';
	protected $pk = 'id';
	protected $db = false;
	protected $method = ['table','field','where','order','limit', 'test'];	
	
	public function __construct($name = '') {		
		$this->db = Db::factory();
		if ($name != '') {
			$this->name = $name;				
		}
		$this->options['table'] = $this->name;
	}	
	//返回上次执行的sql
	public function getLastSql() {
		return $this->db->getLastSql();	
	}	
	public function __destruct() {		
		$this->db = false;
	}
	public function __call($method, $args) {
		$method = strtolower($method);
		if (in_array($method, $this->method)) {
			if ($method == 'test') {				
				$this->options['test'] = 1;
			} elseif ($method == 'where' && !empty($args[0])) {				
				if (count($args[0]) != count($args[0], 1)) {
					foreach ($args[0] as $arg) {
						$this->options[$method][] = $arg;
					}
				} else {
					$this->options[$method][] = $args;
				}				
			} else {
				$this->options[$method] = $args[0];
			}			
			return $this;
		}
	}
	public function __get($property) {
		if (isset($this->options[$property])) return $this->options[$property];
	}	
	public function __set($property, $value) {
		if (in_array($property, $this->method)) {
			$this->options[$property] = $value;			
		}
	}
	//直接执行sql
	public function exectute($sql) {
		return $this->db->exectute($sql);
	}
	//对sql语句中特殊字符转义
	public function cleanString($string) {
		return $this->db->cleanString($string);
	}
	//清除选项
	protected function _clear_options() {
		$this->db->isTest = isset($this->options['test'])? true : false;	
		$table = $this->options['table'];
		$this->options = [];
		$this->options['table'] = $table;
	}	
	//记录条数
	public function count() {		
		$sql = ParseSql::getCountSql($this->options);
		$this->_clear_options();		
		return $this->db->getCount($sql);
	}
	//单条记录
	public function find($pk = '') {
		$this->options['limit'] = 1;
		if (!empty($pk)) $this->options['field'] = $pk;
		$sql = ParseSql::getQuerySql($this->options);			
		$this->_clear_options();		
		return $this->db->getOne($sql);
	}
	//多条记录
	public function select() {
		$sql = ParseSql::getQuerySql($this->options);		
		$this->_clear_options();
		return $this->db->getAll($sql);
	}
	//获取field
	public function getField($field) {
		$this->options['field'] = $field;
		$sql = ParseSql::getQuerySql($this->options);		
		$this->_clear_options();
		if(strpos($field, ',')) {
			$data = $this->db->getAll($sql);
			$fdata = [];
			if (!empty($data)) {
				list($k, $v) = explode(',', $field);
				foreach ($data as $val) {
					$fdata[$val[$k]] = $val[$v];
				}
			}
			return $fdata;
		} else {
			$data = $this->db->getOne($sql);
			return $data[$field];
		}
	}	
	//删除操作
	public function del() {
		$sql = ParseSql::getDelSql($this->options);		
		$this->_clear_options();
		return $this->db->exectute($sql);
	}
	//添加
	public function add($data) {
		if (!empty($data)) {			
			$sql = ParseSql::getSaveSql($this->options, $data);				
			$this->_clear_options();			
			$this->db->exectute($sql);
			return $this->db->getLastId();
		}
		return false;
	}
	//更新
	public function update($data) {
		if (!empty($data)) {
			$pk = $this->pk;
			if (isset($this->options['where']) || isset($data[$pk])) {
				$sql = ParseSql::getSaveSql($this->options, $data, $pk);				
				$this->_clear_options();
				return $this->db->exectute($sql);
			}			
		}
		return false;
	}	
	//保存
	public function save($data, $pk = '') {
		if (!empty($data)) {
			$pk = ($pk == '')? $this->pk : $pk;
			$sql = ParseSql::getSaveSql($this->options, $data, $pk);
			//dump($sql);exit;
			if (isset($this->options['where']) || isset($data[$pk])) {				
				$this->_clear_options();
				return $this->db->exectute($sql);
			} else {				
				$this->_clear_options();
				$this->db->exectute($sql);
				return $this->db->getLastId();
			}
		}
		return false;
	}
	//设置field
	public function setField($field, $value) {
		if (!isset($this->options['table'], $this->options['where'])) return false;
		$sql = ParseSql::getSaveSql($this->options, [$field => $value]);		
		$this->_clear_options();
		return $this->db->exectute($sql);		
	}
	//设置field + 1
	public function setInc($field, $num = 1) {
		$value = $field.'+'.intval($num);
		$sql = ParseSql::getFieldSql($field, $value, $this->options);		
		$this->_clear_options();
		return $this->db->exectute($sql);
	}
	//设置field - 1
	public function setDec($field, $num = 1) {
		$value = $field.'-'.intval($num);
		$sql = ParseSql::getFieldSql($field, $value, $this->options);		
		$this->_clear_options();
		return $this->db->exectute($sql);
	}
}