<?php
/**
 * 框架模板引擎类
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-08
 */
class Tple {
	private function __construct() {}
	private function __clone() {}
	
	public static function render($vfile, $_vars = []) {
		$shtml_open = C('shtml_open');
		if (!$shtml_open || basename($vfile) == 'jump.shtml') {
			self::renderTo($vfile, $_vars);
		} else {
			$params = http_build_query(I());
			$sfile = md5(__MODULE__.basename($vfile).$params).'.shtml';
			$sfile = PATH_SHTML.'/'.$sfile;
			$ntime = time();
			$shtml_time = max(10, intval(C('shtml_time')));
			if (is_file($sfile) && filemtime($sfile) > ($ntime - $shtml_time)) {
				include $sfile;				
			} else {
				ob_start();
				self::renderTo($vfile, $_vars);
				$content = ob_get_contents();
				file_put_contents($sfile, $content);
			}
		}
	}	
	public static function renderTo($vfile, $_vars = []) {
		$m = strtolower(__MODULE__);
		$cfile = 'view-'.$m.'_'.basename($vfile).'.php';
		if (basename($vfile) == 'jump.html') {
			$cfile = 'view-jump.html.php';
		}
		$cfile = PATH_VIEWC.'/'.$cfile;
		if (APP_DEBUG || !file_exists($cfile) || filemtime($cfile) < filemtime($vfile)) {
			$strs = self::comp(file_get_contents($vfile), $_vars);
			file_put_contents($cfile, $strs);
		}
		extract($_vars);
		include $cfile;
	}	
	private static function comp($strs, $_vars = []) {
		$varn = '([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)';		
		$strs = preg_replace_callback('/\{\s*include\s+[\"\']?(.+?)[\"\']?\s*\}/i',function ($match) {
			return file_get_contents(PATH_VIEW.'/'.$match[1]);
		}, $strs);		
		if (preg_match('/\{\s*include\s+[\"\']?(.+?)[\"\']?\s*\}/i', $strs)) {
			$strs = preg_replace_callback('/\{\s*include\s+[\"\']?(.+?)[\"\']?\s*\}/i',function ($match) {
				return file_get_contents(PATH_VIEW.'/'.$match[1]);
			}, $strs);
		}	
		$pats = [
				'/__(\w+)__/i',
				'/\{\s*\$'.$varn.'\s*\}/i',
				'/\{\s*\$'.$varn.'\.'.$varn.'\s*\}/i',
				'/\{\s*\$'.$varn.'\[[\'"]'.$varn.'[\'"]\]\s*\}/i',
				'/\{\s*if\s*(.+?)\s*\}/i',
				'/\{\s*\/(foreach|if)\s*\}/i',
				'/\{\s*(else if|elseif)\s*(.+?)\s*\}/i',
				'/\{\s*else\s*\}/i',
				'/\{\s*foreach\s+\$'.$varn.'\s+as\s+\$'.$varn.'\s*\}/i',
				'/\{\s*foreach\s+\$'.$varn.'\s+as\s+\$'.$varn.'\s*=>\s*\$'.$varn.'\s*\}/i',
				'/\{\s*empty\s+\$'.$varn.'\s*\}/i',
				'/\{\s*:'.$varn.'\((.*?)\)\s*\}/i',
				'/\{\s*:'.$varn.'\((.*?)\)\->'.$varn.'\((.*?)\)\s*\}/i',
				'/\{\s*var\s+\$'.$varn.'\s*=\s*(.+?)\s*\}/i',
				'/\{\s*\$'.$varn.'\|'.$varn.'\s*\}/i',
				'/\{\s*\$'.$varn.'\.'.$varn.'\|'.$varn.'\s*\}/i',
				'/\{\s*\$'.$varn.'\[[\'"]'.$varn.'[\'"]\]\|'.$varn.'\s*\}/i',
				'/\{\s*\$'.$varn.'\|'.$varn.'=(.+?)\s*\}/i',
				'/\{\s*\$'.$varn.'\.'.$varn.'\|'.$varn.'=(.+?)\s*\}/i',
				'/\{\s*\$'.$varn.'\[[\'"]'.$varn.'[\'"]\]\|'.$varn.'=(.+?)\s*\}/i',
		];
		$reps = [
				'<?php echo __\\1__; ?>',
				'<?php echo $\\1; ?>',
				'<?php echo $\\1[\'\\2\']; ?>',
				'<?php echo $\\1[\'\\2\']; ?>',
				'<?php if (\\1) {?>',
				'<?php }?>',
				'<?php }elseif (\\2) {?>',
				'<?php }else {?>',
				'<?php foreach((array)$\\1 as $\\2) { ?>',
				'<?php foreach((array)$\\1 as $\\2 => $\\3) { ?>',
				'<?php } if (empty($\\1)) { ?>',
				'<?php echo \\1(\\2); ?>',
				'<?php echo \\1(\\2)->\\3(\\4); ?>',
				'<?php $\\1 = \\2; ?>',
				'<?php echo \\2($\\1); ?>',
				'<?php echo \\3($\\1[\'\\2\']); ?>',
				'<?php echo \\3($\\1[\'\\2\']); ?>',
				'<?php echo \\2($\\1,\\3); ?>',
				'<?php echo \\3($\\1[\'\\2\'],\\4); ?>',
				'<?php echo \\3($\\1[\'\\2\'],\\4); ?>',
		];
		$strs = preg_replace($pats, $reps, $strs);
		return $strs;							
	}
}