<?php
/**
 * 框架视图处理类
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-08
 */
namespace wiphp;
require PATH_TPLE.'/Tple.php';
class View {
	private static $_vars = [];
	public static function assign($name, $value = NULL) {
		if ($name != '') self::$_vars[$name] = $value;
	} 
	public static function fetch($file = '', $vars = []) {
		if (!empty($vars)) self::$_vars = array_merge(self::$_vars, $vars);
		$path = __MODULE__;
		if ($file == '') {
			$file = __ACTION__;
		} elseif (strpos($file, ':')) {
			list($path,$file) = explode(':', $file);
		} elseif (strpos($file, '/')) {
			$path = '';
		}
		if ($path == '') {
			$vfile = PATH_VIEW.'/'.$file.'.html';
		} else {
			$path = strtolower($path);
			$vfile = PATH_VIEW.'/'.$path.'/'.$file.'.html';
		}	
		if (!file_exists($vfile)) {
			App::halt($file.' 模板文件不存在。');
		} else {
			define('__RUNTIME__', App::getRuntime());			
			\Tple::render($vfile, self::$_vars);
		}		
	}
}