<?php
/**
 * 框架部件基类
 * @copyright Copyright(c) 2020 WillPHP
 * @author DaSongzi <24203741@qq.com/113344.com>
 * @version 2.0
 * @since 2020-09-08
 */
namespace wiphp; 
abstract class Widget {
	protected $name = '';
	protected $time = 0;	
	public function getData($sid = '', $options = []) {
		$name = $this->name.$sid;
		$data = Cache::get($name);
		if (!$data) {
			$data = $this->setData($sid, $options);
			if ($data) {
				Cache::set($name, $data, $this->time);
			}
		}
		return $data;
	}
	public function delData($sid = '') {	
		return Cache::del($this->name.$sid);
	}
	abstract public function setData($sid = '', $options = []);
}