var Tour = (function(){
    var t = [],
        o, cur
    T = {
        step: {
            pl: "krok",
            en: "Step",
            be: "ĞºÑ€Ğ¾Ğº",
            ca: "pas",
            cs: "krok",
            da: "trin",
            de: "Schritt",
            el: "Î²Î®Î¼Î±",
            es: "paso",
            et: "samm",
            fi: "vaihe",
            fr: "Ã©tape",
            hu: "lÃ©pÃ©s",
            it: "passo",
            lt: "Å¾ingsnis",
            lv: "solis",
            mk: "Ñ‡ĞµĞºĞ¾Ñ€",
            nl: "Stap",
            no: "trinn",
            pt: "passo",
            ru: "ÑˆĞ°Ğ³",
            sk: "krok",
            sl: "korak",
            sq: "hapi",
            sv: "steg",
            tr: "adÄ±m",
            uk: "ĞºÑ€Ğ¾Ğº"
        },
        Next: {
            pl: "NastÄ™pny",
            en: "Next",
            be: "Ğ”Ğ°Ğ»ĞµĞ¹",
            ca: "SegÃ¼ent",
            cs: "DalÅ¡Ã­",
            da: "NÃ¦ste",
            de: "Weiter",
            el: "Î¤Î·Î½ ÎµÏ€ÏŒÎ¼ÎµÎ½Î·",
            es: "Siguiente",
            et: "JÃ¤rgmine",
            fi: "Seuraava",
            fr: "Prochaine",
            hu: "KÃ¶vetkezÅ‘",
            it: "Accanto",
            lt: "Kitas",
            lv: "NÄkamÄ",
            mk: "Ğ¡Ğ»ĞµĞ´Ğ½Ğ°",
            nl: "Volgende",
            no: "Neste",
            pt: "PrÃ³ximo",
            ru: "Ğ”Ğ°Ğ»ĞµĞµ",
            sk: "Äalej",
            sl: "Naprej",
            sq: "TjetÃ«r",
            sv: "NÃ¤sta",
            tr: "Gelecek",
            uk: "Ğ”Ğ°Ğ»Ñ–"
        },
        Previous: {
            pl: "Poprzedni",
            en: "Previous",
            be: "ĞŸĞ°Ğ¿ÑÑ€ÑĞ´Ğ½Ñ–",
            ca: "Anteriors",
            cs: "PÅ™edchozÃ­",
            da: "Tidligere",
            de: "Vorherige",
            el: "Î ÏÎ¿Î·Î³Î¿ÏÎ¼ÎµÎ½Î¿",
            es: "Anterior",
            et: "Eelmine",
            fi: "Edellinen",
            fr: "PrÃ©cÃ©dente",
            hu: "ElÅ‘zÅ‘",
            it: "Precedente",
            lt: "Ankstesnis",
            lv: "IepriekÅ¡Ä“jÄ",
            mk: "ĞŸÑ€ĞµÑ‚Ñ…Ğ¾Ğ´Ğ½Ğ°",
            nl: "Vorige",
            no: "Tidligere",
            pt: "Anterior",
            ru: "ĞŸÑ€ĞµĞ´Ñ‹Ğ´ÑƒÑ‰Ğ¸Ğ¹",
            sk: "PredchÃ¡dzajÃºce",
            sl: "PrejÅ¡nji",
            sq: "E mÃ«parshme",
            sv: "FÃ¶regÃ¥ende",
            tr: "Ã–nceki",
            uk: "ĞŸĞ¾Ğ¿ĞµÑ€ĞµĞ´Ğ½Ñ–Ğ¹"
        },
        Finish: {
            pl: "ZakoÅ„cz",
            en: "Finish",
            be: "ĞĞ·Ğ´Ğ°Ğ±Ğ»ĞµĞ½Ğ½Ğµ",
            ca: "Acabat",
            cs: "DokonÄit",
            da: "Finish",
            de: "Finish",
            el: "Î¤ÎµÎ»ÎµÎ¹ÏÎ½ÎµÎ¹",
            es: "Acabado",
            et: "LÃµpeta",
            fi: "Loppuun",
            fr: "Finition",
            hu: "BefejezÃ©s",
            it: "Finitura",
            lt: "Apdaila",
            lv: "Apdare",
            mk: "Ğ—Ğ°Ğ²Ñ€ÑˆĞ¸",
            nl: "Afwerking",
            no: "Ferdig",
            pt: "Acabamento",
            ru: "ĞÑ‚Ğ´ĞµĞ»ĞºĞ°",
            sk: "Povrch",
            sl: "ZakljuÄek",
            sq: "Finish",
            sv: "Avsluta",
            tr: "Bitir",
            uk: "ĞĞ·Ğ´Ğ¾Ğ±Ğ»ĞµĞ½Ğ½Ñ"
        }
    };

    function _t(s)
    {
        return typeof T[s][t[cur].language] == 'undefined' ? T[s]['en'] : T[s][t[cur].language];
    }

    function step(n)
    {
        cur = n;
        $('.tourStep, .tourBg').remove();

        if (!t[n])
        {
            return;
        }
        $('body').append('<div class="tourStep popover" step="' + n + '"><div class="arrow"></div><div class="popover-body">' + t[n].content + '</div><div class="popover-navigation"><span>' + _t('step') + ' ' + (n + 1) + ' / ' + t.length + '</span><div class="popover-navigation-buttons"><button class="tourPrev btn btn-light btn-sm">' + _t('Previous') + '</button><button class="tourNext btn btn-primary btn-sm">' + _t('Next') + '</button></div></div>');
        var el = $('.tourStep')
            .addClass(t[n].position)
            .css({
                minWidth: 250
            }),
            x = 0,
            y = 0;

        if (t[n].element && !!t[n].element.length)
        {
            var x1 = 1e6,
                y1 = 1e6,
                x2 = 0,
                y2 = 0;

            t[n].element.each(function(k, v){
                var ofs = $(v).offset();
                x1 = Math.min(x1, ofs.left);
                y1 = Math.min(y1, ofs.top);

                x2 = Math.max(x2, ofs.left
                    + parseInt($(v).css('border-left-width'))
                    + parseInt($(v).css('padding-left'))
                    + $(v).width()
                    + parseInt($(v).css('padding-right'))
                    + parseInt($(v).css('border-right-width'))
                );

                y2 = Math.max(y2, ofs.top
                    + parseInt($(v).css('border-top-width'))
                    + parseInt($(v).css('padding-top'))
                    + $(v).height()
                    + parseInt($(v).css('padding-bottom'))
                    + parseInt($(v).css('border-bottom-width'))
                );
            });

            switch (t[n].position)
            {
                case 'top':
                    y = y1 - el.height();
                    x = ((x1 + x2) >> 1) - (el.width() >> 1);
                    break;

                case 'right':
                    y = ((y1 + y2) >> 1) - (el.height()>> 1);
                    x = x2;
                    break;

                case 'left':
                    y = ((y1 + y2) >> 1) - (el.height()>> 1);
                    x = x1 - el.width();
                    break;

                case 'bottom':
                    y = y2;
                    x = ((x1 + x2) >> 1) - (el.width() >> 1);
                    break;
            };
        };

        el
            .css({
                position: 'absolute',
                left: x,
                top: y
            })
            .show();

        if (t[n].spotlight)
        {
            var p = t[n].padding;
            $('body').append(Array(5).join('<div class="tourBg"></div>'));

            var pos = [
                {
                    bottom: 'auto',
                    height: y1 - p
                },
                {
                    top: y2 + p,
                    height: $(document).height() - y2 - p
                },
                {
                    right: 'auto',
                    bottom: 'auto',
                    top: y1 - p,
                    width: x1 - p,
                    height: 2 * p + y2 - y1
                },
                {
                    left: x2 + p,
                    bottom: 'auto',
                    top: y1 - p,
                    height: 2 * p + y2 - y1
                }
            ];

            $('.tourBg')
                .css({
                    position: 'absolute',
                    zIndex: 1000,
                    top: 0,
                    bottom: 0,
                    right: 0,
                    left: 0,
                    background: '#000',
                    opacity: 0.3
                }).each(function(k, v){
                $(v).css(pos[k]);
            });
        }

        if (!!t[n].scroll)
        {
            var my = ((Math.min(y, y1) + Math.max(y + el.height(), y2)) >> 1) - ($(window).height() >> 1),
                mx = ((Math.min(x, x1) + Math.max(x + el.width(),  x2)) >> 1) - ($(window).width()  >> 1);

            $('html, body').animate({
                scrollTop:  Math.max(0, Math.min(y, y1, my)),
                scrollLeft: Math.max(0, Math.min(x, x1, mx))
            });
        }

        if (!n)
        {
            $('.tourPrev').remove();
        }

        if (n > t.length - 2)
        {
            $('.tourNext').text(_t('Finish'));
        }

        $('.tourNext').click(Tour.next);
        $('.tourPrev').click(Tour.prev);
        $('.tourClose').click(Tour.close);
    }

    $(window).on('resize', function(){
        if (!!Tour.onresize)
        {
            Tour.onresize();
        }
    });

    return {
        run: function(tour, options){
            try
            {
                t = [];
                cur = 0;

                o = {
                    close: true,
                    content: '',
                    language: 'en',
                    padding: 5,
                    position: 'right',
                    scroll: true,
                    spotlight: true
                };

                for (var k in options)
                {
                    o[k] = options[k];
                }

                $(tour).each(function(k, v){
                    for (var kk in o)
                    {
                        if (typeof v[kk] == 'undefined')
                        {
                            v[kk] = o[kk];
                        }
                    };

                    if (v.element && !!v.element.length)
                    {
                        t.push(v);
                    }
                });

                step(cur);

                if (!!Tour.onstart)
                {
                    Tour.onstart();
                }
            }
            catch(e)
            {}
        },

        next: function(){
            step(cur + 1);

            if (cur < t.length)
            {
                if (!!Tour.onstep)
                {
                    Tour.onstep(t[cur]);
                }
            }
            else if (cur == t.length)
            {
                if (!!Tour.onfinish)
                {
                    Tour.onfinish();
                }
            }
        },

        prev: function(){
            step(cur - 1);

            if (cur >= 0)
            {
                if (!!Tour.onstep)
                {
                    Tour.onstep(t[cur]);
                }
            }
        },

        current: function(){
            return cur;
        },

        close: function(){
            step(-1);

            if (!!Tour.onclose)
            {
                Tour.onclose();
            }
        },

        onstart: null,
        onfinish: null,
        onclose: null,
        onstep: null,

        onresize: function(){
            var n = cur - 1;
            step(-1);
            cur = n;

            setTimeout(function(){
                Tour.next();
            }, 20);
        }
    };
})();