#
# TABLE STRUCTURE FOR: sh_shop
#

DROP TABLE IF EXISTS sh_shop;

CREATE TABLE `sh_shop` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `sid` bigint(20) unsigned NOT NULL default '0',
  `cid` int(10) unsigned NOT NULL default '0',
  `title` varchar(50) NOT NULL default '',
  `nick` varchar(50) NOT NULL default '',
  `shop_url` varchar(255) NOT NULL default '',
  `pic_path` varchar(255) NOT NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `btitle` varchar(100) NOT NULL default '',
  `keyword` varchar(100) NOT NULL default '',
  `description` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`),
  KEY `sid` (`sid`),
  KEY `seqorder` (`seqorder`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (3, 188124207, 5, '唐狮官方旗舰店', '唐狮官方旗舰店', 'http://tonlion.tmall.com/', 'http://logo.taobao.com/shop-logo/b9/e0/T1461cXl4rXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (4, 362409818, 5, '妖精的口袋旗舰店', '妖精的口袋旗舰店', 'http://yaojingdekoudai.tmall.com/', 'http://logo.taobao.com/shop-logo/72/a4/T1nLd_XcJfXXb1upjX', 0, '', '妖精的口袋旗舰店', '妖精的口袋旗舰店');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (5, 130974249, 5, '茵曼旗舰店', '茵曼旗舰店', 'http://inman.tmall.com/', 'http://logo.taobao.com/shop-logo/13/eb/T1t4O2FlXfXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (6, 279839, 5, '百分之一女装店', 'kamozi', 'http://100f1.taobao.com/', 'http://logo.taobao.com/shop-logo/f4/d3/T1J4IMXjNcXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (7, 1200778, 5, '柚子美衣清新实用百搭', '宜佳', 'http://0077.taobao.com/', 'http://logo.taobao.com/shop-logo/0a/b4/T10sSCXntZXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (8, 94153930, 5, 'osa品牌服饰旗舰店', 'osa品牌服饰旗舰店', 'http://osa.tmall.com/', 'http://logo.taobao.com/shop-logo/a8/93/T1jTFqXzxaXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (9, 228784630, 5, '裂帛服饰旗舰店', '裂帛服饰旗舰店', 'http://ripfs.tmall.com/', 'http://logo.taobao.com/shop-logo/48/b5/T1_WQhXhRbXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (10, 263817957, 5, '韩都衣舍旗舰店', '韩都衣舍旗舰店', 'http://handuyishe.tmall.com/', 'http://logo.taobao.com/shop-logo/63/a7/T1CnGeXcxzXXartXjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (11, 387906558, 4, '七匹狼立淘专卖店', '七匹狼立淘专卖店', 'http://septwolveslt.tmall.com/', 'http://logo.taobao.com/shop-logo/e6/bd/T1BgnOXkhdXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (12, 688058032, 4, '罗蒙官方旗舰店', '罗蒙官方旗舰店', 'http://romon.tmall.com/', 'http://logo.taobao.com/shop-logo/a0/3b/T10uJ9XoJDXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (13, 369386575, 4, '与狼共舞官方旗舰店', '与狼共舞官方旗舰店', 'http://dwolvesfs.tmall.com/', 'http://logo.taobao.com/shop-logo/99/ee/T1qVygXblnXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (14, 293015773, 4, '九牧王官方旗舰店', '九牧王官方旗舰', 'http://joeone.tmall.com/', 'http://logo.taobao.com/shop-logo/19/74/T1_shAXghBXXb1upjX.jpg', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (15, 268466435, 4, '诺奇旗舰店', '诺奇旗舰店', 'http://nuoqi.tmall.com/', 'http://logo.taobao.com/shop-logo/ab/86/T1iUeGFetgXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (16, 360260087, 4, '衣品天成旗舰店', '衣品天成旗舰店', 'http://yipintiancheng.tmall.com/', 'http://logo.taobao.com/shop-logo/1e/e4/T1EfKuXtteXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (17, 92414496, 4, 'SPORTICA旗舰店', 'sportica旗舰店', 'http://sportica.tmall.com/', 'http://logo.taobao.com/shop-logo/be/23/T1pNJkFl8bXXaHvGbX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (18, 381731325, 4, '太子龙官方旗舰店', '太子龙官方旗舰店', 'http://tedelon.tmall.com/', 'http://logo.taobao.com/shop-logo/db/a7/T1fK9UXmNgXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (19, 70492495, 3, '膜法世家集市第一店', '膜法世家', 'http://mofashijia.taobao.com/', 'http://logo.taobao.com/shop-logo/1f/b3/T1V7VyXg0sXXartXjX.gif', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (20, 273162744, 3, 'beely旗舰店', 'beely旗舰店', 'http://beely.tmall.com/', 'http://logo.taobao.com/shop-logo/23/37/T1UiM2Xo4gXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (21, 23458207, 3, '西溪漫步化妆品店', '西溪漫步', 'http://myxixi.taobao.com/', 'http://logo.taobao.com/shop-logo/8e/19/T1w0wBXi8fXXaCwpjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (22, 394316726, 3, '曼秀雷敦旗舰店', '曼秀雷敦旗舰店', 'http://mentholatum.tmall.com/', 'http://logo.taobao.com/shop-logo/c6/6a/T1fnynXi42XXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (23, 379424083, 3, '珀莱雅官方旗舰店', '珀莱雅官方旗舰店', 'http://proya.tmall.com/', 'http://logo.taobao.com/shop-logo/2a/b2/T1BGi0XlXcXXartXjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (24, 515369883, 3, '佰草集官方旗舰店', '佰草集官方旗舰店', 'http://herborist.tmall.com/', 'http://logo.taobao.com/shop-logo/05/fb/T178OQXfxgXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (25, 797010937, 3, 'fanxishop凡茜旗舰店', 'fanxishop凡茜旗舰店', 'http://fanxishop.tmall.com/', 'http://logo.taobao.com/shop-logo/68/98/T1_KuIXjFrXXartXjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (26, 90919986, 3, '相宜本草官方旗舰店', '相宜本草丽人丽妆', 'http://xybc.tmall.com/', 'http://logo.taobao.com/shop-logo/c2/ca/T1p5qpXox6XXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (27, 94298837, 3, '御泥坊旗舰店', '御泥坊旗舰店', 'http://yunifang.tmall.com/', 'http://logo.taobao.com/shop-logo/71/af/T18ridXlVlXXartXjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (28, 39443506, 2, '【上上屋】女鞋第一金冠店', 'xizier1985', 'http://shangshangwu.taobao.com/', 'http://logo.taobao.com/shop-logo/99/d4/T1L0R1XcJEXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (29, 52263104, 2, '菲菲美鞋 女鞋专家！2013春夏美鞋火热发售！', '菲菲时尚购物网', 'http://fairyfei.taobao.com/', 'http://logo.taobao.com/shop-logo/83/1b/T1oZmhXntfXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (30, 353042333, 2, '天美意teenmix官方旗舰店', '天美意官方旗舰店', 'http://teenmix.tmall.com/', 'http://logo.taobao.com/shop-logo/15/55/T1vbibXiRcXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (31, 281917995, 2, '千百度官方旗舰店', '千百度官方旗舰店', 'http://cbanner.tmall.com/', 'http://logo.taobao.com/shop-logo/cc/10/T1MjedXpdiXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (32, 260030441, 2, '红蜻蜓品牌旗舰店', '红蜻蜓品牌旗舰店', 'http://reddragonfly.tmall.com/', 'http://logo.taobao.com/shop-logo/a5/0b/T1IO18FgVaXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (33, 373327370, 2, '达芙妮官方旗舰店', '达芙妮官方旗舰店', 'http://daphne.tmall.com/', 'http://logo.taobao.com/shop-logo/4c/5b/T1D7_oXm0kXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (34, 379092709, 2, '骆驼服饰旗舰店', '骆驼服饰旗舰店', 'http://luotuo.tmall.com/', 'http://logo.taobao.com/shop-logo/16/b0/T1A6O5FadXXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (35, 353042353, 2, '他她Tata官方旗舰店', '他她官方旗舰店', 'http://tata.tmall.com/', 'http://logo.taobao.com/shop-logo/68/89/T1RmycXXtqXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (36, 98563612, 2, 'e百丽官方旗舰店', 'e百丽旗舰店', 'http://belle.tmall.com/', 'http://logo.taobao.com/shop-logo/d9/6e/T18ckSXnlbXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (37, 196993935, 5, '优衣库官方旗舰店', '优衣库官方旗舰店', 'http://uniqlo.tmall.com/', 'http://logo.taobao.com/shop-logo/a4/6e/T1XFHhXaVnXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (38, 93494249, 5, '名人瑞裳旗舰店', '名人瑞裳旗舰店', 'http://mrrsbj.tmall.com/', 'http://logo.taobao.com/shop-logo/23/dd/T1OCKJXmVuXXartXjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (39, 1040428670, 5, '欧昵雪服饰旗舰店', '欧昵雪服饰旗舰店', 'http://ounixue.tmall.com/', 'http://logo.taobao.com/shop-logo/a0/90/T1lnf6XbXdXXb1upjX', 0, '', '', '');
INSERT INTO sh_shop (`id`, `sid`, `cid`, `title`, `nick`, `shop_url`, `pic_path`, `seqorder`, `btitle`, `keyword`, `description`) VALUES (40, 513051429, 5, '太平鸟乐町官方旗舰店', '乐町官方旗舰店', 'http://leting.tmall.com/', 'http://logo.taobao.com/shop-logo/12/03/T1v1YeFctXXXb1upjX', 0, '', '', '');
#
# TABLE STRUCTURE FOR: sh_shop_admin
#

DROP TABLE IF EXISTS sh_shop_admin;

CREATE TABLE `sh_shop_admin` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `user_name` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `user_role` tinyint(1) unsigned NOT NULL default '0',
  `user_limit` varchar(255) default NULL,
  `last_login_ip` varchar(50) default NULL,
  `last_login_time` int(10) unsigned default NULL,
  `hits` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_name` (`user_name`),
  KEY `password` (`password`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_admin (`id`, `user_name`, `password`, `email`, `user_role`, `user_limit`, `last_login_ip`, `last_login_time`, `hits`, `create_date`) VALUES (27, 'admin', '7fef6171469e80d32c0559f88b377245', 'admin@admin.com', 1, '0', NULL, NULL, 0, 1433593007);
#
# TABLE STRUCTURE FOR: sh_shop_ads
#

DROP TABLE IF EXISTS sh_shop_ads;

CREATE TABLE `sh_shop_ads` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cid` varchar(30) default NULL,
  `width` smallint(5) unsigned NOT NULL default '0',
  `height` smallint(5) unsigned NOT NULL default '0',
  `is_pic` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `remark` varchar(50) default NULL,
  `hplink` varchar(500) default NULL,
  `file_path` varchar(255) default NULL,
  `js_code` text,
  PRIMARY KEY  (`id`),
  KEY `is_pic` (`is_pic`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (2, 'default', 200, 367, 1, '四件套', '首页-左栏-下', '#', 'uploadfiles/images/20130124/bb1969cff1d1808f7b5c19a68b0b4f08.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (3, 'default', 200, 367, 1, '年货零食专场', '首页-左栏-下', '#', 'uploadfiles/images/20130123/9a0f84d4fb9e80b82ae4fea7c93bf38c.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (4, 'default', 200, 367, 1, '清洁采购', '首页-左栏-下', '#', 'uploadfiles/images/20130124/a1d61ea5346e87c7591cdb47db3b4bbb.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (5, 'default', 1225, 90, 1, '童装1折起', '商品列表页-顶部通栏', '#', 'uploadfiles/images/20130124/409c4fa162001af3eb1b6cc1f99146ca.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (6, 'default', 1225, 90, 1, '饰品', '网站地图-顶部通栏', '#', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (7, 'default', 1225, 90, 1, 'PBA彩妆套装（BB霜+卸妆水）正品', '商品详细页-顶部通栏', '#', 'uploadfiles/images/20110530/812e84bb8e6e446edb7f0c9e5b095a6b.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (16, 'default', 200, 236, 1, '新年新穿衣', '商品列表页-左栏下', '#', 'uploadfiles/images/20130124/8dd3132dfb5bb254a99731073fb1f407.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (21, 'default', 228, 273, 1, '2011春夏新款女装 印花v领修身短袖连衣裙', '资讯列表页-右栏', '#', 'uploadfiles/images/20110619/d7a05bc3327529b91f710bb23feaf921.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (11, 'default', 1225, 100, 1, '2011新款 男士休闲凉鞋 大网眼凉鞋', '资讯列表页顶部', '#', 'uploadfiles/images/20110619/bd31d7394f83c449671ef7dee77ddb70.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (12, 'default', 1225, 100, 1, '正品沃特 VOIT 活动特价款 夏款', '资讯列表页底部', '#', 'uploadfiles/images/20110619/c7981aabd4a448f30b61770c7b81651f.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (13, 'default', 1225, 140, 1, '水晶鞋/钻鞋 鱼嘴鞋罗马鞋 高跟鞋女鞋凉鞋', '资讯详细页顶部', '#', 'uploadfiles/images/20110619/d868d24c1ad06013631456cccada1cfa.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (14, 'default', 1225, 140, 1, '黑色女士水钻时尚细高跟防水台高跟凉鞋', '资讯详细页底部', '#', 'uploadfiles/images/20110619/9304d64e77035d7463a8b3e2d4c084f1.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (15, 'default', 228, 273, 1, '2011春夏新款女装 印花v领修身短袖连衣裙', '资讯详细页右栏', '#', 'uploadfiles/images/20110619/d7a05bc3327529b91f710bb23feaf921.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (1, 'default', 200, 367, 1, '女鞋专场', '首页-左栏-下', '#', 'uploadfiles/images/20130123/a0048afed2c39cdca10aba1401342350.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (17, 'default', 200, 249, 1, '2013春季发布会', '商品列表页-左栏下', '#', 'uploadfiles/images/20130124/5d17717ebda18f4d3b9812823be634cb.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (18, 'default', 200, 230, 1, '饰品', '商品列表页-左栏下', '#', 'uploadfiles/images/20130124/90dad5c50a7672aa2839bc5aaf19a1fa.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (19, 'default', 200, 233, 1, '沐浴露', '商品列表页-左栏下', '#', 'uploadfiles/images/20130124/d1d9e4db08433571743e632f595ebf09.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (22, 'meili', 1225, 100, 1, '秋装新品', '首页-顶部通栏', '#', 'uploadfiles/images/20121028/5e57c3e07349d3cb4edb77e3fcc4c5aa.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (23, 'meili', 1225, 100, 1, '秋装', '文章列表页-顶部通栏', '#', 'uploadfiles/images/20121028/d77fb11af72ea272c5530fb55c274da0.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (24, 'meili', 228, 246, 1, '39.8包邮', '文章列表页-右栏', '#', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (25, 'meili', 1225, 100, 1, '这个秋季与众不同', '文章详细页-顶部通栏', '#', 'uploadfiles/images/20121028/d55a3d2b07b29cefaeb6b33ef6434f37.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (26, 'meili', 228, 246, 1, '包邮专区', '文章详细页-右栏', '#', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (27, 'meili', 1225, 90, 1, '儿童节童装特卖', '商品列表页-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (28, 'meili', 1225, 90, 1, '儿童节童装特卖', '网站地图-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (29, 'meili', 1225, 90, 1, '儿童节童装特卖', '商品详细页-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (30, 'red', 1225, 100, 1, '秋装', '文章列表页-顶部通栏', '#', 'uploadfiles/images/20121028/d77fb11af72ea272c5530fb55c274da0.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (31, 'red', 228, 246, 1, '39.8包邮', '文章列表页-右栏', '#', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (32, 'red', 1225, 100, 1, '这个秋季与众不同', '文章详细页-顶部通栏', '#', 'uploadfiles/images/20121028/d55a3d2b07b29cefaeb6b33ef6434f37.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (33, 'red', 228, 246, 1, '包邮专区', '文章详细页-右栏', '#', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (34, 'red', 1225, 90, 1, '儿童节童装特卖', '网站地图-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (35, 'red', 1225, 90, 1, '品牌特卖', '首页顶部', '#', 'uploadfiles/images/20121011/413bcfda882878e519390f8734ece4ed.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (36, 'red', 1225, 95, 1, '2011新款 太平鸟 女 雪纺 新品夏装 连衣裙', '首页底部', '#', 'uploadfiles/images/20110530/457a0fd383008bd327d611e3541b6323.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (37, 'red', 1225, 90, 1, '2011春季新款韩版女装NO.22时尚黑色盾牌标志潮', '商品搜索顶部', '#', 'uploadfiles/images/20110530/fdc05a72fa6e4120cc8ec179e391ee58.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (38, 'red', 1225, 90, 1, 'PBA彩妆套装（BB霜+卸妆水）正品', '商品详细页面顶部', '#', 'uploadfiles/images/20110530/812e84bb8e6e446edb7f0c9e5b095a6b.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (39, 'default', 990, 90, 1, '饰品', '店铺-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CFcRfH0G7DbPkiN9MMGieIe%2B%2B8H%2FQGUvovuo5eD3ySUilJjgsD2ttgCbhlg%2BsV%2BN%2F9PAiWWgN%2BcJ7wVuMleEaFPOkJRSwB1F29sJVnmyl%2FDM5knVEyIpoL9nwM72MGdCBqI%2BmaaLp25fsJQmxKRDk6iPq9jAJ0zGi%2Bigu%2FgWg%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (40, 'meili', 950, 90, 1, '儿童节童装特卖', '店铺-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxxrJ35Nnc0lpMIthq0pofgVkew7GkovxCjA0E2ESSPLho005itlJvEyXoN2zOqbrBGK4tioD2Pz0eDdnzck%3D', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (41, 'red', 950, 90, 1, '儿童节童装特卖', '店铺-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxxrJ35Nnc0lpMIthq0pofgVkew7GkovxCjA0E2ESSPLho005itlJvEyXoN2zOqbrBGK4tioD2Pz0eDdnzck%3D', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (42, 'tttejia', 216, 200, 1, '首页-1', '首页-1', '#', 'uploadfiles/images/20131112/efc92bc4c52f268507486a92f4519f09.png', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (43, 'tttejia', 216, 200, 1, '首页-2', '首页-2', '#', 'uploadfiles/images/20131112/de0e5c49b3c3a588343b3da5a5530c8b.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (44, 'tttejia', 216, 200, 1, '首页-3', '首页-3', '#', 'uploadfiles/images/20131112/192b2ba82a3ddfc85a3ea81d3010cea1.png', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (45, 'tttejia', 216, 200, 1, '首页-4', '首页-4', '#', 'uploadfiles/images/20131112/41ab5cce45321ee6a7fdf67250fd0afd.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (46, 'tttejia', 990, 90, 1, '童装1折起', '商品列表页-顶部通栏', '#', 'uploadfiles/images/20130124/409c4fa162001af3eb1b6cc1f99146ca.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (47, 'tttejia', 990, 90, 1, '饰品', '网站地图-顶部通栏', '#', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (48, 'tttejia', 990, 90, 1, 'PBA彩妆套装（BB霜+卸妆水）正品', '商品详细页-顶部通栏', '#', 'uploadfiles/images/20110530/812e84bb8e6e446edb7f0c9e5b095a6b.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (49, 'tttejia', 990, 100, 1, '2011新款 男士休闲凉鞋 大网眼凉鞋', '资讯列表页顶部', '#', 'uploadfiles/images/20110619/bd31d7394f83c449671ef7dee77ddb70.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (50, 'tttejia', 990, 100, 1, '正品沃特 VOIT 活动特价款 夏款', '资讯列表页底部', '#', 'uploadfiles/images/20110619/c7981aabd4a448f30b61770c7b81651f.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (51, 'tttejia', 990, 140, 1, '水晶鞋/钻鞋 鱼嘴鞋罗马鞋 高跟鞋女鞋凉鞋', '资讯详细页顶部', '#', 'uploadfiles/images/20110619/d868d24c1ad06013631456cccada1cfa.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (52, 'tttejia', 990, 140, 1, '黑色女士水钻时尚细高跟防水台高跟凉鞋', '资讯详细页底部', '#', 'uploadfiles/images/20110619/9304d64e77035d7463a8b3e2d4c084f1.jpg', NULL);
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (53, 'tttejia', 228, 273, 1, '2011春夏新款女装 印花v领修身短袖连衣裙', '资讯详细页右栏', '#', 'uploadfiles/images/20110619/d7a05bc3327529b91f710bb23feaf921.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (54, 'tttejia', 228, 273, 1, '2011春夏新款女装 印花v领修身短袖连衣裙', '资讯列表页-右栏', '#', 'uploadfiles/images/20110619/d7a05bc3327529b91f710bb23feaf921.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (55, 'tttejia', 990, 90, 1, '饰品', '店铺-顶部通栏', '#', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (56, 'default', 990, 90, 1, '饰品', '商家报名-顶部通栏', '#', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (57, 'meili', 950, 90, 1, '儿童节童装特卖', '商家报名-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (58, 'red', 950, 90, 1, '儿童节童装特卖', '商家报名-顶部通栏', '#', 'uploadfiles/images/20130601/ea320ce700f286752e52daab1aab7f19.jpg', '');
INSERT INTO sh_shop_ads (`id`, `cid`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES (59, 'tttejia', 990, 90, 1, '饰品', '商家报名-顶部通栏', '#', 'uploadfiles/images/20130124/772348888bdc7875d2e45ab9c2064917.jpg', '');
#
# TABLE STRUCTURE FOR: sh_shop_catalog
#

DROP TABLE IF EXISTS sh_shop_catalog;

CREATE TABLE `sh_shop_catalog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cat_name` varchar(50) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_catalog (`id`, `cat_name`, `seqorder`) VALUES (2, '男鞋女鞋', 0);
INSERT INTO sh_shop_catalog (`id`, `cat_name`, `seqorder`) VALUES (3, '化妆品', 0);
INSERT INTO sh_shop_catalog (`id`, `cat_name`, `seqorder`) VALUES (4, '品牌男装', 0);
INSERT INTO sh_shop_catalog (`id`, `cat_name`, `seqorder`) VALUES (5, '品牌女装', 0);
#
# TABLE STRUCTURE FOR: sh_shop_comment
#

DROP TABLE IF EXISTS sh_shop_comment;

CREATE TABLE `sh_shop_comment` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `user_id` bigint(15) unsigned NOT NULL default '0',
  `product_id` bigint(20) unsigned NOT NULL default '0',
  `user_name` varchar(50) default NULL,
  `content` text,
  `ip_address` varchar(50) default NULL,
  `reply` text,
  `is_pass` tinyint(1) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_id` (`user_id`),
  KEY `product_id` (`product_id`),
  KEY `is_pass` (`is_pass`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: sh_shop_email_template
#

DROP TABLE IF EXISTS sh_shop_email_template;

CREATE TABLE `sh_shop_email_template` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `shuo_ming` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `status` tinyint(3) unsigned NOT NULL default '0',
  `content` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_email_template (`id`, `shuo_ming`, `title`, `status`, `content`) VALUES (1, '管理员忘记密码', '您的后台管理员新密码', 1, '<p>您好!<br />\n您于 {tpl_send_time} 修改了后台管理员密码<br />\n管理员帐号： {tpl_user_name}<br />\n修改后的新密码为：{tpl_user_password}<br />\n登陆地址：<a target=\"_blank\" href=\"{tpl_admin_login_url}\">{tpl_admin_login_url}</a><br />\n温馨提示：建议您尽快登录网站管理后台,并重新设置您的管理密码。</p>');
#
# TABLE STRUCTURE FOR: sh_shop_flash
#

DROP TABLE IF EXISTS sh_shop_flash;

CREATE TABLE `sh_shop_flash` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `hplink` varchar(500) default NULL,
  `pic_path` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_flash (`id`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (6, '潮流冬靴', '#', 'uploadfiles/images/20130123/4c989047528d1ecdb959ef1959ca206e.jpg', 0);
INSERT INTO sh_shop_flash (`id`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (5, '优雅品质家纺', '#', 'uploadfiles/images/20130123/6e28a4cebf419df7b42192386a72e540.jpg', 0);
INSERT INTO sh_shop_flash (`id`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (3, '温馨保暖设备', '#', 'uploadfiles/images/20130123/a264490c15a209359deed459bc29fabb.jpg', 0);
INSERT INTO sh_shop_flash (`id`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (4, '气质修身羽绒服', '#', 'uploadfiles/images/20130123/9fbb2917344c4979bf3bfeaff3d2f200.jpg', 0);
#
# TABLE STRUCTURE FOR: sh_shop_link
#

DROP TABLE IF EXISTS sh_shop_link;

CREATE TABLE `sh_shop_link` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cid` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `hplink` varchar(500) default NULL,
  `pic_path` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_link (`id`, `cid`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (2, 1, '搜客淘宝客官方网站', 'http://bbs.soke5.com/', '', 2);
INSERT INTO sh_shop_link (`id`, `cid`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES (6, 0, '搜客淘宝客专业至尊版', 'http://red.soke5.com/', '', 1);
#
# TABLE STRUCTURE FOR: sh_shop_menu
#

DROP TABLE IF EXISTS sh_shop_menu;

CREATE TABLE `sh_shop_menu` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `cat_name` varchar(255) default NULL,
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `hplink` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `is_trash` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=117 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (1, '网站设置', 0, '#', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (3, '文章管理', 0, '#', 3, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (9, '网站配置', 1, 'site_config', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (13, '友情链接', 1, 'link', 8, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (14, '广告管理', 1, 'ads', 3, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (16, '管理员设置', 79, 'admin', 3, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (22, '分类管理', 3, 'news_catalog', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (23, '文章列表', 3, 'news', 1, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (32, '数据库备份', 79, 'mysql_manage', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (35, '文件管理', 79, 'file_manage', 1, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (41, '服务器环境检测', 79, 'help/echo_phpinfo', 5, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (55, '添加文章', 3, 'news/add_record_view', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (60, '顶部导航', 99, 'top_nav', 1, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (90, '焦点图', 1, 'flash', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (94, '商品管理', 0, '#', 1, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (79, '其他杂项', 0, '#', 6, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (77, '静态生成', 3, 'make_html', 3, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (95, '分类管理', 94, 'product_catalog', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (96, '所有商品', 94, 'product', 1, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (98, '底部导航', 99, 'bot_nav', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (99, '板块管理', 0, '#', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (100, '首页商品', 99, 'index_block', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (103, '采集单品', 94, 'product/sell_add', 3, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (104, '热门关键词', 99, 'hot_keyword', 4, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (106, '评论管理', 107, 'comment', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (107, '会员管理', 0, '#', 4, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (108, '会员列表', 107, 'user', 0, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (114, '采集U站', 94, 'u_rule', 2, 0);
INSERT INTO sh_shop_menu (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES (116, '自定义ID采集', 94, 'product/id_caiji', 3, 0);
#
# TABLE STRUCTURE FOR: sh_shop_news
#

DROP TABLE IF EXISTS sh_shop_news;

CREATE TABLE `sh_shop_news` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `title` varchar(500) default NULL,
  `catalog_id` varchar(100) default NULL,
  `keyword` varchar(500) default NULL,
  `description` text NOT NULL,
  `author` varchar(50) default NULL,
  `source` varchar(50) default NULL,
  `summary` text,
  `content` longtext,
  `pic_path` varchar(255) default NULL,
  `is_create` tinyint(1) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  `seqorder` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  `btitle` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `catalog_id` (`catalog_id`),
  KEY `title` (`title`(333)),
  KEY `is_create` (`is_create`)
) ENGINE=MyISAM AUTO_INCREMENT=201 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (4, 'Kipling 2013春季趋势 畅游都市', ',26,', 'Kipling 2013春季趋势 畅游都市', '在2013年春天来临之际，Kipling将频现于春夏时装秀场的迷人印花带入乐想女的生活中，而T台上另一重要时尚元素&mdash;&mdash;对比鲜明的黑白撞色也加入了本季设计。Kipling在这个春季让乐想女们畅游都市&mdash;&mdash;&ldquo;糖果色通勤包&rdquo;Surf&TheCity炫彩都市系列，&ldquo;色彩斑斓、拥有迷人泼墨花卉图案&rdquo;的Wallflo', 'admin', '未知', '在2013年春天来临之际，Kipling将频现于春夏时装秀场的迷人印花带入乐想女的生活中，而T台上另一重要时尚元素&mdash;&mdash;对比鲜明的黑白撞色也加入了本季设计。Kipling在这个春季让乐想女们畅游都市&mdash;&mdash;&ldquo;糖果色通勤包&rdquo;Surf&TheCity炫彩都市系列，&ldquo;色彩斑斓、拥有迷人泼墨花卉图案&rdquo;的Wallflo', '<p>在2013年春天来临之际，Kipling将频现于春夏时装秀场的迷人印花带入乐想女的生活中，而T台上另一重要时尚元素&mdash;&mdash;对比鲜明的黑白撞色也加入了本季设计。Kipling在这个春季让乐想女们畅游都市&mdash;&mdash;&ldquo;糖果色通勤包&rdquo; Surf & The City炫彩都市系列，&ldquo;色彩斑斓、拥有迷人泼墨花卉图案&rdquo;的Wallflower彩色花卉系列以及&ldquo;黑白色块拼接、经典简约&rdquo;的Black&White黑白系列，每个系列的包袋都能满足Kipling乐想女们舒适随性出席任何场合的搭配需求。我爱畅游都市，Kipling随我轻松每一天!</p>\r\n<p><strong>Surf & The City炫彩都市系列&mdash;&mdash;糖果色的通勤包</strong></p>\r\n<p>全新设计风格的Surf & The City炫彩都市系列通勤包让乐想女们轻松应对都市生活中的各种场合！</p>\r\n<p>Super City Bag通勤包可单肩、可斜挎、亦可手提，拥有超大的储物空间，内部不同功能的独立隔层设计能灵巧收纳各种必备物品：大至笔记本电脑、ipad，小至手机、笔，甚至雨伞、水壶都有它独立的收纳空间，贴心的设计及超轻的质感让乐想女们随时出发去面对各种挑战。除Super City Bag通勤包之外，该系列的其他包款，比如可斜挎包，也可手拿的ipad包Drew；中尺寸斜背包Sabin和Gnyta，A4尺寸斜背包Shopper Combo等也各具特色，除依旧延用品牌经典轻巧且耐用的抓皱尼龙面料之外，更创新地推出了缎面与皮革两种不同材质选择。色彩方面则采用了硫磺色、浅花红色、魅力紫色等充满浓郁春日气息的糖果色调，让乐想女们的休闲生活更为多姿多彩！</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130201/510b367e99c455327.JPG\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><strong>Drew Nylon</strong></p>\r\n<p style=\"text-align: center;\">ipad包</p>\r\n<p style=\"text-align: center;\"><img height=\"333\" src=\"http://news.jiapin.com/file:///C:UsersfujitsuAppDataLocalTempmsohtmlclip1�1clip_image002.jpg\" width=\"423\" />人民币790元</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130201/510b367ec4fad8894.JPG\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><strong>Gnyta</strong></p>\r\n<p style=\"text-align: center;\">中等尺寸斜背包</p>\r\n<p style=\"text-align: center;\">人民币1200元</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130201/510b367f061141024.JPG\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><strong>Sabin</strong></p>\r\n<p style=\"text-align: center;\">中等尺寸斜背包</p>\r\n<p style=\"text-align: center;\"><img height=\"152\" src=\"http://news.jiapin.com/file:///C:UsersfujitsuAppDataLocalTempmsohtmlclip1�1clip_image002.gif\" width=\"138\" />人民币1225元</p>\r\n<p style=\"text-align: center;\">&nbsp;</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130201/510b367f497520024.JPG\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><strong>Shopper Combo</strong></p>\r\n<p style=\"text-align: center;\">A4尺寸斜背包</p>\r\n<p style=\"text-align: center;\">人民币890元</p>\r\n<p style=\"text-align: center;\">                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 7, 0, 1370087886, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (5, '春节期间客服工作时间临时调整公告', ',26,', '春节期间客服工作时间临时调整公告', '亲爱的顾客，您好！春节假期马上就要到了，首先感谢您在过去一年中对佳品网的支持与喜爱，因为假期的原因2013年2月9日－2月15日佳品网客服部的工作时间临时调整为10：00－16：00，2月16日起工作时间恢复为周一至周日09：00－18：00，由此给您带来的不便敬请谅解！祝您及您的全家阖家欢乐，万事如意！ 佳品网客服部2013年2月1日', 'admin', '未知', '亲爱的顾客，您好！春节假期马上就要到了，首先感谢您在过去一年中对佳品网的支持与喜爱，因为假期的原因2013年2月9日－2月15日佳品网客服部的工作时间临时调整为10：00－16：00，2月16日起工作时间恢复为周一至周日09：00－18：00，由此给您带来的不便敬请谅解！祝您及您的全家阖家欢乐，万事如意！ 佳品网客服部2013年2月1日', '<p>亲爱的顾客，您好！</p>\r\n<p>春节假期马上就要到了，首先感谢您在过去一年中对佳品网的支持与喜爱，因为假期的原因2013年2月9日－2月15日佳品网客服部的工作时间临时调整为10：00－16：00，2月16日起工作时间恢复为周一至周日09：00－18：00，由此给您带来的不便敬请谅解！</p>\r\n<p>祝您及您的全家阖家欢乐，万事如意！</p>\r\n<p>&nbsp;</p>\r\n<p>佳品网客服部</p>\r\n<p>2013年2月1日</p>\r\n                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087886, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (6, '春节期间快递发货延误的说明', ',26,', '春节期间快递发货延误的说明', ' 近期我国部分地区出现雨雪降温等恶劣天气，且临近春节部分快递发货有所延误，您的订单可能出现配送延迟等情况，给您带来的不便还请谅解！感谢您对佳品网一如既往的支持，在此祝您及家人朋友在新的一年里身体健康，事事顺利。 佳品网', 'admin', '未知', ' 近期我国部分地区出现雨雪降温等恶劣天气，且临近春节部分快递发货有所延误，您的订单可能出现配送延迟等情况，给您带来的不便还请谅解！感谢您对佳品网一如既往的支持，在此祝您及家人朋友在新的一年里身体健康，事事顺利。 佳品网', '<p>&nbsp;</p>\r\n<p>近期我国部分地区出现雨雪降温等恶劣天气，且临近春节部分快递发货有所延误，您的订单可能出现配送延迟等情况，给您带来的不便还请谅解！</p>\r\n<p>感谢您对佳品网一如既往的支持，在此祝您及家人朋友在新的一年里身体健康，事事顺利。</p>\r\n<p>&nbsp;</p>\r\n<p>佳品网</p>\r\n                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087887, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (7, 'Marisfrolg 2013春季新品', ',26,', 'Marisfrolg 2013春季新品', '印花诱惑&ldquo;新鲜明亮的颜色，自然环保的珍贵面料，带出奢华质感。&rdquo;仍然是Marisfrlog最佳的制胜点。Marisfrolg2013春季绚丽的印花系列，极富感染力的热带丛林花型与绿植，给人强烈视觉冲击感，在五彩斑斓的时尚生活中，留下最烂漫的绽放。Marisfrlog设计师们始终追求以最纯粹简约的线条和手工织物面料，诠释优雅女性对奢华质感的追求。白色经典经过秋冬醇厚的沉淀，形于', 'admin', '未知', '印花诱惑&ldquo;新鲜明亮的颜色，自然环保的珍贵面料，带出奢华质感。&rdquo;仍然是Marisfrlog最佳的制胜点。Marisfrolg2013春季绚丽的印花系列，极富感染力的热带丛林花型与绿植，给人强烈视觉冲击感，在五彩斑斓的时尚生活中，留下最烂漫的绽放。Marisfrlog设计师们始终追求以最纯粹简约的线条和手工织物面料，诠释优雅女性对奢华质感的追求。白色经典经过秋冬醇厚的沉淀，形于', '<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130129/5107350ea38ad3701.jpg\" title=\"\" /></p>\r\n<p><strong>印花诱惑</strong></p>\r\n<p>&ldquo;新鲜明亮的颜色，自然环保的珍贵面料，带出奢华质感。&rdquo;仍然是Marisfrlog最佳的制胜点。Marisfrolg2013春季绚丽的印花系列，极富感染力的热带丛林花型与绿植，给人强烈视觉冲击感，在五彩斑斓的时尚生活中，留下最烂漫的绽放。Marisfrlog设计师们始终追求以最纯粹简约的线条和手工织物面料，诠释优雅女性对奢华质感的追求。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130129/510735240557c6158.jpg\" title=\"\" /></p>\r\n<p><strong>白色经典</strong></p>\r\n<p>经过秋冬醇厚的沉淀，形于极简的Marisfrolg在冬末春初之际，不遗余力地叙述着铅华过后低调沉着的历练之美。设计师们似乎从未停止过对白色的创作，单一的色彩却总能给人最纯粹直白的美感。Marisfrolg全新春系列中充满简洁纯净的清新白，将更多注意力放在简约的廓形和轻透的材质中，让这个系列更接近纯净无瑕。</p>\r\n<p>                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087887, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (8, 'Rabu Rabu春夏新品 玩转个性与色彩变换', ',26,', 'Rabu Rabu春夏新品 玩转个性与色彩变换', '本季，RabuRabu依旧主打不同款式的波鞋，而且，加入了许多更新潮，更时尚的元素。打破传统，标新立异，RabuRabu就是要你成为人群中最&ldquo;出彩&rdquo;的那一个。本季新品强力推出的彩色鞋底系列就是最好的体现。色彩艳丽的鞋带与鞋底融为一体，黑色鞋面又不失帅气的感觉，此外，还在鞋头部分加上了特殊的&ldquo;钢头&rdquo;设计，只看外观，便会俘获诸多的心。', 'admin', '未知', '本季，RabuRabu依旧主打不同款式的波鞋，而且，加入了许多更新潮，更时尚的元素。打破传统，标新立异，RabuRabu就是要你成为人群中最&ldquo;出彩&rdquo;的那一个。本季新品强力推出的彩色鞋底系列就是最好的体现。色彩艳丽的鞋带与鞋底融为一体，黑色鞋面又不失帅气的感觉，此外，还在鞋头部分加上了特殊的&ldquo;钢头&rdquo;设计，只看外观，便会俘获诸多的心。', '<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130116/50f6276c8279f7763.jpg\" title=\"\" /></p>\r\n<p>本季，Rabu Rabu依旧主打不同款式的波鞋，而且，加入了许多更新潮，更时尚的元素。</p>\r\n<p>打破传统，标新立异，Rabu Rabu就是要你成为人群中最&ldquo;出彩&rdquo;的那一个。本季新品强力推出的彩色鞋底系列就是最好的体现。色彩艳丽的鞋带与鞋底融为一体，黑色鞋面又不失帅气的感觉，此外，还在鞋头部分加上了特殊的&ldquo;钢头&rdquo;设计，只看外观，便会俘获诸多的心。</p>\r\n<p>                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 1, 0, 1370087887, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (9, '汤唯穿着ANTONIO BERARDI 2013春夏小礼服出席电影宣传活动', ',26,', '汤唯穿着ANTONIO BERARDI 2013春夏小礼服出席电影宣传活动', '安东尼奥&middot;贝拉尔迪(AntonioBerardi)是新晋的意大利高端服饰品牌，生产线设在意大利波洛尼亚(Bologna)，但是时装发布先是在米兰，后来又移师伦敦。走在新千年时尚潮流之巅，加入纯净的想象力，是安东尼奥&middot;贝拉尔迪(AntonioBerardi)设计的最大特色。作为\"高贵辣妹\"维多利亚&middot;贝克汉姆(VictoriaBeckham)最看中的设计师，安', 'admin', '未知', '安东尼奥&middot;贝拉尔迪(AntonioBerardi)是新晋的意大利高端服饰品牌，生产线设在意大利波洛尼亚(Bologna)，但是时装发布先是在米兰，后来又移师伦敦。走在新千年时尚潮流之巅，加入纯净的想象力，是安东尼奥&middot;贝拉尔迪(AntonioBerardi)设计的最大特色。作为\"高贵辣妹\"维多利亚&middot;贝克汉姆(VictoriaBeckham)最看中的设计师，安', '<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f90bc14f03138.jpg\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f90beb4521532.jpg\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f90c25c292600.jpg\" title=\"\" /></p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f90c542579960.jpg\" title=\"\" /></p>\r\n<p>安东尼奥&middot;贝拉尔迪 (Antonio Berardi) 是新晋的意大利高端服饰品牌，生产线设在意大利波洛尼亚 (Bologna)，但是时装发布先是在米兰，后来又移师伦敦。</p>\r\n<p>走在新千年时尚潮流之巅，加入纯净的想象力，是安东尼奥&middot;贝拉尔迪 (Antonio Berardi) 设计的最大特色。作为\"高贵辣妹\"维多利亚&middot;贝克汉姆 (Victoria Beckham) 最看中的设计师，安东尼奥&middot;贝拉尔迪 (Antonio Berardi) 是当今高端时装界年轻耀眼的的新星。</p>\r\n<p>Antonio Berardi于THE SWANK诗韵有售</p>\r\n                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 1, 0, 1370087887, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (10, 'DIOR 2013春夏成衣系列发布', ',26,', 'DIOR 2013春夏成衣系列发布', '当迪奥高级时装公司创立于一九四七年之时，其品牌风格与战争期间盛行的简约硬朗风格背道而驰。拉夫&bull;西蒙解释说：&ldquo;迪奥先生在与过去决裂的跃进中，崇尚女性美、内涵与情感，推崇过去不曾有过的自由思想。以往对女性束缚的根本源于精神层面，而这一解放首先是女性心理上的解放。这就是我想要探索的方向。&rdquo;迪奥二零一三春夏成衣系列旨在突破与极简主义相关的&ldquo;反性别&rdquo;', 'admin', '未知', '当迪奥高级时装公司创立于一九四七年之时，其品牌风格与战争期间盛行的简约硬朗风格背道而驰。拉夫&bull;西蒙解释说：&ldquo;迪奥先生在与过去决裂的跃进中，崇尚女性美、内涵与情感，推崇过去不曾有过的自由思想。以往对女性束缚的根本源于精神层面，而这一解放首先是女性心理上的解放。这就是我想要探索的方向。&rdquo;迪奥二零一三春夏成衣系列旨在突破与极简主义相关的&ldquo;反性别&rdquo;', '<p>当迪奥高级时装公司创立于一九四七年之时，其品牌风格与战争期间盛行的简约硬朗风格背道而驰。拉夫&bull;西蒙解释说：&ldquo;迪奥先生在与过去决裂的跃进中，崇尚女性美、内涵与情感，推崇过去不曾有过的自由思想。以往对女性束缚的根本源于精神层面，而这一解放首先是女性心理上的解放。这就是我想要探索的方向。&rdquo;</p>\r\n<p>迪奥二零一三春夏成衣系列旨在突破与极简主义相关的&ldquo;反性别&rdquo;之说，全力弘扬女性应有的性感、情致、感性与柔美。这一系列成衣歌颂女性的身形，及其灵动、光彩、透彻与快乐的特质。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f5d13f3169046.jpg\" title=\"\" /></p>\r\n<p>迪奥品牌最具代表性的迪奥套装(Bar Jacket)的结构造型，及其立体剪裁所塑造的女性美是本季的重点。迪奥套装衍生出多种造型，我们可以从中看到迪奥先生的&ldquo;A&rdquo;系列和&ldquo;H&rdquo;系列的影子。结构感十足的褶裥让外套更立体，愈发灵动，刺绣和贴花缀饰于多处细节。最引人注目的莫过于迷你连身裙式的外套了。这一新式外套连身裙和多次出现的短巧款型是本系列的重点。这性别的解放，是向迪奥一九六零年代开始出现的成衣的致敬，在晚装的线条中也有着深刻的体现，如搭配短裤穿着的短款晚礼服，或&ldquo;A&rdquo;系列连衣裙中透明色与纯色的应用。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20130115/50f4f5d18c9645443.jpg\" title=\"\" /></p>\r\n<p style=\"text-align: center;\">                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087887, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (11, '中国最长寿者揭晓 101“神奇养生枕”引轰动', ',26,', '中国最长寿者揭晓 101“神奇养生枕”引轰动', '全国人大常委会副委员长司马义&middot;铁力瓦尔地、全国老龄委办公室副主任朱勇以及中国老年学学会常务副会长赵宝华等领导出席了本次会议，同时与会的还有章光101集团董事长赵章光等在健康产业领域做出突出贡献的企业家代表。　　特别值得一提地是，期间，司马义&middot;铁力瓦尔地副委员长与赵章光进行了亲切交流，共同探讨人类长寿的奥秘，肯定了101红豆杉缓释颗粒中医闻香对人类健康长寿有着重要的意义。', 'admin', '未知', '全国人大常委会副委员长司马义&middot;铁力瓦尔地、全国老龄委办公室副主任朱勇以及中国老年学学会常务副会长赵宝华等领导出席了本次会议，同时与会的还有章光101集团董事长赵章光等在健康产业领域做出突出贡献的企业家代表。　　特别值得一提地是，期间，司马义&middot;铁力瓦尔地副委员长与赵章光进行了亲切交流，共同探讨人类长寿的奥秘，肯定了101红豆杉缓释颗粒中医闻香对人类健康长寿有着重要的意义。', '<p>全国人大常委会副委员长司马义&middot;铁力瓦尔地、全国老龄委办公室副主任朱勇以及中国老年学学会常务副会长赵宝华等领导出席了本次会议，同时与会的还有章光101集团董事长赵章光等在健康产业领域做出突出贡献的企业家代表。</p>\r\n<p>　　特别值得一提地是，期间，司马义&middot;铁力瓦尔地副委员长与赵章光进行了亲切交流，共同探讨人类长寿的奥秘，肯定了101红豆杉缓释颗粒中医闻香对人类健康长寿有着重要的意义。</p>\r\n<p align=\"center\"><img alt=\"\" src=\"http://images.qianlong.com/mmsource/imghylanda/20121231/36/5697130814465028500.jpg\" /></p>\r\n<p>　　2012年12月26日，在钓鱼台国宾馆，全国人大常委会副委员长司马义&middot;铁力瓦尔地亲切会见章光101集团董事长赵章光（右一），交流人类长寿的奥秘，肯定101红豆杉缓释颗粒中医闻香对人类健康长寿有着重要的意义</p>\r\n<p>　　<strong>用户众口一词：这个产品太神奇</strong></p>\r\n<p>　　会上，赵章光应邀向出席会议的惟一一对百岁老人夫妻送上了101红豆杉养生枕。握着老人的手，赵章光笑呵呵地说：&ldquo;我也70岁了，看见你们 100多岁还是那么精神矍铄，可喜可贺！再用上我们这个神奇的101红豆杉枕，就更如虎添翼了。看来，我们以后不但都能超越101岁，活到200岁也不是 奇迹啊！&rdquo;</p>\r\n<p align=\"center\"><img alt=\"\" src=\"http://images.qianlong.com/mmsource/imghylanda/20121231/51/8382730331351099759.jpg\" /></p>\r\n<p>　　章光101集团董事长赵章光先生（左一）向著名食品工业科学家和工程技术专家，105岁高龄的酒业泰斗秦含章先生及其夫人赠送101红豆杉缓释颗粒枕，并恭祝老人更加健康长寿。</p>\r\n<p>　　登时，会场议论纷纷，大家对101这个神奇的产品兴趣大发。主持人赶紧拉着赵章光的胳膊，迭声问：&ldquo;这么好的东西，它的神奇之处在哪里？请您为大家解惑。&rdquo;</p>\r\n<p>　　赵章光当即笑着表示：&ldquo;101红豆杉养生枕最大的特点就是通过闻香疗法释放小分子物质，作用于神经系统，从而改善失眠，调节血压、血糖，缓解颈 椎疼等，起到延年益寿的作用&rdquo;；接着他又补充道：&ldquo;这些疗效除了已在临床中得到了证实，还有反馈给101的大量用户感言为证；用户在来信来电中众口一词 &lsquo;这个产品太神奇了&rsquo;&rdquo;。末了，他还不忘幽默地添上一句：&ldquo;&lsquo;神奇产品&rsquo;是用户给我们101封上的，我们自己可不敢自封啊&rdquo;。</p>\r\n<p>　　大家纷纷走向赵章光，希望向他购买产品。为了平息会场，主持人赶紧透露：&ldquo;别急，一会大家都能领到这样一个神奇的101红豆杉产品，会后到门口排队领取&rdquo;。</p>\r\n<p>　　<strong>领导高度评价：101是健康产业表率</strong></p>\r\n<p>　　健康长寿是人类不分种族、不分国家、不分民族的共同追求，是人类社会的永恒主题。截至2012年10月16日，全国（不包括港、澳、台地区）健 在百岁老人达到47773人，约占全国人口总数的3.55/10万。赵宝华表示，中国百岁寿星逐年增多，是中国30年改革巨变的历史见证，是&ldquo;小康中国， 美丽中国，幸福中国&rdquo;的一个重要象征，将极大增强我们发展的自信。</p>\r\n<p>　　针对老龄化问题，赵宝华曾在&ldquo;百岁希望工程-健康快车&rdquo;项目中提出过三条对策：分别是保障老龄化、积极老龄化和健康老龄化。其中健康老龄化就提到需要企业的积极参与，设计生产满足老人不同需求的、高质量的健康产品。&ldquo;这就是企业的责任；这个需求很大。&rdquo;</p>\r\n<p>　　赵宝华表示，中国老年学学会建立的健康产品的筛选和推介平台，以高度的社会责任感和专业精神，按照安全、优质、实用、价廉的原则，筛选和介绍促 进健康长寿的新技术和新产品；从专业方面支持健康新产品的研发，从质量方面维护老年消费者的利益。&ldquo;此次章光101的几百套红豆杉药枕就是经这种严格的程 序审核通过的。&rdquo;</p>\r\n<p>　　会上，赵宝华向所有做出贡献的朋友表示了最衷心的感谢和崇高的敬意。对章光101集团在健康产业方面做出的突出贡献，给予了很高的评价。</p>\r\n<p>　　在健康产业的道路上，赵章光是棵常青树。如今，他以古稀之年依然充满希望的进取精神，不断地创新他的第二事业&mdash;&mdash;红豆杉养生长生产业。对此，赵 宝华表示：&ldquo;在促进健康老龄化与社会代际和谐，加强对长寿养生产品的科学研究等方面，章光101一直走在前列，赵章光本人及其带领的101团队在健康长寿 领域可谓是做出了表率&rdquo;。</p>\r\n                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087888, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (12, '绮瑞英雄会第四季：三国•群英会', ',26,', '绮瑞英雄会第四季：三国•群英会', '这一季的地点选在赤壁，是借用了典故&ldquo;赤壁之战&rdquo;的精髓：通过战略联盟得到以少胜多，以弱胜强的结果。绮瑞希望以此勉励团队：通过共同进步，在群雄割据的市场中缔造绮瑞人的居家服盛世。英雄不论出身及年龄针对目前居家服市场环境不成熟，无序竞争造成市场不明朗的状态下，绮瑞公司根据自身的现状以及未来的发展规划，配合品牌2013年的十周年庆，举办了一场横跨三年六个赛季的战略性品牌营销活动&m', 'admin', '未知', '这一季的地点选在赤壁，是借用了典故&ldquo;赤壁之战&rdquo;的精髓：通过战略联盟得到以少胜多，以弱胜强的结果。绮瑞希望以此勉励团队：通过共同进步，在群雄割据的市场中缔造绮瑞人的居家服盛世。英雄不论出身及年龄针对目前居家服市场环境不成熟，无序竞争造成市场不明朗的状态下，绮瑞公司根据自身的现状以及未来的发展规划，配合品牌2013年的十周年庆，举办了一场横跨三年六个赛季的战略性品牌营销活动&m', '<p>这一季的地点选在赤壁，是借用了典故&ldquo;赤壁之战&rdquo;的精髓：通过战略联盟得到以少胜多，以弱胜强的结果。绮瑞希望以此勉励团队：通过共同进步，在群雄割据的市场中缔造绮瑞人的居家服盛世。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20121228/50dd9b2f961756538.jpg\" title=\"\" /></p>\r\n<p><strong>英雄不论出身及年龄</strong></p>\r\n<p>针对目前居家服市场环境不成熟，无序竞争造成市场不明朗的状态下，绮瑞公司根据自身的现状以及未来的发展规划，配合品牌2013年的十周年庆，举办了一场横跨三年六个赛季的战略性品牌营销活动&mdash;&mdash;绮瑞品牌英雄会，试图告诉团队如何应对目前的市场状态，以及如何发展。</p>\r\n<p>活动主要是对绮瑞人的一次以体验、感受、感悟为主的心智提升的培训，通过以教练方式为主导互通体验式训导课程，激发员工、代理商、加盟商的内在能量，从而提升其内在修炼，是绮瑞品牌对有胆识、有智慧、有思想的英雄群体的甄选和培养。</p>\r\n<p>参与角逐的&ldquo;英雄&rdquo;来自全国各地，有专卖店店长，有主管和经理等高级管理人员，也有销售客服和售货员等基层员工。参与者不仅身份横跨企业的各个层面，年龄的跨度也相对较大。</p>\r\n<p>参与第二轮&ldquo;英雄会&rdquo;选拔的选手中，大部分为20至40岁的青壮年，头发有些花白的62岁胡世华最引人注意。胡世华老当益壮，虽然已经年过花甲，但内心青春不减，脸上仍然洋溢着热情，他对团队的成员介绍道：&ldquo;我年龄比较大，想通过活动学习和提升自己，希望大家多多支持。&rdquo;铿锵有力的话语博得大家热烈的掌声。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20121228/50dd9b300e1ea5576.jpg\" title=\"\" /></p>\r\n<p><strong>英雄有成长</strong></p>\r\n<p>从2011年5月第一季英雄会举办以来，其所受的评价褒贬不一。有人怀疑，在居家服行业尚处于将蛋糕做大的阶段，这个时间应该注重的是产品设计、渠道开发和终端的维护，花这么多的钱培养人才是否值得，是否为期过早。</p>\r\n<p>绮瑞居家服总经理唐以锦一直对这个举措坚定不移，他坚信：产品和人才应该同步发展，而且人才的培养有利于思想层面的统一，这种思想层面的统一，可以转化为各种力量和资源，去服务整个品牌的发展。</p>\r\n<p>从第四季绮瑞&ldquo;英雄&rdquo;的表现中，他觉得自己想要的结果已经在慢慢显露：这短短一年半的时间，他们也看到了一些成果，无论从个人的精神风貌还是业务水平，&ldquo;绮瑞人&rdquo;的成长都是多方面的而且是明显的，更难得的是，他们对服务的把握更加准确，对未来的发展和定位也更明晰。这让公司的高层管理非常欣慰。</p>\r\n<p>活动现场可以看到，一到分享环节，每个人都十分乐于分享自己的故事和收获。私下采访时很多参与者都表示，其实自己很内向，参加英雄会让自己比以前更自信了，更愿意分享和表现自己。</p>\r\n<p>来自北京的李新义说：&ldquo;我非常内向，从不愿主动出击，这作为一个营销人员来说，还是有些吃亏。同时，销售也是全凭的自己的经验做，从来没有战略和思路的概念，现在更加懂得如何去理顺我的工作思路。&rdquo;在他看来，活动扩大了他的知识面，分享和沟通也让他了解市场，改善思维、行事模式和工作方法。他还向记者分享了自己在第一季英雄会中第一次当队长的经历，&ldquo;那真的是迈出了人生最重要的一步。&rdquo;</p>\r\n<p>                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087888, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (13, 'duckfeet 今冬伴您温暖度过', ',26,', 'duckfeet 今冬伴您温暖度过', '与其他极具时尚感的鞋履品牌相比，duckfeet的设计相对来说更简洁，更低调，因此受众人群也更广一点。不仅适合年轻一族，而且，稍长一点的中年人也而完全可以驾驭。数九寒冬，最值得推荐的当属duckfeet棉鞋。为了追求精益求精，同时真正的起到保暖的功效，duckfeet棉鞋鞋内绒毛全部选用100%纯羊毛制作而成，柔软顺滑、温暖舒适，足以抵抗北方的严冬。1310系列就是其中之一。仅从图片便可看出，该系', 'admin', '未知', '与其他极具时尚感的鞋履品牌相比，duckfeet的设计相对来说更简洁，更低调，因此受众人群也更广一点。不仅适合年轻一族，而且，稍长一点的中年人也而完全可以驾驭。数九寒冬，最值得推荐的当属duckfeet棉鞋。为了追求精益求精，同时真正的起到保暖的功效，duckfeet棉鞋鞋内绒毛全部选用100%纯羊毛制作而成，柔软顺滑、温暖舒适，足以抵抗北方的严冬。1310系列就是其中之一。仅从图片便可看出，该系', '<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20121220/50d283f2230de5476.jpg\" title=\"\" /></p>\r\n<p>与其他极具时尚感的鞋履品牌相比，duckfeet的设计相对来说更简洁，更低调，因此受众人群也更广一点。不仅适合年轻一族，而且，稍长一点的中年人也而完全可以驾驭。</p>\r\n<p style=\"text-align: center;\"><br />\r\n<img alt=\"\" border=\"0\" src=\"http://news.jiapin.com/uploadfile/jiapinzixun/20121220/50d283f27d23e3669.jpg\" title=\"\" /></p>\r\n<p>数九寒冬，最值得推荐的当属duckfeet棉鞋。为了追求精益求精，同时真正的起到保暖的功效，duckfeet棉鞋鞋内绒毛全部选用100%纯羊毛制作而成，柔软顺滑、温暖舒适，足以抵抗北方的严冬。1310系列就是其中之一。仅从图片便可看出，该系列皮质非常柔软，而且款式采用了贴心的两穿设计，满足顾客不同的穿着喜好。鞋内的加厚绒毛，只一看便觉得无比温暖。</p>\r\n<p>为体验者的双脚带来无微不至的关怀是duckfeet最终的追求。今年冬天，应该有一双这样足部伴侣跟您一起度过！</p>\r\n<p>                      <p style=\"text-align: center;color: rgb(255,0,0);font-weight:bold;\"></p>', NULL, 1, 0, 0, 1370087888, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (14, 'PCbaby巨献 母婴用品评测盛典榜单', ',26,', 'PCbaby巨献 母婴用品评测盛典榜单', '2013年1月9日，由太平洋亲子网主办的第4届母婴用品评测盛典榜单出炉，此次评测活动历时四个月，数十万网友参与，经层层筛选，评选出6大类别，合计17项行业大奖。其中，3项行业至尊大奖分别由美赞臣、帮宝适、强生婴儿夺得;在其他奖项榜单中，国产品牌和进口品牌可谓平分秋色。PCbaby母婴用品评测盛典由太平洋亲子网主办，是母婴用品行业一年一度的评测盛事，迄今已成功举办了四届，旨在为中国年轻的父母们提供专', 'admin', '未知', '2013年1月9日，由太平洋亲子网主办的第4届母婴用品评测盛典榜单出炉，此次评测活动历时四个月，数十万网友参与，经层层筛选，评选出6大类别，合计17项行业大奖。其中，3项行业至尊大奖分别由美赞臣、帮宝适、强生婴儿夺得;在其他奖项榜单中，国产品牌和进口品牌可谓平分秋色。PCbaby母婴用品评测盛典由太平洋亲子网主办，是母婴用品行业一年一度的评测盛事，迄今已成功举办了四届，旨在为中国年轻的父母们提供专', '<p>2013年1月9日，由太平洋亲子网主办的第4届母婴用品评测盛典榜单出炉，此次评测活动历时四个月，数十万网友参与，经层层筛选，评选出6大类 别，合计17项行业大奖。其中，3项行业至尊大奖分别由美赞臣、帮宝适、强生婴儿夺得;在其他奖项榜单中，国产品牌和进口品牌可谓平分秋色。</p>\n<p style=\"text-align: center;\"><img alt=\"1\" title=\"1\" height=\"222\" width=\"500\" src=\"http://img01.taobaocdn.com/tps/i1/T1C_RcXzBfXXXXXXXX.jpg\" /></p>\n<p>PCbaby母婴用品评测盛典由太平洋亲子网主办，是母婴用品行业一年一度的评测盛事，迄今已成功举办了四届，旨在为中国年轻的父母们提供专业、实用、 有直接导购意义的评测信息，对厂商改进产品产生积极意义和深远影响。2012年的评测盛典盛况空前，前后历时4个多月，共有奶粉、纸尿裤、润肤霜3大行业 90多款产品参评，10名业内资深专家全程监督指导，30家知名媒体全程追踪报道，数十万名网友热情参与投票。</p>\n<p>2012PCbaby母 婴用品评测盛典在评选规则上设置3大要素，分别是网友投票、编辑评测、达人鉴定，通过多维度计算方法，共同评选出奶粉、纸尿裤、润肤霜3个行业的6类奖 项，分别为行业至尊大奖、2012最受欢迎奖、最具潜力奖、最具购买欲奖 、最佳功效奖及最贴心设计奖，共计17项奖项名单，以最公正的方式给予网友最可信的榜单。</p>\n<p>与往届不同，今年的评测盛典的在设置奖项时，更侧重网友口碑，除了继续沿用编辑评测外，首次将网友投票纳入产品评测总分中，并组织万人投票，评选出最受网友欢迎奖，该奖项最后分别由亨氏奶粉、帮宝适纸尿裤、郁美净润肤霜夺得。</p>\n<p>除了至尊大奖、最受欢迎奖之外，最具潜力奖、最具购买欲奖、最佳功效奖以及最贴心设计奖也已出炉，欲知各奖项花落谁家，以上品牌以何优势荣登榜首?详情请登录太平洋亲子网，查看2012年PCbaby母婴用品评测盛典。</p>\n<p>PCbaby2012年度母婴用品评测盛典：http://play9.pcbaby.com.cn/baby121016/index.jsp</p>', NULL, 1, 1, 0, 1370091708, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (15, '迎新春 康Q大红包馈赠母婴小家庭', ',26,', '迎新春 康Q大红包馈赠母婴小家庭', '奖品实物婴童用品价格猛涨小家伤不起在抢生“龙宝宝”的利好助推下，2012年中国新生儿的总量超过了1700万。中国婴童市场需求急剧膨胀，同时也成为了婴童用品价格快速上涨的催化剂，婴童用品消费在每一个小家庭生活开支占比越来越大，一些“小”家庭甚至不堪重负。给年轻的父母，增添一丝烦恼。母婴网站出招冬季送温暖作为国内知名的母婴网站，康Q网为感谢母婴家庭的一路陪伴与支持，在春节即将到来之际，特别推出“登陆康', 'admin', '未知', '奖品实物婴童用品价格猛涨小家伤不起在抢生“龙宝宝”的利好助推下，2012年中国新生儿的总量超过了1700万。中国婴童市场需求急剧膨胀，同时也成为了婴童用品价格快速上涨的催化剂，婴童用品消费在每一个小家庭生活开支占比越来越大，一些“小”家庭甚至不堪重负。给年轻的父母，增添一丝烦恼。母婴网站出招冬季送温暖作为国内知名的母婴网站，康Q网为感谢母婴家庭的一路陪伴与支持，在春节即将到来之际，特别推出“登陆康', '<p style=\"text-align: center;\"><img alt=\"图片1\" style=\"width: 336.0px;height: 500.0px;\" src=\"http://img01.taobaocdn.com/tps/i1/T1xp8dXCJeXXXXXXXX.png\" /></p>\n<p style=\"text-align: center;\">奖品实物</p>\n<p style=\"text-align: left;\">婴童用品价格猛涨 小家伤不起</p>\n<p>在抢生“龙宝宝”的利好助推下，2012年中国新生儿的总量超过了1700万。中国婴童市场需求急剧膨胀，同时也成为了婴童用品价格快速上涨的催化剂，婴童用品消费在每一个小家庭生活开支占比越来越大，一些“小”家庭甚至不堪重负。给年轻的父母，增添一丝烦恼。</p>\n<p>母婴网站出招 冬季送温暖</p>\n<p>作为国内知名的母婴网站，康Q网为感谢母婴家庭的一路陪伴与支持，在春节即将到来之际，特别推出“登陆康Q网 迎新送红包”活动，任何一位关注过康Q网的母婴家庭，只要在活动期内，登陆康Q网首页，参与“迎新送红包”活动，即可拾取大红包，领取实用的母婴用品。</p>\n<p>红包垂手可得 康Q与你同乐</p>\n<p>康Q网提供的母婴用品，专为0-6岁宝宝家庭设计，奖品品类安全、实用、丰富，包括：儿童生活用品，益智玩具，早教礼盒，拉杆书包等等，质量上乘，价格不菲。都是深受家长和小朋友喜爱的知名品牌。</p>\n<p>已经参与活动，来自北京的“龙妈”吴女士表示“现在奶粉和纸尿裤越来越贵，成为家庭生活的很大一笔开销，因此获赠这些育儿用品比一些空有噱头的奖品要实用很多”。这或许也是康Q网所倡导的专业、安全、贴心服务的最好体现。</p>\n<p>行动即有回报，还等什么？</p>\n<p>家有宝宝的妈妈们还等什么，如果您有0-6岁的宝宝，快来参与康Q网推出的“迎新送礼”活动吧。活动地址：http://bbs.kangq.com/viewthread.php?tid=110932&amp;extra=</p>', NULL, 1, 0, 0, 1370091709, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (16, '熊乃瑾亮相OnlyLady美容天后颁奖礼', ',26,', '熊乃瑾亮相OnlyLady美容天后颁奖礼', '1月24日，中国最优质的女性时尚生活平台OnlyLady女人志在上海波特曼丽嘉酒店举行的美容天后颁奖盛典完美落幕。当晚共颁发了包括年度护肤类天后、年度彩妆类天后、年度香氛、身体、头发类天后、综合类天后以及年度特色天后在内的各类大奖，众多美妆护肤产品揽获各类奖项。美容天后颁奖盛典作为OnlyLady年度盛事，通过千万级用户票选，最终产生出年度最受欢迎的各类美容产品榜单。此盛典至今已成功举办六届，成为', 'admin', '未知', '1月24日，中国最优质的女性时尚生活平台OnlyLady女人志在上海波特曼丽嘉酒店举行的美容天后颁奖盛典完美落幕。当晚共颁发了包括年度护肤类天后、年度彩妆类天后、年度香氛、身体、头发类天后、综合类天后以及年度特色天后在内的各类大奖，众多美妆护肤产品揽获各类奖项。美容天后颁奖盛典作为OnlyLady年度盛事，通过千万级用户票选，最终产生出年度最受欢迎的各类美容产品榜单。此盛典至今已成功举办六届，成为', '<p>1月24日，中国最优质的女性时尚生活平台OnlyLady女人志在上海波特曼丽嘉酒店举行的美容天后颁奖盛典完美落幕。当晚共颁发了包括年度护肤 类天后、年度彩妆类天后、年度香氛、身体、头发类天后、综合类天后以及年度特色天后在内的各类大奖，众多美妆护肤产品揽获各类奖项。美容天后颁奖盛典作为 OnlyLady年度盛事，通过千万级用户票选，最终产生出年度最受欢迎的各类美容产品榜单。此盛典至今已成功举办六届，成为业内最具影响力的专业美妆评 选活动。</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T10WpbXsdeXXXXXXXX.jpg\" /></p>\n<p>盛典现场星光璀璨，专家明星云集。CBSi全球副总裁、中国区总裁王路先生、华谊兄弟当红影视明星熊乃瑾、护肤权威DR.E、著名彩妆造型师游丝 棋、国际知名造型师Andy以及资深彩妆造型师阿治老师、OnlyLady美妆专家吴淼等人共同携手OnlyLady诸多达人盛装出席。</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1.lpbXzBbXXXXXXXX.jpg\" /></p>\n<p>熊乃瑾荣获“年度最具正能量女星”奖<br /> 盛典当晚以一幕歌剧表演盛况开场，现场流光溢彩，舞台节目精彩纷呈。首轮奖项揭晓后，当红影视明星 熊乃瑾获得了当晚首个明星大奖：年度最具正能量女星。熊乃瑾不仅对本届主题进行了完美诠释，还与在场的嘉宾共同分享了她与OnlyLady的特殊情感，使 得活动现场气氛直升沸点。主办方将明星大奖颁发给熊乃瑾，以表彰她在艺术与商业领域所创造的非凡价值。</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1G90aXxNdXXXXXXXX.jpg\" /></p>\n<p>当晚OnlyLady签约达人们为本届美容天后表演了特别献礼的精彩节目。作为业内首个创立并首推达人概念的女性专业时尚媒体，十年间，OnlyLady在各领域培养了大批的意见领袖。当晚达人的不凡才艺和出色的专业素养，给现场来宾留下了深刻印象。</p>', NULL, 1, 0, 0, 1370091709, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (17, '旅游卫视加入春晚 派送500万大奖', ',26,', '旅游卫视加入春晚 派送500万大奖', '据介绍，旅游春晚是全国旅游行业首次共聚一堂举行的晚会，晚会的主题为“美丽中国大拜年”，是全国各地卫视中举行最早的卫视春晚，也是全媒体互动特征最为明显的一台春晚。明星唱歌、代言两不误旅游春晚全名为“2013全国旅游行业春节联欢晚会”，以明显区别于其它卫视春晚的特色吸引了众多明星新秀到场，张纪中、孙悦、何洁、爱戴、常石磊、吴樾、黄鹤翔、阿普萨萨等轮番亮相。旅游春晚以歌舞节目为主，众明星为晚会准备了两至', 'admin', '未知', '据介绍，旅游春晚是全国旅游行业首次共聚一堂举行的晚会，晚会的主题为“美丽中国大拜年”，是全国各地卫视中举行最早的卫视春晚，也是全媒体互动特征最为明显的一台春晚。明星唱歌、代言两不误旅游春晚全名为“2013全国旅游行业春节联欢晚会”，以明显区别于其它卫视春晚的特色吸引了众多明星新秀到场，张纪中、孙悦、何洁、爱戴、常石磊、吴樾、黄鹤翔、阿普萨萨等轮番亮相。旅游春晚以歌舞节目为主，众明星为晚会准备了两至', '<p>据介绍，旅游春晚是全国旅游行业首次共聚一堂举行的晚会，晚会的主题为“美丽中国大拜年”，是全国各地卫视中举行最早的卫视春晚，也是全媒体互动特征最为明显的一台春晚。</p>\n<p><strong>明星唱歌、代言两不误</strong></p>\n<p>旅游春晚全名为“2013全国旅游行业春节联欢晚会”，以明显区别于其它卫视春晚的特色吸引了众多明星新秀到场，张纪中、孙悦、何洁、爱戴、常石磊、吴樾、黄鹤翔、阿普萨萨等轮番亮相。</p>\n<p>旅游春晚以歌舞节目为主，众明星为晚会准备了两至三首歌曲，在演唱之余，明星还与主持人积极互动，向观众介绍推荐自己的家乡，何洁在晚会上动情地介绍了自己的彝族身份，代表家乡向全国观众发出了诚挚的邀请。而歌手常石磊究竟是广东人还是蒙古人？也在晚会上揭晓了答案，出生于广东的常石磊，祖籍是蒙古，于是他肩负起了同时“代言”两个家乡的重任，号召观众“既要去蒙古，也要来广东。”</p>\n<p>晚会浓重的节日气氛，因为明星为家乡的代言而充满了温暖的乡情，多位明星在晚上舞台上表示，很荣幸能为家乡做点事，能为家乡的旅游经济做点贡献。</p>\n<p><strong>500万旅游大奖等着拿</strong></p>\n<p>旅游春晚由李秀媛、阿涩、杨旸等主持，在晚上现场，发奖成为最欢乐的环节，凡是打进电话的观众，都会获得一份价值不等的奖品，但前提是回答主持人提出的一个问题，在有史以来最容易回答的问题——“你想不想拿到这个奖”后，观众仅需说出一个字“想！”，即可如愿获奖。</p>\n<p>3天2晚豪华游轮、马尔代夫狄娃婚纱摄影浪漫套系、德懋堂度假徽居别墅住宿、亚布力阳光独家套门票、皇家驿站皇帝套房……价值几百到几千元的奖品设置，让当晚旅游春晚的电话暴热，现场观众纷纷拿出手机拨打，打进电话者即可抽奖。场外观众通过电视荧幕的提示信息，也可通过多种渠道抢到全程免费旅游、单项免单旅游机会，以及免费专车、免费食宿、免费门票等。</p>\n<p>旅游春晚宣传负责人杨旸表示，“为观众设置丰富的奖品，增加了晚会的热闹氛围，也是对一直以来关心旅游卫视观众们的一次回报，我们期望观众在新春能博得一个好彩头，在新的一年有好运气相伴随！”</p>\n<p><strong>韩美林奥运之后又出新设计</strong></p>\n<p>旅游春晚现场，有个很特别的“嘉宾”，吸引了无数观众的视线，它即是著名艺术家韩美林，专为晚会设计的拜年卡通形象“游游”。在接到旅游春晚设计拜年卡通形象的邀请后，韩美林用短短几天时间便拿出了设计方案，拜年开通形象“游游”外形活泼可爱、健康阳光，是对“旅游”概念的最好诠释。</p>\n<p>“游游”是韩美林2008北京奥运会“福娃”设计之后的又一力作，它的出现加深了观众对旅游春晚的印象，同时也提升了旅游春晚的辨识度。</p>\n<p>“和其它卫视春晚相比，旅游卫视的辨识度很高”，杨旸说，“从今年开始，旅游卫视春晚将会秉承将旅游事业发扬光大的理念，吸引更多明星群加入，提高观众的参与度，使旅游春晚成为能给观众留下深刻印象的一台晚会。”</p>\n<p><strong>美丽中国大拜年，提升幸福心能量</strong></p>\n<p>去年底，旅游卫视进行改版，连续推出《公司好声音》、《天才九宫格》、《海誓山盟》、《音乐心旅程》四档新节目，旅游卫视品牌理念也由“心媒体”升级为“幸福心能量”。</p>\n<p>将本届旅游春晚主题定为“美丽中国大拜年”，是旅游卫视紧扣“幸福心能量”理念而作出的选择，在晚会中，明星表演与祖国山水展示相得益彰，全媒体应用让“美丽中国”得到了最大程度的体现。<br />&nbsp;</p>', NULL, 1, 0, 0, 1370091709, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (18, '旅游春晚拜年 韩美林设计吉祥物', ',26,', '旅游春晚拜年 韩美林设计吉祥物', '名为“天池晓月”的网友微博贴出的图片显示，“游游”并未标注作者为韩美林，但却标注了“旅游卫视拜年娃娃”字样，经与旅游卫视核实，网上流出图片可能是参加“旅游春晚”彩排的观众拍摄。旅游卫视宣传负责人杨旸表示，“游游”的确为韩美林应旅游卫视之邀所创作，作为今年旅游卫视举办的旅游春晚吉祥物推出，它将会出现于旅游春晚现场的各个角落。有网友称赞，韩美林新作“游游”很有中国特色，但也有网友委婉指出，“游游”和福', 'admin', '未知', '名为“天池晓月”的网友微博贴出的图片显示，“游游”并未标注作者为韩美林，但却标注了“旅游卫视拜年娃娃”字样，经与旅游卫视核实，网上流出图片可能是参加“旅游春晚”彩排的观众拍摄。旅游卫视宣传负责人杨旸表示，“游游”的确为韩美林应旅游卫视之邀所创作，作为今年旅游卫视举办的旅游春晚吉祥物推出，它将会出现于旅游春晚现场的各个角落。有网友称赞，韩美林新作“游游”很有中国特色，但也有网友委婉指出，“游游”和福', '<p style=\"text-indent: 21.0pt;text-align: center;\"><img style=\"float: none;margin: 0.0px;\" src=\"http://img04.taobaocdn.com/tps/i4/T1UTw_Xe0fXXazt1PL-401-550.jpg\" /> <img style=\"float: none;margin: 0.0px;\" src=\"http://img04.taobaocdn.com/tps/i4/T1UTw_Xe0fXXazt1PL-401-550.jpg\" /> <img style=\"float: none;margin: 0.0px;\" src=\"http://img02.taobaocdn.com/tps/i2/T154A_XoxgXXb1upjX.jpg\" /></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">名为“天池晓月”的网友微博贴出的图片显示，“游游”并未标注作者为韩美林，但却标注了“旅游卫视拜年娃娃”字样，经与旅游卫视核实，网上流出图片可能是参加“旅游春晚”彩排的观众拍摄。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">旅游卫视宣传负责人杨旸表示，“游游”的确为韩美林应旅游卫视之邀所创作，作为今年旅游卫视举办的旅游春晚吉祥物推出，它将会出现于旅游春晚现场的各个角落。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">有网友称赞，韩美林新作“游游”很有中国特色，但也有网友委婉指出，“游游”和福娃有异曲同工之妙。对此杨旸表示，“游游”在设计时，韩美林充分运用了民俗概念，卡通形象活泼可爱，很能代表旅游业，台里对此设计很满意。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">据了解，旅游卫视已经连续两年未转播央视春晚，此次筹办“旅游春晚”将加入今年的春晚战团，目前正在紧锣密鼓进行彩排。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">杨旸对记者称，“旅游春晚”为了回报和感谢长期支持旅游卫视的观众，在明星阵容、晚会形式等方面均有很大吸引人之处，尤其在提升晚会参与度方面，更有“重量级”的设计，让观看节目的观众收获惊喜。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span style=\"font-family: 宋体;\">旅游春晚是全国旅游行业首次共聚一堂举行的晚会，晚会聚集了众多明星，既有丰富娱乐特征，也不乏行业特色，晚会的主题为“美丽中国大拜年”，是全国各地卫视中举行最早的卫视春晚，该档晚会将于</span><span>2</span><span style=\"font-family: 宋体;\">月</span><span>3</span><span style=\"font-family: 宋体;\">日</span><span>19</span><span style=\"font-family: 宋体;\">时</span><span>35</span><span style=\"font-family: 宋体;\">分在旅游卫视正式播出，全媒体互动的晚会形式让这台春晚充满新鲜感，引人期待。</span></p>\n<p style=\"text-indent: 21.0pt;\"><span>&nbsp;</span></p>\n<p style=\"text-indent: 21.0pt;\"><span>&nbsp;</span></p>', NULL, 1, 1, 0, 1370091710, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (19, '安卓成首个分发过2千万应用商店', ',26,', '安卓成首个分发过2千万应用商店', '从2012年7月开始，安卓市场日应用分发量从1080万一路飙升，半年之间实现翻番，在12月一举达到最高单日分发2079万。在这个巨大量级的分发中：占比最高的是以下6类应用：输入法、系统工具类、影音图像类、棋牌休闲类、生活购物类、通讯聊天类、美化壁纸类，分别占比15%、14%、10%、10%、9%、7%，囊括了所有应用的65%的下载量，可见用户生活的刚需之大。移动应用已将传统互联网产品服务完美延伸到', 'admin', '未知', '从2012年7月开始，安卓市场日应用分发量从1080万一路飙升，半年之间实现翻番，在12月一举达到最高单日分发2079万。在这个巨大量级的分发中：占比最高的是以下6类应用：输入法、系统工具类、影音图像类、棋牌休闲类、生活购物类、通讯聊天类、美化壁纸类，分别占比15%、14%、10%、10%、9%、7%，囊括了所有应用的65%的下载量，可见用户生活的刚需之大。移动应用已将传统互联网产品服务完美延伸到', '<p align=\"center\"><img alt=\"安卓市场成国内首个日均分发过2000万的第三方应用商店\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1_c.6XfVgXXXXXXXX.jpg\" /></p>\n<p>从2012年7月开始，安卓市场日应用分发量从1080万一路飙升，半年之间实现翻番，在12月一举达到最高单日分发2079万。在这个巨大量级的 分发中：占比最高的是以下6类应用：输入法、系统工具类、影音图像类、棋牌休闲类、生活购物类、通讯聊天类、美化壁纸类，分别占比15%、14%、 10%、10%、9%、7%，囊括了所有应用的65%的下载量，可见用户生活的刚需之大。移动应用已将传统互联网产品服务完美延伸到手机端，甚至颠覆了传 统互联网的已有模式。移动应用已经渗透进人们生活的方方面面，正在塑造一种新的生活方式，移动生活时代即将来临。</p>\n<p>在TOP榜单中，应用类：微信以无可争议的优势勇夺冠军，其次是QQ、搜狗输入法、墨迹天气、新浪微博;而在游戏方面：水果忍者以其广泛的群众基 础，位居下载量第一的位置，而QQ游戏、愤怒的小鸟、捕鱼达人、植物大战僵尸则分列余下的席位。可见，休闲游戏市场占有率不容小觑。</p>\n<p>援引某第三方研究机构2012年国内第三方移动应用商店研究报告数据：</p>\n<p>以10款热门应用同一版本在不同移动应用商店内的下载量进行统计，安卓市场在应用下载量方面表现出了较为明显的优势。</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1sW.7Xa0dXXXXXXXX.jpg\" /></p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1egc7XedbXXXXXXXX.jpg\" /></p>\n<p>91无线2010年9月成立，是网龙公司旗下专注于无线互联网业务开发与拓展的高新技术企业。旗下拥有安卓市场、91助手两大应用分发平台，91手 机娱乐、安卓网两大门户网站、熊猫看书、91桌面、安卓桌面等强势垂直产品。形成了以内容为端口的完整移动互联应用产品群，是国内最大、最具影响力的智能 手机服务平台。安卓市场更是以强大的分发能力与极丰富的内容得到业界普遍认可，在主要第三方咨询机构Android应用市场榜单排名中均位居前列。无论应 用总数量、累积总下载量、日均分发量、开发者数量等核心数据排名均为首位。截至2012年12月，安卓市场用户量已达7123万，上架应用数超50万。</p>\n<p>有数据表明，70%以上的应用开发者通过第三方应用商店分发他们的应用。而应用商店作为移动互联网主要入口以及开发者应用的首要分发平台，积累大量 用户使用习惯、应用下载、搜索，以及开发者相关的各种数据。可以预见的是，2013年各大应用商店势必加大数据精准挖掘的力度，推出个性化、精确化和智能 化的用户服务。在过去的一年中，应用商店出现严重同质化问题，如各家排行榜大同小异、功能雷同，编辑推荐毫无差异化，结果诸多新兴应用商店纷纷被淘汰下 马。给各大应用商店带来的警示，主流应用商店在2013年必须重视长尾需求，不只是让最好的开发者盈利，还要让更多的开发者存活下来，而有意进入应用商店 领域的机构必须要有相应的差异化策略，方能从大牌应用商店的夹缝中杀出一条血路，闯出自己的天空。</p>', NULL, 1, 1, 0, 1370091710, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (20, '91无线首发《魂斗罗进化革命》', ',26,', '91无线首发《魂斗罗进化革命》', '如今《魂斗罗》，在移动互联时代，他回归了，并且直接登陆智能手机平台。千万游戏迷心中的永恒经典《魂斗罗进化革命》高清版(Android)，今日联合91无线强势首发，让你重燃儿时激情，回归家用机时代的《魂斗罗》岁月!由KONAMI公司开发的游戏神作，荣登安卓手机游戏平台，将其无懈可击的完美体验，精彩再现!《魂斗罗》安卓版完美支持全部主流分辨率，完美适配各种品牌机型，中低端机型用户也可以尽情体验大画面，', 'admin', '未知', '如今《魂斗罗》，在移动互联时代，他回归了，并且直接登陆智能手机平台。千万游戏迷心中的永恒经典《魂斗罗进化革命》高清版(Android)，今日联合91无线强势首发，让你重燃儿时激情，回归家用机时代的《魂斗罗》岁月!由KONAMI公司开发的游戏神作，荣登安卓手机游戏平台，将其无懈可击的完美体验，精彩再现!《魂斗罗》安卓版完美支持全部主流分辨率，完美适配各种品牌机型，中低端机型用户也可以尽情体验大画面，', '<p>如今《魂斗罗》，在移动互联时代，他回归了，并且直接登陆智能手机平台。千万游戏迷心中的永恒经典《魂斗罗进化革命》高清版(Android)，今 日联合91无线强势首发，让你重燃儿时激情，回归家用机时代的《魂斗罗》岁月!由KONAMI公司开发的游戏神作，荣登安卓手机游戏平台，将其无懈可击的 完美体验，精彩再现!</p>\n<p>《魂斗罗》安卓版完美支持全部主流分辨率，完美适配各种品牌机型，中低端机型用户也可以尽情体验大画面，流畅运行，下载迅速快，占用容量小等诸多优点。</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1sUo6XltcXXXXXXXX.jpg\" /></p>\n<p>游戏介绍：</p>\n<p>【精彩画面】、【热血武器】、【全新系统】、【重现经典关卡】全新设定，巅峰级制作!</p>\n<p>《魂斗罗》安卓版在遵从经典元素的基础上，将武器、界面、关卡、BOSS，进行了重新设计更加适合触屏手机操作。同时针对战斗中的各种射击、爆炸效果进行了调整，爆发力、打击感十足。让战斗更加激情!</p>\n<p>还记得终极Boss的模样吗?曾经的我们第一次挑战boss的兴奋感还记忆犹新吗?</p>\n<p>第3关boss</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1pBU6XadeXXXXXXXX.jpg\" /></p>\n<p>第4关boss</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1O876XoldXXXXXXXX.jpg\" /></p>\n<p>第6关</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1bO75XhpgXXXXXXXX.jpg\" /></p>\n<p>那时的心跳加速与兴奋感将在安卓版上重现，所有关卡与终极boss等着你的挑战!同时《魂斗罗》安卓版，添加全新BOSS连战。当玩家胜利通关后， 由全部的关底BOSS组成的终极关卡全面开启!不必再闯漫长的地图，不必再过无数的低级敌人，玩家可以直接挑战令人热血沸腾的关底BOSS。用你的华丽战 斗技巧，升华你的闯关体验!强大的BOSS们，在等待着通关的英雄!</p>\n<p align=\"center\"><img border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T18Oo6XX0fXXXXXXXX.jpg\" /></p>\n<p>据介绍，91无线依托安卓市场、91助手等产品成功已经成长为国内最大规模和最具影响力的移动应用分发平台，截至2012年10月，91助手累计用 户数已达发1.3亿，安卓市场累计用户数达5，500万。2012年12月，安卓市场更成为国内首个日均分发量突破2000万的应用商店。其强大的分发能 力与庞大的用户群，奠定了安卓市场和91助手在业内无可争议的领导地位。91无线一直致力于为广大用户引进国内外最优质的手游作品，为玩家带来极致的游戏 体验。本次联手日本最具影响力的游戏软件商KONAMI，可谓是强强联合，优势互补必将能达到达到双赢的效果。</p>\n<p>看完如此详实的介绍，是不是已经心动到按捺不住了呢?那就赶快打开你手机上的安卓市场或91助手，搜索“魂斗罗”，抢先回味这场记忆中的饕餮游戏盛宴吧。</p>\n<p>PC端也可以下载哦：</p>\n<p>91助手下载地址：http://apk.91.com/Soft/Detail.aspx?Platform=Android&amp;f_id=4763136</p>', NULL, 1, 1, 0, 1370091710, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (21, '91无线优秀应用评选百家厂商参赛', ',26,', '91无线优秀应用评选百家厂商参赛', '从参选对象上看，视频影音，社交聊天，游戏娱乐，美食旅游类的app占据了较大的份额，我们也会将这些时下流行的元素分别列出供用户选择，也包括今年上了《天天向上》的某些app。同时，今年与时下主流媒体新浪微博合作，倾力打造参选平台，优化了参选页面和规范了参选规则，参赛入口与投票入口分开，参选者提交后发出邮件提醒，可以告知是否提交通过，也方便了网友找到投票入口。大赛官网：http://px.91.com/', 'admin', '未知', '从参选对象上看，视频影音，社交聊天，游戏娱乐，美食旅游类的app占据了较大的份额，我们也会将这些时下流行的元素分别列出供用户选择，也包括今年上了《天天向上》的某些app。同时，今年与时下主流媒体新浪微博合作，倾力打造参选平台，优化了参选页面和规范了参选规则，参赛入口与投票入口分开，参选者提交后发出邮件提醒，可以告知是否提交通过，也方便了网友找到投票入口。大赛官网：http://px.91.com/', '<div class=\"inner_main_text\">\n <p>从参选对象上看，视频影音，社交聊天，游戏娱乐，美食旅游类的app占据了较大的份额，我们也会将这些时下流行的元素分别列出供用户选择，也包括今 年上了《天天向上》的某些app。同时，今年与时下主流媒体新浪微博合作，倾力打造参选平台，优化了参选页面和规范了参选规则，参赛入口与投票入口分开， 参选者提交后发出邮件提醒，可以告知是否提交通过，也方便了网友找到投票入口。</p>\n <p>大赛官网：http://px.91.com/91app/</p>\n <p align=\"center\"><img alt=\"91无线2012年度优秀应用评选大赛页面\" src=\"http://img01.taobaocdn.com/tps/i1/T1xt34XX0XXXXXXXXX.jpg\" /></p>\n <p align=\"center\">91无线2012年度优秀应用评选大赛页面</p>\n <p>距离报名截止还有27天，各类优秀的app抓紧时间参与到评选中来，不要错过这一场移动互联网的年末饕餮盛宴!本次评选结果将通过专家评分和新浪微 博、91网友票选等方式综合评选得出，最终将评选出最佳应用、风云人物、优秀研发团队等总共15类奖项。如果拥有一款不错的app，或者你有一个优秀的开 发团队，那就加入我们吧!</p>\n <p>大赛报名地址：http://px.91.com/91app/baomin.php</p>', NULL, 1, 0, 0, 1370091711, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (22, '\"口碑评价\"成为化妆品业最关注内容', ',26,', '\"口碑评价\"成为化妆品业最关注内容', '近日，百度数据研究中心发布了2012年Q3化妆品行业研究报告。作为本次报告的独家合作媒体，为了更好的了解网友对化妆品的需求情况，OnlyLady女人志携手百度进行了Q3化妆品行业解读，通过用户对化妆品需求情况，以全新角度更深入的解读中国化妆品行业。Q3季度行业报告主要呈现了三大特点。\"化妆品口碑评价\"跃居成为网民最关注内容从数据方面看到，三季度整体行业日均搜索指数较之上半年有所上涨，在8月甚至高达', 'admin', '未知', '近日，百度数据研究中心发布了2012年Q3化妆品行业研究报告。作为本次报告的独家合作媒体，为了更好的了解网友对化妆品的需求情况，OnlyLady女人志携手百度进行了Q3化妆品行业解读，通过用户对化妆品需求情况，以全新角度更深入的解读中国化妆品行业。Q3季度行业报告主要呈现了三大特点。\"化妆品口碑评价\"跃居成为网民最关注内容从数据方面看到，三季度整体行业日均搜索指数较之上半年有所上涨，在8月甚至高达', '<p>近日，百度数据研究中心发布了2012年Q3化妆品行业研究报告。作为本次报告的独家合作媒 体，为了更好的了解网友对化妆品的需求情况，OnlyLady女人志携手百度进行了Q3化妆品行业解读，通过用户对化妆品需求情况，以全新角度更深入的解 读中国化妆品行业。Q3季度行业报告主要呈现了三大特点。<br />&quot;化妆品口碑评价&quot;跃居成为网民最关注内容<br /> 从数据方面看到，三季度整体行业 日均搜索指数较之上半年有所上涨，在8月甚至高达361万次搜索。口碑的关注度比已高达15.3%，已超过品牌的关注度。用户对产品、品牌和口碑的关注依 旧遥遥领先其他内容，网民对直接购买、产品查询的热衷度也远高于虚拟的资讯介绍。OnlyLady分析指出，8月份随着秋季的到来，正是处于夏秋交替的季 节，网民搜索化妆品相关信息时，产品的口碑评价已超过品牌成为最关注的内容。网民在对化妆品的选择中，口碑评价有相当高的认知度，这也使得口碑评价成为网 民选择化妆品的重要参考。产品的口碑评价逐渐受到用户关注和依赖，在业内，以1700余万条真是口碑点评的闺蜜网正是以此为依托，成为中国最大的美妆品口 碑交流和消费指导社区。</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1mk.VXhxbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: left;\"><strong>消费者决策受节日影响</strong><br /> 香水类化妆品的搜索指数在七夕情人节期间具有明显上涨迹 象。香水是情人节礼物的常见选择，网民在搜索香水类化妆品时，具体产品成为其最主要关注内容，其次是价格。高档化妆品搜索指数在三季度内变化不大，但在七 夕情人节期间有明显上涨。涨幅度高达40%。 OnlyLady分析指出：消费者决策受节日影响，其对产品的搜索指数与关注度均有明显上升，节日过后相关指数逐步缓慢下降，也由此可见国人消费者对节日 及产品的关注度不无关联。</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1W4sVXk8bXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1CisUXaBeXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: left;\"><strong>大力发展网络渠道有助于化妆品品牌的正确市场走向</strong><br /> 在对Q3化妆品搜索指数进行观 测后不难发现，化妆品品牌在市场竞争激烈的大环境下，把品牌的综合优势展现出来并且把握和控制好市场终端渠道的建设和管理，才能稳步前进。而互联网作为新 兴媒介的传播渠道，是众多化妆品企业所关注的焦点，同时也意味着企业看到了互联网是未来的发展趋势，同时也是一个新兴营销渠道。网络宣传和推广成本相对于 传统渠道来说，口碑宣传效果好，成本较低，更容易让更多的人了解到品牌。现在方便快捷的网络能够更多的满足消费随时随地的化妆品品牌的咨询和产品。此外， 从Q3报告中不难发现，用户群体凸显出女性化，年轻化等明显特征。<br />&nbsp;</p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T1UzZVXflbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;\"><img alt=\"点击查看频道页\" border=\"0\" src=\"http://img01.taobaocdn.com/tps/i1/T11UUVXfdaXXXXXXXX.jpg\" /></p>', NULL, 1, 0, 0, 1370091711, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (23, '过年还要看红装', ',26,', '过年还要看红装', '圣诞有圣诞的穿搭，新年也应有新年的穿搭，就让这个红色相集先揭开序幕。红色无容置疑真的是很tricky的颜色，一不小心就会穿得俗气。而AlexandraTomlinson不但穿红，还大呜大放地以全红装束出游，将快乐的气氛感染他人。耀眼夺目的鲜红让人在寒冬中也能感受到那份活力！要像AlexandraTomlinson般的全红穿搭或许真的有点难度，但配戴一些小饰品或只画一抹红唇也能使整个造型生色不少呢！', 'admin', '未知', '圣诞有圣诞的穿搭，新年也应有新年的穿搭，就让这个红色相集先揭开序幕。红色无容置疑真的是很tricky的颜色，一不小心就会穿得俗气。而AlexandraTomlinson不但穿红，还大呜大放地以全红装束出游，将快乐的气氛感染他人。耀眼夺目的鲜红让人在寒冬中也能感受到那份活力！要像AlexandraTomlinson般的全红穿搭或许真的有点难度，但配戴一些小饰品或只画一抹红唇也能使整个造型生色不少呢！', '<p>圣诞有圣诞的穿搭，新年也应有新年的穿搭，就让这个红色相集先揭开序幕。红色无容置疑真的是很 tricky 的颜色，一不小心就会穿得俗气。 而 Alexandra Tomlinson 不但穿红，还大呜大放地以全红装束出游，将快乐的气氛感染他人。耀眼夺目的鲜红让人在寒冬中也能感受到那份活力！要像 Alexandra Tomlinson 般的全红穿搭或许真的有点难度，但配戴一些小饰品或只画一抹红唇也能使整个造型生色不少呢！</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img01.taobaocdn.com/tps/i1/T1VgwVXdRbXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img03.taobaocdn.com/tps/i3/T1PZkVXiJbXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img03.taobaocdn.com/tps/i3/T1OsAVXgJbXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>', NULL, 1, 4, 0, 1370091711, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (24, '春夏上演帽子戏法', ',26,', '春夏上演帽子戏法', '今天分享的刚好就是来自澳洲的品牌，一直以来都很喜欢SuzyO’Rourke的作品，将头饰和帽子结合工艺的凋塑艺术，让品牌的风格既强烈又鲜明，在此个SpringSummerCouture2012/13系列中，同样串上了品牌独有的戏剧性，更多的是独特的别緻浪漫流窜其中，当中我又特别喜欢别上花朵的那几款。来吧～快来一探澳洲玩帽高手的视觉挑逗吧！   ', 'admin', '未知', '今天分享的刚好就是来自澳洲的品牌，一直以来都很喜欢SuzyO’Rourke的作品，将头饰和帽子结合工艺的凋塑艺术，让品牌的风格既强烈又鲜明，在此个SpringSummerCouture2012/13系列中，同样串上了品牌独有的戏剧性，更多的是独特的别緻浪漫流窜其中，当中我又特别喜欢别上花朵的那几款。来吧～快来一探澳洲玩帽高手的视觉挑逗吧！   ', '<p>\n	今天分享的刚好就是来自澳洲的品牌，一直以来都很喜欢 Suzy O’Rourke 的作品，将头饰和帽子结合工艺的凋塑艺术，让品牌的风格既强烈又鲜明，在此个 Spring Summer Couture 2012/13 系列中，同样串上了品牌独有的戏剧性，更多的是独特的别緻浪漫流窜其中，当中我又特别喜欢别上花朵的那几款。来吧～快来一探澳洲玩帽高手的视觉挑逗吧！\n</p>\n<p style=\"text-align:center;\">\n	&nbsp;<img src=\"http://img04.taobaocdn.com/tps/i4/T1sMUVXbXbXXaCwpjX.png\" /> \n</p>\n<p style=\"text-align:center;\">\n	&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1KqoVXjNcXXaCwpjX.png\" /> \n</p>\n<p style=\"text-align:center;\">\n	&nbsp;<img src=\"http://img04.taobaocdn.com/tps/i4/T1YhUHXotfXXaCwpjX.png\" /> \n</p>', 'uploadfiles/images/20130607/14d16d5c92b7d9c0c4b680e82c47d239.jpg', 1, 18, 0, 1370091712, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (25, 'bread n butter x ToyWatch', ',29,', 'bread n butter x ToyWatch', '   ToyWatch向以玩味手法革新经典手表款式，这次联乘款式为旗下大热的VelvetyCollection，白色硅胶陶瓷混合表身，表面设计用上breadnbutter专用DustyPurple粉紫色，并印有breadnbutter字款。每只手表的底盖更印独立编码001至100，配上特别设计的breadnbutterxToyWatch包装，更显其独一无二(售价HK$2,598)。001及002号', 'admin', '未知', '   ToyWatch向以玩味手法革新经典手表款式，这次联乘款式为旗下大热的VelvetyCollection，白色硅胶陶瓷混合表身，表面设计用上breadnbutter专用DustyPurple粉紫色，并印有breadnbutter字款。每只手表的底盖更印独立编码001至100，配上特别设计的breadnbutterxToyWatch包装，更显其独一无二(售价HK$2,598)。001及002号', '<p style=\"text-align: center;\">&nbsp;<img style=\"float: none;margin: 0.0px;\" src=\"http://img02.taobaocdn.com/tps/i2/T1VoKVXyRdXXbMEQYy-500-421.jpg\" />&nbsp;</p>\n<p>&nbsp;</p>\n<p style=\"text-align: justify;text-justify: inter-ideograph;\"><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">ToyWatch</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">向以玩味手法革新经典手表款式，这次联乘款式为旗下大热的</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">Velvety Collection</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">，白色硅胶陶瓷混合表身，表面设计用上</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">bread n butter </span><span style=\"font-size: 11.0pt;font-family: 宋体;\">专用</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">Dusty Purple</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">粉紫色，并印有</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">bread n butter </span><span style=\"font-size: 11.0pt;font-family: 宋体;\">字款。每只手表的底盖更印独立编码</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">001</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">至</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">100</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">，配上特别设计的</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">bread n butter x ToyWatch</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">包装，更显其独一无二</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\"> (</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">售价</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">HK$2,598)</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">。</span></p>\n<p style=\"text-align: center;\"><img src=\"http://img02.taobaocdn.com/tps/i2/T17piYXplbXXb1upjX.jpg\" /></p>\n<p><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">001</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">及</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">002 </span><span style=\"font-size: 11.0pt;font-family: 宋体;\">号限定版</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">bread n butter X ToyWatch </span><span style=\"font-size: 11.0pt;font-family: 宋体;\">手表已属潮流孖女</span><span style=\"font-size: 11.0pt;font-family: arial   sans-serif;\">Twins</span><span style=\"font-size: 11.0pt;font-family: 宋体;\">所拥有！</span></p>\n<p style=\"text-align: center;\"><img style=\"float: none;margin: 0.0px;\" src=\"http://img03.taobaocdn.com/tps/i3/T1FOKWXsxdXXcOG.Ly-500-911.jpg\" /></p>', NULL, 1, 0, 0, 1370091739, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (26, '纽约时装周街拍', ',29,', '纽约时装周街拍', '    ', 'admin', '未知', '    ', '<p style=\"text-align: center;\">&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1dfQFXjxgXXb1upjX.jpg\" /></p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img01.taobaocdn.com/tps/i1/T1RsUTXk0cXXb1upjX.jpg\" /></p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1WMkTXc0cXXb1upjX.jpg\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>', NULL, 1, 0, 0, 1370091740, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (27, '欧米茄星座华贵珠宝', ',29,', '欧米茄星座华贵珠宝', ' 欧米茄星座腕表是世界上最受欢迎、最具辨识度的表款之一。于1982年首次引入的托爪设计如今已成为星座腕表的标志性特征。这一传奇腕表系列正是Griffes系列珠宝的灵感之源。Griffes珠宝的设计与星座腕表表圈上的独特设计元素一脉相承，同样带有个性托爪，珠宝的一侧镌刻有罗马数字，另一侧则镌刻有“OMEGA”(欧米茄)字样。欧米茄Griffes系列珠宝柔美活泼、魅力非凡，每一枚Griffes珠宝都汲', 'admin', '未知', ' 欧米茄星座腕表是世界上最受欢迎、最具辨识度的表款之一。于1982年首次引入的托爪设计如今已成为星座腕表的标志性特征。这一传奇腕表系列正是Griffes系列珠宝的灵感之源。Griffes珠宝的设计与星座腕表表圈上的独特设计元素一脉相承，同样带有个性托爪，珠宝的一侧镌刻有罗马数字，另一侧则镌刻有“OMEGA”(欧米茄)字样。欧米茄Griffes系列珠宝柔美活泼、魅力非凡，每一枚Griffes珠宝都汲', '<p style=\"text-align: center;\">&nbsp;<img src=\"http://img03.taobaocdn.com/tps/i3/T1V7ISXdtdXXb1upjX.jpg\" /></p>\n<p>欧米茄星座腕表是世界上最受欢迎、最具辨识度的表款之一。于1982年首次引入的托爪设计如今已成为星座腕表的标志性特征。这一传奇腕表系列正是 Griffes系列珠宝的灵感之源。Griffes珠宝的设计与星座腕表表圈上的独特设计元素一脉相承，同样带有个性托爪，珠宝的一侧镌刻有罗马数字，另 一侧则镌刻有“OMEGA”(欧米茄)字样。欧米茄Griffes系列珠宝柔美活泼、魅力非凡，每一枚Griffes珠宝都汲取了星座腕表的精髓，个性出 众又意趣盎然。</p>\n<p>全新欧米茄Griffes系列华贵珠宝集隽永、优雅、动感于一身，必将成为当代珠宝传奇杰作。Griffes戒指采用黄金、红金或白金材质，表面经抛光打磨或镶嵌有璀璨美钻。耳环与长款项链同样经过抛光打磨。</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img04.taobaocdn.com/tps/i4/T1dH.TXg4cXXb1upjX.jpg\" /></p>\n<p style=\"text-align: left;\">欧米茄Flower系列华贵珠宝设计别出心裁，5个欧米茄品牌标识“Ω”相互交叠，构成花朵图案，巧妙利用了品牌标识的极高辨识度，同时又以其精美细节为整体设计平添一抹妩媚，尽显女性柔美魅力。设计中的花朵图案也别具深意，象征着无限热情和花样年华。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img03.taobaocdn.com/tps/i3/T12JQSXaleXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p>戒指、耳环和吊坠采用18K红金搭配珍珠贝母，或18K白金镶钻搭配黑色缟玛瑙。</p>\n<p>Flower系列华贵珠宝巧妙运用了珍珠贝母材质，其灵感源自欧米茄腕表的珍珠贝母表盘。这种独特的材质可恰到好处地彰显女性之美——珍珠贝母象征母性、温柔与呵护，是安宁、誓约和幸福的守护者。</p>\n<p>缟玛瑙则是一种极富特色的天然宝石，一直以来寓意着关爱与呵护，在古希腊，缟玛瑙被认为是爱的象征。Flower系列华贵珠宝中的黑色缟玛瑙与欧米茄腕表的黑色表盘传递着相同的内涵。</p>\n<p>&nbsp;</p>', NULL, 1, 0, 0, 1370091740, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (28, '五大血拼购物地推荐', ',29,', '五大血拼购物地推荐', '推荐不可错过的五大血拼购物朝圣之地，这些目的地不仅品牌齐全、环境优雅，更有惊人折扣呈上！另外，Hotels.com为方便游客住宿，推出高达六折冬季特惠酒店。在Hotels.com上通过注册帐号预订标有“住宿奖赏”的酒店，累计住满十晚后可申请获得一晚免费酒店住房。 推荐购物圣地：伦敦作为世界顶级品牌VivienneWestwood、AlexanderMcQueen、PaulSmith和AnyaHin', 'admin', '未知', '推荐不可错过的五大血拼购物朝圣之地，这些目的地不仅品牌齐全、环境优雅，更有惊人折扣呈上！另外，Hotels.com为方便游客住宿，推出高达六折冬季特惠酒店。在Hotels.com上通过注册帐号预订标有“住宿奖赏”的酒店，累计住满十晚后可申请获得一晚免费酒店住房。 推荐购物圣地：伦敦作为世界顶级品牌VivienneWestwood、AlexanderMcQueen、PaulSmith和AnyaHin', '<p>推荐不可错过的五大血拼购物朝圣之地，这些目的地不仅品牌齐全、环境优雅，更有惊人折扣呈上！另外，Hotels.com为方便游客住宿，推出高达六折冬季特惠酒店。在 Hotels.com上通过注册帐号预订标有“住宿奖赏”的酒店，累计住满十晚后可申请获得一晚免费酒店住房。</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img04.taobaocdn.com/tps/i4/T1MvgDXa8gXXb1upjX.jpg\" /></p>\n<p style=\"text-align: center;\"><strong>推荐购物圣地：伦敦</strong></p>\n<p style=\"text-align: left;\">作为世界顶级品牌Vivienne Westwood、AlexanderMcQueen、Paul Smith 和 Anya Hindmarch 的发源地，伦敦被当之无愧地誉为时尚朝圣之地。而位于伦敦郊区的Bicester 购物村则是知名的血拼目的地，此处汇集 130 多个全球知名品牌，全年提供建议零售价四折的购物优惠，包括Dunhill、Mulberry、Smythson、Matthew Williamson、Penhaligon’s、Agent Provocateur、Temperley London、Gieves &amp; Hawkes、Emma Bridgewater、Cath Kidston、以及欧美名牌 Gucci、Prada、Loro Piana、Salvatore Ferragamo等等。不但如此，Bicester购物村周围旅游景点繁多，包括著名的斯托小镇和百老汇等中世纪古镇，购物之余尽享美景美色。</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1M3IRXnpeXXb1upjX.jpg\" /></p>\n<p>Danubius Hotel Regents Park靠近Lord\'s Cricket Ground、伦敦动物园和杜莎夫人蜡像馆。附近还有皇家音乐学院和海德公园。酒店距维多利亚长途汽车站仅15分车程，在此乘坐Bicester购物村的 购物快车前往购物村仅需1小时车程。</p>\n<p>酒店每房每晚优惠均价人民币1,476*元起，原价约合人民币1,737*元（*以实际预订价格为准），入住可节省20%。旅客须于2012年12月18日之前完成预订，并于2013年1月31日之前入住方可享受优惠。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img01.taobaocdn.com/tps/i1/T16t.DXgxgXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p style=\"text-align: center;\"><strong>推荐购物圣地：巴黎</strong></p>\n<p>巴黎一直是不容置疑的时尚之都和时尚达人的购物天堂。在巴黎最具声誉的莫过于春天百货公司（Printemps Department Store Paris）和老佛爷百货(GaleriesLafayette)，这两家百货都位于著名的奥斯曼大道上，拜占庭式的建筑风格、古典豪华的装饰、琳琅满目 的品牌，更加上打折季的超低折扣，让购物成为享受。除此外，距巴黎市中心仅 35 分钟路程的La Vallee 购物村也是扫货的好去处，村内商品全年均有折扣，最高可达四折，村内囊括法国各大知名品牌，包括：Bonpoint、Celine、Givenchy、 Lancel，以及 Antik Batik、Agn&egrave;s b.和Lalique，还有国际知名品牌：Armani、Diane von Furstenberg、Jimmy Choo、Polo Ralph Lauren、Valentino、Salvatore Ferragamo等等。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img04.taobaocdn.com/tps/i4/T1lqASXctbXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p>H&ocirc;tel du Louvre位于巴黎的中心地带，只需少量步行就可到达皇宫和卢浮宫，附近还有新桥和奥赛博物馆。从酒店出发，步行2分钟即可到达Cityrama Office，每天均有三班La Vallee购物村的购物快车，直达La Vallee购物村。</p>\n<p>酒店每房每晚优惠均价人民币2,074*元起，原价约合人民币2,184*元（*以实际预订价格为准），入住可节省30%。旅客须于2012年12月18日之前完成预订，并于2013年1月31日之前入住方可享受优惠。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img02.taobaocdn.com/tps/i2/T1h4QQXj0eXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p style=\"text-align: left;\">对于众多购物狂们来说，纽约可谓名副其实的购物胜地。从时尚品牌到高级订制，从奢华商业街到平民商场，皆显现出时尚潮流引领者的至高地位，每年的12月至 1月，更是冬季打折季的火热时期。汇聚世界时尚精华的第五大道，几乎集齐世界各大一线品牌，LV旗舰店、Gucci、Versace、Herms、 Zegna、Dior、Chanel、Brooks Brothers、Nike town、Harry Winston、Tiffany以及FAO Schwarz玩具店等，各大品牌新品及限量版均汇聚于此。位于58街与第五大道交汇处的波道夫&middot;古德曼精品百货（Bergdorf Goodman）在第五大道上已有百年历史，百货内汇聚三百多个高档品牌，无论高级时装或是各大潮流品牌在此均可找到。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img01.taobaocdn.com/tps/i1/T1vjcSXg0XXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p>Best Western Plus President Hotel at Times Square位于纽约的中心地带，步行10分钟即可到达第五大道，中环广场剧院、百老汇街和时代广场、洛克菲勒中心和埃德&middot;苏利文剧院等均在附近。</p>\n<p>酒店每房每晚优惠均价人民币1,956*元起，原价约合人民币2,174*元（*以实际预订价格为准），入住可节省30%。旅客须于2012年12月18日之前完成预订，并于2013年1月31日之前入住方可享受优惠。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img03.taobaocdn.com/tps/i3/T1zL.SXoxXXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p style=\"text-align: left;\">名列“全球十佳购物之都”的香港因其较好的税率政策与应有尽有的国际品牌，一直是大陆游客短途出行、体验一站式购物游的首选之地。步入12月，各大商家纷 纷给出最低折扣，可谓购物血拼的最好时机。在香港，购物商城随处可见，坐落于香港繁华地段的中环置地广场，国际一线品牌汇聚，如Chanel、LV、 Loewe、Polo、Marc Jacob、Prada, Versace, Gucci、D&amp;G、Versus、Armani、以及Esprit、U2等。而香港面积最大的购物广场——海港城，汇聚了包括Chanel、 LV、Gucci、Prada、Dior、Dunhill、Hugo Boss、MaxMara、Vivienne Westwood等在内的700多家品牌店，购物休闲设施与酒店一应俱全，是体验一站式购物的最佳地点。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img04.taobaocdn.com/tps/i4/T1QKgSXnRXXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p>香港日航酒店位于尖沙咀东区，俯瞰迷人的维多利亚港湾，步行至著名的海港城商场仅需十几分钟、各大餐厅及娱乐场所均在附近。</p>\n<p>酒店每房每晚优惠均价人民币1,374*元起，原价约合人民币1,446*元（*以实际预订价格为准），入住可节省20%。旅客须于2012年12月18日之前完成预订，并于2013年1月31日之前入住方可享受优惠。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img01.taobaocdn.com/tps/i1/T1WIQDXlhgXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p style=\"text-align: center;\"><strong>推荐目的地：曼谷</strong></p>\n<p>曼谷可谓是东南亚最为物美价廉的购物天堂。现代化的高级购物商场，网罗世界品牌与本土设计， 特色购物街，露天集市与世界闻名的水上集市，各色本土商品包罗万象，让人流连忘返。被称为“东南亚最大商场”的Central World Plaza位于曼谷市中心，商场内现代化的装修风格结合泰国元素，尽显示泰式奢华。LV、Dior、Hugo Boss、Guess、Levis、Miss Sixty等国际品牌与NaRaYa、JSPAL等知名本土品牌更是齐齐汇聚，赶在打折时段，更有低至六折的惊喜优惠。</p>\n<p style=\"text-align: center;\">&nbsp;<span>&nbsp;</span><img src=\"http://img01.taobaocdn.com/tps/i1/T16wQRXaXdXXb1upjX.jpg\" /><span>&nbsp;</span></p>\n<p>The AETAS Bangkok位于曼谷素坤逸路，乘车前往Central World Plaza仅10分钟路程，鲁比尼公园和水门市场，暹罗百丽宫及帕蓬夜市等著名旅游景点均在附近。</p>\n<p>酒店每房每晚优惠均价人民币620*元起（*以实际预订价格为准），入住可节省40%。旅客须于2012年12月18日之前完成预订，并于2013年1月31日之前入住方可享受优惠。</p>\n<p>&nbsp;</p>\n<p>&nbsp;</p>', NULL, 1, 0, 0, 1370091740, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (29, '挑选情人节最浪漫餐厅', ',29,', '挑选情人节最浪漫餐厅', '罗曼蒂克之夜醉人海景晚餐CafeDecoGroup限量情人节美食套餐 甜蜜共聚太平山顶峰-峰景餐厅透过餐厅的落地玻璃幕牆，恋人们可一边远眺香港繁华港口的夜色及闻名世界的摩天大厦，一边享用由餐厅精心设计的五道菜精选套餐，每位港币698，凡惠顾精选套餐的顾客更可获赠蛋白杏仁饼(Macaron)一盒。套餐完整菜单如下：情人节精选头盘日式小杯生蚝、青柠醃带子、蓝蟹细卷、炸鲜虾青口角餐汤椰菜花忌廉汤配红菜头', 'admin', '未知', '罗曼蒂克之夜醉人海景晚餐CafeDecoGroup限量情人节美食套餐 甜蜜共聚太平山顶峰-峰景餐厅透过餐厅的落地玻璃幕牆，恋人们可一边远眺香港繁华港口的夜色及闻名世界的摩天大厦，一边享用由餐厅精心设计的五道菜精选套餐，每位港币698，凡惠顾精选套餐的顾客更可获赠蛋白杏仁饼(Macaron)一盒。套餐完整菜单如下：情人节精选头盘日式小杯生蚝、青柠醃带子、蓝蟹细卷、炸鲜虾青口角餐汤椰菜花忌廉汤配红菜头', '<h3><span style=\"font-size: 14.0px;\">罗曼蒂克之夜 醉人海景晚餐</span></h3>\n<h1><span style=\"font-size: 14.0px;\">Cafe Deco Group 限量情人节美食套餐</span></h1>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img01.taobaocdn.com/tps/i1/T1tDZLXaXeXXb1upjX.jpg\" /></p>\n<p><strong>甜蜜共聚太平山顶峰</strong><strong>-</strong><strong>峰景餐厅</strong></p>\n<p>透过餐厅的落地玻璃幕牆，恋人们可一边远眺香港繁华港口的夜色及闻名世界的摩天大厦，一边享用由餐厅精心设计的五道菜精选套餐，每位港币698，凡惠顾精选套餐的顾客更可获赠蛋白杏仁饼(Macaron)一盒。套餐完整菜单如下：</p>\n<p align=\"center\">情人节精选头盘</p>\n<p align=\"center\">日式小杯生蚝、青柠醃带子、蓝蟹细卷、炸鲜虾青口角</p>\n<p align=\"center\">餐汤</p>\n<p align=\"center\">椰菜花忌廉汤配红菜头脆片</p>\n<p align=\"center\">前菜</p>\n<p align=\"center\">鸭肝野菌云吞配青豆苗、黑菌汁</p>\n<p align=\"center\">主菜</p>\n<p align=\"center\">鲜茄烩地中海鲈鱼伴龙虾、鑽石蚬</p>\n<p align=\"center\">或</p>\n<p align=\"center\">澳洲<span>M7和牛配芝士焗龙虾</span></p>\n<p align=\"center\">甜品</p>\n<p align=\"center\">情人节诱心甜点</p>\n<p style=\"text-align: center;\">&nbsp;<span style=\"display: none;\">&nbsp;</span><img src=\"http://img01.taobaocdn.com/tps/i1/T1ElsMXnJbXXb1upjX.jpg\" /><span style=\"display: none;\">&nbsp;</span></p>\n<p>餐厅位于珍宝海鲜舫顶层，情人们可在香港驰名的避风塘及毗连豪华游艇会景色下享用由新加盟的行政总厨Zero Yu特别推出的六道菜精选套餐，价格为港币1,314（两位计），菜单如下：</p>\n<p align=\"center\">餐前小吃</p>\n<p align=\"center\">鲜蚝伴三文鱼子配接骨木花啫喱</p>\n<p align=\"center\">第一道菜</p>\n<p align=\"center\">鹅肝酱配牛油麵饱伴提子汁</p>\n<p align=\"center\">第二道菜</p>\n<p align=\"center\">烧鸡浓汤配温泉蛋、小龙虾</p>\n<p align=\"center\">主菜</p>\n<p align=\"center\">扒熟成肉眼配辣根忌廉、红酒汁</p>\n<p align=\"center\">或</p>\n<p align=\"center\">香煎蓝鳕鱼伴软心薯、黑蒜汁</p>\n<p align=\"center\">甜品</p>\n<p align=\"center\">甜心蛋白</p>\n<p align=\"center\">心连心</p>\n<p>&nbsp;</p>\n<p><strong>拥抱</strong><strong>270</strong><strong>度维港景色</strong><strong>– Watermark</strong></p>\n<p>餐厅位于香港中环天星码头，坐拥无敌大海景。餐厅于情人节晚将提供五道菜精选套餐，价格为港币2,198（两位计），凡惠顾二人餐更可获赠两杯香槟，菜单如下：</p>\n<p align=\"center\">前菜</p>\n<p align=\"center\">法式传统鹅肝批配甜酒啫喱，青苹果及瑞士甜菜沙律</p>\n<p align=\"center\">餐汤</p>\n<p align=\"center\">黑松露沫浓汤併香煎带子及香草迷利萝卜沙律</p>\n<p align=\"center\">热情果雪葩配薄脆及柠檬蛋白饼</p>\n<p align=\"center\">主菜</p>\n<p align=\"center\">香煎鳟鱼配刁草酱、珍珠茴香、夏南瓜花、藏红花香醋汁</p>\n<p align=\"center\">或</p>\n<p align=\"center\">香烤爱尔兰顶级西冷牛扒配白甘笋酱、彩色番茄、焦糖乾葱及露笋、雪梨牛肉汁</p>\n<p align=\"center\">甜品</p>\n<p align=\"center\">云呢拿烩香梨配拖肥汁、玫瑰啫喱及朱古力雪糕</p>\n<p>www.cafedecogroup.com</p>\n<p><i>所有价目另设加一服务费。</i></p>\n<p><strong>峰景餐厅</strong>位于香港山顶道118号山顶广场一楼及二楼，营业时间为星期一至四及星期日上午11时至晚上11时；星期五及六上午11时至凌晨11时30分。预订座位或查询，请致电(852)2849 5111或电邮至cafedeco@cafedecogroup.com。</p>\n<p><strong>珍之宝餐厅</strong>位于香港香港仔黄竹坑深湾码头珍宝海鲜舫顶层，营业时间为星期二至五正午12时至深夜；星期六、日及公众假期上午11时至深夜。预订座位或查询，请致电(852) 25523331或电邮至topdeck@cafedecogroup.com。</p>\n<p><strong>Watermark</strong>位于香港中环7号天星码头平台L铺。营业时间为星期一至日上午11时至晚上11时。预订座位或查询，请致电(852) 2167 7251或电邮至watermark@cafedecogroup.com。</p>\n<p>&nbsp;</p>', NULL, 1, 0, 0, 1370091741, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (50, 'Erdem2013 早秋女装系列', ',29,', 'Erdem2013 早秋女装系列', '设计师对面料的多样创新应用也让人印象深刻，真丝绉绣在了PVC材质的半身裙和连衣裙上，营造出鱼鳞斑的效果。蕾丝也被混合在绉绸中。         ', 'admin', '未知', '设计师对面料的多样创新应用也让人印象深刻，真丝绉绣在了PVC材质的半身裙和连衣裙上，营造出鱼鳞斑的效果。蕾丝也被混合在绉绸中。         ', '<p>设计师对面料的多样创新应用也让人印象深刻，真丝绉绣在了PVC材质的半身裙和连衣裙上，营造出鱼鳞斑的效果。蕾丝也被混合在绉绸中。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img04.taobaocdn.com/tps/i4/T115EuXgxgXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1XbEJXgheXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<span style=\"display: none;\">&nbsp;</span><img src=\"http://img04.taobaocdn.com/tps/i4/T1bXoJXoFdXXaCwpjX.png\" /><span style=\"display: none;\">&nbsp;</span></p>\n<p style=\"text-align: center;\">&nbsp;</p>', NULL, 1, 0, 0, 1370091750, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (51, 'Chanel 2013早春配饰系列', ',29,', 'Chanel 2013早春配饰系列', '       ', 'admin', '未知', '       ', '<p style=\"text-align: center;\">&nbsp;<img src=\"http://img02.taobaocdn.com/tps/i2/T1Xs3JXgXcXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img01.taobaocdn.com/tps/i1/T14awtXhBiXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;<img src=\"http://img03.taobaocdn.com/tps/i3/T1SeUJXfxdXXaCwpjX.png\" /></p>\n<p style=\"text-align: center;\">&nbsp;</p>\n<p style=\"text-align: center;\">&nbsp;</p>', NULL, 1, 0, 0, 1370091751, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (52, '十款最逗趣造型手包', ',29,', '十款最逗趣造型手包', '如果选择一款手包作为礼物，大家的心头好是什么样的呢？永远不会出错的低调经典款？张扬霸气的McQueen骷髅款？还是镶珠缀金的复古华丽款？如果是我，我会毫不犹豫选择一款拥有逗趣造型的别致手包。造型逗趣的手包它的造型可以是一枚纸杯蛋糕，可以是一本书，可以是一只小狗，当然它也可以是一件乐器……只要拥有这样一款手包，无论搭配什么样的衣服，都能瞬间达到吸睛的效果；而且生活有时候如此无聊，是时候给自己找点乐子', 'admin', '未知', '如果选择一款手包作为礼物，大家的心头好是什么样的呢？永远不会出错的低调经典款？张扬霸气的McQueen骷髅款？还是镶珠缀金的复古华丽款？如果是我，我会毫不犹豫选择一款拥有逗趣造型的别致手包。造型逗趣的手包它的造型可以是一枚纸杯蛋糕，可以是一本书，可以是一只小狗，当然它也可以是一件乐器……只要拥有这样一款手包，无论搭配什么样的衣服，都能瞬间达到吸睛的效果；而且生活有时候如此无聊，是时候给自己找点乐子', '<p>如果选择一款手包作为礼物，大家的心头好是什么样的呢？永远不会出错的低调经典款？张扬霸气的McQueen骷髅款？还是镶珠缀金的复古华丽款？如果是我，我会毫不犹豫选择一款拥有逗趣造型的别致手包。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1SwPOXcpcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 造型逗趣的手包</p>\n<p>它的造型可以是一枚纸杯蛋糕，可以是一本书，可以是一只小狗，当然它也可以是一件乐器……只要拥有这样一款手包，无论搭配什么样的衣服，都能瞬间达到吸睛的效果；而且生活有时候如此无聊，是时候给自己找点乐子了！哪怕只是背上一只让人会心一笑的有趣手包。ARTINFO CHINA特意为大家挑选了十款造型有趣的“拟物”款手包，来看看哪款是你最想拥有的？</p>\n<p>Judith Leiber纸杯蛋糕晚宴包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nkDOXjJbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Judith Leiber纸杯蛋糕晚宴包</p>\n<p>第一次见到这款手包其实是在一部最近热播的幽默剧集《破产女孩》(Broke Girls)的第一季季终集中，Caroline为了将Max亲手制作的纸杯蛋糕带到晚宴上推荐给家政女王，就将真正的纸杯蛋糕放进了纸杯蛋糕形状的晚宴包中。那只精致小巧的，缀满水晶的粉色Bling Bling晚宴包承载了她们创业的梦想，同时也让观众对于Caroline的巧思会心一笑。如果你是一个甜食爱好者，这样一枚手包应该能起到“望梅止渴”的效果吧！</p>\n<p>Miss Deco红苹果手包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1iSHOXoJXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Miss Deco红苹果手包</p>\n<p>水果一直都是手包设计师们钟爱的元素之一。这“颗”红苹果手包采用了硬壳亚克力材质造成了鲜艳欲滴的视觉效果，同时又非常的耐用和结实。可开合的大苹果拥有理想的体积，足以放下必备的物件。贝母质感的叶片也为红苹果增添了华丽的感觉，完全可以应付任何的正式或非正式的场合。</p>\n<p>Olympia Le-Tan 书型手包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1WpbJXc4pXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Olympia Le-Tan 书型手包</p>\n<p>提到这款手包，相信大家都很熟悉，Olympia Le-Tan的 书型手包绝对可以称得上是近日最红的手包之一。当然，它的最初走红得益于两位明星，Natalie Portman以及参演过《哈利波特》，同时也是香奈儿品牌新宠的Clemence Poesy在出席活动时不约而同选择了这款看上去与真正书本无两异的手包。拿上这样一只手包，一种浪漫文艺的气息瞬间加身；多本名著造型以及多款颜色的选择，也使得它成为了百搭利器！</p>\n<p>更多精彩资讯请关注 新浪尚品、欲望潮品</p>\n<p>Kate Spade 键盘包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1eZjNXddkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Kate Spade 键盘包</p>\n<p>Kate Spade的键盘包会让人真正体会到音乐无处不在的意境。就如同电影《钢的琴》中主人公为女儿练习钢琴而自己DIY的纸版键盘，这款手包也能为习琴爱好者提供随时随地联系的机会，足以以假乱真。</p>\n<p>Kate Spade猫头鹰包&amp;Judith Leiber小狗造型包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GjPNXaxiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Kate Spade猫头鹰包（左）和Judith Leiber小狗包（右）</p>\n<p>将这两款手包放在一起介绍的原因不言而喻，它们都是爱动物的朋友们不愿意错过的。以猫头鹰和狗——这两种“万人迷”为灵感的设计不胜枚举，而Kate Spade和Judith Leiber两个手包系列就是典型代表。Kate Spade以猫头鹰为造型，创作了一系列各式包袋；而Judith Leiber则设计了包括雪纳瑞，小猎犬等多个品种小狗的造型手包。</p>\n<p>Lulu Guinness红唇包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1s0LOXeleXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Lulu Guinness红唇包</p>\n<p>乍一看以为是唇膏广告：豹纹的，烈焰红唇，铆钉，米字旗等图案应有尽有，但实际这些“嘴唇”都是Lulu Guinness的嘴唇手包。因买不到钟意的手包，而决定自己设计的Lulu Guinness打造的手包都透露着浓浓的英伦气息，以四、五十年代怀旧的元素作为设计灵感，带有高贵英国淑女优雅的气质。</p>\n<p>Braccialini复古火车包&amp;复古电话包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Hl_OXkJaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Braccialini电话包和火车包</p>\n<p>这年头当然少不了“复古”这个关键词。意大利品牌Braccialini很好地平衡了复古与有趣，不仅保留了复古的精髓，又不显得沉闷，千篇一律。复古火车，小汽车，电话以及古典乐器为Braccialini的设计师提供了无限的灵感，这个系列手包非常适合复古达人凹造型的需要。</p>\n<p>Judith Leiber珠宝佛像手包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PsLNXotnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Judith Leiber珠宝佛像手包</p>\n<p>最后一个推荐还是来自Judith Leiber ，谁叫他们家的大部分手包都如此有趣，吸引眼球呢？这款以大佛为灵感的珠宝佛像手包绝对独一无二，搭配中式和西式服装两相宜；同时这个系列中还有印度佛教的象神等形象，都非常的精致华丽。</p>\n<p>更多精彩资讯请关注 新浪尚品、欲望潮品</p>', NULL, 1, 0, 0, 1370091751, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (53, '迷你半裙混搭入秋 成就超撩人美腿', ',29,', '迷你半裙混搭入秋 成就超撩人美腿', '天气渐凉的时候，千万别忙着把夏天的衣服收起来，特别是能让美腿完美展现的迷你半裙，它可是各种早秋轻薄外套的绝佳拍档。潮人们为我们演绎了四款半裙分别与四种外套的搭配，掌握好它们可以让你的美腿更撩人。时尚解析：今夏最流行的亮色半裙可以轻易打破黑色西装外套的沉闷和保守，只需再搭配一件纯色吊带和优雅高跟鞋，瞬间点亮你的办公空间。时尚解析：黑白灰咖的半身裙与优雅的系带衬衫或印花衬衫组合，搭配上及踝短靴，时髦个', 'admin', '未知', '天气渐凉的时候，千万别忙着把夏天的衣服收起来，特别是能让美腿完美展现的迷你半裙，它可是各种早秋轻薄外套的绝佳拍档。潮人们为我们演绎了四款半裙分别与四种外套的搭配，掌握好它们可以让你的美腿更撩人。时尚解析：今夏最流行的亮色半裙可以轻易打破黑色西装外套的沉闷和保守，只需再搭配一件纯色吊带和优雅高跟鞋，瞬间点亮你的办公空间。时尚解析：黑白灰咖的半身裙与优雅的系带衬衫或印花衬衫组合，搭配上及踝短靴，时髦个', '<p>天气渐凉的时候，千万别忙着把夏天的衣服收起来，特别是能让美腿完美展现的迷你半裙，它可是各种早秋轻薄外套的绝佳拍档。潮人们为我们演绎了四款半裙分别与四种外套的搭配，掌握好它们可以让你的美腿更撩人。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1z8vQXb0dXXXXXXXX.jpg\" /></p>\n<p>时尚解析：今夏最流行的亮色半裙可以轻易打破黑色西装外套的沉闷和保守，只需再搭配一件纯色吊带和优雅高跟鞋，瞬间点亮你的办公空间。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1waPRXgRaXXXXXXXX.jpg\" /></p>\n<p>时尚解析：黑白灰咖的半身裙与优雅的系带衬衫或印花衬衫组合，搭配上及踝短靴，时髦个性又不乏优雅风范的轻熟女就非你莫属。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16g6LXhNpXXXXXXXX.jpg\" /></p>\n<p>时尚解析：复古面料或波点半裙与针织衫可以形成绝妙组合，历史感与柔美气质碰撞，让你的女人味飙升，轻松搞定心仪的他。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16D2QXmFbXXXXXXXX.jpg\" /></p>\n<p>时尚解析：如果你更偏好街头感的装扮，那么就用轻薄的超短纱裙与军装夹克、机车夹克组合，软硬的碰撞个性又不过于中性，肯定提高回头率。</p>', NULL, 1, 0, 0, 1370091751, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (54, '好“色”女  染发热潮', ',29,', '好“色”女  染发热潮', '从卡梅隆&middot;迪亚兹(CameronDiaz)到贝嫂维多利亚&middot;贝克汉姆(VictoriaBeckham)，这些女星的发色总是变来变去，从金发染成黑发然后又染成大红色，让人惊讶于她们的百变风格，和勇于尝试的胆量，以至于早就忘记她们原来的发色了！发色一改变，整体造型也会随之不同。不用提，好莱坞首当最爱变发色的女星名单里绝对有凯蒂&middot;佩里(KatyPerry)和蕾哈娜', 'admin', '未知', '从卡梅隆&middot;迪亚兹(CameronDiaz)到贝嫂维多利亚&middot;贝克汉姆(VictoriaBeckham)，这些女星的发色总是变来变去，从金发染成黑发然后又染成大红色，让人惊讶于她们的百变风格，和勇于尝试的胆量，以至于早就忘记她们原来的发色了！发色一改变，整体造型也会随之不同。不用提，好莱坞首当最爱变发色的女星名单里绝对有凯蒂&middot;佩里(KatyPerry)和蕾哈娜', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1XvbQXcVeXXXXXXXX.jpg\" /></p>\n<p>从卡梅隆&middot;迪亚兹(Cameron Diaz)到贝嫂维多利亚&middot;贝克汉姆(Victoria Beckham)，这些女星的发色总是变来变去，从金发染成黑发然后又染成大红色，让人惊讶于她们的百变风格，和勇于尝试的胆量，以至于早就忘记她们原来的发色了！</p>\n<p>发色一改变，整体造型也会随之不同。不用提，好莱坞首当最爱变发色的女星名单里绝对有凯蒂&middot;佩里(Katy Perry)和蕾哈娜(Rihanna)，无论红的、蓝的、紫的、粉的，还有黑的全都难不倒她们。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nmHPXj4iXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 卡梅隆&middot;迪亚兹(Cameron Diaz)</p>\n<p>美国甜心的始祖卡梅隆&middot;迪亚兹(Cameron Diaz)在与Justin分手后，大胆的把她的招牌亚麻色头发染成全黑！还好她为情伤哀悼的时间不长，很快又染回招牌邻家女孩的美丽金发。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1s4YQXoFdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 卡梅隆&middot;迪亚兹(Cameron Diaz)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1rKLQXjxfXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 维多利亚&middot;贝克汉姆(Victoria Beckham)</p>\n<p>高贵辣妹维多利亚&middot;贝克汉姆(Victoria Beckham)过去从英国搬到洛杉矶的时候，曾经把头发染成金黄色，才过了没多久，她又想念起原本的黑发了，而如今却又留起了女人味十足的栗色长卷发。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1N12PXhdoXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 维多利亚&middot;贝克汉姆(Victoria Beckham)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1cjbPXjtkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 维多利亚&middot;贝克汉姆(Victoria Beckham)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ODPOXgXqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 蕾哈娜(Rihanna)</p>\n<p>她大胆的作风简直就和她的专辑一样无人不知！蕾哈娜(Rihanna)在之前突然改变发型，不仅挑染还剪了超短的飞机头。而后她又把头发染成大红色，还烫了卷发。不过海报网编编还是喜欢她的黑发朋克造型，谁知道几个月之后她又会变成哪种发型？！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GFTLXjFpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 蕾哈娜(Rihanna)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1m.zPXndhXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 蕾哈娜(Rihanna)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pyDQXdxaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 蕾哈娜(Rihanna)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1b2PPXhtmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯蒂&middot;佩里(Katy Perry)</p>\n<p>就如同她朗朗上口的可爱音乐，凯蒂&middot;佩里(Katy Perry)也以她超夸张的造型闻名，她的发色更总是让人印象深刻，无论红、蓝、粉、紫、黑，甚至挑染，凯蒂&middot;佩里(Katy Perry)都非常勇于尝试！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1iJrRXdVaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯蒂&middot;佩里(Katy Perry)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RSjPXdtjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯蒂&middot;佩里(Katy Perry)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wxzPXbVlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 布莱克&middot;莱弗利(Blake Lively)</p>\n<p>在扮演金发富家女Serena van der Woodsen好几年之后，时尚女星布莱克&middot;莱弗利(Blake Lively)为了电影《Hick》的拍摄，将头发染成了温暖的草莓金，但在电影杀青后她又马上变回性感金发女郎。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T15VYQXk4hXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 布莱克&middot;莱弗利(Blake Lively)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1w.DPXbJjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 查理兹&middot;塞隆(Charlize Theron)</p>\n<p>众所周知查理兹&middot;塞隆(Charlize Theron) 是个超敬业的女演员，总是愿意配合角色而改变自己的样貌，她曾为许多场合而将金发染成深色，但最后总是会再变回她的迷人闪亮金发！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1n4rPXfXkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 查理兹&middot;塞隆(Charlize Theron)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GHnRXdVaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 克莉丝朵&middot;雷恩(Crystal Renn)</p>\n<p>当看到总是一头黑发的大Size模特儿克莉丝朵&middot;雷恩(Crystal Renn)，以一头白金色的头发亮相，还瘦了一大圈的时候，整个时尚圈都吓了一大跳！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1IYnRXe0aXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 克莉丝朵&middot;雷恩(Crystal Renn)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_jbQXjpcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 艾玛&middot;斯通(Emma Stone)</p>\n<p>艾玛&middot;斯通(Emma Stone)绝对是金发变红发的资深老手！这位原本发色是亚麻色的女星，首次在儿童选择奖亮相时染了金发，她最近一次拥抱自己自然发色，是在2010年拍摄《The Amazing Spiderman》的时候。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kjjPXdVlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 艾玛&middot;斯通(Emma Stone)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1h5zQXbVdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 艾玛&middot;斯通(Emma Stone)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YVrRXd4bXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 林赛&middot;罗韩(Lindsay Lohan)</p>\n<p>林赛&middot;罗韩(Lindsay Lohan) 大概是最声名狼藉的红发妞了，她大部份的时候都维持着她的自然发色，但在2010年春天的时候，突然把头发染得漆黑！又在三个月后把它漂白成超不自然的金色——正好赶上迎接她的缓刑判决！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1p_DPXX4hXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 林赛&middot;罗韩(Lindsay Lohan)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_Z6RXkXaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 林赛&middot;罗韩(Lindsay Lohan)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1XOzPXoNlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 克里斯蒂娜&middot;阿奎莱拉(Christina Aguilera)</p>\n<p>为了摆脱迪士尼为她塑造的形象，瓶中精灵克里斯蒂娜&middot;阿奎莱拉(Christina Aguilera)改变过许多次造型，其中也包括可怕的黑发和过量的曝晒机所造成的中东人造型，还好她终于找到最适合自己的样子——白金色长发。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1VivPXiVlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 克里斯蒂娜&middot;阿奎莱拉(Christina Aguilera)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1jErOXjdoXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯瑟琳&middot;海格尔(Katherine Heigl)</p>\n<p>无预警的染成黑发之后，凯瑟琳&middot;海格尔(Katherine Heigl) 也经历了好几种不同的棕发造型，最后才又回到她的自然发色。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PmPPXk8jXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯瑟琳&middot;海格尔(Katherine Heigl)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EzrQXjVdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 凯瑟琳&middot;海格尔(Katherine Heigl)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Pn2QXltbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 金&middot;卡戴珊(Kim Kardashian)</p>\n<p>电视影集明星金&middot;卡戴珊(Kim Kardashian)把原本乌黑亮丽的秀发挑染上棕色的时候，着实吓了大家一跳！好在她及时发现这颜色不对，赶紧染回原本的黑色。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pk2QXkFbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 金&middot;卡戴珊(Kim Kardashian)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1S8zQXn0cXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 金&middot;卡戴珊(Kim Kardashian)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mKnNXl4mXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 斯嘉丽&middot;约翰逊(Scarlett Johansson)</p>\n<p>虽然平常是金棕色头发，但这位女演员证明了她可以毫不费力的不断改变发色，她曾把头发染成深棕色，再加上一点红色挑染，不过今年她又变回原本的蜜糖色了。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1m9jLXcVpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 斯嘉丽&middot;约翰逊(Scarlett Johansson)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16srRXdNaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 斯嘉丽&middot;约翰逊(Scarlett Johansson)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1VmrQXi4cXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 布兰特妮&middot;斯诺(Brittany Snow)</p>\n<p>这位金发的美国演员已经长大了，她似乎想用把头发染得火红来证明这点。虽然她在之前曾将头发染成深棕色，但红色更让人感受到她的火热性感。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1WSPPXmpiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 布兰特妮&middot;斯诺(Brittany Snow)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dqYRXkVaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 阿什莉&middot;辛普森(Ashlee Simpson)</p>\n<p>从亮栗色到深棕色再到蓝黑色，这位歌手对激烈的发色改变绝对不陌生！在染了像阿达家族妈妈的黑发之后几个月，她又以浅棕色的利落短发造型亮相，真的超百变！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1DqLMXeBnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 阿什莉&middot;辛普森(Ashlee Simpson)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1y4_QXohdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 阿什莉&middot;辛普森(Ashlee Simpson)</p>', NULL, 1, 0, 0, 1370091752, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (55, '印花秋冬潮流Look看过来', ',29,', '印花秋冬潮流Look看过来', '由“老戏骨”梅丽尔&middot;斯特里普(MerylStreep)主演的电影《铁娘子》(TheIronLady)充分展现出撒切尔夫人外柔内刚的优雅、强势大女人风范，而这部在2012年上映的新片，与2012秋冬的T台趋势不谋而合，一个个简洁利落，又充满女性美感的秀场上的麻豆Look，充分将本季“强势女权”风格发扬光大！而最能体现出兼具优雅的强势女性范儿的，当属印花西服套装！在2012秋冬秀场上，普', 'admin', '未知', '由“老戏骨”梅丽尔&middot;斯特里普(MerylStreep)主演的电影《铁娘子》(TheIronLady)充分展现出撒切尔夫人外柔内刚的优雅、强势大女人风范，而这部在2012年上映的新片，与2012秋冬的T台趋势不谋而合，一个个简洁利落，又充满女性美感的秀场上的麻豆Look，充分将本季“强势女权”风格发扬光大！而最能体现出兼具优雅的强势女性范儿的，当属印花西服套装！在2012秋冬秀场上，普', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1bDTPXmRfXXXXXXXX.jpg\" /></p>\n<p>由“老戏骨”梅丽尔&middot;斯特里普(Meryl Streep) 主演的电影《铁娘子》(The Iron Lady) 充分展现出撒切尔夫人外柔内刚的优雅、强势大女人风范，而这部在2012年上映的新片，与2012秋冬的T台趋势不谋而合，一个个简洁利落，又充满女性美感的秀场上的麻豆Look，充分将本季“强势女权”风格发扬光大！</p>\n<p>而最能体现出兼具优雅的强势女性范儿的，当属印花西服套装！在2012秋冬秀场上，普拉达(Prada)、缪缪(Miu Miu) 成为了这场“女权风潮”的先锋倡导者，男性化的帅气剪裁，融合了万花筒般的印花的绚丽风格，利落不乏趣味，给秋冬的沉闷注入一丝活力针剂！另外詹巴迪斯塔&middot;瓦利 (Giambattista Valli)、路易&middot;威登LV (Louis Vuitton)、爱马仕(Hermes) 的印花套装层次质感丰富，不拘泥于单一的形式，碰撞出的艺术感“火花”令人应接不暇......</p>\n<p>你也想尝试刚柔并济的“Iron Lady”Look吗？随海报编编一起从秀场当中寻找灵感吧！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1DwrQXoVdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 缪缪 (Miu Miu) 2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1qd_LXlBoXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 海尔姆特&middot;朗 (Helmut Lang)2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EhDQXbRdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Schumacher 2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1a_2QXitaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 玛尼(Marni) 2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EknQXeBaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 普拉达 (Prada)2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1hxTQXhtcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 詹巴迪斯塔&middot;瓦利 (Giambattista Valli)2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1fxTLXb0pXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 爱马仕 (Hermes)2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1M4YPXdllXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Aquilano. Rimondi2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1eEnQXoxaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 路易&middot;威登LV (Louis Vuitton)2012秋冬秀场</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1g5zQXcxdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 米索尼(Missoni)2012秋冬秀场</p>', NULL, 1, 0, 0, 1370091773, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (56, '比大片真实！秀场示范装', ',29,', '比大片真实！秀场示范装', '说秀场外街拍好看，不仅仅因为场外嘉宾的出色搭配，而是那些华丽的配饰和你想不到的点睛细节，让人不得不感慨：确实不一样！T台上华美得你不敢尝试的服装、杂志上热推的超大size珠宝，以及看似普通的可爱手机套、小配饰，就这样被时尚达人们混搭在一起，穿上街头。在街拍摄影师的镜头下，这些时尚编辑、模特、博主们似乎比明星更闪耀...2013春夏米兰时装周街拍马上奉上，enjoyit！时尚网站ModaOperan', 'admin', '未知', '说秀场外街拍好看，不仅仅因为场外嘉宾的出色搭配，而是那些华丽的配饰和你想不到的点睛细节，让人不得不感慨：确实不一样！T台上华美得你不敢尝试的服装、杂志上热推的超大size珠宝，以及看似普通的可爱手机套、小配饰，就这样被时尚达人们混搭在一起，穿上街头。在街拍摄影师的镜头下，这些时尚编辑、模特、博主们似乎比明星更闪耀...2013春夏米兰时装周街拍马上奉上，enjoyit！时尚网站ModaOperan', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1tZbQXj4dXXXXXXXX.jpg\" /></p>\n<p>说秀场外街拍好看，不仅仅因为场外嘉宾的出色搭配，而是那些华丽的配饰和你想不到的点睛细节，让人不得不感慨：确实不一样！</p>\n<p>T台上华美得你不敢尝试的服装、杂志上热推的超大size珠宝，以及看似普通的可爱手机套、小配饰，就这样被时尚达人们混搭在一起，穿上街头。在街拍摄影师的镜头下，这些时尚编辑、模特、博主们似乎比明星更闪耀...2013春夏米兰时装周街拍马上奉上，enjoy it！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xQbQXmlaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 时尚网站Moda Operandi艺术总监泰勒&middot;托马西 (Taylor Tomasi)</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YerQXnFcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 香港连卡佛女装部买手TiffanyHsu</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\">&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1eATPXXtiXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1f52PXbdjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">2013春夏米兰时装周秀场外街拍 </p>\n<p class=\"pictext\" align=\"center\">&nbsp;</p>', NULL, 1, 0, 0, 1370091774, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (57, '配饰、发型个性街拍集锦', ',29,', '配饰、发型个性街拍集锦', '最近原宿街头的“重口味”混搭越来越少，小清新&简约复古风格“后来居上”成为主调。不再“强攻”鲜亮色彩搭配的日系潮人，开始“转攻”暗色调的“基本款”搭配，而花样繁杂的配饰，则成为了他们“宣扬”个性的卖点。尤其在鞋履的选择上，从复古感的松糕鞋，到木雕花底的高跟鞋，都凸显了原宿潮人“非同一般”的“审美情趣”。现在就赶快跟着海报编编一块，来看看第155期的日本街拍之古着聚集地原宿篇吧！日本街拍之古着聚集地', 'admin', '未知', '最近原宿街头的“重口味”混搭越来越少，小清新&简约复古风格“后来居上”成为主调。不再“强攻”鲜亮色彩搭配的日系潮人，开始“转攻”暗色调的“基本款”搭配，而花样繁杂的配饰，则成为了他们“宣扬”个性的卖点。尤其在鞋履的选择上，从复古感的松糕鞋，到木雕花底的高跟鞋，都凸显了原宿潮人“非同一般”的“审美情趣”。现在就赶快跟着海报编编一块，来看看第155期的日本街拍之古着聚集地原宿篇吧！日本街拍之古着聚集地', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Nf6QXgdbXXXXXXXX.jpg\" /></p>\n<p>最近原宿街头的“重口味”混搭越来越少，小清新&amp;简约复古风格“后来居上”成为主调。不再“强攻”鲜亮色彩搭配的日系潮人，开始“转攻”暗色调的“基本款”搭配，而花样繁杂的配饰，则成为了他们“宣扬”个性的卖点。尤其在鞋履的选择上，从复古感的松糕鞋，到木雕花底的高跟鞋，都凸显了原宿潮人“非同一般”的“审美情趣”。现在就赶快跟着海报编编一块，来看看第155期的日本街拍之古着聚集地原宿篇吧！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xhbKXk4rXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.nfPXcNhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1h__OXnNoXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1h8jQXjtaXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T13p2PXcFnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T18zrPXbtjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1fyHQXdxbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Ez2QXXBaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1aM_KXdVsXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16uvQXkXbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1NqTJXoVpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ASnPXX0gXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1imvQXghXXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ouvQXeVcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_PLQXddaXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ZifQXhXaXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1jGHQXa8fXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1vnfPXodeXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1q8vQXd8aXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1aifPXXNjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ttvPXoplXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ZRjPXi8iXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10vrPXmRmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pvTQXaFcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ZmvQXg0aXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1q8zPXfNhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1d4TQXgFbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1WeLPXo4lXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xYLQXbpdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ccbQXm0dXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1cgrPXf4kXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pq2MXlRmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1TBbQXoJXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T14hLPXfBjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16xzQXhFbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1rM2PXk8kXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1fRzPXhXiXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1k0DPXmFjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kUYGXbtrXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1d86OXlhoXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1zg_PXnJiXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1J_bQXilXXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1o8_KXgFpXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Oc_PXdXkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nZ6PXfpjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dGfLXeJpXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RLfQXjdbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1gv2PXdFkXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ct6PXaVmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1eOjQXm0aXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1MejQXhJbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1suTQXoJbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1zyHPXk8jXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T12zHQXmFXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_uTPXotlXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1AOHPXcXjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wJ6PXh4mXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1HpzQXaldXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1h4DQXhhbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1y4TPXeFhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1hHPQXbRfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T166HPXhXiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nCHPXdRgXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Fm_PXkXhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ZFzQXgVdXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RWfPXm0nXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T12_HPXmxfXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1o7jHXeVtXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1BZbLXihnXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10InPXhFmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1y9bGXkhqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nWTQXhxfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1K5LPXkpkXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GA6KXhBrXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ycfPXm0kXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1liLQXdxbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dlfHXnxpXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1l._KXiRqXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T14krPXlpiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pjnQXbxbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1DK6PXbBiXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1WX6OXexrXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T15hnHXflrXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1y52PXXNjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wJvHXaXsXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1NbzPXhXlXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1SIrLXfhqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1lnPQXfXXXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kK_PXmtlXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Jf2PXhllXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YJ_QXfddXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T12irPXi8jXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1VDvPXXhhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T17kYQXnBXXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ikfPXedeXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nvPPXolkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 日本街拍之古着聚集地原宿篇</p>', NULL, 1, 0, 0, 1370091774, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (58, '美国天然护肤品牌Astara登陆中国', ',29,', '美国天然护肤品牌Astara登陆中国', '爱诗黛菈由超模SunnyGriffin女士于1997年创办。Sunny曾是美国最著名的美容瘦身顾问和世界上出场费最高的模特之一。爱诗黛菈的产品不含刺激性的化学成分、人工染色剂、防腐剂、合成香料和化学防晒剂，对皮肤刺激性极小。爱诗黛菈保证肌肤及人体长期的安全健康，绝无引发癌症和各种皮肤疾病的危险，也不使用肌肤难以代谢的化学合成物质，增加皮肤的代谢负担。爱诗黛菈旗下没有一款植物精华会加温到40.5℃以', 'admin', '未知', '爱诗黛菈由超模SunnyGriffin女士于1997年创办。Sunny曾是美国最著名的美容瘦身顾问和世界上出场费最高的模特之一。爱诗黛菈的产品不含刺激性的化学成分、人工染色剂、防腐剂、合成香料和化学防晒剂，对皮肤刺激性极小。爱诗黛菈保证肌肤及人体长期的安全健康，绝无引发癌症和各种皮肤疾病的危险，也不使用肌肤难以代谢的化学合成物质，增加皮肤的代谢负担。爱诗黛菈旗下没有一款植物精华会加温到40.5℃以', '<p>爱诗黛菈由超模Sunny Griffin女士于1997年创办。Sunny曾是美国最著名的美容瘦身顾问和世界上出场费最高的模特之一。爱诗黛菈的产品不含刺激性的化学成分、人工染色剂、防腐剂、合成香料和化学防晒剂，对皮肤刺激性极小。爱诗黛菈保证肌肤及人体长期的安全健康，绝无引发癌症和各种皮肤疾病的危险，也不使用肌肤难以代谢的化学合成物质，增加皮肤的代谢负担。</p>\n<p style=\"text-align: center;\"><img style=\"width: 500.0px;float: none;margin: 0.0px;\" src=\"http://img02.taobaocdn.com/tps/i2/T1zbjQXldcXXb1upjX.jpg\" /></p>\n<p>爱诗黛菈旗下没有一款植物精华会加温到40.5℃以上，这样做的目的是为了防止该成份的酶和抗氧化作用被打折扣从而不能百分百地发挥其应有的功效。所以无论从环保还是节约资源角度来说，爱诗黛菈都身先士卒。公司在生产时不涉及残害动物，不使用动物类副产品，并采用可回收包装。我们所有的产品说明及包装都采用水溶性环保油墨印刷，可被水溶解但不会污染水体，更不会长时间的影响生态环境，爱诗黛菈坚定支持环境保护事业。<br />爱诗黛菈Astara护肤四步曲：清洁、修复、补充、再生！</p>\n<p>2005年有机Spa杂志采访Sunny, 并授予爱诗黛菈 “美颜食物”（”face food”）的称号。2008年芝加哥健康和健身杂志发表了一篇长达2页介绍爱诗黛菈的文章，标题为：“自然但令人惊艳。” 2009年：Lucky杂志把净颜面膜称为“我们的最爱”。</p>\n<p style=\"text-align: center;\"><img style=\"float: none;margin: 0.0px;\" src=\"http://img01.taobaocdn.com/tps/i1/T1yQYPXn4hXXb1upjX.jpg\" /></p>\n<p>爱诗黛菈也深受美国好莱坞明星和各界时尚名流的青睐。朱莉亚罗伯茨在怀孕及生产后不想使用含任何化学添加的护肤品，于是选择了爱诗黛菈凝颜倍护精华霜并一直使用至今。丽芙泰勒在接受InStyle杂志采访时说她疯狂的爱上了爱诗黛菈精致面膜。休杰克曼在百老汇演出的时候人物杂志曾写道：“他正在跟爱诗黛菈水润面膜亲密接触。” 丹尼尔克雷格参加Telluride电影节的时候带了一整套的爱诗黛菈产品送给主持人。美国前总统克林顿的女儿2011年结婚前一天在Haven Spa做了全套的新娘Spa疗程，并给她所有的伴娘们分发了爱诗黛菈美丽新娘套装。</p>\n<p>2012年10月，爱诗黛菈品牌全线进军中国市场，提供全系列天然植物护肤品，同时也为中国女性带来高端的天然植物护肤体验，让中国女性恒久美丽、自信的享受生活。相信爱诗黛菈天然、高效、安全的护肤理念将为中国女性带来独一无二、高品质的美的享受。<br />爱诗黛菈明星产品推介：</p>\n<p style=\"text-align: center;\"><span>&nbsp;</span><img style=\"height: 515.0px;width: 500.0px;float: none;margin: 0.0px;\" src=\"http://img02.taobaocdn.com/tps/i2/T1YkYUXlJaXXaCwpjX.png\" /><span>&nbsp;</span></p>\n<p>产品名称：爱诗黛菈凝颜倍护精华霜</p>\n<p>英文名称：Astara Activated Antioxidant Infusion</p>\n<p>参考价格：￥1330.00</p>\n<p>产品规格：59.1ml</p>\n<p>产品功效：抗氧化、营养和均衡肌肤</p>\n<p style=\"text-align: center;\"><span>&nbsp;</span><img style=\"float: none;margin: 0.0px;\" src=\"http://img01.taobaocdn.com/tps/i1/T1OA_QXiNaXXaCwpjX.png\" /><span>&nbsp;</span></p>\n<p>产品名称：爱诗黛菈精致面膜（蓝色火焰）</p>\n<p>英文名称：Astara Blue Flame Purification Mask</p>\n<p>参考价格：￥660.00</p>\n<p>产品规格：59.1ml</p>\n<p>产品功效：祛痘控油，抗菌抗炎</p>', NULL, 1, 0, 0, 1370091774, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (59, '对抗冷空气 牛仔装最受用', ',29,', '对抗冷空气 牛仔装最受用', '蓝色经典一款蓝色经典的牛仔外套不仅能在造型上加分修身腰部曲线，更能与长款T恤及连衣裙等多款衣服搭配，精致的肩章和口袋设计非常实用，红与黄的撞色拼接让这件牛仔衫显得更加的潮拿破仑军装风通勤女外套双排装饰纽扣长袖水洗牛仔衣衬衫，款式非常有型，裁剪得体，上身帅气精神。很华丽的拿破仑军装风，很有点制服控的感觉。石磨水洗工艺经典的牛仔衣版型，自然斑驳的石磨水洗工艺营造立体富有变化的视觉感，做旧的深蓝色泽带来', 'admin', '未知', '蓝色经典一款蓝色经典的牛仔外套不仅能在造型上加分修身腰部曲线，更能与长款T恤及连衣裙等多款衣服搭配，精致的肩章和口袋设计非常实用，红与黄的撞色拼接让这件牛仔衫显得更加的潮拿破仑军装风通勤女外套双排装饰纽扣长袖水洗牛仔衣衬衫，款式非常有型，裁剪得体，上身帅气精神。很华丽的拿破仑军装风，很有点制服控的感觉。石磨水洗工艺经典的牛仔衣版型，自然斑驳的石磨水洗工艺营造立体富有变化的视觉感，做旧的深蓝色泽带来', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.4vPXn8kXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 蓝色经典</p>\n<p>一款蓝色经典的牛仔外套不仅能在造型上加分修身腰部曲线，更能与长款T恤及连衣裙等多款衣服搭配，精致的肩章和口袋设计非常实用，红与黄的撞色拼接让这件牛仔衫显得更加的潮</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1d6_NXXXpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 拿破仑军装风</p>\n<p>通勤女外套双排装饰纽扣长袖水洗牛仔衣衬衫，款式非常有型，裁剪得体，上身帅气精神。很华丽的拿破仑军装风，很有点制服控的感觉。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1qqTQXapdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 石磨水洗工艺</p>\n<p>经典的牛仔衣版型，自然斑驳的石磨水洗工艺营造立体富有变化的视觉感，做旧的深蓝色泽带来狂野的街头气息，经典的款式透露随性的西部风情与高街风范。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EXfPXctmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 背后字母机车修身</p>\n<p>背后字母机车修身牛仔外套！很帅气百搭的时尚单品，在中性装扮中加入些许甜美元素，增添可爱女人味的同时又不失帅气嬉皮感。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Z6TQXbBaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 修身长袖</p>\n<p>修身长袖牛仔小外套，四扣圆领的设计，时尚百搭款，内搭一条黑白条纹的包臀裙，凸显身材让你爱不释手。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mtbQXh0dXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 短款薄型中袖</p>\n<p>很特别的一款短款薄型中袖牛仔衣，领口一直延续到下摆的工艺边与袖口相呼应，很显精致感，又有些许的民族服饰的感觉，圆领的设计使整件YY看上去少了帅气感，更多了些甜美与可爱感。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Mp2LXnlgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 做旧效果</p>\n<p>很经典的一款牛仔外套，牛仔衣一直是人们所喜爱的，复古做旧的效果，最特别是古银色的扣子，增加了不少亮点哦！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1raPPXnlmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 立领+翻领款</p>\n<p>立领+翻领款，折一大层袖子可做七分袖，简约而大气的裁剪穿上后时髦而复古，简单而中性的款式搭配牛仔短裤或者紧身裤都很潮，一条碎花裙裙也能俏皮美好起来。</p>', NULL, 1, 0, 0, 1370091775, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (60, '度假香水推荐', ',29,', '度假香水推荐', '马上就要迎来十一假期了，你是不是早已有了旅行计划？想要一扫旅途的疲劳，为旅行的心情添彩，海报网编编建议随身携带一瓶心爱的香水。香水的存在一定勾起你记忆中的美妙光景，引领你去到从未抵达的幻影梦境，它或是森林中的娇艳花朵，或是岛屿上的甘甜果实，或是耳畔悠扬的钻石声响，让你的十一假期充满惊喜！接下来编编就为还没有想好带什么香水的你给出最完美的建议，一起来看看吧！迪奥(Dior)紫恋魅惑淡香水参考价格：R', 'admin', '未知', '马上就要迎来十一假期了，你是不是早已有了旅行计划？想要一扫旅途的疲劳，为旅行的心情添彩，海报网编编建议随身携带一瓶心爱的香水。香水的存在一定勾起你记忆中的美妙光景，引领你去到从未抵达的幻影梦境，它或是森林中的娇艳花朵，或是岛屿上的甘甜果实，或是耳畔悠扬的钻石声响，让你的十一假期充满惊喜！接下来编编就为还没有想好带什么香水的你给出最完美的建议，一起来看看吧！迪奥(Dior)紫恋魅惑淡香水参考价格：R', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Au2IXglqXXXXXXXX.jpg\" /></p>\n<p>马上就要迎来十一假期了，你是不是早已有了旅行计划？想要一扫旅途的疲劳，为旅行的心情添彩，海报网编编建议随身携带一瓶心爱的香水。香水的存在一定勾起你记忆中的美妙光景，引领你去到从未抵达的幻影梦境，它或是森林中的娇艳花朵，或是岛屿上的甘甜果实，或是耳畔悠扬的钻石声响，让你的十一假期充满惊喜！接下来编编就为还没有想好带什么香水的你给出最完美的建议，一起来看看吧！</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1r4vQXkFaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 迪奥 (Dior) 紫恋魅惑淡香水</p>\n<p>参考价格：RMB780/50ml</p>\n<p>曼妙花语</p>\n<p>玲珑娇嫩的花瓣，如同女性细腻柔软的肌肤。高贵与魅惑的灵感之源，盛放原初的诱惑与无邪的纯真。</p>\n<p>玫瑰</p>\n<p>羽状复叶互生，4-8月绽放。</p>\n<p>香气馥郁，象征美丽与纯洁的爱情。</p>\n<p>玫瑰＋麝香＝优雅性感</p>\n<p>恍如幻境的玫瑰园只为天生性感的美人而绽放。纯玫瑰精油大胆而热烈，带着扑面而来的性感，从前调一路绵延至中调，细腻精致，散发出清新优雅的感性情愫，最后在白麝香与雪松的拥抱下愈趋隽永悠长。</p>\n<p>玫瑰＋牡丹＝高贵果敢</p>\n<p>不论是甘美多汁的苹果梨香还是色彩缤纷的金橘果香，甚至是高贵奢华的牡丹花香，都不及保加利亚玫瑰的变幻多端，那隐约飘渺的辛香，诠释出了女性的性感，同时又充满优雅精致的格调和正面能量的自信。</p>\n<p>玫瑰＋紫檀＝温柔平和</p>\n<p>玫瑰是对美德的加冕，对和平的歌颂，对爱的礼赞。纯净澄澈的玫瑰在小苍兰与玉兰的幽谧香调中缓缓绽放。安静的紫檀木为玫瑰注入宁静的力量，坦率的广藿香照亮了玫瑰强烈的感性气息，如天堂的歌咏一般，温柔而强大。</p>\n<p>玫瑰＋胡椒＝狂野燃情</p>\n<p>午夜的玫瑰，犹如狂热的爱情，时而浓烈如酒，时而温润如玉。覆盆子与蓝莓一同激发出玫瑰的甜腻如霜，牡丹映衬出玫瑰的优雅静谧，粉红胡椒点燃了玫瑰的激情与魅惑，而雪松与香草将这澎湃与热烈化作恒久深邃的温热气息。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mCTQXc8aXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 纪梵希(Givenchy) 花之语香水</p>\n<p>参考价格：RMB610/50ml</p>\n<p>茉莉</p>\n<p>顶生聚伞花序，6-10月开放。</p>\n<p>味极芳香，忠贞与尊贵的象征。</p>\n<p>茉莉＋佛手柑＝梦幻脱俗</p>\n<p>高贵的橙花与清新的野莓、佛手柑带来深入内心的净化力量，让茉莉的馨香如水墨画般渲染开来，由浓转淡却久久不散，最后在雪松与龙涎香的呵护下，留下如天鹅绒般柔软的眷恋之香，芬芳馥郁。</p>\n<p>茉莉＋水仙＝迷醉魅惑</p>\n<p>迷醉魅惑的睡眠茉莉宛若美人的第二层肌肤，清新自然地传递出恣意的性感姿态。芬芳在黑莓、水仙与液体巧克力的簇拥下升华得浓烈而热情，又在香子兰与广藿香的萦绕下释放出摄人心魄的魅惑。</p>\n<p>茉莉＋绿茶＝纯粹之力</p>\n<p>雪白的花瓣包裹着净澈的内心，娇小脆弱却充满敢爱敢恨的纯粹之力，指引你追寻自己的梦想。前调的黑加仑与柑橘带来振奋的能量，让茉莉别具一格的香调传递得更明朗，配合尾调的绿茶与麝香，将香气保持得愈加悠长。</p>\n<p>茉莉＋橙花＝一往情深</p>\n<p>迪奥 (Dior) 先生普罗旺斯乡村居所花园中芳香馥郁的茉莉花成就了Miss Dior系列的芳香传奇。在澄净的血橙与橙花的指引下，茉莉的热情显得愈加明艳动人，随后在玫瑰与依兰的花语交响中，转呈为含蓄悠扬的西普香调。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wuDPXXJmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 梵克雅宝(Van Cleef &amp;Arpels) 唯一之约香水</p>\n<p>参考价格：RMB750/60ml</p>\n<p>奢宠之饰</p>\n<p>耀目的光芒，细腻的触感。</p>\n<p>流光溢彩令举手投足更摄人心魄。</p>\n<p>钻石耳环=闪耀温润</p>\n<p>珠宝与香水都是女性最完美的饰物，梵克雅宝 (Van Cleef &amp;Arpels) 便以这份微妙的关联为灵感，以钻石耳环为原型设计出了这款充满传奇色彩的香水，将两大饰物合二为一。柔媚的木质花香调闪亮而温润，令人联想起初次拥有一款珠宝的珍贵记忆。</p>\n<p>印花丝巾=绚丽芬芳</p>\n<p>经典的古驰 (Gucci) 印花印刻在献给摩洛哥王妃格蕾斯&middot;凯莉的丝巾上，汇聚37种色彩，花朵的绚丽让人陶醉于自然的美好。Flora香水受此图案启发，将花朵与果木结合，演绎一脉相承的芬芳记忆与意大利时尚的魅惑过往。</p>\n<p>高跟鞋=高贵性感</p>\n<p>作为周仰杰 (Jimmy Choo) 最负盛名的款式，蛇纹高跟鞋成为了高贵性感的象征。而周仰杰 (Jimmy Choo) 也以此为灵感，配以珠光宝气的威尼斯Murano玻璃打造了首款淡香水。迷人的异域花香调让人想起那些镶嵌着珠宝走过无数红地毯的高跟鞋。</p>\n<p>风衣=温暖奢华</p>\n<p>皇室御用的博柏利 (Burberry)</p>\n<p>风衣面料，铸就了这款香水的灵感之源。清新的苦艾酒、温暖的檀香以及感性的琥珀香演绎出深邃的木质香调，带来风衣般的温暖呵护。经典的格纹图案演绎出历久弥新的经典之作，带来贵族般的奢华荣宠。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kUzPXahdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Acqua di Parma蓝色地中海香水</p>\n<p>参考价格：RMB760/75ml</p>\n<p>缤纷果趣</p>\n<p>鲜艳跳跃的色泽，丰沛多汁的果实。</p>\n<p>酸甜口感与明艳色彩相遇，激发出无限灵感。</p>\n<p>香柠檬=振奋悠远</p>\n<p>卡拉布里亚是艺术、自然与文化的交融之地，更是全世界最棒的香柠檬产地。来自这个岛屿的柠檬酸甜浓郁，向世人传递出这片海域的独特气息。振奋清新的果香随着红姜和雪松木的气息成为香味核心，将思绪带去古老而惬意的夏日岛屿。</p>\n<p>苹果=清新甘甜</p>\n<p>苹果的甘甜芬芳在一片宁静平和中弥漫，清脆的声响如同双脚的律动一般，注入俏皮桀骜之感，混合着绿草与湿土的气息，霎时间西洋梨、丁香、玉兰花的香氛随之喷薄而出，如飞逝的时光</p>\n<p>柠檬=慵懒随性</p>\n<p>柠檬皮的清新带你远离尘嚣，感受阳光的亲切抚摸。在这第一缕清香扑面而来之时，棕榈叶的加入平添了辛辣风味，呼应着沐浴在阳光下的百合与依兰花瓣，静谧地释放出圆润柔和的异域水果香调，绽放夏日独有的懒散与随性。</p>\n<p>红莓=馥郁明亮</p>\n<p>高贵罕见的红珊瑚宝石瓶身内装满了浓郁多汁的水果香调。在浸润了红莓的甜蜜与扶桑花的明亮后，佛手柑与枸杞谱写出晴朗精致的果香调，最后在睡莲的安抚下，展现出无可比拟的高贵馥郁。</p>', NULL, 1, 0, 0, 1370091775, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (61, '2013伦敦时装周之美包篇', ',29,', '2013伦敦时装周之美包篇', '2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？2013春夏伦敦时装周秀场外街拍之美包201', 'admin', '未知', '2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？2013春夏伦敦时装周秀场外街拍之美包201', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1aYHPXgFmXXXXXXXX.jpg\" /></p>\n<p>2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。</p>\n<p>当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T13PPQXi8aXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1bPLOXdloXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 2013春夏伦敦时装周秀场外街拍之美包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.rDHXf0rXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1hF6KXoFsXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 2013春夏伦敦时装周秀场外街拍之美包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xFzQXmdfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T13YTQXf8eXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 2013春夏伦敦时装周秀场外街拍之美包</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1hfTQXbRcXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1m.bPXoleXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 2013春夏伦敦时装周秀场外街拍之美包</p>', NULL, 1, 1, 0, 1370091775, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (62, '时尚必备30件秋冬单品', ',29,', '时尚必备30件秋冬单品', '秋冬新季来临。如何让你独特又时髦？如何购买任何时髦的搭配都离不开新潮又经典的时尚单品。一件亮闪闪的亮片连衣裙，一条华丽丽的亮钻大项链，一副先锋又时髦的大边框眼镜，都能给你带来瞬间的变化。设计师在细节处的调整可以让整体有所差异，新的一季30件单品重塑你的时尚衣橱。Erdem暗色系——黑暗的冬季即将到来，夏季的明亮花朵也会在冬季黯然，Erdem本季设计像是将AlexanderMcQueen与Valen', 'admin', '未知', '秋冬新季来临。如何让你独特又时髦？如何购买任何时髦的搭配都离不开新潮又经典的时尚单品。一件亮闪闪的亮片连衣裙，一条华丽丽的亮钻大项链，一副先锋又时髦的大边框眼镜，都能给你带来瞬间的变化。设计师在细节处的调整可以让整体有所差异，新的一季30件单品重塑你的时尚衣橱。Erdem暗色系——黑暗的冬季即将到来，夏季的明亮花朵也会在冬季黯然，Erdem本季设计像是将AlexanderMcQueen与Valen', '<p>秋冬新季来临。如何让你独特又时髦？如何购买任何时髦的搭配都离不开新潮又经典的时尚单品。一件亮闪闪的亮片连衣裙，一条华丽丽的亮钻大项链，一副先锋又时髦的大边框眼镜，都能给你带来瞬间的变化。设计师在细节处的调整可以让整体有所差异，新的一季30件单品重塑你的时尚衣橱。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T105fOXiRfXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Erdem</p>\n<p> 暗色系——黑暗的冬季即将到来，夏季的明亮花朵也会在冬季黯然，Erdem本季设计像是将Alexander McQueen与Valentino的灵感相结合。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1TrnOXepgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Stella McCartney</p>\n<p> 一条围巾——秋天到来，让你的头发保持完美造型，包裹在Stella McCartney时髦围巾也是一种风尚。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1MGPKXgtpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">topshop</p>\n<p> 镶褶边的袜子——超级可爱，光着脚穿着夏天凉鞋有些冷了，可以穿一双可爱的短袜，时尚感十足。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Tn2JXhFoXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">harrods ￡1,650</p>\n<p> 亮片——只要每每看到夜幕降临，你就知道是时候开始考虑投资一件派对礼服了，今季奢华金色亮片晚礼服会是一个不错的选择。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1c5fNXctnXXXXXXXX.jpg\" /></p>\n<p>farfetch ￡1439 皮革——2012-13秋冬黑色皮革回归，夏末应该购买一件机车夹克了。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GJfPXoNXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">LOUISE GRAY FOR TOPSHOP</p>\n<p> LOUISE GRAY FOR TOPSHOP——彩色亮片礼服，这些都是伟大的购买投资领先派对季节(真的并不遥远)。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1awjOXiNeXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Brence Aina ￡399</p>\n<p> FREDA—— 去年,举行的在线时装周的一部分获胜作品,我们邀请读者进入我们的设计礼服比赛。这是由Brence Aina获胜的设计，创造了本季伟大的购买渠道。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T12cYOXcReXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">mulberry ￡695</p>\n<p> MULBERRY——这是一个新的包袋季节，所以我们期待Bryn新的设计作品，作为我们的2012-13秋冬新品更新。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xhfOXbtdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">VICTORIA BECKHAM EYEWEAR</p>\n<p> 维多利亚&middot;贝克汉姆眼镜——她证明了自己和她的时尚品牌，现在维多利亚&middot;贝克汉姆是扩大她的时尚帝国推出一系列的框架眼镜。一个非常实用的投资方案。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10GHNXlppXXXXXXXX.jpg\" /></p>\n<p>Marc Jacobs 层次——它的最容易带来新的生机的方式，混合和匹配这些层。马克&middot;雅可布T台秀服，我们搜寻的风格线索，层次越多，效果越好。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1E3rNXg8mXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">harrods ￡210</p>\n<p> 花纹长裤——印染花色的裤子不是适合去任何地方,夏天它被收藏到衣柜的后面。秋冬季节，是时候拿出衣橱晒晒太阳了。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T18cbOXa4fXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">J W ANDERSON FOR TOPSHOP</p>\n<p> J W ANDERSON FOR TOPSHOP——我们急切地等待着到来的Topshop J W安德森系列的发布，9月的开始——完美的时间，当你需要注入一些衣橱新品。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PZ_JXjdrXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Jane Taylor ￡600</p>\n<p> 帽子——我们都爱上了马克&middot;雅可布秀场上魅力斯蒂芬&middot;琼斯的超大号的帽子。这里是如何在看Jane Taylor，不完全是超大号的帽子。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1HXHOXfphXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Marni ￡410</p>\n<p> 厚底鞋——我们第一次看见厚底鞋是在Christopher Kane 2012年春夏T台，这种趋势正在演变，本季Marni推出了一双红色天鹅绒厚底鞋。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16YPOXm4fXXXXXXXX.jpg\" /></p>\n<p>Dara Ettinger ￡83 珠宝——一个忠实的时尚箴言，首饰可以随时更换。这是真的,他们做到了。添加一个配件即可装饰到你的服装，Dara Ettinger拥有了一个全新的吸引力。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EL2NXiFnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">维多利亚的秘密</p>\n<p> 维多利亚的秘密——已经有一个专卖店在Westfield Stratford，很快就会在Bond Street拥有另一家专卖店:维多利亚的秘密。如果您还没有购买,但现在是时候熟悉我们的传奇标签了。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1so_KXaFqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">topshop ￡18.50</p>\n<p> 领子——项圈是一个伟大的设计，让一件简单的T恤看起来非常不同的方式。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1iF2OXexiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">安娜&middot;卡列尼娜风格发饰</p>\n<p> 安娜&middot;卡列尼娜风格——到9月份你会发现自己想要穿一切《安娜&middot;卡列尼娜》风格的服饰，相信我们。佩戴一个发饰是一个很简洁的方式来顺应这个趋势。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ru2PXmlXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">套头衫 ￡310</p>\n<p> 套头衫——谢谢Markus Lupfer，为新一季的套头衫设计亮片图案点缀，这意味着在派对季节里也可以这么穿着。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1HTPNXXliXXXXXXXX.jpg\" /></p>\n<p>Marc by Marc Jacobs, ￡60 配件包——配件包本身是根据硬件的形状大小产生的组合产品——携带完美的iPad配件包，如果不作为iPad的配件包使用，也可以发挥它的装饰功能。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.STOXdBbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Simone Rocha ￡735</p>\n<p> 西蒙&middot;罗卡-西蒙&middot;罗卡在本季伦敦时装周首次展出，她是一位非常值得期待的设计师。现在就比别人领先一步投资她设计。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1QQrOXmXcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Rachel Zoe ￡315</p>\n<p> 靴子——靴子总是一个时尚的转折点——把你正式从一个季节带到另一个季节。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1gi_OXntdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">长筒袜 ￡8</p>\n<p> 长筒袜——当天气热的时候我们穿厚裤袜，当天气冷的时候我们穿打底裤，其实它们是一样的东西。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1TVLPXdBcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">McQ Alexander McQueen ￡130,</p>\n<p> 哥特-添加一点哥特风单品到你的衣橱。别担心,你不需要全力以赴，正如这件T恤，你只需要选择一些简单而又讲究微妙的单品。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1SBLNXeXiXXXXXXXX.jpg\" /></p>\n<p>设计师 Zoe Jordan 建议——你不妨问问你的朋友寻求建议，特别是时尚的朋友。“一个清爽的白衬衫!一个永恒的设计,看起来总是清爽时髦。“时装设计师Zoe Jordan建议如何在这个季节更新你的衣柜。</p>\n<p>&nbsp;</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T12Y_OXktgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">PAUL SMITH ￡269</p>\n<p> 保罗&middot;史密斯——今年10月发布On the Road 系列包袋，行并添加自己的风格，暗示英国扭曲的诉讼。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RKrOXX4gXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Dolce &amp; Gabbana</p>\n<p> 发饰——这是一个国际秀的模特背影，看到一个非常漂亮的发夹组合和珠宝装饰,从Dolce &amp; Gabbana到Rodarte，到处都是丝带和珠子的配饰，最终形成了本季的流行元素。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1gDYNXkJiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Dior Diorshow Mascara ￡23</p>\n<p> 蓝色睫毛膏——2012-13秋冬时装周伸展台，有点怀旧的蓝色睫毛膏袭来，这是秋冬彩妆的一个新的尝试，你一定会喜欢上它。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dFHNXk8lXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">SOPHIA WEBSTER</p>\n<p> 索菲娅&middot;韦伯斯特——没有什么能如此爱上一个新鞋设计师。我们看到了索菲娅&middot;韦伯斯特这个夏天设计。以前是Nicholas Kirkwood的助理，她要为这个即将到来的伦敦时装周带来精彩的作品。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ns6PXahaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\">Maison Martin Margiela</p>\n<p> MAISON MARTIN MARGIELA FOR H&amp;M——11月15日:MAISON MARTIN FOR H&amp;M系列发布，已经有在网络上曝光，时装爱好者早已经做好准备，期待排着购物长队购买自己喜爱的秋冬单品。</p>', NULL, 1, 2, 0, 1370091776, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (63, '穿越老部落珠宝品牌Dannijo', ',29,', '穿越老部落珠宝品牌Dannijo', 'Dannijo2013春夏珠宝新品Dannijo2013春夏珠宝新品珠宝品牌Dannijo在2013春夏纽约时装周上发布了最新的珠宝系列。设计风格野性奔放的Dannijo，在2013春夏系列中依然坚持着浓浓的民族风情，非洲、印第安部落的羽毛头饰、夸张耳环，都成为Dannijo的灵感来源。大颗彩色宝石、串珠、金属链、厚实的黄铜材质，组成造型夸张复杂的珠宝作品，宽手镯、衣领式项链、用珠宝串联成的“连身', 'admin', '未知', 'Dannijo2013春夏珠宝新品Dannijo2013春夏珠宝新品珠宝品牌Dannijo在2013春夏纽约时装周上发布了最新的珠宝系列。设计风格野性奔放的Dannijo，在2013春夏系列中依然坚持着浓浓的民族风情，非洲、印第安部落的羽毛头饰、夸张耳环，都成为Dannijo的灵感来源。大颗彩色宝石、串珠、金属链、厚实的黄铜材质，组成造型夸张复杂的珠宝作品，宽手镯、衣领式项链、用珠宝串联成的“连身', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1s5rOXXpcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ZCLOXghbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1DPfNXkJiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo 2013春夏珠宝新品</p>\n<p>珠宝品牌Dannijo在2013春夏纽约时装周上发布了最新的珠宝系列。设计风格野性奔放的Dannijo，在2013春夏系列中依然坚持着浓浓的民族风情，非洲、印第安部落的羽毛头饰、夸张耳环，都成为Dannijo的灵感来源。大颗彩色宝石、串珠、金属链、厚实的黄铜材质，组成造型夸张复杂的珠宝作品，宽手镯、衣领式项链、用珠宝串联成的“连身衣”，都只需一件就足够抢眼。</p>\n<p>Dannijo将珠宝发布会的会场布置成一座生机勃勃的“植物园”，在草丛的掩映中，民族风情的华丽珠宝，带着观众们穿越回遥远神秘的古老部落。用盛着植物的玻璃瓶展示珠宝的方式，也带来了大自然感觉十足的别样趣味。</p>\n<p>了解更多纽约时装周全面一手消息，点击进入 &gt;&gt;海报时尚网2013春夏纽约时装周专题</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dDnEXiXsXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo 2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mBDNXdFhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1OoHJXoNpXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1K06OXf8dXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1QSHNXftjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo 2013春夏珠宝灵感来源</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1BULNXldgXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1NoLOXfBaXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1KyjNXg8kXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1FpHPXhdaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_N_NXbNmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.t_NXb0kXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1i86OXf0aXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T17VfPXhFXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1XO2NXmdkXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mQzNXbXkXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RnjNXbXfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xpYOXoJeXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1UUzJXbloXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1fsYOXdVfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1nFrOXjphXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YefOXjReXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dannijo2013春夏珠宝新品</p>', NULL, 1, 1, 0, 1370091776, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (64, '蝴蝶兰女神春夏彩妆', ',29,', '蝴蝶兰女神春夏彩妆', '点击进入专题>>海报时尚网独家解析2013春夏伦敦时装周Issa2013春夏女装秀秀场彩妆&发型细节2013春夏伦敦时装周洋溢着满满春夏风情的Issa2013春夏女装秀来了，设计师DaniellaIssaHelayel把Issa2013春夏女装秀上的模特们都装扮成了她心中女神的模样，满眼的鲜亮色彩和飘逸的垂坠设计，洋溢着春天的气息，也犹如蝴蝶般翩翩起舞。更不用说Issa2013春夏女装秀秀场彩妆和', 'admin', '未知', '点击进入专题>>海报时尚网独家解析2013春夏伦敦时装周Issa2013春夏女装秀秀场彩妆&发型细节2013春夏伦敦时装周洋溢着满满春夏风情的Issa2013春夏女装秀来了，设计师DaniellaIssaHelayel把Issa2013春夏女装秀上的模特们都装扮成了她心中女神的模样，满眼的鲜亮色彩和飘逸的垂坠设计，洋溢着春天的气息，也犹如蝴蝶般翩翩起舞。更不用说Issa2013春夏女装秀秀场彩妆和', '<p>点击进入专题 &gt;&gt;海报时尚网独家解析2013春夏伦敦时装周</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kQjNXXRlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>2013春夏伦敦时装周洋溢着满满春夏风情的Issa 2013春夏女装秀来了，设计师Daniella Issa Helayel把Issa 2013春夏女装秀上的模特们都装扮成了她心中女神的模样，满眼的鲜亮色彩和飘逸的垂坠设计，洋溢着春天的气息，也犹如蝴蝶般翩翩起舞。更不用说Issa 2013春夏女装秀秀场彩妆和发型细节了，绝对是最艳丽最妖娆，最热情最美，以及最精致的。</p>\n<p>斜向上拉长的眼线，一丝不苟的发髻，娇艳欲滴的蝴蝶兰，每个模特头上都戴着一小枝绮丽的花，热情鲜艳便是最好的主题。如果你恰好喜欢浓烈热情的女神妆容，那么Issa 2013春夏女装秀秀场彩妆和发型就会是你最好的参考。海报Girl有没有一种想立马尝试看看的冲动呢？</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1RLPKXX0qXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1aNzOXahdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YrvNXnJmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PE6IXgVsXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1uvLNXoxlXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Q1PNXnNmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T188jOXmlaXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kIHNXfpnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YFfJXippXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ca2NXkJnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1QmLNXdtjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1m4_NXbRiXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1iOnOXmRbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1CnbOXdVaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10JbOXjhdXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1rWPKXfloXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xXPPXfFXXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1t2POXnNcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1qtrOXjFfXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T14u2NXaXlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PpvJXd4sXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1V7LNXj8hXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1m9DNXo8iXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1jHLOXXJfXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1R6TNXcBkXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1dqfNXkJnXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16RfOXeVbXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1UAnOXh8bXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_5TNXkRjXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1xQvNXg0jXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T18YTOXileXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1FtjNXghkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wOTOXjpdXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1S3nNXhhmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1j2PNXlNmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1aAzNXgtjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1l1DNXmNlXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1JXzPXkhXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1c5rNXcJmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1axTNXkhmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1CH2NXfRnXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T16K_NXmViXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1PxfNXeVmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1vZDOXlBfXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mH6NXetmXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1XYYNXoBmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1kcHOXh8fXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1vw_OXjpbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1H3PIXelqXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1t3nOXn0dXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1JoLNXfxiXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1a0bNXg0kXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1gNDJXj8pXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1eGrOXfRgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1yl2MXc0jXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1GZ_OXkleXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1w6zNXidhXXXXXXXX.jpg\" /></p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1VxbNXoVjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Issa2013春夏女装秀秀场彩妆&amp;发型细节</p>\n<p>图片来自Issa</p>', NULL, 1, 1, 0, 1370091776, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (65, '“混”出本季至潮摩登女王', ',29,', '“混”出本季至潮摩登女王', '混搭是王道，百搭的运动时尚与潮流印花强强联手，融合了古典元素与强势气息，巧妙组合出2012年秋冬新形象：优雅，硬朗，还有一份高街时尚的玩味幽默。“混”出本季至潮摩登女王!印花西装MarcJacobs红色上衣Kappa珍珠腰链做项链Chanel棕红色图案长裤SeebyChlofromLaneCrawford白衬衫JilSander古董Boucheron黄金镶钻饰胸针、古董铂金镶钻石珍珠胸针、古董黄金', 'admin', '未知', '混搭是王道，百搭的运动时尚与潮流印花强强联手，融合了古典元素与强势气息，巧妙组合出2012年秋冬新形象：优雅，硬朗，还有一份高街时尚的玩味幽默。“混”出本季至潮摩登女王!印花西装MarcJacobs红色上衣Kappa珍珠腰链做项链Chanel棕红色图案长裤SeebyChlofromLaneCrawford白衬衫JilSander古董Boucheron黄金镶钻饰胸针、古董铂金镶钻石珍珠胸针、古董黄金', '<p>混搭是王道，百搭的运动时尚与潮流印花强强联手，融合了古典元素与强势气息，巧妙组合出2012 年秋冬新形象：优雅，硬朗，还有一份高街时尚的玩味幽默。“混”出本季至潮摩登女王!</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1wv2NXnxmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 印花西装 Marc Jacobs</p>\n<p>红色上衣 Kappa</p>\n<p>珍珠腰链做项链 Chanel</p>\n<p>棕红色图案长裤 See by Chlo from</p>\n<p>Lane Crawford</p>\n<p>白衬衫 Jil Sander</p>\n<p>古董Boucheron 黄金镶钻饰胸针、</p>\n<p>古董铂金镶钻石珍珠胸针、</p>\n<p>古董黄金镶珍珠蛇形手镯</p>\n<p>All by Asulikeit</p>\n<p>Tango 系列金属手链 Pomellato</p>\n<p>Wild flowors 系列耳环 De Beers</p>\n<p>马蹄戒指，珍珠戒指 All by Tasaki</p>\n<p>金色宽腰带 Gerard Darel</p>\n<p>驼色腰带 Salvatore Ferragamo</p>\n<p>胸针做腰带装饰 Max Mara</p>\n<p>奢华的风范并不只属于绫罗绸缎，带有几何条纹的Kappa 运动衫上再披一件印花外套，一份不经意的王者气场弥漫开来。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1gmjOXihaXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 印花西装 Miu Miu</p>\n<p>青蓝色高领衫 Weekend Max Mara</p>\n<p>印花领带 Bulgari</p>\n<p>条纹上衣 Kappa</p>\n<p>领带夹 Alfred Dunhill</p>\n<p>口袋巾 Boss Selection</p>\n<p>Mauboussin 系列古董鸟胸针、</p>\n<p>Bulgari 蓝紫色古董胸针、</p>\n<p>VCA 系列古董花胸针</p>\n<p>All by Asulikeit</p>\n<p>金色细项链做领带链 Georg Jensen</p>\n<p>Nudo 系列柠檬晶戒指、马德拉石戒指</p>\n<p>All by Pomellato</p>\n<p>Millemoi 拥幻系列限量美钻戒指</p>\n<p>Forevermark</p>\n<p>双C 腰带 Chanel</p>\n<p>报纸手包 Jil Sander</p>\n<p>信封包 Mischa from Lane Crawford</p>\n<p>搭扣高跟鞋Louis Vuitton</p>\n<p>宽领带，吊链，口袋巾等原本绅士配件，搭配色块运动衫，与高贵夸张假领一起打破了原有的呆板沉闷，另印花西装瞬间变身。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Px6NXatlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 水鸭蓝薄羽外套 Kappa</p>\n<p>金色印花衬衫 Cline</p>\n<p>黄色高领衫 SPORTMAX</p>\n<p>佩斯利花纹领带 Brioni</p>\n<p>领带夹 Alfred Dunhill</p>\n<p>格子长裤Gerard Darel</p>\n<p>蓝色宝石装饰腰带 Chanel</p>\n<p>红色水晶胸针 Marni</p>\n<p>花朵胸针 Louis Vuitton</p>\n<p>Lea 系列耳环De Beers</p>\n<p>蓝色皮草披肩、灰色皮草披肩</p>\n<p>All by Liu.Jo</p>\n<p>白金镶蓝宝石钻石戒指、白金镶翡翠钻</p>\n<p>石戒指、黄金手工编织项链、古董黄金</p>\n<p>钻石胸针、古董Tiffany 铂金像珍珠钻</p>\n<p>石眼镜 All by Asulikeit</p>\n<p>黄色短靴 Miu Miu</p>\n<p>黄色蟒蛇纹高跟鞋点亮全套装扮，带有装饰单品的轻便羽绒和格纹长裤的大胆尝试，碰撞出不一样的华丽摇滚风范。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T18Z2NXmNmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 橙色立领外套 Kappa</p>\n<p>褐色装饰上衣</p>\n<p>Givenchy by Riccardo Tisci</p>\n<p>黄钻戒指 Encordia 拥爱系列限量奢华</p>\n<p>美钻耳饰 All by Forevermark</p>\n<p>Wild flowors 系列镶钻戒指 De Beers</p>\n<p>以UP 为灵感的立体领口设计套上哥特风格的装饰艺术针织衫，带出强烈的形式感体现与众不同的穿衣方式。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T14ArNXj0jXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 紫色薄羽外套 Kappa</p>\n<p>白衬衫 Jil Sander</p>\n<p>印花背心 Miu Miu</p>\n<p>呢料短裤 agns b.</p>\n<p>黑色皮草帽做披肩 Chanel</p>\n<p>水晶胸针All by Max Mara</p>\n<p>Nudo 系列水晶戒指 Pomellato</p>\n<p>水晶戒指 Martine Wester</p>\n<p>水晶链条手镯</p>\n<p>Swarovski Crystallized</p>\n<p>领带，领带夹 All by Alfred Dunhill</p>\n<p>金色链条做领带链，袖扣</p>\n<p>Georg Jensen</p>\n<p>Millemoi 拥幻系列限量美钻耳饰</p>\n<p>Forevermark</p>\n<p>深色皮草为整身衣着加分不少，紫色薄羽外套与欧普图案立领衫混搭，实用而时髦。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Mu6FXjhqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 高领衫、马毛印花裙子、装饰九分裤，</p>\n<p>粉色外套、高跟鞋、胸针 All by Louis Vuitton</p>\n<p>格纹衬衫 Marni</p>\n<p>灰色套头衫 Kappa</p>\n<p>紫色鸵鸟皮腰带 Salvatore Ferragamo</p>\n<p>Tango 系列金色项链 Pomellato</p>\n<p>狗头雨伞 Burberry Prorsum</p>\n<p>Millemoi 拥幻系列限量钻石手环</p>\n<p>Forevermark</p>\n<p>白金镶钻石黑玛瑙耳环、白金镶彩色宝石胸针，</p>\n<p>白金镶钻石蓝宝石花形戒指</p>\n<p>All by Asulikeit</p>\n<p>粉色系的基调柔化了硬朗形象，套头衫搭配时髦的装饰图案的呢料大裙和阔腿裤独特又摩登。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1X8zOXjdbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 几何图案长款外衣，裤子 All by Prada</p>\n<p>灰色条纹上衣 Kappa</p>\n<p>珍珠耳环、发冠All by Tasaki</p>\n<p>Pin-up 系列烟晶戒指，Tango 系列柠檬</p>\n<p>晶戒指 Pomellato</p>\n<p>水晶跟高跟鞋 Chanel</p>\n<p>条纹上衣、干练裤装，再混搭犀利剪裁的无袖长外套……硬朗的穿着在优雅王冠衬托下雌雄同体：琢磨不透的神秘与高贵。</p>', NULL, 1, 0, 0, 1370091777, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (66, '毛衣+链 早秋搭配', ',29,', '毛衣+链 早秋搭配', '薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。点击查看-->搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用', 'admin', '未知', '薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。点击查看-->搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1EkrNXgdkXXXXXXXX.jpg\" /></p>\n<p>薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1uMbOXhRcXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Christopher Kane薰衣草色毛衣，价格：10,280 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1hgfNXjBjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> J Brand九分裤，价格：3,110 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1lPPOXc8aXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Acne银色切尔西短靴，价格：5,090 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T19GLOXjheXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Christopher Kane豹纹手提包，价格：4,450 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1pXYOXcXgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Lanvin浮雕项链，价格：15,850 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10lzOXf0aXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Lanvin星星戒指，价格：3,530 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1IlfMXb8pXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Dominic Jones金色手镯，价格：5,240 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1cGDNXb0nXXXXXXXX.jpg\" /></p>\n<p>毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1_QfOXd0XXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Proenza Schouler毛呢棒球外套，价格：21,420 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1KjjNXo4kXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Burberry London衬衫，价格：4,870 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1bXTJXhNqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> J Brand酒红色九分裤，价格：3,110 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1HfTNXlJhXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Nicholas Kirkwood油画图案短靴，价格：11,360 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1HCvNXd8gXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Proenza Schouler单肩包，价格：14,850 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YqLOXcBdXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Maison Martin Margiela 金色链条手镯，价格：3,080 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与*口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T11__OXkhXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Bottega Veneta圆形镂空项链，价格：20,530 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1MYHJXnXpXXXXXXXX.jpg\" /></p>\n<p>原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1YGLJXiRoXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Stella McCartney金色上衣，价格：7,500 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T13DnNXhVgXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> See by Chlo&eacute;毛衣，价格：2,770 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1F._OXjhXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> J Brand牛仔裤，价格：3,110 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1yjvOXbJbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Pierre Hardy露脚趾粗跟鞋，价格：7,560 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1M_bOXlNXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Marni医生包，价格：8,630 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1mt2NXlVkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Mallarino鸽子形状镂空项链，价格：2,570 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1IXvPXhVXXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Mallarino羽毛形状镂空项链，价格：3,200 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1XFPFXnFrXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> Yves Saint Laurent金色戒指，价格：2,450 CNY</p>\n<p>宽松款的毛衣自去年秋冬便席卷了每个人的衣橱，今年的毛衣风潮不但没有减弱反而愈演愈烈。而毛衣链作为针织服装的最佳配饰，时尚的你又怎么能够落下。</p>\n<p>点击查看--&gt;搭配方案一：薰衣草色的棒针宽松毛衣不由得让我们开始期待秋天的到来，款式简单的纯色毛衣，用夸张的项链搭配再好不过，复古的项链与摩登的装扮相互碰撞，绝对让你成为人群中的焦点。</p>\n<p>点击查看--&gt;搭配方案二：毛呢外套有着和毛衣一样的柔软质地，以色块为基础的搭配，在项链的选择上，适合用颜色鲜艳的颜色点亮全身。</p>\n<p>点击查看--&gt;搭配方案三：原本沉闷的藏蓝色毛衣，内搭金色的上衣，仅仅是脖颈与袖口的几抹亮色，便瞬间焕然一新，而在项链的选择上，则适合用较小尺寸的吊坠叠加佩戴，照样能够闪耀全场。</p>', NULL, 1, 1, 0, 1370091777, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (67, '普通手表如何可以戴出品位', ',29,', '普通手表如何可以戴出品位', '如今，手表已成为时尚人士、商务人士喜欢的装饰品、收藏品。其实，对于喜欢手表的普通人群而言，它也并不是遥不可及，这就像果粉喜欢电子产品、摄友一族喜欢买单反相机一样，凭自己的努力，大众也可以购买一些价格不是十分昂贵的手表。解放碑有不少名表店重庆晨报记者黄宇摄适合公务佩戴的手表选择手表最重要的一点就是和身份相符、场合相符。无论公务员、企业家、还是学生、白领……在买表时都应该遵从这一点。公务场合时一般以正', 'admin', '未知', '如今，手表已成为时尚人士、商务人士喜欢的装饰品、收藏品。其实，对于喜欢手表的普通人群而言，它也并不是遥不可及，这就像果粉喜欢电子产品、摄友一族喜欢买单反相机一样，凭自己的努力，大众也可以购买一些价格不是十分昂贵的手表。解放碑有不少名表店重庆晨报记者黄宇摄适合公务佩戴的手表选择手表最重要的一点就是和身份相符、场合相符。无论公务员、企业家、还是学生、白领……在买表时都应该遵从这一点。公务场合时一般以正', '<p>如今，手表已成为时尚人士、商务人士喜欢的装饰品、收藏品。其实，对于喜欢手表的普通人群而言，它也并不是遥不可及，这就像果粉喜欢电子产品、摄友一族喜欢买单反相机一样，凭自己的努力，大众也可以购买一些价格不是十分昂贵的手表。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1M4HNXiVlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 解放碑有不少名表店</p>\n<p>重庆晨报记者 黄宇 摄</p>\n<p>适合公务佩戴的手表</p>\n<p>选择手表最重要的一点就是和身份相符、场合相符。无论公务员、企业家、还是学生、白领……在买表时都应该遵从这一点。公务场合时一般以正装或制服为主，表盘简洁、较薄、皮表带的腕表比较适合他们，当然，公务员中不乏追求个性的年轻人，他们也可以挑选稍微动感的计时腕表或不要过厚的双日历表。5000到10000元这个价位的手表是不错的选择。</p>\n<p>常伟</p>\n<p>《时计》钟表杂志主编、北京收藏家协会理事、钟表文化学者</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1LxDKXkBmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 天梭</p>\n<p>天梭俊雅系列玫瑰金PVD世界时款</p>\n<p>零售价：2550-3550元</p>\n<p>天梭是走“平民奢侈品”路线的瑞士品牌，它与许多瑞士品牌一样，在超过百年的历史间，但天梭的价格却比任何其它瑞士手表品牌更具吸引力。</p>\n<p>美度贝伦赛丽III系列男士皮带款腕表</p>\n<p>零售价：8700元</p>\n<p>瑞士美度表早于1938年首次进入中国，时称“米度”。它以从经典建筑中汲取灵感的设计、机械机芯，以及万元左右的价格，逐渐受大众欢迎。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T14e6OXiRbXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 飞亚达</p>\n<p>飞亚达2012航天系列腕表</p>\n<p>零售价：6800元</p>\n<p>飞亚达可谓是中国手表的标杆品牌，并将业务延伸至国外。在演绎经典钟表文化的同时，也传达着对时间的认知和对生活的主张。</p>\n<p>天王表锋尚系列腕表</p>\n<p>零售价： 5000－10000元</p>\n<p>上世纪90年代，中央电视台新闻联播前“天王表为您准确报时”这一广告语令人印象深刻，从此，天王表逐步成长为国内知名钟表品牌的代表。</p>\n<p>适合企业家的手表</p>\n<p>江诗丹顿马耳他系列</p>\n<p>江诗丹顿是世界上历史最悠久的钟表制造商，在整个二十世纪，江诗丹顿推出了无数令人永志难忘的时计，每一款均代表了瑞士高级钟表登峰造极的制表工艺。其中，最能体现江诗丹顿创新精神的标志性款式之一，就是1912年首推的酒桶形腕表。此次推荐的马耳他系列，是其巅峰之作，懂表的人一看，就读出你的品位。</p>\n<p>欧米茄海马系列</p>\n<p>欧米茄在中国被人喜欢和熟悉的程度自不用说，它是最适合企业家们佩戴的手表品牌之一。海马系列诞生于1948年，这款1948同轴“伦敦2012”限量版则是今年推出的欧米茄首款海马系列自动腕表的复刻版，六十多年前的时尚风格延续至今。由于全球仅限量发行1948枚，因此也具有收藏价值。并且，这款表蕴含着全新的机芯技术：经瑞士官方天文台认证，搭载3层同轴擒纵系统和无卡度游丝摆轮。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T19vnNXkJmXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> 浪琴</p>\n<p>浪琴名匠系列</p>\n<p>浪琴表的优雅特别符合中国人的审美标准。简约经典的外观是名匠系列的亮点。经典的圆形表身设计，搭配表面上大麦颗粒的压印装饰，和细薄光亮的搪瓷保护层上映衬着的蓝色精钢指针，创造出可以完美展现儒雅男士阳刚一面的经典腕表。本版文/重庆晨报记者 何炎晓 李名璐</p>\n<p>对于企业老板，大众一些的手表，我推荐中高端的卡地亚、万国、劳力士、欧米茄、浪琴、豪利时、豪雅。当然，对钟表有特别要求的，可以选择江诗丹顿、宝珀这种特别低调并有品位的顶级品牌。一方面，这些牌子大众比较熟悉，能够彰显身份；另一方面，它们的款式都不过分华丽花哨，能配的场合比较多。</p>\n<p>张太宇：</p>\n<p>《ELLE睿士》资深钟表编辑</p>', NULL, 1, 1, 0, 1370091777, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (68, '冬季避寒十大阳光海岛', ',29,', '冬季避寒十大阳光海岛', '忙碌的一年即将过去，忙碌了整整一年的你，是否感到身心的疲惫？冬日的太阳毫无暖意，在都市丛林游走，整日呼吸糟糕的空气，听着喧闹纷乱噪音的你，是否感到厌倦？渴望享受火热的阳光，梦想着蓝天、碧浪、白沙滩？还等什么，那就出发吧！TOP1斐济：在彩色的大海里感受生命躺在椰树的树荫里，吹着温润的海风，舒服地躺在白色的沙滩椅上，听着哗哗的海浪声，美美地睡上一个午觉，你曾有过这样的梦想吗？斐济，正是实现你梦想的好', 'admin', '未知', '忙碌的一年即将过去，忙碌了整整一年的你，是否感到身心的疲惫？冬日的太阳毫无暖意，在都市丛林游走，整日呼吸糟糕的空气，听着喧闹纷乱噪音的你，是否感到厌倦？渴望享受火热的阳光，梦想着蓝天、碧浪、白沙滩？还等什么，那就出发吧！TOP1斐济：在彩色的大海里感受生命躺在椰树的树荫里，吹着温润的海风，舒服地躺在白色的沙滩椅上，听着哗哗的海浪声，美美地睡上一个午觉，你曾有过这样的梦想吗？斐济，正是实现你梦想的好', '<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1FjDOXe8bXXXXXXXX.jpg\" /></p>\n<p>忙碌的一年即将过去，忙碌了整整一年的你，是否感到身心的疲惫？冬日的太阳毫无暖意，在都市丛林游走，整日呼吸糟糕的空气，听着喧闹纷乱噪音的你，是否感到厌倦？渴望享受火热的阳光，梦想着蓝天、碧浪、白沙滩？还等什么，那就出发吧！</p>\n<p>TOP1 斐济：在彩色的大海里感受生命</p>\n<p>躺在椰树的树荫里，吹着温润的海风，舒服地躺在白色的沙滩椅上，听着哗哗的海浪声，美美地睡上一个午觉，你曾有过这样的梦想吗？斐济，正是实现你梦想的好地方。</p>\n<p>斐济是在南太平洋，靠近新西兰的一个岛国。那浅浅的海水漫过了珊瑚礁，湮没了沙滩，环绕着小岛。海水在灿烂阳光的照射下，泛着一片片晶莹的淡蓝色，像一条条洁静的蓝带，更像一块块璀璨的翡翠，洒在深蓝色的大海里，镶嵌在葳蕤山林的小岛周围。</p>\n<p>玩法：在斐济，享受阳光、沙滩，潜水感受缤纷的海底世界，当然是必不可少的事情。建议大家还一定要乘飞机游览，在空中俯瞰这漂浮在南太平洋上的斐济，才是最让人难忘的美事。翱翔于斐济群岛的蔚蓝天空中，触摸着一朵朵白云，从空中看到深深浅浅的蓝色包围的绿色小岛，好像散落在蓝色琉璃上的翡翠，那种大自然美的震撼，相信你会终身难忘。</p>\n<p>斐济这个海岛伊甸园，绝美的海景和宜人的气候，绝对会让身在都市丛林的你，忘掉俗世纷纷扰扰，享受一个世外桃源般的绝美假期。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1su_NXjdjXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP2 马尔代夫：到蓝色天堂感受纯净的爱情</p>\n<p>你的蜜月旅行地首选是哪里？我想先90%的人会说：马尔代夫。这个深入人心的度假天堂，确实可以满足你对“浪漫”这个词的所有想象。</p>\n<p>马尔代夫，坐落于印度洋的世外桃源，那里蓝天白云，椰林树影，水清沙白……。在那里，时间被光明正大肆意挥霍着，贪婪享受大自然赋予的一切清新，阳光温暖，海水透蓝，沙滩软绵，爱情更甜，一切美丽的细节，思想与灵魂，都停留在那片无限的美丽中。如果要用一种颜色来表示马尔代夫，那就是蓝，各种深深浅浅的蓝：深邃的蓝色，透明的蓝色，偏绿的蓝色……，从你到马尔代夫开始，就被蓝海、蓝天包围。正如马尔代夫的广告所说，“在地球上最后一个乐园里，只有你和你的爱人，还有马尔代夫……”</p>\n<p>玩法：马尔代夫是群岛国家，娱乐也以水上活动为主，潜水是最佳选择，此外，划水、冲浪、帆板等都是紧张刺激的运动；还可以乘坐独木舟或快船游览小岛；在深夜或者凌晨乘独木舟钓鱼，乘玻璃钢底船潜入海底看鱼，体验完全不同的经历。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1.APNXg0iXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP3 毛里求斯：天堂的原乡</p>\n<p>提起毛里求斯，可能国内大多数人对这个目的地不甚了解，这处位于印度洋的美丽岛国绝对不同凡响，马克&middot;吐温曾称赞其为天堂的原乡，意即上帝是按照毛里求斯这个模板打造出的天堂，而我觉得这里是天堂的天堂！岛上顶级度假村林立，体验的方式丰富多样，无论是平民运动还是贵族休闲，这里都有你想要的一切。</p>\n<p>玩法：如果在毛里求斯你不抓住时机疯玩放纵自己的话，那将无法体验毛里求斯式的享乐精髓。这里近乎丰富的疯玩项目只会让你HIGH到极致，最终感叹自己的时间不够。最值得体验的便是直升机旅行，从空中欣赏天堂岛的美丽无疑让人终生难忘。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T10NvNXflkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP4 长滩岛：沙细软得像面粉</p>\n<p>长滩岛在菲律宾。相比菲律宾的“宿务岛”、“薄荷岛(景区详情 图库)”等知名海岛，长滩岛仿佛是邻家孩子一样，养在深闺人未识。但这正是长滩岛的可爱之处，不管外界如何闹腾，长滩岛仿佛是自成一体，白日有白日的海钓，黑夜有黑夜的欢腾，尤其是在月圆之时，长滩岛美得让人不忍心睡去。</p>\n<p>玩法：风景旖旎的菲律宾长滩岛绝对是度假首选，扬帆出海、深海潜水、海鲜饕餮、特色SPA……甚至Copy一场沙滩婚礼全都No Problem。但如果想体验到独一无二的长滩岛，那就一定要随我们一起，去感受这里游乐与美味的双生，而“玩”与“味”天衣无缝的巧然结合、缺一不可，也正是长滩岛度假的独特魅力之所在。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1jyHOXn8bXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP5 巴厘岛：蜜月般的浪漫之地</p>\n<p>如果把整个印度尼西亚比作由岛屿串成的项链，那么巴厘岛便是这项链上最璀璨的一颗明珠。巴厘岛有“花之岛”、“诗之岛”、“天堂岛”等美称，这里有细洁的沙滩、成荫的绿树，一年四季鲜花盛开，空气清新。</p>\n<p>玩法：巴厘岛有不少知名海滩，其中热闹的库塔海滩是冲浪爱好者流连忘返的天堂。南纬8度灼热的阳光下，一波又一波的白头浪连绵不绝地冲向宽阔的沙滩，每个浪头都有矫健的搏浪者驾浪前行，动作灵巧而优美。充满活力的氛围，常引来不少勇敢者下海一试身手。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1ck6NXlRhXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP6 塞舌尔：如果一定要找个词来形容，那就是“仙境”</p>\n<p>是印度洋上的一颗明珠。它融汇了海岛应有的特质，留给人的感觉是，要多纯净有多纯净：蔚蓝的天空、碧绿的海水、瑰丽的云彩、梦幻的沙滩、奇异的海椰子、庞大的陆上巨龟和美丽的珊瑚礁，以及随时可以亲密接触的一群群鲸鲨。</p>\n<p>玩法：岛上五月谷公园被誉为世界上最小的世界文化遗产，那里生活着珍稀的塞舌尔夜莺和黑鹦鹉。濒临灭绝的黑鹦鹉，作为塞舌尔的国鸟，是这里的主角。它们也是岛上特有的物种，啼叫婉转清扬。其实黑鹦鹉通体呈咖啡色，因为常在树荫中飞行，被人们误以为是黑色。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1zWTNXX4pXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP7 普吉岛：用风景谱写的蓝色圆舞曲</p>\n<p>有一部泰国青春片，叫《初三大四我爱你》，讲述了曼谷的两兄弟提和纳与普吉的两姐妹淳和珍分别相恋的故事。故事里，提频繁往返于曼谷和普吉之间，当提驶着租来的摩托车去找淳的时候，普吉总是在下雨。大雨倾盆的小镇，温情脉脉的小食店，珍的“神仙半岛”，它们成为人们渴望抵达这里的理由...</p>\n<p>玩法：除了感受普吉岛的美丽风景、体验风土人情、享受美食、包括探险在内。还有不可错过的就是享受一次身心放松的spa。这里有最地道的精油按摩，和不同的精油和按摩方式可供挑选，从瑞典推油，中式按摩，到传统的泰式按摩。都别有一番情趣。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1Ks_NXitkXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP8 塞班岛：美女沙滩的绝对诱惑</p>\n<p>是个南北细长的珊瑚礁小岛，西岸沙滩绵延，东岸多岩石断崖。塞班的最高峰--踏破潮(Tapochau)位于波涛汹涌的东岸，站在山顶可俯瞰全岛景色。阳光下的塞班，海水呈现出淡绿、碧绿、深蓝、墨蓝，那一抹深不可测的墨蓝，就是世界最深的海沟--马里亚纳海沟。岸边火红热烈的凤凰花，绵白的长滩，映衬细腻柔滑如蓝色缎子般的海水，斑斓而炫目。黝黑清秀的查莫洛姑娘迈着轻盈的脚步走来，构成了塞班的绝色空间。</p>\n<p>玩法：塞班岛最出名的就是它的潜水活动。全岛有20多处潜水地点，海水的透视度可达30米。其中最有名的潜水地点是蓝洞(Grotto)，位于塞班岛东北部，这里水深达22米，共有3个洞穴，是世界十佳洞穴潜水地之一。蓝洞是典型的天然海蚀洞穴，经由这个洞穴可以潜水游至外海，这里已经成为塞班岛最独特的潜水地点，在这里潜水要求具备国际认证的PADI潜水证，否则只能在洞口看着反射出的奇异蓝光而兴叹止步了。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1f1_JXklqXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP9 冲绳：日本人心中的香格里拉</p>\n<p>之美，在于那梦幻般的色彩。晴空万里、碧海无垠、百花争艳、绿树成荫，琉球熏风轻轻吹过，用这些词形容冲绳真有些老套，而且绝不能尽兴，一句话“吃、喝、玩、乐”这里应有尽有，而且这里是一个真正的太阳乐园、享乐的天堂。</p>\n<p>玩法：每年冬季，座头鲸会来到庆良间海域繁殖，观赏其雄姿的赏鲸之旅倍受欢迎。这里能看到鲸鱼的可能性很高，如果运气好的话，还可就近观赏到生动壮观的鲸鱼泳姿。这里海水的透明度在世界上屈指可数，还栖息着可以与澳大利亚大堡礁相媲美的珊瑚。</p>\n<p style=\"text-align: center;text-indent: 0.0px;\" align=\"center\"><img src=\"http://img01.taobaocdn.com/tps/i1/T1oKDNXoVlXXXXXXXX.jpg\" /></p>\n<p class=\"pictext\" align=\"center\"> TOP10 民丹岛：海滩之旅处女地</p>\n<p>是印尼寥内群岛的最大岛屿，早在15世纪，郑和下西洋的记载中就已提及民丹岛。由于离新加坡很近，乘搭渡轮只需45分钟，不仅新加坡人把它当作后花园，也吸引了很多到新加坡的游客。</p>\n<p>在民丹岛上，你可以到高尔夫球场的绿茵场挥杆；参加海上运动尽情作乐；加入民丹岛生态探险之旅：向村民学习原始钓鱼术，或坐船在热带雨林夹岸的海与河交界水域穿梭游览。除了享受之外，这里还可以探险，乘着快艇顺着由红树林围起的河道可以走上好几个小时，观赏各种植物之外，还经常可以近距离地观看毒蛇、蜥蜴、翠鸟等动物，它们很可能就爬在你头顶的树枝上--在这里，你没有机会说无聊。</p>', NULL, 1, 3, 0, 1370091778, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (69, '如何让手袋成为点睛之笔', ',29,', '如何让手袋成为点睛之笔', '2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？绿色绒布手拿包2013春夏伦敦时装周秀场外街', 'admin', '未知', '2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？绿色绒布手拿包2013春夏伦敦时装周秀场外街', '<p>\n	2013春夏伦敦时装周秀场外美包街拍来了！少了名牌Logo的加持，那些或简约或复古的包包依然谋杀了不少菲林。设计精巧的手包最受宠，糖果色包包搭配素色服装不出错，方形公文包体现复古小情调，丝绒手包与夸张珠宝的组合最完美。\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1yc_OXkNdXXXXXXXX.jpg\" />\n</p>\n<p>\n	当然也有务实精神的OL一族拎着手袋赶场看秀，搭配干练却少了趣味。看完这辑包包街拍，时髦的海报girls是不是也心动马上想添一款人气手包了？\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T14qTNXXhoXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	绿色绒布手拿包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1d4bOXhhbXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	2013春夏伦敦时装周秀场外街拍之美包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1TSvNXjFiXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	黑色铆钉手拿包\n</p>\n<p>\n	更多精彩资讯请关注 新浪尚品、欲望潮品\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1fULNXmhhXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	2013春夏伦敦时装周秀场外街拍之美包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1FA_NXaBhXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	酒红色手拿包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1uHPOXhleXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	2013春夏伦敦时装周秀场外街拍之美包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1arrNXXJiXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	2013春夏伦敦时装周秀场外街拍之美包\n</p>\n<p style=\"text-align:center;text-indent:0.0px;\" align=\"center\">\n	<img src=\"http://img01.taobaocdn.com/tps/i1/T1oxnMXbXqXXXXXXXX.jpg\" />\n</p>\n<p class=\"pictext\" align=\"center\">\n	2013春夏伦敦时装周秀场外街拍之美包\n</p>\n<p>\n	更多精彩资讯请关注 新浪尚品、欲望潮品\n</p>', 'uploadfiles/images/20130601/c6a22813cbde284bf96f14c659e700a9.jpg', 1, 2, 0, 1370091778, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (70, '组图：林心如湿身拍大尺度广告 露香肩捞500万', ',30,', '组图：林心如湿身拍大尺度广告 露香肩捞500万', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', 'admin', '未知', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', '<!--link--><!--/link--><!--[if !IE]>|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8<![endif]-->\r\n\r\n<!-- 幻灯侧栏广告 -->\r\n<div style=\"position:absolute;margin-left:-30px;margin-top:30px;z-index:10\">\r\n    <!--huandeng_F_clcf_div AD begin....\"l=huandeng_F_clcf&log=off\"-->\n<div id=\"huandeng_F_clcf\" style=\"display:none;\" class=\"l_qq_com\">', NULL, 1, 0, 0, 1370091808, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (71, '曾志伟儿媳被曝怒骂老公：结婚因其老爸是名人', ',30,', '曾志伟儿媳被曝怒骂老公：结婚因其老爸是名人', '[导读]近日曾志伟之子曾国猷的妻子张可蕙，在网上讨论区大数婆婆的不是，更恃着有女在手，当公公志伟是“人肉提款机”。她还在个人主页数度爆粗怒骂老公曾国猷，更多次指嫁给他全因为其老爸是曾志伟。曝曾志伟(微博)儿媳辱骂婆婆和老公腾讯娱乐讯据港媒报道，近日曾志伟之子曾国猷（Mark）的妻子张可蕙（Renee），在网上讨论区大数婆婆（曾志伟老婆宋丽华）的不是，更恃着有女在手，当公公志伟是“人肉提款机”。同时', 'admin', '未知', '[导读]近日曾志伟之子曾国猷的妻子张可蕙，在网上讨论区大数婆婆的不是，更恃着有女在手，当公公志伟是“人肉提款机”。她还在个人主页数度爆粗怒骂老公曾国猷，更多次指嫁给他全因为其老爸是曾志伟。曝曾志伟(微博)儿媳辱骂婆婆和老公腾讯娱乐讯据港媒报道，近日曾志伟之子曾国猷（Mark）的妻子张可蕙（Renee），在网上讨论区大数婆婆（曾志伟老婆宋丽华）的不是，更恃着有女在手，当公公志伟是“人肉提款机”。同时', '<p class=\"titdd-Article\">[<strong>导读</strong>]近日曾志伟之子曾国猷的妻子张可蕙，在网上讨论区大数婆婆的不是，更恃着有女在手，当公公志伟是“人肉提款机”。她还在个人主页数度爆粗怒骂老公曾国猷，更多次指嫁给他全因为其老爸是曾志伟。</p><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=曾志伟儿媳被曝怒骂老公：结婚因其老爸是名人 src=\"http://img1.gtimg.com/ent/pics/hv1/161/86/1340/87155591.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">曝<!--keyword--><!--/keyword-->曾志伟<!--keyword-->(<span class=\"infoMblog\">微博</span>)\r\n<!--/keyword-->儿媳辱骂婆婆和老公</SPAN></P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 据港媒报道，近日曾志伟之子曾国猷（Mark）的妻子张可蕙（Renee），在网上讨论区大数婆婆（曾志伟老婆宋丽华）的不是，更恃着有女在手，当公公志伟是“人肉提款机”。同时，她亦在facebook与老公用粗口互骂驳火，内容粗鄙露骨。上周，香港记者向甚少理家事的曾志伟求证，对于家丑外扬，他无奈地说：“她（Renee）要发泄我也没有办法，希望他们小两口自己解决。”至于被新媳妇大骂的婆婆宋丽华就则回应：“家里事我会回去处理。”</P><P style=\"TEXT-INDENT: 2em\">香港记者日前在志伟儿媳妇张可蕙（Renee）的个人facebook中，发现她数度爆粗狂数老公曾国猷，更多次指嫁给他全因为其老爸是曾志伟，尽显极品港女本色。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>夫妻表面融洽</STRONG></P><P style=\"TEXT-INDENT: 2em\">曾国猷与张可蕙去年9月奉女成婚，人前一家三口表现得相当幸福，但原来只是表象，两公婆面和心不和。据报道，张可蕙在网上骂老公成日玩到天亮都不回家：“不是只有你一个辛苦的，曾先生，不要以为照顾孩子好过瘾呀，算了，总之以后不会烦你，你最好赚到钱，令我说不出一句话来就最好。”用语相当粗俗。</P><P style=\"TEXT-INDENT: 2em\">Renee经常在“亲子王国”讨论区发帖。早前她便晒在法国买、价值15多万的爱马仕袋。同时亦喜欢放自己女儿的近照。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>婆婆宋丽华避见儿媳</STRONG></P><P style=\"TEXT-INDENT: 2em\">上周，记者向曾太宋丽华表示，其新抱在讨论区闹她“独裁”，她气冲冲说：“我会回家去处理。”日前却被发现宋丽华独自一人到将军澳宝林&#37032;商场的大快活午膳。饭后她未有即时返家，宁愿在公园周围闲逛三小时才回家，避见儿媳。</P><P style=\"TEXT-INDENT: 2em\">上周一(20日)，曾志伟在电视城录影《超级无敌奖门人终极篇》，记者向他表明来意。他看过儿媳的网上留言后，皱着眉说：“每个人都有情绪，网上发泄我也没办法。我一向都对子女采取开放态度，希望他们小两口自己解决，我不会理！(你儿媳当你是提款机，你当初是否不想她入门？)关我什么事？儿子娶她又不是我娶！喜不喜欢都是他的事，我没有意见！”即以录影为由转身走入化妆间。</P><P style=\"TEXT-INDENT: 2em\">而曾国猷胞兄曾国祥则澄清，怀疑有黑客入侵弟媳的账户。</P>', NULL, 1, 0, 0, 1370091810, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (72, '组图：徐子珊深V裙性感亮相 中门大开获众人搀扶', ',30,', '组图：徐子珊深V裙性感亮相 中门大开获众人搀扶', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', 'admin', '未知', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', '<!--link--><!--/link--><!--[if !IE]>|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8<![endif]-->\r\n\r\n<!-- 幻灯侧栏广告 -->\r\n<div style=\"position:absolute;margin-left:-30px;margin-top:30px;z-index:10\">\r\n    <!--huandeng_F_clcf_div AD begin....\"l=huandeng_F_clcf&log=off\"-->\n<div id=\"huandeng_F_clcf\" style=\"display:none;\" class=\"l_qq_com\">', NULL, 1, 0, 0, 1370091812, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (73, '蔡依林姑姑斥其六亲不认 不开记者会认亲将提告', ',30,', '蔡依林姑姑斥其六亲不认 不开记者会认亲将提告', '蔡依林(微博)姑姑蔡依林中新网6月1日电蔡依林乌龙认亲事件还有续集，她的姑姑蔡如淑接受台媒专访时，控诉蔡依林全家六亲不认、无情无义，并要求蔡依林必须要亲自召开记者会承认她们的亲戚关系，否则不排除提出告诉。据台湾东森电视台网站报道，台湾“肯德基阿兵哥”蔡鼎钧证实是蔡依林的表弟，原本大家以为这个认亲事件应该落幕，但远在美国新泽西的蔡依林姑姑蔡如淑，却坚持对方必须亲自召开记者会公开承认才算数。“经纪人就', 'admin', '未知', '蔡依林(微博)姑姑蔡依林中新网6月1日电蔡依林乌龙认亲事件还有续集，她的姑姑蔡如淑接受台媒专访时，控诉蔡依林全家六亲不认、无情无义，并要求蔡依林必须要亲自召开记者会承认她们的亲戚关系，否则不排除提出告诉。据台湾东森电视台网站报道，台湾“肯德基阿兵哥”蔡鼎钧证实是蔡依林的表弟，原本大家以为这个认亲事件应该落幕，但远在美国新泽西的蔡依林姑姑蔡如淑，却坚持对方必须亲自召开记者会公开承认才算数。“经纪人就', '<P align=center><IMG alt=\"蔡依林姑姑斥其六亲不认 不开记者会认亲将提告\" src=\"http://img1.gtimg.com/ent/pics/hv1/99/79/1340/87153744.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><!--keyword--><!--/keyword-->蔡依林<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->姑姑</P><P align=center><IMG alt=\"蔡依林姑姑斥其六亲不认 不开记者会认亲将提告\" src=\"http://img1.gtimg.com/ent/pics/hv1/101/79/1340/87153746.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>蔡依林</P><P style=\"TEXT-INDENT: 2em\">中新网6月1日电 蔡依林乌龙认亲事件还有续集，她的姑姑蔡如淑接受台媒专访时，控诉蔡依林全家六亲不认、无情无义，并要求蔡依林必须要亲自召开记者会承认她们的亲戚关系，否则不排除提出告诉。</P><P style=\"TEXT-INDENT: 2em\">据台湾东森电视台网站报道，台湾“肯德基阿兵哥”蔡鼎钧证实是蔡依林的表弟，原本大家以为这个认亲事件应该落幕，但远在美国新泽西的蔡依林姑姑蔡如淑，却坚持对方必须亲自召开记者会公开承认才算数。</P><P style=\"TEXT-INDENT: 2em\">“经纪人就说是蔡依林传话，是蔡爸爸传话，那谁撒谎？谁有错呢？所以这个公开记者会是很重要的，就要澄清，因为这也证明她们的诚意对不对？就算是一种过失，她也必须要对社会有个交代。我这么一生……在美国的一切、打下的天下就这么毁于一旦啊！你叫我怎么去做人呢？我还能生存下去吗？”</P><P style=\"TEXT-INDENT: 2em\">蔡如淑受访时几度近乎落泪，并出示近十年来和蔡依林家人出游的亲密合影照片。“怎么可能30年没联络呢？15、16年前蔡&#26107;纹(蔡依林姐姐)在我家里住(过一个暑假)，那2001年我回去(台湾)的时候，去探访他们家人，还在他家里住了几天。我儿子暑期的时候回去，在他家不知道拜访了几次，那怎么会没联络呢？怎么会不熟呢？”</P><P style=\"TEXT-INDENT: 2em\">“你今天能访问到我都还算幸运了，搞不好我就去自杀就算了……”蔡如淑言谈间对哥哥家的态度相当不满；原本以为这个乌龙认亲事件已经落幕，但现在看起来，显然还有续集要上演。</P>', NULL, 1, 0, 0, 1370091814, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (74, '周润发鼓励钟楚红多认识男生 赞老搭档年轻', ',30,', '周润发鼓励钟楚红多认识男生 赞老搭档年轻', '周润发、钟楚红中新网6月1日电据香港“明报”消息，周润发与钟楚红这对《秋天的童话》经典银幕情侣，前晚在某品牌时装秀上再度聚头。周润发鼓励钟楚红多认识男生，钟楚红则说如合作拍戏，可再做发哥女友。周润发与钟楚红自《秋天的童话》及《纵横四海》后再没合作，前晚“船头尺”及“十三妹”重聚，两人风采依然，连同发嫂三人合照，言谈甚欢。穿上露肩裙的钟楚红，笑指早上才在健身房碰到周润发，她大赞对方身材好又帅气。问到', 'admin', '未知', '周润发、钟楚红中新网6月1日电据香港“明报”消息，周润发与钟楚红这对《秋天的童话》经典银幕情侣，前晚在某品牌时装秀上再度聚头。周润发鼓励钟楚红多认识男生，钟楚红则说如合作拍戏，可再做发哥女友。周润发与钟楚红自《秋天的童话》及《纵横四海》后再没合作，前晚“船头尺”及“十三妹”重聚，两人风采依然，连同发嫂三人合照，言谈甚欢。穿上露肩裙的钟楚红，笑指早上才在健身房碰到周润发，她大赞对方身材好又帅气。问到', '<P style=\"TEXT-INDENT: 2em\"></P><P align=center><IMG alt=周润发、钟楚红 src=\"http://img1.gtimg.com/ent/pics/hv1/213/78/1340/87153603.jpg\"></P><P style=\"FONT-SIZE: 10pt\" align=center>周润发、钟楚红</P><P style=\"TEXT-INDENT: 2em\">中新网6月1日电 据香港“明报”消息，周润发与钟楚红这对《秋天的童话》经典银幕情侣，前晚在某品牌时装秀上再度聚头。周润发鼓励钟楚红多认识男生，钟楚红则说如合作拍戏，可再做发哥女友。</P><P style=\"TEXT-INDENT: 2em\">周润发与钟楚红自《秋天的童话》及《纵横四海》后再没合作，前晚“船头尺”及“十三妹”重聚，两人风采依然，连同发嫂三人合照，言谈甚欢。</P><P style=\"TEXT-INDENT: 2em\">穿上露肩裙的钟楚红，笑指早上才在健身房碰到周润发，她大赞对方身材好又帅气。问到有否心痒跟发哥再合作？钟楚红说&#65109;“有！如果发哥开口，我不会拒绝。(拍<!--keyword--><!--/keyword-->《春娇与志明》<!--keyword--><!--/keyword-->续集？)不做志明不做春娇，做发哥老婆或女友就无所谓。”</P><P style=\"TEXT-INDENT: 2em\">钟楚红近日不时被拍到跟男生去逛街，周润发说&#65109;“鼓励！鼓励！”他更叫钟楚红多认识一些男生。</P><P style=\"TEXT-INDENT: 2em\">提到钟楚红愿跟他合作？发哥笑说&#65109;“要有好剧本先，红姑不可做<!--keyword--><!--/keyword-->余文乐<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->阿妈，余文乐做她的爸爸就差不多。”</P>', NULL, 1, 0, 0, 1370091816, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (75, '叶玉卿回应露肚皮跳舞：现在的我享受成熟', ',30,', '叶玉卿回应露肚皮跳舞：现在的我享受成熟', '[导读]阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的一部分原因是因为自己还热爱电影，更主要的原因是因为可以来香港照顾自己生病的母亲。叶玉卿广州日报6月1日报道电影《王牌情敌》将于下周二全国上映，在这部由曾志伟(微博)、叶玉卿、谭咏麟(微博)、黄宗泽(微博)、徐子珊(微博)、王祖蓝等主演的爱情喜剧中，阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的', 'admin', '未知', '[导读]阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的一部分原因是因为自己还热爱电影，更主要的原因是因为可以来香港照顾自己生病的母亲。叶玉卿广州日报6月1日报道电影《王牌情敌》将于下周二全国上映，在这部由曾志伟(微博)、叶玉卿、谭咏麟(微博)、黄宗泽(微博)、徐子珊(微博)、王祖蓝等主演的爱情喜剧中，阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的', '<p class=\"titdd-Article\">[<strong>导读</strong>]阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的一部分原因是因为自己还热爱电影，更主要的原因是因为可以来香港照顾自己生病的母亲。</p><P align=center><IMG alt=叶玉卿回应露肚皮跳舞：现在的我享受成熟 src=\"http://img1.gtimg.com/ent/pics/hv1/100/84/1340/87155020.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>叶玉卿</P><P style=\"TEXT-INDENT: 2em\">广州日报6月1日报道 <!--keyword--><!--/keyword-->电影<!--keyword--><!--/keyword-->《王牌情敌》将于下周二全国上映，在这部由<!--keyword--><!--/keyword-->曾志伟<!--keyword-->(<span class=\"infoMblog\">微博</span>)\r\n<!--/keyword-->、叶玉卿、<!--keyword--><!--/keyword-->谭咏麟<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->、<!--keyword--><!--/keyword-->黄宗泽<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->、<!--keyword--><!--/keyword-->徐子珊<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->、王祖蓝等主演的爱情喜剧中，阔别影坛16年之久的叶玉卿复出演戏。日前她接受记者邮件采访时表示，复出的一部分原因是因为自己还热爱电影，更主要的原因是因为可以来香港照顾自己生病的母亲。</P><P style=\"TEXT-INDENT: 2em\">她现在衣食无忧，相夫教子，演戏从她的生活必需品变成了生活调剂品，她的人生才是真正的戏梦人生。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>复出替丈夫还债？</STRONG></P><P style=\"TEXT-INDENT: 2em\"><STRONG>过戏瘾，回港照顾妈妈</STRONG></P><P style=\"TEXT-INDENT: 2em\">在为什么复出这个问题上，一直有着各种八卦，如叶玉卿的丈夫濒临破产，她复出替丈夫还债，众说纷纭。叶玉卿对于网上的传闻一笑了之，表示这回复出拍戏是吴君如从中帮忙，吴君如去美国探访她时促成了这次复出：“我以前真的没有想过复出，因为我有3个小孩子，已经移民到美国，开始过另外一种生活，所以完全没有想过这个事情，以前我都会说NO。直到吴君如来美国看我，她第一个问题就是问我，你到底有没有戏瘾，有没有想过出来再拍戏。然后曾志伟来找我，他说可以和谭咏麟合作，演他的妻子，我想其实主角不是我，就感觉这是个PARTTIME的临时演员的身份去演，所以我一点压力都没有。”</P><P style=\"TEXT-INDENT: 2em\">不过，叶玉卿也承认，回港拍戏也有出于尽孝心照顾妈妈的考虑：“我妈妈生病很久了，我来美国之后很长时间没有陪她，所以，我就说OK，只要在两周内把我的戏份拍完，我可以考虑，结果曾志伟说可以呀，我们需要8天的工作日，其他时间我可以去看我妈妈。结果我就答应了这次复出。”</P><P style=\"TEXT-INDENT: 2em\"><STRONG>扮丑露肚皮？</STRONG></P><P style=\"TEXT-INDENT: 2em\"><STRONG>这只是演戏，很好玩</STRONG></P><P style=\"TEXT-INDENT: 2em\">虽然叶玉卿已经47岁，但在《王牌情敌》中有一段露出肚皮跳印度舞，十分喜感：“我女儿也跟着我回香港拍戏，我拍这一场戏的时候，她也笑死了，我觉得这个造型好玩，我可以扮得再丑一点都没有所谓，因为这只是演戏，很好玩的。”</P><P style=\"TEXT-INDENT: 2em\">在这段印度舞中，可以看出女神风韵犹存。但叶玉卿说，她没什么保养秘诀，唯一的秘诀就是要保持好的心态：“我觉得自己老也好，不老也好，外表不是最重要的，其实心态才是最重要的。你生活过得很开心、很自在才是最重要。我们不断地成长，这是一个过程，是人生必须要经历的。”叶玉卿表示，与其老是怀念过去的年轻时代，不如享受现在的成熟：“我也很怀念以前年轻的时候，我的黄金时代，每一天都在我们的回忆里，都是我得到的，其实就应该成熟，我应该去享受。我到了47岁这个年纪，我不可能把自己变成20岁的孩子，这样子也太笑话了。”</P><P style=\"TEXT-INDENT: 2em\"><STRONG>剧透社</STRONG></P><P style=\"TEXT-INDENT: 2em\">上世纪七十年代香港，遍地黄金，处处都有生机！为人忠直的宋池雄(黄宗泽 饰)和狡猾的夏石森(<!--keyword--><!--/keyword-->谢天华<!--keyword-->（<span class=\"infoMblog\">微博</span>）<!--/keyword--> 饰)，一起到茶楼打工。两人同时爱上太子女美洋洋(徐子珊 饰)。众人冲过情关，也难敌时代巨轮，面对股灾、移民潮等，宋池雄捍卫茶楼，与街坊一起渡过难关。现代的宋池雄(谭咏麟 饰)人到中年，美洋洋(叶玉卿 饰)已为人母，夏石森(陈百祥 饰)成为集团老板，而茶楼面对新的势力，倾诉神仙(曾志伟 饰)能否令酒楼再添欢乐，又是否可以一如以往，团结就是力量？</P>', NULL, 1, 0, 0, 1370091818, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (76, '黄家强斥“消费死人”说：怀念亲大哥都不行吗', ',30,', '黄家强斥“消费死人”说：怀念亲大哥都不行吗', '[导读]6月30日是Beyond灵魂人物黄家驹逝世20周年的纪念日，身为家驹胞弟、Beyond的贝司手，黄家强将于6月初在香港九展Starhall举行一连两场的“It’salrightLive”演唱会，以表达缅怀家驹之情。黄家强(微博)南方都市报6月1日报道“家驹留了一把吉他给我，这把吉他陪伴着我继续走我的音乐路。虽然我真的很想他仍在我身边，跟我一起面对世事，但我知道这是不可能再发生的了。走到今天', 'admin', '未知', '[导读]6月30日是Beyond灵魂人物黄家驹逝世20周年的纪念日，身为家驹胞弟、Beyond的贝司手，黄家强将于6月初在香港九展Starhall举行一连两场的“It’salrightLive”演唱会，以表达缅怀家驹之情。黄家强(微博)南方都市报6月1日报道“家驹留了一把吉他给我，这把吉他陪伴着我继续走我的音乐路。虽然我真的很想他仍在我身边，跟我一起面对世事，但我知道这是不可能再发生的了。走到今天', '<p class=\"titdd-Article\">[<strong>导读</strong>]6月30日是Beyond灵魂人物黄家驹逝世20周年的纪念日，身为家驹胞弟、Beyond的贝司手，黄家强将于6月初在香港九展Starhall举行一连两场的“It’salright Live”演唱会，以表达缅怀家驹之情。</p><P style=\"TEXT-INDENT: 2em\"></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=黄家强斥“消费死人”说：怀念亲大哥都不行吗 src=\"http://img1.gtimg.com/ent/pics/hv1/50/75/1340/87152675.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">黄家强<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword--></SPAN></P><P style=\"TEXT-INDENT: 2em\">南方都市报6月1日报道 “家驹留了一把吉他给我，这把吉他陪伴着我继续走我的音乐路。虽然我真的很想他仍在我身边，跟我一起面对世事，但我知道这是不可能再发生的了。走到今天，我慢慢找到了自己的生存之道，反而希望他不要再担心我了，我很好。”</P><P style=\"TEXT-INDENT: 2em\">“之所以说‘夹Band’是死穴，是因为‘不夹不散，一夹就散’！有时候，‘夹Band’就是‘夹人’，音乐是很主观的事。”</P><P style=\"TEXT-INDENT: 2em\">6月30日是Beyond灵魂人物黄家驹逝世20周年的纪念日，身为家驹胞弟、Beyond的贝司手，黄家强将于6月初在香港九展Starhall举行一连两场的“It’salright Live”演唱会，以表达缅怀家驹之情。一向作风低调的黄家强近日新动作频频，除了纪念个唱，他还加盟了林建岳、<!--keyword--><!--/keyword-->任贤齐<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->旗下的大岳娱乐，准备以小齐师弟的身份大举开拓内地市场。虽然出道将近30年，但黄家强却从未开过一场属于自己的个人演唱会，所以这次个唱对他来说意义相当重大。接受南方都市报记者专访时，黄家强表示希望能藉着新歌《好好》跟家驹说一声“今天我好好”：“家驹一直以来都很照顾我，可能我给他的感觉比较天真，他总是担心我不懂该怎样去面对这个世界。这些年我变得更坚强，也成长了不少，我想他知道“It\'s alright，今天我好好’，不需要再担心我了！”</P><P style=\"TEXT-INDENT: 2em\">黄家强亲自作曲、填词的《好好》里有一句歌词是“活到这一分钟，遇到挫折跌倒总不会停步”，在演唱会前夕，站在风口浪尖上的黄家强也经历了不少隔空“骂战”。早前黄家强在微博发表了一封给家驹的信，有评论指家强一直在“消费死人”，Beyond前经纪人Leslie Chan也出来痛斥家强“借家驹宣传”。最令人意想不到的是，另一位Beyond成员黄贯中也在微博出言炮轰黄家强，并回应称家强“不是朋友，也不是兄弟”。面对种种不利声音，正在紧张筹备演唱会的黄家强选择了“封嘴”，没有接受任何媒体的访问。而在风波发生前，南都记者曾对黄家强进行了一次关于演唱会的独家专访，他也回应了关于“消费死人”的指责，我们或许能从中窥探到家强对此事的真实看法。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>Beyond情：Beyond的光环，是一种“加冕”</STRONG></P><P style=\"TEXT-INDENT: 2em\">黄家强的乐迷有两类，一类只喜欢Beyond时期的黄家强，另一类则很欣赏“单飞”后的黄家强。无论黄家强在音乐路上作再多的尝试，不少乐迷也只是希望黄家强能再唱回Beyond的经典旧作。面对这个“两难”问题，黄家强早已泰然处之：“在演唱会上我会‘梅花间竹’，唱两首Beyond的歌，再唱一首自己的歌。很多人从小到大都在听Beyond上世纪80年代的歌，要让他们接受我的新歌很难。单独唱我个人的歌，乐迷未必喜欢，这种方式会比较好。”</P><P style=\"TEXT-INDENT: 2em\">许多成功的乐坛组合“分拆上市”后，“单飞”的组合成员大都活在往日光环的阴影下，终身无法脱离这个枷锁。但在黄家强眼中，这个光环反而是“保护罩”：“如果往好的方面想，Beyond跟家驹的光环，一直在保护着我们三个人，这也许是一个框框，但其实也是一种‘加冕’。如果没有Beyond，我怎么有机会去做任性的纯音乐？我可能已经在四处想办法赚钱了。家驹留下最好的东西，就是让我们三个‘唔忧柴米’，一唱Beyond的歌就可以继续谋生，所以我们在音乐上都可以放得很开，全心全意去做一些很理想的东西。”黄家强说，他从没有想过要超越B e-yond，也不担心被Beyond的身份框住自己：“作为Beyond一分子，这是我的骄傲。我在做自己想做的音乐，我不是停滞不前，也没有吃老本。”</P><P style=\"TEXT-INDENT: 2em\"><STRONG>三子情：当正方形变成三角形</STRONG></P><P style=\"TEXT-INDENT: 2em\">家强说过“‘夹Band’是我们三个的死穴”，个中缘由令人心生疑窦，这次就让当事人亲自解惑：“之所以说‘夹Band’是死穴，是因为‘不夹不散，一夹就散’！有时候，‘夹Band’就是‘夹人’，音乐是很主观的事。当我们年少无知、对音乐仍一知半解时，大家处于互相扶持的阶段；但‘单飞’后，大家都独当一面，成长得很快。当每个人都有自己的理念与坚持时，原本没有缝隙的正方形变成了三角形，三个人一起做音乐真的行不通，继续做只会伤感情。如果感觉不对，何必还要勉强？我不想搞到最僵的时候才分手，还可以保持这段友谊时，不如大家就别继续‘夹Band’了。”既然如此，乐迷在有生之年还能有幸再看一次Beyond重组演出么？黄家强说，这件事只有在梦中才可能发生了：“如果三个人可以合体，我们早就合了。”</P><P style=\"TEXT-INDENT: 2em\">有乐迷认为，家驹离世后，三个人的Beyond早已不复辉煌，只是一直在“苟延残喘”。在黄家强看来，Beyond能坚持到现在，已经是一件很好的事：“虽然Beyond解散了，但乐队名字一直还在这里。当Beyond到了这个阶段，已经不是只属于我们三个人的了，每位乐迷都有权拥有这个名字。Beyond的精神并不只有我们三个遗传了，大家也可以继续延续Beyond的这个精神。”虽然黄家强平时与<!--keyword--><!--/keyword-->叶世荣<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->、黄贯中联络不多，但偶尔也会在网上聊几句，家强也有留意三子各自继承Beyond精神的个人作品：“其实我们三个的个人风格都很不一样，黄贯中的是硬摇滚，世荣的比较激昂，我就喜欢英式的音乐，编曲方面也更New Age一些。”</P><P style=\"TEXT-INDENT: 2em\"><STRONG>家驹情：《好好》是写给家驹的</STRONG></P><P style=\"TEXT-INDENT: 2em\">在《好好》中，点睛之句是“我衷心感激，你的声音把我唤醒”&#8212;&#8212;&#8212; 黄家强笔下的这个把“我”唤醒的“你”，自然是哥哥家驹。黄家强说，《好好》是专门写给家驹逝世20周年的纪念之作，没想到竟促成了他的首次个人音乐会，一切全乃无心插柳之举：“5年前我们帮家驹做过一些纪念活动，今年再重复类似的操作没多大意思，我希望用自己的方式去纪念他，跟他说说我心底里最想跟他说的话。家驹对我太重要，我写《好好》，只是想跟他说明我现在的状况，希望他能明白。可能是冥冥中上天自有安排，写完《好好》后就有公司来找我做演唱会，这是第一次有人问我要不要做个人售票演唱会！最开始我只是打算每天晚上在家里把《好好》唱给家驹一个人听，现在可以在台上跟歌迷一起唱、一起怀念家驹，我觉得，可能这就是他(家驹)帮我安排的。”</P><P style=\"TEXT-INDENT: 2em\">其实除了《好好》，黄家强这么多年来一直也有写歌给家驹，“比如《祝你愉快》、《他的吉他》，很明显就是在写家驹的。但我没有明说哪些歌是为了他而写的，自己知道就可以了。家驹留了一把吉他给我，这把吉他陪伴着我继续走我的音乐路。虽然我真的很想他仍在我身边，跟我一起面对世事，但我知道这是不可能再发生的了。走到今天，我慢慢找到了自己的生存之道，反而希望他不要再担心我了，我很好。”</P><P style=\"TEXT-INDENT: 2em\"><STRONG>音乐情：会有明哥小齐，会唱写给<!--keyword--><!--/keyword-->王菲<!--keyword--><!--/keyword-->的歌</STRONG></P><P style=\"TEXT-INDENT: 2em\">除了怀念家驹的部分，这次演唱会还将围绕黄家强的音乐成长历程而展开。黄家强表示，他希望能将旧歌的编曲弄得更具“时代感”，“虽然选曲方面以Beyond为主，因为Beyond代表了我的大部分青春，但在音乐的风格和取向上，我希望大家能听到一场符合‘黄家强’个人音乐喜好的演唱会。演唱会的主题是‘飞跃’，如果明天的我能够赢过今天的我，这就是一种进步。”嘉宾方面，家强请来跟Beyond一同成长的达明一派主音<!--keyword--><!--/keyword-->黄耀明<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->，还有新唱片公司的老板任贤齐：“明哥就像我的另一个哥哥一样，我们经常互相帮忙，我们的合作应该会有惊喜。至于小齐，可能会跟我一起唱《对面的女孩看过来》。我曾经为小齐跟李心洁写过一首叫《风暴》的合唱歌，但我绝对不会扮李心洁的女声来跟他对唱的，哈哈！”</P><P style=\"TEXT-INDENT: 2em\">“单飞”后，黄家强曾经一度帮别的歌手写了很多歌，所以在这次属于自己的演唱会上，他也会选唱其中的一些“沧海遗珠”：“可能很多人不清楚，除了给<!--keyword--><!--/keyword-->陈奕迅<!--keyword--><!--/keyword-->、<!--keyword--><!--/keyword-->陈小春<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->这些男歌手写过歌，我还帮王菲、<!--keyword--><!--/keyword-->李蕙敏<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->、陈慧琳等很多女歌手写歌。如果是女歌手向我邀歌，我交歌会比较快！因为女孩子的歌不适合自己唱，不能留给自己，所以我给女歌手写的歌会比较多。有一次<!--keyword--><!--/keyword-->谢霆锋<!--keyword--><!--/keyword-->找我写歌，写完后我觉得很好听，舍不得给他，然后我就跟霆锋说，‘写不出来啦！’”黄家强向南都记者透露，这次他会破天荒选唱其中几首“女生歌”，并将在编曲方面作出特别的尝试。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>热点回应</STRONG></P><P style=\"TEXT-INDENT: 2em\"><STRONG>谁在“消费死人”？</STRONG></P><P style=\"TEXT-INDENT: 2em\">不怕别人说我“消费死人”：“我不是跟家驹无亲无故的，那个是我的亲大哥。难道我连写一首歌，跟我哥说句话都不行？办纪念活动，有没有用到真感情，是牟利还是‘消费死人’，这个是很容易能看得出的。这次演唱会的每件事情都是突如其来的，时间很紧，几乎连场地都找不到，想选在家驹生日那一天(6月10日)都不行。我很随缘，当整个心态都不同了的时候，我绝对不会给别人一种‘消费死人’的感觉，因为我从没有这样想过。”</P><P style=\"TEXT-INDENT: 2em\">前经纪人才是在“消费死人”：“Beyond的前经纪人(Leslie Chan)整天都在做‘消费死人’的事，他每年都要消费几趟。最近Leslie Chan才用家驹的旧照片出了写真集，还说要把照片的版权费塞给我。我说‘我不要’，我不想承认这个东西是我许可他做的。虽然他未经我同意也可以这样做，因为那些照片的版权是属于他的，但我为什么要收他的钱？如果我收了这些钱，就等于我赞成他这样做；我不收的话，就表示我绝不赞同。我跟这个人完全是‘零交流’，如果Leslie Chan不是在‘消费死人’的话，那他算什么？”</P><P style=\"TEXT-INDENT: 2em\">世荣也没有“消费死人”：“我一点也不害怕别人说我‘消费死人’，我知道自己在做什么，这对我完全没有影响。世荣7月做纪念家驹的Show，我也不想大家说他在‘消费死人’，我反而会觉得很感动，人生有多少个20年？如果他不办这个表演的话，我反而会觉得世荣很无情。其实自从‘单飞’以来，世荣一直都很努力地在写歌给家驹，你能感受得到世荣对家驹的那份情。”</P>', NULL, 1, 0, 0, 1370091820, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (77, '林志玲不介意娇嗲声音被恶搞：大家开心就好', ',30,', '林志玲不介意娇嗲声音被恶搞：大家开心就好', '林志玲(微博)(微信号：chilinglin)中新网6月1日电据香港“明报”消息，林志玲昨天出席某品牌活动，最近她代言的网上游戏广告声带被网友恶搞，志玲闻言惊讶掩口说&#65109;“我不知道，在哪里可看到？就当作另一种宣传吧！我平日的声线较娇嗲，客户喜欢志玲姐姐平日的原音。”问她被恶搞会否不开心？她大方说&#65109;“希望声音配在很好看的女士上。”她自言不会介意&#65109;“大家开心就好', 'admin', '未知', '林志玲(微博)(微信号：chilinglin)中新网6月1日电据香港“明报”消息，林志玲昨天出席某品牌活动，最近她代言的网上游戏广告声带被网友恶搞，志玲闻言惊讶掩口说&#65109;“我不知道，在哪里可看到？就当作另一种宣传吧！我平日的声线较娇嗲，客户喜欢志玲姐姐平日的原音。”问她被恶搞会否不开心？她大方说&#65109;“希望声音配在很好看的女士上。”她自言不会介意&#65109;“大家开心就好', '<P align=center><IMG alt=林志玲不介意娇嗲声音被恶搞：大家开心就好 src=\"http://img1.gtimg.com/ent/pics/hv1/249/74/1340/87152619.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><!--keyword--><!--/keyword-->林志玲<!--keyword-->(<span class=\"infoMblog\">微博</span>)(<span class=\"infoMblog\">微信号：chilinglin</span>)\r\n<!--/keyword--></P><P style=\"TEXT-INDENT: 2em\">中新网6月1日电 据香港“明报”消息，林志玲昨天出席某品牌活动，最近她代言的网上游戏广告声带被网友恶搞，志玲闻言惊讶掩口说&#65109;“我不知道，在哪里可看到？就当作另一种宣传吧！我平日的声线较娇嗲，客户喜欢志玲姐姐平日的原音。”</P><P style=\"TEXT-INDENT: 2em\">问她被恶搞会否不开心？她大方说&#65109;“希望声音配在很好看的女士上。”她自言不会介意&#65109;“大家开心就好。”</P>', NULL, 1, 0, 0, 1370091822, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (78, '郑欣宜修身成功高鼻示人 自曝曾被沈殿霞掌掴', ',30,', '郑欣宜修身成功高鼻示人 自曝曾被沈殿霞掌掴', '[导读]郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传今晚在红馆举行的“开心果永远欣想演唱会”，才再次现身。再度现身的郑欣宜外貌有所变化惹疑。郑欣宜(微博)休息几个月后被发现鼻梁变得又直又高昔日郑欣宜鼻孔外露郑欣宜（中）接受新城电台DJ的访问腾讯娱乐讯2013年6月1日香港郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传', 'admin', '未知', '[导读]郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传今晚在红馆举行的“开心果永远欣想演唱会”，才再次现身。再度现身的郑欣宜外貌有所变化惹疑。郑欣宜(微博)休息几个月后被发现鼻梁变得又直又高昔日郑欣宜鼻孔外露郑欣宜（中）接受新城电台DJ的访问腾讯娱乐讯2013年6月1日香港郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传', '<p class=\"titdd-Article\">[<strong>导读</strong>]郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传今晚在红馆举行的“开心果永远欣想演唱会”，才再次现身。再度现身的郑欣宜外貌有所变化惹疑。</p><P style=\"TEXT-INDENT: 2em\"></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=\"郑欣宜修身成功高鼻示人 自曝曾被沈殿霞掌掴\" src=\"http://img1.gtimg.com/ent/pics/hv1/211/74/1340/87152581.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\"><!--keyword--><!--/keyword-->郑欣宜<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->休息几个月后 被发现鼻梁变得又直又高</SPAN></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=\"郑欣宜修身成功高鼻示人 自曝曾被沈殿霞掌掴\" src=\"http://img1.gtimg.com/ent/pics/hv1/212/74/1340/87152582.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">昔日郑欣宜鼻孔外露</SPAN></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=\"郑欣宜修身成功高鼻示人 自曝曾被沈殿霞掌掴\" src=\"http://img1.gtimg.com/ent/pics/hv1/213/74/1340/87152583.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">郑欣宜（中）接受新城电台DJ的访问</SPAN></P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 2013年6月1日 香港 郑欣宜自本年二月胀爆出席公司春茗后，一直以休息做歌为由“消失”几个月，直至近日为了宣传今晚在红馆举行的“开心果永远欣想演唱会”，才再次现身。成功修身的她消瘦不少，想不到更来个大修整，不但出现V字脸，鼻梁更变得又直又高，本来鼻孔外露的插苏鼻也离奇消失！</P><P style=\"TEXT-INDENT: 2em\"><STRONG>要做就整鼻子</STRONG></P><P style=\"TEXT-INDENT: 2em\">其实多年来曾数度传出郑欣宜整容变好看的消息，全被她一一否认，不过两年前她就曾认真表示：“我暂时没有需要整容，如果要整，当然是做鼻子！我会将两边鼻翼收窄，再整尖和整高鼻子！”原来当时她已下定决心要由丑小鸭变天鹅。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>激怒肥姐捱掴</STRONG></P><P style=\"TEXT-INDENT: 2em\">另外，郑欣宜昨日在新城电台受访时分享与妈妈沈殿霞（肥姐）的生活点滴，她大爆18岁时曾惹到肥姐要掌掴她：“第一次去兰桂坊玩不记得回复妈妈爱的电话，到凌晨5点才回到家里，妈妈骂我令到她好担心，接着一巴掌打下来。”</P><P style=\"TEXT-INDENT: 2em\"><FONT color=#ff0000><STRONG>版权属东方报业集团或ON.CC所有，不得转载！</STRONG></FONT></P>', NULL, 1, 0, 0, 1370091824, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (79, '周秀娜前男友陈伟成笑称怕自己会喜欢男人', ',30,', '周秀娜前男友陈伟成笑称怕自己会喜欢男人', '[导读]据香港媒体报道，周秀娜前男友陈伟成昨天与黄浩然、钟嘉欣与松冈李那现在游泳用品品牌记者会。陈伟成被问及感情问题是否影响到工作，他表示目前只想专注打理自己的生意。（从左至右）陈伟成、黄浩然、钟嘉欣(微博)与松冈李那腾讯娱乐讯据香港媒体报道，周秀娜(微博)前男友陈伟成昨天与黄浩然、钟嘉欣与松冈李那现在游泳用品品牌记者会，陈伟成被问到是否与周秀娜分手而少了很多工作，他表示自己只是想专注打理发型屋生', 'admin', '未知', '[导读]据香港媒体报道，周秀娜前男友陈伟成昨天与黄浩然、钟嘉欣与松冈李那现在游泳用品品牌记者会。陈伟成被问及感情问题是否影响到工作，他表示目前只想专注打理自己的生意。（从左至右）陈伟成、黄浩然、钟嘉欣(微博)与松冈李那腾讯娱乐讯据香港媒体报道，周秀娜(微博)前男友陈伟成昨天与黄浩然、钟嘉欣与松冈李那现在游泳用品品牌记者会，陈伟成被问到是否与周秀娜分手而少了很多工作，他表示自己只是想专注打理发型屋生', '<p class=\"titdd-Article\">[<strong>导读</strong>]据香港媒体报道，周秀娜前男友陈伟成昨天与黄浩然、钟嘉欣与松冈李那现在游泳用品品牌记者会。陈伟成被问及感情问题是否影响到工作，他表示目前只想专注打理自己的生意。</p><P style=\"TEXT-INDENT: 2em\"></P><P align=center><IMG alt=周秀娜前男友陈伟成笑称怕自己会喜欢男人 src=\"http://img1.gtimg.com/ent/pics/hv1/158/73/1340/87152273.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">（从左至右）陈伟成、黄浩然、<!--keyword--><!--/keyword-->钟嘉欣<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword-->与松冈李那</SPAN></P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 据香港媒体报道，周秀娜<!--keyword-->(<span class=\"infoMblog\">微博</span>)<!--/keyword--><SPAN style=\"BACKGROUND-COLOR: navy; COLOR: white\"></SPAN>前男友陈伟成昨天与黄浩然、钟嘉欣<SPAN style=\"BACKGROUND-COLOR: navy; COLOR: white\"></SPAN>与松冈李那现在游泳用品品牌记者会，陈伟成被问到是否与周秀娜分手而少了很多工作，他表示自己只是想专注打理发型屋生意。陈伟成坦言跟周秀娜很久没联系，连对方换了手机号码也不知道，更坦言与周秀娜分手不再是朋友。不过提到周秀娜的新绯闻时，他却很紧张地查问。</P><P style=\"TEXT-INDENT: 2em\">昨天的活动上，陈伟成与松冈李那陈伟成以比基尼及紧身泳裤装束现身，钟嘉欣与黄浩然却只穿密实沙滩装出场，引来传媒一阵嘘声，且黄浩然示范时更忘形掉裤子。</P><P style=\"TEXT-INDENT: 2em\">对于昨天以密实造型出场被嘘，钟嘉欣只管在笑，黄浩然则指因要介绍防晒衫，笑他掉裤子，黄浩然笑说：“我掉了一段时间才有人通知我，幸好有打底！”钟嘉欣在旁笑说：“好有感觉，我意思是在沙滩也会玩到这样！”虽然昨天成了大输家，但钟嘉欣并没介意，并笑指让年轻的来发挥一下，而且她感觉穿泳衣拍硬照还可以接受，自己会没这么怕羞。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>陈伟成承认与周秀娜不是朋友</STRONG></P><P style=\"TEXT-INDENT: 2em\">陈伟成穿泳裤下水坦言酬金满意，但自从与周秀娜分手后他像是少了工作，他表示没去算过，也并非要疗情伤不见人，他近来专注打理发型屋的生意，且又刚与经理人公司满约想转换环境。问是不是不想跟周秀娜同一公司？陈伟成答道：“只是想为自己转换改变新形象！”</P><P style=\"TEXT-INDENT: 2em\">陈伟成坦言跟周秀娜很久没联络，连对方换了电话号码也不知。有指周秀娜为避开他才换电话号码？他指这要去问对方才知道。问到是否分手后做不回朋友？陈伟成直言：“暂时不是朋友！”但当提到周秀娜有新恋情时，陈伟成即紧张地查问，当听到是监制黄永峰，陈伟成像松了口气般笑说：“他是我们的好朋友，跟他的老婆都好熟，以前常四个人一齐去上街，没事的！”问他现在有没有新恋情？陈伟成笑指现在怕自己会喜欢男人，因之前绯闻太多见到女孩子也会有点害怕，所以比较少接触女性。他更透露这次到泰国拜神都是男士团。问他是不是去疗情伤及求段真恋情？他笑说：“只是我之前撞车又进医院做手术觉得倒霉想转运！”问会不是想跟周秀娜复合？他直说：“暂时不会，缘份尽了完结就完结，我也没去想之后，见她开心就OK了，我自己都OK！”</P>', NULL, 1, 0, 0, 1370091826, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (80, '朱丽倩大肚照曝光 刘德华经纪人不回应怀孕传闻', ',30,', '朱丽倩大肚照曝光 刘德华经纪人不回应怀孕传闻', '[导读]据台湾媒体消息，刘德华(华仔)向来注重隐私，日前受访时曾表露很想追生儿子。早前，朱丽倩被拍到小腹微凸，飘散“孕味”，有港媒猜测，朱丽倩早已悄悄有喜。经纪人昨说：“不回应任何传闻。”朱丽倩大肚近照曝光刘德华吻小孩刘德华豪掷两亿起堡垒与朱丽倩拜佛4小时虔诚求子时长：1\'7\'\'播放：608502来源：腾讯视频', 'admin', '未知', '[导读]据台湾媒体消息，刘德华(华仔)向来注重隐私，日前受访时曾表露很想追生儿子。早前，朱丽倩被拍到小腹微凸，飘散“孕味”，有港媒猜测，朱丽倩早已悄悄有喜。经纪人昨说：“不回应任何传闻。”朱丽倩大肚近照曝光刘德华吻小孩刘德华豪掷两亿起堡垒与朱丽倩拜佛4小时虔诚求子时长：1\'7\'\'播放：608502来源：腾讯视频', '<p class=\"titdd-Article\">[<strong>导读</strong>]据台湾媒体消息，刘德华(华仔)向来注重隐私，日前受访时曾表露很想追生儿子。早前，朱丽倩被拍到小腹微凸，飘散“孕味”，有港媒猜测，朱丽倩早已悄悄有喜。经纪人昨说：“不回应任何传闻。”</p><P style=\"TEXT-INDENT: 2em\"></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=\"朱丽倩大肚照曝光 刘德华经纪人不回应怀孕传闻\" src=\"http://img1.gtimg.com/ent/pics/hv1/154/65/1340/87200229.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\">朱丽倩大肚近照曝光</SPAN></P><P align=center><SPAN style=\"FONT-SIZE: 12px\"><IMG alt=\"朱丽倩大肚照曝光 刘德华经纪人不回应怀孕传闻\" src=\"http://img1.gtimg.com/ent/pics/hv1/155/65/1340/87200230.jpg\"></SPAN></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\"><!--keyword--><!--/keyword-->刘德华<!--keyword--><!--/keyword-->吻小孩</SPAN></P><P><div class=\"relativeVideo clearfix\"><div class=\"relInfo clearfix\" id=\"relInfo\"><div class=\"relPic\" id=\"relPic\" bosszone=\"rVideo\"><div class=\"relPicbg\"><h2>刘德华豪掷两亿起堡垒 与朱丽倩拜佛4小时虔诚求子</h2><p class=\"v-runtime\"><label>时长：</label><span class=\"ff-t\">1\'7\'\'</span></p><p class=\"v-times\"><label>播放：</label><span class=\"ff-t\">608502</span></p><p class=\"v-source\"><label>来源：</label>腾讯视频</p>', NULL, 1, 0, 0, 1370091829, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (81, '刘德华被传求神摆阵追子成功 成功再当父亲', ',30,', '刘德华被传求神摆阵追子成功 成功再当父亲', '[导读]据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，随后又被曝成功再做父亲。但目前消息尚未证实。刘德华腾讯娱乐讯据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，隔没几日又有媒体惊爆华仔即将再为人父，妻子朱丽倩再度有孕的消息，碍于习俗未满3个月不能公开，才选择保留喜讯。据媒体报导，刘德华虽然已经有爱女刘向蕙(Hanna)，但观念传统的他', 'admin', '未知', '[导读]据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，随后又被曝成功再做父亲。但目前消息尚未证实。刘德华腾讯娱乐讯据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，隔没几日又有媒体惊爆华仔即将再为人父，妻子朱丽倩再度有孕的消息，碍于习俗未满3个月不能公开，才选择保留喜讯。据媒体报导，刘德华虽然已经有爱女刘向蕙(Hanna)，但观念传统的他', '<p class=\"titdd-Article\">[<strong>导读</strong>]据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，随后又被曝成功再做父亲。但目前消息尚未证实。</p><P style=\"TEXT-INDENT: 2em\"></P><P align=center><IMG alt=\"刘德华被传求神摆阵追子成功 成功再当父亲\" src=\"http://img1.gtimg.com/ent/pics/hv1/32/59/1340/87148577.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center><SPAN style=\"FONT-SIZE: 12px\"><!--keyword--><!--/keyword-->刘德华<!--keyword--><!--/keyword--></SPAN></P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 据台湾媒体报道，天王刘德华最近才被媒体爆料在香港掷金上亿置产、买飞机安顿妻小，隔没几日又有媒体惊爆华仔即将再为人父，妻子朱丽倩再度有孕的消息，碍于习俗未满3个月不能公开，才选择保留喜讯。</P><P style=\"TEXT-INDENT: 2em\">据媒体报导，刘德华虽然已经有爱女刘向蕙(Hanna)，但观念传统的他还是很希望能有个儿子，友人透露，他从没放弃生子，为此寻遍中西名医为47岁的老婆朱丽倩调养身体，甚至求神摆阵只为求得一子。事实上，他早在5月初被记者问到是否有再拼个儿子的计划时，就曾爽快说答应，被媒体猜测疑似乐晕头露了口风，最近华嫂被拍到小腹微凸，更让外界质疑是否悄悄有喜了？</P><P style=\"TEXT-INDENT: 2em\">52岁的刘德华老来得子，对目前唯一的独生女Hanna极为呵护，其中为保护妻女隐私的3处逾亿元的豪宅加上保母、保镳及方便一家3口能共同出入的私人飞机，粗估光是这些开销就高达至少5亿人民币，此举也被猜测是为添子计划铺路。翻开华仔夫妻俩的隐婚史，2人爱情长跑27年，却直到2009年华嫂父亲过世，他才公开承认在2008年于赌城登记结婚。</P>', NULL, 1, 1, 0, 1370091831, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (82, '台男星林佑星8月当爸 自曝遭20岁孕妻强迫行房', ',30,', '台男星林佑星8月当爸 自曝遭20岁孕妻强迫行房', '林佑星带着美女老婆记者会晒恩爱林佑星带着美女老婆腾讯娱乐讯据台湾媒体报道，台湾本土剧男星林佑星日前上节目，才遭好友陈佩骐爆料回家都要装累，只因为年仅20岁的老婆张晏&#33787;体力太好，小俩口甜蜜互动闪瞎人。而他31日出席中天、大爱《手心外的天空》记者会，怀胎五月的老婆爱相随，现场也大胆爆料自己其实这段时间不太敢碰老婆，坦言：“有小孩在里面，怪怪的。”38岁林佑星对老婆呵护备至，即将于8月升格', 'admin', '未知', '林佑星带着美女老婆记者会晒恩爱林佑星带着美女老婆腾讯娱乐讯据台湾媒体报道，台湾本土剧男星林佑星日前上节目，才遭好友陈佩骐爆料回家都要装累，只因为年仅20岁的老婆张晏&#33787;体力太好，小俩口甜蜜互动闪瞎人。而他31日出席中天、大爱《手心外的天空》记者会，怀胎五月的老婆爱相随，现场也大胆爆料自己其实这段时间不太敢碰老婆，坦言：“有小孩在里面，怪怪的。”38岁林佑星对老婆呵护备至，即将于8月升格', '<P align=center><IMG alt=\"台男星林佑星8月当爸 自曝遭20岁孕妻强迫行房\" src=\"http://img1.gtimg.com/ent/pics/hv1/125/58/1340/87148415.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>林佑星带着美女老婆记者会晒恩爱</P><P align=center><IMG alt=\"台男星林佑星8月当爸 自曝遭20岁孕妻强迫行房\" src=\"http://img1.gtimg.com/ent/pics/hv1/144/58/1340/87148434.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>林佑星带着美女老婆</P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 据台湾媒体报道，台湾本土剧男星林佑星日前上节目，才遭好友陈佩骐爆料回家都要装累，只因为年仅20岁的老婆张晏&#33787;体力太好，小俩口甜蜜互动闪瞎人。</P><P style=\"TEXT-INDENT: 2em\">而他31日出席中天、大爱《手心外的天空》记者会，怀胎五月的老婆爱相随，现场也大胆爆料自己其实这段时间不太敢碰老婆，坦言：“有小孩在里面，怪怪的。”38岁林佑星对老婆呵护备至，即将于8月升格当爸的他被剧组封为“大仁哥”，老婆也大赞他体贴，不管半夜想吃糖炒栗子还是热炒鸡睾丸，林佑星都会拚命帮她买回来，就怕饿到爱妻与肚子里的小孩。</P><P style=\"TEXT-INDENT: 2em\">不过林佑星再体贴，也有“过不去”的时候，他现场就坦言老婆怀孕让他不太敢行房：“有小孩在里面，怪怪的。”被问起夫妇俩这段时间都没鱼水之欢？只见林佑星不好意思地笑说：“可我老婆都强迫我！”而张晏&#33787;听见老公这样说，也不甘示弱地回呛：“你要惜福！”透露曾听过有些女性在怀孕期反而会对性生活反感，让老公苦不堪言。</P><P style=\"TEXT-INDENT: 2em\">据悉，两人将于12月28日举办婚宴。</P>', NULL, 1, 0, 0, 1370091833, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (83, '奥斯卡影后被曝体臭熏人又傲慢 沦为女星公敌', ',30,', '奥斯卡影后被曝体臭熏人又傲慢 沦为女星公敌', '格温妮丝帕特洛女星不爽帕特洛腾讯娱乐讯台湾媒体报道，美国奥斯卡影后格温妮丝帕特洛(GwynethPaltrow)在《钢铁人》系列饰演“小辣椒”，该片第3集全球大卖近360亿元台币，她私下却是“超级顾人怨”，被批“高傲刻薄”，同行女星安吉丽娜朱莉、詹妮弗洛佩兹与珍妮佛嘉纳等都很讨厌她；日前她跑趴散发体臭，宾客纷纷走避。好莱坞业界人士指出，葛妮丝父亲布鲁斯生前是好莱坞制片，史蒂芬史匹柏是她乾爹，她自认', 'admin', '未知', '格温妮丝帕特洛女星不爽帕特洛腾讯娱乐讯台湾媒体报道，美国奥斯卡影后格温妮丝帕特洛(GwynethPaltrow)在《钢铁人》系列饰演“小辣椒”，该片第3集全球大卖近360亿元台币，她私下却是“超级顾人怨”，被批“高傲刻薄”，同行女星安吉丽娜朱莉、詹妮弗洛佩兹与珍妮佛嘉纳等都很讨厌她；日前她跑趴散发体臭，宾客纷纷走避。好莱坞业界人士指出，葛妮丝父亲布鲁斯生前是好莱坞制片，史蒂芬史匹柏是她乾爹，她自认', '<P align=center><IMG alt=\"奥斯卡影后被曝体臭熏人又傲慢 沦为女星公敌\" src=\"http://img1.gtimg.com/ent/pics/hv1/245/55/1340/87147770.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>格温妮丝帕特洛</P><P align=center><IMG alt=\"奥斯卡影后被曝体臭熏人又傲慢 沦为女星公敌\" src=\"http://img1.gtimg.com/ent/pics/hv1/248/55/1340/87147773.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>女星不爽帕特洛</P><P style=\"TEXT-INDENT: 2em\">腾讯娱乐讯 台湾媒体报道，美国<!--keyword--><!--/keyword-->奥斯卡<!--keyword--><!--/keyword-->影后格温妮丝帕特洛(Gwyneth Paltrow)在《钢铁人》系列饰演“小辣椒”，该片第3集全球大卖近360亿元台币，她私下却是“超级顾人怨”，被批“高傲刻薄”，同行女星安吉丽娜朱莉、詹妮弗洛佩兹与珍妮佛嘉纳等都很讨厌她；日前她跑趴散发体臭，宾客纷纷走避。</P><P style=\"TEXT-INDENT: 2em\">好莱坞业界人士指出，葛妮丝父亲布鲁斯生前是好莱坞制片，史蒂芬史匹柏是她乾爹，她自认系出好莱坞名门，目中无人，多位制片都点名拒绝与她合作。 </P><P style=\"TEXT-INDENT: 2em\">她上月初出席大都会博物馆时尚派对，事后受访说：“我再也不去了，很难玩。”得罪派对主办人《VOGUE》杂志恶魔总编安娜温图。但她才是不受欢迎人物，目击者说：“葛妮丝的体味很重，我至少看到两人经过她身边时，在鼻子前煽风。” </P><P style=\"TEXT-INDENT: 2em\">讨厌她的人还有一拖拉库。她曾与“小布”布拉德皮特论及婚嫁，小布未婚妻裘莉批她“傲慢又做作”。</P><P style=\"TEXT-INDENT: 2em\"><STRONG>嘉纳批刻薄</STRONG></P><P style=\"TEXT-INDENT: 2em\">前男友“小班”本阿弗莱克的老婆嘉纳向来温和有礼，却说她“像高中的刻薄坏女孩”。小班另一个前女友“翘臀珍”詹妮弗洛佩兹直言葛妮丝是“爱发牢骚的富家女”，对她被《时人》杂志选为今年“最美丽时人”嗤之以鼻。 </P><P style=\"TEXT-INDENT: 2em\">她曾公开嘲笑奥斯卡影后莉丝威斯朋“只会拍愚蠢的爱情片”，莉丝回呛：“拍过《情人眼里出西施》的人凭什么给别人事业上的建言？” </P>', NULL, 1, 0, 0, 1370091835, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (84, '越南嫩模与情色女星代言国产网游 惹网友争议', ',30,', '越南嫩模与情色女星代言国产网游 惹网友争议', '图左：莫绮雯，右：Elly近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片《一路向西》出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。', 'admin', '未知', '图左：莫绮雯，右：Elly近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片《一路向西》出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。', '<P align=center><IMG alt=\"越南嫩模与情色女星代言国产网游 惹网友争议\" src=\"http://img1.gtimg.com/ent/pics/hv1/24/55/1340/87147549.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>图左：莫绮雯，右：Elly</P><P style=\"TEXT-INDENT: 2em\">近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片<!--keyword--><!--/keyword-->《一路向西》<!--keyword--><!--/keyword-->出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。</P>', NULL, 1, 0, 0, 1370091837, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (85, '越南嫩模与情色女星代言国产网游 惹网友争议', ',30,', '越南嫩模与情色女星代言国产网游 惹网友争议', '图左：莫绮雯，右：Elly近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片《一路向西》出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。', 'admin', '未知', '图左：莫绮雯，右：Elly近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片《一路向西》出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。', '<P align=center><IMG alt=\"越南嫩模与情色女星代言国产网游 惹网友争议\" src=\"http://img1.gtimg.com/ent/pics/hv1/24/55/1340/87147549.jpg\"></P><P style=\"FONT-FAMILY: 宋体; FONT-SIZE: 10pt\" align=center>图左：莫绮雯，右：Elly</P><P style=\"TEXT-INDENT: 2em\">近日，国内某网游再次使用“肉弹”营销，邀请了曾在国内大红大热的“越南妞”Elly再度来到中国，与在香港3D情色片<!--keyword--><!--/keyword-->《一路向西》<!--keyword--><!--/keyword-->出演“校花”Zoey的内地女演员莫绮雯一起代言网络游戏，并释出双女暧昧试妆照而引发了“网游营销除了美女还是美女”的争议。</P>', NULL, 1, 0, 0, 1370091837, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (86, '组图：台嫩模发行全裸写真 师姐鸡排妹挤胸力挺', ',30,', '组图：台嫩模发行全裸写真 师姐鸡排妹挤胸力挺', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', 'admin', '未知', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', '<!--link--><!--/link--><!--[if !IE]>|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8<![endif]-->\r\n\r\n<!-- 幻灯侧栏广告 -->\r\n<div style=\"position:absolute;margin-left:-30px;margin-top:30px;z-index:10\">\r\n    <!--huandeng_F_clcf_div AD begin....\"l=huandeng_F_clcf&log=off\"-->\n<div id=\"huandeng_F_clcf\" style=\"display:none;\" class=\"l_qq_com\">', NULL, 1, 0, 0, 1370091839, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (87, '组图：台嫩模发行全裸写真 师姐鸡排妹挤胸力挺', ',30,', '组图：台嫩模发行全裸写真 师姐鸡排妹挤胸力挺', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', 'admin', '未知', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', '<!--link--><!--/link--><!--[if !IE]>|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8<![endif]-->\r\n\r\n<!-- 幻灯侧栏广告 -->\r\n<div style=\"position:absolute;margin-left:-30px;margin-top:30px;z-index:10\">\r\n    <!--huandeng_F_clcf_div AD begin....\"l=huandeng_F_clcf&log=off\"-->\n<div id=\"huandeng_F_clcf\" style=\"display:none;\" class=\"l_qq_com\">', NULL, 1, 0, 0, 1370091839, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (88, '邓丽欣玩性大拒绝方力申求婚 大胆革新不做玉女', ',30,', '邓丽欣玩性大拒绝方力申求婚 大胆革新不做玉女', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', 'admin', '未知', '|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8', '<!--link--><!--/link--><!--[if !IE]>|xGv00|0a9d75fd71cae9fdf59ce6a6769dd9a8<![endif]-->\r\n\r\n<!-- 幻灯侧栏广告 -->\r\n<div style=\"position:absolute;margin-left:-30px;margin-top:30px;z-index:10\">\r\n    <!--huandeng_F_clcf_div AD begin....\"l=huandeng_F_clcf&log=off\"-->\n<div id=\"huandeng_F_clcf\" style=\"display:none;\" class=\"l_qq_com\">', NULL, 1, 0, 0, 1370091841, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (122, '甜美的糖果色 点缀时尚生活', ',1,', '甜美的糖果色 点缀时尚生活', '　　做个糖果派的甜美女孩，让时尚漂亮成为你的主旋律，把专属于你的特别淋漓尽致的美丽展现出来！红色赋予女孩自信的魔法。粉嫩的糖果色很可爱，女孩气质展露无遗。', 'admin', '未知', '　　做个糖果派的甜美女孩，让时尚漂亮成为你的主旋律，把专属于你的特别淋漓尽致的美丽展现出来！红色赋予女孩自信的魔法。粉嫩的糖果色很可爱，女孩气质展露无遗。', '<p>　　做个糖果派的甜美女孩，让时尚漂亮成为你的主旋律，把专属于你的特别淋漓尽致的美丽展现出来！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"甜美的糖果色 点缀时尚生活\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/F2125545429.jpg\" /></p>\r\n<p style=\"text-align: center\">红色赋予女孩自信的魔法。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"甜美的糖果色 点缀时尚生活\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/7A125548444.jpg\" /></p>\r\n<p style=\"text-align: center\">粉嫩的糖果色很可爱，女孩气质展露无遗。</p>', NULL, 1, 0, 0, 1370103773, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (123, '清爽时尚搭配 做精致小美女', ',1,', '清爽时尚搭配 做精致小美女', '　　文静气质的时尚打扮图片，一款条纹针织上衣面料非常舒服肩部洞洞眼很透气哦，条纹是不变的经典元素哦。　　粉嫩的冰激凌色,小房子图案,非常可爱活泼哦包边的设计!', 'admin', '未知', '　　文静气质的时尚打扮图片，一款条纹针织上衣面料非常舒服肩部洞洞眼很透气哦，条纹是不变的经典元素哦。　　粉嫩的冰激凌色,小房子图案,非常可爱活泼哦包边的设计!', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"清爽时尚搭配 做精致小美女\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/6312490525.jpg\" /></p>\r\n<p>　　文静气质的时尚打扮图片，一款条纹针织上衣 面料非常舒服 肩部洞洞眼很透气哦，条纹是不变的经典元素哦。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"清爽时尚搭配 做精致小美女\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/7212492284.jpg\" /></p>\r\n<p>　　粉嫩的冰激凌色,小房子图案,非常可爱活泼哦 包边的设计!</p>', NULL, 1, 0, 0, 1370103773, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (124, '宽臀女生搭配 夏日必瘦穿衣法则', ',1,', '宽臀女生搭配 夏日必瘦穿衣法则', '　　细看美国偶像剧里那些花季少女们，哪个不是清新亮丽的色彩美搭，如今一直强调素色淡雅的日系美搭也开始越来越鲜艳喽，不仅衬托出女生的甜美俏丽，利落的短款搭配也让臀型较肥宽的姑娘们们圆了苗条身材的美梦，赶紧来看看吧!　　将上衣塞进短裙中的穿法既可以制造利落的身型，又能从视觉上让你看起来更加凹凸有型，这样的短搭还可以凸显更为细直的美腿呢，姑娘们赶紧试试吧!　　上身越蓬松，臀型就越紧实利落，所以感觉臀型已', 'admin', '未知', '　　细看美国偶像剧里那些花季少女们，哪个不是清新亮丽的色彩美搭，如今一直强调素色淡雅的日系美搭也开始越来越鲜艳喽，不仅衬托出女生的甜美俏丽，利落的短款搭配也让臀型较肥宽的姑娘们们圆了苗条身材的美梦，赶紧来看看吧!　　将上衣塞进短裙中的穿法既可以制造利落的身型，又能从视觉上让你看起来更加凹凸有型，这样的短搭还可以凸显更为细直的美腿呢，姑娘们赶紧试试吧!　　上身越蓬松，臀型就越紧实利落，所以感觉臀型已', '<p>　　细看美国偶像剧里那些花季少女们，哪个不是清新亮丽的色彩美搭，如今一直强调素色淡雅的日系美搭也开始越来越鲜艳喽，不仅衬托出女生的甜美俏丽，利落的短款搭配也让臀型较肥宽的姑娘们们圆了苗条身材的美梦，赶紧来看看吧!</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"宽臀女生搭配 夏日必瘦穿衣法则\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/EF124511103.jpg\" /></p>\r\n<p>　　将上衣塞进短裙中的穿法既可以制造利落的身型，又能从视觉上让你看起来更加凹凸有型，这样的短搭还可以凸显更为细直的美腿呢，姑娘们赶紧试试吧!</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"宽臀女生搭配 夏日必瘦穿衣法则\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/FD124515372.jpg\" /></p>\r\n<p>　　上身越蓬松，臀型就越紧实利落，所以感觉臀型已经不够收紧略显松垮肥胖的MM们不妨选择蓬松大摆袖装的上衣，转移臃肿宽P的视线，扮高显瘦两不误。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"宽臀女生搭配 夏日必瘦穿衣法则\" src=\"http://www.mimito.com.cn/uploadfile/201305/23/83124516329.jpg\" /></p>\r\n<p>　　A型短裤最适合臀部肥胖的女生拿来遮肉，当然也是显瘦显高的不二法宝，搭配略带膨胀感的上衣，让身型更加匀称有致，超有日系范儿的编织圆帽更有清新气质哦。</p>', NULL, 1, 0, 0, 1370103774, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (125, '都市小资洒脱街搭 凸显夏季清爽', ',1,', '都市小资洒脱街搭 凸显夏季清爽', '都市小资洒脱街搭凸显夏季清爽都市小资洒脱街搭凸显夏季清爽', 'admin', '未知', '都市小资洒脱街搭凸显夏季清爽都市小资洒脱街搭凸显夏季清爽', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"都市小资洒脱街搭 凸显夏季清爽\" src=\"http://www.mimito.com.cn/uploadfile/201305/22/96223852893.jpg\" /></p>\r\n<p style=\"text-align: center\">都市小资洒脱街搭 凸显夏季清爽</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"都市小资洒脱街搭 凸显夏季清爽\" src=\"http://www.mimito.com.cn/uploadfile/201305/22/4B223855989.jpg\" /></p>\r\n<p style=\"text-align: center\">都市小资洒脱街搭 凸显夏季清爽</p>', NULL, 1, 0, 0, 1370103774, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (126, '人人都爱小黑裙 穿出好气质', ',1,', '人人都爱小黑裙 穿出好气质', '人人都爱小黑裙穿出好气质人人都爱小黑裙穿出好气质', 'admin', '未知', '人人都爱小黑裙穿出好气质人人都爱小黑裙穿出好气质', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"人人都爱小黑裙 穿出好气质\" src=\"http://www.mimito.com.cn/uploadfile/201305/21/159219875.jpg\" /></p>\r\n<p style=\"text-align: center\">人人都爱小黑裙 穿出好气质</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"人人都爱小黑裙 穿出好气质\" src=\"http://www.mimito.com.cn/uploadfile/201305/21/B39219982.jpg\" /></p>\r\n<p style=\"text-align: center\">人人都爱小黑裙 穿出好气质</p>', NULL, 1, 0, 0, 1370103775, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (127, '午夜的玫瑰：10款性感夜店装穿搭', ',1,', '午夜的玫瑰：10款性感夜店装穿搭', '　　短暂的夜被美艳如玫瑰的倩影点燃，混杂着劲爆的舞曲，激情的鸡尾酒，似一幕开放、张扬的都市剧热辣上映。争奇斗艳的猎艳场上，若不性感，中规中矩给谁看?午夜的玫瑰：10款性感夜店装穿搭午夜的玫瑰：10款性感夜店装穿搭', 'admin', '未知', '　　短暂的夜被美艳如玫瑰的倩影点燃，混杂着劲爆的舞曲，激情的鸡尾酒，似一幕开放、张扬的都市剧热辣上映。争奇斗艳的猎艳场上，若不性感，中规中矩给谁看?午夜的玫瑰：10款性感夜店装穿搭午夜的玫瑰：10款性感夜店装穿搭', '<p>　　短暂的夜被美艳如玫瑰的倩影点燃，混杂着劲爆的舞曲，激情的鸡尾酒，似一幕开放、张扬的都市剧热辣上映。争奇斗艳的猎艳场上，若不性感，中规中矩给谁看?</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"午夜的玫瑰：10款性感夜店装穿搭\" src=\"http://www.mimito.com.cn/uploadfile/201305/20/18224513698.jpg\" /></p>\r\n<p style=\"text-align: center\">午夜的玫瑰：10款性感夜店装穿搭</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"午夜的玫瑰：10款性感夜店装穿搭\" src=\"http://www.mimito.com.cn/uploadfile/201305/20/C3224515925.jpg\" /></p>\r\n<p style=\"text-align: center\">午夜的玫瑰：10款性感夜店装穿搭</p>', NULL, 1, 0, 0, 1370103779, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (128, '一件衣服多种搭配 今夏最潮穿法', ',1,', '一件衣服多种搭配 今夏最潮穿法', '　　谁能巧妙地将眼下潮流服饰货整洁，或休闲的进行穿搭，谁就是称霸夏天的时髦女王！现在就来参考一下韩国女生们的真实式样，寻找让男生臣服在石榴裙下的最新技巧吧。卷边牛仔短裤与细绳腰带，帆布鞋玩酷感十足白色的半透明连帽衫让牛仔也温柔起来', 'admin', '未知', '　　谁能巧妙地将眼下潮流服饰货整洁，或休闲的进行穿搭，谁就是称霸夏天的时髦女王！现在就来参考一下韩国女生们的真实式样，寻找让男生臣服在石榴裙下的最新技巧吧。卷边牛仔短裤与细绳腰带，帆布鞋玩酷感十足白色的半透明连帽衫让牛仔也温柔起来', '<p>　　谁能巧妙地将眼下潮流服饰货整洁，或休闲的进行穿搭，谁就是称霸夏天的时髦女王！现在就来参考一下韩国女生们的真实式样，寻找让男生臣服在石榴裙下的最新技巧吧。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"一件衣服多种搭配 今夏最潮穿法\" src=\"http://www.mimito.com.cn/uploadfile/201305/20/2022954506.jpg\" /></p>\r\n<p style=\"text-align: center\">卷边牛仔短裤与细绳腰带，帆布鞋玩酷感十足</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"一件衣服多种搭配 今夏最潮穿法\" src=\"http://www.mimito.com.cn/uploadfile/201305/20/2122956460.jpg\" /></p>\r\n<p style=\"text-align: center\">白色的半透明连帽衫让牛仔也温柔起来</p>', NULL, 1, 0, 0, 1370103779, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (129, '甜美性感包臀裙 好身材秀出来', ',1,', '甜美性感包臀裙 好身材秀出来', '　　几何图案OL风连衣裙，完美的板型，完全不挑人，看到这条裙子的第一眼就被吸引住了，黑白相间，也是最能体验神秘浪漫气质的色调，优雅是肯定的，还会有俏皮甜美的感觉哦。　　蕾丝拼接包臀弹性连衣裙，雪纺的清新可人与蕾丝的性感优雅结合起来，柔美秀气里带着几分性感迷人。', 'admin', '未知', '　　几何图案OL风连衣裙，完美的板型，完全不挑人，看到这条裙子的第一眼就被吸引住了，黑白相间，也是最能体验神秘浪漫气质的色调，优雅是肯定的，还会有俏皮甜美的感觉哦。　　蕾丝拼接包臀弹性连衣裙，雪纺的清新可人与蕾丝的性感优雅结合起来，柔美秀气里带着几分性感迷人。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"甜美性感包臀裙 好身材秀出来\" src=\"http://www.mimito.com.cn/uploadfile/201305/15/1F2115643.jpg\" /></p>\r\n<p>　　几何图案OL风连衣裙，完美的板型，完全不挑人，看到这条裙子的第一眼就被吸引住了，黑白相间，也是最能体验神秘浪漫气质的色调，优雅是肯定的，还会有俏皮甜美的感觉哦。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"甜美性感包臀裙 好身材秀出来\" src=\"http://www.mimito.com.cn/uploadfile/201305/15/702116177.jpg\" /></p>\r\n<p>　　蕾丝拼接包臀弹性连衣裙，雪纺的清新可人与蕾丝的性感优雅结合起来，柔美秀气里带着几分性感迷人。</p>', NULL, 1, 0, 0, 1370103780, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (130, '2013春夏蕾丝连衣裙 凸显夏日风情', ',1,', '2013春夏蕾丝连衣裙 凸显夏日风情', '　　蕾丝之于女人就如鲜花之于绿叶一样要组合在一起才能彰显其无与伦比的魅力。夏天我们都爱穿得清凉又不失女人味，蕾丝服饰便成了女生衣橱里的主角，连衣裙更是女生们施展风情的必备。　　蕾丝里的花朵图案充满了宫廷美感，配上裙身上的精美小碎花尽显甜美，也装扮得人淑女味十足。　　浪漫的花纹，简洁的设计清新典雅又时尚大方，适穿的场合也非常之广泛。', 'admin', '未知', '　　蕾丝之于女人就如鲜花之于绿叶一样要组合在一起才能彰显其无与伦比的魅力。夏天我们都爱穿得清凉又不失女人味，蕾丝服饰便成了女生衣橱里的主角，连衣裙更是女生们施展风情的必备。　　蕾丝里的花朵图案充满了宫廷美感，配上裙身上的精美小碎花尽显甜美，也装扮得人淑女味十足。　　浪漫的花纹，简洁的设计清新典雅又时尚大方，适穿的场合也非常之广泛。', '<p>　　蕾丝之于女人就如鲜花之于绿叶一样要组合在一起才能彰显其无与伦比的魅力。夏天我们都爱穿得清凉又不失女人味，蕾丝服饰便成了女生衣橱里的主角，连衣裙更是女生们施展风情的必备。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"2013春夏蕾丝连衣裙 凸显夏日风情\" src=\"http://www.mimito.com.cn/uploadfile/201305/15/DA15120500.jpg\" /></p>\r\n<p>　　蕾丝里的花朵图案充满了宫廷美感，配上裙身上的精美小碎花尽显甜美，也装扮得人淑女味十足。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"2013春夏蕾丝连衣裙 凸显夏日风情\" src=\"http://www.mimito.com.cn/uploadfile/201305/15/9315121875.jpg\" /></p>\r\n<p>　　浪漫的花纹，简洁的设计清新典雅又时尚大方，适穿的场合也非常之广泛。</p>', NULL, 1, 0, 0, 1370103781, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (131, '优雅OL气质短袖 夏日最清新', ',1,', '优雅OL气质短袖 夏日最清新', '　　修身绣花蕾丝短袖，柔软弹力好的长绒棉针织面料配上精致的网纱珠片绣花，很适合文雅清新的姑娘，版型修身又不太紧，裤子裙子都好搭。　　百搭修身长款T恤，简洁的领型，分割式的设计，可以拉长下半身的比例很显瘦哦。这款版型较为宽松，无论是内搭还是外穿看起来都很精神。', 'admin', '未知', '　　修身绣花蕾丝短袖，柔软弹力好的长绒棉针织面料配上精致的网纱珠片绣花，很适合文雅清新的姑娘，版型修身又不太紧，裤子裙子都好搭。　　百搭修身长款T恤，简洁的领型，分割式的设计，可以拉长下半身的比例很显瘦哦。这款版型较为宽松，无论是内搭还是外穿看起来都很精神。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"优雅OL气质短袖 夏日最清新\" src=\"http://www.mimito.com.cn/uploadfile/201305/13/B10315262.jpg\" /></p>\r\n<p>　　修身绣花蕾丝短袖，柔软弹力好的长绒棉针织面料配上精致的网纱珠片绣花，很适合文雅清新的姑娘，版型修身又不太紧，裤子裙子都好搭。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"优雅OL气质短袖 夏日最清新\" src=\"http://www.mimito.com.cn/uploadfile/201305/13/C80328790.jpg\" /></p>\r\n<p>　　百搭修身长款T恤，简洁的领型，分割式的设计，可以拉长下半身的比例很显瘦哦。这款版型较为宽松，无论是内搭还是外穿看起来都很精神。</p>', NULL, 1, 0, 0, 1370103781, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (132, '微胖女生夏天这么搭最美！', ',1,', '微胖女生夏天这么搭最美！', '　　夏天来了，小肚肚上的肉经过一冬的安逸开始小&ldquo;露&rdquo;出来了，不要慌，看小编为你精选六款遮肉美衣，让你显瘦一夏哦。 微胖女生夏天这么搭最美！ 微胖女生夏天这么搭最美！', 'admin', '未知', '　　夏天来了，小肚肚上的肉经过一冬的安逸开始小&ldquo;露&rdquo;出来了，不要慌，看小编为你精选六款遮肉美衣，让你显瘦一夏哦。 微胖女生夏天这么搭最美！ 微胖女生夏天这么搭最美！', '<p>　　夏天来了，小肚肚上的肉经过一冬的安逸开始小&ldquo;露&rdquo;出来了，不要慌，看小编为你精选六款遮肉美衣，让你显瘦一夏哦。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"微胖女生夏天这么搭最美！\" src=\"http://www.mimito.com.cn/uploadfile/201305/12/7E235711976.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;微胖女生夏天这么搭最美！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"微胖女生夏天这么搭最美！\" src=\"http://www.mimito.com.cn/uploadfile/201305/12/33235715546.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;微胖女生夏天这么搭最美！</p>', NULL, 1, 0, 0, 1370103781, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (133, '个性街头酷酷女 潮范搭配你最HOT', ',1,', '个性街头酷酷女 潮范搭配你最HOT', '　　夏天就应该是爱玩浮夸的季节，缤纷的色彩，别致的剪裁，都能让你脱颖而出，灿烂的搭配能让你的心情也变得明亮起来。个性街头酷酷女潮范搭配你最HOT个性街头酷酷女潮范搭配你最HOT', 'admin', '未知', '　　夏天就应该是爱玩浮夸的季节，缤纷的色彩，别致的剪裁，都能让你脱颖而出，灿烂的搭配能让你的心情也变得明亮起来。个性街头酷酷女潮范搭配你最HOT个性街头酷酷女潮范搭配你最HOT', '<p>　　夏天就应该是爱玩浮夸的季节，缤纷的色彩，别致的剪裁，都能让你脱颖而出，灿烂的搭配能让你的心情也变得明亮起来。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"个性街头酷酷女 潮范搭配你最HOT\" src=\"http://www.mimito.com.cn/uploadfile/201305/10/65184258771.jpg\" /></p>\r\n<p style=\"text-align: center\">个性街头酷酷女 潮范搭配你最HOT</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"个性街头酷酷女 潮范搭配你最HOT\" src=\"http://www.mimito.com.cn/uploadfile/201305/10/8E18432789.jpg\" /></p>\r\n<p style=\"text-align: center\">个性街头酷酷女 潮范搭配你最HOT</p>', NULL, 1, 0, 0, 1370103782, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (134, '雪纺连衣裙 小清新浪漫“必杀技”', ',1,', '雪纺连衣裙 小清新浪漫“必杀技”', ' 　　性感露肩燕尾式双层荷叶边长裙，前面开叉设计比较特别，荷叶边也很漂亮，无里布面料有点小垂。 　　甜美U型领蓬蓬娃娃宽松连衣裙，很特别的领子U型的哦，宽松的款式，不挑人，上身效果非常赞噢，粗雪纺质地。', 'admin', '未知', ' 　　性感露肩燕尾式双层荷叶边长裙，前面开叉设计比较特别，荷叶边也很漂亮，无里布面料有点小垂。 　　甜美U型领蓬蓬娃娃宽松连衣裙，很特别的领子U型的哦，宽松的款式，不挑人，上身效果非常赞噢，粗雪纺质地。', '<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"雪纺连衣裙 小清新浪漫“必杀技”\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/6013256280.jpg\" /></p>\r\n<p>　　性感露肩燕尾式双层荷叶边长裙，前面开叉设计比较特别，荷叶边也很漂亮，无里布面料有点小垂。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"雪纺连衣裙 小清新浪漫“必杀技”\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/18132539125.jpg\" /></p>\r\n<p>　　甜美U型领蓬蓬娃娃宽松连衣裙，很特别的领子U型的哦，宽松的款式，不挑人，上身效果非常赞噢，粗雪纺质地。</p>', NULL, 1, 0, 0, 1370103782, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (135, '防晒衫娇美搭 遮阳防晒遮赘肉', ',1,', '防晒衫娇美搭 遮阳防晒遮赘肉', '　　一件小小的防晒衫外套在夏季是必备的，而款式也随着时代变迁而变的多样，它的大作用在于防晒的同时还能遮掩身上的赘肉，让你熊腰粗臂通通消失掉。防晒衫娇美搭遮阳防晒遮赘肉防晒衫娇美搭遮阳防晒遮赘肉', 'admin', '未知', '　　一件小小的防晒衫外套在夏季是必备的，而款式也随着时代变迁而变的多样，它的大作用在于防晒的同时还能遮掩身上的赘肉，让你熊腰粗臂通通消失掉。防晒衫娇美搭遮阳防晒遮赘肉防晒衫娇美搭遮阳防晒遮赘肉', '<p>　　一件小小的防晒衫外套在夏季是必备的，而款式也随着时代变迁而变的多样，它的大作用在于防晒的同时还能遮掩身上的赘肉，让你熊腰粗臂通通消失掉。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"防晒衫娇美搭 遮阳防晒遮赘肉\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/9D111118478.jpg\" /></p>\r\n<p style=\"text-align: center\">防晒衫娇美搭 遮阳防晒遮赘肉</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"防晒衫娇美搭 遮阳防晒遮赘肉\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/AB111124619.jpg\" /></p>\r\n<p style=\"text-align: center\">防晒衫娇美搭 遮阳防晒遮赘肉</p>', NULL, 1, 0, 0, 1370103783, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (136, '性感蕾丝连衣裙 隐隐透视风才迷人', ',1,', '性感蕾丝连衣裙 隐隐透视风才迷人', '　　勾花朵绣圈圈刺绣连衣，精致的刺绣工艺，有着浮雕般的质感，花瓣处的衔接都处理的恰到好处，手工的缝制的立体花朵，层次分明，动感十足，娇艳欲滴。　　韩版时尚灯笼袖蕾丝连衣裙，塑造完美的小蛮腰，蓬蓬的下摆，凸显曼妙的身材曲线，美不胜收，点缀的蕾丝小花边，增添浪漫女人味，精致高档的内衬，让你享受到高品位生活。', 'admin', '未知', '　　勾花朵绣圈圈刺绣连衣，精致的刺绣工艺，有着浮雕般的质感，花瓣处的衔接都处理的恰到好处，手工的缝制的立体花朵，层次分明，动感十足，娇艳欲滴。　　韩版时尚灯笼袖蕾丝连衣裙，塑造完美的小蛮腰，蓬蓬的下摆，凸显曼妙的身材曲线，美不胜收，点缀的蕾丝小花边，增添浪漫女人味，精致高档的内衬，让你享受到高品位生活。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"性感蕾丝连衣裙 隐隐透视风才迷人\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/C394031420.jpg\" /></p>\r\n<p>　　勾花朵绣圈圈刺绣连衣，精致的刺绣工艺，有着浮雕般的质感，花瓣处的衔接都处理的恰到好处，手工的缝制的立体花朵，层次分明，动感十足，娇艳欲滴。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"性感蕾丝连衣裙 隐隐透视风才迷人\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/4C94034719.jpg\" /></p>\r\n<p>　　韩版时尚灯笼袖蕾丝连衣裙，塑造完美的小蛮腰，蓬蓬的下摆，凸显曼妙的身材曲线，美不胜收，点缀的蕾丝小花边，增添浪漫女人味，精致高档的内衬，让你享受到高品位生活。</p>', NULL, 1, 0, 0, 1370103783, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (137, '五月名媛范大气混搭 让身材零缺陷', ',1,', '五月名媛范大气混搭 让身材零缺陷', '　　千变的衣衫成就了街头美不胜收的好&ldquo;风景&rdquo;，简单的搭配就能打造满分的小名媛，一起来看看吧。 五月名媛范大气混搭让身材零缺陷 五月名媛范大气混搭让身材零缺陷', 'admin', '未知', '　　千变的衣衫成就了街头美不胜收的好&ldquo;风景&rdquo;，简单的搭配就能打造满分的小名媛，一起来看看吧。 五月名媛范大气混搭让身材零缺陷 五月名媛范大气混搭让身材零缺陷', '<p>　　千变的衣衫成就了街头美不胜收的好&ldquo;风景&rdquo;，简单的搭配就能打造满分的小名媛，一起来看看吧。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"五月名媛范大气混搭 让身材零缺陷\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/7392915982.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;五月名媛范大气混搭 让身材零缺陷</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"五月名媛范大气混搭 让身材零缺陷\" src=\"http://www.mimito.com.cn/uploadfile/201305/9/4E92920219.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;五月名媛范大气混搭 让身材零缺陷</p>', NULL, 1, 0, 0, 1370103784, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (138, '五款百搭T恤 潮人出街必备', ',1,', '五款百搭T恤 潮人出街必备', '　　猫头鹰图案印花是今年韩国设计流行元素之一，中袖设计，时尚又俏皮可爱.　　宽松的蝙蝠袖设计，透气性好，适应夏天天气热、出汗多的特点，面料柔软、顺滑，触感细腻，更适合贴身穿，最亮之处在于条纹的百搭，让你和任何衣服都能搭出靓丽的装扮。', 'admin', '未知', '　　猫头鹰图案印花是今年韩国设计流行元素之一，中袖设计，时尚又俏皮可爱.　　宽松的蝙蝠袖设计，透气性好，适应夏天天气热、出汗多的特点，面料柔软、顺滑，触感细腻，更适合贴身穿，最亮之处在于条纹的百搭，让你和任何衣服都能搭出靓丽的装扮。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"五款百搭T恤 潮人出街必备\" src=\"http://www.mimito.com.cn/uploadfile/201305/7/34113124317.jpg\" /></p>\r\n<p>　　猫头鹰图案印花是今年韩国设计流行元素之一，中袖设计，时尚又俏皮可爱.</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"五款百搭T恤 潮人出街必备\" src=\"http://www.mimito.com.cn/uploadfile/201305/7/CF113128347.jpg\" /></p>\r\n<p>　　宽松的蝙蝠袖设计，透气性好，适应夏天天气热、出汗多的特点，面料柔软、顺滑，触感细腻，更适合贴身穿，最亮之处在于条纹的百搭，让你和任何衣服都能搭出靓丽的装扮。</p>', NULL, 1, 0, 0, 1370103784, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (139, '六款印花连衣裙 夏日的清新', ',1,', '六款印花连衣裙 夏日的清新', '　　漂亮又华丽的印花能够带来浓浓的夏意，简洁大方的美感，让印花成为流行元素，赶紧为自己添置一条印花连衣裙吧！ 六款印花连衣裙夏日的清新 六款印花连衣裙夏日的清新', 'admin', '未知', '　　漂亮又华丽的印花能够带来浓浓的夏意，简洁大方的美感，让印花成为流行元素，赶紧为自己添置一条印花连衣裙吧！ 六款印花连衣裙夏日的清新 六款印花连衣裙夏日的清新', '<p>\n	　　漂亮又华丽的印花能够带来浓浓的夏意，简洁大方的美感，让印花成为流行元素，赶紧为自己添置一条印花连衣裙吧！\n</p>\n<p style=\"text-align:center;\">\n	<img onload=\"size(this)\" alt=\"六款印花连衣裙 夏日的清新\" src=\"http://www.mimito.com.cn/uploadfile/201305/6/3210398929.jpg\" />\n</p>\n<p style=\"text-align:center;\">\n	&nbsp;六款印花连衣裙 夏日的清新\n</p>\n<p style=\"text-align:center;\">\n	<img onload=\"size(this)\" alt=\"六款印花连衣裙 夏日的清新\" src=\"http://www.mimito.com.cn/uploadfile/201305/6/98103911224.jpg\" />\n</p>\n<p style=\"text-align:center;\">\n	&nbsp;六款印花连衣裙 夏日的清新\n</p>', 'uploadfiles/images/20130607/3fddd5eca4619dfd1e42fd3185624d79.jpg', 1, 1, 0, 1370103785, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (140, '宽松上衣简约搭 打造心机美人', ',1,', '宽松上衣简约搭 打造心机美人', '　　时尚惹眼是每个女孩的梦想，潮人巧用时尚宽松上衣就可以轻松搭配出清爽时髦的造型。宽松的上衣能够将你的骨架适度的包裹，搭配紧身裤装或者个性的Leggings让整个人变得小巧玲珑哦！ 宽松上衣简约搭打造心机美人 宽松上衣简约搭打造心机美人', 'admin', '未知', '　　时尚惹眼是每个女孩的梦想，潮人巧用时尚宽松上衣就可以轻松搭配出清爽时髦的造型。宽松的上衣能够将你的骨架适度的包裹，搭配紧身裤装或者个性的Leggings让整个人变得小巧玲珑哦！ 宽松上衣简约搭打造心机美人 宽松上衣简约搭打造心机美人', '<p>　　时尚惹眼是每个女孩的梦想，潮人巧用时尚宽松上衣就可以轻松搭配出清爽时髦的造型。宽松的上衣能够将你的骨架适度的包裹，搭配紧身裤装或者个性的Leggings让整个人变得小巧玲珑哦！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"宽松上衣简约搭 打造心机美人\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/2719136288.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;宽松上衣简约搭 打造心机美人</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"宽松上衣简约搭 打造心机美人\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/9619138550.jpg\" /></p>\r\n<p style=\"text-align: center\">&nbsp;宽松上衣简约搭 打造心机美人</p>', NULL, 1, 2, 0, 1370103785, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (141, '优雅连衣裙 穿出端庄淑女范儿', ',1,', '优雅连衣裙 穿出端庄淑女范儿', ' 　　这款短袖蕾丝连衣裙，时尚优雅的白色与宝蓝色拼接，精致的领口镂空，让你性感温柔的气息。 　　韩版蕾丝连衣裙，淡淡优雅浅蓝色，蕾丝网纱拼接设计，甜美的娃娃领，上身衬托出白皙皮肤的款。', 'admin', '未知', ' 　　这款短袖蕾丝连衣裙，时尚优雅的白色与宝蓝色拼接，精致的领口镂空，让你性感温柔的气息。 　　韩版蕾丝连衣裙，淡淡优雅浅蓝色，蕾丝网纱拼接设计，甜美的娃娃领，上身衬托出白皙皮肤的款。', '<p style=\"text-align:center;\">\n	&nbsp;<img onload=\"size(this)\" alt=\"优雅连衣裙 穿出端庄淑女范儿\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/76135540556.jpg\" />\n</p>\n<p>\n	　　这款短袖蕾丝连衣裙，时尚优雅的白色与宝蓝色拼接，精致的领口镂空，让你性感温柔的气息。\n</p>\n<p style=\"text-align:center;\">\n	&nbsp;<img onload=\"size(this)\" alt=\"优雅连衣裙 穿出端庄淑女范儿\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/30135544710.jpg\" />\n</p>\n<p>\n	　　韩版蕾丝连衣裙，淡淡优雅浅蓝色，蕾丝网纱拼接设计，甜美的娃娃领，上身衬托出白皙皮肤的款。\n</p>', 'uploadfiles/images/20130607/df8b962e6cd1337b98a313ba65748a79.jpg', 1, 9, 0, 1370103785, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (142, '8款飘逸连衣裙 释放甜美诱惑', ',31,', '8款飘逸连衣裙 释放甜美诱惑', '　　飘逸的雪纺既能增添神秘感，又毫无疑问的展示了女人味。在低调气质中让你优雅绽放。 　　简约，小性感，完美表达出都市女性的柔美和休闲，版型设计和用料都有一定的修饰身型能力，花灰色的布料，使露出的肩膀皮肤更显娇嫩。', 'admin', '未知', '　　飘逸的雪纺既能增添神秘感，又毫无疑问的展示了女人味。在低调气质中让你优雅绽放。 　　简约，小性感，完美表达出都市女性的柔美和休闲，版型设计和用料都有一定的修饰身型能力，花灰色的布料，使露出的肩膀皮肤更显娇嫩。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"8款飘逸连衣裙 释放甜美诱惑\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/CF13437487.jpg\" /></p>\r\n<p>　　飘逸的雪纺既能增添神秘感，又毫无疑问的展示了女人味。在低调气质中让你优雅绽放。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"8款飘逸连衣裙 释放甜美诱惑\" src=\"http://www.mimito.com.cn/uploadfile/201305/4/62134310988.jpg\" /></p>\r\n<p>　　简约，小性感，完美表达出都市女性的柔美和休闲，版型设计和用料都有一定的修饰身型能力，花灰色的布料，使露出的肩膀皮肤更显娇嫩。</p>', NULL, 1, 1, 0, 1370103830, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (143, '5月时尚潮人秀 牛仔连衣裙', ',31,', '5月时尚潮人秀 牛仔连衣裙', ' 　　无袖肩章牛仔连衣裙，简约时尚单排扣，胸前口袋设计，包臀的裁剪，尽显婀娜多姿的身段。 　　立体3D刺绣牛仔连衣裙，胸前时尚的图案，提升的视觉美感，浅蓝色水洗牛仔，出色的穿着效果，久久不能忘怀。', 'admin', '未知', ' 　　无袖肩章牛仔连衣裙，简约时尚单排扣，胸前口袋设计，包臀的裁剪，尽显婀娜多姿的身段。 　　立体3D刺绣牛仔连衣裙，胸前时尚的图案，提升的视觉美感，浅蓝色水洗牛仔，出色的穿着效果，久久不能忘怀。', '<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"5月时尚潮人秀 牛仔连衣裙\" src=\"http://www.mimito.com.cn/uploadfile/201305/3/05145621151.jpg\" /></p>\r\n<p>　　无袖肩章牛仔连衣裙，简约时尚单排扣，胸前口袋设计，包臀的裁剪，尽显婀娜多姿的身段。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"5月时尚潮人秀 牛仔连衣裙\" src=\"http://www.mimito.com.cn/uploadfile/201305/3/78145629339.jpg\" /></p>\r\n<p>　　立体3D刺绣牛仔连衣裙，胸前时尚的图案，提升的视觉美感，浅蓝色水洗牛仔，出色的穿着效果，久久不能忘怀。</p>', NULL, 1, 0, 0, 1370103830, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (144, '风格各异雪纺衫 随性搭出修身感', ',31,', '风格各异雪纺衫 随性搭出修身感', '       入夏时尚主角是雪纺衫，印花，纯色，拼接，宽松，复古等不同风格的雪纺衫，成为夏季衣橱的主角。 　　假两件式的设计，宽松的款式，简洁大方的圆领，亮丽的糖果色，青春活力四射。 　　撞色经典的翻领，修饰脸型又减龄，别出心裁纽扣套头款式，亮丽的复古缤纷印花图案，上身效果非常的不错。', 'admin', '未知', '       入夏时尚主角是雪纺衫，印花，纯色，拼接，宽松，复古等不同风格的雪纺衫，成为夏季衣橱的主角。 　　假两件式的设计，宽松的款式，简洁大方的圆领，亮丽的糖果色，青春活力四射。 　　撞色经典的翻领，修饰脸型又减龄，别出心裁纽扣套头款式，亮丽的复古缤纷印花图案，上身效果非常的不错。', '<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 入夏时尚主角是雪纺衫，印花，纯色，拼接，宽松，复古等不同风格的雪纺衫，成为夏季衣橱的主角。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"风格各异雪纺衫 随性搭出修身感\" src=\"http://www.mimito.com.cn/uploadfile/201305/3/5F14517307.jpg\" /></p>\r\n<p>　　假两件式的设计，宽松的款式，简洁大方的圆领，亮丽的糖果色，青春活力四射。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"风格各异雪纺衫 随性搭出修身感\" src=\"http://www.mimito.com.cn/uploadfile/201305/3/F114519325.jpg\" /></p>\r\n<p>　　撞色经典的翻领，修饰脸型又减龄，别出心裁纽扣套头款式，亮丽的复古缤纷印花图案，上身效果非常的不错。</p>', NULL, 1, 0, 0, 1370103831, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (145, '性感迷人连衣裙 小女人最爱', ',31,', '性感迷人连衣裙 小女人最爱', '　　甜美的连衣裙，橘红的底色加上彩色的菱形格纹非常的耀眼活泼，可以加针织衫搭配哦。很气质，裙子有内衬的，不透的哦，吊带长度是可以调节的。　　公主风的连衣裙,超美超梦幻哦,上身是镂空的针织勾花,很唯美.下身是三层蕾丝的,不是很软,有一定硬度才会有型哦.非常美的裙子。', 'admin', '未知', '　　甜美的连衣裙，橘红的底色加上彩色的菱形格纹非常的耀眼活泼，可以加针织衫搭配哦。很气质，裙子有内衬的，不透的哦，吊带长度是可以调节的。　　公主风的连衣裙,超美超梦幻哦,上身是镂空的针织勾花,很唯美.下身是三层蕾丝的,不是很软,有一定硬度才会有型哦.非常美的裙子。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"性感迷人连衣裙 小女人最爱\" src=\"http://www.mimito.com.cn/uploadfile/201305/2/9B134932898.jpg\" /></p>\r\n<p>　　甜美的连衣裙，橘红的底色加上彩色的菱形格纹非常的耀眼活泼，可以加针织衫搭配哦。很气质，裙子有内衬的，不透的哦，吊带长度是可以调节的。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"性感迷人连衣裙 小女人最爱\" src=\"http://www.mimito.com.cn/uploadfile/201305/2/2E134941770.jpg\" /></p>\r\n<p>　　公主风的连衣裙,超美超梦幻哦,上身是镂空的针织勾花,很唯美.下身是三层蕾丝的,不是很软,有一定硬度才会有型哦. 非常美的裙子。</p>', NULL, 1, 2, 0, 1370103832, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (146, '春夏潮流T恤 简约学院风', ',31,', '春夏潮流T恤 简约学院风', ' 　　宽松韩版可爱人物短袖t恤，超有范儿的哦，简约好搭呢，一条牛仔裤或者短裤就搞定啦。 　　简约时尚缝制订珠字母，纯色的棉质T恤衫，单穿或是内搭都可以的哦', 'admin', '未知', ' 　　宽松韩版可爱人物短袖t恤，超有范儿的哦，简约好搭呢，一条牛仔裤或者短裤就搞定啦。 　　简约时尚缝制订珠字母，纯色的棉质T恤衫，单穿或是内搭都可以的哦', '<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"春夏潮流T恤 简约学院风\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/91202618934.jpg\" /></p>\r\n<p>　　宽松韩版可爱人物短袖t恤，超有范儿的哦，简约好搭呢，一条牛仔裤或者短裤就搞定啦。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"春夏潮流T恤 简约学院风\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/47202625775.jpg\" /></p>\r\n<p>　　简约时尚缝制订珠字母，纯色的棉质T恤衫，单穿或是内搭都可以的哦</p>', NULL, 1, 0, 0, 1370103832, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (147, '90后麻豆美搭 缤纷时尚赚足回头率', ',31,', '90后麻豆美搭 缤纷时尚赚足回头率', '　　春季已经快到尾巴，夏天就不远了，应该考虑丰富衣橱的时候到了。今天推荐几款时尚最新单品，一起来看看吧！90后麻豆美搭缤纷时尚赚足回头率90后麻豆美搭缤纷时尚赚足回头率', 'admin', '未知', '　　春季已经快到尾巴，夏天就不远了，应该考虑丰富衣橱的时候到了。今天推荐几款时尚最新单品，一起来看看吧！90后麻豆美搭缤纷时尚赚足回头率90后麻豆美搭缤纷时尚赚足回头率', '<p>　　春季已经快到尾巴，夏天就不远了，应该考虑丰富衣橱的时候到了。今天推荐几款时尚最新单品，一起来看看吧！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"90后麻豆美搭 缤纷时尚赚足回头率\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/C6202011857.jpg\" /></p>\r\n<p style=\"text-align: center\">90后麻豆美搭 缤纷时尚赚足回头率</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"90后麻豆美搭 缤纷时尚赚足回头率\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/D2202012250.jpg\" /></p>\r\n<p style=\"text-align: center\">90后麻豆美搭 缤纷时尚赚足回头率</p>', NULL, 1, 2, 0, 1370103833, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (148, '轻盈雪纺衫 穿出迷人优雅气质', ',31,', '轻盈雪纺衫 穿出迷人优雅气质', '　　春夏季，正是雪纺衫正当时，轻盈的质地，柔软的面料，总能带给你舒适美妙的体验。推荐几款百元内优雅气质雪纺衫，让你穿出迷人女人味！轻盈雪纺衫穿出迷人优雅气质轻盈雪纺衫穿出迷人优雅气质', 'admin', '未知', '　　春夏季，正是雪纺衫正当时，轻盈的质地，柔软的面料，总能带给你舒适美妙的体验。推荐几款百元内优雅气质雪纺衫，让你穿出迷人女人味！轻盈雪纺衫穿出迷人优雅气质轻盈雪纺衫穿出迷人优雅气质', '<p>　　春夏季，正是雪纺衫正当时，轻盈的质地，柔软的面料，总能带给你舒适美妙的体验。推荐几款百元内优雅气质雪纺衫，让你穿出迷人女人味！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"轻盈雪纺衫 穿出迷人优雅气质\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/22154040493.jpg\" /></p>\r\n<p style=\"text-align: center\">轻盈雪纺衫 穿出迷人优雅气质</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"轻盈雪纺衫 穿出迷人优雅气质\" src=\"http://www.mimito.com.cn/uploadfile/201304/26/08154044711.jpg\" /></p>\r\n<p style=\"text-align: center\">轻盈雪纺衫 穿出迷人优雅气质</p>', NULL, 1, 3, 0, 1370103833, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (149, '超显嫩！8款清新学院风美搭配', ',31,', '超显嫩！8款清新学院风美搭配', '　　复古小清新圆点背带裙，非常显瘦的一款背带裙哦，下半身的裙子做成了包臀裙的设计，使得这款背带裙有了一点时尚OL范儿。 　　娃娃领荷叶边无袖披肩雪纺衫，斗篷披肩的度独特设计，不对称美色款式，时尚中又有性感的味道，紧致立体的飘逸荷叶很是甜美欧美公主范。', 'admin', '未知', '　　复古小清新圆点背带裙，非常显瘦的一款背带裙哦，下半身的裙子做成了包臀裙的设计，使得这款背带裙有了一点时尚OL范儿。 　　娃娃领荷叶边无袖披肩雪纺衫，斗篷披肩的度独特设计，不对称美色款式，时尚中又有性感的味道，紧致立体的飘逸荷叶很是甜美欧美公主范。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"超显嫩！8款清新学院风美搭配\" src=\"http://www.mimito.com.cn/uploadfile/201304/25/1D23319369.jpg\" /></p>\r\n<p>　　复古小清新圆点背带裙，非常显瘦的一款背带裙哦，下半身的裙子做成了包臀裙的设计， 使得这款背带裙有了一点时尚OL范儿。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"超显嫩！8款清新学院风美搭配\" src=\"http://www.mimito.com.cn/uploadfile/201304/25/40233132745.jpg\" /></p>\r\n<p>　　娃娃领荷叶边无袖披肩雪纺衫，斗篷披肩的度独特设计，不对称美色款式，时尚中又有性感的味道，紧致立体的飘逸荷叶很是甜美欧美公主范。</p>', NULL, 1, 1, 0, 1370103834, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (200, '甜美夏装连衣裙 减龄扮靓必备', ',31,', '甜美夏装连衣裙 减龄扮靓必备', '　　甜美的连衣裙，将女性柔美的气质完美释放，推荐几款淑女气质的连衣裙，增人气添桃花运哦。 　　别致的订珠的彼得潘领饰，精致唯美，使得原本简洁的领子透出淑女的韵味，亮丽的裙身，可爱的泡泡袖，裙摆拼接半透的薄薄，柔美气息扑鼻而来。 　　甜美柔蕾丝总是给人予浪漫的感觉，独特的彼得潘领，肩膀处的拼接，裙身亮丽的糖果色，散发出甜美的优雅女人味。', 'admin', '未知', '　　甜美的连衣裙，将女性柔美的气质完美释放，推荐几款淑女气质的连衣裙，增人气添桃花运哦。 　　别致的订珠的彼得潘领饰，精致唯美，使得原本简洁的领子透出淑女的韵味，亮丽的裙身，可爱的泡泡袖，裙摆拼接半透的薄薄，柔美气息扑鼻而来。 　　甜美柔蕾丝总是给人予浪漫的感觉，独特的彼得潘领，肩膀处的拼接，裙身亮丽的糖果色，散发出甜美的优雅女人味。', '<p>　　甜美的连衣裙，将女性柔美的气质完美释放，推荐几款淑女气质的连衣裙，增人气添桃花运哦。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"甜美夏装连衣裙 减龄扮靓必备\" src=\"http://www.mimito.com.cn/uploadfile/201304/25/E5161130254.jpg\" /></p>\r\n<p>　　别致的订珠的彼得潘领饰，精致唯美，使得原本简洁的领子透出淑女的韵味，亮丽的裙身，可爱的泡泡袖，裙摆拼接半透的薄薄，柔美气息扑鼻而来。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"甜美夏装连衣裙 减龄扮靓必备\" src=\"http://www.mimito.com.cn/uploadfile/201304/25/76161134393.jpg\" /></p>\r\n<p>　　甜美柔蕾丝总是给人予浪漫的感觉，独特的彼得潘领，肩膀处的拼接，裙身亮丽的糖果色，散发出甜美的优雅女人味。</p>', NULL, 1, 3, 0, 1370103834, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (151, '牛仔+雪纺！拼接连衣裙更诱惑', ',31,', '牛仔+雪纺！拼接连衣裙更诱惑', '时尚的连衣裙，牛仔和雪纺的拼接让这款裙子好柔美，也可以分开穿哦，不规则的裙摆穿起来更飘逸。超美的连衣裙哦，柔软的牛仔和轻盈的雪纺拼接起来，加上棕色的腰带更完美，还是亲子款的哦。', 'admin', '未知', '时尚的连衣裙，牛仔和雪纺的拼接让这款裙子好柔美，也可以分开穿哦，不规则的裙摆穿起来更飘逸。超美的连衣裙哦，柔软的牛仔和轻盈的雪纺拼接起来，加上棕色的腰带更完美，还是亲子款的哦。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"牛仔+雪纺！拼接连衣裙更诱惑\" src=\"http://www.mimito.com.cn/uploadfile/201304/24/08124744271.jpg\" /></p>\r\n<p style=\"text-align: center\">时尚的连衣裙，牛仔和雪纺的拼接让这款裙子好柔美，也可以分开穿哦，不规则的裙摆穿起来更飘逸。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"牛仔+雪纺！拼接连衣裙更诱惑\" src=\"http://www.mimito.com.cn/uploadfile/201304/24/2512460454.jpg\" /></p>\r\n<p style=\"text-align: center\">超美的连衣裙哦，柔软的牛仔和轻盈的雪纺拼接起来，加上棕色的腰带更完美，还是亲子款的哦。</p>', NULL, 1, 1, 0, 1370103835, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (152, '时尚牛仔裤 穿出翘臀美腿好身材', ',31,', '时尚牛仔裤 穿出翘臀美腿好身材', '　　手工烫钻铁塔牛仔裤，非常别致新颖的一款，修身的款式，手工烫钻的花朵，铁塔精致而美丽，上身绝对抢眼哦。 　　裤子的面料是棉质有弹性的那种，前后都有口袋，简单的铅笔裤款式，超百搭的。浅浅的颜色很好看呢，超喜欢的，大爱。', 'admin', '未知', '　　手工烫钻铁塔牛仔裤，非常别致新颖的一款，修身的款式，手工烫钻的花朵，铁塔精致而美丽，上身绝对抢眼哦。 　　裤子的面料是棉质有弹性的那种，前后都有口袋，简单的铅笔裤款式，超百搭的。浅浅的颜色很好看呢，超喜欢的，大爱。', '<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"时尚牛仔裤 穿出翘臀美腿好身材\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/ED224938308.jpg\" /></p>\r\n<p>　　手工烫钻铁塔牛仔裤，非常别致新颖的一款，修身的款式，手工烫钻的花朵，铁塔精致而美丽，上身绝对抢眼哦。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"时尚牛仔裤 穿出翘臀美腿好身材\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/A82241225369.jpg\" /></p>\r\n<p>　　裤子的面料是棉质有弹性的那种，前后都有口袋，简单的铅笔裤款式，超百搭的。浅浅的颜色很好看呢，超喜欢的，大爱。</p>', NULL, 1, 0, 0, 1370103835, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (153, '熟女装扮最是动人 气场造型最有范', ',31,', '熟女装扮最是动人 气场造型最有范', '　　女人最爱的美衣，看了就想买，好感度百分百俏丽甜美的设计，搭出平易近人的美感。 　　性感和魅力都让人无法抵御，优雅的感觉也应远而生了，是本季最亮丽的角色也是是你首选哦。 　　简约大方，完美无限，独特的款型足以让MM爱不释手。', 'admin', '未知', '　　女人最爱的美衣，看了就想买，好感度百分百俏丽甜美的设计，搭出平易近人的美感。 　　性感和魅力都让人无法抵御，优雅的感觉也应远而生了，是本季最亮丽的角色也是是你首选哦。 　　简约大方，完美无限，独特的款型足以让MM爱不释手。', '<p>　　女人最爱的美衣，看了就想买，好感度百分百俏丽甜美的设计，搭出平易近人的美感。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"熟女装扮最是动人 气场造型最有范\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/04215756191.jpg\" /></p>\r\n<p>　　性感和魅力都让人无法抵御，优雅的感觉也应远而生了，是本季最亮丽的角色也是是你首选哦。</p>\r\n<p style=\"text-align: center\">&nbsp;<img onload=\"size(this)\" alt=\"熟女装扮最是动人 气场造型最有范\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/76215758992.jpg\" /></p>\r\n<p>　　简约大方，完美无限，独特的款型足以让MM爱不释手。</p>', NULL, 1, 0, 0, 1370103836, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (154, '优雅与时尚兼备 名媛女装大盘点', ',31,', '优雅与时尚兼备 名媛女装大盘点', '　　气质的培养不仅仅需要内涵，修身的衣衫更能展现出你的知性气质！今天推荐几款优雅的女装。让妞们尽显名媛风范！优雅与时尚兼备名媛女装大盘点优雅与时尚兼备名媛女装大盘点', 'admin', '未知', '　　气质的培养不仅仅需要内涵，修身的衣衫更能展现出你的知性气质！今天推荐几款优雅的女装。让妞们尽显名媛风范！优雅与时尚兼备名媛女装大盘点优雅与时尚兼备名媛女装大盘点', '<p>　　气质的培养不仅仅需要内涵，修身的衣衫更能展现出你的知性气质！今天推荐几款优雅的女装。让妞们尽显名媛风范！</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"优雅与时尚兼备 名媛女装大盘点\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/AE125811288.jpg\" /></p>\r\n<p style=\"text-align: center\">优雅与时尚兼备 名媛女装大盘点</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"优雅与时尚兼备 名媛女装大盘点\" src=\"http://www.mimito.com.cn/uploadfile/201304/23/5E125815506.jpg\" /></p>\r\n<p style=\"text-align: center\">优雅与时尚兼备 名媛女装大盘点</p>', NULL, 1, 0, 0, 1370103836, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (155, '完美复古连衣裙 打造迷人优雅气质', ',31,', '完美复古连衣裙 打造迷人优雅气质', '　　柔软舒适，不挑身材。适合所以美妞们，搭配不同，营造不同造型，享受舒适时尚，融入柔美情怀，凸现清新自然气质。丝绒质地柔软舒适，极具风情效果，双肩的订珠、镶钻多种材质的拼接组合，增加了个性干练气质感，是春季必备的百搭品。完美复古连衣裙打造迷人优雅气质完美复古连衣裙打造迷人优雅气质完美复古连衣裙打造迷人优雅气质', 'admin', '未知', '　　柔软舒适，不挑身材。适合所以美妞们，搭配不同，营造不同造型，享受舒适时尚，融入柔美情怀，凸现清新自然气质。丝绒质地柔软舒适，极具风情效果，双肩的订珠、镶钻多种材质的拼接组合，增加了个性干练气质感，是春季必备的百搭品。完美复古连衣裙打造迷人优雅气质完美复古连衣裙打造迷人优雅气质完美复古连衣裙打造迷人优雅气质', '<p>　　柔软舒适，不挑身材。适合所以美妞们，搭配不同，营造不同造型，享受舒适时尚，融入柔美情怀，凸现清新自然气质。丝绒质地柔软舒适，极具风情效果，双肩的订珠、镶钻多种材质的拼接组合，增加了个性干练气质感，是春季必备的百搭品。</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"完美复古连衣裙 打造迷人优雅气质\" src=\"http://www.mimito.com.cn/uploadfile/201304/22/F4154622732.jpg\" /></p>\r\n<p style=\"text-align: center\">完美复古连衣裙 打造迷人优雅气质</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"完美复古连衣裙 打造迷人优雅气质\" src=\"http://www.mimito.com.cn/uploadfile/201304/22/2F154623345.jpg\" /></p>\r\n<p style=\"text-align: center\">完美复古连衣裙 打造迷人优雅气质</p>\r\n<p style=\"text-align: center\"><img onload=\"size(this)\" alt=\"完美复古连衣裙 打造迷人优雅气质\" src=\"http://www.mimito.com.cn/uploadfile/201304/22/42154625195.jpg\" /></p>\r\n<p style=\"text-align: center\">完美复古连衣裙 打造迷人优雅气质</p>', NULL, 1, 2, 0, 1370103837, NULL);
INSERT INTO sh_shop_news (`id`, `title`, `catalog_id`, `keyword`, `description`, `author`, `source`, `summary`, `content`, `pic_path`, `is_create`, `hits`, `seqorder`, `create_date`, `btitle`) VALUES (156, '春日百搭多风格小外套', ',31,', '春日百搭多风格小外套', '　　短款修身女拼接外套，多压线耸肩设计，大翻领帅气又个性，明星风范十足！　　修身圆领牛仔短外套，精致的双排扣，领口单侧蝴蝶结装饰，让她瞬间变成最时尚的亮点', 'admin', '未知', '　　短款修身女拼接外套，多压线耸肩设计，大翻领帅气又个性，明星风范十足！　　修身圆领牛仔短外套，精致的双排扣，领口单侧蝴蝶结装饰，让她瞬间变成最时尚的亮点', '<p style=\"text-align:center;\">\n	<img onload=\"size(this)\" alt=\"春日百搭多风格小外套\" src=\"http://www.mimito.com.cn/uploadfile/201304/22/11122741707.jpg\" />\n</p>\n<p>\n	　　短款修身女拼接外套，多压线耸肩设计，大翻领帅气又个性，明星风范十足！\n</p>\n<p style=\"text-align:center;\">\n	<img onload=\"size(this)\" alt=\"春日百搭多风格小外套\" src=\"http://www.mimito.com.cn/uploadfile/201304/22/B9122743856.jpg\" />\n</p>\n<p>\n	　　修身圆领牛仔短外套，精致的双排扣，领口单侧蝴蝶结装饰，让她瞬间变成最时尚的亮点\n</p>', '', 1, 35, 0, 1370103837, NULL);
#
# TABLE STRUCTURE FOR: sh_shop_news_catalog
#

DROP TABLE IF EXISTS sh_shop_news_catalog;

CREATE TABLE `sh_shop_news_catalog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `is_push` tinyint(1) unsigned NOT NULL default '0',
  `cat_name` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `parent_id` int(10) unsigned NOT NULL default '0',
  `deep_id` tinyint(2) unsigned NOT NULL default '0',
  `queue` varchar(255) NOT NULL default '0',
  `is_has_chd` tinyint(1) unsigned NOT NULL default '0',
  `keyword` varchar(100) default NULL,
  `description` varchar(255) default NULL,
  `btitle` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `is_has_chd` (`is_has_chd`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_news_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (1, 0, '服饰', 0, 0, 0, ',1,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_news_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (31, 0, '美女帅哥', 0, 0, 0, ',31,', 0, 'sdfsfes', 'fsefesf', NULL);
INSERT INTO sh_shop_news_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (30, 0, '明星', 0, 0, 0, ',30,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_news_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (29, 1, '潮流趋势', 0, 0, 0, ',29,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_news_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (26, 1, '时尚资讯', 0, 0, 0, ',26,', 0, NULL, NULL, NULL);
#
# TABLE STRUCTURE FOR: sh_shop_product
#

DROP TABLE IF EXISTS sh_shop_product;

CREATE TABLE `sh_shop_product` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `num_iid` bigint(20) unsigned NOT NULL default '0',
  `click_url` text,
  `nick` varchar(255) default NULL,
  `title` varchar(100) default NULL,
  `keyword` varchar(255) default NULL,
  `description` text,
  `props_name` text,
  `volume` int(10) NOT NULL default '0',
  `love` bigint(20) unsigned NOT NULL default '0',
  `catalog_id` varchar(100) NOT NULL default '0',
  `content` mediumtext,
  `shop_price` decimal(10,2) unsigned NOT NULL default '0.00',
  `dc_price` decimal(10,2) unsigned NOT NULL default '0.00',
  `small_pic_path` varchar(300) default NULL,
  `big_pic_path` varchar(300) default NULL,
  `hits` int(10) unsigned NOT NULL default '0',
  `seqorder` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  `btitle` varchar(100) default NULL,
  `sid` int(10) unsigned NOT NULL default '0',
  `user_id` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `catalog_id` (`catalog_id`),
  KEY `title` (`title`),
  KEY `num_iid` (`num_iid`)
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: sh_shop_product_catalog
#

DROP TABLE IF EXISTS sh_shop_product_catalog;

CREATE TABLE `sh_shop_product_catalog` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `is_push` tinyint(1) unsigned NOT NULL default '0',
  `cat_name` varchar(30) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `parent_id` bigint(20) unsigned NOT NULL default '0',
  `deep_id` tinyint(1) unsigned NOT NULL default '0',
  `queue` varchar(50) NOT NULL default '0',
  `is_has_chd` tinyint(1) unsigned NOT NULL default '0',
  `keyword` varchar(100) default NULL,
  `description` varchar(255) default NULL,
  `btitle` varchar(100) default NULL,
  PRIMARY KEY  (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `is_has_chd` (`is_has_chd`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (1, 0, '精致内衣', 10, 0, 0, ',1,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (2, 0, '品牌女装', 11, 0, 0, ',2,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (3, 0, '精品男装', 9, 0, 0, ',3,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (4, 0, '时尚女鞋', 8, 0, 0, ',4,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (5, 0, '流行男鞋', 5, 0, 0, ',5,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (6, 1, '潮流女包', 7, 0, 0, ',6,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (7, 0, '时尚饰品', 4, 0, 0, ',7,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (8, 0, '美容护肤', 6, 0, 0, ',8,', 1, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (9, 0, '户外运动', 3, 0, 0, ',9,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (10, 0, '手机数码', 2, 0, 0, ',10,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (11, 0, '母婴玩具', 1, 0, 0, ',11,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (12, 0, 'T恤', 0, 2, 1, ',2,12,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (13, 0, '裤子', 0, 2, 1, ',2,13,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (14, 0, '衬衫', 0, 2, 1, ',2,14,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (15, 0, '牛仔裤', 0, 2, 1, ',2,15,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (16, 0, '半身裙', 0, 2, 1, ',2,16,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (17, 0, '风衣', 0, 2, 1, ',2,17,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (18, 0, '雪纺衫', 0, 2, 1, ',2,18,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (19, 0, '针织衫', 0, 2, 1, ',2,19,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (20, 1, '连衣裙', 0, 2, 1, ',2,20,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (21, 0, '精品文胸', 0, 1, 1, ',1,21,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (22, 0, '男士内裤', 0, 1, 1, ',1,22,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (23, 0, '女士内裤', 0, 1, 1, ',1,23,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (24, 0, '塑身上衣', 0, 1, 1, ',1,24,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (25, 0, '全棉内裤', 0, 1, 1, ',1,25,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (26, 0, 'T恤', 0, 3, 1, ',3,26,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (27, 0, '衬衫', 0, 3, 1, ',3,27,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (28, 0, '休闲裤', 0, 3, 1, ',3,28,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (29, 0, '夹克', 0, 3, 1, ',3,29,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (30, 0, '牛仔裤', 0, 3, 1, ',3,30,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (31, 0, 'Polo衫', 0, 3, 1, ',3,31,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (32, 0, '风衣', 0, 3, 1, ',3,32,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (33, 0, '皮衣', 0, 3, 1, ',3,33,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (34, 0, '单鞋', 0, 4, 1, ',4,34,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (35, 0, '帆布鞋', 0, 4, 1, ',4,35,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (36, 0, '靴子', 0, 4, 1, ',4,36,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (37, 0, '凉鞋', 0, 4, 1, ',4,37,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (38, 0, '高帮鞋', 0, 4, 1, ',4,38,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (39, 0, '短靴', 0, 4, 1, ',4,39,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (40, 0, '低帮鞋', 0, 5, 1, ',5,40,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (41, 0, '帆布鞋', 0, 5, 1, ',5,41,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (42, 0, '女士单肩', 0, 6, 1, ',6,42,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (43, 0, '女士手提', 0, 6, 1, ',6,43,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (44, 0, '女士手拿', 0, 6, 1, ',6,44,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (45, 0, '女士双肩包', 0, 6, 1, ',6,45,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (46, 0, '面膜', 0, 8, 1, ',8,46,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (47, 0, '香水', 0, 8, 1, ',8,47,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (48, 0, '精华液', 0, 8, 1, ',8,48,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (49, 0, '单方精油', 0, 8, 1, ',8,49,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (50, 0, '复方精油', 0, 8, 1, ',8,50,', 0, NULL, NULL, NULL);
INSERT INTO sh_shop_product_catalog (`id`, `is_push`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `keyword`, `description`, `btitle`) VALUES (51, 0, '眉笔/眉粉', 0, 8, 1, ',8,51,', 0, NULL, NULL, NULL);
#
# TABLE STRUCTURE FOR: sh_shop_product_image
#

DROP TABLE IF EXISTS sh_shop_product_image;

CREATE TABLE `sh_shop_product_image` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `product_id` bigint(20) unsigned NOT NULL default '0',
  `pic_path` varchar(300) default NULL,
  PRIMARY KEY  (`id`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=392 DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: sh_shop_product_temp
#

DROP TABLE IF EXISTS sh_shop_product_temp;

CREATE TABLE `sh_shop_product_temp` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `num_iid` bigint(20) unsigned NOT NULL default '0',
  `click_url` text,
  `nick` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `props_name` text,
  `volume` int(10) unsigned NOT NULL default '0',
  `catalog_id` varchar(100) NOT NULL default '0',
  `content` mediumtext,
  `shop_price` decimal(10,2) unsigned NOT NULL default '0.00',
  `dc_price` decimal(10,2) unsigned NOT NULL default '0.00',
  `pic_path` varchar(300) NOT NULL default '',
  `create_date` int(10) unsigned NOT NULL default '0',
  `user_id` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `num_iid` (`num_iid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: sh_shop_rule
#

DROP TABLE IF EXISTS sh_shop_rule;

CREATE TABLE `sh_shop_rule` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `f_url` varchar(255) default NULL,
  `p_url` varchar(255) default NULL,
  `page_total` int(10) unsigned NOT NULL default '0',
  `page_step` int(10) unsigned NOT NULL default '0',
  `c_total` int(10) unsigned NOT NULL default '0',
  `list_block_s` varchar(500) default NULL,
  `list_block_e` varchar(500) default NULL,
  `list_link_s` varchar(500) default NULL,
  `list_link_e` varchar(500) default NULL,
  `detail_s` varchar(500) default NULL,
  `detail_e` varchar(500) default NULL,
  `charset` varchar(20) default NULL,
  `mod_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (1, '腾讯国内新闻', 'http://news.qq.com/newsgn/gdxw/gedixinwen.htm', 'http://news.qq.com/newsgn/gdxw/gedixinwen_{page}.htm', 10, 1, 0, '<div class=\"mod newslist\"><ul>', '</ul></div>', ' <li>·', '　<span ', 'bossZone=\"content\">', '</div>', 'gbk', 0);
INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (3, '腾讯港台星闻', 'http://ent.qq.com/c/gtxw_1.htm', 'http://ent.qq.com/c/gtxw_{page}.htm', 10, 1, 23, '<div id=\"listZone\">', 'return false\"></a></div>\r\n</div>\r\n</div>', '<h3 class=\"mxzxItem\">', '</h3>', 'bossZone=\"content\">', '</div>', 'gbk', 1370092007);
INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (4, '潮流趋势-淘宝', 'http://fashion.taobao.com/list/2081/1.php', 'http://fashion.taobao.com/list/2081/{page}.php', 5, 1, 45, '<div class=\"list-box\">', '<div id=\"art-list\" style=\"display:none;\"></div>', '<h2>', '</h2>', '<div class=\"info-main-text\" id=\"art-content\">', '</div>', 'gbk', 1370091778);
INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (5, '时尚资讯-淘宝', 'http://fashion.taobao.com/list/2046/1.php', 'http://fashion.taobao.com/list/2046/{page}.php', 5, 1, 11, '<div class=\"list-box\">', '<div id=\"art-list\" style=\"display:none;\"></div>', '<h2>', '</h2>', '<div class=\"info-main-text\" id=\"art-content\">', '</div>', 'gbk', 1370091712);
INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (6, '流行风-佳品网时尚资讯', 'http://news.jiapin.com/list-225.html', 'http://news.jiapin.com/list-225-{page}.html', 5, 1, 10, '<div class=\"listnavs\">', '</div>', '<dt class=\"listbt\">', '</dt>', '<div class=\"fontsize_div\">', '</div>', 'utf-8', 1370087888);
INSERT INTO sh_shop_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES (7, '学搭配 -女人街', 'http://www.mimito.com.cn/dapei/', 'http://www.mimito.com.cn/dapei/page_{page}.html', 5, 1, 2, '<div class=\"list_cont\">', '<div class=\"list_page page\">', '<div class=\"title\">', '</div>', '<div class=\"content_01\">', '</div>', 'utf-8', 1370593547);
#
# TABLE STRUCTURE FOR: sh_shop_u_rule
#

DROP TABLE IF EXISTS sh_shop_u_rule;

CREATE TABLE `sh_shop_u_rule` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `f_url` varchar(255) default NULL,
  `p_url` varchar(255) default NULL,
  `page_total` int(10) unsigned NOT NULL default '0',
  `page_step` int(10) unsigned NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (1, '九块邮-九块九', 'http://jiukuaiyoucom.uz.taobao.com/d/jiu?spm=a2116.2174389.0.0.x7Zx0t&u=jiu/all/1', 'http://jiukuaiyoucom.uz.taobao.com/d/jiu?spm=a2116.2174389.0.0.x7Zx0t&u=jiu/all/{page}', 5, 0);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (3, '折800-女装', 'http://zhe800.uz.taobao.com/d/taofushi?spm=a2116.2183401.0.0.Oi9bYl&tag_id=2', 'http://zhe800.uz.taobao.com/list.php?spm=a2116.2183401.0.0.zh99BB&page={page}&tag_id=2', 3, 1);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (4, 'U站中心-母婴', 'http://uz.lecu8.com/guang-main-cid-4.html', 'http://uz.lecu8.com/guang-main-cid-4-page-{page}.html', 5, 1);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (6, 'U站中心-鞋包', 'http://uz.lecu8.com/guang-main-cid-5.html', 'http://uz.lecu8.com/guang-main-cid-5-page-{page}.html', 5, 0);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (7, 'U站中心-美妆', 'http://uz.lecu8.com/guang-main-cid-9.html', 'http://uz.lecu8.com/guang-main-cid-9-page-{page}.html', 3, 0);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (8, 'U站中心-服饰', 'http://uz.lecu8.com/guang-main-cid-2.html', 'http://uz.lecu8.com/guang-main-cid-2-page-{page}.html', 3, 0);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (9, '连衣裙', 'http://s.etao.com/search?q=%C1%AC%D2%C2%C8%B9&eq=%25E8%25BF%259E%25E8%25A1%25A3%25E8%25A3%2599&initiative_id=wwwetao_20150331&spm=1002.1.8.1', 'http://s.etao.com/search?q=%C1%AC%D2%C2%C8%B9&eq=%25E8%25BF%259E%25E8%25A1%25A3%25E8%25A3%2599&initiative_id=wwwetao_20150331&spm=1002.1.8.1', 5, 0);
INSERT INTO sh_shop_u_rule (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`) VALUES (10, '精品男装', 'http://s.etao.com/search?q=%C4%D0%D7%B0%D0%DD%CF%D0%CD%E2%CC%D7&suggest=0_3&suggest_type=5&wq=%C4%D0%D7%B0&suggest_query=%C4%D0%D7%B0&source=suggest&suggest_auc=1&initiative_id=setao_20150331&eq=', 'http://s.etao.com/search?q=%C4%D0%D7%B0%D0%DD%CF%D0%CD%E2%CC%D7&suggest=0_3&suggest_type=5&wq=%C4%D0%D7%B0&suggest_query=%C4%D0%D7%B0&source=suggest&suggest_auc=1&initiative_id=setao_20150331&eq=', 5, 0);
#
# TABLE STRUCTURE FOR: sh_shop_user
#

DROP TABLE IF EXISTS sh_shop_user;

CREATE TABLE `sh_shop_user` (
  `id` bigint(15) unsigned NOT NULL auto_increment,
  `user_name` varchar(30) NOT NULL default '',
  `taobao_id` bigint(20) unsigned NOT NULL default '0',
  `password` varchar(50) default NULL,
  `pic_path` varchar(255) default NULL,
  `email` varchar(50) default NULL,
  `qq` varchar(20) default NULL,
  `wangwang` varchar(30) default NULL,
  `last_login_ip` varchar(20) default NULL,
  `last_login_time` int(10) unsigned default NULL,
  `login_times` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  `qq_id` varchar(50) default NULL,
  PRIMARY KEY  (`id`),
  KEY `user_name` (`user_name`),
  KEY `password` (`password`),
  KEY `taobao_id` (`taobao_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

