using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using EeekSoft.Web;

namespace EeekSoft.PopupTest
{
	/// <summary>
	/// Test of dynamic control loading
	/// </summary>
	public partial class DynamicTest : System.Web.UI.Page
	{
	
		/// <summary>
		/// Create controls
		/// </summary>
		protected void Page_Load(object sender, System.EventArgs e)
		{
			// Create popup window and popup win anchor control
			PopupWin popupWin=new PopupWin();
			PopupWinAnchor popupAnchor=new PopupWinAnchor();

			// Add controls to page
			placeHolder.Controls.Add(popupAnchor);	
			placeHolder.Controls.Add(popupWin);

			// Set anchor properties
			popupAnchor.PopupToShow=popupWin.ClientID;
			popupAnchor.LinkedControl="reopen";
			popupAnchor.HandledEvent="onclick";

			// Set popup win properties
			popupWin.ActionType=EeekSoft.Web.PopupAction.MessageWindow;
			popupWin.Title="This is popup";
			popupWin.Message="<i>Message</i> displayed in popup";
			popupWin.Text="Text to show in new window..";
			popupWin.HideAfter=5000;

			// Show popup
			popupWin.Visible=true;
			popupWin.AutoShow=false;
		}


		override protected void OnInit(EventArgs e)
		{
			InitializeComponent();
			base.OnInit(e);
		}

		#region Web Form Designer generated code
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    

		}
		#endregion
	}
}
