﻿namespace EeekSoft.Web
{
    using System;
    using System.ComponentModel;
    using System.Drawing.Design;
    using System.Web.UI;
    using System.Windows.Forms;
    using System.Windows.Forms.Design;

    public abstract class ControlsEditor : UITypeEditor
    {
        private IWindowsFormsEditorService edSvc = null;
        private ListBox lb;
        private System.Type typeShow;

        public ControlsEditor(System.Type show)
        {
            this.typeShow = show;
        }

        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
        {
            if (((context == null) || (context.Instance == null)) || (provider == null))
            {
                return value;
            }
            this.edSvc = (IWindowsFormsEditorService) provider.GetService(typeof(IWindowsFormsEditorService));
            if (this.edSvc == null)
            {
                return value;
            }
            this.lb = new ListBox();
            this.lb.BorderStyle = BorderStyle.None;
            this.lb.SelectedIndexChanged += new EventHandler(this.lb_SelectedIndexChanged);
            foreach (System.Web.UI.Control control in ((System.Web.UI.Control) context.Instance).Page.Controls)
            {
                if (control.GetType().IsSubclassOf(this.typeShow) || (control.GetType().FullName == this.typeShow.FullName))
                {
                    this.lb.Items.Add(control.ID);
                }
            }
            this.edSvc.DropDownControl(this.lb);
            if (this.lb.SelectedIndex == -1)
            {
                return value;
            }
            return this.lb.SelectedItem;
        }

        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.DropDown;
        }

        private void lb_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.edSvc != null)
            {
                this.edSvc.CloseDropDown();
            }
        }
    }
}
//5_1_a_s_p_x.c_o_m
