﻿namespace EeekSoft.Web
{
    using System;
    using System.ComponentModel;
    using System.Drawing.Design;
    using System.Windows.Forms;
    using System.Windows.Forms.Design;

    public class JavaScriptEventEditor : UITypeEditor
    {
        private IWindowsFormsEditorService edSvc = null;
        private ListBox lb;

        public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
        {
            if (((context == null) || (context.Instance == null)) || (provider == null))
            {
                return value;
            }
            this.edSvc = (IWindowsFormsEditorService) provider.GetService(typeof(IWindowsFormsEditorService));
            if (this.edSvc == null)
            {
                return value;
            }
            this.lb = new ListBox();
            this.lb.BorderStyle = BorderStyle.None;
            this.lb.SelectedIndexChanged += new EventHandler(this.lb_SelectedIndexChanged);
            this.lb.Items.Add("onclick");
            this.lb.Items.Add("ondblclick");
            this.lb.Items.Add("onmouseover");
            this.lb.Items.Add("onfocus");
            this.lb.Items.Add("oncontextmenu");
            this.edSvc.DropDownControl(this.lb);
            if (this.lb.SelectedIndex == -1)
            {
                return value;
            }
            return this.lb.SelectedItem;
        }

        public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
        {
            return UITypeEditorEditStyle.DropDown;
        }

        private void lb_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.edSvc != null)
            {
                this.edSvc.CloseDropDown();
            }
        }
    }
}

