﻿namespace EeekSoft.Web
{
    using System;
    using System.ComponentModel;
    using System.Drawing;
    using System.Runtime.CompilerServices;
    using System.Web.UI;
    using System.Web.UI.WebControls;

    [DefaultProperty("Message"), ToolboxData("<{0}:PopupWin runat=server></{0}:PopupWin>"), Designer(typeof(PopupWinDesigner))]
    public class PopupWin : WebControl, IPostBackEventHandler
    {
        private string aCommands = "onmouseover=\"style.textDecoration='underline';\"\r\n                  onmouseout=\"style.textDecoration='none';\"\r\n                  href=\"[cmd]\"";
        private string aStyle = "font:12px arial,sans-serif; color:#{8}; text-decoration:none;";
        private bool bAutoShow = true;
        private bool bDragDrop = false;
        private bool bShowLink = true;
        private string closeHtml = "<span style=\"position:absolute; right:0px; top:0px; cursor:pointer; color:#{9}; font:bold 12px arial,sans-serif; \r\n                  position:absolute; right:3px;\"\r\n                  onclick=\"[id]espopup_Close()\"\r\n                  onmousedown=\"event.cancelBubble=true;\"\r\n                  onmouseover=\"style.color='#{10}';\"\r\n                  onmouseout=\"style.color='#{9}';\">X</span>";
        private PopupColorStyle clrStyle;
        private string cntBackground;
        private string cntBorderDark;
        private string cntBorderLight;
        private string cntStyle = "border-left:1px solid #{3}; border-top:1px solid #{3};\r\n                 border-bottom:1px solid #{4}; border-right:1px solid #{4};\r\n                 background:#{5}; padding:2px; overflow:hidden; text-align:center;\r\n                 filter:progid:DXImageTransform.Microsoft.Gradient(GradientType=0,\r\n                 StartColorStr='#FF{6}', EndColorStr='#FF{7}');";
        private string cntStyleI = "position:absolute; left:2px; width:{0}px; top:20px; height:{1}px;";
        private string cntStyleN = "position:absolute; left:2px; width:{0}px; top:20px; height:{1}px;";
        private string divDesign = "background:#{0}; border-right:1px solid #{1}; border-bottom:1px solid #{1};\r\n                  border-left:1px solid #{2}; border-top:1px solid #{2}; position:absolute;\r\n                  z-index:9999; ";
        private string fullmsg = "Text to display in new window.";
        private string gradientEnd;
        private string gradientStart;
        private string hdrStyle = "position:absolute; left:2px; width:[wid]px; top:2px; height:14px;\r\n                 filter:progid:DXImageTransform.Microsoft.Gradient(GradientType=0,\r\n                 StartColorStr='#FF{6}', EndColorStr='#FF{7}');";
        private int iHide;
        private int iSpeed = 20;
        private string msg = "Message to show in popup";
        private PopupAction popAction;
        private PopupDocking popDock;
        private string popupBackground;
        private string popupBorderDark;
        private string popupBorderLight;
        private string sLink;
        private string spopStyle = "body {    background:#[gs]; padding:5px;    filter:progid:DXImageTransform.Microsoft.Gradient(     GradientType=0,StartColorStr='#FF[gs]', EndColorStr='#FF[ge]');  }  h1 {    font:bold 16px arial,sans-serif; color:#[clr];     text-align:center; margin:0px;  }  p {    font:14px arial,sans-serif; color:#[clr];  }";
        private string sPopup = "<head><title>{1}</title><style type=\\\"text/css\\\">{2}</style></head><body><h1>{1}</h1><p>{0}</p></body>";
        private const string sScript = "<script type=\"text/javascript\">\r\n      //<![CDATA[\r\n        var [id]oldonloadHndlr=window.onload, [id]popupHgt, [id]actualHgt, [id]tmrId=-1, [id]resetTimer;\r\n        var [id]titHgt, [id]cntDelta, [id]tmrHide=-1, [id]hideAfter=[hide], [id]hideAlpha, [id]hasFilters=[ie];\r\n        var [id]nWin, [id]showBy=null, [id]dxTimer=-1, [id]popupBottom, [id]oldLeft;\r\n        var [id]nText,[id]nMsg,[id]nTitle,[id]bChangeTexts=false;\r\n        window.onload=[id]espopup_winLoad;\r\n\r\n        var [id]oldonscrollHndr=window.onscroll;\r\n        window.onscroll=[id]espopup_winScroll;\r\n        [id]nText=\"[popup]\";\r\n\r\n        function [id]espopup_winScroll()\r\n        {\r\n          if ([id]oldonscrollHndr!=null) [id]oldonscrollHndr();\r\n          if ([id]tmrHide!=-1)\r\n          {\r\n            el=document.getElementById('[id]');\r\n            el.style.display='none'; el.style.display='block';\r\n          }\r\n        }\r\n\r\n        function [id]espopup_ShowPopup(show)\r\n        {\r\n          if ([id]dxTimer!=-1) { el.filters.blendTrans.stop(); }\r\n\r\n          if (([id]tmrHide!=-1) && ((show!=null) && (show==[id]showBy)))\r\n          {\r\n            clearInterval([id]tmrHide);\r\n            [id]tmrHide=setInterval([id]espopup_tmrHideTimer,[id]hideAfter);\r\n            return;\r\n          }\r\n          if ([id]tmrId!=-1) return;\r\n          [id]showBy=show;\r\n\r\n          elCnt=document.getElementById('[id]_content')\r\n          elTit=document.getElementById('[id]_header');\r\n          el=document.getElementById('[id]');\r\n          el.style.left=[id]oldLeft;\r\n          el.style.top='';\r\n          el.style.filter='';\r\n\r\n          if ([id]tmrHide!=-1) clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n\r\n          document.getElementById('[id]_header').style.display='none';\r\n          document.getElementById('[id]_content').style.display='none';\r\n\r\n          if (navigator.userAgent.indexOf('Opera')!=-1)\r\n            el.style.bottom=(document.body.scrollHeight*1-document.body.scrollTop*1\r\n                            -document.body.offsetHeight*1+1*[id]popupBottom)+'px';\r\n          \r\n          if ([id]bChangeTexts)\r\n          {\r\n            [id]bChangeTexts=false;\r\n            document.getElementById('[id]aCnt').innerHTML=[id]nMsg;\r\n            document.getElementById('[id]titleEl').innerHTML=[id]nTitle;\r\n          }\r\n\r\n          [id]actualHgt=0; el.style.height=[id]actualHgt+'px';\r\n          el.style.visibility='';\r\n          if (![id]resetTimer) el.style.display='';\r\n          [id]tmrId=setInterval([id]espopup_tmrTimer,([id]resetTimer?[stime]:20));\r\n        }\r\n\r\n        function [id]espopup_winLoad()\r\n        {\r\n          if ([id]oldonloadHndlr!=null) [id]oldonloadHndlr();\r\n\r\n          elCnt=document.getElementById('[id]_content')\r\n          elTit=document.getElementById('[id]_header');\r\n          el=document.getElementById('[id]');\r\n\t\t\t\t\t[id]oldLeft=el.style.left;\r\n          [id]popupBottom=el.style.bottom.substr(0,el.style.bottom.length-2);\r\n          \r\n          [id]titHgt=elTit.style.height.substr(0,elTit.style.height.length-2);\r\n          [id]popupHgt=el.style.height;\r\n          [id]popupHgt=[id]popupHgt.substr(0,[id]popupHgt.length-2); [id]actualHgt=0;\r\n          [id]cntDelta=[id]popupHgt-(elCnt.style.height.substr(0,elCnt.style.height.length-2));\r\n\r\n          if ([autoshow])\r\n          {\r\n            [id]resetTimer=true;\r\n            [id]espopup_ShowPopup(null);\r\n          }\r\n        }\r\n\r\n        function [id]espopup_tmrTimer()\r\n        {\r\n          el=document.getElementById('[id]');\r\n          if ([id]resetTimer)\r\n          {\r\n            el.style.display='';\r\n            clearInterval([id]tmrId); [id]resetTimer=false;\r\n            [id]tmrId=setInterval([id]espopup_tmrTimer,[speed]);\r\n          }\r\n          [id]actualHgt+=5;\r\n          if ([id]actualHgt>=[id]popupHgt)\r\n          {\r\n            [id]actualHgt=[id]popupHgt; clearInterval([id]tmrId); [id]tmrId=-1;\r\n            document.getElementById('[id]_content').style.display='';\r\n            if ([id]hideAfter!=-1) [id]tmrHide=setInterval([id]espopup_tmrHideTimer,[id]hideAfter);\r\n          }\r\n          if ([id]titHgt<[id]actualHgt-6)\r\n            document.getElementById('[id]_header').style.display='';\r\n          if (([id]actualHgt-[id]cntDelta)>0)\r\n          {\r\n            elCnt=document.getElementById('[id]_content')\r\n            elCnt.style.display='';\r\n            elCnt.style.height=([id]actualHgt-[id]cntDelta)+'px';\r\n          }\r\n          el.style.height=[id]actualHgt+'px';\r\n        }\r\n        \r\n        function [id]espopup_tmrHideTimer()\r\n        {\r\n          clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n          el=document.getElementById('[id]');\r\n          if ([id]hasFilters)\r\n          {\r\n            backCnt=document.getElementById('[id]_content').innerHTML;\r\n            backTit=document.getElementById('[id]_header').innerHTML;\r\n            document.getElementById('[id]_content').innerHTML='';\r\n            document.getElementById('[id]_header').innerHTML='';\r\n            el.style.filter='blendTrans(duration=1)';\r\n            el.filters.blendTrans.apply();\r\n            el.style.visibility='hidden';\r\n            el.filters.blendTrans.play();\r\n            document.getElementById('[id]_content').innerHTML=backCnt;\r\n            document.getElementById('[id]_header').innerHTML=backTit;\r\n            \r\n            [id]dxTimer=setInterval([id]espopup_dxTimer,1000);\r\n          }\r\n          else el.style.visibility='hidden';\r\n        }\r\n        \r\n        function [id]espopup_dxTimer()\r\n        {\r\n          clearInterval([id]dxTimer); [id]dxTimer=-1;\r\n        }\r\n     \r\n        function [id]espopup_Close()\r\n        {\r\n          if ([id]tmrId==-1)\r\n          {\r\n            el=document.getElementById('[id]');\r\n            el.style.filter='';\r\n            el.style.display='none';\r\n            if ([id]tmrHide!=-1) clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n            [sclose]\r\n          }\r\n        }\r\n    \r\n        function [id]espopup_ShowWindow()\r\n        {\r\n          [slink]\r\n          if ([id]nWin!=null) [id]nWin.close();\r\n          [id]nWin=window.open('','[id]nWin','[winstyle], '+\r\n            'menubar=no, resizable=no, status=no, toolbar=no, location=no');\r\n          [id]nWin.document.write([id]nText);\r\n        }\r\n\r\n        var [id]mousemoveBack,[id]mouseupBack;\r\n        var [id]ofsX,[id]ofsY;\r\n        function [id]espopup_DragDrop(e)\r\n        {\r\n          [id]mousemoveBack=document.body.onmousemove;\r\n          [id]mouseupBack=document.body.onmouseup;\r\n          ox=(e.offsetX==null)?e.layerX:e.offsetX;\r\n          oy=(e.offsetY==null)?e.layerY:e.offsetY;\r\n          [id]ofsX=ox; [id]ofsY=oy;\r\n\r\n          document.body.onmousemove=[id]espopup_DragDropMove;\r\n          document.body.onmouseup=[id]espopup_DragDropStop;\r\n          if ([id]tmrHide!=-1) clearInterval([id]tmrHide);\r\n        }\r\n\r\n        function [id]espopup_DragDropMove(e)\r\n        {\r\n          el=document.getElementById('[id]');          \r\n          if (e==null&&event!=null)\r\n          {\r\n            el.style.left=(event.clientX*1+document.body.scrollLeft-[id]ofsX)+'px';\r\n            el.style.top=(event.clientY*1+document.body.scrollTop-[id]ofsY)+'px';\r\n            event.cancelBubble=true;\r\n          }\r\n          else\r\n          {\r\n            el.style.left=(e.pageX*1-[id]ofsX)+'px';\r\n            el.style.top=(e.pageY*1-[id]ofsY)+'px';\r\n            e.cancelBubble=true;\r\n          }\r\n          if ((event.button&1)==0) [id]espopup_DragDropStop();\r\n        }\r\n\r\n        function [id]espopup_DragDropStop()\r\n        {\r\n          document.body.onmousemove=[id]mousemoveBack;\r\n          document.body.onmouseup=[id]mouseupBack;\r\n        }\r\n\r\n      //]]>\r\n      </script>";
        private string sTarget;
        private int startTime;
        private string textColor;
        private string title = "Title here";
        private bool winScroll = true;
        private Size winSize;
        private string xButton;
        private string xButtonOver;
        private int xOffset;
        private int yOffset;

        [Description("User clicked on link on popup box."), Category("Popup")]
        public event EventHandler LinkClicked;

        [Description("User clicked on 'X' on popup box."), Category("Popup")]
        public event EventHandler PopupClosed;

        public PopupWin()
        {
            this.ColorStyle = PopupColorStyle.Blue;
            this.xOffset = this.yOffset = 15;
            this.popDock = PopupDocking.BottomRight;
            this.iHide = 0x1388;
            this.winSize = new Size(400, 250);
            this.Width = new Unit("200px");
            this.Height = new Unit("100px");
            this.startTime = 0x3e8;
            this.popAction = PopupAction.MessageWindow;
        }

        private Color ColorFromString(string str)
        {
            return ColorTranslator.FromHtml("#" + str);
        }

        private string ColorToString(Color color)
        {
            return (color.R.ToString("x").PadLeft(2, '0') + color.G.ToString("x").PadLeft(2, '0') + color.B.ToString("x").PadLeft(2, '0'));
        }

        internal string GetDesignCode()
        {
            string str = string.Format("width:{0}; height:{1}; ", this.Width, this.Height);
            string str2 = string.Format(this.cntStyleI, this.Width.Value - 6.0, this.Height.Value - 24.0);
            object[] args = new object[11];
            args[0] = this.ClientID;
            args[1] = this.PutColors(this.divDesign);
            args[2] = str;
            args[3] = this.ClientID + "_header";
            double num = this.Width.Value - 6.0;
            args[4] = this.PutColors(this.hdrStyle).Replace("[wid]", num.ToString()) + this.PutColors(this.aStyle);
            args[5] = this.title + this.PutColors(this.closeHtml).Replace("[id]", this.ClientID);
            args[6] = this.ClientID + "_content";
            args[7] = this.PutColors(this.cntStyle) + str2;
            args[8] = this.PutColors(this.aStyle);
            args[9] = this.aCommands.Replace("[id]", this.ClientID);
            args[10] = this.msg;
            return string.Format("<div id=\"{0}\" style=\"{1} {2}; left:0px; top:0px; \"><div id=\"{3}\" style=\"{4}\">{5}</div><div id=\"{6}\" style=\"{7}\"><a style=\"{8}\" {9}>{10}</a></div></div>", args);
        }

        internal string GetWinText(string title, string text)
        {
            string str = this.spopStyle.Replace("[gs]", this.gradientStart).Replace("[ge]", this.gradientEnd).Replace("[clr]", this.textColor);
            return string.Format(this.sPopup, text.Replace(@"\", @"\\").Replace("\"", "\\\""), title, str);
        }

        private string PutColors(string html)
        {
            return string.Format(html, new object[] { this.popupBackground, this.popupBorderDark, this.popupBorderLight, this.cntBorderDark, this.cntBorderLight, this.cntBackground, this.gradientStart, this.gradientEnd, this.textColor, this.xButton, this.xButtonOver });
        }

        public void RaisePostBackEvent(string eventArgument)
        {
            if (eventArgument == "C")
            {
                this.LinkClicked(this, EventArgs.Empty);
            }
            if (eventArgument == "X")
            {
                this.PopupClosed(this, EventArgs.Empty);
            }
        }

        protected override void Render(HtmlTextWriter output)
        {
            string browser = this.Page.Request.Browser.Browser;
            string str2 = "<script type=\"text/javascript\">\r\n      //<![CDATA[\r\n        var [id]oldonloadHndlr=window.onload, [id]popupHgt, [id]actualHgt, [id]tmrId=-1, [id]resetTimer;\r\n        var [id]titHgt, [id]cntDelta, [id]tmrHide=-1, [id]hideAfter=[hide], [id]hideAlpha, [id]hasFilters=[ie];\r\n        var [id]nWin, [id]showBy=null, [id]dxTimer=-1, [id]popupBottom, [id]oldLeft;\r\n        var [id]nText,[id]nMsg,[id]nTitle,[id]bChangeTexts=false;\r\n        window.onload=[id]espopup_winLoad;\r\n\r\n        var [id]oldonscrollHndr=window.onscroll;\r\n        window.onscroll=[id]espopup_winScroll;\r\n        [id]nText=\"[popup]\";\r\n\r\n        function [id]espopup_winScroll()\r\n        {\r\n          if ([id]oldonscrollHndr!=null) [id]oldonscrollHndr();\r\n          if ([id]tmrHide!=-1)\r\n          {\r\n            el=document.getElementById('[id]');\r\n            el.style.display='none'; el.style.display='block';\r\n          }\r\n        }\r\n\r\n        function [id]espopup_ShowPopup(show)\r\n        {\r\n          if ([id]dxTimer!=-1) { el.filters.blendTrans.stop(); }\r\n\r\n          if (([id]tmrHide!=-1) && ((show!=null) && (show==[id]showBy)))\r\n          {\r\n            clearInterval([id]tmrHide);\r\n            [id]tmrHide=setInterval([id]espopup_tmrHideTimer,[id]hideAfter);\r\n            return;\r\n          }\r\n          if ([id]tmrId!=-1) return;\r\n          [id]showBy=show;\r\n\r\n          elCnt=document.getElementById('[id]_content')\r\n          elTit=document.getElementById('[id]_header');\r\n          el=document.getElementById('[id]');\r\n          el.style.left=[id]oldLeft;\r\n          el.style.top='';\r\n          el.style.filter='';\r\n\r\n          if ([id]tmrHide!=-1) clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n\r\n          document.getElementById('[id]_header').style.display='none';\r\n          document.getElementById('[id]_content').style.display='none';\r\n\r\n          if (navigator.userAgent.indexOf('Opera')!=-1)\r\n            el.style.bottom=(document.body.scrollHeight*1-document.body.scrollTop*1\r\n                            -document.body.offsetHeight*1+1*[id]popupBottom)+'px';\r\n          \r\n          if ([id]bChangeTexts)\r\n          {\r\n            [id]bChangeTexts=false;\r\n            document.getElementById('[id]aCnt').innerHTML=[id]nMsg;\r\n            document.getElementById('[id]titleEl').innerHTML=[id]nTitle;\r\n          }\r\n\r\n          [id]actualHgt=0; el.style.height=[id]actualHgt+'px';\r\n          el.style.visibility='';\r\n          if (![id]resetTimer) el.style.display='';\r\n          [id]tmrId=setInterval([id]espopup_tmrTimer,([id]resetTimer?[stime]:20));\r\n        }\r\n\r\n        function [id]espopup_winLoad()\r\n        {\r\n          if ([id]oldonloadHndlr!=null) [id]oldonloadHndlr();\r\n\r\n          elCnt=document.getElementById('[id]_content')\r\n          elTit=document.getElementById('[id]_header');\r\n          el=document.getElementById('[id]');\r\n\t\t\t\t\t[id]oldLeft=el.style.left;\r\n          [id]popupBottom=el.style.bottom.substr(0,el.style.bottom.length-2);\r\n          \r\n          [id]titHgt=elTit.style.height.substr(0,elTit.style.height.length-2);\r\n          [id]popupHgt=el.style.height;\r\n          [id]popupHgt=[id]popupHgt.substr(0,[id]popupHgt.length-2); [id]actualHgt=0;\r\n          [id]cntDelta=[id]popupHgt-(elCnt.style.height.substr(0,elCnt.style.height.length-2));\r\n\r\n          if ([autoshow])\r\n          {\r\n            [id]resetTimer=true;\r\n            [id]espopup_ShowPopup(null);\r\n          }\r\n        }\r\n\r\n        function [id]espopup_tmrTimer()\r\n        {\r\n          el=document.getElementById('[id]');\r\n          if ([id]resetTimer)\r\n          {\r\n            el.style.display='';\r\n            clearInterval([id]tmrId); [id]resetTimer=false;\r\n            [id]tmrId=setInterval([id]espopup_tmrTimer,[speed]);\r\n          }\r\n          [id]actualHgt+=5;\r\n          if ([id]actualHgt>=[id]popupHgt)\r\n          {\r\n            [id]actualHgt=[id]popupHgt; clearInterval([id]tmrId); [id]tmrId=-1;\r\n            document.getElementById('[id]_content').style.display='';\r\n            if ([id]hideAfter!=-1) [id]tmrHide=setInterval([id]espopup_tmrHideTimer,[id]hideAfter);\r\n          }\r\n          if ([id]titHgt<[id]actualHgt-6)\r\n            document.getElementById('[id]_header').style.display='';\r\n          if (([id]actualHgt-[id]cntDelta)>0)\r\n          {\r\n            elCnt=document.getElementById('[id]_content')\r\n            elCnt.style.display='';\r\n            elCnt.style.height=([id]actualHgt-[id]cntDelta)+'px';\r\n          }\r\n          el.style.height=[id]actualHgt+'px';\r\n        }\r\n        \r\n        function [id]espopup_tmrHideTimer()\r\n        {\r\n          clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n          el=document.getElementById('[id]');\r\n          if ([id]hasFilters)\r\n          {\r\n            backCnt=document.getElementById('[id]_content').innerHTML;\r\n            backTit=document.getElementById('[id]_header').innerHTML;\r\n            document.getElementById('[id]_content').innerHTML='';\r\n            document.getElementById('[id]_header').innerHTML='';\r\n            el.style.filter='blendTrans(duration=1)';\r\n            el.filters.blendTrans.apply();\r\n            el.style.visibility='hidden';\r\n            el.filters.blendTrans.play();\r\n            document.getElementById('[id]_content').innerHTML=backCnt;\r\n            document.getElementById('[id]_header').innerHTML=backTit;\r\n            \r\n            [id]dxTimer=setInterval([id]espopup_dxTimer,1000);\r\n          }\r\n          else el.style.visibility='hidden';\r\n        }\r\n        \r\n        function [id]espopup_dxTimer()\r\n        {\r\n          clearInterval([id]dxTimer); [id]dxTimer=-1;\r\n        }\r\n     \r\n        function [id]espopup_Close()\r\n        {\r\n          if ([id]tmrId==-1)\r\n          {\r\n            el=document.getElementById('[id]');\r\n            el.style.filter='';\r\n            el.style.display='none';\r\n            if ([id]tmrHide!=-1) clearInterval([id]tmrHide); [id]tmrHide=-1;\r\n            [sclose]\r\n          }\r\n        }\r\n    \r\n        function [id]espopup_ShowWindow()\r\n        {\r\n          [slink]\r\n          if ([id]nWin!=null) [id]nWin.close();\r\n          [id]nWin=window.open('','[id]nWin','[winstyle], '+\r\n            'menubar=no, resizable=no, status=no, toolbar=no, location=no');\r\n          [id]nWin.document.write([id]nText);\r\n        }\r\n\r\n        var [id]mousemoveBack,[id]mouseupBack;\r\n        var [id]ofsX,[id]ofsY;\r\n        function [id]espopup_DragDrop(e)\r\n        {\r\n          [id]mousemoveBack=document.body.onmousemove;\r\n          [id]mouseupBack=document.body.onmouseup;\r\n          ox=(e.offsetX==null)?e.layerX:e.offsetX;\r\n          oy=(e.offsetY==null)?e.layerY:e.offsetY;\r\n          [id]ofsX=ox; [id]ofsY=oy;\r\n\r\n          document.body.onmousemove=[id]espopup_DragDropMove;\r\n          document.body.onmouseup=[id]espopup_DragDropStop;\r\n          if ([id]tmrHide!=-1) clearInterval([id]tmrHide);\r\n        }\r\n\r\n        function [id]espopup_DragDropMove(e)\r\n        {\r\n          el=document.getElementById('[id]');          \r\n          if (e==null&&event!=null)\r\n          {\r\n            el.style.left=(event.clientX*1+document.body.scrollLeft-[id]ofsX)+'px';\r\n            el.style.top=(event.clientY*1+document.body.scrollTop-[id]ofsY)+'px';\r\n            event.cancelBubble=true;\r\n          }\r\n          else\r\n          {\r\n            el.style.left=(e.pageX*1-[id]ofsX)+'px';\r\n            el.style.top=(e.pageY*1-[id]ofsY)+'px';\r\n            e.cancelBubble=true;\r\n          }\r\n          if ((event.button&1)==0) [id]espopup_DragDropStop();\r\n        }\r\n\r\n        function [id]espopup_DragDropStop()\r\n        {\r\n          document.body.onmousemove=[id]mousemoveBack;\r\n          document.body.onmouseup=[id]mouseupBack;\r\n        }\r\n\r\n      //]]>\r\n      </script>";
            string spopStyle = this.spopStyle;
            string str4 = "";
            switch (this.popAction)
            {
                case PopupAction.RaiseEvents:
                {
                    str4 = this.aCommands.Replace("[cmd]", "javascript:[id]espopup_ShowWindow();");
                    string newValue = (this.LinkClicked == null) ? "" : (this.Page.GetPostBackClientEvent(this, "C") + "; return;");
                    string str6 = (this.PopupClosed == null) ? "" : (this.Page.GetPostBackClientEvent(this, "X") + "; return;");
                    str2 = str2.Replace("[slink]", newValue).Replace("[sclose]", str6);
                    break;
                }
                case PopupAction.MessageWindow:
                    str4 = this.aCommands.Replace("[cmd]", "javascript:[id]espopup_ShowWindow();");
                    str2 = str2.Replace("[slink]", "").Replace("[sclose]", "");
                    break;

                case PopupAction.OpenLink:
                    str4 = this.aCommands.Replace("[cmd]", this.sLink);
                    str2 = str2.Replace("[slink]", "").Replace("[sclose]", "");
                    if (this.sTarget != "")
                    {
                        str4 = str4 + " target=\"" + this.sTarget + "\"";
                    }
                    break;
            }
            spopStyle = spopStyle.Replace("[gs]", this.gradientStart).Replace("[ge]", this.gradientEnd).Replace("[clr]", this.textColor);
            str2 = str2.Replace("[winstyle]", string.Format("width={0},height={1},scrollbars={2}", this.winSize.Width, this.winSize.Height, this.winScroll ? "yes" : "no")).Replace("[hide]", this.iHide.ToString()).Replace("[stime]", this.startTime.ToString()).Replace("[id]", this.ClientID).Replace("[ie]", (browser == "IE") ? "true" : "false").Replace("[popup]", string.Format(this.sPopup, this.fullmsg, this.title, spopStyle)).Replace("[autoshow]", this.bAutoShow.ToString().ToLower()).Replace("[speed]", this.iSpeed.ToString());
            string str7 = string.Format("width:{0}; height:{1}; ", this.Width, this.Height);
            string str8 = string.Format(this.cntStyleI, this.Width.Value - 6.0, this.Height.Value - 24.0);
            string str9 = string.Format(this.cntStyleN, this.Width.Value - 10.0, this.Height.Value - 28.0);
            string str10 = "";
            if (this.bDragDrop)
            {
                str10 = " onmousedown=\"return " + this.ClientID + "espopup_DragDrop(event);\" ";
            }
            if (this.popDock == PopupDocking.BottomLeft)
            {
                str7 = str7 + "left:";
            }
            else
            {
                str7 = str7 + "right:";
            }
            str7 = str7 + string.Format("{0}px; bottom:{1}px;", this.xOffset, this.yOffset);
            object[] args = new object[13];
            args[0] = this.ClientID;
            args[1] = this.PutColors(this.divDesign);
            args[2] = str7;
            args[3] = this.ClientID + "_header";
            args[4] = str10;
            double num = this.Width.Value - 6.0;
            args[5] = this.PutColors(this.hdrStyle).Replace("[wid]", num.ToString()) + this.PutColors(this.aStyle);
            args[6] = "<span id=\"" + this.ClientID + "titleEl\">" + this.title + "</span>" + this.PutColors(this.closeHtml).Replace("[id]", this.ClientID);
            args[7] = this.ClientID + "_content";
            args[8] = this.PutColors(this.cntStyle) + (((browser != "Netscape") && (browser != "Mozilla")) ? str8 : str9);
            args[9] = this.PutColors(this.aStyle);
            args[10] = str4.Replace("[id]", this.ClientID);
            args[11] = this.ClientID + "aCnt";
            args[12] = this.msg;
            output.Write(str2 + string.Format("<div id=\"{0}\" style=\"display:none; {1} {2}\" onselectstart=\"return false;\" {4}><div id=\"{3}\" style=\"cursor:default; display:none; {5}\">{6}</div><div id=\"{7}\" onmousedown=\"event.cancelBubble=true;\" style=\"display:none; {8}\">" + (this.bShowLink ? "<a style=\"{9}\" {10} id=\"{11}\">{12}</a></div></div>" : "<span style=\"{9}\" id=\"{11}\">{12}</span></div></div>"), args));
        }

        [Category("Action"), Description("Type of action (after link is clicked).")]
        public PopupAction ActionType
        {
            get
            {
                return this.popAction;
            }
            set
            {
                this.popAction = value;
            }
        }

        [Description("Automaticly show popup when page loads (after ShowAfter miliseconds)."), DefaultValue(true), Category("Behavior")]
        public bool AutoShow
        {
            get
            {
                return this.bAutoShow;
            }
            set
            {
                this.bAutoShow = value;
            }
        }

        [Category("Design"), Description("Predefined color style.")]
        public PopupColorStyle ColorStyle
        {
            get
            {
                return this.clrStyle;
            }
            set
            {
                this.clrStyle = value;
                switch (value)
                {
                    case PopupColorStyle.Blue:
                        this.textColor = "1F336B";
                        this.xButtonOver = this.popupBorderDark = "455690";
                        this.xButton = this.cntBorderDark = "728EB8";
                        this.popupBorderLight = this.cntBorderLight = "B9C9EF";
                        this.popupBackground = this.cntBackground = this.gradientStart = "E0E9F8";
                        this.gradientEnd = "FFFFFF";
                        return;

                    case PopupColorStyle.Red:
                        this.textColor = "400000";
                        this.xButtonOver = this.popupBorderDark = "800000";
                        this.xButton = this.cntBorderDark = "A05A5A";
                        this.popupBorderLight = this.cntBorderLight = "C8AAAA";
                        this.popupBackground = this.cntBackground = this.gradientStart = "DCC8C8";
                        this.gradientEnd = "FFFFFF";
                        return;

                    case PopupColorStyle.Green:
                        this.textColor = "004000";
                        this.xButtonOver = this.popupBorderDark = "008000";
                        this.xButton = this.cntBorderDark = "5AA05A";
                        this.popupBorderLight = this.cntBorderLight = "AAC8AA";
                        this.popupBackground = this.cntBackground = this.gradientStart = "C8DCC8";
                        this.gradientEnd = "FFFFFF";
                        return;

                    case PopupColorStyle.Violet:
                        this.textColor = "200040";
                        this.xButtonOver = this.popupBorderDark = "400080";
                        this.xButton = this.cntBorderDark = "7D5AA0";
                        this.popupBorderLight = this.cntBorderLight = "B9AAC8";
                        this.popupBackground = this.cntBackground = this.gradientStart = "D2C8DC";
                        this.gradientEnd = "FFFFFF";
                        return;
                }
            }
        }

        [Bindable(true), Category("Design"), Description("Dark shadow color.")]
        public Color DarkShadow
        {
            get
            {
                return this.ColorFromString(this.xButtonOver);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.xButtonOver = this.popupBorderDark = this.ColorToString(value);
            }
        }

        [Description("Popup window docking."), Category("Layout")]
        public PopupDocking DockMode
        {
            get
            {
                return this.popDock;
            }
            set
            {
                this.popDock = value;
            }
        }

        [DefaultValue(true), Description("Allow user to move popup element."), Category("Behavior")]
        public bool DragDrop
        {
            get
            {
                return this.bDragDrop;
            }
            set
            {
                this.bDragDrop = value;
            }
        }

        [Category("Design"), Bindable(true), Description("Dark gradient color (Background in Mozilla).")]
        public Color GradientDark
        {
            get
            {
                return this.ColorFromString(this.gradientStart);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.popupBackground = this.cntBackground = this.gradientStart = this.ColorToString(value);
            }
        }

        [Bindable(true), Category("Design"), Description("Ligh Gradient color.")]
        public Color GradientLight
        {
            get
            {
                return this.ColorFromString(this.gradientEnd);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.gradientEnd = this.ColorToString(value);
            }
        }

        [Bindable(true), Category("Behavior"), DefaultValue(500), Description("How long will be window displayed in milliseconds(-1 for infinite).")]
        public int HideAfter
        {
            get
            {
                return this.iHide;
            }
            set
            {
                this.iHide = value;
            }
        }

        [Description("Light shadow color."), Bindable(true), Category("Design")]
        public Color LightShadow
        {
            get
            {
                return this.ColorFromString(this.popupBorderLight);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.popupBorderLight = this.cntBorderLight = this.ColorToString(value);
            }
        }

        [Description("Adress/javascript to open when link is clicked."), Bindable(true), Category("Action")]
        public string Link
        {
            get
            {
                return this.sLink;
            }
            set
            {
                this.sLink = value;
            }
        }

        [Description("Target for specified link."), Category("Action"), Bindable(true)]
        public string LinkTarget
        {
            get
            {
                return this.sTarget;
            }
            set
            {
                this.sTarget = value;
            }
        }

        [Category("Texts"), Bindable(true), Description("Message in popup.")]
        public string Message
        {
            get
            {
                return this.msg;
            }
            set
            {
                this.msg = value;
            }
        }

        [Description("X offset (from left or right)."), DefaultValue(15), Category("Layout")]
        public int OffsetX
        {
            get
            {
                return this.xOffset;
            }
            set
            {
                this.xOffset = value;
            }
        }

        [Description("Y offset from bottom."), DefaultValue(15), Category("Layout")]
        public int OffsetY
        {
            get
            {
                return this.yOffset;
            }
            set
            {
                this.yOffset = value;
            }
        }

        [DefaultValue(20), Description("Get or set how fast will showing of popup be."), Bindable(true), Category("Behavior")]
        public int PopupSpeed
        {
            get
            {
                return this.iSpeed;
            }
            set
            {
                this.iSpeed = value;
            }
        }

        [Category("Design"), Bindable(true), Description("Shadow color.")]
        public Color Shadow
        {
            get
            {
                return this.ColorFromString(this.xButton);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.xButton = this.cntBorderDark = this.ColorToString(value);
            }
        }

        [DefaultValue(0x3e8), Bindable(true), Description("Delay before displaying popup control."), Category("Behavior")]
        public int ShowAfter
        {
            get
            {
                return this.startTime;
            }
            set
            {
                this.startTime = value;
            }
        }

        [DefaultValue(true), Description("Generate link inside popup and enable action ?"), Category("Action"), Bindable(true)]
        public bool ShowLink
        {
            get
            {
                return this.bShowLink;
            }
            set
            {
                this.bShowLink = value;
            }
        }

        [Description("This text will be displayed in new window."), Category("Action"), Bindable(true)]
        public string Text
        {
            get
            {
                return this.fullmsg;
            }
            set
            {
                this.fullmsg = value.Replace(@"\", @"\\").Replace("\"", "\\\"");
            }
        }

        [Description("Text color."), Bindable(true), Category("Design")]
        public Color TextColor
        {
            get
            {
                return this.ColorFromString(this.textColor);
            }
            set
            {
                this.ColorStyle = PopupColorStyle.Custom;
                this.textColor = this.ColorToString(value);
            }
        }

        [Category("Texts"), Description("Title of popup element and new window."), Bindable(true)]
        public string Title
        {
            get
            {
                return this.title;
            }
            set
            {
                this.title = value;
            }
        }

        [DefaultValue(true), Bindable(true), Category("Window"), Description("Display scrollbars in new window.")]
        public bool WindowScroll
        {
            get
            {
                return this.winScroll;
            }
            set
            {
                this.winScroll = value;
            }
        }

        [Category("Window"), Bindable(true), Description("Opened window size.")]
        public Size WindowSize
        {
            get
            {
                return this.winSize;
            }
            set
            {
                this.winSize = value;
            }
        }
    }
}

