﻿namespace EeekSoft.Web
{
    using System;
    using System.ComponentModel;
    using System.Drawing.Design;
    using System.Web.UI;
    using System.Web.UI.WebControls;

    [ToolboxData("<{0}:PopupWinAnchor runat=server></{0}:PopupWinAnchor>"), Designer(typeof(AnchorDesigner)), DefaultProperty("PopupToShow")]
    public class PopupWinAnchor : WebControl
    {
        private bool bChangeText = false;
        private string controlId;
        private string controlLink;
        private string jsEvent = "onclick";
        private string snMsg;
        private string snText;
        private string snTitle;

        public PopupWinAnchor()
        {
            this.bChangeText = false;
        }

        protected override void Render(HtmlTextWriter output)
        {
            output.Write("\r\n        <script type=\"text/javascript\">\r\n        //<![CDATA[\r\n\r\n        var " + this.ID + "oldOnLoad=window.onload;\r\n        window.onload=" + this.ID + "espopup_anchorInit;\r\n        function " + this.ID + "espopup_anchorInit()\r\n        {\r\n          if (" + this.ID + "oldOnLoad!=null) " + this.ID + "oldOnLoad();\r\n          document.getElementById('" + this.controlLink + "')." + this.jsEvent + "=" + this.ID + "espopup_anchorEvent;\r\n        }\r\n\r\n        function " + this.ID + "espopup_anchorEvent()\r\n        {\r\n          ");
            if (this.bChangeText)
            {
                Control control = this.Page.FindControl(this.controlId);
                if (control != null)
                {
                    output.Write(this.controlId + "nText=\"" + ((PopupWin) control).GetWinText(this.snTitle, this.snText) + "\";\n");
                }
                output.Write(this.controlId + "nMsg=\"" + this.snMsg + "\";\n");
                output.Write(this.controlId + "nTitle=\"" + this.snTitle + "\";\n");
                output.Write(this.controlId + "bChangeTexts=true;\n");
            }
            else
            {
                output.Write(this.controlId + "bChangeTexts=false;\n");
            }
            output.Write("\n" + this.controlId + "espopup_ShowPopup('" + this.ID + "');\r\n        }\r\n        //]]>\r\n        </script>");
        }

        [Description("Should texts on PopupWin be replaced with new texts ?"), DefaultValue(false), Bindable(true), Category("PopupWin")]
        public bool ChangeTexts
        {
            get
            {
                return this.bChangeText;
            }
            set
            {
                this.bChangeText = value;
            }
        }

        [Category("Anchor"), Editor(typeof(JavaScriptEventEditor), typeof(UITypeEditor)), Description("JavaScript event to handle"), DefaultValue("onclick"), Bindable(true)]
        public string HandledEvent
        {
            get
            {
                return this.jsEvent;
            }
            set
            {
                this.jsEvent = value;
            }
        }

        [Editor(typeof(AllControlsEditor), typeof(UITypeEditor)), DefaultValue(""), Description("Control "), Category("Anchor"), Bindable(true)]
        public string LinkedControl
        {
            get
            {
                return this.controlLink;
            }
            set
            {
                this.controlLink = value;
            }
        }

        [Category("PopupWin"), DefaultValue(""), Description("New message text"), Bindable(true)]
        public string NewMessage
        {
            get
            {
                return this.snMsg;
            }
            set
            {
                this.snMsg = value;
            }
        }

        [Bindable(true), Category("PopupWin"), DefaultValue(""), Description("New text to show in opened window")]
        public string NewText
        {
            get
            {
                return this.snText;
            }
            set
            {
                this.snText = value;
            }
        }

        [Category("PopupWin"), Description("New popup title text"), Bindable(true), DefaultValue("")]
        public string NewTitle
        {
            get
            {
                return this.snTitle;
            }
            set
            {
                this.snTitle = value;
            }
        }

        [Description("Popup control to show when event occurs"), Bindable(true), Category("Anchor"), DefaultValue(""), Editor(typeof(PopupControlsEditor), typeof(UITypeEditor))]
        public string PopupToShow
        {
            get
            {
                return this.controlId;
            }
            set
            {
                this.controlId = value;
            }
        }
    }
}

