﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="search.aspx.cs" Inherits="SearchEasy.SiteSearch.search" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
<title><%= SearchModel.PageTitle %></title>
<link rel="stylesheet" type="text/css" href="/static/search_v2.css" />
<link rel="stylesheet" type="text/css" media="all" href="/static/jquery-ui.css" />
<script type="text/javascript" src="/static/jquery.min.js"></script>
<script type="text/javascript" src="/static/jquery-ui.min.js"></script>
<meta name="Description" content="<%= SearchModel.PageDescription %>" />
</head>
<body>
<div class="doc">
	<!-- 公共头部 -->
	<div class="header-search">
        <div class="inner">
            <div class="logo"><a href="/" target="_blank"><img src='/static/logo.png' alt='<%= SearchModel.PageTitle %>' /></a></div>
            <div class="search" id="q-input">
                <div class="input">
					<form id="q-form" method="get" onsubmit="return ValidateForm();"> 
					<span class="kw">
					<input class="text" id="kwq" type="text" name="q" size="40" title="" value="<%= SearchModel.QueryKw %>"  x-webkit-speech="" x-webkit-grammar="builtin:translate"/>
					</span>
					<input type="submit" class="btn-search" value="搜   索"/>
					</form>
				</div>
				<div class="result-status">
                	为您找到相关结果约 <span class="count"><%= SearchModel.ResultCount %></span> 个，用时 <span class="time"><%= SearchModel.ResultTime %></span> 秒 
				</div>
            </div>
        </div>
		<div class="cat">
			<div class="center">
                <%= SearchModel.OutputAllSites("<a href='{0}' data-id='{1}'>{2}</a>") %>
			</div>
		</div>
		<script type="text/javascript">
            $(".cat a[data-id=<%= SearchModel.QuerySiteName %>]").addClass("current");
		</script>
    </div>
    <!-- 公共头部 结束 -->
    <div id="main" class="lo-wrap">
        <div class="filter">
			<!--输出分类-->
            
            <div class="date">
				<div class="keywords_top"><span class="bule"></span><h1>范围</h1></div>
				<span class="h5"></span>
               <ul>
                 <li data-id='f'><a href='/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=<%= SearchModel.SearchDate %>&sb=<%= SearchModel.SortBy %>'>搜索全文</a></li>
                 <li data-id='ftitle'><a href='/search.aspx?q=<%= SearchModel.QueryKw %>&f=title&s=<%= SearchModel.QuerySiteName %>&d=<%= SearchModel.SearchDate %>&sb=<%= SearchModel.SortBy %>'>搜索标题</a></li>
                 <li data-id='fcontent'><a href='/search.aspx?q=<%= SearchModel.QueryKw %>&f=content&s=<%= SearchModel.QuerySiteName %>&d=<%= SearchModel.SearchDate %>&sb=<%= SearchModel.SortBy %>'>搜索内容</a></li>
               </ul>
            </div>
            <div class="date">
				<div class="keywords_top"><span class="bule"></span><h1>时间</h1></div>
				<span class="h5"></span>
                <ul>
                    <li data-id='d0'><a  href="/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=0&f=<%= SearchModel.SearchField %>&sb=<%= SearchModel.SortBy %>">时间不限</a></li>
                    <li data-id='d1'><a  href="/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=1&f=<%= SearchModel.SearchField %>&sb=<%= SearchModel.SortBy %>">当天 </a></li>
                    <li data-id='d7'><a  href="/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=7&f=<%= SearchModel.SearchField %>&sb=<%= SearchModel.SortBy %>">最近一周</a></li>
                    <li data-id='d30'><a  href="/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=30&f=<%= SearchModel.SearchField %>&sb=<%= SearchModel.SortBy %>">最近一个月</a></li>
                    <li data-id='d360'><a  href="/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&d=360&f=<%= SearchModel.SearchField %>&sb=<%= SearchModel.SortBy %>">最近一年</a></li>
                </ul>
            </div>
			<div class="date">
				<div class="keywords_top"><span class="bule"></span><h1>排序</h1></div>
				<span class="h5"></span>
				<ul>
					<li data-id='sb'><a  href='/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&sb=&d=<%= SearchModel.SearchDate %>&f=<%= SearchModel.SearchField %>'>按相关度排序</a></li>
                    <li data-id='sbdate'><a data-id='sbdate' href='/search.aspx?q=<%= SearchModel.QueryKw %>&s=<%= SearchModel.QuerySiteName %>&sb=date&d=<%= SearchModel.SearchDate %>&f=<%= SearchModel.SearchField %>'>按时间排序</a></li>
				</ul>
			</div>
            <script type="text/javascript">
                $(".date li[data-id=f<%= SearchModel.SearchField %>]").addClass("current");
                $(".date li[data-id=d<%= SearchModel.SearchDate %>]").addClass("current");
                $(".date li[data-id=sb<%= SearchModel.SortBy %>]").addClass("current");
		</script>
        </div>
        
        <div class="lo-main">
        	<div class="result">
                
                <div class="list">
                
                <!--搜索结果列表-->
                 
                    <% foreach (var resultItem in SearchModel.ResultList)
                        { %>

                     <div class="item">
                       <div class="i-title"><%= resultItem.SiteName=="" ? "" : "<span>"+resultItem.SiteName+"</span>" %><a href="<%= resultItem.Url %>" target="_blank"><%= resultItem.Title %></a></div>
                       
                       <div class="i-des"><%= resultItem.ToThumbPicUrl("<span style='WIDTH: 120px; FLOAT: left;MARGIN-LEFT: 6px ;MARGIN-RIGHT: 15px'><img width='120' height='80' src='{0}' /></span>") %><%= resultItem.Content %></div>
                       <div class="i-info"><a href="<%= resultItem.Url %>" class="channel" target="_blank"><%= resultItem.Url %></a> - <%= resultItem.PublishDate %></div>
                     </div>
                    <% } %>
                </div>

            	<div class="pages">
            	  <%= SearchModel.PagerHtml %>
            	</div>
            </div>
            <div class="lo-side">
              <div align="right"></div>
            </div>
	    <div class="fix"></div>
        </div>
    </div>
    <div class="footer">
        <div class="center">
			<p class="copyright_en"><%= SearchModel.CopyRight %></p>
		</div>
    </div>
</div>
<script language="javascript" type="text/javascript">
function ValidateForm() {
    var q = $("#kwq").val();
    if (q == "") {
        alert("请输入搜索关键词！");
        return false;
    }

    <% if (SearchModel.UrlRewrite)
    {%>
        window.location.href = "/so/" + q + "/1.html";
        return false;
    <%}
    else {%>
        return true;
    <% }%>
}
</script>
</body>
</html>
 


