﻿using System;
using System.Collections.Generic;
using System.Text;

namespace myControl
{
    public class PagionControl : System.Web.UI.Control
    {
        public PagionControl()
        {
            this._showTotal = true;
            this._pageUrl = "";
            this._pageName = "";
            this._currentPage = 0;
            this._countPage = 0;
            this._pageShowRow = 0;
        }
        private int _currentPage;
        /// <summary>
        /// 当前页
        /// </summary>
        public int CurrentPage
        {
            get { return this._currentPage; }
            set { this._currentPage = value; }
        }

        private int _countPage;
        /// <summary>
        /// 总页数
        /// </summary>
        public int CountPage
        {
            get { return this._countPage; }
            set { this._countPage = value; }
        }

        private string _pageName;
        /// <summary>
        /// 页面 比如:Default.aspx
        /// </summary>
        public string PageName
        {
            get { return this._pageName; }
            set { this._pageName = value; }
        }
        private string _pageUrl;
        /// <summary>
        /// 参数 比如:cate=2&id=1
        /// </summary>
        public string PageUrl
        {
            get { return this._pageUrl; }
            set { this._pageUrl = value; }
        }
        private bool _showTotal;
        /// <summary>
        /// 是否显示总条数
        /// </summary>
        public bool ShowTotal
        {
            get { return this._showTotal; }
            set { this._showTotal = value; }
        }

        private int _pageShowRow;
        /// <summary>
        /// 每页显示多少条数据
        /// </summary>
        public int PageShowRow
        {
            get { return this._pageShowRow; }
            set { this._pageShowRow = value; }
        }
        protected override void Render(System.Web.UI.HtmlTextWriter writer)
        {
            GetString(CurrentPage, this._pageShowRow, this._pageName, this._pageUrl);
            writer.Write(html);
        }

        string dhtml = "<span><a href=\"#\">首页</a></span>&nbsp;&nbsp;<span><a href=\"#\">上一页</a></span>&nbsp;&nbsp;<span><a href=\"#\">下一页</a></span>&nbsp;&nbsp;<span><a href=\"#\">尾页</a></span>&nbsp;&nbsp;跳到<input type=\"text\" size=\"2\" />&nbsp;<a href=\"\">GO</a> ";
        string html = "";
        protected void GetString(int CurrentPage, int ShowRow, string PageName, string PageUrl)
        {
            html = ShowPage(PageName, this._countPage, ShowRow, CurrentPage, "条", this._showTotal, true, true, true, PageUrl);
        }

        private string ShowPage(string mStrFileName, int mTotalput, int mMaxPerPage, int mCurrentPage, string strUnit, bool ShowTotal, bool ShowPageTotal, bool ShowAllPages, bool ShowNumList, string Pageurl)
        {
            if (mTotalput == 0)
                return dhtml;
            int n;
            string strTemp;
            string strUrl;
            if (mTotalput % mMaxPerPage == 0)
                n = mTotalput / mMaxPerPage;
            else
                n = mTotalput / mMaxPerPage + 1;
            if (n == 1)
                return "";
            strTemp = "";
            if (ShowTotal)
                strTemp = strTemp + "共 <b>" + mTotalput + "</b> " + strUnit + "&nbsp;&nbsp;";

            strUrl = JoinChar(mStrFileName);
            if (mCurrentPage < 2)
            {
                strTemp += "首页&nbsp;上一页&nbsp;";
            }
            else
            {
                strTemp += "<a href='" + strUrl + Pageurl + "1'>首页</a>&nbsp;";
                strTemp += "<a href='" + strUrl + Pageurl + (mCurrentPage - 1) + "'>上一页</a>&nbsp;";
            }
            if (ShowNumList)
            {
                if (n <= 10)
                {
                    for (int i = 1; i <= n; i++)
                    {
                        if (mCurrentPage == i)
                        {
                            strTemp += "<font color=red><b>" + i + "</b></font> ";
                        }
                        else
                        {
                            strTemp += "<a href=" + strUrl + Pageurl + i + ">" + i + "</a> ";
                        }
                    }
                }
                else
                {
                    if (mCurrentPage < 5)
                    {
                        for (int i = 1; i <= 10; i++)
                        {
                            if (mCurrentPage == i)
                            {
                                strTemp += "<font color=red><b>" + i + "</b></font> ";
                            }
                            else
                            {
                                strTemp += "<a href=" + strUrl + Pageurl + i + ">" + i + "</a> ";
                            }
                        }
                    }
                    else if (n - mCurrentPage < 5)
                    {
                        for (int i = n - 10 + 1; i <= n; i++)
                        {
                            if (mCurrentPage == i)
                            {
                                strTemp += "<font color=red><b>" + i + "</b></font> ";
                            }
                            else
                            {
                                strTemp += "<a href=" + strUrl + Pageurl + i + ">" + i + "</a> ";
                            }
                        }
                    }
                    else
                    {
                        for (int i = mCurrentPage - 4; i <= mCurrentPage + 5; i++)
                        {
                            if (mCurrentPage == i)
                            {
                                strTemp += "<font color=red><b>" + i + "</b></font> ";
                            }
                            else
                            {
                                strTemp += "<a href=" + strUrl + Pageurl + i + ">" + i + "</a> ";
                            }
                        }
                    }
                }
            }
            if (n - mCurrentPage < 1)
            {
                strTemp = strTemp + "下一页&nbsp;尾页";
            }
            else
            {
                strTemp = strTemp + "<a href='" + strUrl + Pageurl + (mCurrentPage + 1) + "'>下一页</a>&nbsp;";
                strTemp = strTemp + "<a href='" + strUrl + Pageurl + n + "'>尾页</a>";
            }
            if (ShowPageTotal)
            {
                strTemp = strTemp + "&nbsp;页次：<strong><font color=red>" + mCurrentPage + "</font>/" + n + "</strong>页 ";
                strTemp = strTemp + "&nbsp;<b>" + mMaxPerPage + "</b>" + strUnit + "/页";
            }
            if (ShowAllPages)
            {
                strTemp = strTemp + "&nbsp;转到：<select name='page' size='1'  align='absmiddle' onchange=javascript:window.location='" + strUrl + Pageurl + "'+this.options[this.selectedIndex].value;>";
                for (int i = 1; i <= n; i++)
                {
                    strTemp = strTemp + "<option value='" + i + "'";
                    if (mCurrentPage == i) { strTemp = strTemp + " selected "; }
                    strTemp = strTemp + ">第" + i + "页</option>";
                }
                strTemp = strTemp + "</select>";
            }
            return strTemp;
        }

        private string JoinChar(string strUrl)
        {
            if (strUrl == null || strUrl == "") return null;

            if (strUrl.IndexOf('?') < strUrl.Length)
            {
                if (strUrl.IndexOf('?') > 1)
                {
                    if (strUrl.IndexOf('&') < strUrl.Length)
                        return strUrl + "&";
                    else
                        return strUrl;
                }
                else
                    return strUrl + "?";
            }
            else
                return strUrl;
        }
    }
}
