﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Drawing;
using System.IO;
using System.Drawing.Imaging;
using System.Collections;

/// <summary>
/// RadomCode 的摘要说明
/// </summary>
public class RandomCode : System.Web.UI.Page
{
    private System.Web.SessionState.HttpSessionState Session
    {
        get
        {
            return this.Page.Session;
        }
    }

    string SessionRadomCodeStr = "CheckImg";
    string OARandomCode
    {
        get
        {
            if (Session[SessionRadomCodeStr] == null)
            {
                return "";
            }
            return ((string)Session[SessionRadomCodeStr]).ToLower();
        }
    }

    //去掉某些容易混淆的字符
    ArrayList _arr = new ArrayList();
    void InitARR()
    {
        _arr.Clear();
        _arr.Add(105); //i
        _arr.Add(108);//l
        _arr.Add(111); //o
        _arr.Add(48);//0
        _arr.Add(49); //1
        _arr.Add(73);//I
        _arr.Add(79); //O
    }
    bool notHas(int code)
    {
        return _arr.Contains(code) == false;
    }


    public string rFontType
    {
        get
        {
            Random _radom0 = new Random();
            string[] font = { "宋体" };//{ "Verdana", "Arial", "Arial", "Verdana", "Arial", "宋体", "宋体", "宋体", "Arial" };
            int a = _radom0.Next(0, font.Length - 1);
            return font[a];
        }
    }


    public FontStyle rfontStyle
    {
        get
        {
            Random _radom0 = new Random();
            FontStyle[] f ={ FontStyle.Italic, FontStyle.Bold };
            int a = _radom0.Next(0, f.Length - 1);
            return f[a];
        }
    }

    public Color FontColor
    {
        get
        {
            Random _radom0 = new Random();
            Color[] c = { Color.Black, Color.Red, Color.DarkBlue, Color.DarkGreen, Color.DarkOrchid, 
                    Color.Brown, Color.DarkViolet, Color.Purple, Color.DarkBlue};
            int a = _radom0.Next(0, c.Length - 1);
            return (Color)c[a];
        }
    }

    /// <summary>
    /// 生成随机验证码
    /// </summary>
    public byte[] FigureCode()
    {
        InitARR();
        //定义图象的高茺
        int bitmapheight = 25;
        //定义图象的宽度
        int bitmapwidth = 74;
        int _tmpcode = -1;
        string _code = "";
        Random _random = new Random();


        Bitmap _bitmap = null;
        Graphics _graphics = null;
        MemoryStream _stream = null;
        byte[] _outcode = null;
        try
        {
            _stream = new MemoryStream();
            _bitmap = new Bitmap(bitmapwidth, bitmapheight);
            _graphics = Graphics.FromImage(_bitmap);

            //清空图片背景色
            _graphics.Clear(Color.White);
            //画图片的背景噪音线
            for (int i = 0; i < 2; i++)
            {
                int x1 = _random.Next(_bitmap.Width);
                int x2 = _random.Next(_bitmap.Width);
                int y1 = _random.Next(_bitmap.Height);
                int y2 = _random.Next(_bitmap.Height);

                _graphics.DrawLine(new Pen(Color.Silver), x1, y1, x2, y2);
            }
            int fontX = _random.Next(0, 10);
            //产生随机码
            while (_code.Length < 5)
            {
                int fontY = _random.Next(0, 4);
                _tmpcode = _random.Next(48, 122);
                if ((_tmpcode >= 48 && _tmpcode <= 57 && notHas(_tmpcode)) || (_tmpcode >= 97 && _tmpcode <= 122 && notHas(_tmpcode)) || (_tmpcode >= 65 && _tmpcode <= 90 && notHas(_tmpcode)))
                {
                    string _temCode = Convert.ToString(Convert.ToChar(_tmpcode));
                    _code += _temCode;
                    _graphics.DrawString(_temCode, new Font(rFontType, 14, rfontStyle), new System.Drawing.SolidBrush(FontColor), fontX + (_code.Length - 1) * 12, fontY);
                }
            }
            //画图片的前景噪音点
            for (int i = 0; i < 30; i++)
            {
                int x = _random.Next(_bitmap.Width);
                int y = _random.Next(_bitmap.Height);
                // _graphics.DrawString("-", new Font("Arial", 12), new SolidBrush(FontColor), x, y);
                _bitmap.SetPixel(x, y, FontColor);
            }

            //画图片的边框线
            _graphics.DrawRectangle(new Pen(Color.Silver), 0, 0, _bitmap.Width - 1, _bitmap.Height - 1);

            _bitmap.Save(_stream, ImageFormat.Jpeg);
            Session[SessionRadomCodeStr] = _code;
            _outcode = _stream.GetBuffer();
        }
        finally
        {
            if (_bitmap != null)
            {
                _bitmap.Dispose();
                _bitmap = null;
            }
            if (_graphics != null)
            {
                _graphics.Dispose();
                _graphics = null;
            }
            if (_stream != null)
            {
                _stream.Close();
                _stream = null;
            }
            if (_random != null)
            {
                _random = null;
            }
        }
        //随机验证码输出图形
        return _outcode;
    }



    /// <summary>
    /// 检查随机验证码
    /// </summary>
    /// <param name="ARandom"></param>
    /// <returns></returns>
    public bool CheckRandom(string ARandom)
    {
        bool isTrue = this.OARandomCode.ToUpper().Equals(ARandom.ToUpper());
        //Session[SessionRadomCodeStr] = "";
        return isTrue;
    }
}
