﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text.RegularExpressions;
using System.Net;
using System.IO;

/// <summary>
/// WebHelper 的摘要说明
/// </summary>
public class WebHelper
{
    public WebHelper()
    {
        //
        // TODO: 在此处添加构造函数逻辑
        //
    }
    ~WebHelper()
    {
        Dispose();
    }
    public void Dispose()
    {
        GC.SuppressFinalize(this);
    }
    public static string GetBaseURL()
    {
        if (HttpContext.Current.Request.ApplicationPath == "/ ")
        {
            return @"http://" + HttpContext.Current.Request.Url.Host + ":" + HttpContext.Current.Request.Url.Port;
        }
        else
        {
            return @"http://" + HttpContext.Current.Request.Url.Host + ":" + HttpContext.Current.Request.Url.Port + HttpContext.Current.Request.ApplicationPath;
        }
    }

    public static void SendJSMsg(Page p ,string msg)
    {
        p.ClientScript.RegisterStartupScript(typeof(string), Guid.NewGuid().ToString(), string.Format("<script>alert('{0}');</script>",msg));
    }


    #region 匹配页面的链接
    /**/
    /**********************************
     * 函数名称:GetHref
     * 功能说明:匹配页面的链接
     * 参    数:HtmlCode:html源代码
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string Url = @"http://www.baidu.com";
     *          string HtmlCode = o.GetRemoteHtmlCode(Url);
     *          string s = o.GetHref(HtmlCode);
     *          Response.Write(s);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 获取页面的链接正则
    /// </summary>
    /// <param name="HtmlCode"></param>
    /// <returns></returns>
    public string GetHref(string HtmlCode)
    {
        string MatchVale = "";
        string Reg = @"(h|H)(r|R)(e|E)(f|F) *= *('|"")?((\w|\\|\/|\.|:|-|_)+)[\S]*";
        foreach (Match m in Regex.Matches(HtmlCode, Reg))
        {
            MatchVale += (m.Value).ToLower().Replace("href=", "").Trim() + "|";
        }
        return MatchVale;
    }
    #endregion

    #region 替换通过正则获取字符串所带的正则首尾匹配字符串
    /**/
    /**********************************
 * 函数名称:GetHref
 * 功能说明:匹配页面的链接
 * 参    数:HtmlCode:html源代码
 * 调用示例:
 *          GetRemoteObj o = new GetRemoteObj();
 *          string Url = @"http://www.baidu.com";
 *          string HtmlCode = o.GetRemoteHtmlCode(Url);
 *          string s = o.RegReplace(HtmlCode,"<title>","</title>");
 *          Response.Write(s);
 *          o.Dispose();
 * ********************************/
    /**/
    /// <summary>
    /// 替换通过正则获取字符串所带的正则首尾匹配字符串
    /// </summary>
    /// <param name="RegValue">要替换的值</param>
    /// <param name="regStart">正则匹配的首字符串</param>
    /// <param name="regEnd">正则匹配的尾字符串</param>
    /// <returns></returns>
    public string RegReplace(string RegValue, string regStart, string regEnd)
    {
        string s = RegValue;
        if (RegValue != "" && RegValue != null)
        {
            if (regStart != "" && regStart != null)
            {
                s = s.Replace(regStart, "");
            }
            if (regEnd != "" && regEnd != null)
            {
                s = s.Replace(regEnd, "");
            }
        }
        return s;
    }
    #endregion

    #region 获取远程文件源代码
    /**/
    /**********************************
     * 函数名称:GetRemoteHtmlCode
     * 功能说明:获取远程文件源代码
     * 参    数:Url:远程url
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string url = @"http://www.baidu.com";
     *          string s = o.GetRemoteHtmlCode(url);
     *          Response.Write(s);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 获取远程文件源代码
    /// </summary>
    /// <param name="url">远程url</param>
    /// <returns></returns>
    public string GetRemoteHtmlCode(string Url)
    {
        //string s = "";
        ////Uri url = new Uri(Url);
        ////WebResponse r = url.
        //MSXML2.XMLHTTP _xmlhttp = new MSXML2.XMLHTTPClass();
        //_xmlhttp.open("GET", Url, false, null, null);
        //_xmlhttp.send("");
        //if (_xmlhttp.readyState == 4)
        //{
        //    s = System.Text.Encoding.Default.GetString((byte[])_xmlhttp.responseBody);
        //}
        //return s;
        WebRequest request = WebRequest.Create(Url);
        WebResponse response = request.GetResponse();
        Stream resStream = response.GetResponseStream();
        StreamReader sr = new StreamReader(resStream, System.Text.Encoding.Default);
        string content = sr.ReadToEnd();
        resStream.Close();
        sr.Close();
        return content;
    }

    #endregion

    #region 日期随机函数
    /**/
    /**********************************
     * 函数名称:DateRndName
     * 功能说明:日期随机函数
     * 参    数:ra:随机数
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          Random ra = new Random();
     *          string s = o.DateRndName(ra);
     *          Response.Write(s);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 日期随机函数
    /// </summary>
    /// <param name="ra">随机数</param>
    /// <returns></returns>
    public string DateRndName(Random ra)
    {
        DateTime d = DateTime.Now;
        string s = null, y, m, dd, h, mm, ss;
        y = d.Year.ToString();
        m = d.Month.ToString();
        if (m.Length < 2) m = "0" + m;
        dd = d.Day.ToString();
        if (dd.Length < 2) dd = "0" + dd;
        h = d.Hour.ToString();
        if (h.Length < 2) h = "0" + h;
        mm = d.Minute.ToString();
        if (mm.Length < 2) mm = "0" + mm;
        ss = d.Second.ToString();
        if (ss.Length < 2) ss = "0" + ss;
        s += y + ',' + m + ',' + dd + ',' + h + "-" + mm + "-" + ss;
        s += ra.Next(1000000, 9999999).ToString();
        return s;
    }
    #endregion

    #region 匹配页面的图片地址
    /**/
    /**********************************
     * 函数名称:GetImgSrc
     * 功能说明:匹配页面的图片地址
     * 参    数:HtmlCode:html源代码;imgHttp:要补充的http.当比如:<img src="bb/x.gif">则要补充http://www.baidu.com/,当包含http信息时,则可以为空
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string Url = @"http://www.baidu.com";
     *          string HtmlCode = o.GetRemoteHtmlCode(Url);
     *          string s = o.GetImgSrc(HtmlCode,"http://www.baidu.com/");
     *          Response.Write(s);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 匹配页面的图片地址
    /// </summary>
    /// <param name="HtmlCode"></param>
    /// <param name="imgHttp">要补充的http://路径信息</param>
    /// <returns></returns>
    public string GetImgSrc(string HtmlCode, string imgHttp)
    {
        string MatchVale = "";
        string Reg = @"<img.+?>";
        foreach (Match m in Regex.Matches(HtmlCode.ToLower(), Reg))
        {
            MatchVale += GetImg((m.Value).ToLower().Trim(), imgHttp) + "|";
        }

        return MatchVale;
    }
    /// <summary>
    /// 获取指定html
    /// </summary>
    /// <param name="start"></param>
    /// <param name="end"></param>
    /// <param name="html"></param>
    public string GetHtml(string start, string end, string html)
    {
        Regex regstr = new Regex(start + @"([\s\S]*?)" + end);//重开头到结尾截取其中的字符串    
        Match m = regstr.Match(html);
        string s="";
        if (m.Success)
        {
            s+=m.Result("$1");//返回截取到的json数据,    
        }
        return s;
    }    

    /**/
    /// <summary>
    /// 匹配<img src="" />中的图片路径实际链接
    /// </summary>
    /// <param name="ImgString"><img src="" />字符串</param>
    /// <returns></returns>
    public string GetImg(string ImgString, string imgHttp)
    {
        string MatchVale = "";
        string Reg = @"src=.+\.(bmp|jpg|gif|png|)";
        foreach (Match m in Regex.Matches(ImgString.ToLower(), Reg))
        {
            MatchVale += (m.Value).ToLower().Trim().Replace("src=", "");
        }
        if (MatchVale.IndexOf(".net") != -1 || MatchVale.IndexOf(".com") != -1 || MatchVale.IndexOf(".org") != -1 || MatchVale.IndexOf(".cn") != -1 || MatchVale.IndexOf(".cc") != -1 || MatchVale.IndexOf(".info") != -1 || MatchVale.IndexOf(".biz") != -1 || MatchVale.IndexOf(".tv") != -1)
            return (MatchVale);
        else
            return (imgHttp + MatchVale);
    }

    #endregion

    #region 替换HTML源代码
    /**/
    /**********************************
     * 函数名称:RemoveHTML
     * 功能说明:替换HTML源代码
     * 参    数:HtmlCode:html源代码
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string Url = @"http://www.baidu.com";
     *          string HtmlCode = o.GetRemoteHtmlCode(Url);
     *          string s = o.ReplaceEnter(HtmlCode);
     *          string Reg="<title>.+?</title>";
     *          string GetValue=o.GetRegValue(Reg,HtmlCode)
     *          Response.Write(GetValue);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 替换HTML源代码
    /// </summary>
    /// <param name="HtmlCode">html源代码</param>
    /// <returns></returns>
    public string RemoveHTML(string HtmlCode)
    {
        string MatchVale = HtmlCode;
        foreach (Match s in Regex.Matches(HtmlCode, "<.+?>"))
        {
            MatchVale = MatchVale.Replace(s.Value, "");
        }
        return MatchVale;
    }

    #endregion

    #region 执行正则提取出值
    /**/
    /**********************************
     * 函数名称:GetRegValue
     * 功能说明:执行正则提取出值
     * 参    数:HtmlCode:html源代码
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string Url = @"http://www.baidu.com";
     *          string HtmlCode = o.GetRemoteHtmlCode(Url);
     *          string s = o.ReplaceEnter(HtmlCode);
     *          string Reg="<title>.+?</title>";
     *          string GetValue=o.GetRegValue(Reg,HtmlCode)
     *          Response.Write(GetValue);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 执行正则提取出值
    /// </summary>
    /// <param name="RegexString">正则表达式</param>
    /// <param name="RemoteStr">HtmlCode源代码</param>
    /// <returns></returns>
    public string GetRegValue(string RegexString, string RemoteStr)
    {
        string MatchVale = "";
        Regex r = new Regex(RegexString);
        Match m = r.Match(RemoteStr);
        if (m.Success)
        {
            MatchVale = m.Value;
        }
        return MatchVale;
    }
    #endregion

    #region 替换网页中的换行和引号
    /**/
    /**********************************
     * 函数名称:ReplaceEnter
     * 功能说明:替换网页中的换行和引号
     * 参    数:HtmlCode:html源代码
     * 调用示例:
     *          GetRemoteObj o = new GetRemoteObj();
     *          string Url = @"http://www.baidu.com";
     *          string HtmlCode = o.GetRemoteHtmlCode(Url);
     *          string s = o.ReplaceEnter(HtmlCode);
     *          Response.Write(s);
     *          o.Dispose();
     * ********************************/
    /**/
    /// <summary>
    /// 替换网页中的换行和引号
    /// </summary>
    /// <param name="HtmlCode">HTML源代码</param>
    /// <returns></returns>
    public string ReplaceEnter(string HtmlCode)
    {
        string s = "";
        if (HtmlCode == null || HtmlCode == "")
            s = "";
        else
            s = HtmlCode.Replace("\"", "");
        s = s.Replace("\r", "");
        s = s.Replace("\n", "");
        return s;
    }

    #endregion

}
