﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;

public partial class admini_ShuaManager : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (CheckLogin())
        {
            AjaxPro.Utility.RegisterTypeForAjax(typeof(admini_ShuaManager));
            this.ClientScript.RegisterStartupScript(typeof(string), Guid.NewGuid().ToString(), "<script>getLink();</script>");
        }
    }
   
    [AjaxPro.AjaxMethod]
    public ArrayList getLink()
    {
        ArrayList lst = new ArrayList();
        try
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(base.ShuaWZ));
            XmlNodeList list = doc.SelectNodes("/Sites/Site");
            
            if (list.Count > 0)
            {
                foreach (XmlNode node in list)
                {
                    ArrayList al = new ArrayList();
                    al.Add(node.Attributes["siteKey"].Value.ToString().Trim());
                    al.Add(node.Attributes["siteName"].Value.ToString().Trim());
                    al.Add(node.Attributes["siteUrl"].Value.ToString().Trim());
                    al.Add(node.Attributes["siteDesc"].Value.ToString().Trim());
                    al.Add(node.Attributes["LinkType"].Value.ToString().Trim());
                    lst.Add(al);
                }
            }
            else
                lst.Add("0");
           
        }
        catch (Exception ex)
        {
            lst.Add(ex.Message);
        }
        return lst;
    }
    [AjaxPro.AjaxMethod]
    public string addNewSite(int? key, string sname, string surl, string sdesc, string sType)
    {
        try
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(base.ShuaWZ));
            if (key == null)
            {
                XmlNode list = doc.SelectSingleNode("/Sites/Site[last()]");
                string siteKey = list.Attributes["siteKey"].Value;
                XmlNode root = doc.SelectSingleNode("Sites");
                XmlElement el = doc.CreateElement("Site");
                el.SetAttribute("siteKey", int.Parse(siteKey) + 1 + "");
                el.SetAttribute("siteUrl", "http://" + surl);
                el.SetAttribute("siteName", sname);
                el.SetAttribute("siteDesc", sdesc);
                el.SetAttribute("LinkType", sType);

                root.AppendChild(el);
            }
            else
            {
                XmlNode list = doc.SelectSingleNode("/Sites/Site[@siteKey='" + key + "']");
                list.Attributes["siteUrl"].Value = surl;
                list.Attributes["siteName"].Value = sname;
                list.Attributes["siteDesc"].Value = sdesc;
                list.Attributes["LinkType"].Value = sType;
            }
            doc.Save(Server.MapPath(ShuaWZ));
            return "1";
        }
        catch (Exception ex) { return ex.Message; }
    }

}
