﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.Text;

public partial class admini_SiteManager : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!CheckLogin()) return;
        AjaxPro.Utility.RegisterTypeForAjax(typeof(admini_SiteManager));
    }
    [AjaxPro.AjaxMethod]
    public string getLink()
    {
        try
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(base.XmlLink));
            XmlNodeList list = doc.SelectNodes("/Links/link");
            StringBuilder sb = new StringBuilder();
            
            foreach (XmlNode node in list)
            {
                sb.AppendFormat("<tr><td><a target=\"_blank\" href=\"{0}\" title=\"{1}\">{2}</a></td><td>{0}</td><td>{1}</td><td>{3}</td><td><a href=\"javascript:Update('{4}','{2}','{0}','{1}','{5}');\">修改</a>&nbsp;&nbsp;<a href=\"javascript:del('{4}');\">删除</a></td></tr>", node.Attributes["siteUrl"].Value, node.Attributes["siteDesc"].Value, node.Attributes["siteName"].Value, node.Attributes["LinkType"].Value == "1" ? "是" : "否", node.Attributes["siteKey"].Value, node.Attributes["LinkType"].Value);
            }
            return sb.ToString();
        }
        catch (Exception ex)
        {
            return ex.Message;
        }
    }

    [AjaxPro.AjaxMethod]
   public string addNewSite(int? key,string sname, string surl, string sdesc, string sType) 
    {
        try
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(XmlLink));
            if (key == null)
            {
                XmlNode list = doc.SelectSingleNode("/Links/link[last()]");
                string siteKey = list.Attributes["siteKey"].Value;
                XmlNode root = doc.SelectSingleNode("Links");
                XmlElement el = doc.CreateElement("link");
                el.SetAttribute("siteKey", int.Parse(siteKey) + 1 + "");
                el.SetAttribute("siteUrl", "http://" + surl);
                el.SetAttribute("siteName", sname);
                el.SetAttribute("siteDesc", sdesc);
                el.SetAttribute("LinkType", sType);

                root.AppendChild(el);
            }
            else
            {
                XmlNode list = doc.SelectSingleNode("/Links/link[@siteKey='"+key+"']");
                list.Attributes["siteUrl"].Value = surl;
                list.Attributes["siteName"].Value = sname;
                list.Attributes["siteDesc"].Value = sdesc;
                list.Attributes["LinkType"].Value = sType;
            }
            doc.Save(Server.MapPath(XmlLink));
            return "1";
        }
        catch(Exception ex) { return ex.Message; }
    }
    [AjaxPro.AjaxMethod]
    public string del(string key)
    {
        try
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(Server.MapPath(XmlLink));
            XmlNode list = doc.SelectSingleNode("/Links/link[@siteKey='" + key + "']");
            list.Attributes["LinkType"].Value = "0";
            doc.Save(Server.MapPath(XmlLink));
            return "1";
        }
        catch (Exception ex)
        {
            return ex.Message;
        }
    }
}
