<?php
defined ( 'WODE_CMS' ) or exit ( 'Access Denied' );

/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author : milkcy <milkcy@foxmail.com>
 * @version : v1.0
 * =======================================================
 */
class controller {
	
	public $tpl;
	
	public $control;
	
	public $action;
	
	private $c = array ();
	
	public function __construct() {
		$this->tpl = Smarty::getInstance ();
		$this->initialize ();
	}
	
	public function __call($func, $arg) {
		$this->setValue ( "error", $func . Config::lang ( "METHODNOTFIND" ) );
		$this->forward ( "error.html" );
		exit ();
	}
	
	public function setValue($var, $value) {
		$this->tpl->assign ( $var, $value );
	}
	
	public function forward($file) {
		$msgObj = new Msg ();
		if (in_array ( $file, array ('error.html', 'msg/html', 'noRight.html' ) )) {
			$this->tpl->template_dir = ROOT_PATH . "/WODECMS/templates/";
		}
		$fullFilePath = $this->tpl->template_dir . $file;
		if (! file_exists ( $fullFilePath )) {
			$this->tpl->template_dir = ROOT_PATH . "/" . APP_PATH . "/templates/v2/";
			if (! file_exists ( $this->tpl->template_dir . $file )) {
				$this->tpl->assign ( "error", $file . Config::lang ( "TEMPLATENOTEXISTS" ) );
				$this->tpl->display ( "error.html" );
				exit ();
			}
		}
		$this->tpl->assign ( "msgObj", $msgObj );
		$this->tpl->display ( $file );
	}
	
	public function display($file) {
		$msgObj = new Msg ();
		$dir = StringUtil::new_html_special_chars ( $_GET ['dir'] );
		$this->tpl->template_dir = ROOT_PATH . "/plugins/" . $dir . "/templates/";
		$this->tpl->compile_dir = ROOT_PATH . "/" . APP_PATH . "/data/runtime/" . $dir . "/";
		$this->tpl->cache_dir = ROOT_PATH . "/" . APP_PATH . "/data/cache/" . $dir . "/";
		if (! file_exists ( $this->tpl->compile_dir )) {
			FileUtil::createDir ( $this->tpl->compile_dir );
		}
		if (! file_exists ( $this->tpl->cache_dir )) {
			FileUtil::createDir ( $this->tpl->cache_dir );
		}
		$fullFilePath = $this->tpl->template_dir . $file;
		if (! file_exists ( $fullFilePath )) {
			$this->tpl->assign ( "error", $file . Config::lang ( "TEMPLATENOTEXISTS" ) );
			$this->tpl->display ( "error.html" );
			exit ();
		}
		$this->tpl->assign ( "msgObj", $msgObj );
		$this->tpl->display ( $file );
	}
	
	public function plugin() {
		$module = StringUtil::new_html_special_chars ( $_GET ['dir'] );
		$controlFile = ROOT_PATH . '/plugins/' . $module . '/Main.class.php';
		if (! file_exists ( $controlFile )) {
			$this->setValue ( "error", '访问异常或者插件未安装' );
			$this->forward ( "error.html" );
			exit ();
		}
		include ($controlFile);
		$instance = new Main ();
		if (! method_exists ( $instance, "Runner" )) {
			$this->setValue ( "error", 'Runner Method Not Find' );
			$this->forward ( "error.html" );
			exit ();
		}
		$configAry = include ROOT_PATH . '/plugins/' . $module . '/Config.php';
		foreach ( $configAry as $key => $value ) {
			$this->setValue ( "p_" . $key, $value );
		}
		
		if (! empty ( $configAry ["disabled"] )) {
			$msg = Config::lang ( "SOMETHINGISCLOSE", $configAry ["name"] );
			$this->setValue ( "error", $msg );
			$this->forward ( "error.html" );
			exit ();
		}
		$instance->Runner ();
	}
	
	public function initialize() {
		$langObj = new Config ();
		$urlObj = new Url ();
		$msgObj = new Msg ();
		$this->setValue ( "msgObj", $msgObj );
		$this->setValue ( "urlObj", $urlObj );
		$this->setValue ( "langObj", $langObj );
		$this->setValue ( "model", M ( "model" ) );
	}
	
	public function Run() {
		if (!empty($_GET['uuid']) && !empty($_GET['tk'])) {
			$this->ssoLogin();exit;
		}
		$a = R ( 'a', 'G' );
		$c = R ( 'c', 'G' );
		$ac = R ( 'ac', 'G' );
		/**兼容旧版开始**/
		$this->control = empty ( $this->control ) ?  empty($c) ? 'index' : $c : $this->control;
		$this->action = empty ( $this->action ) ?  empty($a) ? 'defaultAction' : $a : $this->action;
		if(!empty($ac)){
			$acAry = explode ( "_", $ac );
			if (count ( $acAry ) == 2) {
				$action = $acAry [1];
				$control = $acAry [0];
			}
			if (count ( $acAry ) == 3) {
				$action = $acAry [2];
				$control = $acAry [0] . '_' . $acAry [1];
			} 
			$this->control = empty ($control ) ? 'index' : $control;
			$this->action = empty ( $action ) ? 'defaultAction' : $action;
		}
		if ($this->action === "list") {
			$this->action = "listAll";
		}
		/**兼容旧版结束**/
		$groupDir = GROUP_DIR;
		$controlFile = ROOT_PATH . '/' . APP_PATH . "/" . GROUP_DIR . "/" . $this->control . '.class.php';
		if (! file_exists ( $controlFile )) {
			$this->setValue ( "error", $this->control . Config::lang ( "CONTROLLERNOTEXISTS" ) );
			$this->forward ( "error.html" );
			exit ();
		}
		include ($controlFile);
		if (! class_exists ( $this->control )) {
			$this->setValue ( "error", $this->control . Config::lang ( "CONTROLLERNOTDEFINED" ) );
			$this->forward ( "error.html" );
			exit ();
		}
		if (! empty ( $_REQUEST ['token'] ) && $groupDir == 'api') {// APP接口权限判断入口
			$this->pubCheck ();
		}
		$instance = new $this->control ();
		$methodName = $this->action;
		if (! method_exists ( $instance, $methodName )) {
			$this->setValue ( "error", $methodName . '方法未定义' );
			$this->forward ( "error.html" );
			exit ();
		}
		$this->forceAttack ();//权限,黑名单判断入口
		$instance->$methodName ();
	}
    
	private function forceAttack() {
		$attack = M ( 'attack' );
		if (Config::get ( "blackcheck" ) == 1 && ! defined ( 'IN_ADMIN' )) {
			$canBePass = $attack->checkForbidden ();
			if ($canBePass) {
				$this->setValue ( "error", Config::lang ( "YOUAREPROHIBITED" ) );
				$this->forward ( "error.html" );
				exit ();
			}
		}
		if (! defined ( 'IN_ADMIN' ) && Config::get ( "checkHack" )) {
			$attack->initLogHacker ();
		}
		if (defined ( 'IN_ADMIN' )) {
			if (!empty($_GET ['ac']) && !in_array ( $_GET ['ac'], array ('common_newCode', 'admin_login', 'admin_loginout', 'admin_defaultAction', 'install' ))) {
				$this->checkHaveRight ();
				if (! Authen::isAdmin ()) {
					if ($_GET ['c'] == 'admin') {
						header ( 'Location:' . Config::get ( 'admin' ) );
						exit ();
					}
					$this->setValue ( "error", Config::lang ( "YOUHAVENOTPERMISSIONTODO" ) );
					$this->forward ( "noRight.html" );
					exit ();
				}
			}
		}
	}
	
	/* 用户角色区分 */
	private function checkHaveRight($ac) {
		$powerObj = M ( 'power' );
		$userGroupId = $powerObj->getUserGroupId ();
		$ifHaveRight = $powerObj->checkUserRight ( $ac, $userGroupId );
		if (! $ifHaveRight) {
			if ($_GET ["c"] == "admin") {
				StringUtil::msgbox ( "请登录后操作!", Config::get ( 'admin' ), 1 );
				exit ();
			}
			$this->setValue ( "error", Config::lang ( "YOUHAVENOTPERMISSIONTODO" ) );
			$this->forward ( "noRight.html" );
			exit ();
		}
	}
	
	public function checkPluginPower($model, $type) {
		$type = $type == 'do' ? 'allowdo' : 'allowview';
		$configAry = include ROOT_PATH . '/plugins/' . $model . '/Config.php';
		if (! empty ( $configAry [$type] ) && ! in_array ( $_SESSION ['userId'] ['grade'], $configAry [$type] )) {
			$this->setValue ( "error", Config::lang ( "YOUHAVENOTPERMISSIONTODO" ) );
			$this->forward ( "noRight.html" );
			exit ();
		}
	}
	
	/**
	 * App 接口认证
	 */
	public function pubCheck() {
		$params = empty ( $_POST ) ? $_GET : $_POST;
		$request_sign = $params ['sign'];
		$request_access_token = $params ['access_token'];
		$sign_method = empty ( $params ['sign_method'] ) ? 'fullmd5' : $params ['sign_method'];
		// 按字典排序参数，得到接口签名
		ksort ( $params );
		$sign_params = $params;
		unset ( $sign_params ['ac'], $sign_params ['a'], $sign_params ['c'], $sign_params ['dir'], $sign_params ['timestamp'], $sign_params ['secret'], $sign_params ['sign_method'], $sign_params ['sign'], $sign_params ['access_token'] );
		$dictionary = '';
		foreach ( $sign_params as $key => $val ) {
			if (is_array ( $val )) {
				foreach ( $val as $key2 => $v ) {
					$dictionary .= $key . "[$key2]" . $v;
				}
			} else {
				$dictionary .= $key . $val;
			}
		}
		$secret = $params ['secret'];
		$sign = $this->$sign_method ( $secret, $dictionary );
		if ($sign != $request_sign) {
			$this->apiCallback ( "SIGN ERROR" );
		}
		$timestamp = $params ['timestamp'];
		$secret = $params ['secret'];
		$sign = $params ['sign'];
		$access_token = md5 ( $timestamp . '_' . $secret . '_' . $sign );
		// access_token 错误
		if ($access_token != $request_access_token) {
			$this->apiCallback ( "ACCESS_TOKEN ERROR" );
		}
		// 时间戳错误
		$time_diff = abs ( $timestamp - time () );
		if ($time_diff > 3600) {
			$this->apiCallback ( "TIMESTAMP ERROR" );
		}
	}
	
	public function fullmd5($secret, $dictionary) {
		return md5 ( urlencode ( $secret . $dictionary . $secret ) );
	}
	
	public function leftmd5($secret, $dictionary) {
		return md5 ( urlencode ( $secret . $dictionary ) );
	}
	
	public function rightmd5($secret, $dictionary) {
		return md5 ( urlencode ( $dictionary . $secret ) );
	}
	
	public function apiCallback($code = '', $data = array(), $msg = '') {
        header("content-type: application/json");
		echo json_encode ( array ("code" => $code, "data" => $data, "msg" => $msg ) );
		exit ();
	}
	
	public function wapCallback($code = '', $data = array(), $msg = '', $subcode = '') {
        header("content-type: application/json");
		echo json_encode ( array ("code" => $code, "data" => $data, "message" => $msg, "subcode" => $subcode ) );
		exit ();
	}

	public function jsonp($code = '', $data = array(), $msg = '', $subcode = ''){
        header('Content-type: application/javascript');
        $jsonCallback = htmlspecialchars($_REQUEST ['callback']); //获取请求者自定义的回调函数名
        echo $jsonCallback."(". json_encode(array ("code" => $code, "data" => $data, "msg" => $msg)) . ")";
        exit ();
    }

	/**
	 * Ajax输出
	 * @param $data 数据
	 * @param string $type 数据类型 text html xml json
	 */
	protected function ajax($data, $type = "JSON") {
		$type = strtoupper ( $type );
		switch ($type) {
			case "HTML" :
			case "TEXT" :
				$_data = $data;
				break;
			case "XML" :
				//XML处理
				$_data = Xml::create ( $data, "root", "UTF-8" );
				break;
			default :
				//JSON处理
				header("content-type: application/json");
				$_data = json_encode ( $data );
		}
		echo $_data;
		exit ();
	}
	
	/**
	 * Ajax方式返回数据到客户端
	 * @access protected
	 * @param mixed $data 要返回的数据
	 * @param String $type AJAX返回数据格式
	 * @param int $json_option 传递给json_encode的option参数
	 * @return void
	 */
	protected function ajaxReturn($data, $type = '', $json_option = 0) {
		if (empty ( $type ))
			$type = 'JSON';
		switch (strtoupper ( $type )) {
			case 'JSON' :
				// 返回JSON数据格式到客户端 包含状态信息
				header ( 'Content-Type:application/json; charset=utf-8' );
				exit ( json_encode ( $data, $json_option ) );
			case 'XML' :
				// 返回xml格式数据
				header ( 'Content-Type:text/xml; charset=utf-8' );
				exit ( xml_encode ( $data ) );
			case 'JSONP' :
				// 返回JSON数据格式到客户端 包含状态信息
				header ( 'Content-Type:application/json; charset=utf-8' );
				$handler = 'callback'; //'jsonpReturn';
				exit ( $handler . '(' . json_encode ( $data, $json_option ) . ');' );
			case 'EVAL' :
				// 返回可执行的js脚本
				header ( 'Content-Type:text/html; charset=utf-8' );
				exit ( $data );
			default :
				// 用于扩展其他返回格式数据
				exit ( 'error' );
		}
	}
	
	/*获取歌曲封面图片*/
	public function getPhotoUrl($num, $path) {
		$sum = $num % 100;
		if (empty ( $sum )) {
			$sum = 0;
		}
		return Config::get ( 'website' ) . Config::get ( 'upload_dir' ) . $path . "/" . $sum . ".jpg";
	}
}
