<?php
/**
 * WODE_CMS
 * =======================================================
 * 版权所有 (C) 2010-2020 www.wodecms.com，并保留所有权利。
 * 网站地址: http://www.wodecms.com
 * Q Q: 9877633
 * -------------------------------------------------------
 *
 * @author :     milkcy <milkcy@foxmail.com>
 * @version :    v1.0
 * =======================================================
 */

/*@func $getInstance 实例化Model类 */
function M($modelName) {
	$baseClassPath = ROOT_PATH . '/' . APP_PATH . '/data/bean/' . $modelName . 'Base.class.php'; //base类,字段缓存
	$baseModelPath = ROOT_PATH . '/' . APP_PATH . '/model/' . $modelName . 'Action.class.php'; //action类
	if (! file_exists ( $baseClassPath )) {
		createFieldKeys ( $modelName ); //自动创建字段缓存
	}
	if (! file_exists ( $baseModelPath )) {
		createBaseModel ( $modelName ); //自动创建Action类
	}
	$modelName = $modelName . "Action";
	if (! class_exists ( $modelName, false )) {
		include ($baseClassPath);
		include ($baseModelPath);
	}
	! file_exists ( $baseModelPath ) && exit ( Config::lang ( "MODEL" ) . $modelName . Config::lang ( "NOTEXISTS" ) );
	! class_exists ( $modelName ) && exit ( Config::lang ( "MODEL" ) . $modelName . Config::lang ( "NOTDEFINED" ) );
	$model = new $modelName ();
	return $model;
}

/*
 * 取一条记录
* 举例:
* include 'core.func.php';
* $UserObj = get(user, 1);
*/

function get($_Obj, $objId) {
	$_Obj = M ( $_Obj );
	$info = $_Obj->db->GetRs ( $_Obj->table, '*', 'where ' . $_Obj->PRI . " = " . intval ( $objId ) );
	if (! $info) {
		return false;
	}
	foreach ( $info as $key => $value ) {
		$_Obj->$key = $value;
	}
	return $_Obj;
}

/* @func createFieldKeys 创建数据库表字段信息 */
function createBaseModel($modelName) {
	$db = mysql::getInstance ();
	$newmodelstr = "<?php \ndefined('WODE_CMS') or exit('Access Denied'); \nclass  " . $modelName . "Action extends  " . $modelName . "Base{ \n ";
	$newmodelstr .= "	public function __construct() {\n ";
	$newmodelstr .= "		parent::__construct();\n ";
	$newmodelstr .= "	}\n";
	$newmodelstr .= "}\n\n";
	$targetFile = ROOT_PATH . '/' . APP_PATH . '/model/' . $modelName . 'Action.class.php';
	$haveDir = is_dir ( ROOT_PATH . '/' . APP_PATH . '/model/' );
	if (! $haveDir) {
		$db->makeDirs ( ROOT_PATH . '/' . APP_PATH . '/model/' );
	}
	if (! file_exists ( $targetFile )) {
		file_put_contents ( $targetFile, $newmodelstr );
	}
}

/* @func createFieldKeys 创建数据库表字段信息 */
function createFieldKeys($modelName) {
	$db = mysql::getInstance ();
	$tableFullName = TABLEPRE . $modelName;
	$sql = "DESC $tableFullName";
	$tables = $db->list_tables ();
	! in_array ( $tableFullName, $tables ) && exit ( TABLEPRE . $modelName . Config::lang ( "NOTEXISTS" ) );
	$result = $db->query ( $sql );
	$i = 0;
	$newmodelstr = "<?php \ndefined('WODE_CMS') or exit('Access Denied'); \nclass " . $modelName . "Base extends baseModel { \n ";
	$fields = array ();
	$types = array ();
	$newmodelstr .= "public \$table ='" . $modelName . "';";
	while ( $row = $db->fetch_assoc ( $result ) ) {
		$mate [$i] = $row;
		if (is_array ( $mate [$i] )) {
			if ($mate [$i] ['Key'] == 'PRI') {
				$newmodelstr .= "\n public \$PRI='" . $mate [$i] ['Field'] . "';";
				if ($mate [$i] ['Extra'] == 'auto_increment') {
					$newmodelstr .= "\n public \$autoid=true;";
				} else {
					$newmodelstr .= "\n public \$autoid=false;";
				}
			}
			$fields [$mate [$i] ['Field']] = $mate [$i] ['Default'];
			$types [$mate [$i] ['Field']] = $mate [$i] ['Type'];
		}
		$i ++;
	}
	$newmodelstr .= "\n public \$fields=" . var_export ( $fields, true ) . ";";
	$newmodelstr .= "\n public \$types=" . var_export ( $types, true ) . ";";
	$newmodelstr .= "\n}\n";
	$targetFile = ROOT_PATH . '/' . APP_PATH . '/data/bean/' . $modelName . 'Base.class.php';
	$haveDir = is_dir ( ROOT_PATH . '/' . APP_PATH . '/data/bean/' );
	if (! $haveDir) {
		$db->makeDirs ( ROOT_PATH . '/' . APP_PATH . '/data/bean/' );
	}
	if (! file_exists ( $targetFile )) {
		file_put_contents ( $targetFile, $newmodelstr );
	}
}

function __autoload($ClassName) {
	$commonFile = (ROOT_PATH . "/WODECMS/libraries/{$ClassName}.class.php");
	$utilFile = (ROOT_PATH . "/WODECMS/helpers/{$ClassName}.class.php");
	$userFile = (ROOT_PATH . "/" . APP_PATH . "/libraries/{$ClassName}.class.php");
	if (file_exists ( $commonFile ) && ! class_exists ( $ClassName )) {
		require_once ($commonFile);
	} else if (file_exists ( $utilFile ) && ! class_exists ( $ClassName )) {
		require_once ($utilFile);
	} else if (file_exists ( $userFile ) && ! class_exists ( $ClassName )) {
		require_once ($userFile);
	}
}

/* *
 * 根据目录自动加载所有php文件
* Enter description here ...
* @param string $path 文件夹路径，不带'/'
*/
function include_dir_phpfile($path) {
	$listFuncs = glob ( $path . '/*.php' );
	if ($listFuncs) {
		foreach ( $listFuncs as $value ) {
			include ($value);
		}
	}
	unset ( $listFuncs );
}

function getDirFileName($path) {
	$fileAry = array ();
	$listFuncs = glob ( $path . '/*.php' );
	$i = 0;
	if ($listFuncs) {
		foreach ( $listFuncs as $value ) {
			$str = strrchr ( $value, "/" );
			$pos = strpos ( $str, "." );
			$fileAry [$i ++] = substr ( $str, 1, $pos - 1 );
		}
	}
	unset ( $listFuncs );
	return $fileAry;
}

function gzip_enabled() {
	static $enabled_gzip = NULL;
	if ($enabled_gzip === NULL) {
		$enabled_gzip = function_exists ( 'ob_gzhandler' );
	}
	return $enabled_gzip;
}

function getRequest($str) {
	$val = $_GET [$str];
	if (is_scalar ( $val )) {
		return intval ( $val );
	}
	return $val;
}

function echoln($str) {
	echo $str . "<br>";
}

function println($ary) {
	ArrayUtil::vd ( $ary );
}

function ParseUrl() {
	if ($_SERVER ['PATH_INFO'] != "") {
		//$pathinfo=substr($_SERVER['PATH_INFO'],1);
		//$pathinfo=str_replace(".html","",$pathinfo);
		$path = trim ( $_SERVER ['PATH_INFO'], '/' );
		$paths = explode ( '/', $path );
		$count = count ( $paths );
		for($i = 1; $i < $count; $i += 1) {
			$_GET [$paths [$i]] = $paths [$i + 1];
		}
		return $_GET;
	}
}

// 去除转义字符
function stripslashes_array($array) {
	if (is_array ( $array )) {
		foreach ( $array as $k => $v ) {
			$array [$k] = stripslashes_array ( $v );
		}
	} else if (is_string ( $array )) {
		$array = stripslashes ( $array );
	}
	return $array;
}

function getDirName() {
	$str = $_SERVER ['PHP_SELF'];
	$arr = explode ( '/', $str );
	$arr = array_reverse ( $arr );
	if ($arr ['1'] == "") {
		//echo $arr['0']."在根目录下";
		return "";
	} else {
		//echo $arr['0']."在".$arr['1']."目录下";
		return $arr ['1'];
	}
}

function mem() {
	$memServers = array (array ('host' => MCHOST, 'port' => MCPORT ), array ('host' => MCHOST2, 'port' => MCPORT2 ) );
	$mc = new MemcacheModel ( $memServers );
	return $mc;
}

/**
 * 无Notice快捷取变量 (Request 的缩写)
 * @param string $k 键值
 * @param string $var 类型 GET|POST|COOKIE|REQUEST|SERVER
 * @return mixed
 */
function R($k, $var = 'G') {
	switch ($var) {
		case 'G' :
			$var = &$_GET;
			break;
		case 'P' :
			$var = &$_POST;
			break;
		case 'C' :
			$var = &$_COOKIE;
			break;
		case 'R' :
			$var = isset ( $_GET [$k] ) ? $_GET : (isset ( $_POST [$k] ) ? $_POST : $_COOKIE);
			break;
		case 'S' :
			$var = &$_SERVER;
			break;
	}
	return isset ( $var [$k] ) ? $var [$k] : null;
}

/**
 * 读取/设置 配置信息 (Config 的缩写)
 * @param string $key 键值
 * @param string $val 设置值
 * @return mixed
 */
function C($key, $val = null) {
	if (is_null ( $val ))
		return isset ( $_ENV ['_config'] [$key] ) ? $_ENV ['_config'] [$key] : $val;
	return $_ENV ['_config'] [$key] = $val;
}

// 安全过滤 (过滤非空格、英文、数字、下划线、中文、日文、朝鲜文，其他语言通过 $ext 添加 Unicode 编码)
// 4E00-9FA5(中文)  30A0-30FF(日文片假名) 3040-309F(日文平假名) 1100-11FF(朝鲜文) 3130-318F(朝鲜文兼容字母) AC00-D7AF(朝鲜文音节)
function safe_str($s, $ext = '') {
	$ext = preg_quote ( $ext );
	$s = preg_replace ( '#[^\040\w\x{4E00}-\x{9FA5}\x{30A0}-\x{30FF}\x{3040}-\x{309F}\x{1100}-\x{11FF}\x{3130}-\x{318F}\x{AC00}-\x{D7AF}' . $ext . ']+#u', '', $s );
	$s = trim ( $s );
	return $s;
}

/**
 * 函数名：ContentsPages
 * 功能：文章内容分页
 * 参数：$url文章内容页URL 类型string，$contents文章内容页内容 类型string，$ptext分页标识 类型string
 */
function ContentsPages($url, $contents, $ptext = '#page#') {
	//文章数组
	$arr = explode ( $ptext, $contents );
	//数组长度&总页数
	$total = count ( $arr );
	//当前页
	$nowpage = $_GET ['pages'] ? $_GET ['pages'] : 1;
	//上页
	$prepage = $nowpage == 1 ? 1 : $nowpage - 1;
	//下页
	$nextpage = $nowpage > $total - 1 ? $total : $nowpage + 1;
	//最后一页
	$lastpage = $total;
	$pdiv = '<div class="flickr">';
	$pdiv .= "<span class=\"disabled\">第{$nowpage}页 / 总{$total}页</span>";
	//首页链接
	$pdiv .= "<a href=\"{$url}&pages=1\">首页</a>";
	//上页链接
	$pdiv .= "<a href=\"{$url}&pages={$prepage}\">上一页</a>";
	//显示分页列表
	$color = '';
	for($i = 1; $i <= $total; $i ++) {
		if ($i == $nowpage) {
			$pdiv .= "<span class=\"current\">{$i}</span>";
		} else {
			$pdiv .= "<a href=\"{$url}&pages={$i}\">{$i}</a>";
		}
	}
	//下页链接
	$pdiv .= "<a href=\"{$url}&pages={$nextpage}\" >下一页</a>";
	//末页链接
	$pdiv .= "<a href=\"{$url}&pages={$lastpage}\">末页</a>";
	$pdiv .= "<a href=\"{$url}&showAll=1\" style=\"text-decoration:none;\">阅读全文</a>";
	$pdiv .= '</div>';
	//输出内容
	//不分页则不显示分页列表
	if ($total <= 1)
		$pdiv = '';
		//输出分页列表
	return $arr [$nowpage - 1] . $pdiv;
}

/**
 * XML编码
 * @param mixed $data 数据
 * @param string $root 根节点名
 * @param string $item 数字索引的子节点名
 * @param string $attr 根节点属性
 * @param string $id   数字索引子节点key转换的属性名
 * @param string $encoding 数据编码
 * @return string
 */
function xml_encode($data, $root='think', $item='item', $attr='', $id='id', $encoding='utf-8') {
    if(is_array($attr)){
        $_attr = array();
        foreach ($attr as $key => $value) {
            $_attr[] = "{$key}=\"{$value}\"";
        }
        $attr = implode(' ', $_attr);
    }
    $attr   = trim($attr);
    $attr   = empty($attr) ? '' : " {$attr}";
    $xml    = "<?xml version=\"1.0\" encoding=\"{$encoding}\"?>";
    $xml   .= "<{$root}{$attr}>";
    $xml   .= data_to_xml($data, $item, $id);
    $xml   .= "</{$root}>";
    return $xml;
}

/**
 * 数据XML编码
 * @param mixed  $data 数据
 * @param string $item 数字索引时的节点名称
 * @param string $id   数字索引key转换为的属性名
 * @return string
 */
function data_to_xml($data, $item='item', $id='id') {
    $xml = $attr = '';
    foreach ($data as $key => $val) {
        if(is_numeric($key)){
            $id && $attr = " {$id}=\"{$key}\"";
            $key  = $item;
        }
        $xml    .=  "<{$key}{$attr}>";
        $xml    .=  (is_array($val) || is_object($val)) ? data_to_xml($val, $item, $id) : $val;
        $xml    .=  "</{$key}>";
    }
    return $xml;
}

/**
 * 获取微信token
 */
function getWeiXinToken() {
    $appid =  Config::get("AppID");
    $secret = Config::get("AppSecret");
    $get_token_url = 'https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=' . $appid . '&secret=' . $secret;
    $file = file_get_contents ( $get_token_url );

    $json_obj = json_decode ( $file, true );
    $access_token = $json_obj ['access_token'];
    return $access_token;
}

//微信token写缓存
function cacheWeiXinToken(){

    $fileUrl = $_SERVER['DOCUMENT_ROOT']."/app/data/wxToken.php";
    $wxToken = json_decode(file_get_contents($fileUrl),true);

    if(!file_exists($fileUrl) || !$wxToken['time'] < time()){
        $data['access_token'] = getWeiXinToken();
        $data['time'] = time()+7200;
        $wxToken = fopen($fileUrl,'w+');
        fwrite($wxToken,json_encode($data));
        fclose($wxToken);
        return $data['access_token'];
    }

    return $wxToken['access_token'];
}

/**
 * 获取微信ticket
 */
function getWeixinTicket(){
    $access_token = cacheWeiXinToken();
    $get_jsapi_ticket_url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=".$access_token."&type=jsapi";
    $jsapi_ticketAry = json_decode(file_get_contents($get_jsapi_ticket_url),true);
    return $jsapi_ticketAry['ticket'];
}

//微信ticket写缓存
function cacheWeiXinTicket(){

    $fileUrl = $_SERVER['DOCUMENT_ROOT']."/app/data/wxTicket.php";
    $wxTicked = json_decode(file_get_contents($fileUrl),true);
    if(!file_exists($fileUrl) || !$wxTicked['time'] < time()){
        $data['ticket'] = getWeixinTicket();
        $data['time'] = time()+7200;
        $wxTicked = fopen($fileUrl,'w+');
        fwrite($wxTicked,json_encode($data));
        fclose($wxTicked);
        return $data['ticket'];
    }

    return $wxTicked['ticket'];
}
$_GET && SafeFilterGet ( $_GET );
$_POST && SafeFilterPost ( $_POST );
$_COOKIE && SafeFilterPost ( $_COOKIE );

function SafeFilterGet(&$arr) {
	$ra = array ('/([\x00-\x08,\x0b-\x0c,\x0e-\x19])/','/javascript/', '/vbscript/', '/expression/', '/applet/', '/meta/', '/xml/', '/blink/', '/style/', '/script/', '/embed/', '/object/', '/iframe/', '/frame/', '/frameset/', '/ilayer/', '/layer/', '/bgsound/', '/title/', '/base/','/onabort/', '/onactivate/', '/onafterprint/', '/onafterupdate/', '/onbeforeactivate/', '/onbeforecopy/', '/onbeforecut/', '/onbeforedeactivate/', '/onbeforeeditfocus/', '/onbeforepaste/', '/onbeforeprint/', '/onbeforeunload/', '/onbeforeupdate/', '/onblur/', '/onbounce/', '/oncellchange/', '/onchange/', '/onclick/', '/oncontextmenu/', '/oncontrolselect/', '/oncopy/', '/oncut/', '/ondataavailable/', '/ondatasetchanged/', '/ondatasetcomplete/', '/ondblclick/', '/ondeactivate/', '/ondrag/', '/ondragend/', '/ondragenter/', '/ondragleave/', '/ondragover/', '/ondragstart/', '/ondrop/', '/onerror/', '/onerrorupdate/', '/onfilterchange/', '/onfinish/', '/onfocus/', '/onfocusin/', '/onfocusout/', '/onhelp/', '/onkeydown/', '/onkeypress/', '/onkeyup/', '/onlayoutcomplete/', '/onload/', '/onlosecapture/', '/onmousedown/', '/onmouseenter/', '/onmouseleave/', '/onmousemove/', '/onmouseout/', '/onmouseover/', '/onmouseup/', '/onmousewheel/', '/onmove/', '/onmoveend/', '/onmovestart/', '/onpaste/', '/onpropertychange/', '/onreadystatechange/', '/onreset/', '/onresize/', '/onresizeend/', '/onresizestart/', '/onrowenter/', '/onrowexit/', '/onrowsdelete/', '/onrowsinserted/', '/onscroll/', '/onselect/', '/onselectionchange/', '/onselectstart/', '/onstart/', '/onstop/', '/onsubmit/', '/onunload/' );
	if (is_array ( $arr )) {
		foreach ( $arr as $key => $value ) {
			if (! is_array ( $value )) { //不是数组了
				if ((function_exists ( "get_magic_quotes_gpc" ) && get_magic_quotes_gpc ()) || (ini_get ( 'magic_quotes_sybase' ) && (strtolower ( ini_get ( 'magic_quotes_sybase' ) ) != "off"))) {
					//不对magic_quotes_gpc转义过的字符使用addslashes(),避免双重转义。
					$value = addslashes ( $value ); //给单引号（'）、双引号（"）、反斜线（\）与 NUL（NULL 字符）加上反斜线转义
				}
				$value = preg_replace ( $ra, '', $value ); //删除非打印字符，粗暴式过滤xss可疑字符串
				$value = str_replace(array("&","'",'<','>','&','"'),array("%26","%27",'&lt;','&gt;','&amp;','&quot;'),$value);
				$arr [$key] = htmlentities ( strip_tags ( $value ), ENT_QUOTES, "UTF-8" ); //去除 HTML 和 PHP 标记并转换为 HTML 实体 //去除 HTML 和 PHP 标记并转换为 HTML 实体
			} else {
				SafeFilterGet ( $arr [$key] ); //数组再次过滤
			}
		}
	}
	
}

function SafeFilterPost(&$arr) {
	$ra = array ('/([\x00-\x08,\x0b-\x0c,\x0e-\x19])/','/javascript/', '/vbscript/', '/expression/', '/applet/', '/meta/', '/xml/', '/blink/', '/style/', '/script/', '/embed/', '/object/', '/iframe/', '/frame/', '/frameset/', '/ilayer/', '/layer/', '/bgsound/', '/title/', '/base/','/onabort/', '/onactivate/', '/onafterprint/', '/onafterupdate/', '/onbeforeactivate/', '/onbeforecopy/', '/onbeforecut/', '/onbeforedeactivate/', '/onbeforeeditfocus/', '/onbeforepaste/', '/onbeforeprint/', '/onbeforeunload/', '/onbeforeupdate/', '/onblur/', '/onbounce/', '/oncellchange/', '/onchange/', '/onclick/', '/oncontextmenu/', '/oncontrolselect/', '/oncopy/', '/oncut/', '/ondataavailable/', '/ondatasetchanged/', '/ondatasetcomplete/', '/ondblclick/', '/ondeactivate/', '/ondrag/', '/ondragend/', '/ondragenter/', '/ondragleave/', '/ondragover/', '/ondragstart/', '/ondrop/', '/onerror/', '/onerrorupdate/', '/onfilterchange/', '/onfinish/', '/onfocus/', '/onfocusin/', '/onfocusout/', '/onhelp/', '/onkeydown/', '/onkeypress/', '/onkeyup/', '/onlayoutcomplete/', '/onload/', '/onlosecapture/', '/onmousedown/', '/onmouseenter/', '/onmouseleave/', '/onmousemove/', '/onmouseout/', '/onmouseover/', '/onmouseup/', '/onmousewheel/', '/onmove/', '/onmoveend/', '/onmovestart/', '/onpaste/', '/onpropertychange/', '/onreadystatechange/', '/onreset/', '/onresize/', '/onresizeend/', '/onresizestart/', '/onrowenter/', '/onrowexit/', '/onrowsdelete/', '/onrowsinserted/', '/onscroll/', '/onselect/', '/onselectionchange/', '/onselectstart/', '/onstart/', '/onstop/', '/onsubmit/', '/onunload/' );
	if (is_array ( $arr )) {
		foreach ( $arr as $key => $value ) {
			if (! is_array ( $value )) { //不是数组了
				if (in_array ( $key, array ('smallmemo', 'content', 'img', 'fbword', 'keywords', 'description', 'tongji', 'postfix','adminmenu','url','post_key', 'notices', 'notice_1','notice_2' ,'notice_3','agents','agent_1','agent_2','agent_3','agentw_1','domain_1','domain_2' ) )) {
					$arr [$key] = $value;
				} else {
					if ((function_exists ( "get_magic_quotes_gpc" ) && get_magic_quotes_gpc ()) || (ini_get ( 'magic_quotes_sybase' ) && (strtolower ( ini_get ( 'magic_quotes_sybase' ) ) != "off"))) {
						//不对magic_quotes_gpc转义过的字符使用addslashes(),避免双重转义。
						$value = addslashes ( $value ); //给单引号（'）、双引号（"）、反斜线（\）与 NUL（NULL 字符）加上反斜线转义
					}
					$value = preg_replace ( $ra, '', $value ); //删除非打印字符，粗暴式过滤xss可疑字符串
					$value = str_replace(array("&","'",'<','>','&','"'),array("%26","%27",'&lt;','&gt;','&amp;','&quot;'),$value);
					$arr [$key] = htmlentities ( strip_tags ( $value ), ENT_QUOTES, "UTF-8" ); //去除 HTML 和 PHP 标记并转换为 HTML 实体 //去除 HTML 和 PHP 标记并转换为 HTML 实体
				}
			} else {
				SafeFilterPost ( $arr [$key] ); //数组再次过滤
			}
		}
	}
}
