<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */

/**
 * Smarty truncate modifier plugin
 *
 * Type:     modifier<br>
 * Name:     truncate<br>
 * Purpose:  Truncate a string to a certain length if necessary,
 * optionally splitting in the middle of a word, and
 * appending the $etc string or inserting $etc into the middle.
 * @link http://smarty.php.net/manual/en/language.modifier.truncate.php
 * truncate (Smarty online manual)
 * @author   Monte Ohrt <monte at ohrt dot com>
 * @param string
 * @param integer
 * @param string
 * @param boolean
 * @param boolean
 * @return string
 */
function smarty_modifier_killAllHtml($string) {
	$string = preg_replace('/&((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1', str_replace(array('&', '"', '<', '>'), array('&', '"', '<', '>'), $string));
		$string = htmlspecialchars_decode($string);
		$string = preg_replace("@<script(.*?)</script>@is", "", $string);
		$string = preg_replace("@<iframe(.*?)</iframe>@is", "", $string);
		$string = preg_replace("@<style(.*?)</style>@is", "", $string);
		$string = preg_replace("@<(.*?)>@is", "", $string);
		$string = preg_replace("/\s+/", " ", $string);
		$string = preg_replace("/<\!--.*?-->/si", "", $string);
		$string = str_replace("&nbsp;", "", $string);
		return $string;
}

/* vim: set expandtab: */

?>
